/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.pack200;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.JarInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.pack200.Pack200Strategy;
import org.apache.commons.compress.compressors.pack200.StreamBridge;
import org.apache.commons.compress.java.util.jar.Pack200;

public class Pack200CompressorOutputStream
extends CompressorOutputStream {
    private boolean finished;
    private final OutputStream originalOutput;
    private final StreamBridge streamBridge;
    private final Map<String, String> properties;

    public Pack200CompressorOutputStream(OutputStream out2) throws IOException {
        this(out2, Pack200Strategy.IN_MEMORY);
    }

    public Pack200CompressorOutputStream(OutputStream out2, Pack200Strategy mode) throws IOException {
        this(out2, mode, null);
    }

    public Pack200CompressorOutputStream(OutputStream out2, Map<String, String> props2) throws IOException {
        this(out2, Pack200Strategy.IN_MEMORY, props2);
    }

    public Pack200CompressorOutputStream(OutputStream out2, Pack200Strategy mode, Map<String, String> props2) throws IOException {
        this.originalOutput = out2;
        this.streamBridge = mode.newStreamBridge();
        this.properties = props2;
    }

    @Override
    public void write(int b) throws IOException {
        this.streamBridge.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.streamBridge.write(b);
    }

    @Override
    public void write(byte[] b, int from, int length2) throws IOException {
        this.streamBridge.write(b, from, length2);
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        finally {
            try {
                this.streamBridge.stop();
            }
            finally {
                this.originalOutput.close();
            }
        }
    }

    public void finish() throws IOException {
        if (!this.finished) {
            this.finished = true;
            Pack200.Packer p = Pack200.newPacker();
            if (this.properties != null) {
                p.properties().putAll(this.properties);
            }
            try (JarInputStream ji = new JarInputStream(this.streamBridge.getInput());){
                p.pack(ji, this.originalOutput);
            }
        }
    }
}

