/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.dynamicconversion.DynamicConverter;
import log.CvtLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.ConfigurationException;
import solver.SolverConfig;
import utils.RuntimeEnvInfo;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 (2\u00020\u0001:\u0002()B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013H&J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0016\u001a\u00020\u0017H&J\u0006\u0010 \u001a\u00020\rJ\u0010\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0016J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013H\u0016J\u0010\u0010&\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H&J\b\u0010'\u001a\u00020\u0003H\u0016R\u0012\u0010\u0005\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u0004\u0018\u00010\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006*"}, d2={"Lsolver/SolverInfo;", "Ljava/io/Serializable;", "name", "", "(Ljava/lang/String;)V", "defaultCommand", "getDefaultCommand", "()Ljava/lang/String;", "defaultCommandVersionInfo", "getDefaultCommandVersionInfo", "defaultCommandVersionInfo$delegate", "Lkotlin/Lazy;", "isDefaultCommandAvailable", "", "()Z", "getName", "versionQuery", "getVersionQuery", "commandForStdInMode", "", "clOptions", "getCmdToChangeTimelimit", "timelimit", "Ljava/time/Duration;", "getOptionForIncremental", "getOptionForMemlimit", "memlimitBytes", "", "getOptionForRandomSeed", "randomSeed", "", "getOptionForTimelimit", "isAvailable", "needsLogicALL", "features", "Lsolver/SolverConfig$LogicFeatures;", "preprocessCheckSatOutput", "lines", "supportsLogicFeatures", "toString", "Companion", "Converter", "GeneralUtils"})
public abstract class SolverInfo
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Lazy defaultCommandVersionInfo$delegate;
    private final boolean isDefaultCommandAvailable;
    @NotNull
    private static final CvtLogger logger;
    @NotNull
    private static final Map<String, SolverInfo> allSolverInfos;

    public SolverInfo(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.name = name;
        Map<String, SolverInfo> map2 = allSolverInfos;
        String string2 = this.name;
        map2.put(string2, this);
        this.defaultCommandVersionInfo$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ SolverInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                Pair<String, String> it = RuntimeEnvInfo.INSTANCE.getSolverVersionIfAvailable(this.this$0, this.this$0.getVersionQuery());
                boolean bl = false;
                Pair<String, String> pair = it;
                Pair<String, String> pair2 = it;
                return (pair == null ? null : pair.getFirst()) + (pair2 == null ? null : pair2.getSecond());
            }
        });
        this.isDefaultCommandAvailable = this.getDefaultCommandVersionInfo() != null;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public abstract String getDefaultCommand();

    @NotNull
    public String getVersionQuery() {
        return "--version";
    }

    private final String getDefaultCommandVersionInfo() {
        Lazy lazy = this.defaultCommandVersionInfo$delegate;
        return (String)lazy.getValue();
    }

    public final boolean isAvailable() {
        return this.getDefaultCommandVersionInfo() != null;
    }

    public final boolean isDefaultCommandAvailable() {
        return this.isDefaultCommandAvailable;
    }

    @NotNull
    public List<String> getOptionForIncremental() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public abstract List<String> getOptionForTimelimit(@NotNull Duration var1);

    @NotNull
    public List<String> getOptionForRandomSeed(int randomSeed) {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<String> getOptionForMemlimit(long memlimitBytes) {
        return CollectionsKt.emptyList();
    }

    @Nullable
    public String getCmdToChangeTimelimit(@NotNull Duration timelimit) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        return null;
    }

    @NotNull
    public abstract List<String> commandForStdInMode(@NotNull List<String> var1);

    public abstract boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures var1);

    public boolean needsLogicALL(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return false;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    @NotNull
    public List<String> preprocessCheckSatOutput(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        return lines;
    }

    static {
        String[] stringArray = new String[]{"smtlibutils", "solverInfo"};
        logger = new CvtLogger(stringArray, null, 2, null);
        allSolverInfos = new LinkedHashMap();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0019R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lsolver/SolverInfo$Companion;", "", "()V", "allSolverInfos", "", "", "Lsolver/SolverInfo;", "getAllSolverInfos", "()Ljava/util/Map;", "logger", "Llog/CvtLogger;", "getLogger", "()Llog/CvtLogger;", "getDefaultConfigs", "", "Lsolver/SolverConfig;", "timelimit", "Ljava/time/Duration;", "memlimitBytes", "", "incrementalMode", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "allowedClOptions", "(Ljava/time/Duration;Ljava/lang/Long;ZLsolver/SolverConfig$LogicFeatures;Ljava/util/List;)Ljava/util/List;", "GeneralUtils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CvtLogger getLogger() {
            return logger;
        }

        @NotNull
        public final Map<String, SolverInfo> getAllSolverInfos() {
            return allSolverInfos;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<SolverConfig> getDefaultConfigs(@NotNull Duration timelimit, @Nullable Long memlimitBytes, boolean incrementalMode, @NotNull SolverConfig.LogicFeatures logicFeatures, @NotNull List<SolverConfig> allowedClOptions) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            SolverConfig it;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(timelimit, "timelimit");
            Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
            Intrinsics.checkNotNullParameter(allowedClOptions, "allowedClOptions");
            if (!(!((Collection)allowedClOptions).isEmpty())) {
                boolean $i$a$-require-SolverInfo$Companion$getDefaultConfigs$22 = false;
                String $i$a$-require-SolverInfo$Companion$getDefaultConfigs$22 = "disallowed all SolverClOptions, yet asking for some";
                throw new IllegalArgumentException($i$a$-require-SolverInfo$Companion$getDefaultConfigs$22.toString());
            }
            Iterable $this$filter$iv = allowedClOptions;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (SolverConfig)element$iv$iv;
                boolean bl = false;
                if (!it.getQualifiesFor().invoke(logicFeatures).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (SolverConfig)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SolverConfig.copy$default(it, null, null, null, null, incrementalMode, timelimit, memlimitBytes, null, null, null, null, 1935, null));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0096\u0002\u00a8\u0006\u0007"}, d2={"Lsolver/SolverInfo$Converter;", "Lksp/dynamicconversion/DynamicConverter;", "Lsolver/SolverInfo;", "()V", "invoke", "v", "", "GeneralUtils"})
    public static final class Converter
    implements DynamicConverter<SolverInfo> {
        @Override
        @NotNull
        public SolverInfo invoke(@NotNull Object v) {
            Intrinsics.checkNotNullParameter(v, "v");
            SolverInfo solverInfo = Companion.getAllSolverInfos().get((String)v);
            if (solverInfo == null) {
                throw new ConfigurationException("No SolverInfo " + v);
            }
            return solverInfo;
        }
    }
}

