/*
 * Decompiled with CFR 0.152.
 */
package compiler;

import compiler.JumpType;
import compiler.SrcMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import log.Logger;
import log.LoggerTypes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a$\u0010\u0007\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bj\u0002`\n0\u00032\u0006\u0010\u000b\u001a\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"logger", "Llog/Logger;", "parseSrcMapping", "", "Lcompiler/SrcMapping;", "srcMap", "", "parseVariableMapping", "", "", "Lcompiler/VariableMapping;", "varMap", "Shared"})
public final class SolidityParserToolsKt {
    @NotNull
    private static final Logger logger = new Logger(LoggerTypes.COMMON);

    @NotNull
    public static final List<SrcMapping> parseSrcMapping(@NotNull String srcMap) {
        Intrinsics.checkNotNullParameter(srcMap, "srcMap");
        String[] stringArray = new String[]{";"};
        List perInstruction = StringsKt.split$default((CharSequence)srcMap, stringArray, false, 0, 6, null);
        if (perInstruction.size() == 0 || perInstruction.size() == 1 && StringsKt.isBlank(((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first(perInstruction)))).toString())) {
            return CollectionsKt.emptyList();
        }
        String first2 = (String)CollectionsKt.first(perInstruction);
        SrcMapping last2 = null;
        List retList = new ArrayList();
        last2 = SolidityParserToolsKt.parseSrcMapping$convertFull(first2, last2);
        retList.add(last2);
        Iterable $this$forEach$iv = CollectionsKt.drop(perInstruction, 1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String i = (String)element$iv;
            boolean bl = false;
            SrcMapping srcMapping = last2 = SolidityParserToolsKt.parseSrcMapping$convertFull(i, last2);
            Intrinsics.checkNotNull(srcMapping);
            retList.add(srcMapping);
        }
        return retList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Map<String, Integer>> parseVariableMapping(@NotNull String varMap) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(varMap, "varMap");
        String[] stringArray = new String[]{";"};
        List perInstruction = StringsKt.split$default((CharSequence)varMap, stringArray, false, 0, 6, null);
        if (perInstruction.isEmpty() || perInstruction.size() == 1 && StringsKt.isBlank(((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first(perInstruction)))).toString())) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = perInstruction;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map map2;
            void mapping;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (((CharSequence)mapping).length() == 0) {
                map2 = MapsKt.emptyMap();
            } else {
                void $this$associateByTo$iv$iv;
                void $this$associateBy$iv;
                Object object;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2;
                Object object2 = new String[]{","};
                object2 = StringsKt.split$default((CharSequence)mapping, object2, false, 0, 6, null);
                boolean $i$f$map2 = false;
                void var13_14 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    Pair pair;
                    void it;
                    String string3 = (String)item$iv$iv2;
                    object = destination$iv$iv2;
                    boolean bl2 = false;
                    String[] stringArray2 = new String[]{":"};
                    List list = StringsKt.split$default((CharSequence)it, stringArray2, false, 0, 6, null);
                    if (list.isEmpty()) {
                        pair = null;
                    } else if (list.size() == 2) {
                        pair = new Pair(list.get(0), list.get(1));
                    } else {
                        throw new Exception("malformed variable mapping: " + (String)mapping + ", should have exactly 2 elements at " + (String)it);
                    }
                    object.add(pair);
                }
                $this$map$iv2 = CollectionsKt.filterNotNull((List)destination$iv$iv2);
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
                destination$iv$iv2 = $this$associateBy$iv;
                Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    Pair bl2 = (Pair)element$iv$iv;
                    object = destination$iv$iv3;
                    boolean bl3 = false;
                    Pair it = (Pair)element$iv$iv;
                    String string4 = (String)it.getFirst();
                    boolean bl4 = false;
                    Integer n = Integer.parseInt((String)it.getSecond());
                    object.put(string4, n);
                }
                map2 = destination$iv$iv3;
            }
            collection.add(map2);
        }
        return (List)destination$iv$iv;
    }

    private static final SrcMapping parseSrcMapping$convertFull(String i, SrcMapping last2) {
        SrcMapping srcMapping;
        String[] stringArray = new String[]{":"};
        List _components = StringsKt.split$default((CharSequence)i, stringArray, false, 0, 6, null);
        if (last2 == null && _components.size() < 4) {
            throw new Exception("Invalid srcmap starting with " + i + " (should have at least 4 components separated by ':'");
        }
        List<String> components = CollectionsKt.take(_components, 4);
        if (last2 == null && components.size() != 4) {
            throw new Exception("Invalid srcmap starting with " + i + " (should have 4 components separated by ':'");
        }
        if (last2 == null) {
            logger.debug((Function0<? extends Object>)new Function0<Object>(i, components){
                final /* synthetic */ String $i;
                final /* synthetic */ List<String> $components;
                {
                    this.$i = $i;
                    this.$components = $components;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Handling srcmap string " + this.$i + " (components=" + this.$components + " size " + this.$components.size() + ") without last";
                }
            });
            return new SrcMapping(Integer.parseInt(components.get(2)), Integer.parseInt(components.get(0)), Integer.parseInt(components.get(1)), JumpType.Companion.toJumpType(components.get(3)));
        }
        logger.debug((Function0<? extends Object>)new Function0<Object>(i, components, last2){
            final /* synthetic */ String $i;
            final /* synthetic */ List<String> $components;
            final /* synthetic */ SrcMapping $last;
            {
                this.$i = $i;
                this.$components = $components;
                this.$last = $last;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "Handling srcmap string " + this.$i + " (components=" + this.$components + " size " + this.$components.size() + ") with last " + this.$last;
            }
        });
        switch (components.size()) {
            case 0: {
                srcMapping = last2;
                break;
            }
            case 1: {
                if (StringsKt.isBlank(components.get(0))) {
                    srcMapping = last2;
                    break;
                }
                srcMapping = new SrcMapping(last2.getSource(), Integer.parseInt(components.get(0)), last2.getLen(), last2.getJumpType());
                break;
            }
            case 2: {
                Integer n = StringsKt.toIntOrNull(components.get(0));
                srcMapping = new SrcMapping(last2.getSource(), n == null ? last2.getBegin() : n.intValue(), Integer.parseInt(components.get(1)), last2.getJumpType());
                break;
            }
            case 3: {
                Integer n = StringsKt.toIntOrNull(components.get(0));
                Integer n2 = StringsKt.toIntOrNull(components.get(1));
                srcMapping = new SrcMapping(Integer.parseInt(components.get(2)), n == null ? last2.getBegin() : n.intValue(), n2 == null ? last2.getLen() : n2.intValue(), last2.getJumpType());
                break;
            }
            case 4: {
                Integer n = StringsKt.toIntOrNull(components.get(2));
                Integer n3 = StringsKt.toIntOrNull(components.get(0));
                Integer n4 = StringsKt.toIntOrNull(components.get(1));
                srcMapping = new SrcMapping(n == null ? last2.getSource() : n.intValue(), n3 == null ? last2.getBegin() : n3.intValue(), n4 == null ? last2.getLen() : n4.intValue(), JumpType.Companion.toJumpType(components.get(3)));
                break;
            }
            default: {
                throw new Exception("Invalid srcmap string " + i + " with more than 4 components");
            }
        }
        return srcMapping;
    }
}

