/*
 * Decompiled with CFR 0.152.
 */
package analysis.worklist;

import analysis.worklist.ChaoticWorklistIteration;
import analysis.worklist.IWorklistScheduler;
import analysis.worklist.StepResult;
import datastructures.stdcollections.ListsKt;
import datastructures.stdcollections.SetsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.WithStableHashCodeIfSerialized;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0007\b&\u0018\u0000*\t\b\u0000\u0010\u0001\u00a2\u0006\u0002\b\u0002*\u0004\b\u0001\u0010\u0003*\u0004\b\u0002\u0010\u00042\u00020\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J%\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\f2\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fJ%\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\f2\u0006\u0010\u0011\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u000eJ'\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\f2\u0006\u0010\u0013\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u0014\u001a\u00028\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u0016H$\u00a2\u0006\u0002\u0010\u0017J%\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\f2\u0006\u0010\r\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000fJ)\u0010\u0019\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u001a\u001a\u00028\u00022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016\u00a2\u0006\u0002\u0010\u001cR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lanalysis/worklist/WorklistIteration;", "T", "Lutils/WithStableHashCodeIfSerialized;", "U", "R", "", "()V", "scheduler", "Lanalysis/worklist/IWorklistScheduler;", "getScheduler", "()Lanalysis/worklist/IWorklistScheduler;", "cont", "Lanalysis/worklist/StepResult;", "k", "(Ljava/lang/Object;)Lanalysis/worklist/StepResult;", "", "halt", "t", "process", "it", "reduce", "results", "", "(Ljava/util/List;)Ljava/lang/Object;", "result", "step", "submit", "workItems", "(Ljava/lang/Iterable;)Ljava/lang/Object;", "GeneralUtils"})
public abstract class WorklistIteration<@WithStableHashCodeIfSerialized T, U, R> {
    @NotNull
    public IWorklistScheduler<T> getScheduler() {
        return ChaoticWorklistIteration.INSTANCE;
    }

    public R submit(@NotNull Iterable<? extends T> workItems) {
        Intrinsics.checkNotNullParameter(workItems, "workItems");
        PersistentSet<? extends T> worklist = null;
        worklist = SetsKt.toPersistentSet(workItems);
        List results = new ArrayList();
        while (!((Collection)worklist).isEmpty()) {
            Sequence sched = CollectionsKt.asSequence((Iterable)worklist);
            PersistentSet next = null;
            next = SetsKt.persistentSetOf();
            Iterable $this$forEach$iv = worklist;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object l = element$iv = iterator2.next();
                boolean bl = false;
                if (!this.getScheduler().shouldSchedule(l, sched)) continue;
                StepResult res2 = this.step(l);
                if (res2 instanceof StepResult.StopWith) {
                    return ((StepResult.StopWith)res2).getRet();
                }
                if (res2 instanceof StepResult.Ok) {
                    CollectionsKt.addAll((Collection)results, ((StepResult.Ok)res2).getResult());
                    next = SetsKt.plus(next, ((StepResult.Ok)res2).getNext());
                }
                worklist = SetsKt.minus(worklist, l);
            }
            worklist = SetsKt.plus(worklist, next);
        }
        return this.reduce(results);
    }

    @Nullable
    protected StepResult<T, U, R> step(T it) {
        return this.process(it);
    }

    @NotNull
    protected abstract StepResult<T, U, R> process(T var1);

    protected abstract R reduce(@NotNull List<? extends U> var1);

    @NotNull
    public final StepResult<T, U, R> cont(@NotNull Iterable<? extends T> k) {
        Intrinsics.checkNotNullParameter(k, "k");
        return new StepResult.Ok(k, ListsKt.listOf());
    }

    @NotNull
    public final StepResult<T, U, R> cont(T k) {
        return new StepResult.Ok((Iterable)ListsKt.listOf(k), ListsKt.listOf());
    }

    @NotNull
    public final StepResult<T, U, R> result(@NotNull Iterable<? extends U> k) {
        Intrinsics.checkNotNullParameter(k, "k");
        return new StepResult.Ok(ListsKt.listOf(), k);
    }

    @NotNull
    public final StepResult<T, U, R> result(U k) {
        return new StepResult.Ok(ListsKt.listOf(), (Iterable)ListsKt.listOf(k));
    }

    @NotNull
    public final StepResult<T, U, R> halt(R t2) {
        return new StepResult.StopWith<R>(t2);
    }
}

