/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.io.InputStreamHeaderInterface;
import com.sas.iom.InputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Map;
import java.util.StringTokenizer;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class InputStreamHeader
extends UnicastRemoteObject
implements InputStreamHeaderInterface {
    private InputStream _inputStream = null;

    public InputStreamHeader(InputStream inputStream) throws RemoteException {
        this._inputStream = inputStream;
    }

    public String getCharacterEncoding() throws IOException, RemoteException {
        String charset = null;
        String ctString = this.getContentType();
        if (ctString != null) {
            StringTokenizer tokenizer = new StringTokenizer(ctString, ";");
            while (tokenizer.hasMoreTokens()) {
                String strParm = tokenizer.nextToken();
                int index = strParm.indexOf("=");
                if (index == -1) continue;
                String strParmName = strParm.substring(0, index).trim();
                String strParmValue = strParm.substring(index + 1).trim();
                if (!strParmName.equalsIgnoreCase("charset")) continue;
                charset = strParmValue;
                break;
            }
        }
        return charset;
    }

    public String getContentEncoding() throws IOException, RemoteException {
        return this.getHeaderField("Content-Encoding");
    }

    public String getContentType() throws IOException, RemoteException {
        return this.getHeaderField("Content-Type");
    }

    public long getHeaderFieldDate(String name, long Default) throws IOException, RemoteException {
        long value = Default;
        String field = this.getHeaderField(name);
        if (field != null) {
            try {
                value = DateFormat.getDateInstance().parse(field).getTime();
            }
            catch (ParseException pe) {
                // empty catch block
            }
        }
        return value;
    }

    public int getHeaderFieldInt(String name, int Default) throws IOException, RemoteException {
        int value = Default;
        String field = this.getHeaderField(name);
        if (field != null) {
            try {
                value = Integer.parseInt(field);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return value;
    }

    public Map getHeaders() throws IOException, RemoteException {
        Map responseHeaders = null;
        if (this._inputStream != null) {
            responseHeaders = this._inputStream.getResponseHeaders();
        }
        return responseHeaders;
    }

    public boolean headerAvailable() throws RemoteException {
        boolean available = false;
        if (this._inputStream != null) {
            available = this._inputStream.headerAvailable();
        }
        return available;
    }

    private String getHeaderField(String name) throws IOException {
        String s = null;
        if (this._inputStream != null) {
            Map responseHeaders = this._inputStream.getResponseHeaders();
            for (String key : responseHeaders.keySet()) {
                if (!name.equalsIgnoreCase(key)) continue;
                s = (String)responseHeaders.get(key);
                break;
            }
        }
        return s;
    }
}

