/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.PublicClonable;
import com.sas.collection.Nil;
import com.sas.collection.RB;
import com.sas.util.Countable;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;

public class Pair
implements PublicClonable,
Countable,
Serializable {
    static final long serialVersionUID = 6595897507134640222L;
    static final String RB_KEY = "Pair.";
    public static final Pair nil = new Nil();
    protected transient Object _car;
    protected transient Object _cdr;
    public static int printLength = 65536;
    public static int printDepth = 256;

    public Pair() {
        this._car = nil;
        this._cdr = nil;
    }

    public Pair(Pair other) {
        this(other.getFirst(), other.getSecond());
    }

    public Pair(Object first, Object second) {
        this._car = first == null ? nil : first;
        this._cdr = second == null ? nil : second;
    }

    public Pair(Object first) {
        this._car = first == null ? nil : first;
        this._cdr = nil;
    }

    public Pair(int count, Object initial) {
        if (count < 1) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "cannotMakeEmpty.ex.txt"));
        }
        this._car = initial;
        this._cdr = count > 1 ? (this._cdr = new Pair(count - 1, initial)) : nil;
    }

    public Pair(int count) {
        this._car = nil;
        if (count < 1) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "cannotMakeEmpty.ex.txt"));
        }
        this._cdr = count > 1 ? new Pair(count - 1) : nil;
    }

    public Pair(Object[] elements) {
        Pair last = this;
        if (elements.length < 1) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "cannotMakeEmpty.ex.txt"));
        }
        last._car = elements[0];
        last._cdr = nil;
        for (int i = 1; i < elements.length; ++i) {
            Pair cons = new Pair(elements[i]);
            last._cdr = cons;
            last = cons;
        }
    }

    public Pair(Enumeration elements) {
        Pair last = this;
        if (!elements.hasMoreElements()) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "cannotMakeEmpty.ex.txt"));
        }
        last._car = elements.nextElement();
        last._cdr = nil;
        while (elements.hasMoreElements()) {
            Pair cons = new Pair(elements.nextElement());
            last._cdr = cons;
            last = cons;
        }
    }

    public int hashCode() {
        return (this._car == nil ? 0 : this._car.hashCode()) + (this._cdr == nil ? 0 : this._cdr.hashCode());
    }

    public final Object car() {
        return this._car;
    }

    public Object getFirst() {
        return this.car();
    }

    public final Object cdr() {
        return this._cdr;
    }

    public Object getSecond() {
        return this.cdr();
    }

    public Object getSecond(int n) {
        Pair p = this.getTail(n - 1);
        return p.cdr();
    }

    public Pair getTail(int n) {
        Pair p = this;
        while (n-- > 0) {
            p = p.getTail();
        }
        return p;
    }

    public final Pair getTail() {
        if (this._cdr instanceof Pair) {
            return (Pair)this._cdr;
        }
        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidTail.ex.txt"));
    }

    public void setFirst(Object head) {
        this.setcar(head);
    }

    public void setcar(Object car) {
        this._car = car == null ? nil : car;
    }

    public void setSecond(Object tail) {
        this.setcdr(tail);
    }

    public void setcdr(Object cdr) {
        this._cdr = cdr == null ? nil : cdr;
    }

    public Pair reverse() {
        try {
            Pair copy = (Pair)this.clone();
            return copy.reverseInPlace();
        }
        catch (CloneNotSupportedException c) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "cannotReverse.ex.txt"));
        }
    }

    @Override
    public int count() {
        int len = 1;
        for (Pair cdr = this.getTail(); cdr != nil; cdr = cdr.getTail()) {
            ++len;
        }
        return len;
    }

    public void print() {
        this.print(System.out);
    }

    protected void print(PrintStream s) {
        this.print(s, 0);
    }

    private void printCar(PrintStream s, int depth) {
        if (this._car instanceof Pair) {
            ((Pair)this._car).print(s, depth + 1);
        } else {
            s.print(this._car.toString());
        }
    }

    protected void print(PrintStream s, int depth) {
        Object p = this.cdr();
        int length = 1;
        if (printDepth > 0 && depth > printDepth) {
            s.print("(***)");
            return;
        }
        s.print("(");
        this.printCar(s, depth + 1);
        while (p != nil && p instanceof Pair) {
            Pair list = (Pair)p;
            if (++length > printLength) {
                s.print(" ...");
                break;
            }
            s.print(" ");
            list.printCar(s, depth + 1);
            p = list.getTail();
        }
        if (p != nil) {
            s.print(". ");
            s.print(p.toString());
        }
        s.print(")\n");
    }

    public Pair transform(TransformInterface t) {
        Object tFirst = null;
        Object tRest = null;
        try {
            tFirst = t.transform(this.car());
        }
        catch (TransformException te) {
            // empty catch block
        }
        tRest = this.cdr();
        if (tRest instanceof Pair) {
            tRest = ((Pair)tRest).transform(t);
        }
        Pair result = new Pair(tFirst, tRest);
        return result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Pair newPair = (Pair)super.clone();
        Object newCar = this._car;
        Object newCdr = this._cdr;
        if (this == nil) {
            return nil;
        }
        if (this._car instanceof Pair) {
            newCar = ((Pair)this._car).clone();
        }
        if (this._cdr instanceof Pair) {
            newCdr = ((Pair)this._cdr).clone();
        }
        newPair.setcar(newCar);
        newPair.setcdr(newCdr);
        return newPair;
    }

    public Pair difference(Pair sublist) {
        if (this._cdr == nil) {
            return new Pair(this._car, this._cdr);
        }
        if (this._cdr == sublist) {
            return new Pair(this._car);
        }
        if (this._cdr instanceof Pair) {
            return new Pair(this._car, (Object)this.getTail().difference(sublist));
        }
        return new Pair(this._car, this._cdr);
    }

    public Pair reverseInPlace() {
        Pair p = this;
        Pair last = nil;
        Pair next = nil;
        while (p != nil) {
            next = p.getTail();
            p._cdr = last;
            last = p;
            p = next;
        }
        return last;
    }

    private static boolean equals(Object that, Object other) {
        if (that == nil || other == nil) {
            return that == other;
        }
        if (that instanceof Pair && other instanceof Pair) {
            return ((Pair)that).equals((Pair)other);
        }
        return that.equals(other);
    }

    public boolean equals(Pair other) {
        if (other == nil) {
            return false;
        }
        return Pair.equals(this._car, other.car()) && Pair.equals(this._cdr, other._cdr);
    }

    public boolean equals(Object otherObject) {
        if (otherObject instanceof Pair) {
            return this.equals((Pair)otherObject);
        }
        return false;
    }

    public Object getItem(int n) {
        Pair p = this.getTail(n);
        return p.car();
    }

    public Pair getLast() {
        Pair p;
        for (p = this; p != nil && p._cdr instanceof Pair; p = p.getTail()) {
        }
        return p;
    }

    public boolean isNull(Pair p) {
        return false;
    }

    public String toString() {
        return "(" + this.getFirst() + " . " + this.getSecond() + ")";
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this._car = stream.readBoolean() ? stream.readObject() : nil;
        this._cdr = stream.readBoolean() ? stream.readObject() : nil;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeBoolean(this._car != nil);
        if (this._car != nil) {
            stream.writeObject(this._car);
        }
        stream.writeBoolean(this._cdr != nil);
        if (this._cdr != nil) {
            stream.writeObject(this._cdr);
        }
        stream.defaultWriteObject();
    }

    static {
        Pair.nil._car = nil;
        Pair.nil._cdr = nil;
    }
}

