# coding: utf-8

"""
    Bacalhau API

    This page is the reference of the Bacalhau REST API. Project docs are available at https://docs.bacalhau.org/. Find more information about Bacalhau at https://github.com/filecoin-project/bacalhau.  # noqa: E501

    OpenAPI spec version: 0.3.22.post4
    Contact: team@bacalhau.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from bacalhau_apiclient.configuration import Configuration


class NetworkConfig(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'domains': 'list[str]',
        'type': 'Network'
    }

    attribute_map = {
        'domains': 'Domains',
        'type': 'Type'
    }

    def __init__(self, domains=None, type=None, _configuration=None):  # noqa: E501
        """NetworkConfig - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._domains = None
        self._type = None
        self.discriminator = None

        if domains is not None:
            self.domains = domains
        if type is not None:
            self.type = type

    @property
    def domains(self):
        """Gets the domains of this NetworkConfig.  # noqa: E501


        :return: The domains of this NetworkConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._domains

    @domains.setter
    def domains(self, domains):
        """Sets the domains of this NetworkConfig.


        :param domains: The domains of this NetworkConfig.  # noqa: E501
        :type: list[str]
        """

        self._domains = domains

    @property
    def type(self):
        """Gets the type of this NetworkConfig.  # noqa: E501


        :return: The type of this NetworkConfig.  # noqa: E501
        :rtype: Network
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this NetworkConfig.


        :param type: The type of this NetworkConfig.  # noqa: E501
        :type: Network
        """

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NetworkConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetworkConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NetworkConfig):
            return True

        return self.to_dict() != other.to_dict()
