/* DO NOT EDIT THE BELOW FILE AS THIS IS LIKELY WILL BE GENERATED AGAIN AND REWRITE OVER IT */
// tslint:disable:no-consecutive-blank-lines ordered-imports align trailing-comma enum-naming
// tslint:disable:whitespace no-unbound-method no-trailing-whitespace no-camelcase
// tslint:disable:no-unused-variable
import TronWeb, {BigNumber, version, Contract} from "tronweb"
import BaseContract from "./base/base"
import {ReqEventResult} from "abi/base/types";
// eslint-disable-next-line import/named
export interface CheckResultEventArgs {
    checker: string;
    found: BigNumber;
    size: BigNumber;
    amount: BigNumber;
}
export interface ClaimPaymentEventArgs {
    beneficiary: string;
    amount: BigNumber;
}
export interface DepositStakingEventArgs {
    _person: string;
    amount: BigNumber;
}
export interface DrawDismissEventArgs {
    checker: string;
    round: BigNumber;
}
export interface DripEventArgs {
    _caller: string;
    _amount: BigNumber;
}
export interface DurationUpdateEventArgs {
    _duration: BigNumber;
}
export interface FailedPaymentEventArgs {
    beneficiary: string;
    amount: BigNumber;
}
export interface FrequencyUpdateEventArgs {
    _frequency: BigNumber;
}
export interface GenesisContractUpdateEventArgs {
    _contract: string;
}
export interface GenesisPeriodCompleteEventArgs {
    _blocktime: BigNumber;
}
export interface IncentiveUpdateEventArgs {
    _incentiveAmount: BigNumber;
}
export interface LiquidityWithdrawEventArgs {
    _amount: BigNumber;
}
export interface MineWithdrawEventArgs {
    _amount: BigNumber;
}
export interface MiningTokenContractUpdateEventArgs {
    _contract: string;
}
export interface NetworkContractUpdateEventArgs {
    _contract: string;
}
export interface NetworkStakingTargetUpdateEventArgs {
    _amount: BigNumber;
}
export interface OwnershipTransferredEventArgs {
    previousOwner: string;
    newOwner: string;
}
export interface PurchaseTicketEventArgs {
    buyer: string;
    amount: BigNumber;
}
export interface ReferralPaymentEventArgs {
    beneficiary: string;
    amount: BigNumber;
}
export interface StakingContractUpdateEventArgs {
    _contract: string;
}
export interface TimerResetEventArgs {
    _startTime: BigNumber;
}
export interface TokenContractUpdateEventArgs {
    _contract: string;
}
export interface WinningNumbersEventArgs {
    openNum: BigNumber[];
}
export interface traillockEventArgs {
    value: BigNumber;
}

type Param = {
    type: string,
    value: any
}

export interface ContractInterface {
    SERVICE_FEE():Promise<BigNumber>
    addCroupier(account: string):Promise<void>
    addGovernor(account: string):Promise<void>
    addWhitelistAdmin(account: string):Promise<void>
    allTickets(index_0: string):Promise<[string, BigNumber, BigNumber, boolean, boolean, boolean, BigNumber, BigNumber, BigNumber]>
    buyTicketTRC20(combo: string[], amount: string):Promise<void>
    changeSettings(hour: string, gMin: string, tktPrice: string):Promise<void>
    checkClaimed(ticketId: string):Promise<boolean>
    checkCompleteNewRound():Promise<void>
    checkExistAddress(up: string):Promise<boolean>
    claimBasic(ticket_id: string):Promise<void>
    claimTop(ticket_id: string):Promise<void>
    compareStr(src: string, src_compared: string):Promise<boolean>
    contractInvalidate():Promise<void>
    currentMaxClaim():Promise<BigNumber>
    depositFundsTrx(trx:number):Promise<void>
    difficulty():Promise<BigNumber>
    distributedRewards():Promise<BigNumber>
    drawWin():Promise<BigNumber>
    drip():Promise<BigNumber>
    dripFrequency():Promise<BigNumber>
    duration():Promise<BigNumber>
    endGenesisFunding():Promise<void>
    expectedMinPoolSizeUSDT():Promise<BigNumber>
    genesisCutoffBalance():Promise<BigNumber>
    incentiveAmount():Promise<BigNumber>
    initStakingModule(_duration: string, _frequency: string, _ratioTargetStakingUSD: string, _expectedPoolSizeUSD: string):Promise<void>
    installGenesis(m: string):Promise<void>
    installMiningToken(deploymentAddress: string):Promise<void>
    installNetworkContract(deploymentAddress: string):Promise<void>
    installTokenCurrency(deploymentAddress: string):Promise<void>
    isCroupier(account: string):Promise<boolean>
    isDripAvailable():Promise<boolean>
    isGovernor(account: string):Promise<boolean>
    isLocked():Promise<boolean>
    isOwner():Promise<boolean>
    isTimeEnded():Promise<boolean>
    isTimeStarted():Promise<boolean>
    isWhitelistAdmin(account: string):Promise<boolean>
    katana():Promise<void>
    lastDistributionTime():Promise<BigNumber>
    lock():Promise<void>
    minedRewards():Promise<BigNumber>
    networkStakingConstantUSDT():Promise<BigNumber>
    nextDripAvailable():Promise<BigNumber>
    owner():Promise<string>
    playerList():Promise<[string[], BigNumber[]]>
    playerTotal(_address: string):Promise<BigNumber>
    registeredFunds(index_0: string):Promise<BigNumber>
    registeredFundsTRC20(index_0: string):Promise<[BigNumber, BigNumber, BigNumber, BigNumber]>
    releasedReward():Promise<BigNumber>
    remainingTime():Promise<BigNumber>
    removeCroupier(account: string):Promise<void>
    removeGovernor(account: string):Promise<void>
    removeWhitelistAdmin(account: string):Promise<void>
    renounceOwnership():Promise<void>
    rewardBalance():Promise<BigNumber>
    seeGenesis():Promise<string>
    seeMiningTokenAddress():Promise<string>
    seeNetworkAddress():Promise<string>
    seeTokenAddress():Promise<string>
    setDripFrequency(_frequency: string):Promise<void>
    setIncentiveAmount(_incentiveAmount: string):Promise<void>
    setNetworkStakingTarget(_u: string):Promise<void>
    shenzhen():Promise<[BigNumber[], boolean[]]>
    stakingDepositFund(amount: string):Promise<void>
    startTime():Promise<BigNumber>
    stringToBytes32(source: string):Promise<string>
    test_picks():Promise<BigNumber[]>
    test_rng():Promise<string>
    ticketKeys(index_0: string, index_1: string):Promise<BigNumber>
    tier():Promise<BigNumber>
    timeSinceStart():Promise<BigNumber>
    totalMiningSupply():Promise<BigNumber>
    totalReward():Promise<BigNumber>
    transferOwnership(newOwner: string):Promise<void>
    unlock():Promise<void>
    unreleasedReward():Promise<BigNumber>
    unstakeClaim():Promise<void>
    withdrawFundsTrx():Promise<void>
    withdrawMinerals():Promise<void>
    zjLimits(wtrx: string, sinktrx: string):Promise<void>
}

// @ts-ignore
export class TRC775 extends BaseContract implements ContractInterface {

public static deployedBytecode = "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";
public static contractName = "TRC775";
    __debug:boolean = true;

    tronweb: TronWeb = null;
    contract: Contract;
    contract_address_t: string;
    based_version: string = version;

    constructor(tron: TronWeb) {
        super();
        this.tronweb = tron
    }

    public static Instance(): (TRC775 | any | boolean) {
        if (window && window.hasOwnProperty("___contract__TRC775__")) {
          // @ts-ignore
          const obj = window.___contract__TRC775__
          if (obj instanceof TRC775) {
            return (obj) as TRC775
          } else {
            return (obj) as TRC775
          }
        } else {
          return false
        }
    }

    async init(contract_address: string) {
        this.contract = await new Contract(this.tronweb, TRC775.ABI(), contract_address);
        /**this.contract = await this.tronweb.contract().new({
            abi:CONTRACT_ABI,
            bytecode: TRC775.deployedBytecode
        });**/
        this.contract_address_t = contract_address;
        if (window && !window.hasOwnProperty("___contract__TRC775__")) {
            // @ts-ignore
            window.___contract__TRC775__ = this
        }   
    }

    setDebug(bool:boolean){
        this.__debug = bool
    }

    public isVersionCompatible():boolean {
      return this.based_version === this.tronweb.version
    }


    // @ts-ignore
    public async SERVICE_FEE():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.SERVICE_FEE()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 SERVICE_FEE");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async addCroupier(account: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.addCroupier(account)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 addCroupier");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async addGovernor(account: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.addGovernor(account)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 addGovernor");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async addWhitelistAdmin(account: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.addWhitelistAdmin(account)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 addWhitelistAdmin");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async allTickets(index_0: string):Promise<[string, BigNumber, BigNumber, boolean, boolean, boolean, BigNumber, BigNumber, BigNumber]>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.allTickets(index_0)
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 allTickets");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async buyTicketTRC20(combo: string[], amount: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.buyTicketTRC20(combo, amount)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 buyTicketTRC20");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async changeSettings(hour: string, gMin: string, tktPrice: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.changeSettings(hour, gMin, tktPrice)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 changeSettings");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async checkClaimed(ticketId: string):Promise<boolean>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.checkClaimed(ticketId)
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 checkClaimed");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async checkCompleteNewRound():Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.checkCompleteNewRound()
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 checkCompleteNewRound");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async checkExistAddress(up: string):Promise<boolean>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.checkExistAddress(up)
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 checkExistAddress");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async claimBasic(ticket_id: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.claimBasic(ticket_id)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 claimBasic");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async claimTop(ticket_id: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.claimTop(ticket_id)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 claimTop");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async compareStr(src: string, src_compared: string):Promise<boolean>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.compareStr(src, src_compared)
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 compareStr");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async contractInvalidate():Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.contractInvalidate()
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 contractInvalidate");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async currentMaxClaim():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.currentMaxClaim()
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 currentMaxClaim");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async depositFundsTrx(trx:number):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  trx ,
        }
        let val = await this.contract.depositFundsTrx()
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 depositFundsTrx");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async difficulty():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.difficulty()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 difficulty");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async distributedRewards():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.distributedRewards()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 distributedRewards");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async drawWin():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.drawWin()
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 drawWin");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async drip():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.drip()
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 drip");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async dripFrequency():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.dripFrequency()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 dripFrequency");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async duration():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.duration()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 duration");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async endGenesisFunding():Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.endGenesisFunding()
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 endGenesisFunding");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async expectedMinPoolSizeUSDT():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.expectedMinPoolSizeUSDT()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 expectedMinPoolSizeUSDT");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async genesisCutoffBalance():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.genesisCutoffBalance()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 genesisCutoffBalance");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async incentiveAmount():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.incentiveAmount()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 incentiveAmount");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async initStakingModule(_duration: string, _frequency: string, _ratioTargetStakingUSD: string, _expectedPoolSizeUSD: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.initStakingModule(_duration, _frequency, _ratioTargetStakingUSD, _expectedPoolSizeUSD)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 initStakingModule");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async installGenesis(m: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.installGenesis(m)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 installGenesis");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async installMiningToken(deploymentAddress: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.installMiningToken(deploymentAddress)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 installMiningToken");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async installNetworkContract(deploymentAddress: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.installNetworkContract(deploymentAddress)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 installNetworkContract");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async installTokenCurrency(deploymentAddress: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.installTokenCurrency(deploymentAddress)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 installTokenCurrency");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async isCroupier(account: string):Promise<boolean>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.isCroupier(account)
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 isCroupier");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async isDripAvailable():Promise<boolean>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.isDripAvailable()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 isDripAvailable");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async isGovernor(account: string):Promise<boolean>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.isGovernor(account)
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 isGovernor");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async isLocked():Promise<boolean>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.isLocked()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 isLocked");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async isOwner():Promise<boolean>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.isOwner()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 isOwner");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async isTimeEnded():Promise<boolean>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.isTimeEnded()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 isTimeEnded");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async isTimeStarted():Promise<boolean>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.isTimeStarted()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 isTimeStarted");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async isWhitelistAdmin(account: string):Promise<boolean>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.isWhitelistAdmin(account)
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 isWhitelistAdmin");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async katana():Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.katana()
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 katana");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async lastDistributionTime():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.lastDistributionTime()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 lastDistributionTime");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async lock():Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.lock()
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 lock");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async minedRewards():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.minedRewards()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 minedRewards");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async networkStakingConstantUSDT():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.networkStakingConstantUSDT()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 networkStakingConstantUSDT");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async nextDripAvailable():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.nextDripAvailable()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 nextDripAvailable");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async owner():Promise<string>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.owner()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 owner");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async playerList():Promise<[string[], BigNumber[]]>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.playerList()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 playerList");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async playerTotal(_address: string):Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.playerTotal(_address)
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 playerTotal");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async registeredFunds(index_0: string):Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.registeredFunds(index_0)
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 registeredFunds");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async registeredFundsTRC20(index_0: string):Promise<[BigNumber, BigNumber, BigNumber, BigNumber]>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.registeredFundsTRC20(index_0)
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 registeredFundsTRC20");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async releasedReward():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.releasedReward()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 releasedReward");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async remainingTime():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.remainingTime()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 remainingTime");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async removeCroupier(account: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.removeCroupier(account)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 removeCroupier");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async removeGovernor(account: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.removeGovernor(account)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 removeGovernor");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async removeWhitelistAdmin(account: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.removeWhitelistAdmin(account)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 removeWhitelistAdmin");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async renounceOwnership():Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.renounceOwnership()
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 renounceOwnership");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async rewardBalance():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.rewardBalance()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 rewardBalance");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async seeGenesis():Promise<string>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.seeGenesis()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 seeGenesis");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async seeMiningTokenAddress():Promise<string>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.seeMiningTokenAddress()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 seeMiningTokenAddress");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async seeNetworkAddress():Promise<string>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.seeNetworkAddress()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 seeNetworkAddress");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async seeTokenAddress():Promise<string>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.seeTokenAddress()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 seeTokenAddress");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async setDripFrequency(_frequency: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.setDripFrequency(_frequency)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 setDripFrequency");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async setIncentiveAmount(_incentiveAmount: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.setIncentiveAmount(_incentiveAmount)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 setIncentiveAmount");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async setNetworkStakingTarget(_u: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.setNetworkStakingTarget(_u)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 setNetworkStakingTarget");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async shenzhen():Promise<[BigNumber[], boolean[]]>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.shenzhen()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 shenzhen");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async stakingDepositFund(amount: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.stakingDepositFund(amount)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 stakingDepositFund");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async startTime():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.startTime()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 startTime");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async stringToBytes32(source: string):Promise<string>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.stringToBytes32(source)
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 stringToBytes32");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async test_picks():Promise<BigNumber[]>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.test_picks()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 test_picks");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async test_rng():Promise<string>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.test_rng()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 test_rng");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async ticketKeys(index_0: string, index_1: string):Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.ticketKeys(index_0, index_1)
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 ticketKeys");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async tier():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.tier()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 tier");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async timeSinceStart():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.timeSinceStart()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 timeSinceStart");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async totalMiningSupply():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.totalMiningSupply()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 totalMiningSupply");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async totalReward():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.totalReward()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 totalReward");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async transferOwnership(newOwner: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.transferOwnership(newOwner)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 transferOwnership");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async unlock():Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.unlock()
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 unlock");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async unreleasedReward():Promise<BigNumber>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  true ,
            callValue:  0 ,
        }
        let val = await this.contract.unreleasedReward()
         .call(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 unreleasedReward");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async unstakeClaim():Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.unstakeClaim()
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 unstakeClaim");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async withdrawFundsTrx():Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.withdrawFundsTrx()
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 withdrawFundsTrx");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async withdrawMinerals():Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.withdrawMinerals()
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 withdrawMinerals");
            console.log(val);
            console.groupEnd();
        }
        return val
    }


    // @ts-ignore
    public async zjLimits(wtrx: string, sinktrx: string):Promise<void>{
        let callparams = {
            userFeePercentage: 30,
            feeLimit: 100000000,
            shouldPollResponse:true,
            _isConstant:  false ,
            callValue:  0 ,
        }
        let val = await this.contract.zjLimits(wtrx, sinktrx)
         .send(callparams) 
        ;

        if(this.__debug){
            console.group("==> debug return raw 💮 zjLimits");
            console.log(val);
            console.groupEnd();
        }
        return val
    }



    public async eventQ(event_name: string, page: number, since: number = 0): Promise<Array<ReqEventResult>> {
        const data = await this.tronweb && this.contract && this.tronweb.getEventResult(
            this.contract_address_t,
            since,
            event_name,
            0,
            20,
            page
        )
        return data
    }


    async startEventListeners():Promise<any> {
        // @ts-ignore
        await this.contract && this.contract.CheckResult().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_CheckResult", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.ClaimPayment().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_ClaimPayment", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.DepositStaking().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_DepositStaking", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.DrawDismiss().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_DrawDismiss", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.Drip().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_Drip", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.DurationUpdate().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_DurationUpdate", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.FailedPayment().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_FailedPayment", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.FrequencyUpdate().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_FrequencyUpdate", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.GenesisContractUpdate().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_GenesisContractUpdate", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.GenesisPeriodComplete().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_GenesisPeriodComplete", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.IncentiveUpdate().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_IncentiveUpdate", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.LiquidityWithdraw().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_LiquidityWithdraw", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.MineWithdraw().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_MineWithdraw", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.MiningTokenContractUpdate().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_MiningTokenContractUpdate", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.NetworkContractUpdate().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_NetworkContractUpdate", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.NetworkStakingTargetUpdate().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_NetworkStakingTargetUpdate", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.OwnershipTransferred().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_OwnershipTransferred", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.PurchaseTicket().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_PurchaseTicket", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.ReferralPayment().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_ReferralPayment", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.StakingContractUpdate().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_StakingContractUpdate", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.TimerReset().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_TimerReset", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.TokenContractUpdate().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_TokenContractUpdate", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.WinningNumbers().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_WinningNumbers", event_payload);
            }
        


        });
        // @ts-ignore
        await this.contract && this.contract.traillock().watch((err, event_payload) => {
            if (err) return console.error('Failed to bind event listener:', err);
    
            if(event_payload){
                let {result,block,transaction,name,contract} = event_payload;


       
                if (this.__debug){
                    console.group('New event received');
                    console.log('- Contract Address:', contract);
                    console.log('- Event Name:', name);
                    console.log('- Transaction:',transaction);
                    console.log('- Block number:', block);
                    console.log('- Result:', result, '\n');
                    console.groupEnd();
                }     
                this.emit("event_traillock", event_payload);
            }
        


        });
    }
   /**
     * @returns The contract ABI
     */
    public static ABI(): any {
        const abi = [
            { 
                inputs: [
                ],
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'constructor',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: 'checker',
                        type: 'address',
                        indexed: true,
                    },
                    {
                        name: 'found',
                        type: 'uint8',
                        indexed: false,
                    },
                    {
                        name: 'size',
                        type: 'uint256',
                        indexed: false,
                    },
                    {
                        name: 'amount',
                        type: 'uint256',
                        indexed: false,
                    },
                ],
                name: 'CheckResult',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: 'beneficiary',
                        type: 'address',
                        indexed: true,
                    },
                    {
                        name: 'amount',
                        type: 'uint256',
                        indexed: false,
                    },
                ],
                name: 'ClaimPayment',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: '_person',
                        type: 'address',
                        indexed: true,
                    },
                    {
                        name: 'amount',
                        type: 'uint256',
                        indexed: false,
                    },
                ],
                name: 'DepositStaking',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: 'checker',
                        type: 'address',
                        indexed: true,
                    },
                    {
                        name: 'round',
                        type: 'uint256',
                        indexed: false,
                    },
                ],
                name: 'DrawDismiss',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: '_caller',
                        type: 'address',
                        indexed: true,
                    },
                    {
                        name: '_amount',
                        type: 'uint256',
                        indexed: false,
                    },
                ],
                name: 'Drip',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: '_duration',
                        type: 'uint256',
                        indexed: false,
                    },
                ],
                name: 'DurationUpdate',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: 'beneficiary',
                        type: 'address',
                        indexed: true,
                    },
                    {
                        name: 'amount',
                        type: 'uint256',
                        indexed: false,
                    },
                ],
                name: 'FailedPayment',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: '_frequency',
                        type: 'uint256',
                        indexed: false,
                    },
                ],
                name: 'FrequencyUpdate',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: '_contract',
                        type: 'address',
                        indexed: true,
                    },
                ],
                name: 'GenesisContractUpdate',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: '_blocktime',
                        type: 'uint256',
                        indexed: false,
                    },
                ],
                name: 'GenesisPeriodComplete',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: '_incentiveAmount',
                        type: 'uint256',
                        indexed: false,
                    },
                ],
                name: 'IncentiveUpdate',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: '_amount',
                        type: 'uint256',
                        indexed: false,
                    },
                ],
                name: 'LiquidityWithdraw',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: '_amount',
                        type: 'uint256',
                        indexed: false,
                    },
                ],
                name: 'MineWithdraw',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: '_contract',
                        type: 'address',
                        indexed: true,
                    },
                ],
                name: 'MiningTokenContractUpdate',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: '_contract',
                        type: 'address',
                        indexed: true,
                    },
                ],
                name: 'NetworkContractUpdate',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: '_amount',
                        type: 'uint256',
                        indexed: false,
                    },
                ],
                name: 'NetworkStakingTargetUpdate',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: 'previousOwner',
                        type: 'address',
                        indexed: true,
                    },
                    {
                        name: 'newOwner',
                        type: 'address',
                        indexed: true,
                    },
                ],
                name: 'OwnershipTransferred',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: 'buyer',
                        type: 'address',
                        indexed: true,
                    },
                    {
                        name: 'amount',
                        type: 'uint256',
                        indexed: false,
                    },
                ],
                name: 'PurchaseTicket',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: 'beneficiary',
                        type: 'address',
                        indexed: true,
                    },
                    {
                        name: 'amount',
                        type: 'uint256',
                        indexed: false,
                    },
                ],
                name: 'ReferralPayment',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: '_contract',
                        type: 'address',
                        indexed: true,
                    },
                ],
                name: 'StakingContractUpdate',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: '_startTime',
                        type: 'uint256',
                        indexed: false,
                    },
                ],
                name: 'TimerReset',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: '_contract',
                        type: 'address',
                        indexed: true,
                    },
                ],
                name: 'TokenContractUpdate',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: 'openNum',
                        type: 'uint8[7]',
                        indexed: false,
                    },
                ],
                name: 'WinningNumbers',
                outputs: [
                ],
                type: 'event',
            },
            { 
                anonymous: false,
                inputs: [
                    {
                        name: 'value',
                        type: 'uint8',
                        indexed: false,
                    },
                ],
                name: 'traillock',
                outputs: [
                ],
                type: 'event',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'SERVICE_FEE',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: 'account',
                        type: 'address',
                    },
                ],
                name: 'addCroupier',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: 'account',
                        type: 'address',
                    },
                ],
                name: 'addGovernor',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: 'account',
                        type: 'address',
                    },
                ],
                name: 'addWhitelistAdmin',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                    {
                        name: 'index_0',
                        type: 'uint256',
                    },
                ],
                name: 'allTickets',
                outputs: [
                    {
                        name: 'playerAddress',
                        type: 'address',
                    },
                    {
                        name: 'price',
                        type: 'uint256',
                    },
                    {
                        name: 'inRound',
                        type: 'uint48',
                    },
                    {
                        name: 'checked',
                        type: 'bool',
                    },
                    {
                        name: 'isTopPrize',
                        type: 'bool',
                    },
                    {
                        name: 'claimed',
                        type: 'bool',
                    },
                    {
                        name: 'hits',
                        type: 'uint8',
                    },
                    {
                        name: 'unclaimFactor',
                        type: 'uint256',
                    },
                    {
                        name: 'unclaimTotal',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: 'combo',
                        type: 'uint8[]',
                    },
                    {
                        name: 'amount',
                        type: 'uint256',
                    },
                ],
                name: 'buyTicketTRC20',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: 'hour',
                        type: 'uint256',
                    },
                    {
                        name: 'gMin',
                        type: 'uint256',
                    },
                    {
                        name: 'tktPrice',
                        type: 'uint256',
                    },
                ],
                name: 'changeSettings',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                    {
                        name: 'ticketId',
                        type: 'uint256',
                    },
                ],
                name: 'checkClaimed',
                outputs: [
                    {
                        name: '',
                        type: 'bool',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                ],
                name: 'checkCompleteNewRound',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                    {
                        name: 'up',
                        type: 'address',
                    },
                ],
                name: 'checkExistAddress',
                outputs: [
                    {
                        name: '',
                        type: 'bool',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: 'ticket_id',
                        type: 'uint256',
                    },
                ],
                name: 'claimBasic',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: 'ticket_id',
                        type: 'uint256',
                    },
                ],
                name: 'claimTop',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                    {
                        name: 'src',
                        type: 'string',
                    },
                    {
                        name: 'src_compared',
                        type: 'string',
                    },
                ],
                name: 'compareStr',
                outputs: [
                    {
                        name: '',
                        type: 'bool',
                    },
                ],
                payable: false,
                stateMutability: 'pure',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                ],
                name: 'contractInvalidate',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                ],
                name: 'currentMaxClaim',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                ],
                name: 'depositFundsTrx',
                outputs: [
                ],
                payable: true,
                stateMutability: 'payable',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'difficulty',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'distributedRewards',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                ],
                name: 'drawWin',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                ],
                name: 'drip',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'dripFrequency',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'duration',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                ],
                name: 'endGenesisFunding',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'expectedMinPoolSizeUSDT',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'genesisCutoffBalance',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'incentiveAmount',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: '_duration',
                        type: 'uint256',
                    },
                    {
                        name: '_frequency',
                        type: 'uint256',
                    },
                    {
                        name: '_ratioTargetStakingUSD',
                        type: 'uint256',
                    },
                    {
                        name: '_expectedPoolSizeUSD',
                        type: 'uint256',
                    },
                ],
                name: 'initStakingModule',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: 'm',
                        type: 'address',
                    },
                ],
                name: 'installGenesis',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: 'deploymentAddress',
                        type: 'address',
                    },
                ],
                name: 'installMiningToken',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: 'deploymentAddress',
                        type: 'address',
                    },
                ],
                name: 'installNetworkContract',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: 'deploymentAddress',
                        type: 'address',
                    },
                ],
                name: 'installTokenCurrency',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                    {
                        name: 'account',
                        type: 'address',
                    },
                ],
                name: 'isCroupier',
                outputs: [
                    {
                        name: '',
                        type: 'bool',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'isDripAvailable',
                outputs: [
                    {
                        name: '',
                        type: 'bool',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                    {
                        name: 'account',
                        type: 'address',
                    },
                ],
                name: 'isGovernor',
                outputs: [
                    {
                        name: '',
                        type: 'bool',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'isLocked',
                outputs: [
                    {
                        name: '',
                        type: 'bool',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'isOwner',
                outputs: [
                    {
                        name: '',
                        type: 'bool',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'isTimeEnded',
                outputs: [
                    {
                        name: '',
                        type: 'bool',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'isTimeStarted',
                outputs: [
                    {
                        name: '',
                        type: 'bool',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                    {
                        name: 'account',
                        type: 'address',
                    },
                ],
                name: 'isWhitelistAdmin',
                outputs: [
                    {
                        name: '',
                        type: 'bool',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                ],
                name: 'katana',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'lastDistributionTime',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                ],
                name: 'lock',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'minedRewards',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'networkStakingConstantUSDT',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'nextDripAvailable',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'owner',
                outputs: [
                    {
                        name: '',
                        type: 'address',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'playerList',
                outputs: [
                    {
                        name: '_addresses',
                        type: 'address[]',
                    },
                    {
                        name: '_values',
                        type: 'uint256[]',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                    {
                        name: '_address',
                        type: 'address',
                    },
                ],
                name: 'playerTotal',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                    {
                        name: 'index_0',
                        type: 'address',
                    },
                ],
                name: 'registeredFunds',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                    {
                        name: 'index_0',
                        type: 'address',
                    },
                ],
                name: 'registeredFundsTRC20',
                outputs: [
                    {
                        name: 'staking',
                        type: 'uint256',
                    },
                    {
                        name: 'reward',
                        type: 'uint256',
                    },
                    {
                        name: 'claimed',
                        type: 'uint256',
                    },
                    {
                        name: 'mining',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'releasedReward',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'remainingTime',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: 'account',
                        type: 'address',
                    },
                ],
                name: 'removeCroupier',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: 'account',
                        type: 'address',
                    },
                ],
                name: 'removeGovernor',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: 'account',
                        type: 'address',
                    },
                ],
                name: 'removeWhitelistAdmin',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                ],
                name: 'renounceOwnership',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'rewardBalance',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'seeGenesis',
                outputs: [
                    {
                        name: '',
                        type: 'address',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'seeMiningTokenAddress',
                outputs: [
                    {
                        name: '',
                        type: 'address',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'seeNetworkAddress',
                outputs: [
                    {
                        name: '',
                        type: 'address',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'seeTokenAddress',
                outputs: [
                    {
                        name: '',
                        type: 'address',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: '_frequency',
                        type: 'uint256',
                    },
                ],
                name: 'setDripFrequency',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: '_incentiveAmount',
                        type: 'uint256',
                    },
                ],
                name: 'setIncentiveAmount',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: '_u',
                        type: 'uint256',
                    },
                ],
                name: 'setNetworkStakingTarget',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'shenzhen',
                outputs: [
                    {
                        name: 'lottoInfo',
                        type: 'uint256[14]',
                    },
                    {
                        name: 'flags',
                        type: 'bool[4]',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: 'amount',
                        type: 'uint256',
                    },
                ],
                name: 'stakingDepositFund',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'startTime',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                    {
                        name: 'source',
                        type: 'string',
                    },
                ],
                name: 'stringToBytes32',
                outputs: [
                    {
                        name: 'result',
                        type: 'bytes32',
                    },
                ],
                payable: false,
                stateMutability: 'pure',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'test_picks',
                outputs: [
                    {
                        name: 'pickList',
                        type: 'uint8[7]',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'test_rng',
                outputs: [
                    {
                        name: '',
                        type: 'bytes32',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                    {
                        name: 'index_0',
                        type: 'address',
                    },
                    {
                        name: 'index_1',
                        type: 'uint256',
                    },
                ],
                name: 'ticketKeys',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'tier',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'timeSinceStart',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'totalMiningSupply',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'totalReward',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: 'newOwner',
                        type: 'address',
                    },
                ],
                name: 'transferOwnership',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                ],
                name: 'unlock',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: true,
                inputs: [
                ],
                name: 'unreleasedReward',
                outputs: [
                    {
                        name: '',
                        type: 'uint256',
                    },
                ],
                payable: false,
                stateMutability: 'view',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                ],
                name: 'unstakeClaim',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                ],
                name: 'withdrawFundsTrx',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                ],
                name: 'withdrawMinerals',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
            { 
                constant: false,
                inputs: [
                    {
                        name: 'wtrx',
                        type: 'uint256',
                    },
                    {
                        name: 'sinktrx',
                        type: 'uint256',
                    },
                ],
                name: 'zjLimits',
                outputs: [
                ],
                payable: false,
                stateMutability: 'nonpayable',
                type: 'function',
            },
        ];
        return abi;
    }
}