"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
// import * as kong_core from '../../kong-core/';
const kong_core = require("kong-core");
const index_1 = require("./resources/eks/helm-charts/kong/index");
class KongEks extends constructs_1.Construct {
    // public endpoints: DnsProps;
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        // this.endpoints = {
        //   adminDns: `admin.${props.hostedZoneName}:443`,
        //   clusterDns: `cluster.${props.hostedZoneName}:443`,
        //   telemetryDns: `telemetry.${props.hostedZoneName}:443`,
        //   managerDns: `manager.${props.hostedZoneName}:443`,
        // };
        const control_plane_secretskey = new aws_cdk_lib_1.aws_kms.Key(this, 'CPSecretsKey', {
            enableKeyRotation: true,
        });
        this.controlPlane = new aws_cdk_lib_1.aws_eks.Cluster(this, 'CP', {
            ...props.controlPlaneClusterProps.eksClusterProps,
            secretsEncryptionKey: control_plane_secretskey,
            defaultCapacity: 0,
            albController: {
                version: aws_cdk_lib_1.aws_eks.AlbControllerVersion.V2_4_1,
            },
        });
        const cp_nodegroup = this.controlPlane.addNodegroupCapacity('CpASG', props.controlPlaneNodeProps);
        cp_nodegroup.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        // new EksNodeHandler(this, 'NodeHandler', {
        //   cluster: this.controlPlane,
        //   nodegroup: cp_nodegroup,
        // });
        new kong_core.MetricsServer(this, 'MetricsServer', {
            cluster: this.controlPlane,
        });
        const kong_rds_instance = new kong_core.RdsStack(this, 'KongRds', {
            ...props.rdsProps,
            vpc: this.controlPlane.vpc,
        });
        const kong_pre_requisites_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongPreReqsStack');
        new kong_core.AutoScalar(this, 'AutoScalar', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
        });
        new kong_core.SecretsManager(kong_pre_requisites_nested_stack, 'SecretsCsi', {
            cluster: this.controlPlane,
        });
        new kong_core.ExternalDns(kong_pre_requisites_nested_stack, 'ExtDns', {
            cluster: this.controlPlane,
            hostedZoneName: props.dnsProps.hostedZoneName,
        });
        const aws_acm_pca = new kong_core.AcmPca(kong_pre_requisites_nested_stack, 'KongCpCa', {
            hostedZoneName: props.dnsProps.hostedZoneName,
            vpc: this.controlPlane.vpc,
        });
        new kong_core.AwsCertManager(kong_pre_requisites_nested_stack, 'KongCpCertManager', {
            cluster: this.controlPlane,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            privateCaArn: aws_acm_pca.privateCaArn,
        });
        this.privateCaArn = aws_acm_pca.privateCaArn;
        const kong_control_plane_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongCpNestedStack');
        new index_1.KongControlPlaneEKS(kong_control_plane_nested_stack, 'KongCPHelmInstall', {
            cluster: this.controlPlane,
            rds: kong_rds_instance.kongPostgresSql,
            namespace: props.namespace,
            // nodegroup: cp_nodegroup,
            license_secret_name: props.licenseSecretsName,
            cacertname: kong_core.Tls.KONG_CP_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            // commonname: 'www.dummy.com',
            // hostedZoneName: props.dnsProps.hostedZoneName,
            HelmOptions: props.controlPlaneClusterProps.kongHelmOptions,
            endpoints: props.dnsProps,
        });
        kong_control_plane_nested_stack.node.addDependency(kong_pre_requisites_nested_stack, kong_rds_instance);
        const telemetry_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongTelemetryNestedStack');
        const telemetry_stack = new kong_core.Telemetry(telemetry_nested_stack, 'KongLogging', {
            createPrometheusWorkspace: props.controlPlaneClusterProps.kongTelemetryOptions.createPrometheusWorkspace,
            cluster: this.controlPlane,
            namespace: kong_core.Namespace.TELEMETRY,
        });
        this.prometheusEndpoint = telemetry_stack.prometheusEndpoint;
        telemetry_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
    }
    ;
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-control-plane.KongEks", version: "3.0.0-dev.18" };
//# sourceMappingURL=data:application/json;base64,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