# Automation Script Examples

This directory contains examples demonstrating automation scripts using the MCP Hardware Project.

## Examples

### automation_script.py

This example shows how to create automation scripts that can control hardware based on schedules, events, or conditions.

**Features:**
- Scheduled tasks
- Event-driven automation
- Condition-based control
- Integration with multiple hardware devices

### pipeline_demo.py

This example demonstrates the Pipeline system for MCP Hardware control.

**Features:**
- Basic pipeline creation
- Pipeline with variables
- Pipeline with expectations
- Pipeline with conditional branching
- Pipeline manager functionality
- Custom pipeline examples

### simple_pipeline.py

This example shows basic pipeline creation and usage.

**Features:**
- Basic pipeline creation
- Variable substitution
- Error handling examples

**Usage:**
```bash
python automation_script.py
python pipeline_demo.py
python simple_pipeline.py
```

**Requirements:**
- Microphone and speakers
- MCP hardware package: `pip install -e .`
