# coding: utf-8

"""
    SKE-API

    The SKE API provides endpoints to create, update, delete clusters within STACKIT portal projects and to trigger further cluster management tasks.

    The version of the OpenAPI document: 1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field
from typing_extensions import Self

from stackit.ske.models.availability_zone import AvailabilityZone
from stackit.ske.models.kubernetes_version import KubernetesVersion
from stackit.ske.models.machine_image import MachineImage
from stackit.ske.models.machine_type import MachineType
from stackit.ske.models.volume_type import VolumeType


class ProviderOptions(BaseModel):
    """
    ProviderOptions
    """

    availability_zones: Optional[List[AvailabilityZone]] = Field(default=None, alias="availabilityZones")
    kubernetes_versions: Optional[List[KubernetesVersion]] = Field(default=None, alias="kubernetesVersions")
    machine_images: Optional[List[MachineImage]] = Field(default=None, alias="machineImages")
    machine_types: Optional[List[MachineType]] = Field(default=None, alias="machineTypes")
    volume_types: Optional[List[VolumeType]] = Field(default=None, alias="volumeTypes")
    __properties: ClassVar[List[str]] = [
        "availabilityZones",
        "kubernetesVersions",
        "machineImages",
        "machineTypes",
        "volumeTypes",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProviderOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in availability_zones (list)
        _items = []
        if self.availability_zones:
            for _item in self.availability_zones:
                if _item:
                    _items.append(_item.to_dict())
            _dict["availabilityZones"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in kubernetes_versions (list)
        _items = []
        if self.kubernetes_versions:
            for _item in self.kubernetes_versions:
                if _item:
                    _items.append(_item.to_dict())
            _dict["kubernetesVersions"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in machine_images (list)
        _items = []
        if self.machine_images:
            for _item in self.machine_images:
                if _item:
                    _items.append(_item.to_dict())
            _dict["machineImages"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in machine_types (list)
        _items = []
        if self.machine_types:
            for _item in self.machine_types:
                if _item:
                    _items.append(_item.to_dict())
            _dict["machineTypes"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in volume_types (list)
        _items = []
        if self.volume_types:
            for _item in self.volume_types:
                if _item:
                    _items.append(_item.to_dict())
            _dict["volumeTypes"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProviderOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "availabilityZones": (
                    [AvailabilityZone.from_dict(_item) for _item in obj["availabilityZones"]]
                    if obj.get("availabilityZones") is not None
                    else None
                ),
                "kubernetesVersions": (
                    [KubernetesVersion.from_dict(_item) for _item in obj["kubernetesVersions"]]
                    if obj.get("kubernetesVersions") is not None
                    else None
                ),
                "machineImages": (
                    [MachineImage.from_dict(_item) for _item in obj["machineImages"]]
                    if obj.get("machineImages") is not None
                    else None
                ),
                "machineTypes": (
                    [MachineType.from_dict(_item) for _item in obj["machineTypes"]]
                    if obj.get("machineTypes") is not None
                    else None
                ),
                "volumeTypes": (
                    [VolumeType.from_dict(_item) for _item in obj["volumeTypes"]]
                    if obj.get("volumeTypes") is not None
                    else None
                ),
            }
        )
        return _obj
