# coding: utf-8

"""
    SKE-API

    The SKE API provides endpoints to create, update, delete clusters within STACKIT portal projects and to trigger further cluster management tasks.

    The version of the OpenAPI document: 1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field
from typing_extensions import Self

from stackit.ske.models.maintenance_auto_update import MaintenanceAutoUpdate
from stackit.ske.models.time_window import TimeWindow


class Maintenance(BaseModel):
    """
    Maintenance
    """

    auto_update: MaintenanceAutoUpdate = Field(alias="autoUpdate")
    time_window: TimeWindow = Field(alias="timeWindow")
    __properties: ClassVar[List[str]] = ["autoUpdate", "timeWindow"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Maintenance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of auto_update
        if self.auto_update:
            _dict["autoUpdate"] = self.auto_update.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time_window
        if self.time_window:
            _dict["timeWindow"] = self.time_window.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Maintenance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "autoUpdate": (
                    MaintenanceAutoUpdate.from_dict(obj["autoUpdate"]) if obj.get("autoUpdate") is not None else None
                ),
                "timeWindow": TimeWindow.from_dict(obj["timeWindow"]) if obj.get("timeWindow") is not None else None,
            }
        )
        return _obj
