# coding: utf-8

"""
    SKE-API

    The SKE API provides endpoints to create, update, delete clusters within STACKIT portal projects and to trigger further cluster management tasks.

    The version of the OpenAPI document: 1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing_extensions import Self

from stackit.ske.models.cluster_status_state import ClusterStatusState
from stackit.ske.models.credentials_rotation_state import CredentialsRotationState
from stackit.ske.models.runtime_error import RuntimeError


class ClusterStatus(BaseModel):
    """
    ClusterStatus
    """

    aggregated: Optional[ClusterStatusState] = ClusterStatusState.STATE_UNSPECIFIED
    creation_time: Optional[StrictStr] = Field(
        default=None, description="Format: `2024-02-15T11:06:29Z`", alias="creationTime"
    )
    credentials_rotation: Optional[CredentialsRotationState] = Field(default=None, alias="credentialsRotation")
    error: Optional[RuntimeError] = None
    hibernated: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["aggregated", "creationTime", "credentialsRotation", "error", "hibernated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClusterStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of credentials_rotation
        if self.credentials_rotation:
            _dict["credentialsRotation"] = self.credentials_rotation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of error
        if self.error:
            _dict["error"] = self.error.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClusterStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "aggregated": (
                    obj.get("aggregated") if obj.get("aggregated") is not None else ClusterStatusState.STATE_UNSPECIFIED
                ),
                "creationTime": obj.get("creationTime"),
                "credentialsRotation": (
                    CredentialsRotationState.from_dict(obj["credentialsRotation"])
                    if obj.get("credentialsRotation") is not None
                    else None
                ),
                "error": RuntimeError.from_dict(obj["error"]) if obj.get("error") is not None else None,
                "hibernated": obj.get("hibernated"),
            }
        )
        return _obj
