# coding: utf-8

"""
    SKE-API

    The SKE API provides endpoints to create, update, delete clusters within STACKIT portal projects and to trigger further cluster management tasks.

    The version of the OpenAPI document: 1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing_extensions import Annotated, Self

from stackit.ske.models.cluster_status import ClusterStatus
from stackit.ske.models.extension import Extension
from stackit.ske.models.hibernation import Hibernation
from stackit.ske.models.kubernetes import Kubernetes
from stackit.ske.models.maintenance import Maintenance
from stackit.ske.models.network import Network
from stackit.ske.models.nodepool import Nodepool


class Cluster(BaseModel):
    """
    Cluster
    """

    extensions: Optional[Extension] = None
    hibernation: Optional[Hibernation] = None
    kubernetes: Kubernetes
    maintenance: Optional[Maintenance] = None
    name: Optional[StrictStr] = None
    network: Optional[Network] = None
    nodepools: Annotated[List[Nodepool], Field(min_length=1, max_length=50)]
    status: Optional[ClusterStatus] = None
    __properties: ClassVar[List[str]] = [
        "extensions",
        "hibernation",
        "kubernetes",
        "maintenance",
        "name",
        "network",
        "nodepools",
        "status",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Cluster from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "name",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of extensions
        if self.extensions:
            _dict["extensions"] = self.extensions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of hibernation
        if self.hibernation:
            _dict["hibernation"] = self.hibernation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of kubernetes
        if self.kubernetes:
            _dict["kubernetes"] = self.kubernetes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of maintenance
        if self.maintenance:
            _dict["maintenance"] = self.maintenance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network
        if self.network:
            _dict["network"] = self.network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in nodepools (list)
        _items = []
        if self.nodepools:
            for _item in self.nodepools:
                if _item:
                    _items.append(_item.to_dict())
            _dict["nodepools"] = _items
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict["status"] = self.status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Cluster from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "extensions": Extension.from_dict(obj["extensions"]) if obj.get("extensions") is not None else None,
                "hibernation": (
                    Hibernation.from_dict(obj["hibernation"]) if obj.get("hibernation") is not None else None
                ),
                "kubernetes": Kubernetes.from_dict(obj["kubernetes"]) if obj.get("kubernetes") is not None else None,
                "maintenance": (
                    Maintenance.from_dict(obj["maintenance"]) if obj.get("maintenance") is not None else None
                ),
                "name": obj.get("name"),
                "network": Network.from_dict(obj["network"]) if obj.get("network") is not None else None,
                "nodepools": (
                    [Nodepool.from_dict(_item) for _item in obj["nodepools"]]
                    if obj.get("nodepools") is not None
                    else None
                ),
                "status": ClusterStatus.from_dict(obj["status"]) if obj.get("status") is not None else None,
            }
        )
        return _obj
