# killtracker

An app for running killmail trackers with Alliance Auth and Discord

![release](https://img.shields.io/pypi/v/aa-killtracker?label=release) ![python](https://img.shields.io/pypi/pyversions/aa-killtracker) ![django](https://img.shields.io/pypi/djversions/aa-killtracker?label=django) ![pipeline](https://gitlab.com/ErikKalkoken/aa-killtracker/badges/master/pipeline.svg) ![coverage](https://gitlab.com/ErikKalkoken/aa-killtracker/badges/master/coverage.svg) ![license](https://img.shields.io/badge/license-MIT-green) ![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)

## Contents

- [Overview](#overview)
- [Key Features](#key-features)
- [Screenshots](#screenshots)
- [Installation](#installation)
- [Trackers](#trackers)
- [Settings](#settings)
- [Change Log](CHANGELOG.md)

## Overview

Killtracker is an app for running killmail based trackers with Alliance Auth and Discord. Trackers are small programs that automatically select killmails based on a set of pre-defined conditions and then post them to a Discord channel as soon as they appear on zKillboard.

The main advantage of the Killtracker app over similar apps is it's high customizability, which allows you to cut through the noise of many false positives and only get the results you are really interested in.

For example you may want to know when a larger group is roaming through your area? Set up a tracker that shows all kills within 10 jumps of your staging that has more than 20 attackers. It will even ping you if you want.

Or you maybe want to be informed about any capitals being active within your jump range? Just setup a tracker for capital kills within 6 LY of your staging.

## Key Features

- Automatically post killmails conforming with a set of conditions to a Discord channel as soon as they arrive on zKillboard
- Use 20+ conditions to define exactly what you want to track
- Optional pinging for every matching killmail
- Designed for fast response times, high throughput and low resource requirements
- Get additional insights about killmails like distance from staging

## Screenshots

Here is an example for settings up a new tracker:

![Tracker1](https://i.imgur.com/tODsBhr.png)

And here is how posted killmails look on Discord:

![Discord](https://i.imgur.com/0ZDrLyC.png)

## Installation

**Important**: This app is a plugin for Alliance Auth. If you don't have Alliance Auth running already, please install it first before proceeding. (see the official [AA installation guide](https://allianceauth.readthedocs.io/en/latest/installation/auth/allianceauth/) for details)

### Step 1 - Install app

Make sure you are in the virtual environment (venv) of your Alliance Auth installation. Then install the newest release from PyPI:

```bash
pip install aa-killtracker
```

### Step 2 - Configure AA settings

Configure your AA settings (`local.py`) as follows:

- Add `'killtracker'` to `INSTALLED_APPS`
- Add below lines to your settings file:

```python
CELERYBEAT_SCHEDULE['killtracker_run_killtracker'] = {
    'task': 'killtracker.tasks.run_killtracker',
    'schedule': crontab(minute='*/1'),
}
```

- Optional: Add additional settings if you want to change any defaults. See [Settings](#settings) for the full list.

### Step 3 - Finalize installation into AA

Run migrations & copy static files

```bash
python manage.py migrate
python manage.py collectstatic
```

Restart your supervisor services for AA

### Step 6 - Load Eve Universe map data

In order to be able to select solar systems and ships types for trackers you need to load that data from ESI once. If you already have run those commands previously you can skip this step.

Load Eve Online map:

```bash
python manage.py eveuniverse_load_data map
```

```bash
python manage.py eveuniverse_load_data ships
```

```bash
python manage.py eveuniverse_load_data structures
```

You may want to wait until the loading is complete before starting to create new trackers.

### Step 7 - Setup trackers

The setup and configuration for trackers is done on the admin page under **Killtracker**.

First need to add the Discord webhook that points to the channel you want your killmail to appear to **Webhooks**. You can use one webhook for all trackers, but it is usually better to create a new channel / webhook for each tracker.

To test that your webhook works correctly you can send a test notification.

Next you can create your trackers under **Tracker**. Make sure you link each tracker to the right webhook. Once you save a tracker that is **enabled** it will start working.

As final test that your setup is correct you may want to create a "Catch all" tracker. for that just create a new tracker without any conditions and it will forward all killmails to your Discord channel as they are received.

Congratulations you are now ready to use killtracker!

## Trackers

All trackers are setup and configured on the admin site under **Killtracker**.

Each tracker has a name, is linked to a webhook and has a set of conditions that define which killmails are selected and shown in the Discord channel. Note that if you define a tracker without any conditions tan you got a "catch all" tracker, that will post any killmail on Discord.

Each of the 20+ conditions belongs to one of two categories and they are named accordingly:

- **require**: Require conditions must be fulfilled by a killmail. e.g. a tracker with the condition **require min attackers = 10** will post only killmails on Discord that have at least 10 attackers.
- **exclude**: Exclude conditions are the opposite of require. Killmails that fulfil this condition will never be posted by this tracker. e.g. a tracker with **exclude high sec** will never show any killmails from high sec.

You can combine multiple conditions to create the tracker you want. Note that conditions are always combined together with a boolean AND. For example: if your tracker has **require min attackers** set to 10 and **exclude high sec** enabled, then you will only get killmails that both have at least 10 attackers and are not in high sec.

## Settings

Here is a list of available settings for this app. They can be configured by adding them to your AA settings file (`local.py`).

Note that all settings are optional and the app will use the documented default settings if they are not used.

Name | Description | Default
-- | -- | --
`KILLTRACKER_KILLMAIL_MAX_AGE_FOR_TRACKER`| Ignore killmails that are older than the given number in minutes. Sometimes killmails appear belated on ZKB, this feature ensures they don't create new alerts | `60`
`KILLTRACKER_MAX_KILLMAILS_PER_RUN`| Maximum number of killmails retrieved from ZKB by task run. This value should be set such that the task that fetches new killmails from ZKB every minute will reliable finish within one minute. To test this run a "Catch all" tacker and see how many killmails your system is capable of processing. Note that you can that exact information from the worker's log file. It will look something like this: `Total killmails received from ZKB in 49 secs: 251`   | `250`
`KILLTRACKER_PURGE_KILLMAILS_AFTER_DAYS`| Killmails older than set number of days will be purged from the database. If you want to keep all killmails set this to 0. Note that this setting is only relevant if you have storing killmails enabled.  | `30`
`KILLTRACKER_STORING_KILLMAILS_ENABLED`| If set to true Killtracker will automatically store all received killmails in the local database. This can be useful if you want to run analytics on killmails etc. However, please note that Killtracker itself currently does not use stored killmails in any way.  | `False`
