# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['wfslib']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['wfslib = entry:main']}

setup_kwargs = {
    'name': 'wfslib',
    'version': '0.1.15',
    'description': 'Programming module for wave front data processing',
    'long_description': '<!DOCTYPE html>\n<html>\n<head><meta charset="utf-8" />\n\n<title>use_case_readme</title>\n\n<script src="https://cdnjs.cloudflare.com/ajax/libs/require.js/2.1.10/require.min.js"></script>\n<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.0.3/jquery.min.js"></script>\n\n\n\n<style type="text/css">\n    /*!\n*\n* Twitter Bootstrap\n*\n*/\n/*!\n * Bootstrap v3.3.7 (http://getbootstrap.com)\n * Copyright 2011-2016 Twitter, Inc.\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\n */\n/*! normalize.css v3.0.3 | MIT License | github.com/necolas/normalize.css */\nhtml {\n  font-family: sans-serif;\n  -ms-text-size-adjust: 100%;\n  -webkit-text-size-adjust: 100%;\n}\nbody {\n  margin: 0;\n}\narticle,\naside,\ndetails,\nfigcaption,\nfigure,\nfooter,\nheader,\nhgroup,\nmain,\nmenu,\nnav,\nsection,\nsummary {\n  display: block;\n}\naudio,\ncanvas,\nprogress,\nvideo {\n  display: inline-block;\n  vertical-align: baseline;\n}\naudio:not([controls]) {\n  display: none;\n  height: 0;\n}\n[hidden],\ntemplate {\n  display: none;\n}\na {\n  background-color: transparent;\n}\na:active,\na:hover {\n  outline: 0;\n}\nabbr[title] {\n  border-bottom: 1px dotted;\n}\nb,\nstrong {\n  font-weight: bold;\n}\ndfn {\n  font-style: italic;\n}\nh1 {\n  font-size: 2em;\n  margin: 0.67em 0;\n}\nmark {\n  background: #ff0;\n  color: #000;\n}\nsmall {\n  font-size: 80%;\n}\nsub,\nsup {\n  font-size: 75%;\n  line-height: 0;\n  position: relative;\n  vertical-align: baseline;\n}\nsup {\n  top: -0.5em;\n}\nsub {\n  bottom: -0.25em;\n}\nimg {\n  border: 0;\n}\nsvg:not(:root) {\n  overflow: hidden;\n}\nfigure {\n  margin: 1em 40px;\n}\nhr {\n  box-sizing: content-box;\n  height: 0;\n}\npre {\n  overflow: auto;\n}\ncode,\nkbd,\npre,\nsamp {\n  font-family: monospace, monospace;\n  font-size: 1em;\n}\nbutton,\ninput,\noptgroup,\nselect,\ntextarea {\n  color: inherit;\n  font: inherit;\n  margin: 0;\n}\nbutton {\n  overflow: visible;\n}\nbutton,\nselect {\n  text-transform: none;\n}\nbutton,\nhtml input[type="button"],\ninput[type="reset"],\ninput[type="submit"] {\n  -webkit-appearance: button;\n  cursor: pointer;\n}\nbutton[disabled],\nhtml input[disabled] {\n  cursor: default;\n}\nbutton::-moz-focus-inner,\ninput::-moz-focus-inner {\n  border: 0;\n  padding: 0;\n}\ninput {\n  line-height: normal;\n}\ninput[type="checkbox"],\ninput[type="radio"] {\n  box-sizing: border-box;\n  padding: 0;\n}\ninput[type="number"]::-webkit-inner-spin-button,\ninput[type="number"]::-webkit-outer-spin-button {\n  height: auto;\n}\ninput[type="search"] {\n  -webkit-appearance: textfield;\n  box-sizing: content-box;\n}\ninput[type="search"]::-webkit-search-cancel-button,\ninput[type="search"]::-webkit-search-decoration {\n  -webkit-appearance: none;\n}\nfieldset {\n  border: 1px solid #c0c0c0;\n  margin: 0 2px;\n  padding: 0.35em 0.625em 0.75em;\n}\nlegend {\n  border: 0;\n  padding: 0;\n}\ntextarea {\n  overflow: auto;\n}\noptgroup {\n  font-weight: bold;\n}\ntable {\n  border-collapse: collapse;\n  border-spacing: 0;\n}\ntd,\nth {\n  padding: 0;\n}\n/*! Source: https://github.com/h5bp/html5-boilerplate/blob/master/src/css/main.css */\n@media print {\n  *,\n  *:before,\n  *:after {\n    background: transparent !important;\n    box-shadow: none !important;\n    text-shadow: none !important;\n  }\n  a,\n  a:visited {\n    text-decoration: underline;\n  }\n  a[href]:after {\n    content: " (" attr(href) ")";\n  }\n  abbr[title]:after {\n    content: " (" attr(title) ")";\n  }\n  a[href^="#"]:after,\n  a[href^="javascript:"]:after {\n    content: "";\n  }\n  pre,\n  blockquote {\n    border: 1px solid #999;\n    page-break-inside: avoid;\n  }\n  thead {\n    display: table-header-group;\n  }\n  tr,\n  img {\n    page-break-inside: avoid;\n  }\n  img {\n    max-width: 100% !important;\n  }\n  p,\n  h2,\n  h3 {\n    orphans: 3;\n    widows: 3;\n  }\n  h2,\n  h3 {\n    page-break-after: avoid;\n  }\n  .navbar {\n    display: none;\n  }\n  .btn > .caret,\n  .dropup > .btn > .caret {\n    border-top-color: #000 !important;\n  }\n  .label {\n    border: 1px solid #000;\n  }\n  .table {\n    border-collapse: collapse !important;\n  }\n  .table td,\n  .table th {\n    background-color: #fff !important;\n  }\n  .table-bordered th,\n  .table-bordered td {\n    border: 1px solid #ddd !important;\n  }\n}\n@font-face {\n  font-family: \'Glyphicons Halflings\';\n  src: url(\'../components/bootstrap/fonts/glyphicons-halflings-regular.eot\');\n  src: url(\'../components/bootstrap/fonts/glyphicons-halflings-regular.eot?#iefix\') format(\'embedded-opentype\'), url(\'../components/bootstrap/fonts/glyphicons-halflings-regular.woff2\') format(\'woff2\'), url(\'../components/bootstrap/fonts/glyphicons-halflings-regular.woff\') format(\'woff\'), url(\'../components/bootstrap/fonts/glyphicons-halflings-regular.ttf\') format(\'truetype\'), url(\'../components/bootstrap/fonts/glyphicons-halflings-regular.svg#glyphicons_halflingsregular\') format(\'svg\');\n}\n.glyphicon {\n  position: relative;\n  top: 1px;\n  display: inline-block;\n  font-family: \'Glyphicons Halflings\';\n  font-style: normal;\n  font-weight: normal;\n  line-height: 1;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\n.glyphicon-asterisk:before {\n  content: "\\002a";\n}\n.glyphicon-plus:before {\n  content: "\\002b";\n}\n.glyphicon-euro:before,\n.glyphicon-eur:before {\n  content: "\\20ac";\n}\n.glyphicon-minus:before {\n  content: "\\2212";\n}\n.glyphicon-cloud:before {\n  content: "\\2601";\n}\n.glyphicon-envelope:before {\n  content: "\\2709";\n}\n.glyphicon-pencil:before {\n  content: "\\270f";\n}\n.glyphicon-glass:before {\n  content: "\\e001";\n}\n.glyphicon-music:before {\n  content: "\\e002";\n}\n.glyphicon-search:before {\n  content: "\\e003";\n}\n.glyphicon-heart:before {\n  content: "\\e005";\n}\n.glyphicon-star:before {\n  content: "\\e006";\n}\n.glyphicon-star-empty:before {\n  content: "\\e007";\n}\n.glyphicon-user:before {\n  content: "\\e008";\n}\n.glyphicon-film:before {\n  content: "\\e009";\n}\n.glyphicon-th-large:before {\n  content: "\\e010";\n}\n.glyphicon-th:before {\n  content: "\\e011";\n}\n.glyphicon-th-list:before {\n  content: "\\e012";\n}\n.glyphicon-ok:before {\n  content: "\\e013";\n}\n.glyphicon-remove:before {\n  content: "\\e014";\n}\n.glyphicon-zoom-in:before {\n  content: "\\e015";\n}\n.glyphicon-zoom-out:before {\n  content: "\\e016";\n}\n.glyphicon-off:before {\n  content: "\\e017";\n}\n.glyphicon-signal:before {\n  content: "\\e018";\n}\n.glyphicon-cog:before {\n  content: "\\e019";\n}\n.glyphicon-trash:before {\n  content: "\\e020";\n}\n.glyphicon-home:before {\n  content: "\\e021";\n}\n.glyphicon-file:before {\n  content: "\\e022";\n}\n.glyphicon-time:before {\n  content: "\\e023";\n}\n.glyphicon-road:before {\n  content: "\\e024";\n}\n.glyphicon-download-alt:before {\n  content: "\\e025";\n}\n.glyphicon-download:before {\n  content: "\\e026";\n}\n.glyphicon-upload:before {\n  content: "\\e027";\n}\n.glyphicon-inbox:before {\n  content: "\\e028";\n}\n.glyphicon-play-circle:before {\n  content: "\\e029";\n}\n.glyphicon-repeat:before {\n  content: "\\e030";\n}\n.glyphicon-refresh:before {\n  content: "\\e031";\n}\n.glyphicon-list-alt:before {\n  content: "\\e032";\n}\n.glyphicon-lock:before {\n  content: "\\e033";\n}\n.glyphicon-flag:before {\n  content: "\\e034";\n}\n.glyphicon-headphones:before {\n  content: "\\e035";\n}\n.glyphicon-volume-off:before {\n  content: "\\e036";\n}\n.glyphicon-volume-down:before {\n  content: "\\e037";\n}\n.glyphicon-volume-up:before {\n  content: "\\e038";\n}\n.glyphicon-qrcode:before {\n  content: "\\e039";\n}\n.glyphicon-barcode:before {\n  content: "\\e040";\n}\n.glyphicon-tag:before {\n  content: "\\e041";\n}\n.glyphicon-tags:before {\n  content: "\\e042";\n}\n.glyphicon-book:before {\n  content: "\\e043";\n}\n.glyphicon-bookmark:before {\n  content: "\\e044";\n}\n.glyphicon-print:before {\n  content: "\\e045";\n}\n.glyphicon-camera:before {\n  content: "\\e046";\n}\n.glyphicon-font:before {\n  content: "\\e047";\n}\n.glyphicon-bold:before {\n  content: "\\e048";\n}\n.glyphicon-italic:before {\n  content: "\\e049";\n}\n.glyphicon-text-height:before {\n  content: "\\e050";\n}\n.glyphicon-text-width:before {\n  content: "\\e051";\n}\n.glyphicon-align-left:before {\n  content: "\\e052";\n}\n.glyphicon-align-center:before {\n  content: "\\e053";\n}\n.glyphicon-align-right:before {\n  content: "\\e054";\n}\n.glyphicon-align-justify:before {\n  content: "\\e055";\n}\n.glyphicon-list:before {\n  content: "\\e056";\n}\n.glyphicon-indent-left:before {\n  content: "\\e057";\n}\n.glyphicon-indent-right:before {\n  content: "\\e058";\n}\n.glyphicon-facetime-video:before {\n  content: "\\e059";\n}\n.glyphicon-picture:before {\n  content: "\\e060";\n}\n.glyphicon-map-marker:before {\n  content: "\\e062";\n}\n.glyphicon-adjust:before {\n  content: "\\e063";\n}\n.glyphicon-tint:before {\n  content: "\\e064";\n}\n.glyphicon-edit:before {\n  content: "\\e065";\n}\n.glyphicon-share:before {\n  content: "\\e066";\n}\n.glyphicon-check:before {\n  content: "\\e067";\n}\n.glyphicon-move:before {\n  content: "\\e068";\n}\n.glyphicon-step-backward:before {\n  content: "\\e069";\n}\n.glyphicon-fast-backward:before {\n  content: "\\e070";\n}\n.glyphicon-backward:before {\n  content: "\\e071";\n}\n.glyphicon-play:before {\n  content: "\\e072";\n}\n.glyphicon-pause:before {\n  content: "\\e073";\n}\n.glyphicon-stop:before {\n  content: "\\e074";\n}\n.glyphicon-forward:before {\n  content: "\\e075";\n}\n.glyphicon-fast-forward:before {\n  content: "\\e076";\n}\n.glyphicon-step-forward:before {\n  content: "\\e077";\n}\n.glyphicon-eject:before {\n  content: "\\e078";\n}\n.glyphicon-chevron-left:before {\n  content: "\\e079";\n}\n.glyphicon-chevron-right:before {\n  content: "\\e080";\n}\n.glyphicon-plus-sign:before {\n  content: "\\e081";\n}\n.glyphicon-minus-sign:before {\n  content: "\\e082";\n}\n.glyphicon-remove-sign:before {\n  content: "\\e083";\n}\n.glyphicon-ok-sign:before {\n  content: "\\e084";\n}\n.glyphicon-question-sign:before {\n  content: "\\e085";\n}\n.glyphicon-info-sign:before {\n  content: "\\e086";\n}\n.glyphicon-screenshot:before {\n  content: "\\e087";\n}\n.glyphicon-remove-circle:before {\n  content: "\\e088";\n}\n.glyphicon-ok-circle:before {\n  content: "\\e089";\n}\n.glyphicon-ban-circle:before {\n  content: "\\e090";\n}\n.glyphicon-arrow-left:before {\n  content: "\\e091";\n}\n.glyphicon-arrow-right:before {\n  content: "\\e092";\n}\n.glyphicon-arrow-up:before {\n  content: "\\e093";\n}\n.glyphicon-arrow-down:before {\n  content: "\\e094";\n}\n.glyphicon-share-alt:before {\n  content: "\\e095";\n}\n.glyphicon-resize-full:before {\n  content: "\\e096";\n}\n.glyphicon-resize-small:before {\n  content: "\\e097";\n}\n.glyphicon-exclamation-sign:before {\n  content: "\\e101";\n}\n.glyphicon-gift:before {\n  content: "\\e102";\n}\n.glyphicon-leaf:before {\n  content: "\\e103";\n}\n.glyphicon-fire:before {\n  content: "\\e104";\n}\n.glyphicon-eye-open:before {\n  content: "\\e105";\n}\n.glyphicon-eye-close:before {\n  content: "\\e106";\n}\n.glyphicon-warning-sign:before {\n  content: "\\e107";\n}\n.glyphicon-plane:before {\n  content: "\\e108";\n}\n.glyphicon-calendar:before {\n  content: "\\e109";\n}\n.glyphicon-random:before {\n  content: "\\e110";\n}\n.glyphicon-comment:before {\n  content: "\\e111";\n}\n.glyphicon-magnet:before {\n  content: "\\e112";\n}\n.glyphicon-chevron-up:before {\n  content: "\\e113";\n}\n.glyphicon-chevron-down:before {\n  content: "\\e114";\n}\n.glyphicon-retweet:before {\n  content: "\\e115";\n}\n.glyphicon-shopping-cart:before {\n  content: "\\e116";\n}\n.glyphicon-folder-close:before {\n  content: "\\e117";\n}\n.glyphicon-folder-open:before {\n  content: "\\e118";\n}\n.glyphicon-resize-vertical:before {\n  content: "\\e119";\n}\n.glyphicon-resize-horizontal:before {\n  content: "\\e120";\n}\n.glyphicon-hdd:before {\n  content: "\\e121";\n}\n.glyphicon-bullhorn:before {\n  content: "\\e122";\n}\n.glyphicon-bell:before {\n  content: "\\e123";\n}\n.glyphicon-certificate:before {\n  content: "\\e124";\n}\n.glyphicon-thumbs-up:before {\n  content: "\\e125";\n}\n.glyphicon-thumbs-down:before {\n  content: "\\e126";\n}\n.glyphicon-hand-right:before {\n  content: "\\e127";\n}\n.glyphicon-hand-left:before {\n  content: "\\e128";\n}\n.glyphicon-hand-up:before {\n  content: "\\e129";\n}\n.glyphicon-hand-down:before {\n  content: "\\e130";\n}\n.glyphicon-circle-arrow-right:before {\n  content: "\\e131";\n}\n.glyphicon-circle-arrow-left:before {\n  content: "\\e132";\n}\n.glyphicon-circle-arrow-up:before {\n  content: "\\e133";\n}\n.glyphicon-circle-arrow-down:before {\n  content: "\\e134";\n}\n.glyphicon-globe:before {\n  content: "\\e135";\n}\n.glyphicon-wrench:before {\n  content: "\\e136";\n}\n.glyphicon-tasks:before {\n  content: "\\e137";\n}\n.glyphicon-filter:before {\n  content: "\\e138";\n}\n.glyphicon-briefcase:before {\n  content: "\\e139";\n}\n.glyphicon-fullscreen:before {\n  content: "\\e140";\n}\n.glyphicon-dashboard:before {\n  content: "\\e141";\n}\n.glyphicon-paperclip:before {\n  content: "\\e142";\n}\n.glyphicon-heart-empty:before {\n  content: "\\e143";\n}\n.glyphicon-link:before {\n  content: "\\e144";\n}\n.glyphicon-phone:before {\n  content: "\\e145";\n}\n.glyphicon-pushpin:before {\n  content: "\\e146";\n}\n.glyphicon-usd:before {\n  content: "\\e148";\n}\n.glyphicon-gbp:before {\n  content: "\\e149";\n}\n.glyphicon-sort:before {\n  content: "\\e150";\n}\n.glyphicon-sort-by-alphabet:before {\n  content: "\\e151";\n}\n.glyphicon-sort-by-alphabet-alt:before {\n  content: "\\e152";\n}\n.glyphicon-sort-by-order:before {\n  content: "\\e153";\n}\n.glyphicon-sort-by-order-alt:before {\n  content: "\\e154";\n}\n.glyphicon-sort-by-attributes:before {\n  content: "\\e155";\n}\n.glyphicon-sort-by-attributes-alt:before {\n  content: "\\e156";\n}\n.glyphicon-unchecked:before {\n  content: "\\e157";\n}\n.glyphicon-expand:before {\n  content: "\\e158";\n}\n.glyphicon-collapse-down:before {\n  content: "\\e159";\n}\n.glyphicon-collapse-up:before {\n  content: "\\e160";\n}\n.glyphicon-log-in:before {\n  content: "\\e161";\n}\n.glyphicon-flash:before {\n  content: "\\e162";\n}\n.glyphicon-log-out:before {\n  content: "\\e163";\n}\n.glyphicon-new-window:before {\n  content: "\\e164";\n}\n.glyphicon-record:before {\n  content: "\\e165";\n}\n.glyphicon-save:before {\n  content: "\\e166";\n}\n.glyphicon-open:before {\n  content: "\\e167";\n}\n.glyphicon-saved:before {\n  content: "\\e168";\n}\n.glyphicon-import:before {\n  content: "\\e169";\n}\n.glyphicon-export:before {\n  content: "\\e170";\n}\n.glyphicon-send:before {\n  content: "\\e171";\n}\n.glyphicon-floppy-disk:before {\n  content: "\\e172";\n}\n.glyphicon-floppy-saved:before {\n  content: "\\e173";\n}\n.glyphicon-floppy-remove:before {\n  content: "\\e174";\n}\n.glyphicon-floppy-save:before {\n  content: "\\e175";\n}\n.glyphicon-floppy-open:before {\n  content: "\\e176";\n}\n.glyphicon-credit-card:before {\n  content: "\\e177";\n}\n.glyphicon-transfer:before {\n  content: "\\e178";\n}\n.glyphicon-cutlery:before {\n  content: "\\e179";\n}\n.glyphicon-header:before {\n  content: "\\e180";\n}\n.glyphicon-compressed:before {\n  content: "\\e181";\n}\n.glyphicon-earphone:before {\n  content: "\\e182";\n}\n.glyphicon-phone-alt:before {\n  content: "\\e183";\n}\n.glyphicon-tower:before {\n  content: "\\e184";\n}\n.glyphicon-stats:before {\n  content: "\\e185";\n}\n.glyphicon-sd-video:before {\n  content: "\\e186";\n}\n.glyphicon-hd-video:before {\n  content: "\\e187";\n}\n.glyphicon-subtitles:before {\n  content: "\\e188";\n}\n.glyphicon-sound-stereo:before {\n  content: "\\e189";\n}\n.glyphicon-sound-dolby:before {\n  content: "\\e190";\n}\n.glyphicon-sound-5-1:before {\n  content: "\\e191";\n}\n.glyphicon-sound-6-1:before {\n  content: "\\e192";\n}\n.glyphicon-sound-7-1:before {\n  content: "\\e193";\n}\n.glyphicon-copyright-mark:before {\n  content: "\\e194";\n}\n.glyphicon-registration-mark:before {\n  content: "\\e195";\n}\n.glyphicon-cloud-download:before {\n  content: "\\e197";\n}\n.glyphicon-cloud-upload:before {\n  content: "\\e198";\n}\n.glyphicon-tree-conifer:before {\n  content: "\\e199";\n}\n.glyphicon-tree-deciduous:before {\n  content: "\\e200";\n}\n.glyphicon-cd:before {\n  content: "\\e201";\n}\n.glyphicon-save-file:before {\n  content: "\\e202";\n}\n.glyphicon-open-file:before {\n  content: "\\e203";\n}\n.glyphicon-level-up:before {\n  content: "\\e204";\n}\n.glyphicon-copy:before {\n  content: "\\e205";\n}\n.glyphicon-paste:before {\n  content: "\\e206";\n}\n.glyphicon-alert:before {\n  content: "\\e209";\n}\n.glyphicon-equalizer:before {\n  content: "\\e210";\n}\n.glyphicon-king:before {\n  content: "\\e211";\n}\n.glyphicon-queen:before {\n  content: "\\e212";\n}\n.glyphicon-pawn:before {\n  content: "\\e213";\n}\n.glyphicon-bishop:before {\n  content: "\\e214";\n}\n.glyphicon-knight:before {\n  content: "\\e215";\n}\n.glyphicon-baby-formula:before {\n  content: "\\e216";\n}\n.glyphicon-tent:before {\n  content: "\\26fa";\n}\n.glyphicon-blackboard:before {\n  content: "\\e218";\n}\n.glyphicon-bed:before {\n  content: "\\e219";\n}\n.glyphicon-apple:before {\n  content: "\\f8ff";\n}\n.glyphicon-erase:before {\n  content: "\\e221";\n}\n.glyphicon-hourglass:before {\n  content: "\\231b";\n}\n.glyphicon-lamp:before {\n  content: "\\e223";\n}\n.glyphicon-duplicate:before {\n  content: "\\e224";\n}\n.glyphicon-piggy-bank:before {\n  content: "\\e225";\n}\n.glyphicon-scissors:before {\n  content: "\\e226";\n}\n.glyphicon-bitcoin:before {\n  content: "\\e227";\n}\n.glyphicon-btc:before {\n  content: "\\e227";\n}\n.glyphicon-xbt:before {\n  content: "\\e227";\n}\n.glyphicon-yen:before {\n  content: "\\00a5";\n}\n.glyphicon-jpy:before {\n  content: "\\00a5";\n}\n.glyphicon-ruble:before {\n  content: "\\20bd";\n}\n.glyphicon-rub:before {\n  content: "\\20bd";\n}\n.glyphicon-scale:before {\n  content: "\\e230";\n}\n.glyphicon-ice-lolly:before {\n  content: "\\e231";\n}\n.glyphicon-ice-lolly-tasted:before {\n  content: "\\e232";\n}\n.glyphicon-education:before {\n  content: "\\e233";\n}\n.glyphicon-option-horizontal:before {\n  content: "\\e234";\n}\n.glyphicon-option-vertical:before {\n  content: "\\e235";\n}\n.glyphicon-menu-hamburger:before {\n  content: "\\e236";\n}\n.glyphicon-modal-window:before {\n  content: "\\e237";\n}\n.glyphicon-oil:before {\n  content: "\\e238";\n}\n.glyphicon-grain:before {\n  content: "\\e239";\n}\n.glyphicon-sunglasses:before {\n  content: "\\e240";\n}\n.glyphicon-text-size:before {\n  content: "\\e241";\n}\n.glyphicon-text-color:before {\n  content: "\\e242";\n}\n.glyphicon-text-background:before {\n  content: "\\e243";\n}\n.glyphicon-object-align-top:before {\n  content: "\\e244";\n}\n.glyphicon-object-align-bottom:before {\n  content: "\\e245";\n}\n.glyphicon-object-align-horizontal:before {\n  content: "\\e246";\n}\n.glyphicon-object-align-left:before {\n  content: "\\e247";\n}\n.glyphicon-object-align-vertical:before {\n  content: "\\e248";\n}\n.glyphicon-object-align-right:before {\n  content: "\\e249";\n}\n.glyphicon-triangle-right:before {\n  content: "\\e250";\n}\n.glyphicon-triangle-left:before {\n  content: "\\e251";\n}\n.glyphicon-triangle-bottom:before {\n  content: "\\e252";\n}\n.glyphicon-triangle-top:before {\n  content: "\\e253";\n}\n.glyphicon-console:before {\n  content: "\\e254";\n}\n.glyphicon-superscript:before {\n  content: "\\e255";\n}\n.glyphicon-subscript:before {\n  content: "\\e256";\n}\n.glyphicon-menu-left:before {\n  content: "\\e257";\n}\n.glyphicon-menu-right:before {\n  content: "\\e258";\n}\n.glyphicon-menu-down:before {\n  content: "\\e259";\n}\n.glyphicon-menu-up:before {\n  content: "\\e260";\n}\n* {\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  box-sizing: border-box;\n}\n*:before,\n*:after {\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  box-sizing: border-box;\n}\nhtml {\n  font-size: 10px;\n  -webkit-tap-highlight-color: rgba(0, 0, 0, 0);\n}\nbody {\n  font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;\n  font-size: 13px;\n  line-height: 1.42857143;\n  color: #000;\n  background-color: #fff;\n}\ninput,\nbutton,\nselect,\ntextarea {\n  font-family: inherit;\n  font-size: inherit;\n  line-height: inherit;\n}\na {\n  color: #337ab7;\n  text-decoration: none;\n}\na:hover,\na:focus {\n  color: #23527c;\n  text-decoration: underline;\n}\na:focus {\n  outline: 5px auto -webkit-focus-ring-color;\n  outline-offset: -2px;\n}\nfigure {\n  margin: 0;\n}\nimg {\n  vertical-align: middle;\n}\n.img-responsive,\n.thumbnail > img,\n.thumbnail a > img,\n.carousel-inner > .item > img,\n.carousel-inner > .item > a > img {\n  display: block;\n  max-width: 100%;\n  height: auto;\n}\n.img-rounded {\n  border-radius: 3px;\n}\n.img-thumbnail {\n  padding: 4px;\n  line-height: 1.42857143;\n  background-color: #fff;\n  border: 1px solid #ddd;\n  border-radius: 2px;\n  -webkit-transition: all 0.2s ease-in-out;\n  -o-transition: all 0.2s ease-in-out;\n  transition: all 0.2s ease-in-out;\n  display: inline-block;\n  max-width: 100%;\n  height: auto;\n}\n.img-circle {\n  border-radius: 50%;\n}\nhr {\n  margin-top: 18px;\n  margin-bottom: 18px;\n  border: 0;\n  border-top: 1px solid #eeeeee;\n}\n.sr-only {\n  position: absolute;\n  width: 1px;\n  height: 1px;\n  margin: -1px;\n  padding: 0;\n  overflow: hidden;\n  clip: rect(0, 0, 0, 0);\n  border: 0;\n}\n.sr-only-focusable:active,\n.sr-only-focusable:focus {\n  position: static;\n  width: auto;\n  height: auto;\n  margin: 0;\n  overflow: visible;\n  clip: auto;\n}\n[role="button"] {\n  cursor: pointer;\n}\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\n.h1,\n.h2,\n.h3,\n.h4,\n.h5,\n.h6 {\n  font-family: inherit;\n  font-weight: 500;\n  line-height: 1.1;\n  color: inherit;\n}\nh1 small,\nh2 small,\nh3 small,\nh4 small,\nh5 small,\nh6 small,\n.h1 small,\n.h2 small,\n.h3 small,\n.h4 small,\n.h5 small,\n.h6 small,\nh1 .small,\nh2 .small,\nh3 .small,\nh4 .small,\nh5 .small,\nh6 .small,\n.h1 .small,\n.h2 .small,\n.h3 .small,\n.h4 .small,\n.h5 .small,\n.h6 .small {\n  font-weight: normal;\n  line-height: 1;\n  color: #777777;\n}\nh1,\n.h1,\nh2,\n.h2,\nh3,\n.h3 {\n  margin-top: 18px;\n  margin-bottom: 9px;\n}\nh1 small,\n.h1 small,\nh2 small,\n.h2 small,\nh3 small,\n.h3 small,\nh1 .small,\n.h1 .small,\nh2 .small,\n.h2 .small,\nh3 .small,\n.h3 .small {\n  font-size: 65%;\n}\nh4,\n.h4,\nh5,\n.h5,\nh6,\n.h6 {\n  margin-top: 9px;\n  margin-bottom: 9px;\n}\nh4 small,\n.h4 small,\nh5 small,\n.h5 small,\nh6 small,\n.h6 small,\nh4 .small,\n.h4 .small,\nh5 .small,\n.h5 .small,\nh6 .small,\n.h6 .small {\n  font-size: 75%;\n}\nh1,\n.h1 {\n  font-size: 33px;\n}\nh2,\n.h2 {\n  font-size: 27px;\n}\nh3,\n.h3 {\n  font-size: 23px;\n}\nh4,\n.h4 {\n  font-size: 17px;\n}\nh5,\n.h5 {\n  font-size: 13px;\n}\nh6,\n.h6 {\n  font-size: 12px;\n}\np {\n  margin: 0 0 9px;\n}\n.lead {\n  margin-bottom: 18px;\n  font-size: 14px;\n  font-weight: 300;\n  line-height: 1.4;\n}\n@media (min-width: 768px) {\n  .lead {\n    font-size: 19.5px;\n  }\n}\nsmall,\n.small {\n  font-size: 92%;\n}\nmark,\n.mark {\n  background-color: #fcf8e3;\n  padding: .2em;\n}\n.text-left {\n  text-align: left;\n}\n.text-right {\n  text-align: right;\n}\n.text-center {\n  text-align: center;\n}\n.text-justify {\n  text-align: justify;\n}\n.text-nowrap {\n  white-space: nowrap;\n}\n.text-lowercase {\n  text-transform: lowercase;\n}\n.text-uppercase {\n  text-transform: uppercase;\n}\n.text-capitalize {\n  text-transform: capitalize;\n}\n.text-muted {\n  color: #777777;\n}\n.text-primary {\n  color: #337ab7;\n}\na.text-primary:hover,\na.text-primary:focus {\n  color: #286090;\n}\n.text-success {\n  color: #3c763d;\n}\na.text-success:hover,\na.text-success:focus {\n  color: #2b542c;\n}\n.text-info {\n  color: #31708f;\n}\na.text-info:hover,\na.text-info:focus {\n  color: #245269;\n}\n.text-warning {\n  color: #8a6d3b;\n}\na.text-warning:hover,\na.text-warning:focus {\n  color: #66512c;\n}\n.text-danger {\n  color: #a94442;\n}\na.text-danger:hover,\na.text-danger:focus {\n  color: #843534;\n}\n.bg-primary {\n  color: #fff;\n  background-color: #337ab7;\n}\na.bg-primary:hover,\na.bg-primary:focus {\n  background-color: #286090;\n}\n.bg-success {\n  background-color: #dff0d8;\n}\na.bg-success:hover,\na.bg-success:focus {\n  background-color: #c1e2b3;\n}\n.bg-info {\n  background-color: #d9edf7;\n}\na.bg-info:hover,\na.bg-info:focus {\n  background-color: #afd9ee;\n}\n.bg-warning {\n  background-color: #fcf8e3;\n}\na.bg-warning:hover,\na.bg-warning:focus {\n  background-color: #f7ecb5;\n}\n.bg-danger {\n  background-color: #f2dede;\n}\na.bg-danger:hover,\na.bg-danger:focus {\n  background-color: #e4b9b9;\n}\n.page-header {\n  padding-bottom: 8px;\n  margin: 36px 0 18px;\n  border-bottom: 1px solid #eeeeee;\n}\nul,\nol {\n  margin-top: 0;\n  margin-bottom: 9px;\n}\nul ul,\nol ul,\nul ol,\nol ol {\n  margin-bottom: 0;\n}\n.list-unstyled {\n  padding-left: 0;\n  list-style: none;\n}\n.list-inline {\n  padding-left: 0;\n  list-style: none;\n  margin-left: -5px;\n}\n.list-inline > li {\n  display: inline-block;\n  padding-left: 5px;\n  padding-right: 5px;\n}\ndl {\n  margin-top: 0;\n  margin-bottom: 18px;\n}\ndt,\ndd {\n  line-height: 1.42857143;\n}\ndt {\n  font-weight: bold;\n}\ndd {\n  margin-left: 0;\n}\n@media (min-width: 541px) {\n  .dl-horizontal dt {\n    float: left;\n    width: 160px;\n    clear: left;\n    text-align: right;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n  }\n  .dl-horizontal dd {\n    margin-left: 180px;\n  }\n}\nabbr[title],\nabbr[data-original-title] {\n  cursor: help;\n  border-bottom: 1px dotted #777777;\n}\n.initialism {\n  font-size: 90%;\n  text-transform: uppercase;\n}\nblockquote {\n  padding: 9px 18px;\n  margin: 0 0 18px;\n  font-size: inherit;\n  border-left: 5px solid #eeeeee;\n}\nblockquote p:last-child,\nblockquote ul:last-child,\nblockquote ol:last-child {\n  margin-bottom: 0;\n}\nblockquote footer,\nblockquote small,\nblockquote .small {\n  display: block;\n  font-size: 80%;\n  line-height: 1.42857143;\n  color: #777777;\n}\nblockquote footer:before,\nblockquote small:before,\nblockquote .small:before {\n  content: \'\\2014 \\00A0\';\n}\n.blockquote-reverse,\nblockquote.pull-right {\n  padding-right: 15px;\n  padding-left: 0;\n  border-right: 5px solid #eeeeee;\n  border-left: 0;\n  text-align: right;\n}\n.blockquote-reverse footer:before,\nblockquote.pull-right footer:before,\n.blockquote-reverse small:before,\nblockquote.pull-right small:before,\n.blockquote-reverse .small:before,\nblockquote.pull-right .small:before {\n  content: \'\';\n}\n.blockquote-reverse footer:after,\nblockquote.pull-right footer:after,\n.blockquote-reverse small:after,\nblockquote.pull-right small:after,\n.blockquote-reverse .small:after,\nblockquote.pull-right .small:after {\n  content: \'\\00A0 \\2014\';\n}\naddress {\n  margin-bottom: 18px;\n  font-style: normal;\n  line-height: 1.42857143;\n}\ncode,\nkbd,\npre,\nsamp {\n  font-family: monospace;\n}\ncode {\n  padding: 2px 4px;\n  font-size: 90%;\n  color: #c7254e;\n  background-color: #f9f2f4;\n  border-radius: 2px;\n}\nkbd {\n  padding: 2px 4px;\n  font-size: 90%;\n  color: #888;\n  background-color: transparent;\n  border-radius: 1px;\n  box-shadow: inset 0 -1px 0 rgba(0, 0, 0, 0.25);\n}\nkbd kbd {\n  padding: 0;\n  font-size: 100%;\n  font-weight: bold;\n  box-shadow: none;\n}\npre {\n  display: block;\n  padding: 8.5px;\n  margin: 0 0 9px;\n  font-size: 12px;\n  line-height: 1.42857143;\n  word-break: break-all;\n  word-wrap: break-word;\n  color: #333333;\n  background-color: #f5f5f5;\n  border: 1px solid #ccc;\n  border-radius: 2px;\n}\npre code {\n  padding: 0;\n  font-size: inherit;\n  color: inherit;\n  white-space: pre-wrap;\n  background-color: transparent;\n  border-radius: 0;\n}\n.pre-scrollable {\n  max-height: 340px;\n  overflow-y: scroll;\n}\n.container {\n  margin-right: auto;\n  margin-left: auto;\n  padding-left: 0px;\n  padding-right: 0px;\n}\n@media (min-width: 768px) {\n  .container {\n    width: 768px;\n  }\n}\n@media (min-width: 992px) {\n  .container {\n    width: 940px;\n  }\n}\n@media (min-width: 1200px) {\n  .container {\n    width: 1140px;\n  }\n}\n.container-fluid {\n  margin-right: auto;\n  margin-left: auto;\n  padding-left: 0px;\n  padding-right: 0px;\n}\n.row {\n  margin-left: 0px;\n  margin-right: 0px;\n}\n.col-xs-1, .col-sm-1, .col-md-1, .col-lg-1, .col-xs-2, .col-sm-2, .col-md-2, .col-lg-2, .col-xs-3, .col-sm-3, .col-md-3, .col-lg-3, .col-xs-4, .col-sm-4, .col-md-4, .col-lg-4, .col-xs-5, .col-sm-5, .col-md-5, .col-lg-5, .col-xs-6, .col-sm-6, .col-md-6, .col-lg-6, .col-xs-7, .col-sm-7, .col-md-7, .col-lg-7, .col-xs-8, .col-sm-8, .col-md-8, .col-lg-8, .col-xs-9, .col-sm-9, .col-md-9, .col-lg-9, .col-xs-10, .col-sm-10, .col-md-10, .col-lg-10, .col-xs-11, .col-sm-11, .col-md-11, .col-lg-11, .col-xs-12, .col-sm-12, .col-md-12, .col-lg-12 {\n  position: relative;\n  min-height: 1px;\n  padding-left: 0px;\n  padding-right: 0px;\n}\n.col-xs-1, .col-xs-2, .col-xs-3, .col-xs-4, .col-xs-5, .col-xs-6, .col-xs-7, .col-xs-8, .col-xs-9, .col-xs-10, .col-xs-11, .col-xs-12 {\n  float: left;\n}\n.col-xs-12 {\n  width: 100%;\n}\n.col-xs-11 {\n  width: 91.66666667%;\n}\n.col-xs-10 {\n  width: 83.33333333%;\n}\n.col-xs-9 {\n  width: 75%;\n}\n.col-xs-8 {\n  width: 66.66666667%;\n}\n.col-xs-7 {\n  width: 58.33333333%;\n}\n.col-xs-6 {\n  width: 50%;\n}\n.col-xs-5 {\n  width: 41.66666667%;\n}\n.col-xs-4 {\n  width: 33.33333333%;\n}\n.col-xs-3 {\n  width: 25%;\n}\n.col-xs-2 {\n  width: 16.66666667%;\n}\n.col-xs-1 {\n  width: 8.33333333%;\n}\n.col-xs-pull-12 {\n  right: 100%;\n}\n.col-xs-pull-11 {\n  right: 91.66666667%;\n}\n.col-xs-pull-10 {\n  right: 83.33333333%;\n}\n.col-xs-pull-9 {\n  right: 75%;\n}\n.col-xs-pull-8 {\n  right: 66.66666667%;\n}\n.col-xs-pull-7 {\n  right: 58.33333333%;\n}\n.col-xs-pull-6 {\n  right: 50%;\n}\n.col-xs-pull-5 {\n  right: 41.66666667%;\n}\n.col-xs-pull-4 {\n  right: 33.33333333%;\n}\n.col-xs-pull-3 {\n  right: 25%;\n}\n.col-xs-pull-2 {\n  right: 16.66666667%;\n}\n.col-xs-pull-1 {\n  right: 8.33333333%;\n}\n.col-xs-pull-0 {\n  right: auto;\n}\n.col-xs-push-12 {\n  left: 100%;\n}\n.col-xs-push-11 {\n  left: 91.66666667%;\n}\n.col-xs-push-10 {\n  left: 83.33333333%;\n}\n.col-xs-push-9 {\n  left: 75%;\n}\n.col-xs-push-8 {\n  left: 66.66666667%;\n}\n.col-xs-push-7 {\n  left: 58.33333333%;\n}\n.col-xs-push-6 {\n  left: 50%;\n}\n.col-xs-push-5 {\n  left: 41.66666667%;\n}\n.col-xs-push-4 {\n  left: 33.33333333%;\n}\n.col-xs-push-3 {\n  left: 25%;\n}\n.col-xs-push-2 {\n  left: 16.66666667%;\n}\n.col-xs-push-1 {\n  left: 8.33333333%;\n}\n.col-xs-push-0 {\n  left: auto;\n}\n.col-xs-offset-12 {\n  margin-left: 100%;\n}\n.col-xs-offset-11 {\n  margin-left: 91.66666667%;\n}\n.col-xs-offset-10 {\n  margin-left: 83.33333333%;\n}\n.col-xs-offset-9 {\n  margin-left: 75%;\n}\n.col-xs-offset-8 {\n  margin-left: 66.66666667%;\n}\n.col-xs-offset-7 {\n  margin-left: 58.33333333%;\n}\n.col-xs-offset-6 {\n  margin-left: 50%;\n}\n.col-xs-offset-5 {\n  margin-left: 41.66666667%;\n}\n.col-xs-offset-4 {\n  margin-left: 33.33333333%;\n}\n.col-xs-offset-3 {\n  margin-left: 25%;\n}\n.col-xs-offset-2 {\n  margin-left: 16.66666667%;\n}\n.col-xs-offset-1 {\n  margin-left: 8.33333333%;\n}\n.col-xs-offset-0 {\n  margin-left: 0%;\n}\n@media (min-width: 768px) {\n  .col-sm-1, .col-sm-2, .col-sm-3, .col-sm-4, .col-sm-5, .col-sm-6, .col-sm-7, .col-sm-8, .col-sm-9, .col-sm-10, .col-sm-11, .col-sm-12 {\n    float: left;\n  }\n  .col-sm-12 {\n    width: 100%;\n  }\n  .col-sm-11 {\n    width: 91.66666667%;\n  }\n  .col-sm-10 {\n    width: 83.33333333%;\n  }\n  .col-sm-9 {\n    width: 75%;\n  }\n  .col-sm-8 {\n    width: 66.66666667%;\n  }\n  .col-sm-7 {\n    width: 58.33333333%;\n  }\n  .col-sm-6 {\n    width: 50%;\n  }\n  .col-sm-5 {\n    width: 41.66666667%;\n  }\n  .col-sm-4 {\n    width: 33.33333333%;\n  }\n  .col-sm-3 {\n    width: 25%;\n  }\n  .col-sm-2 {\n    width: 16.66666667%;\n  }\n  .col-sm-1 {\n    width: 8.33333333%;\n  }\n  .col-sm-pull-12 {\n    right: 100%;\n  }\n  .col-sm-pull-11 {\n    right: 91.66666667%;\n  }\n  .col-sm-pull-10 {\n    right: 83.33333333%;\n  }\n  .col-sm-pull-9 {\n    right: 75%;\n  }\n  .col-sm-pull-8 {\n    right: 66.66666667%;\n  }\n  .col-sm-pull-7 {\n    right: 58.33333333%;\n  }\n  .col-sm-pull-6 {\n    right: 50%;\n  }\n  .col-sm-pull-5 {\n    right: 41.66666667%;\n  }\n  .col-sm-pull-4 {\n    right: 33.33333333%;\n  }\n  .col-sm-pull-3 {\n    right: 25%;\n  }\n  .col-sm-pull-2 {\n    right: 16.66666667%;\n  }\n  .col-sm-pull-1 {\n    right: 8.33333333%;\n  }\n  .col-sm-pull-0 {\n    right: auto;\n  }\n  .col-sm-push-12 {\n    left: 100%;\n  }\n  .col-sm-push-11 {\n    left: 91.66666667%;\n  }\n  .col-sm-push-10 {\n    left: 83.33333333%;\n  }\n  .col-sm-push-9 {\n    left: 75%;\n  }\n  .col-sm-push-8 {\n    left: 66.66666667%;\n  }\n  .col-sm-push-7 {\n    left: 58.33333333%;\n  }\n  .col-sm-push-6 {\n    left: 50%;\n  }\n  .col-sm-push-5 {\n    left: 41.66666667%;\n  }\n  .col-sm-push-4 {\n    left: 33.33333333%;\n  }\n  .col-sm-push-3 {\n    left: 25%;\n  }\n  .col-sm-push-2 {\n    left: 16.66666667%;\n  }\n  .col-sm-push-1 {\n    left: 8.33333333%;\n  }\n  .col-sm-push-0 {\n    left: auto;\n  }\n  .col-sm-offset-12 {\n    margin-left: 100%;\n  }\n  .col-sm-offset-11 {\n    margin-left: 91.66666667%;\n  }\n  .col-sm-offset-10 {\n    margin-left: 83.33333333%;\n  }\n  .col-sm-offset-9 {\n    margin-left: 75%;\n  }\n  .col-sm-offset-8 {\n    margin-left: 66.66666667%;\n  }\n  .col-sm-offset-7 {\n    margin-left: 58.33333333%;\n  }\n  .col-sm-offset-6 {\n    margin-left: 50%;\n  }\n  .col-sm-offset-5 {\n    margin-left: 41.66666667%;\n  }\n  .col-sm-offset-4 {\n    margin-left: 33.33333333%;\n  }\n  .col-sm-offset-3 {\n    margin-left: 25%;\n  }\n  .col-sm-offset-2 {\n    margin-left: 16.66666667%;\n  }\n  .col-sm-offset-1 {\n    margin-left: 8.33333333%;\n  }\n  .col-sm-offset-0 {\n    margin-left: 0%;\n  }\n}\n@media (min-width: 992px) {\n  .col-md-1, .col-md-2, .col-md-3, .col-md-4, .col-md-5, .col-md-6, .col-md-7, .col-md-8, .col-md-9, .col-md-10, .col-md-11, .col-md-12 {\n    float: left;\n  }\n  .col-md-12 {\n    width: 100%;\n  }\n  .col-md-11 {\n    width: 91.66666667%;\n  }\n  .col-md-10 {\n    width: 83.33333333%;\n  }\n  .col-md-9 {\n    width: 75%;\n  }\n  .col-md-8 {\n    width: 66.66666667%;\n  }\n  .col-md-7 {\n    width: 58.33333333%;\n  }\n  .col-md-6 {\n    width: 50%;\n  }\n  .col-md-5 {\n    width: 41.66666667%;\n  }\n  .col-md-4 {\n    width: 33.33333333%;\n  }\n  .col-md-3 {\n    width: 25%;\n  }\n  .col-md-2 {\n    width: 16.66666667%;\n  }\n  .col-md-1 {\n    width: 8.33333333%;\n  }\n  .col-md-pull-12 {\n    right: 100%;\n  }\n  .col-md-pull-11 {\n    right: 91.66666667%;\n  }\n  .col-md-pull-10 {\n    right: 83.33333333%;\n  }\n  .col-md-pull-9 {\n    right: 75%;\n  }\n  .col-md-pull-8 {\n    right: 66.66666667%;\n  }\n  .col-md-pull-7 {\n    right: 58.33333333%;\n  }\n  .col-md-pull-6 {\n    right: 50%;\n  }\n  .col-md-pull-5 {\n    right: 41.66666667%;\n  }\n  .col-md-pull-4 {\n    right: 33.33333333%;\n  }\n  .col-md-pull-3 {\n    right: 25%;\n  }\n  .col-md-pull-2 {\n    right: 16.66666667%;\n  }\n  .col-md-pull-1 {\n    right: 8.33333333%;\n  }\n  .col-md-pull-0 {\n    right: auto;\n  }\n  .col-md-push-12 {\n    left: 100%;\n  }\n  .col-md-push-11 {\n    left: 91.66666667%;\n  }\n  .col-md-push-10 {\n    left: 83.33333333%;\n  }\n  .col-md-push-9 {\n    left: 75%;\n  }\n  .col-md-push-8 {\n    left: 66.66666667%;\n  }\n  .col-md-push-7 {\n    left: 58.33333333%;\n  }\n  .col-md-push-6 {\n    left: 50%;\n  }\n  .col-md-push-5 {\n    left: 41.66666667%;\n  }\n  .col-md-push-4 {\n    left: 33.33333333%;\n  }\n  .col-md-push-3 {\n    left: 25%;\n  }\n  .col-md-push-2 {\n    left: 16.66666667%;\n  }\n  .col-md-push-1 {\n    left: 8.33333333%;\n  }\n  .col-md-push-0 {\n    left: auto;\n  }\n  .col-md-offset-12 {\n    margin-left: 100%;\n  }\n  .col-md-offset-11 {\n    margin-left: 91.66666667%;\n  }\n  .col-md-offset-10 {\n    margin-left: 83.33333333%;\n  }\n  .col-md-offset-9 {\n    margin-left: 75%;\n  }\n  .col-md-offset-8 {\n    margin-left: 66.66666667%;\n  }\n  .col-md-offset-7 {\n    margin-left: 58.33333333%;\n  }\n  .col-md-offset-6 {\n    margin-left: 50%;\n  }\n  .col-md-offset-5 {\n    margin-left: 41.66666667%;\n  }\n  .col-md-offset-4 {\n    margin-left: 33.33333333%;\n  }\n  .col-md-offset-3 {\n    margin-left: 25%;\n  }\n  .col-md-offset-2 {\n    margin-left: 16.66666667%;\n  }\n  .col-md-offset-1 {\n    margin-left: 8.33333333%;\n  }\n  .col-md-offset-0 {\n    margin-left: 0%;\n  }\n}\n@media (min-width: 1200px) {\n  .col-lg-1, .col-lg-2, .col-lg-3, .col-lg-4, .col-lg-5, .col-lg-6, .col-lg-7, .col-lg-8, .col-lg-9, .col-lg-10, .col-lg-11, .col-lg-12 {\n    float: left;\n  }\n  .col-lg-12 {\n    width: 100%;\n  }\n  .col-lg-11 {\n    width: 91.66666667%;\n  }\n  .col-lg-10 {\n    width: 83.33333333%;\n  }\n  .col-lg-9 {\n    width: 75%;\n  }\n  .col-lg-8 {\n    width: 66.66666667%;\n  }\n  .col-lg-7 {\n    width: 58.33333333%;\n  }\n  .col-lg-6 {\n    width: 50%;\n  }\n  .col-lg-5 {\n    width: 41.66666667%;\n  }\n  .col-lg-4 {\n    width: 33.33333333%;\n  }\n  .col-lg-3 {\n    width: 25%;\n  }\n  .col-lg-2 {\n    width: 16.66666667%;\n  }\n  .col-lg-1 {\n    width: 8.33333333%;\n  }\n  .col-lg-pull-12 {\n    right: 100%;\n  }\n  .col-lg-pull-11 {\n    right: 91.66666667%;\n  }\n  .col-lg-pull-10 {\n    right: 83.33333333%;\n  }\n  .col-lg-pull-9 {\n    right: 75%;\n  }\n  .col-lg-pull-8 {\n    right: 66.66666667%;\n  }\n  .col-lg-pull-7 {\n    right: 58.33333333%;\n  }\n  .col-lg-pull-6 {\n    right: 50%;\n  }\n  .col-lg-pull-5 {\n    right: 41.66666667%;\n  }\n  .col-lg-pull-4 {\n    right: 33.33333333%;\n  }\n  .col-lg-pull-3 {\n    right: 25%;\n  }\n  .col-lg-pull-2 {\n    right: 16.66666667%;\n  }\n  .col-lg-pull-1 {\n    right: 8.33333333%;\n  }\n  .col-lg-pull-0 {\n    right: auto;\n  }\n  .col-lg-push-12 {\n    left: 100%;\n  }\n  .col-lg-push-11 {\n    left: 91.66666667%;\n  }\n  .col-lg-push-10 {\n    left: 83.33333333%;\n  }\n  .col-lg-push-9 {\n    left: 75%;\n  }\n  .col-lg-push-8 {\n    left: 66.66666667%;\n  }\n  .col-lg-push-7 {\n    left: 58.33333333%;\n  }\n  .col-lg-push-6 {\n    left: 50%;\n  }\n  .col-lg-push-5 {\n    left: 41.66666667%;\n  }\n  .col-lg-push-4 {\n    left: 33.33333333%;\n  }\n  .col-lg-push-3 {\n    left: 25%;\n  }\n  .col-lg-push-2 {\n    left: 16.66666667%;\n  }\n  .col-lg-push-1 {\n    left: 8.33333333%;\n  }\n  .col-lg-push-0 {\n    left: auto;\n  }\n  .col-lg-offset-12 {\n    margin-left: 100%;\n  }\n  .col-lg-offset-11 {\n    margin-left: 91.66666667%;\n  }\n  .col-lg-offset-10 {\n    margin-left: 83.33333333%;\n  }\n  .col-lg-offset-9 {\n    margin-left: 75%;\n  }\n  .col-lg-offset-8 {\n    margin-left: 66.66666667%;\n  }\n  .col-lg-offset-7 {\n    margin-left: 58.33333333%;\n  }\n  .col-lg-offset-6 {\n    margin-left: 50%;\n  }\n  .col-lg-offset-5 {\n    margin-left: 41.66666667%;\n  }\n  .col-lg-offset-4 {\n    margin-left: 33.33333333%;\n  }\n  .col-lg-offset-3 {\n    margin-left: 25%;\n  }\n  .col-lg-offset-2 {\n    margin-left: 16.66666667%;\n  }\n  .col-lg-offset-1 {\n    margin-left: 8.33333333%;\n  }\n  .col-lg-offset-0 {\n    margin-left: 0%;\n  }\n}\ntable {\n  background-color: transparent;\n}\ncaption {\n  padding-top: 8px;\n  padding-bottom: 8px;\n  color: #777777;\n  text-align: left;\n}\nth {\n  text-align: left;\n}\n.table {\n  width: 100%;\n  max-width: 100%;\n  margin-bottom: 18px;\n}\n.table > thead > tr > th,\n.table > tbody > tr > th,\n.table > tfoot > tr > th,\n.table > thead > tr > td,\n.table > tbody > tr > td,\n.table > tfoot > tr > td {\n  padding: 8px;\n  line-height: 1.42857143;\n  vertical-align: top;\n  border-top: 1px solid #ddd;\n}\n.table > thead > tr > th {\n  vertical-align: bottom;\n  border-bottom: 2px solid #ddd;\n}\n.table > caption + thead > tr:first-child > th,\n.table > colgroup + thead > tr:first-child > th,\n.table > thead:first-child > tr:first-child > th,\n.table > caption + thead > tr:first-child > td,\n.table > colgroup + thead > tr:first-child > td,\n.table > thead:first-child > tr:first-child > td {\n  border-top: 0;\n}\n.table > tbody + tbody {\n  border-top: 2px solid #ddd;\n}\n.table .table {\n  background-color: #fff;\n}\n.table-condensed > thead > tr > th,\n.table-condensed > tbody > tr > th,\n.table-condensed > tfoot > tr > th,\n.table-condensed > thead > tr > td,\n.table-condensed > tbody > tr > td,\n.table-condensed > tfoot > tr > td {\n  padding: 5px;\n}\n.table-bordered {\n  border: 1px solid #ddd;\n}\n.table-bordered > thead > tr > th,\n.table-bordered > tbody > tr > th,\n.table-bordered > tfoot > tr > th,\n.table-bordered > thead > tr > td,\n.table-bordered > tbody > tr > td,\n.table-bordered > tfoot > tr > td {\n  border: 1px solid #ddd;\n}\n.table-bordered > thead > tr > th,\n.table-bordered > thead > tr > td {\n  border-bottom-width: 2px;\n}\n.table-striped > tbody > tr:nth-of-type(odd) {\n  background-color: #f9f9f9;\n}\n.table-hover > tbody > tr:hover {\n  background-color: #f5f5f5;\n}\ntable col[class*="col-"] {\n  position: static;\n  float: none;\n  display: table-column;\n}\ntable td[class*="col-"],\ntable th[class*="col-"] {\n  position: static;\n  float: none;\n  display: table-cell;\n}\n.table > thead > tr > td.active,\n.table > tbody > tr > td.active,\n.table > tfoot > tr > td.active,\n.table > thead > tr > th.active,\n.table > tbody > tr > th.active,\n.table > tfoot > tr > th.active,\n.table > thead > tr.active > td,\n.table > tbody > tr.active > td,\n.table > tfoot > tr.active > td,\n.table > thead > tr.active > th,\n.table > tbody > tr.active > th,\n.table > tfoot > tr.active > th {\n  background-color: #f5f5f5;\n}\n.table-hover > tbody > tr > td.active:hover,\n.table-hover > tbody > tr > th.active:hover,\n.table-hover > tbody > tr.active:hover > td,\n.table-hover > tbody > tr:hover > .active,\n.table-hover > tbody > tr.active:hover > th {\n  background-color: #e8e8e8;\n}\n.table > thead > tr > td.success,\n.table > tbody > tr > td.success,\n.table > tfoot > tr > td.success,\n.table > thead > tr > th.success,\n.table > tbody > tr > th.success,\n.table > tfoot > tr > th.success,\n.table > thead > tr.success > td,\n.table > tbody > tr.success > td,\n.table > tfoot > tr.success > td,\n.table > thead > tr.success > th,\n.table > tbody > tr.success > th,\n.table > tfoot > tr.success > th {\n  background-color: #dff0d8;\n}\n.table-hover > tbody > tr > td.success:hover,\n.table-hover > tbody > tr > th.success:hover,\n.table-hover > tbody > tr.success:hover > td,\n.table-hover > tbody > tr:hover > .success,\n.table-hover > tbody > tr.success:hover > th {\n  background-color: #d0e9c6;\n}\n.table > thead > tr > td.info,\n.table > tbody > tr > td.info,\n.table > tfoot > tr > td.info,\n.table > thead > tr > th.info,\n.table > tbody > tr > th.info,\n.table > tfoot > tr > th.info,\n.table > thead > tr.info > td,\n.table > tbody > tr.info > td,\n.table > tfoot > tr.info > td,\n.table > thead > tr.info > th,\n.table > tbody > tr.info > th,\n.table > tfoot > tr.info > th {\n  background-color: #d9edf7;\n}\n.table-hover > tbody > tr > td.info:hover,\n.table-hover > tbody > tr > th.info:hover,\n.table-hover > tbody > tr.info:hover > td,\n.table-hover > tbody > tr:hover > .info,\n.table-hover > tbody > tr.info:hover > th {\n  background-color: #c4e3f3;\n}\n.table > thead > tr > td.warning,\n.table > tbody > tr > td.warning,\n.table > tfoot > tr > td.warning,\n.table > thead > tr > th.warning,\n.table > tbody > tr > th.warning,\n.table > tfoot > tr > th.warning,\n.table > thead > tr.warning > td,\n.table > tbody > tr.warning > td,\n.table > tfoot > tr.warning > td,\n.table > thead > tr.warning > th,\n.table > tbody > tr.warning > th,\n.table > tfoot > tr.warning > th {\n  background-color: #fcf8e3;\n}\n.table-hover > tbody > tr > td.warning:hover,\n.table-hover > tbody > tr > th.warning:hover,\n.table-hover > tbody > tr.warning:hover > td,\n.table-hover > tbody > tr:hover > .warning,\n.table-hover > tbody > tr.warning:hover > th {\n  background-color: #faf2cc;\n}\n.table > thead > tr > td.danger,\n.table > tbody > tr > td.danger,\n.table > tfoot > tr > td.danger,\n.table > thead > tr > th.danger,\n.table > tbody > tr > th.danger,\n.table > tfoot > tr > th.danger,\n.table > thead > tr.danger > td,\n.table > tbody > tr.danger > td,\n.table > tfoot > tr.danger > td,\n.table > thead > tr.danger > th,\n.table > tbody > tr.danger > th,\n.table > tfoot > tr.danger > th {\n  background-color: #f2dede;\n}\n.table-hover > tbody > tr > td.danger:hover,\n.table-hover > tbody > tr > th.danger:hover,\n.table-hover > tbody > tr.danger:hover > td,\n.table-hover > tbody > tr:hover > .danger,\n.table-hover > tbody > tr.danger:hover > th {\n  background-color: #ebcccc;\n}\n.table-responsive {\n  overflow-x: auto;\n  min-height: 0.01%;\n}\n@media screen and (max-width: 767px) {\n  .table-responsive {\n    width: 100%;\n    margin-bottom: 13.5px;\n    overflow-y: hidden;\n    -ms-overflow-style: -ms-autohiding-scrollbar;\n    border: 1px solid #ddd;\n  }\n  .table-responsive > .table {\n    margin-bottom: 0;\n  }\n  .table-responsive > .table > thead > tr > th,\n  .table-responsive > .table > tbody > tr > th,\n  .table-responsive > .table > tfoot > tr > th,\n  .table-responsive > .table > thead > tr > td,\n  .table-responsive > .table > tbody > tr > td,\n  .table-responsive > .table > tfoot > tr > td {\n    white-space: nowrap;\n  }\n  .table-responsive > .table-bordered {\n    border: 0;\n  }\n  .table-responsive > .table-bordered > thead > tr > th:first-child,\n  .table-responsive > .table-bordered > tbody > tr > th:first-child,\n  .table-responsive > .table-bordered > tfoot > tr > th:first-child,\n  .table-responsive > .table-bordered > thead > tr > td:first-child,\n  .table-responsive > .table-bordered > tbody > tr > td:first-child,\n  .table-responsive > .table-bordered > tfoot > tr > td:first-child {\n    border-left: 0;\n  }\n  .table-responsive > .table-bordered > thead > tr > th:last-child,\n  .table-responsive > .table-bordered > tbody > tr > th:last-child,\n  .table-responsive > .table-bordered > tfoot > tr > th:last-child,\n  .table-responsive > .table-bordered > thead > tr > td:last-child,\n  .table-responsive > .table-bordered > tbody > tr > td:last-child,\n  .table-responsive > .table-bordered > tfoot > tr > td:last-child {\n    border-right: 0;\n  }\n  .table-responsive > .table-bordered > tbody > tr:last-child > th,\n  .table-responsive > .table-bordered > tfoot > tr:last-child > th,\n  .table-responsive > .table-bordered > tbody > tr:last-child > td,\n  .table-responsive > .table-bordered > tfoot > tr:last-child > td {\n    border-bottom: 0;\n  }\n}\nfieldset {\n  padding: 0;\n  margin: 0;\n  border: 0;\n  min-width: 0;\n}\nlegend {\n  display: block;\n  width: 100%;\n  padding: 0;\n  margin-bottom: 18px;\n  font-size: 19.5px;\n  line-height: inherit;\n  color: #333333;\n  border: 0;\n  border-bottom: 1px solid #e5e5e5;\n}\nlabel {\n  display: inline-block;\n  max-width: 100%;\n  margin-bottom: 5px;\n  font-weight: bold;\n}\ninput[type="search"] {\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  box-sizing: border-box;\n}\ninput[type="radio"],\ninput[type="checkbox"] {\n  margin: 4px 0 0;\n  margin-top: 1px \\9;\n  line-height: normal;\n}\ninput[type="file"] {\n  display: block;\n}\ninput[type="range"] {\n  display: block;\n  width: 100%;\n}\nselect[multiple],\nselect[size] {\n  height: auto;\n}\ninput[type="file"]:focus,\ninput[type="radio"]:focus,\ninput[type="checkbox"]:focus {\n  outline: 5px auto -webkit-focus-ring-color;\n  outline-offset: -2px;\n}\noutput {\n  display: block;\n  padding-top: 7px;\n  font-size: 13px;\n  line-height: 1.42857143;\n  color: #555555;\n}\n.form-control {\n  display: block;\n  width: 100%;\n  height: 32px;\n  padding: 6px 12px;\n  font-size: 13px;\n  line-height: 1.42857143;\n  color: #555555;\n  background-color: #fff;\n  background-image: none;\n  border: 1px solid #ccc;\n  border-radius: 2px;\n  -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);\n  box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);\n  -webkit-transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;\n  -o-transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;\n  transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;\n}\n.form-control:focus {\n  border-color: #66afe9;\n  outline: 0;\n  -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px rgba(102, 175, 233, 0.6);\n  box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px rgba(102, 175, 233, 0.6);\n}\n.form-control::-moz-placeholder {\n  color: #999;\n  opacity: 1;\n}\n.form-control:-ms-input-placeholder {\n  color: #999;\n}\n.form-control::-webkit-input-placeholder {\n  color: #999;\n}\n.form-control::-ms-expand {\n  border: 0;\n  background-color: transparent;\n}\n.form-control[disabled],\n.form-control[readonly],\nfieldset[disabled] .form-control {\n  background-color: #eeeeee;\n  opacity: 1;\n}\n.form-control[disabled],\nfieldset[disabled] .form-control {\n  cursor: not-allowed;\n}\ntextarea.form-control {\n  height: auto;\n}\ninput[type="search"] {\n  -webkit-appearance: none;\n}\n@media screen and (-webkit-min-device-pixel-ratio: 0) {\n  input[type="date"].form-control,\n  input[type="time"].form-control,\n  input[type="datetime-local"].form-control,\n  input[type="month"].form-control {\n    line-height: 32px;\n  }\n  input[type="date"].input-sm,\n  input[type="time"].input-sm,\n  input[type="datetime-local"].input-sm,\n  input[type="month"].input-sm,\n  .input-group-sm input[type="date"],\n  .input-group-sm input[type="time"],\n  .input-group-sm input[type="datetime-local"],\n  .input-group-sm input[type="month"] {\n    line-height: 30px;\n  }\n  input[type="date"].input-lg,\n  input[type="time"].input-lg,\n  input[type="datetime-local"].input-lg,\n  input[type="month"].input-lg,\n  .input-group-lg input[type="date"],\n  .input-group-lg input[type="time"],\n  .input-group-lg input[type="datetime-local"],\n  .input-group-lg input[type="month"] {\n    line-height: 45px;\n  }\n}\n.form-group {\n  margin-bottom: 15px;\n}\n.radio,\n.checkbox {\n  position: relative;\n  display: block;\n  margin-top: 10px;\n  margin-bottom: 10px;\n}\n.radio label,\n.checkbox label {\n  min-height: 18px;\n  padding-left: 20px;\n  margin-bottom: 0;\n  font-weight: normal;\n  cursor: pointer;\n}\n.radio input[type="radio"],\n.radio-inline input[type="radio"],\n.checkbox input[type="checkbox"],\n.checkbox-inline input[type="checkbox"] {\n  position: absolute;\n  margin-left: -20px;\n  margin-top: 4px \\9;\n}\n.radio + .radio,\n.checkbox + .checkbox {\n  margin-top: -5px;\n}\n.radio-inline,\n.checkbox-inline {\n  position: relative;\n  display: inline-block;\n  padding-left: 20px;\n  margin-bottom: 0;\n  vertical-align: middle;\n  font-weight: normal;\n  cursor: pointer;\n}\n.radio-inline + .radio-inline,\n.checkbox-inline + .checkbox-inline {\n  margin-top: 0;\n  margin-left: 10px;\n}\ninput[type="radio"][disabled],\ninput[type="checkbox"][disabled],\ninput[type="radio"].disabled,\ninput[type="checkbox"].disabled,\nfieldset[disabled] input[type="radio"],\nfieldset[disabled] input[type="checkbox"] {\n  cursor: not-allowed;\n}\n.radio-inline.disabled,\n.checkbox-inline.disabled,\nfieldset[disabled] .radio-inline,\nfieldset[disabled] .checkbox-inline {\n  cursor: not-allowed;\n}\n.radio.disabled label,\n.checkbox.disabled label,\nfieldset[disabled] .radio label,\nfieldset[disabled] .checkbox label {\n  cursor: not-allowed;\n}\n.form-control-static {\n  padding-top: 7px;\n  padding-bottom: 7px;\n  margin-bottom: 0;\n  min-height: 31px;\n}\n.form-control-static.input-lg,\n.form-control-static.input-sm {\n  padding-left: 0;\n  padding-right: 0;\n}\n.input-sm {\n  height: 30px;\n  padding: 5px 10px;\n  font-size: 12px;\n  line-height: 1.5;\n  border-radius: 1px;\n}\nselect.input-sm {\n  height: 30px;\n  line-height: 30px;\n}\ntextarea.input-sm,\nselect[multiple].input-sm {\n  height: auto;\n}\n.form-group-sm .form-control {\n  height: 30px;\n  padding: 5px 10px;\n  font-size: 12px;\n  line-height: 1.5;\n  border-radius: 1px;\n}\n.form-group-sm select.form-control {\n  height: 30px;\n  line-height: 30px;\n}\n.form-group-sm textarea.form-control,\n.form-group-sm select[multiple].form-control {\n  height: auto;\n}\n.form-group-sm .form-control-static {\n  height: 30px;\n  min-height: 30px;\n  padding: 6px 10px;\n  font-size: 12px;\n  line-height: 1.5;\n}\n.input-lg {\n  height: 45px;\n  padding: 10px 16px;\n  font-size: 17px;\n  line-height: 1.3333333;\n  border-radius: 3px;\n}\nselect.input-lg {\n  height: 45px;\n  line-height: 45px;\n}\ntextarea.input-lg,\nselect[multiple].input-lg {\n  height: auto;\n}\n.form-group-lg .form-control {\n  height: 45px;\n  padding: 10px 16px;\n  font-size: 17px;\n  line-height: 1.3333333;\n  border-radius: 3px;\n}\n.form-group-lg select.form-control {\n  height: 45px;\n  line-height: 45px;\n}\n.form-group-lg textarea.form-control,\n.form-group-lg select[multiple].form-control {\n  height: auto;\n}\n.form-group-lg .form-control-static {\n  height: 45px;\n  min-height: 35px;\n  padding: 11px 16px;\n  font-size: 17px;\n  line-height: 1.3333333;\n}\n.has-feedback {\n  position: relative;\n}\n.has-feedback .form-control {\n  padding-right: 40px;\n}\n.form-control-feedback {\n  position: absolute;\n  top: 0;\n  right: 0;\n  z-index: 2;\n  display: block;\n  width: 32px;\n  height: 32px;\n  line-height: 32px;\n  text-align: center;\n  pointer-events: none;\n}\n.input-lg + .form-control-feedback,\n.input-group-lg + .form-control-feedback,\n.form-group-lg .form-control + .form-control-feedback {\n  width: 45px;\n  height: 45px;\n  line-height: 45px;\n}\n.input-sm + .form-control-feedback,\n.input-group-sm + .form-control-feedback,\n.form-group-sm .form-control + .form-control-feedback {\n  width: 30px;\n  height: 30px;\n  line-height: 30px;\n}\n.has-success .help-block,\n.has-success .control-label,\n.has-success .radio,\n.has-success .checkbox,\n.has-success .radio-inline,\n.has-success .checkbox-inline,\n.has-success.radio label,\n.has-success.checkbox label,\n.has-success.radio-inline label,\n.has-success.checkbox-inline label {\n  color: #3c763d;\n}\n.has-success .form-control {\n  border-color: #3c763d;\n  -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);\n  box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);\n}\n.has-success .form-control:focus {\n  border-color: #2b542c;\n  -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075), 0 0 6px #67b168;\n  box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075), 0 0 6px #67b168;\n}\n.has-success .input-group-addon {\n  color: #3c763d;\n  border-color: #3c763d;\n  background-color: #dff0d8;\n}\n.has-success .form-control-feedback {\n  color: #3c763d;\n}\n.has-warning .help-block,\n.has-warning .control-label,\n.has-warning .radio,\n.has-warning .checkbox,\n.has-warning .radio-inline,\n.has-warning .checkbox-inline,\n.has-warning.radio label,\n.has-warning.checkbox label,\n.has-warning.radio-inline label,\n.has-warning.checkbox-inline label {\n  color: #8a6d3b;\n}\n.has-warning .form-control {\n  border-color: #8a6d3b;\n  -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);\n  box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);\n}\n.has-warning .form-control:focus {\n  border-color: #66512c;\n  -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075), 0 0 6px #c0a16b;\n  box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075), 0 0 6px #c0a16b;\n}\n.has-warning .input-group-addon {\n  color: #8a6d3b;\n  border-color: #8a6d3b;\n  background-color: #fcf8e3;\n}\n.has-warning .form-control-feedback {\n  color: #8a6d3b;\n}\n.has-error .help-block,\n.has-error .control-label,\n.has-error .radio,\n.has-error .checkbox,\n.has-error .radio-inline,\n.has-error .checkbox-inline,\n.has-error.radio label,\n.has-error.checkbox label,\n.has-error.radio-inline label,\n.has-error.checkbox-inline label {\n  color: #a94442;\n}\n.has-error .form-control {\n  border-color: #a94442;\n  -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);\n  box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);\n}\n.has-error .form-control:focus {\n  border-color: #843534;\n  -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075), 0 0 6px #ce8483;\n  box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075), 0 0 6px #ce8483;\n}\n.has-error .input-group-addon {\n  color: #a94442;\n  border-color: #a94442;\n  background-color: #f2dede;\n}\n.has-error .form-control-feedback {\n  color: #a94442;\n}\n.has-feedback label ~ .form-control-feedback {\n  top: 23px;\n}\n.has-feedback label.sr-only ~ .form-control-feedback {\n  top: 0;\n}\n.help-block {\n  display: block;\n  margin-top: 5px;\n  margin-bottom: 10px;\n  color: #404040;\n}\n@media (min-width: 768px) {\n  .form-inline .form-group {\n    display: inline-block;\n    margin-bottom: 0;\n    vertical-align: middle;\n  }\n  .form-inline .form-control {\n    display: inline-block;\n    width: auto;\n    vertical-align: middle;\n  }\n  .form-inline .form-control-static {\n    display: inline-block;\n  }\n  .form-inline .input-group {\n    display: inline-table;\n    vertical-align: middle;\n  }\n  .form-inline .input-group .input-group-addon,\n  .form-inline .input-group .input-group-btn,\n  .form-inline .input-group .form-control {\n    width: auto;\n  }\n  .form-inline .input-group > .form-control {\n    width: 100%;\n  }\n  .form-inline .control-label {\n    margin-bottom: 0;\n    vertical-align: middle;\n  }\n  .form-inline .radio,\n  .form-inline .checkbox {\n    display: inline-block;\n    margin-top: 0;\n    margin-bottom: 0;\n    vertical-align: middle;\n  }\n  .form-inline .radio label,\n  .form-inline .checkbox label {\n    padding-left: 0;\n  }\n  .form-inline .radio input[type="radio"],\n  .form-inline .checkbox input[type="checkbox"] {\n    position: relative;\n    margin-left: 0;\n  }\n  .form-inline .has-feedback .form-control-feedback {\n    top: 0;\n  }\n}\n.form-horizontal .radio,\n.form-horizontal .checkbox,\n.form-horizontal .radio-inline,\n.form-horizontal .checkbox-inline {\n  margin-top: 0;\n  margin-bottom: 0;\n  padding-top: 7px;\n}\n.form-horizontal .radio,\n.form-horizontal .checkbox {\n  min-height: 25px;\n}\n.form-horizontal .form-group {\n  margin-left: 0px;\n  margin-right: 0px;\n}\n@media (min-width: 768px) {\n  .form-horizontal .control-label {\n    text-align: right;\n    margin-bottom: 0;\n    padding-top: 7px;\n  }\n}\n.form-horizontal .has-feedback .form-control-feedback {\n  right: 0px;\n}\n@media (min-width: 768px) {\n  .form-horizontal .form-group-lg .control-label {\n    padding-top: 11px;\n    font-size: 17px;\n  }\n}\n@media (min-width: 768px) {\n  .form-horizontal .form-group-sm .control-label {\n    padding-top: 6px;\n    font-size: 12px;\n  }\n}\n.btn {\n  display: inline-block;\n  margin-bottom: 0;\n  font-weight: normal;\n  text-align: center;\n  vertical-align: middle;\n  touch-action: manipulation;\n  cursor: pointer;\n  background-image: none;\n  border: 1px solid transparent;\n  white-space: nowrap;\n  padding: 6px 12px;\n  font-size: 13px;\n  line-height: 1.42857143;\n  border-radius: 2px;\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n}\n.btn:focus,\n.btn:active:focus,\n.btn.active:focus,\n.btn.focus,\n.btn:active.focus,\n.btn.active.focus {\n  outline: 5px auto -webkit-focus-ring-color;\n  outline-offset: -2px;\n}\n.btn:hover,\n.btn:focus,\n.btn.focus {\n  color: #333;\n  text-decoration: none;\n}\n.btn:active,\n.btn.active {\n  outline: 0;\n  background-image: none;\n  -webkit-box-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125);\n  box-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125);\n}\n.btn.disabled,\n.btn[disabled],\nfieldset[disabled] .btn {\n  cursor: not-allowed;\n  opacity: 0.65;\n  filter: alpha(opacity=65);\n  -webkit-box-shadow: none;\n  box-shadow: none;\n}\na.btn.disabled,\nfieldset[disabled] a.btn {\n  pointer-events: none;\n}\n.btn-default {\n  color: #333;\n  background-color: #fff;\n  border-color: #ccc;\n}\n.btn-default:focus,\n.btn-default.focus {\n  color: #333;\n  background-color: #e6e6e6;\n  border-color: #8c8c8c;\n}\n.btn-default:hover {\n  color: #333;\n  background-color: #e6e6e6;\n  border-color: #adadad;\n}\n.btn-default:active,\n.btn-default.active,\n.open > .dropdown-toggle.btn-default {\n  color: #333;\n  background-color: #e6e6e6;\n  border-color: #adadad;\n}\n.btn-default:active:hover,\n.btn-default.active:hover,\n.open > .dropdown-toggle.btn-default:hover,\n.btn-default:active:focus,\n.btn-default.active:focus,\n.open > .dropdown-toggle.btn-default:focus,\n.btn-default:active.focus,\n.btn-default.active.focus,\n.open > .dropdown-toggle.btn-default.focus {\n  color: #333;\n  background-color: #d4d4d4;\n  border-color: #8c8c8c;\n}\n.btn-default:active,\n.btn-default.active,\n.open > .dropdown-toggle.btn-default {\n  background-image: none;\n}\n.btn-default.disabled:hover,\n.btn-default[disabled]:hover,\nfieldset[disabled] .btn-default:hover,\n.btn-default.disabled:focus,\n.btn-default[disabled]:focus,\nfieldset[disabled] .btn-default:focus,\n.btn-default.disabled.focus,\n.btn-default[disabled].focus,\nfieldset[disabled] .btn-default.focus {\n  background-color: #fff;\n  border-color: #ccc;\n}\n.btn-default .badge {\n  color: #fff;\n  background-color: #333;\n}\n.btn-primary {\n  color: #fff;\n  background-color: #337ab7;\n  border-color: #2e6da4;\n}\n.btn-primary:focus,\n.btn-primary.focus {\n  color: #fff;\n  background-color: #286090;\n  border-color: #122b40;\n}\n.btn-primary:hover {\n  color: #fff;\n  background-color: #286090;\n  border-color: #204d74;\n}\n.btn-primary:active,\n.btn-primary.active,\n.open > .dropdown-toggle.btn-primary {\n  color: #fff;\n  background-color: #286090;\n  border-color: #204d74;\n}\n.btn-primary:active:hover,\n.btn-primary.active:hover,\n.open > .dropdown-toggle.btn-primary:hover,\n.btn-primary:active:focus,\n.btn-primary.active:focus,\n.open > .dropdown-toggle.btn-primary:focus,\n.btn-primary:active.focus,\n.btn-primary.active.focus,\n.open > .dropdown-toggle.btn-primary.focus {\n  color: #fff;\n  background-color: #204d74;\n  border-color: #122b40;\n}\n.btn-primary:active,\n.btn-primary.active,\n.open > .dropdown-toggle.btn-primary {\n  background-image: none;\n}\n.btn-primary.disabled:hover,\n.btn-primary[disabled]:hover,\nfieldset[disabled] .btn-primary:hover,\n.btn-primary.disabled:focus,\n.btn-primary[disabled]:focus,\nfieldset[disabled] .btn-primary:focus,\n.btn-primary.disabled.focus,\n.btn-primary[disabled].focus,\nfieldset[disabled] .btn-primary.focus {\n  background-color: #337ab7;\n  border-color: #2e6da4;\n}\n.btn-primary .badge {\n  color: #337ab7;\n  background-color: #fff;\n}\n.btn-success {\n  color: #fff;\n  background-color: #5cb85c;\n  border-color: #4cae4c;\n}\n.btn-success:focus,\n.btn-success.focus {\n  color: #fff;\n  background-color: #449d44;\n  border-color: #255625;\n}\n.btn-success:hover {\n  color: #fff;\n  background-color: #449d44;\n  border-color: #398439;\n}\n.btn-success:active,\n.btn-success.active,\n.open > .dropdown-toggle.btn-success {\n  color: #fff;\n  background-color: #449d44;\n  border-color: #398439;\n}\n.btn-success:active:hover,\n.btn-success.active:hover,\n.open > .dropdown-toggle.btn-success:hover,\n.btn-success:active:focus,\n.btn-success.active:focus,\n.open > .dropdown-toggle.btn-success:focus,\n.btn-success:active.focus,\n.btn-success.active.focus,\n.open > .dropdown-toggle.btn-success.focus {\n  color: #fff;\n  background-color: #398439;\n  border-color: #255625;\n}\n.btn-success:active,\n.btn-success.active,\n.open > .dropdown-toggle.btn-success {\n  background-image: none;\n}\n.btn-success.disabled:hover,\n.btn-success[disabled]:hover,\nfieldset[disabled] .btn-success:hover,\n.btn-success.disabled:focus,\n.btn-success[disabled]:focus,\nfieldset[disabled] .btn-success:focus,\n.btn-success.disabled.focus,\n.btn-success[disabled].focus,\nfieldset[disabled] .btn-success.focus {\n  background-color: #5cb85c;\n  border-color: #4cae4c;\n}\n.btn-success .badge {\n  color: #5cb85c;\n  background-color: #fff;\n}\n.btn-info {\n  color: #fff;\n  background-color: #5bc0de;\n  border-color: #46b8da;\n}\n.btn-info:focus,\n.btn-info.focus {\n  color: #fff;\n  background-color: #31b0d5;\n  border-color: #1b6d85;\n}\n.btn-info:hover {\n  color: #fff;\n  background-color: #31b0d5;\n  border-color: #269abc;\n}\n.btn-info:active,\n.btn-info.active,\n.open > .dropdown-toggle.btn-info {\n  color: #fff;\n  background-color: #31b0d5;\n  border-color: #269abc;\n}\n.btn-info:active:hover,\n.btn-info.active:hover,\n.open > .dropdown-toggle.btn-info:hover,\n.btn-info:active:focus,\n.btn-info.active:focus,\n.open > .dropdown-toggle.btn-info:focus,\n.btn-info:active.focus,\n.btn-info.active.focus,\n.open > .dropdown-toggle.btn-info.focus {\n  color: #fff;\n  background-color: #269abc;\n  border-color: #1b6d85;\n}\n.btn-info:active,\n.btn-info.active,\n.open > .dropdown-toggle.btn-info {\n  background-image: none;\n}\n.btn-info.disabled:hover,\n.btn-info[disabled]:hover,\nfieldset[disabled] .btn-info:hover,\n.btn-info.disabled:focus,\n.btn-info[disabled]:focus,\nfieldset[disabled] .btn-info:focus,\n.btn-info.disabled.focus,\n.btn-info[disabled].focus,\nfieldset[disabled] .btn-info.focus {\n  background-color: #5bc0de;\n  border-color: #46b8da;\n}\n.btn-info .badge {\n  color: #5bc0de;\n  background-color: #fff;\n}\n.btn-warning {\n  color: #fff;\n  background-color: #f0ad4e;\n  border-color: #eea236;\n}\n.btn-warning:focus,\n.btn-warning.focus {\n  color: #fff;\n  background-color: #ec971f;\n  border-color: #985f0d;\n}\n.btn-warning:hover {\n  color: #fff;\n  background-color: #ec971f;\n  border-color: #d58512;\n}\n.btn-warning:active,\n.btn-warning.active,\n.open > .dropdown-toggle.btn-warning {\n  color: #fff;\n  background-color: #ec971f;\n  border-color: #d58512;\n}\n.btn-warning:active:hover,\n.btn-warning.active:hover,\n.open > .dropdown-toggle.btn-warning:hover,\n.btn-warning:active:focus,\n.btn-warning.active:focus,\n.open > .dropdown-toggle.btn-warning:focus,\n.btn-warning:active.focus,\n.btn-warning.active.focus,\n.open > .dropdown-toggle.btn-warning.focus {\n  color: #fff;\n  background-color: #d58512;\n  border-color: #985f0d;\n}\n.btn-warning:active,\n.btn-warning.active,\n.open > .dropdown-toggle.btn-warning {\n  background-image: none;\n}\n.btn-warning.disabled:hover,\n.btn-warning[disabled]:hover,\nfieldset[disabled] .btn-warning:hover,\n.btn-warning.disabled:focus,\n.btn-warning[disabled]:focus,\nfieldset[disabled] .btn-warning:focus,\n.btn-warning.disabled.focus,\n.btn-warning[disabled].focus,\nfieldset[disabled] .btn-warning.focus {\n  background-color: #f0ad4e;\n  border-color: #eea236;\n}\n.btn-warning .badge {\n  color: #f0ad4e;\n  background-color: #fff;\n}\n.btn-danger {\n  color: #fff;\n  background-color: #d9534f;\n  border-color: #d43f3a;\n}\n.btn-danger:focus,\n.btn-danger.focus {\n  color: #fff;\n  background-color: #c9302c;\n  border-color: #761c19;\n}\n.btn-danger:hover {\n  color: #fff;\n  background-color: #c9302c;\n  border-color: #ac2925;\n}\n.btn-danger:active,\n.btn-danger.active,\n.open > .dropdown-toggle.btn-danger {\n  color: #fff;\n  background-color: #c9302c;\n  border-color: #ac2925;\n}\n.btn-danger:active:hover,\n.btn-danger.active:hover,\n.open > .dropdown-toggle.btn-danger:hover,\n.btn-danger:active:focus,\n.btn-danger.active:focus,\n.open > .dropdown-toggle.btn-danger:focus,\n.btn-danger:active.focus,\n.btn-danger.active.focus,\n.open > .dropdown-toggle.btn-danger.focus {\n  color: #fff;\n  background-color: #ac2925;\n  border-color: #761c19;\n}\n.btn-danger:active,\n.btn-danger.active,\n.open > .dropdown-toggle.btn-danger {\n  background-image: none;\n}\n.btn-danger.disabled:hover,\n.btn-danger[disabled]:hover,\nfieldset[disabled] .btn-danger:hover,\n.btn-danger.disabled:focus,\n.btn-danger[disabled]:focus,\nfieldset[disabled] .btn-danger:focus,\n.btn-danger.disabled.focus,\n.btn-danger[disabled].focus,\nfieldset[disabled] .btn-danger.focus {\n  background-color: #d9534f;\n  border-color: #d43f3a;\n}\n.btn-danger .badge {\n  color: #d9534f;\n  background-color: #fff;\n}\n.btn-link {\n  color: #337ab7;\n  font-weight: normal;\n  border-radius: 0;\n}\n.btn-link,\n.btn-link:active,\n.btn-link.active,\n.btn-link[disabled],\nfieldset[disabled] .btn-link {\n  background-color: transparent;\n  -webkit-box-shadow: none;\n  box-shadow: none;\n}\n.btn-link,\n.btn-link:hover,\n.btn-link:focus,\n.btn-link:active {\n  border-color: transparent;\n}\n.btn-link:hover,\n.btn-link:focus {\n  color: #23527c;\n  text-decoration: underline;\n  background-color: transparent;\n}\n.btn-link[disabled]:hover,\nfieldset[disabled] .btn-link:hover,\n.btn-link[disabled]:focus,\nfieldset[disabled] .btn-link:focus {\n  color: #777777;\n  text-decoration: none;\n}\n.btn-lg,\n.btn-group-lg > .btn {\n  padding: 10px 16px;\n  font-size: 17px;\n  line-height: 1.3333333;\n  border-radius: 3px;\n}\n.btn-sm,\n.btn-group-sm > .btn {\n  padding: 5px 10px;\n  font-size: 12px;\n  line-height: 1.5;\n  border-radius: 1px;\n}\n.btn-xs,\n.btn-group-xs > .btn {\n  padding: 1px 5px;\n  font-size: 12px;\n  line-height: 1.5;\n  border-radius: 1px;\n}\n.btn-block {\n  display: block;\n  width: 100%;\n}\n.btn-block + .btn-block {\n  margin-top: 5px;\n}\ninput[type="submit"].btn-block,\ninput[type="reset"].btn-block,\ninput[type="button"].btn-block {\n  width: 100%;\n}\n.fade {\n  opacity: 0;\n  -webkit-transition: opacity 0.15s linear;\n  -o-transition: opacity 0.15s linear;\n  transition: opacity 0.15s linear;\n}\n.fade.in {\n  opacity: 1;\n}\n.collapse {\n  display: none;\n}\n.collapse.in {\n  display: block;\n}\ntr.collapse.in {\n  display: table-row;\n}\ntbody.collapse.in {\n  display: table-row-group;\n}\n.collapsing {\n  position: relative;\n  height: 0;\n  overflow: hidden;\n  -webkit-transition-property: height, visibility;\n  transition-property: height, visibility;\n  -webkit-transition-duration: 0.35s;\n  transition-duration: 0.35s;\n  -webkit-transition-timing-function: ease;\n  transition-timing-function: ease;\n}\n.caret {\n  display: inline-block;\n  width: 0;\n  height: 0;\n  margin-left: 2px;\n  vertical-align: middle;\n  border-top: 4px dashed;\n  border-top: 4px solid \\9;\n  border-right: 4px solid transparent;\n  border-left: 4px solid transparent;\n}\n.dropup,\n.dropdown {\n  position: relative;\n}\n.dropdown-toggle:focus {\n  outline: 0;\n}\n.dropdown-menu {\n  position: absolute;\n  top: 100%;\n  left: 0;\n  z-index: 1000;\n  display: none;\n  float: left;\n  min-width: 160px;\n  padding: 5px 0;\n  margin: 2px 0 0;\n  list-style: none;\n  font-size: 13px;\n  text-align: left;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border: 1px solid rgba(0, 0, 0, 0.15);\n  border-radius: 2px;\n  -webkit-box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);\n  box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);\n  background-clip: padding-box;\n}\n.dropdown-menu.pull-right {\n  right: 0;\n  left: auto;\n}\n.dropdown-menu .divider {\n  height: 1px;\n  margin: 8px 0;\n  overflow: hidden;\n  background-color: #e5e5e5;\n}\n.dropdown-menu > li > a {\n  display: block;\n  padding: 3px 20px;\n  clear: both;\n  font-weight: normal;\n  line-height: 1.42857143;\n  color: #333333;\n  white-space: nowrap;\n}\n.dropdown-menu > li > a:hover,\n.dropdown-menu > li > a:focus {\n  text-decoration: none;\n  color: #262626;\n  background-color: #f5f5f5;\n}\n.dropdown-menu > .active > a,\n.dropdown-menu > .active > a:hover,\n.dropdown-menu > .active > a:focus {\n  color: #fff;\n  text-decoration: none;\n  outline: 0;\n  background-color: #337ab7;\n}\n.dropdown-menu > .disabled > a,\n.dropdown-menu > .disabled > a:hover,\n.dropdown-menu > .disabled > a:focus {\n  color: #777777;\n}\n.dropdown-menu > .disabled > a:hover,\n.dropdown-menu > .disabled > a:focus {\n  text-decoration: none;\n  background-color: transparent;\n  background-image: none;\n  filter: progid:DXImageTransform.Microsoft.gradient(enabled = false);\n  cursor: not-allowed;\n}\n.open > .dropdown-menu {\n  display: block;\n}\n.open > a {\n  outline: 0;\n}\n.dropdown-menu-right {\n  left: auto;\n  right: 0;\n}\n.dropdown-menu-left {\n  left: 0;\n  right: auto;\n}\n.dropdown-header {\n  display: block;\n  padding: 3px 20px;\n  font-size: 12px;\n  line-height: 1.42857143;\n  color: #777777;\n  white-space: nowrap;\n}\n.dropdown-backdrop {\n  position: fixed;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  top: 0;\n  z-index: 990;\n}\n.pull-right > .dropdown-menu {\n  right: 0;\n  left: auto;\n}\n.dropup .caret,\n.navbar-fixed-bottom .dropdown .caret {\n  border-top: 0;\n  border-bottom: 4px dashed;\n  border-bottom: 4px solid \\9;\n  content: "";\n}\n.dropup .dropdown-menu,\n.navbar-fixed-bottom .dropdown .dropdown-menu {\n  top: auto;\n  bottom: 100%;\n  margin-bottom: 2px;\n}\n@media (min-width: 541px) {\n  .navbar-right .dropdown-menu {\n    left: auto;\n    right: 0;\n  }\n  .navbar-right .dropdown-menu-left {\n    left: 0;\n    right: auto;\n  }\n}\n.btn-group,\n.btn-group-vertical {\n  position: relative;\n  display: inline-block;\n  vertical-align: middle;\n}\n.btn-group > .btn,\n.btn-group-vertical > .btn {\n  position: relative;\n  float: left;\n}\n.btn-group > .btn:hover,\n.btn-group-vertical > .btn:hover,\n.btn-group > .btn:focus,\n.btn-group-vertical > .btn:focus,\n.btn-group > .btn:active,\n.btn-group-vertical > .btn:active,\n.btn-group > .btn.active,\n.btn-group-vertical > .btn.active {\n  z-index: 2;\n}\n.btn-group .btn + .btn,\n.btn-group .btn + .btn-group,\n.btn-group .btn-group + .btn,\n.btn-group .btn-group + .btn-group {\n  margin-left: -1px;\n}\n.btn-toolbar {\n  margin-left: -5px;\n}\n.btn-toolbar .btn,\n.btn-toolbar .btn-group,\n.btn-toolbar .input-group {\n  float: left;\n}\n.btn-toolbar > .btn,\n.btn-toolbar > .btn-group,\n.btn-toolbar > .input-group {\n  margin-left: 5px;\n}\n.btn-group > .btn:not(:first-child):not(:last-child):not(.dropdown-toggle) {\n  border-radius: 0;\n}\n.btn-group > .btn:first-child {\n  margin-left: 0;\n}\n.btn-group > .btn:first-child:not(:last-child):not(.dropdown-toggle) {\n  border-bottom-right-radius: 0;\n  border-top-right-radius: 0;\n}\n.btn-group > .btn:last-child:not(:first-child),\n.btn-group > .dropdown-toggle:not(:first-child) {\n  border-bottom-left-radius: 0;\n  border-top-left-radius: 0;\n}\n.btn-group > .btn-group {\n  float: left;\n}\n.btn-group > .btn-group:not(:first-child):not(:last-child) > .btn {\n  border-radius: 0;\n}\n.btn-group > .btn-group:first-child:not(:last-child) > .btn:last-child,\n.btn-group > .btn-group:first-child:not(:last-child) > .dropdown-toggle {\n  border-bottom-right-radius: 0;\n  border-top-right-radius: 0;\n}\n.btn-group > .btn-group:last-child:not(:first-child) > .btn:first-child {\n  border-bottom-left-radius: 0;\n  border-top-left-radius: 0;\n}\n.btn-group .dropdown-toggle:active,\n.btn-group.open .dropdown-toggle {\n  outline: 0;\n}\n.btn-group > .btn + .dropdown-toggle {\n  padding-left: 8px;\n  padding-right: 8px;\n}\n.btn-group > .btn-lg + .dropdown-toggle {\n  padding-left: 12px;\n  padding-right: 12px;\n}\n.btn-group.open .dropdown-toggle {\n  -webkit-box-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125);\n  box-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125);\n}\n.btn-group.open .dropdown-toggle.btn-link {\n  -webkit-box-shadow: none;\n  box-shadow: none;\n}\n.btn .caret {\n  margin-left: 0;\n}\n.btn-lg .caret {\n  border-width: 5px 5px 0;\n  border-bottom-width: 0;\n}\n.dropup .btn-lg .caret {\n  border-width: 0 5px 5px;\n}\n.btn-group-vertical > .btn,\n.btn-group-vertical > .btn-group,\n.btn-group-vertical > .btn-group > .btn {\n  display: block;\n  float: none;\n  width: 100%;\n  max-width: 100%;\n}\n.btn-group-vertical > .btn-group > .btn {\n  float: none;\n}\n.btn-group-vertical > .btn + .btn,\n.btn-group-vertical > .btn + .btn-group,\n.btn-group-vertical > .btn-group + .btn,\n.btn-group-vertical > .btn-group + .btn-group {\n  margin-top: -1px;\n  margin-left: 0;\n}\n.btn-group-vertical > .btn:not(:first-child):not(:last-child) {\n  border-radius: 0;\n}\n.btn-group-vertical > .btn:first-child:not(:last-child) {\n  border-top-right-radius: 2px;\n  border-top-left-radius: 2px;\n  border-bottom-right-radius: 0;\n  border-bottom-left-radius: 0;\n}\n.btn-group-vertical > .btn:last-child:not(:first-child) {\n  border-top-right-radius: 0;\n  border-top-left-radius: 0;\n  border-bottom-right-radius: 2px;\n  border-bottom-left-radius: 2px;\n}\n.btn-group-vertical > .btn-group:not(:first-child):not(:last-child) > .btn {\n  border-radius: 0;\n}\n.btn-group-vertical > .btn-group:first-child:not(:last-child) > .btn:last-child,\n.btn-group-vertical > .btn-group:first-child:not(:last-child) > .dropdown-toggle {\n  border-bottom-right-radius: 0;\n  border-bottom-left-radius: 0;\n}\n.btn-group-vertical > .btn-group:last-child:not(:first-child) > .btn:first-child {\n  border-top-right-radius: 0;\n  border-top-left-radius: 0;\n}\n.btn-group-justified {\n  display: table;\n  width: 100%;\n  table-layout: fixed;\n  border-collapse: separate;\n}\n.btn-group-justified > .btn,\n.btn-group-justified > .btn-group {\n  float: none;\n  display: table-cell;\n  width: 1%;\n}\n.btn-group-justified > .btn-group .btn {\n  width: 100%;\n}\n.btn-group-justified > .btn-group .dropdown-menu {\n  left: auto;\n}\n[data-toggle="buttons"] > .btn input[type="radio"],\n[data-toggle="buttons"] > .btn-group > .btn input[type="radio"],\n[data-toggle="buttons"] > .btn input[type="checkbox"],\n[data-toggle="buttons"] > .btn-group > .btn input[type="checkbox"] {\n  position: absolute;\n  clip: rect(0, 0, 0, 0);\n  pointer-events: none;\n}\n.input-group {\n  position: relative;\n  display: table;\n  border-collapse: separate;\n}\n.input-group[class*="col-"] {\n  float: none;\n  padding-left: 0;\n  padding-right: 0;\n}\n.input-group .form-control {\n  position: relative;\n  z-index: 2;\n  float: left;\n  width: 100%;\n  margin-bottom: 0;\n}\n.input-group .form-control:focus {\n  z-index: 3;\n}\n.input-group-lg > .form-control,\n.input-group-lg > .input-group-addon,\n.input-group-lg > .input-group-btn > .btn {\n  height: 45px;\n  padding: 10px 16px;\n  font-size: 17px;\n  line-height: 1.3333333;\n  border-radius: 3px;\n}\nselect.input-group-lg > .form-control,\nselect.input-group-lg > .input-group-addon,\nselect.input-group-lg > .input-group-btn > .btn {\n  height: 45px;\n  line-height: 45px;\n}\ntextarea.input-group-lg > .form-control,\ntextarea.input-group-lg > .input-group-addon,\ntextarea.input-group-lg > .input-group-btn > .btn,\nselect[multiple].input-group-lg > .form-control,\nselect[multiple].input-group-lg > .input-group-addon,\nselect[multiple].input-group-lg > .input-group-btn > .btn {\n  height: auto;\n}\n.input-group-sm > .form-control,\n.input-group-sm > .input-group-addon,\n.input-group-sm > .input-group-btn > .btn {\n  height: 30px;\n  padding: 5px 10px;\n  font-size: 12px;\n  line-height: 1.5;\n  border-radius: 1px;\n}\nselect.input-group-sm > .form-control,\nselect.input-group-sm > .input-group-addon,\nselect.input-group-sm > .input-group-btn > .btn {\n  height: 30px;\n  line-height: 30px;\n}\ntextarea.input-group-sm > .form-control,\ntextarea.input-group-sm > .input-group-addon,\ntextarea.input-group-sm > .input-group-btn > .btn,\nselect[multiple].input-group-sm > .form-control,\nselect[multiple].input-group-sm > .input-group-addon,\nselect[multiple].input-group-sm > .input-group-btn > .btn {\n  height: auto;\n}\n.input-group-addon,\n.input-group-btn,\n.input-group .form-control {\n  display: table-cell;\n}\n.input-group-addon:not(:first-child):not(:last-child),\n.input-group-btn:not(:first-child):not(:last-child),\n.input-group .form-control:not(:first-child):not(:last-child) {\n  border-radius: 0;\n}\n.input-group-addon,\n.input-group-btn {\n  width: 1%;\n  white-space: nowrap;\n  vertical-align: middle;\n}\n.input-group-addon {\n  padding: 6px 12px;\n  font-size: 13px;\n  font-weight: normal;\n  line-height: 1;\n  color: #555555;\n  text-align: center;\n  background-color: #eeeeee;\n  border: 1px solid #ccc;\n  border-radius: 2px;\n}\n.input-group-addon.input-sm {\n  padding: 5px 10px;\n  font-size: 12px;\n  border-radius: 1px;\n}\n.input-group-addon.input-lg {\n  padding: 10px 16px;\n  font-size: 17px;\n  border-radius: 3px;\n}\n.input-group-addon input[type="radio"],\n.input-group-addon input[type="checkbox"] {\n  margin-top: 0;\n}\n.input-group .form-control:first-child,\n.input-group-addon:first-child,\n.input-group-btn:first-child > .btn,\n.input-group-btn:first-child > .btn-group > .btn,\n.input-group-btn:first-child > .dropdown-toggle,\n.input-group-btn:last-child > .btn:not(:last-child):not(.dropdown-toggle),\n.input-group-btn:last-child > .btn-group:not(:last-child) > .btn {\n  border-bottom-right-radius: 0;\n  border-top-right-radius: 0;\n}\n.input-group-addon:first-child {\n  border-right: 0;\n}\n.input-group .form-control:last-child,\n.input-group-addon:last-child,\n.input-group-btn:last-child > .btn,\n.input-group-btn:last-child > .btn-group > .btn,\n.input-group-btn:last-child > .dropdown-toggle,\n.input-group-btn:first-child > .btn:not(:first-child),\n.input-group-btn:first-child > .btn-group:not(:first-child) > .btn {\n  border-bottom-left-radius: 0;\n  border-top-left-radius: 0;\n}\n.input-group-addon:last-child {\n  border-left: 0;\n}\n.input-group-btn {\n  position: relative;\n  font-size: 0;\n  white-space: nowrap;\n}\n.input-group-btn > .btn {\n  position: relative;\n}\n.input-group-btn > .btn + .btn {\n  margin-left: -1px;\n}\n.input-group-btn > .btn:hover,\n.input-group-btn > .btn:focus,\n.input-group-btn > .btn:active {\n  z-index: 2;\n}\n.input-group-btn:first-child > .btn,\n.input-group-btn:first-child > .btn-group {\n  margin-right: -1px;\n}\n.input-group-btn:last-child > .btn,\n.input-group-btn:last-child > .btn-group {\n  z-index: 2;\n  margin-left: -1px;\n}\n.nav {\n  margin-bottom: 0;\n  padding-left: 0;\n  list-style: none;\n}\n.nav > li {\n  position: relative;\n  display: block;\n}\n.nav > li > a {\n  position: relative;\n  display: block;\n  padding: 10px 15px;\n}\n.nav > li > a:hover,\n.nav > li > a:focus {\n  text-decoration: none;\n  background-color: #eeeeee;\n}\n.nav > li.disabled > a {\n  color: #777777;\n}\n.nav > li.disabled > a:hover,\n.nav > li.disabled > a:focus {\n  color: #777777;\n  text-decoration: none;\n  background-color: transparent;\n  cursor: not-allowed;\n}\n.nav .open > a,\n.nav .open > a:hover,\n.nav .open > a:focus {\n  background-color: #eeeeee;\n  border-color: #337ab7;\n}\n.nav .nav-divider {\n  height: 1px;\n  margin: 8px 0;\n  overflow: hidden;\n  background-color: #e5e5e5;\n}\n.nav > li > a > img {\n  max-width: none;\n}\n.nav-tabs {\n  border-bottom: 1px solid #ddd;\n}\n.nav-tabs > li {\n  float: left;\n  margin-bottom: -1px;\n}\n.nav-tabs > li > a {\n  margin-right: 2px;\n  line-height: 1.42857143;\n  border: 1px solid transparent;\n  border-radius: 2px 2px 0 0;\n}\n.nav-tabs > li > a:hover {\n  border-color: #eeeeee #eeeeee #ddd;\n}\n.nav-tabs > li.active > a,\n.nav-tabs > li.active > a:hover,\n.nav-tabs > li.active > a:focus {\n  color: #555555;\n  background-color: #fff;\n  border: 1px solid #ddd;\n  border-bottom-color: transparent;\n  cursor: default;\n}\n.nav-tabs.nav-justified {\n  width: 100%;\n  border-bottom: 0;\n}\n.nav-tabs.nav-justified > li {\n  float: none;\n}\n.nav-tabs.nav-justified > li > a {\n  text-align: center;\n  margin-bottom: 5px;\n}\n.nav-tabs.nav-justified > .dropdown .dropdown-menu {\n  top: auto;\n  left: auto;\n}\n@media (min-width: 768px) {\n  .nav-tabs.nav-justified > li {\n    display: table-cell;\n    width: 1%;\n  }\n  .nav-tabs.nav-justified > li > a {\n    margin-bottom: 0;\n  }\n}\n.nav-tabs.nav-justified > li > a {\n  margin-right: 0;\n  border-radius: 2px;\n}\n.nav-tabs.nav-justified > .active > a,\n.nav-tabs.nav-justified > .active > a:hover,\n.nav-tabs.nav-justified > .active > a:focus {\n  border: 1px solid #ddd;\n}\n@media (min-width: 768px) {\n  .nav-tabs.nav-justified > li > a {\n    border-bottom: 1px solid #ddd;\n    border-radius: 2px 2px 0 0;\n  }\n  .nav-tabs.nav-justified > .active > a,\n  .nav-tabs.nav-justified > .active > a:hover,\n  .nav-tabs.nav-justified > .active > a:focus {\n    border-bottom-color: #fff;\n  }\n}\n.nav-pills > li {\n  float: left;\n}\n.nav-pills > li > a {\n  border-radius: 2px;\n}\n.nav-pills > li + li {\n  margin-left: 2px;\n}\n.nav-pills > li.active > a,\n.nav-pills > li.active > a:hover,\n.nav-pills > li.active > a:focus {\n  color: #fff;\n  background-color: #337ab7;\n}\n.nav-stacked > li {\n  float: none;\n}\n.nav-stacked > li + li {\n  margin-top: 2px;\n  margin-left: 0;\n}\n.nav-justified {\n  width: 100%;\n}\n.nav-justified > li {\n  float: none;\n}\n.nav-justified > li > a {\n  text-align: center;\n  margin-bottom: 5px;\n}\n.nav-justified > .dropdown .dropdown-menu {\n  top: auto;\n  left: auto;\n}\n@media (min-width: 768px) {\n  .nav-justified > li {\n    display: table-cell;\n    width: 1%;\n  }\n  .nav-justified > li > a {\n    margin-bottom: 0;\n  }\n}\n.nav-tabs-justified {\n  border-bottom: 0;\n}\n.nav-tabs-justified > li > a {\n  margin-right: 0;\n  border-radius: 2px;\n}\n.nav-tabs-justified > .active > a,\n.nav-tabs-justified > .active > a:hover,\n.nav-tabs-justified > .active > a:focus {\n  border: 1px solid #ddd;\n}\n@media (min-width: 768px) {\n  .nav-tabs-justified > li > a {\n    border-bottom: 1px solid #ddd;\n    border-radius: 2px 2px 0 0;\n  }\n  .nav-tabs-justified > .active > a,\n  .nav-tabs-justified > .active > a:hover,\n  .nav-tabs-justified > .active > a:focus {\n    border-bottom-color: #fff;\n  }\n}\n.tab-content > .tab-pane {\n  display: none;\n}\n.tab-content > .active {\n  display: block;\n}\n.nav-tabs .dropdown-menu {\n  margin-top: -1px;\n  border-top-right-radius: 0;\n  border-top-left-radius: 0;\n}\n.navbar {\n  position: relative;\n  min-height: 30px;\n  margin-bottom: 18px;\n  border: 1px solid transparent;\n}\n@media (min-width: 541px) {\n  .navbar {\n    border-radius: 2px;\n  }\n}\n@media (min-width: 541px) {\n  .navbar-header {\n    float: left;\n  }\n}\n.navbar-collapse {\n  overflow-x: visible;\n  padding-right: 0px;\n  padding-left: 0px;\n  border-top: 1px solid transparent;\n  box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.1);\n  -webkit-overflow-scrolling: touch;\n}\n.navbar-collapse.in {\n  overflow-y: auto;\n}\n@media (min-width: 541px) {\n  .navbar-collapse {\n    width: auto;\n    border-top: 0;\n    box-shadow: none;\n  }\n  .navbar-collapse.collapse {\n    display: block !important;\n    height: auto !important;\n    padding-bottom: 0;\n    overflow: visible !important;\n  }\n  .navbar-collapse.in {\n    overflow-y: visible;\n  }\n  .navbar-fixed-top .navbar-collapse,\n  .navbar-static-top .navbar-collapse,\n  .navbar-fixed-bottom .navbar-collapse {\n    padding-left: 0;\n    padding-right: 0;\n  }\n}\n.navbar-fixed-top .navbar-collapse,\n.navbar-fixed-bottom .navbar-collapse {\n  max-height: 340px;\n}\n@media (max-device-width: 540px) and (orientation: landscape) {\n  .navbar-fixed-top .navbar-collapse,\n  .navbar-fixed-bottom .navbar-collapse {\n    max-height: 200px;\n  }\n}\n.container > .navbar-header,\n.container-fluid > .navbar-header,\n.container > .navbar-collapse,\n.container-fluid > .navbar-collapse {\n  margin-right: 0px;\n  margin-left: 0px;\n}\n@media (min-width: 541px) {\n  .container > .navbar-header,\n  .container-fluid > .navbar-header,\n  .container > .navbar-collapse,\n  .container-fluid > .navbar-collapse {\n    margin-right: 0;\n    margin-left: 0;\n  }\n}\n.navbar-static-top {\n  z-index: 1000;\n  border-width: 0 0 1px;\n}\n@media (min-width: 541px) {\n  .navbar-static-top {\n    border-radius: 0;\n  }\n}\n.navbar-fixed-top,\n.navbar-fixed-bottom {\n  position: fixed;\n  right: 0;\n  left: 0;\n  z-index: 1030;\n}\n@media (min-width: 541px) {\n  .navbar-fixed-top,\n  .navbar-fixed-bottom {\n    border-radius: 0;\n  }\n}\n.navbar-fixed-top {\n  top: 0;\n  border-width: 0 0 1px;\n}\n.navbar-fixed-bottom {\n  bottom: 0;\n  margin-bottom: 0;\n  border-width: 1px 0 0;\n}\n.navbar-brand {\n  float: left;\n  padding: 6px 0px;\n  font-size: 17px;\n  line-height: 18px;\n  height: 30px;\n}\n.navbar-brand:hover,\n.navbar-brand:focus {\n  text-decoration: none;\n}\n.navbar-brand > img {\n  display: block;\n}\n@media (min-width: 541px) {\n  .navbar > .container .navbar-brand,\n  .navbar > .container-fluid .navbar-brand {\n    margin-left: 0px;\n  }\n}\n.navbar-toggle {\n  position: relative;\n  float: right;\n  margin-right: 0px;\n  padding: 9px 10px;\n  margin-top: -2px;\n  margin-bottom: -2px;\n  background-color: transparent;\n  background-image: none;\n  border: 1px solid transparent;\n  border-radius: 2px;\n}\n.navbar-toggle:focus {\n  outline: 0;\n}\n.navbar-toggle .icon-bar {\n  display: block;\n  width: 22px;\n  height: 2px;\n  border-radius: 1px;\n}\n.navbar-toggle .icon-bar + .icon-bar {\n  margin-top: 4px;\n}\n@media (min-width: 541px) {\n  .navbar-toggle {\n    display: none;\n  }\n}\n.navbar-nav {\n  margin: 3px 0px;\n}\n.navbar-nav > li > a {\n  padding-top: 10px;\n  padding-bottom: 10px;\n  line-height: 18px;\n}\n@media (max-width: 540px) {\n  .navbar-nav .open .dropdown-menu {\n    position: static;\n    float: none;\n    width: auto;\n    margin-top: 0;\n    background-color: transparent;\n    border: 0;\n    box-shadow: none;\n  }\n  .navbar-nav .open .dropdown-menu > li > a,\n  .navbar-nav .open .dropdown-menu .dropdown-header {\n    padding: 5px 15px 5px 25px;\n  }\n  .navbar-nav .open .dropdown-menu > li > a {\n    line-height: 18px;\n  }\n  .navbar-nav .open .dropdown-menu > li > a:hover,\n  .navbar-nav .open .dropdown-menu > li > a:focus {\n    background-image: none;\n  }\n}\n@media (min-width: 541px) {\n  .navbar-nav {\n    float: left;\n    margin: 0;\n  }\n  .navbar-nav > li {\n    float: left;\n  }\n  .navbar-nav > li > a {\n    padding-top: 6px;\n    padding-bottom: 6px;\n  }\n}\n.navbar-form {\n  margin-left: 0px;\n  margin-right: 0px;\n  padding: 10px 0px;\n  border-top: 1px solid transparent;\n  border-bottom: 1px solid transparent;\n  -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.1), 0 1px 0 rgba(255, 255, 255, 0.1);\n  box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.1), 0 1px 0 rgba(255, 255, 255, 0.1);\n  margin-top: -1px;\n  margin-bottom: -1px;\n}\n@media (min-width: 768px) {\n  .navbar-form .form-group {\n    display: inline-block;\n    margin-bottom: 0;\n    vertical-align: middle;\n  }\n  .navbar-form .form-control {\n    display: inline-block;\n    width: auto;\n    vertical-align: middle;\n  }\n  .navbar-form .form-control-static {\n    display: inline-block;\n  }\n  .navbar-form .input-group {\n    display: inline-table;\n    vertical-align: middle;\n  }\n  .navbar-form .input-group .input-group-addon,\n  .navbar-form .input-group .input-group-btn,\n  .navbar-form .input-group .form-control {\n    width: auto;\n  }\n  .navbar-form .input-group > .form-control {\n    width: 100%;\n  }\n  .navbar-form .control-label {\n    margin-bottom: 0;\n    vertical-align: middle;\n  }\n  .navbar-form .radio,\n  .navbar-form .checkbox {\n    display: inline-block;\n    margin-top: 0;\n    margin-bottom: 0;\n    vertical-align: middle;\n  }\n  .navbar-form .radio label,\n  .navbar-form .checkbox label {\n    padding-left: 0;\n  }\n  .navbar-form .radio input[type="radio"],\n  .navbar-form .checkbox input[type="checkbox"] {\n    position: relative;\n    margin-left: 0;\n  }\n  .navbar-form .has-feedback .form-control-feedback {\n    top: 0;\n  }\n}\n@media (max-width: 540px) {\n  .navbar-form .form-group {\n    margin-bottom: 5px;\n  }\n  .navbar-form .form-group:last-child {\n    margin-bottom: 0;\n  }\n}\n@media (min-width: 541px) {\n  .navbar-form {\n    width: auto;\n    border: 0;\n    margin-left: 0;\n    margin-right: 0;\n    padding-top: 0;\n    padding-bottom: 0;\n    -webkit-box-shadow: none;\n    box-shadow: none;\n  }\n}\n.navbar-nav > li > .dropdown-menu {\n  margin-top: 0;\n  border-top-right-radius: 0;\n  border-top-left-radius: 0;\n}\n.navbar-fixed-bottom .navbar-nav > li > .dropdown-menu {\n  margin-bottom: 0;\n  border-top-right-radius: 2px;\n  border-top-left-radius: 2px;\n  border-bottom-right-radius: 0;\n  border-bottom-left-radius: 0;\n}\n.navbar-btn {\n  margin-top: -1px;\n  margin-bottom: -1px;\n}\n.navbar-btn.btn-sm {\n  margin-top: 0px;\n  margin-bottom: 0px;\n}\n.navbar-btn.btn-xs {\n  margin-top: 4px;\n  margin-bottom: 4px;\n}\n.navbar-text {\n  margin-top: 6px;\n  margin-bottom: 6px;\n}\n@media (min-width: 541px) {\n  .navbar-text {\n    float: left;\n    margin-left: 0px;\n    margin-right: 0px;\n  }\n}\n@media (min-width: 541px) {\n  .navbar-left {\n    float: left !important;\n    float: left;\n  }\n  .navbar-right {\n    float: right !important;\n    float: right;\n    margin-right: 0px;\n  }\n  .navbar-right ~ .navbar-right {\n    margin-right: 0;\n  }\n}\n.navbar-default {\n  background-color: #f8f8f8;\n  border-color: #e7e7e7;\n}\n.navbar-default .navbar-brand {\n  color: #777;\n}\n.navbar-default .navbar-brand:hover,\n.navbar-default .navbar-brand:focus {\n  color: #5e5e5e;\n  background-color: transparent;\n}\n.navbar-default .navbar-text {\n  color: #777;\n}\n.navbar-default .navbar-nav > li > a {\n  color: #777;\n}\n.navbar-default .navbar-nav > li > a:hover,\n.navbar-default .navbar-nav > li > a:focus {\n  color: #333;\n  background-color: transparent;\n}\n.navbar-default .navbar-nav > .active > a,\n.navbar-default .navbar-nav > .active > a:hover,\n.navbar-default .navbar-nav > .active > a:focus {\n  color: #555;\n  background-color: #e7e7e7;\n}\n.navbar-default .navbar-nav > .disabled > a,\n.navbar-default .navbar-nav > .disabled > a:hover,\n.navbar-default .navbar-nav > .disabled > a:focus {\n  color: #ccc;\n  background-color: transparent;\n}\n.navbar-default .navbar-toggle {\n  border-color: #ddd;\n}\n.navbar-default .navbar-toggle:hover,\n.navbar-default .navbar-toggle:focus {\n  background-color: #ddd;\n}\n.navbar-default .navbar-toggle .icon-bar {\n  background-color: #888;\n}\n.navbar-default .navbar-collapse,\n.navbar-default .navbar-form {\n  border-color: #e7e7e7;\n}\n.navbar-default .navbar-nav > .open > a,\n.navbar-default .navbar-nav > .open > a:hover,\n.navbar-default .navbar-nav > .open > a:focus {\n  background-color: #e7e7e7;\n  color: #555;\n}\n@media (max-width: 540px) {\n  .navbar-default .navbar-nav .open .dropdown-menu > li > a {\n    color: #777;\n  }\n  .navbar-default .navbar-nav .open .dropdown-menu > li > a:hover,\n  .navbar-default .navbar-nav .open .dropdown-menu > li > a:focus {\n    color: #333;\n    background-color: transparent;\n  }\n  .navbar-default .navbar-nav .open .dropdown-menu > .active > a,\n  .navbar-default .navbar-nav .open .dropdown-menu > .active > a:hover,\n  .navbar-default .navbar-nav .open .dropdown-menu > .active > a:focus {\n    color: #555;\n    background-color: #e7e7e7;\n  }\n  .navbar-default .navbar-nav .open .dropdown-menu > .disabled > a,\n  .navbar-default .navbar-nav .open .dropdown-menu > .disabled > a:hover,\n  .navbar-default .navbar-nav .open .dropdown-menu > .disabled > a:focus {\n    color: #ccc;\n    background-color: transparent;\n  }\n}\n.navbar-default .navbar-link {\n  color: #777;\n}\n.navbar-default .navbar-link:hover {\n  color: #333;\n}\n.navbar-default .btn-link {\n  color: #777;\n}\n.navbar-default .btn-link:hover,\n.navbar-default .btn-link:focus {\n  color: #333;\n}\n.navbar-default .btn-link[disabled]:hover,\nfieldset[disabled] .navbar-default .btn-link:hover,\n.navbar-default .btn-link[disabled]:focus,\nfieldset[disabled] .navbar-default .btn-link:focus {\n  color: #ccc;\n}\n.navbar-inverse {\n  background-color: #222;\n  border-color: #080808;\n}\n.navbar-inverse .navbar-brand {\n  color: #9d9d9d;\n}\n.navbar-inverse .navbar-brand:hover,\n.navbar-inverse .navbar-brand:focus {\n  color: #fff;\n  background-color: transparent;\n}\n.navbar-inverse .navbar-text {\n  color: #9d9d9d;\n}\n.navbar-inverse .navbar-nav > li > a {\n  color: #9d9d9d;\n}\n.navbar-inverse .navbar-nav > li > a:hover,\n.navbar-inverse .navbar-nav > li > a:focus {\n  color: #fff;\n  background-color: transparent;\n}\n.navbar-inverse .navbar-nav > .active > a,\n.navbar-inverse .navbar-nav > .active > a:hover,\n.navbar-inverse .navbar-nav > .active > a:focus {\n  color: #fff;\n  background-color: #080808;\n}\n.navbar-inverse .navbar-nav > .disabled > a,\n.navbar-inverse .navbar-nav > .disabled > a:hover,\n.navbar-inverse .navbar-nav > .disabled > a:focus {\n  color: #444;\n  background-color: transparent;\n}\n.navbar-inverse .navbar-toggle {\n  border-color: #333;\n}\n.navbar-inverse .navbar-toggle:hover,\n.navbar-inverse .navbar-toggle:focus {\n  background-color: #333;\n}\n.navbar-inverse .navbar-toggle .icon-bar {\n  background-color: #fff;\n}\n.navbar-inverse .navbar-collapse,\n.navbar-inverse .navbar-form {\n  border-color: #101010;\n}\n.navbar-inverse .navbar-nav > .open > a,\n.navbar-inverse .navbar-nav > .open > a:hover,\n.navbar-inverse .navbar-nav > .open > a:focus {\n  background-color: #080808;\n  color: #fff;\n}\n@media (max-width: 540px) {\n  .navbar-inverse .navbar-nav .open .dropdown-menu > .dropdown-header {\n    border-color: #080808;\n  }\n  .navbar-inverse .navbar-nav .open .dropdown-menu .divider {\n    background-color: #080808;\n  }\n  .navbar-inverse .navbar-nav .open .dropdown-menu > li > a {\n    color: #9d9d9d;\n  }\n  .navbar-inverse .navbar-nav .open .dropdown-menu > li > a:hover,\n  .navbar-inverse .navbar-nav .open .dropdown-menu > li > a:focus {\n    color: #fff;\n    background-color: transparent;\n  }\n  .navbar-inverse .navbar-nav .open .dropdown-menu > .active > a,\n  .navbar-inverse .navbar-nav .open .dropdown-menu > .active > a:hover,\n  .navbar-inverse .navbar-nav .open .dropdown-menu > .active > a:focus {\n    color: #fff;\n    background-color: #080808;\n  }\n  .navbar-inverse .navbar-nav .open .dropdown-menu > .disabled > a,\n  .navbar-inverse .navbar-nav .open .dropdown-menu > .disabled > a:hover,\n  .navbar-inverse .navbar-nav .open .dropdown-menu > .disabled > a:focus {\n    color: #444;\n    background-color: transparent;\n  }\n}\n.navbar-inverse .navbar-link {\n  color: #9d9d9d;\n}\n.navbar-inverse .navbar-link:hover {\n  color: #fff;\n}\n.navbar-inverse .btn-link {\n  color: #9d9d9d;\n}\n.navbar-inverse .btn-link:hover,\n.navbar-inverse .btn-link:focus {\n  color: #fff;\n}\n.navbar-inverse .btn-link[disabled]:hover,\nfieldset[disabled] .navbar-inverse .btn-link:hover,\n.navbar-inverse .btn-link[disabled]:focus,\nfieldset[disabled] .navbar-inverse .btn-link:focus {\n  color: #444;\n}\n.breadcrumb {\n  padding: 8px 15px;\n  margin-bottom: 18px;\n  list-style: none;\n  background-color: #f5f5f5;\n  border-radius: 2px;\n}\n.breadcrumb > li {\n  display: inline-block;\n}\n.breadcrumb > li + li:before {\n  content: "/\\00a0";\n  padding: 0 5px;\n  color: #5e5e5e;\n}\n.breadcrumb > .active {\n  color: #777777;\n}\n.pagination {\n  display: inline-block;\n  padding-left: 0;\n  margin: 18px 0;\n  border-radius: 2px;\n}\n.pagination > li {\n  display: inline;\n}\n.pagination > li > a,\n.pagination > li > span {\n  position: relative;\n  float: left;\n  padding: 6px 12px;\n  line-height: 1.42857143;\n  text-decoration: none;\n  color: #337ab7;\n  background-color: #fff;\n  border: 1px solid #ddd;\n  margin-left: -1px;\n}\n.pagination > li:first-child > a,\n.pagination > li:first-child > span {\n  margin-left: 0;\n  border-bottom-left-radius: 2px;\n  border-top-left-radius: 2px;\n}\n.pagination > li:last-child > a,\n.pagination > li:last-child > span {\n  border-bottom-right-radius: 2px;\n  border-top-right-radius: 2px;\n}\n.pagination > li > a:hover,\n.pagination > li > span:hover,\n.pagination > li > a:focus,\n.pagination > li > span:focus {\n  z-index: 2;\n  color: #23527c;\n  background-color: #eeeeee;\n  border-color: #ddd;\n}\n.pagination > .active > a,\n.pagination > .active > span,\n.pagination > .active > a:hover,\n.pagination > .active > span:hover,\n.pagination > .active > a:focus,\n.pagination > .active > span:focus {\n  z-index: 3;\n  color: #fff;\n  background-color: #337ab7;\n  border-color: #337ab7;\n  cursor: default;\n}\n.pagination > .disabled > span,\n.pagination > .disabled > span:hover,\n.pagination > .disabled > span:focus,\n.pagination > .disabled > a,\n.pagination > .disabled > a:hover,\n.pagination > .disabled > a:focus {\n  color: #777777;\n  background-color: #fff;\n  border-color: #ddd;\n  cursor: not-allowed;\n}\n.pagination-lg > li > a,\n.pagination-lg > li > span {\n  padding: 10px 16px;\n  font-size: 17px;\n  line-height: 1.3333333;\n}\n.pagination-lg > li:first-child > a,\n.pagination-lg > li:first-child > span {\n  border-bottom-left-radius: 3px;\n  border-top-left-radius: 3px;\n}\n.pagination-lg > li:last-child > a,\n.pagination-lg > li:last-child > span {\n  border-bottom-right-radius: 3px;\n  border-top-right-radius: 3px;\n}\n.pagination-sm > li > a,\n.pagination-sm > li > span {\n  padding: 5px 10px;\n  font-size: 12px;\n  line-height: 1.5;\n}\n.pagination-sm > li:first-child > a,\n.pagination-sm > li:first-child > span {\n  border-bottom-left-radius: 1px;\n  border-top-left-radius: 1px;\n}\n.pagination-sm > li:last-child > a,\n.pagination-sm > li:last-child > span {\n  border-bottom-right-radius: 1px;\n  border-top-right-radius: 1px;\n}\n.pager {\n  padding-left: 0;\n  margin: 18px 0;\n  list-style: none;\n  text-align: center;\n}\n.pager li {\n  display: inline;\n}\n.pager li > a,\n.pager li > span {\n  display: inline-block;\n  padding: 5px 14px;\n  background-color: #fff;\n  border: 1px solid #ddd;\n  border-radius: 15px;\n}\n.pager li > a:hover,\n.pager li > a:focus {\n  text-decoration: none;\n  background-color: #eeeeee;\n}\n.pager .next > a,\n.pager .next > span {\n  float: right;\n}\n.pager .previous > a,\n.pager .previous > span {\n  float: left;\n}\n.pager .disabled > a,\n.pager .disabled > a:hover,\n.pager .disabled > a:focus,\n.pager .disabled > span {\n  color: #777777;\n  background-color: #fff;\n  cursor: not-allowed;\n}\n.label {\n  display: inline;\n  padding: .2em .6em .3em;\n  font-size: 75%;\n  font-weight: bold;\n  line-height: 1;\n  color: #fff;\n  text-align: center;\n  white-space: nowrap;\n  vertical-align: baseline;\n  border-radius: .25em;\n}\na.label:hover,\na.label:focus {\n  color: #fff;\n  text-decoration: none;\n  cursor: pointer;\n}\n.label:empty {\n  display: none;\n}\n.btn .label {\n  position: relative;\n  top: -1px;\n}\n.label-default {\n  background-color: #777777;\n}\n.label-default[href]:hover,\n.label-default[href]:focus {\n  background-color: #5e5e5e;\n}\n.label-primary {\n  background-color: #337ab7;\n}\n.label-primary[href]:hover,\n.label-primary[href]:focus {\n  background-color: #286090;\n}\n.label-success {\n  background-color: #5cb85c;\n}\n.label-success[href]:hover,\n.label-success[href]:focus {\n  background-color: #449d44;\n}\n.label-info {\n  background-color: #5bc0de;\n}\n.label-info[href]:hover,\n.label-info[href]:focus {\n  background-color: #31b0d5;\n}\n.label-warning {\n  background-color: #f0ad4e;\n}\n.label-warning[href]:hover,\n.label-warning[href]:focus {\n  background-color: #ec971f;\n}\n.label-danger {\n  background-color: #d9534f;\n}\n.label-danger[href]:hover,\n.label-danger[href]:focus {\n  background-color: #c9302c;\n}\n.badge {\n  display: inline-block;\n  min-width: 10px;\n  padding: 3px 7px;\n  font-size: 12px;\n  font-weight: bold;\n  color: #fff;\n  line-height: 1;\n  vertical-align: middle;\n  white-space: nowrap;\n  text-align: center;\n  background-color: #777777;\n  border-radius: 10px;\n}\n.badge:empty {\n  display: none;\n}\n.btn .badge {\n  position: relative;\n  top: -1px;\n}\n.btn-xs .badge,\n.btn-group-xs > .btn .badge {\n  top: 0;\n  padding: 1px 5px;\n}\na.badge:hover,\na.badge:focus {\n  color: #fff;\n  text-decoration: none;\n  cursor: pointer;\n}\n.list-group-item.active > .badge,\n.nav-pills > .active > a > .badge {\n  color: #337ab7;\n  background-color: #fff;\n}\n.list-group-item > .badge {\n  float: right;\n}\n.list-group-item > .badge + .badge {\n  margin-right: 5px;\n}\n.nav-pills > li > a > .badge {\n  margin-left: 3px;\n}\n.jumbotron {\n  padding-top: 30px;\n  padding-bottom: 30px;\n  margin-bottom: 30px;\n  color: inherit;\n  background-color: #eeeeee;\n}\n.jumbotron h1,\n.jumbotron .h1 {\n  color: inherit;\n}\n.jumbotron p {\n  margin-bottom: 15px;\n  font-size: 20px;\n  font-weight: 200;\n}\n.jumbotron > hr {\n  border-top-color: #d5d5d5;\n}\n.container .jumbotron,\n.container-fluid .jumbotron {\n  border-radius: 3px;\n  padding-left: 0px;\n  padding-right: 0px;\n}\n.jumbotron .container {\n  max-width: 100%;\n}\n@media screen and (min-width: 768px) {\n  .jumbotron {\n    padding-top: 48px;\n    padding-bottom: 48px;\n  }\n  .container .jumbotron,\n  .container-fluid .jumbotron {\n    padding-left: 60px;\n    padding-right: 60px;\n  }\n  .jumbotron h1,\n  .jumbotron .h1 {\n    font-size: 59px;\n  }\n}\n.thumbnail {\n  display: block;\n  padding: 4px;\n  margin-bottom: 18px;\n  line-height: 1.42857143;\n  background-color: #fff;\n  border: 1px solid #ddd;\n  border-radius: 2px;\n  -webkit-transition: border 0.2s ease-in-out;\n  -o-transition: border 0.2s ease-in-out;\n  transition: border 0.2s ease-in-out;\n}\n.thumbnail > img,\n.thumbnail a > img {\n  margin-left: auto;\n  margin-right: auto;\n}\na.thumbnail:hover,\na.thumbnail:focus,\na.thumbnail.active {\n  border-color: #337ab7;\n}\n.thumbnail .caption {\n  padding: 9px;\n  color: #000;\n}\n.alert {\n  padding: 15px;\n  margin-bottom: 18px;\n  border: 1px solid transparent;\n  border-radius: 2px;\n}\n.alert h4 {\n  margin-top: 0;\n  color: inherit;\n}\n.alert .alert-link {\n  font-weight: bold;\n}\n.alert > p,\n.alert > ul {\n  margin-bottom: 0;\n}\n.alert > p + p {\n  margin-top: 5px;\n}\n.alert-dismissable,\n.alert-dismissible {\n  padding-right: 35px;\n}\n.alert-dismissable .close,\n.alert-dismissible .close {\n  position: relative;\n  top: -2px;\n  right: -21px;\n  color: inherit;\n}\n.alert-success {\n  background-color: #dff0d8;\n  border-color: #d6e9c6;\n  color: #3c763d;\n}\n.alert-success hr {\n  border-top-color: #c9e2b3;\n}\n.alert-success .alert-link {\n  color: #2b542c;\n}\n.alert-info {\n  background-color: #d9edf7;\n  border-color: #bce8f1;\n  color: #31708f;\n}\n.alert-info hr {\n  border-top-color: #a6e1ec;\n}\n.alert-info .alert-link {\n  color: #245269;\n}\n.alert-warning {\n  background-color: #fcf8e3;\n  border-color: #faebcc;\n  color: #8a6d3b;\n}\n.alert-warning hr {\n  border-top-color: #f7e1b5;\n}\n.alert-warning .alert-link {\n  color: #66512c;\n}\n.alert-danger {\n  background-color: #f2dede;\n  border-color: #ebccd1;\n  color: #a94442;\n}\n.alert-danger hr {\n  border-top-color: #e4b9c0;\n}\n.alert-danger .alert-link {\n  color: #843534;\n}\n@-webkit-keyframes progress-bar-stripes {\n  from {\n    background-position: 40px 0;\n  }\n  to {\n    background-position: 0 0;\n  }\n}\n@keyframes progress-bar-stripes {\n  from {\n    background-position: 40px 0;\n  }\n  to {\n    background-position: 0 0;\n  }\n}\n.progress {\n  overflow: hidden;\n  height: 18px;\n  margin-bottom: 18px;\n  background-color: #f5f5f5;\n  border-radius: 2px;\n  -webkit-box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.1);\n  box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.1);\n}\n.progress-bar {\n  float: left;\n  width: 0%;\n  height: 100%;\n  font-size: 12px;\n  line-height: 18px;\n  color: #fff;\n  text-align: center;\n  background-color: #337ab7;\n  -webkit-box-shadow: inset 0 -1px 0 rgba(0, 0, 0, 0.15);\n  box-shadow: inset 0 -1px 0 rgba(0, 0, 0, 0.15);\n  -webkit-transition: width 0.6s ease;\n  -o-transition: width 0.6s ease;\n  transition: width 0.6s ease;\n}\n.progress-striped .progress-bar,\n.progress-bar-striped {\n  background-image: -webkit-linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);\n  background-image: -o-linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);\n  background-image: linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);\n  background-size: 40px 40px;\n}\n.progress.active .progress-bar,\n.progress-bar.active {\n  -webkit-animation: progress-bar-stripes 2s linear infinite;\n  -o-animation: progress-bar-stripes 2s linear infinite;\n  animation: progress-bar-stripes 2s linear infinite;\n}\n.progress-bar-success {\n  background-color: #5cb85c;\n}\n.progress-striped .progress-bar-success {\n  background-image: -webkit-linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);\n  background-image: -o-linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);\n  background-image: linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);\n}\n.progress-bar-info {\n  background-color: #5bc0de;\n}\n.progress-striped .progress-bar-info {\n  background-image: -webkit-linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);\n  background-image: -o-linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);\n  background-image: linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);\n}\n.progress-bar-warning {\n  background-color: #f0ad4e;\n}\n.progress-striped .progress-bar-warning {\n  background-image: -webkit-linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);\n  background-image: -o-linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);\n  background-image: linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);\n}\n.progress-bar-danger {\n  background-color: #d9534f;\n}\n.progress-striped .progress-bar-danger {\n  background-image: -webkit-linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);\n  background-image: -o-linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);\n  background-image: linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);\n}\n.media {\n  margin-top: 15px;\n}\n.media:first-child {\n  margin-top: 0;\n}\n.media,\n.media-body {\n  zoom: 1;\n  overflow: hidden;\n}\n.media-body {\n  width: 10000px;\n}\n.media-object {\n  display: block;\n}\n.media-object.img-thumbnail {\n  max-width: none;\n}\n.media-right,\n.media > .pull-right {\n  padding-left: 10px;\n}\n.media-left,\n.media > .pull-left {\n  padding-right: 10px;\n}\n.media-left,\n.media-right,\n.media-body {\n  display: table-cell;\n  vertical-align: top;\n}\n.media-middle {\n  vertical-align: middle;\n}\n.media-bottom {\n  vertical-align: bottom;\n}\n.media-heading {\n  margin-top: 0;\n  margin-bottom: 5px;\n}\n.media-list {\n  padding-left: 0;\n  list-style: none;\n}\n.list-group {\n  margin-bottom: 20px;\n  padding-left: 0;\n}\n.list-group-item {\n  position: relative;\n  display: block;\n  padding: 10px 15px;\n  margin-bottom: -1px;\n  background-color: #fff;\n  border: 1px solid #ddd;\n}\n.list-group-item:first-child {\n  border-top-right-radius: 2px;\n  border-top-left-radius: 2px;\n}\n.list-group-item:last-child {\n  margin-bottom: 0;\n  border-bottom-right-radius: 2px;\n  border-bottom-left-radius: 2px;\n}\na.list-group-item,\nbutton.list-group-item {\n  color: #555;\n}\na.list-group-item .list-group-item-heading,\nbutton.list-group-item .list-group-item-heading {\n  color: #333;\n}\na.list-group-item:hover,\nbutton.list-group-item:hover,\na.list-group-item:focus,\nbutton.list-group-item:focus {\n  text-decoration: none;\n  color: #555;\n  background-color: #f5f5f5;\n}\nbutton.list-group-item {\n  width: 100%;\n  text-align: left;\n}\n.list-group-item.disabled,\n.list-group-item.disabled:hover,\n.list-group-item.disabled:focus {\n  background-color: #eeeeee;\n  color: #777777;\n  cursor: not-allowed;\n}\n.list-group-item.disabled .list-group-item-heading,\n.list-group-item.disabled:hover .list-group-item-heading,\n.list-group-item.disabled:focus .list-group-item-heading {\n  color: inherit;\n}\n.list-group-item.disabled .list-group-item-text,\n.list-group-item.disabled:hover .list-group-item-text,\n.list-group-item.disabled:focus .list-group-item-text {\n  color: #777777;\n}\n.list-group-item.active,\n.list-group-item.active:hover,\n.list-group-item.active:focus {\n  z-index: 2;\n  color: #fff;\n  background-color: #337ab7;\n  border-color: #337ab7;\n}\n.list-group-item.active .list-group-item-heading,\n.list-group-item.active:hover .list-group-item-heading,\n.list-group-item.active:focus .list-group-item-heading,\n.list-group-item.active .list-group-item-heading > small,\n.list-group-item.active:hover .list-group-item-heading > small,\n.list-group-item.active:focus .list-group-item-heading > small,\n.list-group-item.active .list-group-item-heading > .small,\n.list-group-item.active:hover .list-group-item-heading > .small,\n.list-group-item.active:focus .list-group-item-heading > .small {\n  color: inherit;\n}\n.list-group-item.active .list-group-item-text,\n.list-group-item.active:hover .list-group-item-text,\n.list-group-item.active:focus .list-group-item-text {\n  color: #c7ddef;\n}\n.list-group-item-success {\n  color: #3c763d;\n  background-color: #dff0d8;\n}\na.list-group-item-success,\nbutton.list-group-item-success {\n  color: #3c763d;\n}\na.list-group-item-success .list-group-item-heading,\nbutton.list-group-item-success .list-group-item-heading {\n  color: inherit;\n}\na.list-group-item-success:hover,\nbutton.list-group-item-success:hover,\na.list-group-item-success:focus,\nbutton.list-group-item-success:focus {\n  color: #3c763d;\n  background-color: #d0e9c6;\n}\na.list-group-item-success.active,\nbutton.list-group-item-success.active,\na.list-group-item-success.active:hover,\nbutton.list-group-item-success.active:hover,\na.list-group-item-success.active:focus,\nbutton.list-group-item-success.active:focus {\n  color: #fff;\n  background-color: #3c763d;\n  border-color: #3c763d;\n}\n.list-group-item-info {\n  color: #31708f;\n  background-color: #d9edf7;\n}\na.list-group-item-info,\nbutton.list-group-item-info {\n  color: #31708f;\n}\na.list-group-item-info .list-group-item-heading,\nbutton.list-group-item-info .list-group-item-heading {\n  color: inherit;\n}\na.list-group-item-info:hover,\nbutton.list-group-item-info:hover,\na.list-group-item-info:focus,\nbutton.list-group-item-info:focus {\n  color: #31708f;\n  background-color: #c4e3f3;\n}\na.list-group-item-info.active,\nbutton.list-group-item-info.active,\na.list-group-item-info.active:hover,\nbutton.list-group-item-info.active:hover,\na.list-group-item-info.active:focus,\nbutton.list-group-item-info.active:focus {\n  color: #fff;\n  background-color: #31708f;\n  border-color: #31708f;\n}\n.list-group-item-warning {\n  color: #8a6d3b;\n  background-color: #fcf8e3;\n}\na.list-group-item-warning,\nbutton.list-group-item-warning {\n  color: #8a6d3b;\n}\na.list-group-item-warning .list-group-item-heading,\nbutton.list-group-item-warning .list-group-item-heading {\n  color: inherit;\n}\na.list-group-item-warning:hover,\nbutton.list-group-item-warning:hover,\na.list-group-item-warning:focus,\nbutton.list-group-item-warning:focus {\n  color: #8a6d3b;\n  background-color: #faf2cc;\n}\na.list-group-item-warning.active,\nbutton.list-group-item-warning.active,\na.list-group-item-warning.active:hover,\nbutton.list-group-item-warning.active:hover,\na.list-group-item-warning.active:focus,\nbutton.list-group-item-warning.active:focus {\n  color: #fff;\n  background-color: #8a6d3b;\n  border-color: #8a6d3b;\n}\n.list-group-item-danger {\n  color: #a94442;\n  background-color: #f2dede;\n}\na.list-group-item-danger,\nbutton.list-group-item-danger {\n  color: #a94442;\n}\na.list-group-item-danger .list-group-item-heading,\nbutton.list-group-item-danger .list-group-item-heading {\n  color: inherit;\n}\na.list-group-item-danger:hover,\nbutton.list-group-item-danger:hover,\na.list-group-item-danger:focus,\nbutton.list-group-item-danger:focus {\n  color: #a94442;\n  background-color: #ebcccc;\n}\na.list-group-item-danger.active,\nbutton.list-group-item-danger.active,\na.list-group-item-danger.active:hover,\nbutton.list-group-item-danger.active:hover,\na.list-group-item-danger.active:focus,\nbutton.list-group-item-danger.active:focus {\n  color: #fff;\n  background-color: #a94442;\n  border-color: #a94442;\n}\n.list-group-item-heading {\n  margin-top: 0;\n  margin-bottom: 5px;\n}\n.list-group-item-text {\n  margin-bottom: 0;\n  line-height: 1.3;\n}\n.panel {\n  margin-bottom: 18px;\n  background-color: #fff;\n  border: 1px solid transparent;\n  border-radius: 2px;\n  -webkit-box-shadow: 0 1px 1px rgba(0, 0, 0, 0.05);\n  box-shadow: 0 1px 1px rgba(0, 0, 0, 0.05);\n}\n.panel-body {\n  padding: 15px;\n}\n.panel-heading {\n  padding: 10px 15px;\n  border-bottom: 1px solid transparent;\n  border-top-right-radius: 1px;\n  border-top-left-radius: 1px;\n}\n.panel-heading > .dropdown .dropdown-toggle {\n  color: inherit;\n}\n.panel-title {\n  margin-top: 0;\n  margin-bottom: 0;\n  font-size: 15px;\n  color: inherit;\n}\n.panel-title > a,\n.panel-title > small,\n.panel-title > .small,\n.panel-title > small > a,\n.panel-title > .small > a {\n  color: inherit;\n}\n.panel-footer {\n  padding: 10px 15px;\n  background-color: #f5f5f5;\n  border-top: 1px solid #ddd;\n  border-bottom-right-radius: 1px;\n  border-bottom-left-radius: 1px;\n}\n.panel > .list-group,\n.panel > .panel-collapse > .list-group {\n  margin-bottom: 0;\n}\n.panel > .list-group .list-group-item,\n.panel > .panel-collapse > .list-group .list-group-item {\n  border-width: 1px 0;\n  border-radius: 0;\n}\n.panel > .list-group:first-child .list-group-item:first-child,\n.panel > .panel-collapse > .list-group:first-child .list-group-item:first-child {\n  border-top: 0;\n  border-top-right-radius: 1px;\n  border-top-left-radius: 1px;\n}\n.panel > .list-group:last-child .list-group-item:last-child,\n.panel > .panel-collapse > .list-group:last-child .list-group-item:last-child {\n  border-bottom: 0;\n  border-bottom-right-radius: 1px;\n  border-bottom-left-radius: 1px;\n}\n.panel > .panel-heading + .panel-collapse > .list-group .list-group-item:first-child {\n  border-top-right-radius: 0;\n  border-top-left-radius: 0;\n}\n.panel-heading + .list-group .list-group-item:first-child {\n  border-top-width: 0;\n}\n.list-group + .panel-footer {\n  border-top-width: 0;\n}\n.panel > .table,\n.panel > .table-responsive > .table,\n.panel > .panel-collapse > .table {\n  margin-bottom: 0;\n}\n.panel > .table caption,\n.panel > .table-responsive > .table caption,\n.panel > .panel-collapse > .table caption {\n  padding-left: 15px;\n  padding-right: 15px;\n}\n.panel > .table:first-child,\n.panel > .table-responsive:first-child > .table:first-child {\n  border-top-right-radius: 1px;\n  border-top-left-radius: 1px;\n}\n.panel > .table:first-child > thead:first-child > tr:first-child,\n.panel > .table-responsive:first-child > .table:first-child > thead:first-child > tr:first-child,\n.panel > .table:first-child > tbody:first-child > tr:first-child,\n.panel > .table-responsive:first-child > .table:first-child > tbody:first-child > tr:first-child {\n  border-top-left-radius: 1px;\n  border-top-right-radius: 1px;\n}\n.panel > .table:first-child > thead:first-child > tr:first-child td:first-child,\n.panel > .table-responsive:first-child > .table:first-child > thead:first-child > tr:first-child td:first-child,\n.panel > .table:first-child > tbody:first-child > tr:first-child td:first-child,\n.panel > .table-responsive:first-child > .table:first-child > tbody:first-child > tr:first-child td:first-child,\n.panel > .table:first-child > thead:first-child > tr:first-child th:first-child,\n.panel > .table-responsive:first-child > .table:first-child > thead:first-child > tr:first-child th:first-child,\n.panel > .table:first-child > tbody:first-child > tr:first-child th:first-child,\n.panel > .table-responsive:first-child > .table:first-child > tbody:first-child > tr:first-child th:first-child {\n  border-top-left-radius: 1px;\n}\n.panel > .table:first-child > thead:first-child > tr:first-child td:last-child,\n.panel > .table-responsive:first-child > .table:first-child > thead:first-child > tr:first-child td:last-child,\n.panel > .table:first-child > tbody:first-child > tr:first-child td:last-child,\n.panel > .table-responsive:first-child > .table:first-child > tbody:first-child > tr:first-child td:last-child,\n.panel > .table:first-child > thead:first-child > tr:first-child th:last-child,\n.panel > .table-responsive:first-child > .table:first-child > thead:first-child > tr:first-child th:last-child,\n.panel > .table:first-child > tbody:first-child > tr:first-child th:last-child,\n.panel > .table-responsive:first-child > .table:first-child > tbody:first-child > tr:first-child th:last-child {\n  border-top-right-radius: 1px;\n}\n.panel > .table:last-child,\n.panel > .table-responsive:last-child > .table:last-child {\n  border-bottom-right-radius: 1px;\n  border-bottom-left-radius: 1px;\n}\n.panel > .table:last-child > tbody:last-child > tr:last-child,\n.panel > .table-responsive:last-child > .table:last-child > tbody:last-child > tr:last-child,\n.panel > .table:last-child > tfoot:last-child > tr:last-child,\n.panel > .table-responsive:last-child > .table:last-child > tfoot:last-child > tr:last-child {\n  border-bottom-left-radius: 1px;\n  border-bottom-right-radius: 1px;\n}\n.panel > .table:last-child > tbody:last-child > tr:last-child td:first-child,\n.panel > .table-responsive:last-child > .table:last-child > tbody:last-child > tr:last-child td:first-child,\n.panel > .table:last-child > tfoot:last-child > tr:last-child td:first-child,\n.panel > .table-responsive:last-child > .table:last-child > tfoot:last-child > tr:last-child td:first-child,\n.panel > .table:last-child > tbody:last-child > tr:last-child th:first-child,\n.panel > .table-responsive:last-child > .table:last-child > tbody:last-child > tr:last-child th:first-child,\n.panel > .table:last-child > tfoot:last-child > tr:last-child th:first-child,\n.panel > .table-responsive:last-child > .table:last-child > tfoot:last-child > tr:last-child th:first-child {\n  border-bottom-left-radius: 1px;\n}\n.panel > .table:last-child > tbody:last-child > tr:last-child td:last-child,\n.panel > .table-responsive:last-child > .table:last-child > tbody:last-child > tr:last-child td:last-child,\n.panel > .table:last-child > tfoot:last-child > tr:last-child td:last-child,\n.panel > .table-responsive:last-child > .table:last-child > tfoot:last-child > tr:last-child td:last-child,\n.panel > .table:last-child > tbody:last-child > tr:last-child th:last-child,\n.panel > .table-responsive:last-child > .table:last-child > tbody:last-child > tr:last-child th:last-child,\n.panel > .table:last-child > tfoot:last-child > tr:last-child th:last-child,\n.panel > .table-responsive:last-child > .table:last-child > tfoot:last-child > tr:last-child th:last-child {\n  border-bottom-right-radius: 1px;\n}\n.panel > .panel-body + .table,\n.panel > .panel-body + .table-responsive,\n.panel > .table + .panel-body,\n.panel > .table-responsive + .panel-body {\n  border-top: 1px solid #ddd;\n}\n.panel > .table > tbody:first-child > tr:first-child th,\n.panel > .table > tbody:first-child > tr:first-child td {\n  border-top: 0;\n}\n.panel > .table-bordered,\n.panel > .table-responsive > .table-bordered {\n  border: 0;\n}\n.panel > .table-bordered > thead > tr > th:first-child,\n.panel > .table-responsive > .table-bordered > thead > tr > th:first-child,\n.panel > .table-bordered > tbody > tr > th:first-child,\n.panel > .table-responsive > .table-bordered > tbody > tr > th:first-child,\n.panel > .table-bordered > tfoot > tr > th:first-child,\n.panel > .table-responsive > .table-bordered > tfoot > tr > th:first-child,\n.panel > .table-bordered > thead > tr > td:first-child,\n.panel > .table-responsive > .table-bordered > thead > tr > td:first-child,\n.panel > .table-bordered > tbody > tr > td:first-child,\n.panel > .table-responsive > .table-bordered > tbody > tr > td:first-child,\n.panel > .table-bordered > tfoot > tr > td:first-child,\n.panel > .table-responsive > .table-bordered > tfoot > tr > td:first-child {\n  border-left: 0;\n}\n.panel > .table-bordered > thead > tr > th:last-child,\n.panel > .table-responsive > .table-bordered > thead > tr > th:last-child,\n.panel > .table-bordered > tbody > tr > th:last-child,\n.panel > .table-responsive > .table-bordered > tbody > tr > th:last-child,\n.panel > .table-bordered > tfoot > tr > th:last-child,\n.panel > .table-responsive > .table-bordered > tfoot > tr > th:last-child,\n.panel > .table-bordered > thead > tr > td:last-child,\n.panel > .table-responsive > .table-bordered > thead > tr > td:last-child,\n.panel > .table-bordered > tbody > tr > td:last-child,\n.panel > .table-responsive > .table-bordered > tbody > tr > td:last-child,\n.panel > .table-bordered > tfoot > tr > td:last-child,\n.panel > .table-responsive > .table-bordered > tfoot > tr > td:last-child {\n  border-right: 0;\n}\n.panel > .table-bordered > thead > tr:first-child > td,\n.panel > .table-responsive > .table-bordered > thead > tr:first-child > td,\n.panel > .table-bordered > tbody > tr:first-child > td,\n.panel > .table-responsive > .table-bordered > tbody > tr:first-child > td,\n.panel > .table-bordered > thead > tr:first-child > th,\n.panel > .table-responsive > .table-bordered > thead > tr:first-child > th,\n.panel > .table-bordered > tbody > tr:first-child > th,\n.panel > .table-responsive > .table-bordered > tbody > tr:first-child > th {\n  border-bottom: 0;\n}\n.panel > .table-bordered > tbody > tr:last-child > td,\n.panel > .table-responsive > .table-bordered > tbody > tr:last-child > td,\n.panel > .table-bordered > tfoot > tr:last-child > td,\n.panel > .table-responsive > .table-bordered > tfoot > tr:last-child > td,\n.panel > .table-bordered > tbody > tr:last-child > th,\n.panel > .table-responsive > .table-bordered > tbody > tr:last-child > th,\n.panel > .table-bordered > tfoot > tr:last-child > th,\n.panel > .table-responsive > .table-bordered > tfoot > tr:last-child > th {\n  border-bottom: 0;\n}\n.panel > .table-responsive {\n  border: 0;\n  margin-bottom: 0;\n}\n.panel-group {\n  margin-bottom: 18px;\n}\n.panel-group .panel {\n  margin-bottom: 0;\n  border-radius: 2px;\n}\n.panel-group .panel + .panel {\n  margin-top: 5px;\n}\n.panel-group .panel-heading {\n  border-bottom: 0;\n}\n.panel-group .panel-heading + .panel-collapse > .panel-body,\n.panel-group .panel-heading + .panel-collapse > .list-group {\n  border-top: 1px solid #ddd;\n}\n.panel-group .panel-footer {\n  border-top: 0;\n}\n.panel-group .panel-footer + .panel-collapse .panel-body {\n  border-bottom: 1px solid #ddd;\n}\n.panel-default {\n  border-color: #ddd;\n}\n.panel-default > .panel-heading {\n  color: #333333;\n  background-color: #f5f5f5;\n  border-color: #ddd;\n}\n.panel-default > .panel-heading + .panel-collapse > .panel-body {\n  border-top-color: #ddd;\n}\n.panel-default > .panel-heading .badge {\n  color: #f5f5f5;\n  background-color: #333333;\n}\n.panel-default > .panel-footer + .panel-collapse > .panel-body {\n  border-bottom-color: #ddd;\n}\n.panel-primary {\n  border-color: #337ab7;\n}\n.panel-primary > .panel-heading {\n  color: #fff;\n  background-color: #337ab7;\n  border-color: #337ab7;\n}\n.panel-primary > .panel-heading + .panel-collapse > .panel-body {\n  border-top-color: #337ab7;\n}\n.panel-primary > .panel-heading .badge {\n  color: #337ab7;\n  background-color: #fff;\n}\n.panel-primary > .panel-footer + .panel-collapse > .panel-body {\n  border-bottom-color: #337ab7;\n}\n.panel-success {\n  border-color: #d6e9c6;\n}\n.panel-success > .panel-heading {\n  color: #3c763d;\n  background-color: #dff0d8;\n  border-color: #d6e9c6;\n}\n.panel-success > .panel-heading + .panel-collapse > .panel-body {\n  border-top-color: #d6e9c6;\n}\n.panel-success > .panel-heading .badge {\n  color: #dff0d8;\n  background-color: #3c763d;\n}\n.panel-success > .panel-footer + .panel-collapse > .panel-body {\n  border-bottom-color: #d6e9c6;\n}\n.panel-info {\n  border-color: #bce8f1;\n}\n.panel-info > .panel-heading {\n  color: #31708f;\n  background-color: #d9edf7;\n  border-color: #bce8f1;\n}\n.panel-info > .panel-heading + .panel-collapse > .panel-body {\n  border-top-color: #bce8f1;\n}\n.panel-info > .panel-heading .badge {\n  color: #d9edf7;\n  background-color: #31708f;\n}\n.panel-info > .panel-footer + .panel-collapse > .panel-body {\n  border-bottom-color: #bce8f1;\n}\n.panel-warning {\n  border-color: #faebcc;\n}\n.panel-warning > .panel-heading {\n  color: #8a6d3b;\n  background-color: #fcf8e3;\n  border-color: #faebcc;\n}\n.panel-warning > .panel-heading + .panel-collapse > .panel-body {\n  border-top-color: #faebcc;\n}\n.panel-warning > .panel-heading .badge {\n  color: #fcf8e3;\n  background-color: #8a6d3b;\n}\n.panel-warning > .panel-footer + .panel-collapse > .panel-body {\n  border-bottom-color: #faebcc;\n}\n.panel-danger {\n  border-color: #ebccd1;\n}\n.panel-danger > .panel-heading {\n  color: #a94442;\n  background-color: #f2dede;\n  border-color: #ebccd1;\n}\n.panel-danger > .panel-heading + .panel-collapse > .panel-body {\n  border-top-color: #ebccd1;\n}\n.panel-danger > .panel-heading .badge {\n  color: #f2dede;\n  background-color: #a94442;\n}\n.panel-danger > .panel-footer + .panel-collapse > .panel-body {\n  border-bottom-color: #ebccd1;\n}\n.embed-responsive {\n  position: relative;\n  display: block;\n  height: 0;\n  padding: 0;\n  overflow: hidden;\n}\n.embed-responsive .embed-responsive-item,\n.embed-responsive iframe,\n.embed-responsive embed,\n.embed-responsive object,\n.embed-responsive video {\n  position: absolute;\n  top: 0;\n  left: 0;\n  bottom: 0;\n  height: 100%;\n  width: 100%;\n  border: 0;\n}\n.embed-responsive-16by9 {\n  padding-bottom: 56.25%;\n}\n.embed-responsive-4by3 {\n  padding-bottom: 75%;\n}\n.well {\n  min-height: 20px;\n  padding: 19px;\n  margin-bottom: 20px;\n  background-color: #f5f5f5;\n  border: 1px solid #e3e3e3;\n  border-radius: 2px;\n  -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.05);\n  box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.05);\n}\n.well blockquote {\n  border-color: #ddd;\n  border-color: rgba(0, 0, 0, 0.15);\n}\n.well-lg {\n  padding: 24px;\n  border-radius: 3px;\n}\n.well-sm {\n  padding: 9px;\n  border-radius: 1px;\n}\n.close {\n  float: right;\n  font-size: 19.5px;\n  font-weight: bold;\n  line-height: 1;\n  color: #000;\n  text-shadow: 0 1px 0 #fff;\n  opacity: 0.2;\n  filter: alpha(opacity=20);\n}\n.close:hover,\n.close:focus {\n  color: #000;\n  text-decoration: none;\n  cursor: pointer;\n  opacity: 0.5;\n  filter: alpha(opacity=50);\n}\nbutton.close {\n  padding: 0;\n  cursor: pointer;\n  background: transparent;\n  border: 0;\n  -webkit-appearance: none;\n}\n.modal-open {\n  overflow: hidden;\n}\n.modal {\n  display: none;\n  overflow: hidden;\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: 1050;\n  -webkit-overflow-scrolling: touch;\n  outline: 0;\n}\n.modal.fade .modal-dialog {\n  -webkit-transform: translate(0, -25%);\n  -ms-transform: translate(0, -25%);\n  -o-transform: translate(0, -25%);\n  transform: translate(0, -25%);\n  -webkit-transition: -webkit-transform 0.3s ease-out;\n  -moz-transition: -moz-transform 0.3s ease-out;\n  -o-transition: -o-transform 0.3s ease-out;\n  transition: transform 0.3s ease-out;\n}\n.modal.in .modal-dialog {\n  -webkit-transform: translate(0, 0);\n  -ms-transform: translate(0, 0);\n  -o-transform: translate(0, 0);\n  transform: translate(0, 0);\n}\n.modal-open .modal {\n  overflow-x: hidden;\n  overflow-y: auto;\n}\n.modal-dialog {\n  position: relative;\n  width: auto;\n  margin: 10px;\n}\n.modal-content {\n  position: relative;\n  background-color: #fff;\n  border: 1px solid #999;\n  border: 1px solid rgba(0, 0, 0, 0.2);\n  border-radius: 3px;\n  -webkit-box-shadow: 0 3px 9px rgba(0, 0, 0, 0.5);\n  box-shadow: 0 3px 9px rgba(0, 0, 0, 0.5);\n  background-clip: padding-box;\n  outline: 0;\n}\n.modal-backdrop {\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: 1040;\n  background-color: #000;\n}\n.modal-backdrop.fade {\n  opacity: 0;\n  filter: alpha(opacity=0);\n}\n.modal-backdrop.in {\n  opacity: 0.5;\n  filter: alpha(opacity=50);\n}\n.modal-header {\n  padding: 15px;\n  border-bottom: 1px solid #e5e5e5;\n}\n.modal-header .close {\n  margin-top: -2px;\n}\n.modal-title {\n  margin: 0;\n  line-height: 1.42857143;\n}\n.modal-body {\n  position: relative;\n  padding: 15px;\n}\n.modal-footer {\n  padding: 15px;\n  text-align: right;\n  border-top: 1px solid #e5e5e5;\n}\n.modal-footer .btn + .btn {\n  margin-left: 5px;\n  margin-bottom: 0;\n}\n.modal-footer .btn-group .btn + .btn {\n  margin-left: -1px;\n}\n.modal-footer .btn-block + .btn-block {\n  margin-left: 0;\n}\n.modal-scrollbar-measure {\n  position: absolute;\n  top: -9999px;\n  width: 50px;\n  height: 50px;\n  overflow: scroll;\n}\n@media (min-width: 768px) {\n  .modal-dialog {\n    width: 600px;\n    margin: 30px auto;\n  }\n  .modal-content {\n    -webkit-box-shadow: 0 5px 15px rgba(0, 0, 0, 0.5);\n    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.5);\n  }\n  .modal-sm {\n    width: 300px;\n  }\n}\n@media (min-width: 992px) {\n  .modal-lg {\n    width: 900px;\n  }\n}\n.tooltip {\n  position: absolute;\n  z-index: 1070;\n  display: block;\n  font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;\n  font-style: normal;\n  font-weight: normal;\n  letter-spacing: normal;\n  line-break: auto;\n  line-height: 1.42857143;\n  text-align: left;\n  text-align: start;\n  text-decoration: none;\n  text-shadow: none;\n  text-transform: none;\n  white-space: normal;\n  word-break: normal;\n  word-spacing: normal;\n  word-wrap: normal;\n  font-size: 12px;\n  opacity: 0;\n  filter: alpha(opacity=0);\n}\n.tooltip.in {\n  opacity: 0.9;\n  filter: alpha(opacity=90);\n}\n.tooltip.top {\n  margin-top: -3px;\n  padding: 5px 0;\n}\n.tooltip.right {\n  margin-left: 3px;\n  padding: 0 5px;\n}\n.tooltip.bottom {\n  margin-top: 3px;\n  padding: 5px 0;\n}\n.tooltip.left {\n  margin-left: -3px;\n  padding: 0 5px;\n}\n.tooltip-inner {\n  max-width: 200px;\n  padding: 3px 8px;\n  color: #fff;\n  text-align: center;\n  background-color: #000;\n  border-radius: 2px;\n}\n.tooltip-arrow {\n  position: absolute;\n  width: 0;\n  height: 0;\n  border-color: transparent;\n  border-style: solid;\n}\n.tooltip.top .tooltip-arrow {\n  bottom: 0;\n  left: 50%;\n  margin-left: -5px;\n  border-width: 5px 5px 0;\n  border-top-color: #000;\n}\n.tooltip.top-left .tooltip-arrow {\n  bottom: 0;\n  right: 5px;\n  margin-bottom: -5px;\n  border-width: 5px 5px 0;\n  border-top-color: #000;\n}\n.tooltip.top-right .tooltip-arrow {\n  bottom: 0;\n  left: 5px;\n  margin-bottom: -5px;\n  border-width: 5px 5px 0;\n  border-top-color: #000;\n}\n.tooltip.right .tooltip-arrow {\n  top: 50%;\n  left: 0;\n  margin-top: -5px;\n  border-width: 5px 5px 5px 0;\n  border-right-color: #000;\n}\n.tooltip.left .tooltip-arrow {\n  top: 50%;\n  right: 0;\n  margin-top: -5px;\n  border-width: 5px 0 5px 5px;\n  border-left-color: #000;\n}\n.tooltip.bottom .tooltip-arrow {\n  top: 0;\n  left: 50%;\n  margin-left: -5px;\n  border-width: 0 5px 5px;\n  border-bottom-color: #000;\n}\n.tooltip.bottom-left .tooltip-arrow {\n  top: 0;\n  right: 5px;\n  margin-top: -5px;\n  border-width: 0 5px 5px;\n  border-bottom-color: #000;\n}\n.tooltip.bottom-right .tooltip-arrow {\n  top: 0;\n  left: 5px;\n  margin-top: -5px;\n  border-width: 0 5px 5px;\n  border-bottom-color: #000;\n}\n.popover {\n  position: absolute;\n  top: 0;\n  left: 0;\n  z-index: 1060;\n  display: none;\n  max-width: 276px;\n  padding: 1px;\n  font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;\n  font-style: normal;\n  font-weight: normal;\n  letter-spacing: normal;\n  line-break: auto;\n  line-height: 1.42857143;\n  text-align: left;\n  text-align: start;\n  text-decoration: none;\n  text-shadow: none;\n  text-transform: none;\n  white-space: normal;\n  word-break: normal;\n  word-spacing: normal;\n  word-wrap: normal;\n  font-size: 13px;\n  background-color: #fff;\n  background-clip: padding-box;\n  border: 1px solid #ccc;\n  border: 1px solid rgba(0, 0, 0, 0.2);\n  border-radius: 3px;\n  -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);\n  box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);\n}\n.popover.top {\n  margin-top: -10px;\n}\n.popover.right {\n  margin-left: 10px;\n}\n.popover.bottom {\n  margin-top: 10px;\n}\n.popover.left {\n  margin-left: -10px;\n}\n.popover-title {\n  margin: 0;\n  padding: 8px 14px;\n  font-size: 13px;\n  background-color: #f7f7f7;\n  border-bottom: 1px solid #ebebeb;\n  border-radius: 2px 2px 0 0;\n}\n.popover-content {\n  padding: 9px 14px;\n}\n.popover > .arrow,\n.popover > .arrow:after {\n  position: absolute;\n  display: block;\n  width: 0;\n  height: 0;\n  border-color: transparent;\n  border-style: solid;\n}\n.popover > .arrow {\n  border-width: 11px;\n}\n.popover > .arrow:after {\n  border-width: 10px;\n  content: "";\n}\n.popover.top > .arrow {\n  left: 50%;\n  margin-left: -11px;\n  border-bottom-width: 0;\n  border-top-color: #999999;\n  border-top-color: rgba(0, 0, 0, 0.25);\n  bottom: -11px;\n}\n.popover.top > .arrow:after {\n  content: " ";\n  bottom: 1px;\n  margin-left: -10px;\n  border-bottom-width: 0;\n  border-top-color: #fff;\n}\n.popover.right > .arrow {\n  top: 50%;\n  left: -11px;\n  margin-top: -11px;\n  border-left-width: 0;\n  border-right-color: #999999;\n  border-right-color: rgba(0, 0, 0, 0.25);\n}\n.popover.right > .arrow:after {\n  content: " ";\n  left: 1px;\n  bottom: -10px;\n  border-left-width: 0;\n  border-right-color: #fff;\n}\n.popover.bottom > .arrow {\n  left: 50%;\n  margin-left: -11px;\n  border-top-width: 0;\n  border-bottom-color: #999999;\n  border-bottom-color: rgba(0, 0, 0, 0.25);\n  top: -11px;\n}\n.popover.bottom > .arrow:after {\n  content: " ";\n  top: 1px;\n  margin-left: -10px;\n  border-top-width: 0;\n  border-bottom-color: #fff;\n}\n.popover.left > .arrow {\n  top: 50%;\n  right: -11px;\n  margin-top: -11px;\n  border-right-width: 0;\n  border-left-color: #999999;\n  border-left-color: rgba(0, 0, 0, 0.25);\n}\n.popover.left > .arrow:after {\n  content: " ";\n  right: 1px;\n  border-right-width: 0;\n  border-left-color: #fff;\n  bottom: -10px;\n}\n.carousel {\n  position: relative;\n}\n.carousel-inner {\n  position: relative;\n  overflow: hidden;\n  width: 100%;\n}\n.carousel-inner > .item {\n  display: none;\n  position: relative;\n  -webkit-transition: 0.6s ease-in-out left;\n  -o-transition: 0.6s ease-in-out left;\n  transition: 0.6s ease-in-out left;\n}\n.carousel-inner > .item > img,\n.carousel-inner > .item > a > img {\n  line-height: 1;\n}\n@media all and (transform-3d), (-webkit-transform-3d) {\n  .carousel-inner > .item {\n    -webkit-transition: -webkit-transform 0.6s ease-in-out;\n    -moz-transition: -moz-transform 0.6s ease-in-out;\n    -o-transition: -o-transform 0.6s ease-in-out;\n    transition: transform 0.6s ease-in-out;\n    -webkit-backface-visibility: hidden;\n    -moz-backface-visibility: hidden;\n    backface-visibility: hidden;\n    -webkit-perspective: 1000px;\n    -moz-perspective: 1000px;\n    perspective: 1000px;\n  }\n  .carousel-inner > .item.next,\n  .carousel-inner > .item.active.right {\n    -webkit-transform: translate3d(100%, 0, 0);\n    transform: translate3d(100%, 0, 0);\n    left: 0;\n  }\n  .carousel-inner > .item.prev,\n  .carousel-inner > .item.active.left {\n    -webkit-transform: translate3d(-100%, 0, 0);\n    transform: translate3d(-100%, 0, 0);\n    left: 0;\n  }\n  .carousel-inner > .item.next.left,\n  .carousel-inner > .item.prev.right,\n  .carousel-inner > .item.active {\n    -webkit-transform: translate3d(0, 0, 0);\n    transform: translate3d(0, 0, 0);\n    left: 0;\n  }\n}\n.carousel-inner > .active,\n.carousel-inner > .next,\n.carousel-inner > .prev {\n  display: block;\n}\n.carousel-inner > .active {\n  left: 0;\n}\n.carousel-inner > .next,\n.carousel-inner > .prev {\n  position: absolute;\n  top: 0;\n  width: 100%;\n}\n.carousel-inner > .next {\n  left: 100%;\n}\n.carousel-inner > .prev {\n  left: -100%;\n}\n.carousel-inner > .next.left,\n.carousel-inner > .prev.right {\n  left: 0;\n}\n.carousel-inner > .active.left {\n  left: -100%;\n}\n.carousel-inner > .active.right {\n  left: 100%;\n}\n.carousel-control {\n  position: absolute;\n  top: 0;\n  left: 0;\n  bottom: 0;\n  width: 15%;\n  opacity: 0.5;\n  filter: alpha(opacity=50);\n  font-size: 20px;\n  color: #fff;\n  text-align: center;\n  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.6);\n  background-color: rgba(0, 0, 0, 0);\n}\n.carousel-control.left {\n  background-image: -webkit-linear-gradient(left, rgba(0, 0, 0, 0.5) 0%, rgba(0, 0, 0, 0.0001) 100%);\n  background-image: -o-linear-gradient(left, rgba(0, 0, 0, 0.5) 0%, rgba(0, 0, 0, 0.0001) 100%);\n  background-image: linear-gradient(to right, rgba(0, 0, 0, 0.5) 0%, rgba(0, 0, 0, 0.0001) 100%);\n  background-repeat: repeat-x;\n  filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'#80000000\', endColorstr=\'#00000000\', GradientType=1);\n}\n.carousel-control.right {\n  left: auto;\n  right: 0;\n  background-image: -webkit-linear-gradient(left, rgba(0, 0, 0, 0.0001) 0%, rgba(0, 0, 0, 0.5) 100%);\n  background-image: -o-linear-gradient(left, rgba(0, 0, 0, 0.0001) 0%, rgba(0, 0, 0, 0.5) 100%);\n  background-image: linear-gradient(to right, rgba(0, 0, 0, 0.0001) 0%, rgba(0, 0, 0, 0.5) 100%);\n  background-repeat: repeat-x;\n  filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'#00000000\', endColorstr=\'#80000000\', GradientType=1);\n}\n.carousel-control:hover,\n.carousel-control:focus {\n  outline: 0;\n  color: #fff;\n  text-decoration: none;\n  opacity: 0.9;\n  filter: alpha(opacity=90);\n}\n.carousel-control .icon-prev,\n.carousel-control .icon-next,\n.carousel-control .glyphicon-chevron-left,\n.carousel-control .glyphicon-chevron-right {\n  position: absolute;\n  top: 50%;\n  margin-top: -10px;\n  z-index: 5;\n  display: inline-block;\n}\n.carousel-control .icon-prev,\n.carousel-control .glyphicon-chevron-left {\n  left: 50%;\n  margin-left: -10px;\n}\n.carousel-control .icon-next,\n.carousel-control .glyphicon-chevron-right {\n  right: 50%;\n  margin-right: -10px;\n}\n.carousel-control .icon-prev,\n.carousel-control .icon-next {\n  width: 20px;\n  height: 20px;\n  line-height: 1;\n  font-family: serif;\n}\n.carousel-control .icon-prev:before {\n  content: \'\\2039\';\n}\n.carousel-control .icon-next:before {\n  content: \'\\203a\';\n}\n.carousel-indicators {\n  position: absolute;\n  bottom: 10px;\n  left: 50%;\n  z-index: 15;\n  width: 60%;\n  margin-left: -30%;\n  padding-left: 0;\n  list-style: none;\n  text-align: center;\n}\n.carousel-indicators li {\n  display: inline-block;\n  width: 10px;\n  height: 10px;\n  margin: 1px;\n  text-indent: -999px;\n  border: 1px solid #fff;\n  border-radius: 10px;\n  cursor: pointer;\n  background-color: #000 \\9;\n  background-color: rgba(0, 0, 0, 0);\n}\n.carousel-indicators .active {\n  margin: 0;\n  width: 12px;\n  height: 12px;\n  background-color: #fff;\n}\n.carousel-caption {\n  position: absolute;\n  left: 15%;\n  right: 15%;\n  bottom: 20px;\n  z-index: 10;\n  padding-top: 20px;\n  padding-bottom: 20px;\n  color: #fff;\n  text-align: center;\n  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.6);\n}\n.carousel-caption .btn {\n  text-shadow: none;\n}\n@media screen and (min-width: 768px) {\n  .carousel-control .glyphicon-chevron-left,\n  .carousel-control .glyphicon-chevron-right,\n  .carousel-control .icon-prev,\n  .carousel-control .icon-next {\n    width: 30px;\n    height: 30px;\n    margin-top: -10px;\n    font-size: 30px;\n  }\n  .carousel-control .glyphicon-chevron-left,\n  .carousel-control .icon-prev {\n    margin-left: -10px;\n  }\n  .carousel-control .glyphicon-chevron-right,\n  .carousel-control .icon-next {\n    margin-right: -10px;\n  }\n  .carousel-caption {\n    left: 20%;\n    right: 20%;\n    padding-bottom: 30px;\n  }\n  .carousel-indicators {\n    bottom: 20px;\n  }\n}\n.clearfix:before,\n.clearfix:after,\n.dl-horizontal dd:before,\n.dl-horizontal dd:after,\n.container:before,\n.container:after,\n.container-fluid:before,\n.container-fluid:after,\n.row:before,\n.row:after,\n.form-horizontal .form-group:before,\n.form-horizontal .form-group:after,\n.btn-toolbar:before,\n.btn-toolbar:after,\n.btn-group-vertical > .btn-group:before,\n.btn-group-vertical > .btn-group:after,\n.nav:before,\n.nav:after,\n.navbar:before,\n.navbar:after,\n.navbar-header:before,\n.navbar-header:after,\n.navbar-collapse:before,\n.navbar-collapse:after,\n.pager:before,\n.pager:after,\n.panel-body:before,\n.panel-body:after,\n.modal-header:before,\n.modal-header:after,\n.modal-footer:before,\n.modal-footer:after,\n.item_buttons:before,\n.item_buttons:after {\n  content: " ";\n  display: table;\n}\n.clearfix:after,\n.dl-horizontal dd:after,\n.container:after,\n.container-fluid:after,\n.row:after,\n.form-horizontal .form-group:after,\n.btn-toolbar:after,\n.btn-group-vertical > .btn-group:after,\n.nav:after,\n.navbar:after,\n.navbar-header:after,\n.navbar-collapse:after,\n.pager:after,\n.panel-body:after,\n.modal-header:after,\n.modal-footer:after,\n.item_buttons:after {\n  clear: both;\n}\n.center-block {\n  display: block;\n  margin-left: auto;\n  margin-right: auto;\n}\n.pull-right {\n  float: right !important;\n}\n.pull-left {\n  float: left !important;\n}\n.hide {\n  display: none !important;\n}\n.show {\n  display: block !important;\n}\n.invisible {\n  visibility: hidden;\n}\n.text-hide {\n  font: 0/0 a;\n  color: transparent;\n  text-shadow: none;\n  background-color: transparent;\n  border: 0;\n}\n.hidden {\n  display: none !important;\n}\n.affix {\n  position: fixed;\n}\n@-ms-viewport {\n  width: device-width;\n}\n.visible-xs,\n.visible-sm,\n.visible-md,\n.visible-lg {\n  display: none !important;\n}\n.visible-xs-block,\n.visible-xs-inline,\n.visible-xs-inline-block,\n.visible-sm-block,\n.visible-sm-inline,\n.visible-sm-inline-block,\n.visible-md-block,\n.visible-md-inline,\n.visible-md-inline-block,\n.visible-lg-block,\n.visible-lg-inline,\n.visible-lg-inline-block {\n  display: none !important;\n}\n@media (max-width: 767px) {\n  .visible-xs {\n    display: block !important;\n  }\n  table.visible-xs {\n    display: table !important;\n  }\n  tr.visible-xs {\n    display: table-row !important;\n  }\n  th.visible-xs,\n  td.visible-xs {\n    display: table-cell !important;\n  }\n}\n@media (max-width: 767px) {\n  .visible-xs-block {\n    display: block !important;\n  }\n}\n@media (max-width: 767px) {\n  .visible-xs-inline {\n    display: inline !important;\n  }\n}\n@media (max-width: 767px) {\n  .visible-xs-inline-block {\n    display: inline-block !important;\n  }\n}\n@media (min-width: 768px) and (max-width: 991px) {\n  .visible-sm {\n    display: block !important;\n  }\n  table.visible-sm {\n    display: table !important;\n  }\n  tr.visible-sm {\n    display: table-row !important;\n  }\n  th.visible-sm,\n  td.visible-sm {\n    display: table-cell !important;\n  }\n}\n@media (min-width: 768px) and (max-width: 991px) {\n  .visible-sm-block {\n    display: block !important;\n  }\n}\n@media (min-width: 768px) and (max-width: 991px) {\n  .visible-sm-inline {\n    display: inline !important;\n  }\n}\n@media (min-width: 768px) and (max-width: 991px) {\n  .visible-sm-inline-block {\n    display: inline-block !important;\n  }\n}\n@media (min-width: 992px) and (max-width: 1199px) {\n  .visible-md {\n    display: block !important;\n  }\n  table.visible-md {\n    display: table !important;\n  }\n  tr.visible-md {\n    display: table-row !important;\n  }\n  th.visible-md,\n  td.visible-md {\n    display: table-cell !important;\n  }\n}\n@media (min-width: 992px) and (max-width: 1199px) {\n  .visible-md-block {\n    display: block !important;\n  }\n}\n@media (min-width: 992px) and (max-width: 1199px) {\n  .visible-md-inline {\n    display: inline !important;\n  }\n}\n@media (min-width: 992px) and (max-width: 1199px) {\n  .visible-md-inline-block {\n    display: inline-block !important;\n  }\n}\n@media (min-width: 1200px) {\n  .visible-lg {\n    display: block !important;\n  }\n  table.visible-lg {\n    display: table !important;\n  }\n  tr.visible-lg {\n    display: table-row !important;\n  }\n  th.visible-lg,\n  td.visible-lg {\n    display: table-cell !important;\n  }\n}\n@media (min-width: 1200px) {\n  .visible-lg-block {\n    display: block !important;\n  }\n}\n@media (min-width: 1200px) {\n  .visible-lg-inline {\n    display: inline !important;\n  }\n}\n@media (min-width: 1200px) {\n  .visible-lg-inline-block {\n    display: inline-block !important;\n  }\n}\n@media (max-width: 767px) {\n  .hidden-xs {\n    display: none !important;\n  }\n}\n@media (min-width: 768px) and (max-width: 991px) {\n  .hidden-sm {\n    display: none !important;\n  }\n}\n@media (min-width: 992px) and (max-width: 1199px) {\n  .hidden-md {\n    display: none !important;\n  }\n}\n@media (min-width: 1200px) {\n  .hidden-lg {\n    display: none !important;\n  }\n}\n.visible-print {\n  display: none !important;\n}\n@media print {\n  .visible-print {\n    display: block !important;\n  }\n  table.visible-print {\n    display: table !important;\n  }\n  tr.visible-print {\n    display: table-row !important;\n  }\n  th.visible-print,\n  td.visible-print {\n    display: table-cell !important;\n  }\n}\n.visible-print-block {\n  display: none !important;\n}\n@media print {\n  .visible-print-block {\n    display: block !important;\n  }\n}\n.visible-print-inline {\n  display: none !important;\n}\n@media print {\n  .visible-print-inline {\n    display: inline !important;\n  }\n}\n.visible-print-inline-block {\n  display: none !important;\n}\n@media print {\n  .visible-print-inline-block {\n    display: inline-block !important;\n  }\n}\n@media print {\n  .hidden-print {\n    display: none !important;\n  }\n}\n/*!\n*\n* Font Awesome\n*\n*/\n/*!\n *  Font Awesome 4.7.0 by @davegandy - http://fontawesome.io - @fontawesome\n *  License - http://fontawesome.io/license (Font: SIL OFL 1.1, CSS: MIT License)\n */\n/* FONT PATH\n * -------------------------- */\n@font-face {\n  font-family: \'FontAwesome\';\n  src: url(\'../components/font-awesome/fonts/fontawesome-webfont.eot?v=4.7.0\');\n  src: url(\'../components/font-awesome/fonts/fontawesome-webfont.eot?#iefix&v=4.7.0\') format(\'embedded-opentype\'), url(\'../components/font-awesome/fonts/fontawesome-webfont.woff2?v=4.7.0\') format(\'woff2\'), url(\'../components/font-awesome/fonts/fontawesome-webfont.woff?v=4.7.0\') format(\'woff\'), url(\'../components/font-awesome/fonts/fontawesome-webfont.ttf?v=4.7.0\') format(\'truetype\'), url(\'../components/font-awesome/fonts/fontawesome-webfont.svg?v=4.7.0#fontawesomeregular\') format(\'svg\');\n  font-weight: normal;\n  font-style: normal;\n}\n.fa {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\n/* makes the font 33% larger relative to the icon container */\n.fa-lg {\n  font-size: 1.33333333em;\n  line-height: 0.75em;\n  vertical-align: -15%;\n}\n.fa-2x {\n  font-size: 2em;\n}\n.fa-3x {\n  font-size: 3em;\n}\n.fa-4x {\n  font-size: 4em;\n}\n.fa-5x {\n  font-size: 5em;\n}\n.fa-fw {\n  width: 1.28571429em;\n  text-align: center;\n}\n.fa-ul {\n  padding-left: 0;\n  margin-left: 2.14285714em;\n  list-style-type: none;\n}\n.fa-ul > li {\n  position: relative;\n}\n.fa-li {\n  position: absolute;\n  left: -2.14285714em;\n  width: 2.14285714em;\n  top: 0.14285714em;\n  text-align: center;\n}\n.fa-li.fa-lg {\n  left: -1.85714286em;\n}\n.fa-border {\n  padding: .2em .25em .15em;\n  border: solid 0.08em #eee;\n  border-radius: .1em;\n}\n.fa-pull-left {\n  float: left;\n}\n.fa-pull-right {\n  float: right;\n}\n.fa.fa-pull-left {\n  margin-right: .3em;\n}\n.fa.fa-pull-right {\n  margin-left: .3em;\n}\n/* Deprecated as of 4.4.0 */\n.pull-right {\n  float: right;\n}\n.pull-left {\n  float: left;\n}\n.fa.pull-left {\n  margin-right: .3em;\n}\n.fa.pull-right {\n  margin-left: .3em;\n}\n.fa-spin {\n  -webkit-animation: fa-spin 2s infinite linear;\n  animation: fa-spin 2s infinite linear;\n}\n.fa-pulse {\n  -webkit-animation: fa-spin 1s infinite steps(8);\n  animation: fa-spin 1s infinite steps(8);\n}\n@-webkit-keyframes fa-spin {\n  0% {\n    -webkit-transform: rotate(0deg);\n    transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(359deg);\n    transform: rotate(359deg);\n  }\n}\n@keyframes fa-spin {\n  0% {\n    -webkit-transform: rotate(0deg);\n    transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(359deg);\n    transform: rotate(359deg);\n  }\n}\n.fa-rotate-90 {\n  -ms-filter: "progid:DXImageTransform.Microsoft.BasicImage(rotation=1)";\n  -webkit-transform: rotate(90deg);\n  -ms-transform: rotate(90deg);\n  transform: rotate(90deg);\n}\n.fa-rotate-180 {\n  -ms-filter: "progid:DXImageTransform.Microsoft.BasicImage(rotation=2)";\n  -webkit-transform: rotate(180deg);\n  -ms-transform: rotate(180deg);\n  transform: rotate(180deg);\n}\n.fa-rotate-270 {\n  -ms-filter: "progid:DXImageTransform.Microsoft.BasicImage(rotation=3)";\n  -webkit-transform: rotate(270deg);\n  -ms-transform: rotate(270deg);\n  transform: rotate(270deg);\n}\n.fa-flip-horizontal {\n  -ms-filter: "progid:DXImageTransform.Microsoft.BasicImage(rotation=0, mirror=1)";\n  -webkit-transform: scale(-1, 1);\n  -ms-transform: scale(-1, 1);\n  transform: scale(-1, 1);\n}\n.fa-flip-vertical {\n  -ms-filter: "progid:DXImageTransform.Microsoft.BasicImage(rotation=2, mirror=1)";\n  -webkit-transform: scale(1, -1);\n  -ms-transform: scale(1, -1);\n  transform: scale(1, -1);\n}\n:root .fa-rotate-90,\n:root .fa-rotate-180,\n:root .fa-rotate-270,\n:root .fa-flip-horizontal,\n:root .fa-flip-vertical {\n  filter: none;\n}\n.fa-stack {\n  position: relative;\n  display: inline-block;\n  width: 2em;\n  height: 2em;\n  line-height: 2em;\n  vertical-align: middle;\n}\n.fa-stack-1x,\n.fa-stack-2x {\n  position: absolute;\n  left: 0;\n  width: 100%;\n  text-align: center;\n}\n.fa-stack-1x {\n  line-height: inherit;\n}\n.fa-stack-2x {\n  font-size: 2em;\n}\n.fa-inverse {\n  color: #fff;\n}\n/* Font Awesome uses the Unicode Private Use Area (PUA) to ensure screen\n   readers do not read off random characters that represent icons */\n.fa-glass:before {\n  content: "\\f000";\n}\n.fa-music:before {\n  content: "\\f001";\n}\n.fa-search:before {\n  content: "\\f002";\n}\n.fa-envelope-o:before {\n  content: "\\f003";\n}\n.fa-heart:before {\n  content: "\\f004";\n}\n.fa-star:before {\n  content: "\\f005";\n}\n.fa-star-o:before {\n  content: "\\f006";\n}\n.fa-user:before {\n  content: "\\f007";\n}\n.fa-film:before {\n  content: "\\f008";\n}\n.fa-th-large:before {\n  content: "\\f009";\n}\n.fa-th:before {\n  content: "\\f00a";\n}\n.fa-th-list:before {\n  content: "\\f00b";\n}\n.fa-check:before {\n  content: "\\f00c";\n}\n.fa-remove:before,\n.fa-close:before,\n.fa-times:before {\n  content: "\\f00d";\n}\n.fa-search-plus:before {\n  content: "\\f00e";\n}\n.fa-search-minus:before {\n  content: "\\f010";\n}\n.fa-power-off:before {\n  content: "\\f011";\n}\n.fa-signal:before {\n  content: "\\f012";\n}\n.fa-gear:before,\n.fa-cog:before {\n  content: "\\f013";\n}\n.fa-trash-o:before {\n  content: "\\f014";\n}\n.fa-home:before {\n  content: "\\f015";\n}\n.fa-file-o:before {\n  content: "\\f016";\n}\n.fa-clock-o:before {\n  content: "\\f017";\n}\n.fa-road:before {\n  content: "\\f018";\n}\n.fa-download:before {\n  content: "\\f019";\n}\n.fa-arrow-circle-o-down:before {\n  content: "\\f01a";\n}\n.fa-arrow-circle-o-up:before {\n  content: "\\f01b";\n}\n.fa-inbox:before {\n  content: "\\f01c";\n}\n.fa-play-circle-o:before {\n  content: "\\f01d";\n}\n.fa-rotate-right:before,\n.fa-repeat:before {\n  content: "\\f01e";\n}\n.fa-refresh:before {\n  content: "\\f021";\n}\n.fa-list-alt:before {\n  content: "\\f022";\n}\n.fa-lock:before {\n  content: "\\f023";\n}\n.fa-flag:before {\n  content: "\\f024";\n}\n.fa-headphones:before {\n  content: "\\f025";\n}\n.fa-volume-off:before {\n  content: "\\f026";\n}\n.fa-volume-down:before {\n  content: "\\f027";\n}\n.fa-volume-up:before {\n  content: "\\f028";\n}\n.fa-qrcode:before {\n  content: "\\f029";\n}\n.fa-barcode:before {\n  content: "\\f02a";\n}\n.fa-tag:before {\n  content: "\\f02b";\n}\n.fa-tags:before {\n  content: "\\f02c";\n}\n.fa-book:before {\n  content: "\\f02d";\n}\n.fa-bookmark:before {\n  content: "\\f02e";\n}\n.fa-print:before {\n  content: "\\f02f";\n}\n.fa-camera:before {\n  content: "\\f030";\n}\n.fa-font:before {\n  content: "\\f031";\n}\n.fa-bold:before {\n  content: "\\f032";\n}\n.fa-italic:before {\n  content: "\\f033";\n}\n.fa-text-height:before {\n  content: "\\f034";\n}\n.fa-text-width:before {\n  content: "\\f035";\n}\n.fa-align-left:before {\n  content: "\\f036";\n}\n.fa-align-center:before {\n  content: "\\f037";\n}\n.fa-align-right:before {\n  content: "\\f038";\n}\n.fa-align-justify:before {\n  content: "\\f039";\n}\n.fa-list:before {\n  content: "\\f03a";\n}\n.fa-dedent:before,\n.fa-outdent:before {\n  content: "\\f03b";\n}\n.fa-indent:before {\n  content: "\\f03c";\n}\n.fa-video-camera:before {\n  content: "\\f03d";\n}\n.fa-photo:before,\n.fa-image:before,\n.fa-picture-o:before {\n  content: "\\f03e";\n}\n.fa-pencil:before {\n  content: "\\f040";\n}\n.fa-map-marker:before {\n  content: "\\f041";\n}\n.fa-adjust:before {\n  content: "\\f042";\n}\n.fa-tint:before {\n  content: "\\f043";\n}\n.fa-edit:before,\n.fa-pencil-square-o:before {\n  content: "\\f044";\n}\n.fa-share-square-o:before {\n  content: "\\f045";\n}\n.fa-check-square-o:before {\n  content: "\\f046";\n}\n.fa-arrows:before {\n  content: "\\f047";\n}\n.fa-step-backward:before {\n  content: "\\f048";\n}\n.fa-fast-backward:before {\n  content: "\\f049";\n}\n.fa-backward:before {\n  content: "\\f04a";\n}\n.fa-play:before {\n  content: "\\f04b";\n}\n.fa-pause:before {\n  content: "\\f04c";\n}\n.fa-stop:before {\n  content: "\\f04d";\n}\n.fa-forward:before {\n  content: "\\f04e";\n}\n.fa-fast-forward:before {\n  content: "\\f050";\n}\n.fa-step-forward:before {\n  content: "\\f051";\n}\n.fa-eject:before {\n  content: "\\f052";\n}\n.fa-chevron-left:before {\n  content: "\\f053";\n}\n.fa-chevron-right:before {\n  content: "\\f054";\n}\n.fa-plus-circle:before {\n  content: "\\f055";\n}\n.fa-minus-circle:before {\n  content: "\\f056";\n}\n.fa-times-circle:before {\n  content: "\\f057";\n}\n.fa-check-circle:before {\n  content: "\\f058";\n}\n.fa-question-circle:before {\n  content: "\\f059";\n}\n.fa-info-circle:before {\n  content: "\\f05a";\n}\n.fa-crosshairs:before {\n  content: "\\f05b";\n}\n.fa-times-circle-o:before {\n  content: "\\f05c";\n}\n.fa-check-circle-o:before {\n  content: "\\f05d";\n}\n.fa-ban:before {\n  content: "\\f05e";\n}\n.fa-arrow-left:before {\n  content: "\\f060";\n}\n.fa-arrow-right:before {\n  content: "\\f061";\n}\n.fa-arrow-up:before {\n  content: "\\f062";\n}\n.fa-arrow-down:before {\n  content: "\\f063";\n}\n.fa-mail-forward:before,\n.fa-share:before {\n  content: "\\f064";\n}\n.fa-expand:before {\n  content: "\\f065";\n}\n.fa-compress:before {\n  content: "\\f066";\n}\n.fa-plus:before {\n  content: "\\f067";\n}\n.fa-minus:before {\n  content: "\\f068";\n}\n.fa-asterisk:before {\n  content: "\\f069";\n}\n.fa-exclamation-circle:before {\n  content: "\\f06a";\n}\n.fa-gift:before {\n  content: "\\f06b";\n}\n.fa-leaf:before {\n  content: "\\f06c";\n}\n.fa-fire:before {\n  content: "\\f06d";\n}\n.fa-eye:before {\n  content: "\\f06e";\n}\n.fa-eye-slash:before {\n  content: "\\f070";\n}\n.fa-warning:before,\n.fa-exclamation-triangle:before {\n  content: "\\f071";\n}\n.fa-plane:before {\n  content: "\\f072";\n}\n.fa-calendar:before {\n  content: "\\f073";\n}\n.fa-random:before {\n  content: "\\f074";\n}\n.fa-comment:before {\n  content: "\\f075";\n}\n.fa-magnet:before {\n  content: "\\f076";\n}\n.fa-chevron-up:before {\n  content: "\\f077";\n}\n.fa-chevron-down:before {\n  content: "\\f078";\n}\n.fa-retweet:before {\n  content: "\\f079";\n}\n.fa-shopping-cart:before {\n  content: "\\f07a";\n}\n.fa-folder:before {\n  content: "\\f07b";\n}\n.fa-folder-open:before {\n  content: "\\f07c";\n}\n.fa-arrows-v:before {\n  content: "\\f07d";\n}\n.fa-arrows-h:before {\n  content: "\\f07e";\n}\n.fa-bar-chart-o:before,\n.fa-bar-chart:before {\n  content: "\\f080";\n}\n.fa-twitter-square:before {\n  content: "\\f081";\n}\n.fa-facebook-square:before {\n  content: "\\f082";\n}\n.fa-camera-retro:before {\n  content: "\\f083";\n}\n.fa-key:before {\n  content: "\\f084";\n}\n.fa-gears:before,\n.fa-cogs:before {\n  content: "\\f085";\n}\n.fa-comments:before {\n  content: "\\f086";\n}\n.fa-thumbs-o-up:before {\n  content: "\\f087";\n}\n.fa-thumbs-o-down:before {\n  content: "\\f088";\n}\n.fa-star-half:before {\n  content: "\\f089";\n}\n.fa-heart-o:before {\n  content: "\\f08a";\n}\n.fa-sign-out:before {\n  content: "\\f08b";\n}\n.fa-linkedin-square:before {\n  content: "\\f08c";\n}\n.fa-thumb-tack:before {\n  content: "\\f08d";\n}\n.fa-external-link:before {\n  content: "\\f08e";\n}\n.fa-sign-in:before {\n  content: "\\f090";\n}\n.fa-trophy:before {\n  content: "\\f091";\n}\n.fa-github-square:before {\n  content: "\\f092";\n}\n.fa-upload:before {\n  content: "\\f093";\n}\n.fa-lemon-o:before {\n  content: "\\f094";\n}\n.fa-phone:before {\n  content: "\\f095";\n}\n.fa-square-o:before {\n  content: "\\f096";\n}\n.fa-bookmark-o:before {\n  content: "\\f097";\n}\n.fa-phone-square:before {\n  content: "\\f098";\n}\n.fa-twitter:before {\n  content: "\\f099";\n}\n.fa-facebook-f:before,\n.fa-facebook:before {\n  content: "\\f09a";\n}\n.fa-github:before {\n  content: "\\f09b";\n}\n.fa-unlock:before {\n  content: "\\f09c";\n}\n.fa-credit-card:before {\n  content: "\\f09d";\n}\n.fa-feed:before,\n.fa-rss:before {\n  content: "\\f09e";\n}\n.fa-hdd-o:before {\n  content: "\\f0a0";\n}\n.fa-bullhorn:before {\n  content: "\\f0a1";\n}\n.fa-bell:before {\n  content: "\\f0f3";\n}\n.fa-certificate:before {\n  content: "\\f0a3";\n}\n.fa-hand-o-right:before {\n  content: "\\f0a4";\n}\n.fa-hand-o-left:before {\n  content: "\\f0a5";\n}\n.fa-hand-o-up:before {\n  content: "\\f0a6";\n}\n.fa-hand-o-down:before {\n  content: "\\f0a7";\n}\n.fa-arrow-circle-left:before {\n  content: "\\f0a8";\n}\n.fa-arrow-circle-right:before {\n  content: "\\f0a9";\n}\n.fa-arrow-circle-up:before {\n  content: "\\f0aa";\n}\n.fa-arrow-circle-down:before {\n  content: "\\f0ab";\n}\n.fa-globe:before {\n  content: "\\f0ac";\n}\n.fa-wrench:before {\n  content: "\\f0ad";\n}\n.fa-tasks:before {\n  content: "\\f0ae";\n}\n.fa-filter:before {\n  content: "\\f0b0";\n}\n.fa-briefcase:before {\n  content: "\\f0b1";\n}\n.fa-arrows-alt:before {\n  content: "\\f0b2";\n}\n.fa-group:before,\n.fa-users:before {\n  content: "\\f0c0";\n}\n.fa-chain:before,\n.fa-link:before {\n  content: "\\f0c1";\n}\n.fa-cloud:before {\n  content: "\\f0c2";\n}\n.fa-flask:before {\n  content: "\\f0c3";\n}\n.fa-cut:before,\n.fa-scissors:before {\n  content: "\\f0c4";\n}\n.fa-copy:before,\n.fa-files-o:before {\n  content: "\\f0c5";\n}\n.fa-paperclip:before {\n  content: "\\f0c6";\n}\n.fa-save:before,\n.fa-floppy-o:before {\n  content: "\\f0c7";\n}\n.fa-square:before {\n  content: "\\f0c8";\n}\n.fa-navicon:before,\n.fa-reorder:before,\n.fa-bars:before {\n  content: "\\f0c9";\n}\n.fa-list-ul:before {\n  content: "\\f0ca";\n}\n.fa-list-ol:before {\n  content: "\\f0cb";\n}\n.fa-strikethrough:before {\n  content: "\\f0cc";\n}\n.fa-underline:before {\n  content: "\\f0cd";\n}\n.fa-table:before {\n  content: "\\f0ce";\n}\n.fa-magic:before {\n  content: "\\f0d0";\n}\n.fa-truck:before {\n  content: "\\f0d1";\n}\n.fa-pinterest:before {\n  content: "\\f0d2";\n}\n.fa-pinterest-square:before {\n  content: "\\f0d3";\n}\n.fa-google-plus-square:before {\n  content: "\\f0d4";\n}\n.fa-google-plus:before {\n  content: "\\f0d5";\n}\n.fa-money:before {\n  content: "\\f0d6";\n}\n.fa-caret-down:before {\n  content: "\\f0d7";\n}\n.fa-caret-up:before {\n  content: "\\f0d8";\n}\n.fa-caret-left:before {\n  content: "\\f0d9";\n}\n.fa-caret-right:before {\n  content: "\\f0da";\n}\n.fa-columns:before {\n  content: "\\f0db";\n}\n.fa-unsorted:before,\n.fa-sort:before {\n  content: "\\f0dc";\n}\n.fa-sort-down:before,\n.fa-sort-desc:before {\n  content: "\\f0dd";\n}\n.fa-sort-up:before,\n.fa-sort-asc:before {\n  content: "\\f0de";\n}\n.fa-envelope:before {\n  content: "\\f0e0";\n}\n.fa-linkedin:before {\n  content: "\\f0e1";\n}\n.fa-rotate-left:before,\n.fa-undo:before {\n  content: "\\f0e2";\n}\n.fa-legal:before,\n.fa-gavel:before {\n  content: "\\f0e3";\n}\n.fa-dashboard:before,\n.fa-tachometer:before {\n  content: "\\f0e4";\n}\n.fa-comment-o:before {\n  content: "\\f0e5";\n}\n.fa-comments-o:before {\n  content: "\\f0e6";\n}\n.fa-flash:before,\n.fa-bolt:before {\n  content: "\\f0e7";\n}\n.fa-sitemap:before {\n  content: "\\f0e8";\n}\n.fa-umbrella:before {\n  content: "\\f0e9";\n}\n.fa-paste:before,\n.fa-clipboard:before {\n  content: "\\f0ea";\n}\n.fa-lightbulb-o:before {\n  content: "\\f0eb";\n}\n.fa-exchange:before {\n  content: "\\f0ec";\n}\n.fa-cloud-download:before {\n  content: "\\f0ed";\n}\n.fa-cloud-upload:before {\n  content: "\\f0ee";\n}\n.fa-user-md:before {\n  content: "\\f0f0";\n}\n.fa-stethoscope:before {\n  content: "\\f0f1";\n}\n.fa-suitcase:before {\n  content: "\\f0f2";\n}\n.fa-bell-o:before {\n  content: "\\f0a2";\n}\n.fa-coffee:before {\n  content: "\\f0f4";\n}\n.fa-cutlery:before {\n  content: "\\f0f5";\n}\n.fa-file-text-o:before {\n  content: "\\f0f6";\n}\n.fa-building-o:before {\n  content: "\\f0f7";\n}\n.fa-hospital-o:before {\n  content: "\\f0f8";\n}\n.fa-ambulance:before {\n  content: "\\f0f9";\n}\n.fa-medkit:before {\n  content: "\\f0fa";\n}\n.fa-fighter-jet:before {\n  content: "\\f0fb";\n}\n.fa-beer:before {\n  content: "\\f0fc";\n}\n.fa-h-square:before {\n  content: "\\f0fd";\n}\n.fa-plus-square:before {\n  content: "\\f0fe";\n}\n.fa-angle-double-left:before {\n  content: "\\f100";\n}\n.fa-angle-double-right:before {\n  content: "\\f101";\n}\n.fa-angle-double-up:before {\n  content: "\\f102";\n}\n.fa-angle-double-down:before {\n  content: "\\f103";\n}\n.fa-angle-left:before {\n  content: "\\f104";\n}\n.fa-angle-right:before {\n  content: "\\f105";\n}\n.fa-angle-up:before {\n  content: "\\f106";\n}\n.fa-angle-down:before {\n  content: "\\f107";\n}\n.fa-desktop:before {\n  content: "\\f108";\n}\n.fa-laptop:before {\n  content: "\\f109";\n}\n.fa-tablet:before {\n  content: "\\f10a";\n}\n.fa-mobile-phone:before,\n.fa-mobile:before {\n  content: "\\f10b";\n}\n.fa-circle-o:before {\n  content: "\\f10c";\n}\n.fa-quote-left:before {\n  content: "\\f10d";\n}\n.fa-quote-right:before {\n  content: "\\f10e";\n}\n.fa-spinner:before {\n  content: "\\f110";\n}\n.fa-circle:before {\n  content: "\\f111";\n}\n.fa-mail-reply:before,\n.fa-reply:before {\n  content: "\\f112";\n}\n.fa-github-alt:before {\n  content: "\\f113";\n}\n.fa-folder-o:before {\n  content: "\\f114";\n}\n.fa-folder-open-o:before {\n  content: "\\f115";\n}\n.fa-smile-o:before {\n  content: "\\f118";\n}\n.fa-frown-o:before {\n  content: "\\f119";\n}\n.fa-meh-o:before {\n  content: "\\f11a";\n}\n.fa-gamepad:before {\n  content: "\\f11b";\n}\n.fa-keyboard-o:before {\n  content: "\\f11c";\n}\n.fa-flag-o:before {\n  content: "\\f11d";\n}\n.fa-flag-checkered:before {\n  content: "\\f11e";\n}\n.fa-terminal:before {\n  content: "\\f120";\n}\n.fa-code:before {\n  content: "\\f121";\n}\n.fa-mail-reply-all:before,\n.fa-reply-all:before {\n  content: "\\f122";\n}\n.fa-star-half-empty:before,\n.fa-star-half-full:before,\n.fa-star-half-o:before {\n  content: "\\f123";\n}\n.fa-location-arrow:before {\n  content: "\\f124";\n}\n.fa-crop:before {\n  content: "\\f125";\n}\n.fa-code-fork:before {\n  content: "\\f126";\n}\n.fa-unlink:before,\n.fa-chain-broken:before {\n  content: "\\f127";\n}\n.fa-question:before {\n  content: "\\f128";\n}\n.fa-info:before {\n  content: "\\f129";\n}\n.fa-exclamation:before {\n  content: "\\f12a";\n}\n.fa-superscript:before {\n  content: "\\f12b";\n}\n.fa-subscript:before {\n  content: "\\f12c";\n}\n.fa-eraser:before {\n  content: "\\f12d";\n}\n.fa-puzzle-piece:before {\n  content: "\\f12e";\n}\n.fa-microphone:before {\n  content: "\\f130";\n}\n.fa-microphone-slash:before {\n  content: "\\f131";\n}\n.fa-shield:before {\n  content: "\\f132";\n}\n.fa-calendar-o:before {\n  content: "\\f133";\n}\n.fa-fire-extinguisher:before {\n  content: "\\f134";\n}\n.fa-rocket:before {\n  content: "\\f135";\n}\n.fa-maxcdn:before {\n  content: "\\f136";\n}\n.fa-chevron-circle-left:before {\n  content: "\\f137";\n}\n.fa-chevron-circle-right:before {\n  content: "\\f138";\n}\n.fa-chevron-circle-up:before {\n  content: "\\f139";\n}\n.fa-chevron-circle-down:before {\n  content: "\\f13a";\n}\n.fa-html5:before {\n  content: "\\f13b";\n}\n.fa-css3:before {\n  content: "\\f13c";\n}\n.fa-anchor:before {\n  content: "\\f13d";\n}\n.fa-unlock-alt:before {\n  content: "\\f13e";\n}\n.fa-bullseye:before {\n  content: "\\f140";\n}\n.fa-ellipsis-h:before {\n  content: "\\f141";\n}\n.fa-ellipsis-v:before {\n  content: "\\f142";\n}\n.fa-rss-square:before {\n  content: "\\f143";\n}\n.fa-play-circle:before {\n  content: "\\f144";\n}\n.fa-ticket:before {\n  content: "\\f145";\n}\n.fa-minus-square:before {\n  content: "\\f146";\n}\n.fa-minus-square-o:before {\n  content: "\\f147";\n}\n.fa-level-up:before {\n  content: "\\f148";\n}\n.fa-level-down:before {\n  content: "\\f149";\n}\n.fa-check-square:before {\n  content: "\\f14a";\n}\n.fa-pencil-square:before {\n  content: "\\f14b";\n}\n.fa-external-link-square:before {\n  content: "\\f14c";\n}\n.fa-share-square:before {\n  content: "\\f14d";\n}\n.fa-compass:before {\n  content: "\\f14e";\n}\n.fa-toggle-down:before,\n.fa-caret-square-o-down:before {\n  content: "\\f150";\n}\n.fa-toggle-up:before,\n.fa-caret-square-o-up:before {\n  content: "\\f151";\n}\n.fa-toggle-right:before,\n.fa-caret-square-o-right:before {\n  content: "\\f152";\n}\n.fa-euro:before,\n.fa-eur:before {\n  content: "\\f153";\n}\n.fa-gbp:before {\n  content: "\\f154";\n}\n.fa-dollar:before,\n.fa-usd:before {\n  content: "\\f155";\n}\n.fa-rupee:before,\n.fa-inr:before {\n  content: "\\f156";\n}\n.fa-cny:before,\n.fa-rmb:before,\n.fa-yen:before,\n.fa-jpy:before {\n  content: "\\f157";\n}\n.fa-ruble:before,\n.fa-rouble:before,\n.fa-rub:before {\n  content: "\\f158";\n}\n.fa-won:before,\n.fa-krw:before {\n  content: "\\f159";\n}\n.fa-bitcoin:before,\n.fa-btc:before {\n  content: "\\f15a";\n}\n.fa-file:before {\n  content: "\\f15b";\n}\n.fa-file-text:before {\n  content: "\\f15c";\n}\n.fa-sort-alpha-asc:before {\n  content: "\\f15d";\n}\n.fa-sort-alpha-desc:before {\n  content: "\\f15e";\n}\n.fa-sort-amount-asc:before {\n  content: "\\f160";\n}\n.fa-sort-amount-desc:before {\n  content: "\\f161";\n}\n.fa-sort-numeric-asc:before {\n  content: "\\f162";\n}\n.fa-sort-numeric-desc:before {\n  content: "\\f163";\n}\n.fa-thumbs-up:before {\n  content: "\\f164";\n}\n.fa-thumbs-down:before {\n  content: "\\f165";\n}\n.fa-youtube-square:before {\n  content: "\\f166";\n}\n.fa-youtube:before {\n  content: "\\f167";\n}\n.fa-xing:before {\n  content: "\\f168";\n}\n.fa-xing-square:before {\n  content: "\\f169";\n}\n.fa-youtube-play:before {\n  content: "\\f16a";\n}\n.fa-dropbox:before {\n  content: "\\f16b";\n}\n.fa-stack-overflow:before {\n  content: "\\f16c";\n}\n.fa-instagram:before {\n  content: "\\f16d";\n}\n.fa-flickr:before {\n  content: "\\f16e";\n}\n.fa-adn:before {\n  content: "\\f170";\n}\n.fa-bitbucket:before {\n  content: "\\f171";\n}\n.fa-bitbucket-square:before {\n  content: "\\f172";\n}\n.fa-tumblr:before {\n  content: "\\f173";\n}\n.fa-tumblr-square:before {\n  content: "\\f174";\n}\n.fa-long-arrow-down:before {\n  content: "\\f175";\n}\n.fa-long-arrow-up:before {\n  content: "\\f176";\n}\n.fa-long-arrow-left:before {\n  content: "\\f177";\n}\n.fa-long-arrow-right:before {\n  content: "\\f178";\n}\n.fa-apple:before {\n  content: "\\f179";\n}\n.fa-windows:before {\n  content: "\\f17a";\n}\n.fa-android:before {\n  content: "\\f17b";\n}\n.fa-linux:before {\n  content: "\\f17c";\n}\n.fa-dribbble:before {\n  content: "\\f17d";\n}\n.fa-skype:before {\n  content: "\\f17e";\n}\n.fa-foursquare:before {\n  content: "\\f180";\n}\n.fa-trello:before {\n  content: "\\f181";\n}\n.fa-female:before {\n  content: "\\f182";\n}\n.fa-male:before {\n  content: "\\f183";\n}\n.fa-gittip:before,\n.fa-gratipay:before {\n  content: "\\f184";\n}\n.fa-sun-o:before {\n  content: "\\f185";\n}\n.fa-moon-o:before {\n  content: "\\f186";\n}\n.fa-archive:before {\n  content: "\\f187";\n}\n.fa-bug:before {\n  content: "\\f188";\n}\n.fa-vk:before {\n  content: "\\f189";\n}\n.fa-weibo:before {\n  content: "\\f18a";\n}\n.fa-renren:before {\n  content: "\\f18b";\n}\n.fa-pagelines:before {\n  content: "\\f18c";\n}\n.fa-stack-exchange:before {\n  content: "\\f18d";\n}\n.fa-arrow-circle-o-right:before {\n  content: "\\f18e";\n}\n.fa-arrow-circle-o-left:before {\n  content: "\\f190";\n}\n.fa-toggle-left:before,\n.fa-caret-square-o-left:before {\n  content: "\\f191";\n}\n.fa-dot-circle-o:before {\n  content: "\\f192";\n}\n.fa-wheelchair:before {\n  content: "\\f193";\n}\n.fa-vimeo-square:before {\n  content: "\\f194";\n}\n.fa-turkish-lira:before,\n.fa-try:before {\n  content: "\\f195";\n}\n.fa-plus-square-o:before {\n  content: "\\f196";\n}\n.fa-space-shuttle:before {\n  content: "\\f197";\n}\n.fa-slack:before {\n  content: "\\f198";\n}\n.fa-envelope-square:before {\n  content: "\\f199";\n}\n.fa-wordpress:before {\n  content: "\\f19a";\n}\n.fa-openid:before {\n  content: "\\f19b";\n}\n.fa-institution:before,\n.fa-bank:before,\n.fa-university:before {\n  content: "\\f19c";\n}\n.fa-mortar-board:before,\n.fa-graduation-cap:before {\n  content: "\\f19d";\n}\n.fa-yahoo:before {\n  content: "\\f19e";\n}\n.fa-google:before {\n  content: "\\f1a0";\n}\n.fa-reddit:before {\n  content: "\\f1a1";\n}\n.fa-reddit-square:before {\n  content: "\\f1a2";\n}\n.fa-stumbleupon-circle:before {\n  content: "\\f1a3";\n}\n.fa-stumbleupon:before {\n  content: "\\f1a4";\n}\n.fa-delicious:before {\n  content: "\\f1a5";\n}\n.fa-digg:before {\n  content: "\\f1a6";\n}\n.fa-pied-piper-pp:before {\n  content: "\\f1a7";\n}\n.fa-pied-piper-alt:before {\n  content: "\\f1a8";\n}\n.fa-drupal:before {\n  content: "\\f1a9";\n}\n.fa-joomla:before {\n  content: "\\f1aa";\n}\n.fa-language:before {\n  content: "\\f1ab";\n}\n.fa-fax:before {\n  content: "\\f1ac";\n}\n.fa-building:before {\n  content: "\\f1ad";\n}\n.fa-child:before {\n  content: "\\f1ae";\n}\n.fa-paw:before {\n  content: "\\f1b0";\n}\n.fa-spoon:before {\n  content: "\\f1b1";\n}\n.fa-cube:before {\n  content: "\\f1b2";\n}\n.fa-cubes:before {\n  content: "\\f1b3";\n}\n.fa-behance:before {\n  content: "\\f1b4";\n}\n.fa-behance-square:before {\n  content: "\\f1b5";\n}\n.fa-steam:before {\n  content: "\\f1b6";\n}\n.fa-steam-square:before {\n  content: "\\f1b7";\n}\n.fa-recycle:before {\n  content: "\\f1b8";\n}\n.fa-automobile:before,\n.fa-car:before {\n  content: "\\f1b9";\n}\n.fa-cab:before,\n.fa-taxi:before {\n  content: "\\f1ba";\n}\n.fa-tree:before {\n  content: "\\f1bb";\n}\n.fa-spotify:before {\n  content: "\\f1bc";\n}\n.fa-deviantart:before {\n  content: "\\f1bd";\n}\n.fa-soundcloud:before {\n  content: "\\f1be";\n}\n.fa-database:before {\n  content: "\\f1c0";\n}\n.fa-file-pdf-o:before {\n  content: "\\f1c1";\n}\n.fa-file-word-o:before {\n  content: "\\f1c2";\n}\n.fa-file-excel-o:before {\n  content: "\\f1c3";\n}\n.fa-file-powerpoint-o:before {\n  content: "\\f1c4";\n}\n.fa-file-photo-o:before,\n.fa-file-picture-o:before,\n.fa-file-image-o:before {\n  content: "\\f1c5";\n}\n.fa-file-zip-o:before,\n.fa-file-archive-o:before {\n  content: "\\f1c6";\n}\n.fa-file-sound-o:before,\n.fa-file-audio-o:before {\n  content: "\\f1c7";\n}\n.fa-file-movie-o:before,\n.fa-file-video-o:before {\n  content: "\\f1c8";\n}\n.fa-file-code-o:before {\n  content: "\\f1c9";\n}\n.fa-vine:before {\n  content: "\\f1ca";\n}\n.fa-codepen:before {\n  content: "\\f1cb";\n}\n.fa-jsfiddle:before {\n  content: "\\f1cc";\n}\n.fa-life-bouy:before,\n.fa-life-buoy:before,\n.fa-life-saver:before,\n.fa-support:before,\n.fa-life-ring:before {\n  content: "\\f1cd";\n}\n.fa-circle-o-notch:before {\n  content: "\\f1ce";\n}\n.fa-ra:before,\n.fa-resistance:before,\n.fa-rebel:before {\n  content: "\\f1d0";\n}\n.fa-ge:before,\n.fa-empire:before {\n  content: "\\f1d1";\n}\n.fa-git-square:before {\n  content: "\\f1d2";\n}\n.fa-git:before {\n  content: "\\f1d3";\n}\n.fa-y-combinator-square:before,\n.fa-yc-square:before,\n.fa-hacker-news:before {\n  content: "\\f1d4";\n}\n.fa-tencent-weibo:before {\n  content: "\\f1d5";\n}\n.fa-qq:before {\n  content: "\\f1d6";\n}\n.fa-wechat:before,\n.fa-weixin:before {\n  content: "\\f1d7";\n}\n.fa-send:before,\n.fa-paper-plane:before {\n  content: "\\f1d8";\n}\n.fa-send-o:before,\n.fa-paper-plane-o:before {\n  content: "\\f1d9";\n}\n.fa-history:before {\n  content: "\\f1da";\n}\n.fa-circle-thin:before {\n  content: "\\f1db";\n}\n.fa-header:before {\n  content: "\\f1dc";\n}\n.fa-paragraph:before {\n  content: "\\f1dd";\n}\n.fa-sliders:before {\n  content: "\\f1de";\n}\n.fa-share-alt:before {\n  content: "\\f1e0";\n}\n.fa-share-alt-square:before {\n  content: "\\f1e1";\n}\n.fa-bomb:before {\n  content: "\\f1e2";\n}\n.fa-soccer-ball-o:before,\n.fa-futbol-o:before {\n  content: "\\f1e3";\n}\n.fa-tty:before {\n  content: "\\f1e4";\n}\n.fa-binoculars:before {\n  content: "\\f1e5";\n}\n.fa-plug:before {\n  content: "\\f1e6";\n}\n.fa-slideshare:before {\n  content: "\\f1e7";\n}\n.fa-twitch:before {\n  content: "\\f1e8";\n}\n.fa-yelp:before {\n  content: "\\f1e9";\n}\n.fa-newspaper-o:before {\n  content: "\\f1ea";\n}\n.fa-wifi:before {\n  content: "\\f1eb";\n}\n.fa-calculator:before {\n  content: "\\f1ec";\n}\n.fa-paypal:before {\n  content: "\\f1ed";\n}\n.fa-google-wallet:before {\n  content: "\\f1ee";\n}\n.fa-cc-visa:before {\n  content: "\\f1f0";\n}\n.fa-cc-mastercard:before {\n  content: "\\f1f1";\n}\n.fa-cc-discover:before {\n  content: "\\f1f2";\n}\n.fa-cc-amex:before {\n  content: "\\f1f3";\n}\n.fa-cc-paypal:before {\n  content: "\\f1f4";\n}\n.fa-cc-stripe:before {\n  content: "\\f1f5";\n}\n.fa-bell-slash:before {\n  content: "\\f1f6";\n}\n.fa-bell-slash-o:before {\n  content: "\\f1f7";\n}\n.fa-trash:before {\n  content: "\\f1f8";\n}\n.fa-copyright:before {\n  content: "\\f1f9";\n}\n.fa-at:before {\n  content: "\\f1fa";\n}\n.fa-eyedropper:before {\n  content: "\\f1fb";\n}\n.fa-paint-brush:before {\n  content: "\\f1fc";\n}\n.fa-birthday-cake:before {\n  content: "\\f1fd";\n}\n.fa-area-chart:before {\n  content: "\\f1fe";\n}\n.fa-pie-chart:before {\n  content: "\\f200";\n}\n.fa-line-chart:before {\n  content: "\\f201";\n}\n.fa-lastfm:before {\n  content: "\\f202";\n}\n.fa-lastfm-square:before {\n  content: "\\f203";\n}\n.fa-toggle-off:before {\n  content: "\\f204";\n}\n.fa-toggle-on:before {\n  content: "\\f205";\n}\n.fa-bicycle:before {\n  content: "\\f206";\n}\n.fa-bus:before {\n  content: "\\f207";\n}\n.fa-ioxhost:before {\n  content: "\\f208";\n}\n.fa-angellist:before {\n  content: "\\f209";\n}\n.fa-cc:before {\n  content: "\\f20a";\n}\n.fa-shekel:before,\n.fa-sheqel:before,\n.fa-ils:before {\n  content: "\\f20b";\n}\n.fa-meanpath:before {\n  content: "\\f20c";\n}\n.fa-buysellads:before {\n  content: "\\f20d";\n}\n.fa-connectdevelop:before {\n  content: "\\f20e";\n}\n.fa-dashcube:before {\n  content: "\\f210";\n}\n.fa-forumbee:before {\n  content: "\\f211";\n}\n.fa-leanpub:before {\n  content: "\\f212";\n}\n.fa-sellsy:before {\n  content: "\\f213";\n}\n.fa-shirtsinbulk:before {\n  content: "\\f214";\n}\n.fa-simplybuilt:before {\n  content: "\\f215";\n}\n.fa-skyatlas:before {\n  content: "\\f216";\n}\n.fa-cart-plus:before {\n  content: "\\f217";\n}\n.fa-cart-arrow-down:before {\n  content: "\\f218";\n}\n.fa-diamond:before {\n  content: "\\f219";\n}\n.fa-ship:before {\n  content: "\\f21a";\n}\n.fa-user-secret:before {\n  content: "\\f21b";\n}\n.fa-motorcycle:before {\n  content: "\\f21c";\n}\n.fa-street-view:before {\n  content: "\\f21d";\n}\n.fa-heartbeat:before {\n  content: "\\f21e";\n}\n.fa-venus:before {\n  content: "\\f221";\n}\n.fa-mars:before {\n  content: "\\f222";\n}\n.fa-mercury:before {\n  content: "\\f223";\n}\n.fa-intersex:before,\n.fa-transgender:before {\n  content: "\\f224";\n}\n.fa-transgender-alt:before {\n  content: "\\f225";\n}\n.fa-venus-double:before {\n  content: "\\f226";\n}\n.fa-mars-double:before {\n  content: "\\f227";\n}\n.fa-venus-mars:before {\n  content: "\\f228";\n}\n.fa-mars-stroke:before {\n  content: "\\f229";\n}\n.fa-mars-stroke-v:before {\n  content: "\\f22a";\n}\n.fa-mars-stroke-h:before {\n  content: "\\f22b";\n}\n.fa-neuter:before {\n  content: "\\f22c";\n}\n.fa-genderless:before {\n  content: "\\f22d";\n}\n.fa-facebook-official:before {\n  content: "\\f230";\n}\n.fa-pinterest-p:before {\n  content: "\\f231";\n}\n.fa-whatsapp:before {\n  content: "\\f232";\n}\n.fa-server:before {\n  content: "\\f233";\n}\n.fa-user-plus:before {\n  content: "\\f234";\n}\n.fa-user-times:before {\n  content: "\\f235";\n}\n.fa-hotel:before,\n.fa-bed:before {\n  content: "\\f236";\n}\n.fa-viacoin:before {\n  content: "\\f237";\n}\n.fa-train:before {\n  content: "\\f238";\n}\n.fa-subway:before {\n  content: "\\f239";\n}\n.fa-medium:before {\n  content: "\\f23a";\n}\n.fa-yc:before,\n.fa-y-combinator:before {\n  content: "\\f23b";\n}\n.fa-optin-monster:before {\n  content: "\\f23c";\n}\n.fa-opencart:before {\n  content: "\\f23d";\n}\n.fa-expeditedssl:before {\n  content: "\\f23e";\n}\n.fa-battery-4:before,\n.fa-battery:before,\n.fa-battery-full:before {\n  content: "\\f240";\n}\n.fa-battery-3:before,\n.fa-battery-three-quarters:before {\n  content: "\\f241";\n}\n.fa-battery-2:before,\n.fa-battery-half:before {\n  content: "\\f242";\n}\n.fa-battery-1:before,\n.fa-battery-quarter:before {\n  content: "\\f243";\n}\n.fa-battery-0:before,\n.fa-battery-empty:before {\n  content: "\\f244";\n}\n.fa-mouse-pointer:before {\n  content: "\\f245";\n}\n.fa-i-cursor:before {\n  content: "\\f246";\n}\n.fa-object-group:before {\n  content: "\\f247";\n}\n.fa-object-ungroup:before {\n  content: "\\f248";\n}\n.fa-sticky-note:before {\n  content: "\\f249";\n}\n.fa-sticky-note-o:before {\n  content: "\\f24a";\n}\n.fa-cc-jcb:before {\n  content: "\\f24b";\n}\n.fa-cc-diners-club:before {\n  content: "\\f24c";\n}\n.fa-clone:before {\n  content: "\\f24d";\n}\n.fa-balance-scale:before {\n  content: "\\f24e";\n}\n.fa-hourglass-o:before {\n  content: "\\f250";\n}\n.fa-hourglass-1:before,\n.fa-hourglass-start:before {\n  content: "\\f251";\n}\n.fa-hourglass-2:before,\n.fa-hourglass-half:before {\n  content: "\\f252";\n}\n.fa-hourglass-3:before,\n.fa-hourglass-end:before {\n  content: "\\f253";\n}\n.fa-hourglass:before {\n  content: "\\f254";\n}\n.fa-hand-grab-o:before,\n.fa-hand-rock-o:before {\n  content: "\\f255";\n}\n.fa-hand-stop-o:before,\n.fa-hand-paper-o:before {\n  content: "\\f256";\n}\n.fa-hand-scissors-o:before {\n  content: "\\f257";\n}\n.fa-hand-lizard-o:before {\n  content: "\\f258";\n}\n.fa-hand-spock-o:before {\n  content: "\\f259";\n}\n.fa-hand-pointer-o:before {\n  content: "\\f25a";\n}\n.fa-hand-peace-o:before {\n  content: "\\f25b";\n}\n.fa-trademark:before {\n  content: "\\f25c";\n}\n.fa-registered:before {\n  content: "\\f25d";\n}\n.fa-creative-commons:before {\n  content: "\\f25e";\n}\n.fa-gg:before {\n  content: "\\f260";\n}\n.fa-gg-circle:before {\n  content: "\\f261";\n}\n.fa-tripadvisor:before {\n  content: "\\f262";\n}\n.fa-odnoklassniki:before {\n  content: "\\f263";\n}\n.fa-odnoklassniki-square:before {\n  content: "\\f264";\n}\n.fa-get-pocket:before {\n  content: "\\f265";\n}\n.fa-wikipedia-w:before {\n  content: "\\f266";\n}\n.fa-safari:before {\n  content: "\\f267";\n}\n.fa-chrome:before {\n  content: "\\f268";\n}\n.fa-firefox:before {\n  content: "\\f269";\n}\n.fa-opera:before {\n  content: "\\f26a";\n}\n.fa-internet-explorer:before {\n  content: "\\f26b";\n}\n.fa-tv:before,\n.fa-television:before {\n  content: "\\f26c";\n}\n.fa-contao:before {\n  content: "\\f26d";\n}\n.fa-500px:before {\n  content: "\\f26e";\n}\n.fa-amazon:before {\n  content: "\\f270";\n}\n.fa-calendar-plus-o:before {\n  content: "\\f271";\n}\n.fa-calendar-minus-o:before {\n  content: "\\f272";\n}\n.fa-calendar-times-o:before {\n  content: "\\f273";\n}\n.fa-calendar-check-o:before {\n  content: "\\f274";\n}\n.fa-industry:before {\n  content: "\\f275";\n}\n.fa-map-pin:before {\n  content: "\\f276";\n}\n.fa-map-signs:before {\n  content: "\\f277";\n}\n.fa-map-o:before {\n  content: "\\f278";\n}\n.fa-map:before {\n  content: "\\f279";\n}\n.fa-commenting:before {\n  content: "\\f27a";\n}\n.fa-commenting-o:before {\n  content: "\\f27b";\n}\n.fa-houzz:before {\n  content: "\\f27c";\n}\n.fa-vimeo:before {\n  content: "\\f27d";\n}\n.fa-black-tie:before {\n  content: "\\f27e";\n}\n.fa-fonticons:before {\n  content: "\\f280";\n}\n.fa-reddit-alien:before {\n  content: "\\f281";\n}\n.fa-edge:before {\n  content: "\\f282";\n}\n.fa-credit-card-alt:before {\n  content: "\\f283";\n}\n.fa-codiepie:before {\n  content: "\\f284";\n}\n.fa-modx:before {\n  content: "\\f285";\n}\n.fa-fort-awesome:before {\n  content: "\\f286";\n}\n.fa-usb:before {\n  content: "\\f287";\n}\n.fa-product-hunt:before {\n  content: "\\f288";\n}\n.fa-mixcloud:before {\n  content: "\\f289";\n}\n.fa-scribd:before {\n  content: "\\f28a";\n}\n.fa-pause-circle:before {\n  content: "\\f28b";\n}\n.fa-pause-circle-o:before {\n  content: "\\f28c";\n}\n.fa-stop-circle:before {\n  content: "\\f28d";\n}\n.fa-stop-circle-o:before {\n  content: "\\f28e";\n}\n.fa-shopping-bag:before {\n  content: "\\f290";\n}\n.fa-shopping-basket:before {\n  content: "\\f291";\n}\n.fa-hashtag:before {\n  content: "\\f292";\n}\n.fa-bluetooth:before {\n  content: "\\f293";\n}\n.fa-bluetooth-b:before {\n  content: "\\f294";\n}\n.fa-percent:before {\n  content: "\\f295";\n}\n.fa-gitlab:before {\n  content: "\\f296";\n}\n.fa-wpbeginner:before {\n  content: "\\f297";\n}\n.fa-wpforms:before {\n  content: "\\f298";\n}\n.fa-envira:before {\n  content: "\\f299";\n}\n.fa-universal-access:before {\n  content: "\\f29a";\n}\n.fa-wheelchair-alt:before {\n  content: "\\f29b";\n}\n.fa-question-circle-o:before {\n  content: "\\f29c";\n}\n.fa-blind:before {\n  content: "\\f29d";\n}\n.fa-audio-description:before {\n  content: "\\f29e";\n}\n.fa-volume-control-phone:before {\n  content: "\\f2a0";\n}\n.fa-braille:before {\n  content: "\\f2a1";\n}\n.fa-assistive-listening-systems:before {\n  content: "\\f2a2";\n}\n.fa-asl-interpreting:before,\n.fa-american-sign-language-interpreting:before {\n  content: "\\f2a3";\n}\n.fa-deafness:before,\n.fa-hard-of-hearing:before,\n.fa-deaf:before {\n  content: "\\f2a4";\n}\n.fa-glide:before {\n  content: "\\f2a5";\n}\n.fa-glide-g:before {\n  content: "\\f2a6";\n}\n.fa-signing:before,\n.fa-sign-language:before {\n  content: "\\f2a7";\n}\n.fa-low-vision:before {\n  content: "\\f2a8";\n}\n.fa-viadeo:before {\n  content: "\\f2a9";\n}\n.fa-viadeo-square:before {\n  content: "\\f2aa";\n}\n.fa-snapchat:before {\n  content: "\\f2ab";\n}\n.fa-snapchat-ghost:before {\n  content: "\\f2ac";\n}\n.fa-snapchat-square:before {\n  content: "\\f2ad";\n}\n.fa-pied-piper:before {\n  content: "\\f2ae";\n}\n.fa-first-order:before {\n  content: "\\f2b0";\n}\n.fa-yoast:before {\n  content: "\\f2b1";\n}\n.fa-themeisle:before {\n  content: "\\f2b2";\n}\n.fa-google-plus-circle:before,\n.fa-google-plus-official:before {\n  content: "\\f2b3";\n}\n.fa-fa:before,\n.fa-font-awesome:before {\n  content: "\\f2b4";\n}\n.fa-handshake-o:before {\n  content: "\\f2b5";\n}\n.fa-envelope-open:before {\n  content: "\\f2b6";\n}\n.fa-envelope-open-o:before {\n  content: "\\f2b7";\n}\n.fa-linode:before {\n  content: "\\f2b8";\n}\n.fa-address-book:before {\n  content: "\\f2b9";\n}\n.fa-address-book-o:before {\n  content: "\\f2ba";\n}\n.fa-vcard:before,\n.fa-address-card:before {\n  content: "\\f2bb";\n}\n.fa-vcard-o:before,\n.fa-address-card-o:before {\n  content: "\\f2bc";\n}\n.fa-user-circle:before {\n  content: "\\f2bd";\n}\n.fa-user-circle-o:before {\n  content: "\\f2be";\n}\n.fa-user-o:before {\n  content: "\\f2c0";\n}\n.fa-id-badge:before {\n  content: "\\f2c1";\n}\n.fa-drivers-license:before,\n.fa-id-card:before {\n  content: "\\f2c2";\n}\n.fa-drivers-license-o:before,\n.fa-id-card-o:before {\n  content: "\\f2c3";\n}\n.fa-quora:before {\n  content: "\\f2c4";\n}\n.fa-free-code-camp:before {\n  content: "\\f2c5";\n}\n.fa-telegram:before {\n  content: "\\f2c6";\n}\n.fa-thermometer-4:before,\n.fa-thermometer:before,\n.fa-thermometer-full:before {\n  content: "\\f2c7";\n}\n.fa-thermometer-3:before,\n.fa-thermometer-three-quarters:before {\n  content: "\\f2c8";\n}\n.fa-thermometer-2:before,\n.fa-thermometer-half:before {\n  content: "\\f2c9";\n}\n.fa-thermometer-1:before,\n.fa-thermometer-quarter:before {\n  content: "\\f2ca";\n}\n.fa-thermometer-0:before,\n.fa-thermometer-empty:before {\n  content: "\\f2cb";\n}\n.fa-shower:before {\n  content: "\\f2cc";\n}\n.fa-bathtub:before,\n.fa-s15:before,\n.fa-bath:before {\n  content: "\\f2cd";\n}\n.fa-podcast:before {\n  content: "\\f2ce";\n}\n.fa-window-maximize:before {\n  content: "\\f2d0";\n}\n.fa-window-minimize:before {\n  content: "\\f2d1";\n}\n.fa-window-restore:before {\n  content: "\\f2d2";\n}\n.fa-times-rectangle:before,\n.fa-window-close:before {\n  content: "\\f2d3";\n}\n.fa-times-rectangle-o:before,\n.fa-window-close-o:before {\n  content: "\\f2d4";\n}\n.fa-bandcamp:before {\n  content: "\\f2d5";\n}\n.fa-grav:before {\n  content: "\\f2d6";\n}\n.fa-etsy:before {\n  content: "\\f2d7";\n}\n.fa-imdb:before {\n  content: "\\f2d8";\n}\n.fa-ravelry:before {\n  content: "\\f2d9";\n}\n.fa-eercast:before {\n  content: "\\f2da";\n}\n.fa-microchip:before {\n  content: "\\f2db";\n}\n.fa-snowflake-o:before {\n  content: "\\f2dc";\n}\n.fa-superpowers:before {\n  content: "\\f2dd";\n}\n.fa-wpexplorer:before {\n  content: "\\f2de";\n}\n.fa-meetup:before {\n  content: "\\f2e0";\n}\n.sr-only {\n  position: absolute;\n  width: 1px;\n  height: 1px;\n  padding: 0;\n  margin: -1px;\n  overflow: hidden;\n  clip: rect(0, 0, 0, 0);\n  border: 0;\n}\n.sr-only-focusable:active,\n.sr-only-focusable:focus {\n  position: static;\n  width: auto;\n  height: auto;\n  margin: 0;\n  overflow: visible;\n  clip: auto;\n}\n.sr-only-focusable:active,\n.sr-only-focusable:focus {\n  position: static;\n  width: auto;\n  height: auto;\n  margin: 0;\n  overflow: visible;\n  clip: auto;\n}\n/*!\n*\n* IPython base\n*\n*/\n.modal.fade .modal-dialog {\n  -webkit-transform: translate(0, 0);\n  -ms-transform: translate(0, 0);\n  -o-transform: translate(0, 0);\n  transform: translate(0, 0);\n}\ncode {\n  color: #000;\n}\npre {\n  font-size: inherit;\n  line-height: inherit;\n}\nlabel {\n  font-weight: normal;\n}\n/* Make the page background atleast 100% the height of the view port */\n/* Make the page itself atleast 70% the height of the view port */\n.border-box-sizing {\n  box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -webkit-box-sizing: border-box;\n}\n.corner-all {\n  border-radius: 2px;\n}\n.no-padding {\n  padding: 0px;\n}\n/* Flexible box model classes */\n/* Taken from Alex Russell http://infrequently.org/2009/08/css-3-progress/ */\n/* This file is a compatability layer.  It allows the usage of flexible box \nmodel layouts accross multiple browsers, including older browsers.  The newest,\nuniversal implementation of the flexible box model is used when available (see\n`Modern browsers` comments below).  Browsers that are known to implement this \nnew spec completely include:\n\n    Firefox 28.0+\n    Chrome 29.0+\n    Internet Explorer 11+ \n    Opera 17.0+\n\nBrowsers not listed, including Safari, are supported via the styling under the\n`Old browsers` comments below.\n*/\n.hbox {\n  /* Old browsers */\n  display: -webkit-box;\n  -webkit-box-orient: horizontal;\n  -webkit-box-align: stretch;\n  display: -moz-box;\n  -moz-box-orient: horizontal;\n  -moz-box-align: stretch;\n  display: box;\n  box-orient: horizontal;\n  box-align: stretch;\n  /* Modern browsers */\n  display: flex;\n  flex-direction: row;\n  align-items: stretch;\n}\n.hbox > * {\n  /* Old browsers */\n  -webkit-box-flex: 0;\n  -moz-box-flex: 0;\n  box-flex: 0;\n  /* Modern browsers */\n  flex: none;\n}\n.vbox {\n  /* Old browsers */\n  display: -webkit-box;\n  -webkit-box-orient: vertical;\n  -webkit-box-align: stretch;\n  display: -moz-box;\n  -moz-box-orient: vertical;\n  -moz-box-align: stretch;\n  display: box;\n  box-orient: vertical;\n  box-align: stretch;\n  /* Modern browsers */\n  display: flex;\n  flex-direction: column;\n  align-items: stretch;\n}\n.vbox > * {\n  /* Old browsers */\n  -webkit-box-flex: 0;\n  -moz-box-flex: 0;\n  box-flex: 0;\n  /* Modern browsers */\n  flex: none;\n}\n.hbox.reverse,\n.vbox.reverse,\n.reverse {\n  /* Old browsers */\n  -webkit-box-direction: reverse;\n  -moz-box-direction: reverse;\n  box-direction: reverse;\n  /* Modern browsers */\n  flex-direction: row-reverse;\n}\n.hbox.box-flex0,\n.vbox.box-flex0,\n.box-flex0 {\n  /* Old browsers */\n  -webkit-box-flex: 0;\n  -moz-box-flex: 0;\n  box-flex: 0;\n  /* Modern browsers */\n  flex: none;\n  width: auto;\n}\n.hbox.box-flex1,\n.vbox.box-flex1,\n.box-flex1 {\n  /* Old browsers */\n  -webkit-box-flex: 1;\n  -moz-box-flex: 1;\n  box-flex: 1;\n  /* Modern browsers */\n  flex: 1;\n}\n.hbox.box-flex,\n.vbox.box-flex,\n.box-flex {\n  /* Old browsers */\n  /* Old browsers */\n  -webkit-box-flex: 1;\n  -moz-box-flex: 1;\n  box-flex: 1;\n  /* Modern browsers */\n  flex: 1;\n}\n.hbox.box-flex2,\n.vbox.box-flex2,\n.box-flex2 {\n  /* Old browsers */\n  -webkit-box-flex: 2;\n  -moz-box-flex: 2;\n  box-flex: 2;\n  /* Modern browsers */\n  flex: 2;\n}\n.box-group1 {\n  /*  Deprecated */\n  -webkit-box-flex-group: 1;\n  -moz-box-flex-group: 1;\n  box-flex-group: 1;\n}\n.box-group2 {\n  /* Deprecated */\n  -webkit-box-flex-group: 2;\n  -moz-box-flex-group: 2;\n  box-flex-group: 2;\n}\n.hbox.start,\n.vbox.start,\n.start {\n  /* Old browsers */\n  -webkit-box-pack: start;\n  -moz-box-pack: start;\n  box-pack: start;\n  /* Modern browsers */\n  justify-content: flex-start;\n}\n.hbox.end,\n.vbox.end,\n.end {\n  /* Old browsers */\n  -webkit-box-pack: end;\n  -moz-box-pack: end;\n  box-pack: end;\n  /* Modern browsers */\n  justify-content: flex-end;\n}\n.hbox.center,\n.vbox.center,\n.center {\n  /* Old browsers */\n  -webkit-box-pack: center;\n  -moz-box-pack: center;\n  box-pack: center;\n  /* Modern browsers */\n  justify-content: center;\n}\n.hbox.baseline,\n.vbox.baseline,\n.baseline {\n  /* Old browsers */\n  -webkit-box-pack: baseline;\n  -moz-box-pack: baseline;\n  box-pack: baseline;\n  /* Modern browsers */\n  justify-content: baseline;\n}\n.hbox.stretch,\n.vbox.stretch,\n.stretch {\n  /* Old browsers */\n  -webkit-box-pack: stretch;\n  -moz-box-pack: stretch;\n  box-pack: stretch;\n  /* Modern browsers */\n  justify-content: stretch;\n}\n.hbox.align-start,\n.vbox.align-start,\n.align-start {\n  /* Old browsers */\n  -webkit-box-align: start;\n  -moz-box-align: start;\n  box-align: start;\n  /* Modern browsers */\n  align-items: flex-start;\n}\n.hbox.align-end,\n.vbox.align-end,\n.align-end {\n  /* Old browsers */\n  -webkit-box-align: end;\n  -moz-box-align: end;\n  box-align: end;\n  /* Modern browsers */\n  align-items: flex-end;\n}\n.hbox.align-center,\n.vbox.align-center,\n.align-center {\n  /* Old browsers */\n  -webkit-box-align: center;\n  -moz-box-align: center;\n  box-align: center;\n  /* Modern browsers */\n  align-items: center;\n}\n.hbox.align-baseline,\n.vbox.align-baseline,\n.align-baseline {\n  /* Old browsers */\n  -webkit-box-align: baseline;\n  -moz-box-align: baseline;\n  box-align: baseline;\n  /* Modern browsers */\n  align-items: baseline;\n}\n.hbox.align-stretch,\n.vbox.align-stretch,\n.align-stretch {\n  /* Old browsers */\n  -webkit-box-align: stretch;\n  -moz-box-align: stretch;\n  box-align: stretch;\n  /* Modern browsers */\n  align-items: stretch;\n}\ndiv.error {\n  margin: 2em;\n  text-align: center;\n}\ndiv.error > h1 {\n  font-size: 500%;\n  line-height: normal;\n}\ndiv.error > p {\n  font-size: 200%;\n  line-height: normal;\n}\ndiv.traceback-wrapper {\n  text-align: left;\n  max-width: 800px;\n  margin: auto;\n}\ndiv.traceback-wrapper pre.traceback {\n  max-height: 600px;\n  overflow: auto;\n}\n/**\n * Primary styles\n *\n * Author: Jupyter Development Team\n */\nbody {\n  background-color: #fff;\n  /* This makes sure that the body covers the entire window and needs to\n       be in a different element than the display: box in wrapper below */\n  position: absolute;\n  left: 0px;\n  right: 0px;\n  top: 0px;\n  bottom: 0px;\n  overflow: visible;\n}\nbody > #header {\n  /* Initially hidden to prevent FLOUC */\n  display: none;\n  background-color: #fff;\n  /* Display over codemirror */\n  position: relative;\n  z-index: 100;\n}\nbody > #header #header-container {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  padding: 5px;\n  padding-bottom: 5px;\n  padding-top: 5px;\n  box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -webkit-box-sizing: border-box;\n}\nbody > #header .header-bar {\n  width: 100%;\n  height: 1px;\n  background: #e7e7e7;\n  margin-bottom: -1px;\n}\n@media print {\n  body > #header {\n    display: none !important;\n  }\n}\n#header-spacer {\n  width: 100%;\n  visibility: hidden;\n}\n@media print {\n  #header-spacer {\n    display: none;\n  }\n}\n#ipython_notebook {\n  padding-left: 0px;\n  padding-top: 1px;\n  padding-bottom: 1px;\n}\n[dir="rtl"] #ipython_notebook {\n  margin-right: 10px;\n  margin-left: 0;\n}\n[dir="rtl"] #ipython_notebook.pull-left {\n  float: right !important;\n  float: right;\n}\n.flex-spacer {\n  flex: 1;\n}\n#noscript {\n  width: auto;\n  padding-top: 16px;\n  padding-bottom: 16px;\n  text-align: center;\n  font-size: 22px;\n  color: red;\n  font-weight: bold;\n}\n#ipython_notebook img {\n  height: 28px;\n}\n#site {\n  width: 100%;\n  display: none;\n  box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -webkit-box-sizing: border-box;\n  overflow: auto;\n}\n@media print {\n  #site {\n    height: auto !important;\n  }\n}\n/* Smaller buttons */\n.ui-button .ui-button-text {\n  padding: 0.2em 0.8em;\n  font-size: 77%;\n}\ninput.ui-button {\n  padding: 0.3em 0.9em;\n}\nspan#kernel_logo_widget {\n  margin: 0 10px;\n}\nspan#login_widget {\n  float: right;\n}\n[dir="rtl"] span#login_widget {\n  float: left;\n}\nspan#login_widget > .button,\n#logout {\n  color: #333;\n  background-color: #fff;\n  border-color: #ccc;\n}\nspan#login_widget > .button:focus,\n#logout:focus,\nspan#login_widget > .button.focus,\n#logout.focus {\n  color: #333;\n  background-color: #e6e6e6;\n  border-color: #8c8c8c;\n}\nspan#login_widget > .button:hover,\n#logout:hover {\n  color: #333;\n  background-color: #e6e6e6;\n  border-color: #adadad;\n}\nspan#login_widget > .button:active,\n#logout:active,\nspan#login_widget > .button.active,\n#logout.active,\n.open > .dropdown-togglespan#login_widget > .button,\n.open > .dropdown-toggle#logout {\n  color: #333;\n  background-color: #e6e6e6;\n  border-color: #adadad;\n}\nspan#login_widget > .button:active:hover,\n#logout:active:hover,\nspan#login_widget > .button.active:hover,\n#logout.active:hover,\n.open > .dropdown-togglespan#login_widget > .button:hover,\n.open > .dropdown-toggle#logout:hover,\nspan#login_widget > .button:active:focus,\n#logout:active:focus,\nspan#login_widget > .button.active:focus,\n#logout.active:focus,\n.open > .dropdown-togglespan#login_widget > .button:focus,\n.open > .dropdown-toggle#logout:focus,\nspan#login_widget > .button:active.focus,\n#logout:active.focus,\nspan#login_widget > .button.active.focus,\n#logout.active.focus,\n.open > .dropdown-togglespan#login_widget > .button.focus,\n.open > .dropdown-toggle#logout.focus {\n  color: #333;\n  background-color: #d4d4d4;\n  border-color: #8c8c8c;\n}\nspan#login_widget > .button:active,\n#logout:active,\nspan#login_widget > .button.active,\n#logout.active,\n.open > .dropdown-togglespan#login_widget > .button,\n.open > .dropdown-toggle#logout {\n  background-image: none;\n}\nspan#login_widget > .button.disabled:hover,\n#logout.disabled:hover,\nspan#login_widget > .button[disabled]:hover,\n#logout[disabled]:hover,\nfieldset[disabled] span#login_widget > .button:hover,\nfieldset[disabled] #logout:hover,\nspan#login_widget > .button.disabled:focus,\n#logout.disabled:focus,\nspan#login_widget > .button[disabled]:focus,\n#logout[disabled]:focus,\nfieldset[disabled] span#login_widget > .button:focus,\nfieldset[disabled] #logout:focus,\nspan#login_widget > .button.disabled.focus,\n#logout.disabled.focus,\nspan#login_widget > .button[disabled].focus,\n#logout[disabled].focus,\nfieldset[disabled] span#login_widget > .button.focus,\nfieldset[disabled] #logout.focus {\n  background-color: #fff;\n  border-color: #ccc;\n}\nspan#login_widget > .button .badge,\n#logout .badge {\n  color: #fff;\n  background-color: #333;\n}\n.nav-header {\n  text-transform: none;\n}\n#header > span {\n  margin-top: 10px;\n}\n.modal_stretch .modal-dialog {\n  /* Old browsers */\n  display: -webkit-box;\n  -webkit-box-orient: vertical;\n  -webkit-box-align: stretch;\n  display: -moz-box;\n  -moz-box-orient: vertical;\n  -moz-box-align: stretch;\n  display: box;\n  box-orient: vertical;\n  box-align: stretch;\n  /* Modern browsers */\n  display: flex;\n  flex-direction: column;\n  align-items: stretch;\n  min-height: 80vh;\n}\n.modal_stretch .modal-dialog .modal-body {\n  max-height: calc(100vh - 200px);\n  overflow: auto;\n  flex: 1;\n}\n.modal-header {\n  cursor: move;\n}\n@media (min-width: 768px) {\n  .modal .modal-dialog {\n    width: 700px;\n  }\n}\n@media (min-width: 768px) {\n  select.form-control {\n    margin-left: 12px;\n    margin-right: 12px;\n  }\n}\n/*!\n*\n* IPython auth\n*\n*/\n.center-nav {\n  display: inline-block;\n  margin-bottom: -4px;\n}\n[dir="rtl"] .center-nav form.pull-left {\n  float: right !important;\n  float: right;\n}\n[dir="rtl"] .center-nav .navbar-text {\n  float: right;\n}\n[dir="rtl"] .navbar-inner {\n  text-align: right;\n}\n[dir="rtl"] div.text-left {\n  text-align: right;\n}\n/*!\n*\n* IPython tree view\n*\n*/\n/* We need an invisible input field on top of the sentense*/\n/* "Drag file onto the list ..." */\n.alternate_upload {\n  background-color: none;\n  display: inline;\n}\n.alternate_upload.form {\n  padding: 0;\n  margin: 0;\n}\n.alternate_upload input.fileinput {\n  position: absolute;\n  display: block;\n  width: 100%;\n  height: 100%;\n  overflow: hidden;\n  cursor: pointer;\n  opacity: 0;\n  z-index: 2;\n}\n.alternate_upload .btn-xs > input.fileinput {\n  margin: -1px -5px;\n}\n.alternate_upload .btn-upload {\n  position: relative;\n  height: 22px;\n}\n::-webkit-file-upload-button {\n  cursor: pointer;\n}\n/**\n * Primary styles\n *\n * Author: Jupyter Development Team\n */\nul#tabs {\n  margin-bottom: 4px;\n}\nul#tabs a {\n  padding-top: 6px;\n  padding-bottom: 4px;\n}\n[dir="rtl"] ul#tabs.nav-tabs > li {\n  float: right;\n}\n[dir="rtl"] ul#tabs.nav.nav-tabs {\n  padding-right: 0;\n}\nul.breadcrumb a:focus,\nul.breadcrumb a:hover {\n  text-decoration: none;\n}\nul.breadcrumb i.icon-home {\n  font-size: 16px;\n  margin-right: 4px;\n}\nul.breadcrumb span {\n  color: #5e5e5e;\n}\n.list_toolbar {\n  padding: 4px 0 4px 0;\n  vertical-align: middle;\n}\n.list_toolbar .tree-buttons {\n  padding-top: 1px;\n}\n[dir="rtl"] .list_toolbar .tree-buttons .pull-right {\n  float: left !important;\n  float: left;\n}\n[dir="rtl"] .list_toolbar .col-sm-4,\n[dir="rtl"] .list_toolbar .col-sm-8 {\n  float: right;\n}\n.dynamic-buttons {\n  padding-top: 3px;\n  display: inline-block;\n}\n.list_toolbar [class*="span"] {\n  min-height: 24px;\n}\n.list_header {\n  font-weight: bold;\n  background-color: #EEE;\n}\n.list_placeholder {\n  font-weight: bold;\n  padding-top: 4px;\n  padding-bottom: 4px;\n  padding-left: 7px;\n  padding-right: 7px;\n}\n.list_container {\n  margin-top: 4px;\n  margin-bottom: 20px;\n  border: 1px solid #ddd;\n  border-radius: 2px;\n}\n.list_container > div {\n  border-bottom: 1px solid #ddd;\n}\n.list_container > div:hover .list-item {\n  background-color: red;\n}\n.list_container > div:last-child {\n  border: none;\n}\n.list_item:hover .list_item {\n  background-color: #ddd;\n}\n.list_item a {\n  text-decoration: none;\n}\n.list_item:hover {\n  background-color: #fafafa;\n}\n.list_header > div,\n.list_item > div {\n  padding-top: 4px;\n  padding-bottom: 4px;\n  padding-left: 7px;\n  padding-right: 7px;\n  line-height: 22px;\n}\n.list_header > div input,\n.list_item > div input {\n  margin-right: 7px;\n  margin-left: 14px;\n  vertical-align: text-bottom;\n  line-height: 22px;\n  position: relative;\n  top: -1px;\n}\n.list_header > div .item_link,\n.list_item > div .item_link {\n  margin-left: -1px;\n  vertical-align: baseline;\n  line-height: 22px;\n}\n[dir="rtl"] .list_item > div input {\n  margin-right: 0;\n}\n.new-file input[type=checkbox] {\n  visibility: hidden;\n}\n.item_name {\n  line-height: 22px;\n  height: 24px;\n}\n.item_icon {\n  font-size: 14px;\n  color: #5e5e5e;\n  margin-right: 7px;\n  margin-left: 7px;\n  line-height: 22px;\n  vertical-align: baseline;\n}\n.item_modified {\n  margin-right: 7px;\n  margin-left: 7px;\n}\n[dir="rtl"] .item_modified.pull-right {\n  float: left !important;\n  float: left;\n}\n.item_buttons {\n  line-height: 1em;\n  margin-left: -5px;\n}\n.item_buttons .btn,\n.item_buttons .btn-group,\n.item_buttons .input-group {\n  float: left;\n}\n.item_buttons > .btn,\n.item_buttons > .btn-group,\n.item_buttons > .input-group {\n  margin-left: 5px;\n}\n.item_buttons .btn {\n  min-width: 13ex;\n}\n.item_buttons .running-indicator {\n  padding-top: 4px;\n  color: #5cb85c;\n}\n.item_buttons .kernel-name {\n  padding-top: 4px;\n  color: #5bc0de;\n  margin-right: 7px;\n  float: left;\n}\n[dir="rtl"] .item_buttons.pull-right {\n  float: left !important;\n  float: left;\n}\n[dir="rtl"] .item_buttons .kernel-name {\n  margin-left: 7px;\n  float: right;\n}\n.toolbar_info {\n  height: 24px;\n  line-height: 24px;\n}\n.list_item input:not([type=checkbox]) {\n  padding-top: 3px;\n  padding-bottom: 3px;\n  height: 22px;\n  line-height: 14px;\n  margin: 0px;\n}\n.highlight_text {\n  color: blue;\n}\n#project_name {\n  display: inline-block;\n  padding-left: 7px;\n  margin-left: -2px;\n}\n#project_name > .breadcrumb {\n  padding: 0px;\n  margin-bottom: 0px;\n  background-color: transparent;\n  font-weight: bold;\n}\n.sort_button {\n  display: inline-block;\n  padding-left: 7px;\n}\n[dir="rtl"] .sort_button.pull-right {\n  float: left !important;\n  float: left;\n}\n#tree-selector {\n  padding-right: 0px;\n}\n#button-select-all {\n  min-width: 50px;\n}\n[dir="rtl"] #button-select-all.btn {\n  float: right ;\n}\n#select-all {\n  margin-left: 7px;\n  margin-right: 2px;\n  margin-top: 2px;\n  height: 16px;\n}\n[dir="rtl"] #select-all.pull-left {\n  float: right !important;\n  float: right;\n}\n.menu_icon {\n  margin-right: 2px;\n}\n.tab-content .row {\n  margin-left: 0px;\n  margin-right: 0px;\n}\n.folder_icon:before {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  content: "\\f114";\n}\n.folder_icon:before.fa-pull-left {\n  margin-right: .3em;\n}\n.folder_icon:before.fa-pull-right {\n  margin-left: .3em;\n}\n.folder_icon:before.pull-left {\n  margin-right: .3em;\n}\n.folder_icon:before.pull-right {\n  margin-left: .3em;\n}\n.notebook_icon:before {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  content: "\\f02d";\n  position: relative;\n  top: -1px;\n}\n.notebook_icon:before.fa-pull-left {\n  margin-right: .3em;\n}\n.notebook_icon:before.fa-pull-right {\n  margin-left: .3em;\n}\n.notebook_icon:before.pull-left {\n  margin-right: .3em;\n}\n.notebook_icon:before.pull-right {\n  margin-left: .3em;\n}\n.running_notebook_icon:before {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  content: "\\f02d";\n  position: relative;\n  top: -1px;\n  color: #5cb85c;\n}\n.running_notebook_icon:before.fa-pull-left {\n  margin-right: .3em;\n}\n.running_notebook_icon:before.fa-pull-right {\n  margin-left: .3em;\n}\n.running_notebook_icon:before.pull-left {\n  margin-right: .3em;\n}\n.running_notebook_icon:before.pull-right {\n  margin-left: .3em;\n}\n.file_icon:before {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  content: "\\f016";\n  position: relative;\n  top: -2px;\n}\n.file_icon:before.fa-pull-left {\n  margin-right: .3em;\n}\n.file_icon:before.fa-pull-right {\n  margin-left: .3em;\n}\n.file_icon:before.pull-left {\n  margin-right: .3em;\n}\n.file_icon:before.pull-right {\n  margin-left: .3em;\n}\n#notebook_toolbar .pull-right {\n  padding-top: 0px;\n  margin-right: -1px;\n}\nul#new-menu {\n  left: auto;\n  right: 0;\n}\n#new-menu .dropdown-header {\n  font-size: 10px;\n  border-bottom: 1px solid #e5e5e5;\n  padding: 0 0 3px;\n  margin: -3px 20px 0;\n}\n.kernel-menu-icon {\n  padding-right: 12px;\n  width: 24px;\n  content: "\\f096";\n}\n.kernel-menu-icon:before {\n  content: "\\f096";\n}\n.kernel-menu-icon-current:before {\n  content: "\\f00c";\n}\n#tab_content {\n  padding-top: 20px;\n}\n#running .panel-group .panel {\n  margin-top: 3px;\n  margin-bottom: 1em;\n}\n#running .panel-group .panel .panel-heading {\n  background-color: #EEE;\n  padding-top: 4px;\n  padding-bottom: 4px;\n  padding-left: 7px;\n  padding-right: 7px;\n  line-height: 22px;\n}\n#running .panel-group .panel .panel-heading a:focus,\n#running .panel-group .panel .panel-heading a:hover {\n  text-decoration: none;\n}\n#running .panel-group .panel .panel-body {\n  padding: 0px;\n}\n#running .panel-group .panel .panel-body .list_container {\n  margin-top: 0px;\n  margin-bottom: 0px;\n  border: 0px;\n  border-radius: 0px;\n}\n#running .panel-group .panel .panel-body .list_container .list_item {\n  border-bottom: 1px solid #ddd;\n}\n#running .panel-group .panel .panel-body .list_container .list_item:last-child {\n  border-bottom: 0px;\n}\n.delete-button {\n  display: none;\n}\n.duplicate-button {\n  display: none;\n}\n.rename-button {\n  display: none;\n}\n.move-button {\n  display: none;\n}\n.download-button {\n  display: none;\n}\n.shutdown-button {\n  display: none;\n}\n.dynamic-instructions {\n  display: inline-block;\n  padding-top: 4px;\n}\n/*!\n*\n* IPython text editor webapp\n*\n*/\n.selected-keymap i.fa {\n  padding: 0px 5px;\n}\n.selected-keymap i.fa:before {\n  content: "\\f00c";\n}\n#mode-menu {\n  overflow: auto;\n  max-height: 20em;\n}\n.edit_app #header {\n  -webkit-box-shadow: 0px 0px 12px 1px rgba(87, 87, 87, 0.2);\n  box-shadow: 0px 0px 12px 1px rgba(87, 87, 87, 0.2);\n}\n.edit_app #menubar .navbar {\n  /* Use a negative 1 bottom margin, so the border overlaps the border of the\n    header */\n  margin-bottom: -1px;\n}\n.dirty-indicator {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  width: 20px;\n}\n.dirty-indicator.fa-pull-left {\n  margin-right: .3em;\n}\n.dirty-indicator.fa-pull-right {\n  margin-left: .3em;\n}\n.dirty-indicator.pull-left {\n  margin-right: .3em;\n}\n.dirty-indicator.pull-right {\n  margin-left: .3em;\n}\n.dirty-indicator-dirty {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  width: 20px;\n}\n.dirty-indicator-dirty.fa-pull-left {\n  margin-right: .3em;\n}\n.dirty-indicator-dirty.fa-pull-right {\n  margin-left: .3em;\n}\n.dirty-indicator-dirty.pull-left {\n  margin-right: .3em;\n}\n.dirty-indicator-dirty.pull-right {\n  margin-left: .3em;\n}\n.dirty-indicator-clean {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  width: 20px;\n}\n.dirty-indicator-clean.fa-pull-left {\n  margin-right: .3em;\n}\n.dirty-indicator-clean.fa-pull-right {\n  margin-left: .3em;\n}\n.dirty-indicator-clean.pull-left {\n  margin-right: .3em;\n}\n.dirty-indicator-clean.pull-right {\n  margin-left: .3em;\n}\n.dirty-indicator-clean:before {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  content: "\\f00c";\n}\n.dirty-indicator-clean:before.fa-pull-left {\n  margin-right: .3em;\n}\n.dirty-indicator-clean:before.fa-pull-right {\n  margin-left: .3em;\n}\n.dirty-indicator-clean:before.pull-left {\n  margin-right: .3em;\n}\n.dirty-indicator-clean:before.pull-right {\n  margin-left: .3em;\n}\n#filename {\n  font-size: 16pt;\n  display: table;\n  padding: 0px 5px;\n}\n#current-mode {\n  padding-left: 5px;\n  padding-right: 5px;\n}\n#texteditor-backdrop {\n  padding-top: 20px;\n  padding-bottom: 20px;\n}\n@media not print {\n  #texteditor-backdrop {\n    background-color: #EEE;\n  }\n}\n@media print {\n  #texteditor-backdrop #texteditor-container .CodeMirror-gutter,\n  #texteditor-backdrop #texteditor-container .CodeMirror-gutters {\n    background-color: #fff;\n  }\n}\n@media not print {\n  #texteditor-backdrop #texteditor-container .CodeMirror-gutter,\n  #texteditor-backdrop #texteditor-container .CodeMirror-gutters {\n    background-color: #fff;\n  }\n}\n@media not print {\n  #texteditor-backdrop #texteditor-container {\n    padding: 0px;\n    background-color: #fff;\n    -webkit-box-shadow: 0px 0px 12px 1px rgba(87, 87, 87, 0.2);\n    box-shadow: 0px 0px 12px 1px rgba(87, 87, 87, 0.2);\n  }\n}\n.CodeMirror-dialog {\n  background-color: #fff;\n}\n/*!\n*\n* IPython notebook\n*\n*/\n/* CSS font colors for translated ANSI escape sequences */\n/* The color values are a mix of\n   http://www.xcolors.net/dl/baskerville-ivorylight and\n   http://www.xcolors.net/dl/euphrasia */\n.ansi-black-fg {\n  color: #3E424D;\n}\n.ansi-black-bg {\n  background-color: #3E424D;\n}\n.ansi-black-intense-fg {\n  color: #282C36;\n}\n.ansi-black-intense-bg {\n  background-color: #282C36;\n}\n.ansi-red-fg {\n  color: #E75C58;\n}\n.ansi-red-bg {\n  background-color: #E75C58;\n}\n.ansi-red-intense-fg {\n  color: #B22B31;\n}\n.ansi-red-intense-bg {\n  background-color: #B22B31;\n}\n.ansi-green-fg {\n  color: #00A250;\n}\n.ansi-green-bg {\n  background-color: #00A250;\n}\n.ansi-green-intense-fg {\n  color: #007427;\n}\n.ansi-green-intense-bg {\n  background-color: #007427;\n}\n.ansi-yellow-fg {\n  color: #DDB62B;\n}\n.ansi-yellow-bg {\n  background-color: #DDB62B;\n}\n.ansi-yellow-intense-fg {\n  color: #B27D12;\n}\n.ansi-yellow-intense-bg {\n  background-color: #B27D12;\n}\n.ansi-blue-fg {\n  color: #208FFB;\n}\n.ansi-blue-bg {\n  background-color: #208FFB;\n}\n.ansi-blue-intense-fg {\n  color: #0065CA;\n}\n.ansi-blue-intense-bg {\n  background-color: #0065CA;\n}\n.ansi-magenta-fg {\n  color: #D160C4;\n}\n.ansi-magenta-bg {\n  background-color: #D160C4;\n}\n.ansi-magenta-intense-fg {\n  color: #A03196;\n}\n.ansi-magenta-intense-bg {\n  background-color: #A03196;\n}\n.ansi-cyan-fg {\n  color: #60C6C8;\n}\n.ansi-cyan-bg {\n  background-color: #60C6C8;\n}\n.ansi-cyan-intense-fg {\n  color: #258F8F;\n}\n.ansi-cyan-intense-bg {\n  background-color: #258F8F;\n}\n.ansi-white-fg {\n  color: #C5C1B4;\n}\n.ansi-white-bg {\n  background-color: #C5C1B4;\n}\n.ansi-white-intense-fg {\n  color: #A1A6B2;\n}\n.ansi-white-intense-bg {\n  background-color: #A1A6B2;\n}\n.ansi-default-inverse-fg {\n  color: #FFFFFF;\n}\n.ansi-default-inverse-bg {\n  background-color: #000000;\n}\n.ansi-bold {\n  font-weight: bold;\n}\n.ansi-underline {\n  text-decoration: underline;\n}\n/* The following styles are deprecated an will be removed in a future version */\n.ansibold {\n  font-weight: bold;\n}\n.ansi-inverse {\n  outline: 0.5px dotted;\n}\n/* use dark versions for foreground, to improve visibility */\n.ansiblack {\n  color: black;\n}\n.ansired {\n  color: darkred;\n}\n.ansigreen {\n  color: darkgreen;\n}\n.ansiyellow {\n  color: #c4a000;\n}\n.ansiblue {\n  color: darkblue;\n}\n.ansipurple {\n  color: darkviolet;\n}\n.ansicyan {\n  color: steelblue;\n}\n.ansigray {\n  color: gray;\n}\n/* and light for background, for the same reason */\n.ansibgblack {\n  background-color: black;\n}\n.ansibgred {\n  background-color: red;\n}\n.ansibggreen {\n  background-color: green;\n}\n.ansibgyellow {\n  background-color: yellow;\n}\n.ansibgblue {\n  background-color: blue;\n}\n.ansibgpurple {\n  background-color: magenta;\n}\n.ansibgcyan {\n  background-color: cyan;\n}\n.ansibggray {\n  background-color: gray;\n}\ndiv.cell {\n  /* Old browsers */\n  display: -webkit-box;\n  -webkit-box-orient: vertical;\n  -webkit-box-align: stretch;\n  display: -moz-box;\n  -moz-box-orient: vertical;\n  -moz-box-align: stretch;\n  display: box;\n  box-orient: vertical;\n  box-align: stretch;\n  /* Modern browsers */\n  display: flex;\n  flex-direction: column;\n  align-items: stretch;\n  border-radius: 2px;\n  box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -webkit-box-sizing: border-box;\n  border-width: 1px;\n  border-style: solid;\n  border-color: transparent;\n  width: 100%;\n  padding: 5px;\n  /* This acts as a spacer between cells, that is outside the border */\n  margin: 0px;\n  outline: none;\n  position: relative;\n  overflow: visible;\n}\ndiv.cell:before {\n  position: absolute;\n  display: block;\n  top: -1px;\n  left: -1px;\n  width: 5px;\n  height: calc(100% +  2px);\n  content: \'\';\n  background: transparent;\n}\ndiv.cell.jupyter-soft-selected {\n  border-left-color: #E3F2FD;\n  border-left-width: 1px;\n  padding-left: 5px;\n  border-right-color: #E3F2FD;\n  border-right-width: 1px;\n  background: #E3F2FD;\n}\n@media print {\n  div.cell.jupyter-soft-selected {\n    border-color: transparent;\n  }\n}\ndiv.cell.selected,\ndiv.cell.selected.jupyter-soft-selected {\n  border-color: #ababab;\n}\ndiv.cell.selected:before,\ndiv.cell.selected.jupyter-soft-selected:before {\n  position: absolute;\n  display: block;\n  top: -1px;\n  left: -1px;\n  width: 5px;\n  height: calc(100% +  2px);\n  content: \'\';\n  background: #42A5F5;\n}\n@media print {\n  div.cell.selected,\n  div.cell.selected.jupyter-soft-selected {\n    border-color: transparent;\n  }\n}\n.edit_mode div.cell.selected {\n  border-color: #66BB6A;\n}\n.edit_mode div.cell.selected:before {\n  position: absolute;\n  display: block;\n  top: -1px;\n  left: -1px;\n  width: 5px;\n  height: calc(100% +  2px);\n  content: \'\';\n  background: #66BB6A;\n}\n@media print {\n  .edit_mode div.cell.selected {\n    border-color: transparent;\n  }\n}\n.prompt {\n  /* This needs to be wide enough for 3 digit prompt numbers: In[100]: */\n  min-width: 14ex;\n  /* This padding is tuned to match the padding on the CodeMirror editor. */\n  padding: 0.4em;\n  margin: 0px;\n  font-family: monospace;\n  text-align: right;\n  /* This has to match that of the the CodeMirror class line-height below */\n  line-height: 1.21429em;\n  /* Don\'t highlight prompt number selection */\n  -webkit-touch-callout: none;\n  -webkit-user-select: none;\n  -khtml-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  /* Use default cursor */\n  cursor: default;\n}\n@media (max-width: 540px) {\n  .prompt {\n    text-align: left;\n  }\n}\ndiv.inner_cell {\n  min-width: 0;\n  /* Old browsers */\n  display: -webkit-box;\n  -webkit-box-orient: vertical;\n  -webkit-box-align: stretch;\n  display: -moz-box;\n  -moz-box-orient: vertical;\n  -moz-box-align: stretch;\n  display: box;\n  box-orient: vertical;\n  box-align: stretch;\n  /* Modern browsers */\n  display: flex;\n  flex-direction: column;\n  align-items: stretch;\n  /* Old browsers */\n  -webkit-box-flex: 1;\n  -moz-box-flex: 1;\n  box-flex: 1;\n  /* Modern browsers */\n  flex: 1;\n}\n/* input_area and input_prompt must match in top border and margin for alignment */\ndiv.input_area {\n  border: 1px solid #cfcfcf;\n  border-radius: 2px;\n  background: #f7f7f7;\n  line-height: 1.21429em;\n}\n/* This is needed so that empty prompt areas can collapse to zero height when there\n   is no content in the output_subarea and the prompt. The main purpose of this is\n   to make sure that empty JavaScript output_subareas have no height. */\ndiv.prompt:empty {\n  padding-top: 0;\n  padding-bottom: 0;\n}\ndiv.unrecognized_cell {\n  padding: 5px 5px 5px 0px;\n  /* Old browsers */\n  display: -webkit-box;\n  -webkit-box-orient: horizontal;\n  -webkit-box-align: stretch;\n  display: -moz-box;\n  -moz-box-orient: horizontal;\n  -moz-box-align: stretch;\n  display: box;\n  box-orient: horizontal;\n  box-align: stretch;\n  /* Modern browsers */\n  display: flex;\n  flex-direction: row;\n  align-items: stretch;\n}\ndiv.unrecognized_cell .inner_cell {\n  border-radius: 2px;\n  padding: 5px;\n  font-weight: bold;\n  color: red;\n  border: 1px solid #cfcfcf;\n  background: #eaeaea;\n}\ndiv.unrecognized_cell .inner_cell a {\n  color: inherit;\n  text-decoration: none;\n}\ndiv.unrecognized_cell .inner_cell a:hover {\n  color: inherit;\n  text-decoration: none;\n}\n@media (max-width: 540px) {\n  div.unrecognized_cell > div.prompt {\n    display: none;\n  }\n}\ndiv.code_cell {\n  /* avoid page breaking on code cells when printing */\n}\n@media print {\n  div.code_cell {\n    page-break-inside: avoid;\n  }\n}\n/* any special styling for code cells that are currently running goes here */\ndiv.input {\n  page-break-inside: avoid;\n  /* Old browsers */\n  display: -webkit-box;\n  -webkit-box-orient: horizontal;\n  -webkit-box-align: stretch;\n  display: -moz-box;\n  -moz-box-orient: horizontal;\n  -moz-box-align: stretch;\n  display: box;\n  box-orient: horizontal;\n  box-align: stretch;\n  /* Modern browsers */\n  display: flex;\n  flex-direction: row;\n  align-items: stretch;\n}\n@media (max-width: 540px) {\n  div.input {\n    /* Old browsers */\n    display: -webkit-box;\n    -webkit-box-orient: vertical;\n    -webkit-box-align: stretch;\n    display: -moz-box;\n    -moz-box-orient: vertical;\n    -moz-box-align: stretch;\n    display: box;\n    box-orient: vertical;\n    box-align: stretch;\n    /* Modern browsers */\n    display: flex;\n    flex-direction: column;\n    align-items: stretch;\n  }\n}\n/* input_area and input_prompt must match in top border and margin for alignment */\ndiv.input_prompt {\n  color: #303F9F;\n  border-top: 1px solid transparent;\n}\ndiv.input_area > div.highlight {\n  margin: 0.4em;\n  border: none;\n  padding: 0px;\n  background-color: transparent;\n}\ndiv.input_area > div.highlight > pre {\n  margin: 0px;\n  border: none;\n  padding: 0px;\n  background-color: transparent;\n}\n/* The following gets added to the <head> if it is detected that the user has a\n * monospace font with inconsistent normal/bold/italic height.  See\n * notebookmain.js.  Such fonts will have keywords vertically offset with\n * respect to the rest of the text.  The user should select a better font.\n * See: https://github.com/ipython/ipython/issues/1503\n *\n * .CodeMirror span {\n *      vertical-align: bottom;\n * }\n */\n.CodeMirror {\n  line-height: 1.21429em;\n  /* Changed from 1em to our global default */\n  font-size: 14px;\n  height: auto;\n  /* Changed to auto to autogrow */\n  background: none;\n  /* Changed from white to allow our bg to show through */\n}\n.CodeMirror-scroll {\n  /*  The CodeMirror docs are a bit fuzzy on if overflow-y should be hidden or visible.*/\n  /*  We have found that if it is visible, vertical scrollbars appear with font size changes.*/\n  overflow-y: hidden;\n  overflow-x: auto;\n}\n.CodeMirror-lines {\n  /* In CM2, this used to be 0.4em, but in CM3 it went to 4px. We need the em value because */\n  /* we have set a different line-height and want this to scale with that. */\n  /* Note that this should set vertical padding only, since CodeMirror assumes\n       that horizontal padding will be set on CodeMirror pre */\n  padding: 0.4em 0;\n}\n.CodeMirror-linenumber {\n  padding: 0 8px 0 4px;\n}\n.CodeMirror-gutters {\n  border-bottom-left-radius: 2px;\n  border-top-left-radius: 2px;\n}\n.CodeMirror pre {\n  /* In CM3 this went to 4px from 0 in CM2. This sets horizontal padding only,\n    use .CodeMirror-lines for vertical */\n  padding: 0 0.4em;\n  border: 0;\n  border-radius: 0;\n}\n.CodeMirror-cursor {\n  border-left: 1.4px solid black;\n}\n@media screen and (min-width: 2138px) and (max-width: 4319px) {\n  .CodeMirror-cursor {\n    border-left: 2px solid black;\n  }\n}\n@media screen and (min-width: 4320px) {\n  .CodeMirror-cursor {\n    border-left: 4px solid black;\n  }\n}\n/*\n\nOriginal style from softwaremaniacs.org (c) Ivan Sagalaev <Maniac@SoftwareManiacs.Org>\nAdapted from GitHub theme\n\n*/\n.highlight-base {\n  color: #000;\n}\n.highlight-variable {\n  color: #000;\n}\n.highlight-variable-2 {\n  color: #1a1a1a;\n}\n.highlight-variable-3 {\n  color: #333333;\n}\n.highlight-string {\n  color: #BA2121;\n}\n.highlight-comment {\n  color: #408080;\n  font-style: italic;\n}\n.highlight-number {\n  color: #080;\n}\n.highlight-atom {\n  color: #88F;\n}\n.highlight-keyword {\n  color: #008000;\n  font-weight: bold;\n}\n.highlight-builtin {\n  color: #008000;\n}\n.highlight-error {\n  color: #f00;\n}\n.highlight-operator {\n  color: #AA22FF;\n  font-weight: bold;\n}\n.highlight-meta {\n  color: #AA22FF;\n}\n/* previously not defined, copying from default codemirror */\n.highlight-def {\n  color: #00f;\n}\n.highlight-string-2 {\n  color: #f50;\n}\n.highlight-qualifier {\n  color: #555;\n}\n.highlight-bracket {\n  color: #997;\n}\n.highlight-tag {\n  color: #170;\n}\n.highlight-attribute {\n  color: #00c;\n}\n.highlight-header {\n  color: blue;\n}\n.highlight-quote {\n  color: #090;\n}\n.highlight-link {\n  color: #00c;\n}\n/* apply the same style to codemirror */\n.cm-s-ipython span.cm-keyword {\n  color: #008000;\n  font-weight: bold;\n}\n.cm-s-ipython span.cm-atom {\n  color: #88F;\n}\n.cm-s-ipython span.cm-number {\n  color: #080;\n}\n.cm-s-ipython span.cm-def {\n  color: #00f;\n}\n.cm-s-ipython span.cm-variable {\n  color: #000;\n}\n.cm-s-ipython span.cm-operator {\n  color: #AA22FF;\n  font-weight: bold;\n}\n.cm-s-ipython span.cm-variable-2 {\n  color: #1a1a1a;\n}\n.cm-s-ipython span.cm-variable-3 {\n  color: #333333;\n}\n.cm-s-ipython span.cm-comment {\n  color: #408080;\n  font-style: italic;\n}\n.cm-s-ipython span.cm-string {\n  color: #BA2121;\n}\n.cm-s-ipython span.cm-string-2 {\n  color: #f50;\n}\n.cm-s-ipython span.cm-meta {\n  color: #AA22FF;\n}\n.cm-s-ipython span.cm-qualifier {\n  color: #555;\n}\n.cm-s-ipython span.cm-builtin {\n  color: #008000;\n}\n.cm-s-ipython span.cm-bracket {\n  color: #997;\n}\n.cm-s-ipython span.cm-tag {\n  color: #170;\n}\n.cm-s-ipython span.cm-attribute {\n  color: #00c;\n}\n.cm-s-ipython span.cm-header {\n  color: blue;\n}\n.cm-s-ipython span.cm-quote {\n  color: #090;\n}\n.cm-s-ipython span.cm-link {\n  color: #00c;\n}\n.cm-s-ipython span.cm-error {\n  color: #f00;\n}\n.cm-s-ipython span.cm-tab {\n  background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAMCAYAAAAkuj5RAAAAAXNSR0IArs4c6QAAAGFJREFUSMft1LsRQFAQheHPowAKoACx3IgEKtaEHujDjORSgWTH/ZOdnZOcM/sgk/kFFWY0qV8foQwS4MKBCS3qR6ixBJvElOobYAtivseIE120FaowJPN75GMu8j/LfMwNjh4HUpwg4LUAAAAASUVORK5CYII=);\n  background-position: right;\n  background-repeat: no-repeat;\n}\ndiv.output_wrapper {\n  /* this position must be relative to enable descendents to be absolute within it */\n  position: relative;\n  /* Old browsers */\n  display: -webkit-box;\n  -webkit-box-orient: vertical;\n  -webkit-box-align: stretch;\n  display: -moz-box;\n  -moz-box-orient: vertical;\n  -moz-box-align: stretch;\n  display: box;\n  box-orient: vertical;\n  box-align: stretch;\n  /* Modern browsers */\n  display: flex;\n  flex-direction: column;\n  align-items: stretch;\n  z-index: 1;\n}\n/* class for the output area when it should be height-limited */\ndiv.output_scroll {\n  /* ideally, this would be max-height, but FF barfs all over that */\n  height: 24em;\n  /* FF needs this *and the wrapper* to specify full width, or it will shrinkwrap */\n  width: 100%;\n  overflow: auto;\n  border-radius: 2px;\n  -webkit-box-shadow: inset 0 2px 8px rgba(0, 0, 0, 0.8);\n  box-shadow: inset 0 2px 8px rgba(0, 0, 0, 0.8);\n  display: block;\n}\n/* output div while it is collapsed */\ndiv.output_collapsed {\n  margin: 0px;\n  padding: 0px;\n  /* Old browsers */\n  display: -webkit-box;\n  -webkit-box-orient: vertical;\n  -webkit-box-align: stretch;\n  display: -moz-box;\n  -moz-box-orient: vertical;\n  -moz-box-align: stretch;\n  display: box;\n  box-orient: vertical;\n  box-align: stretch;\n  /* Modern browsers */\n  display: flex;\n  flex-direction: column;\n  align-items: stretch;\n}\ndiv.out_prompt_overlay {\n  height: 100%;\n  padding: 0px 0.4em;\n  position: absolute;\n  border-radius: 2px;\n}\ndiv.out_prompt_overlay:hover {\n  /* use inner shadow to get border that is computed the same on WebKit/FF */\n  -webkit-box-shadow: inset 0 0 1px #000;\n  box-shadow: inset 0 0 1px #000;\n  background: rgba(240, 240, 240, 0.5);\n}\ndiv.output_prompt {\n  color: #D84315;\n}\n/* This class is the outer container of all output sections. */\ndiv.output_area {\n  padding: 0px;\n  page-break-inside: avoid;\n  /* Old browsers */\n  display: -webkit-box;\n  -webkit-box-orient: horizontal;\n  -webkit-box-align: stretch;\n  display: -moz-box;\n  -moz-box-orient: horizontal;\n  -moz-box-align: stretch;\n  display: box;\n  box-orient: horizontal;\n  box-align: stretch;\n  /* Modern browsers */\n  display: flex;\n  flex-direction: row;\n  align-items: stretch;\n}\ndiv.output_area .MathJax_Display {\n  text-align: left !important;\n}\ndiv.output_area .rendered_html table {\n  margin-left: 0;\n  margin-right: 0;\n}\ndiv.output_area .rendered_html img {\n  margin-left: 0;\n  margin-right: 0;\n}\ndiv.output_area img,\ndiv.output_area svg {\n  max-width: 100%;\n  height: auto;\n}\ndiv.output_area img.unconfined,\ndiv.output_area svg.unconfined {\n  max-width: none;\n}\ndiv.output_area .mglyph > img {\n  max-width: none;\n}\n/* This is needed to protect the pre formating from global settings such\n   as that of bootstrap */\n.output {\n  /* Old browsers */\n  display: -webkit-box;\n  -webkit-box-orient: vertical;\n  -webkit-box-align: stretch;\n  display: -moz-box;\n  -moz-box-orient: vertical;\n  -moz-box-align: stretch;\n  display: box;\n  box-orient: vertical;\n  box-align: stretch;\n  /* Modern browsers */\n  display: flex;\n  flex-direction: column;\n  align-items: stretch;\n}\n@media (max-width: 540px) {\n  div.output_area {\n    /* Old browsers */\n    display: -webkit-box;\n    -webkit-box-orient: vertical;\n    -webkit-box-align: stretch;\n    display: -moz-box;\n    -moz-box-orient: vertical;\n    -moz-box-align: stretch;\n    display: box;\n    box-orient: vertical;\n    box-align: stretch;\n    /* Modern browsers */\n    display: flex;\n    flex-direction: column;\n    align-items: stretch;\n  }\n}\ndiv.output_area pre {\n  margin: 0;\n  padding: 1px 0 1px 0;\n  border: 0;\n  vertical-align: baseline;\n  color: black;\n  background-color: transparent;\n  border-radius: 0;\n}\n/* This class is for the output subarea inside the output_area and after\n   the prompt div. */\ndiv.output_subarea {\n  overflow-x: auto;\n  padding: 0.4em;\n  /* Old browsers */\n  -webkit-box-flex: 1;\n  -moz-box-flex: 1;\n  box-flex: 1;\n  /* Modern browsers */\n  flex: 1;\n  max-width: calc(100% - 14ex);\n}\ndiv.output_scroll div.output_subarea {\n  overflow-x: visible;\n}\n/* The rest of the output_* classes are for special styling of the different\n   output types */\n/* all text output has this class: */\ndiv.output_text {\n  text-align: left;\n  color: #000;\n  /* This has to match that of the the CodeMirror class line-height below */\n  line-height: 1.21429em;\n}\n/* stdout/stderr are \'text\' as well as \'stream\', but execute_result/error are *not* streams */\ndiv.output_stderr {\n  background: #fdd;\n  /* very light red background for stderr */\n}\ndiv.output_latex {\n  text-align: left;\n}\n/* Empty output_javascript divs should have no height */\ndiv.output_javascript:empty {\n  padding: 0;\n}\n.js-error {\n  color: darkred;\n}\n/* raw_input styles */\ndiv.raw_input_container {\n  line-height: 1.21429em;\n  padding-top: 5px;\n}\npre.raw_input_prompt {\n  /* nothing needed here. */\n}\ninput.raw_input {\n  font-family: monospace;\n  font-size: inherit;\n  color: inherit;\n  width: auto;\n  /* make sure input baseline aligns with prompt */\n  vertical-align: baseline;\n  /* padding + margin = 0.5em between prompt and cursor */\n  padding: 0em 0.25em;\n  margin: 0em 0.25em;\n}\ninput.raw_input:focus {\n  box-shadow: none;\n}\np.p-space {\n  margin-bottom: 10px;\n}\ndiv.output_unrecognized {\n  padding: 5px;\n  font-weight: bold;\n  color: red;\n}\ndiv.output_unrecognized a {\n  color: inherit;\n  text-decoration: none;\n}\ndiv.output_unrecognized a:hover {\n  color: inherit;\n  text-decoration: none;\n}\n.rendered_html {\n  color: #000;\n  /* any extras will just be numbers: */\n}\n.rendered_html em {\n  font-style: italic;\n}\n.rendered_html strong {\n  font-weight: bold;\n}\n.rendered_html u {\n  text-decoration: underline;\n}\n.rendered_html :link {\n  text-decoration: underline;\n}\n.rendered_html :visited {\n  text-decoration: underline;\n}\n.rendered_html h1 {\n  font-size: 185.7%;\n  margin: 1.08em 0 0 0;\n  font-weight: bold;\n  line-height: 1.0;\n}\n.rendered_html h2 {\n  font-size: 157.1%;\n  margin: 1.27em 0 0 0;\n  font-weight: bold;\n  line-height: 1.0;\n}\n.rendered_html h3 {\n  font-size: 128.6%;\n  margin: 1.55em 0 0 0;\n  font-weight: bold;\n  line-height: 1.0;\n}\n.rendered_html h4 {\n  font-size: 100%;\n  margin: 2em 0 0 0;\n  font-weight: bold;\n  line-height: 1.0;\n}\n.rendered_html h5 {\n  font-size: 100%;\n  margin: 2em 0 0 0;\n  font-weight: bold;\n  line-height: 1.0;\n  font-style: italic;\n}\n.rendered_html h6 {\n  font-size: 100%;\n  margin: 2em 0 0 0;\n  font-weight: bold;\n  line-height: 1.0;\n  font-style: italic;\n}\n.rendered_html h1:first-child {\n  margin-top: 0.538em;\n}\n.rendered_html h2:first-child {\n  margin-top: 0.636em;\n}\n.rendered_html h3:first-child {\n  margin-top: 0.777em;\n}\n.rendered_html h4:first-child {\n  margin-top: 1em;\n}\n.rendered_html h5:first-child {\n  margin-top: 1em;\n}\n.rendered_html h6:first-child {\n  margin-top: 1em;\n}\n.rendered_html ul:not(.list-inline),\n.rendered_html ol:not(.list-inline) {\n  padding-left: 2em;\n}\n.rendered_html ul {\n  list-style: disc;\n}\n.rendered_html ul ul {\n  list-style: square;\n  margin-top: 0;\n}\n.rendered_html ul ul ul {\n  list-style: circle;\n}\n.rendered_html ol {\n  list-style: decimal;\n}\n.rendered_html ol ol {\n  list-style: upper-alpha;\n  margin-top: 0;\n}\n.rendered_html ol ol ol {\n  list-style: lower-alpha;\n}\n.rendered_html ol ol ol ol {\n  list-style: lower-roman;\n}\n.rendered_html ol ol ol ol ol {\n  list-style: decimal;\n}\n.rendered_html * + ul {\n  margin-top: 1em;\n}\n.rendered_html * + ol {\n  margin-top: 1em;\n}\n.rendered_html hr {\n  color: black;\n  background-color: black;\n}\n.rendered_html pre {\n  margin: 1em 2em;\n  padding: 0px;\n  background-color: #fff;\n}\n.rendered_html code {\n  background-color: #eff0f1;\n}\n.rendered_html p code {\n  padding: 1px 5px;\n}\n.rendered_html pre code {\n  background-color: #fff;\n}\n.rendered_html pre,\n.rendered_html code {\n  border: 0;\n  color: #000;\n  font-size: 100%;\n}\n.rendered_html blockquote {\n  margin: 1em 2em;\n}\n.rendered_html table {\n  margin-left: auto;\n  margin-right: auto;\n  border: none;\n  border-collapse: collapse;\n  border-spacing: 0;\n  color: black;\n  font-size: 12px;\n  table-layout: fixed;\n}\n.rendered_html thead {\n  border-bottom: 1px solid black;\n  vertical-align: bottom;\n}\n.rendered_html tr,\n.rendered_html th,\n.rendered_html td {\n  text-align: right;\n  vertical-align: middle;\n  padding: 0.5em 0.5em;\n  line-height: normal;\n  white-space: normal;\n  max-width: none;\n  border: none;\n}\n.rendered_html th {\n  font-weight: bold;\n}\n.rendered_html tbody tr:nth-child(odd) {\n  background: #f5f5f5;\n}\n.rendered_html tbody tr:hover {\n  background: rgba(66, 165, 245, 0.2);\n}\n.rendered_html * + table {\n  margin-top: 1em;\n}\n.rendered_html p {\n  text-align: left;\n}\n.rendered_html * + p {\n  margin-top: 1em;\n}\n.rendered_html img {\n  display: block;\n  margin-left: auto;\n  margin-right: auto;\n}\n.rendered_html * + img {\n  margin-top: 1em;\n}\n.rendered_html img,\n.rendered_html svg {\n  max-width: 100%;\n  height: auto;\n}\n.rendered_html img.unconfined,\n.rendered_html svg.unconfined {\n  max-width: none;\n}\n.rendered_html .alert {\n  margin-bottom: initial;\n}\n.rendered_html * + .alert {\n  margin-top: 1em;\n}\n[dir="rtl"] .rendered_html p {\n  text-align: right;\n}\ndiv.text_cell {\n  /* Old browsers */\n  display: -webkit-box;\n  -webkit-box-orient: horizontal;\n  -webkit-box-align: stretch;\n  display: -moz-box;\n  -moz-box-orient: horizontal;\n  -moz-box-align: stretch;\n  display: box;\n  box-orient: horizontal;\n  box-align: stretch;\n  /* Modern browsers */\n  display: flex;\n  flex-direction: row;\n  align-items: stretch;\n}\n@media (max-width: 540px) {\n  div.text_cell > div.prompt {\n    display: none;\n  }\n}\ndiv.text_cell_render {\n  /*font-family: "Helvetica Neue", Arial, Helvetica, Geneva, sans-serif;*/\n  outline: none;\n  resize: none;\n  width: inherit;\n  border-style: none;\n  padding: 0.5em 0.5em 0.5em 0.4em;\n  color: #000;\n  box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -webkit-box-sizing: border-box;\n}\na.anchor-link:link {\n  text-decoration: none;\n  padding: 0px 20px;\n  visibility: hidden;\n}\nh1:hover .anchor-link,\nh2:hover .anchor-link,\nh3:hover .anchor-link,\nh4:hover .anchor-link,\nh5:hover .anchor-link,\nh6:hover .anchor-link {\n  visibility: visible;\n}\n.text_cell.rendered .input_area {\n  display: none;\n}\n.text_cell.rendered .rendered_html {\n  overflow-x: auto;\n  overflow-y: hidden;\n}\n.text_cell.rendered .rendered_html tr,\n.text_cell.rendered .rendered_html th,\n.text_cell.rendered .rendered_html td {\n  max-width: none;\n}\n.text_cell.unrendered .text_cell_render {\n  display: none;\n}\n.text_cell .dropzone .input_area {\n  border: 2px dashed #bababa;\n  margin: -1px;\n}\n.cm-header-1,\n.cm-header-2,\n.cm-header-3,\n.cm-header-4,\n.cm-header-5,\n.cm-header-6 {\n  font-weight: bold;\n  font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;\n}\n.cm-header-1 {\n  font-size: 185.7%;\n}\n.cm-header-2 {\n  font-size: 157.1%;\n}\n.cm-header-3 {\n  font-size: 128.6%;\n}\n.cm-header-4 {\n  font-size: 110%;\n}\n.cm-header-5 {\n  font-size: 100%;\n  font-style: italic;\n}\n.cm-header-6 {\n  font-size: 100%;\n  font-style: italic;\n}\n/*!\n*\n* IPython notebook webapp\n*\n*/\n@media (max-width: 767px) {\n  .notebook_app {\n    padding-left: 0px;\n    padding-right: 0px;\n  }\n}\n#ipython-main-app {\n  box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -webkit-box-sizing: border-box;\n  height: 100%;\n}\ndiv#notebook_panel {\n  margin: 0px;\n  padding: 0px;\n  box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -webkit-box-sizing: border-box;\n  height: 100%;\n}\ndiv#notebook {\n  font-size: 14px;\n  line-height: 20px;\n  overflow-y: hidden;\n  overflow-x: auto;\n  width: 100%;\n  /* This spaces the page away from the edge of the notebook area */\n  padding-top: 20px;\n  margin: 0px;\n  outline: none;\n  box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -webkit-box-sizing: border-box;\n  min-height: 100%;\n}\n@media not print {\n  #notebook-container {\n    padding: 15px;\n    background-color: #fff;\n    min-height: 0;\n    -webkit-box-shadow: 0px 0px 12px 1px rgba(87, 87, 87, 0.2);\n    box-shadow: 0px 0px 12px 1px rgba(87, 87, 87, 0.2);\n  }\n}\n@media print {\n  #notebook-container {\n    width: 100%;\n  }\n}\ndiv.ui-widget-content {\n  border: 1px solid #ababab;\n  outline: none;\n}\npre.dialog {\n  background-color: #f7f7f7;\n  border: 1px solid #ddd;\n  border-radius: 2px;\n  padding: 0.4em;\n  padding-left: 2em;\n}\np.dialog {\n  padding: 0.2em;\n}\n/* Word-wrap output correctly.  This is the CSS3 spelling, though Firefox seems\n   to not honor it correctly.  Webkit browsers (Chrome, rekonq, Safari) do.\n */\npre,\ncode,\nkbd,\nsamp {\n  white-space: pre-wrap;\n}\n#fonttest {\n  font-family: monospace;\n}\np {\n  margin-bottom: 0;\n}\n.end_space {\n  min-height: 100px;\n  transition: height .2s ease;\n}\n.notebook_app > #header {\n  -webkit-box-shadow: 0px 0px 12px 1px rgba(87, 87, 87, 0.2);\n  box-shadow: 0px 0px 12px 1px rgba(87, 87, 87, 0.2);\n}\n@media not print {\n  .notebook_app {\n    background-color: #EEE;\n  }\n}\nkbd {\n  border-style: solid;\n  border-width: 1px;\n  box-shadow: none;\n  margin: 2px;\n  padding-left: 2px;\n  padding-right: 2px;\n  padding-top: 1px;\n  padding-bottom: 1px;\n}\n.jupyter-keybindings {\n  padding: 1px;\n  line-height: 24px;\n  border-bottom: 1px solid gray;\n}\n.jupyter-keybindings input {\n  margin: 0;\n  padding: 0;\n  border: none;\n}\n.jupyter-keybindings i {\n  padding: 6px;\n}\n.well code {\n  background-color: #ffffff;\n  border-color: #ababab;\n  border-width: 1px;\n  border-style: solid;\n  padding: 2px;\n  padding-top: 1px;\n  padding-bottom: 1px;\n}\n/* CSS for the cell toolbar */\n.celltoolbar {\n  border: thin solid #CFCFCF;\n  border-bottom: none;\n  background: #EEE;\n  border-radius: 2px 2px 0px 0px;\n  width: 100%;\n  height: 29px;\n  padding-right: 4px;\n  /* Old browsers */\n  display: -webkit-box;\n  -webkit-box-orient: horizontal;\n  -webkit-box-align: stretch;\n  display: -moz-box;\n  -moz-box-orient: horizontal;\n  -moz-box-align: stretch;\n  display: box;\n  box-orient: horizontal;\n  box-align: stretch;\n  /* Modern browsers */\n  display: flex;\n  flex-direction: row;\n  align-items: stretch;\n  /* Old browsers */\n  -webkit-box-pack: end;\n  -moz-box-pack: end;\n  box-pack: end;\n  /* Modern browsers */\n  justify-content: flex-end;\n  display: -webkit-flex;\n}\n@media print {\n  .celltoolbar {\n    display: none;\n  }\n}\n.ctb_hideshow {\n  display: none;\n  vertical-align: bottom;\n}\n/* ctb_show is added to the ctb_hideshow div to show the cell toolbar.\n   Cell toolbars are only shown when the ctb_global_show class is also set.\n*/\n.ctb_global_show .ctb_show.ctb_hideshow {\n  display: block;\n}\n.ctb_global_show .ctb_show + .input_area,\n.ctb_global_show .ctb_show + div.text_cell_input,\n.ctb_global_show .ctb_show ~ div.text_cell_render {\n  border-top-right-radius: 0px;\n  border-top-left-radius: 0px;\n}\n.ctb_global_show .ctb_show ~ div.text_cell_render {\n  border: 1px solid #cfcfcf;\n}\n.celltoolbar {\n  font-size: 87%;\n  padding-top: 3px;\n}\n.celltoolbar select {\n  display: block;\n  width: 100%;\n  height: 32px;\n  padding: 6px 12px;\n  font-size: 13px;\n  line-height: 1.42857143;\n  color: #555555;\n  background-color: #fff;\n  background-image: none;\n  border: 1px solid #ccc;\n  border-radius: 2px;\n  -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);\n  box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);\n  -webkit-transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;\n  -o-transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;\n  transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;\n  height: 30px;\n  padding: 5px 10px;\n  font-size: 12px;\n  line-height: 1.5;\n  border-radius: 1px;\n  width: inherit;\n  font-size: inherit;\n  height: 22px;\n  padding: 0px;\n  display: inline-block;\n}\n.celltoolbar select:focus {\n  border-color: #66afe9;\n  outline: 0;\n  -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px rgba(102, 175, 233, 0.6);\n  box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px rgba(102, 175, 233, 0.6);\n}\n.celltoolbar select::-moz-placeholder {\n  color: #999;\n  opacity: 1;\n}\n.celltoolbar select:-ms-input-placeholder {\n  color: #999;\n}\n.celltoolbar select::-webkit-input-placeholder {\n  color: #999;\n}\n.celltoolbar select::-ms-expand {\n  border: 0;\n  background-color: transparent;\n}\n.celltoolbar select[disabled],\n.celltoolbar select[readonly],\nfieldset[disabled] .celltoolbar select {\n  background-color: #eeeeee;\n  opacity: 1;\n}\n.celltoolbar select[disabled],\nfieldset[disabled] .celltoolbar select {\n  cursor: not-allowed;\n}\ntextarea.celltoolbar select {\n  height: auto;\n}\nselect.celltoolbar select {\n  height: 30px;\n  line-height: 30px;\n}\ntextarea.celltoolbar select,\nselect[multiple].celltoolbar select {\n  height: auto;\n}\n.celltoolbar label {\n  margin-left: 5px;\n  margin-right: 5px;\n}\n.tags_button_container {\n  width: 100%;\n  display: flex;\n}\n.tag-container {\n  display: flex;\n  flex-direction: row;\n  flex-grow: 1;\n  overflow: hidden;\n  position: relative;\n}\n.tag-container > * {\n  margin: 0 4px;\n}\n.remove-tag-btn {\n  margin-left: 4px;\n}\n.tags-input {\n  display: flex;\n}\n.cell-tag:last-child:after {\n  content: "";\n  position: absolute;\n  right: 0;\n  width: 40px;\n  height: 100%;\n  /* Fade to background color of cell toolbar */\n  background: linear-gradient(to right, rgba(0, 0, 0, 0), #EEE);\n}\n.tags-input > * {\n  margin-left: 4px;\n}\n.cell-tag,\n.tags-input input,\n.tags-input button {\n  display: block;\n  width: 100%;\n  height: 32px;\n  padding: 6px 12px;\n  font-size: 13px;\n  line-height: 1.42857143;\n  color: #555555;\n  background-color: #fff;\n  background-image: none;\n  border: 1px solid #ccc;\n  border-radius: 2px;\n  -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);\n  box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);\n  -webkit-transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;\n  -o-transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;\n  transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;\n  height: 30px;\n  padding: 5px 10px;\n  font-size: 12px;\n  line-height: 1.5;\n  border-radius: 1px;\n  box-shadow: none;\n  width: inherit;\n  font-size: inherit;\n  height: 22px;\n  line-height: 22px;\n  padding: 0px 4px;\n  display: inline-block;\n}\n.cell-tag:focus,\n.tags-input input:focus,\n.tags-input button:focus {\n  border-color: #66afe9;\n  outline: 0;\n  -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px rgba(102, 175, 233, 0.6);\n  box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px rgba(102, 175, 233, 0.6);\n}\n.cell-tag::-moz-placeholder,\n.tags-input input::-moz-placeholder,\n.tags-input button::-moz-placeholder {\n  color: #999;\n  opacity: 1;\n}\n.cell-tag:-ms-input-placeholder,\n.tags-input input:-ms-input-placeholder,\n.tags-input button:-ms-input-placeholder {\n  color: #999;\n}\n.cell-tag::-webkit-input-placeholder,\n.tags-input input::-webkit-input-placeholder,\n.tags-input button::-webkit-input-placeholder {\n  color: #999;\n}\n.cell-tag::-ms-expand,\n.tags-input input::-ms-expand,\n.tags-input button::-ms-expand {\n  border: 0;\n  background-color: transparent;\n}\n.cell-tag[disabled],\n.tags-input input[disabled],\n.tags-input button[disabled],\n.cell-tag[readonly],\n.tags-input input[readonly],\n.tags-input button[readonly],\nfieldset[disabled] .cell-tag,\nfieldset[disabled] .tags-input input,\nfieldset[disabled] .tags-input button {\n  background-color: #eeeeee;\n  opacity: 1;\n}\n.cell-tag[disabled],\n.tags-input input[disabled],\n.tags-input button[disabled],\nfieldset[disabled] .cell-tag,\nfieldset[disabled] .tags-input input,\nfieldset[disabled] .tags-input button {\n  cursor: not-allowed;\n}\ntextarea.cell-tag,\ntextarea.tags-input input,\ntextarea.tags-input button {\n  height: auto;\n}\nselect.cell-tag,\nselect.tags-input input,\nselect.tags-input button {\n  height: 30px;\n  line-height: 30px;\n}\ntextarea.cell-tag,\ntextarea.tags-input input,\ntextarea.tags-input button,\nselect[multiple].cell-tag,\nselect[multiple].tags-input input,\nselect[multiple].tags-input button {\n  height: auto;\n}\n.cell-tag,\n.tags-input button {\n  padding: 0px 4px;\n}\n.cell-tag {\n  background-color: #fff;\n  white-space: nowrap;\n}\n.tags-input input[type=text]:focus {\n  outline: none;\n  box-shadow: none;\n  border-color: #ccc;\n}\n.completions {\n  position: absolute;\n  z-index: 110;\n  overflow: hidden;\n  border: 1px solid #ababab;\n  border-radius: 2px;\n  -webkit-box-shadow: 0px 6px 10px -1px #adadad;\n  box-shadow: 0px 6px 10px -1px #adadad;\n  line-height: 1;\n}\n.completions select {\n  background: white;\n  outline: none;\n  border: none;\n  padding: 0px;\n  margin: 0px;\n  overflow: auto;\n  font-family: monospace;\n  font-size: 110%;\n  color: #000;\n  width: auto;\n}\n.completions select option.context {\n  color: #286090;\n}\n#kernel_logo_widget .current_kernel_logo {\n  display: none;\n  margin-top: -1px;\n  margin-bottom: -1px;\n  width: 32px;\n  height: 32px;\n}\n[dir="rtl"] #kernel_logo_widget {\n  float: left !important;\n  float: left;\n}\n.modal .modal-body .move-path {\n  display: flex;\n  flex-direction: row;\n  justify-content: space;\n  align-items: center;\n}\n.modal .modal-body .move-path .server-root {\n  padding-right: 20px;\n}\n.modal .modal-body .move-path .path-input {\n  flex: 1;\n}\n#menubar {\n  box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -webkit-box-sizing: border-box;\n  margin-top: 1px;\n}\n#menubar .navbar {\n  border-top: 1px;\n  border-radius: 0px 0px 2px 2px;\n  margin-bottom: 0px;\n}\n#menubar .navbar-toggle {\n  float: left;\n  padding-top: 7px;\n  padding-bottom: 7px;\n  border: none;\n}\n#menubar .navbar-collapse {\n  clear: left;\n}\n[dir="rtl"] #menubar .navbar-toggle {\n  float: right;\n}\n[dir="rtl"] #menubar .navbar-collapse {\n  clear: right;\n}\n[dir="rtl"] #menubar .navbar-nav {\n  float: right;\n}\n[dir="rtl"] #menubar .nav {\n  padding-right: 0px;\n}\n[dir="rtl"] #menubar .navbar-nav > li {\n  float: right;\n}\n[dir="rtl"] #menubar .navbar-right {\n  float: left !important;\n}\n[dir="rtl"] ul.dropdown-menu {\n  text-align: right;\n  left: auto;\n}\n[dir="rtl"] ul#new-menu.dropdown-menu {\n  right: auto;\n  left: 0;\n}\n.nav-wrapper {\n  border-bottom: 1px solid #e7e7e7;\n}\ni.menu-icon {\n  padding-top: 4px;\n}\n[dir="rtl"] i.menu-icon.pull-right {\n  float: left !important;\n  float: left;\n}\nul#help_menu li a {\n  overflow: hidden;\n  padding-right: 2.2em;\n}\nul#help_menu li a i {\n  margin-right: -1.2em;\n}\n[dir="rtl"] ul#help_menu li a {\n  padding-left: 2.2em;\n}\n[dir="rtl"] ul#help_menu li a i {\n  margin-right: 0;\n  margin-left: -1.2em;\n}\n[dir="rtl"] ul#help_menu li a i.pull-right {\n  float: left !important;\n  float: left;\n}\n.dropdown-submenu {\n  position: relative;\n}\n.dropdown-submenu > .dropdown-menu {\n  top: 0;\n  left: 100%;\n  margin-top: -6px;\n  margin-left: -1px;\n}\n[dir="rtl"] .dropdown-submenu > .dropdown-menu {\n  right: 100%;\n  margin-right: -1px;\n}\n.dropdown-submenu:hover > .dropdown-menu {\n  display: block;\n}\n.dropdown-submenu > a:after {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  display: block;\n  content: "\\f0da";\n  float: right;\n  color: #333333;\n  margin-top: 2px;\n  margin-right: -10px;\n}\n.dropdown-submenu > a:after.fa-pull-left {\n  margin-right: .3em;\n}\n.dropdown-submenu > a:after.fa-pull-right {\n  margin-left: .3em;\n}\n.dropdown-submenu > a:after.pull-left {\n  margin-right: .3em;\n}\n.dropdown-submenu > a:after.pull-right {\n  margin-left: .3em;\n}\n[dir="rtl"] .dropdown-submenu > a:after {\n  float: left;\n  content: "\\f0d9";\n  margin-right: 0;\n  margin-left: -10px;\n}\n.dropdown-submenu:hover > a:after {\n  color: #262626;\n}\n.dropdown-submenu.pull-left {\n  float: none;\n}\n.dropdown-submenu.pull-left > .dropdown-menu {\n  left: -100%;\n  margin-left: 10px;\n}\n#notification_area {\n  float: right !important;\n  float: right;\n  z-index: 10;\n}\n[dir="rtl"] #notification_area {\n  float: left !important;\n  float: left;\n}\n.indicator_area {\n  float: right !important;\n  float: right;\n  color: #777;\n  margin-left: 5px;\n  margin-right: 5px;\n  width: 11px;\n  z-index: 10;\n  text-align: center;\n  width: auto;\n}\n[dir="rtl"] .indicator_area {\n  float: left !important;\n  float: left;\n}\n#kernel_indicator {\n  float: right !important;\n  float: right;\n  color: #777;\n  margin-left: 5px;\n  margin-right: 5px;\n  width: 11px;\n  z-index: 10;\n  text-align: center;\n  width: auto;\n  border-left: 1px solid;\n}\n#kernel_indicator .kernel_indicator_name {\n  padding-left: 5px;\n  padding-right: 5px;\n}\n[dir="rtl"] #kernel_indicator {\n  float: left !important;\n  float: left;\n  border-left: 0;\n  border-right: 1px solid;\n}\n#modal_indicator {\n  float: right !important;\n  float: right;\n  color: #777;\n  margin-left: 5px;\n  margin-right: 5px;\n  width: 11px;\n  z-index: 10;\n  text-align: center;\n  width: auto;\n}\n[dir="rtl"] #modal_indicator {\n  float: left !important;\n  float: left;\n}\n#readonly-indicator {\n  float: right !important;\n  float: right;\n  color: #777;\n  margin-left: 5px;\n  margin-right: 5px;\n  width: 11px;\n  z-index: 10;\n  text-align: center;\n  width: auto;\n  margin-top: 2px;\n  margin-bottom: 0px;\n  margin-left: 0px;\n  margin-right: 0px;\n  display: none;\n}\n.modal_indicator:before {\n  width: 1.28571429em;\n  text-align: center;\n}\n.edit_mode .modal_indicator:before {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  content: "\\f040";\n}\n.edit_mode .modal_indicator:before.fa-pull-left {\n  margin-right: .3em;\n}\n.edit_mode .modal_indicator:before.fa-pull-right {\n  margin-left: .3em;\n}\n.edit_mode .modal_indicator:before.pull-left {\n  margin-right: .3em;\n}\n.edit_mode .modal_indicator:before.pull-right {\n  margin-left: .3em;\n}\n.command_mode .modal_indicator:before {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  content: \' \';\n}\n.command_mode .modal_indicator:before.fa-pull-left {\n  margin-right: .3em;\n}\n.command_mode .modal_indicator:before.fa-pull-right {\n  margin-left: .3em;\n}\n.command_mode .modal_indicator:before.pull-left {\n  margin-right: .3em;\n}\n.command_mode .modal_indicator:before.pull-right {\n  margin-left: .3em;\n}\n.kernel_idle_icon:before {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  content: "\\f10c";\n}\n.kernel_idle_icon:before.fa-pull-left {\n  margin-right: .3em;\n}\n.kernel_idle_icon:before.fa-pull-right {\n  margin-left: .3em;\n}\n.kernel_idle_icon:before.pull-left {\n  margin-right: .3em;\n}\n.kernel_idle_icon:before.pull-right {\n  margin-left: .3em;\n}\n.kernel_busy_icon:before {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  content: "\\f111";\n}\n.kernel_busy_icon:before.fa-pull-left {\n  margin-right: .3em;\n}\n.kernel_busy_icon:before.fa-pull-right {\n  margin-left: .3em;\n}\n.kernel_busy_icon:before.pull-left {\n  margin-right: .3em;\n}\n.kernel_busy_icon:before.pull-right {\n  margin-left: .3em;\n}\n.kernel_dead_icon:before {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  content: "\\f1e2";\n}\n.kernel_dead_icon:before.fa-pull-left {\n  margin-right: .3em;\n}\n.kernel_dead_icon:before.fa-pull-right {\n  margin-left: .3em;\n}\n.kernel_dead_icon:before.pull-left {\n  margin-right: .3em;\n}\n.kernel_dead_icon:before.pull-right {\n  margin-left: .3em;\n}\n.kernel_disconnected_icon:before {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  content: "\\f127";\n}\n.kernel_disconnected_icon:before.fa-pull-left {\n  margin-right: .3em;\n}\n.kernel_disconnected_icon:before.fa-pull-right {\n  margin-left: .3em;\n}\n.kernel_disconnected_icon:before.pull-left {\n  margin-right: .3em;\n}\n.kernel_disconnected_icon:before.pull-right {\n  margin-left: .3em;\n}\n.notification_widget {\n  color: #777;\n  z-index: 10;\n  background: rgba(240, 240, 240, 0.5);\n  margin-right: 4px;\n  color: #333;\n  background-color: #fff;\n  border-color: #ccc;\n}\n.notification_widget:focus,\n.notification_widget.focus {\n  color: #333;\n  background-color: #e6e6e6;\n  border-color: #8c8c8c;\n}\n.notification_widget:hover {\n  color: #333;\n  background-color: #e6e6e6;\n  border-color: #adadad;\n}\n.notification_widget:active,\n.notification_widget.active,\n.open > .dropdown-toggle.notification_widget {\n  color: #333;\n  background-color: #e6e6e6;\n  border-color: #adadad;\n}\n.notification_widget:active:hover,\n.notification_widget.active:hover,\n.open > .dropdown-toggle.notification_widget:hover,\n.notification_widget:active:focus,\n.notification_widget.active:focus,\n.open > .dropdown-toggle.notification_widget:focus,\n.notification_widget:active.focus,\n.notification_widget.active.focus,\n.open > .dropdown-toggle.notification_widget.focus {\n  color: #333;\n  background-color: #d4d4d4;\n  border-color: #8c8c8c;\n}\n.notification_widget:active,\n.notification_widget.active,\n.open > .dropdown-toggle.notification_widget {\n  background-image: none;\n}\n.notification_widget.disabled:hover,\n.notification_widget[disabled]:hover,\nfieldset[disabled] .notification_widget:hover,\n.notification_widget.disabled:focus,\n.notification_widget[disabled]:focus,\nfieldset[disabled] .notification_widget:focus,\n.notification_widget.disabled.focus,\n.notification_widget[disabled].focus,\nfieldset[disabled] .notification_widget.focus {\n  background-color: #fff;\n  border-color: #ccc;\n}\n.notification_widget .badge {\n  color: #fff;\n  background-color: #333;\n}\n.notification_widget.warning {\n  color: #fff;\n  background-color: #f0ad4e;\n  border-color: #eea236;\n}\n.notification_widget.warning:focus,\n.notification_widget.warning.focus {\n  color: #fff;\n  background-color: #ec971f;\n  border-color: #985f0d;\n}\n.notification_widget.warning:hover {\n  color: #fff;\n  background-color: #ec971f;\n  border-color: #d58512;\n}\n.notification_widget.warning:active,\n.notification_widget.warning.active,\n.open > .dropdown-toggle.notification_widget.warning {\n  color: #fff;\n  background-color: #ec971f;\n  border-color: #d58512;\n}\n.notification_widget.warning:active:hover,\n.notification_widget.warning.active:hover,\n.open > .dropdown-toggle.notification_widget.warning:hover,\n.notification_widget.warning:active:focus,\n.notification_widget.warning.active:focus,\n.open > .dropdown-toggle.notification_widget.warning:focus,\n.notification_widget.warning:active.focus,\n.notification_widget.warning.active.focus,\n.open > .dropdown-toggle.notification_widget.warning.focus {\n  color: #fff;\n  background-color: #d58512;\n  border-color: #985f0d;\n}\n.notification_widget.warning:active,\n.notification_widget.warning.active,\n.open > .dropdown-toggle.notification_widget.warning {\n  background-image: none;\n}\n.notification_widget.warning.disabled:hover,\n.notification_widget.warning[disabled]:hover,\nfieldset[disabled] .notification_widget.warning:hover,\n.notification_widget.warning.disabled:focus,\n.notification_widget.warning[disabled]:focus,\nfieldset[disabled] .notification_widget.warning:focus,\n.notification_widget.warning.disabled.focus,\n.notification_widget.warning[disabled].focus,\nfieldset[disabled] .notification_widget.warning.focus {\n  background-color: #f0ad4e;\n  border-color: #eea236;\n}\n.notification_widget.warning .badge {\n  color: #f0ad4e;\n  background-color: #fff;\n}\n.notification_widget.success {\n  color: #fff;\n  background-color: #5cb85c;\n  border-color: #4cae4c;\n}\n.notification_widget.success:focus,\n.notification_widget.success.focus {\n  color: #fff;\n  background-color: #449d44;\n  border-color: #255625;\n}\n.notification_widget.success:hover {\n  color: #fff;\n  background-color: #449d44;\n  border-color: #398439;\n}\n.notification_widget.success:active,\n.notification_widget.success.active,\n.open > .dropdown-toggle.notification_widget.success {\n  color: #fff;\n  background-color: #449d44;\n  border-color: #398439;\n}\n.notification_widget.success:active:hover,\n.notification_widget.success.active:hover,\n.open > .dropdown-toggle.notification_widget.success:hover,\n.notification_widget.success:active:focus,\n.notification_widget.success.active:focus,\n.open > .dropdown-toggle.notification_widget.success:focus,\n.notification_widget.success:active.focus,\n.notification_widget.success.active.focus,\n.open > .dropdown-toggle.notification_widget.success.focus {\n  color: #fff;\n  background-color: #398439;\n  border-color: #255625;\n}\n.notification_widget.success:active,\n.notification_widget.success.active,\n.open > .dropdown-toggle.notification_widget.success {\n  background-image: none;\n}\n.notification_widget.success.disabled:hover,\n.notification_widget.success[disabled]:hover,\nfieldset[disabled] .notification_widget.success:hover,\n.notification_widget.success.disabled:focus,\n.notification_widget.success[disabled]:focus,\nfieldset[disabled] .notification_widget.success:focus,\n.notification_widget.success.disabled.focus,\n.notification_widget.success[disabled].focus,\nfieldset[disabled] .notification_widget.success.focus {\n  background-color: #5cb85c;\n  border-color: #4cae4c;\n}\n.notification_widget.success .badge {\n  color: #5cb85c;\n  background-color: #fff;\n}\n.notification_widget.info {\n  color: #fff;\n  background-color: #5bc0de;\n  border-color: #46b8da;\n}\n.notification_widget.info:focus,\n.notification_widget.info.focus {\n  color: #fff;\n  background-color: #31b0d5;\n  border-color: #1b6d85;\n}\n.notification_widget.info:hover {\n  color: #fff;\n  background-color: #31b0d5;\n  border-color: #269abc;\n}\n.notification_widget.info:active,\n.notification_widget.info.active,\n.open > .dropdown-toggle.notification_widget.info {\n  color: #fff;\n  background-color: #31b0d5;\n  border-color: #269abc;\n}\n.notification_widget.info:active:hover,\n.notification_widget.info.active:hover,\n.open > .dropdown-toggle.notification_widget.info:hover,\n.notification_widget.info:active:focus,\n.notification_widget.info.active:focus,\n.open > .dropdown-toggle.notification_widget.info:focus,\n.notification_widget.info:active.focus,\n.notification_widget.info.active.focus,\n.open > .dropdown-toggle.notification_widget.info.focus {\n  color: #fff;\n  background-color: #269abc;\n  border-color: #1b6d85;\n}\n.notification_widget.info:active,\n.notification_widget.info.active,\n.open > .dropdown-toggle.notification_widget.info {\n  background-image: none;\n}\n.notification_widget.info.disabled:hover,\n.notification_widget.info[disabled]:hover,\nfieldset[disabled] .notification_widget.info:hover,\n.notification_widget.info.disabled:focus,\n.notification_widget.info[disabled]:focus,\nfieldset[disabled] .notification_widget.info:focus,\n.notification_widget.info.disabled.focus,\n.notification_widget.info[disabled].focus,\nfieldset[disabled] .notification_widget.info.focus {\n  background-color: #5bc0de;\n  border-color: #46b8da;\n}\n.notification_widget.info .badge {\n  color: #5bc0de;\n  background-color: #fff;\n}\n.notification_widget.danger {\n  color: #fff;\n  background-color: #d9534f;\n  border-color: #d43f3a;\n}\n.notification_widget.danger:focus,\n.notification_widget.danger.focus {\n  color: #fff;\n  background-color: #c9302c;\n  border-color: #761c19;\n}\n.notification_widget.danger:hover {\n  color: #fff;\n  background-color: #c9302c;\n  border-color: #ac2925;\n}\n.notification_widget.danger:active,\n.notification_widget.danger.active,\n.open > .dropdown-toggle.notification_widget.danger {\n  color: #fff;\n  background-color: #c9302c;\n  border-color: #ac2925;\n}\n.notification_widget.danger:active:hover,\n.notification_widget.danger.active:hover,\n.open > .dropdown-toggle.notification_widget.danger:hover,\n.notification_widget.danger:active:focus,\n.notification_widget.danger.active:focus,\n.open > .dropdown-toggle.notification_widget.danger:focus,\n.notification_widget.danger:active.focus,\n.notification_widget.danger.active.focus,\n.open > .dropdown-toggle.notification_widget.danger.focus {\n  color: #fff;\n  background-color: #ac2925;\n  border-color: #761c19;\n}\n.notification_widget.danger:active,\n.notification_widget.danger.active,\n.open > .dropdown-toggle.notification_widget.danger {\n  background-image: none;\n}\n.notification_widget.danger.disabled:hover,\n.notification_widget.danger[disabled]:hover,\nfieldset[disabled] .notification_widget.danger:hover,\n.notification_widget.danger.disabled:focus,\n.notification_widget.danger[disabled]:focus,\nfieldset[disabled] .notification_widget.danger:focus,\n.notification_widget.danger.disabled.focus,\n.notification_widget.danger[disabled].focus,\nfieldset[disabled] .notification_widget.danger.focus {\n  background-color: #d9534f;\n  border-color: #d43f3a;\n}\n.notification_widget.danger .badge {\n  color: #d9534f;\n  background-color: #fff;\n}\ndiv#pager {\n  background-color: #fff;\n  font-size: 14px;\n  line-height: 20px;\n  overflow: hidden;\n  display: none;\n  position: fixed;\n  bottom: 0px;\n  width: 100%;\n  max-height: 50%;\n  padding-top: 8px;\n  -webkit-box-shadow: 0px 0px 12px 1px rgba(87, 87, 87, 0.2);\n  box-shadow: 0px 0px 12px 1px rgba(87, 87, 87, 0.2);\n  /* Display over codemirror */\n  z-index: 100;\n  /* Hack which prevents jquery ui resizable from changing top. */\n  top: auto !important;\n}\ndiv#pager pre {\n  line-height: 1.21429em;\n  color: #000;\n  background-color: #f7f7f7;\n  padding: 0.4em;\n}\ndiv#pager #pager-button-area {\n  position: absolute;\n  top: 8px;\n  right: 20px;\n}\ndiv#pager #pager-contents {\n  position: relative;\n  overflow: auto;\n  width: 100%;\n  height: 100%;\n}\ndiv#pager #pager-contents #pager-container {\n  position: relative;\n  padding: 15px 0px;\n  box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -webkit-box-sizing: border-box;\n}\ndiv#pager .ui-resizable-handle {\n  top: 0px;\n  height: 8px;\n  background: #f7f7f7;\n  border-top: 1px solid #cfcfcf;\n  border-bottom: 1px solid #cfcfcf;\n  /* This injects handle bars (a short, wide = symbol) for \n        the resize handle. */\n}\ndiv#pager .ui-resizable-handle::after {\n  content: \'\';\n  top: 2px;\n  left: 50%;\n  height: 3px;\n  width: 30px;\n  margin-left: -15px;\n  position: absolute;\n  border-top: 1px solid #cfcfcf;\n}\n.quickhelp {\n  /* Old browsers */\n  display: -webkit-box;\n  -webkit-box-orient: horizontal;\n  -webkit-box-align: stretch;\n  display: -moz-box;\n  -moz-box-orient: horizontal;\n  -moz-box-align: stretch;\n  display: box;\n  box-orient: horizontal;\n  box-align: stretch;\n  /* Modern browsers */\n  display: flex;\n  flex-direction: row;\n  align-items: stretch;\n  line-height: 1.8em;\n}\n.shortcut_key {\n  display: inline-block;\n  width: 21ex;\n  text-align: right;\n  font-family: monospace;\n}\n.shortcut_descr {\n  display: inline-block;\n  /* Old browsers */\n  -webkit-box-flex: 1;\n  -moz-box-flex: 1;\n  box-flex: 1;\n  /* Modern browsers */\n  flex: 1;\n}\nspan.save_widget {\n  height: 30px;\n  margin-top: 4px;\n  display: flex;\n  justify-content: flex-start;\n  align-items: baseline;\n  width: 50%;\n  flex: 1;\n}\nspan.save_widget span.filename {\n  height: 100%;\n  line-height: 1em;\n  margin-left: 16px;\n  border: none;\n  font-size: 146.5%;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n  border-radius: 2px;\n}\nspan.save_widget span.filename:hover {\n  background-color: #e6e6e6;\n}\n[dir="rtl"] span.save_widget.pull-left {\n  float: right !important;\n  float: right;\n}\n[dir="rtl"] span.save_widget span.filename {\n  margin-left: 0;\n  margin-right: 16px;\n}\nspan.checkpoint_status,\nspan.autosave_status {\n  font-size: small;\n  white-space: nowrap;\n  padding: 0 5px;\n}\n@media (max-width: 767px) {\n  span.save_widget {\n    font-size: small;\n    padding: 0 0 0 5px;\n  }\n  span.checkpoint_status,\n  span.autosave_status {\n    display: none;\n  }\n}\n@media (min-width: 768px) and (max-width: 991px) {\n  span.checkpoint_status {\n    display: none;\n  }\n  span.autosave_status {\n    font-size: x-small;\n  }\n}\n.toolbar {\n  padding: 0px;\n  margin-left: -5px;\n  margin-top: 2px;\n  margin-bottom: 5px;\n  box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -webkit-box-sizing: border-box;\n}\n.toolbar select,\n.toolbar label {\n  width: auto;\n  vertical-align: middle;\n  margin-right: 2px;\n  margin-bottom: 0px;\n  display: inline;\n  font-size: 92%;\n  margin-left: 0.3em;\n  margin-right: 0.3em;\n  padding: 0px;\n  padding-top: 3px;\n}\n.toolbar .btn {\n  padding: 2px 8px;\n}\n.toolbar .btn-group {\n  margin-top: 0px;\n  margin-left: 5px;\n}\n.toolbar-btn-label {\n  margin-left: 6px;\n}\n#maintoolbar {\n  margin-bottom: -3px;\n  margin-top: -8px;\n  border: 0px;\n  min-height: 27px;\n  margin-left: 0px;\n  padding-top: 11px;\n  padding-bottom: 3px;\n}\n#maintoolbar .navbar-text {\n  float: none;\n  vertical-align: middle;\n  text-align: right;\n  margin-left: 5px;\n  margin-right: 0px;\n  margin-top: 0px;\n}\n.select-xs {\n  height: 24px;\n}\n[dir="rtl"] .btn-group > .btn,\n.btn-group-vertical > .btn {\n  float: right;\n}\n.pulse,\n.dropdown-menu > li > a.pulse,\nli.pulse > a.dropdown-toggle,\nli.pulse.open > a.dropdown-toggle {\n  background-color: #F37626;\n  color: white;\n}\n/**\n * Primary styles\n *\n * Author: Jupyter Development Team\n */\n/** WARNING IF YOU ARE EDITTING THIS FILE, if this is a .css file, It has a lot\n * of chance of beeing generated from the ../less/[samename].less file, you can\n * try to get back the less file by reverting somme commit in history\n **/\n/*\n * We\'ll try to get something pretty, so we\n * have some strange css to have the scroll bar on\n * the left with fix button on the top right of the tooltip\n */\n@-moz-keyframes fadeOut {\n  from {\n    opacity: 1;\n  }\n  to {\n    opacity: 0;\n  }\n}\n@-webkit-keyframes fadeOut {\n  from {\n    opacity: 1;\n  }\n  to {\n    opacity: 0;\n  }\n}\n@-moz-keyframes fadeIn {\n  from {\n    opacity: 0;\n  }\n  to {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes fadeIn {\n  from {\n    opacity: 0;\n  }\n  to {\n    opacity: 1;\n  }\n}\n/*properties of tooltip after "expand"*/\n.bigtooltip {\n  overflow: auto;\n  height: 200px;\n  -webkit-transition-property: height;\n  -webkit-transition-duration: 500ms;\n  -moz-transition-property: height;\n  -moz-transition-duration: 500ms;\n  transition-property: height;\n  transition-duration: 500ms;\n}\n/*properties of tooltip before "expand"*/\n.smalltooltip {\n  -webkit-transition-property: height;\n  -webkit-transition-duration: 500ms;\n  -moz-transition-property: height;\n  -moz-transition-duration: 500ms;\n  transition-property: height;\n  transition-duration: 500ms;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  height: 80px;\n}\n.tooltipbuttons {\n  position: absolute;\n  padding-right: 15px;\n  top: 0px;\n  right: 0px;\n}\n.tooltiptext {\n  /*avoid the button to overlap on some docstring*/\n  padding-right: 30px;\n}\n.ipython_tooltip {\n  max-width: 700px;\n  /*fade-in animation when inserted*/\n  -webkit-animation: fadeOut 400ms;\n  -moz-animation: fadeOut 400ms;\n  animation: fadeOut 400ms;\n  -webkit-animation: fadeIn 400ms;\n  -moz-animation: fadeIn 400ms;\n  animation: fadeIn 400ms;\n  vertical-align: middle;\n  background-color: #f7f7f7;\n  overflow: visible;\n  border: #ababab 1px solid;\n  outline: none;\n  padding: 3px;\n  margin: 0px;\n  padding-left: 7px;\n  font-family: monospace;\n  min-height: 50px;\n  -moz-box-shadow: 0px 6px 10px -1px #adadad;\n  -webkit-box-shadow: 0px 6px 10px -1px #adadad;\n  box-shadow: 0px 6px 10px -1px #adadad;\n  border-radius: 2px;\n  position: absolute;\n  z-index: 1000;\n}\n.ipython_tooltip a {\n  float: right;\n}\n.ipython_tooltip .tooltiptext pre {\n  border: 0;\n  border-radius: 0;\n  font-size: 100%;\n  background-color: #f7f7f7;\n}\n.pretooltiparrow {\n  left: 0px;\n  margin: 0px;\n  top: -16px;\n  width: 40px;\n  height: 16px;\n  overflow: hidden;\n  position: absolute;\n}\n.pretooltiparrow:before {\n  background-color: #f7f7f7;\n  border: 1px #ababab solid;\n  z-index: 11;\n  content: "";\n  position: absolute;\n  left: 15px;\n  top: 10px;\n  width: 25px;\n  height: 25px;\n  -webkit-transform: rotate(45deg);\n  -moz-transform: rotate(45deg);\n  -ms-transform: rotate(45deg);\n  -o-transform: rotate(45deg);\n}\nul.typeahead-list i {\n  margin-left: -10px;\n  width: 18px;\n}\n[dir="rtl"] ul.typeahead-list i {\n  margin-left: 0;\n  margin-right: -10px;\n}\nul.typeahead-list {\n  max-height: 80vh;\n  overflow: auto;\n}\nul.typeahead-list > li > a {\n  /** Firefox bug **/\n  /* see https://github.com/jupyter/notebook/issues/559 */\n  white-space: normal;\n}\nul.typeahead-list  > li > a.pull-right {\n  float: left !important;\n  float: left;\n}\n[dir="rtl"] .typeahead-list {\n  text-align: right;\n}\n.cmd-palette .modal-body {\n  padding: 7px;\n}\n.cmd-palette form {\n  background: white;\n}\n.cmd-palette input {\n  outline: none;\n}\n.no-shortcut {\n  min-width: 20px;\n  color: transparent;\n}\n[dir="rtl"] .no-shortcut.pull-right {\n  float: left !important;\n  float: left;\n}\n[dir="rtl"] .command-shortcut.pull-right {\n  float: left !important;\n  float: left;\n}\n.command-shortcut:before {\n  content: "(command mode)";\n  padding-right: 3px;\n  color: #777777;\n}\n.edit-shortcut:before {\n  content: "(edit)";\n  padding-right: 3px;\n  color: #777777;\n}\n[dir="rtl"] .edit-shortcut.pull-right {\n  float: left !important;\n  float: left;\n}\n#find-and-replace #replace-preview .match,\n#find-and-replace #replace-preview .insert {\n  background-color: #BBDEFB;\n  border-color: #90CAF9;\n  border-style: solid;\n  border-width: 1px;\n  border-radius: 0px;\n}\n[dir="ltr"] #find-and-replace .input-group-btn + .form-control {\n  border-left: none;\n}\n[dir="rtl"] #find-and-replace .input-group-btn + .form-control {\n  border-right: none;\n}\n#find-and-replace #replace-preview .replace .match {\n  background-color: #FFCDD2;\n  border-color: #EF9A9A;\n  border-radius: 0px;\n}\n#find-and-replace #replace-preview .replace .insert {\n  background-color: #C8E6C9;\n  border-color: #A5D6A7;\n  border-radius: 0px;\n}\n#find-and-replace #replace-preview {\n  max-height: 60vh;\n  overflow: auto;\n}\n#find-and-replace #replace-preview pre {\n  padding: 5px 10px;\n}\n.terminal-app {\n  background: #EEE;\n}\n.terminal-app #header {\n  background: #fff;\n  -webkit-box-shadow: 0px 0px 12px 1px rgba(87, 87, 87, 0.2);\n  box-shadow: 0px 0px 12px 1px rgba(87, 87, 87, 0.2);\n}\n.terminal-app .terminal {\n  width: 100%;\n  float: left;\n  font-family: monospace;\n  color: white;\n  background: black;\n  padding: 0.4em;\n  border-radius: 2px;\n  -webkit-box-shadow: 0px 0px 12px 1px rgba(87, 87, 87, 0.4);\n  box-shadow: 0px 0px 12px 1px rgba(87, 87, 87, 0.4);\n}\n.terminal-app .terminal,\n.terminal-app .terminal dummy-screen {\n  line-height: 1em;\n  font-size: 14px;\n}\n.terminal-app .terminal .xterm-rows {\n  padding: 10px;\n}\n.terminal-app .terminal-cursor {\n  color: black;\n  background: white;\n}\n.terminal-app #terminado-container {\n  margin-top: 20px;\n}\n/*# sourceMappingURL=style.min.css.map */\n    </style>\n<style type="text/css">\n    .highlight .hll { background-color: #ffffcc }\n.highlight  { background: #f8f8f8; }\n.highlight .c { color: #408080; font-style: italic } /* Comment */\n.highlight .err { border: 1px solid #FF0000 } /* Error */\n.highlight .k { color: #008000; font-weight: bold } /* Keyword */\n.highlight .o { color: #666666 } /* Operator */\n.highlight .ch { color: #408080; font-style: italic } /* Comment.Hashbang */\n.highlight .cm { color: #408080; font-style: italic } /* Comment.Multiline */\n.highlight .cp { color: #BC7A00 } /* Comment.Preproc */\n.highlight .cpf { color: #408080; font-style: italic } /* Comment.PreprocFile */\n.highlight .c1 { color: #408080; font-style: italic } /* Comment.Single */\n.highlight .cs { color: #408080; font-style: italic } /* Comment.Special */\n.highlight .gd { color: #A00000 } /* Generic.Deleted */\n.highlight .ge { font-style: italic } /* Generic.Emph */\n.highlight .gr { color: #FF0000 } /* Generic.Error */\n.highlight .gh { color: #000080; font-weight: bold } /* Generic.Heading */\n.highlight .gi { color: #00A000 } /* Generic.Inserted */\n.highlight .go { color: #888888 } /* Generic.Output */\n.highlight .gp { color: #000080; font-weight: bold } /* Generic.Prompt */\n.highlight .gs { font-weight: bold } /* Generic.Strong */\n.highlight .gu { color: #800080; font-weight: bold } /* Generic.Subheading */\n.highlight .gt { color: #0044DD } /* Generic.Traceback */\n.highlight .kc { color: #008000; font-weight: bold } /* Keyword.Constant */\n.highlight .kd { color: #008000; font-weight: bold } /* Keyword.Declaration */\n.highlight .kn { color: #008000; font-weight: bold } /* Keyword.Namespace */\n.highlight .kp { color: #008000 } /* Keyword.Pseudo */\n.highlight .kr { color: #008000; font-weight: bold } /* Keyword.Reserved */\n.highlight .kt { color: #B00040 } /* Keyword.Type */\n.highlight .m { color: #666666 } /* Literal.Number */\n.highlight .s { color: #BA2121 } /* Literal.String */\n.highlight .na { color: #7D9029 } /* Name.Attribute */\n.highlight .nb { color: #008000 } /* Name.Builtin */\n.highlight .nc { color: #0000FF; font-weight: bold } /* Name.Class */\n.highlight .no { color: #880000 } /* Name.Constant */\n.highlight .nd { color: #AA22FF } /* Name.Decorator */\n.highlight .ni { color: #999999; font-weight: bold } /* Name.Entity */\n.highlight .ne { color: #D2413A; font-weight: bold } /* Name.Exception */\n.highlight .nf { color: #0000FF } /* Name.Function */\n.highlight .nl { color: #A0A000 } /* Name.Label */\n.highlight .nn { color: #0000FF; font-weight: bold } /* Name.Namespace */\n.highlight .nt { color: #008000; font-weight: bold } /* Name.Tag */\n.highlight .nv { color: #19177C } /* Name.Variable */\n.highlight .ow { color: #AA22FF; font-weight: bold } /* Operator.Word */\n.highlight .w { color: #bbbbbb } /* Text.Whitespace */\n.highlight .mb { color: #666666 } /* Literal.Number.Bin */\n.highlight .mf { color: #666666 } /* Literal.Number.Float */\n.highlight .mh { color: #666666 } /* Literal.Number.Hex */\n.highlight .mi { color: #666666 } /* Literal.Number.Integer */\n.highlight .mo { color: #666666 } /* Literal.Number.Oct */\n.highlight .sa { color: #BA2121 } /* Literal.String.Affix */\n.highlight .sb { color: #BA2121 } /* Literal.String.Backtick */\n.highlight .sc { color: #BA2121 } /* Literal.String.Char */\n.highlight .dl { color: #BA2121 } /* Literal.String.Delimiter */\n.highlight .sd { color: #BA2121; font-style: italic } /* Literal.String.Doc */\n.highlight .s2 { color: #BA2121 } /* Literal.String.Double */\n.highlight .se { color: #BB6622; font-weight: bold } /* Literal.String.Escape */\n.highlight .sh { color: #BA2121 } /* Literal.String.Heredoc */\n.highlight .si { color: #BB6688; font-weight: bold } /* Literal.String.Interpol */\n.highlight .sx { color: #008000 } /* Literal.String.Other */\n.highlight .sr { color: #BB6688 } /* Literal.String.Regex */\n.highlight .s1 { color: #BA2121 } /* Literal.String.Single */\n.highlight .ss { color: #19177C } /* Literal.String.Symbol */\n.highlight .bp { color: #008000 } /* Name.Builtin.Pseudo */\n.highlight .fm { color: #0000FF } /* Name.Function.Magic */\n.highlight .vc { color: #19177C } /* Name.Variable.Class */\n.highlight .vg { color: #19177C } /* Name.Variable.Global */\n.highlight .vi { color: #19177C } /* Name.Variable.Instance */\n.highlight .vm { color: #19177C } /* Name.Variable.Magic */\n.highlight .il { color: #666666 } /* Literal.Number.Integer.Long */\n    </style>\n\n\n<style type="text/css">\n/* Overrides of notebook CSS for static HTML export */\nbody {\n  overflow: visible;\n  padding: 8px;\n}\n\ndiv#notebook {\n  overflow: visible;\n  border-top: none;\n}@media print {\n  div.cell {\n    display: block;\n    page-break-inside: avoid;\n  } \n  div.output_wrapper { \n    display: block;\n    page-break-inside: avoid; \n  }\n  div.output { \n    display: block;\n    page-break-inside: avoid; \n  }\n}\n</style>\n\n<!-- Custom stylesheet, it must be in the same directory as the html file -->\n<link rel="stylesheet" href="custom.css">\n\n<!-- Loading mathjax macro -->\n<!-- Load mathjax -->\n    <script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/latest.js?config=TeX-AMS_HTML"></script>\n    <!-- MathJax configuration -->\n    <script type="text/x-mathjax-config">\n    MathJax.Hub.Config({\n        tex2jax: {\n            inlineMath: [ [\'$\',\'$\'], ["\\\\(","\\\\)"] ],\n            displayMath: [ [\'$$\',\'$$\'], ["\\\\[","\\\\]"] ],\n            processEscapes: true,\n            processEnvironments: true\n        },\n        // Center justify equations in code and markdown cells. Elsewhere\n        // we use CSS to left justify single line equations in code cells.\n        displayAlign: \'center\',\n        "HTML-CSS": {\n            styles: {\'.MathJax_Display\': {"margin": 0}},\n            linebreaks: { automatic: true }\n        }\n    });\n    </script>\n    <!-- End of mathjax configuration --></head>\n<body>\n  <div tabindex="-1" id="notebook" class="border-box-sizing">\n    <div class="container" id="notebook-container">\n\n<div class="cell border-box-sizing code_cell rendered">\n<div class="input">\n<div class="prompt input_prompt">In&nbsp;[1]:</div>\n<div class="inner_cell">\n    <div class="input_area">\n<div class=" highlight hl-ipython3"><pre><span></span><span class="kn">import</span> <span class="nn">numpy</span> <span class="k">as</span> <span class="nn">np</span>\n<span class="kn">import</span> <span class="nn">matplotlib.pyplot</span> <span class="k">as</span> <span class="nn">plt</span>\n\n<span class="kn">from</span> <span class="nn">wfslib.geometry</span> <span class="k">import</span> <span class="n">Geometry</span>\n<span class="kn">from</span> <span class="nn">wfslib.wfs</span> <span class="k">import</span> <span class="n">WFSData</span>\n</pre></div>\n\n    </div>\n</div>\n</div>\n\n</div>\n<div class="cell border-box-sizing text_cell rendered"><div class="prompt input_prompt">\n</div><div class="inner_cell">\n<div class="text_cell_render border-box-sizing rendered_html">\n<h3 id="&#1050;&#1088;&#1091;&#1087;&#1085;&#1072;&#1103;-&#1089;&#1077;&#1090;&#1082;&#1072;-&#1079;&#1072;&#1089;&#1074;&#1077;&#1095;&#1077;&#1085;&#1085;&#1072;&#1103;-&#1087;&#1086;&#1083;&#1085;&#1086;&#1089;&#1090;&#1100;&#1102;">&#1050;&#1088;&#1091;&#1087;&#1085;&#1072;&#1103; &#1089;&#1077;&#1090;&#1082;&#1072; &#1079;&#1072;&#1089;&#1074;&#1077;&#1095;&#1077;&#1085;&#1085;&#1072;&#1103; &#1087;&#1086;&#1083;&#1085;&#1086;&#1089;&#1090;&#1100;&#1102;<a class="anchor-link" href="#&#1050;&#1088;&#1091;&#1087;&#1085;&#1072;&#1103;-&#1089;&#1077;&#1090;&#1082;&#1072;-&#1079;&#1072;&#1089;&#1074;&#1077;&#1095;&#1077;&#1085;&#1085;&#1072;&#1103;-&#1087;&#1086;&#1083;&#1085;&#1086;&#1089;&#1090;&#1100;&#1102;">&#182;</a></h3>\n</div>\n</div>\n</div>\n<div class="cell border-box-sizing code_cell rendered">\n<div class="input">\n<div class="prompt input_prompt">In&nbsp;[4]:</div>\n<div class="inner_cell">\n    <div class="input_area">\n<div class=" highlight hl-ipython3"><pre><span></span><span class="kn">from</span> <span class="nn">PIL</span> <span class="k">import</span> <span class="n">Image</span>\n\n\n<span class="n">path</span> <span class="o">=</span> <span class="s2">&quot;../data/bad_img3.tiff&quot;</span>\n\n<span class="n">arr</span> <span class="o">=</span> <span class="n">np</span><span class="o">.</span><span class="n">array</span><span class="p">(</span><span class="n">Image</span><span class="o">.</span><span class="n">open</span><span class="p">(</span><span class="n">path</span><span class="p">))[</span><span class="mi">500</span><span class="p">:</span><span class="mi">1500</span><span class="p">,</span> <span class="mi">500</span><span class="p">:</span><span class="mi">1500</span><span class="p">]</span>\n<span class="n">arr</span> <span class="o">=</span> <span class="n">np</span><span class="o">.</span><span class="n">expand_dims</span><span class="p">(</span><span class="n">arr</span><span class="p">,</span> <span class="mi">0</span><span class="p">)</span>\n<span class="n">wfs</span> <span class="o">=</span> <span class="n">WFSData</span><span class="p">(</span><span class="n">arr</span><span class="p">)</span>\n<span class="n">wfs</span><span class="o">.</span><span class="n">geometry</span><span class="o">.</span><span class="n">set_options</span><span class="p">(</span><span class="n">shift</span><span class="o">=</span><span class="p">(</span><span class="o">-</span><span class="mi">22</span><span class="p">,</span> <span class="o">-</span><span class="mi">36</span><span class="p">))</span>\n<span class="n">wfs</span><span class="o">.</span><span class="n">reference</span> <span class="o">=</span> <span class="mi">27</span>\n<span class="n">wfs</span><span class="o">.</span><span class="n">good_only</span> <span class="o">=</span> <span class="kc">True</span> <span class="c1">#отображать только качественные субапертуры</span>\n<span class="n">plt</span><span class="o">.</span><span class="n">imshow</span><span class="p">(</span><span class="n">arr</span><span class="p">[</span><span class="mi">0</span><span class="p">])</span>\n<span class="n">wfs</span><span class="o">.</span><span class="n">show_geometry</span><span class="p">()</span>\n</pre></div>\n\n    </div>\n</div>\n</div>\n\n<div class="output_wrapper">\n<div class="output">\n\n\n<div class="output_area">\n\n    <div class="prompt"></div>\n\n\n<div class="output_subarea output_stream output_stdout output_text">\n<pre>240.66666666666666\n317.0\n</pre>\n</div>\n</div>\n\n<div class="output_area">\n\n    <div class="prompt"></div>\n\n\n<div class="output_subarea output_stream output_stderr output_text">\n<pre>C:\\Users\\mi\\Anaconda3\\lib\\site-packages\\wfslib\\wfs.py:164: UserWarning: WARNING: Set the geometry for the file!\n  warn(&#34;WARNING: Set the geometry for the file!&#34;, UserWarning)\n</pre>\n</div>\n</div>\n\n<div class="output_area">\n\n    <div class="prompt"></div>\n\n\n\n\n<div class="output_png output_subarea ">\n<img src="data:image/png;base64,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\n"\n>\n</div>\n\n</div>\n\n<div class="output_area">\n\n    <div class="prompt"></div>\n\n\n\n\n<div class="output_png output_subarea ">\n<img src="data:image/png;base64,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\n"\n>\n</div>\n\n</div>\n\n</div>\n</div>\n\n</div>\n<div class="cell border-box-sizing code_cell rendered">\n<div class="input">\n<div class="prompt input_prompt">In&nbsp;[3]:</div>\n<div class="inner_cell">\n    <div class="input_area">\n<div class=" highlight hl-ipython3"><pre><span></span><span class="c1">#print(str (wfs[0].get_offset(43)))</span>\n<span class="n">wfs</span><span class="o">.</span><span class="n">mask</span> <span class="o">=</span> <span class="kc">True</span>\n<span class="n">plt</span><span class="o">.</span><span class="n">subplot</span><span class="p">(</span><span class="mi">1</span><span class="p">,</span><span class="mi">2</span><span class="p">,</span><span class="mi">1</span><span class="p">)</span>\n<span class="n">plt</span><span class="o">.</span><span class="n">imshow</span><span class="p">(</span><span class="n">wfs</span><span class="p">[</span><span class="mi">0</span><span class="p">][</span><span class="mi">17</span><span class="p">])</span>\n<span class="n">plt</span><span class="o">.</span><span class="n">subplot</span><span class="p">(</span><span class="mi">1</span><span class="p">,</span><span class="mi">2</span><span class="p">,</span><span class="mi">2</span><span class="p">)</span>\n<span class="n">plt</span><span class="o">.</span><span class="n">imshow</span><span class="p">(</span><span class="n">wfs</span><span class="p">[</span><span class="mi">0</span><span class="p">][</span><span class="mi">1</span><span class="p">])</span>\n</pre></div>\n\n    </div>\n</div>\n</div>\n\n<div class="output_wrapper">\n<div class="output">\n\n\n<div class="output_area">\n\n    <div class="prompt output_prompt">Out[3]:</div>\n\n\n\n\n<div class="output_text output_subarea output_execute_result">\n<pre>&lt;matplotlib.image.AxesImage at 0x2781c39aa90&gt;</pre>\n</div>\n\n</div>\n\n<div class="output_area">\n\n    <div class="prompt"></div>\n\n\n\n\n<div class="output_png output_subarea ">\n<img src="data:image/png;base64,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\n"\n>\n</div>\n\n</div>\n\n</div>\n</div>\n\n</div>\n<div class="cell border-box-sizing text_cell rendered"><div class="prompt input_prompt">\n</div><div class="inner_cell">\n<div class="text_cell_render border-box-sizing rendered_html">\n<h3 id="&#1050;&#1088;&#1091;&#1087;&#1085;&#1072;&#1103;-&#1089;&#1077;&#1090;&#1082;&#1072;-&#1093;&#1072;&#1089;&#1074;&#1077;&#1095;&#1077;&#1085;&#1085;&#1072;&#1103;-&#1076;&#1080;&#1072;&#1075;&#1086;&#1085;&#1072;&#1083;&#1100;&#1085;&#1086;">&#1050;&#1088;&#1091;&#1087;&#1085;&#1072;&#1103; &#1089;&#1077;&#1090;&#1082;&#1072; &#1093;&#1072;&#1089;&#1074;&#1077;&#1095;&#1077;&#1085;&#1085;&#1072;&#1103; &#1076;&#1080;&#1072;&#1075;&#1086;&#1085;&#1072;&#1083;&#1100;&#1085;&#1086;<a class="anchor-link" href="#&#1050;&#1088;&#1091;&#1087;&#1085;&#1072;&#1103;-&#1089;&#1077;&#1090;&#1082;&#1072;-&#1093;&#1072;&#1089;&#1074;&#1077;&#1095;&#1077;&#1085;&#1085;&#1072;&#1103;-&#1076;&#1080;&#1072;&#1075;&#1086;&#1085;&#1072;&#1083;&#1100;&#1085;&#1086;">&#182;</a></h3>\n</div>\n</div>\n</div>\n<div class="cell border-box-sizing code_cell rendered">\n<div class="input">\n<div class="prompt input_prompt">In&nbsp;[3]:</div>\n<div class="inner_cell">\n    <div class="input_area">\n<div class=" highlight hl-ipython3"><pre><span></span><span class="n">path</span> <span class="o">=</span> <span class="s2">&quot;../data/bad_img1.tiff&quot;</span>\n\n<span class="n">Geometry</span><span class="o">.</span><span class="n">only_wavelets</span> <span class="o">=</span> <span class="mi">0</span>\n\n<span class="n">arr</span> <span class="o">=</span> <span class="n">np</span><span class="o">.</span><span class="n">array</span><span class="p">(</span><span class="n">Image</span><span class="o">.</span><span class="n">open</span><span class="p">(</span><span class="n">path</span><span class="p">))[</span><span class="mi">500</span><span class="p">:</span><span class="mi">1500</span><span class="p">,</span> <span class="mi">500</span><span class="p">:</span><span class="mi">1500</span><span class="p">]</span>\n<span class="n">arr</span> <span class="o">=</span> <span class="n">np</span><span class="o">.</span><span class="n">expand_dims</span><span class="p">(</span><span class="n">arr</span><span class="p">,</span> <span class="mi">0</span><span class="p">)</span>\n<span class="n">wfs</span> <span class="o">=</span> <span class="n">WFSData</span><span class="p">(</span><span class="n">arr</span><span class="p">)</span>\n<span class="n">wfs</span><span class="o">.</span><span class="n">geometry</span><span class="o">.</span><span class="n">set_options</span><span class="p">(</span><span class="n">shift</span><span class="o">=</span><span class="p">(</span><span class="o">-</span><span class="mi">65</span><span class="p">,</span> <span class="o">-</span><span class="mi">15</span><span class="p">))</span>\n<span class="n">wfs</span><span class="o">.</span><span class="n">reference</span> <span class="o">=</span> <span class="mi">27</span>\n\n\n\n<span class="n">plt</span><span class="o">.</span><span class="n">imshow</span><span class="p">(</span><span class="n">arr</span><span class="p">[</span><span class="mi">0</span><span class="p">])</span>\n<span class="n">wfs</span><span class="o">.</span><span class="n">show_geometry</span><span class="p">(</span><span class="n">show_type</span> <span class="o">=</span> <span class="s2">&quot;offsets&quot;</span><span class="p">)</span>\n</pre></div>\n\n    </div>\n</div>\n</div>\n\n<div class="output_wrapper">\n<div class="output">\n\n\n<div class="output_area">\n\n    <div class="prompt"></div>\n\n\n<div class="output_subarea output_stream output_stdout output_text">\n<pre>314.0\n342.5\n</pre>\n</div>\n</div>\n\n<div class="output_area">\n\n    <div class="prompt"></div>\n\n\n<div class="output_subarea output_stream output_stderr output_text">\n<pre>C:\\Users\\mi\\Anaconda3\\lib\\site-packages\\wfslib\\wfs.py:164: UserWarning: WARNING: Set the geometry for the file!\n  warn(&#34;WARNING: Set the geometry for the file!&#34;, UserWarning)\n</pre>\n</div>\n</div>\n\n<div class="output_area">\n\n    <div class="prompt"></div>\n\n\n\n\n<div class="output_png output_subarea ">\n<img src="data:image/png;base64,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\n"\n>\n</div>\n\n</div>\n\n<div class="output_area">\n\n    <div class="prompt"></div>\n\n\n\n\n<div class="output_png output_subarea ">\n<img src="data:image/png;base64,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