       langchain.docstore.in_memoryInMemoryDocstore)}_dict}($2a775d91-f052-44ed-8160-611274b64a95langchain.schema.documentDocument)}(__dict__}(page_contentX/  hide:
  - navigation
  - footer

FastStream

Effortless event stream integration for your services

Features

FastStream simplifies the process of writing producers and consumers for message queues, handling all the
parsing, networking and documentation generation automatically.

Making streaming microservices has never been easier. Designed with junior developers in mind, FastStream simplifies your work while keeping the door open for more advanced use-cases. Here's a look at the core features that make FastStream a go-to framework for modern, data-centric microservices.

Multiple Brokers: FastStream provides a unified API to work across multiple message brokers (Kafka, RabbitMQ support)

Pydantic Validation: Leverage Pydantic's{.external-link target="_blank"} validation capabilities to serialize and validates incoming messages

Automatic Docs: Stay ahead with automatic AsyncAPI{.external-link target="_blank"} documentation

Intuitive: Full-typed editor support makes your development experience smooth, catching errors before they reach runtime

Powerful Dependency Injection System: Manage your service dependencies efficiently with FastStream's built-in DI system

Testable: Supports in-memory tests, making your CI/CD pipeline faster and more reliable

Extendable: Use extensions for lifespans, custom serialization and middlewares

Integrations: FastStream is fully compatible with any HTTP framework you want (FastAPI especially)

Built for Automatic Code Generation: FastStream is optimized for automatic code generation using advanced models like GPT and Llama

That's FastStream in a nutshell—easy, efficient, and powerful. Whether you're just starting with streaming microservices or looking to scale, FastStream has got you covered.

History

FastStream is a new package based on the ideas and experiences gained from FastKafka{.external-link target="_blank"} and Propan{.external-link target="_blank"}. By joining our forces, we picked up the best from both packages and created a unified way to write services capable of processing streamed data regradless of the underliying protocol. We'll continue to maintain both packages, but new development will be in this project. If you are starting a new service, this package is the recommended way to do it.

Install

=== "Kafka"
    sh
    pip install faststream[kafka]

=== "RabbitMQ"
    sh
    pip install faststream[rabbit]

Writing app code

FastStream brokers provide convenient function decorators #!python @broker.subscriber
and #!python @broker.publisher to allow you to delegate the actual process of:

consuming and producing data to Event queues, and

decoding and encoding JSON encoded messages

These decorators make it easy to specify the processing logic for your consumers and producers, allowing you to focus on the core business logic of your application without worrying about the underlying integration.

Also, FastStream uses Pydantic{.external-link target="_blank"} to parse input
JSON-encoded data into Python objects, making it easy to work with structured data in your applications, so you can serialize your input messages just using type annotations.

Here is an example python app using FastStream that consumes data from an incoming data stream and outputs the data to another one:

=== "Kafka"
    ```python linenums="1" hl_lines="9"
from faststream import FastStream
from faststream.kafka import KafkaBroker

broker = KafkaBroker("localhost:9092")
app = FastStream(broker)

@broker.subscriber("in-topic")
@broker.publisher("out-topic")
async def handle_msg(user: str, user_id: int) -> str:
    return f"User: {user_id} - {user} registered"
    ```

=== "RabbitMQ"
    ```python linenums="1" hl_lines="9"
from faststream import FastStream
from faststream.rabbit import RabbitBroker

broker = RabbitBroker("amqp://guest:guest@localhost:5672/")
app = FastStream(broker)

@broker.subscriber("in-queue")
@broker.publisher("out-queue")
async def handle_msg(user: str, user_id: int) -> str:
    return f"User: {user_id} - {user} registered"
    ```

Also, Pydantic’s BaseModel{.external-link target="_blank"} class allows you
to define messages using a declarative syntax, making it easy to specify the fields and types of your messages.

=== "Kafka"
    ```python linenums="1" hl_lines="1 8 14"
from pydantic import BaseModel, Field, PositiveInt
from faststream import FastStream
from faststream.kafka import KafkaBroker

broker = KafkaBroker("localhost:9092")
app = FastStream(broker)

class User(BaseModel):
    user: str = Field(..., examples=["John"])
    user_id: PositiveInt = Field(..., examples=["1"])

@broker.subscriber("in-topic")
@broker.publisher("out-topic")
async def handle_msg(data: User) -> str:
    return f"User: {data.user} - {data.user_id} registered"
    ```

=== "RabbitMQ"
    ```python linenums="1" hl_lines="1 8 14"
from pydantic import BaseModel, Field, PositiveInt
from faststream import FastStream
from faststream.rabbit import RabbitBroker

broker = RabbitBroker("amqp://guest:guest@localhost:5672/")
app = FastStream(broker)

class User(BaseModel):
    user: str = Field(..., examples=["John"])
    user_id: PositiveInt = Field(..., examples=["1"])

@broker.subscriber("in-queue")
@broker.publisher("out-queue")
async def handle_msg(data: User) -> str:
    return f"User: {data.user} - {data.user_id} registered"
    ```

Testing the service

The service can be tested using the TestBroker context managers, which, by default, puts the Broker into "testing mode".

The Tester will redirect your subscriber and publisher decorated functions to the InMemory brokers, allowing you to quickly test your app without the need for a running broker and all its dependencies.

Using pytest, the test for our service would look like this:

=== "Kafka"
    ```python linenums="1" hl_lines="3 10 18-19"
    # Code above omitted 👆

import pytest
import pydantic
from faststream.kafka import TestKafkaBroker

@pytest.mark.asyncio
async def test_correct():
    async with TestKafkaBroker(broker) as br:
        await br.publish({
            "user": "John",
            "user_id": 1,
        }, "in-topic")

@pytest.mark.asyncio
async def test_invalid():
    async with TestKafkaBroker(broker) as br:
        with pytest.raises(pydantic.ValidationError):
            await br.publish("wrong message", "in-topic")
    ```

=== "RabbitMQ"
    ```python linenums="1" hl_lines="3 10 18-19"
    # Code above omitted 👆

import pytest
import pydantic
from faststream.rabbit import TestRabbitBroker

@pytest.mark.asyncio
async def test_correct():
    async with TestRabbitBroker(broker) as br:
        await br.publish({
            "user": "John",
            "user_id": 1,
        }, "in-queue")

@pytest.mark.asyncio
async def test_invalid():
    async with TestRabbitBroker(broker) as br:
        with pytest.raises(pydantic.ValidationError):
            await br.publish("wrong message", "in-queue")
    ```

Running the application

The application can be started using built-in FastStream CLI command.

To run the service, use the FastStream CLI command and pass the module (in this case, the file where the app implementation is located) and the app symbol to the command.

shell
faststream run basic:app

After running the command, you should see the following output:

shell
INFO     - FastStream app starting...
INFO     - input_data |            - `HandleMsg` waiting for messages
INFO     - FastStream app started successfully! To exit press CTRL+C

Also, FastStream provides you a great hot reload feature to improve your Development Experience

shell
faststream run basic:app --reload

And multiprocessing horizontal scaling feature as well:

shell
faststream run basic:app --workers 3

You can know more about CLI features here{.internal-link}

Project Documentation

FastStream automatically generates documentation for your project according to the AsyncAPI{.external-link target="_blank"} specification. You can work with both generated artifacts and place a web view of your documentation on resources available to related teams.

The availability of such documentation significantly simplifies the integration of services: you can immediately see what channels and message formats the application works with. And most importantly, it won't cost anything - FastStream has already created the docs for you!

Dependencies

FastStream (thanks to FastDepend{.external-link target="_blank"}) has a dependency management system similar to pytest fixtures and FastAPI Depends at the same time. Function arguments declare which dependencies you want are needed, and a special decorator delivers them from the global Context object.

```python linenums="1" hl_lines="9-10"
from faststream import Depends, Logger
async def base_dep(user_id: int) -> bool:
    return True

@broker.subscriber("in-test")
async def base_handler(user: str,
                       logger: Logger,
                       dep: bool = Depends(base_dep)):
    assert dep is True
    logger.info(user)
```

HTTP Frameworks integrations

Any Framework

You can use FastStream MQBrokers without a FastStream application.
Just start and stop them according to your application's lifespan.

{! includes/index/integrations.md !}

FastAPI Plugin

Also, FastStream can be used as part of FastAPI.

Just import a StreamRouter you need and declare the message handler with the same #!python @router.subscriber(...) and #!python @router.publisher(...) decorators.

!!! tip
    When used this way, FastStream does not utilize its own dependency and serialization system but integrates seamlessly into FastAPI.
    This means you can use Depends, BackgroundTasks and other FastAPI tools as if it were a regular HTTP endpoint.

{! includes/getting_started/integrations/fastapi/1.md !}

!!! note
    More integration features can be found here{.internal-link}

Code generator

As evident, FastStream is an incredibly user-friendly framework. However, we've taken it a step further and made it even more user-friendly! Introducing faststream-gen{.external-link target="_blank"}, a Python library that harnesses the power of generative AI to effortlessly generate FastStream applications. Simply describe your application requirements, and faststream-gen{.external-link target="_blank"} will generate a production-grade FastStream project that is ready to deploy in no time.

Save application description inside description.txt:
```
Create a FastStream application using localhost broker for testing and use the
default port number.

It should consume messages from the 'input_data' topic, where each message is a
JSON encoded object containing a single attribute: 'data'.

While consuming from the topic, increment the value of the data attribute by 1.

Finally, send message to the 'output_data' topic.
```

and run the following command to create a new FastStream project:
shell
faststream_gen -i description.txt

shell
✨  Generating a new FastStream application!
 ✔ Application description validated.
 ✔ FastStream app skeleton code generated. akes around 15 to 45 seconds)...
 ✔ The app and the tests are generated.  around 30 to 90 seconds)...
 ✔ New FastStream project created.
 ✔ Integration tests were successfully completed.
 Tokens used: 10768
 Total Cost (USD): $0.03284
✨  All files were successfully generated!

Tutorial

We also invite you to explore our tutorial, where we will guide you through the process of utilizing the faststream-gen{.external-link target="_blank"} Python library to effortlessly create FastStream applications:

Cryptocurrency analysis with FastStream{.external-link target="_blank"}

Stay in touch

Please show your support and stay in touch by:

giving our GitHub repository{.external-link target="_blank"} a star, and

joining our Discord server{.external-link target="_blank"}

Your support helps us to stay in touch with you and encourages us to
continue developing and improving the framework. Thank you for your
support!

Contributors

Thanks to all of these amazing people who made the project better!metadata}sourceG/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/index.mdsu__fields_set__(hh__private_attribute_values__}
_lc_kwargs}(hhhhusub$944af302-e9e5-4f27-b1c8-5dd9e68c1ed0h
)}(h
}(hX2  hide:
  - navigation
  - footer

Release Notes

FastStream is a new package based on the ideas and experiences gained from FastKafka and Propan. By joining our forces, we picked up the best from both packages and created the unified way to write services capable of processing streamed data regradless of the underliying protocol. We'll continue to maintain both packages, but new development will be in this project. If you are starting a new service, this package is the recommended way to do it.

Features

FastStream simplifies the process of writing producers and consumers for message queues, handling all the
parsing, networking and documentation generation automatically.

Making streaming microservices has never been easier. Designed with junior developers in mind, FastStream simplifies your work while keeping the door open for more advanced use-cases. Here's a look at the core features that make FastStream a go-to framework for modern, data-centric microservices.

Multiple Brokers: FastStream provides a unified API to work across multiple message brokers (Kafka, RabbitMQ support)

Pydantic Validation: Leverage Pydantic's validation capabilities to serialize and validates incoming messages

Automatic Docs: Stay ahead with automatic AsyncAPI documentation.

Intuitive: full typed editor support makes your development experience smooth, catching errors before they reach runtime

Powerful Dependency Injection System: Manage your service dependencies efficiently with FastStream's built-in DI system.

Testable: supports in-memory tests, making your CI/CD pipeline faster and more reliable

Extendable: use extensions for lifespans, custom serialization and middlewares

Integrations: FastStream is fully compatible with any HTTP framework you want (FastAPI especially)

Built for Automatic Code Generation: FastStream is optimized for automatic code generation using advanced models like GPT and Llama

That's FastStream in a nutshell—easy, efficient, and powerful. Whether you're just starting with streaming microservices or looking to scale, FastStream has got you covered.h}hI/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/release.mdsuh(hhh}h}(hhhh usub$25f0837c-ff87-4ebe-bf04-435806578d45h
)}(h
}(hX+  Kafka Routing

Kafka Overview

What is Kafka?

Kafka{.external-link target="_blank"} is an open-source distributed streaming platform developed by the Apache Software Foundation. It is designed to handle high-throughput, fault-tolerant, real-time data streaming. Kafka is widely used for building real-time data pipelines and streaming applications.

Key Kafka Concepts

1. Publish-Subscribe Model

Kafka is built around the publish-subscribe messaging model. In this model, data is published to topics, and multiple consumers can subscribe to these topics to receive the data. This decouples the producers of data from the consumers, allowing for flexibility and scalability.

2. Topics

A topic in Kafka is a logical channel or category to which messages are published by producers and from which messages are consumed by consumers. Topics are used to organize and categorize data streams. Each topic can have multiple partitions, which enable Kafka to distribute data and provide parallelism for both producers and consumers.

Kafka Topics

Understanding Kafka Topics

Topics are fundamental to Kafka and serve as the central point of data distribution. Here are some key points about topics:

Topics allow you to logically group and categorize messages.

Each message sent to Kafka is associated with a specific topic.

Topics can have one or more partitions to enable parallel processing and scaling.

Consumers subscribe to topics to receive messages.

FastStream KafkaBroker

The FastStream KafkaBroker is a key component of the FastStream framework that enables seamless integration with Apache Kafka. With the KafkaBroker, developers can easily connect to Kafka brokers, produce messages to Kafka topics, and consume messages from Kafka topics within their FastStream applications.

Establishing a Connection

To connect to Kafka using the FastStream KafkaBroker module, follow these steps:

Initialize the KafkaBroker instance: Start by initializing a KafkaBroker instance with the necessary configuration, including Kafka broker address.

Create your processing logic: Write a function that will consume the incoming messages in the defined format and produce a response to the defined topic

Decorate your processing function: To connect your processing function to the desired Kafka topics you need to decorate it with #!python @broker.subscriber and #!python @broker.publisher decorators. Now, after you start your application, your processing function will be called whenever a new message in the subscribed topic is available and produce the function return value to the topic defined in the publisher decorator.

Here's a simplified code example demonstrating how to establish a connection to Kafka using FastStream's KafkaBroker module:

```python linenums="1"
from faststream import FastStream
from faststream.kafka import KafkaBroker

broker = KafkaBroker("localhost:9092")
app = FastStream(broker)

@broker.subscriber("in-topic")
@broker.publisher("out-topic")
async def handle_msg(user: str, user_id: int) -> str:
    return f"User: {user_id} - {user} registered"
```

This minimal example illustrates how FastStream simplifies the process of connecting to Kafka and performing basic message processing from the in_topic to the out-topic. Depending on your specific use case and requirements, you can further customize your Kafka integration with FastStream to build robust and efficient streaming applications.

For more advanced configuration options and detailed usage instructions, please refer to the FastStream Kafka documentation and the offical Kafka documentation{.external-link target="_blank"}.h}hM/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/kafka/index.mdsuh(hhh}h}(hh)hh*usub$3a558d6a-defd-4642-852b-35d686c033c1h
)}(h
}(hX  Access to Message Information

As you may know, FastStream serializes a message body and provides you access to it through function arguments. However, there are times when you need to access additional message attributes such as offsets, headers, or other metadata.

Message Access

You can easily access this information by referring to the message object in the Context!

This object serves as a unified FastStream wrapper around the native broker library message (for example, aiokafka.ConsumerRecord in the case of Kafka). It contains most of the required information, including:

#!python body: bytes

#!python checksum: int

#!python headers: Sequence[Tuple[str, bytes]]

#!python key: Optional[aiokafka.structs.KT]

#!python offset: int

#!python partition: int

#!python serialized_key_size: int

#!python serialized_value_size: int

#!python timestamp: int

#!python timestamp_type: int

#!python topic: str

#!python value: Optional[aiokafka.structs.VT]

For example, if you would like to access the headers of an incoming message, you would do so like this:

```python hl_lines="1 6"
from faststream.kafka import KafkaMessage

@broker.subscriber("test")
async def base_handler(
    body: str,
    msg: KafkaMessage,
):
    print(msg.headers)
```

Message Fields Access

In most cases, you don't need all message fields; you need to know just a part of them.
You can use Context Fields access feature for this.

For example, you can get access to the headers like this:

```python hl_lines="6"
from faststream import Context

@broker.subscriber("test")
async def base_handler(
    body: str,
    headers: str = Context("message.headers"),
):
    print(headers)
```h}hO/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/kafka/message.mdsuh(hhh}h}(hh3hh4usub$c6e42d71-eeee-4a9e-89ae-70d95cf97af8h
)}(h
}(hX]  Publishing in Batches

If you want to send your data in batches, #!python @broker.publisher(...) decorator makes that possible for you.
To produce in batches, you need to do two things:

When creating your publisher, set the batch argument to True.

Return a tuple of the messages you wish to send in a batch. This action will prompt the producer to collect the messages and send them in a batch to a Kafka broker.

Here is an example of an app producing in batches to output_data topic when consuming from input_data_1.

In the highligted lines, we can see the steps of creating and using a batch publisher:

Creation of the publisher.

Publishing an actual batch of messages.

```python linenums="1" hl_lines="19 26"
from typing import Tuple

from pydantic import BaseModel, Field, NonNegativeFloat

from faststream import FastStream, Logger
from faststream.kafka import KafkaBroker

class Data(BaseModel):
    data: NonNegativeFloat = Field(
        ..., examples=[0.5], description="Float data example"
    )

broker = KafkaBroker("localhost:9092")
app = FastStream(broker)

decrease_and_increase = broker.publisher("output_data", batch=True)

@decrease_and_increase
@broker.subscriber("input_data_1")
async def on_input_data_1(msg: Data, logger: Logger) -> Tuple[Data, Data]:
    logger.info(msg)
    return Data(data=(msg.data * 0.5)), Data(data=(msg.data * 2.0))
```h}ha/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/kafka/Publisher/batch_publisher.mdsuh(hhh}h}(hh=hh>usub$c013e787-e9b6-47cf-87bf-ce755baf58f3h
)}(h
}(hX"  Publishing

FastStream KafkaBroker supports all regular publishing usecases{.internal-link}, which you can use without any changes.

In the following chapters, we will demonstrate how to use a KafkaBroker publisher in specific use cases, such as publishing batches or publishing with a key.h}hW/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/kafka/Publisher/index.mdsuh(hhh}h}(hhGhhHusub$489e7316-2068-4a51-bc32-43eebfa2612fh
)}(h
}(hXC  Defining a Partition Key

Partition keys are used in Apache Kafka to determine which partition a message should be written to. This ensures that related messages are kept together in the same partition, which can be useful for ensuring order or for grouping related messages together for efficient processing. Additionally, partitioning data across multiple partitions allows Kafka to distribute load across multiple brokers and scale horizontally, while replicating data across multiple brokers provides fault tolerance.

You can define your partition keys when using the #!python @KafkaBroker.publisher(...) decorator. This guide will demonstrate this feature to you.

Calling publish with a Key

To publish a message to a Kafka topic using a key, simply pass the key parameter to the publish function call, like this:

python
    await to_output_data.publish(Data(data=msg.data + 1.0), key=b"key")

App Example

Let's take a look at the whole app example that will consume from the input_data topic and publish with a key to the output_data topic.

You can see that the only difference from normal publishing is that now we pass the key to the publisher call.

```python linenums="1" hl_lines="25"
from pydantic import BaseModel, Field, NonNegativeFloat

from faststream import Context, FastStream, Logger
from faststream.kafka import KafkaBroker

class Data(BaseModel):
    data: NonNegativeFloat = Field(
        ..., examples=[0.5], description="Float data example"
    )

broker = KafkaBroker("localhost:9092")
app = FastStream(broker)

to_output_data = broker.publisher("output_data")

@broker.subscriber("input_data")
async def on_input_data(
    msg: Data, logger: Logger, key: bytes = Context("message.raw_message.key")
) -> None:
    logger.info(f"on_input_data({msg=})")
    await to_output_data.publish(Data(data=msg.data + 1.0), key=b"key")
```h}h]/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/kafka/Publisher/using_a_key.mdsuh(hhh}h}(hhQhhRusub$36cf4d50-d838-4968-8299-50c2548b6089h
)}(h
}(hX  Batch Subscriber

If you want to consume data in batches, the #!python @broker.subscriber(...) decorator makes that possible for you. By typing a consumed msg object as a list of messages and setting the batch parameter to True, the subscriber will call your consuming function with a batch of messages consumed from a single partition. Let’s demonstrate that now.

Subscriber Function with Batching

To consume messages in batches, you need to wrap your message type into a list and and set the batch parameter to True. The #!python @broker.subscriber(...) decorator will take care of the rest for you. Your subscribed function will be called with batches grouped by partition now.

Here is an example of consuming in batches from the test_batch topic:

python linenums="1"
@broker.subscriber("test_batch", batch=True)
async def handle_batch(msg: List[HelloWorld], logger: Logger):
    logger.info(msg)h}hc/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/kafka/Subscriber/batch_subscriber.mdsuh(hhh}h}(hh[hh\usub$a9280603-497a-4d0c-8477-d93eef69dd4ah
)}(h
}(hX	
  Basic Subscriber

To start consuming from a Kafka topic, just decorate your consuming function with a #!python @broker.subscriber(...) decorator, passing a string as a topic key.

In the folowing example, we will create a simple FastStream app that will consume HelloWorld messages from a hello_world topic.

The full app code looks like this:

```python linenums="1"
from pydantic import BaseModel, Field

from faststream import FastStream, Logger
from faststream.kafka import KafkaBroker

class HelloWorld(BaseModel):
    msg: str = Field(
        ...,
        examples=["Hello"],
        description="Demo hello world message",
    )

broker = KafkaBroker("localhost:9092")
app = FastStream(broker)

@broker.subscriber("hello_world")
async def on_hello_world(msg: HelloWorld, logger: Logger):
    logger.info(msg)
```

Import FastStream and KafkaBroker

To use the #!python @broker.subscriber(...) decorator, first we need to import the base FastStream app KafkaBroker to create our broker.

python linenums="1"
from faststream import FastStream, Logger
from faststream.kafka import KafkaBroker

Define the HelloWorld Message Structure

Next, you need to define the structure of the messages you want to consume from the topic using Pydantic. For the guide, we’ll stick to something basic, but you are free to define any complex message structure you wish in your project.

python linenums="1"
class HelloWorld(BaseModel):
    msg: str = Field(
        ...,
        examples=["Hello"],
        description="Demo hello world message",
    )

Create a KafkaBroker

Next, we will create a KafkaBroker object and wrap it into the FastStream object so that we can start our app using CLI later.

python linenums="1"
broker = KafkaBroker("localhost:9092")
app = FastStream(broker)

Create a Function that will Consume Messages from a Kafka hello-world Topic

Let’s create a consumer function that will consume HelloWorld messages from hello_world topic and log them.

python linenums="1"
@broker.subscriber("hello_world")
async def on_hello_world(msg: HelloWorld, logger: Logger):
    logger.info(msg)

The function decorated with the #!python @broker.subscriber(...) decorator will be called when a message is produced to Kafka.

The message will then be injected into the typed msg argument of the function, and its type will be used to parse the message.

In this example case, when the message is sent to a hello_world topic, it will be parsed into a HelloWorld class, and the on_hello_world function will be called with the parsed class as the msg argument value.h}hX/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/kafka/Subscriber/index.mdsuh(hhh}h}(hhehhfusub$023a3c45-be94-4441-b200-a40dafcf4599h
)}(h
}(hX  Application and Access Logging

FastStream uses two previously configured loggers:

faststream - used by FastStream app

faststream.access - used by the broker

Logging Requests

To log requests, it is strongly recommended to use the access_logger of your broker, as it is available from the Context{.internal-link} of your application.

```python
from faststream import Logger
from faststream.rabbit import RabbitBroker

broker = RabbitBroker()

@broker.subscriber("test")
async def func(logger: Logger):
    logger.info("message received")
```

This approach offers several advantages:

The logger already contains the request context, including the message ID and broker-based parameters.

By replacing the logger when initializing the broker, you will automatically replace all loggers inside your functions.

Logging Levels

If you use the FastStream CLI, you can change the current logging level of the entire application directly from the command line.

The --log-level flag sets the current logging level for both the broker and the FastStream app. This allows you to configure the levels of not only the default loggers but also your custom loggers, if you use them inside FastStream.

console
faststream run serve:app --log-level debug

If you want to completely disable the default logging of FastStream, you can set logger=None

```python
from faststream import FastStream
from faststream.rabbit import RabbitBroker

broker = RabbitBroker(logger=None)  # Disables broker logs
app = FastStream(broker, logger=None)  # Disables application logs
```

!!! warning
    Be careful: the logger that you get from the context will also have the value None if you turn off broker logging.

If you don't want to lose access to the `logger' inside your context but want to disable the default logs of FastStream, you can lower the level of logs that the broker publishes itself.

```python
import logging
from faststream.rabbit import RabbitBroker

Sets the broker logs to the DEBUG level

broker = RabbitBroker(log_level=logging.DEBUG)
```

Formatting Logs

If you are not satisfied with the current format of your application logs, you can change it directly in your broker's constructor.

python
from faststream.rabbit import RabbitBroker
broker = RabbitBroker(log_fmt="%(asctime)s %(levelname)s - %(message)s")

Using Your Own Loggers

Since FastStream works with the standard logging.Logger object, you can initiate an application and a broker
using your own logger.

```python
import logging
from faststream import FastStream
from faststream.rabbit import RabbitBroker

logger = logging.getLogger("my_logger")

broker = RabbitBroker(logger=logger)
app = FastStream(broker, logger=logger)
```

By doing this, you will lose information about the context of the current request. However, you can retrieve it directly from the context anywhere in your code.

python
from faststream import context
log_context: dict[str, str] = context.get_local("log_context")

Logger Access

If you want to override default logger's behavior, you can access them directly via logging.

python
import logging
logger = logging.getLogger("faststream")
access_logger = logging.getLogger("faststream.access")

Or you can import them from FastStream.

python
from faststream.log import access_logger, loggerh}hY/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/logging.mdsuh(hhh}h}(hhohhpusub$f440d061-ebf4-4e3e-ad56-b84e4f4f432fh
)}(h
}(hX  hide:
    - toc
run_docker: To start a new project, we need a test broker container

QUICK START

Install using pip:

{% import 'getting_started/index/install.md' as includes with context %}
{{ includes }}

Basic Usage

To create a basic application, add the following code to a new file (e.g. serve.py):

{! includes/getting_started/index/base.md !}

And just run this command:

shell
faststream run serve:app

After running the command, you should see the following output:

shell
INFO     - FastStream app starting...
INFO     - test |            - `BaseHandler` waiting for messages
INFO     - FastStream app started successfully! To exit, press CTRL+C

Enjoy your new development experience!

??? tip "Don't forget to stop the test broker container"
    bash
    docker container stop test-mqh}hW/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/index.mdsuh(hhh}h}(hhyhhzusub$5a19d47e-486e-4e00-ba41-1b86ff2b8070h
)}(h
}(h h}hb/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/dependencies/sub.mdsuh(hhh}h}(hhhhusub$d0655548-290c-4c90-8803-3674448a3370h
)}(h
}(h8Broker-level dependencies

Subscriber-level dependenciesh}he/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/dependencies/global.mdsuh(hhh}h}(hhhhusub$710ff35b-c286-4ee1-8235-971f4f6600f0h
)}(h
}(hhh}hd/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/dependencies/yield.mdsuh(hhh}h}(hhhhusub$2602d508-98d4-414c-ba9c-09b399de153ch
)}(h
}(hhh}hd/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/dependencies/class.mdsuh(hhh}h}(hhhhusub$d065f425-69ae-44f7-9bec-5a74c4aed55fh
)}(h
}(hXZ  nested: A nested dependency is called here

Dependencies

FastStream uses the secondary library FastDepends{.external-link target="_blank"} for dependency management.
This dependency system is literally borrowed from FastAPI, so if you know how to work with that framework, you'll be comfortable with dependencies in FastStream.

You can visit the FastDepends{.external-link target="_blank"} documentation for more details, but the key points and additions are covered here.

Type Casting

The key function in the dependency management and type conversion system in FastStream is the decorator #!python @apply_types (also known as #!python @inject in FastDepends).

By default, it applies to all event handlers, unless you disabled the same option when creating the broker.

{! includes/getting_started/dependencies/1.md !}

!!! warning
    Setting the apply_types=False flag not only disables type casting but also Depends and Context.

This flag can be useful if you are using FastStream within another framework and you need to use its native dependency system.

Dependency Injection

To implement dependencies in FastStream, a special class called Depends is used

{! includes/getting_started/dependencies/2.md !}

The first step: You need to declare a dependency, which can be any Callable object.

??? note "Callable"
    A "Callable" is an object that can be "called". It can be a function, a class, or a class method.

{! includes/getting_started/dependencies/3.md !}

Second step: Declare which dependencies you need using Depends

{! includes/getting_started/dependencies/4.md !}

The last step: Just use the result of executing your dependency!

It's easy, isn't it?

!!! tip "Auto #!python @apply_types"
    In the code above, we didn't use this decorator for our dependencies. However, it still applies
    to all functions used as dependencies. Please keep this in your mind.

Top-level Dependencies

If you don't need a dependency result, you can use the following code:

python
@broker.subscriber("test")
def method(_ = Depends(...)): ...

But, using a special subscriber parameter is much more suitable:

python
@broker.subscriber("test", dependencies=[Depends(...)])
def method(): ...

You can also declare broker-level dependencies, which will be applied to all broker's handlers:

python
broker = RabbitBroker(dependencies=[Depends(...)])

Nested Dependencies

Dependencies can also contain other dependencies. This works in a very predictable way: just declare
Depends in the dependent function.

{% import 'getting_started/dependencies/5.md' as includes with context %}
{{ includes }}

!!! Tip "Caching"
    In the example above, the another_dependency function will be called at ONCE!
    FastDepends caches all dependency execution results within ONE #!python @apply_types call stack.
    This means that all nested dependencies will receive the cached result of dependency execution.
    But, between different calls of the main function, these results will be different.

Use with Regular Functions

You can use the decorator #!python @apply_types not only with #!python @broker.subscriber(...), but also with regular functions, both synchronous and asynchronous.

=== "Sync"
    ```python hl_lines="3-4" linenums="1"
from faststream import Depends, apply_types

def simple_dependency(a: int, b: int = 3):
    return a + b

@apply_types
def method(a: int, d: int = Depends(simple_dependency)):
    return a + d

assert method("1") == 5
    ```

=== "Async"
    ```python hl_lines="4-5 7-8" linenums="1"
import asyncio
from faststream import Depends, apply_types

async def simple_dependency(a: int, b: int = 3):
    return a + b

def another_dependency(a: int):
    return a

@apply_types
async def method(
    a: int,
    b: int = Depends(simple_dependency),
    c: int = Depends(another_dependency),
):
    return a + b + c

assert asyncio.run(method("1")) == 6
    ```

Casting Dependency Types

FastDepends, used by FastStream, also gives the type return. This means that the value returned by the dependency will be
be cast to the type twice: as return for dependencies and as the input argument of the main function. This does not incur additional costs if
these types have the same annotation. Just keep it in mind. Or not... Anyway, I've warned you.

```python linenums="1"
from faststream import Depends, apply_types

def simple_dependency(a: int, b: int = 3) -> str:
    return a + b  # 'return' is cast to str for the first time

@inject
def method(a: int, d: int = Depends(simple_dependency)):
    # 'd' is cast to int for the second time
    return a + d

assert method("1") == 5
```

Also, the result of executing the dependency is cached. If you use this dependency in N functions,
this cached result will be converted to type N times (at the input to the function being used).

To avoid problems with this, use mypy{.external-link target="_blank"} or just be careful with the annotation
of types in your project.h}hd/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/dependencies/index.mdsuh(hhh}h}(hhhhusub$0b1fcd97-be5b-4ca5-963d-afa7ffcc44b3h
)}(h
}(h;https://lancetnik.github.io/FastDepends/tutorial/overrides/h}hf/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/dependencies/testing.mdsuh(hhh}h}(hhhhusub$03f56b6f-ac48-4888-8fd0-796ae27fbae1h
)}(h
}(hX  comment_1: This way you can get access to context object by its name
comment_2: This way you can get access to context object specific field

Access by Name

Sometimes, you may need to use a different name for the argument (not the one under which it is stored in the context) or get access to specific parts of the object. To do this, simply specify the name of what you want to access, and the context will provide you with the object.

{% import 'getting_started/context/fields.md' as includes with context %}
{{ includes }}h}h`/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/context/fields.mdsuh(hhh}h}(hhhhusub$aabb10a8-005d-4a0b-8ead-5198127a280fh
)}(h
}(hX  Context Extra Options

Additionally, Context provides you with some extra capabilities for working with containing objects.

Default Values

For instance, if you attempt to access a field that doesn't exist in the global context, you will receive a pydantic.ValidationError exception.

However, you can set default values if needed.

=== "Kafka"
    python linenums="1" hl_lines="3 5"
    {!> docs_src/getting_started/context/default_arguments_kafka.py [ln:7-11] !}

=== "RabbitMQ"
    python linenums="1" hl_lines="3 5"
    {!> docs_src/getting_started/context/default_arguments_rabbit.py [ln:7-11] !}

Cast Context Types

By default, context fields are NOT CAST to the type specified in their annotation.

=== "Kafka"
    python linenums="1" hl_lines="6 10 12"
    {!> docs_src/getting_started/context/cast_kafka.py [ln:1-12] !}

=== "RabbitMQ"
    python linenums="1" hl_lines="6 10 12"
    {!> docs_src/getting_started/context/cast_rabbit.py [ln:1-12] !}

If you require this functionality, you can enable the appropriate flag.

=== "Kafka"
    python linenums="1" hl_lines="3 5"
    {!> docs_src/getting_started/context/cast_kafka.py [ln:14-18] !}

=== "RabbitMQ"
    python linenums="1" hl_lines="3 5"
    {!> docs_src/getting_started/context/cast_rabbit.py [ln:14-18] !}h}h_/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/context/extra.mdsuh(hhh}h}(hhhhusub$0e2aa7ad-990b-4cb0-bcd5-76cd25a79e3fh
)}(h
}(hX  Existing Fields

Context already contains some global objects that you can always access:

broker - the current broker

context - the context itself, in which you can write your own fields

logger - the logger used for your broker (tags messages with message_id)

message - the raw message (if you need access to it)

At the same time, thanks to contextlib.ContextVar, message is local for you current consumer scope.

Access to Context Fields

By default, the context searches for an object based on the argument name.

=== "Kafka"
    python linenums="1" hl_lines="1 12-15"
    {!> docs_src/getting_started/context/existed_context_kafka.py [ln:1-2,10-11,14-23] !}

=== "RabbitMQ"
    python linenums="1" hl_lines="1 12-15"
    {!> docs_src/getting_started/context/existed_context_rabbit.py [ln:1-2,10-11,14-23] !}

Annotated Aliases

Also, FastStream has already created Annotated aliases to provide you with comfortable access to existing objects. You can import them directly from faststream or your broker-specific modules:

Shared aliases

python
from faststream import Logger, ContextRepo

Kafka aliases

python
from faststream.kafka.annotations import (
    Logger, ContextRepo, KafkaMessage, KafkaBroker, KafkaProducer
)

RabbitMQ aliases

python
from faststream.rabbit.annotations import (
    Logger, ContextRepo, RabbitMessage, RabbitBroker, RabbitProducer
)

To use them, simply import and use them as subscriber argument annotations.

=== "Kafka"
    python linenums="1" hl_lines="3-8 17-20"
    {!> docs_src/getting_started/context/existed_context_kafka.py [ln:1-11,26-35] !}

=== "RabbitMQ"
    python linenums="1" hl_lines="3-8 17-20"
    {!> docs_src/getting_started/context/existed_context_rabbit.py [ln:1-11,26-35] !}h}ha/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/context/existed.mdsuh(hhh}h}(hhhhusub$baaa8f51-8e83-4a37-a1ae-be59c16e458eh
)}(h
}(hX  Application Context

FastStreams has its own Dependency Injection container - Context, used to store application runtime objects and variables.

With this container, you can access both application scope and message processing scope objects. This functionality is similar to Depends{.internal-link} usage.

=== "Kafka"
    python linenums="1" hl_lines="1 11"
    {!> docs_src/getting_started/context/base_kafka.py !}

=== "RabbitMQ"
    python linenums="1" hl_lines="1 11"
    {!> docs_src/getting_started/context/base_rabbit.py !}

But, with the Annotated{.external-docs target="_blank"} Python feature usage, it is much closer to #!python @pytest.fixture.

=== "Kafka"
    python linenums="1" hl_lines="1 6 15"
    {!> docs_src/getting_started/context/annotated_kafka.py !}

=== "RabbitMQ"
    python linenums="1" hl_lines="1 6 15"
    {!> docs_src/getting_started/context/annotated_rabbit.py !}

Usages

By default, the context is available in the same place as Depends:

at lifespan hooks

message subscribers

nested dependencies

!!! tip
    Fields obtained from the Context are editable, so editing them in a function means editing them everywhere.

Compatibility with Regular Functions

To use context in other functions, use the #!python @apply_types decorator. In this case, the context of the called function will correspond to the context of the event handler from which it was called.

```python linenums="1" hl_lines="6 9-10"
from faststream import Context, apply_types
@broker.subscriber("test")
async def handler(body):
    nested_func(body)

@apply_types
def nested_func(body, logger=Context()):
    logger.info(body)
```

In the example above, we did not pass the logger function at calling it; it was placed outside of context.h}h_/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/context/index.mdsuh(hhh}h}(hhhhusub$5c12f098-7578-4e53-886b-f1ad148ba059h
)}(h
}(hXQ  Context Fields Declaration

You can also store your own objects in the Context.

Global

To declare an application-level context field, you need to call the context.set_global method with with a key to indicate where the object will be placed in the context.

=== "Kafka"
    python linenums="1" hl_lines="9-10"
    {!> docs_src/getting_started/context/custom_global_context_kafka.py [ln:1-5,16-18] !}

=== "RabbitMQ"
    python linenums="1" hl_lines="9-10"
    {!> docs_src/getting_started/context/custom_global_context_rabbit.py [ln:1-5,16-18] !}

Afterward, you can access your secret field in the usual way:

=== "Kafka"
    python linenums="1" hl_lines="4"
    {!> docs_src/getting_started/context/custom_global_context_kafka.py [ln:8-13] !}

=== "RabbitMQ"
    python linenums="1" hl_lines="4"
    {!> docs_src/getting_started/context/custom_global_context_rabbit.py [ln:8-13] !}

In this case, the field becomes a global context field: it does not depend on the current message handler (unlike message)

To remove a field from the context use the reset_global method:

python
context.reset_global("my_key")

Local

To set a local context (available only within the message processing scope), use the context manager scope

=== "Kafka"
    python linenums="1" hl_lines="15 19 21-22"
    {!> docs_src/getting_started/context/custom_local_context_kafka.py !}

=== "RabbitMQ"
    python linenums="1" hl_lines="15 19 21-22"
    {!> docs_src/getting_started/context/custom_local_context_rabbit.py !}

You can also set the context yourself, and it will remain within the current call stack until you clear it.

=== "Kafka"
    python linenums="1" hl_lines="1 14 25"
    {!> docs_src/getting_started/context/manual_local_context_kafka.py !}

=== "RabbitMQ"
    python linenums="1" hl_lines="1 14 25"
    {!> docs_src/getting_started/context/manual_local_context_rabbit.py !}h}h`/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/context/custom.mdsuh(hhh}h}(hhhhusub$7fad6eea-bb43-400f-b696-928b14d089a6h
)}(h
}(hX  CLI

FastStream has its own built-in CLI tool for your maximum comfort as a developer.

!!! quote ""
    Thanks to typer{.external-link target="_blank"} and watchfiles{.external-link target="_blank"}. Their work is the basis of this tool.

shell
faststream --help

```{ .shell .no-copy }
Usage: faststream [OPTIONS] COMMAND [ARGS]...

Generate, run and manage FastStream apps to greater development experience

Options:
  -v, --version                   Show current platform, python and FastStream
                                  version
  --install-completion [bash|zsh|fish|powershell|pwsh]
                                  Install completion for the specified shell.
  --show-completion [bash|zsh|fish|powershell|pwsh]
                                  Show completion for the specified shell, to
                                  copy it or customize the installation.
  --help                          Show this message and exit.

Commands:
  docs  AsyncAPI schema commands
  run   Run [MODULE:APP] FastStream application
```

Running the Project

Multiprocessing Scaling

FastStream allows you to scale application right from the command line by running you application in the Process pool.

Just set the --worker option to scale your application:

shell
faststream run serve:app --workers 2

{ .shell .no-copy }
INFO     - Started parent process [7591]
INFO     - Started child process [7593]
INFO     - Started child process [7594]
INFO     - test |            - `Handle` waiting for messages
INFO     - test |            - `Handle` waiting for messages

Hot Reload

Thanks to watchfiles{.external-link target="_blank"}, written in Rust, you can
work with your project easily. Edit the code as much as you like - the new version has already been launched and is waiting for your requests!

shell
faststream run serve:app --reload

{ .shell .no-copy }
INFO     - Started reloader process [7902] using WatchFiles
INFO     - FastStream app starting...
INFO     - test |            - `Handle` waiting for messages
INFO     - FastStream app started successfully! To exit press CTRL+C

Environment Management

You can pass any custom flags and launch options to the FastStream CLI even without first registering them. Just use them when launching the application - and they will be right in your environment.

Use this option to select environment files, configure logging, or at your discretion.

For example, we will pass the .env file to the context of our application:

shell
faststream run serve:app --env=.env.dev

{ .shell .no-copy }
INFO     - FastStream app starting...
INFO     - test |            - `Handle` waiting for messages
INFO     - FastStream app started successfully! To exit press CTRL+C

{! includes/getting_started/cli/env.md !}

!!! note
    Note that the env parameter was passed to the setup function directly from the command line

All passed values can be of type #!python bool, #!python str or #!python list[str].

In this case, the flags will be interpreted as follows:

{ .shell .no-copy }
faststream run app:app --flag       # flag = True
faststream run app:app --no-flag    # flag = False
faststream run app:app --my-flag    # my_flag = True
faststream run app:app --key value  # key = "value"
faststream run app:app --key 1 2    # key = ["1", "2"]

You can use them both individually and together in unlimited quantities.

AsyncAPI Schema

Also, the FastStream CLI allows you to work with the AsyncAPI schema in a simple way.

You are able to generate .json or .yaml files by your application code or host HTML representation directly:

shell
faststream docs --help

```{ .shell .no-copy }
Usage: faststream docs [OPTIONS] COMMAND [ARGS]...

AsyncAPI schema commands

Options:
  --help  Show this message and exit.

Commands:
  gen    Generate project AsyncAPI schema
  serve  Serve project AsyncAPI schema
```

To learn more about the commands above, please visit AsyncAPI export{.internal-link} and AsyncAPI hosting{.internal-link}.h}h[/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/cli/index.mdsuh(hhh}h}(hhhhusub$1a3152b1-6dcc-4666-8c1f-eb157330c8bfh
)}(h
}(hX  Pydantic Serialization

pydantic.Field

Besides, FastStream uses your handlers' annotations to collect information about the application schema and generate AsyncAPI{.external-link target="_blank"} schema.

You can access this information with extra details using pydantic.Field (such as title, description and examples). Additionally, Fields{.external-link target="_blank"} usage allows you to add extra validations to your message schema.

Just use pydantic.Field as a function default argument:

=== "Kafka"
    python linenums="1" hl_lines="12-17"
    {!> docs_src/getting_started/subscription/pydantic_fields_kafka.py !}

=== "RabbitMQ"
    python linenums="1" hl_lines="12-17"
    {!> docs_src/getting_started/subscription/pydantic_fields_rabbit.py !}

pydantic.BaseModel

To make your message schema reusable between different subscribers and publishers, you can decalre it as a pydantic.BaseModel and use it as a single message annotation:

=== "Kafka"
    python linenums="1" hl_lines="1 10 20"
    {!> docs_src/getting_started/subscription/pydantic_model_kafka.py !}

=== "RabbitMQ"
    python linenums="1" hl_lines="1 10 20"
    {!> docs_src/getting_started/subscription/pydantic_model_rabbit.py !}h}hg/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/subscription/pydantic.mdsuh(hhh}h}(hhhhusub$8ee23c4f-7b8a-4d30-af55-f7d60d2e32c4h
)}(h
}(hX  Subscription Basics

FastStream provides a Message Broker agnostic way to subscribe to event streams.

You need not even know about topics/queues/subjects or any broker inner objects you use.
The basic syntax is the same for all brokers:

=== "Kafka"
    ```python
    from faststream.kafka import KafkaBroker

=== "RabbitMQ"
    ```python
    from faststream.rabbit import RabbitBroker

!!! tip
    If you want to use Message Broker specific features, please visit the corresponding broker documentation section.
    In the Tutorial section, the general features are described.

Also, synchronous functions are supported as well:

=== "Kafka"
    ```python
    from faststream.kafka import KafkaBroker

=== "RabbitMQ"
    ```python
    from faststream.rabbit import RabbitBroker

Message Body Serialization

Generally, FastStream uses your function type annotation to serialize incoming message body with Pydantic{.external-link target="_blank"}. This is similar to how FastAPI{.external-link target="_blank"} works (if you are familiar with it).

python
@broker.subscriber("test")
async def handle_str(msg_body: str):
    ...

You can also access some extra features through the function arguments, such as Depends{.internal-link} and Context{.internal-link} if required.

However, you can easily disable Pydantic validation by creating a broker with the following option #!python Broker(apply_types=False) (this also disables Context and Depends features).

This way FastStream still consumes #!python json.loads result, but without pydantic validation and casting.

=== "Kafka"
    ```python
    from faststream.kafka import KafkaBroker

=== "RabbitMQ"
    ```python
    from faststream.rabbit import RabbitBroker

Multiple Subscriptions

You can also subscribe to multiple event streams at the same time with one function. Just wrap it with multiple #!python @broker.subscriber(...) decorators (they have no effect on each other).

python
@broker.subscriber("first_sub")
@broker.subscriber("second_sub")
async def handler(msg):
    ...h}hd/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/subscription/index.mdsuh(hhh}h}(hj  hj  usub$0c0be44b-b1b2-4c73-83e6-27159740e735h
)}(h
}(hX9  Annotation Serialization

Basic usage

As you already know, FastStream serializes your incoming message body according to the function type annotations using Pydantic{.external-link target="_blank"}.

So, there are some valid usecases:

```python
@broker.subscriber("test")
async def handle(msg: str):
    ...

@broker.subscriber("test")
async def handle(msg: bytes):
    ...

@broker.subscriber("test")
async def handle(msg: int):
    ...
```

As with other Python primitive types as well (#!python float, #!python bool, #!python datetime, etc)

!!! note
    If the incoming message cannot be serialized by the described schema, FastStream raises a pydantic.ValidationError with a correct log message.

Also, thanks to Pydantic (again), FastStream is able to serialize (and validate) more complex types like pydantic.HttpUrl, pydantic.PostitiveInt, etc.

JSON Basic Serialization

But how can we serialize more complex message, like #!json { "name": "John", "user_id": 1 } ?

For sure, we can serialize it as a simple #!python dict

```python
from typing import Dict, Any

@broker.subscriber("test")
async def handle(msg: dict[str, Any]):
    ...
```

But it doesn't looks like a correct message validation, does it?

For this reason, FastStream supports per-argument message serialization: you can declare multiple arguments with various types and your message will unpack to them:

=== "Kafka"
    python
    {!> docs_src/getting_started/subscription/annotation_kafka.py [ln:8-11] !}

=== "RabbitMQ"
    python
    {!> docs_src/getting_started/subscription/annotation_rabbit.py [ln:8-11] !}h}hi/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/subscription/annotation.mdsuh(hhh}h}(hj
  hj  usub$b63114c8-d1c7-4f01-9717-70a82c862948h
)}(h
}(hXn  Application-level Filtering

FastStream also allows you to specify the message processing way using message headers, body type or something else. The filter feature enables you to consume various messages with different schemas within a single event stream.

!!! tip
    Message must be consumed at ONCE (crossing filters are not allowed)

As an example, let's create a subscriber for both JSON and non-JSON messages:

=== "Kafka"
    python linenums="1" hl_lines="10 17"
    {!> docs_src/getting_started/subscription/filter_kafka.py [ln:1-19] !}

=== "RabbitMQ"
    python linenums="1" hl_lines="10 17"
    {!> docs_src/getting_started/subscription/filter_rabbit.py [ln:1-19] !}

!!! note
    A subscriber without a filter is a default subscriber. It consumes messages that have not been consumed yet.

For now, the following message will be delivered to the handle function

=== "Kafka"
    python hl_lines="2"
    {!> docs_src/getting_started/subscription/filter_kafka.py [ln:24-27] !}

=== "RabbitMQ"
    python hl_lines="2"
    {!> docs_src/getting_started/subscription/filter_rabbit.py [ln:24-27] !}

And this one will be delivered to the default_handler

=== "Kafka"
    python hl_lines="2"
    {!> docs_src/getting_started/subscription/filter_kafka.py [ln:29-32] !}

=== "RabbitMQ"
    python hl_lines="2"
    {!> docs_src/getting_started/subscription/filter_rabbit.py [ln:29-32] !}h}hh/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/subscription/filtering.mdsuh(hhh}h}(hj  hj  usub$2b1df16a-e7e5-4177-91ac-86e0ad3ad5bbh
)}(h
}(hX|  Subscriber Testing

Testability is a crucial part of any application, and FastStream provides you with the tools to test your code easily.

Original Application

Let's take a look at the original application to test

=== "Kafka"
    python linenums="1" title="annotation_kafka.py"
    {!> docs_src/getting_started/subscription/annotation_kafka.py !}

=== "RabbitMQ"
    python linenums="1" title="annotation_rabbit.py"
    {!> docs_src/getting_started/subscription/annotation_rabbit.py !}

It consumes JSON messages like #!json { "name": "username", "user_id": 1 }

You can test your consume function like a regular one, for sure:

python
@pytest.mark.asyncio
async def test_handler():
    await handle("John", 1)

But if you want to test your function closer to your real runtime, you should use the special FastStream test client.

In-Memory Testing

Deploying a whole service with a Message Broker is a bit too much just for testing purposes, especially in your CI environment. Not to mention the possible loss of messages due to network failures when working with real brokers.

For this reason, FastStream has a special TestClient to make your broker work in InMemory mode.

Just use it like a regular async context manager - all published messages will be routed in-memory (without any external dependencies) and consumed by the correct handler.

=== "Kafka"
    python linenums="1" hl_lines="4 11-12"
    {!> docs_src/getting_started/subscription/testing_kafka.py [ln:1-12] !}

=== "RabbitMQ"
    python linenums="1" hl_lines="4 11-12"
    {!> docs_src/getting_started/subscription/testing_rabbit.py [ln:1-12] !}

Catching Exceptions

This way you can catch any exceptions that occur inside your handler:

=== "Kafka"
    python linenums="1" hl_lines="4"
    {!> docs_src/getting_started/subscription/testing_kafka.py [ln:18-23] !}

=== "RabbitMQ"
    python linenums="1" hl_lines="4"
    {!> docs_src/getting_started/subscription/testing_rabbit.py [ln:18-23] !}

Validates Input

Also, your handler has a mock object to validate your input or call counts.

=== "Kafka"
    python linenums="1" hl_lines="6"
    {!> docs_src/getting_started/subscription/testing_kafka.py [ln:9-14] !}

=== "RabbitMQ"
    python linenums="1" hl_lines="6"
    {!> docs_src/getting_started/subscription/testing_rabbit.py [ln:9-14] !}

!!! note
    The Handler mock has a not-serialized JSON message body. This way you can validate the incoming message view, not python arguments.

You should be careful with this feature: all mock objects will be cleared when the context manager exits.

=== "Kafka"
    python linenums="1" hl_lines="6 8"
    {!> docs_src/getting_started/subscription/testing_kafka.py [ln:9-16] !}

=== "RabbitMQ"
    python linenums="1" hl_lines="6 8"
    {!> docs_src/getting_started/subscription/testing_rabbit.py [ln:9-16] !}

Real Broker Testing

If you want to test your application in a real environment, you shouldn't have to rewrite all you tests: just pass with_real optional parameter to your TestClient context manager. This way, TestClient supports all the testing features but uses an unpatched broker to send and consume messages.

=== "Kafka"
    python linenums="1" hl_lines="4 11 13 20 23"
    {!> docs_src/getting_started/subscription/real_testing_kafka.py !}

=== "RabbitMQ"
    python linenums="1" hl_lines="4 11 13 20 23"
    {!> docs_src/getting_started/subscription/real_testing_rabbit.py !}

!!! tip
    When you're using a patched broker to test your consumers, the publish method is called synchronously with a consumer one, so you need not wait until your message is consumed. But in the real broker's case, it doesn't.

A Little Tip

It can be very helpful to set the with_real flag using an environment variable. This way, you will be able to choose the testing mode right from the command line:

bash
WITH_REAL=True/False pytest tests/

To learn more about managing your application configiruation visit this{.internal-link} page.h}hc/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/subscription/test.mdsuh(hhh}h}(hj!  hj"  usub$cb71c7f2-02f0-4161-86c2-6ea9569ccb19h
)}(h
}(hX
  How to Generate and Serve AsyncAPI Documentation

In this guide, let's explore how to generate and serve AsyncAPI{.external-link target="_blank"} documentation for our FastStream application.

Writing the FastStream Application

Here's an example Python application using FastStream that consumes data from a
topic, increments the value, and outputs the data to another topic.
Save it in a file called basic.py.

``` python
from pydantic import BaseModel, Field, NonNegativeFloat

from faststream import FastStream, Logger
from faststream.kafka import KafkaBroker

class DataBasic(BaseModel):
    data: NonNegativeFloat = Field(
        ..., examples=[0.5], description="Float data example"
    )

broker = KafkaBroker("localhost:9092")
app = FastStream(broker)

@broker.publisher("output_data")
@broker.subscriber("input_data")
async def on_input_data(msg: DataBasic, logger: Logger) -> DataBasic:
    logger.info(msg)
    return DataBasic(data=msg.data + 1.0)
```

Generating the AsyncAPI Specification

Now that we have a FastStream application, we can proceed with generating the AsyncAPI specification using a CLI command.

shell
faststream docs gen basic:app

The above command will generate the AsyncAPI specification and save it in a file called asyncapi.json.

If you prefer yaml instead of json, please run the following command to generate asyncapi.yaml.

shell
faststream docs gen --yaml basic:app

!!! note
    To generate the documentation in yaml format, please install the necessary dependency to work with YAML file format at first.h}ha/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/asyncapi/export.mdsuh(hhh}h}(hj+  hj,  usub$6fbdca79-4f53-437f-b8c0-6d3361f437e3h
)}(h
}(hXN  Serving the AsyncAPI Documentation

FastStream provides a command to serve the AsyncAPI documentation.

!!! note
    This feature requires an Internet connection to obtain the AsyncAPI HTML via CDN.

shell
faststream docs serve basic:app

In the above command, we are providing the path in the format of python_module:FastStream. Alternatively, you can also specify asyncapi.json or asyncapi.yaml to serve the AsyncAPI documentation.

``` shell
faststream docs serve asyncapi.json

or

faststream docs serve asyncapi.yaml
```

After running the command, it should serve the AsyncAPI documentation on port 8000 and display the following logs in the terminal.

shell
INFO:     Started server process [2364992]
INFO:     Waiting for application startup.
INFO:     Application startup complete.
INFO:     Uvicorn running on http://localhost:8000 (Press CTRL+C to quit)

And you should be able to see the following page in your browser:

=== "Short"
    { loading=lazy }

=== "Expand"
    { loading=lazy }

!!! tip
    The command also offers options to serve the documentation on a different host and port.h}h     b/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/asyncapi/hosting.mdsuh(hhh}h}(hj5  hj6  usub$408d11e0-dc72-45d0-a770-18f4ea640224h
)}(h
}(hCustomize AsyncAPI Schema

setup custom FastStream app info

setup custom broker information

setup custom handler information

setup payload information via pydantic model

generate schema.json, customize manually and serve it insteadh}ha/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/asyncapi/custom.mdsuh(hhh}h}(hj?  hj@  usub$a7a78d9c-e95c-49a1-9c66-77377a03f1bch
)}(h
}(hX	  FastAPI Plugin

Handling messages

FastStream can be used as a part of FastAPI.

Just import a StreamRouter you need and declare the message handler in the same way as with a regular FastStream application.

{! includes/getting_started/integrations/fastapi/1.md !}

When processing a message from a broker, the entire message body is placed simultaneously in both the body and path request parameters. You can access them in any way convenient for you. The message header is placed in headers.

Also, this router can be fully used as an HttpRouter (of which it is the inheritor). So, you can
use it to declare any get, post, put and other HTTP methods. For example, this is done at line 19.

!!! warning
    If your ASGI server does not support installing state inside lifespan, you can disable this behavior as follows:

Accessing the Broker Object

Inside each router, there is a broker. You can easily access it if you need to send a message to MQ:

{! includes/getting_started/integrations/fastapi/2.md !}

You can use the following Depends to access the broker if you want to use it at different parts of your program:

{! includes/getting_started/integrations/fastapi/3.md !}

Or you can access the broker from a FastAPI application state:

```python
from fastapi import Request

@app.get("/")
def main(request: Request):
    broker = request.state.broker
```

@after_startup

The FastStream application has the #!python @after_startup hook, which allows you to perform operations with your message broker after the connection is established. This can be extremely convenient for managing your brokers' objects and/or sending messages. This hook is also available for your FastAPI StreamRouter

{! includes/getting_started/integrations/fastapi/4.md !}

Documentation

When using FastStream as a router for FastAPI, the framework automatically registers endpoints for hosting AsyncAPI documentation into your application with the following default values:

{! includes/getting_started/integrations/fastapi/5.md !}

This way, you will have three routes to interact with your application's AsyncAPI schema:

/asyncapi - the same as the CLI created page{.internal-link}

/asyncapi.json - download the JSON schema representation

/asyncapi.yaml - download the YAML schema representation

Testing

To test your FastAPI StreamRouter, you can still use it with the TestClient:

{! includes/getting_started/integrations/fastapi/6.md !}h}hl/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/integrations/fastapi/index.mdsuh(hhh}h}(hjI  hjJ  usub$e2e4f758-d6aa-4e70-a268-d2fcb315ee96h
)}(h
}(hXF  template variables

fastapi_plugin: If you want to use FastStream in conjunction with FastAPI, perhaps you should use a special plugin{.internal-link}
no_hook: However, even if such a hook is not provided, you can do it yourself.

INTEGRATIONS

FastStream brokers are very easy to integrate with any of your applications:
it is enough to initialize the broker at startup and close it correctly at the end of
your application.

Most HTTP frameworks have built-in lifecycle hooks for this.

{% import 'getting_started/integrations/http/1.md' as includes with context %}
{{ includes }}h}ho/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/integrations/frameworks/index.mdsuh(hhh}h}(hjS  hjT  usub$ca44aca1-9e99-433b-ae61-b472ed03a3ceh
)}(h
}(hX  Custom Decoder

At this stage, the body of a StreamMessage is transformed into the format that it will take when it enters your handler function. This stage is the one you will need to redefine more often.

Signature

The original decoder function has a relatively simple signature (this is a simplified version):

=== "Kafka"
    ``` python
    from faststream.types import DecodedMessage
    from faststream.kafka import KafkaMessage

=== "RabbitMQ"
    ``` python
    from faststream.types import DecodedMessage
    from faststream.rabbit import RabbitMessage

Alternatively, you can reuse the original decoder function with the following signature:

=== "Kafka"
    ``` python
    from types import Callable, Awaitable
    from faststream.types import DecodedMessage
    from faststream.kafka import KafkaMessage

=== "RabbitMQ"
    ``` python
    from types import Callable, Awaitable
    from faststream.types import DecodedMessage
    from faststream.rabbit import RabbitMessage

!!! note
    The original decoder is always an asynchronous function, so your custom decoder should also be asynchronous.

Afterward, you can set this custom decoder at the broker or subscriber level.

Example

You can find examples of Protobuf and Msgpack serialization in the next article{.internal-link}.h}hg/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/serialization/decoder.mdsuh(hhh}h}(hj]  hj^  usub$6a2e509a-7250-47d6-8874-4cc054f77705h
)}(h
}(hX3  Custom Parser

At this stage, FastStream serializes an incoming message from the broker's framework into a general format called StreamMessage. During this stage, the message body remains in the form of raw bytes.

StreamMessage is a general representation of a message within FastStream. It contains all the information required for message processing within FastStreams.  It is even used to represent message batches, so the primary reason to customize it is to redefine the metadata associated with FastStream messages.

For example, you can specify your own header with the message_id semantic. This allows you to inform FastStream about this custom header through parser customization.

Signature

To create a custom message parser, you should write a regular Python function (synchronous or asynchronous) with the following signature:

=== "Kafka"
    ``` python
    from aiokafka import ConsumerRecord
    from faststream.kafka import KafkaMessage

=== "RabbitMQ"
    ``` python
    from aio_pika import IncomingMessage
    from faststream.rabbit import RabbitMessage

Alternatively, you can reuse the original parser function with the following signature:

=== "Kafka"
    ``` python
    from types import Callable, Awaitable
    from aiokafka import ConsumerRecord
    from faststream.kafka import KafkaMessage

=== "RabbitMQ"
    ``` python
    from types import Callable, Awaitable
    from aio_pika import IncomingMessage
    from faststream.rabbit import RabbitMessage

The argument naming doesn't matter; the parser will always be placed as the second argument.

!!! note
    The original parser is always an asynchronous function, so your custom parser should also be asynchronous.

Afterward, you can set this custom parser at the broker or subscriber level.

Example

As an example, let's redefine message_id to a custom header:

=== "Kafka"
    python linenums="1" hl_lines="9-15 18 28"
    {!> docs_src/getting_started/serialization/parser_kafka.py !}

=== "RabbitMQ"
    python linenums="1" hl_lines="9-15 18 28"
    {!> docs_src/getting_started/serialization/parser_rabbit.py !}h}hf/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/serialization/parser.mdsuh(hhh}h}(hjg  hjh  usub$cab4ba75-fae4-470c-bcf1-4f6bb009a19ah
)}(h
}(hX  Custom Serialization

Serialization Steps

Before the message reaches your subscriber, FastStream applies two functions to it sequentially: parse_message and decode_message. You can modify one or both stages depending on your needs.

Message Parsing

At this stage, FastStream serializes an incoming message from the broker's framework into a general format called - StreamMessage. During this stage, the message body remains in the form of raw bytes.

!!! warning ""
    This stage is closely related to the features of the broker used, and in most cases, redefining it is not necessary.

The parser declared at the broker level will be applied to all subscribers. The parser declared at the subscriber level is applied only to that specific subscriber and overrides the `broker' parser if specified.

Message Decoding

At this stage, the body of the StreamMessage is transformed into a format suitable for processing within your subscriber function. This is the stage you may need to redefine more often.h}he/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/serialization/index.mdsuh(hhh}h}(hjq  hjr  usub$9892b106-e359-40f4-99fd-ac5a95a4f64ah
)}(h
}(hX  Serialization examples

Protobuf

In this section, we will explore an example using Protobuf. However, this approach is also applicable to other serialization methods.

???- note "Protobuf"
    Protobuf is an alternative message serialization method commonly used in GRPC.  Its main advantage is that it results in much smaller message sizes[^1] compared to JSON, but it requires a message schema (.proto files) on both the client and server sides.

To begin, install the necessary dependencies:

console
pip install grpcio-tools

Next, let's define the schema for our message:

```proto title="message.proto"
syntax = "proto3";

message Person {
    string name = 1;
    float age = 2;
}
```

Now, generate a Python class to work with messages in Protobuf format:

console
python -m grpc_tools.protoc --python_out=. --pyi_out=. -I . message.proto

This generates two files: message_pb2.py and message_pb2.pyi. We can use the generated class to serialize our messages:

``` python linenums="1" hl_lines="1 10-13 16 23"
from message_pb2 import Person

from faststream import FastStream, Logger, NoCast
from faststream.rabbit import RabbitBroker, RabbitMessage

broker = RabbitBroker()
app = FastStream(broker)

async def decode_message(msg: RabbitMessage) -> Person:
    decoded = Person()
    decoded.ParseFromString(msg.body)
    return decoded

@broker.subscriber("test", decoder=decode_message)
async def consume(body: NoCast[Person], logger: Logger):
    logger.info(body)

@app.after_startup
async def publish():
    body = Person(name="John", age=25).SerializeToString()
    await broker.publish(body, "test")
```

Note that we used the NoCast annotation to exclude the message from the pydantic representation of our handler.

python
async def consume(body: NoCast[Person], logger: Logger):

Msgpack

Msgpack is another alternative binary data format. Its main advantage is that it results in smaller message sizes[^2] compared to JSON, although slightly larger than Protobuf. The key advantage is that it doesn't require a message schema, making it easy to use in most cases.

To get started, install the necessary dependencies:

console
pip install msgpack

Since there is no need for a schema, you can easily write a Msgpack decoder:

``` python linenums="1" hl_lines="1 10-11 14 21"
import msgpack

from faststream import FastStream, Logger
from faststream.rabbit import RabbitBroker, RabbitMessage

broker = RabbitBroker()
app = FastStream(broker)

async def decode_message(msg: RabbitMessage):
    return msgpack.loads(msg.body)

@broker.subscriber("test", decoder=decode_message)
async def consume(body, logger: Logger):
    logger.info(body)

@app.after_startup
async def publish():
    body = msgpack.dumps({"name": "John", "age": 25}, use_bin_type=True)
    await broker.publish(body, "test")
```

Using Msgpack is much simpler than using Protobuf schemas. Therefore, if you don't have strict message size limitations, you can use Msgpack serialization in most cases.

Tips

Data Compression

If you are dealing with very large messages, consider compressing them as well. You can explore libraries such as lz4{.external-link targer="_blank"} or zstd{.external-link targer="_blank"} for compression algorithms.

Compression can significantly reduce message size, especially if there are repeated blocks. However, in the case of small message bodies, data compression may increase the message size. Therefore, you should assess the compression impact based on your specific application requirements.

Broker-Level Serialization

You can still set a custom decoder at the Broker or Router level. However, if you want to automatically encode publishing messages as well, you should explore Middleware{.internal-link} for serialization implimentation.

[^1]:
    For example, a message like #!json { "name": "John", "age": 25 } in JSON takes 27 bytes, while in Protobuf, it takes only 11 bytes. With lists and more complex structures, the savings can be even more significant (up to 20x times).

[^2]:
    A message with Msgpack serialization, such as #!json { "name": "John", "age": 25 }, takes 16 bytes.h}hh/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/serialization/examples.mdsuh(hhh}h}(hj{  hj|  usub$02b5f6b4-15cc-44e0-b2f6-91e504d17606h
)}(h
}(hX  Settings and Environment Variables

In many cases, your application may require external settings or configurations, such as a broker connection or database credentials.

To manage these settings effectively, it's common to provide them through environment variables that can be read by the application.

Pydantic Settings

Fortunately, Pydantic  provides a useful utility for handling settings coming from environment variables with Pydantic: Settings management{.external-link target="_blank"}.

Install pydantic-settings

First, install the pydantic-settings package:

console
pip install pydantic-settings

!!! info
    In Pydantic v1, this functionality was included with the main package. Now it is distributed as an independent package so that you can choose not to install it if you don't need that functionality.

Create the Settings Object

Import BaseSettings from Pydantic and create a subclass, similar to what you would do with a Pydantic model.

Just like with Pydantic models, you declare class attributes with type annotations and can use all the same validation features and tools, including different data types and additional validations with Field().

=== "Pydantic v2"
    ```python linenums='1' hl_lines="1 4" title="config.py"
from pydantic_settings import BaseSettings

class Settings(BaseSettings):
    url: str = ""
    queue: str = "test-queue"

settings = Settings()
    ```

=== "Pydantic v1"
    !!! info
        In Pydantic v1 you would import BaseSettings directly from pydantic instead of from pydantic_settings.

from pydantic import BaseSettings

class Settings(BaseSettings):
    url: str = ""
    queue: str = "test-queue"

settings = Settings()
    ```

When you create an instance of that Settings class (in this case, in the settings object), Pydantic will read the environment variables in a case-insensitive way. For example, an upper-case variable APP_NAME will still be read for the attribute app_name.

It will also convert and validate the data, so when you use that settings object, you will have data of the type you declared (e.g. items_per_user will be an int).

Using the settings

Now you can use the new settings object in your application:

```python linenums='1' hl_lines="3 9 14" title="serve.py"
import os

from pydantic_settings import BaseSettings

from faststream import FastStream
from faststream.rabbit import RabbitBroker

class Settings(BaseSettings):
    url: str
    queue: str = "test-queue"

settings = Settings(_env_file=os.getenv("ENV", ".env"))

broker = RabbitBroker(settings.url)
app = FastStream(broker)

@broker.subscriber(settings.queue)
async def handler(msg):
    ...
```

Running the Application

You can run the application while passing the configuration parameters as environment variables. For example, you could set an URL:

console
URL="amqp://guest:guest@localhost:5672" faststream run serve:app

!!! tip
    To set multiple environment variables for a single command, separate them with spaces and put them all before the command.

Reading a .env File

If you have many settings that may change frequently, especially in different environments, it might be useful to store them in a file and then read them as if they were environment variables.

This practice is common enough that it has a name; these environment variables are typically placed in a file named .env, commonly referred to as a "dotenv" file.

!!! tip
    In Unix-like systems like Linux and macOS, a file starting with a dot (.) is considered a hidden file.

Pydantic supports reading from these types of files using an external library. You can learn more at Pydantic Settings: Dotenv (.env) support{.external-link target="_blank"}.

!!! tip
    To use this feature, you need to install the python-dotenv library.

The .env File

You can create a .env file with contents like this:

bash
URL="amqp://guest:guest@localhost:5672"
QUEUE="test-queue"

Reading Settings from .env

Then update your config.py as follows:

```python linenums='1' hl_lines="1 11"
import os

from pydantic_settings import BaseSettings

class Settings(BaseSettings):
    url: str
    queue: str = "test-queue"

settings = Settings(_env_file=os.getenv("ENV", ".env"))
```

This way, you can specify different .env files directly from your terminal, which can be extremely helpful for various testing and production scenarios.

!!! note
    By default, Pydantic will attempt to find a .env file. If it's not present, Pydantic will use the default field values.

Choosing the .env File at Startup

Now you can run the apllication with different .env files like so:

console
ENV=.local.env faststream run serve:app

Or, for a production environment:

console
ENV=.production.env faststream run serve:app

Or even for a test environment:

console
ENV=.test.env pytesth}h^/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/config/index.mdsuh(hhh}h}(hj  hj  usub$b06d7034-78a2-476e-968c-ceeefd17504ch
)}(h
}(hXX
  Middlewares

Middlewares are a powerful mechanism that allows you to add additional logic to any stage of the message processing pipeline.

This way, you can greatly extend your FastStream application with features such as:

Integration with any logging/metrics systems

Application-level message serialization logic

Rich publishing of messages with extra information

And many other capabilities

Middlewares have several methods to override. You can implement some or all of them and use middlewares at the broker, router, or subscriber level. Thus, middlewares are the most flexible  FastStream feature.

Message Receive Wrapper

Unfortunately, this powerful feature has a somewhat complex signature too.

Using middlewares, you can wrap the entire message processing pipeline. In this case, you need to specify on_receive and after_processed methods:

``` python
from faststream import BaseMiddleware

class MyMiddleware(BaseMiddleware):
    async def on_receive(self):
        print(f"Received: {self.message}")
        return await super().on_receive()

```

These methods should be overwritten only in a broker-level middlewares.

python
Broker(middlewares=[MyMiddleware])

In other cases, on_receive will be called at every subscriber filter function call.

!!! tip
    Please always call #!python super() methods at the end of your function; this is important for correct error processing.

Message Consuming Wrapper

Also, using middlewares, you are able to wrap consumer function calls directly.

In this case, you need to specify on_receive and after_processed methods:

``` python
from typing import Optional

from faststream import BaseMiddleware:
from faststream.types import DecodedMessage

class MyMiddleware(BaseMiddleware):
    async def on_consume(self, msg: DecodedMessage) -> DecodedMessage:
        return await super().on_consume(msg)

```

This way, you can patch the incoming message body right before passing it to your consumer subscriber.

Also, if you have multiple filters for one subscriber, these methods will be called at once when the filtering is completed successfully.

Message Publishing Wrapper

Finally, using middlewares, you are able to patch outgoing messages too. For example, you can compress/encode outgoing messages at the application level.

In this, case you need to specify on_publish and after_publish methods:

``` python
from typing import Optional

from faststream import BaseMiddleware:
from faststream.types import SendableMessage

class MyMiddleware(BaseMiddleware):
    async def on_publish(self, msg: SendableMessage) -> SendableMessage:
        return await super().on_publish(msg)

```h}hc/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/middlewares/index.mdsuh(hhh}h}(hj  hj  usub$7a526183-6804-4060-9720-8848e38b7007h
)}(h
}(hX  Publisher Object

The Publisher Object provides a full-featured way to publish messages. It has AsyncAPI representation and includes testable features. This method creates a reusable Publisher object.

It can be used as a function decorator. The order of Subscriber and Publisher decorators doesn't matter, but they can only be used with functions decorated by a subscriber decorator.

It also uses the handler function's return type annotation to cast the function's return value before sending, so be accurate with it:

=== "Kafka"
    python linenums="1"
    {!> docs_src/getting_started/publishing/object_kafka.py !}

=== "RabbitMQ"
    python linenums="1"
    {!> docs_src/getting_started/publishing/object_rabbit.py !}

You can use it multiple times with one function to broadcast the function's return:

python
@publisher1
@publisher2
@broker.subscriber("in")
async def handle(msg) -> str:
    return "Response"

Additionally, it automatically sends a message with the same correlation_id as the incoming message. This way, you get the same correlation_id for the entire message pipeline process across all services, allowing you to collect a trace.h}hc/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/publishing/object.mdsuh(hhh}h}(hj  hj  usub$9d5d5789-f2d0-4805-b5e4-4f8423eeb3e5h
)}(h
}(hX  Publisher Decorator

The second easiest way to publish messages is by using the Publisher Decorator. This method has an AsyncAPI representation and is suitable for quickly creating applications. However, it doesn't provide all testing features.

It creates a structured DataPipeline unit with an input and output. The order of Subscriber and Publisher decorators doesn't matter, but they can only be used with functions decorated by a subscriber as well.

It uses the handler function's return type annotation to cast the function's return value before sending, so be accurate with it:

=== "Kafka"
    python linenums="1"
    {!> docs_src/getting_started/publishing/decorator_kafka.py !}

=== "RabbitMQ"
    python linenums="1"
    {!> docs_src/getting_started/publishing/decorator_rabbit.py !}

It can be used multiple times with one function to broadcast the function's return:

python
@broker.subscriber("in")
@broker.publisher("first-out")
@broker.publisher("second-out")
async def handle(msg) -> str:
    return "Response"

Additionally, it automatically sends a message with the same correlation_id as the incoming message. This way, you get the same correlation_id for the entire message pipeline process across all services, allowing you to collect a trace.h}hf/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/publishing/decorator.mdsuh(hhh}h}(hj  hj  usub$592bfab8-a7a6-4f3a-9b16-d8195f9372a6h
)}(h
}(hX  Publisher Direct Usage

The Publisher Direct Usage is a full-featured way to publish messages. It has AsyncAPI representation and includes testable features. This method creates a reusable Publisher object that can be used directly to publish a message:

=== "Kafka"
    python linenums="1"
    {!> docs_src/getting_started/publishing/direct_kafka.py !}

=== "RabbitMQ"
    python linenums="1"
    {!> docs_src/getting_started/publishing/direct_rabbit.py !}

It is suitable for publishing different messages to different outputs within the same processing function:

python
@broker.subscriber("in")
async def handle(msg) -> str:
    await publisher1.publish("Response-1")
    await publisher2.publish("Response-2")h}hc/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/publishing/direct.mdsuh(hhh}h}(hj  hj  usub$4f508acd-5254-4872-84b0-5f68157e587ah
)}(h
}(hXJ  Publishing Basics

FastStream is broker-agnostic and easy to use, even as a client in non-FastStream applications.

It offers several use cases for publishing messages:

Using `broker.publish``

Using a decorator

Using a publisher object decorator

Using a publisher object directly

FastStream allows you to publish any JSON-serializable messages (Python types, Pydantic models, etc.) or raw bytes.

It automatically sets up all required headers, especially the correlation_id, which is used to trace message processing pipelines across all services.

To publish a message, simply set up the message content and a routing key:

=== "Kafka"
    python
    async with KafkaBroker() as br:
        await br.publish("message", "topic")

=== "RabbitMQ"
    python
    async with RabbitBroker() as br:
        await br.publish("message", "queue")h}hb/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/publishing/index.mdsuh(hhh}h}(hj  hj  usub$ebaa384e-eb91-469e-a01b-cdfe0c86f9c0h
)}(h
}(hX  Broker Publishing

The easiest way to publish a message is to use a Broker, which allows you to use it as a publisher client in any applications.

In the FastStream project, this call is not represented in the AsyncAPI scheme. You can use it to send rarely-publishing messages, such as startup or shutdown events.

=== "Kafka"
    python linenums="1"
    {!> docs_src/getting_started/publishing/broker_kafka.py !}

=== "RabbitMQ"
    python linenums="1"
    {!> docs_src/getting_started/publishing/broker_rabbit.py !}h}hc/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/publishing/broker.mdsuh(hhh}h}(hj  hj  usub$518f5993-32ea-4bf6-840c-032da4adf0d1h
)}(h
}(hXt  Publisher Testing

If you are working with a Publisher object (either decorator or direct), you can check outgoing messages as well. There are several testing features available:

In-memory TestClient

Publishing (including error handling)

Checking the incoming message body

Note about mock clearing after the context exits

Base application

=== "Decorator"
=== "Kafka"
    python linenums="1"
    {!> docs_src/getting_started/publishing/object_kafka.py[ln:7-12] !}

=== "RabbitMQ"
    python linenums="1"
    {!> docs_src/getting_started/publishing/object_rabbit.py[ln:7-12] !}

=== "Direct"
=== "Kafka"
    python linenums="1"
    {!> docs_src/getting_started/publishing/direct_kafka.py[ln:7-11] !}

=== "RabbitMQ"
    python linenums="1"
    {!> docs_src/getting_started/publishing/direct_rabbit.py[ln:7-11] !}

Testing

=== "Kafka"
    python linenums="1"
    {!> docs_src/getting_started/publishing/object_kafka_testing.py [ln:1-3,7-12] !}

=== "RabbitMQ"
    python linenums="1"
    {!> docs_src/getting_started/publishing/object_rabbit_testing.py [ln:1-3,7-12] !}

Testing with a real broker

Waiting for the consumer to be calledh}ha/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/publishing/test.mdsuh(hhh}h}(hj  hj  usub$54334f90-073b-4c2a-b13b-791b7c2a6d6ch
)}(h
}(hX  template variables

note_decor: Now you can use the created router to register handlers and publishers as if it were a regular broker
note_include: Then you can simply include all the handlers declared using the router in your broker
note_publish: Please note that when publishing a message, you now need to specify the same prefix that you used when creating the router

Broker Router

Sometimes you want to:

split an application into includable modules

separate business logic from your handler registration

apply some decoder/middleware/dependencies to a subscribers group

For these reasons, FastStream has a special Broker Router.

Router Usage

First, you need to import the Broker Router from the same module from where you imported the broker.

!!! note ""
    When creating a Broker Router, you can specify a prefix that will be automatically applied to all subscribers and publishers of this router.

{% import 'getting_started/routers/1.md' as includes with context %}
{{ includes }}

!!! tip
    Also, when creating a Broker Router, you can specify middleware, dependencies, parser and decoder to apply them to all subscribers declared via this router.

Delay Handler Registration

If you want to separate your application's core logic from FastStream's routing logic, you can write some core functions and use them as Broker Router handlers later:

=== "Kafka"
    python linenums="1" hl_lines="2 8 13 15"
    {!> docs_src/getting_started/routers/router_delay_kafka.py [ln:1-15] !}

=== "RabbitMQ"
    python linenums="1" hl_lines="2 8 13 15"
    {!> docs_src/getting_started/routers/router_delay_rabbit.py [ln:1-15] !}

!!! warning
    Be careful, this way you won't be able to test your handlers with a mock object.h}h_/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/routers/index.mdsuh(hhh}h}(hj  hj  usub$4470d596-0b8b-4a84-b1f2-4dd3860b9fc3h
)}(h
}(hX
  Development

After cloning the project, you'll need to set up the development environment. Here are the guidelines on how to do this.

Virtual Environment with venv

Create a virtual environment in a directory using Python's venv module:

bash
python -m venv venv

That will create a ./venv/ directory with Python binaries, allowing you to install packages in an isolated environment.

Activate the Environment

Activate the new environment with:

bash
source ./venv/bin/activate

Ensure you have the latest pip version in your virtual environment:

bash
python -m pip install --upgrade pip

Installing Dependencies

After activating the virtual environment as described above, run:

bash
pip install -e ".[dev]"

This will install all the dependencies and your local FastStream in your virtual environment.

Using Your local FastStream

If you create a Python file that imports and uses FastStream, and run it with the Python from your local environment, it will use your local FastStream source code.

Whenever you update your local FastStream source code, it will automatically use the latest version when you run your Python file again. This is because it is installed with -e.

This way, you don't have to "install" your local version to be able to test every change.

To use your local FastStream CLI, type:

bash
python -m faststream ...

Running Tests

Pytest

To run tests with your current FastStream application and Python environment, use:

```bash
pytest tests

or

./scripts/test.sh

with coverage output

./scripts/test-cov.sh
```

In your project, you'll find some pytest marks:

slow

rabbit

kafka

all

By default, running pytest will execute "not slow" tests.

To run all tests use:

bash
pytest -m 'all'

If you don't have a local RabbitMQ or Kafka instance running, you can run tests without those dependencies:

bash
pytest -m 'not rabbit and not kafka'

To run tests based on RabbitMQ, Kafka, or other dependencies, the following dependencies are needed to be started as docker containers:

yaml
version: "3"
services:
  # nosemgrep: yaml.docker-compose.security.writable-filesystem-service.writable-filesystem-service
  rabbitmq:
    image: rabbitmq:alpine
    ports:
      - "5672:5672"
    # https://semgrep.dev/r?q=yaml.docker-compose.security.no-new-privileges.no-new-privileges
    security_opt:
      - no-new-privileges:true
  # nosemgrep: yaml.docker-compose.security.writable-filesystem-service.writable-filesystem-service
  kafka:
    image: bitnami/kafka:3.5.0
    ports:
      - "9092:9092"
    environment:
      KAFKA_ENABLE_KRAFT: "true"
      KAFKA_CFG_NODE_ID: "1"
      KAFKA_CFG_PROCESS_ROLES: "broker,controller"
      KAFKA_CFG_CONTROLLER_LISTENER_NAMES: "CONTROLLER"
      KAFKA_CFG_LISTENERS: "PLAINTEXT://:9092,CONTROLLER://:9093"
      KAFKA_CFG_LISTENER_SECURITY_PROTOCOL_MAP: "CONTROLLER:PLAINTEXT,PLAINTEXT:PLAINTEXT"
      KAFKA_CFG_ADVERTISED_LISTENERS: "PLAINTEXT://127.0.0.1:9092"
      KAFKA_BROKER_ID: "1"
      KAFKA_CFG_CONTROLLER_QUORUM_VOTERS: "1@kafka:9093"
      ALLOW_PLAINTEXT_LISTENER: "true"
    # https://semgrep.dev/r?q=yaml.docker-compose.security.no-new-privileges.no-new-privileges
    security_opt:
      - no-new-privileges:true

You can start the dependencies easily using provided script by running:

bash
./scripts/start_test_env.sh

Once you are done with development and running tests, you can stop the dependencies' docker containers by running:

bash
./scripts/stop_test_env.shh}hk/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/contributing/CONTRIBUTING.mdsuh(hhh}h}(hj  hj  usub$ec950329-550a-40b3-847d-70ce61c68d30h
)}(h
}(hX  Documentation

How to help

You will be of invaluable help if you contribute to the documentation.

Such a contribution can be:

Indications of inaccuracies, errors, typos

Suggestions for editing specific sections

Making additions

You can report all this in discussions{.external-link targer="_blank"} on GitHub, start issue{.external-link targer="_blank"}, or write about it in our discord{.external-link targer="_blank"} group.

!!! note
    Special thanks to those who are ready to offer help with the case and help in developing documentation, as well as translating it into other languages.

How to get started

To develop the documentation, you don't even need to install the entire FastStream project as a whole.

Enough:

Clone the project repository

Create a virtual environment
    bash
    python -m venv venv

Activate it
    bash
    source venv/bin/activate

Install documentation dependencies
    bash
    pip install ".[devdocs]"

Go to the docs/ directory

Start the local documentation server
    bash
    mkdocs serve

Now all changes in the documentation files will be reflected on your local version of the site.
After making all the changes, you can issue a PR with them - and we will gladly accept it!h}hc/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/contributing/docs.mdsuh(hhh}h}(hj  hj  usub$7a926bb8-a9ae-4614-986e-2c5e89efdca1h
)}(h
}(hX  Lifespan Events

Sometimes you need to define the logic that should be executed before launching the application.
This means that the code will be executed once - even before your application starts receiving messages.

Also, you may need to terminate some processes after stopping the application. In this case, your code will also be executed exactly once:
but after the completion of the main application.

Since this code is executed before the application starts and after it stops, it covers the entire lifecycle (lifespan) of the application.

This can be very useful for initializing your application settings at startup, raising a pool of connections to a database, or running machine learning models.h}h`/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/lifespan/index.mdsuh(hhh}h}(hj  hj  usub$d8db5814-0428-4108-ae79-86f3972ded08h
)}(h
}(hX  Events Testing

In the most cases you are testing your subsriber/publisher functions, but sometimes you need to trigger some lifespan hooks in your tests too.

For this reason, FastStream has a special TestApp patcher working as a regular async context manager.

{! includes/getting_started/lifespan/testing.md !}

!!! tip
    If you are using a connected broker inside withing your lifespan hooks, it's advisable to patch the broker first (before applying the application patch).h}h_/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/lifespan/test.mdsuh(hhh}h}(hj  hj  usub$d9cff32c-0b57-47e6-badb-6938562245b9h
)}(h
}(hXu  Lifespan Hooks

Usage example

Let's imagine that your application uses pydantic as your settings manager.

!!! note ""
    I highly recommend using pydantic for these purposes, because this dependency is already used at FastStream
    and you don't have to install an additional package

Also, let's imagine that you have several .env, .env.development, .env.test, .env.production files with your application settings,
and you want to switch them at startup without any code changes.

By passing optional arguments with the command line{.internal-link} to your code FastStream allows you to do this easily.

Lifespan

Let's write some code for our example

{! includes/getting_started/lifespan/1.md !}

Now this application can be run using the following command to manage the environment:

bash
faststream run serve:app --env .env.test

Details

Now let's look into a little more detail

To begin with, we used a decorator

{! includes/getting_started/lifespan/2.md !}

to declare a function that should run when our application starts

The next step is to declare the arguments that our function will receive

{! includes/getting_started/lifespan/3.md !}

In this case, the env field will be passed to the setup function from the arguments with the command line

!!! tip
    The default lifecycle functions are used with the decorator #!python @apply_types,
    therefore, all context fields{.internal-link} and dependencies{.internal-link} are available in them

Then, we initialized the settings of our application using the file passed to us from the command line

{! includes/getting_started/lifespan/4.md !}

And put these settings in a global context

{! includes/getting_started/lifespan/5.md !}

??? note
    Now we can access our settings anywhere in the application right from the context

The last step we initialized our broker: now, when the application starts, it will be ready to receive messages

{! includes/getting_started/lifespan/6.md !}

Another example

Now let's imagine that we have a machine learning model that needs to process messages from some broker.

Initialization of such models usually takes a long time. It would be wise to do this at the start of the application, and not when processing each message.

You can initialize your model somewhere at the top of your module/file. However, in this case, this code will be run even just in case of importing
this module, for example, during testing. It is unlikely that you want to run your model on every test run...

Therefore, it is worth initializing the model in the #!python @app.on_startup hook.

Also, we don't want the model to finish its work incorrectly when the application is stopped. To avoid this, we need the hook #!python @app.on_shutdown

{! includes/getting_started/lifespan/7.md !}

Multiple hooks

If you want to declare multiple lifecycle hooks, they will be used in the order they are registered:

```python linenums="1" hl_lines="6 11"
from faststream import Context, ContextRepo, FastStream

app = FastStream()

@app.on_startup
async def setup(context: ContextRepo):
    context.set_global("field", 1)

@app.on_startup
async def setup_later(field: int = Context()):
    assert field == 1
```

Some more details

Async or not async

In the asynchronous version of the application, both asynchronous and synchronous methods can be used as hooks.
In the synchronous version, only synchronous methods are available.

Command line arguments

Command line arguments are available in all #!python @app.on_startup hooks. To use them in other parts of the application, put them in the ContextRepo.

Broker initialization

The #!python @app.on_startup hooks are called BEFORE the broker is launched by the application. The #!python @app.after_shutdown hooks are triggered AFTER stopping the broker.

If you want to perform some actions AFTER initializing the broker: send messages, initialize objects, etc., you should use the #!python @app.after_startup hook.h}h`/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/getting-started/lifespan/hooks.mdsuh(hhh}h}(hj  hj  usub$643c5e63-9976-43f9-a512-66a7394dd3d4h
)}(h
}(hXI  Consuming Acknowledgements

As you may know, RabbitMQ employs a rather extensive Acknowledgement{.external-link target="_blank"} policy.

In most cases, FastStream automatically acknowledges (acks) messages on your behalf. When your function executes correctly, including sending all responses, a message will be acknowledged (and rejected in case of an exception).

However, there are situations where you might want to use a different acknowledgement logic.

Retries

If you prefer to use a nack instead of a reject when there's an error in message processing, you can specify the retry flag in the #!python  @broker.subscriber(...) method, which is responsible for error handling logic.

By default, this flag is set to False, indicating that if an error occurs during message processing, the message can still be retrieved from the queue:

python
@broker.subscriber("test", retry=False) # don't handle exceptions
async def base_handler(body: str):
    ...

If this flag is set to True, the message will be nacked and placed back in the queue each time an error occurs. In this scenario, the message can be processed by another consumer (if there are several of them) or by the same one:

python
@broker.subscriber("test", retry=True)  # try again indefinitely
async def base_handler(body: str):
    ...

If the retry flag is set to an int, the message will be placed back in the queue, and the number of retries will be limited to this number:

python
@broker.subscriber("test", retry=3)     # make up to 3 attempts
async def base_handler(body: str):
    ...

!!! bug
    At the moment, attempts are counted only by the current consumer. If the message goes to another consumer, it will have its own counter.
    Subsequently, this logic will be reworked.

!!! tip
    For more complex error handling cases, you can use tenacity{.external-link target="_blank"}

Manual acknowledgement

If you want to acknowledge a message manually, you can get access directy to the message object via the Context{.internal-link} and call the method.

```python
from faststream.rabbit import RabbitMessage

@broker.subscriber("test")
async def base_handler(body: str, msg: RabbitMessage):
    await msg.ack()
    # or
    await msg.nack()
    # or
    await msg.reject()
```

FastStream will see that the message was already acknowledged and will do nothing at process end.

Interrupt Process

If you want to interrupt message processing at any call stack, you can raise faststream.exceptions.AckMessage

``` python linenums="1" hl_lines="16"
from faststream import FastStream
from faststream.exceptions import AckMessage
from faststream.rabbit import RabbitBroker

broker = RabbitBroker("amqp://guest:guest@localhost:5672/")
app = FastStream(broker)

@broker.subscriber("test-queue")
async def handle(body):
    smth_processing(body)

def smth_processing(body):
    if True:
        raise AckMessage()

@app.after_startup
async def test_publishing():
    await broker.publish("Hello!", "test-queue")
```

This way, FastStream interrupts the current message proccessing and acknowledges it immediately. Also, you can raise NackMessage and RejectMessage too.h}hL/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/rabbit/ack.mdsuh(hhh}h}(hj  hj  usub$4f5cf536-eb89-41de-9fbb-14aa249cb939h
)}(h
}(hX]  Publishing

FastStream RabbitBroker supports all regular publishing usecases{.internal-link}. you can use them without any changes.

However, if you wish to further customize the publishing logic further, you should take a more deep-dive look at specific RabbitBroker parameters.

Rabbit Publishing

RabbitBroker also uses the unified publish method (from a publisher object) to send messages.

However, in this case, an object of the aio_pika.Message class (if necessary) can be used as a message (in addition to python primitives and pydantic.BaseModel).

You can specify queue (used as a routing_key) and exchange (optionally) to send by their name.

``` python
import asyncio
from faststream.rabbit import RabbitBroker

async def pub():
    async with RabbitBroker() as broker:
        await broker.publish(
            "Hi!",
            queue="test",
            exchange="test"
        )

asyncio.run(pub())
```

If you don't specify any exchange, the message will be send to the default one.

Also, you are able to use special RabbitQueue and RabbitExchange objects as queue and exchange arguments:

``` python
from faststream.rabbit import RabbitExchange, RabbitQueue

await broker.publish(
    "Hi!",
    queue=RabbitQueue("test"),
    exchange=RabbitExchange("test")
)
```

If you specify exchange that doesn't exist, RabbitBroker will create a required one and then publish a message to it.

!!! tip
    Be accurate with it: if you have already created an Exchange with specific parameters and try to send a message by exchange name to it, the broker will try to create it. So, Exchange parameters conflict will occur.

Basic Arguments

The publish method takes the following arguments:

#!python message = "" - message to send

#!python exchange: str | RabbitExchange | None = None - the exchange where the message will be sent to. If not specified - default is used

#!python queue: str | RabbitQueue = "" - the queue where the message will be sent (since most queues use their name as the routing key, this is a human-readable version of routing_key)

#!python routing_key: str = "" - also a message routing key, if not specified, the queue argument will be used

Message Parameters

You can read more about all the available flags in the RabbitMQ documentation{.external-link target="_blank"}

#!python headers: dict[str, Any] | None = None - message headers (used by consumers)

#!python content_type: str | None = None - the content_type of the message being sent (set automatically, used by consumers)

#!python content_encoding: str | None = None - encoding of the message (used by consumers)

#!python persist: bool = False - restore messages on RabbitMQ reboot

#!python priority: int | None = None - the priority of the message

#!python correlation_id: str | None = None - message id, which helps to match the original message with the reply to it (generated automatically)

#!python message_id: str | None = None - message ID (generated automatically)

#!python timestamp: int | float | time delta | datetime | None = None - message sending time (set automatically)

#!python expiration: int | float | time delta | datetime | None = None - message lifetime (in seconds)

#!python type: str | None = None - the type of message (used by consumers)

#!python user_id: str | None = None - ID of the RabbitMQ user who sent the message

#!python app_id: str | None = None - ID of the application that sent the message (used by consumers)

Send Flags

Arguments for sending a message:

#!python mandatory: bool = True - the client is waiting for confirmation that the message will be placed in some queue (if there are no queues, return it to the sender)

#!python immediate: bool = False - the client expects that there is a consumer ready to take the message to work "right now" (if there is no consumer, return it to the sender)

#!python timeout: int | float | None = None - send confirmation time from RabbitMQh}hS/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/rabbit/publishing.mdsuh(hhh}h}(hj  hj  usub$064c3166-8153-4455-abdc-601c185738adh
)}(h
}(hX  Rabbit Routing

Advantages

The advantage of RabbitMQ is the ability to configure flexible and complex message routing scenarios.

RabbitMQ covers the whole range of routing: from one queue - one consumer, to a queue retrieved from several sources, including message prioritization.

!!! note
      For more information about RabbitMQ, please visit the official documentation{.external-link target="_blank"}

It supports the ability to successfully process messages, mark them as processed with an error, remove them from the queue (it is also impossible to re-receive processed messages, unlike Kafka), lock it for the processing duration, and monitor its current status.

Having to keep track of the current status of all messages is a cause of the RabbitMQ performance issues. With really large message volumes, RabbitMQ starts to degrade. However, if this was a "one-time influx", then consumers will free the queue of messages and the "health" of RabbitMQ will be stable.

If your scenario is not based on processing millions of messages and also requires building complex routing logic, RabbitMQ will be the right choice.

Basic Concepts

If you want to totally understand how RabbitMQ works, you should visit their official website. There you will find top-level comments about the basic concepts and usage examples.

Entities

RabbitMQ works with three main entities:

Exchange - the point of receiving messages from publisher

Queue - the point of pushing messages to consumer

Binding - the relationship between queue-exchange or exchange-exchange

Routing Rules

The rules for delivering messages to consumers depend on the type of exchange and binding parameters. All the main options will be discussed at examples{.internal-link}.

In general, the message path looks so:

Publisher sends a message to exchange, specify its routing_key and headers according to which routing will take place.

Exchange, depending on the message parameters, determines which of the subscribed bindings to send the message to.

Binding delivers the message to queue or another exchange (in this case it will send it further by its own rules).

Queue, after receiving a message, sends it to one of subscribed consumers (PUSH API).

At this stage, the message gets into your application - and you start processing it.

Message Statuses

RabbitMQ requires confirmation of message processing: only after that, it will be removed from the queue.

Confirmation can be either positive (Acknowledgment - ack) if the message was successfully processed or negative (Negative Acknowledgment - nack) if the message was processed with an error.

At the same time, in case of an error, the message can also be extracted from the queue (reject); otherwise, after a negative confirmation, it will be requeued for processing again.

In most cases, FastStream performs all the necessary actions by itself. However, if you want to manage the message lifecycle directly, you can access the message object itself and call the appropriate methods directly. This can be useful if you want to implement an "at most once" policy and you need to confirm the consuming of the message before it is actually processed.

FastStream Specific

FastStream omits the ability to create bindings directly, since in most cases, you do not need to subscribe one queue to several exchanges or subscribe exchanges to each other. On the contrary, this practice leads to over-complication of the message routing scheme, which makes it difficult to maintain and further develop the entire infrastructure of services.

FastStream suggests you adhere to the scheme exchange:queue as 1:N, which will greatly simplify the scheme of interaction between your services. It is better to create an additional queue for a new exchange than to subscribe to an existing one.h}hN/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/rabbit/index.mdsuh(hhh}h}(hj%  hj&  usub$505744f8-ea02-4fe6-b486-31660aa5120ah
)}(h
}(hX  RabbitMQ Queue/Exchange Declaration

FastStream declares and validates all exchanges and queues using publishers and subscribers RabbitMQ objects, but sometimes you need to declare them manually.

RabbitBroker provides a way to achieve this easily.

``` python linenums="1" hl_lines="15-20 22-27"
from faststream import FastStream
from faststream.rabbit import (
    ExchangeType,
    RabbitBroker,
    RabbitExchange,
    RabbitQueue,
)

broker = RabbitBroker()
app = FastStream(broker)

@app.after_startup
async def declare_smth():
    await broker.declare_exchange(
        RabbitExchange(
            name="some-exchange",
            type=ExchangeType.FANOUT,
        )
    )

```

These methods require just one argument (RabbitQueue/RabbitExchange) containing information about your RabbitMQ required objects. They declare/validate RabbitMQ objects and return low-level aio-pika robust objects to interact with.

!!! tip
    Also, these methods are idempotent, so you can call them with the same arguments multiple times, but the objects will be created once; next time the method will return an already stored object. This way you can get access to any queue/exchange created automatically.h}hP/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/rabbit/declare.mdsuh(hhh}h}(hj/  hj0  usub$2dd316cf-b66b-4ed6-99e9-801d002725f9h
)}(h
}(hX  RPC over RMQ

Blocking Request

FastStream provides you with the ability to send a blocking RPC request over RabbitMQ in a very simple way.

It uses the Direct Reply-To{.external-link target="_blank"} RabbitMQ feature, so you don't need to create any queues to consume a response.

Just send a message like a regular one and get a response synchronously.

It is very close to common requests syntax:

python hl_lines="1 4"
msg = await broker.publish(
    "Hi!",
    queue="test",
    rpc=True,
)

Also, you have two extra options to control this behavior:

#!python rpc_timeout: Optional[float] = 30.0 - controls how long you are waiting for a response

#!python raise_timeout: bool = False - by default, a timeout request returns None, but if you need to raise a TimeoutException directly, you can specify this option

Reply-To

Also, if you want to create a permanent request-reply data flow, probably, you should create a permanent queue to consume responses.

So, if you have such one, you can specify it with the reply_to argument. This way, FastStream will send a response to this queue automatically.

``` python hl_lines="1 8"
@broker.subscriber("response-queue")
async def consume_responses(msg):
    ...

msg = await broker.publish(
    "Hi!",
    queue="test",
    reply_to="response-queue",
)
```h}hL/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/rabbit/rpc.mdsuh(hhh}h}(hj9  hj:  usub$1faabc4f-4a78-4e5f-af81-5f5019ba5939h
)}(h
}(hXY	  Access to Message Information

As you know, FastStream serializes a message body and provides you access to it through function arguments. But sometimes you want access to a message_id, headers, or other meta-information.

Message Access

You can get it in a simple way: just acces to the message object in the Context{.internal-link}!

It is a FastStream wrapper around a native broker library message (aio_pika.IncomingMessage in the RabbitMQ case). It contains the required information such as:

#!python body: bytes

#!python decoded_body: Any

#!python content_type: str

#!python reply_to: str

#!python headers: dict[str, Any]

#!python message_id: str

#!python correlation_id: str

```python hl_lines="1 6"
from faststream.rabbit import RabbitMessage

@broker.subscriber("test")
async def base_handler(
    body: str,
    msg: RabbitMessage,
):
    print(msg.correlation_id)
```

Also, if you can't find the information you reqiure, you can get access directly to the wrapped aio_pika.IncomingMessage, which contains complete message information.

```python hl_lines="6"
from aio_pika import IncomingMessage
from faststream.rabbit import RabbitMessage

@broker.subscriber("test")
async def base_handler(body: str, msg: RabbitMessage):
    raw: IncomingMessage = msg.raw_message
    print(raw)
```

Message Fields Access

But in the most cases, you don't need all message fields; you need to access some of them. You can use Context Fields access{.internal-link} feature for this reason.

For example, you can get access to the correlation_id like this:

```python hl_lines="6"
from faststream import Context

@broker.subscriber("test")
async def base_handler(
    body: str,
    cor_id: str = Context("message.correlation_id"),
):
    print(cor_id)
```

Or even directly from the raw message:

```python hl_lines="6"
from faststream import Context

@broker.subscriber("test")
async def base_handler(
    body: str,
    cor_id: str = Context("message.raw_message.correlation_id"),
):
    print(cor_id)
```

But this code is too long to be reused everywhere. In this case, you can use a Python Annotated{.external-link target="_blank"} feature:

=== "python 3.9+"
    ```python hl_lines="4 9"
    from types import Annotated
    from faststream import Context

=== "python 3.6+"
    ```python hl_lines="4 9"
    from typing_extensions import Annotated
    from faststream import Contexth}hP/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/rabbit/message.mdsuh(hhh}h}(hjC  hjD  usub$0639d4c4-10e2-4fd1-ab05-ea05ece284a7h
)}(h
}(hX  Header Exchange

The Header Exchange is the most complex and flexible way to route messages in RabbitMQ. This exchange type sends messages to queues according by matching the queue binding arguments with message headers.

At the same time, if several consumers are subscribed to the queue, messages will also be distributed among them.

Example

```python linenums="1"
from faststream import FastStream, Logger
from faststream.rabbit import ExchangeType, RabbitBroker, RabbitExchange, RabbitQueue

broker = RabbitBroker()
app = FastStream(broker)

exch = RabbitExchange("exchange", auto_delete=True, type=ExchangeType.HEADERS)

queue_1 = RabbitQueue(
    "test-queue-1",
    auto_delete=True,
    bind_arguments={"key": 1},
)
queue_2 = RabbitQueue(
    "test-queue-2",
    auto_delete=True,
    bind_arguments={"key": 2, "key2": 2, "x-match": "any"},
)
queue_3 = RabbitQueue(
    "test-queue-3",
    auto_delete=True,
    bind_arguments={"key": 2, "key2": 2, "x-match": "all"},
)

@broker.subscriber(queue_1, exch)
async def base_handler1(logger: Logger):
    logger.info("base_handler1")

@broker.subscriber(queue_1, exch)
async def base_handler2(logger: Logger):
    logger.info("base_handler2")

@broker.subscriber(queue_2, exch)
async def base_handler3(logger: Logger):
    logger.info("base_handler3")

@broker.subscriber(queue_3, exch)
async def base_handler4(logger: Logger):
    logger.info("base_handler4")

@app.after_startup
async def send_messages():
    await broker.publish(exchange=exch, headers={"key": 1})  # handlers: 1
    await broker.publish(exchange=exch, headers={"key": 1})  # handlers: 2
    await broker.publish(exchange=exch, headers={"key": 1})  # handlers: 1
    await broker.publish(exchange=exch, headers={"key": 2})  # handlers: 3
    await broker.publish(exchange=exch, headers={"key2": 2})  # handlers: 3
    await broker.publish(
        exchange=exch, headers={"key": 2, "key2": 2.0}
    )  # handlers: 3, 4
```

Consumer Announcement

First, we announce our Header exchange and several queues that will listen to it:

```python linenums="7" hl_lines="1 6 11 16"
exch = RabbitExchange("exchange", auto_delete=True, type=ExchangeType.HEADERS)

queue_1 = RabbitQueue(
    "test-queue-1",
    auto_delete=True,
    bind_arguments={"key": 1},
)
queue_2 = RabbitQueue(
    "test-queue-2",
    auto_delete=True,
    bind_arguments={"key": 2, "key2": 2, "x-match": "any"},
)
queue_3 = RabbitQueue(
    "test-queue-3",
    auto_delete=True,
    bind_arguments={"key": 2, "key2": 2, "x-match": "all"},
)
```

The x-match argument indicates whether the arguments should match the message headers in whole or in part.

Then we signed up several consumers using the advertised queues to the exchange we created:

```python linenums="26" hl_lines="1 6 11 16"
@broker.subscriber(queue_1, exch)
async def base_handler1(logger: Logger):
    logger.info("base_handler1")

@broker.subscriber(queue_1, exch)
async def base_handler2(logger: Logger):
    logger.info("base_handler2")

@broker.subscriber(queue_2, exch)
async def base_handler3(logger: Logger):
    logger.info("base_handler3")

@broker.subscriber(queue_3, exch)
async def base_handler4(logger: Logger):
    logger.info("base_handler4")
```

!!! note
    handler1 and handler2 are subscribed to the same exchange using the same queue:
    within a single service, this does not make sense, since messages will come to these handlers in turn.
    Here we emulate the work of several consumers and load balancing between them.

Message Distribution

Now the distribution of messages between these consumers will look like this:

python linenums="48"
    await broker.publish(exchange=exch, headers={"key": 1})  # handlers: 1

Message 1 will be sent to handler1 because it listens to a queue whose key header matches the key header of the message.

python linenums="49"
    await broker.publish(exchange=exch, headers={"key": 1})  # handlers: 2

Message 2 will be sent to handler2 because it listens to exchange using the same queue, but handler1 is busy.

python linenums="50"
    await broker.publish(exchange=exch, headers={"key": 1})  # handlers: 1

Message 3 will be sent to handler1 again because it is currently free.

python linenums="51"
    await broker.publish(exchange=exch, headers={"key": 2})  # handlers: 3

Message 4 will be sent to handler3 because it listens to a queue whose key header coincided with the key header of the message.

python linenums="52"
    await broker.publish(exchange=exch, headers={"key2": 2})  # handlers: 3

Message 5 will be sent to handler3 because it listens to a queue whose header key2 coincided with the header key2 of the message.

python linenums="53"
    await broker.publish(
        exchange=exch, headers={"key": 2, "key2": 2.0}
    )  # handlers: 3, 4

Message 6 will be sent to handler3 and handler4 because the message headers completely match the queue keys.

!!! note
    When sending messages to Header exchange, it makes no sense to specify the arguments queue or routing_key, because they will be ignored

!!! warning
    For incredibly complex routes, you can use the option to bind an exchange to another exchange. In this case, all the same rules apply as for queues subscribed to exchange. The only difference is that the signed exchange can further distribute messages according to its own rules.h}hY/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/rabbit/examples/headers.mdsuh(hhh}h}(hjM  hjN  usub$f983f3cc-36c5-4410-98e2-ff37a0ab8b93h
)}(h
}(hXa  Direct Exchange

The Direct Exchange is the basic way to route messages in RabbitMQ. Its core is very simple: the exchange sends messages to those queues whose routing_key matches the routing_key of the message being sent.

!!! note
    The Default Exchange, to which all queues in RabbitMQ are subscribed, has the Direct type by default.

Scaling

If several consumers are listening to the same queue, messages will be distributed to one of them (round-robin). This behavior is common for all types of exchange because it refers to the queue itself. The type of exchange affects which queues the message gets into.

Thus, RabbitMQ can independently balance the load on queue consumers. You can increase the processing speed of the message flow from the queue by launching additional instances of a consumer service. You don't need to make changes to the current infrastructure configuration: RabbitMQ will take care of how to distribute messages between your services.

Example

!!! tip
    The Direct Exchange is the type used in FastStream by default. You can simply declare it as follows:

The argument auto_delete=True in this and subsequent examples is used only to clear the state of RabbitMQ after example runs.

```python linenums="1"
from faststream import FastStream, Logger
from faststream.rabbit import RabbitBroker, RabbitExchange, RabbitQueue

broker = RabbitBroker()
app = FastStream(broker)

exch = RabbitExchange("exchange", auto_delete=True)

queue_1 = RabbitQueue("test-q-1", auto_delete=True)
queue_2 = RabbitQueue("test-q-2", auto_delete=True)

@broker.subscriber(queue_1, exch)
async def base_handler1(logger: Logger):
    logger.info("base_handler1")

@broker.subscriber(queue_1, exch)
async def base_handler2(logger: Logger):
    logger.info("base_handler2")

@broker.subscriber(queue_2, exch)
async def base_handler3(logger: Logger):
    logger.info("base_handler3")

@app.after_startup
async def send_messages():
    await broker.publish(queue="test-q-1", exchange=exch)  # handlers: 1
    await broker.publish(queue="test-q-1", exchange=exch)  # handlers: 2
    await broker.publish(queue="test-q-1", exchange=exch)  # handlers: 1
    await broker.publish(queue="test-q-2", exchange=exch)  # handlers: 3
```

Consumer Announcement

First, we announce our Direct exchange and several queues that will listen to it:

```python linenums="7"
exch = RabbitExchange("exchange", auto_delete=True)

queue_1 = RabbitQueue("test-q-1", auto_delete=True)
queue_2 = RabbitQueue("test-q-2", auto_delete=True)
```

Then we sign up several consumers using the advertised queues to the exchange we created:

```python linenums="13" hl_lines="1 6 11"
@broker.subscriber(queue_1, exch)
async def base_handler1(logger: Logger):
    logger.info("base_handler1")

@broker.subscriber(queue_1, exch)
async def base_handler2(logger: Logger):
    logger.info("base_handler2")

@broker.subscriber(queue_2, exch)
async def base_handler3(logger: Logger):
    logger.info("base_handler3")
```

!!! note
    handler1 and handler2 are subscribed to the same exchange using the same queue:
    within a single service, this does not make sense, since messages will come to these handlers in turn.
    Here we emulate the work of several consumers and load balancing between them.

Message Distribution

Now, the distribution of messages between these consumers will look like this:

python linenums="30"
    await broker.publish(queue="test-q-1", exchange=exch)  # handlers: 1

Message 1 will be sent to handler1 because it listens to the exchange using a queue with the routing key test-q-1.

python linenums="31"
    await broker.publish(queue="test-q-1", exchange=exch)  # handlers: 2

Message 2 will be sent to handler2 because it listens to the exchange using the same queue, but handler1 is busy.

python linenums="32"
    await broker.publish(queue="test-q-1", exchange=exch)  # handlers: 1

Message 3 will be sent to handler1 again because it is currently free.

python linenums="33"
    await broker.publish(queue="test-q-2", exchange=exch)  # handlers: 3

Message 4 will be sent to handler3 because it is the only one listening to the exchange using a queue with the routing key test-q-2.'      h}hX/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/rabbit/examples/direct.mdsuh(hhh}h}(hjW  hjX  usub$5865c2b4-e853-47d1-9785-8fec6c7d2f09h
)}(h
}(hX6  RabbitMQ Streams

RabbitMQ has a Streams{.exteranl-link target="_blank"} feature, which is closely related to Kafka topics.

The main difference from regular RabbitMQ queues is that the messages are not deleted after consuming.

And FastStream supports this feature as well!

```python linenums="1" hl_lines="4 10-12 17"
from faststream import FastStream, Logger
from faststream.rabbit import RabbitBroker, RabbitQueue

broker = RabbitBroker(max_consumers=10)
app = FastStream(broker)

queue = RabbitQueue(
    name="test",
    durable=True,
    arguments={
        "x-queue-type": "stream",
    },
)

@broker.subscriber(
    queue,
    consume_args={"x-stream-offset": "first"},
)
async def handle(msg, logger: Logger):
    logger.info(msg)

@app.after_startup
async def test():
    await broker.publish("Hi!", queue)
```h}hX/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/rabbit/examples/stream.mdsuh(hhh}h}(hja  hjb  usub$88861323-1e1b-499b-9f34-7ba010c73f4dh
)}(h
}(hXi  Basic Subscriber

If you know nothing about RabbitMQ and how it works, you will still able to use FastStream RabbitBroker.

Just use the #!python @broker.subscriber(...) method with a string as a routing key.

```python linenums="1"
from faststream import FastStream
from faststream.rabbit import RabbitBroker

broker = RabbitBroker()
app = FastStream(broker)

@broker.subscriber("routing_key")  # handle messages by routing key
async def handle(msg):
    print(msg)

@app.after_startup
async def test_publish():
    await broker.publish(
        "message",
        "routing_key",  # publish message with routing key
    )
```

This is the principle all FastStream brokers work by: you don't need to learn them in-depth if you want to just send a message.

RabbitMQ Details

If you are already familiar with RabbitMQ logic, you should also be acquainted with the inner workings of the example mentioned above.

In this case, FastStream either creates or validates a queue with a specified routing_key and binds it to the default RabbitMQ exchange.

If you want to specify a queue-exchange pair with additional arguments, FastStream provides you with the ability to do so. You can use special RabbitQueue and RabbitExchange objects to configure RabbitMQ queues, exchanges, and binding properties. For examples of using various types of exchanges, please refer to the following articles.h}hW/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/rabbit/examples/index.mdsuh(hhh}h}(hjk  hjl  usub$2cfa3bec-8c06-44b8-8e69-17c66afe3251h
)}(h
}(hX
  Topic Exchange

At the same time, if several consumers are subscribed to the queue, messages will be distributed among them.

Example

```python linenums="1"
from faststream import FastStream, Logger
from faststream.rabbit import ExchangeType, RabbitBroker, RabbitExchange, RabbitQueue

broker = RabbitBroker()
app = FastStream(broker)

exch = RabbitExchange("exchange", auto_delete=True, type=ExchangeType.TOPIC)

queue_1 = RabbitQueue("test-queue-1", auto_delete=True, routing_key=".info")
queue_2 = RabbitQueue("test-queue-2", auto_delete=True, routing_key=".debug")

@broker.subscriber(queue_1, exch)
async def base_handler1(logger: Logger):
    logger.info("base_handler1")

@broker.subscriber(queue_1, exch)
async def base_handler2(logger: Logger):
    logger.info("base_handler2")

@broker.subscriber(queue_2, exch)
async def base_handler3(logger: Logger):
    logger.info("base_handler3")

@app.after_startup
async def send_messages():
    await broker.publish(routing_key="logs.info", exchange=exch)  # handlers: 1
    await broker.publish(routing_key="logs.info", exchange=exch)  # handlers: 2
    await broker.publish(routing_key="logs.info", exchange=exch)  # handlers: 1
    await broker.publish(routing_key="logs.debug", exchange=exch)  # handlers: 3
```

Consumer Announcement

First, we announce our Topic exchange and several queues that will listen to it:

```python linenums="7" hl_lines="1 3-4"
exch = RabbitExchange("exchange", auto_delete=True, type=ExchangeType.TOPIC)

queue_1 = RabbitQueue("test-queue-1", auto_delete=True, routing_key=".info")
queue_2 = RabbitQueue("test-queue-2", auto_delete=True, routing_key=".debug")
```

At the same time, in the routing_key of our queues, we specify the pattern of routing keys that will be processed by this queue.

Then we sign up several consumers using the advertised queues to the exchange we created:

```python linenums="13" hl_lines="1 6 11"
@broker.subscriber(queue_1, exch)
async def base_handler1(logger: Logger):
    logger.info("base_handler1")

@broker.subscriber(queue_1, exch)
async def base_handler2(logger: Logger):
    logger.info("base_handler2")

@broker.subscriber(queue_2, exch)
async def base_handler3(logger: Logger):
    logger.info("base_handler3")
```

!!! note
    handler1 and handler2 are subscribed to the same exchange using the same queue:
    within a single service, this does not make sense, since messages will come to these handlers in turn.
    Here we emulate the work of several consumers and load balancing between them.

Message Distribution

Now the distribution of messages between these consumers will look like this:

python linenums="30"
    await broker.publish(routing_key="logs.info", exchange=exch)  # handlers: 1

Message 1 will be sent to handler1 because it listens to exchange using a queue with the routing key *.info.

python linenums="31"
    await broker.publish(routing_key="logs.info", exchange=exch)  # handlers: 2

Message 2 will be sent to handler2 because it listens to exchange using the same queue, but handler1 is busy.

python linenums="32"
    await broker.publish(routing_key="logs.info", exchange=exch)  # handlers: 1

Message 3 will be sent to handler1 again because it is currently free.

python linenums="33"
    await broker.publish(routing_key="logs.debug", exchange=exch)  # handlers: 3

Message 4 will be sent to handler3 because it is the only one listening to exchange using a queue with the routing key *.debug.h}hW/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/rabbit/examples/topic.mdsuh(hhh}h}(hju  hjv  usub$5ec74bf0-1970-483b-b7db-976a566fb448h
)}(h
}(hX}  Fanout Exchange

The Fanout Exchange is an even simpler, but slightly less popular way of routing in RabbitMQ. This type of exchange sends messages to all queues subscribed to it, ignoring any arguments of the message.

At the same time, if the queue listens to several consumers, messages will also be distributed among them.

Example

```python linenums="1"
from faststream import FastStream, Logger
from faststream.rabbit import ExchangeType, RabbitBroker, RabbitExchange, RabbitQueue

broker = RabbitBroker()
app = FastStream(broker)

exch = RabbitExchange("exchange", auto_delete=True, type=ExchangeType.FANOUT)

queue_1 = RabbitQueue("test-q-1", auto_delete=True)
queue_2 = RabbitQueue("test-q-2", auto_delete=True)

@broker.subscriber(queue_1, exch)
async def base_handler1(logger: Logger):
    logger.info("base_handler1")

@broker.subscriber(queue_1, exch)
async def base_handler2(logger: Logger):
    logger.info("base_handler2")

@broker.subscriber(queue_2, exch)
async def base_handler3(logger: Logger):
    logger.info("base_handler3")

@app.after_startup
async def send_messages():
    await broker.publish(exchange=exch)  # handlers: 1, 3
    await broker.publish(exchange=exch)  # handlers: 2, 3
    await broker.publish(exchange=exch)  # handlers: 1, 3
    await broker.publish(exchange=exch)  # handlers: 2, 3
```

Consumer Announcement

To begin with, we announced our Fanout exchange and several queues that will listen to it:

```python linenums="7" hl_lines="1"
exch = RabbitExchange("exchange", auto_delete=True, type=ExchangeType.FANOUT)

queue_1 = RabbitQueue("test-q-1", auto_delete=True)
queue_2 = RabbitQueue("test-q-2", auto_delete=True)
```

Then we signed up several consumers using the advertised queues to the exchange we created:

```python linenums="13" hl_lines="1 6 11"
@broker.subscriber(queue_1, exch)
async def base_handler1(logger: Logger):
    logger.info("base_handler1")

@broker.subscriber(queue_1, exch)
async def base_handler2(logger: Logger):
    logger.info("base_handler2")

@broker.subscriber(queue_2, exch)
async def base_handler3(logger: Logger):
    logger.info("base_handler3")
```

!!! note
    handler1 and handler2 are subscribed to the same exchange using the same queue:
    within a single service, this does not make sense, since messages will come to these handlers in turn.
    Here we emulate the work of several consumers and load balancing between them.

Message Distribution

Now the distribution of messages between these consumers will look like this:

python linenums="30"
    await broker.publish(exchange=exch)  # handlers: 1, 3

Message 1 will be sent to handler1 and handler3 because they listen to exchange using different queues.

python linenums="31"
    await broker.publish(exchange=exch)  # handlers: 2, 3

python linenums="32"
    await broker.publish(exchange=exch)  # handlers: 1, 3

Message 3 will be sent to handler1 and handler3.

python linenums="33"
    await broker.publish(exchange=exch)  # handlers: 2, 3

Message 4 will be sent to handler2 and handler3.

!!! note
    When sending messages to Fanout exchange, it makes no sense to specify the arguments queue or routing_key, because they will be ignored.h}hX/tmp/tmp19_cw5l4/extrated_path/faststream-main/.faststream_gen/rabbit/examples/fanout.mdsuh(hhh}h}(hj  hj  usubusb}(K hKhKh%Kh/Kh9KhCKhMKhWKhaK	hkK
huKhKhK
hKhKhKhKhKhKhKhKhKhKhKhKj	  Kj  Kj  Kj'  Kj1  Kj;  KjE  K jO  K!jY  K"jc  K#jm  K$jw  K%j  K&j  K'j  K(j  K)j  K*j  K+j  K,j  K-j  K.j  K/j  K0j  K1j  K2j  K3j
  K4j  K5j!  K6j+  K7j5  K8j?  K9jI  K:jS  K;j]  K<jg  K=jq  K>j{  u.