import pandas as pd
import pytest

from moosir_feature.transformers.indicators.feature_manager import *
from moosir_feature.transformers.indicators.contexts import *


@pytest.fixture
def ohlc():
    return pd.DataFrame(data=np.random.rand(100, 4), columns=["Open", "High", "Low", "Close"])


"""
todo: test context!!!!
"""


def test_feature_manager_calculate_forwards(ohlc: pd.DataFrame):
    # arrange
    win_lens = [3, 6]
    forward_lens = [2, 5]

    # feature_names = OPERATORS_IND.keys()
    feature_names = [
        RsiOperator.__name__,
    ]

    context = Context()

    # act
    result = calculate_forwards(ohlc=ohlc,
                                win_lens=win_lens,
                                forward_periods=forward_lens,
                                feature_names=feature_names)

    # assert
    print(result)
    assert context.validate(result, operators=[RsiOperator], periods=win_lens, forward_periods=forward_lens)
    # assert len(result) == len(ohlc) - 4, "nan values generated by window still exist"


def test_feature_manager_calculate_features_lags(ohlc: pd.DataFrame):
    # arrange
    win_lens = [3, 6]
    lag_lens = [2, 5]

    feature_names = [
        RsiOperator.__name__,
    ]

    context = Context()

    # act
    result = calculate_lags(ohlc=ohlc,
                            win_lens=win_lens,
                            lag_lens=lag_lens,
                            feature_names=feature_names)

    # assert
    print(result)
    assert context.validate(result, operators=[RsiOperator], periods=win_lens, lag_periods=lag_lens)
    # assert len(result) == len(ohlc) - 4, "nan values generated by window still exist"


def test_feature_manager_calculate_features_all_indicators(ohlc: pd.DataFrame):
    # arrange
    win_lens = [3, 4]

    feature_names = OPERATORS_IND.keys()

    context = Context()

    # act
    result = calculate_features(ohlc=ohlc,
                                win_lens=win_lens,
                                feature_names=feature_names)

    # assert
    assert context.validate(result, operators=OPERATORS_IND.values(), periods=win_lens)
    assert len(result) == len(ohlc) - 4, "nan values generated by window still exist"


def test_feature_manager_calculate_features_e2e(ohlc):
    # arrange
    look_back_periods = [3, 4]

    tech_indicators = list(OPERATORS_IND.keys()) + list(OPERATORS_RET.keys())

    context = Context()

    # act
    result = calculate_features(ohlc=ohlc,
                                win_lens=look_back_periods,
                                feature_names=tech_indicators)

    # assert
    assert context.validate(result, operators=OPERATORS_IND.values(), periods=look_back_periods)
    assert context.validate(result, operators=OPERATORS_RET.values(), periods=look_back_periods)
