import { Config } from "conventional-changelog-config-spec";
export interface BumpOptions {
    /**
     * The name of a .json file to set `version`.
     */
    readonly versionFile: string;
    /**
     * The name of the changelog file to generate.
     */
    readonly changelog: string;
    /**
     * Use a pre-release suffix.
     * @default - normal versioning
     */
    readonly prerelease?: string;
    /**
     * Defines the major version line. This is used to select the latest version
     * and also enforce that new major versions are not released accidentally.
     *
     * Can not be set together with `minMajorVersion`.
     *
     * @default - any version is supported
     */
    readonly majorVersion?: number;
    /**
     * Defines the minimal major version. This is used if you want to start with
     * a specific major version, and increment from there on.
     * This can be useful to set to 1, as breaking changes before the 1.x major
     * release are not incrementing the major version number.
     *
     * Can not be set together with `majorVersion`.
     *
     * @default - No minimum version is being enforced
     */
    readonly minMajorVersion?: number;
    /**
     * The name of a file which will include the output version number (a text file).
     *
     * Relative to cwd.
     *
     * @example ".version.txt"
     */
    readonly bumpFile: string;
    /**
     * The name of the file which will include the release tag (a text file).
     *
     * Relative to cwd.
     *
     * @example ".releasetag.txt"
     */
    readonly releaseTagFile: string;
    /**
     * The prefix applied to release tags. Bumps will be made based on the latest
     * version found with this prefix.
     */
    readonly tagPrefix?: string;
    /**
     * Conguration values that would append to versionrc file or overwrite values
     * coming to that from default one.
     */
    readonly versionrcOptions?: Config;
}
/**
 * Resolves the latest version from git tags and uses `standard-version` to bump
 * to the next version based on commits.
 *
 * This expects `standard-version` to be installed in the path.
 *
 * @param cwd working directory (git repository)
 * @param options options
 */
export declare function bump(cwd: string, options: BumpOptions): Promise<void>;
