"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const spec_1 = require("@jsii/spec");
const lib_1 = require("../lib");
describe('@struct', () => {
    test('causes behavioral-named interfaces to be structs', () => {
        const assembly = (0, lib_1.sourceToAssemblyHelper)(`
      /** @struct */
      export interface IPSet {
        readonly cidr: string;
      }
    `);
        expect(assembly.types['testpkg.IPSet'].kind).toBe(spec_1.TypeKind.Interface);
        expect(assembly.types['testpkg.IPSet'].datatype).toBe(true);
    });
    test('can be used on any struct', () => {
        const assembly = (0, lib_1.sourceToAssemblyHelper)(`
      /** @struct */
      export interface Struct {
        readonly cidr: string;
      }
    `);
        expect(assembly.types['testpkg.Struct'].kind).toBe(spec_1.TypeKind.Interface);
        expect(assembly.types['testpkg.Struct'].datatype).toBe(true);
    });
});
//# sourceMappingURL=hints.test.js.map