export declare function inTempDir<T>(block: () => T | Promise<T>): Promise<T>;
export declare type DownloadFailure = 'no_such_package';
export declare type NpmDownloadResult<T> = {
    success: true;
    result: T;
} | {
    success: false;
    reason: DownloadFailure;
};
export declare function showDownloadFailure(f: DownloadFailure): "NPM package does not exist" | undefined;
export declare function downloadNpmPackage<T>(pkg: string, block: (dir: string) => Promise<T>): Promise<NpmDownloadResult<T>>;
export declare function flatMap<T, U>(xs: T[], fn: (x: T) => U[]): U[];
/**
 * Don't recurse infinitely by guarding a block with `do()`.
 */
export declare class RecursionBreaker<A> {
    private readonly elements;
    do(key: A, block: () => void): void;
}
//# sourceMappingURL=util.d.ts.map