"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_msk_1 = require("aws-cdk-lib/aws-msk");
const nag_rules_1 = require("../../nag-rules");
/**
 * MSK clusters use TLS communication between brokers
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_msk_1.CfnCluster) {
        const encryptionInfo = aws_cdk_lib_1.Stack.of(node).resolve(node.encryptionInfo);
        if (encryptionInfo != undefined) {
            const encryptionInTransit = aws_cdk_lib_1.Stack.of(node).resolve(encryptionInfo.encryptionInTransit);
            if (encryptionInTransit != undefined) {
                const inCluster = nag_rules_1.NagRules.resolveIfPrimitive(node, encryptionInTransit.inCluster);
                if (inCluster === false) {
                    return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
                }
            }
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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