"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.DeployCdkStackAction=void 0;const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),fs=require("fs"),path=require("path"),cpactions=require("../../../../aws-codepipeline-actions"),iam=require("../../../../aws-iam"),core_1=require("../../../../core"),cxapi=require("../../../../cx-api"),constructs_1=require("constructs"),construct_internals_1=require("../../private/construct-internals"),fs_1=require("../../private/fs");class DeployCdkStackAction{constructor(props){if(props.output&&!props.outputFileName)throw new Error("If 'output' is set, 'outputFileName' is also required");this.stackArtifactId=props.stackArtifactId,this.dependencyStackArtifactIds=props.dependencyStackArtifactIds??[],this.prepareRunOrder=props.prepareRunOrder??1,this.executeRunOrder=props.executeRunOrder??this.prepareRunOrder+1,this.stackName=props.stackName;const baseActionName=props.baseActionName??this.stackName,changeSetName=props.changeSetName??"PipelineChange";this.prepareChangeSetAction=new cpactions.CloudFormationCreateReplaceChangeSetAction({actionName:`${baseActionName}.Prepare`,changeSetName,runOrder:this.prepareRunOrder,stackName:this.stackName,templatePath:props.cloudAssemblyInput.atPath(props.templatePath),adminPermissions:!1,role:props.actionRole,deploymentRole:props.cloudFormationExecutionRole,region:props.region,cfnCapabilities:[core_1.CfnCapabilities.NAMED_IAM,core_1.CfnCapabilities.AUTO_EXPAND],templateConfiguration:props.templateConfigurationPath?props.cloudAssemblyInput.atPath(props.templateConfigurationPath):void 0}),this.executeChangeSetAction=new cpactions.CloudFormationExecuteChangeSetAction({actionName:`${baseActionName}.Deploy`,changeSetName,runOrder:this.executeRunOrder,stackName:this.stackName,role:props.actionRole,region:props.region,outputFileName:props.outputFileName,output:props.output})}static fromStackArtifact(scope,artifact,options){if(!artifact.assumeRoleArn)throw new Error(`Stack '${artifact.stackName}' does not have deployment role information; use the 'DefaultStackSynthesizer' synthesizer, or set the '@aws-cdk/core:newStyleStackSynthesis' context key.`);const artRegion=artifact.environment.region,region=artRegion===core_1.Stack.of(scope).region||artRegion===cxapi.UNKNOWN_REGION?void 0:artRegion,artAccount=artifact.environment.account,account=artAccount===core_1.Stack.of(scope).account||artAccount===cxapi.UNKNOWN_ACCOUNT?void 0:artAccount,actionRole=roleFromPlaceholderArn(scope,region,account,artifact.assumeRoleArn),cloudFormationExecutionRole=roleFromPlaceholderArn(scope,region,account,artifact.cloudFormationExecutionRoleArn),appAsmRoot=construct_internals_1.assemblyBuilderOf(construct_internals_1.appOf(scope)).outdir,fullTemplatePath=path.join(artifact.assembly.directory,artifact.templateFile);let fullConfigPath;return Object.keys(artifact.tags).length>0&&(fullConfigPath=`${fullTemplatePath}.config.json`,writeTemplateConfiguration(fullConfigPath,{Tags:artifact.tags})),new DeployCdkStackAction({actionRole,cloudFormationExecutionRole,templatePath:fs_1.toPosixPath(path.relative(appAsmRoot,fullTemplatePath)),templateConfigurationPath:fullConfigPath?fs_1.toPosixPath(path.relative(appAsmRoot,fullConfigPath)):void 0,region,stackArtifactId:artifact.id,dependencyStackArtifactIds:artifact.dependencies.filter(isStackArtifact).map(s=>s.id),stackName:options.stackName??artifact.stackName,...options})}bind(scope,stage,options){return stage.addAction(this.prepareChangeSetAction),this.executeChangeSetAction.bind(scope,stage,options)}onStateChange(name,target,options){return this.executeChangeSetAction.onStateChange(name,target,options)}get actionProperties(){return this.executeChangeSetAction.actionProperties}}exports.DeployCdkStackAction=DeployCdkStackAction,_a=JSII_RTTI_SYMBOL_1,DeployCdkStackAction[_a]={fqn:"aws-cdk-lib.pipelines.DeployCdkStackAction",version:"2.69.0"};function roleFromPlaceholderArn(scope,region,account,arn){if(!arn)return;const id=arn;let existingRole=constructs_1.Node.of(scope).tryFindChild(`ImmutableRole${id}`);if(existingRole||(existingRole=constructs_1.Node.of(scope).tryFindChild(id),existingRole))return existingRole;const arnToImport=cxapi.EnvironmentPlaceholders.replace(arn,{region:region??core_1.Aws.REGION,accountId:account??core_1.Aws.ACCOUNT_ID,partition:core_1.Aws.PARTITION});return iam.Role.fromRoleArn(scope,id,arnToImport,{mutable:!1,addGrantsToResources:!0})}function isStackArtifact(a){return a.constructor.name==="CloudFormationStackArtifact"}function writeTemplateConfiguration(filename,config){fs.writeFileSync(filename,JSON.stringify(config,void 0,2),{encoding:"utf-8"})}
