"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.StringListParameter=exports.StringParameter=exports.ParameterTier=exports.ParameterDataType=exports.ParameterType=exports.ParameterValueType=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),iam=require("../../aws-iam"),cxschema=require("../../cloud-assembly-schema"),core_1=require("../../core"),ssm=require("./ssm.generated"),util_1=require("./util");class ParameterBase extends core_1.Resource{grantRead(grantee){return this.encryptionKey&&this.encryptionKey.grantDecrypt(grantee),iam.Grant.addToPrincipal({grantee,actions:["ssm:DescribeParameters","ssm:GetParameters","ssm:GetParameter","ssm:GetParameterHistory"],resourceArns:[this.parameterArn]})}grantWrite(grantee){return this.encryptionKey&&this.encryptionKey.grantEncrypt(grantee),iam.Grant.addToPrincipal({grantee,actions:["ssm:PutParameter"],resourceArns:[this.parameterArn]})}}var ParameterValueType;(function(ParameterValueType2){ParameterValueType2.STRING="String",ParameterValueType2.AWS_EC2_AVAILABILITYZONE_NAME="AWS::EC2::AvailabilityZone::Name",ParameterValueType2.AWS_EC2_IMAGE_ID="AWS::EC2::Image::Id",ParameterValueType2.AWS_EC2_INSTANCE_ID="AWS::EC2::Instance::Id",ParameterValueType2.AWS_EC2_KEYPAIR_KEYNAME="AWS::EC2::KeyPair::KeyName",ParameterValueType2.AWS_EC2_SECURITYGROUP_GROUPNAME="AWS::EC2::SecurityGroup::GroupName",ParameterValueType2.AWS_EC2_SECURITYGROUP_ID="AWS::EC2::SecurityGroup::Id",ParameterValueType2.AWS_EC2_SUBNET_ID="AWS::EC2::Subnet::Id",ParameterValueType2.AWS_EC2_VOLUME_ID="AWS::EC2::Volume::Id",ParameterValueType2.AWS_EC2_VPC_ID="AWS::EC2::VPC::Id",ParameterValueType2.AWS_ROUTE53_HOSTEDZONE_ID="AWS::Route53::HostedZone::Id"})(ParameterValueType=exports.ParameterValueType||(exports.ParameterValueType={}));var ParameterType;(function(ParameterType2){ParameterType2.STRING="String",ParameterType2.SECURE_STRING="SecureString",ParameterType2.STRING_LIST="StringList",ParameterType2.AWS_EC2_IMAGE_ID="AWS::EC2::Image::Id"})(ParameterType=exports.ParameterType||(exports.ParameterType={}));var ParameterDataType;(function(ParameterDataType2){ParameterDataType2.TEXT="text",ParameterDataType2.AWS_EC2_IMAGE="aws:ec2:image"})(ParameterDataType=exports.ParameterDataType||(exports.ParameterDataType={}));var ParameterTier;(function(ParameterTier2){ParameterTier2.ADVANCED="Advanced",ParameterTier2.INTELLIGENT_TIERING="Intelligent-Tiering",ParameterTier2.STANDARD="Standard"})(ParameterTier=exports.ParameterTier||(exports.ParameterTier={}));class StringParameter extends ParameterBase{constructor(scope,id,props){super(scope,id,{physicalName:props.parameterName});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_StringParameterProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,StringParameter),error}if(props.allowedPattern&&_assertValidValue(props.stringValue,props.allowedPattern),validateParameterName(this.physicalName),props.description&&props.description?.length>1024)throw new Error("Description cannot be longer than 1024 characters.");if(props.type&&props.type===ParameterType.AWS_EC2_IMAGE_ID)throw new Error("The type must either be ParameterType.STRING or ParameterType.STRING_LIST. Did you mean to set dataType: ParameterDataType.AWS_EC2_IMAGE instead?");const resource=new ssm.CfnParameter(this,"Resource",{allowedPattern:props.allowedPattern,description:props.description,name:this.physicalName,tier:props.tier,type:props.type||ParameterType.STRING,dataType:props.dataType,value:props.stringValue});this.parameterName=this.getResourceNameAttribute(resource.ref),this.parameterArn=util_1.arnForParameterName(this,this.parameterName,{physicalName:props.parameterName||util_1.AUTOGEN_MARKER,simpleName:props.simpleName}),this.parameterType=resource.attrType,this.stringValue=resource.attrValue}static fromStringParameterName(scope,id,stringParameterName){return this.fromStringParameterAttributes(scope,id,{parameterName:stringParameterName})}static fromStringParameterAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_StringParameterAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromStringParameterAttributes),error}if(!attrs.parameterName)throw new Error("parameterName cannot be an empty string");if(attrs.type&&![ParameterType.STRING,ParameterType.AWS_EC2_IMAGE_ID].includes(attrs.type))throw new Error(`fromStringParameterAttributes does not support ${attrs.type}. Please use ParameterType.STRING or ParameterType.AWS_EC2_IMAGE_ID`);const type=attrs.type??attrs.valueType??ParameterValueType.STRING,stringValue=attrs.version?new core_1.CfnDynamicReference(core_1.CfnDynamicReferenceService.SSM,`${attrs.parameterName}:${core_1.Tokenization.stringifyNumber(attrs.version)}`).toString():new core_1.CfnParameter(scope,`${id}.Parameter`,{type:`AWS::SSM::Parameter::Value<${type}>`,default:attrs.parameterName}).valueAsString;class Import extends ParameterBase{constructor(){super(...arguments),this.parameterName=attrs.parameterName,this.parameterArn=util_1.arnForParameterName(this,attrs.parameterName,{simpleName:attrs.simpleName}),this.parameterType=ParameterType.STRING,this.stringValue=stringValue}}return new Import(scope,id)}static fromSecureStringParameterAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_SecureStringParameterAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromSecureStringParameterAttributes),error}const version=attrs.version?core_1.Tokenization.stringifyNumber(attrs.version):"",stringValue=new core_1.CfnDynamicReference(core_1.CfnDynamicReferenceService.SSM_SECURE,version?`${attrs.parameterName}:${version}`:attrs.parameterName).toString();class Import extends ParameterBase{constructor(){super(...arguments),this.parameterName=attrs.parameterName,this.parameterArn=util_1.arnForParameterName(this,attrs.parameterName,{simpleName:attrs.simpleName}),this.parameterType=ParameterType.SECURE_STRING,this.stringValue=stringValue,this.encryptionKey=attrs.encryptionKey}}return new Import(scope,id)}static valueFromLookup(scope,parameterName){return core_1.ContextProvider.getValue(scope,{provider:cxschema.ContextProvider.SSM_PARAMETER_PROVIDER,props:{parameterName},dummyValue:`dummy-value-for-${parameterName}`}).value}static valueForStringParameter(scope,parameterName,version){return StringParameter.valueForTypedStringParameterV2(scope,parameterName,ParameterValueType.STRING,version)}static valueForTypedStringParameterV2(scope,parameterName,type=ParameterValueType.STRING,version){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_ParameterValueType(type)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.valueForTypedStringParameterV2),error}const stack=core_1.Stack.of(scope),id=makeIdentityForImportedValue(parameterName),exists=stack.node.tryFindChild(id);return exists?exists.stringValue:this.fromStringParameterAttributes(stack,id,{parameterName,version,valueType:type}).stringValue}static valueForTypedStringParameter(scope,parameterName,type=ParameterType.STRING,version){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_ssm.StringParameter#valueForTypedStringParameter","- use valueForTypedStringParameterV2 instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_ParameterType(type)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.valueForTypedStringParameter),error}if(type===ParameterType.STRING_LIST)throw new Error("valueForTypedStringParameter does not support STRING_LIST, use valueForTypedListParameter instead");const stack=core_1.Stack.of(scope),id=makeIdentityForImportedValue(parameterName),exists=stack.node.tryFindChild(id);return exists?exists.stringValue:this.fromStringParameterAttributes(stack,id,{parameterName,version,type}).stringValue}static valueForSecureStringParameter(scope,parameterName,version){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_ssm.StringParameter#valueForSecureStringParameter","Use `SecretValue.ssmSecure()` instead, it will correctly type the imported value as a `SecretValue` and allow importing without version.")}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.valueForSecureStringParameter),error}const stack=core_1.Stack.of(scope),id=makeIdentityForImportedValue(parameterName),exists=stack.node.tryFindChild(id);return exists?exists.stringValue:this.fromSecureStringParameterAttributes(stack,id,{parameterName,version}).stringValue}}exports.StringParameter=StringParameter,_a=JSII_RTTI_SYMBOL_1,StringParameter[_a]={fqn:"aws-cdk-lib.aws_ssm.StringParameter",version:"2.69.0"};class StringListParameter extends ParameterBase{constructor(scope,id,props){super(scope,id,{physicalName:props.parameterName});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_StringListParameterProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,StringListParameter),error}if(props.stringListValue.find(str=>!core_1.Token.isUnresolved(str)&&str.indexOf(",")!==-1))throw new Error("Values of a StringList SSM Parameter cannot contain the ',' character. Use a string parameter instead.");if(props.allowedPattern&&!core_1.Token.isUnresolved(props.stringListValue)&&props.stringListValue.forEach(str=>_assertValidValue(str,props.allowedPattern)),validateParameterName(this.physicalName),props.description&&props.description?.length>1024)throw new Error("Description cannot be longer than 1024 characters.");const resource=new ssm.CfnParameter(this,"Resource",{allowedPattern:props.allowedPattern,description:props.description,name:this.physicalName,tier:props.tier,type:ParameterType.STRING_LIST,value:core_1.Fn.join(",",props.stringListValue)});this.parameterName=this.getResourceNameAttribute(resource.ref),this.parameterArn=util_1.arnForParameterName(this,this.parameterName,{physicalName:props.parameterName||util_1.AUTOGEN_MARKER,simpleName:props.simpleName}),this.parameterType=resource.attrType,this.stringListValue=core_1.Fn.split(",",resource.attrValue)}static fromStringListParameterName(scope,id,stringListParameterName){class Import extends ParameterBase{constructor(){super(...arguments),this.parameterName=stringListParameterName,this.parameterArn=util_1.arnForParameterName(this,this.parameterName),this.parameterType=ParameterType.STRING_LIST,this.stringListValue=core_1.Fn.split(",",new core_1.CfnDynamicReference(core_1.CfnDynamicReferenceService.SSM,stringListParameterName).toString())}}return new Import(scope,id)}static fromListParameterAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_ListParameterAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromListParameterAttributes),error}if(!attrs.parameterName)throw new Error("parameterName cannot be an empty string");const valueType=`List<${attrs.elementType??ParameterValueType.STRING}>`,stringValue=attrs.version?new core_1.CfnDynamicReference(core_1.CfnDynamicReferenceService.SSM,`${attrs.parameterName}:${core_1.Tokenization.stringifyNumber(attrs.version)}`).toStringList():new core_1.CfnParameter(scope,`${id}.Parameter`,{type:`AWS::SSM::Parameter::Value<${valueType}>`,default:attrs.parameterName}).valueAsList;class Import extends ParameterBase{constructor(){super(...arguments),this.parameterName=attrs.parameterName,this.parameterArn=util_1.arnForParameterName(this,attrs.parameterName,{simpleName:attrs.simpleName}),this.parameterType=valueType,this.stringListValue=stringValue}}return new Import(scope,id)}static valueForTypedListParameter(scope,parameterName,type=ParameterValueType.STRING,version){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_ParameterValueType(type)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.valueForTypedListParameter),error}const stack=core_1.Stack.of(scope),id=makeIdentityForImportedValue(parameterName),exists=stack.node.tryFindChild(id);return exists?exists.stringListValue:this.fromListParameterAttributes(stack,id,{parameterName,elementType:type,version}).stringListValue}}exports.StringListParameter=StringListParameter,_b=JSII_RTTI_SYMBOL_1,StringListParameter[_b]={fqn:"aws-cdk-lib.aws_ssm.StringListParameter",version:"2.69.0"};function _assertValidValue(value,allowedPattern){if(!(core_1.Token.isUnresolved(value)||core_1.Token.isUnresolved(allowedPattern))&&!new RegExp(allowedPattern).test(value))throw new Error(`The supplied value (${value}) does not match the specified allowedPattern (${allowedPattern})`)}function makeIdentityForImportedValue(parameterName){return`SsmParameterValue:${parameterName}:C96584B6-F00A-464E-AD19-53AFF4B05118`}function validateParameterName(parameterName){if(!core_1.Token.isUnresolved(parameterName)){if(parameterName.length>2048)throw new Error("name cannot be longer than 2048 characters.");if(!parameterName.match(/^[\/\w.-]+$/))throw new Error(`name must only contain letters, numbers, and the following 4 symbols .-_/; got ${parameterName}`)}}
