"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Domain=exports.TLSSecurityPolicy=exports.ElasticsearchVersion=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),url_1=require("url"),acm=require("../../aws-certificatemanager"),aws_cloudwatch_1=require("../../aws-cloudwatch"),ec2=require("../../aws-ec2"),iam=require("../../aws-iam"),logs=require("../../aws-logs"),route53=require("../../aws-route53"),secretsmanager=require("../../aws-secretsmanager"),cdk=require("../../core"),elasticsearch_access_policy_1=require("./elasticsearch-access-policy"),elasticsearch_generated_1=require("./elasticsearch.generated"),log_group_resource_policy_1=require("./log-group-resource-policy"),perms=require("./perms");class ElasticsearchVersion{constructor(version){this.version=version}static of(version){return new ElasticsearchVersion(version)}}exports.ElasticsearchVersion=ElasticsearchVersion,_a=JSII_RTTI_SYMBOL_1,ElasticsearchVersion[_a]={fqn:"aws-cdk-lib.aws_elasticsearch.ElasticsearchVersion",version:"2.69.0"},ElasticsearchVersion.V1_5=ElasticsearchVersion.of("1.5"),ElasticsearchVersion.V2_3=ElasticsearchVersion.of("2.3"),ElasticsearchVersion.V5_1=ElasticsearchVersion.of("5.1"),ElasticsearchVersion.V5_3=ElasticsearchVersion.of("5.3"),ElasticsearchVersion.V5_5=ElasticsearchVersion.of("5.5"),ElasticsearchVersion.V5_6=ElasticsearchVersion.of("5.6"),ElasticsearchVersion.V6_0=ElasticsearchVersion.of("6.0"),ElasticsearchVersion.V6_2=ElasticsearchVersion.of("6.2"),ElasticsearchVersion.V6_3=ElasticsearchVersion.of("6.3"),ElasticsearchVersion.V6_4=ElasticsearchVersion.of("6.4"),ElasticsearchVersion.V6_5=ElasticsearchVersion.of("6.5"),ElasticsearchVersion.V6_7=ElasticsearchVersion.of("6.7"),ElasticsearchVersion.V6_8=ElasticsearchVersion.of("6.8"),ElasticsearchVersion.V7_1=ElasticsearchVersion.of("7.1"),ElasticsearchVersion.V7_4=ElasticsearchVersion.of("7.4"),ElasticsearchVersion.V7_7=ElasticsearchVersion.of("7.7"),ElasticsearchVersion.V7_8=ElasticsearchVersion.of("7.8"),ElasticsearchVersion.V7_9=ElasticsearchVersion.of("7.9"),ElasticsearchVersion.V7_10=ElasticsearchVersion.of("7.10");var TLSSecurityPolicy;(function(TLSSecurityPolicy2){TLSSecurityPolicy2.TLS_1_0="Policy-Min-TLS-1-0-2019-07",TLSSecurityPolicy2.TLS_1_2="Policy-Min-TLS-1-2-2019-07"})(TLSSecurityPolicy=exports.TLSSecurityPolicy||(exports.TLSSecurityPolicy={}));class DomainBase extends cdk.Resource{grantRead(identity){return this.grant(identity,perms.ES_READ_ACTIONS,this.domainArn,`${this.domainArn}/*`)}grantWrite(identity){return this.grant(identity,perms.ES_WRITE_ACTIONS,this.domainArn,`${this.domainArn}/*`)}grantReadWrite(identity){return this.grant(identity,perms.ES_READ_WRITE_ACTIONS,this.domainArn,`${this.domainArn}/*`)}grantIndexRead(index,identity){return this.grant(identity,perms.ES_READ_ACTIONS,`${this.domainArn}/${index}`,`${this.domainArn}/${index}/*`)}grantIndexWrite(index,identity){return this.grant(identity,perms.ES_WRITE_ACTIONS,`${this.domainArn}/${index}`,`${this.domainArn}/${index}/*`)}grantIndexReadWrite(index,identity){return this.grant(identity,perms.ES_READ_WRITE_ACTIONS,`${this.domainArn}/${index}`,`${this.domainArn}/${index}/*`)}grantPathRead(path,identity){return this.grant(identity,perms.ES_READ_ACTIONS,`${this.domainArn}/${path}`)}grantPathWrite(path,identity){return this.grant(identity,perms.ES_WRITE_ACTIONS,`${this.domainArn}/${path}`)}grantPathReadWrite(path,identity){return this.grant(identity,perms.ES_READ_WRITE_ACTIONS,`${this.domainArn}/${path}`)}metric(metricName,props){return new aws_cloudwatch_1.Metric({namespace:"AWS/ES",metricName,dimensionsMap:{DomainName:this.domainName,ClientId:this.env.account},...props}).attachTo(this)}metricClusterStatusRed(props){return this.metric("ClusterStatus.red",{statistic:aws_cloudwatch_1.Statistic.MAXIMUM,...props})}metricClusterStatusYellow(props){return this.metric("ClusterStatus.yellow",{statistic:aws_cloudwatch_1.Statistic.MAXIMUM,...props})}metricFreeStorageSpace(props){return this.metric("FreeStorageSpace",{statistic:aws_cloudwatch_1.Statistic.MINIMUM,...props})}metricClusterIndexWritesBlocked(props){return this.metric("ClusterIndexWritesBlocked",{statistic:aws_cloudwatch_1.Statistic.MAXIMUM,period:cdk.Duration.minutes(1),...props})}metricNodes(props){return this.metric("Nodes",{statistic:aws_cloudwatch_1.Statistic.MINIMUM,period:cdk.Duration.hours(1),...props})}metricAutomatedSnapshotFailure(props){return this.metric("AutomatedSnapshotFailure",{statistic:aws_cloudwatch_1.Statistic.MAXIMUM,...props})}metricCPUUtilization(props){return this.metric("CPUUtilization",{statistic:aws_cloudwatch_1.Statistic.MAXIMUM,...props})}metricJVMMemoryPressure(props){return this.metric("JVMMemoryPressure",{statistic:aws_cloudwatch_1.Statistic.MAXIMUM,...props})}metricMasterCPUUtilization(props){return this.metric("MasterCPUUtilization",{statistic:aws_cloudwatch_1.Statistic.MAXIMUM,...props})}metricMasterJVMMemoryPressure(props){return this.metric("MasterJVMMemoryPressure",{statistic:aws_cloudwatch_1.Statistic.MAXIMUM,...props})}metricKMSKeyError(props){return this.metric("KMSKeyError",{statistic:aws_cloudwatch_1.Statistic.MAXIMUM,...props})}metricKMSKeyInaccessible(props){return this.metric("KMSKeyInaccessible",{statistic:aws_cloudwatch_1.Statistic.MAXIMUM,...props})}metricSearchableDocuments(props){return this.metric("SearchableDocuments",{statistic:aws_cloudwatch_1.Statistic.MAXIMUM,...props})}metricSearchLatency(props){return this.metric("SearchLatency",{statistic:"p99",...props})}metricIndexingLatency(props){return this.metric("IndexingLatency",{statistic:"p99",...props})}grant(grantee,domainActions,resourceArn,...otherResourceArns){const resourceArns=[resourceArn,...otherResourceArns];return iam.Grant.addToPrincipal({grantee,actions:domainActions,resourceArns,scope:this})}}class Domain extends DomainBase{constructor(scope,id,props){super(scope,id,{physicalName:props.domainName});try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticsearch.Domain","use opensearchservice module instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticsearch_DomainProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Domain),error}const defaultInstanceType="r5.large.elasticsearch",warmDefaultInstanceType="ultrawarm1.medium.elasticsearch",dedicatedMasterType=initializeInstanceType(defaultInstanceType,props.capacity?.masterNodeInstanceType),dedicatedMasterCount=props.capacity?.masterNodes??0,dedicatedMasterEnabled=cdk.Token.isUnresolved(dedicatedMasterCount)?!0:dedicatedMasterCount>0,instanceType=initializeInstanceType(defaultInstanceType,props.capacity?.dataNodeInstanceType),instanceCount=props.capacity?.dataNodes??1,warmType=initializeInstanceType(warmDefaultInstanceType,props.capacity?.warmInstanceType),warmCount=props.capacity?.warmNodes??0,warmEnabled=cdk.Token.isUnresolved(warmCount)?!0:warmCount>0,availabilityZoneCount=props.zoneAwareness?.availabilityZoneCount??2;if(![2,3].includes(availabilityZoneCount))throw new Error("Invalid zone awareness configuration; availabilityZoneCount must be 2 or 3");const zoneAwarenessEnabled=props.zoneAwareness?.enabled??props.zoneAwareness?.availabilityZoneCount!=null;let securityGroups,subnets;if(props.vpc&&(subnets=selectSubnets(props.vpc,props.vpcSubnets??[{subnetType:ec2.SubnetType.PRIVATE_WITH_EGRESS}]),securityGroups=props.securityGroups??[new ec2.SecurityGroup(this,"SecurityGroup",{vpc:props.vpc,description:`Security group for domain ${this.node.id}`})],this._connections=new ec2.Connections({securityGroups})),subnets&&zoneAwarenessEnabled&&new Set(subnets.map(subnet=>subnet.availabilityZone)).size<availabilityZoneCount)throw new Error("When providing vpc options you need to provide a subnet for each AZ you are using");if([dedicatedMasterType,instanceType,warmType].some(t=>!cdk.Token.isUnresolved(t)&&!t.endsWith(".elasticsearch")))throw new Error('Master, data and UltraWarm node instance types must end with ".elasticsearch".');if(!cdk.Token.isUnresolved(warmType)&&!warmType.startsWith("ultrawarm"))throw new Error('UltraWarm node instance type must start with "ultrawarm".');const elasticsearchVersion=props.version.version,elasticsearchVersionNum=parseVersion(props.version);if(elasticsearchVersionNum<=7.7&&![1.5,2.3,5.1,5.3,5.5,5.6,6,6.2,6.3,6.4,6.5,6.7,6.8,7.1,7.4,7.7].includes(elasticsearchVersionNum))throw new Error(`Unknown Elasticsearch version: ${elasticsearchVersion}`);const unsignedBasicAuthEnabled=props.useUnsignedBasicAuth??!1;if(unsignedBasicAuthEnabled){if(props.enforceHttps==!1)throw new Error("You cannot disable HTTPS and use unsigned basic auth");if(props.nodeToNodeEncryption==!1)throw new Error("You cannot disable node to node encryption and use unsigned basic auth");if(props.encryptionAtRest?.enabled==!1)throw new Error("You cannot disable encryption at rest and use unsigned basic auth")}const unsignedAccessPolicy=new iam.PolicyStatement({effect:iam.Effect.ALLOW,actions:["es:ESHttp*"],principals:[new iam.AnyPrincipal],resources:[cdk.Lazy.string({produce:()=>`${this.domainArn}/*`})]}),masterUserArn=props.fineGrainedAccessControl?.masterUserArn,masterUserNameProps=props.fineGrainedAccessControl?.masterUserName,masterUserName=unsignedBasicAuthEnabled?masterUserArn==null?masterUserNameProps??"admin":void 0:masterUserNameProps;if(masterUserArn!=null&&masterUserName!=null)throw new Error("Invalid fine grained access control settings. Only provide one of master user ARN or master user name. Not both.");const advancedSecurityEnabled=(masterUserArn??masterUserName)!=null,internalUserDatabaseEnabled=masterUserName!=null,masterUserPasswordProp=props.fineGrainedAccessControl?.masterUserPassword,createMasterUserPassword=()=>new secretsmanager.Secret(this,"MasterUser",{generateSecretString:{secretStringTemplate:JSON.stringify({username:masterUserName}),generateStringKey:"password",excludeCharacters:"{}'\\*[]()`"}}).secretValueFromJson("password");this.masterUserPassword=internalUserDatabaseEnabled?masterUserPasswordProp??createMasterUserPassword():void 0;const encryptionAtRestEnabled=props.encryptionAtRest?.enabled??(props.encryptionAtRest?.kmsKey!=null||unsignedBasicAuthEnabled),nodeToNodeEncryptionEnabled=props.nodeToNodeEncryption??unsignedBasicAuthEnabled,volumeSize=props.ebs?.volumeSize??10,volumeType=props.ebs?.volumeType??ec2.EbsDeviceVolumeType.GENERAL_PURPOSE_SSD,ebsEnabled=props.ebs?.enabled??!0,enforceHttps=props.enforceHttps??unsignedBasicAuthEnabled;function isInstanceType(t){return dedicatedMasterType.startsWith(t)||instanceType.startsWith(t)}function isSomeInstanceType(...instanceTypes){return instanceTypes.some(isInstanceType)}function isEveryDatanodeInstanceType(...instanceTypes){return instanceTypes.some(t=>instanceType.startsWith(t))}if(elasticsearchVersionNum<5.1){if(props.logging?.appLogEnabled)throw new Error("Error logs publishing requires Elasticsearch version 5.1 or later.");if(props.encryptionAtRest?.enabled)throw new Error("Encryption of data at rest requires Elasticsearch version 5.1 or later.");if(props.cognitoKibanaAuth!=null)throw new Error("Cognito authentication for Kibana requires Elasticsearch version 5.1 or later.");if(isSomeInstanceType("c5","i3","m5","r5"))throw new Error("C5, I3, M5, and R5 instance types require Elasticsearch version 5.1 or later.")}if(elasticsearchVersionNum<6&&props.nodeToNodeEncryption)throw new Error("Node-to-node encryption requires Elasticsearch version 6.0 or later.");if(elasticsearchVersionNum<6.7){if(unsignedBasicAuthEnabled)throw new Error("Using unsigned basic auth requires Elasticsearch version 6.7 or later.");if(advancedSecurityEnabled)throw new Error("Fine-grained access control requires Elasticsearch version 6.7 or later.")}if(elasticsearchVersionNum<6.8&&warmEnabled)throw new Error("UltraWarm requires Elasticsearch 6.8 or later.");if(isSomeInstanceType("i3","r6gd")&&ebsEnabled)throw new Error("I3 and R6GD instance types do not support EBS storage volumes.");if(isSomeInstanceType("m3","r3","t2")&&encryptionAtRestEnabled)throw new Error("M3, R3, and T2 instance types do not support encryption of data at rest.");if(isInstanceType("t2.micro")&&elasticsearchVersionNum>2.3)throw new Error("The t2.micro.elasticsearch instance type supports only Elasticsearch 1.5 and 2.3.");if(isSomeInstanceType("t2","t3")&&warmEnabled)throw new Error("T2 and T3 instance types do not support UltraWarm storage.");if(!ebsEnabled&&!isEveryDatanodeInstanceType("r3","i3","r6gd"))throw new Error("EBS volumes are required when using instance types other than r3, i3 or r6gd.");if(advancedSecurityEnabled){if(!nodeToNodeEncryptionEnabled)throw new Error("Node-to-node encryption is required when fine-grained access control is enabled.");if(!encryptionAtRestEnabled)throw new Error("Encryption-at-rest is required when fine-grained access control is enabled.");if(!enforceHttps)throw new Error("Enforce HTTPS is required when fine-grained access control is enabled.")}if(props.logging?.auditLogEnabled&&!advancedSecurityEnabled)throw new Error("Fine-grained access control is required when audit logs publishing is enabled.");if(warmEnabled&&!dedicatedMasterEnabled)throw new Error("Dedicated master node is required when UltraWarm storage is enabled.");let cfnVpcOptions;securityGroups&&subnets&&(cfnVpcOptions={securityGroupIds:securityGroups.map(sg=>sg.securityGroupId),subnetIds:subnets.map(subnet=>subnet.subnetId)});const logGroups=[];props.logging?.slowSearchLogEnabled&&(this.slowSearchLogGroup=props.logging.slowSearchLogGroup??new logs.LogGroup(this,"SlowSearchLogs",{retention:logs.RetentionDays.ONE_MONTH}),logGroups.push(this.slowSearchLogGroup)),props.logging?.slowIndexLogEnabled&&(this.slowIndexLogGroup=props.logging.slowIndexLogGroup??new logs.LogGroup(this,"SlowIndexLogs",{retention:logs.RetentionDays.ONE_MONTH}),logGroups.push(this.slowIndexLogGroup)),props.logging?.appLogEnabled&&(this.appLogGroup=props.logging.appLogGroup??new logs.LogGroup(this,"AppLogs",{retention:logs.RetentionDays.ONE_MONTH}),logGroups.push(this.appLogGroup)),props.logging?.auditLogEnabled&&(this.auditLogGroup=props.logging.auditLogGroup??new logs.LogGroup(this,"AuditLogs",{retention:logs.RetentionDays.ONE_MONTH}),logGroups.push(this.auditLogGroup));let logGroupResourcePolicy=null;if(logGroups.length>0){const logPolicyStatement=new iam.PolicyStatement({effect:iam.Effect.ALLOW,actions:["logs:PutLogEvents","logs:CreateLogStream"],resources:logGroups.map(lg=>lg.logGroupArn),principals:[new iam.ServicePrincipal("es.amazonaws.com")]});logGroupResourcePolicy=new log_group_resource_policy_1.LogGroupResourcePolicy(this,`ESLogGroupPolicy${this.node.addr}`,{policyName:`ESLogPolicy${this.node.addr}`,policyStatements:[logPolicyStatement]})}const logPublishing={};this.appLogGroup&&(logPublishing.ES_APPLICATION_LOGS={enabled:!0,cloudWatchLogsLogGroupArn:this.appLogGroup.logGroupArn}),this.slowSearchLogGroup&&(logPublishing.SEARCH_SLOW_LOGS={enabled:!0,cloudWatchLogsLogGroupArn:this.slowSearchLogGroup.logGroupArn}),this.slowIndexLogGroup&&(logPublishing.INDEX_SLOW_LOGS={enabled:!0,cloudWatchLogsLogGroupArn:this.slowIndexLogGroup.logGroupArn}),this.auditLogGroup&&(logPublishing.AUDIT_LOGS={enabled:this.auditLogGroup!=null,cloudWatchLogsLogGroupArn:this.auditLogGroup?.logGroupArn});let customEndpointCertificate;if(props.customEndpoint&&(props.customEndpoint.certificate?customEndpointCertificate=props.customEndpoint.certificate:customEndpointCertificate=new acm.Certificate(this,"CustomEndpointCertificate",{domainName:props.customEndpoint.domainName,validation:props.customEndpoint.hostedZone?acm.CertificateValidation.fromDns(props.customEndpoint.hostedZone):void 0})),this.domain=new elasticsearch_generated_1.CfnDomain(this,"Resource",{domainName:this.physicalName,elasticsearchVersion,elasticsearchClusterConfig:{dedicatedMasterEnabled,dedicatedMasterCount:dedicatedMasterEnabled?dedicatedMasterCount:void 0,dedicatedMasterType:dedicatedMasterEnabled?dedicatedMasterType:void 0,instanceCount,instanceType,warmEnabled:warmEnabled||void 0,warmCount:warmEnabled?warmCount:void 0,warmType:warmEnabled?warmType:void 0,zoneAwarenessEnabled,zoneAwarenessConfig:zoneAwarenessEnabled?{availabilityZoneCount}:void 0},ebsOptions:{ebsEnabled,volumeSize:ebsEnabled?volumeSize:void 0,volumeType:ebsEnabled?volumeType:void 0,iops:ebsEnabled?props.ebs?.iops:void 0},encryptionAtRestOptions:{enabled:encryptionAtRestEnabled,kmsKeyId:encryptionAtRestEnabled?props.encryptionAtRest?.kmsKey?.keyId:void 0},nodeToNodeEncryptionOptions:{enabled:nodeToNodeEncryptionEnabled},logPublishingOptions:logPublishing,cognitoOptions:{enabled:props.cognitoKibanaAuth!=null,identityPoolId:props.cognitoKibanaAuth?.identityPoolId,roleArn:props.cognitoKibanaAuth?.role.roleArn,userPoolId:props.cognitoKibanaAuth?.userPoolId},vpcOptions:cfnVpcOptions,snapshotOptions:props.automatedSnapshotStartHour?{automatedSnapshotStartHour:props.automatedSnapshotStartHour}:void 0,domainEndpointOptions:{enforceHttps,tlsSecurityPolicy:props.tlsSecurityPolicy??TLSSecurityPolicy.TLS_1_0,...props.customEndpoint&&{customEndpointEnabled:!0,customEndpoint:props.customEndpoint.domainName,customEndpointCertificateArn:customEndpointCertificate.certificateArn}},advancedSecurityOptions:advancedSecurityEnabled?{enabled:!0,internalUserDatabaseEnabled,masterUserOptions:{masterUserArn,masterUserName,masterUserPassword:this.masterUserPassword?.unsafeUnwrap()}}:void 0,advancedOptions:props.advancedOptions}),this.domain.applyRemovalPolicy(props.removalPolicy),props.enableVersionUpgrade&&(this.domain.cfnOptions.updatePolicy={...this.domain.cfnOptions.updatePolicy,enableVersionUpgrade:props.enableVersionUpgrade}),logGroupResourcePolicy&&this.domain.node.addDependency(logGroupResourcePolicy),props.domainName){if(!cdk.Token.isUnresolved(props.domainName)){if(!props.domainName.match(/^[a-z0-9\-]+$/))throw new Error(`Invalid domainName '${props.domainName}'. Valid characters are a-z (lowercase only), 0-9, and \u2013 (hyphen).`);if(props.domainName.length<3||props.domainName.length>28)throw new Error(`Invalid domainName '${props.domainName}'. It must be between 3 and 28 characters`);if(props.domainName[0]<"a"||props.domainName[0]>"z")throw new Error(`Invalid domainName '${props.domainName}'. It must start with a lowercase letter`)}this.node.addMetadata("aws:cdk:hasPhysicalName",props.domainName)}this.domainName=this.getResourceNameAttribute(this.domain.ref),this.domainEndpoint=this.domain.getAtt("DomainEndpoint").toString(),this.domainArn=this.getResourceArnAttribute(this.domain.attrArn,{service:"es",resource:"domain",resourceName:this.physicalName}),props.customEndpoint?.hostedZone&&new route53.CnameRecord(this,"CnameRecord",{recordName:props.customEndpoint.domainName,zone:props.customEndpoint.hostedZone,domainName:this.domainEndpoint}),this.encryptionAtRestOptions=props.encryptionAtRest,props.accessPolicies&&this.addAccessPolicies(...props.accessPolicies),unsignedBasicAuthEnabled&&this.addAccessPolicies(unsignedAccessPolicy)}static fromDomainEndpoint(scope,id,domainEndpoint){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticsearch.Domain#fromDomainEndpoint","use opensearchservice module instead")}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromDomainEndpoint),error}const stack=cdk.Stack.of(scope),domainName=extractNameFromEndpoint(domainEndpoint),domainArn=stack.formatArn({service:"es",resource:"domain",resourceName:domainName});return Domain.fromDomainAttributes(scope,id,{domainArn,domainEndpoint})}static fromDomainAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticsearch.Domain#fromDomainAttributes","use opensearchservice module instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticsearch_DomainAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromDomainAttributes),error}const{domainArn,domainEndpoint}=attrs,domainName=cdk.Stack.of(scope).splitArn(domainArn,cdk.ArnFormat.SLASH_RESOURCE_NAME).resourceName??extractNameFromEndpoint(domainEndpoint);return new class extends DomainBase{constructor(){super(scope,id),this.domainArn=domainArn,this.domainName=domainName,this.domainEndpoint=domainEndpoint.replace(/^https?:\/\//,"")}}}get connections(){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticsearch.Domain#connections","use opensearchservice module instead")}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,jsiiDeprecationWarnings.getPropertyDescriptor(this,"connections").get),error}if(!this._connections)throw new Error("Connections are only available on VPC enabled domains. Use the 'vpc' property to place a domain inside a VPC");return this._connections}addAccessPolicies(...accessPolicyStatements){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticsearch.Domain#addAccessPolicies","use opensearchservice module instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_PolicyStatement(accessPolicyStatements)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addAccessPolicies),error}accessPolicyStatements.length>0&&(this.accessPolicy?this.accessPolicy.addAccessPolicies(...accessPolicyStatements):(this.accessPolicy=new elasticsearch_access_policy_1.ElasticsearchAccessPolicy(this,"ESAccessPolicy",{domainName:this.domainName,domainArn:this.domainArn,accessPolicies:accessPolicyStatements}),this.encryptionAtRestOptions?.kmsKey&&this.accessPolicy.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({actions:["kms:List*","kms:Describe*","kms:CreateGrant"],resources:[this.encryptionAtRestOptions.kmsKey.keyArn],effect:iam.Effect.ALLOW}))))}}exports.Domain=Domain,_b=JSII_RTTI_SYMBOL_1,Domain[_b]={fqn:"aws-cdk-lib.aws_elasticsearch.Domain",version:"2.69.0"};function extractNameFromEndpoint(domainEndpoint){const{hostname}=new url_1.URL(domainEndpoint),domain=hostname.split(".")[0],suffix="-"+domain.split("-").slice(-1)[0];return domain.split(suffix)[0]}function parseVersion(version){const versionStr=version.version,firstDot=versionStr.indexOf(".");if(firstDot<1)throw new Error(`Invalid Elasticsearch version: ${versionStr}. Version string needs to start with major and minor version (x.y).`);const secondDot=versionStr.indexOf(".",firstDot+1);try{return secondDot==-1?parseFloat(versionStr):parseFloat(versionStr.substring(0,secondDot))}catch{throw new Error(`Invalid Elasticsearch version: ${versionStr}. Version string needs to start with major and minor version (x.y).`)}}function selectSubnets(vpc,vpcSubnets){const selected=[];for(const selection of vpcSubnets)selected.push(...vpc.selectSubnets(selection).subnets);return selected}function initializeInstanceType(defaultInstanceType,instanceType){return instanceType?cdk.Token.isUnresolved(instanceType)?instanceType:instanceType.toLowerCase():defaultInstanceType}
