"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.StepScalingPolicy=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),aws_autoscaling_common_1=require("../../aws-autoscaling-common"),cloudwatch=require("../../aws-cloudwatch"),constructs_1=require("constructs"),step_scaling_action_1=require("./step-scaling-action");class StepScalingPolicy extends constructs_1.Construct{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_applicationautoscaling_StepScalingPolicyProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,StepScalingPolicy),error}if(props.scalingSteps.length<2)throw new Error("You must supply at least 2 intervals for autoscaling");if(props.datapointsToAlarm!==void 0&&props.datapointsToAlarm<1)throw new RangeError(`datapointsToAlarm cannot be less than 1, got: ${props.datapointsToAlarm}`);const adjustmentType=props.adjustmentType||step_scaling_action_1.AdjustmentType.CHANGE_IN_CAPACITY,changesAreAbsolute=adjustmentType===step_scaling_action_1.AdjustmentType.EXACT_CAPACITY,intervals=aws_autoscaling_common_1.normalizeIntervals(props.scalingSteps,changesAreAbsolute),alarms=aws_autoscaling_common_1.findAlarmThresholds(intervals);if(alarms.lowerAlarmIntervalIndex!==void 0){const threshold=intervals[alarms.lowerAlarmIntervalIndex].upper;this.lowerAction=new step_scaling_action_1.StepScalingAction(this,"LowerPolicy",{adjustmentType,cooldown:props.cooldown,metricAggregationType:props.metricAggregationType??aggregationTypeFromMetric(props.metric),minAdjustmentMagnitude:props.minAdjustmentMagnitude,scalingTarget:props.scalingTarget});for(let i=alarms.lowerAlarmIntervalIndex;i>=0;i--)this.lowerAction.addAdjustment({adjustment:intervals[i].change,lowerBound:i!==0?intervals[i].lower-threshold:void 0,upperBound:intervals[i].upper-threshold});this.lowerAlarm=new cloudwatch.Alarm(this,"LowerAlarm",{metric:props.metric,alarmDescription:"Lower threshold scaling alarm",comparisonOperator:cloudwatch.ComparisonOperator.LESS_THAN_OR_EQUAL_TO_THRESHOLD,evaluationPeriods:props.evaluationPeriods??1,datapointsToAlarm:props.datapointsToAlarm,threshold}),this.lowerAlarm.addAlarmAction(new StepScalingAlarmAction(this.lowerAction))}if(alarms.upperAlarmIntervalIndex!==void 0){const threshold=intervals[alarms.upperAlarmIntervalIndex].lower;this.upperAction=new step_scaling_action_1.StepScalingAction(this,"UpperPolicy",{adjustmentType,cooldown:props.cooldown,metricAggregationType:props.metricAggregationType??aggregationTypeFromMetric(props.metric),minAdjustmentMagnitude:props.minAdjustmentMagnitude,scalingTarget:props.scalingTarget});for(let i=alarms.upperAlarmIntervalIndex;i<intervals.length;i++)this.upperAction.addAdjustment({adjustment:intervals[i].change,lowerBound:intervals[i].lower-threshold,upperBound:i!==intervals.length-1?intervals[i].upper-threshold:void 0});this.upperAlarm=new cloudwatch.Alarm(this,"UpperAlarm",{metric:props.metric,alarmDescription:"Upper threshold scaling alarm",comparisonOperator:cloudwatch.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,evaluationPeriods:props.evaluationPeriods??1,datapointsToAlarm:props.datapointsToAlarm,threshold}),this.upperAlarm.addAlarmAction(new StepScalingAlarmAction(this.upperAction))}}}exports.StepScalingPolicy=StepScalingPolicy,_a=JSII_RTTI_SYMBOL_1,StepScalingPolicy[_a]={fqn:"aws-cdk-lib.aws_applicationautoscaling.StepScalingPolicy",version:"2.69.0"};function aggregationTypeFromMetric(metric){const statistic=metric.toMetricConfig().metricStat?.statistic;if(statistic!=null)switch(statistic){case"Average":return step_scaling_action_1.MetricAggregationType.AVERAGE;case"Minimum":return step_scaling_action_1.MetricAggregationType.MINIMUM;case"Maximum":return step_scaling_action_1.MetricAggregationType.MAXIMUM;default:return step_scaling_action_1.MetricAggregationType.AVERAGE}}class StepScalingAlarmAction{constructor(stepScalingAction){this.stepScalingAction=stepScalingAction}bind(_scope,_alarm){return{alarmActionArn:this.stepScalingAction.scalingPolicyArn}}}
