"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.StateMachine=exports.LogLevel=exports.StateMachineType=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cloudwatch=require("../../aws-cloudwatch"),iam=require("../../aws-iam"),core_1=require("../../core"),state_graph_1=require("./state-graph"),stepfunctions_canned_metrics_generated_1=require("./stepfunctions-canned-metrics.generated"),stepfunctions_generated_1=require("./stepfunctions.generated");var StateMachineType;(function(StateMachineType2){StateMachineType2.EXPRESS="EXPRESS",StateMachineType2.STANDARD="STANDARD"})(StateMachineType=exports.StateMachineType||(exports.StateMachineType={}));var LogLevel;(function(LogLevel2){LogLevel2.OFF="OFF",LogLevel2.ALL="ALL",LogLevel2.ERROR="ERROR",LogLevel2.FATAL="FATAL"})(LogLevel=exports.LogLevel||(exports.LogLevel={}));class StateMachineBase extends core_1.Resource{static fromStateMachineArn(scope,id,stateMachineArn){class Import extends StateMachineBase{constructor(){super(...arguments),this.stateMachineArn=stateMachineArn,this.grantPrincipal=new iam.UnknownPrincipal({resource:this})}}return new Import(scope,id,{environmentFromArn:stateMachineArn})}static fromStateMachineName(scope,id,stateMachineName){const stateMachineArn=core_1.Stack.of(scope).formatArn({service:"states",resource:"stateMachine",arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME,resourceName:stateMachineName});return this.fromStateMachineArn(scope,id,stateMachineArn)}grantStartExecution(identity){return iam.Grant.addToPrincipal({grantee:identity,actions:["states:StartExecution"],resourceArns:[this.stateMachineArn]})}grantStartSyncExecution(identity){return iam.Grant.addToPrincipal({grantee:identity,actions:["states:StartSyncExecution"],resourceArns:[this.stateMachineArn]})}grantRead(identity){return iam.Grant.addToPrincipal({grantee:identity,actions:["states:ListExecutions","states:ListStateMachines"],resourceArns:[this.stateMachineArn]}),iam.Grant.addToPrincipal({grantee:identity,actions:["states:DescribeExecution","states:DescribeStateMachineForExecution","states:GetExecutionHistory"],resourceArns:[`${this.executionArn()}:*`]}),iam.Grant.addToPrincipal({grantee:identity,actions:["states:ListActivities","states:DescribeStateMachine","states:DescribeActivity"],resourceArns:["*"]})}grantTaskResponse(identity){return iam.Grant.addToPrincipal({grantee:identity,actions:["states:SendTaskSuccess","states:SendTaskFailure","states:SendTaskHeartbeat"],resourceArns:[this.stateMachineArn]})}grantExecution(identity,...actions){return iam.Grant.addToPrincipal({grantee:identity,actions,resourceArns:[`${this.executionArn()}:*`]})}grant(identity,...actions){return iam.Grant.addToPrincipal({grantee:identity,actions,resourceArns:[this.stateMachineArn]})}metric(metricName,props){return new cloudwatch.Metric({namespace:"AWS/States",metricName,dimensionsMap:{StateMachineArn:this.stateMachineArn},statistic:"sum",...props}).attachTo(this)}metricFailed(props){return this.cannedMetric(stepfunctions_canned_metrics_generated_1.StatesMetrics.executionsFailedSum,props)}metricThrottled(props){return this.metric("ExecutionThrottled",props)}metricAborted(props){return this.cannedMetric(stepfunctions_canned_metrics_generated_1.StatesMetrics.executionsAbortedSum,props)}metricSucceeded(props){return this.cannedMetric(stepfunctions_canned_metrics_generated_1.StatesMetrics.executionsSucceededSum,props)}metricTimedOut(props){return this.cannedMetric(stepfunctions_canned_metrics_generated_1.StatesMetrics.executionsTimedOutSum,props)}metricStarted(props){return this.metric("ExecutionsStarted",props)}metricTime(props){return this.cannedMetric(stepfunctions_canned_metrics_generated_1.StatesMetrics.executionTimeAverage,props)}executionArn(){return core_1.Stack.of(this).formatArn({resource:"execution",service:"states",resourceName:core_1.Arn.split(this.stateMachineArn,core_1.ArnFormat.COLON_RESOURCE_NAME).resourceName,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME})}cannedMetric(fn,props){return new cloudwatch.Metric({...fn({StateMachineArn:this.stateMachineArn}),...props}).attachTo(this)}}class StateMachine extends StateMachineBase{constructor(scope,id,props){super(scope,id,{physicalName:props.stateMachineName});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_StateMachineProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,StateMachine),error}props.stateMachineName!==void 0&&this.validateStateMachineName(props.stateMachineName),this.role=props.role||new iam.Role(this,"Role",{assumedBy:new iam.ServicePrincipal("states.amazonaws.com")});const graph=new state_graph_1.StateGraph(props.definition.startState,`State Machine ${id} definition`);graph.timeout=props.timeout,this.stateMachineType=props.stateMachineType??StateMachineType.STANDARD;const resource=new stepfunctions_generated_1.CfnStateMachine(this,"Resource",{stateMachineName:this.physicalName,stateMachineType:props.stateMachineType??void 0,roleArn:this.role.roleArn,definitionString:core_1.Stack.of(this).toJsonString(graph.toGraphJson()),loggingConfiguration:props.logs?this.buildLoggingConfiguration(props.logs):void 0,tracingConfiguration:props.tracingEnabled?this.buildTracingConfiguration():void 0});resource.applyRemovalPolicy(props.removalPolicy,{default:core_1.RemovalPolicy.DESTROY}),resource.node.addDependency(this.role);for(const statement of graph.policyStatements)this.addToRolePolicy(statement);this.stateMachineName=this.getResourceNameAttribute(resource.attrName),this.stateMachineArn=this.getResourceArnAttribute(resource.ref,{service:"states",resource:"stateMachine",resourceName:this.physicalName,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME})}get grantPrincipal(){return this.role.grantPrincipal}addToRolePolicy(statement){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addToRolePolicy),error}this.role.addToPrincipalPolicy(statement)}validateStateMachineName(stateMachineName){if(!core_1.Token.isUnresolved(stateMachineName)){if(stateMachineName.length<1||stateMachineName.length>80)throw new Error(`State Machine name must be between 1 and 80 characters. Received: ${stateMachineName}`);if(!stateMachineName.match(/^[a-z0-9\+\!\@\.\(\)\-\=\_\']+$/i))throw new Error(`State Machine name must match "^[a-z0-9+!@.()-=_']+$/i". Received: ${stateMachineName}`)}}buildLoggingConfiguration(logOptions){return this.addToRolePolicy(new iam.PolicyStatement({effect:iam.Effect.ALLOW,actions:["logs:CreateLogDelivery","logs:GetLogDelivery","logs:UpdateLogDelivery","logs:DeleteLogDelivery","logs:ListLogDeliveries","logs:PutResourcePolicy","logs:DescribeResourcePolicies","logs:DescribeLogGroups"],resources:["*"]})),{destinations:[{cloudWatchLogsLogGroup:{logGroupArn:logOptions.destination.logGroupArn}}],includeExecutionData:logOptions.includeExecutionData,level:logOptions.level||"ERROR"}}buildTracingConfiguration(){return this.addToRolePolicy(new iam.PolicyStatement({actions:["xray:PutTraceSegments","xray:PutTelemetryRecords","xray:GetSamplingRules","xray:GetSamplingTargets"],resources:["*"]})),{enabled:!0}}}exports.StateMachine=StateMachine,_a=JSII_RTTI_SYMBOL_1,StateMachine[_a]={fqn:"aws-cdk-lib.aws_stepfunctions.StateMachine",version:"2.69.0"};
