"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.ServerlessClusterFromSnapshot=exports.ServerlessCluster=exports.AuroraCapacityUnit=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),ec2=require("../../aws-ec2"),iam=require("../../aws-iam"),secretsmanager=require("../../aws-secretsmanager"),core_1=require("../../core"),cxapi=require("../../cx-api"),database_secret_1=require("./database-secret"),endpoint_1=require("./endpoint"),perms_1=require("./perms"),util_1=require("./private/util"),rds_generated_1=require("./rds.generated"),subnet_group_1=require("./subnet-group");var AuroraCapacityUnit;(function(AuroraCapacityUnit2){AuroraCapacityUnit2[AuroraCapacityUnit2.ACU_1=1]="ACU_1",AuroraCapacityUnit2[AuroraCapacityUnit2.ACU_2=2]="ACU_2",AuroraCapacityUnit2[AuroraCapacityUnit2.ACU_4=4]="ACU_4",AuroraCapacityUnit2[AuroraCapacityUnit2.ACU_8=8]="ACU_8",AuroraCapacityUnit2[AuroraCapacityUnit2.ACU_16=16]="ACU_16",AuroraCapacityUnit2[AuroraCapacityUnit2.ACU_32=32]="ACU_32",AuroraCapacityUnit2[AuroraCapacityUnit2.ACU_64=64]="ACU_64",AuroraCapacityUnit2[AuroraCapacityUnit2.ACU_128=128]="ACU_128",AuroraCapacityUnit2[AuroraCapacityUnit2.ACU_192=192]="ACU_192",AuroraCapacityUnit2[AuroraCapacityUnit2.ACU_256=256]="ACU_256",AuroraCapacityUnit2[AuroraCapacityUnit2.ACU_384=384]="ACU_384"})(AuroraCapacityUnit=exports.AuroraCapacityUnit||(exports.AuroraCapacityUnit={}));class ServerlessClusterBase extends core_1.Resource{get clusterArn(){return core_1.Stack.of(this).formatArn({service:"rds",resource:"cluster",arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME,resourceName:this.clusterIdentifier})}grantDataApiAccess(grantee){if(this.enableDataApi===!1)throw new Error("Cannot grant Data API access when the Data API is disabled");this.enableDataApi=!0;const ret=iam.Grant.addToPrincipal({grantee,actions:perms_1.DATA_API_ACTIONS,resourceArns:["*"],scope:this});return this.secret?.grantRead(grantee),ret}asSecretAttachmentTarget(){return{targetId:this.clusterIdentifier,targetType:secretsmanager.AttachmentTargetType.RDS_DB_CLUSTER}}}class ServerlessClusterNew extends ServerlessClusterBase{constructor(scope,id,props){if(super(scope,id),props.vpc===void 0){if(props.vpcSubnets!==void 0)throw new Error("A VPC is required to use vpcSubnets in ServerlessCluster. Please add a VPC or remove vpcSubnets");if(props.subnetGroup!==void 0)throw new Error("A VPC is required to use subnetGroup in ServerlessCluster. Please add a VPC or remove subnetGroup");if(props.securityGroups!==void 0)throw new Error("A VPC is required to use securityGroups in ServerlessCluster. Please add a VPC or remove securityGroups")}let subnetGroup=props.subnetGroup;if(this.securityGroups=props.securityGroups??[],props.vpc!==void 0){const{subnetIds}=props.vpc.selectSubnets(props.vpcSubnets);subnetIds.length<2&&core_1.Annotations.of(this).addError(`Cluster requires at least 2 subnets, got ${subnetIds.length}`),subnetGroup=props.subnetGroup??new subnet_group_1.SubnetGroup(this,"Subnets",{description:`Subnets for ${id} database`,vpc:props.vpc,vpcSubnets:props.vpcSubnets,removalPolicy:props.removalPolicy===core_1.RemovalPolicy.RETAIN?props.removalPolicy:void 0}),this.securityGroups=props.securityGroups??[new ec2.SecurityGroup(this,"SecurityGroup",{description:"RDS security group",vpc:props.vpc})]}if(props.backupRetention){const backupRetentionDays=props.backupRetention.toDays();if(backupRetentionDays<1||backupRetentionDays>35)throw new Error(`backup retention period must be between 1 and 35 days. received: ${backupRetentionDays}`)}const clusterEngineBindConfig=props.engine.bindToCluster(this,{parameterGroup:props.parameterGroup}),clusterParameterGroupConfig=(props.parameterGroup??clusterEngineBindConfig.parameterGroup)?.bindToCluster({}),clusterIdentifier=core_1.FeatureFlags.of(this).isEnabled(cxapi.RDS_LOWERCASE_DB_IDENTIFIER)?props.clusterIdentifier?.toLowerCase():props.clusterIdentifier;this.newCfnProps={backupRetentionPeriod:props.backupRetention?.toDays(),databaseName:props.defaultDatabaseName,dbClusterIdentifier:clusterIdentifier,dbClusterParameterGroupName:clusterParameterGroupConfig?.parameterGroupName,dbSubnetGroupName:subnetGroup?.subnetGroupName,deletionProtection:util_1.defaultDeletionProtection(props.deletionProtection,props.removalPolicy),engine:props.engine.engineType,engineVersion:props.engine.engineVersion?.fullVersion,engineMode:"serverless",enableHttpEndpoint:core_1.Lazy.any({produce:()=>this.enableDataApi}),scalingConfiguration:props.scaling?this.renderScalingConfiguration(props.scaling):void 0,storageEncrypted:!0,vpcSecurityGroupIds:this.securityGroups.map(sg=>sg.securityGroupId),copyTagsToSnapshot:props.copyTagsToSnapshot??!0},this.connections=new ec2.Connections({securityGroups:this.securityGroups,defaultPort:ec2.Port.tcp(core_1.Lazy.number({produce:()=>this.clusterEndpoint.port}))})}renderScalingConfiguration(options){const minCapacity=options.minCapacity,maxCapacity=options.maxCapacity;if(minCapacity&&maxCapacity&&minCapacity>maxCapacity)throw new Error("maximum capacity must be greater than or equal to minimum capacity.");const secondsToAutoPause=options.autoPause?.toSeconds();if(secondsToAutoPause&&(secondsToAutoPause<300||secondsToAutoPause>86400))throw new Error("auto pause time must be between 5 minutes and 1 day.");return{autoPause:secondsToAutoPause!==0,minCapacity:options.minCapacity,maxCapacity:options.maxCapacity,secondsUntilAutoPause:secondsToAutoPause===0?void 0:secondsToAutoPause}}}class ServerlessCluster extends ServerlessClusterNew{constructor(scope,id,props){super(scope,id,props);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_ServerlessClusterProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ServerlessCluster),error}this.vpc=props.vpc,this.vpcSubnets=props.vpcSubnets,this.singleUserRotationApplication=props.engine.singleUserRotationApplication,this.multiUserRotationApplication=props.engine.multiUserRotationApplication,this.enableDataApi=props.enableDataApi;const credentials=util_1.renderCredentials(this,props.engine,props.credentials),secret=credentials.secret,cluster=new rds_generated_1.CfnDBCluster(this,"Resource",{...this.newCfnProps,masterUsername:credentials.username,masterUserPassword:credentials.password?.unsafeUnwrap(),kmsKeyId:props.storageEncryptionKey?.keyArn});this.clusterIdentifier=cluster.ref;const portAttribute=core_1.Token.asNumber(cluster.attrEndpointPort);this.clusterEndpoint=new endpoint_1.Endpoint(cluster.attrEndpointAddress,portAttribute),this.clusterReadEndpoint=new endpoint_1.Endpoint(cluster.attrReadEndpointAddress,portAttribute),cluster.applyRemovalPolicy(props.removalPolicy??core_1.RemovalPolicy.SNAPSHOT),secret&&(this.secret=secret.attach(this))}static fromServerlessClusterAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_ServerlessClusterAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromServerlessClusterAttributes),error}return new ImportedServerlessCluster(scope,id,attrs)}addRotationSingleUser(options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_RotationSingleUserOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addRotationSingleUser),error}if(!this.secret)throw new Error("Cannot add single user rotation for a cluster without secret.");if(this.vpc===void 0)throw new Error("Cannot add single user rotation for a cluster without VPC.");const id="RotationSingleUser";if(this.node.tryFindChild(id))throw new Error("A single user rotation was already added to this cluster.");return new secretsmanager.SecretRotation(this,id,{...util_1.applyDefaultRotationOptions(options,this.vpcSubnets),secret:this.secret,application:this.singleUserRotationApplication,vpc:this.vpc,target:this})}addRotationMultiUser(id,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_RotationMultiUserOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addRotationMultiUser),error}if(!this.secret)throw new Error("Cannot add multi user rotation for a cluster without secret.");if(this.vpc===void 0)throw new Error("Cannot add multi user rotation for a cluster without VPC.");return new secretsmanager.SecretRotation(this,id,{...util_1.applyDefaultRotationOptions(options,this.vpcSubnets),secret:options.secret,masterSecret:this.secret,application:this.multiUserRotationApplication,vpc:this.vpc,target:this})}}exports.ServerlessCluster=ServerlessCluster,_a=JSII_RTTI_SYMBOL_1,ServerlessCluster[_a]={fqn:"aws-cdk-lib.aws_rds.ServerlessCluster",version:"2.69.0"};class ImportedServerlessCluster extends ServerlessClusterBase{constructor(scope,id,attrs){super(scope,id),this.enableDataApi=!0,this.clusterIdentifier=attrs.clusterIdentifier;const defaultPort=attrs.port?ec2.Port.tcp(attrs.port):void 0;this.connections=new ec2.Connections({securityGroups:attrs.securityGroups,defaultPort}),this.secret=attrs.secret,this._clusterEndpoint=attrs.clusterEndpointAddress&&attrs.port?new endpoint_1.Endpoint(attrs.clusterEndpointAddress,attrs.port):void 0,this._clusterReadEndpoint=attrs.readerEndpointAddress&&attrs.port?new endpoint_1.Endpoint(attrs.readerEndpointAddress,attrs.port):void 0}get clusterEndpoint(){if(!this._clusterEndpoint)throw new Error("Cannot access `clusterEndpoint` of an imported cluster without an endpoint address and port");return this._clusterEndpoint}get clusterReadEndpoint(){if(!this._clusterReadEndpoint)throw new Error("Cannot access `clusterReadEndpoint` of an imported cluster without a readerEndpointAddress and port");return this._clusterReadEndpoint}}class ServerlessClusterFromSnapshot extends ServerlessClusterNew{constructor(scope,id,props){super(scope,id,props);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_ServerlessClusterFromSnapshotProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ServerlessClusterFromSnapshot),error}this.enableDataApi=props.enableDataApi;let credentials=props.credentials,secret=credentials?.secret;if(!secret&&credentials?.generatePassword){if(!credentials.username)throw new Error("`credentials` `username` must be specified when `generatePassword` is set to true");secret=new database_secret_1.DatabaseSecret(this,"Secret",{username:credentials.username,encryptionKey:credentials.encryptionKey,excludeCharacters:credentials.excludeCharacters,replaceOnPasswordCriteriaChanges:credentials.replaceOnPasswordCriteriaChanges,replicaRegions:credentials.replicaRegions})}const cluster=new rds_generated_1.CfnDBCluster(this,"Resource",{...this.newCfnProps,snapshotIdentifier:props.snapshotIdentifier,masterUserPassword:secret?.secretValueFromJson("password")?.unsafeUnwrap()??credentials?.password?.unsafeUnwrap()});this.clusterIdentifier=cluster.ref;const portAttribute=core_1.Token.asNumber(cluster.attrEndpointPort);this.clusterEndpoint=new endpoint_1.Endpoint(cluster.attrEndpointAddress,portAttribute),this.clusterReadEndpoint=new endpoint_1.Endpoint(cluster.attrReadEndpointAddress,portAttribute),cluster.applyRemovalPolicy(props.removalPolicy??core_1.RemovalPolicy.SNAPSHOT),secret&&(this.secret=secret.attach(this))}}exports.ServerlessClusterFromSnapshot=ServerlessClusterFromSnapshot,_b=JSII_RTTI_SYMBOL_1,ServerlessClusterFromSnapshot[_b]={fqn:"aws-cdk-lib.aws_rds.ServerlessClusterFromSnapshot",version:"2.69.0"};
