"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Nodegroup=exports.TaintEffect=exports.CapacityType=exports.NodegroupAmiType=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),aws_ec2_1=require("../../aws-ec2"),aws_iam_1=require("../../aws-iam"),core_1=require("../../core"),constructs_1=require("constructs"),cluster_1=require("./cluster"),eks_generated_1=require("./eks.generated");var NodegroupAmiType;(function(NodegroupAmiType2){NodegroupAmiType2.AL2_X86_64="AL2_x86_64",NodegroupAmiType2.AL2_X86_64_GPU="AL2_x86_64_GPU",NodegroupAmiType2.AL2_ARM_64="AL2_ARM_64",NodegroupAmiType2.BOTTLEROCKET_ARM_64="BOTTLEROCKET_ARM_64",NodegroupAmiType2.BOTTLEROCKET_X86_64="BOTTLEROCKET_x86_64"})(NodegroupAmiType=exports.NodegroupAmiType||(exports.NodegroupAmiType={}));var CapacityType;(function(CapacityType2){CapacityType2.SPOT="SPOT",CapacityType2.ON_DEMAND="ON_DEMAND"})(CapacityType=exports.CapacityType||(exports.CapacityType={}));var TaintEffect;(function(TaintEffect2){TaintEffect2.NO_SCHEDULE="NO_SCHEDULE",TaintEffect2.PREFER_NO_SCHEDULE="PREFER_NO_SCHEDULE",TaintEffect2.NO_EXECUTE="NO_EXECUTE"})(TaintEffect=exports.TaintEffect||(exports.TaintEffect={}));class Nodegroup extends core_1.Resource{constructor(scope,id,props){super(scope,id,{physicalName:props.nodegroupName});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_eks_NodegroupProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Nodegroup),error}if(this.cluster=props.cluster,this.desiredSize=props.desiredSize??props.minSize??2,this.maxSize=props.maxSize??this.desiredSize,this.minSize=props.minSize??1,core_1.withResolved(this.desiredSize,this.maxSize,(desired,max)=>{if(desired!==void 0&&desired>max)throw new Error(`Desired capacity ${desired} can't be greater than max size ${max}`)}),core_1.withResolved(this.desiredSize,this.minSize,(desired,min)=>{if(desired!==void 0&&desired<min)throw new Error(`Minimum capacity ${min} can't be greater than desired size ${desired}`)}),props.launchTemplateSpec&&props.diskSize)throw new Error("diskSize must be specified within the launch template");if(props.instanceType&&props.instanceTypes)throw new Error('"instanceType is deprecated, please use "instanceTypes" only.');props.instanceType&&core_1.Annotations.of(this).addWarning('"instanceType" is deprecated and will be removed in the next major version. please use "instanceTypes" instead');const instanceTypes=props.instanceTypes??(props.instanceType?[props.instanceType]:void 0);let possibleAmiTypes=[];if(instanceTypes&&instanceTypes.length>0&&(possibleAmiTypes=getPossibleAmiTypes(instanceTypes),props.amiType&&!possibleAmiTypes.includes(props.amiType)))throw new Error(`The specified AMI does not match the instance types architecture, either specify one of ${possibleAmiTypes} or don't specify any`);if(props.nodeRole)this.role=props.nodeRole;else{const ngRole=new aws_iam_1.Role(this,"NodeGroupRole",{assumedBy:new aws_iam_1.ServicePrincipal("ec2.amazonaws.com")});ngRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName("AmazonEKSWorkerNodePolicy")),ngRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName("AmazonEKS_CNI_Policy")),ngRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName("AmazonEC2ContainerRegistryReadOnly")),this.role=ngRole}const resource=new eks_generated_1.CfnNodegroup(this,"Resource",{clusterName:this.cluster.clusterName,nodegroupName:props.nodegroupName,nodeRole:this.role.roleArn,subnets:this.cluster.vpc.selectSubnets(props.subnets).subnetIds,amiType:props.launchTemplateSpec?props.amiType:props.amiType??possibleAmiTypes[0],capacityType:props.capacityType?props.capacityType.valueOf():void 0,diskSize:props.diskSize,forceUpdateEnabled:props.forceUpdate??!0,instanceTypes:instanceTypes?.map(t=>t.toString()),labels:props.labels,taints:props.taints,launchTemplate:props.launchTemplateSpec,releaseVersion:props.releaseVersion,remoteAccess:props.remoteAccess?{ec2SshKey:props.remoteAccess.sshKeyName,sourceSecurityGroups:props.remoteAccess.sourceSecurityGroups?props.remoteAccess.sourceSecurityGroups.map(m=>m.securityGroupId):void 0}:void 0,scalingConfig:{desiredSize:this.desiredSize,maxSize:this.maxSize,minSize:this.minSize},tags:props.tags});this.cluster instanceof cluster_1.Cluster&&(this.cluster.awsAuth.addRoleMapping(this.role,{username:"system:node:{{EC2PrivateDNSName}}",groups:["system:bootstrappers","system:nodes"]}),this.cluster.albController&&constructs_1.Node.of(this.cluster.albController).addDependency(this)),this.nodegroupArn=this.getResourceArnAttribute(resource.attrArn,{service:"eks",resource:"nodegroup",resourceName:this.physicalName}),this.nodegroupName=this.getResourceNameAttribute(resource.ref)}static fromNodegroupName(scope,id,nodegroupName){class Import extends core_1.Resource{constructor(){super(...arguments),this.nodegroupName=nodegroupName}}return new Import(scope,id)}}exports.Nodegroup=Nodegroup,_a=JSII_RTTI_SYMBOL_1,Nodegroup[_a]={fqn:"aws-cdk-lib.aws_eks.Nodegroup",version:"2.69.0"};const arm64AmiTypes=[NodegroupAmiType.AL2_ARM_64,NodegroupAmiType.BOTTLEROCKET_ARM_64],x8664AmiTypes=[NodegroupAmiType.AL2_X86_64,NodegroupAmiType.BOTTLEROCKET_X86_64],gpuAmiTypes=[NodegroupAmiType.AL2_X86_64_GPU];function isGpuInstanceType(instanceType){const instanceTypeComponents=instanceType.toString().match(/^([a-z]+)(\d{1,2})([a-z]*)\.([a-z0-9]+)$/);if(instanceTypeComponents==null)throw new Error("Malformed instance type identifier");const family=instanceTypeComponents[1];return["p","g","inf"].includes(family)}function getPossibleAmiTypes(instanceTypes){function typeToArch(instanceType){return isGpuInstanceType(instanceType)?"GPU":instanceType.architecture}const archAmiMap=new Map([[aws_ec2_1.InstanceArchitecture.ARM_64,arm64AmiTypes],[aws_ec2_1.InstanceArchitecture.X86_64,x8664AmiTypes],["GPU",gpuAmiTypes]]),architectures=new Set(instanceTypes.map(typeToArch));if(architectures.size===0)throw new Error(`Cannot determine any ami type comptaible with instance types: ${instanceTypes.map(i=>i.toString).join(",")}`);if(architectures.size>1)throw new Error("instanceTypes of different architectures is not allowed");return archAmiMap.get(Array.from(architectures)[0])}
