"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.BackupSelection=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),iam=require("../../aws-iam"),core_1=require("../../core"),backup_generated_1=require("./backup.generated"),backupable_resources_collector_1=require("./backupable-resources-collector"),resource_1=require("./resource");class BackupSelection extends core_1.Resource{constructor(scope,id,props){super(scope,id),this.listOfTags=[],this.resources=[],this.backupableResourcesCollector=new backupable_resources_collector_1.BackupableResourcesCollector;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_backup_BackupSelectionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,BackupSelection),error}const role=props.role||new iam.Role(this,"Role",{assumedBy:new iam.ServicePrincipal("backup.amazonaws.com")});role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName("service-role/AWSBackupServiceRolePolicyForBackup")),props.allowRestores&&role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName("service-role/AWSBackupServiceRolePolicyForRestores")),this.grantPrincipal=role;const selection=new backup_generated_1.CfnBackupSelection(this,"Resource",{backupPlanId:props.backupPlan.backupPlanId,backupSelection:{iamRoleArn:role.roleArn,selectionName:props.backupSelectionName||this.node.id,listOfTags:core_1.Lazy.any({produce:()=>this.listOfTags},{omitEmptyArray:!0}),resources:core_1.Lazy.list({produce:()=>[...this.resources,...this.backupableResourcesCollector.resources]},{omitEmpty:!0})}});this.backupPlanId=selection.attrBackupPlanId,this.selectionId=selection.attrSelectionId;for(const resource of props.resources)this.addResource(resource)}addResource(resource){resource.tagCondition&&this.listOfTags.push({conditionKey:resource.tagCondition.key,conditionType:resource.tagCondition.operation||resource_1.TagOperation.STRING_EQUALS,conditionValue:resource.tagCondition.value}),resource.resource&&this.resources.push(resource.resource),resource.construct&&core_1.Aspects.of(resource.construct).add(this.backupableResourcesCollector)}}exports.BackupSelection=BackupSelection,_a=JSII_RTTI_SYMBOL_1,BackupSelection[_a]={fqn:"aws-cdk-lib.aws_backup.BackupSelection",version:"2.69.0"};
