/*!
 * Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  const bokeh = factory();
  bokeh.__bokeh__ = true;
  if (typeof root.Bokeh === "undefined" || typeof root.Bokeh.__bokeh__ === "undefined") {
    root.Bokeh = bokeh;
  }
  const Bokeh = root.Bokeh;
  Bokeh[bokeh.version] = bokeh;
})(this, function() {
  var define;
  var parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
    if (aliases === undefined) aliases = {};
    if (externals === undefined) externals = {};

    var cache = {};

    var normalize = function(name) {
      if (typeof name === "number")
        return name;

      if (name === "bokehjs")
        return entry;

      var prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)

      var alias = aliases[name]
      if (alias != null)
        return alias;

      var trailing = name.length > 0 && name[name.lenght-1] === "/";
      var index = aliases[name + (trailing ? "" : "/") + "index"];
      if (index != null)
        return index;

      return name;
    }

    var require = function(name) {
      var mod = cache[name];
      if (!mod) {
        var id = normalize(name);

        mod = cache[id];
        if (!mod) {
          if (!modules[id]) {
            if (externals[id] === false || (externals[id] == true && parent_require)) {
              try {
                mod = {exports: externals[id] ? parent_require(id) : {}};
                cache[id] = cache[name] = mod;
                return mod.exports;
              } catch (e) {}
            }

            var err = new Error("Cannot find module '" + name + "'");
            err.code = 'MODULE_NOT_FOUND';
            throw err;
          }

          mod = {exports: {}};
          cache[id] = cache[name] = mod;

          function __esModule() {
            Object.defineProperty(mod.exports, "__esModule", {value: true});
          }

          function __esExport(name, value) {
            Object.defineProperty(mod.exports, name, {
              enumerable: true, get: function () { return value; }
            });
          }

          modules[id].call(mod.exports, require, mod, mod.exports, __esModule, __esExport);
        } else {
          cache[name] = mod;
        }
      }

      return mod.exports;
    }
    require.resolve = function(name) {
      return ""
    }

    var main = require(entry);
    main.require = require;

    if (typeof Proxy !== "undefined") {
      // allow Bokeh.loader["@bokehjs/module/name"] syntax
      main.loader = new Proxy({}, {
        get: function(_obj, module) {
          return require(module);
        }
      });
    }

    main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
      if (plugin_aliases === undefined) plugin_aliases = {};
      if (plugin_externals === undefined) plugin_externals = {};

      for (var name in plugin_modules) {
        modules[name] = plugin_modules[name];
      }

      for (var name in plugin_aliases) {
        aliases[name] = plugin_aliases[name];
      }

      for (var name in plugin_externals) {
        externals[name] = plugin_externals[name];
      }

      var plugin = require(plugin_entry);

      for (var name in plugin) {
        main[name] = plugin[name];
      }

      return plugin;
    }

    return main;
  })
([
function _(r,t,_,a,n){a();var o=r(1);r(2),o.__exportStar(r(116),_)},
function _(t,e,n,r,o){r();var a=function(t,e){return(a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n])})(t,e)};function i(t){var e="function"==typeof Symbol&&Symbol.iterator,n=e&&t[e],r=0;if(n)return n.call(t);if(t&&"number"==typeof t.length)return{next:function(){return t&&r>=t.length&&(t=void 0),{value:t&&t[r++],done:!t}}};throw new TypeError(e?"Object is not iterable.":"Symbol.iterator is not defined.")}function c(t,e){var n="function"==typeof Symbol&&t[Symbol.iterator];if(!n)return t;var r,o,a=n.call(t),i=[];try{for(;(void 0===e||e-- >0)&&!(r=a.next()).done;)i.push(r.value)}catch(t){o={error:t}}finally{try{r&&!r.done&&(n=a.return)&&n.call(a)}finally{if(o)throw o.error}}return i}function u(t){return this instanceof u?(this.v=t,this):new u(t)}n.__extends=function(t,e){function n(){this.constructor=t}a(t,e),t.prototype=null===e?Object.create(e):(n.prototype=e.prototype,new n)},n.__assign=function(){return n.__assign=Object.assign||function(t){for(var e,n=1,r=arguments.length;n<r;n++)for(var o in e=arguments[n])Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o]);return t},n.__assign.apply(this,arguments)},n.__rest=function(t,e){var n={};for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&e.indexOf(r)<0&&(n[r]=t[r]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var o=0;for(r=Object.getOwnPropertySymbols(t);o<r.length;o++)e.indexOf(r[o])<0&&Object.prototype.propertyIsEnumerable.call(t,r[o])&&(n[r[o]]=t[r[o]])}return n},n.__decorate=function(t,e,n,r){var o,a=arguments.length,i=a<3?e:null===r?r=Object.getOwnPropertyDescriptor(e,n):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)i=Reflect.decorate(t,e,n,r);else for(var c=t.length-1;c>=0;c--)(o=t[c])&&(i=(a<3?o(i):a>3?o(e,n,i):o(e,n))||i);return a>3&&i&&Object.defineProperty(e,n,i),i},n.__param=function(t,e){return function(n,r){e(n,r,t)}},n.__metadata=function(t,e){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(t,e)},n.__awaiter=function(t,e,n,r){return new(n||(n=Promise))((function(o,a){function i(t){try{u(r.next(t))}catch(t){a(t)}}function c(t){try{u(r.throw(t))}catch(t){a(t)}}function u(t){var e;t.done?o(t.value):(e=t.value,e instanceof n?e:new n((function(t){t(e)}))).then(i,c)}u((r=r.apply(t,e||[])).next())}))},n.__generator=function(t,e){var n,r,o,a,i={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return a={next:c(0),throw:c(1),return:c(2)},"function"==typeof Symbol&&(a[Symbol.iterator]=function(){return this}),a;function c(a){return function(c){return function(a){if(n)throw new TypeError("Generator is already executing.");for(;i;)try{if(n=1,r&&(o=2&a[0]?r.return:a[0]?r.throw||((o=r.return)&&o.call(r),0):r.next)&&!(o=o.call(r,a[1])).done)return o;switch(r=0,o&&(a=[2&a[0],o.value]),a[0]){case 0:case 1:o=a;break;case 4:return i.label++,{value:a[1],done:!1};case 5:i.label++,r=a[1],a=[0];continue;case 7:a=i.ops.pop(),i.trys.pop();continue;default:if(!(o=i.trys,(o=o.length>0&&o[o.length-1])||6!==a[0]&&2!==a[0])){i=0;continue}if(3===a[0]&&(!o||a[1]>o[0]&&a[1]<o[3])){i.label=a[1];break}if(6===a[0]&&i.label<o[1]){i.label=o[1],o=a;break}if(o&&i.label<o[2]){i.label=o[2],i.ops.push(a);break}o[2]&&i.ops.pop(),i.trys.pop();continue}a=e.call(t,i)}catch(t){a=[6,t],r=0}finally{n=o=0}if(5&a[0])throw a[1];return{value:a[0]?a[1]:void 0,done:!0}}([a,c])}}},n.__createBinding=Object.create?function(t,e,n,r){void 0===r&&(r=n),Object.defineProperty(t,r,{enumerable:!0,get:function(){return e[n]}})}:function(t,e,n,r){void 0===r&&(r=n),t[r]=e[n]},n.__exportStar=function(t,e){for(var r in t)"default"===r||Object.prototype.hasOwnProperty.call(e,r)||n.__createBinding(e,t,r)},n.__values=i,n.__read=c,n.__spread=function(){for(var t=[],e=0;e<arguments.length;e++)t=t.concat(c(arguments[e]));return t},n.__spreadArrays=function(){for(var t=0,e=0,n=arguments.length;e<n;e++)t+=arguments[e].length;var r=Array(t),o=0;for(e=0;e<n;e++)for(var a=arguments[e],i=0,c=a.length;i<c;i++,o++)r[o]=a[i];return r},n.__await=u,n.__asyncGenerator=function(t,e,n){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var r,o=n.apply(t,e||[]),a=[];return r={},i("next"),i("throw"),i("return"),r[Symbol.asyncIterator]=function(){return this},r;function i(t){o[t]&&(r[t]=function(e){return new Promise((function(n,r){a.push([t,e,n,r])>1||c(t,e)}))})}function c(t,e){try{(n=o[t](e)).value instanceof u?Promise.resolve(n.value.v).then(f,l):s(a[0][2],n)}catch(t){s(a[0][3],t)}var n}function f(t){c("next",t)}function l(t){c("throw",t)}function s(t,e){t(e),a.shift(),a.length&&c(a[0][0],a[0][1])}},n.__asyncDelegator=function(t){var e,n;return e={},r("next"),r("throw",(function(t){throw t})),r("return"),e[Symbol.iterator]=function(){return this},e;function r(r,o){e[r]=t[r]?function(e){return(n=!n)?{value:u(t[r](e)),done:"return"===r}:o?o(e):e}:o}},n.__asyncValues=function(t){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var e,n=t[Symbol.asyncIterator];return n?n.call(t):(t=i(t),e={},r("next"),r("throw"),r("return"),e[Symbol.asyncIterator]=function(){return this},e);function r(n){e[n]=t[n]&&function(e){return new Promise((function(r,o){(function(t,e,n,r){Promise.resolve(r).then((function(e){t({value:e,done:n})}),e)})(r,o,(e=t[n](e)).done,e.value)}))}}},n.__makeTemplateObject=function(t,e){return Object.defineProperty?Object.defineProperty(t,"raw",{value:e}):t.raw=e,t};var f=Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e};n.__importStar=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var r in t)"default"!==r&&Object.prototype.hasOwnProperty.call(t,r)&&n.__createBinding(e,t,r);return f(e,t),e},n.__importDefault=function(t){return t&&t.__esModule?t:{default:t}},n.__classPrivateFieldGet=function(t,e){if(!e.has(t))throw new TypeError("attempted to get private field on non-instance");return e.get(t)},n.__classPrivateFieldSet=function(t,e,n){if(!e.has(t))throw new TypeError("attempted to set private field on non-instance");return e.set(t,n),n}},
function _(r,t,o,y,e){if(y(),r(3),r(12),r(15),r(18),r(25),r(55),r(58),r(61),r(64),r(100),r(107),r(113),r(114),void 0===Object.is&&(Object.is=function(r,t){return r===t?0!==r||1/r==1/t:r!=r&&t!=t}),void 0===Object.values&&(Object.values=function(r){return Object.keys(r).map((function(t){return r[t]}))}),void 0===Uint8Array.prototype.fill&&(Uint8Array.prototype.fill=Array.prototype.fill,Int8Array.prototype.fill=Array.prototype.fill,Uint16Array.prototype.fill=Array.prototype.fill,Int16Array.prototype.fill=Array.prototype.fill,Uint32Array.prototype.fill=Array.prototype.fill,Int32Array.prototype.fill=Array.prototype.fill,Float32Array.prototype.fill=Array.prototype.fill,Float64Array.prototype.fill=Array.prototype.fill),void 0===Array.prototype[Symbol.iterator]){function p(){var r=0,t=this;return{next:function(){var o=t.length<=r;return{value:o?void 0:t[r++],done:o}}}}!function(){arguments.constructor.prototype[Symbol.iterator]=p,Array.prototype[Symbol.iterator]=p,Uint8Array.prototype[Symbol.iterator]=p,Int8Array.prototype[Symbol.iterator]=p,Uint16Array.prototype[Symbol.iterator]=p,Int16Array.prototype[Symbol.iterator]=p,Uint32Array.prototype[Symbol.iterator]=p,Int32Array.prototype[Symbol.iterator]=p,Float32Array.prototype[Symbol.iterator]=p,Float64Array.prototype[Symbol.iterator]=p}()}"undefined"!=typeof CanvasPixelArray&&(CanvasPixelArray.prototype.set=function(r){for(var t=0;t<this.length;t++)this[t]=r[t]})},
function _(e,n,a,b,i){e(4)()||Object.defineProperty(Object,"assign",{value:e(5),configurable:!0,enumerable:!1,writable:!0})},
function _(r,t,o,a,n){t.exports=function(){var r,t=Object.assign;return"function"==typeof t&&(t(r={foo:"raz"},{bar:"dwa"},{trzy:"trzy"}),r.foo+r.bar+r.trzy==="razdwatrzy")}},
function _(t,r,n,o,c){var a=t(6),f=t(11),h=Math.max;r.exports=function(t,r){var n,o,c,i=h(arguments.length,2);for(t=Object(f(t)),c=function(o){try{t[o]=r[o]}catch(t){n||(n=t)}},o=1;o<i;++o)a(r=arguments[o]).forEach(c);if(void 0!==n)throw n;return t}},
function _(e,t,c,n,o){t.exports=e(7)()?Object.keys:e(8)},
function _(t,r,e,n,c){r.exports=function(){try{return Object.keys("primitive"),!0}catch(t){return!1}}},
function _(t,e,n,c,r){var o=t(9),u=Object.keys;e.exports=function(t){return u(o(t)?Object(t):t)}},
function _(n,r,t,u,o){var c=n(10)();r.exports=function(n){return n!==c&&null!==n}},
function _(n,o,t,c,f){o.exports=function(){}},
function _(n,r,e,o,t){var u=n(9);r.exports=function(n){if(!u(n))throw new TypeError("Cannot use null or undefined");return n}},
function _(e,n,r,t,b){e(13)()||Object.defineProperty(Object,"entries",{value:e(14),configurable:!0,enumerable:!1,writable:!0})},
function _(t,n,o,r,e){n.exports=function(){try{return"foo"===Object.entries({foo:12})[0][0]}catch(t){return!1}}},
function _(r,n,e,t,a){var o=r(11);n.exports=function(r){o(r);var n=[];for(var e in r=Object(r))propertyIsEnumerable.call(r,e)&&n.push([e,r[e]]);return n}},
function _(e,r,n,b,i){e(16)()||Object.defineProperty(Number,"isInteger",{value:e(17),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,e,r,o){t.exports=function(){var n=Number.isInteger;return"function"==typeof n&&(!n("23")&&n(34)&&!n(32.34))}},
function _(n,t,e,o,r){t.exports=function(n){return"number"==typeof n&&n%1==0}},
function _(e,r,t,n,a){e(19)()||Object.defineProperty(String.prototype,"repeat",{value:e(20),configurable:!0,enumerable:!1,writable:!0})},
function _(o,f,t,e,n){f.exports=function(){return"function"==typeof"foo".repeat&&"foofoo"==="foo".repeat(2)}},
function _(r,n,t,o,e){var i=r(11),u=r(21);n.exports=function(r){var n,t=String(i(this));if((r=u(r))<0)throw new RangeError("Count must be >= 0");if(!isFinite(r))throw new RangeError("Count must be < ∞");for(n="";r;)r%2&&(n+=t),r>1&&(t+=t),r>>=1;return n}},
function _(t,i,n,r,a){var o=t(22),e=Math.abs,s=Math.floor;i.exports=function(t){return isNaN(t)?0:0!==(t=Number(t))&&isFinite(t)?o(t)*s(e(t)):t}},
function _(n,t,i,o,s){t.exports=n(23)()?Math.sign:n(24)},
function _(n,t,o,f,i){t.exports=function(){var n=Math.sign;return"function"==typeof n&&(1===n(10)&&-1===n(-20))}},
function _(n,r,t,u,e){r.exports=function(n){return n=Number(n),isNaN(n)||0===n?n:n>0?1:-1}},
function _(e,r,a,n,b){e(26)()||Object.defineProperty(Array,"from",{value:e(27),configurable:!0,enumerable:!1,writable:!0})},
function _(n,o,r,a,t){o.exports=function(){var n,o,r=Array.from;return"function"==typeof r&&(o=r(n=["raz","dwa"]),Boolean(o&&o!==n&&"dwa"===o[1]))}},
function _(e,l,r,n,t){var a=e(28).iterator,i=e(50),u=e(51),o=e(52),f=e(53),c=e(11),v=e(9),h=e(54),y=Array.isArray,s=Function.prototype.call,A={configurable:!0,enumerable:!0,writable:!0,value:null},g=Object.defineProperty;l.exports=function(e){var l,r,n,t,p,w,b,d,x,j,O=arguments[1],m=arguments[2];if(e=Object(c(e)),v(O)&&f(O),this&&this!==Array&&u(this))l=this;else{if(!O){if(i(e))return 1!==(p=e.length)?Array.apply(null,e):((t=new Array(1))[0]=e[0],t);if(y(e)){for(t=new Array(p=e.length),r=0;r<p;++r)t[r]=e[r];return t}}t=[]}if(!y(e))if(void 0!==(x=e[a])){for(b=f(x).call(e),l&&(t=new l),d=b.next(),r=0;!d.done;)j=O?s.call(O,m,d.value,r):d.value,l?(A.value=j,g(t,r,A)):t[r]=j,d=b.next(),++r;p=r}else if(h(e)){for(p=e.length,l&&(t=new l),r=0,n=0;r<p;++r)j=e[r],r+1<p&&(w=j.charCodeAt(0))>=55296&&w<=56319&&(j+=e[++r]),j=O?s.call(O,m,j,n):j,l?(A.value=j,g(t,n,A)):t[n]=j,++n;p=n}if(void 0===p)for(p=o(e.length),l&&(t=new l(p)),r=0;r<p;++r)j=O?s.call(O,m,e[r],r):e[r],l?(A.value=j,g(t,r,A)):t[r]=j;return l&&(A.value=null,t.length=p),t}},
function _(o,n,t,b,c){n.exports=o(29)()?o(30).Symbol:o(33)},
function _(t,o,r,e,n){var i=t(30),f={object:!0,symbol:!0};o.exports=function(){var t,o=i.Symbol;if("function"!=typeof o)return!1;t=o("test symbol");try{String(t)}catch(t){return!1}return!!f[typeof o.iterator]&&(!!f[typeof o.toPrimitive]&&!!f[typeof o.toStringTag])}},
function _(o,i,l,n,s){i.exports=o(31)()?globalThis:o(32)},
function _(o,r,l,t,a){r.exports=function(){return"object"==typeof globalThis&&(!!globalThis&&globalThis.Array===Array)}},
function _(t,e,o,r,n){var i=function(){if("object"==typeof self&&self)return self;if("object"==typeof window&&window)return window;throw new Error("Unable to resolve global `this`")};e.exports=function(){if(this)return this;try{Object.defineProperty(Object.prototype,"__global__",{get:function(){return this},configurable:!0})}catch(t){return i()}try{return __global__||i()}finally{delete Object.prototype.__global__}}()},
function _(t,o,r,n,e){var i,c,p,y=t(34),s=t(45),u=t(30).Symbol,f=t(47),_=t(48),a=t(49),S=Object.create,g=Object.defineProperties,m=Object.defineProperty;if("function"==typeof u)try{String(u()),p=!0}catch(t){}else u=null;c=function(t){if(this instanceof c)throw new TypeError("Symbol is not a constructor");return i(t)},o.exports=i=function t(o){var r;if(this instanceof t)throw new TypeError("Symbol is not a constructor");return p?u(o):(r=S(c.prototype),o=void 0===o?"":String(o),g(r,{__description__:y("",o),__name__:y("",f(o))}))},_(i),a(i),g(c.prototype,{constructor:y(i),toString:y("",(function(){return this.__name__}))}),g(i.prototype,{toString:y((function(){return"Symbol ("+s(this).__description__+")"})),valueOf:y((function(){return s(this)}))}),m(i.prototype,i.toPrimitive,y("",(function(){var t=s(this);return"symbol"==typeof t?t:t.toString()}))),m(i.prototype,i.toStringTag,y("c","Symbol")),m(c.prototype,i.toStringTag,y("c",i.prototype[i.toStringTag])),m(c.prototype,i.toPrimitive,y("c",i.prototype[i.toPrimitive]))},
function _(l,e,n,r,a){var t=l(35),c=l(36),i=l(40),o=l(41),u=l(42);(e.exports=function(l,e){var n,r,a,c,v;return arguments.length<2||"string"!=typeof l?(c=e,e=l,l=null):c=arguments[2],t(l)?(n=u.call(l,"c"),r=u.call(l,"e"),a=u.call(l,"w")):(n=a=!0,r=!1),v={value:e,configurable:n,enumerable:r,writable:a},c?i(o(c),v):v}).gs=function(l,e,n){var r,a,v,f;return"string"!=typeof l?(v=n,n=e,e=l,l=null):v=arguments[3],t(e)?c(e)?t(n)?c(n)||(v=n,n=void 0):n=void 0:(v=e,e=n=void 0):e=void 0,t(l)?(r=u.call(l,"c"),a=u.call(l,"e")):(r=!0,a=!1),f={get:e,set:n,configurable:r,enumerable:a},v?i(o(v),f):f}},
function _(n,t,u,o,r){t.exports=function(n){return null!=n}},
function _(t,n,o,r,s){var c=t(37),e=/^\s*class[\s{/}]/,i=Function.prototype.toString;n.exports=function(t){return!!c(t)&&!e.test(i.call(t))}},
function _(t,n,r,e,f){var u=t(38);n.exports=function(t){if("function"!=typeof t)return!1;if(!hasOwnProperty.call(t,"length"))return!1;try{if("number"!=typeof t.length)return!1;if("function"!=typeof t.call)return!1;if("function"!=typeof t.apply)return!1}catch(t){return!1}return!u(t)}},
function _(r,t,n,o,c){var u=r(39);t.exports=function(r){if(!u(r))return!1;try{return!!r.constructor&&r.constructor.prototype===r}catch(r){return!1}}},
function _(n,t,e,o,r){var c=n(35),f={object:!0,function:!0,undefined:!0};t.exports=function(n){return!!c(n)&&hasOwnProperty.call(f,typeof n)}},
function _(n,s,t,c,e){s.exports=n(4)()?Object.assign:n(5)},
function _(r,n,t,c,o){var a=r(9),e=Array.prototype.forEach,f=Object.create,u=function(r,n){var t;for(t in r)n[t]=r[t]};n.exports=function(r){var n=f(null);return e.call(arguments,(function(r){a(r)&&u(Object(r),n)})),n}},
function _(t,n,o,i,p){n.exports=t(43)()?String.prototype.contains:t(44)},
function _(n,o,t,a,c){var i="razdwatrzy";o.exports=function(){return"function"==typeof i.contains&&(!0===i.contains("dwa")&&!1===i.contains("foo"))}},
function _(t,n,r,i,o){var e=String.prototype.indexOf;n.exports=function(t){return e.call(this,t,arguments[1])>-1}},
function _(r,n,o,t,e){var i=r(46);n.exports=function(r){if(!i(r))throw new TypeError(r+" is not a symbol");return r}},
function _(o,t,n,r,c){t.exports=function(o){return!!o&&("symbol"==typeof o||!!o.constructor&&("Symbol"===o.constructor.name&&"Symbol"===o[o.constructor.toStringTag]))}},
function _(t,e,n,r,o){var c=t(34),u=Object.create,f=Object.defineProperty,i=Object.prototype,l=u(null);e.exports=function(t){for(var e,n,r=0;l[t+(r||"")];)++r;return l[t+=r||""]=!0,f(i,e="@@"+t,c.gs(null,(function(t){n||(n=!0,f(this,e,c(t)),n=!1)}))),e}},
function _(e,t,a,s,i){var r=e(34),c=e(30).Symbol;t.exports=function(e){return Object.defineProperties(e,{hasInstance:r("",c&&c.hasInstance||e("hasInstance")),isConcatSpreadable:r("",c&&c.isConcatSpreadable||e("isConcatSpreadable")),iterator:r("",c&&c.iterator||e("iterator")),match:r("",c&&c.match||e("match")),replace:r("",c&&c.replace||e("replace")),search:r("",c&&c.search||e("search")),species:r("",c&&c.species||e("species")),split:r("",c&&c.split||e("split")),toPrimitive:r("",c&&c.toPrimitive||e("toPrimitive")),toStringTag:r("",c&&c.toStringTag||e("toStringTag")),unscopables:r("",c&&c.unscopables||e("unscopables"))})}},
function _(r,n,e,t,i){var o=r(34),f=r(45),u=Object.create(null);n.exports=function(r){return Object.defineProperties(r,{for:o((function(n){return u[n]?u[n]:u[n]=r(String(n))})),keyFor:o((function(r){var n;for(n in f(r),u)if(u[n]===r)return n}))})}},
function _(t,n,r,o,c){var e=Object.prototype.toString,u=e.call(function(){return arguments}());n.exports=function(t){return e.call(t)===u}},
function _(t,o,n,e,c){var p=Object.prototype.toString,r=RegExp.prototype.test.bind(/^[object [A-Za-z0-9]*Function]$/);o.exports=function(t){return"function"==typeof t&&r(p.call(t))}},
function _(n,t,r,a,o){var u=n(21),c=Math.max;t.exports=function(n){return c(0,u(n))}},
function _(n,o,t,r,f){o.exports=function(n){if("function"!=typeof n)throw new TypeError(n+" is not a function");return n}},
function _(t,n,o,e,r){var c=Object.prototype.toString,i=c.call("");n.exports=function(t){return"string"==typeof t||t&&"object"==typeof t&&(t instanceof String||c.call(t)===i)||!1}},
function _(e,r,l,t,a){e(56)()||Object.defineProperty(Array.prototype,"fill",{value:e(57),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,f,i,o){t.exports=function(){var n=[1,2,3,4,5,6];return"function"==typeof n.fill&&"1,2,3,-1,-1,-1"===String(n.fill(-1,-3))}},
function _(t,n,i,o,r){var a=t(21),h=t(52),v=t(11),e=Math.max,f=Math.min;n.exports=function(t){var n,i=v(this),o=arguments[1],r=arguments[2],u=h(i.length);for(o=void 0===o?0:a(o),r=void 0===r?u:a(r),n=o<0?e(u+o,0):f(o,u);n<u&&n<r;++n)i[n]=t;return i}},
function _(e,a,l,n,r){e(59)()||Object.defineProperty(Math,"log10",{value:e(60),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,o,f,r){t.exports=function(){var n=Math.log10;return"function"==typeof n&&.3010299956639812===n(2)}},
function _(t,a,n,r,N){var o=Math.log,u=Math.LOG10E;a.exports=function(t){return isNaN(t)||(t=Number(t))<0?NaN:0===t?-1/0:1===t?0:t===1/0?1/0:o(t)*u}},
function _(e,a,l,n,r){e(62)()||Object.defineProperty(Math,"log1p",{value:e(63),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,o,f,r){t.exports=function(){var n=Math.log1p;return"function"==typeof n&&.6931471805599453===n(1)}},
function _(e,n,r,t,N){var a=Math.log;n.exports=function(e){return isNaN(e)||(e=Number(e))<-1?NaN:-1===e?-1/0:0===e?e:e===1/0?1/0:e>-1e-8&&e<1e-8?e-e*e/2:a(1+e)}},
function _(e,n,r,t,a){e(65)()||Object.defineProperty(e(66),"Set",{value:e(67),configurable:!0,enumerable:!1,writable:!0})},
function _(t,e,n,o,f){e.exports=function(){var t,e;return"function"==typeof Set&&(t=new Set(["raz","dwa","trzy"]),"[object Set]"===String(t)&&(3===t.size&&("function"==typeof t.add&&("function"==typeof t.clear&&("function"==typeof t.delete&&("function"==typeof t.entries&&("function"==typeof t.forEach&&("function"==typeof t.has&&("function"==typeof t.keys&&("function"==typeof t.values&&(!1===(e=t.values().next()).done&&"raz"===e.value)))))))))))}},
function _(t,e,o,r,l){var n=function(){if("object"==typeof self&&self)return self;if("object"==typeof window&&window)return window;throw new Error("Unable to resolve global `this`")};e.exports=function(){if(this)return this;if("object"==typeof globalThis&&globalThis)return globalThis;try{Object.defineProperty(Object.prototype,"__global__",{get:function(){return this},configurable:!0})}catch(t){return n()}try{return __global__||n()}finally{delete Object.prototype.__global__}}()},
function _(t,e,n,r,i){var s,o,a,_=t(68),c=t(69),u=t(73),h=t(53),l=t(34),f=t(78),p=t(28),y=t(79),v=t(81),d=t(98),D=t(99),g=Function.prototype.call,w=Object.defineProperty,b=Object.getPrototypeOf;D&&(a=Set),e.exports=s=function(){var t,e=arguments[0];if(!(this instanceof s))throw new TypeError("Constructor requires 'new'");return t=D&&u?u(new a,b(this)):this,null!=e&&y(e),w(t,"__setData__",l("c",[])),e?(v(e,(function(t){-1===c.call(this,t)&&this.push(t)}),t.__setData__),t):t},D&&(u&&u(s,a),s.prototype=Object.create(a.prototype,{constructor:l(s)})),f(Object.defineProperties(s.prototype,{add:l((function(t){return this.has(t)||this.emit("_add",this.__setData__.push(t)-1,t),this})),clear:l((function(){this.__setData__.length&&(_.call(this.__setData__),this.emit("_clear"))})),delete:l((function(t){var e=c.call(this.__setData__,t);return-1!==e&&(this.__setData__.splice(e,1),this.emit("_delete",e,t),!0)})),entries:l((function(){return new d(this,"key+value")})),forEach:l((function(t){var e,n,r,i=arguments[1];for(h(t),n=(e=this.values())._next();void 0!==n;)r=e._resolve(n),g.call(t,i,r,r,this),n=e._next()})),has:l((function(t){return-1!==c.call(this.__setData__,t)})),keys:l(o=function(){return this.values()}),size:l.gs((function(){return this.__setData__.length})),values:l((function(){return new d(this)})),toString:l((function(){return"[object Set]"}))})),w(s.prototype,p.iterator,l(o)),w(s.prototype,p.toStringTag,l("c","Set"))},
function _(t,n,i,r,e){var h=t(11);n.exports=function(){return h(this).length=0,this}},
function _(t,r,e,i,n){var o=t(70),a=t(52),h=t(11),s=Array.prototype.indexOf,p=Object.prototype.hasOwnProperty,f=Math.abs,l=Math.floor;r.exports=function(t){var r,e,i,n;if(!o(t))return s.apply(this,arguments);for(e=a(h(this).length),i=arguments[1],r=i=isNaN(i)?0:i>=0?l(i):a(this.length)-l(f(i));r<e;++r)if(p.call(this,r)&&(n=this[r],o(n)))return r;return-1}},
function _(N,e,i,n,o){e.exports=N(71)()?Number.isNaN:N(72)},
function _(n,t,o,r,u){t.exports=function(){var n=Number.isNaN;return"function"==typeof n&&(!n({})&&n(NaN)&&!n(34))}},
function _(n,t,o,r,u){t.exports=function(n){return n!=n}},
function _(t,e,o,c,f){e.exports=t(74)()?Object.setPrototypeOf:t(75)},
function _(t,e,o,n,r){var c=Object.create,f=Object.getPrototypeOf,u={};e.exports=function(){var t=Object.setPrototypeOf,e=arguments[0]||c;return"function"==typeof t&&f(t(e(null),u))===u}},
function _(e,t,l,r,o){var n,_,u,c,i=e(76),p=e(11),f=Object.prototype.isPrototypeOf,a=Object.defineProperty,b={configurable:!0,enumerable:!1,writable:!0,value:void 0};n=function(e,t){if(p(e),null===t||i(t))return e;throw new TypeError("Prototype must be null or an object")},t.exports=(_=function(){var e,t=Object.create(null),l={},r=Object.getOwnPropertyDescriptor(Object.prototype,"__proto__");if(r){try{(e=r.set).call(t,l)}catch(e){}if(Object.getPrototypeOf(t)===l)return{set:e,level:2}}return t.__proto__=l,Object.getPrototypeOf(t)===l?{level:2}:((t={}).__proto__=l,Object.getPrototypeOf(t)===l&&{level:1})}())?(2===_.level?_.set?(c=_.set,u=function(e,t){return c.call(n(e,t),t),e}):u=function(e,t){return n(e,t).__proto__=t,e}:u=function e(t,l){var r;return n(t,l),(r=f.call(e.nullPolyfill,t))&&delete e.nullPolyfill.__proto__,null===l&&(l=e.nullPolyfill),t.__proto__=l,r&&a(e.nullPolyfill,"__proto__",b),t},Object.defineProperty(u,"level",{configurable:!1,enumerable:!1,writable:!1,value:_.level})):null,e(77)},
function _(n,t,o,c,e){var f=n(9),r={function:!0,object:!0};t.exports=function(n){return f(n)&&r[typeof n]||!1}},
function _(e,r,l,t,n){var o,a,i,u,b=Object.create;e(74)()||(o=e(75)),r.exports=o?1!==o.level?b:(a={},i={},u={configurable:!1,enumerable:!1,writable:!0,value:void 0},Object.getOwnPropertyNames(Object.prototype).forEach((function(e){i[e]="__proto__"!==e?u:{configurable:!0,enumerable:!1,writable:!0,value:void 0}})),Object.defineProperties(a,i),Object.defineProperty(o,"nullPolyfill",{configurable:!1,enumerable:!1,writable:!1,value:a}),function(e,r){return b(null===e?a:e,r)}):b},
function _(e,t,n,i,l){var r,c,_,o,s,a,h,f=e(34),u=e(53),p=Function.prototype.apply,b=Function.prototype.call,y=Object.create,O=Object.defineProperty,j=Object.defineProperties,v=Object.prototype.hasOwnProperty,d={configurable:!0,enumerable:!1,writable:!0};c=function(e,t){var n,i;return u(t),i=this,r.call(this,e,n=function(){_.call(i,e,n),p.call(t,this,arguments)}),n.__eeOnceListener__=t,this},s={on:r=function(e,t){var n;return u(t),v.call(this,"__ee__")?n=this.__ee__:(n=d.value=y(null),O(this,"__ee__",d),d.value=null),n[e]?"object"==typeof n[e]?n[e].push(t):n[e]=[n[e],t]:n[e]=t,this},once:c,off:_=function(e,t){var n,i,l,r;if(u(t),!v.call(this,"__ee__"))return this;if(!(n=this.__ee__)[e])return this;if("object"==typeof(i=n[e]))for(r=0;l=i[r];++r)l!==t&&l.__eeOnceListener__!==t||(2===i.length?n[e]=i[r?0:1]:i.splice(r,1));else i!==t&&i.__eeOnceListener__!==t||delete n[e];return this},emit:o=function(e){var t,n,i,l,r;if(v.call(this,"__ee__")&&(l=this.__ee__[e]))if("object"==typeof l){for(n=arguments.length,r=new Array(n-1),t=1;t<n;++t)r[t-1]=arguments[t];for(l=l.slice(),t=0;i=l[t];++t)p.call(i,this,r)}else switch(arguments.length){case 1:b.call(l,this);break;case 2:b.call(l,this,arguments[1]);break;case 3:b.call(l,this,arguments[1],arguments[2]);break;default:for(n=arguments.length,r=new Array(n-1),t=1;t<n;++t)r[t-1]=arguments[t];p.call(l,this,r)}}},a={on:f(r),once:f(c),off:f(_),emit:f(o)},h=j({},a),t.exports=n=function(e){return null==e?y(h):j(Object(e),a)},n.methods=s},
function _(r,n,t,e,o){var i=r(80);n.exports=function(r){if(!i(r))throw new TypeError(r+" is not iterable");return r}},
function _(r,t,n,o,i){var a=r(50),e=r(9),f=r(54),u=r(28).iterator,c=Array.isArray;t.exports=function(r){return!!e(r)&&(!!c(r)||(!!f(r)||(!!a(r)||"function"==typeof r[u])))}},
function _(r,n,t,a,e){var o=r(50),l=r(53),c=r(54),i=r(82),f=Array.isArray,u=Function.prototype.call,s=Array.prototype.some;n.exports=function(r,n){var t,a,e,y,p,A,g,v,x=arguments[2];if(f(r)||o(r)?t="array":c(r)?t="string":r=i(r),l(n),e=function(){y=!0},"array"!==t)if("string"!==t)for(a=r.next();!a.done;){if(u.call(n,x,a.value,e),y)return;a=r.next()}else for(A=r.length,p=0;p<A&&(g=r[p],p+1<A&&(v=g.charCodeAt(0))>=55296&&v<=56319&&(g+=r[++p]),u.call(n,x,g,e),!y);++p);else s.call(r,(function(r){return u.call(n,x,r,e),y}))}},
function _(n,t,e,o,r){var f=n(50),i=n(54),u=n(83),c=n(97),w=n(79),a=n(28).iterator;t.exports=function(n){return"function"==typeof w(n)[a]?n[a]():f(n)?new u(n):i(n)?new c(n):new u(n)}},
function _(t,e,r,o,_){var i,n=t(73),l=t(42),a=t(34),s=t(28),c=t(84),u=Object.defineProperty;i=e.exports=function(t,e){if(!(this instanceof i))throw new TypeError("Constructor requires 'new'");c.call(this,t),e=e?l.call(e,"key+value")?"key+value":l.call(e,"key")?"key":"value":"value",u(this,"__kind__",a("",e))},n&&n(i,c),delete i.prototype.constructor,i.prototype=Object.create(c.prototype,{_resolve:a((function(t){return"value"===this.__kind__?this.__list__[t]:"key+value"===this.__kind__?[t,this.__list__[t]]:t}))}),u(i.prototype,s.toStringTag,a("c","Array Iterator"))},
function _(_,t,e,n,i){var o,s=_(68),r=_(40),h=_(53),d=_(11),c=_(34),u=_(85),l=_(28),f=Object.defineProperty,x=Object.defineProperties;t.exports=o=function(_,t){if(!(this instanceof o))throw new TypeError("Constructor requires 'new'");x(this,{__list__:c("w",d(_)),__context__:c("w",t),__nextIndex__:c("w",0)}),t&&(h(t.on),t.on("_add",this._onAdd),t.on("_delete",this._onDelete),t.on("_clear",this._onClear))},delete o.prototype.constructor,x(o.prototype,r({_next:c((function(){var _;if(this.__list__)return this.__redo__&&void 0!==(_=this.__redo__.shift())?_:this.__nextIndex__<this.__list__.length?this.__nextIndex__++:void this._unBind()})),next:c((function(){return this._createResult(this._next())})),_createResult:c((function(_){return void 0===_?{done:!0,value:void 0}:{done:!1,value:this._resolve(_)}})),_resolve:c((function(_){return this.__list__[_]})),_unBind:c((function(){this.__list__=null,delete this.__redo__,this.__context__&&(this.__context__.off("_add",this._onAdd),this.__context__.off("_delete",this._onDelete),this.__context__.off("_clear",this._onClear),this.__context__=null)})),toString:c((function(){return"[object "+(this[l.toStringTag]||"Object")+"]"}))},u({_onAdd:c((function(_){_>=this.__nextIndex__||(++this.__nextIndex__,this.__redo__?(this.__redo__.forEach((function(t,e){t>=_&&(this.__redo__[e]=++t)}),this),this.__redo__.push(_)):f(this,"__redo__",c("c",[_])))})),_onDelete:c((function(_){var t;_>=this.__nextIndex__||(--this.__nextIndex__,this.__redo__&&(-1!==(t=this.__redo__.indexOf(_))&&this.__redo__.splice(t,1),this.__redo__.forEach((function(t,e){t>_&&(this.__redo__[e]=--t)}),this)))})),_onClear:c((function(){this.__redo__&&s.call(this.__redo__),this.__nextIndex__=0}))}))),f(o.prototype,l.iterator,c((function(){return this})))},
function _(e,t,n,r,o){var i,l=e(35),u=e(86),s=e(91),v=e(92),a=e(41),c=e(94),f=Function.prototype.bind,p=Object.defineProperty,h=Object.prototype.hasOwnProperty;i=function(e,t,n){var r,o=u(t)&&s(t.value);return delete(r=v(t)).writable,delete r.value,r.get=function(){return!n.overwriteDefinition&&h.call(this,e)?o:(t.value=f.call(o,n.resolveContext?n.resolveContext(this):this),p(this,e,t),this[e])},r},t.exports=function(e){var t=a(arguments[1]);return l(t.resolveContext)&&s(t.resolveContext),c(e,(function(e,n){return i(n,e,t)}))}},
function _(n,t,o,r,u){var e=n(87),a=n(35);t.exports=function(n){return a(n)?n:e(n,"Cannot use %v",arguments[1])}},
function _(r,e,n,t,i){var o=r(35),f=r(39),u=r(88),a=r(89),l=function(r,e){return r.replace("%v",a(e))};e.exports=function(r,e,n){if(!f(n))throw new TypeError(l(e,r));if(!o(r)){if("default"in n)return n.default;if(n.isOptional)return null}var t=u(n.errorMessage);throw o(t)||(t=e),new TypeError(l(t,r))}},
function _(t,n,r,u,e){var i=t(35),o=t(39),f=Object.prototype.toString;n.exports=function(t){if(!i(t))return null;if(o(t)){var n=t.toString;if("function"!=typeof n)return null;if(n===f)return null}try{return""+t}catch(t){return null}}},
function _(r,e,n,t,u){var c=r(90),a=/[\n\r\u2028\u2029]/g;e.exports=function(r){var e=c(r);return null===e?"<Non-coercible to string value>":(e.length>100&&(e=e.slice(0,99)+"…"),e=e.replace(a,(function(r){switch(r){case"\n":return"\\n";case"\r":return"\\r";case"\u2028":return"\\u2028";case"\u2029":return"\\u2029";default:throw new Error("Unexpected character")}})))}},
function _(t,r,n,c,u){r.exports=function(t){try{return t.toString()}catch(r){try{return String(t)}catch(t){return null}}}},
function _(n,t,i,o,r){var u=n(87),a=n(36);t.exports=function(n){return a(n)?n:u(n,"%v is not a plain function",arguments[1])}},
function _(n,r,t,e,u){var c=n(93),i=n(40),f=n(11);r.exports=function(n){var r=Object(f(n)),t=arguments[1],e=Object(arguments[2]);if(r!==n&&!t)return r;var u={};return t?c(t,(function(r){(e.ensure||r in n)&&(u[r]=n[r])})):i(u,n),u}},
function _(r,o,f,n,t){o.exports=r(26)()?Array.from:r(27)},
function _(n,t,o,c,r){var u=n(53),a=n(95),i=Function.prototype.call;t.exports=function(n,t){var o={},c=arguments[2];return u(t),a(n,(function(n,r,u,a){o[r]=i.call(t,c,n,r,u,a)})),o}},
function _(o,c,f,n,r){c.exports=o(96)("forEach")},
function _(t,n,o,c,e){var r=t(53),u=t(11),l=Function.prototype.bind,p=Function.prototype.call,i=Object.keys,a=Object.prototype.propertyIsEnumerable;n.exports=function(t,n){return function(o,c){var e,f=arguments[2],y=arguments[3];return o=Object(u(o)),r(c),e=i(o),y&&e.sort("function"==typeof y?l.call(y,o):void 0),"function"!=typeof t&&(t=e[t]),p.call(t,e,(function(t,e){return a.call(o,t)?p.call(c,f,o[t],t,o,e):n}))}}},
function _(t,_,e,n,r){var i,o=t(73),s=t(34),h=t(28),c=t(84),l=Object.defineProperty;i=_.exports=function(t){if(!(this instanceof i))throw new TypeError("Constructor requires 'new'");t=String(t),c.call(this,t),l(this,"__length__",s("",t.length))},o&&o(i,c),delete i.prototype.constructor,i.prototype=Object.create(c.prototype,{_next:s((function(){if(this.__list__)return this.__nextIndex__<this.__length__?this.__nextIndex__++:void this._unBind()})),_resolve:s((function(t){var _,e=this.__list__[t];return this.__nextIndex__===this.__length__?e:(_=e.charCodeAt(0))>=55296&&_<=56319?e+this.__list__[this.__nextIndex__++]:e}))}),l(i.prototype,h.toStringTag,s("c","String Iterator"))},
function _(t,e,_,r,i){var o,n=t(73),s=t(42),a=t(34),c=t(84),l=t(28).toStringTag,u=Object.defineProperty;o=e.exports=function(t,e){if(!(this instanceof o))return new o(t,e);c.call(this,t.__setData__,t),e=e&&s.call(e,"key+value")?"key+value":"value",u(this,"__kind__",a("",e))},n&&n(o,c),o.prototype=Object.create(c.prototype,{constructor:a(o),_resolve:a((function(t){return"value"===this.__kind__?this.__list__[t]:[this.__list__[t],this.__list__[t]]})),toString:a((function(){return"[object Set Iterator]"}))}),u(o.prototype,l,a("c","Set Iterator"))},
function _(t,e,o,p,n){e.exports="undefined"!=typeof Set&&"[object Set]"===Object.prototype.toString.call(Set.prototype)},
function _(e,a,n,r,b){e(101)()||Object.defineProperty(e(66),"Map",{value:e(102),configurable:!0,enumerable:!1,writable:!0})},
function _(t,e,n,o,f){e.exports=function(){var t,e;if("function"!=typeof Map)return!1;try{t=new Map([["raz","one"],["dwa","two"],["trzy","three"]])}catch(t){return!1}return"[object Map]"===String(t)&&(3===t.size&&("function"==typeof t.clear&&("function"==typeof t.delete&&("function"==typeof t.entries&&("function"==typeof t.forEach&&("function"==typeof t.get&&("function"==typeof t.has&&("function"==typeof t.keys&&("function"==typeof t.set&&("function"==typeof t.values&&(!1===(e=t.entries().next()).done&&(!!e.value&&("raz"===e.value[0]&&"one"===e.value[1])))))))))))))}},
function _(t,e,a,_,n){var i,r=t(68),s=t(69),o=t(73),p=t(53),c=t(11),u=t(34),l=t(78),h=t(28),f=t(79),y=t(81),m=t(103),D=t(106),v=Function.prototype.call,K=Object.defineProperties,d=Object.getPrototypeOf;e.exports=i=function(){var t,e,a,_=arguments[0];if(!(this instanceof i))throw new TypeError("Constructor requires 'new'");return a=D&&o&&Map!==i?o(new Map,d(this)):this,null!=_&&f(_),K(a,{__mapKeysData__:u("c",t=[]),__mapValuesData__:u("c",e=[])}),_?(y(_,(function(a){var _=c(a)[0];a=a[1],-1===s.call(t,_)&&(t.push(_),e.push(a))}),a),a):a},D&&(o&&o(i,Map),i.prototype=Object.create(Map.prototype,{constructor:u(i)})),l(K(i.prototype,{clear:u((function(){this.__mapKeysData__.length&&(r.call(this.__mapKeysData__),r.call(this.__mapValuesData__),this.emit("_clear"))})),delete:u((function(t){var e=s.call(this.__mapKeysData__,t);return-1!==e&&(this.__mapKeysData__.splice(e,1),this.__mapValuesData__.splice(e,1),this.emit("_delete",e,t),!0)})),entries:u((function(){return new m(this,"key+value")})),forEach:u((function(t){var e,a,_=arguments[1];for(p(t),a=(e=this.entries())._next();void 0!==a;)v.call(t,_,this.__mapValuesData__[a],this.__mapKeysData__[a],this),a=e._next()})),get:u((function(t){var e=s.call(this.__mapKeysData__,t);if(-1!==e)return this.__mapValuesData__[e]})),has:u((function(t){return-1!==s.call(this.__mapKeysData__,t)})),keys:u((function(){return new m(this,"key")})),set:u((function(t,e){var a,_=s.call(this.__mapKeysData__,t);return-1===_&&(_=this.__mapKeysData__.push(t)-1,a=!0),this.__mapValuesData__[_]=e,a&&this.emit("_add",_,t),this})),size:u.gs((function(){return this.__mapKeysData__.length})),values:u((function(){return new m(this,"value")})),toString:u((function(){return"[object Map]"}))})),Object.defineProperty(i.prototype,h.iterator,u((function(){return this.entries()}))),Object.defineProperty(i.prototype,h.toStringTag,u("c","Map"))},
function _(t,_,e,i,n){var r,o=t(73),s=t(34),a=t(84),u=t(28).toStringTag,c=t(104),l=Object.defineProperties,p=a.prototype._unBind;r=_.exports=function(t,_){if(!(this instanceof r))return new r(t,_);a.call(this,t.__mapKeysData__,t),_&&c[_]||(_="key+value"),l(this,{__kind__:s("",_),__values__:s("w",t.__mapValuesData__)})},o&&o(r,a),r.prototype=Object.create(a.prototype,{constructor:s(r),_resolve:s((function(t){return"value"===this.__kind__?this.__values__[t]:"key"===this.__kind__?this.__list__[t]:[this.__list__[t],this.__values__[t]]})),_unBind:s((function(){this.__values__=null,p.call(this)})),toString:s((function(){return"[object Map Iterator]"}))}),Object.defineProperty(r.prototype,u,s("c","Map Iterator"))},
function _(e,u,a,k,l){u.exports=e(105)("key","value","key+value")},
function _(r,t,n,c,o){var a=Array.prototype.forEach,e=Object.create;t.exports=function(r){var t=e(null);return a.call(arguments,(function(r){t[r]=!0})),t}},
function _(t,e,o,p,n){e.exports="undefined"!=typeof Map&&"[object Map]"===Object.prototype.toString.call(new Map)},
function _(e,a,n,r,b){e(108)()||Object.defineProperty(e(66),"WeakMap",{value:e(109),configurable:!0,enumerable:!1,writable:!0})},
function _(t,e,n,o,f){e.exports=function(){var t,e;if("function"!=typeof WeakMap)return!1;try{t=new WeakMap([[e={},"one"],[{},"two"],[{},"three"]])}catch(t){return!1}return"[object WeakMap]"===String(t)&&("function"==typeof t.set&&(t.set({},1)===t&&("function"==typeof t.delete&&("function"==typeof t.has&&"one"===t.get(e)))))}},
function _(t,e,a,r,n){var o,p=t(9),_=t(73),i=t(110),c=t(11),s=t(111),u=t(34),f=t(82),k=t(81),M=t(28).toStringTag,h=t(112),w=Array.isArray,y=Object.defineProperty,l=Object.prototype.hasOwnProperty,D=Object.getPrototypeOf;e.exports=o=function(){var t,e=arguments[0];if(!(this instanceof o))throw new TypeError("Constructor requires 'new'");return t=h&&_&&WeakMap!==o?_(new WeakMap,D(this)):this,p(e)&&(w(e)||(e=f(e))),y(t,"__weakMapData__",u("c","$weakMap$"+s())),e?(k(e,(function(e){c(e),t.set(e[0],e[1])})),t):t},h&&(_&&_(o,WeakMap),o.prototype=Object.create(WeakMap.prototype,{constructor:u(o)})),Object.defineProperties(o.prototype,{delete:u((function(t){return!!l.call(i(t),this.__weakMapData__)&&(delete t[this.__weakMapData__],!0)})),get:u((function(t){if(l.call(i(t),this.__weakMapData__))return t[this.__weakMapData__]})),has:u((function(t){return l.call(i(t),this.__weakMapData__)})),set:u((function(t,e){return y(i(t),this.__weakMapData__,u("c",e)),this})),toString:u((function(){return"[object WeakMap]"}))}),y(o.prototype,M,u("c","WeakMap"))},
function _(n,r,t,o,e){var i=n(76);r.exports=function(n){if(!i(n))throw new TypeError(n+" is not an Object");return n}},
function _(t,n,r,e,o){var a=Object.create(null),c=Math.random;n.exports=function(){var t;do{t=c().toString(36).slice(2)}while(a[t]);return t}},
function _(t,e,o,a,p){e.exports="function"==typeof WeakMap&&"[object WeakMap]"===Object.prototype.toString.call(new WeakMap)},
function _(e,b,l,n,r){e(29)()||Object.defineProperty(e(30),"Symbol",{value:e(33),configurable:!0,enumerable:!1,writable:!0})},
function _(l,o,f,i,n){o.exports=l(115).polyfill()},
function _(t,e,n,r,o){
/*!
     * @overview es6-promise - a tiny implementation of Promises/A+.
     * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
     * @license   Licensed under MIT license
     *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
     * @version   v4.2.8+1e68dce6
     */
!function(t,r){"object"==typeof n&&void 0!==e?e.exports=r():"function"==typeof define&&define.amd?define(r):t.ES6Promise=r()}(this,(function(){"use strict";function e(t){return"function"==typeof t}var n=Array.isArray?Array.isArray:function(t){return"[object Array]"===Object.prototype.toString.call(t)},r=0,o=void 0,i=void 0,s=function(t,e){v[r]=t,v[r+1]=e,2===(r+=2)&&(i?i(p):b())};var u="undefined"!=typeof window?window:void 0,c=u||{},a=c.MutationObserver||c.WebKitMutationObserver,f="undefined"==typeof self&&"undefined"!=typeof process&&"[object process]"==={}.toString.call(process),l="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;function h(){var t=setTimeout;return function(){return t(p,1)}}var v=new Array(1e3);function p(){for(var t=0;t<r;t+=2){(0,v[t])(v[t+1]),v[t]=void 0,v[t+1]=void 0}r=0}var d,_,y,m,b=void 0;function w(t,e){var n=this,r=new this.constructor(j);void 0===r[A]&&k(r);var o=n._state;if(o){var i=arguments[o-1];s((function(){return F(o,r,i,n._result)}))}else O(n,r,t,e);return r}function g(t){if(t&&"object"==typeof t&&t.constructor===this)return t;var e=new this(j);return T(e,t),e}f?b=function(){return process.nextTick(p)}:a?(_=0,y=new a(p),m=document.createTextNode(""),y.observe(m,{characterData:!0}),b=function(){m.data=_=++_%2}):l?((d=new MessageChannel).port1.onmessage=p,b=function(){return d.port2.postMessage(0)}):b=void 0===u&&"function"==typeof t?function(){try{var t=Function("return this")().require("vertx");return void 0!==(o=t.runOnLoop||t.runOnContext)?function(){o(p)}:h()}catch(t){return h()}}():h();var A=Math.random().toString(36).substring(2);function j(){}var S=void 0;function E(t,n,r){n.constructor===t.constructor&&r===w&&n.constructor.resolve===g?function(t,e){1===e._state?P(t,e._result):2===e._state?C(t,e._result):O(e,void 0,(function(e){return T(t,e)}),(function(e){return C(t,e)}))}(t,n):void 0===r?P(t,n):e(r)?function(t,e,n){s((function(t){var r=!1,o=function(t,e,n,r){try{t.call(e,n,r)}catch(t){return t}}(n,e,(function(n){r||(r=!0,e!==n?T(t,n):P(t,n))}),(function(e){r||(r=!0,C(t,e))}),t._label);!r&&o&&(r=!0,C(t,o))}),t)}(t,n,r):P(t,n)}function T(t,e){if(t===e)C(t,new TypeError("You cannot resolve a promise with itself"));else if(o=typeof(r=e),null===r||"object"!==o&&"function"!==o)P(t,e);else{var n=void 0;try{n=e.then}catch(e){return void C(t,e)}E(t,e,n)}var r,o}function M(t){t._onerror&&t._onerror(t._result),x(t)}function P(t,e){t._state===S&&(t._result=e,t._state=1,0!==t._subscribers.length&&s(x,t))}function C(t,e){t._state===S&&(t._state=2,t._result=e,s(M,t))}function O(t,e,n,r){var o=t._subscribers,i=o.length;t._onerror=null,o[i]=e,o[i+1]=n,o[i+2]=r,0===i&&t._state&&s(x,t)}function x(t){var e=t._subscribers,n=t._state;if(0!==e.length){for(var r=void 0,o=void 0,i=t._result,s=0;s<e.length;s+=3)r=e[s],o=e[s+n],r?F(n,r,o,i):o(i);t._subscribers.length=0}}function F(t,n,r,o){var i=e(r),s=void 0,u=void 0,c=!0;if(i){try{s=r(o)}catch(t){c=!1,u=t}if(n===s)return void C(n,new TypeError("A promises callback cannot return that same promise."))}else s=o;n._state!==S||(i&&c?T(n,s):!1===c?C(n,u):1===t?P(n,s):2===t&&C(n,s))}var Y=0;function k(t){t[A]=Y++,t._state=void 0,t._result=void 0,t._subscribers=[]}var q=function(){function t(t,e){this._instanceConstructor=t,this.promise=new t(j),this.promise[A]||k(this.promise),n(e)?(this.length=e.length,this._remaining=e.length,this._result=new Array(this.length),0===this.length?P(this.promise,this._result):(this.length=this.length||0,this._enumerate(e),0===this._remaining&&P(this.promise,this._result))):C(this.promise,new Error("Array Methods must be provided an Array"))}return t.prototype._enumerate=function(t){for(var e=0;this._state===S&&e<t.length;e++)this._eachEntry(t[e],e)},t.prototype._eachEntry=function(t,e){var n=this._instanceConstructor,r=n.resolve;if(r===g){var o=void 0,i=void 0,s=!1;try{o=t.then}catch(t){s=!0,i=t}if(o===w&&t._state!==S)this._settledAt(t._state,e,t._result);else if("function"!=typeof o)this._remaining--,this._result[e]=t;else if(n===D){var u=new n(j);s?C(u,i):E(u,t,o),this._willSettleAt(u,e)}else this._willSettleAt(new n((function(e){return e(t)})),e)}else this._willSettleAt(r(t),e)},t.prototype._settledAt=function(t,e,n){var r=this.promise;r._state===S&&(this._remaining--,2===t?C(r,n):this._result[e]=n),0===this._remaining&&P(r,this._result)},t.prototype._willSettleAt=function(t,e){var n=this;O(t,void 0,(function(t){return n._settledAt(1,e,t)}),(function(t){return n._settledAt(2,e,t)}))},t}();var D=function(){function t(e){this[A]=Y++,this._result=this._state=void 0,this._subscribers=[],j!==e&&("function"!=typeof e&&function(){throw new TypeError("You must pass a resolver function as the first argument to the promise constructor")}(),this instanceof t?function(t,e){try{e((function(e){T(t,e)}),(function(e){C(t,e)}))}catch(e){C(t,e)}}(this,e):function(){throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.")}())}return t.prototype.catch=function(t){return this.then(null,t)},t.prototype.finally=function(t){var n=this,r=n.constructor;return e(t)?n.then((function(e){return r.resolve(t()).then((function(){return e}))}),(function(e){return r.resolve(t()).then((function(){throw e}))})):n.then(t,t)},t}();return D.prototype.then=w,D.all=function(t){return new q(this,t).promise},D.race=function(t){var e=this;return n(t)?new e((function(n,r){for(var o=t.length,i=0;i<o;i++)e.resolve(t[i]).then(n,r)})):new e((function(t,e){return e(new TypeError("You must pass an array to race."))}))},D.resolve=g,D.reject=function(t){var e=new this(j);return C(e,t),e},D._setScheduler=function(t){i=t},D._setAsap=function(t){s=t},D._asap=s,D.polyfill=function(){var t=void 0;if("undefined"!=typeof global)t=global;else if("undefined"!=typeof self)t=self;else try{t=Function("return this")()}catch(t){throw new Error("polyfill failed because global object is unavailable in this environment")}var e=t.Promise;if(e){var n=null;try{n=Object.prototype.toString.call(e.resolve())}catch(t){}if("[object Promise]"===n&&!e.cast)return}t.Promise=D},D.Promise=D,D}))},
function _(t,_,n,o,r){o(),t(1).__exportStar(t(117),n)},
function _(e,t,o,s,l){s();var r=e(1);l("version",e(118).version),l("index",e(119).index),o.embed=r.__importStar(e(119)),o.protocol=r.__importStar(e(507)),o._testing=r.__importStar(e(508));var _=e(134);l("logger",_.logger),l("set_log_level",_.set_log_level),l("settings",e(142).settings),l("Models",e(122).Models),l("documents",e(120).documents),l("safely",e(509).safely)},
function _(n,e,i,o,v){o(),i.version="2.3.0-dev.2"},
function _(e,r,t,n,o){n();var s=e(1),a=e(120),u=e(134),d=e(144),i=e(128),_=e(123),c=e(131),l=e(498),f=e(500),m=e(499),h=e(498);o("add_document_standalone",h.add_document_standalone),o("index",h.index),o("add_document_from_session",e(500).add_document_from_session);var v=e(505);function b(e,r,t,n){return s.__awaiter(this,void 0,void 0,(function(){var o,c,h,v,b,g,p,w,y,k,O,x,B,E,H,K,R,T,S,j,D,I,J;return s.__generator(this,(function(L){switch(L.label){case 0:_.isString(e)&&(e=JSON.parse(d.unescape(e))),o={};try{for(c=s.__values(i.entries(e)),h=c.next();!h.done;h=c.next())v=s.__read(h.value,2),b=v[0],g=v[1],o[b]=a.Document.from_json(g)}catch(e){j={error:e}}finally{try{h&&!h.done&&(D=c.return)&&D.call(c)}finally{if(j)throw j.error}}p=[],L.label=1;case 1:L.trys.push([1,12,13,14]),w=s.__values(r),y=w.next(),L.label=2;case 2:return y.done?[3,11]:(k=y.value,O=m._resolve_element(k),x=m._resolve_root_elements(k),null==k.docid?[3,4]:(E=(B=p).push,[4,l.add_document_standalone(o[k.docid],O,x,k.use_for_title)]));case 3:return E.apply(B,[L.sent()]),[3,10];case 4:if(null==k.token)return[3,9];H=f._get_ws_url(t,n),u.logger.debug("embed: computed ws url: "+H),L.label=5;case 5:return L.trys.push([5,7,,8]),R=(K=p).push,[4,f.add_document_from_session(H,k.token,O,x,k.use_for_title)];case 6:return R.apply(K,[L.sent()]),console.log("Bokeh items were rendered successfully"),[3,8];case 7:return T=L.sent(),console.log("Error rendering Bokeh items:",T),[3,8];case 8:return[3,10];case 9:throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");case 10:return y=w.next(),[3,2];case 11:return[3,14];case 12:return S=L.sent(),I={error:S},[3,14];case 13:try{y&&!y.done&&(J=w.return)&&J.call(w)}finally{if(I)throw I.error}return[7];case 14:return[2,p]}}))}))}o("embed_items_notebook",v.embed_items_notebook),o("kernels",v.kernels),o("BOKEH_ROOT",e(499).BOKEH_ROOT),t.embed_item=function(e,r){return s.__awaiter(this,void 0,void 0,(function(){var t,n,o,a,u,i;return s.__generator(this,(function(_){switch(_.label){case 0:return t={},n=d.uuid4(),t[n]=e.doc,null==r&&(r=e.target_id),null!=(o=document.getElementById(r))&&o.classList.add(m.BOKEH_ROOT),(i={})[e.root_id]=r,a={roots:i,root_ids:[e.root_id],docid:n},[4,c.defer((function(){return b(t,[a])}))];case 1:return u=s.__read.apply(void 0,[_.sent(),1]),[2,u[0]]}}))}))},t.embed_items=function(e,r,t,n){return s.__awaiter(this,void 0,void 0,(function(){return s.__generator(this,(function(o){switch(o.label){case 0:return[4,c.defer((function(){return b(e,r,t,n)}))];case 1:return[2,o.sent()]}}))}))}},
function _(r,t,_,a,o){a();var e=r(1);e.__exportStar(r(121),_),e.__exportStar(r(240),_)},
function _(e,t,r,n,o){n();var a=e(1),l=e(122),i=e(118),s=e(134),_=e(429),c=e(129),u=e(130),f=e(132),d=e(146),h=e(124),v=e(128),y=a.__importStar(e(239)),p=e(140),m=e(123),w=e(407),g=e(237),x=e(196),b=e(240),j=function(){function e(e){this.document=e,this.session=null,this.subscribed_models=new Set}return e.prototype.send_event=function(e){var t=new b.MessageSentEvent(this.document,"bokeh_event",e.to_json());this.document._trigger_on_change(t)},e.prototype.trigger=function(e){var t,r;try{for(var n=a.__values(this.subscribed_models),o=n.next();!o.done;o=n.next()){var l=o.value;null!=e.origin&&e.origin!=l||l._process_event(e)}}catch(e){t={error:e}}finally{try{o&&!o.done&&(r=n.return)&&r.call(n)}finally{if(t)throw t.error}}},e}();r.EventManager=j,j.__name__="EventManager",r.documents=[],r.DEFAULT_TITLE="Bokeh Application";var k=function(){function e(){r.documents.push(this),this._init_timestamp=Date.now(),this._title=r.DEFAULT_TITLE,this._roots=[],this._all_models=new Map,this._all_models_freeze_count=0,this._callbacks=new Map,this._message_callbacks=new Map,this.event_manager=new j(this),this.idle=new u.Signal0(this,"idle"),this._idle_roots=new WeakMap,this._interactive_timestamp=null,this._interactive_plot=null}return Object.defineProperty(e.prototype,"layoutables",{get:function(){return this._roots.filter((function(e){return e instanceof w.LayoutDOM}))},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"is_idle",{get:function(){var e,t;try{for(var r=a.__values(this.layoutables),n=r.next();!n.done;n=r.next()){var o=n.value;if(!this._idle_roots.has(o))return!1}}catch(t){e={error:t}}finally{try{n&&!n.done&&(t=r.return)&&t.call(r)}finally{if(e)throw e.error}}return!0},enumerable:!1,configurable:!0}),e.prototype.notify_idle=function(e){this._idle_roots.set(e,!0),this.is_idle&&(s.logger.info("document idle at "+(Date.now()-this._init_timestamp)+" ms"),this.event_manager.send_event(new _.DocumentReady),this.idle.emit())},e.prototype.clear=function(){this._push_all_models_freeze();try{for(;this._roots.length>0;)this.remove_root(this._roots[0])}finally{this._pop_all_models_freeze()}},e.prototype.interactive_start=function(e){null==this._interactive_plot&&(this._interactive_plot=e,this._interactive_plot.trigger_event(new _.LODStart)),this._interactive_timestamp=Date.now()},e.prototype.interactive_stop=function(){null!=this._interactive_plot&&this._interactive_plot.trigger_event(new _.LODEnd),this._interactive_plot=null,this._interactive_timestamp=null},e.prototype.interactive_duration=function(){return null==this._interactive_timestamp?-1:Date.now()-this._interactive_timestamp},e.prototype.destructively_move=function(e){var t,r,n,o;if(e===this)throw new Error("Attempted to overwrite a document with itself");e.clear();var l=h.copy(this._roots);this.clear();try{for(var i=a.__values(l),s=i.next();!s.done;s=i.next()){if(null!=(u=s.value).document)throw new Error("Somehow we didn't detach "+u)}}catch(e){t={error:e}}finally{try{s&&!s.done&&(r=i.return)&&r.call(i)}finally{if(t)throw t.error}}if(0!=this._all_models.size)throw new Error("this._all_models still had stuff in it: "+this._all_models);try{for(var _=a.__values(l),c=_.next();!c.done;c=_.next()){var u=c.value;e.add_root(u)}}catch(e){n={error:e}}finally{try{c&&!c.done&&(o=_.return)&&o.call(_)}finally{if(n)throw n.error}}e.set_title(this._title)},e.prototype._push_all_models_freeze=function(){this._all_models_freeze_count+=1},e.prototype._pop_all_models_freeze=function(){this._all_models_freeze_count-=1,0===this._all_models_freeze_count&&this._recompute_all_models()},e.prototype._invalidate_all_models=function(){s.logger.debug("invalidating document models"),0===this._all_models_freeze_count&&this._recompute_all_models()},e.prototype._recompute_all_models=function(){var e,t,r,n,o,l,i,s,_=new Set;try{for(var c=a.__values(this._roots),u=c.next();!u.done;u=c.next()){var f=u.value;_=y.union(_,f.references())}}catch(t){e={error:t}}finally{try{u&&!u.done&&(t=c.return)&&t.call(c)}finally{if(e)throw e.error}}var d=new Set(this._all_models.values()),h=y.difference(d,_),v=y.difference(_,d),p=new Map;try{for(var m=a.__values(_),w=m.next();!w.done;w=m.next()){var g=w.value;p.set(g.id,g)}}catch(e){r={error:e}}finally{try{w&&!w.done&&(n=m.return)&&n.call(m)}finally{if(r)throw r.error}}try{for(var x=a.__values(h),b=x.next();!b.done;b=x.next()){b.value.detach_document()}}catch(e){o={error:e}}finally{try{b&&!b.done&&(l=x.return)&&l.call(x)}finally{if(o)throw o.error}}try{for(var j=a.__values(v),k=j.next();!k.done;k=j.next()){k.value.attach_document(this)}}catch(e){i={error:e}}finally{try{k&&!k.done&&(s=j.return)&&s.call(j)}finally{if(i)throw i.error}}this._all_models=p},e.prototype.roots=function(){return this._roots},e.prototype.add_root=function(e,t){if(s.logger.debug("Adding root: "+e),!h.includes(this._roots,e)){this._push_all_models_freeze();try{this._roots.push(e)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new b.RootAddedEvent(this,e,t))}},e.prototype.remove_root=function(e,t){var r=this._roots.indexOf(e);if(!(r<0)){this._push_all_models_freeze();try{this._roots.splice(r,1)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new b.RootRemovedEvent(this,e,t))}},e.prototype.title=function(){return this._title},e.prototype.set_title=function(e,t){e!==this._title&&(this._title=e,this._trigger_on_change(new b.TitleChangedEvent(this,e,t)))},e.prototype.get_model_by_id=function(e){var t;return null!==(t=this._all_models.get(e))&&void 0!==t?t:null},e.prototype.get_model_by_name=function(e){var t,r,n=[];try{for(var o=a.__values(this._all_models.values()),l=o.next();!l.done;l=o.next()){var i=l.value;i instanceof x.Model&&i.name==e&&n.push(i)}}catch(e){t={error:e}}finally{try{l&&!l.done&&(r=o.return)&&r.call(o)}finally{if(t)throw t.error}}switch(n.length){case 0:return null;case 1:return n[0];default:throw new Error("Multiple models are named '"+e+"'")}},e.prototype.on_message=function(e,t){var r=this._message_callbacks.get(e);null==r?this._message_callbacks.set(e,new Set([t])):r.add(t)},e.prototype.remove_on_message=function(e,t){var r;null===(r=this._message_callbacks.get(e))||void 0===r||r.delete(t)},e.prototype._trigger_on_message=function(e,t){var r,n,o=this._message_callbacks.get(e);if(null!=o)try{for(var l=a.__values(o),i=l.next();!i.done;i=l.next()){(0,i.value)(t)}}catch(e){r={error:e}}finally{try{i&&!i.done&&(n=l.return)&&n.call(l)}finally{if(r)throw r.error}}},e.prototype.on_change=function(e,t){void 0===t&&(t=!1),this._callbacks.has(e)||this._callbacks.set(e,t)},e.prototype.remove_on_change=function(e){this._callbacks.delete(e)},e.prototype._trigger_on_change=function(e){var t,r,n,o;try{for(var l=a.__values(this._callbacks),i=l.next();!i.done;i=l.next()){var s=a.__read(i.value,2),_=s[0];if(!s[1]&&e instanceof b.DocumentEventBatch)try{for(var c=(n=void 0,a.__values(e.events)),u=c.next();!u.done;u=c.next()){_(u.value)}}catch(e){n={error:e}}finally{try{u&&!u.done&&(o=c.return)&&o.call(c)}finally{if(n)throw n.error}}else _(e)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=l.return)&&r.call(l)}finally{if(t)throw t.error}}},e.prototype._notify_change=function(e,t,r,n,o){this._trigger_on_change(new b.ModelChangedEvent(this,e,t,r,n,null==o?void 0:o.setter_id,null==o?void 0:o.hint))},e._references_json=function(e,t){var r,n;void 0===t&&(t=!0);var o=[];try{for(var l=a.__values(e),i=l.next();!i.done;i=l.next()){var s=i.value,_=s.struct();_.attributes=s.attributes_as_json(t),delete _.attributes.id,o.push(_)}}catch(e){r={error:e}}finally{try{i&&!i.done&&(n=l.return)&&n.call(l)}finally{if(r)throw r.error}}return o},e._instantiate_object=function(e,t,r){var n=Object.assign(Object.assign({},r),{id:e,__deferred__:!0});return new(l.Models(t))(n)},e._instantiate_references_json=function(t,r){var n,o,l,i=new Map;try{for(var s=a.__values(t),_=s.next();!_.done;_=s.next()){var c=_.value,u=c.id,f=c.type,d=null!==(l=c.attributes)&&void 0!==l?l:{},h=r.get(u);null==h&&(h=e._instantiate_object(u,f,d),null!=c.subtype&&h.set_subtype(c.subtype)),i.set(h.id,h)}}catch(e){n={error:e}}finally{try{_&&!_.done&&(o=s.return)&&o.call(s)}finally{if(n)throw n.error}}return i},e._resolve_refs=function(e,t,r,n){function o(e){if(f.is_ref(e)){if(t.has(e.id))return t.get(e.id);if(r.has(e.id))return r.get(e.id);throw new Error("reference "+JSON.stringify(e)+" isn't known (not in Document?)")}return d.is_NDArray_ref(e)?d.decode_NDArray(e,n):m.isArray(e)?function(e){var t,r,n=[];try{for(var l=a.__values(e),i=l.next();!i.done;i=l.next()){var s=i.value;n.push(o(s))}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=l.return)&&r.call(l)}finally{if(t)throw t.error}}return n}(e):m.isPlainObject(e)?function(e){var t,r,n={};try{for(var l=a.__values(v.entries(e)),i=l.next();!i.done;i=l.next()){var s=a.__read(i.value,2),_=s[0],c=s[1];n[_]=o(c)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=l.return)&&r.call(l)}finally{if(t)throw t.error}}return n}(e):e}return o(e)},e._initialize_references_json=function(t,r,n,o){var l,i,s,_,u,f,d=new Map;try{for(var h=a.__values(t),y=h.next();!y.done;y=h.next()){var p=y.value,w=p.id,g=p.attributes,x=!r.has(w),b=x?n.get(w):r.get(w),j=e._resolve_refs(g,r,n,o);b.setv(j,{silent:!0}),d.set(w,{instance:b,is_new:x})}}catch(e){l={error:e}}finally{try{y&&!y.done&&(i=h.return)&&i.call(h)}finally{if(l)throw l.error}}var k=[],M=new Set;function E(e){var t,r,n,o,l,i;if(e instanceof c.HasProps){if(d.has(e.id)&&!M.has(e.id)){M.add(e.id);var s=d.get(e.id),_=s.instance,u=s.is_new,f=_.attributes;try{for(var h=a.__values(v.values(f)),y=h.next();!y.done;y=h.next()){E(y.value)}}catch(e){t={error:e}}finally{try{y&&!y.done&&(r=h.return)&&r.call(h)}finally{if(t)throw t.error}}u&&(_.finalize(),k.push(_))}}else if(m.isArray(e))try{for(var p=a.__values(e),w=p.next();!w.done;w=p.next()){E(w.value)}}catch(e){n={error:e}}finally{try{w&&!w.done&&(o=p.return)&&o.call(p)}finally{if(n)throw n.error}}else if(m.isPlainObject(e))try{for(var g=a.__values(v.values(e)),x=g.next();!x.done;x=g.next()){E(x.value)}}catch(e){l={error:e}}finally{try{x&&!x.done&&(i=g.return)&&i.call(g)}finally{if(l)throw l.error}}}try{for(var S=a.__values(d.values()),C=S.next();!C.done;C=S.next()){E(C.value.instance)}}catch(e){s={error:e}}finally{try{C&&!C.done&&(_=S.return)&&_.call(S)}finally{if(s)throw s.error}}try{for(var D=a.__values(k),O=D.next();!O.done;O=D.next()){(b=O.value).connect_signals()}}catch(e){u={error:e}}finally{try{O&&!O.done&&(f=D.return)&&f.call(D)}finally{if(u)throw u.error}}},e._event_for_attribute_change=function(e,t,r,n,o){if(n.get_model_by_id(e.id).property(t).syncable){var a={kind:"ModelChanged",model:{id:e.id},attr:t,new:r};return c.HasProps._json_record_references(n,r,o,{recursive:!0}),a}return null},e._events_to_sync_objects=function(t,r,n,o){var l,i,_,c,u,f,d=Object.keys(t.attributes),v=Object.keys(r.attributes),y=h.difference(d,v),m=h.difference(v,d),w=h.intersection(d,v),g=[];try{for(var x=a.__values(y),b=x.next();!b.done;b=x.next()){var j=b.value;s.logger.warn("Server sent key "+j+" but we don't seem to have it in our JSON")}}catch(e){l={error:e}}finally{try{b&&!b.done&&(i=x.return)&&i.call(x)}finally{if(l)throw l.error}}try{for(var k=a.__values(m),M=k.next();!M.done;M=k.next()){j=M.value;var E=r.attributes[j];g.push(e._event_for_attribute_change(t,j,E,n,o))}}catch(e){_={error:e}}finally{try{M&&!M.done&&(c=k.return)&&c.call(k)}finally{if(_)throw _.error}}try{for(var S=a.__values(w),C=S.next();!C.done;C=S.next()){j=C.value;var D=t.attributes[j];E=r.attributes[j];null==D&&null==E||(null==D||null==E?g.push(e._event_for_attribute_change(t,j,E,n,o)):p.is_equal(D,E)||g.push(e._event_for_attribute_change(t,j,E,n,o)))}}catch(e){u={error:e}}finally{try{C&&!C.done&&(f=S.return)&&f.call(S)}finally{if(u)throw u.error}}return g.filter((function(e){return null!=e}))},e._compute_patch_since_json=function(t,r){var n,o,l,i,s,_,c=r.to_json(!1);function u(e){var t,r,n=new Map;try{for(var o=a.__values(e.roots.references),l=o.next();!l.done;l=o.next()){var i=l.value;n.set(i.id,i)}}catch(e){t={error:e}}finally{try{l&&!l.done&&(r=o.return)&&r.call(o)}finally{if(t)throw t.error}}return n}var f=u(t),d=new Map,v=[];try{for(var y=a.__values(t.roots.root_ids),p=y.next();!p.done;p=y.next()){var m=p.value;d.set(m,f.get(m)),v.push(m)}}catch(e){n={error:e}}finally{try{p&&!p.done&&(o=y.return)&&o.call(y)}finally{if(n)throw n.error}}var w=u(c),g=new Map,x=[];try{for(var b=a.__values(c.roots.root_ids),j=b.next();!j.done;j=b.next()){m=j.value;g.set(m,w.get(m)),x.push(m)}}catch(e){l={error:e}}finally{try{j&&!j.done&&(i=b.return)&&i.call(b)}finally{if(l)throw l.error}}if(v.sort(),x.sort(),h.difference(v,x).length>0||h.difference(x,v).length>0)throw new Error("Not implemented: computing add/remove of document roots");var k=new Set,M=[];try{for(var E=a.__values(r._all_models.keys()),S=E.next();!S.done;S=E.next()){var C=S.value;if(f.has(C)){var D=e._events_to_sync_objects(f.get(C),w.get(C),r,k);M=M.concat(D)}}}catch(e){s={error:e}}finally{try{S&&!S.done&&(_=E.return)&&_.call(E)}finally{if(s)throw s.error}}return{references:e._references_json(k,!1),events:M}},e.prototype.to_json_string=function(e){return void 0===e&&(e=!0),JSON.stringify(this.to_json(e))},e.prototype.to_json=function(t){void 0===t&&(t=!0);var r=this._roots.map((function(e){return e.id})),n=this._all_models.values();return{version:i.version,title:this._title,roots:{root_ids:r,references:e._references_json(n,t)}}},e.from_json_string=function(t){var r=JSON.parse(t);return e.from_json(r)},e.from_json=function(t){var r,n;s.logger.debug("Creating Document from JSON");var o=t.version,l=-1!==o.indexOf("+")||-1!==o.indexOf("-"),_="Library versions: JS ("+i.version+") / Python ("+o+")";l||i.version.replace(/-(dev|rc)\./,"$1")==o?s.logger.debug(_):(s.logger.warn("JS/Python version mismatch"),s.logger.warn(_));var c=t.roots,u=c.root_ids,f=c.references,d=e._instantiate_references_json(f,new Map);e._initialize_references_json(f,new Map,d,new Map);var h=new e;try{for(var v=a.__values(u),y=v.next();!y.done;y=v.next()){var p=y.value,m=d.get(p);null!=m&&h.add_root(m)}}catch(e){r={error:e}}finally{try{y&&!y.done&&(n=v.return)&&n.call(v)}finally{if(r)throw r.error}}return h.set_title(t.title),h},e.prototype.replace_with_json=function(t){e.from_json(t).destructively_move(this)},e.prototype.create_json_patch_string=function(e){return JSON.stringify(this.create_json_patch(e))},e.prototype.create_json_patch=function(t){var r,n,o=new Set,l=[];try{for(var i=a.__values(t),_=i.next();!_.done;_=i.next()){var c=_.value;if(c.document!==this)throw s.logger.warn("Cannot create a patch using events from a different document, event had ",c.document," we are ",this),new Error("Cannot create a patch using events from a different document");l.push(c.json(o))}}catch(e){r={error:e}}finally{try{_&&!_.done&&(n=i.return)&&n.call(i)}finally{if(r)throw r.error}}return{events:l,references:e._references_json(o)}},e.prototype.apply_json_patch=function(t,r,n){var o,l,i,_,c,u,f;void 0===r&&(r=new Map);var d=t.references,h=t.events,v=e._instantiate_references_json(d,this._all_models);r instanceof Map||(r=new Map(r));try{for(var y=a.__values(h),p=y.next();!p.done;p=y.next()){switch((O=p.value).kind){case"RootAdded":case"RootRemoved":case"ModelChanged":var m=O.model.id,w=this._all_models.get(m);if(null!=w)v.set(m,w);else if(!v.has(m))throw s.logger.warn("Got an event for unknown model "+O.model+'"'),new Error("event model wasn't known")}}}catch(e){o={error:e}}finally{try{p&&!p.done&&(l=y.return)&&l.call(y)}finally{if(o)throw o.error}}var x=new Map,b=new Map;try{for(var j=a.__values(v),k=j.next();!k.done;k=j.next()){var M=a.__read(k.value,2),E=M[0],S=M[1];this._all_models.has(E)?x.set(E,S):b.set(E,S)}}catch(e){i={error:e}}finally{try{k&&!k.done&&(_=j.return)&&_.call(j)}finally{if(i)throw i.error}}e._initialize_references_json(d,x,b,r);try{for(var C=a.__values(h),D=C.next();!D.done;D=C.next()){var O;switch((O=D.value).kind){case"MessageSent":var z=O.msg_type,A=O.msg_data,N=void 0;if(void 0===A){if(1!=r.size)throw new Error("expected exactly one buffer");var R=a.__read(r,1);N=a.__read(R[0],2)[1]}else N=e._resolve_refs(A,x,b,r);this._trigger_on_message(z,N);break;case"ModelChanged":var J=O.model.id,P=this._all_models.get(J);if(null==P)throw new Error("Cannot apply patch to "+J+" which is not in the document");var L=O.attr;S=e._resolve_refs(O.new,x,b,r);P.setv(((f={})[L]=S,f),{setter_id:n});break;case"ColumnDataChanged":var T=O.column_source.id;if(null==(B=this._all_models.get(T)))throw new Error("Cannot stream to "+T+" which is not in the document");N=e._resolve_refs(O.new,new Map,new Map,r);if(null!=O.cols)for(var U in B.data)U in N||(N[U]=B.data[U]);B.setv({data:N},{setter_id:n,check_eq:!1});break;case"ColumnsStreamed":T=O.column_source.id;if(null==(B=this._all_models.get(T)))throw new Error("Cannot stream to "+T+" which is not in the document");if(!(B instanceof g.ColumnDataSource))throw new Error("Cannot stream to non-ColumnDataSource");N=O.data;var q=O.rollover;B.stream(N,q,n);break;case"ColumnsPatched":var B;T=O.column_source.id;if(null==(B=this._all_models.get(T)))throw new Error("Cannot patch "+T+" which is not in the document");if(!(B instanceof g.ColumnDataSource))throw new Error("Cannot patch non-ColumnDataSource");var F=O.patches;B.patch(F,n);break;case"RootAdded":var H=O.model.id,I=v.get(H);this.add_root(I,n);break;case"RootRemoved":H=O.model.id,I=v.get(H);this.remove_root(I,n);break;case"TitleChanged":this.set_title(O.title,n);break;default:throw new Error("Unknown patch event "+JSON.stringify(O))}}}catch(e){c={error:e}}finally{try{D&&!D.done&&(u=C.return)&&u.call(C)}finally{if(c)throw c.error}}},e}();r.Document=k,k.__name__="Document"},
function _(e,r,o,s,t){s();var i=e(1),n=e(123),l=e(128),d=e(129);o.overrides={};var a=new Map;o.Models=function(e){var r,s=null!==(r=o.overrides[e])&&void 0!==r?r:a.get(e);if(null==s)throw new Error("Model '"+e+"' does not exist. This could be due to a widget or a custom model not being registered before first usage.");return s},o.Models.register=function(e,r){o.overrides[e]=r},o.Models.unregister=function(e){delete o.overrides[e]},o.Models.register_models=function(e,r,o){var s,t,u;if(void 0===r&&(r=!1),null!=e)try{for(var f=i.__values(l.values(e)),v=f.next();!v.done;v=f.next()){var c=v.value;if(u=c,n.isObject(u)&&u.prototype instanceof d.HasProps){var _=c.__qualified__;r||!a.has(_)?a.set(_,c):null!=o?o(_):console.warn("Model '"+_+"' was already registered")}}}catch(e){s={error:e}}finally{try{v&&!v.done&&(t=f.return)&&t.call(f)}finally{if(s)throw s.error}}},o.register_models=o.Models.register_models,o.Models.registered_names=function(){return Array.from(a.keys())};var u=i.__importStar(e(149));o.register_models(u)},
function _(r,n,t,e,i){e();
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
var o=r(124),u=Object.prototype.toString;function c(r){return"[object Number]"===u.call(r)}function a(r){var n=typeof r;return"function"===n||"object"===n&&!!r}t.isBoolean=function(r){return!0===r||!1===r||"[object Boolean]"===u.call(r)},t.isNumber=c,t.isInteger=function(r){return c(r)&&Number.isInteger(r)},t.isString=function(r){return"[object String]"===u.call(r)},t.isFunction=function(r){return"[object Function]"===u.call(r)},t.isArray=function(r){return Array.isArray(r)},t.isArrayOf=function(r,n){return o.every(r,n)},t.isArrayableOf=function(r,n){for(var t=0,e=r.length;t<e;t++)if(!n(r[t]))return!1;return!0},t.isTypedArray=function(r){return ArrayBuffer.isView(r)&&!(r instanceof DataView)},t.isObject=a,t.isPlainObject=function(r){return a(r)&&(null==r.constructor||r.constructor===Object)},t.isIterable=function(r){return Symbol.iterator in Object(r)}},
function _(r,n,e,t,a){t();var i=r(1),o=r(125),u=r(126),f=r(127);
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
a("map",f.map),a("reduce",f.reduce),a("min",f.min),a("min_by",f.min_by),a("max",f.max),a("max_by",f.max_by),a("sum",f.sum),a("cumsum",f.cumsum),a("every",f.every),a("some",f.some),a("find",f.find),a("find_last",f.find_last),a("find_index",f.find_index),a("find_last_index",f.find_last_index),a("sorted_index",f.sorted_index),a("is_empty",f.is_empty);var l=Array.prototype.slice;function c(r){return l.call(r)}function v(r){return[].concat.apply([],i.__spread(r))}function y(r,n){return-1!==r.indexOf(n)}function d(r,n,e){void 0===e&&(e=1),u.assert(e>0,"'step' must be a positive number"),null==n&&(n=r,r=0);for(var t=r<=n?e:-e,a=(0,Math.max)((0,Math.ceil)((0,Math.abs)(n-r)/e),0),i=new Array(a),o=0;o<a;o++,r+=t)i[o]=r;return i}e.head=function(r){return r[0]},e.tail=function(r){return r[r.length-1]},e.last=function(r){return r[r.length-1]},e.copy=c,e.concat=v,e.includes=y,e.contains=y,e.nth=function(r,n){return r[n>=0?n:r.length+n]},e.zip=function(){for(var r=[],n=0;n<arguments.length;n++)r[n]=arguments[n];if(0==r.length)return[];for(var e=f.min(r.map((function(r){return r.length}))),t=r.length,a=new Array(e),i=0;i<e;i++){a[i]=new Array(t);for(var o=0;o<t;o++)a[i][o]=r[o][i]}return a},e.unzip=function(r){for(var n=r.length,e=f.min(r.map((function(r){return r.length}))),t=Array(e),a=0;a<e;a++)t[a]=new Array(n);for(var i=0;i<n;i++)for(a=0;a<e;a++)t[a][i]=r[i][a];return t},e.range=d,e.linspace=function(r,n,e){void 0===e&&(e=100);for(var t=(n-r)/(e-1),a=new Array(e),i=0;i<e;i++)a[i]=r+t*i;return a},e.transpose=function(r){for(var n=r.length,e=r[0].length,t=[],a=0;a<e;a++){t[a]=[];for(var i=0;i<n;i++)t[a][i]=r[i][a]}return t},e.argmin=function(r){return f.min_by(d(r.length),(function(n){return r[n]}))},e.argmax=function(r){return f.max_by(d(r.length),(function(n){return r[n]}))},e.sort_by=function(r,n){var e=r.map((function(r,e){return{value:r,index:e,key:n(r)}}));return e.sort((function(r,n){var e=r.key,t=n.key;if(e!==t){if(e>t||void 0===e)return 1;if(e<t||void 0===t)return-1}return r.index-n.index})),e.map((function(r){return r.value}))},e.uniq=function(r){var n,e,t=new Set;try{for(var a=i.__values(r),o=a.next();!o.done;o=a.next()){var u=o.value;t.add(u)}}catch(r){n={error:r}}finally{try{o&&!o.done&&(e=a.return)&&e.call(a)}finally{if(n)throw n.error}}return i.__spread(t)},e.uniq_by=function(r,n){var e,t,a=[],o=[];try{for(var u=i.__values(r),f=u.next();!f.done;f=u.next()){var l=f.value,c=n(l);y(o,c)||(o.push(c),a.push(l))}}catch(r){e={error:r}}finally{try{f&&!f.done&&(t=u.return)&&t.call(u)}finally{if(e)throw e.error}}return a},e.union=function(){for(var r,n,e,t,a=[],o=0;o<arguments.length;o++)a[o]=arguments[o];var u=new Set;try{for(var f=i.__values(a),l=f.next();!l.done;l=f.next()){var c=l.value;try{for(var v=(e=void 0,i.__values(c)),y=v.next();!y.done;y=v.next()){var d=y.value;u.add(d)}}catch(r){e={error:r}}finally{try{y&&!y.done&&(t=v.return)&&t.call(v)}finally{if(e)throw e.error}}}}catch(n){r={error:n}}finally{try{l&&!l.done&&(n=f.return)&&n.call(f)}finally{if(r)throw r.error}}return i.__spread(u)},e.intersection=function(r){for(var n,e,t,a,o=[],u=1;u<arguments.length;u++)o[u-1]=arguments[u];var f=[];try{r:for(var l=i.__values(r),c=l.next();!c.done;c=l.next()){var v=c.value;if(!y(f,v)){try{for(var d=(t=void 0,i.__values(o)),s=d.next();!s.done;s=d.next()){var h=s.value;if(!y(h,v))continue r}}catch(r){t={error:r}}finally{try{s&&!s.done&&(a=d.return)&&a.call(d)}finally{if(t)throw t.error}}f.push(v)}}}catch(r){n={error:r}}finally{try{c&&!c.done&&(e=l.return)&&e.call(l)}finally{if(n)throw n.error}}return f},e.difference=function(r){for(var n=[],e=1;e<arguments.length;e++)n[e-1]=arguments[e];var t=v(n);return r.filter((function(r){return!y(t,r)}))},e.remove_at=function(r,n){var e=c(r);return e.splice(n,1),e},e.remove_by=function(r,n){for(var e=0;e<r.length;)n(r[e])?r.splice(e,1):e++},e.shuffle=function(r){for(var n=r.length,e=new Array(n),t=0;t<n;t++){var a=o.randomIn(0,t);a!==t&&(e[t]=e[a]),e[a]=r[t]}return e},e.pairwise=function(r,n){for(var e=r.length,t=new Array(e-1),a=0;a<e-1;a++)t[a]=n(r[a],r[a+1]);return t},e.reversed=function(r){for(var n=r.length,e=new Array(n),t=0;t<n;t++)e[n-t-1]=r[t];return e},e.repeat=function(r,n){for(var e=new Array(n),t=0;t<n;t++)e[t]=r;return e}},
function _(n,t,r,a,o){function u(n){if(0==n)return 0;for(;n<=0;)n+=2*Math.PI;for(;n>2*Math.PI;)n-=2*Math.PI;return n}function e(n,t){return u(n-t)}function f(){return Math.random()}a(),r.angle_norm=u,r.angle_dist=e,r.angle_between=function(n,t,r,a){void 0===a&&(a=!1);var o=e(t,r);if(0==o)return!1;if(o==2*Math.PI)return!0;var f=u(n),i=e(t,f)<=o&&e(f,r)<=o;return a?!i:i},r.random=f,r.randomIn=function(n,t){return null==t&&(t=n,n=0),n+Math.floor(Math.random()*(t-n+1))},r.atan2=function(n,t){return Math.atan2(t[1]-n[1],t[0]-n[0])},r.radians=function(n){return n*(Math.PI/180)},r.degrees=function(n){return n/(Math.PI/180)},r.rnorm=function(n,t){for(var r,a;r=f(),a=(2*(a=f())-1)*Math.sqrt(1/Math.E*2),!(-4*r*r*Math.log(r)>=a*a););var o=a/r;return o=n+t*o},r.clamp=function(n,t,r){return n<t?t:n>r?r:n},r.log=function(n,t){return void 0===t&&(t=Math.E),Math.log(n)/Math.log(t)}},
function _(r,n,e,t,o){t();var i=r(1),s=function(r){function n(){return null!==r&&r.apply(this,arguments)||this}return i.__extends(n,r),n}(Error);e.AssertionError=s,s.__name__="AssertionError",e.assert=function(r,n){if(!(!0===r||!1!==r&&r()))throw new s(null!=n?n:"Assertion failed")},e.unreachable=function(){throw new Error("unreachable code")}},
function _(r,n,t,e,i){e();var o=r(1),u=r(123),f=r(125);function a(r,n,t){for(var e,i,u=[],f=3;f<arguments.length;f++)u[f-3]=arguments[f];var a=r.length;n<0&&(n+=a),n<0?n=0:n>a&&(n=a),null==t||t>a-n?t=a-n:t<0&&(t=0);for(var l=a-t+u.length,c=new r.constructor(l),v=0;v<n;v++)c[v]=r[v];try{for(var h=o.__values(u),g=h.next();!g.done;g=h.next()){var s=g.value;c[v++]=s}}catch(r){e={error:r}}finally{try{g&&!g.done&&(i=h.return)&&i.call(h)}finally{if(e)throw e.error}}for(var d=n+t;d<a;d++)c[v++]=r[d];return c}function l(r,n){return a(r,n,r.length-n)}function c(r,n){for(var t=r.length,e=new r.constructor(t),i=0;i<t;i++)e[i]=n(r[i],i,r);return e}function v(r,n,t){var e,i,o=r.length;if(void 0===t&&0==o)throw new Error("can't reduce an empty array without an initial value");for(void 0===t?(e=r[0],i=1):(e=t,i=0);i<o;i++)e=n(e,r[i],i,r);return e}function h(r){return function(n,t){for(var e=n.length,i=r>0?0:e-1;i>=0&&i<e;i+=r)if(t(n[i]))return i;return-1}}function g(r,n){for(var t=0,e=r.length;t<e;){var i=Math.floor((t+e)/2);r[i]<n?t=i+1:e=i}return t}function s(r,n,t,e,i){var o=(i-t)/(e-n),u=o*(r-n)+t;return isFinite(u)||(u=o*(r-e)+i,isFinite(u)||t!=i||(u=t)),u}function d(r,n){if(r<n[0])return-1;if(r>n[n.length-1])return n.length;for(var t=0,e=n.length-1;e-t!=1;){var i=t+Math.floor((e-t)/2);r>=n[i]?t=i:e=i}return t}t.is_empty=function(r){return 0==r.length},t.copy=function(r){return u.isArray(r)?r.slice():new r.constructor(r)},t.splice=a,t.head=l,t.insert=function(r,n,t){return a(r,t,0,n)},t.append=function(r,n){return a(r,r.length,0,n)},t.prepend=function(r,n){return a(r,0,0,n)},t.indexOf=function(r,n){for(var t=0,e=r.length;t<e;t++)if(r[t]===n)return t;return-1},t.subselect=function(r,n){for(var t=n.length,e=new r.constructor(t),i=0;i<t;i++)e[i]=r[n[i]];return e},t.map=c,t.filter=function(r,n){for(var t=r.length,e=new r.constructor(t),i=0,o=0;o<t;o++){var u=r[o];n(u,o,r)&&(e[i++]=u)}return l(e,i)},t.reduce=v,t.min=function(r){for(var n,t=1/0,e=0,i=r.length;e<i;e++)n=r[e],!isNaN(n)&&n<t&&(t=n);return t},t.max=function(r){for(var n,t=-1/0,e=0,i=r.length;e<i;e++)n=r[e],!isNaN(n)&&n>t&&(t=n);return t},t.minmax=function(r){for(var n,t=1/0,e=-1/0,i=0,o=r.length;i<o;i++)n=r[i],isNaN(n)||(n<t&&(t=n),n>e&&(e=n));return[t,e]},t.min_by=function(r,n){if(0==r.length)throw new Error("min_by() called with an empty array");for(var t=r[0],e=n(t),i=1,o=r.length;i<o;i++){var u=r[i],f=n(u);f<e&&(t=u,e=f)}return t},t.max_by=function(r,n){if(0==r.length)throw new Error("max_by() called with an empty array");for(var t=r[0],e=n(t),i=1,o=r.length;i<o;i++){var u=r[i],f=n(u);f>e&&(t=u,e=f)}return t},t.sum=function(r){for(var n=0,t=0,e=r.length;t<e;t++)n+=r[t];return n},t.cumsum=function(r){var n=new r.constructor(r.length);return v(r,(function(r,t,e){return n[e]=r+t}),0),n},t.every=function(r,n){for(var t=0,e=r.length;t<e;t++)if(!n(r[t]))return!1;return!0},t.some=function(r,n){for(var t=0,e=r.length;t<e;t++)if(n(r[t]))return!0;return!1},t.index_of=function(r,n){for(var t=0,e=r.length;t<e;t++)if(r[t]===n)return t;return-1},t.find_index=h(1),t.find_last_index=h(-1),t.find=function(r,n){var e=t.find_index(r,n);return-1==e?void 0:r[e]},t.find_last=function(r,n){var e=t.find_last_index(r,n);return-1==e?void 0:r[e]},t.sorted_index=g,t.bin_counts=function(r,n){for(var t=n.length-1,e=Array(t).fill(0),i=0;i<r.length;i++){var o=g(n,r[i]);e[f.clamp(o-1,0,t-1)]+=1}return e},t.interpolate=function(r,n,t){for(var e=r.length,i=new Array(e),o=0;o<e;o++){var u=r[o];if(isNaN(u))i[o]=u;else{var f=d(u,n);if(-1==f)i[o]=t[0];else if(f==n.length)i[o]=t[t.length-1];else if(f==n.length-1||n[f]==u)i[o]=t[f];else{var a=n[f],l=t[f],c=n[f+1],v=t[f+1];i[o]=s(u,a,l,c,v)}}}return i},t.left_edge_index=d,t.norm=function(r,n,t){var e=t-n;return c(r,(function(r){return(r-n)/e}))}},
function _(e,r,t,n,a){n();var c=e(1),o=e(124);function l(e){return Object.keys(e).length}t.keys=Object.keys,t.values=Object.values,t.entries=Object.entries,t.extend=Object.assign,t.clone=function(e){return Object.assign({},e)},t.merge=function(e,r){var t,n,a=Object.create(Object.prototype),l=o.concat([Object.keys(e),Object.keys(r)]);try{for(var u=c.__values(l),i=u.next();!i.done;i=u.next()){var s=i.value,y=e.hasOwnProperty(s)?e[s]:[],f=r.hasOwnProperty(s)?r[s]:[];a[s]=o.union(y,f)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(n=u.return)&&n.call(u)}finally{if(t)throw t.error}}return a},t.size=l,t.isEmpty=function(e){return 0==l(e)},t.to_object=function(e){var r,t,n={};try{for(var a=c.__values(e),o=a.next();!o.done;o=a.next()){var l=c.__read(o.value,2),u=l[0],i=l[1];n[u]=i}}catch(e){r={error:e}}finally{try{o&&!o.done&&(t=a.return)&&t.call(a)}finally{if(r)throw r.error}}return n}},
function _(r,e,t,n,a){n();var o=r(1),i=r(130),l=r(132),s=o.__importStar(r(133)),u=o.__importStar(r(136)),c=o.__importStar(r(143)),_=r(144),f=r(124),v=r(128),y=r(123),p=r(140),d=r(120),h=r(145),g=r(146),x=r(140),w=r(148),b=o.__importStar(r(136)),m=function(r){function e(e){var t,n;void 0===e&&(e={});var a,l=this;(l=r.call(this)||this)._subtype=void 0,l.document=null,l.destroyed=new i.Signal0(l,"destroyed"),l.change=new i.Signal0(l,"change"),l.transformchange=new i.Signal0(l,"transformchange"),l.properties={},l._pending=!1,l._changing=!1;var c=e instanceof Map?e.get:function(r){return e[r]};try{for(var _=o.__values(v.entries(l._props)),f=_.next();!f.done;f=_.next()){var y=o.__read(f.value,2),p=y[0],d=y[1],h=d.type,g=d.default_value,x=d.options,w=void 0;w=h instanceof s.PropertyAlias?l.properties[h.attr]:h instanceof u.Kind?new s.PrimitiveProperty(l,p,h,g,c(p),x):new h(l,p,u.Any,g,c(p),x),l.properties[p]=w}}catch(r){t={error:r}}finally{try{f&&!f.done&&(n=_.return)&&n.call(_)}finally{if(t)throw t.error}}return null!==(a=c("__deferred__"))&&void 0!==a&&a||(l.finalize(),l.connect_signals()),l}return o.__extends(e,r),Object.defineProperty(e.prototype,"type",{get:function(){return this.constructor.__qualified__},set:function(r){console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead"),this.constructor.__name__=r},enumerable:!1,configurable:!0}),Object.defineProperty(e,"__qualified__",{get:function(){var r=this.__module__,e=this.__name__;return null!=r?r+"."+e:e},enumerable:!1,configurable:!0}),Object.defineProperty(e,Symbol.toStringTag,{get:function(){return this.__name__},enumerable:!1,configurable:!0}),e.init_HasProps=function(){this.prototype._props={},this.prototype._mixins=[],this.define((function(r){return{id:[r.String,function(){return _.uniqueId()}]}}))},e._fix_default=function(r,e){if(void 0!==r){if(y.isFunction(r))return r;if(y.isArray(r))return function(){return f.copy(r)};if(y.isPlainObject(r))return function(){return v.clone(r)};if(y.isObject(r))throw new Error(r+" must be explicitly wrapped in a function");return function(){return r}}},e.define=function(r){var e,t,n=function(r,e){if(null!=a.prototype._props[r])throw new Error("attempted to redefine property '"+a.prototype.type+"."+r+"'");if(null!=a.prototype[r])throw new Error("attempted to redefine attribute '"+a.prototype.type+"."+r+"'");Object.defineProperty(a.prototype,r,{get:function(){return this.properties[r].get_value()},set:function(e){var t;return this.setv(((t={})[r]=e,t)),this},configurable:!1,enumerable:!0});var t=o.__read(e,3),n=t[0],i=t[1],l=t[2],s={type:n,default_value:a._fix_default(i,r),options:l},u=v.clone(a.prototype._props);u[r]=s,a.prototype._props=u},a=this;try{for(var i=o.__values(v.entries(y.isFunction(r)?r(b):r)),l=i.next();!l.done;l=i.next()){var s=o.__read(l.value,2);n(s[0],s[1])}}catch(r){e={error:r}}finally{try{l&&!l.done&&(t=i.return)&&t.call(i)}finally{if(e)throw e.error}}},e.internal=function(r){var e,t,n={};try{for(var a=o.__values(v.entries(y.isFunction(r)?r(b):r)),i=a.next();!i.done;i=a.next()){var l=o.__read(i.value,2),s=l[0],u=l[1],c=o.__read(u,3),_=c[0],f=c[1],p=c[2],d=void 0===p?{}:p;n[s]=[_,f,Object.assign(Object.assign({},d),{internal:!0})]}}catch(r){e={error:r}}finally{try{i&&!i.done&&(t=a.return)&&t.call(a)}finally{if(e)throw e.error}}this.define(n)},e.mixins=function(r){var e,t;function n(r){switch(r){case"line":return c.LineVector;case"fill":return c.FillVector;case"hatch":return c.HatchVector;case"text":return c.TextVector;default:throw new Error("Unknown property mixin kind '"+r+"'")}}function a(r,e){var t,n,a={};try{for(var i=o.__values(v.entries(e)),l=i.next();!l.done;l=i.next()){var s=o.__read(l.value,2),u=s[0],c=s[1];a[r+u]=c}}catch(r){t={error:r}}finally{try{l&&!l.done&&(n=i.return)&&n.call(i)}finally{if(t)throw t.error}}return a}function i(r){var e=o.__read(Object.keys(r),1)[0];return o.__read(e.split("_",1),1)[0]}y.isArray(r)||(r=[r]);var l={},s=[];try{for(var u=o.__values(r),_=u.next();!_.done;_=u.next()){var f=_.value;if(y.isString(f)){var p=o.__read(f.split(":"),2),d=p[0],h=p[1],g=void 0===h?"":h,x=n(d);s.push(f),v.extend(l,a(g,x))}else if(y.isArray(f)){var w=o.__read(f,2);g=w[0],x=w[1];s.push(i(x)+":"+g),v.extend(l,a(g,x))}else{x=f;s.push(i(x)),v.extend(l,x)}}}catch(r){e={error:r}}finally{try{_&&!_.done&&(t=u.return)&&t.call(u)}finally{if(e)throw e.error}}this.define(l),this.prototype._mixins=o.__spread(this.prototype._mixins,s)},e.override=function(r){var e,t;try{for(var n=o.__values(v.entries(r)),a=n.next();!a.done;a=n.next()){var i=o.__read(a.value,2),l=i[0],s=i[1],u=this._fix_default(s,l),c=this.prototype._props[l];if(null==c)throw new Error("attempted to override nonexistent '"+this.prototype.type+"."+l+"'");var _=v.clone(this.prototype._props);_[l]=Object.assign(Object.assign({},c),{default_value:u}),this.prototype._props=_}}catch(r){e={error:r}}finally{try{a&&!a.done&&(t=n.return)&&t.call(n)}finally{if(e)throw e.error}}},e.prototype.toString=function(){return this.type+"("+this.id+")"},e.prototype.property=function(r){var e=this.properties[r];if(null!=e)return e;throw new Error("unknown property "+this.type+"."+r)},Object.defineProperty(e.prototype,"attributes",{get:function(){var r,e,t={};try{for(var n=o.__values(this),a=n.next();!a.done;a=n.next()){var i=a.value;t[i.attr]=i.get_value()}}catch(e){r={error:e}}finally{try{a&&!a.done&&(e=n.return)&&e.call(n)}finally{if(r)throw r.error}}return t},enumerable:!1,configurable:!0}),e.prototype[x.equals]=function(r,e){var t,n;try{for(var a=o.__values(this),i=a.next();!i.done;i=a.next()){var l=i.value,s=r.property(l.attr);if(e.eq(l.get_value(),s.get_value()))return!1}}catch(r){t={error:r}}finally{try{i&&!i.done&&(n=a.return)&&n.call(a)}finally{if(t)throw t.error}}return!0},e.prototype[w.pretty]=function(r){var e,t,n=r.token,a=[];try{for(var i=o.__values(this),l=i.next();!l.done;l=i.next()){var s=l.value;if(s.dirty){var u=s.get_value();a.push(""+s.attr+n(":")+" "+r.to_string(u))}}}catch(r){e={error:r}}finally{try{l&&!l.done&&(t=i.return)&&t.call(i)}finally{if(e)throw e.error}}return""+this.constructor.__qualified__+n("(")+n("{")+a.join(n(",")+" ")+n("}")+n(")")},e.prototype.finalize=function(){var r,e,t=this;try{for(var n=o.__values(this),a=n.next();!a.done;a=n.next()){var i=a.value;null!=i.spec.transform&&this.connect(i.spec.transform.change,(function(){return t.transformchange.emit()}))}}catch(e){r={error:e}}finally{try{a&&!a.done&&(e=n.return)&&e.call(n)}finally{if(r)throw r.error}}this.initialize()},e.prototype.initialize=function(){},e.prototype.connect_signals=function(){},e.prototype.disconnect_signals=function(){i.Signal.disconnectReceiver(this)},e.prototype.destroy=function(){this.disconnect_signals(),this.destroyed.emit()},e.prototype.clone=function(){return new this.constructor(this.attributes)},e.prototype._setv=function(r,e){var t,n,a,i,l=e.check_eq,s=[],u=this._changing;this._changing=!0;try{for(var c=o.__values(r),_=c.next();!_.done;_=c.next()){var f=o.__read(_.value,2),v=f[0],y=f[1];!1!==l&&p.is_equal(v.get_value(),y)||(v.set_value(y),s.push(v))}}catch(r){t={error:r}}finally{try{_&&!_.done&&(n=c.return)&&n.call(c)}finally{if(t)throw t.error}}s.length>0&&(this._pending=!0);try{for(var d=o.__values(s),h=d.next();!h.done;h=d.next()){(v=h.value).change.emit()}}catch(r){a={error:r}}finally{try{h&&!h.done&&(i=d.return)&&i.call(d)}finally{if(a)throw a.error}}if(!u){if(!e.no_change)for(;this._pending;)this._pending=!1,this.change.emit();this._pending=!1,this._changing=!1}},e.prototype.setv=function(r,e){var t,n,a,i,l,s,u,c;void 0===e&&(e={});var _=v.entries(r);if(0!=_.length)if(!0!==e.silent){var f=new Map,y=new Map;try{for(var p=o.__values(_),d=p.next();!d.done;d=p.next()){var h=o.__read(d.value,2),g=(M=h[0],V=h[1],this.properties[M]);f.set(g,V),y.set(g,g.get_value())}}catch(r){a={error:r}}finally{try{d&&!d.done&&(i=p.return)&&i.call(p)}finally{if(a)throw a.error}}this._setv(f,e);var x=this.document;if(null!=x){var w=[];try{for(var b=o.__values(y),m=b.next();!m.done;m=b.next()){var j=o.__read(m.value,2);g=j[0],V=j[1];w.push([g,V,g.get_value()])}}catch(r){l={error:r}}finally{try{m&&!m.done&&(s=b.return)&&s.call(b)}finally{if(l)throw l.error}}try{for(var S=o.__values(w),O=S.next();!O.done;O=S.next()){var P=o.__read(O.value,3),A=P[1],E=P[2];if(this._needs_invalidate(A,E)){x._invalidate_all_models();break}}}catch(r){u={error:r}}finally{try{O&&!O.done&&(c=S.return)&&c.call(S)}finally{if(u)throw u.error}}this._push_changes(w,e)}}else try{for(var q=o.__values(_),z=q.next();!z.done;z=q.next()){var k=o.__read(z.value,2),M=k[0],V=k[1];this.properties[M].set_value(V)}}catch(r){t={error:r}}finally{try{z&&!z.done&&(n=q.return)&&n.call(q)}finally{if(t)throw t.error}}},e.prototype.getv=function(r){return this.property(r).get_value()},e.prototype.ref=function(){return{id:this.id}},e.prototype.struct=function(){var r={type:this.type,id:this.id,attributes:{}};return null!=this._subtype&&(r.subtype=this._subtype),r},e.prototype.set_subtype=function(r){this._subtype=r},e.prototype[Symbol.iterator]=function(){return o.__generator(this,(function(r){switch(r.label){case 0:return[5,o.__values(v.values(this.properties))];case 1:return r.sent(),[2]}}))},e.prototype.syncable_properties=function(){var r,e,t,n,a,i;return o.__generator(this,(function(l){switch(l.label){case 0:l.trys.push([0,5,6,7]),r=o.__values(this),e=r.next(),l.label=1;case 1:return e.done?[3,4]:(t=e.value).syncable?[4,t]:[3,3];case 2:l.sent(),l.label=3;case 3:return e=r.next(),[3,1];case 4:return[3,7];case 5:return n=l.sent(),a={error:n},[3,7];case 6:try{e&&!e.done&&(i=r.return)&&i.call(r)}finally{if(a)throw a.error}return[7];case 7:return[2]}}))},e.prototype.serializable_attributes=function(){var r,e,t={};try{for(var n=o.__values(this.syncable_properties()),a=n.next();!a.done;a=n.next()){var i=a.value;t[i.attr]=i.get_value()}}catch(e){r={error:e}}finally{try{a&&!a.done&&(e=n.return)&&e.call(n)}finally{if(r)throw r.error}}return t},e._value_to_json=function(r){var t,n;if(r instanceof e)return r.ref();if(h.is_NDArray(r))return g.encode_NDArray(r);if(y.isArray(r)||y.isTypedArray(r)){for(var a=r.length,i=new Array(a),l=0;l<a;l++){var s=r[l];i[l]=e._value_to_json(s)}return i}if(y.isPlainObject(r)){var u={};try{for(var c=o.__values(v.entries(r)),_=c.next();!_.done;_=c.next()){var f=o.__read(_.value,2),p=f[0],d=f[1];u[p]=e._value_to_json(d)}}catch(r){t={error:r}}finally{try{_&&!_.done&&(n=c.return)&&n.call(c)}finally{if(t)throw t.error}}return u}if(null===r||y.isBoolean(r)||y.isNumber(r)||y.isString(r))return r;throw new g.SerializationError(Object.prototype.toString.call(r)+" is not serializable")},e.prototype.attributes_as_json=function(r,t){var n,a;void 0===r&&(r=!0),void 0===t&&(t=e._value_to_json);var i={};try{for(var l=o.__values(this),s=l.next();!s.done;s=l.next()){var u=s.value;u.syncable&&(r||u.dirty)&&(i[u.attr]=t(u.get_value()))}}catch(r){n={error:r}}finally{try{s&&!s.done&&(a=l.return)&&a.call(l)}finally{if(n)throw n.error}}return i},e._json_record_references=function(r,t,n,a){var i,s,u,c,_=a.recursive;if(l.is_ref(t)){var f=r.get_model_by_id(t.id);null==f||n.has(f)||e._value_record_references(f,n,{recursive:_})}else if(y.isArray(t))try{for(var p=o.__values(t),d=p.next();!d.done;d=p.next()){var h=d.value;e._json_record_references(r,h,n,{recursive:_})}}catch(r){i={error:r}}finally{try{d&&!d.done&&(s=p.return)&&s.call(p)}finally{if(i)throw i.error}}else if(y.isPlainObject(t))try{for(var g=o.__values(v.values(t)),x=g.next();!x.done;x=g.next()){h=x.value;e._json_record_references(r,h,n,{recursive:_})}}catch(r){u={error:r}}finally{try{x&&!x.done&&(c=g.return)&&c.call(g)}finally{if(u)throw u.error}}},e._value_record_references=function(r,t,n){var a,i,l,s,u,c,_=n.recursive;if(r instanceof e){if(!t.has(r)&&(t.add(r),_)){var f=r._immediate_references();try{for(var p=o.__values(f),d=p.next();!d.done;d=p.next()){var h=d.value;e._value_record_references(h,t,{recursive:!0})}}catch(r){a={error:r}}finally{try{d&&!d.done&&(i=p.return)&&i.call(p)}finally{if(a)throw a.error}}}}else if(y.isArray(r))try{for(var g=o.__values(r),x=g.next();!x.done;x=g.next()){var w=x.value;e._value_record_references(w,t,{recursive:_})}}catch(r){l={error:r}}finally{try{x&&!x.done&&(s=g.return)&&s.call(g)}finally{if(l)throw l.error}}else if(y.isPlainObject(r))try{for(var b=o.__values(v.values(r)),m=b.next();!m.done;m=b.next()){w=m.value;e._value_record_references(w,t,{recursive:_})}}catch(r){u={error:r}}finally{try{m&&!m.done&&(c=b.return)&&c.call(b)}finally{if(u)throw u.error}}},e.prototype._immediate_references=function(){var r,t,n=new Set;try{for(var a=o.__values(this.syncable_properties()),i=a.next();!i.done;i=a.next()){var l=i.value.get_value();e._value_record_references(l,n,{recursive:!1})}}catch(e){r={error:e}}finally{try{i&&!i.done&&(t=a.return)&&t.call(a)}finally{if(r)throw r.error}}return n},e.prototype.references=function(){var r=new Set;return e._value_record_references(this,r,{recursive:!0}),r},e.prototype._doc_attached=function(){},e.prototype._doc_detached=function(){},e.prototype.attach_document=function(r){if(null!=this.document&&this.document!=r)throw new Error("models must be owned by only a single document");this.document=r,this._doc_attached()},e.prototype.detach_document=function(){this._doc_detached(),this.document=null},e.prototype._needs_invalidate=function(r,t){var n,a,i,l,s=new Set;e._value_record_references(t,s,{recursive:!1});var u=new Set;e._value_record_references(r,u,{recursive:!1});try{for(var c=o.__values(s),_=c.next();!_.done;_=c.next()){var f=_.value;if(!u.has(f))return!0}}catch(r){n={error:r}}finally{try{_&&!_.done&&(a=c.return)&&a.call(c)}finally{if(n)throw n.error}}try{for(var v=o.__values(u),y=v.next();!y.done;y=v.next()){var p=y.value;if(!s.has(p))return!0}}catch(r){i={error:r}}finally{try{y&&!y.done&&(l=v.return)&&l.call(v)}finally{if(i)throw i.error}}return!1},e.prototype._push_changes=function(r,e){var t,n;void 0===e&&(e={});var a=this.document;if(null!=a){var i=e.setter_id,l=[];try{for(var s=o.__values(r),u=s.next();!u.done;u=s.next()){var c=o.__read(u.value,3),_=c[0],f=c[1],v=c[2];_.syncable&&l.push(new d.ModelChangedEvent(a,this,_.attr,f,v,i))}}catch(r){t={error:r}}finally{try{u&&!u.done&&(n=s.return)&&n.call(s)}finally{if(t)throw t.error}}if(0!=l.length){var y=void 0;1==l.length?y=o.__read(l,1)[0]:y=new d.DocumentEventBatch(a,l,i),a._trigger_on_change(y)}}},e.prototype.materialize_dataspecs=function(r){var e,t,n={};try{for(var a=o.__values(this),i=a.next();!i.done;i=a.next()){var l=i.value;if(l instanceof s.VectorSpec&&(!l.optional||null!=l.spec.value||l.dirty)){var u=l.attr,c=l.array(r);n["_"+u]=c,l instanceof s.DistanceSpec&&(n["max_"+u]=f.max(c))}}}catch(r){e={error:r}}finally{try{i&&!i.done&&(t=a.return)&&t.call(a)}finally{if(e)throw e.error}}return n},e.prototype.on_change=function(r,e){var t,n;try{for(var a=o.__values(y.isArray(r)?r:[r]),i=a.next();!i.done;i=a.next()){var l=i.value;this.connect(l.change,e)}}catch(r){t={error:r}}finally{try{i&&!i.done&&(n=a.return)&&n.call(a)}finally{if(t)throw t.error}}},e}(i.Signalable());t.HasProps=m,m.init_HasProps()},
function _(n,r,t,e,l){e();var i=n(1),a=n(131),o=n(124),u=function(){function n(n,r){this.sender=n,this.name=r}return n.prototype.connect=function(n,r){void 0===r&&(r=null),s.has(this.sender)||s.set(this.sender,[]);var t=s.get(this.sender);if(null!=v(t,this,n,r))return!1;var e=null!=r?r:n;f.has(e)||f.set(e,[]);var l=f.get(e),i={signal:this,slot:n,context:r};return t.push(i),l.push(i),!0},n.prototype.disconnect=function(n,r){void 0===r&&(r=null);var t=s.get(this.sender);if(null==t||0===t.length)return!1;var e=v(t,this,n,r);if(null==e)return!1;var l=null!=r?r:n,i=f.get(l);return e.signal=null,d(t),d(i),!0},n.prototype.emit=function(n){var r,t,e,l=null!==(e=s.get(this.sender))&&void 0!==e?e:[];try{for(var a=i.__values(l),o=a.next();!o.done;o=a.next()){var u=o.value,c=u.signal,f=u.slot,v=u.context;c===this&&f.call(v,n,this.sender)}}catch(n){r={error:n}}finally{try{o&&!o.done&&(t=a.return)&&t.call(a)}finally{if(r)throw r.error}}},n}();t.Signal=u,u.__name__="Signal";var c=function(n){function r(){return null!==n&&n.apply(this,arguments)||this}return i.__extends(r,n),r.prototype.emit=function(){n.prototype.emit.call(this,void 0)},r}(u);t.Signal0=c,c.__name__="Signal0",function(n){n.disconnectBetween=function(n,r){var t,e,l=s.get(n);if(null!=l&&0!==l.length){var a=f.get(r);if(null!=a&&0!==a.length){try{for(var o=i.__values(a),u=o.next();!u.done;u=o.next()){var c=u.value;if(null==c.signal)return;c.signal.sender===n&&(c.signal=null)}}catch(n){t={error:n}}finally{try{u&&!u.done&&(e=o.return)&&e.call(o)}finally{if(t)throw t.error}}d(l),d(a)}}},n.disconnectSender=function(n){var r,t,e,l=s.get(n);if(null!=l&&0!==l.length){try{for(var a=i.__values(l),o=a.next();!o.done;o=a.next()){var u=o.value;if(null==u.signal)return;var c=null!==(e=u.context)&&void 0!==e?e:u.slot;u.signal=null,d(f.get(c))}}catch(n){r={error:n}}finally{try{o&&!o.done&&(t=a.return)&&t.call(a)}finally{if(r)throw r.error}}d(l)}},n.disconnectReceiver=function(n){var r,t,e=f.get(n);if(null!=e&&0!==e.length){try{for(var l=i.__values(e),a=l.next();!a.done;a=l.next()){var o=a.value;if(null==o.signal)return;var u=o.signal.sender;o.signal=null,d(s.get(u))}}catch(n){r={error:n}}finally{try{a&&!a.done&&(t=l.return)&&t.call(l)}finally{if(r)throw r.error}}d(e)}},n.disconnectAll=function(n){var r,t,e,l,a=s.get(n);if(null!=a&&0!==a.length){try{for(var o=i.__values(a),u=o.next();!u.done;u=o.next()){u.value.signal=null}}catch(n){r={error:n}}finally{try{u&&!u.done&&(t=o.return)&&t.call(o)}finally{if(r)throw r.error}}d(a)}var c=f.get(n);if(null!=c&&0!==c.length){try{for(var v=i.__values(c),h=v.next();!h.done;h=v.next()){h.value.signal=null}}catch(n){e={error:n}}finally{try{h&&!h.done&&(l=v.return)&&l.call(v)}finally{if(e)throw e.error}}d(c)}}}(u||(t.Signal=u={})),t.Signalable=function(){return function(){function n(){}return n.prototype.connect=function(n,r){return n.connect(r,this)},n.prototype.disconnect=function(n,r){return n.disconnect(r,this)},n}()};var s=new WeakMap,f=new WeakMap;function v(n,r,t,e){return o.find(n,(function(n){return n.signal===r&&n.slot===t&&n.context===e}))}var h=new Set;function d(n){0===h.size&&a.defer(g),h.add(n)}function g(){var n,r;try{for(var t=i.__values(h),e=t.next();!e.done;e=t.next()){var l=e.value;o.remove_by(l,(function(n){return null==n.signal}))}}catch(r){n={error:r}}finally{try{e&&!e.done&&(r=t.return)&&r.call(t)}finally{if(n)throw n.error}}h.clear()}},
function _(n,t,e,r,u){r(),e.delay=
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
function(n,t){return setTimeout(n,t)};var i="function"==typeof requestAnimationFrame?requestAnimationFrame:setImmediate;e.defer=function(n){return new Promise((function(t){i((function(){return t(n())}))}))},e.throttle=function(n,t,e){var r,u,i;void 0===e&&(e={});var o=null,a=0,l=function(){a=!1===e.leading?0:Date.now(),o=null,i=n.apply(r,u),o||(r=u=null)};return function(){var c=Date.now();a||!1!==e.leading||(a=c);var f=t-(c-a);return r=this,u=arguments,f<=0||f>t?(o&&(clearTimeout(o),o=null),a=c,i=n.apply(r,u),o||(r=u=null)):o||!1===e.trailing||(o=setTimeout(l,f)),i}},e.once=function(n){var t,e=!1;return function(){return e||(e=!0,t=n()),t}}},
function _(n,i,r,e,t){e();var f=n(123),u=n(128);r.is_ref=function(n){if(f.isPlainObject(n)){var i=u.keys(n);return 1==i.length&&"id"==i[0]}return!1}},
function _(n,t,e,r,i){r();var o=n(1),a=n(130),u=n(134),l=o.__importStar(n(135)),_=n(139),s=n(124),c=n(127),p=n(137),f=n(123),d=n(142);function h(n){try{return JSON.stringify(n)}catch(t){return n.toString()}}function y(n){return f.isPlainObject(n)&&(void 0===n.value?0:1)+(void 0===n.field?0:1)+(void 0===n.expr?0:1)==1}e.isSpec=y;var v=function(){function n(n,t,e,r,i,o){var u,l,_;if(void 0===o&&(o={}),this.obj=n,this.attr=t,this.kind=e,this.default_value=r,this._dirty=!1,this.change=new a.Signal0(this.obj,"change"),this.internal=null!==(u=o.internal)&&void 0!==u&&u,this.optional=null!==(l=o.optional)&&void 0!==l&&l,this.on_update=o.on_update,void 0!==i)_=i,this._dirty=!0;else{var s=this._default_override();if(void 0!==s)_=s;else{if(void 0===r)return void(this.spec={value:null});_=r(n)}}this._update(_)}return Object.defineProperty(n.prototype,"is_value",{get:function(){return void 0!==this.spec.value},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"syncable",{get:function(){return!this.internal},enumerable:!1,configurable:!0}),n.prototype.get_value=function(){return this.spec.value},n.prototype.set_value=function(n){this._update(n),this._dirty=!0},n.prototype._default_override=function(){},Object.defineProperty(n.prototype,"dirty",{get:function(){return this._dirty},enumerable:!1,configurable:!0}),n.prototype._update=function(n){var t;this.validate(n),this.spec={value:n},null===(t=this.on_update)||void 0===t||t.call(this,n,this.obj)},n.prototype.toString=function(){return"Prop("+this.obj+"."+this.attr+", spec: "+h(this.spec)+")"},n.prototype.normalize=function(n){return n},n.prototype.validate=function(n){if(!this.valid(n))throw new Error(this.obj+"."+this.attr+" given invalid value: "+h(n))},n.prototype.valid=function(n){return this.kind.valid(n)},n.prototype.value=function(n){if(void 0===n&&(n=!0),!this.is_value)throw new Error("attempted to retrieve property value for property without value specification");var t=this.normalize([this.spec.value])[0];return null!=this.spec.transform&&n&&(t=this.spec.transform.compute(t)),t},n}();e.Property=v,v.__name__="Property";var S=function(n){this.attr=n};e.PropertyAlias=S,S.__name__="PropertyAlias",e.Alias=function(n){return new S(n)};var m=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(v);e.PrimitiveProperty=m,m.__name__="PrimitiveProperty";var g=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(v);e.Any=g,g.__name__="Any";var x=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype.valid=function(n){return f.isArray(n)||n instanceof Float32Array||n instanceof Float64Array},t}(v);e.Array=x,x.__name__="Array";var b=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype.valid=function(n){return f.isBoolean(n)},t}(v);e.Boolean=b,b.__name__="Boolean";var P=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype.valid=function(n){return f.isString(n)&&p.is_color(n)},t}(v);e.Color=P,P.__name__="Color";var A=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(v);e.Instance=A,A.__name__="Instance";var C=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype.valid=function(n){return f.isNumber(n)},t}(v);e.Number=C,C.__name__="Number";var L=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype.valid=function(n){return f.isNumber(n)&&(0|n)==n},t}(C);e.Int=L,L.__name__="Int";var N=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(C);e.Angle=N,N.__name__="Angle";var T=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype.valid=function(n){return f.isNumber(n)&&0<=n&&n<=1},t}(C);e.Percent=T,T.__name__="Percent";var q=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype.valid=function(n){return f.isString(n)},t}(v);e.String=q,q.__name__="String";var O=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype.valid=function(n){return null===n||f.isString(n)},t}(v);e.NullString=O,O.__name__="NullString";var B=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(q);e.FontSize=B,B.__name__="FontSize";var D=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype._default_override=function(){return d.settings.dev?"Bokeh":void 0},t}(q);e.Font=D,D.__name__="Font";var M=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype.valid=function(n){return f.isString(n)&&s.includes(this.enum_values,n)},t}(v);function j(n){return function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),Object.defineProperty(e.prototype,"enum_values",{get:function(){return o.__spread(n)},enumerable:!1,configurable:!0}),e}(M)}e.EnumProperty=M,M.__name__="EnumProperty",e.Enum=j;var w=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),Object.defineProperty(t.prototype,"enum_values",{get:function(){return o.__spread(l.Direction)},enumerable:!1,configurable:!0}),t.prototype.normalize=function(n){for(var t=new Uint8Array(n.length),e=0;e<n.length;e++)switch(n[e]){case"clock":t[e]=0;break;case"anticlock":t[e]=1}return t},t}(M);e.Direction=w,w.__name__="Direction",e.Anchor=j(l.Anchor),e.AngleUnits=j(l.AngleUnits),e.BoxOrigin=j(l.BoxOrigin),e.ButtonType=j(l.ButtonType),e.CalendarPosition=j(l.CalendarPosition),e.Dimension=j(l.Dimension),e.Dimensions=j(l.Dimensions),e.Distribution=j(l.Distribution),e.FontStyle=j(l.FontStyle),e.HatchPatternType=j(l.HatchPatternType),e.HTTPMethod=j(l.HTTPMethod),e.HexTileOrientation=j(l.HexTileOrientation),e.HoverMode=j(l.HoverMode),e.LatLon=j(l.LatLon),e.LegendClickPolicy=j(l.LegendClickPolicy),e.LegendLocation=j(l.LegendLocation),e.LineCap=j(l.LineCap),e.LineJoin=j(l.LineJoin),e.LinePolicy=j(l.LinePolicy),e.Location=j(l.Location),e.Logo=j(l.Logo),e.MarkerType=j(l.MarkerType),e.MutedPolicy=j(l.MutedPolicy),e.Orientation=j(l.Orientation),e.OutputBackend=j(l.OutputBackend),e.PaddingUnits=j(l.PaddingUnits),e.Place=j(l.Place),e.PointPolicy=j(l.PointPolicy),e.RadiusDimension=j(l.RadiusDimension),e.RenderLevel=j(l.RenderLevel),e.RenderMode=j(l.RenderMode),e.ResetPolicy=j(l.ResetPolicy),e.RoundingFunction=j(l.RoundingFunction),e.Side=j(l.Side),e.SizingMode=j(l.SizingMode),e.Sort=j(l.Sort),e.SpatialUnits=j(l.SpatialUnits),e.StartEnd=j(l.StartEnd),e.StepMode=j(l.StepMode),e.TapBehavior=j(l.TapBehavior),e.TextAlign=j(l.TextAlign),e.TextBaseline=j(l.TextBaseline),e.TextureRepetition=j(l.TextureRepetition),e.TickLabelOrientation=j(l.TickLabelOrientation),e.TooltipAttachment=j(l.TooltipAttachment),e.UpdateMode=j(l.UpdateMode),e.VerticalAlign=j(l.VerticalAlign);var k=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype.get_value=function(){return null===this.spec.value?null:this.spec},t.prototype._update=function(n){y(n)?this.spec=n:this.spec={value:n},null!=this.spec.value&&this.validate(this.spec.value)},t}(v);e.ScalarSpec=k,k.__name__="ScalarSpec";var F=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(k);e.AnyScalar=F,F.__name__="AnyScalar";var U=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(k);e.ColorScalar=U,U.__name__="ColorScalar";var z=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(k);e.NumberScalar=z,z.__name__="NumberScalar";var R=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(k);e.StringScalar=R,R.__name__="StringScalar";var E=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(k);e.NullStringScalar=E,E.__name__="NullStringScalar";var H=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(k);e.ArrayScalar=H,H.__name__="ArrayScalar";var X=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(k);e.LineJoinScalar=X,X.__name__="LineJoinScalar";var Y=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(k);e.LineCapScalar=Y,Y.__name__="LineCapScalar";var I=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(k);e.FontSizeScalar=I,I.__name__="FontSizeScalar";var J=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(k);e.FontStyleScalar=J,J.__name__="FontStyleScalar";var V=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(k);e.TextAlignScalar=V,V.__name__="TextAlignScalar";var G=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(k);e.TextBaselineScalar=G,G.__name__="TextBaselineScalar";var K=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype.get_value=function(){return null===this.spec.value?null:this.spec},t.prototype._update=function(n){y(n)?this.spec=n:this.spec={value:n},null!=this.spec.value&&this.validate(this.spec.value)},t.prototype.array=function(n){var t,e,r=null!==(t=n.get_length())&&void 0!==t?t:1;if(null!=this.spec.field){var i=n.get_column(this.spec.field);if(null!=i)e=this.normalize(i);else{u.logger.warn("attempted to retrieve property array for nonexistent field '"+this.spec.field+"'");var o=new _.NumberArray(r);o.fill(NaN),e=o}}else if(null!=this.spec.expr)e=this.normalize(this.spec.expr.v_compute(n));else{var a=this.value(!1);if(f.isNumber(a)){var l=new _.NumberArray(r);l.fill(a),e=l}else e=s.repeat(a,r)}return null!=this.spec.transform&&(e=this.spec.transform.v_compute(e)),e},t}(v);e.VectorSpec=K,K.__name__="VectorSpec";var Q=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(K);e.DataSpec=Q,Q.__name__="DataSpec";var W=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype._update=function(t){n.prototype._update.call(this,t),null==this.spec.units&&(this.spec.units=this.default_units);var e=this.spec.units;if(!s.includes(this.valid_units,e))throw new Error("units must be one of "+this.valid_units.join(", ")+"; got: "+e)},Object.defineProperty(t.prototype,"units",{get:function(){return this.spec.units},set:function(n){this.spec.units=n},enumerable:!1,configurable:!0}),t}(K);e.UnitsSpec=W,W.__name__="UnitsSpec";var Z=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype.array=function(t){return new _.NumberArray(n.prototype.array.call(this,t))},t}(W);e.NumberUnitsSpec=Z,Z.__name__="NumberUnitsSpec";var $=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(Q);e.BaseCoordinateSpec=$,$.__name__="BaseCoordinateSpec";var nn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}($);e.CoordinateSpec=nn,nn.__name__="CoordinateSpec";var tn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}($);e.CoordinateSeqSpec=tn,tn.__name__="CoordinateSeqSpec";var en=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}($);e.CoordinateSeqSeqSeqSpec=en,en.__name__="CoordinateSeqSeqSeqSpec";var rn=function(n){function t(){var t=n.apply(this,o.__spread(arguments))||this;return t.dimension="x",t}return o.__extends(t,n),t}(nn);e.XCoordinateSpec=rn,rn.__name__="XCoordinateSpec";var on=function(n){function t(){var t=n.apply(this,o.__spread(arguments))||this;return t.dimension="y",t}return o.__extends(t,n),t}(nn);e.YCoordinateSpec=on,on.__name__="YCoordinateSpec";var an=function(n){function t(){var t=n.apply(this,o.__spread(arguments))||this;return t.dimension="x",t}return o.__extends(t,n),t}(tn);e.XCoordinateSeqSpec=an,an.__name__="XCoordinateSeqSpec";var un=function(n){function t(){var t=n.apply(this,o.__spread(arguments))||this;return t.dimension="y",t}return o.__extends(t,n),t}(tn);e.YCoordinateSeqSpec=un,un.__name__="YCoordinateSeqSpec";var ln=function(n){function t(){var t=n.apply(this,o.__spread(arguments))||this;return t.dimension="x",t}return o.__extends(t,n),t}(en);e.XCoordinateSeqSeqSeqSpec=ln,ln.__name__="XCoordinateSeqSeqSeqSpec";var _n=function(n){function t(){var t=n.apply(this,o.__spread(arguments))||this;return t.dimension="y",t}return o.__extends(t,n),t}(en);e.YCoordinateSeqSeqSeqSpec=_n,_n.__name__="YCoordinateSeqSeqSeqSpec";var sn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),Object.defineProperty(t.prototype,"default_units",{get:function(){return"rad"},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"valid_units",{get:function(){return o.__spread(l.AngleUnits)},enumerable:!1,configurable:!0}),t.prototype.normalize=function(t){return"deg"==this.spec.units&&(t=c.map(t,(function(n){return n*Math.PI/180}))),t=c.map(t,(function(n){return-n})),n.prototype.normalize.call(this,t)},t}(Z);e.AngleSpec=sn,sn.__name__="AngleSpec";var cn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),Object.defineProperty(t.prototype,"default_units",{get:function(){return"data"},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"valid_units",{get:function(){return o.__spread(l.SpatialUnits)},enumerable:!1,configurable:!0}),t}(Z);e.DistanceSpec=cn,cn.__name__="DistanceSpec";var pn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),Object.defineProperty(t.prototype,"default_units",{get:function(){return"screen"},enumerable:!1,configurable:!0}),t}(cn);e.ScreenDistanceSpec=pn,pn.__name__="ScreenDistanceSpec";var fn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype.array=function(t){return new Uint8Array(n.prototype.array.call(this,t))},t}(Q);e.BooleanSpec=fn,fn.__name__="BooleanSpec";var dn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype.array=function(t){return new _.NumberArray(n.prototype.array.call(this,t))},t}(Q);e.NumberSpec=dn,dn.__name__="NumberSpec";var hn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype.array=function(t){for(var e=n.prototype.array.call(this,t),r=e.length,i=new _.ColorArray(r),o=0;o<r;o++){var a=e[o];if(f.isNumber(a))i[o]=a;else{var u=p.color2rgba(a);i[o]=p.encode_rgba(u)}}return i},t}(Q);e.ColorSpec=hn,hn.__name__="ColorSpec";var yn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(Q);e.FontSizeSpec=yn,yn.__name__="FontSizeSpec";var vn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(Q);e.MarkerSpec=vn,vn.__name__="MarkerSpec";var Sn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(Q);e.StringSpec=Sn,Sn.__name__="StringSpec";var mn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(Q);e.NullStringSpec=mn,mn.__name__="NullStringSpec";var gn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t}(Q);e.NDArraySpec=gn,gn.__name__="NDArraySpec"},
function _(e,l,o,n,t){n();var r=e(1),g=e(123),i=e(128),v={},a=function(e,l){this.name=e,this.level=l};o.LogLevel=a,a.__name__="LogLevel";var s=function(){function e(l,o){void 0===o&&(o=e.INFO),this._name=l,this.set_level(o)}return Object.defineProperty(e,"levels",{get:function(){return Object.keys(e.log_levels)},enumerable:!1,configurable:!0}),e.get=function(l,o){if(void 0===o&&(o=e.INFO),l.length>0){var n=v[l];return null==n&&(v[l]=n=new e(l,o)),n}throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level")},Object.defineProperty(e.prototype,"level",{get:function(){return this.get_level()},enumerable:!1,configurable:!0}),e.prototype.get_level=function(){return this._log_level},e.prototype.set_level=function(l){var o,n;if(l instanceof a)this._log_level=l;else{if(!g.isString(l)||null==e.log_levels[l])throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");this._log_level=e.log_levels[l]}var t="["+this._name+"]";try{for(var v=r.__values(i.entries(e.log_levels)),s=v.next();!s.done;s=v.next()){var c=r.__read(s.value,2),_=c[0];c[1].level<this._log_level.level||this._log_level.level===e.OFF.level?this[_]=function(){}:this[_]=f(_,t)}}catch(e){o={error:e}}finally{try{s&&!s.done&&(n=v.return)&&n.call(v)}finally{if(o)throw o.error}}},e.prototype.trace=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.debug=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.info=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.warn=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.error=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e}();function f(e,l){return null!=console[e]?console[e].bind(console,l):null!=console.log?console.log.bind(console,l):function(){}}function c(e){var l=o.logger.level;return g.isString(e)&&null==s.log_levels[e]?(console.log("[bokeh] unrecognized logging level '"+e+"' passed to Bokeh.set_log_level(), ignoring"),console.log("[bokeh] valid log levels are: "+s.levels.join(", "))):(console.log("[bokeh] setting log level to: '"+(g.isString(e)?e:e.level)+"'"),o.logger.set_level(e)),l}o.Logger=s,s.__name__="Logger",s.TRACE=new a("trace",0),s.DEBUG=new a("debug",1),s.INFO=new a("info",2),s.WARN=new a("warn",6),s.ERROR=new a("error",7),s.FATAL=new a("fatal",8),s.OFF=new a("off",9),s.log_levels={trace:s.TRACE,debug:s.DEBUG,info:s.INFO,warn:s.WARN,error:s.ERROR,fatal:s.FATAL,off:s.OFF},o.logger=s.get("bokeh"),o.set_log_level=c,o.with_log_level=function(e,l){var o=c(e);try{l()}finally{c(o)}}},
function _(e,n,t,o,i){o();var a=e(136);t.Align=a.Enum("start","center","end"),t.Anchor=a.Enum("top_left","top_center","top_right","center_left","center","center_right","bottom_left","bottom_center","bottom_right"),t.AngleUnits=a.Enum("deg","rad"),t.BoxOrigin=a.Enum("corner","center"),t.ButtonType=a.Enum("default","primary","success","warning","danger"),t.CalendarPosition=a.Enum("auto","above","below"),t.Dimension=a.Enum("width","height"),t.Dimensions=a.Enum("width","height","both"),t.Direction=a.Enum("clock","anticlock"),t.Distribution=a.Enum("uniform","normal"),t.FontStyle=a.Enum("normal","italic","bold","bold italic"),t.HatchPatternType=a.Enum("blank","dot","ring","horizontal_line","vertical_line","cross","horizontal_dash","vertical_dash","spiral","right_diagonal_line","left_diagonal_line","diagonal_cross","right_diagonal_dash","left_diagonal_dash","horizontal_wave","vertical_wave","criss_cross"," ",".","o","-","|","+",'"',":","@","/","\\","x",",","`","v",">","*"),t.HTTPMethod=a.Enum("POST","GET"),t.HexTileOrientation=a.Enum("pointytop","flattop"),t.HoverMode=a.Enum("mouse","hline","vline"),t.LatLon=a.Enum("lat","lon"),t.LegendClickPolicy=a.Enum("none","hide","mute"),t.LegendLocation=t.Anchor,t.LineCap=a.Enum("butt","round","square"),t.LineJoin=a.Enum("miter","round","bevel"),t.LinePolicy=a.Enum("prev","next","nearest","interp","none"),t.Location=a.Enum("above","below","left","right"),t.Logo=a.Enum("normal","grey"),t.MarkerType=a.Enum("asterisk","circle","circle_cross","circle_dot","circle_x","circle_y","cross","dash","diamond","diamond_cross","diamond_dot","dot","hex","hex_dot","inverted_triangle","plus","square","square_cross","square_dot","square_pin","square_x","triangle","triangle_dot","triangle_pin","x","y"),t.MutedPolicy=a.Enum("show","ignore"),t.Orientation=a.Enum("vertical","horizontal"),t.OutputBackend=a.Enum("canvas","svg","webgl"),t.PaddingUnits=a.Enum("percent","absolute"),t.Place=a.Enum("above","below","left","right","center"),t.PointPolicy=a.Enum("snap_to_data","follow_mouse","none"),t.RadiusDimension=a.Enum("x","y","max","min"),t.RenderLevel=a.Enum("image","underlay","glyph","guide","annotation","overlay"),t.RenderMode=a.Enum("canvas","css"),t.ResetPolicy=a.Enum("standard","event_only"),t.RoundingFunction=a.Enum("round","nearest","floor","rounddown","ceil","roundup"),t.SelectionMode=a.Enum("replace","append","intersect","subtract"),t.Side=a.Enum("above","below","left","right"),t.SizingMode=a.Enum("stretch_width","stretch_height","stretch_both","scale_width","scale_height","scale_both","fixed"),t.Sort=a.Enum("ascending","descending"),t.SpatialUnits=a.Enum("screen","data"),t.StartEnd=a.Enum("start","end"),t.StepMode=a.Enum("after","before","center"),t.TapBehavior=a.Enum("select","inspect"),t.TextAlign=a.Enum("left","right","center"),t.TextBaseline=a.Enum("top","middle","bottom","alphabetic","hanging","ideographic"),t.TextureRepetition=a.Enum("repeat","repeat_x","repeat_y","no_repeat"),t.TickLabelOrientation=a.Enum("vertical","horizontal","parallel","normal"),t.TooltipAttachment=a.Enum("horizontal","vertical","left","right","above","below"),t.UpdateMode=a.Enum("replace","append"),t.VerticalAlign=a.Enum("top","middle","bottom")},
function _(n,t,r,e,i){e();var u=n(1),o=u.__importStar(n(123)),a=n(137),_=n(128),l=window.Map,s=function(){};r.Kind=s,s.__name__="Kind",function(n){var t=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return!0},t}(s);t.__name__="Any",n.Any=t;var r=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return!0},t}(s);r.__name__="Unknown",n.Unknown=r;var e=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return o.isBoolean(n)},t}(s);e.__name__="Boolean",n.Boolean=e;var i=function(n){function t(t){var r=n.call(this)||this;return r.obj_type=t,r}return u.__extends(t,n),t.prototype.valid=function(n){return!0},t}(s);i.__name__="Ref",n.Ref=i;var c=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return!0},t}(s);c.__name__="AnyRef",n.AnyRef=c;var f=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return o.isNumber(n)},t}(s);f.__name__="Number",n.Number=f;var p=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(t){return n.prototype.valid.call(this,t)&&o.isInteger(t)},t}(f);p.__name__="Int",n.Int=p;var y=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(t){return n.prototype.valid.call(this,t)&&0<=t&&t<=1},t}(f);y.__name__="Percent",n.Percent=y;var v=function(n){function t(t){var r=n.call(this)||this;return r.types=t,r.types=t,r}return u.__extends(t,n),t.prototype.valid=function(n){return this.types.some((function(t){return t.valid(n)}))},t}(s);v.__name__="Or",n.Or=v;var d=function(n){function t(t){var r=n.call(this)||this;return r.types=t,r.types=t,r}return u.__extends(t,n),t.prototype.valid=function(n){if(!o.isArray(n))return!1;for(var t=0;t<this.types.length;t++){var r=this.types[t],e=n[t];if(!r.valid(e))return!1}return!0},t}(s);d.__name__="Tuple",n.Tuple=d;var h=function(n){function t(t){var r=n.call(this)||this;return r.struct_type=t,r}return u.__extends(t,n),t.prototype.valid=function(n){if(!o.isPlainObject(n))return!1;var t=this.struct_type;if(_.size(t)!=_.size(n))return!1;for(var r in t)if(t.hasOwnProperty(r)){if(!n.hasOwnProperty(r))return!1;var e=t[r],i=n[r];if(!e.valid(i))return!1}return!0},t}(s);h.__name__="Struct",n.Struct=h;var m=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return o.isArray(n)||o.isTypedArray(n)},t}(s);m.__name__="Arrayable",n.Arrayable=m;var w=function(n){function t(t){var r=n.call(this)||this;return r.item_type=t,r}return u.__extends(t,n),t.prototype.valid=function(n){var t=this;return o.isArray(n)&&n.every((function(n){return t.item_type.valid(n)}))},t}(s);w.__name__="Array",n.Array=w;var K=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return null===n},t}(s);K.__name__="Null",n.Null=K;var x=function(n){function t(t){var r=n.call(this)||this;return r.base_type=t,r}return u.__extends(t,n),t.prototype.valid=function(n){return null===n||this.base_type.valid(n)},t}(s);x.__name__="Nullable",n.Nullable=x;var b=function(n){function t(t){var r=n.call(this)||this;return r.base_type=t,r}return u.__extends(t,n),t.prototype.valid=function(n){return void 0===n||this.base_type.valid(n)},t}(s);b.__name__="Opt",n.Opt=b;var A=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return o.isString(n)},t}(s);A.__name__="String",n.String=A;var S=function(n){function t(t){var r=n.call(this)||this;return r.values=new Set(t),r}return u.__extends(t,n),t.prototype.valid=function(n){return this.values.has(n)},t.prototype[Symbol.iterator]=function(){return u.__generator(this,(function(n){switch(n.label){case 0:return[5,u.__values(this.values)];case 1:return n.sent(),[2]}}))},t}(s);S.__name__="Enum",n.Enum=S;var g=function(n){function t(t){var r=n.call(this)||this;return r.item_type=t,r}return u.__extends(t,n),t.prototype.valid=function(n){if(!o.isPlainObject(n))return!1;for(var t in n)if(n.hasOwnProperty(t)){var r=n[t];if(!this.item_type.valid(r))return!1}return!0},t}(s);g.__name__="Dict",n.Dict=g;var N=function(n){function t(t,r){var e=n.call(this)||this;return e.key_type=t,e.item_type=r,e}return u.__extends(t,n),t.prototype.valid=function(n){var t,r;if(!(n instanceof l))return!1;try{for(var e=u.__values(n.entries()),i=e.next();!i.done;i=e.next()){var o=u.__read(i.value,2),a=o[0],_=o[1];if(!this.key_type.valid(a)||!this.item_type.valid(_))return!1}}catch(n){t={error:n}}finally{try{i&&!i.done&&(r=e.return)&&r.call(e)}finally{if(t)throw t.error}}return!0},t}(s);N.__name__="Map",n.Map=N;var O=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return o.isString(n)&&a.is_color(n)},t}(s);O.__name__="Color",n.Color=O;var P=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return o.isFunction(n)},t}(s);P.__name__="Function",n.Function=P}(r.Kinds||(r.Kinds={})),r.Any=new r.Kinds.Any,r.Unknown=new r.Kinds.Unknown,r.Boolean=new r.Kinds.Boolean,r.Number=new r.Kinds.Number,r.Int=new r.Kinds.Int,r.String=new r.Kinds.String,r.Null=new r.Kinds.Null,r.Nullable=function(n){return new r.Kinds.Nullable(n)},r.Opt=function(n){return new r.Kinds.Opt(n)},r.Or=function(){for(var n=[],t=0;t<arguments.length;t++)n[t]=arguments[t];return new r.Kinds.Or(n)},r.Tuple=function(){for(var n=[],t=0;t<arguments.length;t++)n[t]=arguments[t];return new r.Kinds.Tuple(n)},r.Struct=function(n){return new r.Kinds.Struct(n)},r.Arrayable=new r.Kinds.Arrayable,r.Array=function(n){return new r.Kinds.Array(n)},r.Dict=function(n){return new r.Kinds.Dict(n)},r.Map=function(n,t){return new r.Kinds.Map(n,t)},r.Enum=function(){for(var n=[],t=0;t<arguments.length;t++)n[t]=arguments[t];return new r.Kinds.Enum(n)},r.Ref=function(n){return new r.Kinds.Ref(n)},r.AnyRef=function(){return new r.Kinds.AnyRef},r.Function=function(){return new r.Kinds.Function},r.Percent=new r.Kinds.Percent,r.Alpha=r.Percent,r.Color=new r.Kinds.Color,r.Auto=r.Enum("auto"),r.FontSize=r.String,r.Font=r.String,r.Angle=r.Number},
function _(r,e,n,t,a){t();var i=r(1),l=r(138),o=r(124);function u(r){var e=Number(r).toString(16);return 1==e.length?"0"+e:e}function c(r){if(0==(r+="").indexOf("#"))return r;if(l.is_svg_color(r))return l.svg_colors[r];if(0==r.indexOf("rgb")){var e=r.replace(/^rgba?\(|\s+|\)$/g,"").split(","),n=e.slice(0,3).map(u).join("");return 4==e.length&&(n+=u(Math.floor(255*parseFloat(e[3])))),"#"+n.slice(0,8)}return r}function s(r){var e;switch(r.substring(0,4)){case"rgba":e={start:"rgba(",len:4,alpha:!0};break;case"rgb(":e={start:"rgb(",len:3,alpha:!1};break;default:return!1}if(new RegExp(".*?(\\.).*(,)").test(r))return!1;var n=r.replace(e.start,"").replace(")","").split(",").map(parseFloat);return n.length==e.len&&((!e.alpha||0<=n[3]&&n[3]<=1)&&!o.includes(n.slice(0,3).map((function(r){return 0<=r&&r<=255})),!1))}n.is_color=function(r){return l.is_svg_color(r.toLowerCase())||"#"==r.substring(0,1)||s(r)},n.rgb2hex=function(r,e,n){return"#"+u(255&r)+u(255&e)+u(255&n)},n.color2hex=c,n.encode_rgba=function(r){var e=i.__read(r,4);return(255*e[0]|0)<<24|(255*e[1]|0)<<16|(255*e[2]|0)<<8|255*e[3]|0},n.decode_rgba=function(r){return[(r>>24&255)/255,(r>>16&255)/255,(r>>8&255)/255,(r>>0&255)/255]},n.color2rgba=function(r,e){if(void 0===e&&(e=1),!r)return[0,0,0,0];var n=c(r);(n=n.replace(/ |#/g,"")).length<=4&&(n=n.replace(/(.)/g,"$1$1"));for(var t=n.match(/../g).map((function(r){return parseInt(r,16)/255}));t.length<3;)t.push(0);return t.length<4&&t.push(e),t.slice(0,4)},n.valid_rgb=s},
function _(F,e,r,l,a){l(),r.svg_colors={indianred:"#CD5C5C",lightcoral:"#F08080",salmon:"#FA8072",darksalmon:"#E9967A",lightsalmon:"#FFA07A",crimson:"#DC143C",red:"#FF0000",firebrick:"#B22222",darkred:"#8B0000",pink:"#FFC0CB",lightpink:"#FFB6C1",hotpink:"#FF69B4",deeppink:"#FF1493",mediumvioletred:"#C71585",palevioletred:"#DB7093",coral:"#FF7F50",tomato:"#FF6347",orangered:"#FF4500",darkorange:"#FF8C00",orange:"#FFA500",gold:"#FFD700",yellow:"#FFFF00",lightyellow:"#FFFFE0",lemonchiffon:"#FFFACD",lightgoldenrodyellow:"#FAFAD2",papayawhip:"#FFEFD5",moccasin:"#FFE4B5",peachpuff:"#FFDAB9",palegoldenrod:"#EEE8AA",khaki:"#F0E68C",darkkhaki:"#BDB76B",lavender:"#E6E6FA",thistle:"#D8BFD8",plum:"#DDA0DD",violet:"#EE82EE",orchid:"#DA70D6",fuchsia:"#FF00FF",magenta:"#FF00FF",mediumorchid:"#BA55D3",mediumpurple:"#9370DB",blueviolet:"#8A2BE2",darkviolet:"#9400D3",darkorchid:"#9932CC",darkmagenta:"#8B008B",purple:"#800080",indigo:"#4B0082",slateblue:"#6A5ACD",darkslateblue:"#483D8B",mediumslateblue:"#7B68EE",greenyellow:"#ADFF2F",chartreuse:"#7FFF00",lawngreen:"#7CFC00",lime:"#00FF00",limegreen:"#32CD32",palegreen:"#98FB98",lightgreen:"#90EE90",mediumspringgreen:"#00FA9A",springgreen:"#00FF7F",mediumseagreen:"#3CB371",seagreen:"#2E8B57",forestgreen:"#228B22",green:"#008000",darkgreen:"#006400",yellowgreen:"#9ACD32",olivedrab:"#6B8E23",olive:"#808000",darkolivegreen:"#556B2F",mediumaquamarine:"#66CDAA",darkseagreen:"#8FBC8F",lightseagreen:"#20B2AA",darkcyan:"#008B8B",teal:"#008080",aqua:"#00FFFF",cyan:"#00FFFF",lightcyan:"#E0FFFF",paleturquoise:"#AFEEEE",aquamarine:"#7FFFD4",turquoise:"#40E0D0",mediumturquoise:"#48D1CC",darkturquoise:"#00CED1",cadetblue:"#5F9EA0",steelblue:"#4682B4",lightsteelblue:"#B0C4DE",powderblue:"#B0E0E6",lightblue:"#ADD8E6",skyblue:"#87CEEB",lightskyblue:"#87CEFA",deepskyblue:"#00BFFF",dodgerblue:"#1E90FF",cornflowerblue:"#6495ED",royalblue:"#4169E1",blue:"#0000FF",mediumblue:"#0000CD",darkblue:"#00008B",navy:"#000080",midnightblue:"#191970",cornsilk:"#FFF8DC",blanchedalmond:"#FFEBCD",bisque:"#FFE4C4",navajowhite:"#FFDEAD",wheat:"#F5DEB3",burlywood:"#DEB887",tan:"#D2B48C",rosybrown:"#BC8F8F",sandybrown:"#F4A460",goldenrod:"#DAA520",darkgoldenrod:"#B8860B",peru:"#CD853F",chocolate:"#D2691E",saddlebrown:"#8B4513",sienna:"#A0522D",brown:"#A52A2A",maroon:"#800000",white:"#FFFFFF",snow:"#FFFAFA",honeydew:"#F0FFF0",mintcream:"#F5FFFA",azure:"#F0FFFF",aliceblue:"#F0F8FF",ghostwhite:"#F8F8FF",whitesmoke:"#F5F5F5",seashell:"#FFF5EE",beige:"#F5F5DC",oldlace:"#FDF5E6",floralwhite:"#FFFAF0",ivory:"#FFFFF0",antiquewhite:"#FAEBD7",linen:"#FAF0E6",lavenderblush:"#FFF0F5",mistyrose:"#FFE4E1",gainsboro:"#DCDCDC",lightgray:"#D3D3D3",lightgrey:"#D3D3D3",silver:"#C0C0C0",darkgray:"#A9A9A9",darkgrey:"#A9A9A9",gray:"#808080",grey:"#808080",dimgray:"#696969",dimgrey:"#696969",lightslategray:"#778899",lightslategrey:"#778899",slategray:"#708090",slategrey:"#708090",darkslategray:"#2F4F4F",darkslategrey:"#2F4F4F",black:"#000000"},r.is_svg_color=function(F){return F in r.svg_colors}},
function _(r,t,e,a,n){a();var s=r(1);e.NumberArray=Float32Array,e.ColorArray=Uint32Array;var o=r(140),i=function(){function r(r,t){this.offsets=r,this.array=t}return r.prototype[o.equals]=function(r,t){return t.arrays(this.offsets,r.offsets)&&t.arrays(this.array,r.array)},Object.defineProperty(r.prototype,"length",{get:function(){return this.offsets.length},enumerable:!1,configurable:!0}),r.prototype.clone=function(){return new r(new Uint32Array(this.offsets),new e.NumberArray(this.array))},r.from=function(t){for(var a=t.length,n=new Uint32Array(a),s=0,o=0;o<a;o++){var i=t[o].length;n[o]=s,s+=i}var f=new e.NumberArray(s);for(o=0;o<a;o++)f.set(t[o],n[o]);return new r(n,f)},r.prototype[Symbol.iterator]=function(){var r,t,e,a;return s.__generator(this,(function(n){switch(n.label){case 0:t=(r=this).offsets,e=r.length,a=0,n.label=1;case 1:return a<e?[4,this.array.subarray(t[a],t[a+1])]:[3,4];case 2:n.sent(),n.label=3;case 3:return a++,[3,1];case 4:return[2]}}))},r.prototype.get=function(r){var t=this.offsets;return this.array.subarray(t[r],t[r+1])},r.prototype.set=function(r,t){this.array.set(t,this.offsets[r])},r}();e.RaggedArray=i,i.__name__="RaggedArray",i[Symbol.toStringTag]="RaggedArray",n("Indices",r(141).BitSet)},
function _(r,t,e,n,o){n();var a=r(1);e.equals=Symbol("equals"),e.wildcard=Symbol("wildcard");var c=Object.prototype.toString,i=function(){function r(){this.a_stack=[],this.b_stack=[]}return r.prototype.eq=function(r,t){var n=this;if(Object.is(r,t))return!0;if(r===e.wildcard||t===e.wildcard)return!0;if(null==r||null==t)return r===t;var o=c.call(r);if(o!=c.call(t))return!1;switch(o){case"[object Number]":return this.numbers(r,t);case"[object RegExp]":case"[object String]":return""+r==""+t;case"[object Date]":case"[object Boolean]":return+r==+t}for(var a=this.a_stack,i=this.b_stack,s=a.length;s--;)if(a[s]===r)return i[s]===t;a.push(r),i.push(t);var u=function(){if(null!=r[e.equals]&&null!=t[e.equals])return r[e.equals](t,n);switch(o){case"[object Array]":case"[object Uint8Array]":case"[object Int8Array]":case"[object Uint16Array]":case"[object Int16Array]":case"[object Uint32Array]":case"[object Int32Array]":case"[object Float32Array]":case"[object Float64Array]":return n.arrays(r,t);case"[object Map]":return n.maps(r,t);case"[object Set]":return n.sets(r,t);case"[object Object]":if(r.constructor==t.constructor&&(null==r.constructor||r.constructor===Object))return n.objects(r,t);case"[object Function]":if(r.constructor==t.constructor&&r.constructor===Function)return n.eq(""+r,""+t)}if(r instanceof Node)return n.nodes(r,t);throw Error("can't compare objects of type "+o)}();return a.pop(),i.pop(),u},r.prototype.numbers=function(r,t){return Object.is(r,t)},r.prototype.arrays=function(r,t){var e=r.length;if(e!=t.length)return!1;for(var n=0;n<e;n++)if(!this.eq(r[n],t[n]))return!1;return!0},r.prototype.iterables=function(r,t){for(var e=r[Symbol.iterator](),n=t[Symbol.iterator]();;){var o=e.next(),a=n.next();if(o.done&&a.done)return!0;if(o.done||a.done)return!1;if(!this.eq(o.value,a.value))return!1}},r.prototype.maps=function(r,t){var e,n;if(r.size!=t.size)return!1;try{for(var o=a.__values(r),c=o.next();!c.done;c=o.next()){var i=a.__read(c.value,2),s=i[0],u=i[1];if(!t.has(s)||!this.eq(u,t.get(s)))return!1}}catch(r){e={error:r}}finally{try{c&&!c.done&&(n=o.return)&&n.call(o)}finally{if(e)throw e.error}}return!0},r.prototype.sets=function(r,t){var e,n;if(r.size!=t.size)return!1;try{for(var o=a.__values(r),c=o.next();!c.done;c=o.next()){var i=c.value;if(!t.has(i))return!1}}catch(r){e={error:r}}finally{try{c&&!c.done&&(n=o.return)&&n.call(o)}finally{if(e)throw e.error}}return!0},r.prototype.objects=function(r,t){var e,n,o=Object.keys(r);if(o.length!=Object.keys(t).length)return!1;try{for(var c=a.__values(o),i=c.next();!i.done;i=c.next()){var s=i.value;if(!t.hasOwnProperty(s)||!this.eq(r[s],t[s]))return!1}}catch(r){e={error:r}}finally{try{i&&!i.done&&(n=c.return)&&n.call(c)}finally{if(e)throw e.error}}return!0},r.prototype.nodes=function(r,t){return r.nodeType==t.nodeType&&(r.textContent==t.textContent&&!!this.iterables(r.childNodes,t.childNodes))},r}();e.Comparator=i,i.__name__="Comparator";var s=Math.abs,u=function(r){function t(t){void 0===t&&(t=1e-4);var e=r.call(this)||this;return e.tolerance=t,e}return a.__extends(t,r),t.prototype.numbers=function(t,e){return r.prototype.numbers.call(this,t,e)||s(t-e)<this.tolerance},t}(i);function l(r,t){return(new i).eq(r,t)}e.SimilarComparator=u,u.__name__="SimilarComparator",e.is_equal=l,e.is_similar=function(r,t,e){return new u(e).eq(r,t)},e.isEqual=l},
function _(r,t,e,n,a){n();var s=r(1),i=r(126),o=r(124),u=r(140),c=function(){function r(r,t){void 0===t&&(t=0),this.size=r,this[Symbol.toStringTag]="BitSet",this._count=null,this._nwords=Math.ceil(r/32),0==t||1==t?(this._array=new Uint32Array(this._nwords),1==t&&this._array.fill(4294967295)):(i.assert(t.length==this._nwords,"Initializer size mismatch"),this._array=t)}return r.prototype.clone=function(){return new r(this.size,new Uint32Array(this._array))},r.prototype[u.equals]=function(r,t){if(!t.eq(this.size,r.size))return!1;for(var e=this._nwords,n=this.size%e,a=0==n?e:e-1,s=0;s<a;s++)if(this._array[s]!=r._array[s])return!1;if(0==n)return!0;var i=1<<n-1,o=i-1^i;return(this._array[a]&o)==(r._array[a]&o)},r.all_set=function(t){return new r(t,1)},r.all_unset=function(t){return new r(t,0)},r.from_indices=function(t,e){var n,a,i=new r(t);try{for(var o=s.__values(e),u=o.next();!u.done;u=o.next()){var c=u.value;i.set(c)}}catch(r){n={error:r}}finally{try{u&&!u.done&&(a=o.return)&&a.call(o)}finally{if(n)throw n.error}}return i},r.from_booleans=function(t,e){for(var n=new r(t),a=Math.min(t,e.length),s=0;s<a;s++)e[s]&&n.set(s);return n},r.prototype._check_bounds=function(r){i.assert(0<=r&&r<this.size,"Out of bounds")},r.prototype.get=function(r){this._check_bounds(r);var t=r>>>5,e=31&r;return!!(this._array[t]>>e&1)},r.prototype.set=function(r,t){void 0===t&&(t=!0),this._check_bounds(r),this._count=null;var e=r>>>5,n=31&r;t?this._array[e]|=1<<n:this._array[e]&=~(1<<n)},r.prototype.unset=function(r){this.set(r,!1)},r.prototype[Symbol.iterator]=function(){return s.__generator(this,(function(r){switch(r.label){case 0:return[5,s.__values(this.ones())];case 1:return r.sent(),[2]}}))},Object.defineProperty(r.prototype,"count",{get:function(){var r=this._count;return null==r&&(this._count=r=this._get_count()),r},enumerable:!1,configurable:!0}),r.prototype._get_count=function(){for(var r=this,t=r._array,e=r._nwords,n=r.size,a=0,s=0,i=0;i<e;i++){var o=t[i];if(0==o)s+=32;else for(var u=0;u<32&&s<n;u++,s++)o>>>u&1&&(a+=1)}return a},r.prototype.ones=function(){var r,t,e,n,a,i,o,u;return s.__generator(this,(function(s){switch(s.label){case 0:t=(r=this)._array,e=r._nwords,n=r.size,a=0,i=0,s.label=1;case 1:if(!(i<e))return[3,6];if(0==(o=t[i]))return a+=32,[3,5];u=0,s.label=2;case 2:return u<32&&a<n?o>>>u&1?[4,a]:[3,4]:[3,5];case 3:s.sent(),s.label=4;case 4:return u++,a++,[3,2];case 5:return i++,[3,1];case 6:return[2]}}))},r.prototype.zeros=function(){var r,t,e,n,a,i,o,u;return s.__generator(this,(function(s){switch(s.label){case 0:t=(r=this)._array,e=r._nwords,n=r.size,a=0,i=0,s.label=1;case 1:if(!(i<e))return[3,6];if(4294967295==(o=t[i]))return a+=32,[3,5];u=0,s.label=2;case 2:return u<32&&a<n?o>>>u&1?[3,4]:[4,a]:[3,5];case 3:s.sent(),s.label=4;case 4:return u++,a++,[3,2];case 5:return i++,[3,1];case 6:return[2]}}))},r.prototype._check_size=function(r){i.assert(this.size==r.size,"Size mismatch")},r.prototype.add=function(r){this._check_size(r);for(var t=0;t<this._nwords;t++)this._array[t]|=r._array[t]},r.prototype.intersect=function(r){this._check_size(r);for(var t=0;t<this._nwords;t++)this._array[t]&=r._array[t]},r.prototype.subtract=function(r){this._check_size(r);for(var t=0;t<this._nwords;t++){var e=this._array[t],n=r._array[t];this._array[t]=(e^n)&e}},r.prototype.union=function(r){this._check_size(r);for(var t=this.clone(),e=0;e<this._nwords;e++)t._array[e]|=r._array[e];return t},r.prototype.intersection=function(r){this._check_size(r);for(var t=this.clone(),e=0;e<this._nwords;e++)t._array[e]&=r._array[e];return t},r.prototype.difference=function(r){this._check_size(r);for(var t=this.clone(),e=0;e<this._nwords;e++){var n=this._array[e],a=r._array[e];t._array[e]=(n^a)&n}return t},r.prototype.select=function(r){var t,e;i.assert(this.size==r.length,"Size mismatch");var n=this.count,a=new r.constructor(n),o=0;try{for(var u=s.__values(this),c=u.next();!c.done;c=u.next()){var h=c.value;a[o++]=r[h]}}catch(r){t={error:r}}finally{try{c&&!c.done&&(e=u.return)&&e.call(u)}finally{if(t)throw t.error}}return a},r}();e.BitSet=c,c.__name__="BitSet";var h=function(){function r(r,t,e){this.nrows=r,this.ncols=t,this._matrix=new Array(r);for(var n=0;n<r;n++){this._matrix[n]=new Array(t);for(var a=0;a<t;a++)this._matrix[n][a]=e(n,a)}}return r.prototype.at=function(r,t){return this._matrix[r][t]},r.prototype[Symbol.iterator]=function(){var r,t;return s.__generator(this,(function(e){switch(e.label){case 0:r=0,e.label=1;case 1:if(!(r<this.nrows))return[3,6];t=0,e.label=2;case 2:return t<this.ncols?[4,[this._matrix[r][t],r,t]]:[3,5];case 3:e.sent(),e.label=4;case 4:return t++,[3,2];case 5:return r++,[3,1];case 6:return[2]}}))},r.prototype.values=function(){var r,t,e,n,a,i;return s.__generator(this,(function(o){switch(o.label){case 0:o.trys.push([0,5,6,7]),r=s.__values(this),t=r.next(),o.label=1;case 1:return t.done?[3,4]:(e=s.__read(t.value,1),[4,e[0]]);case 2:o.sent(),o.label=3;case 3:return t=r.next(),[3,1];case 4:return[3,7];case 5:return n=o.sent(),a={error:n},[3,7];case 6:try{t&&!t.done&&(i=r.return)&&i.call(r)}finally{if(a)throw a.error}return[7];case 7:return[2]}}))},r.prototype.map=function(t){var e=this;return new r(this.nrows,this.ncols,(function(r,n){return t(e.at(r,n),r,n)}))},r.prototype.apply=function(t){var e=this,n=r.from(t),a=this.nrows,s=this.ncols;if(a==n.nrows&&s==n.ncols)return new r(a,s,(function(r,t){return n.at(r,t)(e.at(r,t),r,t)}));throw new Error("dimensions don't match")},r.prototype.to_sparse=function(){return s.__spread(this)},r.from=function(t,e){if(t instanceof r)return t;if(null!=e){var n=t;return new r(Math.floor(n.length/e),e,(function(r,t){return n[r*e+t]}))}var a=t;return new r(t.length,o.min(a.map((function(r){return r.length}))),(function(r,t){return a[r][t]}))},r}();e.Matrix=h,h.__name__="Matrix"},
function _(e,t,n,i,r){i();var o=function(){function e(){this._dev=!1}return Object.defineProperty(e.prototype,"dev",{get:function(){return this._dev},set:function(e){this._dev=e},enumerable:!1,configurable:!0}),e}();n.Settings=o,o.__name__="Settings",n.settings=new o},
function _(e,l,a,t,r){t();var c=e(1),o=c.__importStar(e(133)),n=e(135),i=c.__importStar(e(136));a.Line={line_color:[i.Nullable(i.Color),"black"],line_alpha:[i.Alpha,1],line_width:[i.Number,1],line_join:[n.LineJoin,"bevel"],line_cap:[n.LineCap,"butt"],line_dash:[i.Array(i.Number),[]],line_dash_offset:[i.Number,0]},a.Fill={fill_color:[i.Nullable(i.Color),"gray"],fill_alpha:[i.Alpha,1]},a.Hatch={hatch_color:[i.Nullable(i.Color),"black"],hatch_alpha:[i.Alpha,1],hatch_scale:[i.Number,12],hatch_pattern:[i.Nullable(i.Or(n.HatchPatternType,i.String)),null],hatch_weight:[i.Number,1],hatch_extra:[i.Dict(i.AnyRef()),{}]},a.Text={text_color:[i.Nullable(i.Color),"#444444"],text_alpha:[i.Alpha,1],text_font:[o.Font,"helvetica"],text_font_size:[i.FontSize,"16px"],text_font_style:[n.FontStyle,"normal"],text_align:[n.TextAlign,"left"],text_baseline:[n.TextBaseline,"bottom"],text_line_height:[i.Number,1.2]},a.LineScalar={line_color:[o.ColorScalar,"black"],line_alpha:[o.NumberScalar,1],line_width:[o.NumberScalar,1],line_join:[o.LineJoinScalar,"bevel"],line_cap:[o.LineCapScalar,"butt"],line_dash:[o.ArrayScalar,[]],line_dash_offset:[o.NumberScalar,0]},a.FillScalar={fill_color:[o.ColorScalar,"gray"],fill_alpha:[o.NumberScalar,1]},a.HatchScalar={hatch_color:[o.ColorScalar,"black"],hatch_alpha:[o.NumberScalar,1],hatch_scale:[o.NumberScalar,12],hatch_pattern:[o.NullStringScalar,null],hatch_weight:[o.NumberScalar,1],hatch_extra:[o.AnyScalar,{}]},a.TextScalar={text_color:[o.ColorScalar,"#444444"],text_alpha:[o.NumberScalar,1],text_font:[o.Font,"helvetica"],text_font_size:[o.FontSizeScalar,"16px"],text_font_style:[o.FontStyleScalar,"normal"],text_align:[o.TextAlignScalar,"left"],text_baseline:[o.TextBaselineScalar,"bottom"],text_line_height:[o.NumberScalar,1.2]},a.LineVector={line_color:[o.ColorSpec,"black"],line_alpha:[o.NumberSpec,1],line_width:[o.NumberSpec,1],line_join:[n.LineJoin,"bevel"],line_cap:[n.LineCap,"butt"],line_dash:[i.Array(i.Number),[]],line_dash_offset:[i.Number,0]},a.FillVector={fill_color:[o.ColorSpec,"gray"],fill_alpha:[o.NumberSpec,1]},a.HatchVector={hatch_color:[o.ColorSpec,"black"],hatch_alpha:[o.NumberSpec,1],hatch_scale:[o.NumberSpec,12],hatch_pattern:[o.NullStringSpec,null],hatch_weight:[o.NumberSpec,1],hatch_extra:[i.Dict(i.AnyRef()),{}]},a.TextVector={text_color:[o.ColorSpec,"#444444"],text_alpha:[o.NumberSpec,1],text_font:[o.Font,"helvetica"],text_font_size:[o.FontSizeSpec,"16px"],text_font_style:[n.FontStyle,"normal"],text_align:[n.TextAlign,"left"],text_baseline:[n.TextBaseline,"bottom"],text_line_height:[i.Number,1.2]}},
function _(r,t,e,n,u){n();var a=r(142);function c(){for(var r=new Array(32),t="0123456789ABCDEF",e=0;e<32;e++)r[e]=t.substr(Math.floor(16*Math.random()),1);return r[12]="4",r[16]=t.substr(3&r[16].charCodeAt(0)|8,1),r.join("")}e.startsWith=function(r,t,e){return void 0===e&&(e=0),r.substr(e,t.length)==t},e.uuid4=c;var s=1e3;e.uniqueId=function(r){var t=a.settings.dev?"j"+s++:c();return null!=r?r+"-"+t:t},e.escape=function(r){return r.replace(/(?:[&<>"'`])/g,(function(r){switch(r){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&#x27;";case"`":return"&#x60;";default:return r}}))},e.unescape=function(r){return r.replace(/&(amp|lt|gt|quot|#x27|#x60);/g,(function(r,t){switch(t){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';case"#x27":return"'";case"#x60":return"`";default:return t}}))},e.use_strict=function(r){return"'use strict';\n"+r},e.to_fixed=function(r,t){return r.toFixed(t).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"")}},
function _(n,r,e,t,a){t();var s=n(1),i=n(123),u=n(126),_=n(140),o=Symbol("__ndarray__"),h=function(n){function r(r,e){var t=new n(r);return t.__ndarray__=o,t.dtype="uint8",t.shape=null!=e?e:v(r)?r.shape:[t.length],t.dimension=t.shape.length,t}return s.__extends(r,n),r.prototype[_.equals]=function(n,r){return r.eq(this.shape,n.shape)&&r.arrays(this,n)},r}(Uint8Array);e.Uint8NDArray=h,h.__name__="Uint8NDArray";var y=function(n){function r(r,e){var t=new n(r);return t.__ndarray__=o,t.dtype="int8",t.shape=null!=e?e:v(r)?r.shape:[t.length],t.dimension=t.shape.length,t}return s.__extends(r,n),r.prototype[_.equals]=function(n,r){return r.eq(this.shape,n.shape)&&r.arrays(this,n)},r}(Int8Array);e.Int8NDArray=y,y.__name__="Int8NDArray";var p=function(n){function r(r,e){var t=new n(r);return t.__ndarray__=o,t.dtype="uint16",t.shape=null!=e?e:v(r)?r.shape:[t.length],t.dimension=t.shape.length,t}return s.__extends(r,n),r.prototype[_.equals]=function(n,r){return r.eq(this.shape,n.shape)&&r.arrays(this,n)},r}(Uint16Array);e.Uint16NDArray=p,p.__name__="Uint16NDArray";var l=function(n){function r(r,e){var t=new n(r);return t.__ndarray__=o,t.dtype="int16",t.shape=null!=e?e:v(r)?r.shape:[t.length],t.dimension=t.shape.length,t}return s.__extends(r,n),r.prototype[_.equals]=function(n,r){return r.eq(this.shape,n.shape)&&r.arrays(this,n)},r}(Int16Array);e.Int16NDArray=l,l.__name__="Int16NDArray";var c=function(n){function r(r,e){var t=new n(r);return t.__ndarray__=o,t.dtype="uint32",t.shape=null!=e?e:v(r)?r.shape:[t.length],t.dimension=t.shape.length,t}return s.__extends(r,n),r.prototype[_.equals]=function(n,r){return r.eq(this.shape,n.shape)&&r.arrays(this,n)},r}(Uint32Array);e.Uint32NDArray=c,c.__name__="Uint32NDArray";var f=function(n){function r(r,e){var t=new n(r);return t.__ndarray__=o,t.dtype="int32",t.shape=null!=e?e:v(r)?r.shape:[t.length],t.dimension=t.shape.length,t}return s.__extends(r,n),r.prototype[_.equals]=function(n,r){return r.eq(this.shape,n.shape)&&r.arrays(this,n)},r}(Int32Array);e.Int32NDArray=f,f.__name__="Int32NDArray";var d=function(n){function r(r,e){var t=new n(r);return t.__ndarray__=o,t.dtype="float32",t.shape=null!=e?e:v(r)?r.shape:[t.length],t.dimension=t.shape.length,t}return s.__extends(r,n),r.prototype[_.equals]=function(n,r){return r.eq(this.shape,n.shape)&&r.arrays(this,n)},r}(Float32Array);e.Float32NDArray=d,d.__name__="Float32NDArray";var A=function(n){function r(r,e){var t=new n(r);return t.__ndarray__=o,t.dtype="float64",t.shape=null!=e?e:v(r)?r.shape:[t.length],t.dimension=t.shape.length,t}return s.__extends(r,n),r.prototype[_.equals]=function(n,r){return r.eq(this.shape,n.shape)&&r.arrays(this,n)},r}(Float64Array);function v(n){return i.isObject(n)&&n.__ndarray__==o}e.Float64NDArray=A,A.__name__="Float64NDArray",e.is_NDArray=v,e.ndarray=function(n,r){void 0===r&&(r={});var e=r.dtype;null==e&&(e=n instanceof ArrayBuffer||i.isArray(n)?"float32":function(){switch(!0){case n instanceof Uint8Array:return"uint8";case n instanceof Int8Array:return"int8";case n instanceof Uint16Array:return"uint16";case n instanceof Int16Array:return"int16";case n instanceof Uint32Array:return"uint32";case n instanceof Int32Array:return"int32";case n instanceof Float32Array:return"float32";case n instanceof Float64Array:return"float64";default:u.unreachable()}}());var t=r.shape;switch(e){case"uint8":return new h(n,t);case"int8":return new y(n,t);case"uint16":return new p(n,t);case"int16":return new l(n,t);case"uint32":return new c(n,t);case"int32":return new f(n,t);case"float32":return new d(n,t);case"float64":return new A(n,t)}}},
function _(r,e,n,t,a){t();var f=r(1),i=r(123),_=r(147),u=f.__importStar(r(145)),o=function(r){function e(){return null!==r&&r.apply(this,arguments)||this}return f.__extends(e,r),e}(Error);function s(r){var e=new Uint8Array(r),n=Array.from(e).map((function(r){return String.fromCharCode(r)}));return btoa(n.join(""))}function c(r){for(var e=atob(r),n=e.length,t=new Uint8Array(n),a=0,f=n;a<f;a++)t[a]=e.charCodeAt(a);return t.buffer}function b(r){for(var e=new Uint8Array(r.buffer,r.byteOffset,2*r.length),n=0,t=e.length;n<t;n+=2){var a=e[n];e[n]=e[n+1],e[n+1]=a}}function y(r){for(var e=new Uint8Array(r.buffer,r.byteOffset,4*r.length),n=0,t=e.length;n<t;n+=4){var a=e[n];e[n]=e[n+3],e[n+3]=a,a=e[n+1],e[n+1]=e[n+2],e[n+2]=a}}function l(r){for(var e=new Uint8Array(r.buffer,r.byteOffset,8*r.length),n=0,t=e.length;n<t;n+=8){var a=e[n];e[n]=e[n+7],e[n+7]=a,a=e[n+1],e[n+1]=e[n+6],e[n+6]=a,a=e[n+2],e[n+2]=e[n+5],e[n+5]=a,a=e[n+3],e[n+3]=e[n+4],e[n+4]=a}}n.SerializationError=o,o.__name__="SerializationError",n.buffer_to_base64=s,n.base64_to_buffer=c,n.BYTE_ORDER=_.is_little_endian?"little":"big",n.swap16=b,n.swap32=y,n.swap64=l,n.is_NDArray_ref=function(r){return i.isPlainObject(r)&&("__buffer__"in r||"__ndarray__"in r)},n.decode_NDArray=function(r,e){var t,a=r.shape,f=r.dtype,i=r.order;if("__buffer__"in r){var _=e.get(r.__buffer__);if(null==_)throw new Error("buffer for "+r.__buffer__+" not found");t=_}else t=c(r.__ndarray__);var o=function(){switch(f){case"uint8":return new u.Uint8NDArray(t,a);case"int8":return new u.Int8NDArray(t,a);case"uint16":return new u.Uint16NDArray(t,a);case"int16":return new u.Int16NDArray(t,a);case"uint32":return new u.Uint32NDArray(t,a);case"int32":return new u.Int32NDArray(t,a);case"float32":return new u.Float32NDArray(t,a);case"float64":return new u.Float64NDArray(t,a)}}();if(i!==n.BYTE_ORDER)switch(o.BYTES_PER_ELEMENT){case 2:b(o);break;case 4:y(o);break;case 8:l(o)}return o},n.encode_NDArray=function(r,e){var t={order:n.BYTE_ORDER,dtype:r.dtype,shape:r.shape};if(null!=e){var a=""+e.size;return e.set(a,r.buffer),Object.assign({__buffer__:a},t)}var f=s(r.buffer);return Object.assign({__ndarray__:f},t)}},
function _(n,i,e,r,t){var a;r(),e.is_ie=(a="undefined"!=typeof navigator?navigator.userAgent:"").indexOf("MSIE")>=0||a.indexOf("Trident")>0||a.indexOf("Edge")>0,e.is_mobile="undefined"!=typeof window&&("ontouchstart"in window||navigator.maxTouchPoints>0),e.is_little_endian=function(){var n=new ArrayBuffer(4),i=new Uint8Array(n);new Uint32Array(n)[1]=168496141;var e=!0;return 10==i[4]&&11==i[5]&&12==i[6]&&13==i[7]&&(e=!1),e}()},
function _(t,r,n,e,i){e();var o=t(1),a=t(123),s=t(128);n.pretty=Symbol("pretty");var u=function(){function t(t){this.precision=null==t?void 0:t.precision}return t.prototype.to_string=function(t){return function(t){return n.pretty in Object(t)}(t)?t[n.pretty](this):a.isBoolean(t)?this.boolean(t):a.isNumber(t)?this.number(t):a.isString(t)?this.string(t):a.isArray(t)?this.array(t):a.isIterable(t)?this.iterable(t):a.isPlainObject(t)?this.object(t):""+t},t.prototype.token=function(t){return t},t.prototype.boolean=function(t){return""+t},t.prototype.number=function(t){return null!=this.precision?t.toFixed(this.precision):""+t},t.prototype.string=function(t){return'"'+t.replace(/'/g,"\\'")+'"'},t.prototype.array=function(t){var r,n,e=this.token,i=[];try{for(var a=o.__values(t),s=a.next();!s.done;s=a.next()){var u=s.value;i.push(this.to_string(u))}}catch(t){r={error:t}}finally{try{s&&!s.done&&(n=a.return)&&n.call(a)}finally{if(r)throw r.error}}return""+e("[")+i.join(e(",")+" ")+e("]")},t.prototype.iterable=function(t){var r,n=this.token,e=null!==(r=Object(t)[Symbol.toStringTag])&&void 0!==r?r:"Object",i=this.array(t);return""+e+n("(")+i+n(")")},t.prototype.object=function(t){var r,n,e=this.token,i=[];try{for(var a=o.__values(s.entries(t)),u=a.next();!u.done;u=a.next()){var l=o.__read(u.value,2),c=l[0],p=l[1];i.push(""+c+e(":")+" "+this.to_string(p))}}catch(t){r={error:t}}finally{try{u&&!u.done&&(n=a.return)&&n.call(a)}finally{if(r)throw r.error}}return""+e("{")+i.join(e(",")+" ")+e("}")},t}();n.Printer=u,u.__name__="Printer",n.to_string=function(t,r){return new u(r).to_string(t)}},
function _(r,t,_,a,o){a();var e=r(1);e.__exportStar(r(150),_),e.__exportStar(r(315),_),e.__exportStar(r(342),_),e.__exportStar(r(346),_),e.__exportStar(r(357),_),e.__exportStar(r(361),_),e.__exportStar(r(366),_),e.__exportStar(r(370),_),e.__exportStar(r(401),_),e.__exportStar(r(403),_),e.__exportStar(r(405),_),e.__exportStar(r(255),_),e.__exportStar(r(267),_),e.__exportStar(r(421),_),e.__exportStar(r(425),_),e.__exportStar(r(437),_),e.__exportStar(r(438),_),e.__exportStar(r(439),_),e.__exportStar(r(440),_),e.__exportStar(r(441),_),e.__exportStar(r(446),_),e.__exportStar(r(448),_),e.__exportStar(r(459),_),e.__exportStar(r(463),_)},
function _(e,o,n,a,t){a(),t("Annotation",e(151).Annotation),t("Arrow",e(198).Arrow),t("ArrowHead",e(199).ArrowHead),t("OpenHead",e(199).OpenHead),t("NormalHead",e(199).NormalHead),t("TeeHead",e(199).TeeHead),t("VeeHead",e(199).VeeHead),t("Band",e(241).Band),t("BoxAnnotation",e(243).BoxAnnotation),t("ColorBar",e(244).ColorBar),t("Label",e(279).Label),t("LabelSet",e(281).LabelSet),t("Legend",e(282).Legend),t("LegendItem",e(283).LegendItem),t("PolyAnnotation",e(285).PolyAnnotation),t("Slope",e(286).Slope),t("Span",e(287).Span),t("TextAnnotation",e(280).TextAnnotation),t("Title",e(288).Title),t("ToolbarPanel",e(289).ToolbarPanel),t("Tooltip",e(311).Tooltip),t("Whisker",e(314).Whisker)},
function _(t,e,n,i,o){i();var r=t(1),a=r.__importStar(t(152)),s=t(128),_=t(185),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),Object.defineProperty(e.prototype,"panel",{get:function(){return this.layout},enumerable:!1,configurable:!0}),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var n=this.model.properties;this.on_change(n.visible,(function(){return e.plot_view.request_layout()}))},e.prototype.get_size=function(){if(this.model.visible){var t=this._get_size(),e=t.width,n=t.height;return{width:Math.round(e),height:Math.round(n)}}return{width:0,height:0}},e.prototype._get_size=function(){throw new Error("not implemented")},e.prototype.set_data=function(t){var e,n,i=this.model.materialize_dataspecs(t);if(s.extend(this,i),this.plot_model.use_map){var o=this;null!=o._x&&(e=r.__read(a.project_xy(o._x,o._y),2),o._x=e[0],o._y=e[1]),null!=o._xs&&(n=r.__read(a.project_xsys(o._xs,o._ys),2),o._xs=n[0],o._ys=n[1])}},Object.defineProperty(e.prototype,"needs_clip",{get:function(){return null==this.layout},enumerable:!1,configurable:!0}),e.prototype.serializable_state=function(){var e=t.prototype.serializable_state.call(this);return null==this.layout?e:Object.assign(Object.assign({},e),{bbox:this.layout.bbox.box})},e}(_.RendererView);n.AnnotationView=l,l.__name__="AnnotationView";var u=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_Annotation=function(){this.override({level:"annotation"})},e}(_.Renderer);n.Annotation=u,u.__name__="Annotation",u.init_Annotation()},
function _(n,r,e,t,a){t();var i=n(1),u=i.__importDefault(n(153)),l=i.__importDefault(n(154)),o=n(139),c=new l.default("GOOGLE"),_=new l.default("WGS84"),f=u.default(_,c);e.wgs84_mercator={compute:function(n,r){return isFinite(n)&&isFinite(r)?f.forward([n,r]):[NaN,NaN]},invert:function(n,r){return isFinite(n)&&isFinite(r)?f.inverse([n,r]):[NaN,NaN]}};var v={lon:[-20026376.39,20026376.39],lat:[-20048966.1,20048966.1]},p={lon:[-180,180],lat:[-85.06,85.06]},s=Math.min,m=Math.max;function g(n,r){var t=s(n.length,r.length),a=new o.NumberArray(t),i=new o.NumberArray(t);return e.inplace.project_xy(n,r,a,i),[a,i]}e.clip_mercator=function(n,r,e){var t=i.__read(v[e],2),a=t[0],u=t[1];return[m(n,a),s(r,u)]},e.in_bounds=function(n,r){var e=i.__read(p[r],2),t=e[0],a=e[1];return t<n&&n<a},function(n){function r(n,r,t,a){var u=s(n.length,r.length);t=null!=t?t:n,a=null!=a?a:r;for(var l=0;l<u;l++){var o=n[l],c=r[l],_=i.__read(e.wgs84_mercator.compute(o,c),2),f=_[0],v=_[1];t[l]=f,a[l]=v}}n.project_xy=r,n.project_xsys=function(n,e,t,a){var i=s(n.length,e.length);t=null!=t?t:n,a=null!=a?a:e;for(var u=0;u<i;u++)r(n[u],e[u],t[u],a[u])}}(e.inplace||(e.inplace={})),e.project_xy=g,e.project_xsys=function(n,r){for(var e=s(n.length,r.length),t=new Array(e),a=new Array(e),u=0;u<e;u++){var l=i.__read(g(n[u],r[u]),2),o=l[0],c=l[1];t[u]=o,a[u]=c}return[t,a]}},
function _(e,n,t,r,o){r();var a=e(1),i=a.__importDefault(e(154)),c=a.__importDefault(e(179)),u=i.default("WGS84");function f(e,n,t){var r,o,a;return Array.isArray(t)?(r=c.default(e,n,t)||{x:NaN,y:NaN},t.length>2?void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name?"number"==typeof r.z?[r.x,r.y,r.z].concat(t.splice(3)):[r.x,r.y,t[2]].concat(t.splice(3)):[r.x,r.y].concat(t.splice(2)):[r.x,r.y]):(o=c.default(e,n,t),2===(a=Object.keys(t)).length||a.forEach((function(r){if(void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name){if("x"===r||"y"===r||"z"===r)return}else if("x"===r||"y"===r)return;o[r]=t[r]})),o)}function l(e){return e instanceof i.default?e:e.oProj?e.oProj:i.default(e)}t.default=function(e,n,t){e=l(e);var r,o=!1;return void 0===n?(n=e,e=u,o=!0):(void 0!==n.x||Array.isArray(n))&&(t=n,n=e,e=u,o=!0),n=l(n),t?f(e,n,t):(r={forward:function(t){return f(e,n,t)},inverse:function(t){return f(n,e,t)}},o&&(r.oProj=n),r)}},
function _(t,e,a,s,i){s();var u=t(1),l=u.__importDefault(t(155)),r=u.__importDefault(t(166)),f=u.__importDefault(t(167)),o=t(175),p=u.__importDefault(t(177)),d=u.__importDefault(t(178)),m=u.__importDefault(t(162));function n(t,e){if(!(this instanceof n))return new n(t);e=e||function(t){if(t)throw t};var a=l.default(t);if("object"==typeof a){var s=n.projections.get(a.projName);if(s){if(a.datumCode&&"none"!==a.datumCode){var i=m.default(p.default,a.datumCode);i&&(a.datum_params=i.towgs84?i.towgs84.split(","):null,a.ellps=i.ellipse,a.datumName=i.datumName?i.datumName:a.datumCode)}a.k0=a.k0||1,a.axis=a.axis||"enu",a.ellps=a.ellps||"wgs84";var u=o.sphere(a.a,a.b,a.rf,a.ellps,a.sphere),f=o.eccentricity(u.a,u.b,u.rf,a.R_A),h=a.datum||d.default(a.datumCode,a.datum_params,u.a,u.b,f.es,f.ep2);r.default(this,a),r.default(this,s),this.a=u.a,this.b=u.b,this.rf=u.rf,this.sphere=u.sphere,this.es=f.es,this.e=f.e,this.ep2=f.ep2,this.datum=h,this.init(),e(null,this)}else e(t)}else e(t)}n.projections=f.default,n.projections.start(),a.default=n},
function _(t,r,u,n,e){n();var f=t(1),i=f.__importDefault(t(156)),a=f.__importDefault(t(163)),o=f.__importDefault(t(158)),l=f.__importDefault(t(162));var C=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"];var d=["3857","900913","3785","102113"];u.default=function(t){if(!function(t){return"string"==typeof t}(t))return t;if(function(t){return t in i.default}(t))return i.default[t];if(function(t){return C.some((function(r){return t.indexOf(r)>-1}))}(t)){var r=a.default(t);if(function(t){var r=l.default(t,"authority");if(r){var u=l.default(r,"epsg");return u&&d.indexOf(u)>-1}}(r))return i.default["EPSG:3857"];var u=function(t){var r=l.default(t,"extension");if(r)return l.default(r,"proj4")}(r);return u?o.default(u):r}return function(t){return"+"===t[0]}(t)?o.default(t):void 0}},
function _(t,r,i,e,n){e();var a=t(1),f=a.__importDefault(t(157)),l=a.__importDefault(t(158)),u=a.__importDefault(t(163));function o(t){var r=this;if(2===arguments.length){var i=arguments[1];"string"==typeof i?"+"===i.charAt(0)?o[t]=l.default(arguments[1]):o[t]=u.default(arguments[1]):o[t]=i}else if(1===arguments.length){if(Array.isArray(t))return t.map((function(t){Array.isArray(t)?o.apply(r,t):o(t)}));if("string"==typeof t){if(t in o)return o[t]}else"EPSG"in t?o["EPSG:"+t.EPSG]=t:"ESRI"in t?o["ESRI:"+t.ESRI]=t:"IAU2000"in t?o["IAU2000:"+t.IAU2000]=t:console.log(t);return}}f.default(o),i.default=o},
function _(t,l,G,S,e){S(),G.default=function(t){t("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),t("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),t("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),t.WGS84=t["EPSG:4326"],t["EPSG:3785"]=t["EPSG:3857"],t.GOOGLE=t["EPSG:3857"],t["EPSG:900913"]=t["EPSG:3857"],t["EPSG:102113"]=t["EPSG:3857"]}},
function _(t,n,o,a,u){a();var e=t(1),r=t(159),i=e.__importDefault(t(160)),f=e.__importDefault(t(161)),l=e.__importDefault(t(162));o.default=function(t){var n,o,a,u={},e=t.split("+").map((function(t){return t.trim()})).filter((function(t){return t})).reduce((function(t,n){var o=n.split("=");return o.push(!0),t[o[0].toLowerCase()]=o[1],t}),{}),c={proj:"projName",datum:"datumCode",rf:function(t){u.rf=parseFloat(t)},lat_0:function(t){u.lat0=t*r.D2R},lat_1:function(t){u.lat1=t*r.D2R},lat_2:function(t){u.lat2=t*r.D2R},lat_ts:function(t){u.lat_ts=t*r.D2R},lon_0:function(t){u.long0=t*r.D2R},lon_1:function(t){u.long1=t*r.D2R},lon_2:function(t){u.long2=t*r.D2R},alpha:function(t){u.alpha=parseFloat(t)*r.D2R},lonc:function(t){u.longc=t*r.D2R},x_0:function(t){u.x0=parseFloat(t)},y_0:function(t){u.y0=parseFloat(t)},k_0:function(t){u.k0=parseFloat(t)},k:function(t){u.k0=parseFloat(t)},a:function(t){u.a=parseFloat(t)},b:function(t){u.b=parseFloat(t)},r_a:function(){u.R_A=!0},zone:function(t){u.zone=parseInt(t,10)},south:function(){u.utmSouth=!0},towgs84:function(t){u.datum_params=t.split(",").map((function(t){return parseFloat(t)}))},to_meter:function(t){u.to_meter=parseFloat(t)},units:function(t){u.units=t;var n=l.default(f.default,t);n&&(u.to_meter=n.to_meter)},from_greenwich:function(t){u.from_greenwich=t*r.D2R},pm:function(t){var n=l.default(i.default,t);u.from_greenwich=(n||parseFloat(t))*r.D2R},nadgrids:function(t){"@null"===t?u.datumCode="none":u.nadgrids=t},axis:function(t){var n="ewnsud";3===t.length&&-1!==n.indexOf(t.substr(0,1))&&-1!==n.indexOf(t.substr(1,1))&&-1!==n.indexOf(t.substr(2,1))&&(u.axis=t)}};for(n in e)o=e[n],n in c?"function"==typeof(a=c[n])?a(o):u[a]=o:u[n]=o;return"string"==typeof u.datumCode&&"WGS84"!==u.datumCode&&(u.datumCode=u.datumCode.toLowerCase()),u}},
function _(P,A,_,D,I){D(),_.PJD_3PARAM=1,_.PJD_7PARAM=2,_.PJD_WGS84=4,_.PJD_NODATUM=5,_.SEC_TO_RAD=484813681109536e-20,_.HALF_PI=Math.PI/2,_.SIXTH=.16666666666666666,_.RA4=.04722222222222222,_.RA6=.022156084656084655,_.EPSLN=1e-10,_.D2R=.017453292519943295,_.R2D=57.29577951308232,_.FORTPI=Math.PI/4,_.TWO_PI=2*Math.PI,_.SPI=3.14159265359},
function _(o,r,a,e,s){e();var n={};a.default=n,n.greenwich=0,n.lisbon=-9.131906111111,n.paris=2.337229166667,n.bogota=-74.080916666667,n.madrid=-3.687938888889,n.rome=12.452333333333,n.bern=7.439583333333,n.jakarta=106.807719444444,n.ferro=-17.666666666667,n.brussels=4.367975,n.stockholm=18.058277777778,n.athens=23.7163375,n.oslo=10.722916666667},
function _(t,e,f,o,u){o(),f.default={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}}},
function _(e,r,t,a,n){a();var o=/[\s_\-\/\(\)]/g;t.default=function(e,r){if(e[r])return e[r];for(var t,a=Object.keys(e),n=r.toLowerCase().replace(o,""),f=-1;++f<a.length;)if((t=a[f]).toLowerCase().replace(o,"")===n)return e[t]}},
function _(e,a,t,o,d){o();var r=e(1),n=r.__importDefault(e(164)),l=e(165);function i(e){return.017453292519943295*e}t.default=function(e){var a=n.default(e),t=a.shift(),o=a.shift();a.unshift(["name",o]),a.unshift(["type",t]);var d={};return l.sExpr(a,d),function(e){if("GEOGCS"===e.type?e.projName="longlat":"LOCAL_CS"===e.type?(e.projName="identity",e.local=!0):"object"==typeof e.PROJECTION?e.projName=Object.keys(e.PROJECTION)[0]:e.projName=e.PROJECTION,e.AXIS){for(var a="",t=0,o=e.AXIS.length;t<o;++t){var d=e.AXIS[t][0].toLowerCase();-1!==d.indexOf("north")?a+="n":-1!==d.indexOf("south")?a+="s":-1!==d.indexOf("east")?a+="e":-1!==d.indexOf("west")&&(a+="w")}2===a.length&&(a+="u"),3===a.length&&(e.axis=a)}e.UNIT&&(e.units=e.UNIT.name.toLowerCase(),"metre"===e.units&&(e.units="meter"),e.UNIT.convert&&("GEOGCS"===e.type?e.DATUM&&e.DATUM.SPHEROID&&(e.to_meter=e.UNIT.convert*e.DATUM.SPHEROID.a):e.to_meter=e.UNIT.convert));var r=e.GEOGCS;function n(a){return a*(e.to_meter||1)}"GEOGCS"===e.type&&(r=e),r&&(r.DATUM?e.datumCode=r.DATUM.name.toLowerCase():e.datumCode=r.name.toLowerCase(),"d_"===e.datumCode.slice(0,2)&&(e.datumCode=e.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==e.datumCode&&"new_zealand_1949"!==e.datumCode||(e.datumCode="nzgd49"),"wgs_1984"!==e.datumCode&&"world_geodetic_system_1984"!==e.datumCode||("Mercator_Auxiliary_Sphere"===e.PROJECTION&&(e.sphere=!0),e.datumCode="wgs84"),"_ferro"===e.datumCode.slice(-6)&&(e.datumCode=e.datumCode.slice(0,-6)),"_jakarta"===e.datumCode.slice(-8)&&(e.datumCode=e.datumCode.slice(0,-8)),~e.datumCode.indexOf("belge")&&(e.datumCode="rnb72"),r.DATUM&&r.DATUM.SPHEROID&&(e.ellps=r.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===e.ellps.toLowerCase().slice(0,13)&&(e.ellps="intl"),e.a=r.DATUM.SPHEROID.a,e.rf=parseFloat(r.DATUM.SPHEROID.rf,10)),r.DATUM&&r.DATUM.TOWGS84&&(e.datum_params=r.DATUM.TOWGS84),~e.datumCode.indexOf("osgb_1936")&&(e.datumCode="osgb36"),~e.datumCode.indexOf("osni_1952")&&(e.datumCode="osni52"),(~e.datumCode.indexOf("tm65")||~e.datumCode.indexOf("geodetic_datum_of_1965"))&&(e.datumCode="ire65"),"ch1903+"===e.datumCode&&(e.datumCode="ch1903"),~e.datumCode.indexOf("israel")&&(e.datumCode="isr93")),e.b&&!isFinite(e.b)&&(e.b=e.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_2","Standard_Parallel_2"],["false_easting","False_Easting"],["false_northing","False_Northing"],["central_meridian","Central_Meridian"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",i],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",i],["x0","false_easting",n],["y0","false_northing",n],["long0","central_meridian",i],["lat0","latitude_of_origin",i],["lat0","standard_parallel_1",i],["lat1","standard_parallel_1",i],["lat2","standard_parallel_2",i],["azimuth","Azimuth"],["alpha","azimuth",i],["srsCode","name"]].forEach((function(a){return t=e,d=(o=a)[0],r=o[1],void(!(d in t)&&r in t&&(t[d]=t[r],3===o.length&&(t[d]=o[2](t[d]))));var t,o,d,r})),e.long0||!e.longc||"Albers_Conic_Equal_Area"!==e.projName&&"Lambert_Azimuthal_Equal_Area"!==e.projName||(e.long0=e.longc),e.lat_ts||!e.lat1||"Stereographic_South_Pole"!==e.projName&&"Polar Stereographic (variant B)"!==e.projName||(e.lat0=i(e.lat1>0?90:-90),e.lat_ts=e.lat1)}(d),d}},
function _(t,e,r,i,s){i(),r.default=function(t){return new d(t).output()};var h=/\s/,o=/[A-Za-z]/,n=/[A-Za-z84]/,a=/[,\]]/,u=/[\d\.E\-\+]/;function d(t){if("string"!=typeof t)throw new Error("not a string");this.text=t.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=1}d.prototype.readCharicter=function(){var t=this.text[this.place++];if(4!==this.state)for(;h.test(t);){if(this.place>=this.text.length)return;t=this.text[this.place++]}switch(this.state){case 1:return this.neutral(t);case 2:return this.keyword(t);case 4:return this.quoted(t);case 5:return this.afterquote(t);case 3:return this.number(t);case-1:return}},d.prototype.afterquote=function(t){if('"'===t)return this.word+='"',void(this.state=4);if(a.test(t))return this.word=this.word.trim(),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in afterquote yet, index '+this.place)},d.prototype.afterItem=function(t){return","===t?(null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=1)):"]"===t?(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=1,this.currentObject=this.stack.pop(),void(this.currentObject||(this.state=-1))):void 0},d.prototype.number=function(t){if(!u.test(t)){if(a.test(t))return this.word=parseFloat(this.word),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in number yet, index '+this.place)}this.word+=t},d.prototype.quoted=function(t){'"'!==t?this.word+=t:this.state=5},d.prototype.keyword=function(t){if(n.test(t))this.word+=t;else{if("["===t){var e=[];return e.push(this.word),this.level++,null===this.root?this.root=e:this.currentObject.push(e),this.stack.push(this.currentObject),this.currentObject=e,void(this.state=1)}if(!a.test(t))throw new Error("havn't handled \""+t+'" in keyword yet, index '+this.place);this.afterItem(t)}},d.prototype.neutral=function(t){if(o.test(t))return this.word=t,void(this.state=2);if('"'===t)return this.word="",void(this.state=4);if(u.test(t))return this.word=t,void(this.state=3);if(!a.test(t))throw new Error("havn't handled \""+t+'" in neutral yet, index '+this.place);this.afterItem(t)},d.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)}},
function _(e,a,r,s,c){function n(e,a,r){Array.isArray(a)&&(r.unshift(a),a=null);var s=a?{}:e,c=r.reduce((function(e,a){return E(a,e),e}),s);a&&(e[a]=c)}function E(e,a){if(Array.isArray(e)){var r=e.shift();if("PARAMETER"===r&&(r=e.shift()),1===e.length)return Array.isArray(e[0])?(a[r]={},void E(e[0],a[r])):void(a[r]=e[0]);if(e.length)if("TOWGS84"!==r){if("AXIS"===r)return r in a||(a[r]=[]),void a[r].push(e);var s;switch(Array.isArray(r)||(a[r]={}),r){case"UNIT":case"PRIMEM":case"VERT_DATUM":return a[r]={name:e[0].toLowerCase(),convert:e[1]},void(3===e.length&&E(e[2],a[r]));case"SPHEROID":case"ELLIPSOID":return a[r]={name:e[0],a:e[1],rf:e[2]},void(4===e.length&&E(e[3],a[r]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return e[0]=["name",e[0]],void n(a,r,e);default:for(s=-1;++s<e.length;)if(!Array.isArray(e[s]))return E(e,a[r]);return n(a,r,e)}}else a[r]=e;else a[r]=!0}else a[e]=!0}s(),r.sExpr=E},
function _(n,r,f,i,t){i(),f.default=function(n,r){var f,i;if(n=n||{},!r)return n;for(i in r)void 0!==(f=r[i])&&(n[i]=f);return n}},
function _(t,a,e,o,n){o();var r=t(1),f=r.__importDefault(t(168)),u=r.__importDefault(t(174)),i=[f.default,u.default],d={},c=[];function l(t,a){var e=c.length;return t.names?(c[e]=t,t.names.forEach((function(t){d[t.toLowerCase()]=e})),this):(console.log(a),!0)}function s(t){if(!t)return!1;var a=t.toLowerCase();return void 0!==d[a]&&c[d[a]]?c[d[a]]:void 0}function v(){i.forEach(l)}e.add=l,e.get=s,e.start=v,e.default={start:v,add:l,get:s}},
function _(t,i,s,h,a){h();var e=t(1),r=e.__importDefault(t(169)),n=e.__importDefault(t(170)),l=e.__importDefault(t(172)),u=e.__importDefault(t(173)),o=t(159);function f(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=r.default(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)}function _(t){var i,s,h=t.x,a=t.y;if(a*o.R2D>90&&a*o.R2D<-90&&h*o.R2D>180&&h*o.R2D<-180)return null;if(Math.abs(Math.abs(a)-o.HALF_PI)<=o.EPSLN)return null;if(this.sphere)i=this.x0+this.a*this.k0*n.default(h-this.long0),s=this.y0+this.a*this.k0*Math.log(Math.tan(o.FORTPI+.5*a));else{var e=Math.sin(a),r=l.default(this.e,a,e);i=this.x0+this.a*this.k0*n.default(h-this.long0),s=this.y0-this.a*this.k0*Math.log(r)}return t.x=i,t.y=s,t}function M(t){var i,s,h=t.x-this.x0,a=t.y-this.y0;if(this.sphere)s=o.HALF_PI-2*Math.atan(Math.exp(-a/(this.a*this.k0)));else{var e=Math.exp(-a/(this.a*this.k0));if(-9999===(s=u.default(this.e,e)))return null}return i=n.default(this.long0+h/(this.a*this.k0)),t.x=i,t.y=s,t}s.init=f,s.forward=_,s.inverse=M,s.names=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"],s.default={init:f,forward:_,inverse:M,names:s.names}},
function _(t,n,r,u,a){u(),r.default=function(t,n,r){var u=t*n;return r/Math.sqrt(1-u*u)}},
function _(t,a,u,f,n){f();var e=t(1),r=t(159),_=e.__importDefault(t(171));u.default=function(t){return Math.abs(t)<=r.SPI?t:t-_.default(t)*r.TWO_PI}},
function _(n,t,u,f,c){f(),u.default=function(n){return n<0?-1:1}},
function _(t,a,n,r,u){r();var f=t(159);n.default=function(t,a,n){var r=t*n,u=.5*t;return r=Math.pow((1-r)/(1+r),u),Math.tan(.5*(f.HALF_PI-a))/r}},
function _(a,t,n,r,f){r();var h=a(159);n.default=function(a,t){for(var n,r,f=.5*a,u=h.HALF_PI-2*Math.atan(t),M=0;M<=15;M++)if(n=a*Math.sin(u),u+=r=h.HALF_PI-2*Math.atan(t*Math.pow((1-n)/(1+n),f))-u,Math.abs(r)<=1e-10)return u;return-9999}},
function _(n,i,e,t,r){function a(){}function f(n){return n}t(),e.init=a,e.forward=f,e.inverse=f,e.names=["longlat","identity"],e.default={init:a,forward:f,inverse:f,names:e.names}},
function _(r,t,e,a,f){a();var n=r(1),i=r(159),u=n.__importStar(r(176)),c=n.__importDefault(r(162));e.eccentricity=function(r,t,e,a){var f=r*r,n=t*t,u=(f-n)/f,c=0;return a?(f=(r*=1-u*(i.SIXTH+u*(i.RA4+u*i.RA6)))*r,u=0):c=Math.sqrt(u),{es:u,e:c,ep2:(f-n)/n}},e.sphere=function(r,t,e,a,f){if(!r){var n=c.default(u.default,a);n||(n=u.WGS84),r=n.a,t=n.b,e=n.rf}return e&&!t&&(t=(1-1/e)*r),(0===e||Math.abs(r-t)<i.EPSLN)&&(f=!0,t=r),{a:r,b:t,rf:e,sphere:f}}},
function _(e,a,l,s,r){s();var i={};l.default=i,i.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},i.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},i.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},i.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},i.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},i.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},i.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},i.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},i.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},i.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},i.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},i.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},i.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},i.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},i.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},i.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},i.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},i.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},i.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},i.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},i.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},i.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},i.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},i.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},i.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},i.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},i.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},i.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},i.hough={a:6378270,rf:297,ellipseName:"Hough"},i.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},i.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},i.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},i.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},i.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},i.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},i.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},i.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},i.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},i.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},i.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},i.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"},l.WGS84=i.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"},i.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}},
function _(e,a,s,t,l){t();var m={};s.default=m,m.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},m.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},m.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},m.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},m.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},m.potsdam={towgs84:"606.0,23.0,413.0",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},m.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},m.hermannskogel={towgs84:"653.0,-212.0,449.0",ellipse:"bessel",datumName:"Hermannskogel"},m.osni52={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},m.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},m.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},m.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},m.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},m.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},m.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},m.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},m.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},
function _(a,m,_,t,u){t();var p=a(159);_.default=function(a,m,_,t,u,d){var r={};return r.datum_type=void 0===a||"none"===a?p.PJD_NODATUM:p.PJD_WGS84,m&&(r.datum_params=m.map(parseFloat),0===r.datum_params[0]&&0===r.datum_params[1]&&0===r.datum_params[2]||(r.datum_type=p.PJD_3PARAM),r.datum_params.length>3&&(0===r.datum_params[3]&&0===r.datum_params[4]&&0===r.datum_params[5]&&0===r.datum_params[6]||(r.datum_type=p.PJD_7PARAM,r.datum_params[3]*=p.SEC_TO_RAD,r.datum_params[4]*=p.SEC_TO_RAD,r.datum_params[5]*=p.SEC_TO_RAD,r.datum_params[6]=r.datum_params[6]/1e6+1))),r.a=_,r.b=t,r.es=u,r.ep2=d,r}},
function _(t,e,a,r,u){r();var m=t(1),_=t(159),o=m.__importDefault(t(180)),d=m.__importDefault(t(182)),f=m.__importDefault(t(154)),n=m.__importDefault(t(183)),i=m.__importDefault(t(184));a.default=function t(e,a,r){var u;if(Array.isArray(r)&&(r=n.default(r)),i.default(r),e.datum&&a.datum&&function(t,e){return(t.datum.datum_type===_.PJD_3PARAM||t.datum.datum_type===_.PJD_7PARAM)&&"WGS84"!==e.datumCode||(e.datum.datum_type===_.PJD_3PARAM||e.datum.datum_type===_.PJD_7PARAM)&&"WGS84"!==t.datumCode}(e,a)&&(r=t(e,u=new f.default("WGS84"),r),e=u),"enu"!==e.axis&&(r=d.default(e,!1,r)),"longlat"===e.projName)r={x:r.x*_.D2R,y:r.y*_.D2R,z:r.z||0};else if(e.to_meter&&(r={x:r.x*e.to_meter,y:r.y*e.to_meter,z:r.z||0}),!(r=e.inverse(r)))return;return e.from_greenwich&&(r.x+=e.from_greenwich),r=o.default(e.datum,a.datum,r),a.from_greenwich&&(r={x:r.x-a.from_greenwich,y:r.y,z:r.z||0}),"longlat"===a.projName?r={x:r.x*_.R2D,y:r.y*_.R2D,z:r.z||0}:(r=a.forward(r),a.to_meter&&(r={x:r.x/a.to_meter,y:r.y/a.to_meter,z:r.z||0})),"enu"!==a.axis?d.default(a,!0,r):r}},
function _(t,e,a,u,m){u();var _=t(159),c=t(181);function o(t){return t===_.PJD_3PARAM||t===_.PJD_7PARAM}a.default=function(t,e,a){return c.compareDatums(t,e)||t.datum_type===_.PJD_NODATUM||e.datum_type===_.PJD_NODATUM?a:t.es!==e.es||t.a!==e.a||o(t.datum_type)||o(e.datum_type)?(a=c.geodeticToGeocentric(a,t.es,t.a),o(t.datum_type)&&(a=c.geocentricToWgs84(a,t.datum_type,t.datum_params)),o(e.datum_type)&&(a=c.geocentricFromWgs84(a,e.datum_type,e.datum_params)),c.geocentricToGeodetic(a,e.es,e.a,e.b)):a}},
function _(a,t,r,m,u){m();var s=a(159);r.compareDatums=function(a,t){return a.datum_type===t.datum_type&&(!(a.a!==t.a||Math.abs(a.es-t.es)>5e-11)&&(a.datum_type===s.PJD_3PARAM?a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]:a.datum_type!==s.PJD_7PARAM||a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]&&a.datum_params[3]===t.datum_params[3]&&a.datum_params[4]===t.datum_params[4]&&a.datum_params[5]===t.datum_params[5]&&a.datum_params[6]===t.datum_params[6]))},r.geodeticToGeocentric=function(a,t,r){var m,u,_,e,n=a.x,d=a.y,i=a.z?a.z:0;if(d<-s.HALF_PI&&d>-1.001*s.HALF_PI)d=-s.HALF_PI;else if(d>s.HALF_PI&&d<1.001*s.HALF_PI)d=s.HALF_PI;else{if(d<-s.HALF_PI)return{x:-1/0,y:-1/0,z:a.z};if(d>s.HALF_PI)return{x:1/0,y:1/0,z:a.z}}return n>Math.PI&&(n-=2*Math.PI),u=Math.sin(d),e=Math.cos(d),_=u*u,{x:((m=r/Math.sqrt(1-t*_))+i)*e*Math.cos(n),y:(m+i)*e*Math.sin(n),z:(m*(1-t)+i)*u}},r.geocentricToGeodetic=function(a,t,r,m){var u,_,e,n,d,i,p,P,y,z,M,A,o,c,x,h=1e-12,f=a.x,I=a.y,F=a.z?a.z:0;if(u=Math.sqrt(f*f+I*I),_=Math.sqrt(f*f+I*I+F*F),u/r<h){if(c=0,_/r<h)return s.HALF_PI,x=-m,{x:a.x,y:a.y,z:a.z}}else c=Math.atan2(I,f);e=F/_,P=(n=u/_)*(1-t)*(d=1/Math.sqrt(1-t*(2-t)*n*n)),y=e*d,o=0;do{o++,i=t*(p=r/Math.sqrt(1-t*y*y))/(p+(x=u*P+F*y-p*(1-t*y*y))),A=(M=e*(d=1/Math.sqrt(1-i*(2-i)*n*n)))*P-(z=n*(1-i)*d)*y,P=z,y=M}while(A*A>1e-24&&o<30);return{x:c,y:Math.atan(M/Math.abs(z)),z:x}},r.geocentricToWgs84=function(a,t,r){if(t===s.PJD_3PARAM)return{x:a.x+r[0],y:a.y+r[1],z:a.z+r[2]};if(t===s.PJD_7PARAM){var m=r[0],u=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6];return{x:i*(a.x-d*a.y+n*a.z)+m,y:i*(d*a.x+a.y-e*a.z)+u,z:i*(-n*a.x+e*a.y+a.z)+_}}},r.geocentricFromWgs84=function(a,t,r){if(t===s.PJD_3PARAM)return{x:a.x-r[0],y:a.y-r[1],z:a.z-r[2]};if(t===s.PJD_7PARAM){var m=r[0],u=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6],p=(a.x-m)/i,P=(a.y-u)/i,y=(a.z-_)/i;return{x:p+d*P-n*y,y:-d*p+P+e*y,z:n*p-e*P+y}}}},
function _(e,a,i,s,n){s(),i.default=function(e,a,i){var s,n,c,r=i.x,d=i.y,f=i.z||0,u={};for(c=0;c<3;c++)if(!a||2!==c||void 0!==i.z)switch(0===c?(s=r,n=-1!=="ew".indexOf(e.axis[c])?"x":"y"):1===c?(s=d,n=-1!=="ns".indexOf(e.axis[c])?"y":"x"):(s=f,n="z"),e.axis[c]){case"e":case"w":case"n":case"s":u[n]=s;break;case"u":void 0!==i[n]&&(u.z=s);break;case"d":void 0!==i[n]&&(u.z=-s);break;default:return null}return u}},
function _(n,t,e,u,f){u(),e.default=function(n){var t={x:n[0],y:n[1]};return n.length>2&&(t.z=n[2]),n.length>3&&(t.m=n[3]),t}},
function _(e,i,n,t,r){function o(e){if("function"==typeof Number.isFinite){if(Number.isFinite(e))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof e||e!=e||!isFinite(e))throw new TypeError("coordinates must be finite numbers")}t(),n.default=function(e){o(e.x),o(e.y)}},
function _(e,t,n,i,r){i();var o=e(1),a=e(186),l=o.__importStar(e(189)),s=e(135),_=e(196),u=e(197),c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),Object.defineProperty(t.prototype,"coordinates",{get:function(){return this._coordinates},enumerable:!1,configurable:!0}),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.visuals=new l.Visuals(this.model),this.needs_webgl_blit=!1,this._initialize_coordinates()},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this);var n=this.model.properties,i=n.x_range_name,r=n.y_range_name;this.on_change([i,r],(function(){return t._initialize_coordinates()}))},t.prototype._initialize_coordinates=function(){var e=this.model,t=e.x_range_name,n=e.y_range_name,i=this.plot_view.frame,r=i.x_scales.get(t),o=i.y_scales.get(n);this._coordinates=new u.CoordinateTransform(r,o)},Object.defineProperty(t.prototype,"plot_view",{get:function(){return this.parent},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"plot_model",{get:function(){return this.parent.model},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"layer",{get:function(){var e=this.plot_view.canvas_view,t=e.overlays,n=e.primary;return"overlay"==this.model.level?t:n},enumerable:!1,configurable:!0}),t.prototype.request_render=function(){this.plot_view.request_render()},t.prototype.notify_finished=function(){this.plot_view.notify_finished()},Object.defineProperty(t.prototype,"needs_clip",{get:function(){return!1},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"has_webgl",{get:function(){return!1},enumerable:!1,configurable:!0}),t.prototype.render=function(){this.model.visible&&this._render(),this._has_finished=!0},t.prototype.renderer_view=function(e){},t}(a.View);n.RendererView=c,c.__name__="RendererView";var p=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_Renderer=function(){this.define((function(e){var t=e.Boolean,n=e.String;return{level:[s.RenderLevel],visible:[t,!0],x_range_name:[n,"default"],y_range_name:[n,"default"]}}))},t}(_.Model);n.Renderer=p,p.__name__="Renderer",p.init_Renderer()},
function _(t,e,r,n,o){n();var i=t(1),s=t(130),a=t(187),c=t(123),u=i.__importDefault(t(188)),l=function(){function t(t){this.removed=new s.Signal0(this,"removed"),this._ready=Promise.resolve(void 0);var e=t.model,r=t.parent;this.model=e,this.parent=r,this.root=null==r?this:r.root,this.removed.emit()}return Object.defineProperty(t.prototype,"ready",{get:function(){return this._ready},enumerable:!1,configurable:!0}),t.prototype.connect=function(t,e){var r=this;return t.connect((function(t,n){var o=Promise.resolve(e.call(r,t,n));r._ready=r._ready.then((function(){return o}))}),this)},t.prototype.disconnect=function(t,e){return t.disconnect(e,this)},t.prototype.initialize=function(){var t,e;this._has_finished=!1,this.is_root&&(this._stylesheet=a.stylesheet);try{for(var r=i.__values(this.styles()),n=r.next();!n.done;n=r.next()){var o=n.value;this.stylesheet.append(o)}}catch(e){t={error:e}}finally{try{n&&!n.done&&(e=r.return)&&e.call(r)}finally{if(t)throw t.error}}},t.prototype.lazy_initialize=function(){return i.__awaiter(this,void 0,void 0,(function(){return i.__generator(this,(function(t){return[2]}))}))},t.prototype.remove=function(){this.disconnect_signals(),this.removed.emit()},t.prototype.toString=function(){return this.model.type+"View("+this.model.id+")"},t.prototype.serializable_state=function(){return{type:this.model.type}},Object.defineProperty(t.prototype,"is_root",{get:function(){return null==this.parent},enumerable:!1,configurable:!0}),t.prototype.assert_root=function(){if(!this.is_root)throw new Error(this.toString()+" is not a root layout")},t.prototype.has_finished=function(){return this._has_finished},Object.defineProperty(t.prototype,"is_idle",{get:function(){return this.has_finished()},enumerable:!1,configurable:!0}),t.prototype.connect_signals=function(){},t.prototype.disconnect_signals=function(){s.Signal.disconnectReceiver(this)},t.prototype.on_change=function(t,e){var r,n;try{for(var o=i.__values(c.isArray(t)?t:[t]),s=o.next();!s.done;s=o.next()){var a=s.value;this.connect(a.change,e)}}catch(t){r={error:t}}finally{try{s&&!s.done&&(n=o.return)&&n.call(o)}finally{if(r)throw r.error}}},t.prototype.cursor=function(t,e){return null},Object.defineProperty(t.prototype,"stylesheet",{get:function(){return this.is_root?this._stylesheet:this.root.stylesheet},enumerable:!1,configurable:!0}),t.prototype.styles=function(){return[u.default]},t}();r.View=l,l.__name__="View"},
function _(t,e,r,n,i){n();var l=t(1),o=t(123),a=t(128),s=function(t){return function(e){var r,n,i,s,u,c,h,d,f,y,p,v;void 0===e&&(e={});for(var g=[],m=1;m<arguments.length;m++)g[m-1]=arguments[m];var x=document.createElement(t);x.classList.add("bk");try{for(var _=l.__values(a.entries(e)),w=_.next();!w.done;w=_.next()){var b=l.__read(w.value,2),L=b[0],C=b[1];if(null!=C&&(!o.isBoolean(C)||C))if("class"===L&&(o.isString(C)&&(C=C.split(/\s+/)),o.isArray(C)))try{for(var M=(i=void 0,l.__values(C)),E=M.next();!E.done;E=M.next()){var S=E.value;null!=S&&x.classList.add(S)}}catch(t){i={error:t}}finally{try{E&&!E.done&&(s=M.return)&&s.call(M)}finally{if(i)throw i.error}}else if("style"===L&&o.isPlainObject(C))try{for(var B=(u=void 0,l.__values(a.entries(C))),k=B.next();!k.done;k=B.next()){var T=l.__read(k.value,2),N=T[0],R=T[1];x.style[N]=R}}catch(t){u={error:t}}finally{try{k&&!k.done&&(c=B.return)&&c.call(B)}finally{if(u)throw u.error}}else if("data"===L&&o.isPlainObject(C))try{for(var A=(h=void 0,l.__values(a.entries(C))),z=A.next();!z.done;z=A.next()){var D=l.__read(z.value,2),O=D[0];R=D[1];x.dataset[O]=R}}catch(t){h={error:t}}finally{try{z&&!z.done&&(d=A.return)&&d.call(A)}finally{if(h)throw h.error}}else x.setAttribute(L,C)}}catch(t){r={error:t}}finally{try{w&&!w.done&&(n=_.return)&&n.call(_)}finally{if(r)throw r.error}}function P(t){var e,r;if(o.isString(t))x.appendChild(document.createTextNode(t));else if(t instanceof Node)x.appendChild(t);else if(t instanceof NodeList||t instanceof HTMLCollection)try{for(var n=l.__values(t),i=n.next();!i.done;i=n.next()){var a=i.value;x.appendChild(a)}}catch(t){e={error:t}}finally{try{i&&!i.done&&(r=n.return)&&r.call(n)}finally{if(e)throw e.error}}else if(null!=t&&!1!==t)throw new Error("expected a DOM element, string, false or null, got "+JSON.stringify(t))}try{for(var W=l.__values(g),U=W.next();!U.done;U=W.next()){var j=U.value;if(o.isArray(j))try{for(var H=(p=void 0,l.__values(j)),K=H.next();!K.done;K=H.next()){var F=K.value;P(F)}}catch(t){p={error:t}}finally{try{K&&!K.done&&(v=H.return)&&v.call(H)}finally{if(p)throw p.error}}else P(j)}}catch(t){f={error:t}}finally{try{U&&!U.done&&(y=W.return)&&y.call(W)}finally{if(f)throw f.error}}return x}};function u(t){var e=t.parentNode;null!=e&&e.removeChild(t)}function c(t){for(var e,r,n=[],i=1;i<arguments.length;i++)n[i-1]=arguments[i];var o=t.firstChild;try{for(var a=l.__values(n),s=a.next();!s.done;s=a.next()){var u=s.value;t.insertBefore(u,o)}}catch(t){e={error:t}}finally{try{s&&!s.done&&(r=a.return)&&r.call(a)}finally{if(e)throw e.error}}}function h(t,e){var r,n,i,l=Element.prototype;return(null!==(i=null!==(n=null!==(r=l.matches)&&void 0!==r?r:l.webkitMatchesSelector)&&void 0!==n?n:l.mozMatchesSelector)&&void 0!==i?i:l.msMatchesSelector).call(t,e)}function d(t){return parseFloat(t)||0}function f(t){var e=getComputedStyle(t);return{border:{top:d(e.borderTopWidth),bottom:d(e.borderBottomWidth),left:d(e.borderLeftWidth),right:d(e.borderRightWidth)},margin:{top:d(e.marginTop),bottom:d(e.marginBottom),left:d(e.marginLeft),right:d(e.marginRight)},padding:{top:d(e.paddingTop),bottom:d(e.paddingBottom),left:d(e.paddingLeft),right:d(e.paddingRight)}}}function y(t){var e=t.getBoundingClientRect();return{width:Math.ceil(e.width),height:Math.ceil(e.height)}}r.createElement=function(t,e){for(var r=[],n=2;n<arguments.length;n++)r[n-2]=arguments[n];return s(t).apply(void 0,l.__spread([e],r))},r.div=s("div"),r.span=s("span"),r.canvas=s("canvas"),r.link=s("link"),r.style=s("style"),r.a=s("a"),r.p=s("p"),r.i=s("i"),r.pre=s("pre"),r.button=s("button"),r.label=s("label"),r.input=s("input"),r.select=s("select"),r.option=s("option"),r.optgroup=s("optgroup"),r.textarea=s("textarea"),r.nbsp=function(){return document.createTextNode(" ")},r.append=function(t){for(var e,r,n=[],i=1;i<arguments.length;i++)n[i-1]=arguments[i];try{for(var o=l.__values(n),a=o.next();!a.done;a=o.next()){var s=a.value;t.appendChild(s)}}catch(t){e={error:t}}finally{try{a&&!a.done&&(r=o.return)&&r.call(o)}finally{if(e)throw e.error}}},r.remove=u,r.removeElement=u,r.replaceWith=function(t,e){var r=t.parentNode;null!=r&&r.replaceChild(e,t)},r.prepend=c,r.empty=function(t,e){var r,n,i;for(void 0===e&&(e=!1);i=t.firstChild;)t.removeChild(i);if(e&&t instanceof Element)try{for(var o=l.__values(t.attributes),a=o.next();!a.done;a=o.next()){var s=a.value;t.removeAttributeNode(s)}}catch(t){r={error:t}}finally{try{a&&!a.done&&(n=o.return)&&n.call(o)}finally{if(r)throw r.error}}},r.display=function(t){t.style.display=""},r.undisplay=function(t){t.style.display="none"},r.show=function(t){t.style.visibility=""},r.hide=function(t){t.style.visibility="hidden"},r.offset=function(t){var e=t.getBoundingClientRect();return{top:e.top+window.pageYOffset-document.documentElement.clientTop,left:e.left+window.pageXOffset-document.documentElement.clientLeft}},r.matches=h,r.parent=function(t,e){for(var r=t;r=r.parentElement;)if(h(r,e))return r;return null},r.extents=f,r.size=y,r.scroll_size=function(t){return{width:Math.ceil(t.scrollWidth),height:Math.ceil(t.scrollHeight)}},r.outer_size=function(t){var e=f(t).margin,r=e.left,n=e.right,i=e.top,l=e.bottom,o=y(t),a=o.width,s=o.height;return{width:Math.ceil(a+r+n),height:Math.ceil(s+i+l)}},r.content_size=function(t){var e,r,n=t.getBoundingClientRect(),i=n.left,o=n.top,a=f(t).padding,s=0,u=0;try{for(var c=l.__values(t.children),h=c.next();!h.done;h=c.next()){var d=h.value.getBoundingClientRect();s=Math.max(s,Math.ceil(d.left-i-a.left+d.width)),u=Math.max(u,Math.ceil(d.top-o-a.top+d.height))}}catch(t){e={error:t}}finally{try{h&&!h.done&&(r=c.return)&&r.call(c)}finally{if(e)throw e.error}}return{width:s,height:u}},r.position=function(t,e,r){var n=t.style;if(n.left=e.x+"px",n.top=e.y+"px",n.width=e.width+"px",n.height=e.height+"px",null==r)n.margin="";else{var i=r.top,l=r.right,o=r.bottom,a=r.left;n.margin=i+"px "+l+"px "+o+"px "+a+"px"}},r.children=function(t){return Array.from(t.children)};var p,v=function(){function t(t){this.el=t,this.classList=t.classList}return Object.defineProperty(t.prototype,"values",{get:function(){for(var t=[],e=0;e<this.classList.length;e++){var r=this.classList.item(e);null!=r&&t.push(r)}return t},enumerable:!1,configurable:!0}),t.prototype.has=function(t){return this.classList.contains(t)},t.prototype.add=function(){for(var t,e,r=[],n=0;n<arguments.length;n++)r[n]=arguments[n];try{for(var i=l.__values(r),o=i.next();!o.done;o=i.next()){var a=o.value;this.classList.add(a)}}catch(e){t={error:e}}finally{try{o&&!o.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}return this},t.prototype.remove=function(){for(var t,e,r=[],n=0;n<arguments.length;n++)r[n]=arguments[n];try{for(var i=l.__values(r),o=i.next();!o.done;o=i.next()){var a=o.value;this.classList.remove(a)}}catch(e){t={error:e}}finally{try{o&&!o.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}return this},t.prototype.clear=function(){var t,e;try{for(var r=l.__values(this.values),n=r.next();!n.done;n=r.next()){var i=n.value;"bk"!=i&&this.classList.remove(i)}}catch(e){t={error:e}}finally{try{n&&!n.done&&(e=r.return)&&e.call(r)}finally{if(t)throw t.error}}return this},t.prototype.toggle=function(t,e){return(null!=e?e:!this.has(t))?this.add(t):this.remove(t),this},t}();function g(t,e,r){var n=t.style,i=n.width,l=n.height,o=n.position,a=n.display;t.style.position="absolute",t.style.display="",t.style.width=null!=e.width&&e.width!=1/0?e.width+"px":"auto",t.style.height=null!=e.height&&e.height!=1/0?e.height+"px":"auto";try{return r()}finally{t.style.position=o,t.style.display=a,t.style.width=i,t.style.height=l}}r.ClassList=v,v.__name__="ClassList",r.classes=function(t){return new v(t)},r.toggle_attribute=function(t,e,r){null==r&&(r=!t.hasAttribute(e)),r?t.setAttribute(e,"true"):t.removeAttribute(e)},(p=r.Keys||(r.Keys={}))[p.Backspace=8]="Backspace",p[p.Tab=9]="Tab",p[p.Enter=13]="Enter",p[p.Esc=27]="Esc",p[p.PageUp=33]="PageUp",p[p.PageDown=34]="PageDown",p[p.Left=37]="Left",p[p.Up=38]="Up",p[p.Right=39]="Right",p[p.Down=40]="Down",p[p.Delete=46]="Delete",r.undisplayed=function(t,e){var r=t.style.display;t.style.display="none";try{return e()}finally{t.style.display=r}},r.unsized=function(t,e){return g(t,{},e)},r.sized=g;var m=function(){function t(t){this.root=t,this.known=new Set,this.style=r.style({type:"text/css"}),c(t,this.style)}return t.prototype.append=function(t){this.known.has(t)||(this.style.appendChild(document.createTextNode(t)),this.known.add(t))},t}();r.StyleSheet=m,m.__name__="StyleSheet",r.stylesheet=new m(document.head)},
function _(n,o,i,e,t){e();i.default="\n.bk-root {\n  position: relative;\n  width: auto;\n  height: auto;\n  z-index: 0;\n  box-sizing: border-box;\n  font-family: Helvetica, Arial, sans-serif;\n  font-size: 13px;\n}\n.bk-root .bk,\n.bk-root .bk:before,\n.bk-root .bk:after {\n  box-sizing: inherit;\n  margin: 0;\n  border: 0;\n  padding: 0;\n  background-image: none;\n  font-family: inherit;\n  font-size: 100%;\n  line-height: 1.42857143;\n}\n.bk-root pre.bk {\n  font-family: Courier, monospace;\n}\n"},
function _(e,t,a,r,o){r();var i=e(1),l=i.__importStar(e(143)),n=i.__importStar(e(133)),c=e(137),s=e(123),h=e(190),_=e(192);function u(e,t){var a=i.__read(s.isString(e)?c.color2rgba(e):c.decode_rgba(e),4),r=a[0],o=a[1],l=a[2],n=a[3];return"rgba("+255*r+", "+255*o+", "+255*l+", "+(1==n?t:n)+")"}function p(e,t,a){e.moveTo(0,a+.5),e.lineTo(t,a+.5),e.stroke()}function v(e,t,a){e.moveTo(a+.5,0),e.lineTo(a+.5,t),e.stroke()}function f(e,t){e.moveTo(0,t),e.lineTo(t,0),e.stroke(),e.moveTo(0,0),e.lineTo(t,t),e.stroke()}a.hatch_aliases={" ":"blank",".":"dot",o:"ring","-":"horizontal_line","|":"vertical_line","+":"cross",'"':"horizontal_dash",":":"vertical_dash","@":"spiral","/":"right_diagonal_line","\\":"left_diagonal_line",x:"diagonal_cross",",":"right_diagonal_dash","`":"left_diagonal_dash",v:"horizontal_wave",">":"vertical_wave","*":"criss_cross"};var y=function(){function e(e,t){var a,r;void 0===t&&(t=""),this.obj=e,this.prefix=t,this.cache={};try{for(var o=i.__values(this.attrs),l=o.next();!l.done;l=o.next()){var n=l.value;this[n]=e.properties[t+n]}}catch(e){a={error:e}}finally{try{l&&!l.done&&(r=o.return)&&r.call(o)}finally{if(a)throw a.error}}}return e.prototype.warm_cache=function(e,t){var a,r;try{for(var o=i.__values(this.attrs),l=o.next();!l.done;l=o.next()){var c=l.value,s=this.obj.properties[this.prefix+c];if(void 0!==s.spec.value)this.cache[c]=s.spec.value;else{if(!(null!=e&&s instanceof n.VectorSpec))throw new Error("source is required with a vectorized visual property");var h=s.array(e),_=null!=t?t.select(h):h;this.cache[c+"_array"]=_}}}catch(e){a={error:e}}finally{try{l&&!l.done&&(r=o.return)&&r.call(o)}finally{if(a)throw a.error}}},e.prototype.cache_select=function(e,t){var a,r=this.obj.properties[this.prefix+e];return void 0!==r.spec.value?this.cache[e]=a=r.spec.value:this.cache[e]=a=this.cache[e+"_array"][t],a},e.prototype.get_array=function(e){return this.cache[e+"_array"]},e.prototype.set_vectorize=function(e,t){this._set_vectorize(e,t)},e}();a.ContextProperties=y,y.__name__="ContextProperties";var d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.set_value=function(e){var t=this.line_color.value(),a=this.line_alpha.value();e.strokeStyle=u(t,a),e.lineWidth=this.line_width.value(),e.lineJoin=this.line_join.value(),e.lineCap=this.line_cap.value(),e.lineDash=this.line_dash.value(),e.lineDashOffset=this.line_dash_offset.value()},Object.defineProperty(t.prototype,"doit",{get:function(){return!(null===this.line_color.spec.value||0==this.line_alpha.spec.value||0==this.line_width.spec.value)},enumerable:!1,configurable:!0}),t.prototype._set_vectorize=function(e,t){var a=this.cache_select("line_color",t),r=this.cache_select("line_alpha",t),o=this.cache_select("line_width",t),i=this.cache_select("line_join",t),l=this.cache_select("line_cap",t),n=this.cache_select("line_dash",t),c=this.cache_select("line_dash_offset",t);e.strokeStyle=u(a,r),e.lineWidth=o,e.lineJoin=i,e.lineCap=l,e.lineDash=n,e.lineDashOffset=c},t.prototype.color_value=function(){return u(this.line_color.value(),this.line_alpha.value())},t}(y);a.Line=d,d.__name__="Line",d.prototype.attrs=Object.keys(l.LineVector);var x=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.set_value=function(e){var t=this.fill_color.value(),a=this.fill_alpha.value();e.fillStyle=u(t,a)},Object.defineProperty(t.prototype,"doit",{get:function(){return!(null===this.fill_color.spec.value||0==this.fill_alpha.spec.value)},enumerable:!1,configurable:!0}),t.prototype._set_vectorize=function(e,t){var a=this.cache_select("fill_color",t),r=this.cache_select("fill_alpha",t);e.fillStyle=u(a,r)},t.prototype.color_value=function(){return u(this.fill_color.value(),this.fill_alpha.value())},t}(y);a.Fill=x,x.__name__="Fill",x.prototype.attrs=Object.keys(l.FillVector);var k=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.cache_select=function(t,r){var o;if("pattern"==t){var i=this.cache_select("hatch_color",r),l=this.cache_select("hatch_alpha",r),n=this.cache_select("hatch_scale",r),c=this.cache_select("hatch_pattern",r),s=this.cache_select("hatch_weight",r),y=this.cache.hatch_extra;if(null!=y&&y.hasOwnProperty(c)){var d=y[c];this.cache.pattern=d.get_pattern(i,l,n,s)}else this.cache.pattern=function(e){var t=e instanceof h.SVGRenderingContext2D?"svg":"canvas",r=new _.CanvasLayer(t,!0);return r.resize(n,n),r.prepare(),function(e,t,r,o,i,l){var n,c=i,s=c/2,h=s/2;switch(e.strokeStyle=u(r,o),e.lineCap="square",e.fillStyle=r,e.lineWidth=l,null!==(n=a.hatch_aliases[t])&&void 0!==n?n:t){case"blank":break;case"dot":e.arc(s,s,s/2,0,2*Math.PI,!0),e.fill();break;case"ring":e.arc(s,s,s/2,0,2*Math.PI,!0),e.stroke();break;case"horizontal_line":p(e,c,s);break;case"vertical_line":v(e,c,s);break;case"cross":p(e,c,s),v(e,c,s);break;case"horizontal_dash":p(e,s,s);break;case"vertical_dash":v(e,s,s);break;case"spiral":var _=c/30;e.moveTo(s,s);for(var y=0;y<360;y++){var d=.1*y,x=s+_*d*Math.cos(d),k=s+_*d*Math.sin(d);e.lineTo(x,k)}e.stroke();break;case"right_diagonal_line":e.moveTo(.5-h,c),e.lineTo(h+.5,0),e.stroke(),e.moveTo(h+.5,c),e.lineTo(3*h+.5,0),e.stroke(),e.moveTo(3*h+.5,c),e.lineTo(5*h+.5,0),e.stroke(),e.stroke();break;case"left_diagonal_line":e.moveTo(h+.5,c),e.lineTo(.5-h,0),e.stroke(),e.moveTo(3*h+.5,c),e.lineTo(h+.5,0),e.stroke(),e.moveTo(5*h+.5,c),e.lineTo(3*h+.5,0),e.stroke(),e.stroke();break;case"diagonal_cross":f(e,c);break;case"right_diagonal_dash":e.moveTo(h+.5,3*h+.5),e.lineTo(3*h+.5,h+.5),e.stroke();break;case"left_diagonal_dash":e.moveTo(h+.5,h+.5),e.lineTo(3*h+.5,3*h+.5),e.stroke();break;case"horizontal_wave":e.moveTo(0,h),e.lineTo(s,3*h),e.lineTo(c,h),e.stroke();break;case"vertical_wave":e.moveTo(h,0),e.lineTo(3*h,s),e.lineTo(h,c),e.stroke();break;case"criss_cross":f(e,c),p(e,c,s),v(e,c,s)}}(r.ctx,c,i,l,n,s),e.createPattern(r.canvas,"repeat")}}else o=e.prototype.cache_select.call(this,t,r);return o},t.prototype._try_defer=function(e){var t=this.cache,a=t.hatch_pattern,r=t.hatch_extra;null!=r&&r.hasOwnProperty(a)&&r[a].onload(e)},Object.defineProperty(t.prototype,"doit",{get:function(){return!(null===this.hatch_color.spec.value||0==this.hatch_alpha.spec.value||" "==this.hatch_pattern.spec.value||"blank"==this.hatch_pattern.spec.value||null===this.hatch_pattern.spec.value)},enumerable:!1,configurable:!0}),t.prototype.doit2=function(e,t,a,r){this.doit&&(this.cache_select("pattern",t),null==this.cache.pattern(e)?this._try_defer(r):(this.set_vectorize(e,t),a()))},t.prototype._set_vectorize=function(e,t){this.cache_select("pattern",t),e.fillStyle=this.cache.pattern(e)},t.prototype.color_value=function(){return u(this.hatch_color.value(),this.hatch_alpha.value())},t}(y);a.Hatch=k,k.__name__="Hatch",k.prototype.attrs=Object.keys(l.HatchVector);var b=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.color_value=function(){return u(this.text_color.value(),this.text_alpha.value())},t.prototype.font_value=function(){var e=this.text_font.value(),t=this.text_font_size.value();return this.text_font_style.value()+" "+t+" "+e},t.prototype.v_font_value=function(t){e.prototype.cache_select.call(this,"text_font_style",t),e.prototype.cache_select.call(this,"text_font_size",t),e.prototype.cache_select.call(this,"text_font",t);var a=this.cache;return a.text_font_style+" "+a.text_font_size+" "+a.text_font},t.prototype.cache_select=function(t,a){var r;return"font"==t?this.cache.font=r=this.v_font_value(a):r=e.prototype.cache_select.call(this,t,a),r},t.prototype.set_value=function(e){var t=this.text_color.value(),a=this.text_alpha.value();e.fillStyle=u(t,a),e.font=this.font_value(),e.textAlign=this.text_align.value(),e.textBaseline=this.text_baseline.value()},Object.defineProperty(t.prototype,"doit",{get:function(){return!(null===this.text_color.spec.value||0==this.text_alpha.spec.value)},enumerable:!1,configurable:!0}),t.prototype._set_vectorize=function(e,t){var a=this.cache_select("text_color",t),r=this.cache_select("text_alpha",t),o=this.cache_select("font",t),i=this.cache_select("text_align",t),l=this.cache_select("text_baseline",t);e.fillStyle=u(a,r),e.font=o,e.textAlign=i,e.textBaseline=l},t}(y);a.Text=b,b.__name__="Text",b.prototype.attrs=Object.keys(l.TextVector);var g=function(){function e(e){var t,a;try{for(var r=i.__values(e._mixins),o=r.next();!o.done;o=r.next()){var l=o.value,n=i.__read(l.split(":"),2),c=n[0],s=n[1],h=void 0===s?"":s,_=void 0;switch(c){case"line":_=d;break;case"fill":_=x;break;case"hatch":_=k;break;case"text":_=b;break;default:throw new Error("unknown visual: "+c)}this[h+c]=new _(e,h)}}catch(e){t={error:e}}finally{try{o&&!o.done&&(a=r.return)&&a.call(r)}finally{if(t)throw t.error}}}return e.prototype.warm_cache=function(e,t){for(var a in this)if(this.hasOwnProperty(a)){var r=this[a];r instanceof y&&r.warm_cache(e,t)}},e}();a.Visuals=g,g.__name__="Visuals"},
function _(t,e,r,i,n){i();var a=t(1),s=t(191),o=t(123),l=t(187);function h(t){if(!t)throw new Error("cannot create a random attribute name for an undefined object");var e="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz",r="";do{r="";for(var i=0;i<12;i++)r+=e[Math.floor(Math.random()*e.length)]}while(t[r]);return r}function _(t){var e,r={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return null!==(e=r[t])&&void 0!==e?e:r.alphabetic}var p=function(t,e){var r=new Map,i=t.split(",");e=null!=e?e:10;for(var n=0;n<i.length;n+=2){var a="&"+i[n+1]+";",s=parseInt(i[n],e);r.set(a,"&#"+s+";")}return r.set("\\xa0","&#160;"),r}("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),u={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}},c=function(){function t(t,e){this.__root=t,this.__ctx=e}return t.prototype.addColorStop=function(t,e){var r=this.__ctx.__createElement("stop");if(r.setAttribute("offset",""+t),-1!==e.indexOf("rgba")){var i=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(e),n=a.__read(i,5),s=n[1],o=n[2],l=n[3],h=n[4];r.setAttribute("stop-color","rgb("+s+","+o+","+l+")"),r.setAttribute("stop-opacity",h)}else r.setAttribute("stop-color",e);this.__root.appendChild(r)},t}();c.__name__="CanvasGradient";var d=function(t,e){this.__root=t,this.__ctx=e};d.__name__="CanvasPattern";var f=function(){function t(t){var e,r,i;this.__currentPosition=null,this.__currentElementsToStyle=null,this._transform=new s.AffineTransform,this._clip_path=null,this.__document=null!==(e=null==t?void 0:t.document)&&void 0!==e?e:document,(null==t?void 0:t.ctx)?this.__ctx=t.ctx:(this.__canvas=this.__document.createElement("canvas"),this.__ctx=this.__canvas.getContext("2d")),this.__setDefaultStyles(),this.__stack=[],this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg"),this.__root.setAttribute("version","1.1"),this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink"),this.width=null!==(r=null==t?void 0:t.width)&&void 0!==r?r:500,this.height=null!==(i=null==t?void 0:t.height)&&void 0!==i?i:500,this.__ids={},this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs"),this.__root.appendChild(this.__defs)}return Object.defineProperty(t.prototype,"canvas",{get:function(){return this},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"width",{get:function(){return this._width},set:function(t){this._width=t,this.__root.setAttribute("width",""+t)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"height",{get:function(){return this._height},set:function(t){this._height=t,this.__root.setAttribute("height",""+t)},enumerable:!1,configurable:!0}),t.prototype.__createElement=function(t,e,r){var i,n;void 0===e&&(e={}),void 0===r&&(r=!1);var s=this.__document.createElementNS("http://www.w3.org/2000/svg",t);r&&(s.setAttribute("fill","none"),s.setAttribute("stroke","none"));var o=Object.keys(e);try{for(var l=a.__values(o),h=l.next();!h.done;h=l.next()){var _=h.value;s.setAttribute(_,""+e[_])}}catch(t){i={error:t}}finally{try{h&&!h.done&&(n=l.return)&&n.call(l)}finally{if(i)throw i.error}}return s},t.prototype.__setDefaultStyles=function(){for(var t=Object.keys(u),e=0;e<t.length;e++){var r=t[e];this[r]=u[r].canvas}},t.prototype.__applyStyleState=function(t){for(var e=Object.keys(t),r=0;r<e.length;r++){var i=e[r];this[i]=t[i]}},t.prototype.__getStyleState=function(){for(var t=Object.keys(u),e={},r=0;r<t.length;r++){var i=t[r];e[i]=this[i]}return e},t.prototype.__applyStyleToCurrentElement=function(t){var e,r,i,n,s=this.__currentElement,l=this.__currentElementsToStyle;if(null!=l){s.setAttribute(t,""),s=l.element;try{for(var h=a.__values(l.children),_=h.next();!_.done;_=h.next()){_.value.setAttribute(t,"")}}catch(t){e={error:t}}finally{try{_&&!_.done&&(r=h.return)&&r.call(h)}finally{if(e)throw e.error}}}for(var p=Object.keys(u),f=0;f<p.length;f++){var m=u[p[f]],g=this[p[f]];if(m.apply)if(g instanceof d){try{for(var v=(i=void 0,a.__values(a.__spread(g.__ctx.__defs.childNodes))),y=v.next();!y.done;y=v.next()){var b=y.value;if(b instanceof Element){var w=b.getAttribute("id");this.__ids[w]=w,this.__defs.appendChild(b)}}}catch(t){i={error:t}}finally{try{y&&!y.done&&(n=v.return)&&n.call(v)}finally{if(i)throw i.error}}var x=g.__root.getAttribute("id");s.setAttribute(m.apply,"url(#"+x+")")}else if(g instanceof c){x=g.__root.getAttribute("id");s.setAttribute(m.apply,"url(#"+x+")")}else if(-1!==m.apply.indexOf(t)&&m.svg!==g)if("stroke"!==m.svgAttr&&"fill"!==m.svgAttr||!o.isString(g)||-1===g.indexOf("rgba")){var A=m.svgAttr;if("globalAlpha"===p[f]&&(A=t+"-"+m.svgAttr,s.getAttribute(A)))continue;s.setAttribute(A,""+g)}else{var E=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(g),k=a.__read(E,5),C=k[1],S=k[2],P=k[3],T=k[4];s.setAttribute(m.svgAttr,"rgb("+C+","+S+","+P+")");var j=parseFloat(T),F=this.globalAlpha;null!=F&&(j*=F),s.setAttribute(m.svgAttr+"-opacity",""+j)}}},t.prototype.get_serialized_svg=function(t){var e,r;void 0===t&&(t=!1);var i=(new XMLSerializer).serializeToString(this.__root);if(/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi.test(i)&&(i=i.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')),t)try{for(var n=a.__values(p),s=n.next();!s.done;s=n.next()){var o=a.__read(s.value,2),l=o[0],h=o[1],_=new RegExp(l,"gi");_.test(i)&&(i=i.replace(_,h))}}catch(t){e={error:t}}finally{try{s&&!s.done&&(r=n.return)&&r.call(n)}finally{if(e)throw e.error}}return i},t.prototype.get_svg=function(){return this.__root},t.prototype.save=function(){this.__stack.push({transform:this._transform,clip_path:this._clip_path,attributes:this.__getStyleState()}),this._transform=this._transform.clone()},t.prototype.restore=function(){if(0!=this.__stack.length){var t=this.__stack.pop(),e=t.transform,r=t.clip_path,i=t.attributes;this._transform=e,this._clip_path=r,this.__applyStyleState(i)}},t.prototype._apply_transform=function(t,e){void 0===e&&(e=this._transform),e.is_identity||t.setAttribute("transform",e.toString())},t.prototype.scale=function(t,e){isFinite(t)&&(null==e||isFinite(e))&&this._transform.scale(t,null!=e?e:t)},t.prototype.rotate=function(t){isFinite(t)&&this._transform.rotate(t)},t.prototype.translate=function(t,e){isFinite(t+e)&&this._transform.translate(t,e)},t.prototype.transform=function(t,e,r,i,n,a){isFinite(t+e+r+i+n+a)&&this._transform.transform(t,e,r,i,n,a)},t.prototype.beginPath=function(){this.__currentDefaultPath="",this.__currentPosition=null;var t=this.__createElement("path",{},!0);this.__root.appendChild(t),this.__currentElement=t},t.prototype.__applyCurrentDefaultPath=function(){var t=this.__currentElement;"path"===t.nodeName?t.setAttribute("d",this.__currentDefaultPath):console.error("Attempted to apply path command to node",t.nodeName)},t.prototype.__addPathCommand=function(t,e,r){var i=this.__currentDefaultPath?" ":"";this.__currentDefaultPath+=i+r,this.__currentPosition={x:t,y:e}},Object.defineProperty(t.prototype,"_hasCurrentDefaultPath",{get:function(){return!!this.__currentDefaultPath},enumerable:!1,configurable:!0}),t.prototype.moveTo=function(t,e){if(isFinite(t+e)){"path"!==this.__currentElement.nodeName&&this.beginPath();var r=a.__read(this._transform.apply(t,e),2),i=r[0],n=r[1];this.__addPathCommand(i,n,"M "+i+" "+n)}},t.prototype.closePath=function(){this._hasCurrentDefaultPath&&this.__addPathCommand(NaN,NaN,"Z")},t.prototype.lineTo=function(t,e){if(isFinite(t+e))if(this._hasCurrentDefaultPath){var r=a.__read(this._transform.apply(t,e),2),i=r[0],n=r[1];this.__addPathCommand(i,n,"L "+i+" "+n)}else this.moveTo(t,e)},t.prototype.bezierCurveTo=function(t,e,r,i,n,s){if(isFinite(t+e+r+i+n+s)){var o=a.__read(this._transform.apply(n,s),2),l=o[0],h=o[1],_=a.__read(this._transform.apply(t,e),2),p=_[0],u=_[1],c=a.__read(this._transform.apply(r,i),2),d=c[0],f=c[1];this.__addPathCommand(l,h,"C "+p+" "+u+" "+d+" "+f+" "+l+" "+h)}},t.prototype.quadraticCurveTo=function(t,e,r,i){if(isFinite(t+e+r+i)){var n=a.__read(this._transform.apply(r,i),2),s=n[0],o=n[1],l=a.__read(this._transform.apply(t,e),2),h=l[0],_=l[1];this.__addPathCommand(s,o,"Q "+h+" "+_+" "+s+" "+o)}},t.prototype.arcTo=function(t,e,r,i,n){if(isFinite(t+e+r+i+n)&&null!=this.__currentPosition){var s=this.__currentPosition.x,o=this.__currentPosition.y;if(n<0)throw new Error("IndexSizeError: The radius provided ("+n+") is negative.");if(s===t&&o===e||t===r&&e===i||0===n)this.lineTo(t,e);else{var l=b([s-t,o-e]),h=b([r-t,i-e]);if(l[0]*h[1]!=l[1]*h[0]){var _=l[0]*h[0]+l[1]*h[1],p=Math.acos(Math.abs(_)),u=b([l[0]+h[0],l[1]+h[1]]),c=n/Math.sin(p/2),d=t+c*u[0],f=e+c*u[1],m=[-l[1],l[0]],g=[h[1],-h[0]],v=w(m),y=w(g);this.lineTo(d+m[0]*n,f+m[1]*n),this.arc(d,f,n,v,y)}else this.lineTo(t,e)}}function b(t){var e=a.__read(t,2),r=e[0],i=e[1],n=Math.sqrt(Math.pow(r,2)+Math.pow(i,2));return[r/n,i/n]}function w(t){var e=t[0];return t[1]>=0?Math.acos(e):-Math.acos(e)}},t.prototype.stroke=function(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","fill"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("stroke"),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)},t.prototype.fill=function(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","stroke"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("fill"),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)},t.prototype.rect=function(t,e,r,i){isFinite(t+e+r+i)&&("path"!==this.__currentElement.nodeName&&this.beginPath(),this.moveTo(t,e),this.lineTo(t+r,e),this.lineTo(t+r,e+i),this.lineTo(t,e+i),this.lineTo(t,e))},t.prototype.fillRect=function(t,e,r,i){isFinite(t+e+r+i)&&(this.beginPath(),this.rect(t,e,r,i),this.fill())},t.prototype.strokeRect=function(t,e,r,i){isFinite(t+e+r+i)&&(this.beginPath(),this.rect(t,e,r,i),this.stroke())},t.prototype.__clearCanvas=function(){l.empty(this.__defs),l.empty(this.__root),this.__root.appendChild(this.__defs),this.__currentElement=this.__root},t.prototype.clearRect=function(t,e,r,i){if(isFinite(t+e+r+i))if(0!==t||0!==e||r!==this.width||i!==this.height){var n=this.__createElement("rect",{x:t,y:e,width:r,height:i,fill:"#FFFFFF"},!0);this._apply_transform(n),this.__root.appendChild(n)}else this.__clearCanvas()},t.prototype.createLinearGradient=function(t,e,r,i){if(!isFinite(t+e+r+i))throw new Error("The provided double value is non-finite");var n=a.__read(this._transform.apply(t,e),2),s=n[0],o=n[1],l=a.__read(this._transform.apply(r,i),2),_=l[0],p=l[1],u=this.__createElement("linearGradient",{id:h(this.__ids),x1:s+"px",x2:_+"px",y1:o+"px",y2:p+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(u),new c(u,this)},t.prototype.createRadialGradient=function(t,e,r,i,n,s){if(!isFinite(t+e+r+i+n+s))throw new Error("The provided double value is non-finite");var o=a.__read(this._transform.apply(t,e),2),l=o[0],_=o[1],p=a.__read(this._transform.apply(i,n),2),u=p[0],d=p[1],f=this.__createElement("radialGradient",{id:h(this.__ids),cx:u+"px",cy:d+"px",r:s+"px",fx:l+"px",fy:_+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(f),new c(f,this)},t.prototype.__parseFont=function(){var t,e,r,i,n,a=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font),s={style:null!==(t=a[1])&&void 0!==t?t:"normal",size:null!==(e=a[4])&&void 0!==e?e:"10px",family:null!==(r=a[6])&&void 0!==r?r:"sans-serif",weight:null!==(i=a[3])&&void 0!==i?i:"normal",decoration:null!==(n=a[2])&&void 0!==n?n:"normal"};return"underline"===this.__fontUnderline&&(s.decoration="underline"),null!=this.__fontHref&&(s.href=this.__fontHref),s},t.prototype.__wrapTextLink=function(t,e){if(t.href){var r=this.__createElement("a");return r.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",t.href),r.appendChild(e),r}return e},t.prototype.__applyText=function(t,e,r,i){var n,a,s,o=this.__parseFont(),l=this.__createElement("text",{"font-family":o.family,"font-size":o.size,"font-style":o.style,"font-weight":o.weight,"text-decoration":o.decoration,x:e,y:r,"text-anchor":(n=this.textAlign,s={left:"start",right:"end",center:"middle",start:"start",end:"end"},null!==(a=s[n])&&void 0!==a?a:s.start),"dominant-baseline":_(this.textBaseline)},!0);l.appendChild(this.__document.createTextNode(t)),this._apply_transform(l),this.__currentElement=l,this.__applyStyleToCurrentElement(i),this.__root.appendChild(this.__wrapTextLink(o,l))},t.prototype.fillText=function(t,e,r){null!=t&&isFinite(e+r)&&this.__applyText(t,e,r,"fill")},t.prototype.strokeText=function(t,e,r){null!=t&&isFinite(e+r)&&this.__applyText(t,e,r,"stroke")},t.prototype.measureText=function(t){return this.__ctx.font=this.font,this.__ctx.measureText(t)},t.prototype.arc=function(t,e,r,i,n,s){if(void 0===s&&(s=!1),isFinite(t+e+r+i+n)&&i!==n){(i%=2*Math.PI)===(n%=2*Math.PI)&&(n=(n+2*Math.PI-.001*(s?-1:1))%(2*Math.PI));var o=t+r*Math.cos(n),l=e+r*Math.sin(n),h=t+r*Math.cos(i),_=e+r*Math.sin(i),p=s?0:1,u=0,c=n-i;c<0&&(c+=2*Math.PI),u=s?c>Math.PI?0:1:c>Math.PI?1:0,this.lineTo(h,_);var d=r,f=r,m=a.__read(this._transform.apply(o,l),2),g=m[0],v=m[1];this.__addPathCommand(g,v,"A "+d+" "+f+" 0 "+u+" "+p+" "+g+" "+v)}},t.prototype.clip=function(){var t=this.__createElement("clipPath"),e=h(this.__ids);this.__applyCurrentDefaultPath(),t.setAttribute("id",e),t.appendChild(this.__currentElement),this.__defs.appendChild(t),this._clip_path="url(#"+e+")"},t.prototype.drawImage=function(e){for(var r,i,n,s,o,l,h,_,p,u,c,d,f,m,g,v=[],y=1;y<arguments.length;y++)v[y-1]=arguments[y];if(2==v.length){if(_=(r=a.__read(v,2))[0],p=r[1],!isFinite(_+p))return;d=0,f=0,u=m=e.width,c=g=e.height}else if(4==v.length){if(_=(i=a.__read(v,4))[0],p=i[1],u=i[2],c=i[3],!isFinite(_+p+u+c))return;d=0,f=0,m=e.width,g=e.height}else{if(8!==v.length)throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length);if(d=(n=a.__read(v,8))[0],f=n[1],m=n[2],g=n[3],_=n[4],p=n[5],u=n[6],c=n[7],!isFinite(d+f+m+g+_+p+u+c))return}var b=this.__root,w="translate("+_+", "+p+")",x=this._transform.clone().translate(_,p);if(e instanceof t||e instanceof SVGSVGElement){var A=e instanceof SVGSVGElement?e:e.get_svg(),E=A.cloneNode(!0),k=void 0;x.is_identity?k=b:(k=this.__createElement("g"),this._apply_transform(k,x),b.appendChild(k));try{for(var C=a.__values(a.__spread(E.childNodes)),S=C.next();!S.done;S=C.next()){var P=S.value;if(P instanceof SVGDefsElement)try{for(var T=(l=void 0,a.__values(a.__spread(P.childNodes))),j=T.next();!j.done;j=T.next()){var F=j.value;if(F instanceof Element){var M=F.getAttribute("id");this.__ids[M]=M,this.__defs.appendChild(F)}}}catch(t){l={error:t}}finally{try{j&&!j.done&&(h=T.return)&&h.call(T)}finally{if(l)throw l.error}}else k.appendChild(P)}}catch(t){s={error:t}}finally{try{S&&!S.done&&(o=C.return)&&o.call(C)}finally{if(s)throw s.error}}}else if(e instanceof HTMLImageElement||e instanceof SVGImageElement){if((D=this.__createElement("image")).setAttribute("width",""+u),D.setAttribute("height",""+c),D.setAttribute("preserveAspectRatio","none"),d||f||m!==e.width||g!==e.height)(O=this.__document.createElement("canvas")).width=u,O.height=c,(q=O.getContext("2d")).drawImage(e,d,f,m,g,0,0,u,c),e=O;D.setAttribute("transform",w);var N=e instanceof HTMLCanvasElement?e.toDataURL():e.getAttribute("src");D.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",N),b.appendChild(D)}else if(e instanceof HTMLCanvasElement){var D,O,q;(D=this.__createElement("image")).setAttribute("width",""+u),D.setAttribute("height",""+c),D.setAttribute("preserveAspectRatio","none"),(O=this.__document.createElement("canvas")).width=u,O.height=c,(q=O.getContext("2d")).imageSmoothingEnabled=!1,q.drawImage(e,d,f,m,g,0,0,u,c),e=O,D.setAttribute("transform",w),D.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",e.toDataURL()),b.appendChild(D)}},t.prototype.createPattern=function(e,r){var i,n,s,o,l=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),_=h(this.__ids);if(l.setAttribute("id",_),l.setAttribute("width",""+this._to_number(e.width)),l.setAttribute("height",""+this._to_number(e.height)),l.setAttribute("patternUnits","userSpaceOnUse"),e instanceof HTMLCanvasElement||e instanceof HTMLImageElement||e instanceof SVGImageElement){var p=this.__document.createElementNS("http://www.w3.org/2000/svg","image"),u=e instanceof HTMLCanvasElement?e.toDataURL():e.getAttribute("src");p.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",u),l.appendChild(p),this.__defs.appendChild(l)}else if(e instanceof t){try{for(var c=a.__values(a.__spread(e.__root.childNodes)),f=c.next();!f.done;f=c.next()){(v=f.value)instanceof SVGDefsElement||l.appendChild(v)}}catch(t){i={error:t}}finally{try{f&&!f.done&&(n=c.return)&&n.call(c)}finally{if(i)throw i.error}}this.__defs.appendChild(l)}else{if(!(e instanceof SVGSVGElement))throw new Error("unsupported");try{for(var m=a.__values(a.__spread(e.childNodes)),g=m.next();!g.done;g=m.next()){var v;(v=g.value)instanceof SVGDefsElement||l.appendChild(v)}}catch(t){s={error:t}}finally{try{g&&!g.done&&(o=m.return)&&o.call(m)}finally{if(s)throw s.error}}this.__defs.appendChild(l)}return new d(l,this)},t.prototype.setLineDash=function(t){t&&t.length>0?this.lineDash=t.join(","):this.lineDash=null},t.prototype._to_number=function(t){return o.isNumber(t)?t:t.baseVal.value},t}();r.SVGRenderingContext2D=f,f.__name__="SVGRenderingContext2D"},
function _(t,r,n,o,e){o();var i=Math.sin,a=Math.cos,s=function(){function t(t,r,n,o,e,i){void 0===t&&(t=1),void 0===r&&(r=0),void 0===n&&(n=0),void 0===o&&(o=1),void 0===e&&(e=0),void 0===i&&(i=0),this.a=t,this.b=r,this.c=n,this.d=o,this.e=e,this.f=i}return t.prototype.toString=function(){var t=this;return"matrix("+t.a+", "+t.b+", "+t.c+", "+t.d+", "+t.e+", "+t.f+")"},t.prototype.clone=function(){var r=this;return new t(r.a,r.b,r.c,r.d,r.e,r.f)},Object.defineProperty(t.prototype,"is_identity",{get:function(){var t=this,r=t.a,n=t.b,o=t.c,e=t.d,i=t.e,a=t.f;return 1==r&&0==n&&0==o&&1==e&&0==i&&0==a},enumerable:!1,configurable:!0}),t.prototype.apply=function(t,r){var n=this,o=n.a,e=n.b,i=n.c,a=n.d;return[o*t+i*r+n.e,e*t+a*r+n.f]},t.prototype.iv_apply=function(t,r){for(var n=this,o=n.a,e=n.b,i=n.c,a=n.d,s=n.e,f=n.f,p=t.length,c=0;c<p;c++){var u=t[c],h=r[c];t[c]=o*u+i*h+s,r[c]=e*u+a*h+f}},t.prototype.transform=function(t,r,n,o,e,i){var a=this,s=a.a,f=a.b,p=a.c,c=a.d,u=a.e,h=a.f;return this.a=s*t+p*r,this.c=s*n+p*o,this.e=s*e+p*i+u,this.b=f*t+c*r,this.d=f*n+c*o,this.f=f*e+c*i+h,this},t.prototype.translate=function(t,r){return this.transform(1,0,0,1,t,r)},t.prototype.scale=function(t,r){return this.transform(t,0,0,r,0,0)},t.prototype.skew=function(t,r){return this.transform(1,r,t,1,0,0)},t.prototype.rotate=function(t){var r=i(t),n=a(t);return this.transform(n,r,-r,n,0,0)},t.prototype.rotate_ccw=function(t){return this.rotate(-t)},t.prototype.translate_x=function(t){return this.translate(t,0)},t.prototype.translate_y=function(t){return this.translate(0,t)},t.prototype.flip=function(){return this.scale(-1,-1)},t.prototype.flip_x=function(){return this.scale(1,-1)},t.prototype.flip_y=function(){return this.scale(-1,1)},t}();n.AffineTransform=s,s.__name__="AffineTransform"},
function _(e,t,i,n,a){n();var r,o,s=e(1),l=e(129),h=e(193),p=e(134),c=e(187),_=e(135),u=e(128),v=e(194),d=e(195),b=e(190),g=(r=document.createElement("canvas"),null!=(o=r.getContext("webgl",{premultipliedAlpha:!0}))?{canvas:r,gl:o}:void p.logger.trace("WebGL is not supported")),y={position:"absolute",top:"0",left:"0",width:"100%",height:"100%"},f=function(){function e(e,t){switch(this.backend=e,this.hidpi=t,this.pixel_ratio=1,this.bbox=new v.BBox,e){case"webgl":case"canvas":if(this._el=this._canvas=c.canvas({style:y}),null==(i=this.canvas.getContext("2d")))throw new Error("unable to obtain 2D rendering context");this._ctx=i,t&&(this.pixel_ratio=devicePixelRatio);break;case"svg":var i=new b.SVGRenderingContext2D;this._ctx=i,this._canvas=i.get_svg(),this._el=c.div({style:y},this._canvas)}d.fixup_ctx(this._ctx)}return Object.defineProperty(e.prototype,"canvas",{get:function(){return this._canvas},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"ctx",{get:function(){return this._ctx},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"el",{get:function(){return this._el},enumerable:!1,configurable:!0}),e.prototype.resize=function(e,t){this.bbox=new v.BBox({left:0,top:0,width:e,height:t});var i=this._ctx instanceof b.SVGRenderingContext2D?this._ctx:this.canvas;i.width=e*this.pixel_ratio,i.height=t*this.pixel_ratio},e.prototype.prepare=function(){var e=this,t=e.ctx,i=e.hidpi,n=e.pixel_ratio;t.save(),i&&(t.scale(n,n),t.translate(.5,.5)),this.clear()},e.prototype.clear=function(){var e=this.bbox,t=e.x,i=e.y,n=e.width,a=e.height;this.ctx.clearRect(t,i,n,a)},e.prototype.finish=function(){this.ctx.restore()},e.prototype.to_blob=function(){var e=this._canvas;if(e instanceof HTMLCanvasElement)return null!=e.msToBlob?Promise.resolve(e.msToBlob()):new Promise((function(t,i){e.toBlob((function(e){return null!=e?t(e):i()}),"image/png")}));var t=this._ctx.get_serialized_svg(!0),i=new Blob([t],{type:"image/svg+xml"});return Promise.resolve(i)},e}();i.CanvasLayer=f,f.__name__="CanvasLayer";var x=function(e){function t(){var t=e.apply(this,s.__spread(arguments))||this;return t.bbox=new v.BBox,t}return s.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this);var t=this.model,i=t.output_backend,n=t.hidpi;"webgl"==i&&(this.webgl=g),this.underlays_el=c.div({style:y}),this.primary=new f(i,n),this.overlays=new f(i,n),this.overlays_el=c.div({style:y}),this.events_el=c.div({class:"bk-canvas-events",style:y});var a=[this.underlays_el,this.primary.el,this.overlays.el,this.overlays_el,this.events_el];u.extend(this.el.style,y),c.append.apply(void 0,s.__spread([this.el],a)),p.logger.debug("CanvasView initialized")},t.prototype.add_underlay=function(e){this.underlays_el.appendChild(e)},t.prototype.add_overlay=function(e){this.overlays_el.appendChild(e)},t.prototype.add_event=function(e){this.events_el.appendChild(e)},Object.defineProperty(t.prototype,"pixel_ratio",{get:function(){return this.primary.pixel_ratio},enumerable:!1,configurable:!0}),t.prototype.resize=function(e,t){this.bbox=new v.BBox({left:0,top:0,width:e,height:t}),this.primary.resize(e,t),this.overlays.resize(e,t)},t.prototype.prepare_webgl=function(e){var t=this.webgl;if(null!=t){var i=this.bbox,n=i.width,a=i.height;t.canvas.width=this.pixel_ratio*n,t.canvas.height=this.pixel_ratio*a;var r=t.gl;r.enable(r.SCISSOR_TEST);var o=s.__read(e,4),l=o[0],h=o[1],p=o[2],c=o[3],_=this.bbox,u=_.xview,v=_.yview,d=u.compute(l),b=v.compute(h+c),g=this.pixel_ratio;r.scissor(g*d,g*b,g*p,g*c),r.enable(r.BLEND),r.blendFuncSeparate(r.SRC_ALPHA,r.ONE_MINUS_SRC_ALPHA,r.ONE_MINUS_DST_ALPHA,r.ONE)}},t.prototype.clear_webgl=function(){var e=this.webgl;if(null!=e){var t=e.gl,i=e.canvas;t.viewport(0,0,i.width,i.height),t.clearColor(0,0,0,0),t.clear(t.COLOR_BUFFER_BIT|t.DEPTH_BUFFER_BIT)}},t.prototype.blit_webgl=function(e){var t=this.webgl;if(null!=t&&(p.logger.debug("Blitting WebGL canvas"),e.restore(),e.drawImage(t.canvas,0,0),e.save(),this.model.hidpi)){var i=this.pixel_ratio;e.scale(i,i),e.translate(.5,.5)}},t.prototype.compose=function(){var e=this.model,t=e.output_backend,i=e.hidpi,n=this.bbox,a=n.width,r=n.height,o=new f(t,i);return o.resize(a,r),o.ctx.drawImage(this.primary.canvas,0,0),o.ctx.drawImage(this.overlays.canvas,0,0),o},t.prototype.to_blob=function(){return this.compose().to_blob()},t}(h.DOMView);i.CanvasView=x,x.__name__="CanvasView";var w=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_Canvas=function(){this.prototype.default_view=x,this.internal((function(e){return{hidpi:[e.Boolean,!0],output_backend:[_.OutputBackend,"canvas"]}}))},t}(l.HasProps);i.Canvas=w,w.__name__="Canvas",w.init_Canvas()},
function _(e,t,n,i,o){i();var r=e(1),s=e(186),p=e(187),c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.el=this._createElement()},t.prototype.remove=function(){p.remove(this.el),e.prototype.remove.call(this)},t.prototype.css_classes=function(){return[]},t.prototype.render=function(){},t.prototype.renderTo=function(e){e.appendChild(this.el),this.render()},t.prototype._createElement=function(){return p.createElement(this.tagName,{class:this.css_classes()})},t}(s.View);n.DOMView=c,c.__name__="DOMView",c.prototype.tagName="div"},
function _(t,e,i,r,n){r();var o=t(139),h=Math.min,u=Math.max;i.empty=function(){return{x0:1/0,y0:1/0,x1:-1/0,y1:-1/0}},i.positive_x=function(){return{x0:Number.MIN_VALUE,y0:-1/0,x1:1/0,y1:1/0}},i.positive_y=function(){return{x0:-1/0,y0:Number.MIN_VALUE,x1:1/0,y1:1/0}},i.union=function(t,e){return{x0:h(t.x0,e.x0),x1:u(t.x1,e.x1),y0:h(t.y0,e.y0),y1:u(t.y1,e.y1)}};var y=function(){function t(t){if(null==t)this.x0=0,this.y0=0,this.x1=0,this.y1=0;else if("x0"in t){var e=t.x0,i=t.y0,r=t.x1,n=t.y1;if(!(e<=r&&i<=n))throw new Error("invalid bbox {x0: "+e+", y0: "+i+", x1: "+r+", y1: "+n+"}");this.x0=e,this.y0=i,this.x1=r,this.y1=n}else if("x"in t){var o=t.x,h=t.y,u=t.width,y=t.height;if(!(u>=0&&y>=0))throw new Error("invalid bbox {x: "+o+", y: "+h+", width: "+u+", height: "+y+"}");this.x0=o,this.y0=h,this.x1=o+u,this.y1=h+y}else{var f=void 0,s=void 0,c=void 0,p=void 0;if("width"in t)if("left"in t)s=(f=t.left)+t.width;else if("right"in t)f=(s=t.right)-t.width;else{var b=t.width/2;f=t.hcenter-b,s=t.hcenter+b}else f=t.left,s=t.right;if("height"in t)if("top"in t)p=(c=t.top)+t.height;else if("bottom"in t)c=(p=t.bottom)-t.height;else{var a=t.height/2;c=t.vcenter-a,p=t.vcenter+a}else c=t.top,p=t.bottom;if(!(f<=s&&c<=p))throw new Error("invalid bbox {left: "+f+", top: "+c+", right: "+s+", bottom: "+p+"}");this.x0=f,this.y0=c,this.x1=s,this.y1=p}}return t.prototype.toString=function(){return"BBox({left: "+this.left+", top: "+this.top+", width: "+this.width+", height: "+this.height+"})"},Object.defineProperty(t.prototype,"left",{get:function(){return this.x0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"top",{get:function(){return this.y0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"right",{get:function(){return this.x1},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"bottom",{get:function(){return this.y1},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"p0",{get:function(){return[this.x0,this.y0]},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"p1",{get:function(){return[this.x1,this.y1]},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"x",{get:function(){return this.x0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"y",{get:function(){return this.y0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"width",{get:function(){return this.x1-this.x0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"height",{get:function(){return this.y1-this.y0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"rect",{get:function(){return{x0:this.x0,y0:this.y0,x1:this.x1,y1:this.y1}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"box",{get:function(){return{x:this.x,y:this.y,width:this.width,height:this.height}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"h_range",{get:function(){return{start:this.x0,end:this.x1}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"v_range",{get:function(){return{start:this.y0,end:this.y1}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"ranges",{get:function(){return[this.h_range,this.v_range]},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"aspect",{get:function(){return this.width/this.height},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"hcenter",{get:function(){return(this.left+this.right)/2},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"vcenter",{get:function(){return(this.top+this.bottom)/2},enumerable:!1,configurable:!0}),t.prototype.relativize=function(){return new t({x:0,y:0,width:this.width,height:this.height})},t.prototype.contains=function(t,e){return t>=this.x0&&t<=this.x1&&e>=this.y0&&e<=this.y1},t.prototype.clip=function(t,e){return t<this.x0?t=this.x0:t>this.x1&&(t=this.x1),e<this.y0?e=this.y0:e>this.y1&&(e=this.y1),[t,e]},t.prototype.union=function(e){return new t({x0:h(this.x0,e.x0),y0:h(this.y0,e.y0),x1:u(this.x1,e.x1),y1:u(this.y1,e.y1)})},t.prototype.equals=function(t){return this.x0==t.x0&&this.y0==t.y0&&this.x1==t.x1&&this.y1==t.y1},Object.defineProperty(t.prototype,"xview",{get:function(){var t=this;return{compute:function(e){return t.left+e},v_compute:function(e){for(var i=new o.NumberArray(e.length),r=t.left,n=0;n<e.length;n++)i[n]=r+e[n];return i}}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"yview",{get:function(){var t=this;return{compute:function(e){return t.bottom-e},v_compute:function(e){for(var i=new o.NumberArray(e.length),r=t.bottom,n=0;n<e.length;n++)i[n]=r-e[n];return i}}},enumerable:!1,configurable:!0}),t}();i.BBox=y,y.__name__="BBox"},
function _(e,t,n,o,a){o(),n.fixup_ctx=function(e){!function(e){void 0===e.lineDash&&Object.defineProperty(e,"lineDash",{get:function(){return e.getLineDash()},set:function(t){return e.setLineDash(t)}})}(e),function(e){e.setImageSmoothingEnabled=function(t){e.imageSmoothingEnabled=t,e.mozImageSmoothingEnabled=t,e.oImageSmoothingEnabled=t,e.webkitImageSmoothingEnabled=t,e.msImageSmoothingEnabled=t},e.getImageSmoothingEnabled=function(){var t=e.imageSmoothingEnabled;return null==t||t}}(e),function(e){e.measureText&&null==e.html5MeasureText&&(e.html5MeasureText=e.measureText,e.measureText=function(t){var n=e.html5MeasureText(t);return n.ascent=1.6*e.html5MeasureText("m").width,n})}(e),function(e){e.ellipse||(e.ellipse=function(t,n,o,a,i,r,u,m){void 0===m&&(m=!1);var l=.551784;e.translate(t,n),e.rotate(i);var s=o,g=a;m&&(s=-o,g=-a),e.moveTo(-s,0),e.bezierCurveTo(-s,g*l,-s*l,g,0,g),e.bezierCurveTo(s*l,g,s,g*l,s,0),e.bezierCurveTo(s,-g*l,s*l,-g,0,-g),e.bezierCurveTo(-s*l,-g,-s,-g*l,-s,0),e.rotate(-i),e.translate(-t,-n)})}(e)}},
function _(e,t,n,r,a){r();var o=e(1),c=e(129),i=e(123),s=e(128),l=e(134),_=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_Model=function(){this.define((function(e){var t=e.Any,n=e.Unknown,r=e.String,a=e.Array,o=e.Dict,c=e.Nullable;return{tags:[a(n),[]],name:[c(r),null],js_property_callbacks:[o(a(t)),{}],js_event_callbacks:[o(a(t)),{}],subscribed_events:[a(r),[]]}}))},t.prototype.initialize=function(){e.prototype.initialize.call(this),this._js_callbacks=new Map},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this._update_property_callbacks(),this.connect(this.properties.js_property_callbacks.change,(function(){return t._update_property_callbacks()})),this.connect(this.properties.js_event_callbacks.change,(function(){return t._update_event_callbacks()})),this.connect(this.properties.subscribed_events.change,(function(){return t._update_event_callbacks()}))},t.prototype._process_event=function(e){var t,n,r;try{for(var a=o.__values(null!==(r=this.js_event_callbacks[e.event_name])&&void 0!==r?r:[]),c=a.next();!c.done;c=a.next()){c.value.execute(e)}}catch(e){t={error:e}}finally{try{c&&!c.done&&(n=a.return)&&n.call(a)}finally{if(t)throw t.error}}null!=this.document&&this.subscribed_events.some((function(t){return t==e.event_name}))&&this.document.event_manager.send_event(e)},t.prototype.trigger_event=function(e){null!=this.document&&(e.origin=this,this.document.event_manager.trigger(e))},t.prototype._update_event_callbacks=function(){null!=this.document?this.document.event_manager.subscribed_models.add(this):l.logger.warn("WARNING: Document not defined for updating event callbacks")},t.prototype._update_property_callbacks=function(){var e,t,n,r,a,c,i,l,_=this,u=function(e){var t=o.__read(e.split(":"),2),n=t[0],r=t[1],a=void 0===r?null:r;return null!=a?_.properties[a][n]:_[n]};try{for(var d=o.__values(this._js_callbacks),p=d.next();!p.done;p=d.next()){var h=o.__read(p.value,2),f=h[0],v=h[1],y=u(f);try{for(var b=(n=void 0,o.__values(v)),g=b.next();!g.done;g=b.next()){var m=g.value;this.disconnect(y,m)}}catch(e){n={error:e}}finally{try{g&&!g.done&&(r=b.return)&&r.call(b)}finally{if(n)throw n.error}}}}catch(t){e={error:t}}finally{try{p&&!p.done&&(t=d.return)&&t.call(d)}finally{if(e)throw e.error}}this._js_callbacks.clear();try{for(var k=o.__values(s.entries(this.js_property_callbacks)),w=k.next();!w.done;w=k.next()){var x=o.__read(w.value,2),j=(f=x[0],(v=x[1]).map((function(e){return function(){return e.execute(_)}})));this._js_callbacks.set(f,j);y=u(f);try{for(var M=(i=void 0,o.__values(j)),A=M.next();!A.done;A=M.next()){m=A.value;this.connect(y,m)}}catch(e){i={error:e}}finally{try{A&&!A.done&&(l=M.return)&&l.call(M)}finally{if(i)throw i.error}}}}catch(e){a={error:e}}finally{try{w&&!w.done&&(c=k.return)&&c.call(k)}finally{if(a)throw a.error}}},t.prototype._doc_attached=function(){s.isEmpty(this.js_event_callbacks)&&0==this.subscribed_events.length||this._update_event_callbacks()},t.prototype._doc_detached=function(){this.document.event_manager.subscribed_models.delete(this)},t.prototype.select=function(e){if(i.isString(e))return o.__spread(this.references()).filter((function(n){return n instanceof t&&n.name===e}));if(e.prototype instanceof c.HasProps)return o.__spread(this.references()).filter((function(t){return t instanceof e}));throw new Error("invalid selector")},t.prototype.select_one=function(e){var t=this.select(e);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error("found more than one object matching given selector")}},t}(c.HasProps);n.Model=_,_.__name__="Model",_.init_Model()},
function _(e,s,t,n,r){n();var _=function(){function e(e,s){this.x_scale=e,this.y_scale=s,this.x_range=this.x_scale.source_range,this.y_range=this.y_scale.source_range,this.ranges=[this.x_range,this.y_range],this.scales=[this.x_scale,this.y_scale]}return e.prototype.map_to_screen=function(e,s){return[this.x_scale.v_compute(e),this.y_scale.v_compute(s)]},e.prototype.map_from_screen=function(e,s){return[this.x_scale.v_invert(e),this.y_scale.v_invert(s)]},e}();t.CoordinateTransform=_,_.__name__="CoordinateTransform"},
function _(t,e,i,r,o){r();var n=t(1),a=t(151),s=t(199),_=t(200),c=t(237),d=t(143),h=t(135),l=n.__importStar(t(133)),u=t(125),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.set_data(this.model.source)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return e.set_data(e.model.source)})),this.connect(this.model.source.streaming,(function(){return e.set_data(e.model.source)})),this.connect(this.model.source.patching,(function(){return e.set_data(e.model.source)})),this.connect(this.model.source.change,(function(){return e.set_data(e.model.source)}))},e.prototype.set_data=function(e){t.prototype.set_data.call(this,e),this.visuals.warm_cache(e),this.plot_view.request_render()},e.prototype._map_data=function(){var t,e,i,r,o=this.plot_view.frame;return"data"==this.model.start_units?(t=this.coordinates.x_scale.v_compute(this._x_start),e=this.coordinates.y_scale.v_compute(this._y_start)):(t=o.xview.v_compute(this._x_start),e=o.yview.v_compute(this._y_start)),"data"==this.model.end_units?(i=this.coordinates.x_scale.v_compute(this._x_end),r=this.coordinates.y_scale.v_compute(this._y_end)):(i=o.xview.v_compute(this._x_end),r=o.yview.v_compute(this._y_end)),[[t,e],[i,r]]},e.prototype._render=function(){var t=this.layer.ctx;t.save();var e=n.__read(this._map_data(),2),i=e[0],r=e[1];null!=this.model.end&&this._arrow_head(t,"render",this.model.end,i,r),null!=this.model.start&&this._arrow_head(t,"render",this.model.start,r,i),t.beginPath();var o=this.plot_view.frame.bbox,a=o.x,s=o.y,_=o.width,c=o.height;t.rect(a,s,_,c),null!=this.model.end&&this._arrow_head(t,"clip",this.model.end,i,r),null!=this.model.start&&this._arrow_head(t,"clip",this.model.start,r,i),t.closePath(),t.clip(),this._arrow_body(t,i,r),t.restore()},e.prototype._arrow_head=function(t,e,i,r,o){for(var n=0,a=this._x_start.length;n<a;n++){var s=Math.PI/2+u.atan2([r[0][n],r[1][n]],[o[0][n],o[1][n]]);t.save(),t.translate(o[0][n],o[1][n]),t.rotate(s),"render"==e?i.render(t,n):"clip"==e&&i.clip(t,n),t.restore()}},e.prototype._arrow_body=function(t,e,i){if(this.visuals.line.doit)for(var r=0,o=this._x_start.length;r<o;r++)this.visuals.line.set_vectorize(t,r),t.beginPath(),t.moveTo(e[0][r],e[1][r]),t.lineTo(i[0][r],i[1][r]),t.stroke()},e}(a.AnnotationView);i.ArrowView=p,p.__name__="ArrowView";var m=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Arrow=function(){this.prototype.default_view=p,this.mixins(d.LineVector),this.define((function(t){var e=t.Ref,i=t.Nullable;return{x_start:[l.XCoordinateSpec],y_start:[l.YCoordinateSpec],start_units:[h.SpatialUnits,"data"],start:[i(e(s.ArrowHead)),null],x_end:[l.XCoordinateSpec],y_end:[l.YCoordinateSpec],end_units:[h.SpatialUnits,"data"],end:[i(e(s.ArrowHead)),function(){return new s.OpenHead}],source:[e(_.ColumnarDataSource),function(){return new c.ColumnDataSource}]}}))},e}(a.Annotation);i.Arrow=m,m.__name__="Arrow",m.init_Arrow()},
function _(i,e,t,s,n){s();var o=i(1),l=i(151),r=i(189),h=i(143),a=function(i){function e(e){return i.call(this,e)||this}return o.__extends(e,i),e.init_ArrowHead=function(){this.define((function(i){return{size:[i.Number,25]}}))},e.prototype.initialize=function(){i.prototype.initialize.call(this),this.visuals=new r.Visuals(this)},e}(l.Annotation);t.ArrowHead=a,a.__name__="ArrowHead",a.init_ArrowHead();var c=function(i){function e(e){return i.call(this,e)||this}return o.__extends(e,i),e.init_OpenHead=function(){this.mixins(h.LineVector)},e.prototype.clip=function(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(0,0),i.lineTo(.5*this.size,this.size)},e.prototype.render=function(i,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.stroke())},e}(a);t.OpenHead=c,c.__name__="OpenHead",c.init_OpenHead();var _=function(i){function e(e){return i.call(this,e)||this}return o.__extends(e,i),e.init_NormalHead=function(){this.mixins([h.LineVector,h.FillVector]),this.override({fill_color:"black"})},e.prototype.clip=function(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(.5*this.size,this.size)},e.prototype.render=function(i,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(i,e),this._normal(i,e),i.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),this._normal(i,e),i.stroke())},e.prototype._normal=function(i,e){i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.closePath()},e}(a);t.NormalHead=_,_.__name__="NormalHead",_.init_NormalHead();var u=function(i){function e(e){return i.call(this,e)||this}return o.__extends(e,i),e.init_VeeHead=function(){this.mixins([h.LineVector,h.FillVector]),this.override({fill_color:"black"})},e.prototype.clip=function(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(0,.5*this.size),i.lineTo(.5*this.size,this.size)},e.prototype.render=function(i,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(i,e),this._vee(i,e),i.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),this._vee(i,e),i.stroke())},e.prototype._vee=function(i,e){i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.lineTo(0,.5*this.size),i.closePath()},e}(a);t.VeeHead=u,u.__name__="VeeHead",u.init_VeeHead();var z=function(i){function e(e){return i.call(this,e)||this}return o.__extends(e,i),e.init_TeeHead=function(){this.mixins(h.LineVector)},e.prototype.render=function(i,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),i.beginPath(),i.moveTo(.5*this.size,0),i.lineTo(-.5*this.size,0),i.stroke())},e.prototype.clip=function(i,e){},e}(a);t.TeeHead=z,z.__name__="TeeHead",z.init_TeeHead()},
function _(t,n,e,r,i){r();var a=t(1),o=t(201),u=t(130),l=t(134),c=t(209),s=t(123),h=t(124),f=t(128),g=t(202),p=t(236),d=function(t){function n(n){return t.call(this,n)||this}return a.__extends(n,t),n.prototype.get_array=function(t){var n=this.data[t];return null==n?this.data[t]=n=[]:s.isArray(n)||(this.data[t]=n=Array.from(n)),n},n.init_ColumnarDataSource=function(){this.define((function(t){return{selection_policy:[(0,t.Ref)(p.SelectionPolicy),function(){return new p.UnionRenderers}]}})),this.internal((function(t){var n=t.Ref;return{selection_manager:[n(c.SelectionManager),function(t){return new c.SelectionManager({source:t})}],inspected:[n(g.Selection),function(){return new g.Selection}]}}))},n.prototype.initialize=function(){t.prototype.initialize.call(this),this._select=new u.Signal0(this,"select"),this.inspect=new u.Signal(this,"inspect"),this.streaming=new u.Signal0(this,"streaming"),this.patching=new u.Signal(this,"patching")},n.prototype.get_column=function(t){var n=this.data[t];return null!=n?n:null},n.prototype.columns=function(){return f.keys(this.data)},n.prototype.get_length=function(t){void 0===t&&(t=!0);var n=h.uniq(f.values(this.data).map((function(t){return t.length})));switch(n.length){case 0:return null;case 1:return n[0];default:var e="data source has columns of inconsistent lengths";if(t)return l.logger.warn(e),n.sort()[0];throw new Error(e)}},Object.defineProperty(n.prototype,"length",{get:function(){var t;return null!==(t=this.get_length())&&void 0!==t?t:0},enumerable:!1,configurable:!0}),n.prototype.clear=function(){var t,n,e={};try{for(var r=a.__values(this.columns()),i=r.next();!i.done;i=r.next()){var o=i.value;e[o]=new this.data[o].constructor(0)}}catch(n){t={error:n}}finally{try{i&&!i.done&&(n=r.return)&&n.call(r)}finally{if(t)throw t.error}}this.data=e},n}(o.DataSource);e.ColumnarDataSource=d,d.__name__="ColumnarDataSource",d.init_ColumnarDataSource()},
function _(n,e,t,i,c){i();var u=n(1),o=n(196),r=n(202),a=function(n){function e(e){return n.call(this,e)||this}return u.__extends(e,n),e.init_DataSource=function(){this.define((function(n){return{selected:[(0,n.Ref)(r.Selection),function(){return new r.Selection}]}}))},e}(o.Model);t.DataSource=a,a.__name__="DataSource",a.init_DataSource()},
function _(i,e,t,n,s){n();var l=i(1),c=i(196),h=i(124),d=i(128),_=i(203),u=function(i){function e(e){return i.call(this,e)||this}return l.__extends(e,i),e.prototype.get_view=function(){return this.view},e.init_Selection=function(){this.define((function(i){var e=i.Int,t=i.Array,n=i.Dict;return{indices:[t(e),[]],line_indices:[t(e),[]],multiline_indices:[n(t(e)),{}]}})),this.internal((function(i){var e=i.Int,t=i.Array,n=i.Ref,s=i.Struct,l=i.Nullable;return{selected_glyphs:[t(n(_.Glyph)),[]],view:[l(n(_.GlyphView)),null],image_indices:[t(s({index:e,dim1:e,dim2:e,flat_index:e})),[]]}}))},Object.defineProperty(e.prototype,"selected_glyph",{get:function(){return this.selected_glyphs.length>0?this.selected_glyphs[0]:null},enumerable:!1,configurable:!0}),e.prototype.add_to_selected_glyphs=function(i){this.selected_glyphs.push(i)},e.prototype.update=function(i,e,t){switch(void 0===e&&(e=!0),void 0===t&&(t="replace"),t){case"replace":this.indices=i.indices,this.line_indices=i.line_indices,this.selected_glyphs=i.selected_glyphs,this.view=i.view,this.multiline_indices=i.multiline_indices,this.image_indices=i.image_indices;break;case"append":this.update_through_union(i);break;case"intersect":this.update_through_intersection(i);break;case"subtract":this.update_through_subtraction(i)}},e.prototype.clear=function(){this.indices=[],this.line_indices=[],this.multiline_indices={},this.view=null,this.selected_glyphs=[]},e.prototype.is_empty=function(){return 0==this.indices.length&&0==this.line_indices.length&&0==this.image_indices.length},e.prototype.update_through_union=function(i){this.indices=h.union(this.indices,i.indices),this.selected_glyphs=h.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=h.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=d.merge(i.multiline_indices,this.multiline_indices)},e.prototype.update_through_intersection=function(i){this.indices=h.intersection(this.indices,i.indices),this.selected_glyphs=h.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=h.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=d.merge(i.multiline_indices,this.multiline_indices)},e.prototype.update_through_subtraction=function(i){this.indices=h.difference(this.indices,i.indices),this.selected_glyphs=h.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=h.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=d.merge(i.multiline_indices,this.multiline_indices)},e}(c.Model);t.Selection=u,u.__name__="Selection",u.init_Selection()},
function _(t,e,n,r,i){r();var a=t(1),o=a.__importStar(t(133)),s=a.__importStar(t(194)),_=a.__importStar(t(189)),l=t(186),d=t(196),h=t(134),p=t(139),c=t(127),u=t(204),y=t(207),f=t(202),g=function(t){function e(){var e=t.apply(this,a.__spread(arguments))||this;return e._index=null,e._data_size=null,e._nohit_warned=new Set,e}return a.__extends(e,t),Object.defineProperty(e.prototype,"renderer",{get:function(){return this.parent},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"has_webgl",{get:function(){return null!=this.glglyph},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"index",{get:function(){var t=this._index;if(null!=t)return t;throw new Error(this+".index_data() wasn't called")},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"data_size",{get:function(){var t=this._data_size;if(null!=t)return t;throw new Error(this+".set_data() wasn't called")},enumerable:!1,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.visuals=new _.Visuals(this.model)},e.prototype.set_visuals=function(t,e){this.visuals.warm_cache(t,e),null!=this.glglyph&&this.glglyph.set_visuals_changed()},e.prototype.render=function(t,e,n){t.beginPath(),null!=this.glglyph&&(this.renderer.needs_webgl_blit=this.glglyph.render(t,e,n),this.renderer.needs_webgl_blit)||this._render(t,e,n)},e.prototype.has_finished=function(){return!0},e.prototype.notify_finished=function(){this.renderer.notify_finished()},e.prototype._bounds=function(t){return t},e.prototype.bounds=function(){return this._bounds(this.index.bbox)},e.prototype.log_bounds=function(){var t=this.index.bounds(s.positive_x()),e=t.x0,n=t.x1,r=this.index.bounds(s.positive_y()),i=r.y0,a=r.y1;return this._bounds({x0:e,y0:i,x1:n,y1:a})},e.prototype.get_anchor_point=function(t,e,n){var r=a.__read(n,2),i=r[0],o=r[1];switch(t){case"center":var s=a.__read(this.scenterxy(e,i,o),2);return{x:s[0],y:s[1]};default:return null}},e.prototype.scenterx=function(t,e,n){return this.scenterxy(t,e,n)[0]},e.prototype.scentery=function(t,e,n){return this.scenterxy(t,e,n)[1]},e.prototype.sdist=function(t,e,n,r,i){var a,o;void 0===r&&(r="edge"),void 0===i&&(i=!1);var s=e.length;if("center"==r){var _=c.map(n,(function(t){return t/2}));a=new Float64Array(s);for(var l=0;l<s;l++)a[l]=e[l]-_[l];o=new Float64Array(s);for(l=0;l<s;l++)o[l]=e[l]+_[l]}else{a=e,o=new Float64Array(s);for(l=0;l<s;l++)o[l]=a[l]+n[l]}var d=t.v_compute(a),h=t.v_compute(o);return i?c.map(d,(function(t,e){return Math.ceil(Math.abs(h[e]-d[e]))})):c.map(d,(function(t,e){return Math.abs(h[e]-d[e])}))},e.prototype.draw_legend_for_index=function(t,e,n){},e.prototype.hit_test=function(t){switch(t.type){case"point":if(null!=this._hit_point)return this._hit_point(t);break;case"span":if(null!=this._hit_span)return this._hit_span(t);break;case"rect":if(null!=this._hit_rect)return this._hit_rect(t);break;case"poly":if(null!=this._hit_poly)return this._hit_poly(t)}return this._nohit_warned.has(t.type)||(h.logger.debug("'"+t.type+"' selection not available for "+this.model.type),this._nohit_warned.add(t.type)),null},e.prototype._hit_rect_against_index=function(t){var e=t.sx0,n=t.sx1,r=t.sy0,i=t.sy1,o=a.__read(this.renderer.coordinates.x_scale.r_invert(e,n),2),s=o[0],_=o[1],l=a.__read(this.renderer.coordinates.y_scale.r_invert(r,i),2),d=l[0],h=l[1],p=a.__spread(this.index.indices({x0:s,x1:_,y0:d,y1:h}));return new f.Selection({indices:p})},e.prototype._project_data=function(){},e.prototype.set_data=function(t,e,n){var r,i,s,_,l=this.renderer.coordinates,d=l.x_range,h=l.y_range;this._data_size=null!==(s=t.get_length())&&void 0!==s?s:1;try{for(var u=a.__values(this.model),f=u.next();!f.done;f=u.next()){var g=f.value;if(g instanceof o.VectorSpec&&(!g.optional||null!=g.spec.value||g.dirty)){var v=g.attr,x=g.array(t),b=e.select(x);if(g instanceof o.BaseCoordinateSpec){var m="x"==g.dimension?d:h;if(m instanceof y.FactorRange)if(g instanceof o.CoordinateSpec)b=m.v_synthetic(b);else if(g instanceof o.CoordinateSeqSpec)for(var w=0;w<b.length;w++)b[w]=m.v_synthetic(b[w]);g instanceof o.CoordinateSeqSpec&&(b=p.RaggedArray.from(b))}else g instanceof o.DistanceSpec&&(this["max_"+v]=c.max(b));this["_"+v]=b}}}catch(t){r={error:t}}finally{try{f&&!f.done&&(i=u.return)&&i.call(u)}finally{if(r)throw r.error}}this.renderer.plot_view.model.use_map&&this._project_data(),this._set_data(n),null===(_=this.glglyph)||void 0===_||_.set_data_changed(),this.index_data()},e.prototype._set_data=function(t){},Object.defineProperty(e.prototype,"_index_size",{get:function(){return this.data_size},enumerable:!1,configurable:!0}),e.prototype.index_data=function(){var t=new u.SpatialIndex(this._index_size);this._index_data(t),t.finish(),this._index=t},e.prototype.mask_data=function(){return null!=this.glglyph||null==this._mask_data?p.Indices.all_set(this.data_size):this._mask_data()},e.prototype.map_data=function(){var t,e,n,r=this.renderer.coordinates,i=r.x_scale,s=r.y_scale;try{for(var _=a.__values(this.model),l=_.next();!l.done;l=_.next()){var d=l.value;if(d instanceof o.BaseCoordinateSpec){var h="x"==d.dimension?i:s,c=this["_"+d.attr];if(c instanceof p.RaggedArray){var u=h.v_compute(c.array);c=new p.RaggedArray(c.offsets,u)}else c=h.v_compute(c);this["s"+d.attr]=c}}}catch(e){t={error:e}}finally{try{l&&!l.done&&(e=_.return)&&e.call(_)}finally{if(t)throw t.error}}this._map_data(),null===(n=this.glglyph)||void 0===n||n.set_data_changed()},e.prototype._map_data=function(){},e}(l.View);n.GlyphView=g,g.__name__="GlyphView";var v=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_Glyph=function(){},e}(d.Model);n.Glyph=v,v.__name__="Glyph",v.init_Glyph()},
function _(n,t,e,i,r){i();var o=n(1),s=o.__importDefault(n(205)),a=n(139),u=n(194);function d(n,t){for(var e=0,i=t.length-1;e<i;){var r=e+i>>1;t[r]>n?i=r:e=r+1}return t[e]}var h=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype.search_indices=function(n,t,e,i){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var r=this._boxes.length-4,o=[],s=new a.Indices(this.numItems);void 0!==r;){for(var u=Math.min(r+4*this.nodeSize,d(r,this._levelBounds)),h=r;h<u;h+=4){var l=0|this._indices[h>>2];e<this._boxes[h+0]||(i<this._boxes[h+1]||n>this._boxes[h+2]||t>this._boxes[h+3]||(r<4*this.numItems?s.set(l):o.push(l)))}r=o.pop()}return s},t}(s.default);h.__name__="_FlatBush";var l=function(){function n(n){this.index=null,n>0&&(this.index=new h(n))}return n.prototype.add=function(n,t,e,i){var r;null===(r=this.index)||void 0===r||r.add(n,t,e,i)},n.prototype.add_empty=function(){var n;null===(n=this.index)||void 0===n||n.add(1/0,1/0,-1/0,-1/0)},n.prototype.finish=function(){var n;null===(n=this.index)||void 0===n||n.finish()},n.prototype._normalize=function(n){var t,e,i=n.x0,r=n.y0,s=n.x1,a=n.y1;return i>s&&(i=(t=o.__read([s,i],2))[0],s=t[1]),r>a&&(r=(e=o.__read([a,r],2))[0],a=e[1]),{x0:i,y0:r,x1:s,y1:a}},Object.defineProperty(n.prototype,"bbox",{get:function(){if(null==this.index)return u.empty();var n=this.index;return{x0:n.minX,y0:n.minY,x1:n.maxX,y1:n.maxY}},enumerable:!1,configurable:!0}),n.prototype.indices=function(n){if(null==this.index)return new a.Indices(0);var t=this._normalize(n),e=t.x0,i=t.y0,r=t.x1,o=t.y1;return this.index.search_indices(e,i,r,o)},n.prototype.bounds=function(n){var t,e,i=u.empty();try{for(var r=o.__values(this.indices(n)),s=r.next();!s.done;s=r.next()){var a=s.value,d=this.index._boxes,h=d[4*a+0],l=d[4*a+1],x=d[4*a+2],_=d[4*a+3];x<i.x0&&(i.x0=x),h>i.x1&&(i.x1=h),_<i.y0&&(i.y0=_),l>i.y1&&(i.y1=l)}}catch(n){t={error:n}}finally{try{s&&!s.done&&(e=r.return)&&e.call(r)}finally{if(t)throw t.error}}return i},n}();e.SpatialIndex=l,l.__name__="SpatialIndex"},
function _(t,i,s,e,r){e();var h=t(1),o=h.__importDefault(t(206)),n=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array],a=function(){function t(t,i,s,e){if(void 0===i&&(i=16),void 0===s&&(s=Float64Array),void 0===t)throw new Error("Missing required argument: numItems.");if(isNaN(t)||t<=0)throw new Error("Unpexpected numItems value: "+t+".");this.numItems=+t,this.nodeSize=Math.min(Math.max(+i,2),65535);var r=t,h=r;this._levelBounds=[4*r];do{h+=r=Math.ceil(r/this.nodeSize),this._levelBounds.push(4*h)}while(1!==r);this.ArrayType=s||Float64Array,this.IndexArrayType=h<16384?Uint16Array:Uint32Array;var a=n.indexOf(this.ArrayType),_=4*h*this.ArrayType.BYTES_PER_ELEMENT;if(a<0)throw new Error("Unexpected typed array class: "+s+".");e&&e instanceof ArrayBuffer?(this.data=e,this._boxes=new this.ArrayType(this.data,8,4*h),this._indices=new this.IndexArrayType(this.data,8+_,h),this._pos=4*h,this.minX=this._boxes[this._pos-4],this.minY=this._boxes[this._pos-3],this.maxX=this._boxes[this._pos-2],this.maxY=this._boxes[this._pos-1]):(this.data=new ArrayBuffer(8+_+h*this.IndexArrayType.BYTES_PER_ELEMENT),this._boxes=new this.ArrayType(this.data,8,4*h),this._indices=new this.IndexArrayType(this.data,8+_,h),this._pos=0,this.minX=1/0,this.minY=1/0,this.maxX=-1/0,this.maxY=-1/0,new Uint8Array(this.data,0,2).set([251,48+a]),new Uint16Array(this.data,2,1)[0]=i,new Uint32Array(this.data,4,1)[0]=t),this._queue=new o.default}return t.from=function(i){if(!(i instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");var s=h.__read(new Uint8Array(i,0,2),2),e=s[0],r=s[1];if(251!==e)throw new Error("Data does not appear to be in a Flatbush format.");if(r>>4!=3)throw new Error("Got v"+(r>>4)+" data when expected v3.");var o=h.__read(new Uint16Array(i,2,1),1)[0];return new t(h.__read(new Uint32Array(i,4,1),1)[0],o,n[15&r],i)},t.prototype.add=function(t,i,s,e){var r=this._pos>>2;return this._indices[r]=r,this._boxes[this._pos++]=t,this._boxes[this._pos++]=i,this._boxes[this._pos++]=s,this._boxes[this._pos++]=e,t<this.minX&&(this.minX=t),i<this.minY&&(this.minY=i),s>this.maxX&&(this.maxX=s),e>this.maxY&&(this.maxY=e),r},t.prototype.finish=function(){if(this._pos>>2!==this.numItems)throw new Error("Added "+(this._pos>>2)+" items when expected "+this.numItems+".");if(this.numItems<=this.nodeSize)return this._boxes[this._pos++]=this.minX,this._boxes[this._pos++]=this.minY,this._boxes[this._pos++]=this.maxX,void(this._boxes[this._pos++]=this.maxY);for(var t=this.maxX-this.minX,i=this.maxY-this.minY,s=new Uint32Array(this.numItems),e=0;e<this.numItems;e++){var r=4*e,h=this._boxes[r++],o=this._boxes[r++],n=this._boxes[r++],a=this._boxes[r++],_=Math.floor(65535*((h+n)/2-this.minX)/t),d=Math.floor(65535*((o+a)/2-this.minY)/i);s[e]=p(_,d)}!function t(i,s,e,r,h,o){if(Math.floor(r/o)>=Math.floor(h/o))return;var n=i[r+h>>1],a=r-1,_=h+1;for(;;){do{a++}while(i[a]<n);do{_--}while(i[_]>n);if(a>=_)break;x(i,s,e,a,_)}t(i,s,e,r,_,o),t(i,s,e,_+1,h,o)}(s,this._boxes,this._indices,0,this.numItems-1,this.nodeSize);for(e=0,r=0;e<this._levelBounds.length-1;e++)for(var u=this._levelBounds[e];r<u;){for(var m=r,f=1/0,y=1/0,l=-1/0,b=-1/0,v=0;v<this.nodeSize&&r<u;v++)f=Math.min(f,this._boxes[r++]),y=Math.min(y,this._boxes[r++]),l=Math.max(l,this._boxes[r++]),b=Math.max(b,this._boxes[r++]);this._indices[this._pos>>2]=m,this._boxes[this._pos++]=f,this._boxes[this._pos++]=y,this._boxes[this._pos++]=l,this._boxes[this._pos++]=b}},t.prototype.search=function(t,i,s,e,r){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var h=this._boxes.length-4,o=[],n=[];void 0!==h;){for(var a=Math.min(h+4*this.nodeSize,d(h,this._levelBounds)),_=h;_<a;_+=4){var x=0|this._indices[_>>2];s<this._boxes[_]||(e<this._boxes[_+1]||t>this._boxes[_+2]||i>this._boxes[_+3]||(h<4*this.numItems?(void 0===r||r(x))&&n.push(x):o.push(x)))}h=o.pop()}return n},t.prototype.neighbors=function(t,i,s,e,r){if(void 0===s&&(s=1/0),void 0===e&&(e=1/0),this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var h=this._boxes.length-4,o=this._queue,n=[],a=e*e;void 0!==h;){for(var x=Math.min(h+4*this.nodeSize,d(h,this._levelBounds)),p=h;p<x;p+=4){var u=0|this._indices[p>>2],m=_(t,this._boxes[p],this._boxes[p+2]),f=_(i,this._boxes[p+1],this._boxes[p+3]),y=m*m+f*f;h<4*this.numItems?(void 0===r||r(u))&&o.push(-u-1,y):o.push(u,y)}for(;o.length&&o.peek()<0;){if((y=o.peekValue())>a)return o.clear(),n;if(n.push(-o.pop()-1),n.length===s)return o.clear(),n}h=o.pop()}return o.clear(),n},t}();function _(t,i,s){return t<i?i-t:t<=s?0:t-s}function d(t,i){for(var s=0,e=i.length-1;s<e;){var r=s+e>>1;i[r]>t?e=r:s=r+1}return i[s]}function x(t,i,s,e,r){var h=t[e];t[e]=t[r],t[r]=h;var o=4*e,n=4*r,a=i[o],_=i[o+1],d=i[o+2],x=i[o+3];i[o]=i[n],i[o+1]=i[n+1],i[o+2]=i[n+2],i[o+3]=i[n+3],i[n]=a,i[n+1]=_,i[n+2]=d,i[n+3]=x;var p=s[e];s[e]=s[r],s[r]=p}function p(t,i){var s=t^i,e=65535^s,r=65535^(t|i),h=t&(65535^i),o=s|e>>1,n=s>>1^s,a=r>>1^e&h>>1^r,_=s&r>>1^h>>1^h;n=(s=o)&(e=n)>>2^e&(s^e)>>2,a^=s&(r=a)>>2^e&(h=_)>>2,_^=e&r>>2^(s^e)&h>>2,n=(s=o=s&s>>2^e&e>>2)&(e=n)>>4^e&(s^e)>>4,a^=s&(r=a)>>4^e&(h=_)>>4,_^=e&r>>4^(s^e)&h>>4,a^=(s=o=s&s>>4^e&e>>4)&(r=a)>>8^(e=n)&(h=_)>>8;var d=t^i,x=(e=(_^=e&r>>8^(s^e)&h>>8)^_>>1)|65535^(d|(s=a^a>>1));return((x=1431655765&((x=858993459&((x=252645135&((x=16711935&(x|x<<8))|x<<4))|x<<2))|x<<1))<<1|(d=1431655765&((d=858993459&((d=252645135&((d=16711935&(d|d<<8))|d<<4))|d<<2))|d<<1)))>>>0}s.default=a},
function _(t,i,s,h,e){h();var n=function(){function t(){this.ids=[],this.values=[],this.length=0}return t.prototype.clear=function(){this.length=0},t.prototype.push=function(t,i){var s=this.length++;for(this.ids[s]=t,this.values[s]=i;s>0;){var h=s-1>>1,e=this.values[h];if(i>=e)break;this.ids[s]=this.ids[h],this.values[s]=e,s=h}this.ids[s]=t,this.values[s]=i},t.prototype.pop=function(){if(0!==this.length){var t=this.ids[0];if(this.length--,this.length>0){for(var i=this.ids[0]=this.ids[this.length],s=this.values[0]=this.values[this.length],h=this.length>>1,e=0;e<h;){var n=1+(e<<1),l=n+1,u=this.ids[n],r=this.values[n],a=this.values[l];if(l<this.length&&a<r&&(n=l,u=this.ids[l],r=a),r>=s)break;this.ids[e]=u,this.values[e]=r,e=n}this.ids[e]=i,this.values[e]=s}return t}},t.prototype.peek=function(){if(0!==this.length)return this.ids[0]},t.prototype.peekValue=function(){if(0!==this.length)return this.values[0]},t}();s.default=n},
function _(r,e,n,t,a){t();var i=r(1),o=r(208),s=r(135),l=r(139),u=r(124),p=r(123),c=r(126);function d(r,e,n){void 0===n&&(n=0);for(var t=new Map,a=0;a<r.length;a++){var i=r[a];if(t.has(i))throw new Error("duplicate factor or subfactor: "+i);t.set(i,{value:.5+a*(1+e)+n})}return[t,(r.length-1)*e]}function _(r,e,n,t){var a,o,s,l,p;void 0===t&&(t=0);var c=new Map,_=new Map;try{for(var g=i.__values(r),f=g.next();!f.done;f=g.next()){var v=i.__read(f.value,2),h=v[0],y=v[1],m=null!==(p=_.get(h))&&void 0!==p?p:[];_.set(h,i.__spread(m,[y]))}}catch(r){a={error:r}}finally{try{f&&!f.done&&(o=g.return)&&o.call(g)}finally{if(a)throw a.error}}var b=t,w=0,x=function(r,t){var a=t.length,o=i.__read(d(t,n,b),2),s=o[0],l=o[1];w+=l;var p=u.sum(t.map((function(r){return s.get(r).value})));c.set(r,{value:p/a,mapping:s}),b+=a+e+l};try{for(var N=i.__values(_),S=N.next();!S.done;S=N.next()){var k=i.__read(S.value,2);x(h=k[0],m=k[1])}}catch(r){s={error:r}}finally{try{S&&!S.done&&(l=N.return)&&l.call(N)}finally{if(s)throw s.error}}return[c,(_.size-1)*e+w]}function g(r,e,n,t,a){var o,s,l,p,c;void 0===a&&(a=0);var d=new Map,g=new Map;try{for(var f=i.__values(r),v=f.next();!v.done;v=f.next()){var h=i.__read(v.value,3),y=h[0],m=h[1],b=h[2],w=null!==(c=g.get(y))&&void 0!==c?c:[];g.set(y,i.__spread(w,[[m,b]]))}}catch(r){o={error:r}}finally{try{v&&!v.done&&(s=f.return)&&s.call(f)}finally{if(o)throw o.error}}var x=a,N=0,S=function(r,a){var o=a.length,s=i.__read(_(a,n,t,x),2),l=s[0],p=s[1];N+=p;var c=u.sum(a.map((function(r){var e=i.__read(r,1)[0];return l.get(e).value})));d.set(r,{value:c/o,mapping:l}),x+=o+e+p};try{for(var k=i.__values(g),A=k.next();!A.done;A=k.next()){var M=i.__read(A.value,2);S(y=M[0],w=M[1])}}catch(r){l={error:r}}finally{try{A&&!A.done&&(p=k.return)&&p.call(k)}finally{if(l)throw l.error}}return[d,(g.size-1)*e+N]}n.map_one_level=d,n.map_two_levels=_,n.map_three_levels=g;var f=function(r){function e(e){return r.call(this,e)||this}return i.__extends(e,r),e.init_FactorRange=function(){this.define((function(r){var e=r.Any,n=r.Number;return{factors:[(0,r.Array)(e),[]],factor_padding:[n,0],subgroup_padding:[n,.8],group_padding:[n,1.4],range_padding:[n,0],range_padding_units:[s.PaddingUnits,"percent"],start:[n],end:[n]}})),this.internal((function(r){var e=r.Number,n=r.String,t=r.Array,a=r.Tuple,i=r.Nullable;return{levels:[e],mids:[i(t(a(n,n))),null],tops:[i(t(n)),null]}}))},Object.defineProperty(e.prototype,"min",{get:function(){return this.start},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"max",{get:function(){return this.end},enumerable:!1,configurable:!0}),e.prototype.initialize=function(){r.prototype.initialize.call(this),this._init(!0)},e.prototype.connect_signals=function(){var e=this;r.prototype.connect_signals.call(this),this.connect(this.properties.factors.change,(function(){return e.reset()})),this.connect(this.properties.factor_padding.change,(function(){return e.reset()})),this.connect(this.properties.group_padding.change,(function(){return e.reset()})),this.connect(this.properties.subgroup_padding.change,(function(){return e.reset()})),this.connect(this.properties.range_padding.change,(function(){return e.reset()})),this.connect(this.properties.range_padding_units.change,(function(){return e.reset()}))},e.prototype.reset=function(){this._init(!1),this.change.emit()},e.prototype._lookup=function(r){switch(r.length){case 1:var e=i.__read(r,1)[0];return null!=(a=this._mapping.get(e))?a.value:NaN;case 2:var n=i.__read(r,2),t=(e=n[0],n[1]);if(null!=(a=this._mapping.get(e)))if(null!=(o=a.mapping.get(t)))return o.value;return NaN;case 3:var a,o,s=i.__read(r,3),l=(e=s[0],t=s[1],s[2]);if(null!=(a=this._mapping.get(e)))if(null!=(o=a.mapping.get(t))){var u=o.mapping.get(l);if(null!=u)return u.value}return NaN;default:c.unreachable()}},e.prototype.synthetic=function(r){if(p.isNumber(r))return r;if(p.isString(r))return this._lookup([r]);var e=0,n=r[r.length-1];return p.isNumber(n)&&(e=n,r=r.slice(0,-1)),this._lookup(r)+e},e.prototype.v_synthetic=function(r){for(var e=r.length,n=new l.NumberArray(e),t=0;t<e;t++)n[t]=this.synthetic(r[t]);return n},e.prototype._init=function(r){var e=this,n=function(){var r,n,t,a;if(u.every(e.factors,p.isString)){var o=e.factors,s=i.__read(d(o,e.factor_padding),2);return{levels:1,mapping:s[0],tops:null,mids:null,inside_padding:s[1]}}if(u.every(e.factors,(function(r){return p.isArray(r)&&2==r.length&&p.isString(r[0])&&p.isString(r[1])}))){o=e.factors;var l=i.__read(_(o,e.group_padding,e.factor_padding),2),f=l[0],v=l[1],h=i.__spread(f.keys());return{levels:2,mapping:f,tops:h,mids:null,inside_padding:v}}if(u.every(e.factors,(function(r){return p.isArray(r)&&3==r.length&&p.isString(r[0])&&p.isString(r[1])&&p.isString(r[2])}))){o=e.factors;var y=i.__read(g(o,e.group_padding,e.subgroup_padding,e.factor_padding),2),m=y[0],b=y[1],w=i.__spread(m.keys()),x=[];try{for(var N=i.__values(m),S=N.next();!S.done;S=N.next()){var k=i.__read(S.value,2),A=k[0],M=k[1];try{for(var R=(t=void 0,i.__values(M.mapping.keys())),z=R.next();!z.done;z=R.next()){var F=z.value;x.push([A,F])}}catch(r){t={error:r}}finally{try{z&&!z.done&&(a=R.return)&&a.call(R)}finally{if(t)throw t.error}}}}catch(e){r={error:e}}finally{try{S&&!S.done&&(n=N.return)&&n.call(N)}finally{if(r)throw r.error}}return{levels:3,mapping:m,tops:w,mids:x,inside_padding:b}}c.unreachable()}(),t=n.levels,a=n.mapping,o=n.tops,s=n.mids,l=n.inside_padding;this._mapping=a,this.tops=o,this.mids=s;var f=0,v=this.factors.length+l;if("percent"==this.range_padding_units){var h=(v-f)*this.range_padding/2;f-=h,v+=h}else f-=this.range_padding,v+=this.range_padding;this.setv({start:f,end:v,levels:t},{silent:r}),"auto"==this.bounds&&this.setv({bounds:[f,v]},{silent:!0})},e}(o.Range);n.FactorRange=f,f.__name__="FactorRange",f.init_FactorRange()},
function _(e,n,t,i,r){i();var a=e(1),u=function(e){function n(n){var t=e.call(this,n)||this;return t.have_updated_interactively=!1,t}return a.__extends(n,e),n.init_Range=function(){this.define((function(e){var n=e.Number,t=e.Tuple,i=e.Or,r=e.Auto,a=e.Nullable;return{bounds:[a(i(t(a(n),a(n)),r)),null],min_interval:[a(n),null],max_interval:[a(n),null]}})),this.internal((function(e){return{plots:[(0,e.Array)((0,e.AnyRef)()),[]]}}))},Object.defineProperty(n.prototype,"is_reversed",{get:function(){return this.start>this.end},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"is_valid",{get:function(){return!isNaN(this.min)&&!isNaN(this.max)},enumerable:!1,configurable:!0}),n}(e(196).Model);t.Range=u,u.__name__="Range",u.init_Range()},
function _(e,t,r,n,i){n();var o=e(1),c=e(129),l=e(202),s=e(210),a=e(231),p=e(200),u=function(e){function t(t){var r=e.call(this,t)||this;return r.inspectors=new Map,r}return o.__extends(t,e),t.init_SelectionManager=function(){this.internal((function(e){return{source:[(0,e.Ref)(p.ColumnarDataSource)]}}))},t.prototype.select=function(e,t,r,n){var i,c,l,p;void 0===n&&(n="replace");var u=[],_=[];try{for(var h=o.__values(e),f=h.next();!f.done;f=h.next()){(m=f.value)instanceof s.GlyphRendererView?u.push(m):m instanceof a.GraphRendererView&&_.push(m)}}catch(e){i={error:e}}finally{try{f&&!f.done&&(c=h.return)&&c.call(h)}finally{if(i)throw i.error}}var d=!1;try{for(var y=o.__values(_),v=y.next();!v.done;v=y.next()){var m,g=(m=v.value).model.selection_policy.hit_test(t,m);d=d||m.model.selection_policy.do_selection(g,m.model,r,n)}}catch(e){l={error:e}}finally{try{v&&!v.done&&(p=y.return)&&p.call(y)}finally{if(l)throw l.error}}if(u.length>0){g=this.source.selection_policy.hit_test(t,u);d=d||this.source.selection_policy.do_selection(g,this.source,r,n)}return d},t.prototype.inspect=function(e,t){var r=!1;if(e instanceof s.GlyphRendererView){if(null!=(i=e.hit_test(t))){r=!i.is_empty();var n=this.get_or_create_inspector(e.model);n.update(i,!0,"replace"),this.source.setv({inspected:n},{silent:!0}),this.source.inspect.emit([e.model,{geometry:t}])}}else if(e instanceof a.GraphRendererView){var i=e.model.inspection_policy.hit_test(t,e);r=r||e.model.inspection_policy.do_inspection(i,t,e,!1,"replace")}return r},t.prototype.clear=function(e){this.source.selected.clear(),null!=e&&this.get_or_create_inspector(e.model).clear()},t.prototype.get_or_create_inspector=function(e){var t=this.inspectors.get(e);return null==t&&(t=new l.Selection,this.inspectors.set(e,t)),t},t}(c.HasProps);r.SelectionManager=u,u.__name__="SelectionManager",u.init_SelectionManager()},
function _(e,t,i,n,l){n();var r=e(1),s=e(211),h=e(212),o=e(224),a=e(225),c=e(227),_=e(203),u=e(200),d=e(228),p=e(139),y=e(127),g=e(124),v=e(128),f=e(230),m=e(207),w={fill:{},line:{}},b={fill:{fill_alpha:.3,fill_color:"grey"},line:{line_alpha:.3,line_color:"grey"}},x={fill:{fill_alpha:.2},line:{}},V=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),Object.defineProperty(t.prototype,"glyph_view",{get:function(){return this.glyph},enumerable:!1,configurable:!0}),t.prototype.lazy_initialize=function(){return r.__awaiter(this,void 0,void 0,(function(){function t(e){var t=v.clone(s);return n&&v.extend(t,e.fill),l&&v.extend(t,e.line),new i.constructor(t)}var i,n,l,s,h,o,a,c,_,u,d,p,y,f,m;return r.__generator(this,(function(r){switch(r.label){case 0:return[4,e.prototype.lazy_initialize.call(this)];case 1:return r.sent(),i=this.model.glyph,n=g.includes(i._mixins,"fill"),l=g.includes(i._mixins,"line"),delete(s=v.clone(i.attributes)).id,h=this,[4,this.build_glyph_view(i)];case 2:return h.glyph=r.sent(),null==(o=this.model.selection_glyph)?o=t({fill:{},line:{}}):"auto"===o&&(o=t(w)),a=this,[4,this.build_glyph_view(o)];case 3:return a.selection_glyph=r.sent(),null==(c=this.model.nonselection_glyph)?c=t({fill:{},line:{}}):"auto"===c&&(c=t(x)),_=this,[4,this.build_glyph_view(c)];case 4:return _.nonselection_glyph=r.sent(),null==(u=this.model.hover_glyph)?[3,6]:(d=this,[4,this.build_glyph_view(u)]);case 5:d.hover_glyph=r.sent(),r.label=6;case 6:return null==(p=this.model.muted_glyph)?[3,8]:(y=this,[4,this.build_glyph_view(p)]);case 7:y.muted_glyph=r.sent(),r.label=8;case 8:return f=t(b),m=this,[4,this.build_glyph_view(f)];case 9:return m.decimated_glyph=r.sent(),this.set_data(!1),[2]}}))}))},t.prototype.build_glyph_view=function(e){return r.__awaiter(this,void 0,void 0,(function(){return r.__generator(this,(function(t){return[2,f.build_view(e,{parent:this})]}))}))},t.prototype.remove=function(){var t,i;this.glyph.remove(),this.selection_glyph.remove(),this.nonselection_glyph.remove(),null===(t=this.hover_glyph)||void 0===t||t.remove(),null===(i=this.muted_glyph)||void 0===i||i.remove(),this.decimated_glyph.remove(),e.prototype.remove.call(this)},t.prototype.connect_signals=function(){var t,i,n,l,s=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return s.request_render()})),this.connect(this.model.glyph.change,(function(){return s.set_data()})),this.connect(this.model.data_source.change,(function(){return s.set_data()})),this.connect(this.model.data_source.streaming,(function(){return s.set_data()})),this.connect(this.model.data_source.patching,(function(e){return s.set_data(!0,e)})),this.connect(this.model.data_source.selected.change,(function(){return s.request_render()})),this.connect(this.model.data_source._select,(function(){return s.request_render()})),null!=this.hover_glyph&&this.connect(this.model.data_source.inspect,(function(){return s.request_render()})),this.connect(this.model.properties.view.change,(function(){return s.set_data()})),this.connect(this.model.view.properties.indices.change,(function(){return s.set_data()})),this.connect(this.model.view.properties.masked.change,(function(){return s.set_visuals()})),this.connect(this.model.properties.visible.change,(function(){return s.plot_view.invalidate_dataranges=!0}));var h=this.plot_view.frame,o=h.x_ranges,a=h.y_ranges;try{for(var c=r.__values(o),_=c.next();!_.done;_=c.next()){(p=r.__read(_.value,2)[1])instanceof m.FactorRange&&this.connect(p.change,(function(){return s.set_data()}))}}catch(e){t={error:e}}finally{try{_&&!_.done&&(i=c.return)&&i.call(c)}finally{if(t)throw t.error}}try{for(var u=r.__values(a),d=u.next();!d.done;d=u.next()){var p;(p=r.__read(d.value,2)[1])instanceof m.FactorRange&&this.connect(p.change,(function(){return s.set_data()}))}}catch(e){n={error:e}}finally{try{d&&!d.done&&(l=u.return)&&l.call(u)}finally{if(n)throw n.error}}this.connect(this.model.glyph.transformchange,(function(){return s.set_data()}))},t.prototype._update_masked_indices=function(){var e=this.glyph.mask_data();return this.model.view.masked=e,e},t.prototype.set_data=function(e,t){void 0===e&&(e=!0),void 0===t&&(t=null);var i=this.model.data_source;this.all_indices=this.model.view.indices;var n=this.all_indices;this.glyph.set_data(i,n,t),this.set_visuals(),this._update_masked_indices();var l=this.plot_model.lod_factor,r=this.all_indices.count;this.decimated=new p.Indices(r);for(var s=0;s<r;s+=l)this.decimated.set(s);this.plot_view.invalidate_dataranges=!0,e&&this.request_render()},t.prototype.set_visuals=function(){var e,t,i,n,l=this.model.data_source,r=this.all_indices;this.glyph.set_visuals(l,r),this.decimated_glyph.set_visuals(l,r),null===(e=this.selection_glyph)||void 0===e||e.set_visuals(l,r),null===(t=this.nonselection_glyph)||void 0===t||t.set_visuals(l,r),null===(i=this.hover_glyph)||void 0===i||i.set_visuals(l,r),null===(n=this.muted_glyph)||void 0===n||n.set_visuals(l,r)},Object.defineProperty(t.prototype,"has_webgl",{get:function(){return this.glyph.has_webgl},enumerable:!1,configurable:!0}),t.prototype._render=function(){var e,t,i,n,l,s,_,u,d=this,p=this.has_webgl;this.glyph.map_data();var v=r.__spread(this.all_indices),f=r.__spread(this._update_masked_indices()),m=this.layer.ctx;m.save();var w,b=this.model.data_source.selected;w=!b||b.is_empty()?[]:this.glyph instanceof h.LineView&&b.selected_glyph===this.glyph.model?this.model.view.convert_indices_from_subset(f):b.indices;var x,V,G,R=this.model.data_source.inspected,k=new Set(!R||R.is_empty()?[]:R.selected_glyph?d.model.view.convert_indices_from_subset(f):R.indices.length>0?R.indices:Object.keys(R.multiline_indices).map((function(e){return parseInt(e)}))),z=y.filter(f,(function(e){return k.has(v[e])})),q=this.plot_model.lod_threshold;if(null!=this.model.document&&this.model.document.interactive_duration()>0&&!p&&null!=q&&v.length>q?(f=r.__spread(this.decimated),x=this.decimated_glyph,V=this.decimated_glyph,G=this.selection_glyph):(x=this.model.muted&&null!=this.muted_glyph?this.muted_glyph:this.glyph,V=this.nonselection_glyph,G=this.selection_glyph),null!=this.hover_glyph&&z.length&&(f=g.difference(f,z)),w.length){var A={};try{for(var D=r.__values(w),O=D.next();!O.done;O=D.next()){A[I=O.value]=!0}}catch(e){i={error:e}}finally{try{O&&!O.done&&(n=D.return)&&n.call(D)}finally{if(i)throw i.error}}var L=new Array,S=new Array;if(this.glyph instanceof h.LineView)try{for(var j=r.__values(v),C=j.next();!C.done;C=j.next()){null!=A[I=C.value]?L.push(I):S.push(I)}}catch(e){l={error:e}}finally{try{C&&!C.done&&(s=j.return)&&s.call(j)}finally{if(l)throw l.error}}else try{for(var P=r.__values(f),F=P.next();!F.done;F=P.next()){var I=F.value;null!=A[v[I]]?L.push(I):S.push(I)}}catch(e){_={error:e}}finally{try{F&&!F.done&&(u=P.return)&&u.call(P)}finally{if(_)throw _.error}}V.render(m,S,this.glyph),G.render(m,L,this.glyph),null!=this.hover_glyph&&(this.glyph instanceof h.LineView?this.hover_glyph.render(m,this.model.view.convert_indices_from_subset(z),this.glyph):this.hover_glyph.render(m,z,this.glyph))}else if(this.glyph instanceof h.LineView)this.hover_glyph&&z.length?this.hover_glyph.render(m,this.model.view.convert_indices_from_subset(z),this.glyph):x.render(m,v,this.glyph);else if(this.glyph instanceof o.PatchView||this.glyph instanceof a.HAreaView||this.glyph instanceof c.VAreaView)if(0==R.selected_glyphs.length||null==this.hover_glyph)x.render(m,v,this.glyph);else try{for(var B=r.__values(R.selected_glyphs),H=B.next();!H.done;H=B.next()){H.value==this.glyph.model&&this.hover_glyph.render(m,v,this.glyph)}}catch(t){e={error:t}}finally{try{H&&!H.done&&(t=B.return)&&t.call(B)}finally{if(e)throw e.error}}else x.render(m,f,this.glyph),this.hover_glyph&&z.length&&this.hover_glyph.render(m,z,this.glyph);m.restore()},t.prototype.draw_legend=function(e,t,i,n,l,r,s,h){null==h&&(h=this.model.get_reference_point(r,s)),this.glyph.draw_legend_for_index(e,{x0:t,x1:i,y0:n,y1:l},h)},t.prototype.hit_test=function(e){if(!this.model.visible)return null;var t=this.glyph.hit_test(e);return null==t?null:this.model.view.convert_selection_from_subset(t)},t}(s.DataRendererView);i.GlyphRendererView=V,V.__name__="GlyphRendererView";var G=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_GlyphRenderer=function(){this.prototype.default_view=V,this.define((function(e){var t=e.Boolean,i=e.Auto,n=e.Or,l=e.Ref,r=e.Nullable;return{data_source:[l(u.ColumnarDataSource)],view:[l(d.CDSView),function(e){return new d.CDSView({source:e.data_source})}],glyph:[l(_.Glyph)],hover_glyph:[r(l(_.Glyph)),null],nonselection_glyph:[n(l(_.Glyph),i),"auto"],selection_glyph:[n(l(_.Glyph),i),"auto"],muted_glyph:[r(l(_.Glyph)),null],muted:[t,!1]}}))},t.prototype.initialize=function(){e.prototype.initialize.call(this),this.view.source!=this.data_source&&(this.view.source=this.data_source,this.view.compute_indices())},t.prototype.get_reference_point=function(e,t){var i=0;if(null!=e){var n=this.data_source.get_column(e);if(null!=n){var l=y.indexOf(n,t);-1!=l&&(i=l)}}return i},t.prototype.get_selection_manager=function(){return this.data_source.selection_manager},t}(s.DataRenderer);i.GlyphRenderer=G,G.__name__="GlyphRenderer",G.init_GlyphRenderer()},
function _(e,n,t,r,i){r();var a=e(1),o=e(185),c=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),Object.defineProperty(n.prototype,"xscale",{get:function(){return this.coordinates.x_scale},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"yscale",{get:function(){return this.coordinates.y_scale},enumerable:!1,configurable:!0}),n}(o.RendererView);t.DataRendererView=c,c.__name__="DataRendererView";var u=function(e){function n(n){return e.call(this,n)||this}return a.__extends(n,e),n.init_DataRenderer=function(){this.override({level:"glyph"})},Object.defineProperty(n.prototype,"selection_manager",{get:function(){return this.get_selection_manager()},enumerable:!1,configurable:!0}),n}(o.Renderer);t.DataRenderer=u,u.__name__="DataRenderer",u.init_DataRenderer()},
function _(e,i,t,n,r){n();var s=e(1),l=e(213),o=e(214),_=e(216),h=s.__importStar(e(143)),a=s.__importStar(e(215)),u=e(202),p=function(e){function i(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(i,e),i.prototype.initialize=function(){e.prototype.initialize.call(this);var i=this.renderer.plot_view.canvas_view.webgl;null!=i&&(this.glglyph=new _.LineGL(i.gl,this))},i.prototype._render=function(e,i,t){var n,r,l=t.sx,o=t.sy,_=!1,h=null;this.visuals.line.set_value(e);try{for(var a=s.__values(i),u=a.next();!u.done;u=a.next()){var p=u.value;if(_){if(!isFinite(l[p]+o[p])){e.stroke(),e.beginPath(),_=!1,h=p;continue}null!=h&&p-h>1&&(e.stroke(),_=!1)}_?e.lineTo(l[p],o[p]):(e.beginPath(),e.moveTo(l[p],o[p]),_=!0),h=p}}catch(e){n={error:e}}finally{try{u&&!u.done&&(r=a.return)&&r.call(a)}finally{if(n)throw n.error}}_&&e.stroke()},i.prototype._hit_point=function(e){for(var i=new u.Selection,t={x:e.sx,y:e.sy},n=9999,r=Math.max(2,this.visuals.line.line_width.value()/2),s=0,l=this.sx.length-1;s<l;s++){var o={x:this.sx[s],y:this.sy[s]},_={x:this.sx[s+1],y:this.sy[s+1]},h=a.dist_to_segment(t,o,_);h<r&&h<n&&(n=h,i.add_to_selected_glyphs(this.model),i.view=this,i.line_indices=[s])}return i},i.prototype._hit_span=function(e){var i,t,n=e.sx,r=e.sy,s=new u.Selection;"v"==e.direction?(i=this.renderer.yscale.invert(r),t=this._y):(i=this.renderer.xscale.invert(n),t=this._x);for(var l=0,o=t.length-1;l<o;l++)(t[l]<=i&&i<=t[l+1]||t[l+1]<=i&&i<=t[l])&&(s.add_to_selected_glyphs(this.model),s.view=this,s.line_indices.push(l));return s},i.prototype.get_interpolation_hit=function(e,i){var t=s.__read([this._x[e],this._y[e],this._x[e+1],this._y[e+1]],4),n=t[0],r=t[1],l=t[2],_=t[3];return o.line_interpolation(this.renderer,i,n,r,l,_)},i.prototype.draw_legend_for_index=function(e,i,t){o.generic_line_legend(this.visuals,e,i,t)},i}(l.XYGlyphView);t.LineView=p,p.__name__="LineView";var y=function(e){function i(i){return e.call(this,i)||this}return s.__extends(i,e),i.init_Line=function(){this.prototype.default_view=p,this.mixins(h.Line)},i}(l.XYGlyph);t.Line=y,y.__name__="Line",y.init_Line()},
function _(t,i,n,e,_){e();var r=t(1),o=t(152),p=r.__importStar(t(133)),a=t(203),h=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(i,t),i.prototype._project_data=function(){o.inplace.project_xy(this._x,this._y)},i.prototype._index_data=function(t){for(var i=this.data_size,n=0;n<i;n++){var e=this._x[n],_=this._y[n];isNaN(e+_)||!isFinite(e+_)?t.add_empty():t.add(e,_,e,_)}},i.prototype.scenterxy=function(t){return[this.sx[t],this.sy[t]]},i}(a.GlyphView);n.XYGlyphView=h,h.__name__="XYGlyphView";var s=function(t){function i(i){return t.call(this,i)||this}return r.__extends(i,t),i.init_XYGlyph=function(){this.define((function(t){return{x:[p.XCoordinateSpec,{field:"x"}],y:[p.YCoordinateSpec,{field:"y"}]}}))},i}(a.Glyph);n.XYGlyph=s,s.__name__="XYGlyph",s.init_XYGlyph()},
function _(e,t,i,r,n){r();var a=e(1),_=a.__importStar(e(215));i.generic_line_legend=function(e,t,i,r){var n=i.x0,a=i.x1,_=i.y0,l=i.y1;t.save(),t.beginPath(),t.moveTo(n,(_+l)/2),t.lineTo(a,(_+l)/2),e.line.doit&&(e.line.set_vectorize(t,r),t.stroke()),t.restore()},i.generic_area_legend=function(e,t,i,r){var n=i.x0,a=i.x1,_=i.y0,l=i.y1,c=.1*Math.abs(a-n),o=.1*Math.abs(l-_),s=n+c,v=a-c,h=_+o,d=l-o;e.fill.doit&&(e.fill.set_vectorize(t,r),t.fillRect(s,h,v-s,d-h)),null!=e.hatch&&e.hatch.doit&&(e.hatch.set_vectorize(t,r),t.fillRect(s,h,v-s,d-h)),e.line&&e.line.doit&&(t.beginPath(),t.rect(s,h,v-s,d-h),e.line.set_vectorize(t,r),t.stroke())},i.line_interpolation=function(e,t,i,r,n,l){var c,o,s,v,h,d,x,y,f,g,m=t.sx,u=t.sy;"point"==t.type?(f=(c=a.__read(e.yscale.r_invert(u-1,u+1),2))[0],g=c[1],x=(o=a.__read(e.xscale.r_invert(m-1,m+1),2))[0],y=o[1]):"v"==t.direction?(f=(s=a.__read(e.yscale.r_invert(u,u),2))[0],g=s[1],x=(v=a.__read([Math.min(i-1,n-1),Math.max(i+1,n+1)],2))[0],y=v[1]):(x=(h=a.__read(e.xscale.r_invert(m,m),2))[0],y=h[1],f=(d=a.__read([Math.min(r-1,l-1),Math.max(r+1,l+1)],2))[0],g=d[1]);var M=_.check_2_segments_intersect(x,f,y,g,i,r,n,l);return[M.x,M.y]}},
function _(t,n,r,o,a){function e(t,n){return Math.pow(t.x-n.x,2)+Math.pow(t.y-n.y,2)}function h(t,n,r){var o=e(n,r);if(0==o)return e(t,n);var a=((t.x-n.x)*(r.x-n.x)+(t.y-n.y)*(r.y-n.y))/o;return e(t,a<0?n:a>1?r:{x:n.x+a*(r.x-n.x),y:n.y+a*(r.y-n.y)})}o(),r.point_in_poly=function(t,n,r,o){for(var a=!1,e=r[r.length-1],h=o[o.length-1],i=0;i<r.length;i++){var s=r[i],u=o[i];h<n!=u<n&&e+(n-h)/(u-h)*(s-e)<t&&(a=!a),e=s,h=u}return a},r.point_in_ellipse=function(t,n,r,o,a,e,h){var i=Math.pow(Math.cos(r)/a,2)+Math.pow(Math.sin(r)/o,2),s=2*Math.cos(r)*Math.sin(r)*(Math.pow(1/a,2)-Math.pow(1/o,2)),u=Math.pow(Math.cos(r)/o,2)+Math.pow(Math.sin(r)/a,2);return i*Math.pow(t-e,2)+s*(t-e)*(n-h)+u*Math.pow(n-h,2)<=1},r.dist_2_pts=e,r.dist_to_segment_squared=h,r.dist_to_segment=function(t,n,r){return Math.sqrt(h(t,n,r))},r.check_2_segments_intersect=function(t,n,r,o,a,e,h,i){var s=(i-e)*(r-t)-(h-a)*(o-n);if(0==s)return{hit:!1,x:null,y:null};var u=n-e,M=t-a,p=(h-a)*u-(i-e)*M;return M=((r-t)*u-(o-n)*M)/s,{hit:(u=p/s)>0&&u<1&&M>0&&M<1,x:t+u*(r-t),y:n+u*(o-n)}}},
function _(t,e,s,i,a){i();var r=t(1),n=t(217),o=t(221),_=t(222),h=t(223),l=t(137),g=function(){function t(t){this._atlas=new Map,this._width=256,this._height=256,this.tex=new n.Texture2d(t),this.tex.set_wrapping(t.REPEAT,t.REPEAT),this.tex.set_interpolation(t.NEAREST,t.NEAREST),this.tex.set_size([this._width,this._height],t.RGBA),this.tex.set_data([0,0],[this._width,this._height],new Uint8Array(4*this._width*this._height)),this.get_atlas_data([1])}return t.prototype.get_atlas_data=function(t){var e=t.join("-"),s=this._atlas.get(e);if(null==s){var i=r.__read(this.make_pattern(t),2),a=i[0],n=i[1],o=this._atlas.size;this.tex.set_data([0,o],[this._width,1],new Uint8Array(a.map((function(t){return t+10})))),s=[o/this._height,n],this._atlas.set(e,s)}return s},t.prototype.make_pattern=function(t){var e,s;t.length>1&&t.length%2&&(t=t.concat(t));var i=0;try{for(var a=r.__values(t),n=a.next();!n.done;n=a.next()){i+=n.value}}catch(t){e={error:t}}finally{try{n&&!n.done&&(s=a.return)&&s.call(a)}finally{if(e)throw e.error}}for(var o=[],_=0,h=0,l=t.length+2;h<l;h+=2){var g=Math.max(1e-4,t[h%t.length]),u=Math.max(1e-4,t[(h+1)%t.length]);o.push(_,_+g),_+=g+u}var f=this._width,v=new Float32Array(4*f);for(h=0,l=f;h<l;h++){for(var p=void 0,d=void 0,c=void 0,b=i*h/(f-1),w=0,y=1e16,m=0,x=o.length;m<x;m++){var A=Math.abs(o[m]-b);A<y&&(w=m,y=A)}w%2==0?(c=b<=o[w]?1:0,d=o[w],p=o[w+1]):(c=b>o[w]?-1:0,d=o[w-1],p=o[w]),v[4*h+0]=o[w],v[4*h+1]=c,v[4*h+2]=d,v[4*h+3]=p}return[v,i]},t}();g.__name__="DashAtlas";var u={miter:0,round:1,bevel:2},f={"":0,none:0,".":0,round:1,")":1,"(":1,o:1,"triangle in":2,"<":2,"triangle out":3,">":3,square:4,"[":4,"]":4,"=":4,butt:5,"|":5},v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype.init=function(){var t=this.gl;this._scale_aspect=0;var e=_.vertex_shader,s=h.fragment_shader;this.prog=new n.Program(t),this.prog.set_shaders(e,s),this.index_buffer=new n.IndexBuffer(t),this.vbo_position=new n.VertexBuffer(t),this.vbo_tangents=new n.VertexBuffer(t),this.vbo_segment=new n.VertexBuffer(t),this.vbo_angles=new n.VertexBuffer(t),this.vbo_texcoord=new n.VertexBuffer(t),this.dash_atlas=new g(t)},e.prototype.draw=function(t,e,s){var i=e.glglyph;if(i.data_changed&&(i._set_data(),i.data_changed=!1),this.visuals_changed&&(this._set_visuals(),this.visuals_changed=!1),i._update_scale(1,1),this._scale_aspect=1,this.prog.set_attribute("a_position","vec2",i.vbo_position),this.prog.set_attribute("a_tangents","vec4",i.vbo_tangents),this.prog.set_attribute("a_segment","vec2",i.vbo_segment),this.prog.set_attribute("a_angles","vec2",i.vbo_angles),this.prog.set_attribute("a_texcoord","vec2",i.vbo_texcoord),this.prog.set_uniform("u_length","float",[i.cumsum]),this.prog.set_texture("u_dash_atlas",this.dash_atlas.tex),this.prog.set_uniform("u_pixel_ratio","float",[s.pixel_ratio]),this.prog.set_uniform("u_canvas_size","vec2",[s.width,s.height]),this.prog.set_uniform("u_scale_aspect","vec2",[1,1]),this.prog.set_uniform("u_scale_length","float",[Math.sqrt(2)]),this.I_triangles=i.I_triangles,this.I_triangles.length<65535)this.index_buffer.set_size(2*this.I_triangles.length),this.index_buffer.set_data(0,new Uint16Array(this.I_triangles)),this.prog.draw(this.gl.TRIANGLES,this.index_buffer);else{t=Array.from(this.I_triangles);for(var a=this.I_triangles.length,r=64008,n=[],o=0,_=Math.ceil(a/r);o<_;o++)n.push([]);for(o=0,_=t.length;o<_;o++){var h=t[o]%r;n[l=Math.floor(t[o]/r)].push(h)}var l=0;for(_=n.length;l<_;l++){var g=new Uint16Array(n[l]),u=l*r*4;0!==g.length&&(this.prog.set_attribute("a_position","vec2",i.vbo_position,0,2*u),this.prog.set_attribute("a_tangents","vec4",i.vbo_tangents,0,4*u),this.prog.set_attribute("a_segment","vec2",i.vbo_segment,0,2*u),this.prog.set_attribute("a_angles","vec2",i.vbo_angles,0,2*u),this.prog.set_attribute("a_texcoord","vec2",i.vbo_texcoord,0,2*u),this.index_buffer.set_size(2*g.length),this.index_buffer.set_data(0,g),this.prog.draw(this.gl.TRIANGLES,this.index_buffer))}}},e.prototype._set_data=function(){this._bake(),this.vbo_position.set_size(4*this.V_position.length),this.vbo_position.set_data(0,this.V_position),this.vbo_tangents.set_size(4*this.V_tangents.length),this.vbo_tangents.set_data(0,this.V_tangents),this.vbo_angles.set_size(4*this.V_angles.length),this.vbo_angles.set_data(0,this.V_angles),this.vbo_texcoord.set_size(4*this.V_texcoord.length),this.vbo_texcoord.set_data(0,this.V_texcoord)},e.prototype._set_visuals=function(){var t,e=l.color2rgba(this.glyph.visuals.line.line_color.value(),this.glyph.visuals.line.line_alpha.value()),s=f[this.glyph.visuals.line.line_cap.value()],i=u[this.glyph.visuals.line.line_join.value()];this.prog.set_uniform("u_color","vec4",e),this.prog.set_uniform("u_linewidth","float",[this.glyph.visuals.line.line_width.value()]),this.prog.set_uniform("u_antialias","float",[.9]),this.prog.set_uniform("u_linecaps","vec2",[s,s]),this.prog.set_uniform("u_linejoin","float",[i]),this.prog.set_uniform("u_miter_limit","float",[10]);var a=this.glyph.visuals.line.line_dash.value(),n=0,o=1;a.length&&(n=(t=r.__read(this.dash_atlas.get_atlas_data(a),2))[0],o=t[1]),this.prog.set_uniform("u_dash_index","float",[n]),this.prog.set_uniform("u_dash_phase","float",[this.glyph.visuals.line.line_dash_offset.value()]),this.prog.set_uniform("u_dash_period","float",[o]),this.prog.set_uniform("u_dash_caps","vec2",[s,s]),this.prog.set_uniform("u_closed","float",[0])},e.prototype._bake=function(){for(var t,e,s,i,a,r,n,o,_=this.nvertices,h=this.glyph.sx,l=this.glyph.sy,g=n=new Float32Array(2*_),u=new Float32Array(2*_),f=o=new Float32Array(4*_),v=0,p=_;v<p;v++)g[2*v+0]=h[v],g[2*v+1]=l[v];this.tangents=e=new Float32Array(2*_-2);for(v=0,p=_-1;v<p;v++)e[2*v+0]=n[2*(v+1)+0]-n[2*v+0],e[2*v+1]=n[2*(v+1)+1]-n[2*v+1];for(v=0,p=_-1;v<p;v++)f[4*(v+1)+0]=e[2*v+0],f[4*(v+1)+1]=e[2*v+1],f[4*v+2]=e[2*v+0],f[4*v+3]=e[2*v+1];f[0]=e[0],f[1]=e[1],f[4*(_-1)+2]=e[2*(_-2)+0],f[4*(_-1)+3]=e[2*(_-2)+1];var d=new Float32Array(_);for(v=0,p=_;v<p;v++)d[v]=Math.atan2(o[4*v+0]*o[4*v+3]-o[4*v+1]*o[4*v+2],o[4*v+0]*o[4*v+2]+o[4*v+1]*o[4*v+3]);for(v=0,p=_-1;v<p;v++)u[2*v+0]=d[v],u[2*v+1]=d[v+1];var c=4*_-4;this.V_position=i=new Float32Array(2*c),this.V_angles=s=new Float32Array(2*c),this.V_tangents=a=new Float32Array(4*c),this.V_texcoord=r=new Float32Array(2*c);for(v=0,p=_;v<p;v++)for(var b=0;b<4;b++){for(var w=0;w<2;w++)i[2*(4*v+b-2)+w]=g[2*v+w],s[2*(4*v+b)+w]=u[2*v+w];for(w=0;w<4;w++)a[4*(4*v+b-2)+w]=f[4*v+w]}for(v=0,p=_;v<p;v++)r[2*(4*v+0)+0]=-1,r[2*(4*v+1)+0]=-1,r[2*(4*v+2)+0]=1,r[2*(4*v+3)+0]=1,r[2*(4*v+0)+1]=-1,r[2*(4*v+1)+1]=1,r[2*(4*v+2)+1]=-1,r[2*(4*v+3)+1]=1;var y=6*(_-1);this.I_triangles=t=new Uint32Array(y);for(v=0,p=_;v<p;v++)t[6*v+0]=0+4*v,t[6*v+1]=1+4*v,t[6*v+2]=3+4*v,t[6*v+3]=2+4*v,t[6*v+4]=0+4*v,t[6*v+5]=3+4*v},e.prototype._update_scale=function(t,e){var s,i=this.nvertices,a=4*i-4,r=this.tangents,n=new Float32Array(i-1),o=new Float32Array(2*i);this.V_segment=s=new Float32Array(2*a);for(var _=0,h=i-1;_<h;_++)n[_]=Math.sqrt(Math.pow(r[2*_+0]*t,2)+Math.pow(r[2*_+1]*e,2));var l=0;for(_=0,h=i-1;_<h;_++)l+=n[_],o[2*(_+1)+0]=l,o[2*_+1]=l;for(_=0,h=i;_<h;_++)for(var g=0;g<4;g++)for(var u=0;u<2;u++)s[2*(4*_+g)+u]=o[2*_+u];this.cumsum=l,this.vbo_segment.set_size(4*this.V_segment.length),this.vbo_segment.set_data(0,this.V_segment)},e}(o.BaseGLGlyph);s.LineGL=v,v.__name__="LineGL"},
function _(e,r,f,u,x){u(),x("Program",e(218).Program),x("Texture2d",e(220).Texture2d);var t=e(219);x("IndexBuffer",t.IndexBuffer),x("VertexBuffer",t.VertexBuffer)},
function _(t,e,r,a,i){a();var n=t(1),s=t(219),o=function(){function t(t){this.gl=t,this.UTYPEMAP={float:"uniform1fv",vec2:"uniform2fv",vec3:"uniform3fv",vec4:"uniform4fv",int:"uniform1iv",ivec2:"uniform2iv",ivec3:"uniform3iv",ivec4:"uniform4iv",bool:"uniform1iv",bvec2:"uniform2iv",bvec3:"uniform3iv",bvec4:"uniform4iv",mat2:"uniformMatrix2fv",mat3:"uniformMatrix3fv",mat4:"uniformMatrix4fv",sampler1D:"uniform1i",sampler2D:"uniform1i",sampler3D:"uniform1i"},this.ATYPEMAP={float:"vertexAttrib1f",vec2:"vertexAttrib2f",vec3:"vertexAttrib3f",vec4:"vertexAttrib4f"},this.ATYPEINFO={float:[1,5126],vec2:[2,5126],vec3:[3,5126],vec4:[4,5126]},this._linked=!1,this._validated=!1,this._unset_variables=new Set,this._known_invalid=new Set,this._locations=new Map,this._samplers=new Map,this._attributes=new Map,this.handle=this.gl.createProgram()}return t.prototype.delete=function(){this.gl.deleteProgram(this.handle)},t.prototype.activate=function(){this.gl.useProgram(this.handle)},t.prototype.deactivate=function(){this.gl.useProgram(0)},t.prototype.set_shaders=function(t,e){var r,a,i=this.gl;this._linked=!1;var s=i.createShader(i.VERTEX_SHADER),o=i.createShader(i.FRAGMENT_SHADER),l=[[t,s,"vertex"],[e,o,"fragment"]];try{for(var h=n.__values(l),_=h.next();!_.done;_=h.next()){var v=n.__read(_.value,3),d=v[0],f=v[1],u=v[2];if(i.shaderSource(f,d),i.compileShader(f),!i.getShaderParameter(f,i.COMPILE_STATUS)){var c=i.getShaderInfoLog(f);throw new Error("errors in "+u+" shader:\n"+c)}}}catch(t){r={error:t}}finally{try{_&&!_.done&&(a=h.return)&&a.call(h)}finally{if(r)throw r.error}}if(i.attachShader(this.handle,s),i.attachShader(this.handle,o),i.linkProgram(this.handle),!i.getProgramParameter(this.handle,i.LINK_STATUS)){var g=i.getProgramInfoLog(this.handle);throw new Error("Program link error:\n"+g)}this._unset_variables=this._get_active_attributes_and_uniforms(),i.detachShader(this.handle,s),i.detachShader(this.handle,o),i.deleteShader(s),i.deleteShader(o),this._known_invalid.clear(),this._linked=!0},t.prototype._get_active_attributes_and_uniforms=function(){var t,e,r,a,i,s,o=this.gl;this._locations.clear();var l=new RegExp("(\\w+)\\s*(\\[(\\d+)\\])\\s*"),h=o.getProgramParameter(this.handle,o.ACTIVE_UNIFORMS),_=[],v=[],d=[[_,o.getProgramParameter(this.handle,o.ACTIVE_ATTRIBUTES),o.getActiveAttrib,o.getAttribLocation],[v,h,o.getActiveUniform,o.getUniformLocation]];try{for(var f=n.__values(d),u=f.next();!u.done;u=f.next())for(var c=n.__read(u.value,4),g=c[0],m=c[1],p=c[2],b=c[3],w=0;w<m;w+=1){var y=p.call(o,this.handle,w),A=(k=y.name).match(l);if(null!=A)for(var P=A[1],x=0;x<y.size;x+=1)g.push([P+"["+x+"]",y.type]);else g.push([k,y.type]);this._locations.set(k,b.call(o,this.handle,k))}}catch(e){t={error:e}}finally{try{u&&!u.done&&(e=f.return)&&e.call(f)}finally{if(t)throw t.error}}var E=new Set;try{for(var S=n.__values(_),T=S.next();!T.done;T=S.next()){var k=n.__read(T.value,1)[0];E.add(k)}}catch(t){r={error:t}}finally{try{T&&!T.done&&(a=S.return)&&a.call(S)}finally{if(r)throw r.error}}try{for(var I=n.__values(v),R=I.next();!R.done;R=I.next()){k=n.__read(R.value,1)[0];E.add(k)}}catch(t){i={error:t}}finally{try{R&&!R.done&&(s=I.return)&&s.call(I)}finally{if(i)throw i.error}}return E},t.prototype.set_texture=function(t,e){var r;if(!this._linked)throw new Error("Cannot set uniform when program has no code");var a=null!==(r=this._locations.get(t))&&void 0!==r?r:-1;if(a<0)this._known_invalid.has(t)||(this._known_invalid.add(t),console.log('"Variable '+t+" is not an active texture"));else{this._unset_variables.has(t)&&this._unset_variables.delete(t),this.activate();var i=this._samplers.size;this._samplers.has(t)&&(i=this._samplers.get(t)[2]),this._samplers.set(t,[e._target,e.handle,i]),this.gl.uniform1i(a,i)}},t.prototype.set_uniform=function(t,e,r){var a;if(!this._linked)throw new Error("Cannot set uniform when program has no code");var i=null!==(a=this._locations.get(t))&&void 0!==a?a:-1;if(i<0)this._known_invalid.has(t)||(this._known_invalid.add(t),console.log("Variable "+t+" is not an active uniform"));else{this._unset_variables.has(t)&&this._unset_variables.delete(t);var n=1;if(!e.startsWith("mat")){var s="int"==e||"bool"==e?"float":e.replace(/^ib/,"");n=Math.floor(r.length/this.ATYPEINFO[s][0])}if(n>1)for(var o=0;o<n;o+=1)if(this._unset_variables.has(t+"["+o+"]")){var l=t+"["+o+"]";this._unset_variables.has(l)&&this._unset_variables.delete(l)}var h=this.UTYPEMAP[e];this.activate(),e.startsWith("mat")?this.gl[h](i,!1,r):this.gl[h](i,r)}},t.prototype.set_attribute=function(t,e,r,a,i){var o;if(void 0===a&&(a=0),void 0===i&&(i=0),!this._linked)throw new Error("Cannot set attribute when program has no code");var l=null!==(o=this._locations.get(t))&&void 0!==o?o:-1;if(l<0)this._known_invalid.has(t)||(this._known_invalid.add(t),r instanceof s.VertexBuffer&&i>0||console.log("Variable "+t+" is not an active attribute"));else if(this._unset_variables.has(t)&&this._unset_variables.delete(t),this.activate(),r instanceof s.VertexBuffer){var h=n.__read(this.ATYPEINFO[e],2),_=(v="vertexAttribPointer",[h[0],h[1],!1,a,i]);this._attributes.set(t,[r.handle,l,v,_])}else{var v=this.ATYPEMAP[e];this._attributes.set(t,[null,l,v,r])}},t.prototype._pre_draw=function(){var t,e,r,a;this.activate();try{for(var i=n.__values(this._samplers.values()),s=i.next();!s.done;s=i.next()){var o=n.__read(s.value,3),l=o[0],h=o[1],_=o[2];this.gl.activeTexture(this.gl.TEXTURE0+_),this.gl.bindTexture(l,h)}}catch(e){t={error:e}}finally{try{s&&!s.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}try{for(var v=n.__values(this._attributes.values()),d=v.next();!d.done;d=v.next()){var f=n.__read(d.value,4),u=f[0],c=f[1],g=f[2],m=f[3];null!=u?(this.gl.bindBuffer(this.gl.ARRAY_BUFFER,u),this.gl.enableVertexAttribArray(c),this.gl[g].apply(this.gl,n.__spread([c],m))):(this.gl.bindBuffer(this.gl.ARRAY_BUFFER,null),this.gl.disableVertexAttribArray(c),this.gl[g].apply(this.gl,n.__spread([c],m)))}}catch(t){r={error:t}}finally{try{d&&!d.done&&(a=v.return)&&a.call(v)}finally{if(r)throw r.error}}this._validated||(this._validated=!0,this._validate())},t.prototype._validate=function(){if(this._unset_variables.size&&console.log("Program has unset variables: "+this._unset_variables),this.gl.validateProgram(this.handle),!this.gl.getProgramParameter(this.handle,this.gl.VALIDATE_STATUS))throw console.log(this.gl.getProgramInfoLog(this.handle)),new Error("Program validation error")},t.prototype.draw=function(t,e){if(!this._linked)throw new Error("Cannot draw program if code has not been set");if(e instanceof s.IndexBuffer){this._pre_draw(),e.activate();var r=e.buffer_size/2,a=this.gl.UNSIGNED_SHORT;this.gl.drawElements(t,r,a,0),e.deactivate()}else{var i=n.__read(e,2),o=i[0];0!=(r=i[1])&&(this._pre_draw(),this.gl.drawArrays(t,o,r))}},t}();r.Program=o,o.__name__="Program"},
function _(t,e,i,r,f){r();var n=t(1),a=function(){function t(t){this.gl=t,this._usage=35048,this.buffer_size=0,this.handle=this.gl.createBuffer()}return t.prototype.delete=function(){this.gl.deleteBuffer(this.handle)},t.prototype.activate=function(){this.gl.bindBuffer(this._target,this.handle)},t.prototype.deactivate=function(){this.gl.bindBuffer(this._target,null)},t.prototype.set_size=function(t){t!=this.buffer_size&&(this.activate(),this.gl.bufferData(this._target,t,this._usage),this.buffer_size=t)},t.prototype.set_data=function(t,e){this.activate(),this.gl.bufferSubData(this._target,t,e)},t}();i.Buffer=a,a.__name__="Buffer";var s=function(t){function e(){var e=t.apply(this,n.__spread(arguments))||this;return e._target=34962,e}return n.__extends(e,t),e}(a);i.VertexBuffer=s,s.__name__="VertexBuffer";var u=function(t){function e(){var e=t.apply(this,n.__spread(arguments))||this;return e._target=34963,e}return n.__extends(e,t),e}(a);i.IndexBuffer=u,u.__name__="IndexBuffer"},
function _(t,e,r,i,a){i();var h=t(1),n=t(126),o=function(){function t(t){this.gl=t,this._target=3553,this._types={Int8Array:5120,Uint8Array:5121,Int16Array:5122,Uint16Array:5123,Int32Array:5124,Uint32Array:5125,Float32Array:5126},this.handle=this.gl.createTexture()}return t.prototype.delete=function(){this.gl.deleteTexture(this.handle)},t.prototype.activate=function(){this.gl.bindTexture(this._target,this.handle)},t.prototype.deactivate=function(){this.gl.bindTexture(this._target,0)},t.prototype._get_alignment=function(t){var e,r;try{for(var i=h.__values([4,8,2,1]),a=i.next();!a.done;a=i.next()){var o=a.value;if(t%o==0)return o}}catch(t){e={error:t}}finally{try{a&&!a.done&&(r=i.return)&&r.call(i)}finally{if(e)throw e.error}}n.unreachable()},t.prototype.set_wrapping=function(t,e){this.activate(),this.gl.texParameterf(this._target,this.gl.TEXTURE_WRAP_S,t),this.gl.texParameterf(this._target,this.gl.TEXTURE_WRAP_T,e)},t.prototype.set_interpolation=function(t,e){this.activate(),this.gl.texParameterf(this._target,this.gl.TEXTURE_MIN_FILTER,t),this.gl.texParameterf(this._target,this.gl.TEXTURE_MAG_FILTER,e)},t.prototype.set_size=function(t,e){var r,i,a,n=h.__read(t,2),o=n[0],s=n[1];o==(null===(r=this._shape_format)||void 0===r?void 0:r.width)&&s==(null===(i=this._shape_format)||void 0===i?void 0:i.height)&&e==(null===(a=this._shape_format)||void 0===a?void 0:a.format)||(this._shape_format={width:o,height:s,format:e},this.activate(),this.gl.texImage2D(this._target,0,e,o,s,0,e,this.gl.UNSIGNED_BYTE,null))},t.prototype.set_data=function(t,e,r){var i=h.__read(e,2),a=i[0],n=i[1];this.activate();var o=this._shape_format.format,s=h.__read(t,2),_=s[0],l=s[1],g=this._types[r.constructor.name];if(null==g)throw new Error("Type "+r.constructor.name+" not allowed for texture");var u=this._get_alignment(a);4!=u&&this.gl.pixelStorei(this.gl.UNPACK_ALIGNMENT,u),this.gl.texSubImage2D(this._target,0,_,l,a,n,o,g,r),4!=u&&this.gl.pixelStorei(this.gl.UNPACK_ALIGNMENT,4)},t}();r.Texture2d=o,o.__name__="Texture2d"},
function _(t,e,i,h,n){h();var s=function(){function t(t,e){this.gl=t,this.glyph=e,this.nvertices=0,this.size_changed=!1,this.data_changed=!1,this.visuals_changed=!1,this.init()}return t.prototype.set_data_changed=function(){var t=this.glyph.data_size;t!=this.nvertices&&(this.nvertices=t,this.size_changed=!0),this.data_changed=!0},t.prototype.set_visuals_changed=function(){this.visuals_changed=!0},t.prototype.render=function(t,e,i){if(0==e.length)return!0;var h=this.glyph.renderer.plot_view.canvas_view.webgl.canvas,n=h.width,s=h.height,a={pixel_ratio:this.glyph.renderer.plot_view.canvas_view.pixel_ratio,width:n,height:s};return this.draw(e,i,a),!0},t}();i.BaseGLGlyph=s,s.__name__="BaseGLGlyph"},
function _(n,e,t,a,i){a(),t.vertex_shader="\nprecision mediump float;\n\nconst float PI = 3.14159265358979323846264;\nconst float THETA = 15.0 * 3.14159265358979323846264/180.0;\n\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size, u_offset;\nuniform vec2 u_scale_aspect;\nuniform float u_scale_length;\n\nuniform vec4 u_color;\nuniform float u_antialias;\nuniform float u_length;\nuniform float u_linewidth;\nuniform float u_dash_index;\nuniform float u_closed;\n\nattribute vec2 a_position;\nattribute vec4 a_tangents;\nattribute vec2 a_segment;\nattribute vec2 a_angles;\nattribute vec2 a_texcoord;\n\nvarying vec4  v_color;\nvarying vec2  v_segment;\nvarying vec2  v_angles;\nvarying vec2  v_texcoord;\nvarying vec2  v_miter;\nvarying float v_length;\nvarying float v_linewidth;\n\nfloat cross(in vec2 v1, in vec2 v2)\n{\n    return v1.x*v2.y - v1.y*v2.x;\n}\n\nfloat signed_distance(in vec2 v1, in vec2 v2, in vec2 v3)\n{\n    return cross(v2-v1,v1-v3) / length(v2-v1);\n}\n\nvoid rotate( in vec2 v, in float alpha, out vec2 result )\n{\n    float c = cos(alpha);\n    float s = sin(alpha);\n    result = vec2( c*v.x - s*v.y,\n                   s*v.x + c*v.y );\n}\n\nvoid main()\n{\n    bool closed = (u_closed > 0.0);\n\n    // Attributes and uniforms to varyings\n    v_color = u_color;\n    v_linewidth = u_linewidth;\n    v_segment = a_segment * u_scale_length;\n    v_length = u_length * u_scale_length;\n\n    // Scale to map to pixel coordinates. The original algorithm from the paper\n    // assumed isotropic scale. We obviously do not have this.\n    vec2 abs_scale_aspect = abs(u_scale_aspect);\n    vec2 abs_scale = u_scale_length * abs_scale_aspect;\n\n    // Correct angles for aspect ratio\n    vec2 av;\n    av = vec2(1.0, tan(a_angles.x)) / abs_scale_aspect;\n    v_angles.x = atan(av.y, av.x);\n    av = vec2(1.0, tan(a_angles.y)) / abs_scale_aspect;\n    v_angles.y = atan(av.y, av.x);\n\n    // Thickness below 1 pixel are represented using a 1 pixel thickness\n    // and a modified alpha\n    v_color.a = min(v_linewidth, v_color.a);\n    v_linewidth = max(v_linewidth, 1.0);\n\n    // If color is fully transparent we just will discard the fragment anyway\n    if( v_color.a <= 0.0 ) {\n        gl_Position = vec4(0.0,0.0,0.0,1.0);\n        return;\n    }\n\n    // This is the actual half width of the line\n    float w = ceil(u_antialias+v_linewidth)/2.0;\n\n    vec2 position = a_position;\n\n    vec2 t1 = normalize(a_tangents.xy * abs_scale_aspect);  // note the scaling for aspect ratio here\n    vec2 t2 = normalize(a_tangents.zw * abs_scale_aspect);\n    float u = a_texcoord.x;\n    float v = a_texcoord.y;\n    vec2 o1 = vec2( +t1.y, -t1.x);\n    vec2 o2 = vec2( +t2.y, -t2.x);\n\n    // This is a join\n    // ----------------------------------------------------------------\n    if( t1 != t2 ) {\n        float angle = atan (t1.x*t2.y-t1.y*t2.x, t1.x*t2.x+t1.y*t2.y);  // Angle needs recalculation for some reason\n        vec2 t  = normalize(t1+t2);\n        vec2 o  = vec2( + t.y, - t.x);\n\n        if ( u_dash_index > 0.0 )\n        {\n            // Broken angle\n            // ----------------------------------------------------------------\n            if( (abs(angle) > THETA) ) {\n                position += v * w * o / cos(angle/2.0);\n                float s = sign(angle);\n                if( angle < 0.0 ) {\n                    if( u == +1.0 ) {\n                        u = v_segment.y + v * w * tan(angle/2.0);\n                        if( v == 1.0 ) {\n                            position -= 2.0 * w * t1 / sin(angle);\n                            u -= 2.0 * w / sin(angle);\n                        }\n                    } else {\n                        u = v_segment.x - v * w * tan(angle/2.0);\n                        if( v == 1.0 ) {\n                            position += 2.0 * w * t2 / sin(angle);\n                            u += 2.0*w / sin(angle);\n                        }\n                    }\n                } else {\n                    if( u == +1.0 ) {\n                        u = v_segment.y + v * w * tan(angle/2.0);\n                        if( v == -1.0 ) {\n                            position += 2.0 * w * t1 / sin(angle);\n                            u += 2.0 * w / sin(angle);\n                        }\n                    } else {\n                        u = v_segment.x - v * w * tan(angle/2.0);\n                        if( v == -1.0 ) {\n                            position -= 2.0 * w * t2 / sin(angle);\n                            u -= 2.0*w / sin(angle);\n                        }\n                    }\n                }\n                // Continuous angle\n                // ------------------------------------------------------------\n            } else {\n                position += v * w * o / cos(angle/2.0);\n                if( u == +1.0 ) u = v_segment.y;\n                else            u = v_segment.x;\n            }\n        }\n\n        // Solid line\n        // --------------------------------------------------------------------\n        else\n        {\n            position.xy += v * w * o / cos(angle/2.0);\n            if( angle < 0.0 ) {\n                if( u == +1.0 ) {\n                    u = v_segment.y + v * w * tan(angle/2.0);\n                } else {\n                    u = v_segment.x - v * w * tan(angle/2.0);\n                }\n            } else {\n                if( u == +1.0 ) {\n                    u = v_segment.y + v * w * tan(angle/2.0);\n                } else {\n                    u = v_segment.x - v * w * tan(angle/2.0);\n                }\n            }\n        }\n\n    // This is a line start or end (t1 == t2)\n    // ------------------------------------------------------------------------\n    } else {\n        position += v * w * o1;\n        if( u == -1.0 ) {\n            u = v_segment.x - w;\n            position -= w * t1;\n        } else {\n            u = v_segment.y + w;\n            position += w * t2;\n        }\n    }\n\n    // Miter distance\n    // ------------------------------------------------------------------------\n    vec2 t;\n    vec2 curr = a_position * abs_scale;\n    if( a_texcoord.x < 0.0 ) {\n        vec2 next = curr + t2*(v_segment.y-v_segment.x);\n\n        rotate( t1, +v_angles.x/2.0, t);\n        v_miter.x = signed_distance(curr, curr+t, position);\n\n        rotate( t2, +v_angles.y/2.0, t);\n        v_miter.y = signed_distance(next, next+t, position);\n    } else {\n        vec2 prev = curr - t1*(v_segment.y-v_segment.x);\n\n        rotate( t1, -v_angles.x/2.0,t);\n        v_miter.x = signed_distance(prev, prev+t, position);\n\n        rotate( t2, -v_angles.y/2.0,t);\n        v_miter.y = signed_distance(curr, curr+t, position);\n    }\n\n    if (!closed && v_segment.x <= 0.0) {\n        v_miter.x = 1e10;\n    }\n    if (!closed && v_segment.y >= v_length)\n    {\n        v_miter.y = 1e10;\n    }\n\n    v_texcoord = vec2( u, v*w );\n\n    // Calculate position in device coordinates. Note that we\n    // already scaled with abs scale above.\n    vec2 normpos = position * sign(u_scale_aspect);\n    normpos += 0.5;  // make up for Bokeh's offset\n    normpos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(normpos*2.0-1.0, 0.0, 1.0);\n    gl_Position.y *= -1.0;\n}\n"},
function _(n,t,e,s,a){s(),e.fragment_shader="\nprecision mediump float;\n\nconst float PI = 3.14159265358979323846264;\nconst float THETA = 15.0 * 3.14159265358979323846264/180.0;\n\nuniform sampler2D u_dash_atlas;\n\nuniform vec2 u_linecaps;\nuniform float u_miter_limit;\nuniform float u_linejoin;\nuniform float u_antialias;\nuniform float u_dash_phase;\nuniform float u_dash_period;\nuniform float u_dash_index;\nuniform vec2 u_dash_caps;\nuniform float u_closed;\n\nvarying vec4  v_color;\nvarying vec2  v_segment;\nvarying vec2  v_angles;\nvarying vec2  v_texcoord;\nvarying vec2  v_miter;\nvarying float v_length;\nvarying float v_linewidth;\n\n// Compute distance to cap ----------------------------------------------------\nfloat cap( int type, float dx, float dy, float t, float linewidth )\n{\n    float d = 0.0;\n    dx = abs(dx);\n    dy = abs(dy);\n    if      (type == 0)  discard;  // None\n    else if (type == 1)  d = sqrt(dx*dx+dy*dy);  // Round\n    else if (type == 3)  d = (dx+abs(dy));  // Triangle in\n    else if (type == 2)  d = max(abs(dy),(t+dx-abs(dy)));  // Triangle out\n    else if (type == 4)  d = max(dx,dy);  // Square\n    else if (type == 5)  d = max(dx+t,dy);  // Butt\n    return d;\n}\n\n// Compute distance to join -------------------------------------------------\nfloat join( in int type, in float d, in vec2 segment, in vec2 texcoord, in vec2 miter,\n           in float linewidth )\n{\n    // texcoord.x is distance from start\n    // texcoord.y is distance from centerline\n    // segment.x and y indicate the limits (as for texcoord.x) for this segment\n\n    float dx = texcoord.x;\n\n    // Round join\n    if( type == 1 ) {\n        if (dx < segment.x) {\n            d = max(d,length( texcoord - vec2(segment.x,0.0)));\n            //d = length( texcoord - vec2(segment.x,0.0));\n        } else if (dx > segment.y) {\n            d = max(d,length( texcoord - vec2(segment.y,0.0)));\n            //d = length( texcoord - vec2(segment.y,0.0));\n        }\n    }\n    // Bevel join\n    else if ( type == 2 ) {\n        if (dx < segment.x) {\n            vec2 x = texcoord - vec2(segment.x,0.0);\n            d = max(d, max(abs(x.x), abs(x.y)));\n\n        } else if (dx > segment.y) {\n            vec2 x = texcoord - vec2(segment.y,0.0);\n            d = max(d, max(abs(x.x), abs(x.y)));\n        }\n        /*  Original code for bevel which does not work for us\n        if( (dx < segment.x) ||  (dx > segment.y) )\n            d = max(d, min(abs(x.x),abs(x.y)));\n        */\n    }\n\n    return d;\n}\n\nvoid main()\n{\n    // If color is fully transparent we just discard the fragment\n    if( v_color.a <= 0.0 ) {\n        discard;\n    }\n\n    // Test if dash pattern is the solid one (0)\n    bool solid =  (u_dash_index == 0.0);\n\n    // Test if path is closed\n    bool closed = (u_closed > 0.0);\n\n    vec4 color = v_color;\n    float dx = v_texcoord.x;\n    float dy = v_texcoord.y;\n    float t = v_linewidth/2.0-u_antialias;\n    float width = 1.0;  //v_linewidth; original code had dashes scale with line width, we do not\n    float d = 0.0;\n\n    vec2 linecaps = u_linecaps;\n    vec2 dash_caps = u_dash_caps;\n    float line_start = 0.0;\n    float line_stop = v_length;\n\n    // Apply miter limit; fragments too far into the miter are simply discarded\n    if( (dx < v_segment.x) || (dx > v_segment.y) ) {\n        float into_miter = max(v_segment.x - dx, dx - v_segment.y);\n        if (into_miter > u_miter_limit*v_linewidth/2.0)\n          discard;\n    }\n\n    // Solid line --------------------------------------------------------------\n    if( solid ) {\n        d = abs(dy);\n        if( (!closed) && (dx < line_start) ) {\n            d = cap( int(u_linecaps.x), abs(dx), abs(dy), t, v_linewidth );\n        }\n        else if( (!closed) &&  (dx > line_stop) ) {\n            d = cap( int(u_linecaps.y), abs(dx)-line_stop, abs(dy), t, v_linewidth );\n        }\n        else {\n            d = join( int(u_linejoin), abs(dy), v_segment, v_texcoord, v_miter, v_linewidth );\n        }\n\n    // Dash line --------------------------------------------------------------\n    } else {\n        float segment_start = v_segment.x;\n        float segment_stop  = v_segment.y;\n        float segment_center= (segment_start+segment_stop)/2.0;\n        float freq          = u_dash_period*width;\n        float u = mod( dx + u_dash_phase*width, freq);\n        vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n        float dash_center= tex.x * width;\n        float dash_type  = tex.y;\n        float _start = tex.z * width;\n        float _stop  = tex.a * width;\n        float dash_start = dx - u + _start;\n        float dash_stop  = dx - u + _stop;\n\n        // Compute extents of the first dash (the one relative to v_segment.x)\n        // Note: this could be computed in the vertex shader\n        if( (dash_stop < segment_start) && (dash_caps.x != 5.0) ) {\n            float u = mod(segment_start + u_dash_phase*width, freq);\n            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n            dash_center= tex.x * width;\n            //dash_type  = tex.y;\n            float _start = tex.z * width;\n            float _stop  = tex.a * width;\n            dash_start = segment_start - u + _start;\n            dash_stop = segment_start - u + _stop;\n        }\n\n        // Compute extents of the last dash (the one relatives to v_segment.y)\n        // Note: This could be computed in the vertex shader\n        else if( (dash_start > segment_stop)  && (dash_caps.y != 5.0) ) {\n            float u = mod(segment_stop + u_dash_phase*width, freq);\n            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n            dash_center= tex.x * width;\n            //dash_type  = tex.y;\n            float _start = tex.z * width;\n            float _stop  = tex.a * width;\n            dash_start = segment_stop - u + _start;\n            dash_stop  = segment_stop - u + _stop;\n        }\n\n        // This test if the we are dealing with a discontinuous angle\n        bool discontinuous = ((dx <  segment_center) && abs(v_angles.x) > THETA) ||\n                             ((dx >= segment_center) && abs(v_angles.y) > THETA);\n        //if( dx < line_start) discontinuous = false;\n        //if( dx > line_stop)  discontinuous = false;\n\n        float d_join = join( int(u_linejoin), abs(dy),\n                            v_segment, v_texcoord, v_miter, v_linewidth );\n\n        // When path is closed, we do not have room for linecaps, so we make room\n        // by shortening the total length\n        if (closed) {\n             line_start += v_linewidth/2.0;\n             line_stop  -= v_linewidth/2.0;\n        }\n\n        // We also need to take antialias area into account\n        //line_start += u_antialias;\n        //line_stop  -= u_antialias;\n\n        // Check is dash stop is before line start\n        if( dash_stop <= line_start ) {\n            discard;\n        }\n        // Check is dash start is beyond line stop\n        if( dash_start >= line_stop ) {\n            discard;\n        }\n\n        // Check if current dash start is beyond segment stop\n        if( discontinuous ) {\n            // Dash start is beyond segment, we discard\n            if( (dash_start > segment_stop) ) {\n                discard;\n                //gl_FragColor = vec4(1.0,0.0,0.0,.25); return;\n            }\n\n            // Dash stop is before segment, we discard\n            if( (dash_stop < segment_start) ) {\n                discard;  //gl_FragColor = vec4(0.0,1.0,0.0,.25); return;\n            }\n\n            // Special case for round caps (nicer with this)\n            if( dash_caps.x == 1.0 ) {\n                if( (u > _stop) && (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0)) {\n                    discard;\n                }\n            }\n\n            // Special case for round caps  (nicer with this)\n            if( dash_caps.y == 1.0 ) {\n                if( (u < _start) && (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0)) {\n                    discard;\n                }\n            }\n\n            // Special case for triangle caps (in & out) and square\n            // We make sure the cap stop at crossing frontier\n            if( (dash_caps.x != 1.0) && (dash_caps.x != 5.0) ) {\n                if( (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0) ) {\n                    float a = v_angles.x/2.0;\n                    float x = (segment_start-dx)*cos(a) - dy*sin(a);\n                    float y = (segment_start-dx)*sin(a) + dy*cos(a);\n                    if( x > 0.0 ) discard;\n                    // We transform the cap into square to avoid holes\n                    dash_caps.x = 4.0;\n                }\n            }\n\n            // Special case for triangle caps (in & out) and square\n            // We make sure the cap stop at crossing frontier\n            if( (dash_caps.y != 1.0) && (dash_caps.y != 5.0) ) {\n                if( (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0) ) {\n                    float a = v_angles.y/2.0;\n                    float x = (dx-segment_stop)*cos(a) - dy*sin(a);\n                    float y = (dx-segment_stop)*sin(a) + dy*cos(a);\n                    if( x > 0.0 ) discard;\n                    // We transform the caps into square to avoid holes\n                    dash_caps.y = 4.0;\n                }\n            }\n        }\n\n        // Line cap at start\n        if( (dx < line_start) && (dash_start < line_start) && (dash_stop > line_start) ) {\n            d = cap( int(linecaps.x), dx-line_start, dy, t, v_linewidth);\n        }\n        // Line cap at stop\n        else if( (dx > line_stop) && (dash_stop > line_stop) && (dash_start < line_stop) ) {\n            d = cap( int(linecaps.y), dx-line_stop, dy, t, v_linewidth);\n        }\n        // Dash cap left - dash_type = -1, 0 or 1, but there may be roundoff errors\n        else if( dash_type < -0.5 ) {\n            d = cap( int(dash_caps.y), abs(u-dash_center), dy, t, v_linewidth);\n            if( (dx > line_start) && (dx < line_stop) )\n                d = max(d,d_join);\n        }\n        // Dash cap right\n        else if( dash_type > 0.5 ) {\n            d = cap( int(dash_caps.x), abs(dash_center-u), dy, t, v_linewidth);\n            if( (dx > line_start) && (dx < line_stop) )\n                d = max(d,d_join);\n        }\n        // Dash body (plain)\n        else {// if( dash_type > -0.5 &&  dash_type < 0.5) {\n            d = abs(dy);\n        }\n\n        // Line join\n        if( (dx > line_start) && (dx < line_stop)) {\n            if( (dx <= segment_start) && (dash_start <= segment_start)\n                && (dash_stop >= segment_start) ) {\n                d = d_join;\n                // Antialias at outer border\n                float angle = PI/2.+v_angles.x;\n                float f = abs( (segment_start - dx)*cos(angle) - dy*sin(angle));\n                d = max(f,d);\n            }\n            else if( (dx > segment_stop) && (dash_start <= segment_stop)\n                     && (dash_stop >= segment_stop) ) {\n                d = d_join;\n                // Antialias at outer border\n                float angle = PI/2.+v_angles.y;\n                float f = abs((dx - segment_stop)*cos(angle) - dy*sin(angle));\n                d = max(f,d);\n            }\n            else if( dx < (segment_start - v_linewidth/2.)) {\n                discard;\n            }\n            else if( dx > (segment_stop + v_linewidth/2.)) {\n                discard;\n            }\n        }\n        else if( dx < (segment_start - v_linewidth/2.)) {\n            discard;\n        }\n        else if( dx > (segment_stop + v_linewidth/2.)) {\n            discard;\n        }\n    }\n\n    // Distance to border ------------------------------------------------------\n    d = d - t;\n    if( d < 0.0 ) {\n        gl_FragColor = color;\n    } else {\n        d /= u_antialias;\n        gl_FragColor = vec4(color.rgb, exp(-d*d)*color.a);\n    }\n}\n"},
function _(t,i,e,n,r){n();var o=t(1),l=t(213),s=t(214),a=o.__importStar(t(215)),_=o.__importStar(t(143)),h=t(202),u=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(i,t),i.prototype._inner_loop=function(t,i,e,n,r){var l,s;try{for(var a=o.__values(i),_=a.next();!_.done;_=a.next()){var h=_.value;0!=h?isNaN(e[h]+n[h])?(t.closePath(),r.apply(t),t.beginPath()):t.lineTo(e[h],n[h]):(t.beginPath(),t.moveTo(e[h],n[h]))}}catch(t){l={error:t}}finally{try{_&&!_.done&&(s=a.return)&&s.call(a)}finally{if(l)throw l.error}}t.closePath(),r.call(t)},i.prototype._render=function(t,i,e){var n=this,r=e.sx,o=e.sy;this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner_loop(t,i,r,o,t.fill)),this.visuals.hatch.doit2(t,0,(function(){return n._inner_loop(t,i,r,o,t.fill)}),(function(){return n.renderer.request_render()})),this.visuals.line.doit&&(this.visuals.line.set_value(t),this._inner_loop(t,i,r,o,t.stroke))},i.prototype.draw_legend_for_index=function(t,i,e){s.generic_area_legend(this.visuals,t,i,e)},i.prototype._hit_point=function(t){var i=new h.Selection;return a.point_in_poly(t.sx,t.sy,this.sx,this.sy)&&(i.add_to_selected_glyphs(this.model),i.view=this),i},i}(l.XYGlyphView);e.PatchView=u,u.__name__="PatchView";var c=function(t){function i(i){return t.call(this,i)||this}return o.__extends(i,t),i.init_Patch=function(){this.prototype.default_view=u,this.mixins([_.Line,_.Fill,_.Hatch])},i}(l.XYGlyph);e.Patch=c,c.__name__="Patch",c.init_Patch()},
function _(t,e,i,n,r){n();var s=t(1),o=t(139),a=t(226),_=s.__importStar(t(215)),h=s.__importStar(t(133)),l=t(202),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype._index_data=function(t){for(var e=Math.min,i=Math.max,n=this.data_size,r=0;r<n;r++){var s=this._x1[r],o=this._x2[r],a=this._y[r];isNaN(s+o+a)||!isFinite(s+o+a)?t.add_empty():t.add(e(s,o),a,i(s,o),a)}},e.prototype._inner=function(t,e,i,n,r){t.beginPath();for(var s=0,o=e.length;s<o;s++)t.lineTo(e[s],n[s]);for(s=i.length-1;s>=0;s--)t.lineTo(i[s],n[s]);t.closePath(),r.call(t)},e.prototype._render=function(t,e,i){var n=this,r=i.sx1,s=i.sx2,o=i.sy;this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner(t,r,s,o,t.fill)),this.visuals.hatch.doit2(t,0,(function(){return n._inner(t,r,s,o,t.fill)}),(function(){return n.renderer.request_render()}))},e.prototype._hit_point=function(t){for(var e=this.sy.length,i=new o.NumberArray(2*e),n=new o.NumberArray(2*e),r=0,s=e;r<s;r++)i[r]=this.sx1[r],n[r]=this.sy[r],i[e+r]=this.sx2[e-r-1],n[e+r]=this.sy[e-r-1];var a=new l.Selection;return _.point_in_poly(t.sx,t.sy,i,n)&&(a.add_to_selected_glyphs(this.model),a.view=this),a},e.prototype.scenterxy=function(t){return[(this.sx1[t]+this.sx2[t])/2,this.sy[t]]},e.prototype._map_data=function(){this.sx1=this.renderer.xscale.v_compute(this._x1),this.sx2=this.renderer.xscale.v_compute(this._x2),this.sy=this.renderer.yscale.v_compute(this._y)},e}(a.AreaView);i.HAreaView=u,u.__name__="HAreaView";var c=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_HArea=function(){this.prototype.default_view=u,this.define((function(t){return{x1:[h.XCoordinateSpec,{field:"x1"}],x2:[h.XCoordinateSpec,{field:"x2"}],y:[h.YCoordinateSpec,{field:"y"}]}}))},e}(a.Area);i.HArea=c,c.__name__="HArea",c.init_HArea()},
function _(n,e,i,t,r){t();var _=n(1),a=n(203),u=n(214),l=_.__importStar(n(143)),o=function(n){function e(){return null!==n&&n.apply(this,arguments)||this}return _.__extends(e,n),e.prototype.draw_legend_for_index=function(n,e,i){u.generic_area_legend(this.visuals,n,e,i)},e}(a.GlyphView);i.AreaView=o,o.__name__="AreaView";var c=function(n){function e(e){return n.call(this,e)||this}return _.__extends(e,n),e.init_Area=function(){this.mixins([l.Fill,l.HatchVector])},e}(a.Glyph);i.Area=c,c.__name__="Area",c.init_Area()},
function _(t,e,i,n,r){n();var s=t(1),o=t(139),a=t(226),_=s.__importStar(t(215)),h=s.__importStar(t(133)),l=t(202),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype._index_data=function(t){for(var e=Math.min,i=Math.max,n=this.data_size,r=0;r<n;r++){var s=this._x[r],o=this._y1[r],a=this._y2[r];isNaN(s+o+a)||!isFinite(s+o+a)?t.add_empty():t.add(s,e(o,a),s,i(o,a))}},e.prototype._inner=function(t,e,i,n,r){t.beginPath();for(var s=0,o=i.length;s<o;s++)t.lineTo(e[s],i[s]);for(s=n.length-1;s>=0;s--)t.lineTo(e[s],n[s]);t.closePath(),r.call(t)},e.prototype._render=function(t,e,i){var n=this,r=i.sx,s=i.sy1,o=i.sy2;this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner(t,r,s,o,t.fill)),this.visuals.hatch.doit2(t,0,(function(){return n._inner(t,r,s,o,t.fill)}),(function(){return n.renderer.request_render()}))},e.prototype.scenterxy=function(t){return[this.sx[t],(this.sy1[t]+this.sy2[t])/2]},e.prototype._hit_point=function(t){for(var e=this.sx.length,i=new o.NumberArray(2*e),n=new o.NumberArray(2*e),r=0,s=e;r<s;r++)i[r]=this.sx[r],n[r]=this.sy1[r],i[e+r]=this.sx[e-r-1],n[e+r]=this.sy2[e-r-1];var a=new l.Selection;return _.point_in_poly(t.sx,t.sy,i,n)&&(a.add_to_selected_glyphs(this.model),a.view=this),a},e.prototype._map_data=function(){this.sx=this.renderer.xscale.v_compute(this._x),this.sy1=this.renderer.yscale.v_compute(this._y1),this.sy2=this.renderer.yscale.v_compute(this._y2)},e}(a.AreaView);i.VAreaView=u,u.__name__="VAreaView";var y=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_VArea=function(){this.prototype.default_view=u,this.define((function(t){return{x:[h.XCoordinateSpec,{field:"x"}],y1:[h.YCoordinateSpec,{field:"y1"}],y2:[h.YCoordinateSpec,{field:"y2"}]}}))},e}(a.Area);i.VArea=y,y.__name__="VArea",y.init_VArea()},
function _(t,n,e,i,c){i();var s=t(1),r=t(196),o=t(202),u=t(139),a=t(229),l=t(200),_=function(t){function n(n){return t.call(this,n)||this}return s.__extends(n,t),n.init_CDSView=function(){this.define((function(t){var n=t.Array,e=t.Ref;return{filters:[n(e(a.Filter)),[]],source:[e(l.ColumnarDataSource)]}})),this.internal((function(t){var n=t.Int,e=t.Dict,i=t.Ref,c=t.Nullable;return{indices:[i(u.Indices)],indices_map:[e(n),{}],masked:[c(i(u.Indices)),null]}}))},n.prototype.initialize=function(){t.prototype.initialize.call(this),this.compute_indices()},n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this),this.connect(this.properties.filters.change,(function(){return n.compute_indices()}));var e=function(){var t=function(){return n.compute_indices()};null!=n.source&&(n.connect(n.source.change,t),n.source instanceof l.ColumnarDataSource&&(n.connect(n.source.streaming,t),n.connect(n.source.patching,t)))},i=null!=this.source;i?e():this.connect(this.properties.source.change,(function(){i||(e(),i=!0)}))},n.prototype.compute_indices=function(){var t,n,e,i=this.source;if(null!=i){var c=null!==(e=i.get_length())&&void 0!==e?e:1,r=u.Indices.all_set(c);try{for(var o=s.__values(this.filters),a=o.next();!a.done;a=o.next()){var l=a.value;r.intersect(l.compute_indices(i))}}catch(n){t={error:n}}finally{try{a&&!a.done&&(n=o.return)&&n.call(o)}finally{if(t)throw t.error}}this.indices=r,this._indices=s.__spread(r),this.indices_map_to_subset()}},n.prototype.indices_map_to_subset=function(){this.indices_map={};for(var t=0;t<this._indices.length;t++)this.indices_map[this._indices[t]]=t},n.prototype.convert_selection_from_subset=function(t){var n=this,e=t.indices.map((function(t){return n._indices[t]}));return new o.Selection(Object.assign(Object.assign({},t.attributes),{indices:e}))},n.prototype.convert_selection_to_subset=function(t){var n=this,e=t.indices.map((function(t){return n.indices_map[t]}));return new o.Selection(Object.assign(Object.assign({},t.attributes),{indices:e}))},n.prototype.convert_indices_from_subset=function(t){var n=this;return t.map((function(t){return n._indices[t]}))},n}(r.Model);e.CDSView=_,_.__name__="CDSView",_.init_CDSView()},
function _(n,t,e,i,r){i();var _=n(1),l=function(n){function t(t){return n.call(this,t)||this}return _.__extends(t,n),t}(n(196).Model);e.Filter=l,l.__name__="Filter"},
function _(e,r,n,t,a){t();var i=e(1),l=e(124);function o(e,r,n){return i.__awaiter(this,void 0,void 0,(function(){var t;return i.__generator(this,(function(a){switch(a.label){case 0:return(t=new e(Object.assign(Object.assign({},n),{model:r}))).initialize(),[4,t.lazy_initialize()];case 1:return a.sent(),[2,t]}}))}))}n.build_view=function(e,r,n){return void 0===r&&(r={parent:null}),void 0===n&&(n=function(e){return e.default_view}),i.__awaiter(this,void 0,void 0,(function(){var t;return i.__generator(this,(function(a){switch(a.label){case 0:return[4,o(n(e),e,r)];case 1:return(t=a.sent()).connect_signals(),[2,t]}}))}))},n.build_views=function(e,r,n,t){return void 0===n&&(n={parent:null}),void 0===t&&(t=function(e){return e.default_view}),i.__awaiter(this,void 0,void 0,(function(){var a,u,c,s,f,v,_,d,h,y,w,b,g,x,p,m,z,j;return i.__generator(this,(function(O){switch(O.label){case 0:a=l.difference(i.__spread(e.keys()),r);try{for(u=i.__values(a),c=u.next();!c.done;c=u.next())d=c.value,e.get(d).remove(),e.delete(d)}catch(e){g={error:e}}finally{try{c&&!c.done&&(x=u.return)&&x.call(u)}finally{if(g)throw g.error}}s=[],f=r.filter((function(r){return!e.has(r)})),O.label=1;case 1:O.trys.push([1,6,7,8]),v=i.__values(f),_=v.next(),O.label=2;case 2:return _.done?[3,5]:(d=_.value,[4,o(t(d),d,n)]);case 3:b=O.sent(),e.set(d,b),s.push(b),O.label=4;case 4:return _=v.next(),[3,2];case 5:return[3,8];case 6:return h=O.sent(),p={error:h},[3,8];case 7:try{_&&!_.done&&(m=v.return)&&m.call(v)}finally{if(p)throw p.error}return[7];case 8:try{for(y=i.__values(s),w=y.next();!w.done;w=y.next())(b=w.value).connect_signals()}catch(e){z={error:e}}finally{try{w&&!w.done&&(j=y.return)&&j.call(y)}finally{if(z)throw z.error}}return[2,s]}}))}))},n.remove_views=function(e){var r,n;try{for(var t=i.__values(e),a=t.next();!a.done;a=t.next()){var l=i.__read(a.value,2),o=l[0];l[1].remove(),e.delete(o)}}catch(e){r={error:e}}finally{try{a&&!a.done&&(n=t.return)&&n.call(t)}finally{if(r)throw r.error}}}},
function _(e,r,t,n,i){n();var o=e(1),l=e(211),a=e(210),p=e(232),s=e(233),_=e(230),d=e(213),u=e(234),h=e(235),c=e(126),y=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(r,e),Object.defineProperty(r.prototype,"glyph_view",{get:function(){return this.node_view.glyph},enumerable:!1,configurable:!0}),r.prototype.lazy_initialize=function(){return o.__awaiter(this,void 0,void 0,(function(){var r,t,n,i,l,a,p,s,y,v,g,f,w;return o.__generator(this,(function(m){switch(m.label){case 0:return[4,e.prototype.lazy_initialize.call(this)];case 1:if(m.sent(),r=this.model,t=null,n=null,i={v_compute:function(e){return c.assert(null==t),o.__read(t=r.layout_provider.get_edge_coordinates(e),1)[0]}},l={v_compute:function(e){c.assert(null!=t);var r=o.__read(t,2)[1];return t=null,r}},a={v_compute:function(e){return c.assert(null==n),o.__read(n=r.layout_provider.get_node_coordinates(e),1)[0]}},p={v_compute:function(e){c.assert(null!=n);var r=o.__read(n,2)[1];return n=null,r}},s=this.model,y=s.edge_renderer,v=s.node_renderer,!(y.glyph instanceof u.MultiLine||y.glyph instanceof h.Patches))throw new Error(this+".edge_renderer.glyph must be a MultiLine glyph");if(!(v.glyph instanceof d.XYGlyph))throw new Error(this+".node_renderer.glyph must be a XYGlyph glyph");return y.glyph.properties.xs.internal=!0,y.glyph.properties.ys.internal=!0,v.glyph.properties.x.internal=!0,v.glyph.properties.y.internal=!0,y.glyph.xs={expr:i},y.glyph.ys={expr:l},v.glyph.x={expr:a},v.glyph.y={expr:p},g=this.parent,f=this,[4,_.build_view(y,{parent:g})];case 2:return f.edge_view=m.sent(),w=this,[4,_.build_view(v,{parent:g})];case 3:return w.node_view=m.sent(),[2]}}))}))},r.prototype.connect_signals=function(){var r=this;e.prototype.connect_signals.call(this),this.connect(this.model.layout_provider.change,(function(){r.edge_view.set_data(!1),r.node_view.set_data(!1),r.request_render()}))},r.prototype.remove=function(){this.edge_view.remove(),this.node_view.remove(),e.prototype.remove.call(this)},r.prototype._render=function(){this.edge_view.render(),this.node_view.render()},r.prototype.renderer_view=function(r){if(r instanceof a.GlyphRenderer){if(r==this.edge_view.model)return this.edge_view;if(r==this.node_view.model)return this.node_view}return e.prototype.renderer_view.call(this,r)},r}(l.DataRendererView);t.GraphRendererView=y,y.__name__="GraphRendererView";var v=function(e){function r(r){return e.call(this,r)||this}return o.__extends(r,e),r.init_GraphRenderer=function(){this.prototype.default_view=y,this.define((function(e){var r=e.Ref;return{layout_provider:[r(p.LayoutProvider)],node_renderer:[r(a.GlyphRenderer)],edge_renderer:[r(a.GlyphRenderer)],selection_policy:[r(s.GraphHitTestPolicy),function(){return new s.NodesOnly}],inspection_policy:[r(s.GraphHitTestPolicy),function(){return new s.NodesOnly}]}}))},r.prototype.get_selection_manager=function(){return this.node_renderer.data_source.selection_manager},r}(l.DataRenderer);t.GraphRenderer=v,v.__name__="GraphRenderer",v.init_GraphRenderer()},
function _(n,t,r,e,o){e();var i=n(1),u=function(n){function t(t){return n.call(this,t)||this}return i.__extends(t,n),t}(n(196).Model);r.LayoutProvider=u,u.__name__="LayoutProvider"},
function _(e,t,n,r,o){r();var d=e(1),i=e(196),_=e(127),s=e(124),a=e(202),c=function(e){function t(t){return e.call(this,t)||this}return d.__extends(t,e),t.prototype._hit_test_nodes=function(e,t){if(!t.model.visible)return null;var n=t.node_view.glyph.hit_test(e);return null==n?null:t.node_view.model.view.convert_selection_from_subset(n)},t.prototype._hit_test_edges=function(e,t){if(!t.model.visible)return null;var n=t.edge_view.glyph.hit_test(e);return null==n?null:t.edge_view.model.view.convert_selection_from_subset(n)},t}(i.Model);n.GraphHitTestPolicy=c,c.__name__="GraphHitTestPolicy";var l=function(e){function t(t){return e.call(this,t)||this}return d.__extends(t,e),t.prototype.hit_test=function(e,t){return this._hit_test_nodes(e,t)},t.prototype.do_selection=function(e,t,n,r){if(null==e)return!1;var o=t.node_renderer.data_source.selected;return o.update(e,n,r),t.node_renderer.data_source._select.emit(),!o.is_empty()},t.prototype.do_inspection=function(e,t,n,r,o){if(null==e)return!1;var d=n.model.get_selection_manager().get_or_create_inspector(n.node_view.model);return d.update(e,r,o),n.node_view.model.data_source.setv({inspected:d},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view.model,{geometry:t}]),!d.is_empty()},t}(c);n.NodesOnly=l,l.__name__="NodesOnly";var u=function(e){function t(t){return e.call(this,t)||this}return d.__extends(t,e),t.prototype.hit_test=function(e,t){return this._hit_test_nodes(e,t)},t.prototype.get_linked_edges=function(e,t,n){var r,o,i=[];"selection"==n?i=e.selected.indices.map((function(t){return e.data.index[t]})):"inspection"==n&&(i=e.inspected.indices.map((function(t){return e.data.index[t]})));for(var _=[],c=0;c<t.data.start.length;c++)(s.contains(i,t.data.start[c])||s.contains(i,t.data.end[c]))&&_.push(c);var l=new a.Selection;try{for(var u=d.__values(_),p=u.next();!p.done;p=u.next()){c=p.value;l.multiline_indices[c]=[0]}}catch(e){r={error:e}}finally{try{p&&!p.done&&(o=u.return)&&o.call(u)}finally{if(r)throw r.error}}return l.indices=_,l},t.prototype.do_selection=function(e,t,n,r){if(null==e)return!1;var o=t.node_renderer.data_source.selected;o.update(e,n,r);var d=t.edge_renderer.data_source.selected,i=this.get_linked_edges(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return d.update(i,n,r),t.node_renderer.data_source._select.emit(),!o.is_empty()},t.prototype.do_inspection=function(e,t,n,r,o){if(null==e)return!1;var d=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model);d.update(e,r,o),n.node_view.model.data_source.setv({inspected:d},{silent:!0});var i=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model),_=this.get_linked_edges(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return i.update(_,r,o),n.edge_view.model.data_source.setv({inspected:i},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view.model,{geometry:t}]),!d.is_empty()},t}(c);n.NodesAndLinkedEdges=u,u.__name__="NodesAndLinkedEdges";var p=function(e){function t(t){return e.call(this,t)||this}return d.__extends(t,e),t.prototype.hit_test=function(e,t){return this._hit_test_edges(e,t)},t.prototype.get_linked_nodes=function(e,t,n){var r,o,i=[];"selection"==n?i=t.selected.indices:"inspection"==n&&(i=t.inspected.indices);var c=[];try{for(var l=d.__values(i),u=l.next();!u.done;u=l.next()){var p=u.value;c.push(t.data.start[p]),c.push(t.data.end[p])}}catch(e){r={error:e}}finally{try{u&&!u.done&&(o=l.return)&&o.call(l)}finally{if(r)throw r.error}}var v=s.uniq(c).map((function(t){return _.indexOf(e.data.index,t)}));return new a.Selection({indices:v})},t.prototype.do_selection=function(e,t,n,r){if(null==e)return!1;var o=t.edge_renderer.data_source.selected;o.update(e,n,r);var d=t.node_renderer.data_source.selected,i=this.get_linked_nodes(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return d.update(i,n,r),t.edge_renderer.data_source._select.emit(),!o.is_empty()},t.prototype.do_inspection=function(e,t,n,r,o){if(null==e)return!1;var d=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model);d.update(e,r,o),n.edge_view.model.data_source.setv({inspected:d},{silent:!0});var i=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model),_=this.get_linked_nodes(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return i.update(_,r,o),n.node_view.model.data_source.setv({inspected:i},{silent:!0}),n.edge_view.model.data_source.inspect.emit([n.edge_view.model,{geometry:t}]),!d.is_empty()},t}(c);n.EdgesAndLinkedNodes=p,p.__name__="EdgesAndLinkedNodes"},
function _(e,t,i,n,r){n();var s=e(1),o=e(152),a=e(143),_=s.__importStar(e(215)),l=s.__importStar(e(133)),h=e(127),c=e(128),u=e(203),p=e(214),d=e(202),y=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype._project_data=function(){o.inplace.project_xy(this._xs.array,this._ys.array)},t.prototype._index_data=function(e){for(var t=this.data_size,i=0;i<t;i++){var n=this._xs.get(i);if(0!=n.length){var r=this._ys.get(i);if(0!=r.length){var o=s.__read(h.minmax(n),2),a=o[0],_=o[1],l=s.__read(h.minmax(r),2),c=l[0],u=l[1];e.add(a,c,_,u)}else e.add_empty()}else e.add_empty()}},t.prototype._render=function(e,t,i){var n,r,o=i.sxs,a=i.sys;try{for(var _=s.__values(t),l=_.next();!l.done;l=_.next()){var h=l.value,c=o.get(h),u=a.get(h);this.visuals.line.set_vectorize(e,h);for(var p=0,d=c.length;p<d;p++)0!=p?isNaN(c[p])||isNaN(u[p])?(e.stroke(),e.beginPath()):e.lineTo(c[p],u[p]):(e.beginPath(),e.moveTo(c[p],u[p]));e.stroke()}}catch(e){n={error:e}}finally{try{l&&!l.done&&(r=_.return)&&r.call(_)}finally{if(n)throw n.error}}},t.prototype._hit_point=function(e){for(var t={x:e.sx,y:e.sy},i=9999,n=new Map,r=0,o=this.sxs.length;r<o;r++){for(var a=Math.max(2,this.visuals.line.cache_select("line_width",r)/2),l=this.sxs.get(r),h=this.sys.get(r),u=null,p=0,y=l.length-1;p<y;p++){var f={x:l[p],y:h[p]},v={x:l[p+1],y:h[p+1]},x=_.dist_to_segment(t,f,v);x<a&&x<i&&(i=x,u=[p])}null!=u&&n.set(r,u)}return new d.Selection({indices:s.__spread(n.keys()),multiline_indices:c.to_object(n)})},t.prototype._hit_span=function(e){var t,i,n=e.sx,r=e.sy;"v"==e.direction?(t=this.renderer.yscale.invert(r),i=this._ys):(t=this.renderer.xscale.invert(n),i=this._xs);for(var o=new Map,a=0,_=i.length;a<_;a++){for(var l=i.get(a),h=[],u=0,p=l.length-1;u<p;u++)l[u]<=t&&t<=l[u+1]&&h.push(u);h.length>0&&o.set(a,h)}return new d.Selection({indices:s.__spread(o.keys()),multiline_indices:c.to_object(o)})},t.prototype.get_interpolation_hit=function(e,t,i){var n=this._xs.get(e),r=this._ys.get(e),s=n[t],o=r[t],a=n[t+1],_=r[t+1];return p.line_interpolation(this.renderer,i,s,o,a,_)},t.prototype.draw_legend_for_index=function(e,t,i){p.generic_line_legend(this.visuals,e,t,i)},t.prototype.scenterxy=function(){throw new Error(this+".scenterxy() is not implemented")},t}(u.GlyphView);i.MultiLineView=y,y.__name__="MultiLineView";var f=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_MultiLine=function(){this.prototype.default_view=y,this.define((function(e){return{xs:[l.XCoordinateSeqSpec,{field:"xs"}],ys:[l.YCoordinateSeqSpec,{field:"ys"}]}})),this.mixins(a.LineVector)},t}(u.Glyph);i.MultiLine=f,f.__name__="MultiLine",f.init_MultiLine()},
function _(e,t,r,i,n){i();var a=e(1),s=e(203),o=e(214),_=e(127),l=e(143),c=a.__importStar(e(215)),h=a.__importStar(e(133)),u=e(202),y=e(126),f=e(152),d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(t,e),t.prototype._project_data=function(){f.inplace.project_xy(this._xs.array,this._ys.array)},t.prototype._index_data=function(e){for(var t=this.data_size,r=0;r<t;r++){var i=this._xs.get(r),n=this._ys.get(r);if(0==i.length)e.add_empty();else{var s=a.__read(_.minmax(i),2),o=s[0],l=s[1],c=a.__read(_.minmax(n),2),h=c[0],u=c[1];e.add(o,h,l,u)}}},t.prototype._mask_data=function(){var e=this.renderer.plot_view.frame,t=e.x_range,r=e.y_range;return this.index.indices({x0:t.min,x1:t.max,y0:r.min,y1:r.max})},t.prototype._inner_loop=function(e,t,r,i){for(var n=0,a=t.length;n<a;n++)0!=n?isNaN(t[n]+r[n])?(e.closePath(),i.apply(e),e.beginPath()):e.lineTo(t[n],r[n]):(e.beginPath(),e.moveTo(t[n],r[n]));e.closePath(),i.call(e)},t.prototype._render=function(e,t,r){var i,n,s=this,o=r.sxs,_=r.sys,l=function(t){var r=o.get(t),i=_.get(t);c.visuals.fill.doit&&(c.visuals.fill.set_vectorize(e,t),c._inner_loop(e,r,i,e.fill)),c.visuals.hatch.doit2(e,t,(function(){return s._inner_loop(e,r,i,e.fill)}),(function(){return s.renderer.request_render()})),c.visuals.line.doit&&(c.visuals.line.set_vectorize(e,t),c._inner_loop(e,r,i,e.stroke))},c=this;try{for(var h=a.__values(t),u=h.next();!u.done;u=h.next()){l(u.value)}}catch(e){i={error:e}}finally{try{u&&!u.done&&(n=h.return)&&n.call(h)}finally{if(i)throw i.error}}},t.prototype._hit_rect=function(e){var t,r,i=e.sx0,n=e.sx1,s=e.sy0,o=e.sy1,_=[i,n,n,i],l=[s,s,o,o],h=a.__read(this.renderer.xscale.r_invert(i,n),2),y=h[0],f=h[1],d=a.__read(this.renderer.yscale.r_invert(s,o),2),p=d[0],v=d[1],x=this.index.indices({x0:y,x1:f,y0:p,y1:v}),g=[];try{for(var m=a.__values(x),b=m.next();!b.done;b=m.next()){for(var w=b.value,P=this.sxs.get(w),S=this.sys.get(w),k=!0,N=0,V=P.length;N<V;N++){var q=P[N],z=S[N];if(!c.point_in_poly(q,z,_,l)){k=!1;break}}k&&g.push(w)}}catch(e){t={error:e}}finally{try{b&&!b.done&&(r=m.return)&&r.call(m)}finally{if(t)throw t.error}}return new u.Selection({indices:g})},t.prototype._hit_point=function(e){var t,r,i=e.sx,n=e.sy,s=this.renderer.xscale.invert(i),o=this.renderer.yscale.invert(n),_=this.index.indices({x0:s,y0:o,x1:s,y1:o}),l=[];try{for(var h=a.__values(_),y=h.next();!y.done;y=h.next())for(var f=y.value,d=this.sxs.get(f),p=this.sys.get(f),v=d.length,x=0,g=0;;g++){if(isNaN(d[g])||g==v){var m=d.subarray(x,g),b=p.subarray(x,g);if(c.point_in_poly(i,n,m,b)){l.push(f);break}x=g+1}if(g==v)break}}catch(e){t={error:e}}finally{try{y&&!y.done&&(r=h.return)&&r.call(h)}finally{if(t)throw t.error}}return new u.Selection({indices:l})},t.prototype._get_snap_coord=function(e){return _.sum(e)/e.length},t.prototype.scenterxy=function(e,t,r){for(var i=this.sxs.get(e),n=this.sys.get(e),a=i.length,s=!1,o=0,_=0;;_++){var l=isNaN(i[_]);if(s=s||l,_==a&&!s)return[this._get_snap_coord(i),this._get_snap_coord(n)];if(l||_==a){var h=i.subarray(o,_),u=n.subarray(o,_);if(c.point_in_poly(t,r,h,u))return[this._get_snap_coord(h),this._get_snap_coord(u)];o=_+1}if(_==a)break}y.unreachable()},t.prototype.draw_legend_for_index=function(e,t,r){o.generic_area_legend(this.visuals,e,t,r)},t}(s.GlyphView);r.PatchesView=d,d.__name__="PatchesView";var p=function(e){function t(t){return e.call(this,t)||this}return a.__extends(t,e),t.init_Patches=function(){this.prototype.default_view=d,this.define((function(e){return{xs:[h.XCoordinateSeqSpec,{field:"xs"}],ys:[h.YCoordinateSeqSpec,{field:"ys"}]}})),this.mixins([l.LineVector,l.FillVector,l.HatchVector])},t}(s.Glyph);r.Patches=p,p.__name__="Patches",p.init_Patches()},
function _(e,r,t,n,l){n();var o=e(1),u=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(r,e),r.prototype.do_selection=function(e,r,t,n){return null!==e&&(r.selected.update(e,t,n),r._select.emit(),!r.selected.is_empty())},r}(e(196).Model);t.SelectionPolicy=u,u.__name__="SelectionPolicy";var a=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(r,e),r.prototype.hit_test=function(e,r){var t,n,l,u,a=[];try{for(var i=o.__values(r),_=i.next();!_.done;_=i.next()){var c=_.value.hit_test(e);null!==c&&a.push(c)}}catch(e){t={error:e}}finally{try{_&&!_.done&&(n=i.return)&&n.call(i)}finally{if(t)throw t.error}}if(a.length>0){var s=a[0];try{for(var f=o.__values(a),h=f.next();!h.done;h=f.next()){var y=h.value;s.update_through_intersection(y)}}catch(e){l={error:e}}finally{try{h&&!h.done&&(u=f.return)&&u.call(f)}finally{if(l)throw l.error}}return s}return null},r}(u);t.IntersectRenderers=a,a.__name__="IntersectRenderers";var i=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(r,e),r.prototype.hit_test=function(e,r){var t,n,l,u,a=[];try{for(var i=o.__values(r),_=i.next();!_.done;_=i.next()){var c=_.value.hit_test(e);null!==c&&a.push(c)}}catch(e){t={error:e}}finally{try{_&&!_.done&&(n=i.return)&&n.call(i)}finally{if(t)throw t.error}}if(a.length>0){var s=a[0];try{for(var f=o.__values(a),h=f.next();!h.done;h=f.next()){var y=h.value;s.update_through_union(y)}}catch(e){l={error:e}}finally{try{h&&!h.done&&(u=f.return)&&u.call(f)}finally{if(l)throw l.error}}return s}return null},r}(u);t.UnionRenderers=i,i.__name__="UnionRenderers"},
function _(t,r,n,e,a){e();var i=t(1),o=t(200),l=t(123),u=t(128),s=i.__importStar(t(238)),c=t(239),d=t(240);function h(t,r,n){if(l.isArray(t)){var e=t.concat(r);return null!=n&&e.length>n?e.slice(-n):e}if(l.isTypedArray(t)){var a=t.length+r.length;if(null!=n&&a>n){var i=a-n,o=t.length;e=void 0;t.length<n?(e=new t.constructor(n)).set(t,0):e=t;for(var u=i,c=o;u<c;u++)e[u-i]=e[u];for(u=0,c=r.length;u<c;u++)e[u+(o-i)]=r[u];return e}var d=new t.constructor(r);return s.concat(t,d)}throw new Error("unsupported array types")}function _(t,r){var n,e,a;return l.isNumber(t)?(n=t,a=t+1,e=1):(n=null!=t.start?t.start:0,a=null!=t.stop?t.stop:r,e=null!=t.step?t.step:1),[n,a,e]}function f(t,r){var n,e,a=new Set,o=!1;try{for(var u=i.__values(r),s=u.next();!s.done;s=u.next()){var c=i.__read(s.value,2),d=c[0],h=c[1],f=void 0,v=void 0,m=void 0,y=void 0;if(l.isArray(d)){var p=i.__read(d,1)[0];a.add(p),f=t[p].shape,v=t[p],y=h,2===d.length?(f=[1,f[0]],m=[d[0],0,d[1]]):m=d}else l.isNumber(d)?(y=[h],a.add(d)):(y=h,o=!0),m=[0,0,d],f=[1,t.length],v=t;var g=0,w=i.__read(_(m[1],f[0]),3),S=w[0],x=w[1],C=w[2],D=i.__read(_(m[2],f[1]),3),A=D[0],E=D[1],b=D[2];for(p=S;p<x;p+=C)for(var N=A;N<E;N+=b)o&&a.add(N),v[p*f[1]+N]=y[g],g++}}catch(t){n={error:t}}finally{try{s&&!s.done&&(e=u.return)&&e.call(u)}finally{if(n)throw n.error}}return a}n.stream_to_column=h,n.slice=_,n.patch_to_column=f;var v=function(t){function r(r){return t.call(this,r)||this}return i.__extends(r,t),r.init_ColumnDataSource=function(){this.define((function(t){return{data:[(0,t.Dict)(t.Any),{}]}}))},r.prototype.stream=function(t,r,n){var e,a,o=this.data;try{for(var l=i.__values(u.entries(t)),s=l.next();!s.done;s=l.next()){var c=i.__read(s.value,2),_=c[0],f=c[1];o[_]=h(o[_],f,r)}}catch(t){e={error:t}}finally{try{s&&!s.done&&(a=l.return)&&a.call(l)}finally{if(e)throw e.error}}if(this.setv({data:o},{silent:!0}),this.streaming.emit(),null!=this.document){var v=new d.ColumnsStreamedEvent(this.document,this.ref(),t,r);this.document._notify_change(this,"data",null,null,{setter_id:n,hint:v})}},r.prototype.patch=function(t,r){var n,e,a=this.data,o=new Set;try{for(var l=i.__values(u.entries(t)),s=l.next();!s.done;s=l.next()){var h=i.__read(s.value,2),_=h[0],v=h[1];o=c.union(o,f(a[_],v))}}catch(t){n={error:t}}finally{try{s&&!s.done&&(e=l.return)&&e.call(l)}finally{if(n)throw n.error}}if(this.setv({data:a},{silent:!0}),this.patching.emit(i.__spread(o)),null!=this.document){var m=new d.ColumnsPatchedEvent(this.document,this.ref(),t);this.document._notify_change(this,"data",null,null,{setter_id:r,hint:m})}},r}(o.ColumnarDataSource);n.ColumnDataSource=v,v.__name__="ColumnDataSource",v.init_ColumnDataSource()},
function _(r,e,n,t,a){t();var l=r(1);n.concat=function(r){for(var e,n,t,a,o=[],c=1;c<arguments.length;c++)o[c-1]=arguments[c];var v=r.length;try{for(var f=l.__values(o),u=f.next();!u.done;u=f.next()){v+=(s=u.value).length}}catch(r){e={error:r}}finally{try{u&&!u.done&&(n=f.return)&&n.call(f)}finally{if(e)throw e.error}}var h=new r.constructor(v);h.set(r,0);var i=r.length;try{for(var y=l.__values(o),g=y.next();!g.done;g=y.next()){var s=g.value;h.set(s,i),i+=s.length}}catch(r){t={error:r}}finally{try{g&&!g.done&&(a=y.return)&&a.call(y)}finally{if(t)throw t.error}}return h}},
function _(r,e,n,a,t){a();var l=r(1);function o(){for(var r,e,n,a,t=[],o=0;o<arguments.length;o++)t[o]=arguments[o];var f=new Set;try{for(var v=l.__values(t),i=v.next();!i.done;i=v.next()){var u=i.value;try{for(var c=(n=void 0,l.__values(u)),y=c.next();!y.done;y=c.next()){var d=y.value;f.add(d)}}catch(r){n={error:r}}finally{try{y&&!y.done&&(a=c.return)&&a.call(c)}finally{if(n)throw n.error}}}}catch(e){r={error:e}}finally{try{i&&!i.done&&(e=v.return)&&e.call(v)}finally{if(r)throw r.error}}return f}n.union=o,n.intersection=function(r){for(var e,n,a,t,o=[],f=1;f<arguments.length;f++)o[f-1]=arguments[f];var v=new Set;try{r:for(var i=l.__values(r),u=i.next();!u.done;u=i.next()){var c=u.value;try{for(var y=(a=void 0,l.__values(o)),d=y.next();!d.done;d=y.next()){var h=d.value;if(!h.has(c))continue r}}catch(r){a={error:r}}finally{try{d&&!d.done&&(t=y.return)&&t.call(y)}finally{if(a)throw a.error}}v.add(c)}}catch(r){e={error:r}}finally{try{u&&!u.done&&(n=i.return)&&n.call(i)}finally{if(e)throw e.error}}return v},n.difference=function(r){for(var e,n,a=[],t=1;t<arguments.length;t++)a[t-1]=arguments[t];var f=new Set(r);try{for(var v=l.__values(o.apply(void 0,l.__spread(a))),i=v.next();!i.done;i=v.next()){var u=i.value;f.delete(u)}}catch(r){e={error:r}}finally{try{i&&!i.done&&(n=v.return)&&n.call(v)}finally{if(e)throw e.error}}return f}},
function _(e,t,n,r,o){r();var s=e(1),a=e(129),i=function(e){this.document=e};n.DocumentEvent=i,i.__name__="DocumentEvent";var _=function(e){function t(t,n,r){var o=e.call(this,t)||this;return o.events=n,o.setter_id=r,o}return s.__extends(t,e),t}(i);n.DocumentEventBatch=_,_.__name__="DocumentEventBatch";var u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t}(i);n.DocumentChangedEvent=u,u.__name__="DocumentChangedEvent";var d=function(e){function t(t,n,r){var o=e.call(this,t)||this;return o.msg_type=n,o.msg_data=r,o}return s.__extends(t,e),t.prototype.json=function(e){var t=this.msg_data,n=a.HasProps._value_to_json(t),r=new Set;return a.HasProps._value_record_references(t,r,{recursive:!0}),{kind:"MessageSent",msg_type:this.msg_type,msg_data:n}},t}(u);n.MessageSentEvent=d,d.__name__="MessageSentEvent";var l=function(e){function t(t,n,r,o,s,a,i){var _=e.call(this,t)||this;return _.model=n,_.attr=r,_.old=o,_.new_=s,_.setter_id=a,_.hint=i,_}return s.__extends(t,e),t.prototype.json=function(e){var t,n;if("id"===this.attr)throw new Error("'id' field should never change, whatever code just set it is wrong");if(null!=this.hint)return this.hint.json(e);var r=this.new_,o=a.HasProps._value_to_json(r),i=new Set;a.HasProps._value_record_references(r,i,{recursive:!0}),i.has(this.model)&&this.model!==r&&i.delete(this.model);try{for(var _=s.__values(i),u=_.next();!u.done;u=_.next()){var d=u.value;e.add(d)}}catch(e){t={error:e}}finally{try{u&&!u.done&&(n=_.return)&&n.call(_)}finally{if(t)throw t.error}}return{kind:"ModelChanged",model:this.model.ref(),attr:this.attr,new:o}},t}(u);n.ModelChangedEvent=l,l.__name__="ModelChangedEvent";var c=function(e){function t(t,n,r){var o=e.call(this,t)||this;return o.column_source=n,o.patches=r,o}return s.__extends(t,e),t.prototype.json=function(e){return{kind:"ColumnsPatched",column_source:this.column_source,patches:this.patches}},t}(u);n.ColumnsPatchedEvent=c,c.__name__="ColumnsPatchedEvent";var h=function(e){function t(t,n,r,o){var s=e.call(this,t)||this;return s.column_source=n,s.data=r,s.rollover=o,s}return s.__extends(t,e),t.prototype.json=function(e){return{kind:"ColumnsStreamed",column_source:this.column_source,data:this.data,rollover:this.rollover}},t}(u);n.ColumnsStreamedEvent=h,h.__name__="ColumnsStreamedEvent";var v=function(e){function t(t,n,r){var o=e.call(this,t)||this;return o.title=n,o.setter_id=r,o}return s.__extends(t,e),t.prototype.json=function(e){return{kind:"TitleChanged",title:this.title}},t}(u);n.TitleChangedEvent=v,v.__name__="TitleChangedEvent";var m=function(e){function t(t,n,r){var o=e.call(this,t)||this;return o.model=n,o.setter_id=r,o}return s.__extends(t,e),t.prototype.json=function(e){return a.HasProps._value_record_references(this.model,e,{recursive:!0}),{kind:"RootAdded",model:this.model.ref()}},t}(u);n.RootAddedEvent=m,m.__name__="RootAddedEvent";var f=function(e){function t(t,n,r){var o=e.call(this,t)||this;return o.model=n,o.setter_id=r,o}return s.__extends(t,e),t.prototype.json=function(e){return{kind:"RootRemoved",model:this.model.ref()}},t}(u);n.RootRemovedEvent=f,f.__name__="RootRemovedEvent"},
function _(t,i,e,s,n){s();var o=t(1),_=t(242),l=o.__importStar(t(143)),r=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(i,t),i.prototype.connect_signals=function(){var i=this;t.prototype.connect_signals.call(this);var e=function(){return i.set_data(i.model.source)};this.connect(this.model.change,e),this.connect(this.model.source.streaming,e),this.connect(this.model.source.patching,e),this.connect(this.model.source.change,e)},i.prototype._render=function(){this._map_data();var t=this.layer.ctx;t.beginPath(),t.moveTo(this._lower_sx[0],this._lower_sy[0]);for(var i=0,e=this._lower_sx.length;i<e;i++)t.lineTo(this._lower_sx[i],this._lower_sy[i]);for(i=this._upper_sx.length-1;i>=0;i--)t.lineTo(this._upper_sx[i],this._upper_sy[i]);t.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_value(t),t.fill()),t.beginPath(),t.moveTo(this._lower_sx[0],this._lower_sy[0]);for(i=0,e=this._lower_sx.length;i<e;i++)t.lineTo(this._lower_sx[i],this._lower_sy[i]);this.visuals.line.doit&&(this.visuals.line.set_value(t),t.stroke()),t.beginPath(),t.moveTo(this._upper_sx[0],this._upper_sy[0]);for(i=0,e=this._upper_sx.length;i<e;i++)t.lineTo(this._upper_sx[i],this._upper_sy[i]);this.visuals.line.doit&&(this.visuals.line.set_value(t),t.stroke())},i}(_.UpperLowerView);e.BandView=r,r.__name__="BandView";var h=function(t){function i(i){return t.call(this,i)||this}return o.__extends(i,t),i.init_Band=function(){this.prototype.default_view=r,this.mixins([l.Line,l.Fill]),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},i}(_.UpperLower);e.Band=h,h.__name__="Band",h.init_Band()},
function _(e,t,i,r,n){r();var o=e(1),s=e(151),p=e(200),a=e(237),u=e(135),_=o.__importStar(e(133)),h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.set_data(this.model.source)},t.prototype.set_data=function(t){e.prototype.set_data.call(this,t),this.visuals.warm_cache(t),this.plot_view.request_render()},t.prototype._map_data=function(){var e,t,i,r=this.plot_view.frame,n=this.model.dimension,s=this.coordinates.x_scale,p=this.coordinates.y_scale,a="height"==n?p:s,u="height"==n?s:p,_="height"==n?r.yview:r.xview,h="height"==n?r.xview:r.yview;e="data"==this.model.properties.lower.units?a.v_compute(this._lower):_.v_compute(this._lower),t="data"==this.model.properties.upper.units?a.v_compute(this._upper):_.v_compute(this._upper),i="data"==this.model.properties.base.units?u.v_compute(this._base):h.v_compute(this._base);var c=o.__read("height"==n?[1,0]:[0,1],2),l=c[0],d=c[1],m=[e,i],f=[t,i];this._lower_sx=m[l],this._lower_sy=m[d],this._upper_sx=f[l],this._upper_sy=f[d]},t}(s.AnnotationView);i.UpperLowerView=h,h.__name__="UpperLowerView";var c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),Object.defineProperty(t.prototype,"dimension",{get:function(){return"width"==this.obj.dimension?"x":"y"},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"units",{get:function(){var e;return null!==(e=this.spec.units)&&void 0!==e?e:"data"},enumerable:!1,configurable:!0}),t}(_.CoordinateSpec);i.XOrYCoordinateSpec=c,c.__name__="XOrYCoordinateSpec";var l=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_UpperLower=function(){this.define((function(e){var t=e.Ref;return{dimension:[u.Dimension,"height"],lower:[c,{field:"lower"}],upper:[c,{field:"upper"}],base:[c,{field:"base"}],source:[t(p.ColumnarDataSource),function(){return new a.ColumnDataSource}]}}))},t}(s.Annotation);i.UpperLower=l,l.__name__="UpperLower",l.init_UpperLower()},
function _(t,i,o,n,e){n();var s=t(1),l=t(151),r=t(130),a=s.__importStar(t(143)),h=t(135),u=t(194);o.EDGE_TOLERANCE=2.5;var _=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(i,t),i.prototype.connect_signals=function(){var i=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return i.plot_view.request_paint(i)})),this.connect(this.model.data_update,(function(){return i.plot_view.request_paint(i)}))},i.prototype._render=function(){var t=this;if(null!=this.model.left||null!=this.model.right||null!=this.model.top||null!=this.model.bottom){var i=this.plot_view.frame,o=this.coordinates.x_scale,n=this.coordinates.y_scale,e=function(i,o,n,e,s){return null!=i?t.model.screen?i:"data"==o?n.compute(i):e.compute(i):s};this.sleft=e(this.model.left,this.model.left_units,o,i.xview,i.bbox.left),this.sright=e(this.model.right,this.model.right_units,o,i.xview,i.bbox.right),this.stop=e(this.model.top,this.model.top_units,n,i.yview,i.bbox.top),this.sbottom=e(this.model.bottom,this.model.bottom_units,n,i.yview,i.bbox.bottom),this._paint_box(this.sleft,this.sright,this.sbottom,this.stop)}},i.prototype._paint_box=function(t,i,o,n){var e=this.layer.ctx;e.save(),e.beginPath(),e.rect(t,n,i-t,o-n),this.visuals.fill.doit&&(this.visuals.fill.set_value(e),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_value(e),e.stroke()),e.restore()},i.prototype.interactive_bbox=function(){var t=this.model.properties.line_width.value()+o.EDGE_TOLERANCE;return new u.BBox({x0:this.sleft-t,y0:this.stop-t,x1:this.sright+t,y1:this.sbottom+t})},i.prototype.interactive_hit=function(t,i){return null!=this.model.in_cursor&&this.interactive_bbox().contains(t,i)},i.prototype.cursor=function(t,i){return Math.abs(t-this.sleft)<3||Math.abs(t-this.sright)<3?this.model.ew_cursor:Math.abs(i-this.sbottom)<3||Math.abs(i-this.stop)<3?this.model.ns_cursor:t>this.sleft&&t<this.sright&&i>this.stop&&i<this.sbottom?this.model.in_cursor:null},i}(l.AnnotationView);o.BoxAnnotationView=_,_.__name__="BoxAnnotationView";var c=function(t){function i(i){return t.call(this,i)||this}return s.__extends(i,t),i.init_BoxAnnotation=function(){this.prototype.default_view=_,this.mixins([a.Line,a.Fill]),this.define((function(t){var i=t.Number,o=t.Nullable;return{render_mode:[h.RenderMode,"canvas"],top:[o(i),null],top_units:[h.SpatialUnits,"data"],bottom:[o(i),null],bottom_units:[h.SpatialUnits,"data"],left:[o(i),null],left_units:[h.SpatialUnits,"data"],right:[o(i),null],right_units:[h.SpatialUnits,"data"]}})),this.internal((function(t){var i=t.Boolean,o=t.String,n=t.Nullable;return{screen:[i,!1],ew_cursor:[n(o),null],ns_cursor:[n(o),null],in_cursor:[n(o),null]}})),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},i.prototype.initialize=function(){t.prototype.initialize.call(this),this.data_update=new r.Signal0(this,"data_update")},i.prototype.update=function(t){var i=t.left,o=t.right,n=t.top,e=t.bottom;this.setv({left:i,right:o,top:n,bottom:e,screen:!0},{silent:!0}),this.data_update.emit()},i}(l.Annotation);o.BoxAnnotation=c,c.__name__="BoxAnnotation",c.init_BoxAnnotation()},
function _(t,e,i,o,r){o();var a=t(1),n=t(151),s=t(245),l=t(247),_=t(248),h=t(250),m=t(251),d=t(255),c=t(264),u=t(276),p=t(277),f=t(275),g=t(135),v=a.__importStar(t(143)),b=a.__importStar(t(278)),k=t(124),w=t(127),x=t(123),j=t(126),y=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._set_canvas_image()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.ticker.change,(function(){return e.plot_view.request_render()})),this.connect(this.model.formatter.change,(function(){return e.plot_view.request_render()})),null!=this.model.color_mapper&&this.connect(this.model.color_mapper.change,(function(){e._set_canvas_image(),e.plot_view.request_render()}))},e.prototype._get_size=function(){if(null==this.model.color_mapper)return{width:0,height:0};var t=this.compute_legend_dimensions();return{width:t.width,height:t.height}},e.prototype._set_canvas_image=function(){var t,e;if(null!=this.model.color_mapper){var i,o,r=this.model.color_mapper.palette;switch("vertical"==this.model.orientation&&(r=k.reversed(r)),this.model.orientation){case"vertical":i=(t=a.__read([1,r.length],2))[0],o=t[1];break;case"horizontal":i=(e=a.__read([r.length,1],2))[0],o=e[1]}var n=document.createElement("canvas");n.width=i,n.height=o;var s=n.getContext("2d"),l=s.getImageData(0,0,i,o),_=new d.LinearColorMapper({palette:r}).rgba_mapper.v_compute(k.range(0,r.length));l.data.set(_),s.putImageData(l,0,0),this.image=n}},e.prototype.compute_legend_dimensions=function(){var t,e,i=this._computed_image_dimensions(),o=a.__read([i.height,i.width],2),r=o[0],n=o[1],s=this._get_label_extent(),l=this._title_extent(),_=this._tick_extent(),h=this.model.padding;switch(this.model.orientation){case"vertical":t=r+l+2*h,e=n+_+s+2*h;break;case"horizontal":t=r+l+_+s+2*h,e=n+2*h}return{width:e,height:t}},e.prototype.compute_legend_location=function(){var t,e,i=this.compute_legend_dimensions(),o=a.__read([i.height,i.width],2),r=o[0],n=o[1],s=this.model.margin,l=null!=this.panel?this.panel:this.plot_view.frame,_=a.__read(l.bbox.ranges,2),h=_[0],m=_[1],d=this.model.location;if(x.isString(d))switch(d){case"top_left":t=h.start+s,e=m.start+s;break;case"top_center":t=(h.end+h.start)/2-n/2,e=m.start+s;break;case"top_right":t=h.end-s-n,e=m.start+s;break;case"bottom_right":t=h.end-s-n,e=m.end-s-r;break;case"bottom_center":t=(h.end+h.start)/2-n/2,e=m.end-s-r;break;case"bottom_left":t=h.start+s,e=m.end-s-r;break;case"center_left":t=h.start+s,e=(m.end+m.start)/2-r/2;break;case"center":t=(h.end+h.start)/2-n/2,e=(m.end+m.start)/2-r/2;break;case"center_right":t=h.end-s-n,e=(m.end+m.start)/2-r/2}else if(x.isArray(d)&&2==d.length){var c=a.__read(d,2),u=c[0],p=c[1];t=l.xview.compute(u),e=l.yview.compute(p)-r}else j.unreachable();return{sx:t,sy:e}},e.prototype._render=function(){if(null!=this.model.color_mapper){var t=this.layer.ctx;t.save();var e=this.compute_legend_location(),i=e.sx,o=e.sy;t.translate(i,o),this._draw_bbox(t);var r=this._get_image_offset();t.translate(r.x,r.y),this._draw_image(t);var a=this.tick_info();this._draw_major_ticks(t,a),this._draw_minor_ticks(t,a),this._draw_major_labels(t,a),this.model.title&&this._draw_title(t),t.restore()}},e.prototype._draw_bbox=function(t){var e=this.compute_legend_dimensions();t.save(),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(0,0,e.width,e.height)),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()},e.prototype._draw_image=function(t){var e=this._computed_image_dimensions();t.save(),t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.scale_alpha,t.drawImage(this.image,0,0,e.width,e.height),this.visuals.bar_line.doit&&(this.visuals.bar_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()},e.prototype._draw_major_ticks=function(t,e){if(this.visuals.major_tick_line.doit){var i=a.__read(this._normals(),2),o=i[0],r=i[1],n=this._computed_image_dimensions(),s=a.__read([n.width*o,n.height*r],2),l=s[0],_=s[1],h=a.__read(e.coords.major,2),m=h[0],d=h[1],c=this.model.major_tick_in,u=this.model.major_tick_out;t.save(),t.translate(l,_),this.visuals.major_tick_line.set_value(t);for(var p=0,f=m.length;p<f;p++)t.beginPath(),t.moveTo(Math.round(m[p]+o*u),Math.round(d[p]+r*u)),t.lineTo(Math.round(m[p]-o*c),Math.round(d[p]-r*c)),t.stroke();t.restore()}},e.prototype._draw_minor_ticks=function(t,e){if(this.visuals.minor_tick_line.doit){var i=a.__read(this._normals(),2),o=i[0],r=i[1],n=this._computed_image_dimensions(),s=a.__read([n.width*o,n.height*r],2),l=s[0],_=s[1],h=a.__read(e.coords.minor,2),m=h[0],d=h[1],c=this.model.minor_tick_in,u=this.model.minor_tick_out;t.save(),t.translate(l,_),this.visuals.minor_tick_line.set_value(t);for(var p=0,f=m.length;p<f;p++)t.beginPath(),t.moveTo(Math.round(m[p]+o*u),Math.round(d[p]+r*u)),t.lineTo(Math.round(m[p]-o*c),Math.round(d[p]-r*c)),t.stroke();t.restore()}},e.prototype._draw_major_labels=function(t,e){if(this.visuals.major_label_text.doit){var i=a.__read(this._normals(),2),o=i[0],r=i[1],n=this._computed_image_dimensions(),s=a.__read([n.width*o,n.height*r],2),l=s[0],_=s[1],h=this.model.label_standoff+this._tick_extent(),m=a.__read([h*o,h*r],2),d=m[0],c=m[1],u=a.__read(e.coords.major,2),p=u[0],f=u[1],g=e.labels.major;this.visuals.major_label_text.set_value(t),t.save(),t.translate(l+d,_+c);for(var v=0,b=p.length;v<b;v++)t.fillText(g[v],Math.round(p[v]+o*this.model.label_standoff),Math.round(f[v]+r*this.model.label_standoff));t.restore()}},e.prototype._draw_title=function(t){this.visuals.title_text.doit&&(t.save(),this.visuals.title_text.set_value(t),t.fillText(this.model.title,0,-this.model.title_standoff),t.restore())},e.prototype._get_label_extent=function(){var t,e=this.tick_info().labels.major;if(k.is_empty(e))t=0;else{var i=this.layer.ctx;switch(i.save(),this.visuals.major_label_text.set_value(i),this.model.orientation){case"vertical":t=k.max(e.map((function(t){return i.measureText(t.toString()).width})));break;case"horizontal":t=b.measure_font(this.visuals.major_label_text.font_value()).height}t+=this.model.label_standoff,i.restore()}return t},e.prototype._get_image_offset=function(){return{x:this.model.padding,y:this.model.padding+this._title_extent()}},e.prototype._normals=function(){return"vertical"==this.model.orientation?[1,0]:[0,1]},e.prototype._title_extent=function(){var t=this.model.title_text_font+" "+this.model.title_text_font_size+" "+this.model.title_text_font_style;return this.model.title?b.measure_font(t).height+this.model.title_standoff:0},e.prototype._tick_extent=function(){return k.max([this.model.major_tick_out,this.model.minor_tick_out])},e.prototype._computed_image_dimensions=function(){var t,e,i=this.plot_view.frame.bbox.height,o=this.plot_view.frame.bbox.width,r=this._title_extent();switch(this.model.orientation){case"vertical":"auto"==this.model.height?null!=this.panel?t=i-2*this.model.padding-r:(t=k.max([25*this.model.color_mapper.palette.length,.3*i]),t=k.min([t,.8*i-2*this.model.padding-r])):t=this.model.height,e="auto"==this.model.width?25:this.model.width;break;case"horizontal":t="auto"==this.model.height?25:this.model.height,"auto"==this.model.width?null!=this.panel?e=o-2*this.model.padding:(e=k.max([25*this.model.color_mapper.palette.length,.3*o]),e=k.min([e,.8*o-2*this.model.padding])):e=this.model.width}return{width:e,height:t}},e.prototype._tick_coordinate_scale=function(t){var e={source_range:new f.Range1d({start:this.model.color_mapper.metrics.min,end:this.model.color_mapper.metrics.max}),target_range:new f.Range1d({start:0,end:t})},i=this.model.color_mapper;if(i instanceof d.LinearColorMapper)return new c.LinearScale(e);if(i instanceof d.LogColorMapper)return new p.LogScale(e);if(i instanceof d.ScanningColorMapper){var o=i.metrics.binning;return new u.LinearInterpolationScale(Object.assign(Object.assign({},e),{binning:o}))}j.unreachable()},e.prototype._format_major_labels=function(t,e){for(var i=this.model.formatter.doFormat(t,{loc:NaN}),o=0,r=e.length;o<r;o++)e[o]in this.model.major_label_overrides&&(i[o]=this.model.major_label_overrides[e[o]]);return i},e.prototype.tick_info=function(){var t,e=this._computed_image_dimensions();switch(this.model.orientation){case"vertical":t=e.height;break;case"horizontal":t=e.width}for(var i=this._tick_coordinate_scale(t),o=a.__read(this._normals(),2),r=o[0],n=o[1],s=a.__read([this.model.color_mapper.metrics.min,this.model.color_mapper.metrics.max],2),l=s[0],_=s[1],h=this.model.ticker.get_ticks_no_defaults(l,_,NaN,this.model.ticker.desired_num_ticks),m=h.major,d=h.minor,c=[[],[]],u=[[],[]],p=0,f=m.length;p<f;p++)m[p]<l||m[p]>_||(c[r].push(m[p]),c[n].push(0));for(p=0,f=d.length;p<f;p++)d[p]<l||d[p]>_||(u[r].push(d[p]),u[n].push(0));var g={major:this._format_major_labels(c[r],m)},v={major:[[],[]],minor:[[],[]]};return v.major[r]=i.v_compute(c[r]),v.minor[r]=i.v_compute(u[r]),v.major[n]=c[n],v.minor[n]=u[n],"vertical"==this.model.orientation&&(v.major[r]=w.map(v.major[r],(function(e){return t-e})),v.minor[r]=w.map(v.minor[r],(function(e){return t-e}))),{coords:v,labels:g}},e}(n.AnnotationView);i.ColorBarView=y,y.__name__="ColorBarView";var M=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_ColorBar=function(){this.prototype.default_view=y,this.mixins([["major_label_",v.Text],["title_",v.Text],["major_tick_",v.Line],["minor_tick_",v.Line],["border_",v.Line],["bar_",v.Line],["background_",v.Fill]]),this.define((function(t){var e=t.Alpha,i=t.Number,o=t.String,r=t.Tuple,a=t.Dict,n=t.Or,d=t.Ref,c=t.Auto;return{location:[n(g.LegendLocation,r(i,i)),"top_right"],orientation:[g.Orientation,"vertical"],title:[o],title_standoff:[i,2],width:[n(i,c),"auto"],height:[n(i,c),"auto"],scale_alpha:[e,1],ticker:[d(s.ContinuousTicker),function(){return new _.BasicTicker}],formatter:[d(l.TickFormatter),function(){return new h.BasicTickFormatter}],major_label_overrides:[a(o),{}],color_mapper:[d(m.ContinuousColorMapper)],label_standoff:[i,5],margin:[i,30],padding:[i,10],major_tick_in:[i,5],major_tick_out:[i,0],minor_tick_in:[i,0],minor_tick_out:[i,0]}})),this.override({background_fill_color:"#ffffff",background_fill_alpha:.95,bar_line_color:null,border_line_color:null,major_label_text_align:"center",major_label_text_baseline:"middle",major_label_text_font_size:"11px",major_tick_line_color:"#ffffff",minor_tick_line_color:null,title_text_font_size:"13px",title_text_font_style:"italic"})},e}(n.Annotation);i.ColorBar=M,M.__name__="ColorBar",M.init_ColorBar()},
function _(t,r,n,e,i){e();var o=t(1),u=t(246),a=t(124),l=function(t){function r(r){return t.call(this,r)||this}return o.__extends(r,t),r.init_ContinuousTicker=function(){this.define((function(t){var r=t.Int;return{num_minor_ticks:[r,5],desired_num_ticks:[r,6]}}))},r.prototype.get_ticks=function(t,r,n,e){return this.get_ticks_no_defaults(t,r,e,this.desired_num_ticks)},r.prototype.get_ticks_no_defaults=function(t,r,n,e){var i,u,l,c,_,s,f=this.get_interval(t,r,e),h=Math.floor(t/f),v=Math.ceil(r/f),d=(isFinite(h)&&isFinite(v)?a.range(h,v+1):[]).map((function(t){return t*f})).filter((function(n){return t<=n&&n<=r})),y=this.num_minor_ticks,k=[];if(y>0&&d.length>0){var m=f/y,p=a.range(0,y).map((function(t){return t*m}));try{for(var g=o.__values(p.slice(1)),x=g.next();!x.done;x=g.next()){var T=x.value,C=d[0]-T;t<=C&&C<=r&&k.push(C)}}catch(t){i={error:t}}finally{try{x&&!x.done&&(u=g.return)&&u.call(g)}finally{if(i)throw i.error}}try{for(var w=o.__values(d),F=w.next();!F.done;F=w.next()){var M=F.value;try{for(var j=(_=void 0,o.__values(p)),I=j.next();!I.done;I=j.next()){T=I.value;t<=(C=M+T)&&C<=r&&k.push(C)}}catch(t){_={error:t}}finally{try{I&&!I.done&&(s=j.return)&&s.call(j)}finally{if(_)throw _.error}}}}catch(t){l={error:t}}finally{try{F&&!F.done&&(c=w.return)&&c.call(w)}finally{if(l)throw l.error}}}return{major:d,minor:k}},r.prototype.get_ideal_interval=function(t,r,n){return(r-t)/n},r}(u.Ticker);n.ContinuousTicker=l,l.__name__="ContinuousTicker",l.init_ContinuousTicker()},
function _(n,e,t,i,r){i();var _=n(1),c=function(n){function e(e){return n.call(this,e)||this}return _.__extends(e,n),e}(n(196).Model);t.Ticker=c,c.__name__="Ticker"},
function _(t,o,n,r,e){r();var u=t(1),c=function(t){function o(o){return t.call(this,o)||this}return u.__extends(o,t),o.prototype.compute=function(t,o){return this.doFormat([t],null!=o?o:{loc:0})[0]},o.prototype.v_compute=function(t,o){return this.doFormat(t,null!=o?o:{loc:0})},o}(t(196).Model);n.TickFormatter=c,c.__name__="TickFormatter"},
function _(i,n,c,e,t){e();var r=i(1),_=function(i){function n(n){return i.call(this,n)||this}return r.__extends(n,i),n}(i(249).AdaptiveTicker);c.BasicTicker=_,_.__name__="BasicTicker"},
function _(t,i,n,e,a){e();var s=t(1),r=t(245),_=t(124),o=t(125),l=function(t){function i(i){return t.call(this,i)||this}return s.__extends(i,t),i.init_AdaptiveTicker=function(){this.define((function(t){var i=t.Number,n=t.Array,e=t.Nullable;return{base:[i,10],mantissas:[n(i),[1,2,5]],min_interval:[i,0],max_interval:[e(i),null]}}))},i.prototype.get_min_interval=function(){return this.min_interval},i.prototype.get_max_interval=function(){var t;return null!==(t=this.max_interval)&&void 0!==t?t:1/0},i.prototype.initialize=function(){t.prototype.initialize.call(this);var i=_.nth(this.mantissas,-1)/this.base,n=_.nth(this.mantissas,0)*this.base;this.extended_mantissas=s.__spread([i],this.mantissas,[n]),this.base_factor=0===this.get_min_interval()?1:this.get_min_interval()},i.prototype.get_interval=function(t,i,n){var e=i-t,a=this.get_ideal_interval(t,i,n),s=Math.floor(o.log(a/this.base_factor,this.base)),r=Math.pow(this.base,s)*this.base_factor,l=this.extended_mantissas,h=l.map((function(t){return Math.abs(n-e/(t*r))})),u=l[_.argmin(h)]*r;return o.clamp(u,this.get_min_interval(),this.get_max_interval())},i}(r.ContinuousTicker);n.AdaptiveTicker=l,l.__name__="AdaptiveTicker",l.init_AdaptiveTicker()},
function _(i,t,e,r,n){r();var o=i(1),a=i(247),c=i(144),s=function(i){function t(t){var e=i.call(this,t)||this;return e.last_precision=3,e}return o.__extends(t,i),t.init_BasicTickFormatter=function(){this.define((function(i){var t=i.Boolean,e=i.Int,r=i.Auto;return{precision:[(0,i.Or)(e,r),"auto"],use_scientific:[t,!0],power_limit_high:[e,5],power_limit_low:[e,-3]}}))},Object.defineProperty(t.prototype,"scientific_limit_low",{get:function(){return Math.pow(10,this.power_limit_low)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"scientific_limit_high",{get:function(){return Math.pow(10,this.power_limit_high)},enumerable:!1,configurable:!0}),t.prototype._need_sci=function(i){var t,e;if(!this.use_scientific)return!1;var r=this.scientific_limit_high,n=this.scientific_limit_low,a=i.length<2?0:Math.abs(i[1]-i[0])/1e4;try{for(var c=o.__values(i),s=c.next();!s.done;s=c.next()){var _=s.value,u=Math.abs(_);if(!(u<=a)&&(u>=r||u<=n))return!0}}catch(i){t={error:i}}finally{try{s&&!s.done&&(e=c.return)&&e.call(c)}finally{if(t)throw t.error}}return!1},t.prototype._format_with_precision=function(i,t,e){return t?i.map((function(i){return i.toExponential(e)})):i.map((function(i){return c.to_fixed(i,e)}))},t.prototype._auto_precision=function(i,t){var e=new Array(i.length),r=this.last_precision<=15;i:for(var n=this.last_precision;r?n<=15:n>=1;r?n++:n--){if(t){e[0]=i[0].toExponential(n);for(var o=1;o<i.length;o++)if(e[o]==e[o-1])continue i;this.last_precision=n;break}e[0]=c.to_fixed(i[0],n);for(o=1;o<i.length;o++)if(e[o]=c.to_fixed(i[o],n),e[o]==e[o-1])continue i;this.last_precision=n;break}return this.last_precision},t.prototype.doFormat=function(i,t){if(0==i.length)return[];var e=this._need_sci(i),r="auto"==this.precision?this._auto_precision(i,e):this.precision;return this._format_with_precision(i,e,r)},t}(a.TickFormatter);e.BasicTickFormatter=s,s.__name__="BasicTickFormatter",s.init_BasicTickFormatter()},
function _(e,t,r,n,a){n();var o=e(1),l=e(252),s=e(210),c=e(124),i=e(123),u=function(e){function t(t){var r=e.call(this,t)||this;return r._scan_data=null,r}return o.__extends(t,e),t.init_ContinuousColorMapper=function(){this.define((function(e){var t=e.Number,r=e.String,n=e.Ref,a=e.Color,o=e.Or,l=e.Tuple,c=e.Array,i=e.Nullable;return{high:[i(t),null],low:[i(t),null],high_color:[i(a),null],low_color:[i(a),null],domain:[c(l(n(s.GlyphRenderer),o(r,c(r)))),[]]}}))},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this);var r=function(){var e,r;try{for(var n=o.__values(t.domain),a=n.next();!a.done;a=n.next()){var l=o.__read(a.value,1)[0];t.connect(l.view.change,(function(){return t.update_data()})),t.connect(l.data_source.selected.change,(function(){return t.update_data()}))}}catch(t){e={error:t}}finally{try{a&&!a.done&&(r=n.return)&&r.call(n)}finally{if(e)throw e.error}}};this.connect(this.properties.domain.change,(function(){return r()})),r()},t.prototype.update_data=function(){var e=this.domain,t=this.palette,r=o.__spread(this._collect(e));this._scan_data=this.scan(r,t.length),this.change.emit()},Object.defineProperty(t.prototype,"metrics",{get:function(){return null==this._scan_data&&this.update_data(),this._scan_data},enumerable:!1,configurable:!0}),t.prototype._collect=function(e){var t,r,n,a,l,s,u,_,h,d,p,f,v,g,y;return o.__generator(this,(function(b){switch(b.label){case 0:b.trys.push([0,11,12,13]),t=o.__values(e),r=t.next(),b.label=1;case 1:if(r.done)return[3,10];n=o.__read(r.value,2),a=n[0],l=n[1],s=function(e){var t,r,n,l,s,u,_,h,d,p;return o.__generator(this,(function(f){switch(f.label){case 0:if(t=a.data_source.get_column(e),t=a.view.indices.select(t),r=a.view.masked,n=a.data_source.selected.indices,l=void 0,null!=r&&n.length>0?l=c.intersection(o.__spread(r),n):null!=r?l=o.__spread(r):n.length>0&&(l=n),null!=l&&(t=c.map(l,(function(e){return t[e]}))),!(t.length>0)||i.isNumber(t[0]))return[3,9];f.label=1;case 1:f.trys.push([1,6,7,8]),d=void 0,s=o.__values(t),u=s.next(),f.label=2;case 2:return u.done?[3,5]:(_=u.value,[5,o.__values(_)]);case 3:f.sent(),f.label=4;case 4:return u=s.next(),[3,2];case 5:return[3,8];case 6:return h=f.sent(),d={error:h},[3,8];case 7:try{u&&!u.done&&(p=s.return)&&p.call(s)}finally{if(d)throw d.error}return[7];case 8:return[3,11];case 9:return[5,o.__values(t)];case 10:f.sent(),f.label=11;case 11:return[2]}}))},b.label=2;case 2:b.trys.push([2,7,8,9]),g=void 0,u=o.__values(i.isArray(l)?l:[l]),_=u.next(),b.label=3;case 3:return _.done?[3,6]:(h=_.value,[5,s(h)]);case 4:b.sent(),b.label=5;case 5:return _=u.next(),[3,3];case 6:return[3,9];case 7:return d=b.sent(),g={error:d},[3,9];case 8:try{_&&!_.done&&(y=u.return)&&y.call(u)}finally{if(g)throw g.error}return[7];case 9:return r=t.next(),[3,1];case 10:return[3,13];case 11:return p=b.sent(),f={error:p},[3,13];case 12:try{r&&!r.done&&(v=t.return)&&v.call(t)}finally{if(f)throw f.error}return[7];case 13:return[2]}}))},t.prototype._v_compute=function(e,t,r,n){var a=n.nan_color,l=n.low_color,s=n.high_color;null==l&&(l=r[0]),null==s&&(s=r[r.length-1]);var i=this.domain,u=c.is_empty(i)?e:o.__spread(this._collect(i));this._scan_data=this.scan(u,r.length);for(var _=0,h=e.length;_<h;_++){var d=e[_];isNaN(d)?t[_]=a:t[_]=this.cmap(d,r,l,s,this._scan_data)}},t.prototype._colors=function(t){return Object.assign(Object.assign({},e.prototype._colors.call(this,t)),{low_color:null!=this.low_color?t(this.low_color):void 0,high_color:null!=this.high_color?t(this.high_color):void 0})},t}(l.ColorMapper);r.ContinuousColorMapper=u,u.__name__="ContinuousColorMapper",u.init_ContinuousColorMapper()},
function _(r,t,n,e,o){e();var i=r(1),a=r(253),u=r(123),c=r(137),_=r(147);function l(r){return u.isNumber(r)?r:("#"!=r[0]&&(r=c.color2hex(r)),9!=r.length&&(r+="ff"),parseInt(r.slice(1),16))}function p(r){for(var t=new Uint32Array(r.length),n=0,e=r.length;n<e;n++)t[n]=l(r[n]);return t}function f(r){if(_.is_little_endian)for(var t=new DataView(r.buffer),n=0,e=r.length;n<e;n++)t.setUint32(4*n,r[n]);return new Uint8Array(r.buffer)}n._convert_color=l,n._convert_palette=p,n._uint32_to_rgba=f;var s=function(r){function t(t){return r.call(this,t)||this}return i.__extends(t,r),t.init_ColorMapper=function(){this.define((function(r){var t=r.Number,n=r.Color;return{palette:[(0,r.Array)((0,r.Or)(n,t))],nan_color:[n,"gray"]}}))},t.prototype.v_compute=function(r){var t=new Array(r.length);return this._v_compute(r,t,this.palette,this._colors((function(r){return r}))),t},Object.defineProperty(t.prototype,"rgba_mapper",{get:function(){var r=this,t=p(this.palette),n=this._colors(l);return{v_compute:function(e){var o=new Uint32Array(e.length);return r._v_compute(e,o,t,n),f(o)}}},enumerable:!1,configurable:!0}),t.prototype._colors=function(r){return{nan_color:r(this.nan_color)}},t}(a.Mapper);n.ColorMapper=s,s.__name__="ColorMapper",s.init_ColorMapper()},
function _(n,r,t,e,o){e();var p=n(1),i=function(n){function r(r){return n.call(this,r)||this}return p.__extends(r,n),r.prototype.compute=function(n){throw new Error("mapping single values is not supported")},r}(n(254).Transform);t.Mapper=i,i.__name__="Mapper"},
function _(n,r,t,_,e){_();var o=n(1),a=function(n){function r(r){return n.call(this,r)||this}return o.__extends(r,n),r}(n(196).Model);t.Transform=a,a.__name__="Transform"},
function _(r,o,a,p,e){p(),e("CategoricalColorMapper",r(256).CategoricalColorMapper),e("CategoricalMarkerMapper",r(258).CategoricalMarkerMapper),e("CategoricalPatternMapper",r(259).CategoricalPatternMapper),e("ContinuousColorMapper",r(251).ContinuousColorMapper),e("ColorMapper",r(252).ColorMapper),e("LinearColorMapper",r(260).LinearColorMapper),e("LogColorMapper",r(261).LogColorMapper),e("ScanningColorMapper",r(262).ScanningColorMapper),e("EqHistColorMapper",r(263).EqHistColorMapper)},
function _(t,r,o,a,n){a();var e=t(1),i=t(257),c=function(t){function r(r){return t.call(this,r)||this}return e.__extends(r,t),r.init_CategoricalColorMapper=function(){this.define((function(t){var r=t.Any,o=t.Number,a=t.Array,n=t.Nullable;return{factors:[a(r)],start:[o,0],end:[n(o),null]}}))},r.prototype._v_compute=function(t,r,o,a){var n=a.nan_color;i.cat_v_compute(t,this.factors,o,r,this.start,this.end,n)},r}(t(252).ColorMapper);o.CategoricalColorMapper=c,c.__name__="CategoricalColorMapper",c.init_CategoricalColorMapper()},
function _(n,t,e,i,l){i();var r=n(127),u=n(123);function f(n,t){if(n.length!=t.length)return!1;for(var e=0,i=n.length;e<i;e++)if(n[e]!==t[e])return!1;return!0}e._cat_equals=f,e.cat_v_compute=function(n,t,e,i,l,o,c){for(var a=n.length,v=function(a){var v=n[a],_=void 0;u.isString(v)?_=r.index_of(t,v):(null!=l?v=null!=o?v.slice(l,o):v.slice(l):null!=o&&(v=v.slice(0,o)),_=1==v.length?r.index_of(t,v[0]):r.find_index(t,(function(n){return f(n,v)})));var g=void 0;g=_<0||_>=e.length?c:e[_],i[a]=g},_=0;_<a;_++)v(_)}},
function _(r,e,t,a,n){a();var i=r(1),u=r(257),c=r(253),l=r(135),o=function(r){function e(e){return r.call(this,e)||this}return i.__extends(e,r),e.init_CategoricalMarkerMapper=function(){this.define((function(r){var e=r.Any,t=r.Number,a=r.Array,n=r.Nullable;return{factors:[a(e)],markers:[a(l.MarkerType)],start:[t,0],end:[n(t),null],default_value:[l.MarkerType,"circle"]}}))},e.prototype.v_compute=function(r){var e=new Array(r.length);return u.cat_v_compute(r,this.factors,this.markers,e,this.start,this.end,this.default_value),e},e}(c.Mapper);t.CategoricalMarkerMapper=o,o.__name__="CategoricalMarkerMapper",o.init_CategoricalMarkerMapper()},
function _(t,e,a,r,n){r();var i=t(1),u=t(257),c=t(253),p=t(135),l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_CategoricalPatternMapper=function(){this.define((function(t){var e=t.Any,a=t.Number,r=t.Array,n=t.Nullable;return{factors:[r(e)],patterns:[r(p.HatchPatternType)],start:[a,0],end:[n(a),null],default_value:[p.HatchPatternType," "]}}))},e.prototype.v_compute=function(t){var e=new Array(t.length);return u.cat_v_compute(t,this.factors,this.patterns,e,this.start,this.end,this.default_value),e},e}(c.Mapper);a.CategoricalPatternMapper=l,l.__name__="CategoricalPatternMapper",l.init_CategoricalPatternMapper()},
function _(n,r,t,o,i){o();var a=n(1),e=n(251),l=n(127),u=function(n){function r(r){return n.call(this,r)||this}return a.__extends(r,n),r.prototype.scan=function(n,r){var t=null!=this.low?this.low:l.min(n),o=null!=this.high?this.high:l.max(n);return{max:o,min:t,norm_factor:1/(o-t),normed_interval:1/r}},r.prototype.cmap=function(n,r,t,o,i){var a=r.length-1;if(n==i.max)return r[a];var e=(n-i.min)*i.norm_factor,l=Math.floor(e/i.normed_interval);return l<0?t:l>a?o:r[l]},r}(e.ContinuousColorMapper);t.LinearColorMapper=u,u.__name__="LinearColorMapper"},
function _(t,n,o,r,a){r();var i=t(1),l=t(251),e=t(127),h=function(t){function n(n){return t.call(this,n)||this}return i.__extends(n,t),n.prototype.scan=function(t,n){var o=null!=this.low?this.low:e.min(t),r=null!=this.high?this.high:e.max(t);return{max:r,min:o,scale:n/(Math.log(r)-Math.log(o))}},n.prototype.cmap=function(t,n,o,r,a){var i=n.length-1;if(t>a.max)return r;if(t==a.max)return n[i];if(t<a.min)return o;var l=Math.log(t)-Math.log(a.min),e=Math.floor(l*a.scale);return e>i&&(e=i),n[e]},n}(l.ContinuousColorMapper);o.LogColorMapper=h,h.__name__="LogColorMapper"},
function _(n,i,e,t,o){t();var r=n(1),a=n(251),p=n(127),u=function(n){function i(i){return n.call(this,i)||this}return r.__extends(i,n),i.prototype.cmap=function(n,i,e,t,o){return n<o.binning[0]?e:n>o.binning[o.binning.length-1]?t:i[p.left_edge_index(n,o.binning)]},i}(a.ContinuousColorMapper);e.ScanningColorMapper=u,u.__name__="ScanningColorMapper"},
function _(n,i,r,t,e){t();var o=n(1),a=n(262),l=n(127),s=n(124),u=n(134),h=function(n){function i(i){return n.call(this,i)||this}return o.__extends(i,n),i.init_EqHistColorMapper=function(){this.define((function(n){return{bins:[n.Int,65536]}}))},i.prototype.scan=function(n,i){for(var r=null!=this.low?this.low:l.min(n),t=null!=this.high?this.high:l.max(n),e=this.bins,o=s.linspace(r,t,e+1),a=l.bin_counts(n,o),h=new Array(e),p=0,c=o.length;p<c-1;p++){var f=o[p],g=o[p+1];h[p]=(f+g)/2}for(var m=s.cumsum(a),_=m[m.length-1],v=l.map(m,(function(n){return n/_})),M=i-1,q=[],C=0,H=2*i;M!=i&&C<4&&0!=M;){var b=H/M;if(b>1e3)break;H=Math.round(Math.max(i*b,i));var d=s.range(0,H),w=l.map(v,(function(n){return n*(H-1)}));q=l.interpolate(d,w,h),M=s.uniq(q).length-1,C++}if(0==M){q=[r,t];for(var E=0;E<i-1;E++)q.push(t)}else q=q.slice(q.length-i-1),M!=i&&u.logger.warn("EqHistColorMapper warning: Histogram equalization did not converge.");return{min:r,max:t,binning:q}},i}(a.ScanningColorMapper);r.EqHistColorMapper=h,h.__name__="EqHistColorMapper",h.init_EqHistColorMapper()},
function _(t,n,e,r,i){r();var o=t(1),u=function(t){function n(n){return t.call(this,n)||this}return o.__extends(n,t),n.prototype.compute=function(t){return this._linear_compute(t)},n.prototype.v_compute=function(t){return this._linear_v_compute(t)},n.prototype.invert=function(t){return this._linear_invert(t)},n.prototype.v_invert=function(t){return this._linear_v_invert(t)},n}(t(265).ContinuousScale);e.LinearScale=u,u.__name__="LinearScale"},
function _(n,t,u,e,c){e();var i=n(1),o=function(n){function t(t){return n.call(this,t)||this}return i.__extends(t,n),t}(n(266).Scale);u.ContinuousScale=o,o.__name__="ContinuousScale"},
function _(t,e,r,n,i){n();var _=t(1),a=t(267),o=t(208),u=t(275),s=t(139),c=function(t){function e(e){return t.call(this,e)||this}return _.__extends(e,t),e.init_Scale=function(){this.internal((function(t){var e=t.Ref;return{source_range:[e(o.Range)],target_range:[e(u.Range1d)]}}))},e.prototype.r_compute=function(t,e){return this.target_range.is_reversed?[this.compute(e),this.compute(t)]:[this.compute(t),this.compute(e)]},e.prototype.r_invert=function(t,e){return this.target_range.is_reversed?[this.invert(e),this.invert(t)]:[this.invert(t),this.invert(e)]},e.prototype._linear_compute=function(t){var e=_.__read(this._linear_compute_state(),2);return e[0]*t+e[1]},e.prototype._linear_v_compute=function(t){for(var e=_.__read(this._linear_compute_state(),2),r=e[0],n=e[1],i=new s.NumberArray(t.length),a=0;a<t.length;a++)i[a]=r*t[a]+n;return i},e.prototype._linear_invert=function(t){var e=_.__read(this._linear_compute_state(),2),r=e[0];return(t-e[1])/r},e.prototype._linear_v_invert=function(t){for(var e=_.__read(this._linear_compute_state(),2),r=e[0],n=e[1],i=new s.NumberArray(t.length),a=0;a<t.length;a++)i[a]=(t[a]-n)/r;return i},e.prototype._linear_compute_state=function(){var t=this.source_range.start,e=this.source_range.end,r=this.target_range.start,n=(this.target_range.end-r)/(e-t);return[n,-n*t+r]},e}(a.Transform);r.Scale=c,c.__name__="Scale",c.init_Scale()},
function _(r,o,t,e,n){e(),n("CustomJSTransform",r(268).CustomJSTransform),n("Dodge",r(269).Dodge),n("Interpolator",r(271).Interpolator),n("Jitter",r(272).Jitter),n("LinearInterpolator",r(273).LinearInterpolator),n("StepInterpolator",r(274).StepInterpolator),n("Transform",r(254).Transform)},
function _(t,r,n,e,o){e();var s=t(1),i=t(254),u=t(128),a=t(144),f=function(t){function r(r){return t.call(this,r)||this}return s.__extends(r,t),r.init_CustomJSTransform=function(){this.define((function(t){var r=t.Unknown,n=t.String;return{args:[(0,t.Dict)(r),{}],func:[n,""],v_func:[n,""]}}))},Object.defineProperty(r.prototype,"names",{get:function(){return u.keys(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(r.prototype,"values",{get:function(){return u.values(this.args)},enumerable:!1,configurable:!0}),r.prototype._make_transform=function(t,r){return new(Function.bind.apply(Function,s.__spread([void 0],this.names,[t,a.use_strict(r)])))},Object.defineProperty(r.prototype,"scalar_transform",{get:function(){return this._make_transform("x",this.func)},enumerable:!1,configurable:!0}),Object.defineProperty(r.prototype,"vector_transform",{get:function(){return this._make_transform("xs",this.v_func)},enumerable:!1,configurable:!0}),r.prototype.compute=function(t){return this.scalar_transform.apply(this,s.__spread(this.values,[t]))},r.prototype.v_compute=function(t){return this.vector_transform.apply(this,s.__spread(this.values,[t]))},r}(i.Transform);n.CustomJSTransform=f,f.__name__="CustomJSTransform",f.init_CustomJSTransform()},
function _(n,t,e,i,o){i();var u=n(1),r=function(n){function t(t){return n.call(this,t)||this}return u.__extends(t,n),t.init_Dodge=function(){this.define((function(n){return{value:[n.Number,0]}}))},t.prototype._compute=function(n){return n+this.value},t}(n(270).RangeTransform);e.Dodge=r,r.__name__="Dodge",r.init_Dodge()},
function _(n,e,r,t,i){t();var a=n(1),o=n(254),s=n(208),u=n(207),f=n(139),c=n(123),h=function(n){function e(e){return n.call(this,e)||this}return a.__extends(e,n),e.init_RangeTransform=function(){this.define((function(n){return{range:[(0,n.Ref)(s.Range)]}}))},e.prototype.v_compute=function(n){var e;if(this.range instanceof u.FactorRange)e=this.range.v_synthetic(n);else{if(!c.isArrayableOf(n,c.isNumber))throw new Error("unexpected");e=n}for(var r=new f.NumberArray(e.length),t=0;t<e.length;t++){var i=e[t];r[t]=this._compute(i)}return r},e.prototype.compute=function(n){if(this.range instanceof u.FactorRange)return this._compute(this.range.synthetic(n));if(c.isNumber(n))return this._compute(n);throw new Error("unexpected")},e}(o.Transform);r.RangeTransform=h,h.__name__="RangeTransform",h.init_RangeTransform()},
function _(t,r,e,n,o){n();var i=t(1),a=t(254),s=t(200),h=t(139),l=t(124),d=t(123),u=function(t){function r(r){var e=t.call(this,r)||this;return e._sorted_dirty=!0,e}return i.__extends(r,t),r.init_Interpolator=function(){this.define((function(t){var r=t.Boolean,e=t.Number,n=t.String,o=t.Ref,i=t.Array,a=t.Or,h=t.Nullable;return{x:[a(n,i(e))],y:[a(n,i(e))],data:[h(o(s.ColumnarDataSource)),null],clip:[r,!0]}}))},r.prototype.connect_signals=function(){var r=this;t.prototype.connect_signals.call(this),this.connect(this.change,(function(){return r._sorted_dirty=!0}))},r.prototype.v_compute=function(t){for(var r=new h.NumberArray(t.length),e=0;e<t.length;e++){var n=t[e];r[e]=this.compute(n)}return r},r.prototype.sort=function(t){if(void 0===t&&(t=!1),this._sorted_dirty){var r,e;if(d.isString(this.x)&&d.isString(this.y)&&null!=this.data){var n=this.data.columns();if(!l.includes(n,this.x))throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");if(!l.includes(n,this.y))throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");r=this.data.get_column(this.x),e=this.data.get_column(this.y)}else{if(!d.isArray(this.x)||!d.isArray(this.y))throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");r=this.x,e=this.y}if(r.length!==e.length)throw new Error("The length for x and y do not match");if(r.length<2)throw new Error("x and y must have at least two elements to support interpolation");for(var o=r.length,i=new Uint32Array(o),a=0;a<o;a++)i[a]=a;var s=t?-1:1;i.sort((function(t,e){return s*(r[t]-r[e])})),this._x_sorted=new h.NumberArray(o),this._y_sorted=new h.NumberArray(o);for(a=0;a<o;a++)this._x_sorted[a]=r[i[a]],this._y_sorted[a]=e[i[a]];this._sorted_dirty=!1}},r}(a.Transform);e.Interpolator=u,u.__name__="Interpolator",u.init_Interpolator()},
function _(t,i,n,r,e){r();var u=t(1),o=t(270),s=t(135),a=u.__importStar(t(125)),h=function(t){function i(i){return t.call(this,i)||this}return u.__extends(i,t),i.init_Jitter=function(){this.define((function(t){var i=t.Number;return{mean:[i,0],width:[i,1],distribution:[s.Distribution,"uniform"]}}))},i.prototype.v_compute=function(i){return null!=this.previous_values&&this.previous_values.length==i.length||(this.previous_values=t.prototype.v_compute.call(this,i)),this.previous_values},i.prototype._compute=function(t){switch(this.distribution){case"uniform":return t+this.mean+(a.random()-.5)*this.width;case"normal":return t+a.rnorm(this.mean,this.width)}},i}(o.RangeTransform);n.Jitter=h,h.__name__="Jitter",h.init_Jitter()},
function _(t,r,_,e,s){e();var i=t(1),o=t(124),n=function(t){function r(r){return t.call(this,r)||this}return i.__extends(r,t),r.prototype.compute=function(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}if(t==this._x_sorted[0])return this._y_sorted[0];var r=o.find_last_index(this._x_sorted,(function(r){return r<t})),_=this._x_sorted[r],e=this._x_sorted[r+1],s=this._y_sorted[r],i=this._y_sorted[r+1];return s+(t-_)/(e-_)*(i-s)},r}(t(271).Interpolator);_.LinearInterpolator=n,n.__name__="LinearInterpolator"},
function _(t,e,r,n,i){n();var o=t(1),s=t(271),_=t(135),d=t(124),h=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_StepInterpolator=function(){this.define((function(){return{mode:[_.StepMode,"after"]}}))},e.prototype.compute=function(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}var e;switch(this.mode){case"after":e=d.find_last_index(this._x_sorted,(function(e){return t>=e}));break;case"before":e=d.find_index(this._x_sorted,(function(e){return t<=e}));break;case"center":var r=this._x_sorted.map((function(e){return Math.abs(e-t)})),n=d.min(r);e=d.find_index(r,(function(t){return n===t}));break;default:throw new Error("unknown mode: "+this.mode)}return-1!=e?this._y_sorted[e]:NaN},e}(s.Interpolator);r.StepInterpolator=h,h.__name__="StepInterpolator",h.init_StepInterpolator()},
function _(t,e,n,s,i){s();var r=t(1),a=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_Range1d=function(){this.define((function(t){var e=t.Number,n=t.Nullable;return{start:[e,0],end:[e,1],reset_start:[n(e),null,{on_update:function(t,e){e._reset_start=null!=t?t:e.start}}],reset_end:[n(e),null,{on_update:function(t,e){e._reset_end=null!=t?t:e.end}}]}}))},e.prototype._set_auto_bounds=function(){if("auto"==this.bounds){var t=Math.min(this._reset_start,this._reset_end),e=Math.max(this._reset_start,this._reset_end);this.setv({bounds:[t,e]},{silent:!0})}},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._set_auto_bounds()},Object.defineProperty(e.prototype,"min",{get:function(){return Math.min(this.start,this.end)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"max",{get:function(){return Math.max(this.start,this.end)},enumerable:!1,configurable:!0}),e.prototype.reset=function(){this._set_auto_bounds();var t=this._reset_start,e=this._reset_end;this.start!=t||this.end!=e?this.setv({start:t,end:e}):this.change.emit()},e.prototype.map=function(t){return new e({start:t(this.start),end:t(this.end)})},e.prototype.widen=function(t){var n=this.start,s=this.end;return this.is_reversed?(n+=t,s-=t):(n-=t,s+=t),new e({start:n,end:s})},e}(t(208).Range);n.Range1d=a,a.__name__="Range1d",a.init_Range1d()},
function _(n,t,r,e,i){e();var a=n(1),o=n(266),u=n(139),c=n(124),s=n(127),_=function(n){function t(t){return n.call(this,t)||this}return a.__extends(t,n),t.init_LinearInterpolationScale=function(){this.internal((function(n){return{binning:[n.Arrayable]}}))},t.prototype.compute=function(n){return n},t.prototype.v_compute=function(n){var t=this,r=s.norm(n,this.source_range.start,this.source_range.end),e=c.linspace(0,1,this.binning.length),i=s.interpolate(r,e,this.binning),a=s.norm(i,this.source_range.start,this.source_range.end),o=this.target_range.end-this.target_range.start,_=s.map(a,(function(n){return t.target_range.start+n*o}));return new u.NumberArray(_)},t.prototype.invert=function(n){return n},t.prototype.v_invert=function(n){return new u.NumberArray(n)},t}(o.Scale);r.LinearInterpolationScale=_,_.__name__="LinearInterpolationScale",_.init_LinearInterpolationScale()},
function _(t,e,r,a,o){a();var n=t(1),_=t(265),i=t(139),h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.prototype.compute=function(t){var e,r=n.__read(this._compute_state(),4),a=r[0],o=r[1],_=r[2],i=r[3];if(0==_)e=0;else{var h=(Math.log(t)-i)/_;e=isFinite(h)?h*a+o:NaN}return e},e.prototype.v_compute=function(t){var e=n.__read(this._compute_state(),4),r=e[0],a=e[1],o=e[2],_=e[3],h=new i.NumberArray(t.length);if(0==o)for(var u=0;u<t.length;u++)h[u]=0;else for(u=0;u<t.length;u++){var s=(Math.log(t[u])-_)/o,c=void 0;c=isFinite(s)?s*r+a:NaN,h[u]=c}return h},e.prototype.invert=function(t){var e=n.__read(this._compute_state(),4),r=e[0],a=e[1],o=e[2],_=e[3],i=(t-a)/r;return Math.exp(o*i+_)},e.prototype.v_invert=function(t){for(var e=n.__read(this._compute_state(),4),r=e[0],a=e[1],o=e[2],_=e[3],h=new i.NumberArray(t.length),u=0;u<t.length;u++){var s=(t[u]-a)/r;h[u]=Math.exp(o*s+_)}return h},e.prototype._get_safe_factor=function(t,e){var r,a=t<0?0:t,o=e<0?0:e;if(a==o)if(0==a)a=(r=n.__read([1,10],2))[0],o=r[1];else{var _=Math.log(a)/Math.log(10);a=Math.pow(10,Math.floor(_)),o=Math.ceil(_)!=Math.floor(_)?Math.pow(10,Math.ceil(_)):Math.pow(10,Math.ceil(_)+1)}return[a,o]},e.prototype._compute_state=function(){var t,e,r=this.source_range.start,a=this.source_range.end,o=this.target_range.start,_=this.target_range.end-o,i=n.__read(this._get_safe_factor(r,a),2),h=i[0],u=i[1];return 0==h?(t=Math.log(u),e=0):(t=Math.log(u)-Math.log(h),e=Math.log(h)),[_,o,t,e]},e}(_.ContinuousScale);r.LogScale=h,h.__name__="LogScale"},
function _(e,t,n,i,l){i();var o=e(187),a=new Map;n.measure_font=function(e){var t=a.get(e);if(null!=t)return t;var n=o.span({style:{font:e}},"Hg"),i=o.div({style:{display:"inline-block",width:"1px",height:"0px"}}),l=o.div({},n,i);document.body.appendChild(l);try{i.style.verticalAlign="baseline";var r=o.offset(i).top-o.offset(n).top;i.style.verticalAlign="bottom";var d=o.offset(i).top-o.offset(n).top,s={height:d,ascent:r,descent:d-r};return a.set(e,s),s}finally{document.body.removeChild(l)}};var r=new Map;n.measure_text=function(e,t){var n=r.get(t);if(null!=n){var i=n.get(e);if(null!=i)return i}else n=new Map,r.set(t,n);var l=o.div({style:{display:"inline-block","white-space":"nowrap",font:t}},e);document.body.appendChild(l);try{var a=l.getBoundingClientRect(),d=a.width,s=a.height;return n.set(e,{width:d,height:s}),{width:d,height:s}}finally{document.body.removeChild(l)}}},
function _(t,e,i,n,s){n();var a=t(1),l=t(280),o=t(135),r=a.__importStar(t(143)),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.visuals.warm_cache()},e.prototype._get_size=function(){var t=this.layer.ctx;this.visuals.text.set_value(t);var e=t.measureText(this.model.text);return{width:e.width,height:e.ascent}},e.prototype._render=function(){var t;switch(this.model.angle_units){case"rad":t=-this.model.angle;break;case"deg":t=-this.model.angle*Math.PI/180}var e=null!=this.panel?this.panel:this.plot_view.frame,i=this.coordinates.x_scale,n=this.coordinates.y_scale,s="data"==this.model.x_units?i.compute(this.model.x):e.xview.compute(this.model.x),a="data"==this.model.y_units?n.compute(this.model.y):e.yview.compute(this.model.y);s+=this.model.x_offset,a-=this.model.y_offset,("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,this.model.text,s,a,t)},e}(l.TextAnnotationView);i.LabelView=_,_.__name__="LabelView";var h=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_Label=function(){this.prototype.default_view=_,this.mixins([r.Text,["border_",r.Line],["background_",r.Fill]]),this.define((function(t){var e=t.Number,i=t.String,n=t.Angle;return{x:[e],x_units:[o.SpatialUnits,"data"],y:[e],y_units:[o.SpatialUnits,"data"],text:[i],angle:[n,0],angle_units:[o.AngleUnits,"rad"],x_offset:[e,0],y_offset:[e,0]}})),this.override({background_fill_color:null,border_line_color:null})},e}(l.TextAnnotation);i.Label=h,h.__name__="Label",h.init_Label()},
function _(t,e,i,s,n){s();var o=t(1),a=t(151),l=t(187),r=t(135),u=t(278),_=t(126),c=function(t){function e(){var e=t.apply(this,o.__spread(arguments))||this;return e.rotate=!0,e}return o.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),"css"==this.model.render_mode&&(this.el=l.div(),this.plot_view.canvas_view.add_overlay(this.el))},e.prototype.remove=function(){null!=this.el&&l.remove(this.el),t.prototype.remove.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),"css"==this.model.render_mode?this.connect(this.model.change,(function(){return e.render()})):this.connect(this.model.change,(function(){return e.plot_view.request_render()}))},e.prototype.render=function(){this.model.visible||"css"!=this.model.render_mode||l.undisplay(this.el),t.prototype.render.call(this)},e.prototype._calculate_text_dimensions=function(t,e){return[t.measureText(e).width,u.measure_font(this.visuals.text.font_value()).height]},e.prototype._calculate_bounding_box_dimensions=function(t,e){var i,s,n=o.__read(this._calculate_text_dimensions(t,e),2),a=n[0],l=n[1];switch(t.textAlign){case"left":i=0;break;case"center":i=-a/2;break;case"right":i=-a;break;default:_.unreachable()}switch(t.textBaseline){case"top":s=0;break;case"middle":s=-.5*l;break;case"bottom":s=-1*l;break;case"alphabetic":s=-.8*l;break;case"hanging":s=-.17*l;break;case"ideographic":s=-.83*l;break;default:_.unreachable()}return[i,s,a,l]},e.prototype._canvas_text=function(t,e,i,s,n){this.visuals.text.set_value(t);var o=this._calculate_bounding_box_dimensions(t,e);t.save(),t.beginPath(),t.translate(i,s),n&&t.rotate(n),t.rect(o[0],o[1],o[2],o[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.stroke()),this.visuals.text.doit&&(this.visuals.text.set_value(t),t.fillText(e,0,0)),t.restore()},e.prototype._css_text=function(t,e,i,s,n){var o=this.el;_.assert(null!=o),l.undisplay(o),this.visuals.text.set_value(t);var a=this._calculate_bounding_box_dimensions(t,e),r=this.visuals.border_line.line_dash.value().length<2?"solid":"dashed";this.visuals.border_line.set_value(t),this.visuals.background_fill.set_value(t),o.style.position="absolute",o.style.left=i+a[0]+"px",o.style.top=s+a[1]+"px",o.style.color=""+this.visuals.text.text_color.value(),o.style.opacity=""+this.visuals.text.text_alpha.value(),o.style.font=""+this.visuals.text.font_value(),o.style.lineHeight="normal",n&&(o.style.transform="rotate("+n+"rad)"),this.visuals.background_fill.doit&&(o.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(o.style.borderStyle=""+r,o.style.borderWidth=this.visuals.border_line.line_width.value()+"px",o.style.borderColor=""+this.visuals.border_line.color_value()),o.textContent=e,l.display(o)},e}(a.AnnotationView);i.TextAnnotationView=c,c.__name__="TextAnnotationView";var d=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_TextAnnotation=function(){this.define((function(){return{render_mode:[r.RenderMode,"canvas"]}}))},e}(a.Annotation);i.TextAnnotation=d,d.__name__="TextAnnotation",d.init_TextAnnotation()},
function _(t,e,i,s,o){s();var n=t(1),a=t(280),r=t(237),l=n.__importStar(t(143)),_=t(135),c=t(187),u=n.__importStar(t(133)),d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){if(t.prototype.initialize.call(this),this.set_data(this.model.source),"css"==this.model.render_mode)for(var e=0,i=this._text.length;e<i;e++){var s=c.div({style:{display:"none"}});this.el.appendChild(s)}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),"css"==this.model.render_mode?(this.connect(this.model.change,(function(){e.set_data(e.model.source),e.render()})),this.connect(this.model.source.streaming,(function(){e.set_data(e.model.source),e.render()})),this.connect(this.model.source.patching,(function(){e.set_data(e.model.source),e.render()})),this.connect(this.model.source.change,(function(){e.set_data(e.model.source),e.render()}))):(this.connect(this.model.change,(function(){e.set_data(e.model.source),e.plot_view.request_render()})),this.connect(this.model.source.streaming,(function(){e.set_data(e.model.source),e.plot_view.request_render()})),this.connect(this.model.source.patching,(function(){e.set_data(e.model.source),e.plot_view.request_render()})),this.connect(this.model.source.change,(function(){e.set_data(e.model.source),e.plot_view.request_render()})))},e.prototype.set_data=function(e){t.prototype.set_data.call(this,e),this.visuals.warm_cache(e)},e.prototype._map_data=function(){var t=this.coordinates.x_scale,e=this.coordinates.y_scale,i=null!=this.panel?this.panel:this.plot_view.frame;return["data"==this.model.x_units?t.v_compute(this._x):i.xview.v_compute(this._x),"data"==this.model.y_units?e.v_compute(this._y):i.yview.v_compute(this._y)]},e.prototype._render=function(){for(var t="canvas"==this.model.render_mode?this._v_canvas_text.bind(this):this._v_css_text.bind(this),e=this.layer.ctx,i=n.__read(this._map_data(),2),s=i[0],o=i[1],a=0,r=this._text.length;a<r;a++)t(e,a,this._text[a],s[a]+this._x_offset[a],o[a]-this._y_offset[a],this._angle[a])},e.prototype._get_size=function(){var t=this.layer.ctx;this.visuals.text.set_value(t);var e=t.measureText(this._text[0]);return{width:e.width,height:e.ascent}},e.prototype._v_canvas_text=function(t,e,i,s,o,n){this.visuals.text.set_vectorize(t,e);var a=this._calculate_bounding_box_dimensions(t,i);t.save(),t.beginPath(),t.translate(s,o),t.rotate(n),t.rect(a[0],a[1],a[2],a[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),t.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),t.stroke()),this.visuals.text.doit&&(this.visuals.text.set_vectorize(t,e),t.fillText(i,0,0)),t.restore()},e.prototype._v_css_text=function(t,e,i,s,o,n){var a=this.el.children[e];a.textContent=i,this.visuals.text.set_vectorize(t,e);var r=this._calculate_bounding_box_dimensions(t,i),l=this.visuals.border_line.line_dash.value().length<2?"solid":"dashed";this.visuals.border_line.set_vectorize(t,e),this.visuals.background_fill.set_vectorize(t,e),a.style.position="absolute",a.style.left=s+r[0]+"px",a.style.top=o+r[1]+"px",a.style.color=""+this.visuals.text.text_color.value(),a.style.opacity=""+this.visuals.text.text_alpha.value(),a.style.font=""+this.visuals.text.font_value(),a.style.lineHeight="normal",n&&(a.style.transform="rotate("+n+"rad)"),this.visuals.background_fill.doit&&(a.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(a.style.borderStyle=""+l,a.style.borderWidth=this.visuals.border_line.line_width.value()+"px",a.style.borderColor=""+this.visuals.border_line.color_value()),c.display(a)},e}(a.TextAnnotationView);i.LabelSetView=d,d.__name__="LabelSetView";var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_LabelSet=function(){this.prototype.default_view=d,this.mixins([l.TextVector,["border_",l.LineVector],["background_",l.FillVector]]),this.define((function(t){var e=t.Ref;return{x:[u.XCoordinateSpec],y:[u.YCoordinateSpec],x_units:[_.SpatialUnits,"data"],y_units:[_.SpatialUnits,"data"],text:[u.StringSpec,{field:"text"}],angle:[u.AngleSpec,0],x_offset:[u.NumberSpec,{value:0}],y_offset:[u.NumberSpec,{value:0}],source:[e(r.ColumnDataSource),function(){return new r.ColumnDataSource}]}})),this.override({background_fill_color:null,border_line_color:null})},e}(a.TextAnnotation);i.LabelSet=h,h.__name__="LabelSet",h.init_LabelSet()},
function _(e,t,i,r,l){r();var n=e(1),a=e(151),o=e(283),s=e(135),_=n.__importStar(e(143)),h=e(130),d=e(278),c=e(194),u=e(124),f=e(123),v=e(126),g=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.cursor=function(e,t){return"none"==this.model.click_policy?null:"pointer"},Object.defineProperty(t.prototype,"legend_padding",{get:function(){return null!=this.visuals.border_line.line_color.value()?this.model.padding:0},enumerable:!1,configurable:!0}),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return t.plot_view.request_render()})),this.connect(this.model.item_change,(function(){return t.plot_view.request_render()}))},t.prototype.compute_legend_bbox=function(){var e,t,i,r,l=this.model.get_legend_names(),a=this.model,o=a.glyph_height,s=a.glyph_width,_=this.model,h=_.label_height,g=_.label_width;this.max_label_height=u.max([d.measure_font(this.visuals.label_text.font_value()).height,h,o]);var m=this.layer.ctx;m.save(),this.visuals.label_text.set_value(m),this.text_widths=new Map;try{for(var p=n.__values(l),x=p.next();!x.done;x=p.next()){var y=x.value;this.text_widths.set(y,u.max([m.measureText(y).width,g]))}}catch(t){e={error:t}}finally{try{x&&!x.done&&(t=p.return)&&t.call(p)}finally{if(e)throw e.error}}this.visuals.title_text.set_value(m),this.title_height=this.model.title?d.measure_font(this.visuals.title_text.font_value()).height+this.model.title_standoff:0,this.title_width=this.model.title?m.measureText(this.model.title).width:0,m.restore();var b,w,k=Math.max(u.max(n.__spread(this.text_widths.values())),0),L=this.model.margin,T=this.legend_padding,z=this.model.spacing,A=this.model.label_standoff;if("vertical"==this.model.orientation)b=l.length*this.max_label_height+Math.max(l.length-1,0)*z+2*T+this.title_height,w=u.max([k+s+A+2*T,this.title_width+2*T]);else{var B=2*T+Math.max(l.length-1,0)*z;try{for(var M=n.__values(this.text_widths),P=M.next();!P.done;P=M.next()){var S=n.__read(P.value,2)[1];B+=u.max([S,g])+s+A}}catch(e){i={error:e}}finally{try{P&&!P.done&&(r=M.return)&&r.call(M)}finally{if(i)throw i.error}}w=u.max([this.title_width+2*T,B]),b=this.max_label_height+this.title_height+2*T}var O,V,q=null!=this.panel?this.panel:this.plot_view.frame,F=n.__read(q.bbox.ranges,2),j=F[0],C=F[1],I=this.model.location;if(f.isString(I))switch(I){case"top_left":O=j.start+L,V=C.start+L;break;case"top_center":O=(j.end+j.start)/2-w/2,V=C.start+L;break;case"top_right":O=j.end-L-w,V=C.start+L;break;case"bottom_right":O=j.end-L-w,V=C.end-L-b;break;case"bottom_center":O=(j.end+j.start)/2-w/2,V=C.end-L-b;break;case"bottom_left":O=j.start+L,V=C.end-L-b;break;case"center_left":O=j.start+L,V=(C.end+C.start)/2-b/2;break;case"center":O=(j.end+j.start)/2-w/2,V=(C.end+C.start)/2-b/2;break;case"center_right":O=j.end-L-w,V=(C.end+C.start)/2-b/2}else if(f.isArray(I)&&2==I.length){var N=n.__read(I,2),R=N[0],D=N[1];O=q.xview.compute(R),V=q.yview.compute(D)-b}else v.unreachable();return new c.BBox({left:O,top:V,width:w,height:b})},t.prototype.interactive_bbox=function(){return this.compute_legend_bbox()},t.prototype.interactive_hit=function(e,t){return this.interactive_bbox().contains(e,t)},t.prototype.on_hit=function(e,t){var i,r,l,a,o,s,_,h,d,u,f,v=this.model.glyph_width,g=this.legend_padding,m=this.model.spacing,p=this.model.label_standoff,x=f=g,y=this.compute_legend_bbox(),b="vertical"==this.model.orientation;try{for(var w=n.__values(this.model.items),k=w.next();!k.done;k=w.next()){var L=k.value,T=L.get_labels_list_from_label_prop();try{for(var z=(l=void 0,n.__values(T)),A=z.next();!A.done;A=z.next()){var B=A.value,M=y.x+x,P=y.y+f+this.title_height,S=void 0,O=void 0;if(b?(S=(o=n.__read([y.width-2*g,this.max_label_height],2))[0],O=o[1]):(S=(s=n.__read([this.text_widths.get(B)+v+p,this.max_label_height],2))[0],O=s[1]),new c.BBox({left:M,top:P,width:S,height:O}).contains(e,t)){switch(this.model.click_policy){case"hide":try{for(var V=(_=void 0,n.__values(L.renderers)),q=V.next();!q.done;q=V.next()){(C=q.value).visible=!C.visible}}catch(e){_={error:e}}finally{try{q&&!q.done&&(h=V.return)&&h.call(V)}finally{if(_)throw _.error}}break;case"mute":try{for(var F=(d=void 0,n.__values(L.renderers)),j=F.next();!j.done;j=F.next()){var C;(C=j.value).muted=!C.muted}}catch(e){d={error:e}}finally{try{j&&!j.done&&(u=F.return)&&u.call(F)}finally{if(d)throw d.error}}}return!0}b?f+=this.max_label_height+m:x+=this.text_widths.get(B)+v+p+m}}catch(e){l={error:e}}finally{try{A&&!A.done&&(a=z.return)&&a.call(z)}finally{if(l)throw l.error}}}}catch(e){i={error:e}}finally{try{k&&!k.done&&(r=w.return)&&r.call(w)}finally{if(i)throw i.error}}return!1},t.prototype._render=function(){var e,t;if(0!=this.model.items.length){try{for(var i=n.__values(this.model.items),r=i.next();!r.done;r=i.next()){r.value.legend=this.model}}catch(t){e={error:t}}finally{try{r&&!r.done&&(t=i.return)&&t.call(i)}finally{if(e)throw e.error}}var l=this.layer.ctx,a=this.compute_legend_bbox();l.save(),this._draw_legend_box(l,a),this._draw_legend_items(l,a),this.model.title&&this._draw_title(l,a),l.restore()}},t.prototype._draw_legend_box=function(e,t){e.beginPath(),e.rect(t.x,t.y,t.width,t.height),this.visuals.background_fill.set_value(e),e.fill(),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(e),e.stroke())},t.prototype._draw_legend_items=function(e,t){var i,r,l=this,a=this.model,o=a.glyph_width,s=a.glyph_height,_=this.legend_padding,h=this.model.spacing,d=this.model.label_standoff,c=_,f=_,v="vertical"==this.model.orientation,g=function(i){var r,a,g,p,x,y,b=i.get_labels_list_from_label_prop(),w=i.get_field_from_label_prop();if(0==b.length)return"continue";var k=function(){switch(l.model.click_policy){case"none":return!0;case"hide":return u.every(i.renderers,(function(e){return e.visible}));case"mute":return u.every(i.renderers,(function(e){return!e.muted}))}}();try{for(var L=(r=void 0,n.__values(b)),T=L.next();!T.done;T=L.next()){var z=T.value,A=t.x+c,B=t.y+f+m.title_height,M=A+o,P=B+s;v?f+=m.max_label_height+h:c+=m.text_widths.get(z)+o+d+h,m.visuals.label_text.set_value(e),e.fillText(z,M+d,B+m.max_label_height/2);try{for(var S=(g=void 0,n.__values(i.renderers)),O=S.next();!O.done;O=S.next()){var V=O.value,q=m.plot_view.renderer_view(V);null==q||q.draw_legend(e,A,M,B,P,w,z,i.index)}}catch(e){g={error:e}}finally{try{O&&!O.done&&(p=S.return)&&p.call(S)}finally{if(g)throw g.error}}if(!k){var F=void 0,j=void 0;v?(F=(x=n.__read([t.width-2*_,m.max_label_height],2))[0],j=x[1]):(F=(y=n.__read([m.text_widths.get(z)+o+d,m.max_label_height],2))[0],j=y[1]),e.beginPath(),e.rect(A,B,F,j),m.visuals.inactive_fill.set_value(e),e.fill()}}}catch(e){r={error:e}}finally{try{T&&!T.done&&(a=L.return)&&a.call(L)}finally{if(r)throw r.error}}},m=this;try{for(var p=n.__values(this.model.items),x=p.next();!x.done;x=p.next()){g(x.value)}}catch(e){i={error:e}}finally{try{x&&!x.done&&(r=p.return)&&r.call(p)}finally{if(i)throw i.error}}},t.prototype._draw_title=function(e,t){this.visuals.title_text.doit&&(e.save(),e.translate(t.x0,t.y0+this.title_height),this.visuals.title_text.set_value(e),e.fillText(this.model.title,this.legend_padding,this.legend_padding-this.model.title_standoff),e.restore())},t.prototype._get_size=function(){var e=this.compute_legend_bbox(),t=e.width,i=e.height;return{width:t+2*this.model.margin,height:i+2*this.model.margin}},t}(a.AnnotationView);i.LegendView=g,g.__name__="LegendView";var m=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.item_change=new h.Signal0(this,"item_change")},t.init_Legend=function(){this.prototype.default_view=g,this.mixins([["label_",_.Text],["title_",_.Text],["inactive_",_.Fill],["border_",_.Line],["background_",_.Fill]]),this.define((function(e){var t=e.Number,i=e.String,r=e.Array,l=e.Tuple,n=e.Or,a=e.Ref;return{orientation:[s.Orientation,"vertical"],location:[n(s.LegendLocation,l(t,t)),"top_right"],title:[i],title_standoff:[t,5],label_standoff:[t,5],glyph_height:[t,20],glyph_width:[t,20],label_height:[t,20],label_width:[t,20],margin:[t,10],padding:[t,10],spacing:[t,3],items:[r(a(o.LegendItem)),[]],click_policy:[s.LegendClickPolicy,"none"]}})),this.override({border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,inactive_fill_color:"white",inactive_fill_alpha:.7,label_text_font_size:"13px",label_text_baseline:"middle",title_text_font_size:"13px",title_text_font_style:"italic"})},t.prototype.get_legend_names=function(){var e,t,i=[];try{for(var r=n.__values(this.items),l=r.next();!l.done;l=r.next()){var a=l.value.get_labels_list_from_label_prop();i.push.apply(i,n.__spread(a))}}catch(t){e={error:t}}finally{try{l&&!l.done&&(t=r.return)&&t.call(r)}finally{if(e)throw e.error}}return i},t}(a.Annotation);i.Legend=m,m.__name__="Legend",m.init_Legend()},
function _(e,r,n,t,l){t();var i=e(1),o=e(196),a=e(210),u=e(200),_=e(284),s=i.__importStar(e(133)),d=e(134),c=e(124),f=function(e){function r(r){return e.call(this,r)||this}return i.__extends(r,e),r.init_LegendItem=function(){this.define((function(e){var r=e.Int,n=e.Array,t=e.Ref,l=e.Nullable;return{label:[s.NullStringSpec,null],renderers:[n(t(a.GlyphRenderer)),[]],index:[l(r),null]}}))},r.prototype._check_data_sources_on_renderers=function(){var e,r;if(null!=this.get_field_from_label_prop()){if(this.renderers.length<1)return!1;var n=this.renderers[0].data_source;if(null!=n)try{for(var t=i.__values(this.renderers),l=t.next();!l.done;l=t.next()){if(l.value.data_source!=n)return!1}}catch(r){e={error:r}}finally{try{l&&!l.done&&(r=t.return)&&r.call(t)}finally{if(e)throw e.error}}}return!0},r.prototype._check_field_label_on_data_source=function(){var e=this.get_field_from_label_prop();if(null!=e){if(this.renderers.length<1)return!1;var r=this.renderers[0].data_source;if(null!=r&&!c.includes(r.columns(),e))return!1}return!0},r.prototype.initialize=function(){var r=this;e.prototype.initialize.call(this),this.legend=null,this.connect(this.change,(function(){var e;return null===(e=r.legend)||void 0===e?void 0:e.item_change.emit()})),this._check_data_sources_on_renderers()||d.logger.error("Non matching data sources on legend item renderers"),this._check_field_label_on_data_source()||d.logger.error("Bad column name on label: "+this.label)},r.prototype.get_field_from_label_prop=function(){var e=this.label;return _.isField(e)?e.field:null},r.prototype.get_labels_list_from_label_prop=function(){if(_.isValue(this.label)){var e=this.label.value;return null!=e?[e]:[]}var r=this.get_field_from_label_prop();if(null!=r){var n=void 0;if(!this.renderers[0]||null==this.renderers[0].data_source)return["No source found"];if((n=this.renderers[0].data_source)instanceof u.ColumnarDataSource){var t=n.get_column(r);return null!=t?c.uniq(Array.from(t)):["Invalid field"]}}return[]},r}(o.Model);n.LegendItem=f,f.__name__="LegendItem",f.init_LegendItem()},
function _(i,n,e,t,u){t();var l=i(123);e.isValue=function(i){return l.isPlainObject(i)&&"value"in i},e.isField=function(i){return l.isPlainObject(i)&&"field"in i}},
function _(t,n,i,e,o){e();var s=t(1),l=t(151),a=s.__importStar(t(143)),r=t(135),c=t(130),u=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(n,t),n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return n.plot_view.request_render()})),this.connect(this.model.data_update,(function(){return n.plot_view.request_render()}))},n.prototype._render=function(){var t=this.model,n=t.xs,i=t.ys;if(n.length==i.length&&!(n.length<3||i.length<3)){for(var e=this.plot_view.frame,o=this.layer.ctx,s=0,l=n.length;s<l;s++){var a=void 0;if("screen"!=this.model.xs_units)throw new Error("not implemented");a=this.model.screen?n[s]:e.xview.compute(n[s]);var r=void 0;if("screen"!=this.model.ys_units)throw new Error("not implemented");r=this.model.screen?i[s]:e.yview.compute(i[s]),0==s?(o.beginPath(),o.moveTo(a,r)):o.lineTo(a,r)}o.closePath(),this.visuals.line.doit&&(this.visuals.line.set_value(o),o.stroke()),this.visuals.fill.doit&&(this.visuals.fill.set_value(o),o.fill())}},n}(l.AnnotationView);i.PolyAnnotationView=u,u.__name__="PolyAnnotationView";var h=function(t){function n(n){return t.call(this,n)||this}return s.__extends(n,t),n.init_PolyAnnotation=function(){this.prototype.default_view=u,this.mixins([a.Line,a.Fill]),this.define((function(t){var n=t.Number,i=t.Array;return{xs:[i(n),[]],xs_units:[r.SpatialUnits,"data"],ys:[i(n),[]],ys_units:[r.SpatialUnits,"data"]}})),this.internal((function(t){return{screen:[t.Boolean,!1]}})),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},n.prototype.initialize=function(){t.prototype.initialize.call(this),this.data_update=new c.Signal0(this,"data_update")},n.prototype.update=function(t){var n=t.xs,i=t.ys;this.setv({xs:n,ys:i,screen:!0},{silent:!0}),this.data_update.emit()},n}(l.Annotation);i.PolyAnnotation=h,h.__name__="PolyAnnotation",h.init_PolyAnnotation()},
function _(t,e,i,n,o){n();var r=t(1),l=t(151),s=r.__importStar(t(143)),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return e.plot_view.request_render()}))},e.prototype._render=function(){var t=this.model.gradient,e=this.model.y_intercept;if(null!=t&&null!=e){var i,n,o,r,l=this.plot_view.frame,s=this.coordinates.x_scale,a=this.coordinates.y_scale;if(0==t)n=i=a.compute(e),r=(o=l.bbox.left)+l.bbox.width;else{n=(i=l.bbox.top)+l.bbox.height;var c=(a.invert(i)-e)/t,u=(a.invert(n)-e)/t;o=s.compute(c),r=s.compute(u)}var _=this.layer.ctx;_.save(),_.beginPath(),this.visuals.line.set_value(_),_.moveTo(o,i),_.lineTo(r,n),_.stroke(),_.restore()}},e}(l.AnnotationView);i.SlopeView=a,a.__name__="SlopeView";var c=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_Slope=function(){this.prototype.default_view=a,this.mixins(s.Line),this.define((function(t){var e=t.Number,i=t.Nullable;return{gradient:[i(e),null],y_intercept:[i(e),null]}})),this.override({line_color:"black"})},e}(l.Annotation);i.Slope=c,c.__name__="Slope",c.init_Slope()},
function _(t,n,i,e,o){e();var r=t(1),a=t(151),s=r.__importStar(t(143)),l=t(135),h=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return n.plot_view.request_paint(n)}))},n.prototype._render=function(){var t=this,n=this.model.location;if(null!=n){var i,e,o,r,a=this.plot_view.frame,s=this.coordinates.x_scale,l=this.coordinates.y_scale,h=function(i,e){return"data"==t.model.location_units?i.compute(n):t.model.for_hover?n:e.compute(n)};"width"==this.model.dimension?(o=h(l,a.yview),e=a.bbox.left,r=a.bbox.width,i=this.model.properties.line_width.value()):(o=a.bbox.top,e=h(s,a.xview),r=this.model.properties.line_width.value(),i=a.bbox.height);var c=this.layer.ctx;c.save(),c.beginPath(),this.visuals.line.set_value(c),c.moveTo(e,o),"width"==this.model.dimension?c.lineTo(e+r,o):c.lineTo(e,o+i),c.stroke(),c.restore()}},n}(a.AnnotationView);i.SpanView=h,h.__name__="SpanView";var c=function(t){function n(n){return t.call(this,n)||this}return r.__extends(n,t),n.init_Span=function(){this.prototype.default_view=h,this.mixins(s.Line),this.define((function(t){var n=t.Number,i=t.Nullable;return{render_mode:[l.RenderMode,"canvas"],location:[i(n),null],location_units:[l.SpatialUnits,"data"],dimension:[l.Dimension,"width"]}})),this.internal((function(t){return{for_hover:[t.Boolean,!1]}})),this.override({line_color:"black"})},n}(a.Annotation);i.Span=c,c.__name__="Span",c.init_Span()},
function _(t,e,i,l,n){l();var a=t(1),r=t(280),o=t(135),s=t(189),c=a.__importStar(t(143)),h=a.__importStar(t(133)),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.visuals.text=new s.Text(this.model)},e.prototype._get_location=function(){var t,e,i=this.panel,l=this.model.offset,n=i.bbox;switch(i.side){case"above":case"below":switch(this.model.vertical_align){case"top":e=n.top+5;break;case"middle":e=n.vcenter;break;case"bottom":e=n.bottom-5}switch(this.model.align){case"left":t=n.left+l;break;case"center":t=n.hcenter;break;case"right":t=n.right-l}break;case"left":switch(this.model.vertical_align){case"top":t=n.left-5;break;case"middle":t=n.hcenter;break;case"bottom":t=n.right+5}switch(this.model.align){case"left":e=n.bottom-l;break;case"center":e=n.vcenter;break;case"right":e=n.top+l}break;case"right":switch(this.model.vertical_align){case"top":t=n.right-5;break;case"middle":t=n.hcenter;break;case"bottom":t=n.left+5}switch(this.model.align){case"left":e=n.top+l;break;case"center":e=n.vcenter;break;case"right":e=n.bottom-l}}return[t,e]},e.prototype._render=function(){var t=this.model.text;if(null!=t&&0!=t.length){this.model.text_baseline=this.model.vertical_align,this.model.text_align=this.model.align;var e=a.__read(this._get_location(),2),i=e[0],l=e[1],n=this.panel.get_label_angle_heuristic("parallel");("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,t,i,l,n)}},e.prototype._get_size=function(){var t=this.model.text;if(null==t||0==t.length)return{width:0,height:0};this.visuals.text.set_value(this.layer.ctx);var e=this.layer.ctx.measureText(t);return{width:e.width,height:e.ascent*this.visuals.text.text_line_height.value()+10}},e}(r.TextAnnotationView);i.TitleView=_,_.__name__="TitleView";var d=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_Title=function(){this.prototype.default_view=_,this.mixins([["border_",c.Line],["background_",c.Fill]]),this.define((function(t){var e=t.Number;return{text:[t.String],text_font:[h.Font,"helvetica"],text_font_size:[h.StringSpec,"13px"],text_font_style:[o.FontStyle,"bold"],text_color:[h.ColorSpec,"#444444"],text_alpha:[h.NumberSpec,1],text_line_height:[e,1],vertical_align:[o.VerticalAlign,"bottom"],align:[o.TextAlign,"left"],offset:[e,0]}})),this.internal((function(){return{text_align:[o.TextAlign,"left"],text_baseline:[o.TextBaseline,"bottom"]}})),this.override({background_fill_color:null,border_line_color:null})},e}(r.TextAnnotation);i.Title=d,d.__name__="Title",d.init_Title()},
function _(t,i,e,o,n){o();var l=t(1),r=t(151),a=t(290),s=t(230),_=t(187),h=t(194),p=function(t){function i(){var i=t.apply(this,l.__spread(arguments))||this;return i.rotate=!0,i._invalidate_toolbar=!0,i._previous_bbox=new h.BBox,i}return l.__extends(i,t),i.prototype.initialize=function(){t.prototype.initialize.call(this),this.el=_.div(),this.plot_view.canvas_view.add_event(this.el)},i.prototype.lazy_initialize=function(){return l.__awaiter(this,void 0,void 0,(function(){var i,e=this;return l.__generator(this,(function(o){switch(o.label){case 0:return[4,t.prototype.lazy_initialize.call(this)];case 1:return o.sent(),i=this,[4,s.build_view(this.model.toolbar,{parent:this})];case 2:return i._toolbar_view=o.sent(),this.plot_view.visibility_callbacks.push((function(t){return e._toolbar_view.set_visibility(t)})),[2]}}))}))},i.prototype.remove=function(){this._toolbar_view.remove(),_.remove(this.el),t.prototype.remove.call(this)},i.prototype.render=function(){this.model.visible||_.undisplay(this.el),t.prototype.render.call(this)},i.prototype._render=function(){var t=this.panel.bbox;this._previous_bbox.equals(t)||(_.position(this.el,t),this._previous_bbox=t),this._invalidate_toolbar&&(this.el.style.position="absolute",this.el.style.overflow="hidden",this._toolbar_view.render(),_.empty(this.el),this.el.appendChild(this._toolbar_view.el),this._invalidate_toolbar=!1),_.display(this.el)},i.prototype._get_size=function(){var t=this.model.toolbar,i=t.tools,e=t.logo;return{width:30*i.length+(null!=e?25:0),height:30}},i}(r.AnnotationView);e.ToolbarPanelView=p,p.__name__="ToolbarPanelView";var u=function(t){function i(i){return t.call(this,i)||this}return l.__extends(i,t),i.init_ToolbarPanel=function(){this.prototype.default_view=p,this.define((function(t){return{toolbar:[(0,t.Ref)(a.Toolbar)]}}))},i}(r.Annotation);e.ToolbarPanel=u,u.__name__="ToolbarPanel",u.init_ToolbarPanel()},
function _(t,e,r,i,n){i();var a=t(1),o=t(123),l=t(124),c=t(128),s=t(291),u=t(292),v=t(304),_=t(305);r.Drag=s.Tool,r.Inspection=s.Tool,r.Scroll=s.Tool,r.Tap=s.Tool;var h=function(t){switch(t){case"tap":return"active_tap";case"pan":return"active_drag";case"pinch":case"scroll":return"active_scroll";case"multi":return"active_multi"}return null},f=function(t){return"tap"==t||"pan"==t},p=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_Toolbar=function(){this.prototype.default_view=_.ToolbarBaseView,this.define((function(t){var e=t.Or,i=t.Ref,n=t.Auto,a=t.Null,o=t.Nullable;return{active_drag:[e(i(r.Drag),n,a),"auto"],active_inspect:[e(i(r.Inspection),n,a),"auto"],active_scroll:[e(i(r.Scroll),n,a),"auto"],active_tap:[e(i(r.Tap),n,a),"auto"],active_multi:[o(i(u.GestureTool)),null]}}))},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var r=this.properties,i=r.tools,n=r.active_drag,a=r.active_inspect,o=r.active_scroll,l=r.active_tap,c=r.active_multi;this.on_change([i,n,a,o,l,c],(function(){return e._init_tools()}))},e.prototype._init_tools=function(){var e,r,i,n,s,u,_,p,y,d,g,T,x=this;if(t.prototype._init_tools.call(this),"auto"==this.active_inspect);else if(this.active_inspect instanceof v.InspectTool){var w=!1;try{for(var b=a.__values(this.inspectors),m=b.next();!m.done;m=b.next()){(D=m.value)!=this.active_inspect?D.active=!1:w=!0}}catch(t){e={error:t}}finally{try{m&&!m.done&&(r=b.return)&&r.call(b)}finally{if(e)throw e.error}}w||(this.active_inspect=null)}else if(o.isArray(this.active_inspect)){var I=l.intersection(this.active_inspect,this.inspectors);I.length!=this.active_inspect.length&&(this.active_inspect=I);try{for(var A=a.__values(this.inspectors),B=A.next();!B.done;B=A.next()){var D=B.value;l.includes(this.active_inspect,D)||(D.active=!1)}}catch(t){i={error:t}}finally{try{B&&!B.done&&(n=A.return)&&n.call(A)}finally{if(i)throw i.error}}}else if(null==this.active_inspect)try{for(var N=a.__values(this.inspectors),S=N.next();!S.done;S=N.next()){(D=S.value).active=!1}}catch(t){s={error:t}}finally{try{S&&!S.done&&(u=N.return)&&u.call(N)}finally{if(s)throw s.error}}var G=function(t){t.active?x._active_change(t):t.active=!0};try{for(var O=a.__values(c.values(this.gestures)),R=O.next();!R.done;R=O.next()){(H=R.value).tools=l.sort_by(H.tools,(function(t){return t.default_order}));var V=function(t){j.connect(t.properties.active.change,(function(){return x._active_change(t)}))},j=this;try{for(var k=(y=void 0,a.__values(H.tools)),q=k.next();!q.done;q=k.next()){V(q.value)}}catch(t){y={error:t}}finally{try{q&&!q.done&&(d=k.return)&&d.call(k)}finally{if(y)throw y.error}}}}catch(t){_={error:t}}finally{try{R&&!R.done&&(p=O.return)&&p.call(O)}finally{if(_)throw _.error}}try{for(var z=a.__values(c.entries(this.gestures)),C=z.next();!C.done;C=z.next()){var E=a.__read(C.value,2),F=E[0],H=E[1],J=h(F);if(J){var K=this[J];"auto"==K?0!=H.tools.length&&f(F)&&G(H.tools[0]):null!=K&&(l.includes(this.tools,K)?G(K):this[J]=null)}}}catch(t){g={error:t}}finally{try{C&&!C.done&&(T=z.return)&&T.call(z)}finally{if(g)throw g.error}}},e}(_.ToolbarBase);r.Toolbar=p,p.__name__="Toolbar",p.init_Toolbar()},
function _(t,e,n,o,i){o();var r=t(1),a=t(186),s=t(124),c=t(196),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),Object.defineProperty(e.prototype,"plot_view",{get:function(){return this.parent},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"plot_model",{get:function(){return this.parent.model},enumerable:!1,configurable:!0}),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,(function(){e.model.active?e.activate():e.deactivate()}))},e.prototype.activate=function(){},e.prototype.deactivate=function(){},e}(a.View);n.ToolView=_,_.__name__="ToolView";var l=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_Tool=function(){this.prototype._known_aliases=new Map,this.internal((function(t){return{active:[t.Boolean,!1]}}))},Object.defineProperty(e.prototype,"synthetic_renderers",{get:function(){return[]},enumerable:!1,configurable:!0}),e.prototype._get_dim_tooltip=function(t,e){switch(e){case"width":return t+" (x-axis)";case"height":return t+" (y-axis)";case"both":return t}},e.prototype._get_dim_limits=function(t,e,n,o){var i,a=r.__read(t,2),c=a[0],_=a[1],l=r.__read(e,2),p=l[0],u=l[1],h=n.bbox.h_range;"width"==o||"both"==o?(i=[s.min([c,p]),s.max([c,p])],i=[s.max([i[0],h.start]),s.min([i[1],h.end])]):i=[h.start,h.end];var f,d=n.bbox.v_range;return"height"==o||"both"==o?(f=[s.min([_,u]),s.max([_,u])],f=[s.max([f[0],d.start]),s.min([f[1],d.end])]):f=[d.start,d.end],[i,f]},e.register_alias=function(t,e){this.prototype._known_aliases.set(t,e)},e.from_string=function(t){var e=this.prototype._known_aliases.get(t);if(null!=e)return e();var n=r.__spread(this.prototype._known_aliases.keys());throw new Error("unexpected tool name '"+t+"', possible tools are "+n.join(", "))},e}(c.Model);n.Tool=l,l.__name__="Tool",l.init_Tool()},
function _(t,n,e,o,u){o();var r=t(1),i=t(293),_=t(302),l=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(i.ButtonToolView);e.GestureToolView=l,l.__name__="GestureToolView";var s=function(t){function n(n){var e=t.call(this,n)||this;return e.button_view=_.OnOffButtonView,e}return r.__extends(n,t),n}(i.ButtonTool);e.GestureTool=s,s.__name__="GestureTool"},
function _(t,e,o,n,i){n();var r=t(1),l=r.__importDefault(t(294)),u=t(193),a=t(291),s=t(187),c=t(144),p=t(123),_=t(124),h=t(295),f=r.__importDefault(t(296)),m=r.__importDefault(t(297)),d=r.__importDefault(t(298)),y=t(299),v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this);var o=this.model.menu;if(null!=o){var n=this.parent.model.toolbar_location,i="left"==n||"above"==n,r=this.parent.model.horizontal?"vertical":"horizontal";this._menu=new y.ContextMenu(i?_.reversed(o):o,{orientation:r,prevent_hide:function(t){return t.target==e.el}})}this._hammer=new l.default(this.el,{touchAction:"auto",inputClass:l.default.TouchMouseInput}),this.connect(this.model.change,(function(){return e.render()})),this._hammer.on("tap",(function(t){var o;(null===(o=e._menu)||void 0===o?void 0:o.is_open)?e._menu.hide():t.target==e.el&&e._clicked()})),this._hammer.on("press",(function(){return e._pressed()}))},e.prototype.remove=function(){var e;this._hammer.destroy(),null===(e=this._menu)||void 0===e||e.remove(),t.prototype.remove.call(this)},e.prototype.styles=function(){return r.__spread(t.prototype.styles.call(this),[f.default,m.default,d.default])},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(h.bk_toolbar_button)},e.prototype.render=function(){s.empty(this.el);var t=this.model.computed_icon;p.isString(t)&&(c.startsWith(t,"data:image")?this.el.style.backgroundImage="url('"+t+"')":this.el.classList.add(t)),this.el.title=this.model.tooltip,null!=this._menu&&this.root.el.appendChild(this._menu.el)},e.prototype._pressed=function(){var t,e=this,o=this.el.getBoundingClientRect(),n=o.left,i=o.top,r=o.right,l=o.bottom,u=function(){switch(e.parent.model.toolbar_location){case"right":return{right:n,top:i};case"left":return{left:r,top:i};case"above":return{left:n,top:l};case"below":return{left:n,bottom:i}}}();null===(t=this._menu)||void 0===t||t.toggle(u)},e}(u.DOMView);o.ButtonToolButtonView=v,v.__name__="ButtonToolButtonView";var b=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e}(a.ToolView);o.ButtonToolView=b,b.__name__="ButtonToolView";var g=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_ButtonTool=function(){this.internal((function(t){return{disabled:[t.Boolean,!1]}}))},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this.tool_name},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"computed_icon",{get:function(){return this.icon},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"menu",{get:function(){return null},enumerable:!1,configurable:!0}),e}(a.Tool);o.ButtonTool=g,g.__name__="ButtonTool",g.init_ButtonTool()},
function _(t,e,i,n,r){
/*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
!function(t,i,n,r){"use strict";var s,o=["","webkit","Moz","MS","ms","o"],a=i.createElement("div"),h=Math.round,u=Math.abs,c=Date.now;function l(t,e,i){return setTimeout(T(t,i),e)}function p(t,e,i){return!!Array.isArray(t)&&(f(t,i[e],i),!0)}function f(t,e,i){var n;if(t)if(t.forEach)t.forEach(e,i);else if(t.length!==r)for(n=0;n<t.length;)e.call(i,t[n],n,t),n++;else for(n in t)t.hasOwnProperty(n)&&e.call(i,t[n],n,t)}function v(e,i,n){var r="DEPRECATED METHOD: "+i+"\n"+n+" AT \n";return function(){var i=new Error("get-stack-trace"),n=i&&i.stack?i.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",s=t.console&&(t.console.warn||t.console.log);return s&&s.call(t.console,r,n),e.apply(this,arguments)}}s="function"!=typeof Object.assign?function(t){if(t===r||null===t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),i=1;i<arguments.length;i++){var n=arguments[i];if(n!==r&&null!==n)for(var s in n)n.hasOwnProperty(s)&&(e[s]=n[s])}return e}:Object.assign;var d=v((function(t,e,i){for(var n=Object.keys(e),s=0;s<n.length;)(!i||i&&t[n[s]]===r)&&(t[n[s]]=e[n[s]]),s++;return t}),"extend","Use `assign`."),m=v((function(t,e){return d(t,e,!0)}),"merge","Use `assign`.");function g(t,e,i){var n,r=e.prototype;(n=t.prototype=Object.create(r)).constructor=t,n._super=r,i&&s(n,i)}function T(t,e){return function(){return t.apply(e,arguments)}}function y(t,e){return"function"==typeof t?t.apply(e&&e[0]||r,e):t}function E(t,e){return t===r?e:t}function I(t,e,i){f(S(e),(function(e){t.addEventListener(e,i,!1)}))}function A(t,e,i){f(S(e),(function(e){t.removeEventListener(e,i,!1)}))}function _(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function C(t,e){return t.indexOf(e)>-1}function S(t){return t.trim().split(/\s+/g)}function b(t,e,i){if(t.indexOf&&!i)return t.indexOf(e);for(var n=0;n<t.length;){if(i&&t[n][i]==e||!i&&t[n]===e)return n;n++}return-1}function P(t){return Array.prototype.slice.call(t,0)}function D(t,e,i){for(var n=[],r=[],s=0;s<t.length;){var o=e?t[s][e]:t[s];b(r,o)<0&&n.push(t[s]),r[s]=o,s++}return i&&(n=e?n.sort((function(t,i){return t[e]>i[e]})):n.sort()),n}function x(t,e){for(var i,n,s=e[0].toUpperCase()+e.slice(1),a=0;a<o.length;){if((n=(i=o[a])?i+s:e)in t)return n;a++}return r}var w=1;function O(e){var i=e.ownerDocument||e;return i.defaultView||i.parentWindow||t}var R="ontouchstart"in t,M=x(t,"PointerEvent")!==r,z=R&&/mobile|tablet|ip(ad|hone|od)|android/i.test(navigator.userAgent),N="touch",X="mouse",Y=24,F=["x","y"],W=["clientX","clientY"];function q(t,e){var i=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){y(t.options.enable,[t])&&i.handler(e)},this.init()}function k(t,e,i){var n=i.pointers.length,s=i.changedPointers.length,o=1&e&&n-s==0,a=12&e&&n-s==0;i.isFirst=!!o,i.isFinal=!!a,o&&(t.session={}),i.eventType=e,function(t,e){var i=t.session,n=e.pointers,s=n.length;i.firstInput||(i.firstInput=H(e));s>1&&!i.firstMultiple?i.firstMultiple=H(e):1===s&&(i.firstMultiple=!1);var o=i.firstInput,a=i.firstMultiple,h=a?a.center:o.center,l=e.center=L(n);e.timeStamp=c(),e.deltaTime=e.timeStamp-o.timeStamp,e.angle=G(h,l),e.distance=j(h,l),function(t,e){var i=e.center,n=t.offsetDelta||{},r=t.prevDelta||{},s=t.prevInput||{};1!==e.eventType&&4!==s.eventType||(r=t.prevDelta={x:s.deltaX||0,y:s.deltaY||0},n=t.offsetDelta={x:i.x,y:i.y});e.deltaX=r.x+(i.x-n.x),e.deltaY=r.y+(i.y-n.y)}(i,e),e.offsetDirection=V(e.deltaX,e.deltaY);var p=U(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=p.x,e.overallVelocityY=p.y,e.overallVelocity=u(p.x)>u(p.y)?p.x:p.y,e.scale=a?(f=a.pointers,v=n,j(v[0],v[1],W)/j(f[0],f[1],W)):1,e.rotation=a?function(t,e){return G(e[1],e[0],W)+G(t[1],t[0],W)}(a.pointers,n):0,e.maxPointers=i.prevInput?e.pointers.length>i.prevInput.maxPointers?e.pointers.length:i.prevInput.maxPointers:e.pointers.length,function(t,e){var i,n,s,o,a=t.lastInterval||e,h=e.timeStamp-a.timeStamp;if(8!=e.eventType&&(h>25||a.velocity===r)){var c=e.deltaX-a.deltaX,l=e.deltaY-a.deltaY,p=U(h,c,l);n=p.x,s=p.y,i=u(p.x)>u(p.y)?p.x:p.y,o=V(c,l),t.lastInterval=e}else i=a.velocity,n=a.velocityX,s=a.velocityY,o=a.direction;e.velocity=i,e.velocityX=n,e.velocityY=s,e.direction=o}(i,e);var f,v;var d=t.element;_(e.srcEvent.target,d)&&(d=e.srcEvent.target);e.target=d}(t,i),t.emit("hammer.input",i),t.recognize(i),t.session.prevInput=i}function H(t){for(var e=[],i=0;i<t.pointers.length;)e[i]={clientX:h(t.pointers[i].clientX),clientY:h(t.pointers[i].clientY)},i++;return{timeStamp:c(),pointers:e,center:L(e),deltaX:t.deltaX,deltaY:t.deltaY}}function L(t){var e=t.length;if(1===e)return{x:h(t[0].clientX),y:h(t[0].clientY)};for(var i=0,n=0,r=0;r<e;)i+=t[r].clientX,n+=t[r].clientY,r++;return{x:h(i/e),y:h(n/e)}}function U(t,e,i){return{x:e/t||0,y:i/t||0}}function V(t,e){return t===e?1:u(t)>=u(e)?t<0?2:4:e<0?8:16}function j(t,e,i){i||(i=F);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return Math.sqrt(n*n+r*r)}function G(t,e,i){i||(i=F);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return 180*Math.atan2(r,n)/Math.PI}q.prototype={handler:function(){},init:function(){this.evEl&&I(this.element,this.evEl,this.domHandler),this.evTarget&&I(this.target,this.evTarget,this.domHandler),this.evWin&&I(O(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&A(this.element,this.evEl,this.domHandler),this.evTarget&&A(this.target,this.evTarget,this.domHandler),this.evWin&&A(O(this.element),this.evWin,this.domHandler)}};var Z={mousedown:1,mousemove:2,mouseup:4},B="mousedown",$="mousemove mouseup";function J(){this.evEl=B,this.evWin=$,this.pressed=!1,q.apply(this,arguments)}g(J,q,{handler:function(t){var e=Z[t.type];1&e&&0===t.button&&(this.pressed=!0),2&e&&1!==t.which&&(e=4),this.pressed&&(4&e&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:X,srcEvent:t}))}});var K={pointerdown:1,pointermove:2,pointerup:4,pointercancel:8,pointerout:8},Q={2:N,3:"pen",4:X,5:"kinect"},tt="pointerdown",et="pointermove pointerup pointercancel";function it(){this.evEl=tt,this.evWin=et,q.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}t.MSPointerEvent&&!t.PointerEvent&&(tt="MSPointerDown",et="MSPointerMove MSPointerUp MSPointerCancel"),g(it,q,{handler:function(t){var e=this.store,i=!1,n=t.type.toLowerCase().replace("ms",""),r=K[n],s=Q[t.pointerType]||t.pointerType,o=s==N,a=b(e,t.pointerId,"pointerId");1&r&&(0===t.button||o)?a<0&&(e.push(t),a=e.length-1):12&r&&(i=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:s,srcEvent:t}),i&&e.splice(a,1))}});var nt={touchstart:1,touchmove:2,touchend:4,touchcancel:8},rt="touchstart",st="touchstart touchmove touchend touchcancel";function ot(){this.evTarget=rt,this.evWin=st,this.started=!1,q.apply(this,arguments)}function at(t,e){var i=P(t.touches),n=P(t.changedTouches);return 12&e&&(i=D(i.concat(n),"identifier",!0)),[i,n]}g(ot,q,{handler:function(t){var e=nt[t.type];if(1===e&&(this.started=!0),this.started){var i=at.call(this,t,e);12&e&&i[0].length-i[1].length==0&&(this.started=!1),this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:N,srcEvent:t})}}});var ht={touchstart:1,touchmove:2,touchend:4,touchcancel:8},ut="touchstart touchmove touchend touchcancel";function ct(){this.evTarget=ut,this.targetIds={},q.apply(this,arguments)}function lt(t,e){var i=P(t.touches),n=this.targetIds;if(3&e&&1===i.length)return n[i[0].identifier]=!0,[i,i];var r,s,o=P(t.changedTouches),a=[],h=this.target;if(s=i.filter((function(t){return _(t.target,h)})),1===e)for(r=0;r<s.length;)n[s[r].identifier]=!0,r++;for(r=0;r<o.length;)n[o[r].identifier]&&a.push(o[r]),12&e&&delete n[o[r].identifier],r++;return a.length?[D(s.concat(a),"identifier",!0),a]:void 0}g(ct,q,{handler:function(t){var e=ht[t.type],i=lt.call(this,t,e);i&&this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:N,srcEvent:t})}});function pt(){q.apply(this,arguments);var t=T(this.handler,this);this.touch=new ct(this.manager,t),this.mouse=new J(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function ft(t,e){1&t?(this.primaryTouch=e.changedPointers[0].identifier,vt.call(this,e)):12&t&&vt.call(this,e)}function vt(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var i={x:e.clientX,y:e.clientY};this.lastTouches.push(i);var n=this.lastTouches;setTimeout((function(){var t=n.indexOf(i);t>-1&&n.splice(t,1)}),2500)}}function dt(t){for(var e=t.srcEvent.clientX,i=t.srcEvent.clientY,n=0;n<this.lastTouches.length;n++){var r=this.lastTouches[n],s=Math.abs(e-r.x),o=Math.abs(i-r.y);if(s<=25&&o<=25)return!0}return!1}g(pt,q,{handler:function(t,e,i){var n=i.pointerType==N,r=i.pointerType==X;if(!(r&&i.sourceCapabilities&&i.sourceCapabilities.firesTouchEvents)){if(n)ft.call(this,e,i);else if(r&&dt.call(this,i))return;this.callback(t,e,i)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var mt=x(a.style,"touchAction"),gt=mt!==r,Tt="compute",yt="auto",Et="manipulation",It="none",At="pan-x",_t="pan-y",Ct=function(){if(!gt)return!1;var e={},i=t.CSS&&t.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach((function(n){e[n]=!i||t.CSS.supports("touch-action",n)})),e}();function St(t,e){this.manager=t,this.set(e)}St.prototype={set:function(t){t==Tt&&(t=this.compute()),gt&&this.manager.element.style&&Ct[t]&&(this.manager.element.style[mt]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return f(this.manager.recognizers,(function(e){y(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))})),function(t){if(C(t,It))return It;var e=C(t,At),i=C(t,_t);if(e&&i)return It;if(e||i)return e?At:_t;if(C(t,Et))return Et;return yt}(t.join(" "))},preventDefaults:function(t){var e=t.srcEvent,i=t.offsetDirection;if(this.manager.session.prevented)e.preventDefault();else{var n=this.actions,r=C(n,It)&&!Ct.none,s=C(n,_t)&&!Ct["pan-y"],o=C(n,At)&&!Ct["pan-x"];if(r){var a=1===t.pointers.length,h=t.distance<2,u=t.deltaTime<250;if(a&&h&&u)return}if(!o||!s)return r||s&&6&i||o&&i&Y?this.preventSrc(e):void 0}},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};var bt=32;function Pt(t){this.options=s({},this.defaults,t||{}),this.id=w++,this.manager=null,this.options.enable=E(this.options.enable,!0),this.state=1,this.simultaneous={},this.requireFail=[]}function Dt(t){return 16&t?"cancel":8&t?"end":4&t?"move":2&t?"start":""}function xt(t){return 16==t?"down":8==t?"up":2==t?"left":4==t?"right":""}function wt(t,e){var i=e.manager;return i?i.get(t):t}function Ot(){Pt.apply(this,arguments)}function Rt(){Ot.apply(this,arguments),this.pX=null,this.pY=null}function Mt(){Ot.apply(this,arguments)}function zt(){Pt.apply(this,arguments),this._timer=null,this._input=null}function Nt(){Ot.apply(this,arguments)}function Xt(){Ot.apply(this,arguments)}function Yt(){Pt.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function Ft(t,e){return(e=e||{}).recognizers=E(e.recognizers,Ft.defaults.preset),new Wt(t,e)}Pt.prototype={defaults:{},set:function(t){return s(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(p(t,"recognizeWith",this))return this;var e=this.simultaneous;return e[(t=wt(t,this)).id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return p(t,"dropRecognizeWith",this)||(t=wt(t,this),delete this.simultaneous[t.id]),this},requireFailure:function(t){if(p(t,"requireFailure",this))return this;var e=this.requireFail;return-1===b(e,t=wt(t,this))&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(p(t,"dropRequireFailure",this))return this;t=wt(t,this);var e=b(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){var e=this,i=this.state;function n(i){e.manager.emit(i,t)}i<8&&n(e.options.event+Dt(i)),n(e.options.event),t.additionalEvent&&n(t.additionalEvent),i>=8&&n(e.options.event+Dt(i))},tryEmit:function(t){if(this.canEmit())return this.emit(t);this.state=bt},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(33&this.requireFail[t].state))return!1;t++}return!0},recognize:function(t){var e=s({},t);if(!y(this.options.enable,[this,e]))return this.reset(),void(this.state=bt);56&this.state&&(this.state=1),this.state=this.process(e),30&this.state&&this.tryEmit(e)},process:function(t){},getTouchAction:function(){},reset:function(){}},g(Ot,Pt,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,i=t.eventType,n=6&e,r=this.attrTest(t);return n&&(8&i||!r)?16|e:n||r?4&i?8|e:2&e?4|e:2:bt}}),g(Rt,Ot,{defaults:{event:"pan",threshold:10,pointers:1,direction:30},getTouchAction:function(){var t=this.options.direction,e=[];return 6&t&&e.push(_t),t&Y&&e.push(At),e},directionTest:function(t){var e=this.options,i=!0,n=t.distance,r=t.direction,s=t.deltaX,o=t.deltaY;return r&e.direction||(6&e.direction?(r=0===s?1:s<0?2:4,i=s!=this.pX,n=Math.abs(t.deltaX)):(r=0===o?1:o<0?8:16,i=o!=this.pY,n=Math.abs(t.deltaY))),t.direction=r,i&&n>e.threshold&&r&e.direction},attrTest:function(t){return Ot.prototype.attrTest.call(this,t)&&(2&this.state||!(2&this.state)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=xt(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),g(Mt,Ot,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return[It]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||2&this.state)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),g(zt,Pt,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return[yt]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!n||!i||12&t.eventType&&!r)this.reset();else if(1&t.eventType)this.reset(),this._timer=l((function(){this.state=8,this.tryEmit()}),e.time,this);else if(4&t.eventType)return 8;return bt},reset:function(){clearTimeout(this._timer)},emit:function(t){8===this.state&&(t&&4&t.eventType?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=c(),this.manager.emit(this.options.event,this._input)))}}),g(Nt,Ot,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return[It]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||2&this.state)}}),g(Xt,Ot,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:30,pointers:1},getTouchAction:function(){return Rt.prototype.getTouchAction.call(this)},attrTest:function(t){var e,i=this.options.direction;return 30&i?e=t.overallVelocity:6&i?e=t.overallVelocityX:i&Y&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&i&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&u(e)>this.options.velocity&&4&t.eventType},emit:function(t){var e=xt(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),g(Yt,Pt,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return[Et]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),1&t.eventType&&0===this.count)return this.failTimeout();if(n&&r&&i){if(4!=t.eventType)return this.failTimeout();var s=!this.pTime||t.timeStamp-this.pTime<e.interval,o=!this.pCenter||j(this.pCenter,t.center)<e.posThreshold;if(this.pTime=t.timeStamp,this.pCenter=t.center,o&&s?this.count+=1:this.count=1,this._input=t,0===this.count%e.taps)return this.hasRequireFailures()?(this._timer=l((function(){this.state=8,this.tryEmit()}),e.interval,this),2):8}return bt},failTimeout:function(){return this._timer=l((function(){this.state=bt}),this.options.interval,this),bt},reset:function(){clearTimeout(this._timer)},emit:function(){8==this.state&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),Ft.VERSION="2.0.7",Ft.defaults={domEvents:!1,touchAction:Tt,enable:!0,inputTarget:null,inputClass:null,preset:[[Nt,{enable:!1}],[Mt,{enable:!1},["rotate"]],[Xt,{direction:6}],[Rt,{direction:6},["swipe"]],[Yt],[Yt,{event:"doubletap",taps:2},["tap"]],[zt]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};function Wt(t,e){var i;this.options=s({},Ft.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=new((i=this).options.inputClass||(M?it:z?ct:R?pt:J))(i,k),this.touchAction=new St(this,this.options.touchAction),qt(this,!0),f(this.options.recognizers,(function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])}),this)}function qt(t,e){var i,n=t.element;n.style&&(f(t.options.cssProps,(function(r,s){i=x(n.style,s),e?(t.oldCssProps[i]=n.style[i],n.style[i]=r):n.style[i]=t.oldCssProps[i]||""})),e||(t.oldCssProps={}))}Wt.prototype={set:function(t){return s(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?2:1},recognize:function(t){var e=this.session;if(!e.stopped){var i;this.touchAction.preventDefaults(t);var n=this.recognizers,r=e.curRecognizer;(!r||r&&8&r.state)&&(r=e.curRecognizer=null);for(var s=0;s<n.length;)i=n[s],2===e.stopped||r&&i!=r&&!i.canRecognizeWith(r)?i.reset():i.recognize(t),!r&&14&i.state&&(r=e.curRecognizer=i),s++}},get:function(t){if(t instanceof Pt)return t;for(var e=this.recognizers,i=0;i<e.length;i++)if(e[i].options.event==t)return e[i];return null},add:function(t){if(p(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(p(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,i=b(e,t);-1!==i&&(e.splice(i,1),this.touchAction.update())}return this},on:function(t,e){if(t!==r&&e!==r){var i=this.handlers;return f(S(t),(function(t){i[t]=i[t]||[],i[t].push(e)})),this}},off:function(t,e){if(t!==r){var i=this.handlers;return f(S(t),(function(t){e?i[t]&&i[t].splice(b(i[t],e),1):delete i[t]})),this}},emit:function(t,e){this.options.domEvents&&function(t,e){var n=i.createEvent("Event");n.initEvent(t,!0,!0),n.gesture=e,e.target.dispatchEvent(n)}(t,e);var n=this.handlers[t]&&this.handlers[t].slice();if(n&&n.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var r=0;r<n.length;)n[r](e),r++}},destroy:function(){this.element&&qt(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},s(Ft,{INPUT_START:1,INPUT_MOVE:2,INPUT_END:4,INPUT_CANCEL:8,STATE_POSSIBLE:1,STATE_BEGAN:2,STATE_CHANGED:4,STATE_ENDED:8,STATE_RECOGNIZED:8,STATE_CANCELLED:16,STATE_FAILED:bt,DIRECTION_NONE:1,DIRECTION_LEFT:2,DIRECTION_RIGHT:4,DIRECTION_UP:8,DIRECTION_DOWN:16,DIRECTION_HORIZONTAL:6,DIRECTION_VERTICAL:Y,DIRECTION_ALL:30,Manager:Wt,Input:q,TouchAction:St,TouchInput:ct,MouseInput:J,PointerEventInput:it,TouchMouseInput:pt,SingleTouchInput:ot,Recognizer:Pt,AttrRecognizer:Ot,Tap:Yt,Pan:Rt,Swipe:Xt,Pinch:Mt,Rotate:Nt,Press:zt,on:I,off:A,each:f,merge:m,extend:d,assign:s,inherit:g,bindFn:T,prefixed:x}),(void 0!==t?t:"undefined"!=typeof self?self:{}).Hammer=Ft,"function"==typeof define&&define.amd?define((function(){return Ft})):void 0!==e&&e.exports?e.exports=Ft:t.Hammer=Ft}(window,document)},
function _(o,b,t,a,n){a(),t.bk_toolbar="bk-toolbar",t.bk_toolbar_hidden="bk-toolbar-hidden",t.bk_toolbar_button="bk-toolbar-button",t.bk_button_bar="bk-button-bar",t.bk_toolbar_button_custom_action="bk-toolbar-button-custom-action"},
function _(o,b,t,n,r){n();t.default='\n.bk-root .bk-toolbar-hidden {\n  visibility: hidden;\n  opacity: 0;\n  transition: visibility 0.3s linear, opacity 0.3s linear;\n}\n.bk-root .bk-toolbar,\n.bk-root .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-toolbar .bk-logo {\n  flex-shrink: 0;\n  -webkit-flex-shrink: 0;\n}\n.bk-root .bk-toolbar.bk-above,\n.bk-root .bk-toolbar.bk-below {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n  justify-content: flex-end;\n  -webkit-justify-content: flex-end;\n}\n.bk-root .bk-toolbar.bk-above .bk-button-bar,\n.bk-root .bk-toolbar.bk-below .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-toolbar.bk-above .bk-logo,\n.bk-root .bk-toolbar.bk-below .bk-logo {\n  order: 1;\n  -webkit-order: 1;\n  margin-left: 5px;\n  margin-right: 0px;\n}\n.bk-root .bk-toolbar.bk-left,\n.bk-root .bk-toolbar.bk-right {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n  justify-content: flex-start;\n  -webkit-justify-content: flex-start;\n}\n.bk-root .bk-toolbar.bk-left .bk-button-bar,\n.bk-root .bk-toolbar.bk-right .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-toolbar.bk-left .bk-logo,\n.bk-root .bk-toolbar.bk-right .bk-logo {\n  order: 0;\n  -webkit-order: 0;\n  margin-bottom: 5px;\n  margin-top: 0px;\n}\n.bk-root .bk-toolbar-button {\n  width: 30px;\n  height: 30px;\n  cursor: pointer;\n  background-size: 60% 60%;\n  background-origin: border-box;\n  background-color: transparent;\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n.bk-root .bk-toolbar-button:hover {\n  background-color: rgba(192, 192, 192, 0.15);\n}\n.bk-root .bk-toolbar-button:focus {\n  outline: none;\n}\n.bk-root .bk-toolbar-button::-moz-focus-inner {\n  border: 0;\n}\n.bk-root .bk-toolbar.bk-above .bk-toolbar-button {\n  border-bottom: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-above .bk-toolbar-button.bk-active {\n  border-bottom-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-below .bk-toolbar-button {\n  border-top: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-below .bk-toolbar-button.bk-active {\n  border-top-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-right .bk-toolbar-button {\n  border-left: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-right .bk-toolbar-button.bk-active {\n  border-left-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-left .bk-toolbar-button {\n  border-right: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-left .bk-toolbar-button.bk-active {\n  border-right-color: #26aae1;\n}\n.bk-root .bk-button-bar + .bk-button-bar:before {\n  content: " ";\n  display: inline-block;\n  background-color: lightgray;\n}\n.bk-root .bk-toolbar.bk-above .bk-button-bar + .bk-button-bar:before,\n.bk-root .bk-toolbar.bk-below .bk-button-bar + .bk-button-bar:before {\n  height: 10px;\n  width: 1px;\n}\n.bk-root .bk-toolbar.bk-left .bk-button-bar + .bk-button-bar:before,\n.bk-root .bk-toolbar.bk-right .bk-button-bar + .bk-button-bar:before {\n  height: 1px;\n  width: 10px;\n}\n'},
function _(A,g,C,B,w){B();C.default='\n.bk-root .bk-tool-icon-copy-to-clipboard {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUSDBoBvcHQeQAAAG9JREFUWMNjXLhsJcNAAiaGAQYwB/xHwh/Q+ITEkfHQCwEWND4jmeb8H/JpgBwfI6cNBhLSEkqaGXRpgFRAcZoZsmlg1AGjDhh1wKgDRh0w6gCaVcf/R2wIkNqw+D9s0wADvUNiyIYA47BJAwPuAAAj/Cjd0TCN6wAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-replace-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxokK3gniQAAAHpJREFUWMNjXLhsJcNAAiaGAQajDhhwB7DgEP+PxmeksvjgDwFcLmYkUh2hkBj8IcBIZXsYh1w2/I8v3sgAOM0bLYhGc8GgrwuICgldfQO88pcvXvg/aOuCUQeM5oLRuoCFCJcTbOMh5XOiW0JDNhdQS3y0IBp1ABwAAF8KGrhC1Eg6AAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-append-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkZWD04WwAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAAAoUlEQVRYw+1WQQ6AIAwrhO8Y/bIXEz9jIMSDr8ETCUEPQzA4pMeFLKNbu4l5WR0CDOMEALBGIzMuQIBEZQjPgP9JLjwTfBjY9sO9lZsFA9IafZng3BlIyVefgd8XQFZBAWe8jfNxwsDhir6rzoCiPiy1K+J8/FRQemv2XfAdFcQ9znU4Viqg9ta1qYJ+D1BnAIBrkgGVOrXNqUA9rbyZm/AEzFh4jEeY/soAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-intersect-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkrkOpp2wAAAPhJREFUWMPtV1EKwjAMTUavI3oawR/vtn5srJdREfzwMvHHQlcT2mpdMzFfWxiP5r2+JMN+mAiCOB72CABgR1cln4oOGocJnuMTSxWk8jMm7OggYkYXA9gPE3uyd8NXHONJ+eYMdE/NqCJmEZ5ZqlJJ4sUksKN7cYSaPoCZFWR1QI+Xm1fBACU63Cw22x0AAJxudwrffVwvZ+JmQdAHZkw0d4EpAMCw8k87pMdbnwtizQumJYv3nwV6XOA1qbUT/oQLUJgFRbsiNwFVucBIlyR3p0tdMp+XmFjfLKi1LatyAXtCRjPWBdL3Ke3VuACJKFfDr/xFN2fgAR/Go0qaLlmEAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-subtract-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxgsF5XNOQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABFUlEQVRYw9VWUQqDMAxNpWfxQxD1MoP97G7zQ5mH2RTZYLtM9lWoMbXtxLXNX4OG9r28l4hrd0PQoqxqAACYpxH25C/nkwCHyCBwSPoS09k1T5Fo+4EiExcC4v584xGFmyIXHBLRISAVZyZufUPVa4rcrwmPDgr93ylo+2GliLRUYHK6th/o/6r7nfLpqaCsagEA8Hh9FmcNKeRmgeYDC+SCq0B6FFi8/BcV6BdR9cL3gCv3ijPKOacsn3rBEcjmaVxpfGcg4wHxzgJJnc6241Hn23DERFRAu1bNcWa3Q0uXi62XR6sCaWoSejbtdLYmU3kTEunNgj0bUbQqYG/IcMaqwPS9jftoVCAQ0ZVDJwf0zQdH4AsyW6fpQu4YegAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-clear-selection {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUGEhcuan3d3wAAAoRJREFUWMPtlzFP3EAQhd+b3TNSzg0N5TWXLkJQUUaKhIQ4fgP/g5ArrriE/I3opEgRrZtIVJR0FJQ010SioUmEZHtnUpwN9gWHGA5BJCy58MraffvmfZ41v3z9hqe8BE98vQh4cgG+Ydzmnrng8efvQJNi/uN7dznx/B3ggtfhf4ehNdUttRzBDIm/2VTiiWCG1HK0nc+3UWtq8BQIiEEakEQOADBIA4QCQmBqoHBhFNR27ikQSmGdYCdTqCpEHMDZmEKRWUBEv1gBDg5SzRJnpopILWICgWuRYflLamuzxB2BmtYqSRIka5VWU8QduXO+1hRc5YZu5GAwmP2ZJzND0IBu5HCV2+NQcAhAVRsnC2IbPzPdSjzd6to6VtfWkXi6YLaVWr7xoAwkfpb8MnC3SH7rKSMBe4M0jA/OTicFIbtCGRIyNbURhcf3ErCd6YwA1m0HgAxhw1NGQnlXBHG4kylVlSJuH0RfIP2CkL2I/qS1gIAAQiBl1QwFggIHtyxgrxK5PgyfC0JWKoT0HLh8LwoietB4TYKaIl7yeNURxB05UtMxDOcVQlZIrlRKdK6m47gjR/fuBRQihyLArtNeJD50Izcx2Eczu7iFkIug4VM3cpOr3MKDekFED0fWUHv9Zq0kpLnridjhY3XDg7NTN0jDrhO3X7O9Wg7wwyANu4mnayNg3gmbu0tCNoUyBNGv2l4rB9EXynA7082FOxAQLhU6rQVO9T2AvWowFToNCJcPORGxIRcnpjZSKATSU9NxvOQnAPArDSaQoUKnNI4iufkGtD4P3EHIcWZhz4HLceSOyrR3Izf5memPAL2cX3yhAkonysZVaWLBkd9dw1Ivv2a/AYPkK+ty1U1DAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-box-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg0kduFrowAAAIdJREFUWMPtVtEKwCAI9KL//4e9DPZ3+wP3KgOjNZouFYI4C8q7s7DtB1lGIeMoRMRinCLXg/ML3EcFqpjjloOyZxRntxpwQ8HsgHYARKFAtSFrCg3TCdMFCE1BuuALEXJLjC4qENsFVXCESZw38/kWLOkC/K4PcOc/Hj03WkoDT3EaWW9egQul6CUbq90JTwAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-box-zoom {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg82t254aQAAAkBJREFUWMPN11+E1FEUB/DPTFn2qaeIpcSwr5NlUyJiKWVXWUqvlUh/iE3RY9mUekkPPURtLKNRrFJEeuphGfUUaVliiX1aVjGs6aG7+XX9ZnZ+d2fTl2vmnHvPPfeee/79Sk+may2/UQq/q7Qu+bAJoxjHIKqB/wlfUMcMVqI9bLZ+DGIKwzlzQ2GcxCx2xwvKOUKlaHTiX8bHNspjDONHkOmJBW5jIof/FvPh/06MZOb6cRc7cGn1AKUE5cdzlM/gAr5F/O24H3xkFRfxAbVygvK+cIsspjGWo1zgjeFpxL+BvnLw7laBA4xjIFJwrgu52DoVjKdY4HBEX8dSF3JLYe1fe6UcYCii3xWQjdfuSTnAtoheKCC7GNED5Zx4L4qt61jbTLHA94geKSC7P7ZeShQ0Inoi1IJuEOeORooFXkV0FZNdZs5qvFfKAeqYy7nZ6yg//HG0MBfffh71lFrQDCW2EvEP4mt4okZUDftz9rmGZkotmMxJRtlisy+MTniAWrty3AlXw0hFM2TD89l+oNsoOJXjbIs4EpqNtTCLXbiZ0g+M4mFObj8U3vsNjoZCVcmk60ZwthpepLZkB/AsivWfOJZxtpUQHfWib7KWDwzjeegBZJSdKFiE2qJTFFTwElsi/unQ/awXrU4WGMD7nOJxBY/1EO2iYConq93CHT1GOwucjdqnRyFz+VcHmMNefMY9nNkA3SWUOoXhQviSWQ4huLIRFlirFixnQq/XaKXUgg2xQNGv4V7x/RcW+AXPB3h7H1PaiQAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-zoom-in {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsUBmL8iQAAA2JJREFUWMO9l12IlFUYx3//MzPrLpSjkm5oN4FFIWVEl66IQlFYwtLOzozsjHdGRSCRF0sfBEXRVV0FQuQiLm5CZNBFgRRaRLVFhbJ2EdiN5gbK7toObTPn6eYdPTvNzPvOBz5Xh/ec5/n/n89zXtEHmZqeSXSuXBz/3zfdKvBWJHQrwZuRcP0El+QkbQXeBX6WZEgm6TtJk5lM5o4Lc+cV6qpf4Ga20Tm338zeATItVK9Ker6yvPzp4NDQ3+XieGsCU9MzTYumGbhz7m4ze9/MHgvBgItACrgfGAj2jgAvAYs3wlEujjc13kii8YyZrXXOfWhmo9GnFUlvOOemarVapVqtkslksmb2KjARqL62ecuWN9NxbRInzrldAXhV0uFSIfdew7G/gNLU9MwS8CwSmE3Oz88fcXG5blfpqVRq0Ix8VIAAX0XgrVL7HDCHGcCaWrV60LUBN8Dae58aQIxEqcA592I9M610JL0cpG/U9TIHJNKY3RV5z0R+7Nd4HZ0P1g/2RMBuegLAsRMnb4vT8d5vqKfMzOgtAlADrkmqGywmiMBTwfr3dC9j1Xv/r6Tvg/5/5ejxE6cO7M9faVbQZrYNOFSPmqQvVo9FKexvi5uWX58943aM7DwAfBDY+FbSCxP5sdkGx55GeguzrUEXPaSo2pFkAbiSZQCAzZJOmdkjwd6SpB/M7KykQTPbA2wDhoIzRzcNDx9MJwGNIXdJ0mEzmwbujL7dbma7gd03A7lKfnTOvf74nl0r6bonTUbujRSUCrm2d4L3/kvn3JPe+8+BDW2i9o+kT7z3kxP5sYsA6W47oE64TsR7P9tQL4vA2mh9WdIscKxUyJ0M7aR7acOGzikD65EQLEjaa2ZXzMwDFeB6qZBbbLTRE4EGeSaozNOZgYFf8qP7lmIvs354n0qlHpB0T7B9Ogl4IgJJrmjv/SiQjbrkD+BMUkfSbYATPdckrTOzkciWAXOlQu5cYgLdPEIapud9wMOR9zVJH3ViKx333mtHMJvNuoWFhZ3A+ojMcja77njXBEKwJJfTcqUyCIQ34Mf7nnh0paMnXacFuGoC1mr3AtuDfLzd8Zuyl+rfuGn4HLAD+Az4qZQf+61TAj0Noj8vX6oC35SL43u7teG6rf5+iXppwW7/JUL5D03qaFRvvUe+AAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-zoom-out {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsHgty9VwAAA0FJREFUWMO9l09oXFUUxn/fmXlpItppi22k7UJBRSlVkCytSAuKUloIdjKT0El3FXVXdVFKRVAQV7qQohsNwdA0UFvBhYtqUVyIVlRaogtFQVq7qSTVjA3z3nHzBq/jvPmTN/Ss7rv3nvN99/y794kByMzcfE/7picn/jenmwWeRUI3E7wdCRskuCSTdDfwBvCtJEdySV9KOhpF0e0/LF5SqKtBgbv7ZjObcvfXgShD9Zqk5+orKx8Oj4z8NT05kU1gZm6+bdK0Azezu9z9hLs/HoIBvwAF4H5gKFh7B3gBWFY3460kWve4+3oze9fdx9OpVUmvmNlMHMf1RqNBFEUldz8OHAxUX9q6bduryut+Sfvc/Wz62ZD0fK1afjND9y3gGSRwv1GMojstTxUUCoVhdyopEYDzKXjWwZ4FFnEHWBc3Goet00m7lZlZYQixKw0FZnakGZksHUnHgvCN5/KARBH37enpOVg58H13HV0Kxg/kIuD/ngSA2ZMLt3bTSZJkUzNk7k4+D0AM/CGpaXCyBw/sC8Y/qZd2GpZiuL9YLN4Sx/HpoP5/c/exQ1OVq+1yyt13SLoArEsJnMjlgfOffvK3u58Kprab2QezJxfG2iTzUzI70wRPG9jbmpmb95SNB9mpzp7/j2yVdNbdx4K565K+cvfPJQ27+x5gBzAS7Hlvy+jo4WIvoC3kWpcvS3rR3eeAO9K529x9N7C7zX6AC2b28hN7Hl1Vt44niVq13LUjmtlYkiQfA5s6eO+GpDNJkhw9NFX5ueNt2ARodyF1IHIN2JiOl4H16fiKpK+B2Vq1vBAqFAf4IJkGNiIhWJK0192vunsC1IE/a9XycquNXARa5OnApeeioaHvKuP7r3dTGsiLqFAo7JR0T7B8rhfwXARa2us4UEqr5Ffgs151i/08oTNKdIO770ptObBYq5Yv5ibQq/sl3Qc8lJ4+lnSqH1vFfp9koZRKJVtaWnqkWXqSVkqlDe+vmUDWpZMlK/X6MBDegKf3P/nYaj8ErN9fqZBYEsf3Ag8G8Xit33BaniTcvGX0IvAw8BHwTa1y4Md+CeRqRL9fudwAvpienNi7Vhu21uwflOT+L+i1X2TJP57iUvUFtHWsAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-help {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-hover {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4oVHp0SwAAAQJJREFUWMPtlsENgzAMRb8RQ5VJItFDOgaZAMaAA0iZpN3KPZSoEEHSQBCViI/G8pfNt/KAFFcPshPdoAGgZkYVVYjQAFCyFLN8tlAbXRwAxp61nc9XCkGERpZCxRDvBl0zoxp7K98GAACxxH29srNNmPsK2l7zHoHHXZDr+/9vwDfB3kgeSB5IHkgeOH0DmesJjSXi6pUvkYt5u9teVy6aWREDM0D0BRvmGRV5N6DsQkMzI64FidtI5t3AOKWaFhuioY8dlYf9TO1PREUh/9HVeAqzIThHgWZ6MuNmC1jiL1mK4pAzlKUojEmNsxcmL0J60tazWjLZFpClPbd9BMJfL95145YajN5RHQAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-crosshair {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADEUlEQVRYR81XXVIaQRCeHqug8CXmBNETaE4gniDwIgpVspxAbxC9ATkBkCpQ8gKeQDiB5AQxNyAvUlrldr7eHxyGXZi1rMJ5opbp7m++7un+htSGF204vsoMoNXrlzSpfWa1oxQfhAegCZGaEtPorHo8znIoJwCt6+td8uk7ApUQCIHTF4BNAWzImq8ap6cP68CsBdDp9i9ZqXM7ML79g/EnCWD+jgMKENKqWT+tXK0CkQqgNRjs0OxpQIqKhoMxaG6/6JeRnK7T6yO2UvVqhYSlLX+ryORfgKn9ORDFIy7ky41yGcwsr0QAQfDH5zucOswx819fs4egI9OFCcD8DjBF7VNbEX0JzdWEt3NHSSASAcCxBDqMgt/623kvyTgNgNjJIfTjk4D4FqaJR1715MjmYAmA5Bx3AwUXQL+t105KaTlcBSC26XRvhjEIoLiq1yqXpr8FAGG16/ug4IT27fxBWu7EiQuAiImJpEMKE6nYM30uAIDDttSUOPfJP7JzbjPhAiBIh9QE67vIvoOi9WJfCwDavf40ulpjbCqmUf+W753ezURuh7Dg1SqflwAEHU6pgfyBq9Y4qx0LG++2fnZ/eUzcstmdM2AWH+jfc+liWdBJfSENf8Lifi3GVwC9mybOfi5dzatWVrbbLIHNva8p5h/16gkaFiLGGxbufkoE6XguwePiXLF3XmMfCUCUAqtKXU7sumd1CowOuJEi3Pg1FBpjitIGhyvVSfvmjci6ZR+rFQfDiPVE2jFYeICQ+PoewwjC5h7CZld6DBdyu6nDSKgzOyIMhmhK5TTqXYbRorZYM46TmpKAAOrGWwSJJekSB1yqJNOzp1Gs7YJ0EDeySDIMtJbQHh6Kf/uFfNFZkolJICRmz0P8DKWZuIG2g1hpok+Mk0Qphs0h9lzMtWRoNvYLuVImUWrmPJDlBKeRBDfATGOpHkhw670QSHWGLLckmF1PTsMlYqMJpyUbiO0weiMMceqLVTcotnMCYAYJJbcuQrVgZFP0NOOJYpr62pf3AmrHfWUG4O7abefGAfwH7EXSMJafOlYAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-lasso-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgwlGP1qdAAABMBJREFUWMO9V1uIVVUY/r61z57ZMx4DnbzgkbQXL5iCJphlWdpIGY4jpFBkEiU9ZNaDRRcITcIwMwgxoQtU2IMXdAZfMjFvpERXYiSbysyBEXFmyuHMnLP32uvrwT2xnY5nxvHQ93Jg7fWv71/r//7L4a59TRgqJk+Z6v3a+sv0OI5nk5wu6VaSVZImAThHsgjgrKTvM5nMUWvtmf5n8HodCIKgOgzDhc65pSTrJQWDsSNpJX1ljHnDOfdT37oZLLHv+8OMMasKhcIJ59xHAJYMlhwAJGUAzJfUTHLFuFzOG5QDU6dNMyQfs9Yedc5tBpAD4IYYNQGoBrDtQnt7/b0LFrJsCHzfn2itfQfAnZLiazytA3AaQAuAiwDaEgeNpGkkswAWSBqRONB38b88z5uTKePt6iiKXkk8jq+iJC5LOmiMaTLGHLPWhmWeHr7vV0dRtATAapAzIVmSo51zyzIlbm2stesFPA6pKk0r6Ryg93y/ek8YFvPOOTg3cDSiKCoC2OP7/rEoirYm4rUkF12lAWNM1lr7lqQn0+QA8gI2jBg5cj6Aj8OwmB+KAKIoukhyp6SRJAUgl0ndPLDWPi9pJQCbuviXvu+/GIZhW1dnJ24UJFuTjCCA2ADA8sYGWmsXS3qmL94kDYAtkh4Nw7ANlQJ5U6INT1KrAYC9zQdykl7nFSj5fXp5Y8NWVBhy7mUAjqShMYdMXV2dJ2klyRwAJ8lIeuGWCRMP7N7frEqSG2OmAFhKshNAp5wrmO7u7jEAngPQm1S2z2pqapr+OPt7XEly0oxwzq2RdFmSD2AMgKKJouhhAL4kA+Cs53l7e3t7uytJHgRBreTWkXwkKVJnJD0B4GAGwIJE9R6AFufc6UqSZ7PZbD6ff5dkA4CQZEHSqwAOISmXtwGIE+F1SeqqIP8d+Xz+C0mLJYWSAODteXffczjdDQNJ0BWMCoLg5gqIbRTJNwHsljQhUb0luWPM2LE7Thw/9m/5NCT/TByxAOYWi8X6/gdWV1dnfN8fNRBxJpMZTXKdc+6IpFVJWAEgkvSJpA0X2tvtVTaSjgOYBCAEEADYSHK87/sfhmEYA9gShuEDkgzJHyWtB/B1irQ2juP7ADxkrX0wOUOpzmdpzEY590HJ7Ni1r2kSyZOSiv2+hSRjSTXp/QAukzySNJOJkmalyNIl10hqMcasdc61XDNcQRD8BnITgNp+36r6kfcNFMMlLQGwTNLMEuQGQBfJl2bdPru+HDkAZAqFQux53jZHEsC6aw0eg2gylNRBcqcx5v04ji999+03AwsWAOI4Lsy9a94WkisAnE5a5WCJYwCfA1g7LJudI2lTHMeXBm1faiQzxkyRtF3S5CTupeAB+KG2tnZFT0/P30NO2VKLzrmfAbwGMipjG5Oc0dPTc0Md05SZ5U4Q2FxChErtEYD7jTGNQ3UgM8Asv90Yc9I5LSKRlXSI5CxJa0jWSALJjKRnAewfkniT+vwf7N7fXHK9rq7O7+jo+BTA/NRrdBpjnnLOnUrvXd7YMPQXSBunneno6IhIHgYwW1JtkgmBpBkATlVMAwOk3nFJ+VSoqgCMr6gIy2FcLtdKspAedyQN/98caDt/3kpyabUmf8WvG/8A1vODTBVE/0MAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-pan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4lKssI9gAAAOtJREFUWMPVll0KwyAMgNPgoc0JzDX2Mtgp3csKErSamGabIEUo/T6bHz0ezxdsjPJ5kvUDaROem7VJAp3gufkbtwtI+JYEOsHNEugIN0mgM1wtsVoF1MnyKtZHZBW4DVxoMh6jaAW0MTfnBAbALyUwCD6UwEB4VyJN4FXx4aqUAACgFLjzrsRP9AECAP4Cm88QtJeJrGivdeNdPpko+j1H7XzUB+6WYHmo4eDk4wj41XFMEfBZGXpK0F/eB+QhVcXslVo7i6eANjF5NYSojCN7wi05MJNgbfKiMaPZA75TBVKCrWWbnGrb3DPePZ9Bcbe/QecAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-xpan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4X4hxZdgAAAMpJREFUWMPtlsEKwjAMhr/pwOOedINJe/PobWXCfAIvgo/nA4heOiilZQqN2yE5lpD/I38SWt3uD9aMHSuHAiiAAmwaYCqoM/0KMABtQYDW11wEaHyiEei28bWb8LGOkk5C4iEEgE11YBQWDyHGuAMD0CeS30IQPfACbC3o+Vd2bOIOWMCtoO1mC+ap3CfmoCokFs/SZd6E0ILjnzrhvFbyEJ2FIZzXyB6iZ3AkjITn8WOdSbbAoaD4NSW+tIZdQYBOPyQKoAAKkIsPv0se4A/1UC0AAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-ypan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4anK0lywAAAMVJREFUWMPtlzEKwzAMRX/S7rlpIMXeOnaLaME36FLo8XqCdNFghGljyc4kgQi2Q/SUj0F/eL7eMMTKz6j9wNlYPGRrFcSoLH4XxQPvdQeYuPOlcLbw2dRTgqvoXEaolWM0aP4LYm0NkHYWzyFSSwlmzjw2sR6OvAXNwgEcwAEcwAEcwAEcoGYk20SiMCHlmVoCzACoojEqjHBmCeJOCOo1lgPA7Q8E8TvdjMmHuzsV3NFD4w+1t+Ai/gTx3qHuOFqdMQB8ASMwJX0IEHOeAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-range {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-polygon-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-redo {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4itK+dVQAAAaFJREFUWMPt1L1rFFEUBfDfJDaBBSslIFjbaSFp1FJQFMVCHkzhKIqdUYOCoBgErVz8rCwiTDMwBCIKipDWyip/gxAIWAmBgBC0eYFh2Gx2l9lFcA5M8e59782Zc84dWrT435Hs1siLchqn43MS0zgW22vYxjesYjVLw3YjBPKinMUTBOwf8J5fKLGYpWFjJAJ5Uc7gIW6jM6Kim3iNZ1katgYmEL/6I+YasvY7Lg6iRpIX5VF8wuEe/XV8wGf8jN6LWTiAc7iEQ7ucPZ+lYW0vAtfwvlbfwCKW9gpXDOv1mJvZHiSO91MiyYsyiQSuxtpXXM7SsDmM5nlRdrCMMz3sOJWl4Xevc/vwBzdwAl+yNNwZxfRI+GxelK9ikHcwh8d4NNR/YFRES1ZwoTYdR7I0rNf3TzVNIGbmSvR/Bx08mIgCFSVu4l2ltIWD9WxNGR+W8KOynqnZ0rwCeVG+wa0hjrxtWoF5dAfc28V8Mib/n+Nev5dnabg/zgw87aNEN/bHOwVRiRe4Wym9zNKwMKkpgIWKEt24njxiJlq0aPFv4i9ZWXMSPPhE/QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-reset {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4gWqH8eQAABLdJREFUWMPtlktsVGUUx3/nfvfOlLQaY2IiRRMQIRpI0PjamJhoVASDvNpCpYw1vJQYSVwZwIVQF6wwRHmkAUof9ElrI6VqDAXcID4TF0IiYQMkSlTokNCZ+b7jove2t+NMH7rQBWd3v+989/zP+Z8X3Jb/WGQySvUNTQBJESkNguAVYIWqzhaRhwBU9WcR+QXoymazn6jqzUQiMQSQzWZRVdal1vwzAI2tHQBPOuc2AbWTdOyQ53n7nHNfRwee51GzqoIQMCLDpr3x/tLQ0oZzrk5Vj0/BOEBt+KYuOlBVGlrahr0Wob27t3gEjnZ2AyQzmUwHsDgP6J/AYRE553neDwDOuUdU9QngNeCumK4TkRMhZUORcYC1qysLA6iuSQHIwkWLD6lqapQsuSmwTVV3h99I7EcAR462A2xR2Ilq6ehTaejvO1774kuLNALR33eclsaGsQDe3fYegHl43vyNwEeqGl1963mm2jl7YZRTQ82qlWP4HM6ZToC5ztkW4LHQoALru7s6Di5dvlIj/e6ujrEAWoZDn8hmMjXATMACGaAVuBjXTVVXFc/AxhaA+4zvn1DV+eHxVWPMAmvtb5GeMWZyZVhI2rt7qVy2pOh9U1snwIPW2vMi4oWJuBPYHkVAVScPoKmtkzVVK6cEMsyJraHhiCqJqJUwj/JRz7TW1iSSyR2rVyylqa0Ta+24Ic8vXaAEmDFc/l5Z2A/80OibuVyuz/f9ElUdHCmvw82t5HK5h6y1PYhsz2YyGw43t2KtBZHIGwB6+j4rCkBVUdV7gXrggnPuu8h4eP+xMeZS2D0rJYZ6AdAMzAt1b4nI26p6IFZOY8pugijcKSIHVLUK0LyST4vnrVfnWr3mjmP4QTATaERkXkypRFX3isjmuHdRJEK6Ckqquopp06bdKCkp2Sgi7XnGLcg7gzeutwNIiPYc8HixqIrIOlU9ONVIhHPEd851icgSVXUiskVV94gIqoonIt0i8gfQCfwae38e6BWRXuBZz5jZ8VbaOE4EIqlZVUEQBLlkMplS1QER2RwkEnsSyaREDUzyeNsvIhvCMqkH1kdIJ2o+k8iJB1LVVRfjZ6nqqlEAIbdVQGto8Lrv+/dbawcjAL7vc+6bs+zetetfLSHxniIFGofGGsU2oC7eOCbDfZ7nQawBOSAX74SF9oEPImOq+r7nmVmxb5raukZa8UReGmNmhbMkAwwBH467EYVZe49z7kdgenj8k7V2oTHm8kgdWcvrNdVFjR8cHkYzjDH9wLjDaEwEzpwa4MypgWvAjtjxfGNMj4jMiT+M+kFsZI/Q6Pv+HGNMT8w4wI7TAyevxXVPD5z8+zD64tRXAMHVK1eaVLUyVvuDqroV2BOnJF4ZIedviUidqt4Re9s+vbx8zZXLl7PR2+nl5Tz/zNOFp2FzxzGAklw22wUsLLaSKXwf8vhosZUM6PeDYEUum70VHfpBwKsVyyfeikOP6oBNwN1TrLbfgX3A1kKLzKeff8nLLzw38T5wZDgxn1LnNk5lLRfP26/OnR2hwfNYW2Atn9RCsrf+EECyrKysDFimqhXhyjY3VLkAXBKRDqA7nU6nS0tLhyIj6XSaN9bVclv+l/IXAmkwvZc+jNUAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-save {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4UexUIzAAAAIRJREFUWMNjXLhs5X+GAQRMDAMMWJDYjGhyf7CoIQf8x2H+f0KGM9M7BBio5FNcITo408CoA0YdQM1cwEhtB/ylgqMkCJmFLwrOQguj/xTg50hmkeyARAYGhlNUCIXjDAwM0eREwTUGBgbz0Ww46oBRB4w6YNQBow4YdcCIahP+H5EhAAAH2R8hH3Rg0QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-tap-select {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-undo {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4em8Dh0gAAAatJREFUWMPt1rFrFFEQBvDfGhACASshkL/ALpWVrSAKEQV5sIULWlgZNSgIFkGIVQ412gkBt1lYLERREFJqJRaW1oHAoZUQsDqwecWy7N3tbe6C4H2wxc682Zn3zTfvLXPM8b8j6RqYF+UCzsfnHBawGt3fMcAX7GEvS8NgKgXkRbmMxwg41TLsN0psZmnodyogL8pFPMIdLHUk7hA7eJKl4U/rAuKu3+HslFr/FZezNPSTFslX8QErDe4DvMVH/Iq9F7VwGpdwZUjsPtaSFjv/1vCBPjaxO0xcNbHejLpZrrlvJCMCT+JzA+2fcC1Lw+GE4l3CG1yIptfjCtiKoqtiJ0vD3aM0Py/K57iIMxgkQxat4EdN7e9xdRzlk+LEEPvDWvIDXJ928sYxjL36icWK+VaWhlezOIqbGFirJd/H7szugrwoX+D2BDEvszSsT5OBdfRaru/F9dPXQF6U27g/KnmWhgctxqyzBrZGMNGL/rHI0nDkKXiKexXTsywNGx0OnFbFNk3BRoWJXnw//j+ivCi32/S8CxPVNiWOAdUiJtXITIqYY45/Cn8B2D97FYW2H+IAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-wheel-pan {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-wheel-zoom {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-box-edit {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-freehand-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-poly-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-point-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-poly-edit {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-line-edit {\n  background-image: url("data:image/png;base64,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");\n}\n'},
function _(n,o,r,t,e){t();r.default="\n.bk-root .bk-menu-icon {\n  width: 28px;\n  height: 28px;\n  background-size: 60%;\n  background-color: transparent;\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n.bk-root .bk-context-menu {\n  position: absolute;\n  display: inline-flex;\n  display: -webkit-inline-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  width: auto;\n  height: auto;\n  z-index: 100;\n  cursor: pointer;\n  font-size: 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n  box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);\n}\n.bk-root .bk-context-menu.bk-horizontal {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-context-menu.bk-vertical {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-context-menu > .bk-divider {\n  cursor: default;\n  overflow: hidden;\n  background-color: #e5e5e5;\n}\n.bk-root .bk-context-menu.bk-horizontal > .bk-divider {\n  width: 1px;\n  margin: 5px 0;\n}\n.bk-root .bk-context-menu.bk-vertical > .bk-divider {\n  height: 1px;\n  margin: 0 5px;\n}\n.bk-root .bk-context-menu > :not(.bk-divider) {\n  border: 1px solid transparent;\n}\n.bk-root .bk-context-menu > :not(.bk-divider).bk-active {\n  border-color: #26aae1;\n}\n.bk-root .bk-context-menu > :not(.bk-divider):hover {\n  background-color: #f9f9f9;\n}\n.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):first-child {\n  border-top-left-radius: 4px;\n  border-bottom-left-radius: 4px;\n}\n.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):last-child {\n  border-top-right-radius: 4px;\n  border-bottom-right-radius: 4px;\n}\n.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):first-child {\n  border-top-left-radius: 4px;\n  border-top-right-radius: 4px;\n}\n.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):last-child {\n  border-bottom-left-radius: 4px;\n  border-bottom-right-radius: 4px;\n}\n.bk-root .bk-menu {\n  position: absolute;\n  left: 0;\n  width: 100%;\n  z-index: 100;\n  cursor: pointer;\n  font-size: 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n  box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);\n}\n.bk-root .bk-menu.bk-above {\n  bottom: 100%;\n}\n.bk-root .bk-menu.bk-below {\n  top: 100%;\n}\n.bk-root .bk-menu > .bk-divider {\n  height: 1px;\n  margin: 7.5px 0;\n  overflow: hidden;\n  background-color: #e5e5e5;\n}\n.bk-root .bk-menu > :not(.bk-divider) {\n  padding: 6px 12px;\n}\n.bk-root .bk-menu > :not(.bk-divider):hover,\n.bk-root .bk-menu > :not(.bk-divider).bk-active {\n  background-color: #e6e6e6;\n}\n.bk-root .bk-caret {\n  display: inline-block;\n  vertical-align: middle;\n  width: 0;\n  height: 0;\n  margin: 0 5px;\n}\n.bk-root .bk-caret.bk-down {\n  border-top: 4px solid;\n}\n.bk-root .bk-caret.bk-up {\n  border-bottom: 4px solid;\n}\n.bk-root .bk-caret.bk-down,\n.bk-root .bk-caret.bk-up {\n  border-right: 4px solid transparent;\n  border-left: 4px solid transparent;\n}\n.bk-root .bk-caret.bk-left {\n  border-right: 4px solid;\n}\n.bk-root .bk-caret.bk-right {\n  border-left: 4px solid;\n}\n.bk-root .bk-caret.bk-left,\n.bk-root .bk-caret.bk-right {\n  border-top: 4px solid transparent;\n  border-bottom: 4px solid transparent;\n}\n"},
function _(t,e,n,i,o){i();var l=t(1),s=t(187),r=t(300),u=l.__importStar(t(301)),h=function(){function t(t,e){var n=this;void 0===e&&(e={}),this.items=t,this.options=e,this.el=s.div(),this._open=!1,this._item_click=function(t){var e;null===(e=n.items[t])||void 0===e||e.handler(),n.hide()},this._on_mousedown=function(t){var e,i,o=t.target;o instanceof Node&&n.el.contains(o)||(null===(i=(e=n.options).prevent_hide)||void 0===i?void 0:i.call(e,t))||n.hide()},this._on_keydown=function(t){t.keyCode==s.Keys.Esc&&n.hide()},this._on_blur=function(){n.hide()},s.undisplay(this.el)}return Object.defineProperty(t.prototype,"is_open",{get:function(){return this._open},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"can_open",{get:function(){return 0!=this.items.length},enumerable:!1,configurable:!0}),t.prototype.remove=function(){s.remove(this.el),this._unlisten()},t.prototype._listen=function(){document.addEventListener("mousedown",this._on_mousedown),document.addEventListener("keydown",this._on_keydown),window.addEventListener("blur",this._on_blur)},t.prototype._unlisten=function(){document.removeEventListener("mousedown",this._on_mousedown),document.removeEventListener("keydown",this._on_keydown),window.removeEventListener("blur",this._on_blur)},t.prototype._position=function(t){var e=this.el.parentElement;if(null!=e){var n=e.getBoundingClientRect();this.el.style.left=null!=t.left?t.left-n.left+"px":"",this.el.style.top=null!=t.top?t.top-n.top+"px":"",this.el.style.right=null!=t.right?n.right-t.right+"px":"",this.el.style.bottom=null!=t.bottom?n.bottom-t.bottom+"px":""}},t.prototype.render=function(){var t,e,n,i,o=this;s.empty(this.el,!0);var h=null!==(n=this.options.orientation)&&void 0!==n?n:"vertical";s.classes(this.el).add("bk-context-menu","bk-"+h);var d=function(t,e){var n=void 0;if(null==t)n=s.div({class:u.bk_divider});else{if(null!=t.if&&!t.if())return"continue";var l=null!=t.icon?s.div({class:["bk-menu-icon",t.icon]}):null;n=s.div({class:(null===(i=t.active)||void 0===i?void 0:i.call(t))?"bk-active":null,title:t.tooltip},l,t.label)}n.addEventListener("click",(function(){return o._item_click(e)})),c.el.appendChild(n)},c=this;try{for(var p=l.__values(r.enumerate(this.items)),a=p.next();!a.done;a=p.next()){var _=l.__read(a.value,2);d(_[0],_[1])}}catch(e){t={error:e}}finally{try{a&&!a.done&&(e=p.return)&&e.call(p)}finally{if(t)throw t.error}}},t.prototype.show=function(t){if(0!=this.items.length&&!this._open){if(this.render(),0==this.el.children.length)return;this._position(null!=t?t:{left:0,top:0}),s.display(this.el),this._listen(),this._open=!0}},t.prototype.hide=function(){this._open&&(this._open=!1,this._unlisten(),s.undisplay(this.el))},t.prototype.toggle=function(t){this._open?this.hide():this.show(t)},t}();n.ContextMenu=h,h.__name__="ContextMenu"},
function _(e,r,n,t,a){t();var l=e(1),u=e(124);function s(e,r){var n,t,a,s,c,o,i,f,v,_,h,y,b;return l.__generator(this,(function(d){switch(d.label){case 0:return n=e.length,r>n?[2]:[4,(t=u.range(r)).map((function(r){return e[r]}))];case 1:d.sent(),d.label=2;case 2:0,a=void 0;try{for(_=void 0,s=l.__values(u.reversed(u.range(r))),c=s.next();!c.done;c=s.next())if(o=c.value,t[o]!=o+n-r){a=o;break}}catch(e){_={error:e}}finally{try{c&&!c.done&&(h=s.return)&&h.call(s)}finally{if(_)throw _.error}}if(null==a)return[2];t[a]+=1;try{for(y=void 0,i=l.__values(u.range(a+1,r)),f=i.next();!f.done;f=i.next())v=f.value,t[v]=t[v-1]+1}catch(e){y={error:e}}finally{try{f&&!f.done&&(b=i.return)&&b.call(i)}finally{if(y)throw y.error}}return[4,t.map((function(r){return e[r]}))];case 3:return d.sent(),[3,2];case 4:return[2]}}))}n.enumerate=function(e){var r,n,t,a,u,s;return l.__generator(this,(function(c){switch(c.label){case 0:r=0,c.label=1;case 1:c.trys.push([1,6,7,8]),n=l.__values(e),t=n.next(),c.label=2;case 2:return t.done?[3,5]:[4,[t.value,r++]];case 3:c.sent(),c.label=4;case 4:return t=n.next(),[3,2];case 5:return[3,8];case 6:return a=c.sent(),u={error:a},[3,8];case 7:try{t&&!t.done&&(s=n.return)&&s.call(n)}finally{if(u)throw u.error}return[7];case 8:return[2]}}))},n.combinations=s,n.subsets=function(e){var r,n,t,a,c,o;return l.__generator(this,(function(i){switch(i.label){case 0:i.trys.push([0,5,6,7]),r=l.__values(u.range(e.length+1)),n=r.next(),i.label=1;case 1:return n.done?[3,4]:(t=n.value,[5,l.__values(s(e,t))]);case 2:i.sent(),i.label=3;case 3:return n=r.next(),[3,1];case 4:return[3,7];case 5:return a=i.sent(),c={error:a},[3,7];case 6:try{n&&!n.done&&(o=r.return)&&o.call(r)}finally{if(c)throw c.error}return[7];case 7:return[2]}}))}},
function _(b,e,k,i,d){i(),k.bk_menu="bk-menu",k.bk_caret="bk-caret",k.bk_divider="bk-divider"},
function _(t,e,n,o,i){o();var c=t(1),l=t(293),r=t(303),u=t(187),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return c.__extends(e,t),e.prototype.render=function(){t.prototype.render.call(this),u.classes(this.el).toggle(r.bk_active,this.model.active)},e.prototype._clicked=function(){var t=this.model.active;this.model.active=!t},e}(l.ButtonToolButtonView);n.OnOffButtonView=s,s.__name__="OnOffButtonView"},
function _(b,e,k,t,i){t(),k.bk_active="bk-active",k.bk_inline="bk-inline",k.bk_left="bk-left",k.bk_right="bk-right",k.bk_above="bk-above",k.bk_below="bk-below",k.bk_up="bk-up",k.bk_down="bk-down",k.bk_side=function(b){switch(b){case"above":return k.bk_above;case"below":return k.bk_below;case"left":return k.bk_left;case"right":return k.bk_right}}},
function _(t,n,e,o,i){o();var u=t(1),_=t(293),l=t(302),r=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return u.__extends(n,t),n}(_.ButtonToolView);e.InspectToolView=r,r.__name__="InspectToolView";var c=function(t){function n(n){var e=t.call(this,n)||this;return e.event_type="move",e}return u.__extends(n,t),n.init_InspectTool=function(){this.prototype.button_view=l.OnOffButtonView,this.define((function(t){return{toggleable:[t.Boolean,!0]}})),this.override({active:!0})},n}(_.ButtonTool);e.InspectTool=c,c.__name__="InspectTool",c.init_InspectTool()},
function _(t,e,o,i,l){i();var n=t(1),r=t(134),a=t(187),s=t(230),u=t(193),c=t(135),_=t(124),h=t(128),v=t(123),p=t(196),f=t(291),d=t(292),b=t(306),y=t(307),g=t(304),m=t(295),w=t(309),T=t(303),x=n.__importDefault(t(296)),k=n.__importDefault(t(310)),z=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_ToolbarViewModel=function(){this.define((function(t){var e=t.Boolean;return{_visible:[(0,t.Nullable)(e),null],autohide:[e,!1]}}))},Object.defineProperty(e.prototype,"visible",{get:function(){return!this.autohide||null!=this._visible&&this._visible},enumerable:!1,configurable:!0}),e}(p.Model);o.ToolbarViewModel=z,z.__name__="ToolbarViewModel",z.init_ToolbarViewModel();var B=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._tool_button_views=new Map,this._toolbar_view_model=new z({autohide:this.model.autohide})},e.prototype.lazy_initialize=function(){return n.__awaiter(this,void 0,void 0,(function(){return n.__generator(this,(function(e){switch(e.label){case 0:return[4,t.prototype.lazy_initialize.call(this)];case 1:return e.sent(),[4,this._build_tool_button_views()];case 2:return e.sent(),[2]}}))}))},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.tools.change,(function(){return n.__awaiter(e,void 0,void 0,(function(){return n.__generator(this,(function(t){switch(t.label){case 0:return[4,this._build_tool_button_views()];case 1:return t.sent(),this.render(),[2]}}))}))})),this.connect(this.model.properties.autohide.change,(function(){e._toolbar_view_model.autohide=e.model.autohide,e._on_visible_change()})),this.connect(this._toolbar_view_model.properties._visible.change,(function(){return e._on_visible_change()}))},e.prototype.styles=function(){return n.__spread(t.prototype.styles.call(this),[x.default,k.default])},e.prototype.remove=function(){s.remove_views(this._tool_button_views),t.prototype.remove.call(this)},e.prototype._build_tool_button_views=function(){return n.__awaiter(this,void 0,void 0,(function(){var t;return n.__generator(this,(function(e){switch(e.label){case 0:return t=null!=this.model._proxied_tools?this.model._proxied_tools:this.model.tools,[4,s.build_views(this._tool_button_views,t,{parent:this},(function(t){return t.button_view}))];case 1:return e.sent(),[2]}}))}))},e.prototype.set_visibility=function(t){t!=this._toolbar_view_model._visible&&(this._toolbar_view_model._visible=t)},e.prototype._on_visible_change=function(){var t=this._toolbar_view_model.visible,e=m.bk_toolbar_hidden;this.el.classList.contains(e)&&t?this.el.classList.remove(e):t||this.el.classList.add(e)},e.prototype.render=function(){var t,e,o,i,l,r,s=this;if(a.empty(this.el),this.el.classList.add(m.bk_toolbar),this.el.classList.add(T.bk_side(this.model.toolbar_location)),this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change(),null!=this.model.logo){var u="grey"===this.model.logo?w.bk_grey:null,c=a.a({href:"https://bokeh.org/",target:"_blank",class:[w.bk_logo,w.bk_logo_small,u]});this.el.appendChild(c)}try{for(var _=n.__values(this._tool_button_views),v=_.next();!v.done;v=_.next()){n.__read(v.value,2)[1].render()}}catch(e){t={error:e}}finally{try{v&&!v.done&&(e=_.return)&&e.call(_)}finally{if(t)throw t.error}}var p=[],f=function(t){return s._tool_button_views.get(t).el},d=this.model.gestures;try{for(var b=n.__values(h.values(d)),y=b.next();!y.done;y=b.next()){var g=y.value;p.push(g.tools.map(f))}}catch(t){o={error:t}}finally{try{y&&!y.done&&(i=b.return)&&i.call(b)}finally{if(o)throw o.error}}p.push(this.model.actions.map(f)),p.push(this.model.inspectors.filter((function(t){return t.toggleable})).map(f));try{for(var x=n.__values(p),k=x.next();!k.done;k=x.next()){var z=k.value;if(0!==z.length){var B=a.div({class:m.bk_button_bar},z);this.el.appendChild(B)}}}catch(t){l={error:t}}finally{try{k&&!k.done&&(r=x.return)&&r.call(x)}finally{if(l)throw l.error}}},e.prototype.update_layout=function(){},e.prototype.update_position=function(){},e.prototype.after_layout=function(){this._has_finished=!0},e}(u.DOMView);function M(){return{pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}}}o.ToolbarBaseView=B,B.__name__="ToolbarBaseView";var L=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_ToolbarBase=function(){this.prototype.default_view=B,this.define((function(t){var e=t.Boolean;return{tools:[(0,t.Array)((0,t.Ref)(f.Tool)),[]],logo:[c.Logo,"normal"],autohide:[e,!1]}})),this.internal((function(t){var e=t.Array,o=t.Struct,i=t.Ref,l=t.Nullable,n=o({tools:e(i(d.GestureTool)),active:l(i(f.Tool))});return{gestures:[o({pan:n,scroll:n,pinch:n,tap:n,doubletap:n,press:n,pressup:n,rotate:n,move:n,multi:n}),M],actions:[e(i(b.ActionTool)),[]],inspectors:[e(i(g.InspectTool)),[]],help:[e(i(y.HelpTool)),[]],toolbar_location:[c.Location,"right"]}}))},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._init_tools()},e.prototype._init_tools=function(){var t,e,o,i,l,a,s=this,u=function(t,e){if(t.length!=e.length)return!0;var o=new Set(e.map((function(t){return t.id})));return _.some(t,(function(t){return!o.has(t.id)}))},c=this.tools.filter((function(t){return t instanceof g.InspectTool}));u(this.inspectors,c)&&(this.inspectors=c);var h=this.tools.filter((function(t){return t instanceof y.HelpTool}));u(this.help,h)&&(this.help=h);var p=this.tools.filter((function(t){return t instanceof b.ActionTool}));u(this.actions,p)&&(this.actions=p);var f=function(t,e){t in s.gestures||r.logger.warn("Toolbar: unknown event type '"+t+"' for tool: "+e)},m={pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}};try{for(var w=n.__values(this.tools),T=w.next();!T.done;T=w.next()){var x=T.value;if(x instanceof d.GestureTool&&x.event_type)if(v.isString(x.event_type))m[x.event_type].tools.push(x),f(x.event_type,x);else{m.multi.tools.push(x);try{for(var k=(o=void 0,n.__values(x.event_type)),z=k.next();!z.done;z=k.next()){f(z.value,x)}}catch(t){o={error:t}}finally{try{z&&!z.done&&(i=k.return)&&i.call(k)}finally{if(o)throw o.error}}}}}catch(e){t={error:e}}finally{try{T&&!T.done&&(e=w.return)&&e.call(w)}finally{if(t)throw t.error}}var B=function(t){var e=M.gestures[t];u(e.tools,m[t].tools)&&(e.tools=m[t].tools),e.active&&_.every(e.tools,(function(t){return t.id!=e.active.id}))&&(e.active=null)},M=this;try{for(var L=n.__values(Object.keys(m)),V=L.next();!V.done;V=L.next()){B(V.value)}}catch(t){l={error:t}}finally{try{V&&!V.done&&(a=L.return)&&a.call(L)}finally{if(l)throw l.error}}},Object.defineProperty(e.prototype,"horizontal",{get:function(){return"above"===this.toolbar_location||"below"===this.toolbar_location},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"vertical",{get:function(){return"left"===this.toolbar_location||"right"===this.toolbar_location},enumerable:!1,configurable:!0}),e.prototype._active_change=function(t){var e,o,i=t.event_type;if(null!=i){var l=v.isString(i)?[i]:i;try{for(var a=n.__values(l),s=a.next();!s.done;s=a.next()){var u=s.value;if(t.active){var c=this.gestures[u].active;null!=c&&t!=c&&(r.logger.debug("Toolbar: deactivating tool: "+c+" for event type '"+u+"'"),c.active=!1),this.gestures[u].active=t,r.logger.debug("Toolbar: activating tool: "+t+" for event type '"+u+"'")}else this.gestures[u].active=null}}catch(t){e={error:t}}finally{try{s&&!s.done&&(o=a.return)&&o.call(a)}finally{if(e)throw e.error}}}},e}(p.Model);o.ToolbarBase=L,L.__name__="ToolbarBase",L.init_ToolbarBase()},
function _(t,n,o,i,e){i();var c=t(1),u=t(293),l=t(130),_=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return c.__extends(n,t),n.prototype._clicked=function(){this.model.do.emit(void 0)},n}(u.ButtonToolButtonView);o.ActionToolButtonView=_,_.__name__="ActionToolButtonView";var r=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return c.__extends(n,t),n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this),this.connect(this.model.do,(function(t){return n.doit(t)}))},n}(u.ButtonToolView);o.ActionToolView=r,r.__name__="ActionToolView";var s=function(t){function n(n){var o=t.call(this,n)||this;return o.button_view=_,o.do=new l.Signal(o,"do"),o}return c.__extends(n,t),n}(u.ButtonTool);o.ActionTool=s,s.__name__="ActionTool"},
function _(t,o,e,n,i){n();var l=t(1),r=t(306),p=t(308),u=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return l.__extends(o,t),o.prototype.doit=function(){window.open(this.model.redirect)},o}(r.ActionToolView);e.HelpToolView=u,u.__name__="HelpToolView";var _=function(t){function o(o){var e=t.call(this,o)||this;return e.tool_name="Help",e.icon=p.bk_tool_icon_help,e}return l.__extends(o,t),o.init_HelpTool=function(){this.prototype.default_view=u,this.define((function(t){var o=t.String;return{help_tooltip:[o,"Click the question mark to learn more about Bokeh plot tools."],redirect:[o,"https://docs.bokeh.org/en/latest/docs/user_guide/tools.html"]}})),this.register_alias("help",(function(){return new o}))},Object.defineProperty(o.prototype,"tooltip",{get:function(){return this.help_tooltip},enumerable:!1,configurable:!0}),o}(r.ActionTool);e.HelpTool=_,_.__name__="HelpTool",_.init_HelpTool()},
function _(o,_,l,n,t){n(),l.bk_tool_icon_box_select="bk-tool-icon-box-select",l.bk_tool_icon_box_zoom="bk-tool-icon-box-zoom",l.bk_tool_icon_zoom_in="bk-tool-icon-zoom-in",l.bk_tool_icon_zoom_out="bk-tool-icon-zoom-out",l.bk_tool_icon_help="bk-tool-icon-help",l.bk_tool_icon_hover="bk-tool-icon-hover",l.bk_tool_icon_crosshair="bk-tool-icon-crosshair",l.bk_tool_icon_lasso_select="bk-tool-icon-lasso-select",l.bk_tool_icon_pan="bk-tool-icon-pan",l.bk_tool_icon_xpan="bk-tool-icon-xpan",l.bk_tool_icon_ypan="bk-tool-icon-ypan",l.bk_tool_icon_range="bk-tool-icon-range",l.bk_tool_icon_polygon_select="bk-tool-icon-polygon-select",l.bk_tool_icon_redo="bk-tool-icon-redo",l.bk_tool_icon_reset="bk-tool-icon-reset",l.bk_tool_icon_save="bk-tool-icon-save",l.bk_tool_icon_tap_select="bk-tool-icon-tap-select",l.bk_tool_icon_undo="bk-tool-icon-undo",l.bk_tool_icon_wheel_pan="bk-tool-icon-wheel-pan",l.bk_tool_icon_wheel_zoom="bk-tool-icon-wheel-zoom",l.bk_tool_icon_box_edit="bk-tool-icon-box-edit",l.bk_tool_icon_freehand_draw="bk-tool-icon-freehand-draw",l.bk_tool_icon_poly_draw="bk-tool-icon-poly-draw",l.bk_tool_icon_point_draw="bk-tool-icon-point-draw",l.bk_tool_icon_poly_edit="bk-tool-icon-poly-edit",l.bk_tool_icon_line_edit="bk-tool-icon-line-edit"},
function _(o,b,k,l,g){l(),k.bk_logo="bk-logo",k.bk_logo_notebook="bk-logo-notebook",k.bk_logo_small="bk-logo-small",k.bk_grey="bk-grey"},
function _(l,n,o,A,g){A();o.default="\n.bk-root .bk-logo {\n  margin: 5px;\n  position: relative;\n  display: block;\n  background-repeat: no-repeat;\n}\n.bk-root .bk-logo.bk-grey {\n  filter: url(\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg'><filter id='grayscale'><feColorMatrix type='matrix' values='0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0'/></filter></svg>#grayscale\");\n  /* Firefox 10+, Firefox on Android */\n  filter: gray;\n  /* IE6-9 */\n  -webkit-filter: grayscale(100%);\n  /* Chrome 19+, Safari 6+, Safari 6+ iOS */\n}\n.bk-root .bk-logo-small {\n  width: 20px;\n  height: 20px;\n  background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);\n}\n.bk-root .bk-logo-notebook {\n  display: inline-block;\n  vertical-align: middle;\n  margin-right: 5px;\n}\n"},
function _(t,e,i,o,l){o();var s=t(1),n=t(151),r=t(135),a=t(187),h=t(312),c=t(303),p=s.__importDefault(t(313)),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.el=a.div({class:h.bk_tooltip}),a.undisplay(this.el),this.plot_view.canvas_view.add_overlay(this.el)},e.prototype.remove=function(){a.remove(this.el),t.prototype.remove.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.content.change,(function(){return e.render()})),this.connect(this.model.properties.position.change,(function(){return e._reposition()}))},e.prototype.styles=function(){return s.__spread(t.prototype.styles.call(this),[p.default])},e.prototype.render=function(){this.model.visible||a.undisplay(this.el),t.prototype.render.call(this)},e.prototype._render=function(){var t=this.model.content;null!=t?(a.empty(this.el),a.classes(this.el).toggle(h.bk_tooltip_custom,this.model.custom),this.el.appendChild(t),this.model.show_arrow&&this.el.classList.add(h.bk_tooltip_arrow)):a.undisplay(this.el)},e.prototype._reposition=function(){var t=this,e=this.model.position;if(null!=e){var i,o=s.__read(e,2),l=o[0],n=o[1],r=function(){var e=t.parent.layout.bbox.relativize(),i=t.model.attachment;switch(i){case"horizontal":return l<e.hcenter?"right":"left";case"vertical":return n<e.vcenter?"below":"above";default:return i}}();this.el.classList.remove(c.bk_right),this.el.classList.remove(c.bk_left),this.el.classList.remove(c.bk_above),this.el.classList.remove(c.bk_below),a.display(this.el);var h=null,p=null;switch(r){case"right":this.el.classList.add(c.bk_left),h=l+(this.el.offsetWidth-this.el.clientWidth)+10,i=n-this.el.offsetHeight/2;break;case"left":this.el.classList.add(c.bk_right),p=this.plot_view.layout.bbox.width-l+10,i=n-this.el.offsetHeight/2;break;case"below":this.el.classList.add(c.bk_above),i=n+(this.el.offsetHeight-this.el.clientHeight)+10,h=Math.round(l-this.el.offsetWidth/2);break;case"above":this.el.classList.add(c.bk_below),i=n-this.el.offsetHeight-10,h=Math.round(l-this.el.offsetWidth/2)}this.el.style.top=i+"px",this.el.style.left=null!=h?h+"px":"auto",this.el.style.right=null!=p?p+"px":"auto"}else a.undisplay(this.el)},e}(n.AnnotationView);i.TooltipView=u,u.__name__="TooltipView";var d=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_Tooltip=function(){this.prototype.default_view=u,this.define((function(t){var e=t.Boolean;return{attachment:[r.TooltipAttachment,"horizontal"],inner_only:[e,!0],show_arrow:[e,!0]}})),this.internal((function(t){var e=t.Boolean,i=t.Number,o=t.Tuple,l=t.Ref;return{position:[(0,t.Nullable)(o(i,i)),null],content:[l(HTMLElement),function(){return a.div()}],custom:[e]}})),this.override({level:"overlay"})},e.prototype.clear=function(){this.position=null},e}(n.Annotation);i.Tooltip=d,d.__name__="Tooltip",d.init_Tooltip()},
function _(o,t,l,b,_){b(),l.bk_tooltip="bk-tooltip",l.bk_tooltip_arrow="bk-tooltip-arrow",l.bk_tooltip_custom="bk-tooltip-custom",l.bk_tooltip_row_label="bk-tooltip-row-label",l.bk_tooltip_row_value="bk-tooltip-row-value",l.bk_tooltip_color_block="bk-tooltip-color-block"},
function _(o,n,t,r,e){r();t.default='\n.bk-root {\n  /* Same border color used everywhere */\n  /* Gray of icons */\n}\n.bk-root .bk-tooltip {\n  font-weight: 300;\n  font-size: 12px;\n  position: absolute;\n  padding: 5px;\n  border: 1px solid #e5e5e5;\n  color: #2f2f2f;\n  background-color: white;\n  pointer-events: none;\n  opacity: 0.95;\n  z-index: 100;\n}\n.bk-root .bk-tooltip > div:not(:first-child) {\n  /* gives space when multiple elements are being hovered over */\n  margin-top: 5px;\n  border-top: #e5e5e5 1px dashed;\n}\n.bk-root .bk-tooltip.bk-left.bk-tooltip-arrow::before {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-left::before {\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right.bk-tooltip-arrow::after {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right::after {\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-above::before {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  top: -10px;\n  border-bottom-width: 10px;\n  border-bottom-color: #909599;\n}\n.bk-root .bk-tooltip.bk-below::after {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  bottom: -10px;\n  border-top-width: 10px;\n  border-top-color: #909599;\n}\n.bk-root .bk-tooltip-row-label {\n  text-align: right;\n  color: #26aae1;\n  /* blue from toolbar highlighting */\n}\n.bk-root .bk-tooltip-row-value {\n  color: default;\n  /* seems to be necessary for notebook */\n}\n.bk-root .bk-tooltip-color-block {\n  width: 12px;\n  height: 12px;\n  margin-left: 5px;\n  margin-right: 5px;\n  outline: #dddddd solid 1px;\n  display: inline-block;\n}\n'},
function _(e,t,r,i,s){i();var n=e(1),o=e(242),h=e(199),a=e(143),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.source.streaming,(function(){return t.set_data(t.model.source)})),this.connect(this.model.source.patching,(function(){return t.set_data(t.model.source)})),this.connect(this.model.source.change,(function(){return t.set_data(t.model.source)}))},t.prototype._render=function(){this._map_data();var e=this.layer.ctx;if(this.visuals.line.doit)for(var t=0,r=this._lower_sx.length;t<r;t++)this.visuals.line.set_vectorize(e,t),e.beginPath(),e.moveTo(this._lower_sx[t],this._lower_sy[t]),e.lineTo(this._upper_sx[t],this._upper_sy[t]),e.stroke();var i="height"==this.model.dimension?0:Math.PI/2;if(null!=this.model.lower_head)for(t=0,r=this._lower_sx.length;t<r;t++)e.save(),e.translate(this._lower_sx[t],this._lower_sy[t]),e.rotate(i+Math.PI),this.model.lower_head.render(e,t),e.restore();if(null!=this.model.upper_head)for(t=0,r=this._upper_sx.length;t<r;t++)e.save(),e.translate(this._upper_sx[t],this._upper_sy[t]),e.rotate(i),this.model.upper_head.render(e,t),e.restore()},t}(o.UpperLowerView);r.WhiskerView=l,l.__name__="WhiskerView";var _=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_Whisker=function(){this.prototype.default_view=l,this.mixins(a.LineVector),this.define((function(e){var t=e.Ref;return{lower_head:[t(h.ArrowHead),function(){return new h.TeeHead({level:"underlay",size:10})}],upper_head:[t(h.ArrowHead),function(){return new h.TeeHead({level:"underlay",size:10})}]}})),this.override({level:"underlay"})},t}(o.UpperLower);r.Whisker=_,_.__name__="Whisker",_.init_Whisker()},
function _(i,s,x,A,o){A(),o("Axis",i(316).Axis),o("CategoricalAxis",i(318).CategoricalAxis),o("ContinuousAxis",i(321).ContinuousAxis),o("DatetimeAxis",i(322).DatetimeAxis),o("LinearAxis",i(323).LinearAxis),o("LogAxis",i(336).LogAxis),o("MercatorAxis",i(339).MercatorAxis)},
function _(e,t,i,r,a){r();var o=e(1),n=e(317),s=e(246),l=e(247),_=o.__importStar(e(143)),h=e(135),c=e(124),d=e(123),u=e(207),b=Math.abs,m=Math.min,p=Math.max,f=function(e){function t(){var t=e.apply(this,o.__spread(arguments))||this;return t.rotate=!0,t}return o.__extends(t,e),Object.defineProperty(t.prototype,"panel",{get:function(){return this.layout},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"is_renderable",{get:function(){var e=o.__read(this.ranges,2),t=e[0],i=e[1];return t.is_valid&&i.is_valid},enumerable:!1,configurable:!0}),t.prototype._render=function(){var e;if(this.is_renderable){var t={tick:this._tick_extent(),tick_label:this._tick_label_extents(),axis_label:this._axis_label_extent()},i=this.tick_coords,r=this.layer.ctx;r.save(),this._draw_rule(r,t),this._draw_major_ticks(r,t,i),this._draw_minor_ticks(r,t,i),this._draw_major_labels(r,t,i),this._draw_axis_label(r,t,i),null===(e=this._paint)||void 0===e||e.call(this,r,t,i),r.restore()}},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return t.plot_view.request_layout()}))},t.prototype.get_size=function(){if(this.model.visible&&null==this.model.fixed_location&&this.is_renderable){var e=this._get_size();return{width:0,height:Math.round(e)}}return{width:0,height:0}},t.prototype._get_size=function(){return this._tick_extent()+this._tick_label_extent()+this._axis_label_extent()},Object.defineProperty(t.prototype,"needs_clip",{get:function(){return null!=this.model.fixed_location},enumerable:!1,configurable:!0}),t.prototype._draw_rule=function(e,t){if(this.visuals.axis_line.doit){var i=o.__read(this.rule_coords,2),r=i[0],a=i[1],n=o.__read(this.coordinates.map_to_screen(r,a),2),s=n[0],l=n[1],_=o.__read(this.normals,2),h=_[0],c=_[1],d=o.__read(this.offsets,2),u=d[0],b=d[1];this.visuals.axis_line.set_value(e),e.beginPath(),e.moveTo(Math.round(s[0]+h*u),Math.round(l[0]+c*b));for(var m=1;m<s.length;m++){var p=Math.round(s[m]+h*u),f=Math.round(l[m]+c*b);e.lineTo(p,f)}e.stroke()}},t.prototype._draw_major_ticks=function(e,t,i){var r=this.model.major_tick_in,a=this.model.major_tick_out,o=this.visuals.major_tick_line;this._draw_ticks(e,i.major,r,a,o)},t.prototype._draw_minor_ticks=function(e,t,i){var r=this.model.minor_tick_in,a=this.model.minor_tick_out,o=this.visuals.minor_tick_line;this._draw_ticks(e,i.minor,r,a,o)},t.prototype._draw_major_labels=function(e,t,i){var r=i.major,a=this.compute_labels(r[this.dimension]),o=this.model.major_label_orientation,n=t.tick+this.model.major_label_standoff,s=this.visuals.major_label_text;this._draw_oriented_labels(e,a,r,o,this.panel.side,n,s)},t.prototype._draw_axis_label=function(e,t,i){if(null!=this.model.axis_label&&0!=this.model.axis_label.length&&null==this.model.fixed_location){var r,a,o=this.panel.bbox;switch(this.panel.side){case"above":r=o.hcenter,a=o.bottom;break;case"below":r=o.hcenter,a=o.top;break;case"left":r=o.right,a=o.vcenter;break;case"right":r=o.left,a=o.vcenter;break;default:throw new Error("unknown side: "+this.panel.side)}var n=[[r],[a]],s=t.tick+c.sum(t.tick_label)+this.model.axis_label_standoff,l=this.visuals.axis_label_text;this._draw_oriented_labels(e,[this.model.axis_label],n,"parallel",this.panel.side,s,l,"screen")}},t.prototype._draw_ticks=function(e,t,i,r,a){if(a.doit){var n=o.__read(t,2),s=n[0],l=n[1],_=o.__read(this.coordinates.map_to_screen(s,l),2),h=_[0],c=_[1],d=o.__read(this.normals,2),u=d[0],b=d[1],m=o.__read(this.offsets,2),p=m[0],f=m[1],x=o.__read([u*(p-i),b*(f-i)],2),v=x[0],g=x[1],k=o.__read([u*(p+r),b*(f+r)],2),y=k[0],j=k[1];a.set_value(e),e.beginPath();for(var w=0;w<h.length;w++){var M=Math.round(h[w]+y),O=Math.round(c[w]+j),P=Math.round(h[w]+v),T=Math.round(c[w]+g);e.moveTo(M,O),e.lineTo(P,T)}e.stroke()}},t.prototype._draw_oriented_labels=function(e,t,i,r,a,n,s,l){var _,h,c,u;if(void 0===l&&(l="data"),s.doit&&0!=t.length){var b,m,p,f;if("screen"==l)b=(_=o.__read(i,2))[0],m=_[1],p=(h=o.__read([0,0],2))[0],f=h[1];else{var x=o.__read(i,2),v=x[0],g=x[1];b=(c=o.__read(this.coordinates.map_to_screen(v,g),2))[0],m=c[1],p=(u=o.__read(this.offsets,2))[0],f=u[1]}var k,y=o.__read(this.normals,2),j=y[0]*(p+n),w=y[1]*(f+n);s.set_value(e),this.panel.apply_label_text_heuristics(e,r),k=d.isString(r)?this.panel.get_label_angle_heuristic(r):-r;for(var M=0;M<b.length;M++){var O=Math.round(b[M]+j),P=Math.round(m[M]+w);e.translate(O,P),e.rotate(k),e.fillText(t[M],0,0),e.rotate(-k),e.translate(-O,-P)}}},t.prototype._axis_label_extent=function(){if(null==this.model.axis_label||""==this.model.axis_label)return 0;var e=this.model.axis_label_standoff,t=this.visuals.axis_label_text;return this._oriented_labels_extent([this.model.axis_label],"parallel",this.panel.side,e,t)},t.prototype._tick_extent=function(){return this.model.major_tick_out},t.prototype._tick_label_extent=function(){return c.sum(this._tick_label_extents())},t.prototype._tick_label_extents=function(){var e=this.tick_coords.major,t=this.compute_labels(e[this.dimension]),i=this.model.major_label_orientation,r=this.model.major_label_standoff,a=this.visuals.major_label_text;return[this._oriented_labels_extent(t,i,this.panel.side,r,a)]},t.prototype._oriented_labels_extent=function(e,t,i,r,a){if(0==e.length)return 0;var o,n,s=this.layer.ctx;a.set_value(s),d.isString(t)?(o=1,n=this.panel.get_label_angle_heuristic(t)):(o=2,n=-t),n=Math.abs(n);for(var l=Math.cos(n),_=Math.sin(n),h=0,c=0;c<e.length;c++){var u=1.1*s.measureText(e[c]).width,b=.9*s.measureText(e[c]).ascent,m=void 0;(m="above"==i||"below"==i?u*_+b/o*l:u*l+b/o*_)>h&&(h=m)}return h>0&&(h+=r),h},Object.defineProperty(t.prototype,"normals",{get:function(){return this.panel.normals},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"dimension",{get:function(){return this.panel.dimension},enumerable:!1,configurable:!0}),t.prototype.compute_labels=function(e){for(var t=this.model.formatter.doFormat(e,this),i=0;i<e.length;i++)e[i]in this.model.major_label_overrides&&(t[i]=this.model.major_label_overrides[e[i]]);return t},Object.defineProperty(t.prototype,"offsets",{get:function(){if(null!=this.model.fixed_location)return[0,0];var e=this.plot_view.frame,t=o.__read([0,0],2),i=t[0],r=t[1];switch(this.panel.side){case"below":r=b(this.panel.bbox.top-e.bbox.bottom);break;case"above":r=b(this.panel.bbox.bottom-e.bbox.top);break;case"right":i=b(this.panel.bbox.left-e.bbox.right);break;case"left":i=b(this.panel.bbox.right-e.bbox.left)}return[i,r]},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"ranges",{get:function(){var e=this.dimension,t=(e+1)%2,i=this.coordinates.ranges;return[i[e],i[t]]},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"computed_bounds",{get:function(){var e=o.__read(this.ranges,1)[0],t=this.model.bounds,i=[e.min,e.max];if("auto"==t)return[e.min,e.max];var r=void 0,a=void 0,n=o.__read(t,2),s=n[0],l=n[1],_=o.__read(i,2),h=_[0],c=_[1];return b(s-l)>b(h-c)?(r=p(m(s,l),h),a=m(p(s,l),c)):(r=m(s,l),a=p(s,l)),[r,a]},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"rule_coords",{get:function(){var e=this.dimension,t=(e+1)%2,i=o.__read(this.ranges,1)[0],r=o.__read(this.computed_bounds,2),a=r[0],n=r[1],s=[new Array(2),new Array(2)];return s[e][0]=Math.max(a,i.min),s[e][1]=Math.min(n,i.max),s[e][0]>s[e][1]&&(s[e][0]=s[e][1]=NaN),s[t][0]=this.loc,s[t][1]=this.loc,s},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"tick_coords",{get:function(){for(var e=this.dimension,t=(e+1)%2,i=o.__read(this.ranges,1)[0],r=o.__read(this.computed_bounds,2),a=r[0],n=r[1],s=this.model.ticker.get_ticks(a,n,i,this.loc),l=s.major,_=s.minor,h=[[],[]],c=[[],[]],d=o.__read([i.min,i.max],2),u=d[0],b=d[1],m=0;m<l.length;m++)l[m]<u||l[m]>b||(h[e].push(l[m]),h[t].push(this.loc));for(m=0;m<_.length;m++)_[m]<u||_[m]>b||(c[e].push(_[m]),c[t].push(this.loc));return{major:h,minor:c}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"loc",{get:function(){var e=this.model.fixed_location;if(null!=e){if(d.isNumber(e))return e;var t=o.__read(this.ranges,2)[1];if(t instanceof u.FactorRange)return t.synthetic(e);throw new Error("unexpected")}var i=o.__read(this.ranges,2)[1];switch(this.panel.side){case"left":case"below":return i.start;case"right":case"above":return i.end}},enumerable:!1,configurable:!0}),t.prototype.serializable_state=function(){return Object.assign(Object.assign({},e.prototype.serializable_state.call(this)),{bbox:this.layout.bbox.box})},t}(n.GuideRendererView);i.AxisView=f,f.__name__="AxisView";var x=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_Axis=function(){this.prototype.default_view=f,this.mixins([["axis_",_.Line],["major_tick_",_.Line],["minor_tick_",_.Line],["major_label_",_.Text],["axis_label_",_.Text]]),this.define((function(e){var t=e.Any,i=e.Int,r=e.Number,a=e.String,o=e.Ref,n=e.Dict,_=e.Tuple,c=e.Or,d=e.Nullable,u=e.Auto;return{bounds:[c(_(r,r),u),"auto"],ticker:[o(s.Ticker)],formatter:[o(l.TickFormatter)],axis_label:[d(a),""],axis_label_standoff:[i,5],major_label_standoff:[i,5],major_label_orientation:[c(h.TickLabelOrientation,r),"horizontal"],major_label_overrides:[n(a),{}],major_tick_in:[r,2],major_tick_out:[r,6],minor_tick_in:[r,0],minor_tick_out:[r,4],fixed_location:[d(c(r,t)),null]}})),this.override({axis_line_color:"black",major_tick_line_color:"black",minor_tick_line_color:"black",major_label_text_font_size:"11px",major_label_text_align:"center",major_label_text_baseline:"alphabetic",axis_label_text_font_size:"13px",axis_label_text_font_style:"italic"})},t}(n.GuideRenderer);i.Axis=x,x.__name__="Axis",x.init_Axis()},
function _(e,n,r,i,t){i();var d=e(1),u=e(185),_=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return d.__extends(n,e),n}(u.RendererView);r.GuideRendererView=_,_.__name__="GuideRendererView";var R=function(e){function n(n){return e.call(this,n)||this}return d.__extends(n,e),n.init_GuideRenderer=function(){this.override({level:"guide"})},n}(u.Renderer);r.GuideRenderer=R,R.__name__="GuideRenderer",R.init_GuideRenderer()},
function _(t,e,r,o,i){o();var a=t(1),s=t(316),n=t(319),_=t(320),l=a.__importStar(t(143)),u=t(135),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),e.prototype._paint=function(t,e,r){this._draw_group_separators(t,e,r)},e.prototype._draw_group_separators=function(t,e,r){var o,i=a.__read(this.ranges,1)[0],s=a.__read(this.computed_bounds,2),n=s[0],_=s[1];if(i.tops&&!(i.tops.length<2)&&this.visuals.separator_line.doit){for(var l=this.dimension,u=(l+1)%2,p=[[],[]],c=0,h=0;h<i.tops.length-1;h++){for(var d=void 0,m=void 0,f=c;f<i.factors.length;f++)if(i.factors[f][0]==i.tops[h+1]){d=(o=a.__read([i.factors[f-1],i.factors[f]],2))[0],m=o[1],c=f;break}var g=(i.synthetic(d)+i.synthetic(m))/2;g>n&&g<_&&(p[l].push(g),p[u].push(this.loc))}var b=this._tick_label_extent();this._draw_ticks(t,p,-3,b-6,this.visuals.separator_line)}},e.prototype._draw_major_labels=function(t,e,r){for(var o=this._get_factor_info(),i=e.tick+this.model.major_label_standoff,s=0;s<o.length;s++){var n=a.__read(o[s],4),_=n[0],l=n[1],u=n[2],p=n[3];this._draw_oriented_labels(t,_,l,u,this.panel.side,i,p),i+=e.tick_label[s]}},e.prototype._tick_label_extents=function(){var t,e,r=this._get_factor_info(),o=[];try{for(var i=a.__values(r),s=i.next();!s.done;s=i.next()){var n=a.__read(s.value,4),_=n[0],l=n[2],u=n[3],p=this._oriented_labels_extent(_,l,this.panel.side,this.model.major_label_standoff,u);o.push(p)}}catch(e){t={error:e}}finally{try{s&&!s.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}return o},e.prototype._get_factor_info=function(){var t=a.__read(this.ranges,1)[0],e=a.__read(this.computed_bounds,2),r=e[0],o=e[1],i=this.loc,s=this.model.ticker.get_ticks(r,o,t,i),n=this.tick_coords,_=[];if(1==t.levels){var l=s.major,u=this.model.formatter.doFormat(l,this);_.push([u,n.major,this.model.major_label_orientation,this.visuals.major_label_text])}else if(2==t.levels){l=s.major.map((function(t){return t[1]})),u=this.model.formatter.doFormat(l,this);_.push([u,n.major,this.model.major_label_orientation,this.visuals.major_label_text]),_.push([s.tops,n.tops,this.model.group_label_orientation,this.visuals.group_text])}else if(3==t.levels){l=s.major.map((function(t){return t[2]})),u=this.model.formatter.doFormat(l,this);var p=s.mids.map((function(t){return t[1]}));_.push([u,n.major,this.model.major_label_orientation,this.visuals.major_label_text]),_.push([p,n.mids,this.model.subgroup_label_orientation,this.visuals.subgroup_text]),_.push([s.tops,n.tops,this.model.group_label_orientation,this.visuals.group_text])}return _},Object.defineProperty(e.prototype,"tick_coords",{get:function(){var t=this,e=this.dimension,r=(e+1)%2,o=a.__read(this.ranges,1)[0],i=a.__read(this.computed_bounds,2),s=i[0],n=i[1],_=this.model.ticker.get_ticks(s,n,o,this.loc),l={major:[[],[]],mids:[[],[]],tops:[[],[]],minor:[[],[]]};return l.major[e]=_.major,l.major[r]=_.major.map((function(){return t.loc})),3==o.levels&&(l.mids[e]=_.mids,l.mids[r]=_.mids.map((function(){return t.loc}))),o.levels>1&&(l.tops[e]=_.tops,l.tops[r]=_.tops.map((function(){return t.loc}))),l},enumerable:!1,configurable:!0}),e}(s.AxisView);r.CategoricalAxisView=p,p.__name__="CategoricalAxisView";var c=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_CategoricalAxis=function(){this.prototype.default_view=p,this.mixins([["separator_",l.Line],["group_",l.Text],["subgroup_",l.Text]]),this.define((function(t){var e=t.Number,r=t.Or;return{group_label_orientation:[r(u.TickLabelOrientation,e),"parallel"],subgroup_label_orientation:[r(u.TickLabelOrientation,e),"parallel"]}})),this.override({ticker:function(){return new n.CategoricalTicker},formatter:function(){return new _.CategoricalTickFormatter},separator_line_color:"lightgrey",separator_line_width:2,group_text_font_style:"bold",group_text_font_size:"11px",group_text_color:"grey",subgroup_text_font_style:"bold",subgroup_text_font_size:"11px"})},e}(s.Axis);r.CategoricalAxis=c,c.__name__="CategoricalAxis",c.init_CategoricalAxis()},
function _(t,r,e,o,n){o();var c=t(1),i=function(t){function r(r){return t.call(this,r)||this}return c.__extends(r,t),r.prototype.get_ticks=function(t,r,e,o){var n,c;return{major:this._collect(e.factors,e,t,r),minor:[],tops:this._collect(null!==(n=e.tops)&&void 0!==n?n:[],e,t,r),mids:this._collect(null!==(c=e.mids)&&void 0!==c?c:[],e,t,r)}},r.prototype._collect=function(t,r,e,o){var n,i,l=[];try{for(var a=c.__values(t),s=a.next();!s.done;s=a.next()){var u=s.value,_=r.synthetic(u);_>e&&_<o&&l.push(u)}}catch(t){n={error:t}}finally{try{s&&!s.done&&(i=a.return)&&i.call(a)}finally{if(n)throw n.error}}return l},r}(t(246).Ticker);e.CategoricalTicker=i,i.__name__="CategoricalTicker"},
function _(t,r,o,n,e){n();var a=t(1),c=t(247),i=t(124),u=function(t){function r(r){return t.call(this,r)||this}return a.__extends(r,t),r.prototype.doFormat=function(t,r){return i.copy(t)},r}(c.TickFormatter);o.CategoricalTickFormatter=u,u.__name__="CategoricalTickFormatter"},
function _(n,i,t,u,s){u();var e=n(1),o=n(316),_=function(n){function i(){return null!==n&&n.apply(this,arguments)||this}return e.__extends(i,n),i}(o.AxisView);t.ContinuousAxisView=_,_.__name__="ContinuousAxisView";var r=function(n){function i(i){return n.call(this,i)||this}return e.__extends(i,n),i}(o.Axis);t.ContinuousAxis=r,r.__name__="ContinuousAxis"},
function _(t,e,i,n,r){n();var a=t(1),s=t(323),u=t(324),_=t(329),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),e}(s.LinearAxisView);i.DatetimeAxisView=o,o.__name__="DatetimeAxisView";var c=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_DatetimeAxis=function(){this.prototype.default_view=o,this.override({ticker:function(){return new _.DatetimeTicker},formatter:function(){return new u.DatetimeTickFormatter}})},e}(s.LinearAxis);i.DatetimeAxis=c,c.__name__="DatetimeAxis",c.init_DatetimeAxis()},
function _(i,n,t,e,r){e();var s=i(1),u=i(321),a=i(250),o=i(248),_=function(i){function n(){return null!==i&&i.apply(this,arguments)||this}return s.__extends(n,i),n}(u.ContinuousAxisView);t.LinearAxisView=_,_.__name__="LinearAxisView";var c=function(i){function n(n){return i.call(this,n)||this}return s.__extends(n,i),n.init_LinearAxis=function(){this.prototype.default_view=_,this.override({ticker:function(){return new o.BasicTicker},formatter:function(){return new a.BasicTickFormatter}})},n}(u.ContinuousAxis);t.LinearAxis=c,c.__name__="LinearAxis",c.init_LinearAxis()},
function _(t,r,e,n,i){n();var s=t(1),o=s.__importDefault(t(325)),a=t(247),u=t(134),c=t(326),m=t(124),h=t(123);function d(t){return o.default(t,"%Y %m %d %H %M %S").split(/\s+/).map((function(t){return parseInt(t,10)}))}function l(t,r){if(h.isFunction(r))return r(t);var e=c.sprintf("$1%06d",function(t){return Math.round(t/1e3%1*1e6)}(t));return-1==(r=r.replace(/((^|[^%])(%%)*)%f/,e)).indexOf("%")?r:o.default(t,r)}var f=["microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"],_=function(t){function r(r){var e=t.call(this,r)||this;return e.strip_leading_zeros=!0,e}return s.__extends(r,t),r.init_DatetimeTickFormatter=function(){this.define((function(t){var r=t.String,e=t.Array;return{microseconds:[e(r),["%fus"]],milliseconds:[e(r),["%3Nms","%S.%3Ns"]],seconds:[e(r),["%Ss"]],minsec:[e(r),[":%M:%S"]],minutes:[e(r),[":%M","%Mm"]],hourmin:[e(r),["%H:%M"]],hours:[e(r),["%Hh","%H:%M"]],days:[e(r),["%m/%d","%a%d"]],months:[e(r),["%m/%Y","%b %Y"]],years:[e(r),["%Y"]]}}))},r.prototype.initialize=function(){t.prototype.initialize.call(this),this._update_width_formats()},r.prototype._update_width_formats=function(){var t=+o.default(new Date),r=function(r){var e=r.map((function(r){return l(t,r).length})),n=m.sort_by(m.zip(e,r),(function(t){return s.__read(t,1)[0]}));return m.unzip(n)};this._width_formats={microseconds:r(this.microseconds),milliseconds:r(this.milliseconds),seconds:r(this.seconds),minsec:r(this.minsec),minutes:r(this.minutes),hourmin:r(this.hourmin),hours:r(this.hours),days:r(this.days),months:r(this.months),years:r(this.years)}},r.prototype._get_resolution_str=function(t,r){var e=1.1*t;switch(!1){case!(e<.001):return"microseconds";case!(e<1):return"milliseconds";case!(e<60):return r>=60?"minsec":"seconds";case!(e<3600):return r>=3600?"hourmin":"minutes";case!(e<86400):return"hours";case!(e<2678400):return"days";case!(e<31536e3):return"months";default:return"years"}},r.prototype.doFormat=function(t,r){var e,n,i,o;if(0==t.length)return[];var a=Math.abs(t[t.length-1]-t[0])/1e3,c=a/(t.length-1),m=this._get_resolution_str(c,a),h=s.__read(this._width_formats[m],2),_=s.__read(h[1],1)[0],p=[],y=f.indexOf(m),v={};try{for(var g=s.__values(f),w=g.next();!w.done;w=g.next()){v[w.value]=0}}catch(t){e={error:t}}finally{try{w&&!w.done&&(n=g.return)&&n.call(g)}finally{if(e)throw e.error}}v.seconds=5,v.minsec=4,v.minutes=4,v.hourmin=3,v.hours=3;try{for(var k=s.__values(t),M=k.next();!M.done;M=k.next()){var x=M.value,F=void 0,b=void 0;try{b=d(x),F=l(x,_)}catch(t){u.logger.warn("unable to format tick for timestamp value "+x),u.logger.warn(" - "+t),p.push("ERR");continue}for(var z=!1,D=y;0==b[v[f[D]]];){if((D+=1)==f.length)break;if(("minsec"==m||"hourmin"==m)&&!z){if("minsec"==m&&0==b[4]&&0!=b[5]||"hourmin"==m&&0==b[3]&&0!=b[4]){F=l(x,this._width_formats[f[y-1]][1][0]);break}z=!0}F=l(x,this._width_formats[f[D]][1][0])}if(this.strip_leading_zeros){var S=F.replace(/^0+/g,"");S!=F&&isNaN(parseInt(S))&&(S="0"+S),p.push(S)}else p.push(F)}}catch(t){i={error:t}}finally{try{M&&!M.done&&(o=k.return)&&o.call(k)}finally{if(i)throw i.error}}return p},r}(a.TickFormatter);e.DatetimeTickFormatter=_,_.__name__="DatetimeTickFormatter",_.init_DatetimeTickFormatter()},
function _(e,t,n,r,o){!function(e){"object"==typeof t&&t.exports?t.exports=e():"function"==typeof define?define(e):this.tz=e()}((function(){function e(e,t,n){var r,o=t.day[1];do{r=new Date(Date.UTC(n,t.month,Math.abs(o++)))}while(t.day[0]<7&&r.getUTCDay()!=t.day[0]);return(r={clock:t.clock,sort:r.getTime(),rule:t,save:6e4*t.save,offset:e.offset})[r.clock]=r.sort+6e4*t.time,r.posix?r.wallclock=r[r.clock]+(e.offset+t.saved):r.posix=r[r.clock]-(e.offset+t.saved),r}function t(t,n,r){var o,a,u,i,l,s,c,f=t[t.zone],h=[],T=new Date(r).getUTCFullYear(),g=1;for(o=1,a=f.length;o<a&&!(f[o][n]<=r);o++);if((u=f[o]).rules){for(s=t[u.rules],c=T+1;c>=T-g;--c)for(o=0,a=s.length;o<a;o++)s[o].from<=c&&c<=s[o].to?h.push(e(u,s[o],c)):s[o].to<c&&1==g&&(g=c-s[o].to);for(h.sort((function(e,t){return e.sort-t.sort})),o=0,a=h.length;o<a;o++)r>=h[o][n]&&h[o][h[o].clock]>u[h[o].clock]&&(i=h[o])}return i&&((l=/^(.*)\/(.*)$/.exec(u.format))?i.abbrev=l[i.save?2:1]:i.abbrev=u.format.replace(/%s/,i.rule.letter)),i||u}function n(e,n){return"UTC"==e.zone?n:(e.entry=t(e,"posix",n),n+e.entry.offset+e.entry.save)}function r(e,n){return"UTC"==e.zone?n:(e.entry=r=t(e,"wallclock",n),0<(o=n-r.wallclock)&&o<r.save?null:n-r.offset-r.save);var r,o}function o(e,t,o){var a,i=+(o[1]+1),s=o[2]*i,c=u.indexOf(o[3].toLowerCase());if(c>9)t+=s*l[c-10];else{if(a=new Date(n(e,t)),c<7)for(;s;)a.setUTCDate(a.getUTCDate()+i),a.getUTCDay()==c&&(s-=i);else 7==c?a.setUTCFullYear(a.getUTCFullYear()+s):8==c?a.setUTCMonth(a.getUTCMonth()+s):a.setUTCDate(a.getUTCDate()+s);null==(t=r(e,a.getTime()))&&(t=r(e,a.getTime()+864e5*i)-864e5*i)}return t}var a={clock:function(){return+new Date},zone:"UTC",entry:{abbrev:"UTC",offset:0,save:0},UTC:1,z:function(e,t,n,r){var o,a,u=this.entry.offset+this.entry.save,i=Math.abs(u/1e3),l=[],s=3600;for(o=0;o<3;o++)l.push(("0"+Math.floor(i/s)).slice(-2)),i%=s,s/=60;return"^"!=n||u?("^"==n&&(r=3),3==r?(a=(a=l.join(":")).replace(/:00$/,""),"^"!=n&&(a=a.replace(/:00$/,""))):r?(a=l.slice(0,r+1).join(":"),"^"==n&&(a=a.replace(/:00$/,""))):a=l.slice(0,2).join(""),a=(a=(u<0?"-":"+")+a).replace(/([-+])(0)/,{_:" $1","-":"$1"}[n]||"$1$2")):"Z"},"%":function(e){return"%"},n:function(e){return"\n"},t:function(e){return"\t"},U:function(e){return s(e,0)},W:function(e){return s(e,1)},V:function(e){return c(e)[0]},G:function(e){return c(e)[1]},g:function(e){return c(e)[1]%100},j:function(e){return Math.floor((e.getTime()-Date.UTC(e.getUTCFullYear(),0))/864e5)+1},s:function(e){return Math.floor(e.getTime()/1e3)},C:function(e){return Math.floor(e.getUTCFullYear()/100)},N:function(e){return e.getTime()%1e3*1e6},m:function(e){return e.getUTCMonth()+1},Y:function(e){return e.getUTCFullYear()},y:function(e){return e.getUTCFullYear()%100},H:function(e){return e.getUTCHours()},M:function(e){return e.getUTCMinutes()},S:function(e){return e.getUTCSeconds()},e:function(e){return e.getUTCDate()},d:function(e){return e.getUTCDate()},u:function(e){return e.getUTCDay()||7},w:function(e){return e.getUTCDay()},l:function(e){return e.getUTCHours()%12||12},I:function(e){return e.getUTCHours()%12||12},k:function(e){return e.getUTCHours()},Z:function(e){return this.entry.abbrev},a:function(e){return this[this.locale].day.abbrev[e.getUTCDay()]},A:function(e){return this[this.locale].day.full[e.getUTCDay()]},h:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},b:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},B:function(e){return this[this.locale].month.full[e.getUTCMonth()]},P:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)].toLowerCase()},p:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)]},R:function(e,t){return this.convert([t,"%H:%M"])},T:function(e,t){return this.convert([t,"%H:%M:%S"])},D:function(e,t){return this.convert([t,"%m/%d/%y"])},F:function(e,t){return this.convert([t,"%Y-%m-%d"])},x:function(e,t){return this.convert([t,this[this.locale].date])},r:function(e,t){return this.convert([t,this[this.locale].time12||"%I:%M:%S"])},X:function(e,t){return this.convert([t,this[this.locale].time24])},c:function(e,t){return this.convert([t,this[this.locale].dateTime])},convert:function(e){if(!e.length)return"1.0.23";var t,a,u,l,s,c=Object.create(this),f=[];for(t=0;t<e.length;t++)if(l=e[t],Array.isArray(l))t||isNaN(l[1])?l.splice.apply(e,[t--,1].concat(l)):s=l;else if(isNaN(l)){if("string"==(u=typeof l))~l.indexOf("%")?c.format=l:t||"*"!=l?!t&&(u=/^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(l))?((s=[]).push.apply(s,u.slice(1,8)),u[9]?(s.push(u[10]+1),s.push.apply(s,u[11].split(/:/))):u[8]&&s.push(1)):/^\w{2,3}_\w{2}$/.test(l)?c.locale=l:(u=i.exec(l))?f.push(u):c.zone=l:s=l;else if("function"==u){if(u=l.call(c))return u}else if(/^\w{2,3}_\w{2}$/.test(l.name))c[l.name]=l;else if(l.zones){for(u in l.zones)c[u]=l.zones[u];for(u in l.rules)c[u]=l.rules[u]}}else t||(s=l);if(c[c.locale]||delete c.locale,c[c.zone]||delete c.zone,null!=s){if("*"==s)s=c.clock();else if(Array.isArray(s)){for(u=[],a=!s[7],t=0;t<11;t++)u[t]=+(s[t]||0);--u[1],s=Date.UTC.apply(Date.UTC,u)+-u[7]*(36e5*u[8]+6e4*u[9]+1e3*u[10])}else s=Math.floor(s);if(!isNaN(s)){if(a&&(s=r(c,s)),null==s)return s;for(t=0,a=f.length;t<a;t++)s=o(c,s,f[t]);return c.format?(u=new Date(n(c,s)),c.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,(function(e,t,n,r,o){var a,i,l="0";if(a=c[o]){for(e=String(a.call(c,u,s,t,n.length)),"_"==(t||a.style)&&(l=" "),i="-"==t?0:a.pad||0;e.length<i;)e=l+e;for(i="-"==t?0:r||a.pad;e.length<i;)e=l+e;"N"==o&&i<e.length&&(e=e.slice(0,i)),"^"==t&&(e=e.toUpperCase())}return e}))):s}}return function(){return c.convert(arguments)}},locale:"en_US",en_US:{date:"%m/%d/%Y",time24:"%I:%M:%S %p",time12:"%I:%M:%S %p",dateTime:"%a %d %b %Y %I:%M:%S %p %Z",meridiem:["AM","PM"],month:{abbrev:"Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),full:"January|February|March|April|May|June|July|August|September|October|November|December".split("|")},day:{abbrev:"Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),full:"Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")}}},u="Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond",i=new RegExp("^\\s*([+-])(\\d+)\\s+("+u+")s?\\s*$","i"),l=[36e5,6e4,1e3,1];function s(e,t){var n,r,o;return r=new Date(Date.UTC(e.getUTCFullYear(),0)),n=Math.floor((e.getTime()-r.getTime())/864e5),r.getUTCDay()==t?o=0:8==(o=7-r.getUTCDay()+t)&&(o=1),n>=o?Math.floor((n-o)/7)+1:0}function c(e){var t,n,r;return n=e.getUTCFullYear(),t=new Date(Date.UTC(n,0)).getUTCDay(),(r=s(e,1)+(t>1&&t<=4?1:0))?53!=r||4==t||3==t&&29==new Date(n,1,29).getDate()?[r,e.getUTCFullYear()]:[1,e.getUTCFullYear()+1]:(n=e.getUTCFullYear()-1,[r=4==(t=new Date(Date.UTC(n,0)).getUTCDay())||3==t&&29==new Date(n,1,29).getDate()?53:52,e.getUTCFullYear()-1])}return u=u.toLowerCase().split("|"),"delmHMSUWVgCIky".replace(/./g,(function(e){a[e].pad=2})),a.N.pad=9,a.j.pad=3,a.k.style="_",a.l.style="_",a.e.style="_",function(){return a.convert(arguments)}}))},
function _(r,n,t,e,i){e();var u=r(1),a=u.__importStar(r(327)),f=r(328),o=u.__importDefault(r(325)),l=r(136),c=r(144),s=r(123);function m(r){for(var n=[],t=1;t<arguments.length;t++)n[t-1]=arguments[t];return f.sprintf.apply(void 0,u.__spread([r],n))}function p(r,n,t){return s.isNumber(r)?m(function(){switch(!1){case Math.floor(r)!=r:return"%d";case!(Math.abs(r)>.1&&Math.abs(r)<1e3):return"%0.3f";default:return"%0.3e"}}(),r):""+r}function d(r,n,e){if(null==n)return p;if(null!=e&&r in e){var i=e[r];if(s.isString(i)){if(i in t.DEFAULT_FORMATTERS)return t.DEFAULT_FORMATTERS[i];throw new Error("Unknown tooltip field formatter type '"+i+"'")}return function(r,n,t){return i.format(r,n,t)}}return t.DEFAULT_FORMATTERS.numeral}function _(r,n,t,e){return"$"==r[0]?function(r,n){if(r in n)return n[r];throw new Error("Unknown special variable '$"+r+"'")}(r.substring(1),e):function(r,n,t){var e=n.get_column(r);if(null==e)return null;if(s.isNumber(t))return e[t];var i=e[t.index];return s.isTypedArray(i)||s.isArray(i)?s.isArray(i[0])?i[t.dim2][t.dim1]:i[t.flat_index]:i}(r.substring(1).replace(/[{}]/g,""),n,t)}t.FormatterType=l.Enum("numeral","printf","datetime"),t.DEFAULT_FORMATTERS={numeral:function(r,n,t){return a.format(r,n)},datetime:function(r,n,t){return o.default(r,n)},printf:function(r,n,t){return m(n,r)}},t.sprintf=m,t.basic_formatter=p,t.get_formatter=d,t.get_value=_,t.replace_placeholders=function(r,n,t,e,i){var a,f;if(void 0===i&&(i={}),s.isString(r)?(a=r,f=!1):(a=r.html,f=!0),a=(a=a.replace(/@\$name/g,(function(r){return"@{"+i.name+"}"}))).replace(/((?:\$\w+)|(?:@\w+)|(?:@{(?:[^{}]+)}))(?:{([^{}]+)})?/g,(function(r,u,a){var o=_(u,n,t,i);if(null==o)return""+c.escape("???");if("safe"==a)return f=!0,""+o;var l=d(u,a,e);return""+c.escape(l(o,a,i))})),f){var o=(new DOMParser).parseFromString(a,"text/html");return u.__spread(o.body.childNodes)}return a}},
function _(e,n,t,r,i){
/*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
var a,o={},l=o,u="en-US",c=null,s="0,0";void 0!==n&&n.exports;function f(e){this._value=e}function d(e){var n,t="";for(n=0;n<e;n++)t+="0";return t}function h(e,n,t,r){var i,a,o=Math.pow(10,n);return a=e.toFixed(0).search("e")>-1?function(e,n){var t,r,i,a;return t=(a=e.toString()).split("e")[0],i=a.split("e")[1],a=t.split(".")[0]+(r=t.split(".")[1]||"")+d(i-r.length),n>0&&(a+="."+d(n)),a}(e,n):(t(e*o)/o).toFixed(n),r&&(i=new RegExp("0{1,"+r+"}$"),a=a.replace(i,"")),a}function p(e,n,t){return n.indexOf("$")>-1?function(e,n,t){var r,i,a=n,l=a.indexOf("$"),c=a.indexOf("("),s=a.indexOf("+"),f=a.indexOf("-"),d="",h="";-1===a.indexOf("$")?"infix"===o[u].currency.position?(h=o[u].currency.symbol,o[u].currency.spaceSeparated&&(h=" "+h+" ")):o[u].currency.spaceSeparated&&(d=" "):a.indexOf(" $")>-1?(d=" ",a=a.replace(" $","")):a.indexOf("$ ")>-1?(d=" ",a=a.replace("$ ","")):a=a.replace("$","");if(i=m(e,a,t,h),-1===n.indexOf("$"))switch(o[u].currency.position){case"postfix":i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[u].currency.symbol),i=i.join("")):i=i+d+o[u].currency.symbol;break;case"infix":break;case"prefix":i.indexOf("(")>-1||i.indexOf("-")>-1?(i=i.split(""),r=Math.max(c,f)+1,i.splice(r,0,o[u].currency.symbol+d),i=i.join("")):i=o[u].currency.symbol+d+i;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else l<=1?i.indexOf("(")>-1||i.indexOf("+")>-1||i.indexOf("-")>-1?(r=1,(l<c||l<s||l<f)&&(r=0),(i=i.split("")).splice(r,0,o[u].currency.symbol+d),i=i.join("")):i=o[u].currency.symbol+d+i:i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[u].currency.symbol),i=i.join("")):i=i+d+o[u].currency.symbol;return i}(e,n,t):n.indexOf("%")>-1?function(e,n,t){var r,i="";e*=100,n.indexOf(" %")>-1?(i=" ",n=n.replace(" %","")):n=n.replace("%","");(r=m(e,n,t)).indexOf(")")>-1?((r=r.split("")).splice(-1,0,i+"%"),r=r.join("")):r=r+i+"%";return r}(e,n,t):n.indexOf(":")>-1?function(e){var n=Math.floor(e/60/60),t=Math.floor((e-60*n*60)/60),r=Math.round(e-60*n*60-60*t);return n+":"+(t<10?"0"+t:t)+":"+(r<10?"0"+r:r)}(e):m(e,n,t)}function m(e,n,t,r){var i,a,l,s,f,d,p,m,x,g,O,b,w,y,M,v,$,B=!1,E=!1,F=!1,k="",U=!1,N=!1,S=!1,j=!1,D=!1,C="",L="",T=Math.abs(e),K=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],G=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],I="",P=!1,R=!1;if(0===e&&null!==c)return c;if(!isFinite(e))return""+e;if(0===n.indexOf("{")){var W=n.indexOf("}");if(-1===W)throw Error('Format should also contain a "}"');b=n.slice(1,W),n=n.slice(W+1)}else b="";if(n.indexOf("}")===n.length-1){var Y=n.indexOf("{");if(-1===Y)throw Error('Format should also contain a "{"');w=n.slice(Y+1,-1),n=n.slice(0,Y+1)}else w="";if(v=null===($=-1===n.indexOf(".")?n.match(/([0-9]+).*/):n.match(/([0-9]+)\..*/))?-1:$[1].length,-1!==n.indexOf("-")&&(P=!0),n.indexOf("(")>-1?(B=!0,n=n.slice(1,-1)):n.indexOf("+")>-1&&(E=!0,n=n.replace(/\+/g,"")),n.indexOf("a")>-1){if(g=n.split(".")[0].match(/[0-9]+/g)||["0"],g=parseInt(g[0],10),U=n.indexOf("aK")>=0,N=n.indexOf("aM")>=0,S=n.indexOf("aB")>=0,j=n.indexOf("aT")>=0,D=U||N||S||j,n.indexOf(" a")>-1?(k=" ",n=n.replace(" a","")):n=n.replace("a",""),p=0===(p=(f=Math.floor(Math.log(T)/Math.LN10)+1)%3)?3:p,g&&0!==T&&(d=Math.floor(Math.log(T)/Math.LN10)+1-g,m=3*~~((Math.min(g,f)-p)/3),T/=Math.pow(10,m),-1===n.indexOf(".")&&g>3))for(n+="[.]",M=(M=0===d?0:3*~~(d/3)-d)<0?M+3:M,i=0;i<M;i++)n+="0";Math.floor(Math.log(Math.abs(e))/Math.LN10)+1!==g&&(T>=Math.pow(10,12)&&!D||j?(k+=o[u].abbreviations.trillion,e/=Math.pow(10,12)):T<Math.pow(10,12)&&T>=Math.pow(10,9)&&!D||S?(k+=o[u].abbreviations.billion,e/=Math.pow(10,9)):T<Math.pow(10,9)&&T>=Math.pow(10,6)&&!D||N?(k+=o[u].abbreviations.million,e/=Math.pow(10,6)):(T<Math.pow(10,6)&&T>=Math.pow(10,3)&&!D||U)&&(k+=o[u].abbreviations.thousand,e/=Math.pow(10,3)))}if(n.indexOf("b")>-1)for(n.indexOf(" b")>-1?(C=" ",n=n.replace(" b","")):n=n.replace("b",""),s=0;s<=K.length;s++)if(a=Math.pow(1024,s),l=Math.pow(1024,s+1),e>=a&&e<l){C+=K[s],a>0&&(e/=a);break}if(n.indexOf("d")>-1)for(n.indexOf(" d")>-1?(C=" ",n=n.replace(" d","")):n=n.replace("d",""),s=0;s<=G.length;s++)if(a=Math.pow(1e3,s),l=Math.pow(1e3,s+1),e>=a&&e<l){C+=G[s],a>0&&(e/=a);break}if(n.indexOf("o")>-1&&(n.indexOf(" o")>-1?(L=" ",n=n.replace(" o","")):n=n.replace("o",""),o[u].ordinal&&(L+=o[u].ordinal(e))),n.indexOf("[.]")>-1&&(F=!0,n=n.replace("[.]",".")),x=e.toString().split(".")[0],O=n.split(".")[1],y=n.indexOf(","),O){if(x=(I=-1!==O.indexOf("*")?h(e,e.toString().split(".")[1].length,t):O.indexOf("[")>-1?h(e,(O=(O=O.replace("]","")).split("["))[0].length+O[1].length,t,O[1].length):h(e,O.length,t)).split(".")[0],I.split(".")[1].length)I=(r?k+r:o[u].delimiters.decimal)+I.split(".")[1];else I="";F&&0===Number(I.slice(1))&&(I="")}else x=h(e,null,t);return x.indexOf("-")>-1&&(x=x.slice(1),R=!0),x.length<v&&(x=new Array(v-x.length+1).join("0")+x),y>-1&&(x=x.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+o[u].delimiters.thousands)),0===n.indexOf(".")&&(x=""),b+(n.indexOf("(")<n.indexOf("-")?(B&&R?"(":"")+(P&&R||!B&&R?"-":""):(P&&R||!B&&R?"-":"")+(B&&R?"(":""))+(!R&&E&&0!==e?"+":"")+x+I+(L||"")+(k&&!r?k:"")+(C||"")+(B&&R?")":"")+w}function x(e,n){o[e]=n}function g(e){u=e;var n=o[e].defaults;n&&n.format&&a.defaultFormat(n.format),n&&n.currencyFormat&&a.defaultCurrencyFormat(n.currencyFormat)}(a=function(e){return a.isNumbro(e)?e=e.value():0===e||void 0===e?e=0:Number(e)||(e=a.fn.unformat(e)),new f(Number(e))}).version="1.6.2",a.isNumbro=function(e){return e instanceof f},a.setLanguage=function(e,n){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var t=e,r=e.split("-")[0],i=null;l[t]||(Object.keys(l).forEach((function(e){i||e.split("-")[0]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.setCulture=function(e,n){var t=e,r=e.split("-")[1],i=null;o[t]||(r&&Object.keys(o).forEach((function(e){i||e.split("-")[1]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.language=function(e,n){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!e)return u;if(e&&!n){if(!l[e])throw new Error("Unknown language : "+e);g(e)}return!n&&l[e]||x(e,n),a},a.culture=function(e,n){if(!e)return u;if(e&&!n){if(!o[e])throw new Error("Unknown culture : "+e);g(e)}return!n&&o[e]||x(e,n),a},a.languageData=function(e){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!e)return l[u];if(!l[e])throw new Error("Unknown language : "+e);return l[e]},a.cultureData=function(e){if(!e)return o[u];if(!o[e])throw new Error("Unknown culture : "+e);return o[e]},a.culture("en-US",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(e){var n=e%10;return 1==~~(e%100/10)?"th":1===n?"st":2===n?"nd":3===n?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}}),a.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),l},a.cultures=function(){return o},a.zeroFormat=function(e){c="string"==typeof e?e:null},a.defaultFormat=function(e){s="string"==typeof e?e:"0.0"},a.defaultCurrencyFormat=function(e){"string"==typeof e?e:"0$"},a.validate=function(e,n){var t,r,i,o,l,u,c,s;if("string"!=typeof e&&(e+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",e)),(e=e.trim()).match(/^\d+$/))return!0;if(""===e)return!1;try{c=a.cultureData(n)}catch(e){c=a.cultureData(a.culture())}return i=c.currency.symbol,l=c.abbreviations,t=c.delimiters.decimal,r="."===c.delimiters.thousands?"\\.":c.delimiters.thousands,(null===(s=e.match(/^[^\d]+/))||(e=e.substr(1),s[0]===i))&&((null===(s=e.match(/[^\d]+$/))||(e=e.slice(0,-1),s[0]===l.thousand||s[0]===l.million||s[0]===l.billion||s[0]===l.trillion))&&(u=new RegExp(r+"{2}"),!e.match(/[^\d.,]/g)&&(!((o=e.split(t)).length>2)&&(o.length<2?!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u):1===o[0].length?!!o[0].match(/^\d+$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/):!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/)))))},n.exports={format:function(e,n,t,r){return null!=t&&t!==a.culture()&&a.setCulture(t),p(Number(e),null!=n?n:s,null==r?Math.round:r)}}},
function _(e,n,t,r,i){!function(){"use strict";var e={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[+-]/};function n(e){return i(a(e),arguments)}function r(e,t){return n.apply(null,[e].concat(t||[]))}function i(t,r){var i,s,a,o,p,c,l,u,f,d=1,g=t.length,y="";for(s=0;s<g;s++)if("string"==typeof t[s])y+=t[s];else if("object"==typeof t[s]){if((o=t[s]).keys)for(i=r[d],a=0;a<o.keys.length;a++){if(null==i)throw new Error(n('[sprintf] Cannot access property "%s" of undefined value "%s"',o.keys[a],o.keys[a-1]));i=i[o.keys[a]]}else i=o.param_no?r[o.param_no]:r[d++];if(e.not_type.test(o.type)&&e.not_primitive.test(o.type)&&i instanceof Function&&(i=i()),e.numeric_arg.test(o.type)&&"number"!=typeof i&&isNaN(i))throw new TypeError(n("[sprintf] expecting number but found %T",i));switch(e.number.test(o.type)&&(u=i>=0),o.type){case"b":i=parseInt(i,10).toString(2);break;case"c":i=String.fromCharCode(parseInt(i,10));break;case"d":case"i":i=parseInt(i,10);break;case"j":i=JSON.stringify(i,null,o.width?parseInt(o.width):0);break;case"e":i=o.precision?parseFloat(i).toExponential(o.precision):parseFloat(i).toExponential();break;case"f":i=o.precision?parseFloat(i).toFixed(o.precision):parseFloat(i);break;case"g":i=o.precision?String(Number(i.toPrecision(o.precision))):parseFloat(i);break;case"o":i=(parseInt(i,10)>>>0).toString(8);break;case"s":i=String(i),i=o.precision?i.substring(0,o.precision):i;break;case"t":i=String(!!i),i=o.precision?i.substring(0,o.precision):i;break;case"T":i=Object.prototype.toString.call(i).slice(8,-1).toLowerCase(),i=o.precision?i.substring(0,o.precision):i;break;case"u":i=parseInt(i,10)>>>0;break;case"v":i=i.valueOf(),i=o.precision?i.substring(0,o.precision):i;break;case"x":i=(parseInt(i,10)>>>0).toString(16);break;case"X":i=(parseInt(i,10)>>>0).toString(16).toUpperCase()}e.json.test(o.type)?y+=i:(!e.number.test(o.type)||u&&!o.sign?f="":(f=u?"+":"-",i=i.toString().replace(e.sign,"")),c=o.pad_char?"0"===o.pad_char?"0":o.pad_char.charAt(1):" ",l=o.width-(f+i).length,p=o.width&&l>0?c.repeat(l):"",y+=o.align?f+i+p:"0"===c?f+p+i:p+f+i)}return y}var s=Object.create(null);function a(n){if(s[n])return s[n];for(var t,r=n,i=[],a=0;r;){if(null!==(t=e.text.exec(r)))i.push(t[0]);else if(null!==(t=e.modulo.exec(r)))i.push("%");else{if(null===(t=e.placeholder.exec(r)))throw new SyntaxError("[sprintf] unexpected placeholder");if(t[2]){a|=1;var o=[],p=t[2],c=[];if(null===(c=e.key.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o.push(c[1]);""!==(p=p.substring(c[0].length));)if(null!==(c=e.key_access.exec(p)))o.push(c[1]);else{if(null===(c=e.index_access.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");o.push(c[1])}t[2]=o}else a|=2;if(3===a)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");i.push({placeholder:t[0],param_no:t[1],keys:t[2],sign:t[3],pad_char:t[4],align:t[5],width:t[6],precision:t[7],type:t[8]})}r=r.substring(t[0].length)}return s[n]=i}void 0!==t&&(t.sprintf=n,t.vsprintf=r),"undefined"!=typeof window&&(window.sprintf=n,window.vsprintf=r,"function"==typeof define&&define.amd&&define((function(){return{sprintf:n,vsprintf:r}})))}()},
function _(e,n,i,t,r){t();var a=e(1),s=e(124),c=e(249),_=e(330),m=e(331),k=e(334),o=e(335),T=e(333),u=function(e){function n(n){return e.call(this,n)||this}return a.__extends(n,e),n.init_DatetimeTicker=function(){this.override({num_minor_ticks:0,tickers:function(){return[new c.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*T.ONE_MILLI,num_minor_ticks:0}),new c.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:T.ONE_SECOND,max_interval:30*T.ONE_MINUTE,num_minor_ticks:0}),new c.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:T.ONE_HOUR,max_interval:12*T.ONE_HOUR,num_minor_ticks:0}),new m.DaysTicker({days:s.range(1,32)}),new m.DaysTicker({days:s.range(1,31,3)}),new m.DaysTicker({days:[1,8,15,22]}),new m.DaysTicker({days:[1,15]}),new k.MonthsTicker({months:s.range(0,12,1)}),new k.MonthsTicker({months:s.range(0,12,2)}),new k.MonthsTicker({months:s.range(0,12,4)}),new k.MonthsTicker({months:s.range(0,12,6)}),new o.YearsTicker({})]}})},n}(_.CompositeTicker);i.DatetimeTicker=u,u.__name__="DatetimeTicker",u.init_DatetimeTicker()},
function _(t,e,i,n,r){n();var o=t(1),s=t(245),_=t(124),a=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_CompositeTicker=function(){this.define((function(t){return{tickers:[(0,t.Array)((0,t.Ref)(s.ContinuousTicker)),[]]}}))},Object.defineProperty(e.prototype,"min_intervals",{get:function(){return this.tickers.map((function(t){return t.get_min_interval()}))},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"max_intervals",{get:function(){return this.tickers.map((function(t){return t.get_max_interval()}))},enumerable:!1,configurable:!0}),e.prototype.get_min_interval=function(){return this.min_intervals[0]},e.prototype.get_max_interval=function(){return this.max_intervals[0]},e.prototype.get_best_ticker=function(t,e,i){var n,r=e-t,o=this.get_ideal_interval(t,e,i),s=[_.sorted_index(this.min_intervals,o)-1,_.sorted_index(this.max_intervals,o)],a=[this.min_intervals[s[0]],this.max_intervals[s[1]]].map((function(t){return Math.abs(i-r/t)}));if(_.is_empty(a.filter((function(t){return!isNaN(t)}))))n=this.tickers[0];else{var u=s[_.argmin(a)];n=this.tickers[u]}return n},e.prototype.get_interval=function(t,e,i){return this.get_best_ticker(t,e,i).get_interval(t,e,i)},e.prototype.get_ticks_no_defaults=function(t,e,i,n){return this.get_best_ticker(t,e,n).get_ticks_no_defaults(t,e,i,n)},e}(s.ContinuousTicker);i.CompositeTicker=a,a.__name__="CompositeTicker",a.init_CompositeTicker()},
function _(t,n,e,r,i){r();var a=t(1),o=t(332),s=t(333),c=t(124);var u=function(t){function n(n){return t.call(this,n)||this}return a.__extends(n,t),n.init_DaysTicker=function(){this.define((function(t){var n=t.Int;return{days:[(0,t.Array)(n),[]]}})),this.override({num_minor_ticks:0})},n.prototype.initialize=function(){t.prototype.initialize.call(this);var n=this.days;n.length>1?this.interval=(n[1]-n[0])*s.ONE_DAY:this.interval=31*s.ONE_DAY},n.prototype.get_ticks_no_defaults=function(t,n,e,r){var i=function(t,n){var e=s.last_month_no_later_than(new Date(t)),r=s.last_month_no_later_than(new Date(n));r.setUTCMonth(r.getUTCMonth()+1);for(var i=[],a=e;i.push(s.copy_date(a)),a.setUTCMonth(a.getUTCMonth()+1),!(a>r););return i}(t,n),o=this.days,u=this.interval;return{major:c.concat(i.map((function(t){return function(t,n){var e,r,i=t.getUTCMonth(),c=[];try{for(var u=a.__values(o),_=u.next();!_.done;_=u.next()){var l=_.value,h=s.copy_date(t);h.setUTCDate(l),new Date(h.getTime()+n/2).getUTCMonth()==i&&c.push(h)}}catch(t){e={error:t}}finally{try{_&&!_.done&&(r=u.return)&&r.call(u)}finally{if(e)throw e.error}}return c}(t,u)}))).map((function(t){return t.getTime()})).filter((function(e){return t<=e&&e<=n})),minor:[]}},n}(o.SingleIntervalTicker);e.DaysTicker=u,u.__name__="DaysTicker",u.init_DaysTicker()},
function _(n,t,e,i,r){i();var l=n(1),u=function(n){function t(t){return n.call(this,t)||this}return l.__extends(t,n),t.init_SingleIntervalTicker=function(){this.define((function(n){return{interval:[n.Number]}}))},t.prototype.get_interval=function(n,t,e){return this.interval},t.prototype.get_min_interval=function(){return this.interval},t.prototype.get_max_interval=function(){return this.interval},t}(n(245).ContinuousTicker);e.SingleIntervalTicker=u,u.__name__="SingleIntervalTicker",u.init_SingleIntervalTicker()},
function _(t,e,_,n,E){function N(t){return new Date(t.getTime())}function O(t){var e=N(t);return e.setUTCDate(1),e.setUTCHours(0),e.setUTCMinutes(0),e.setUTCSeconds(0),e.setUTCMilliseconds(0),e}n(),_.ONE_MILLI=1,_.ONE_SECOND=1e3,_.ONE_MINUTE=60*_.ONE_SECOND,_.ONE_HOUR=60*_.ONE_MINUTE,_.ONE_DAY=24*_.ONE_HOUR,_.ONE_MONTH=30*_.ONE_DAY,_.ONE_YEAR=365*_.ONE_DAY,_.copy_date=N,_.last_month_no_later_than=O,_.last_year_no_later_than=function(t){var e=O(t);return e.setUTCMonth(0),e}},
function _(t,n,e,r,i){r();var a=t(1),o=t(332),u=t(333),l=t(124);var c=function(t){function n(n){return t.call(this,n)||this}return a.__extends(n,t),n.init_MonthsTicker=function(){this.define((function(t){var n=t.Int;return{months:[(0,t.Array)(n),[]]}}))},n.prototype.initialize=function(){t.prototype.initialize.call(this);var n=this.months;n.length>1?this.interval=(n[1]-n[0])*u.ONE_MONTH:this.interval=12*u.ONE_MONTH},n.prototype.get_ticks_no_defaults=function(t,n,e,r){var i=function(t,n){var e=u.last_year_no_later_than(new Date(t)),r=u.last_year_no_later_than(new Date(n));r.setUTCFullYear(r.getUTCFullYear()+1);for(var i=[],a=e;i.push(u.copy_date(a)),a.setUTCFullYear(a.getUTCFullYear()+1),!(a>r););return i}(t,n),a=this.months;return{major:l.concat(i.map((function(t){return a.map((function(n){var e=u.copy_date(t);return e.setUTCMonth(n),e}))}))).map((function(t){return t.getTime()})).filter((function(e){return t<=e&&e<=n})),minor:[]}},n}(o.SingleIntervalTicker);e.MonthsTicker=c,c.__name__="MonthsTicker",c.init_MonthsTicker()},
function _(t,e,i,n,r){n();var a=t(1),_=t(248),c=t(332),o=t(333),l=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.interval=o.ONE_YEAR,this.basic_ticker=new _.BasicTicker({num_minor_ticks:0})},e.prototype.get_ticks_no_defaults=function(t,e,i,n){var r=o.last_year_no_later_than(new Date(t)).getUTCFullYear(),a=o.last_year_no_later_than(new Date(e)).getUTCFullYear();return{major:this.basic_ticker.get_ticks_no_defaults(r,a,i,n).major.map((function(t){return Date.UTC(t,0,1)})).filter((function(i){return t<=i&&i<=e})),minor:[]}},e}(c.SingleIntervalTicker);i.YearsTicker=l,l.__name__="YearsTicker"},
function _(i,n,t,e,o){e();var r=i(1),u=i(321),s=i(337),_=i(338),c=function(i){function n(){return null!==i&&i.apply(this,arguments)||this}return r.__extends(n,i),n}(u.ContinuousAxisView);t.LogAxisView=c,c.__name__="LogAxisView";var f=function(i){function n(n){return i.call(this,n)||this}return r.__extends(n,i),n.init_LogAxis=function(){this.prototype.default_view=c,this.override({ticker:function(){return new _.LogTicker},formatter:function(){return new s.LogTickFormatter}})},n}(u.ContinuousAxis);t.LogAxis=f,f.__name__="LogAxis",f.init_LogAxis()},
function _(t,i,r,e,n){e();var o=t(1),a=t(247),c=t(250),l=t(338),u=function(t){function i(i){return t.call(this,i)||this}return o.__extends(i,t),i.init_LogTickFormatter=function(){this.define((function(t){var i=t.Ref;return{ticker:[(0,t.Nullable)(i(l.LogTicker)),null]}}))},i.prototype.initialize=function(){t.prototype.initialize.call(this),this.basic_formatter=new c.BasicTickFormatter},i.prototype.doFormat=function(t,i){if(0==t.length)return[];for(var r=null!=this.ticker?this.ticker.base:10,e=!1,n=new Array(t.length),o=0,a=t.length;o<a;o++)if(n[o]=r+"^"+Math.round(Math.log(t[o])/Math.log(r)),o>0&&n[o]==n[o-1]){e=!0;break}return e?this.basic_formatter.doFormat(t,i):n},i}(a.TickFormatter);r.LogTickFormatter=u,u.__name__="LogTickFormatter",u.init_LogTickFormatter()},
function _(r,t,e,n,a){n();var o=r(1),i=r(249),l=r(124),u=function(r){function t(t){return r.call(this,t)||this}return o.__extends(t,r),t.init_LogTicker=function(){this.override({mantissas:[1,5]})},t.prototype.get_ticks_no_defaults=function(r,t,e,n){var a,i,u,f,c,h,v,s,_,y,d,g,p,x=this.num_minor_ticks,M=[],m=this.base,w=Math.log(r)/Math.log(m),k=Math.log(t)/Math.log(m),T=k-w;if(isFinite(T))if(T<2){var L=this.get_interval(r,t,n),b=Math.floor(r/L),j=Math.ceil(t/L);if(p=l.range(b,j+1).filter((function(r){return 0!=r})).map((function(r){return r*L})).filter((function(e){return r<=e&&e<=t})),x>0&&p.length>0){var A=L/x,F=l.range(0,x).map((function(r){return r*A}));try{for(var q=o.__values(F.slice(1)),z=q.next();!z.done;z=q.next()){var B=z.value;M.push(p[0]-B)}}catch(r){a={error:r}}finally{try{z&&!z.done&&(i=q.return)&&i.call(q)}finally{if(a)throw a.error}}try{for(var C=o.__values(p),D=C.next();!D.done;D=C.next()){var E=D.value;try{for(var G=(c=void 0,o.__values(F)),H=G.next();!H.done;H=G.next()){B=H.value;M.push(E+B)}}catch(r){c={error:r}}finally{try{H&&!H.done&&(h=G.return)&&h.call(G)}finally{if(c)throw c.error}}}}catch(r){u={error:r}}finally{try{D&&!D.done&&(f=C.return)&&f.call(C)}finally{if(u)throw u.error}}}}else{var I=Math.ceil(.999999*w),J=Math.floor(1.000001*k),K=Math.ceil((J-I)/9);if(p=l.range(I-1,J+1,K).map((function(r){return Math.pow(m,r)})),x>0&&p.length>0){var N=Math.pow(m,K)/x;F=l.range(1,x+1).map((function(r){return r*N}));try{for(var O=o.__values(F),P=O.next();!P.done;P=O.next()){B=P.value;M.push(p[0]/B)}}catch(r){v={error:r}}finally{try{P&&!P.done&&(s=O.return)&&s.call(O)}finally{if(v)throw v.error}}M.push(p[0]);try{for(var Q=o.__values(p),R=Q.next();!R.done;R=Q.next()){E=R.value;try{for(var S=(d=void 0,o.__values(F)),U=S.next();!U.done;U=S.next()){B=U.value;M.push(E*B)}}catch(r){d={error:r}}finally{try{U&&!U.done&&(g=S.return)&&g.call(S)}finally{if(d)throw d.error}}}}catch(r){_={error:r}}finally{try{R&&!R.done&&(y=Q.return)&&y.call(Q)}finally{if(_)throw _.error}}}}else p=[];return{major:p.filter((function(e){return r<=e&&e<=t})),minor:M.filter((function(e){return r<=e&&e<=t}))}},t}(i.AdaptiveTicker);e.LogTicker=u,u.__name__="LogTicker",u.init_LogTicker()},
function _(t,r,i,e,n){e();var o=t(1),a=t(316),c=t(323),s=t(340),u=t(341),_=function(t){function r(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(r,t),r}(a.AxisView);i.MercatorAxisView=_,_.__name__="MercatorAxisView";var f=function(t){function r(r){return t.call(this,r)||this}return o.__extends(r,t),r.init_MercatorAxis=function(){this.prototype.default_view=_,this.override({ticker:function(){return new u.MercatorTicker({dimension:"lat"})},formatter:function(){return new s.MercatorTickFormatter({dimension:"lat"})}})},r}(c.LinearAxis);i.MercatorAxis=f,f.__name__="MercatorAxis",f.init_MercatorAxis()},
function _(r,t,n,o,e){o();var i=r(1),a=r(250),c=r(135),m=r(152),s=function(r){function t(t){return r.call(this,t)||this}return i.__extends(t,r),t.init_MercatorTickFormatter=function(){this.define((function(){return{dimension:[c.LatLon]}}))},t.prototype.doFormat=function(t,n){if(null==this.dimension)throw new Error("MercatorTickFormatter.dimension not configured");if(0==t.length)return[];var o=t.length,e=new Array(o);if("lon"==this.dimension)for(var a=0;a<o;a++){var c=i.__read(m.wgs84_mercator.invert(t[a],n.loc),1)[0];e[a]=c}else for(a=0;a<o;a++){var s=i.__read(m.wgs84_mercator.invert(n.loc,t[a]),2)[1];e[a]=s}return r.prototype.doFormat.call(this,e,n)},t}(a.BasicTickFormatter);n.MercatorTickFormatter=s,s.__name__="MercatorTickFormatter",s.init_MercatorTickFormatter()},
function _(r,t,e,n,o){n();var a=r(1),i=r(248),_=r(135),c=r(152),l=function(r){function t(t){return r.call(this,t)||this}return a.__extends(t,r),t.init_MercatorTicker=function(){this.define((function(){return{dimension:[_.LatLon]}}))},t.prototype.get_ticks_no_defaults=function(r,t,e,n){var o;if(null==this.dimension)throw new Error(this+".dimension wasn't configured");return r=(o=a.__read(c.clip_mercator(r,t,this.dimension),2))[0],t=o[1],"lon"==this.dimension?this._get_ticks_lon(r,t,e,n):this._get_ticks_lat(r,t,e,n)},t.prototype._get_ticks_lon=function(t,e,n,o){var i,_,l,s,u=a.__read(c.wgs84_mercator.invert(t,n),1)[0],f=a.__read(c.wgs84_mercator.invert(e,n),2),d=f[0],m=f[1],v=r.prototype.get_ticks_no_defaults.call(this,u,d,n,o),h=[];try{for(var y=a.__values(v.major),p=y.next();!p.done;p=y.next()){var g=p.value;if(c.in_bounds(g,"lon")){var w=a.__read(c.wgs84_mercator.compute(g,m),1)[0];h.push(w)}}}catch(r){i={error:r}}finally{try{p&&!p.done&&(_=y.return)&&_.call(y)}finally{if(i)throw i.error}}var k=[];try{for(var x=a.__values(v.minor),T=x.next();!T.done;T=x.next()){g=T.value;if(c.in_bounds(g,"lon")){w=a.__read(c.wgs84_mercator.compute(g,m),1)[0];k.push(w)}}}catch(r){l={error:r}}finally{try{T&&!T.done&&(s=x.return)&&s.call(x)}finally{if(l)throw l.error}}return{major:h,minor:k}},t.prototype._get_ticks_lat=function(t,e,n,o){var i,_,l,s,u=a.__read(c.wgs84_mercator.invert(n,t),2)[1],f=a.__read(c.wgs84_mercator.invert(n,e),2),d=f[0],m=f[1],v=r.prototype.get_ticks_no_defaults.call(this,u,m,n,o),h=[];try{for(var y=a.__values(v.major),p=y.next();!p.done;p=y.next()){var g=p.value;if(c.in_bounds(g,"lat")){var w=a.__read(c.wgs84_mercator.compute(d,g),2)[1];h.push(w)}}}catch(r){i={error:r}}finally{try{p&&!p.done&&(_=y.return)&&_.call(y)}finally{if(i)throw i.error}}var k=[];try{for(var x=a.__values(v.minor),T=x.next();!T.done;T=x.next()){g=T.value;if(c.in_bounds(g,"lat")){w=a.__read(c.wgs84_mercator.compute(d,g),2)[1];k.push(w)}}}catch(r){l={error:r}}finally{try{T&&!T.done&&(s=x.return)&&s.call(x)}finally{if(l)throw l.error}}return{major:h,minor:k}},t}(i.BasicTicker);e.MercatorTicker=l,l.__name__="MercatorTicker",l.init_MercatorTicker()},
function _(n,o,t,u,e){u(),e("CustomJS",n(343).CustomJS),e("OpenURL",n(345).OpenURL)},
function _(t,e,n,r,i){r();var o=t(1),u=t(344),c=t(128),a=t(144),s=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_CustomJS=function(){this.define((function(t){var e=t.Unknown,n=t.String;return{args:[(0,t.Dict)(e),{}],code:[n,""]}}))},Object.defineProperty(e.prototype,"names",{get:function(){return c.keys(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"values",{get:function(){return c.values(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"func",{get:function(){var t=a.use_strict(this.code);return new(Function.bind.apply(Function,o.__spread([void 0],this.names,["cb_obj","cb_data",t])))},enumerable:!1,configurable:!0}),e.prototype.execute=function(t,e){return void 0===e&&(e={}),this.func.apply(t,this.values.concat(t,e))},e}(u.Callback);n.CustomJS=s,s.__name__="CustomJS",s.init_CustomJS()},
function _(n,t,a,l,_){l();var c=n(1),e=function(n){function t(t){return n.call(this,t)||this}return c.__extends(t,n),t}(n(196).Model);a.Callback=e,e.__name__="Callback"},
function _(n,e,r,t,i){t();var o=n(1),a=n(344),l=n(326),c=n(123),u=function(n){function e(e){return n.call(this,e)||this}return o.__extends(e,n),e.init_OpenURL=function(){this.define((function(n){var e=n.Boolean;return{url:[n.String,"http://"],same_tab:[e,!1]}}))},e.prototype.execute=function(n,e){var r,t,i,a,u=this,f=e.source,s=function(n){var e=l.replace_placeholders(u.url,f,n);if(!c.isString(e))throw new Error("HTML output is not supported in this context");u.same_tab?window.location.href=e:window.open(e)},_=f.selected;try{for(var d=o.__values(_.indices),h=d.next();!h.done;h=d.next()){s(h.value)}}catch(n){r={error:n}}finally{try{h&&!h.done&&(t=d.return)&&t.call(d)}finally{if(r)throw r.error}}try{for(var p=o.__values(_.line_indices),v=p.next();!v.done;v=p.next()){s(v.value)}}catch(n){i={error:n}}finally{try{v&&!v.done&&(a=p.return)&&a.call(p)}finally{if(i)throw i.error}}},e}(a.Callback);r.OpenURL=u,u.__name__="OpenURL",u.init_OpenURL()},
function _(a,n,e,r,s){r(),s("Canvas",a(192).Canvas),s("CartesianFrame",a(347).CartesianFrame)},
function _(e,t,r,n,a){n();var s=e(1),_=e(348),o=e(265),i=e(277),c=e(275),l=e(349),g=e(207),u=e(351),f=e(128),y=e(126),p=function(e){function t(t,r,n,a,s,_){void 0===s&&(s={}),void 0===_&&(_={});var o=e.call(this)||this;return o.in_x_scale=t,o.in_y_scale=r,o.x_range=n,o.y_range=a,o.extra_x_ranges=s,o.extra_y_ranges=_,y.assert(null==t.source_range&&null==t.target_range),y.assert(null==r.source_range&&null==r.target_range),o._configure_scales(),o}return s.__extends(t,e),t.prototype._get_ranges=function(e,t){return new Map(f.entries(Object.assign(Object.assign({},t),{default:e})))},t.prototype._get_scales=function(e,t,r){var n,a,u=new Map;try{for(var f=s.__values(t),y=f.next();!y.done;y=f.next()){var p=s.__read(y.value,2),h=p[0],b=p[1];if((b instanceof l.DataRange1d||b instanceof c.Range1d)&&!(e instanceof o.ContinuousScale))throw new Error("Range "+b.type+" is incompatible is Scale "+e.type);if(b instanceof g.FactorRange&&!(e instanceof _.CategoricalScale))throw new Error("Range "+b.type+" is incompatible is Scale "+e.type);e instanceof i.LogScale&&b instanceof l.DataRange1d&&(b.scale_hint="log");var x=e.clone();x.setv({source_range:b,target_range:r}),u.set(h,x)}}catch(e){n={error:e}}finally{try{y&&!y.done&&(a=f.return)&&a.call(f)}finally{if(n)throw n.error}}return u},t.prototype._configure_frame_ranges=function(){var e=this.bbox;this._x_target=new c.Range1d({start:e.left,end:e.right}),this._y_target=new c.Range1d({start:e.bottom,end:e.top})},t.prototype._configure_scales=function(){this._configure_frame_ranges(),this._x_ranges=this._get_ranges(this.x_range,this.extra_x_ranges),this._y_ranges=this._get_ranges(this.y_range,this.extra_y_ranges),this._x_scales=this._get_scales(this.in_x_scale,this._x_ranges,this._x_target),this._y_scales=this._get_scales(this.in_y_scale,this._y_ranges,this._y_target)},t.prototype._update_scales=function(){var e,t,r,n;this._configure_frame_ranges();try{for(var a=s.__values(this._x_scales),_=a.next();!_.done;_=a.next()){s.__read(_.value,2)[1].target_range=this._x_target}}catch(t){e={error:t}}finally{try{_&&!_.done&&(t=a.return)&&t.call(a)}finally{if(e)throw e.error}}try{for(var o=s.__values(this._y_scales),i=o.next();!i.done;i=o.next()){s.__read(i.value,2)[1].target_range=this._y_target}}catch(e){r={error:e}}finally{try{i&&!i.done&&(n=o.return)&&n.call(o)}finally{if(r)throw r.error}}},t.prototype._set_geometry=function(t,r){e.prototype._set_geometry.call(this,t,r),this._update_scales()},Object.defineProperty(t.prototype,"x_target",{get:function(){return this._x_target},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"y_target",{get:function(){return this._y_target},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"x_ranges",{get:function(){return this._x_ranges},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"y_ranges",{get:function(){return this._y_ranges},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"x_scales",{get:function(){return this._x_scales},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"y_scales",{get:function(){return this._y_scales},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"x_scale",{get:function(){return this._x_scales.get("default")},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"y_scale",{get:function(){return this._y_scales.get("default")},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"xscales",{get:function(){return f.to_object(this.x_scales)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"yscales",{get:function(){return f.to_object(this.y_scales)},enumerable:!1,configurable:!0}),t}(u.LayoutItem);r.CartesianFrame=p,p.__name__="CartesianFrame"},
function _(t,e,n,r,i){r();var o=t(1),c=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.prototype.compute=function(e){return t.prototype._linear_compute.call(this,this.source_range.synthetic(e))},e.prototype.v_compute=function(e){return t.prototype._linear_v_compute.call(this,this.source_range.v_synthetic(e))},e.prototype.invert=function(t){return this._linear_invert(t)},e.prototype.v_invert=function(t){return this._linear_v_invert(t)},e}(t(266).Scale);n.CategoricalScale=c,c.__name__="CategoricalScale"},
function _(t,i,n,a,e){a();var r=t(1),l=t(350),o=t(135),s=t(134),_=r.__importStar(t(194)),d=t(124),u=function(t){function i(i){var n=t.call(this,i)||this;return n.have_updated_interactively=!1,n}return r.__extends(i,t),i.init_DataRange1d=function(){this.define((function(t){var i=t.Boolean,n=t.Number,a=t.Nullable;return{start:[n],end:[n],range_padding:[n,.1],range_padding_units:[o.PaddingUnits,"percent"],flipped:[i,!1],follow:[a(o.StartEnd),null],follow_interval:[a(n),null],default_span:[n,2],only_visible:[i,!1]}})),this.internal((function(t){return{scale_hint:[(0,t.Enum)("log","auto"),"auto"]}}))},i.prototype.initialize=function(){t.prototype.initialize.call(this),this._initial_start=this.start,this._initial_end=this.end,this._initial_range_padding=this.range_padding,this._initial_range_padding_units=this.range_padding_units,this._initial_follow=this.follow,this._initial_follow_interval=this.follow_interval,this._initial_default_span=this.default_span,this._plot_bounds=new Map},Object.defineProperty(i.prototype,"min",{get:function(){return Math.min(this.start,this.end)},enumerable:!1,configurable:!0}),Object.defineProperty(i.prototype,"max",{get:function(){return Math.max(this.start,this.end)},enumerable:!1,configurable:!0}),i.prototype.computed_renderers=function(){var t,i,n,a,e=this.names,l=this.renderers;if(0==l.length)try{for(var o=r.__values(this.plots),_=o.next();!_.done;_=o.next()){var u=_.value;l=l.concat(u.data_renderers)}}catch(i){t={error:i}}finally{try{_&&!_.done&&(i=o.return)&&i.call(o)}finally{if(t)throw t.error}}e.length>0&&(l=l.filter((function(t){return d.includes(e,t.name)}))),s.logger.debug("computed "+l.length+" renderers for "+this);try{for(var h=r.__values(l),p=h.next();!p.done;p=h.next()){var g=p.value;s.logger.trace(" - "+g)}}catch(t){n={error:t}}finally{try{p&&!p.done&&(a=h.return)&&a.call(h)}finally{if(n)throw n.error}}return l},i.prototype._compute_plot_bounds=function(t,i){var n,a,e=_.empty();try{for(var l=r.__values(t),o=l.next();!o.done;o=l.next()){var s=o.value,d=i.get(s);null==d||!s.visible&&this.only_visible||(e=_.union(e,d))}}catch(t){n={error:t}}finally{try{o&&!o.done&&(a=l.return)&&a.call(l)}finally{if(n)throw n.error}}return e},i.prototype.adjust_bounds_for_aspect=function(t,i){var n=_.empty(),a=t.x1-t.x0;a<=0&&(a=1);var e=t.y1-t.y0;e<=0&&(e=1);var r=.5*(t.x1+t.x0),l=.5*(t.y1+t.y0);return a<i*e?a=i*e:e=a/i,n.x1=r+.5*a,n.x0=r-.5*a,n.y1=l+.5*e,n.y0=l-.5*e,n},i.prototype._compute_min_max=function(t,i){var n,a,e,l,o,s,d=_.empty();try{for(var u=r.__values(t),h=u.next();!h.done;h=u.next()){var p=h.value;d=_.union(d,p)}}catch(t){n={error:t}}finally{try{h&&!h.done&&(a=u.return)&&a.call(u)}finally{if(n)throw n.error}}return 0==i?(o=(e=r.__read([d.x0,d.x1],2))[0],s=e[1]):(o=(l=r.__read([d.y0,d.y1],2))[0],s=l[1]),[o,s]},i.prototype._compute_range=function(t,i){var n,a,e,l=this.range_padding;if(null!=this._initial_start&&(t=this._initial_start),null!=this._initial_end&&(i=this._initial_end),"log"==this.scale_hint){(isNaN(t)||!isFinite(t)||t<=0)&&(t=isNaN(i)||!isFinite(i)||i<=0?.1:i/100,s.logger.warn("could not determine minimum data value for log axis, DataRange1d using value "+t)),(isNaN(i)||!isFinite(i)||i<=0)&&(i=isNaN(t)||!isFinite(t)||t<=0?10:100*t,s.logger.warn("could not determine maximum data value for log axis, DataRange1d using value "+i));var o=void 0,_=void 0;if(i==t)_=this.default_span+.001,o=Math.log(t)/Math.log(10);else{var d=void 0,u=void 0;"percent"==this.range_padding_units?(d=Math.log(t)/Math.log(10),_=((u=Math.log(i)/Math.log(10))-d)*(1+l)):(d=Math.log(t-l)/Math.log(10),_=(u=Math.log(i+l)/Math.log(10))-d),o=(d+u)/2}a=Math.pow(10,o-_/2),e=Math.pow(10,o+_/2)}else{_=void 0;a=(o=(i+t)/2)-(_=i==t?this.default_span:"percent"==this.range_padding_units?(i-t)*(1+l):i-t+2*l)/2,e=o+_/2}var h=1;this.flipped&&(a=(n=r.__read([e,a],2))[0],e=n[1],h=-1);var p=this.follow_interval;return null!=p&&Math.abs(a-e)>p&&("start"==this.follow?e=a+h*p:"end"==this.follow&&(a=e-h*p)),[a,e]},i.prototype.update=function(t,i,n,a){if(!this.have_updated_interactively){var e=this.computed_renderers(),l=this._compute_plot_bounds(e,t);null!=a&&(l=this.adjust_bounds_for_aspect(l,a)),this._plot_bounds.set(n,l);var o=r.__read(this._compute_min_max(this._plot_bounds.values(),i),2),s=o[0],_=o[1],d=r.__read(this._compute_range(s,_),2),u=d[0],h=d[1];null!=this._initial_start&&("log"==this.scale_hint?this._initial_start>0&&(u=this._initial_start):u=this._initial_start),null!=this._initial_end&&("log"==this.scale_hint?this._initial_end>0&&(h=this._initial_end):h=this._initial_end);var p=r.__read([this.start,this.end],2),g=p[0],f=p[1];if(u!=g||h!=f){var c={};u!=g&&(c.start=u),h!=f&&(c.end=h),this.setv(c)}"auto"==this.bounds&&this.setv({bounds:[u,h]},{silent:!0}),this.change.emit()}},i.prototype.reset=function(){this.have_updated_interactively=!1,this.setv({range_padding:this._initial_range_padding,range_padding_units:this._initial_range_padding_units,follow:this._initial_follow,follow_interval:this._initial_follow_interval,default_span:this._initial_default_span},{silent:!0}),this.change.emit()},i}(l.DataRange);n.DataRange1d=u,u.__name__="DataRange1d",u.init_DataRange1d()},
function _(n,a,e,t,r){t();var i=n(1),_=n(208),u=n(211),f=function(n){function a(a){return n.call(this,a)||this}return i.__extends(a,n),a.init_DataRange=function(){this.define((function(n){var a=n.String,e=n.Array,t=n.Ref;return{names:[e(a),[]],renderers:[e(t(u.DataRenderer)),[]]}}))},a}(_.Range);e.DataRange=f,f.__name__="DataRange",f.init_DataRange()},
function _(a,o,t,i,n){i();var c=a(352);n("Sizeable",c.Sizeable),n("SizingPolicy",c.SizingPolicy);var r=a(353);n("Layoutable",r.Layoutable),n("LayoutItem",r.LayoutItem);var e=a(354);n("HStack",e.HStack),n("VStack",e.VStack),n("AnchorLayout",e.AnchorLayout);var u=a(355);n("Grid",u.Grid),n("Row",u.Row),n("Column",u.Column);var l=a(356);n("ContentBox",l.ContentBox),n("VariadicBox",l.VariadicBox)},
function _(t,h,i,e,n){e();var o=t(136),r=Math.min,w=Math.max,d=function(){function t(t){void 0===t&&(t={}),this.width=null!=t.width?t.width:0,this.height=null!=t.height?t.height:0}return t.prototype.bounded_to=function(h){var i=h.width,e=h.height;return new t({width:this.width==1/0&&null!=i?i:this.width,height:this.height==1/0&&null!=e?e:this.height})},t.prototype.expanded_to=function(h){var i=h.width,e=h.height;return new t({width:i!=1/0?w(this.width,i):this.width,height:e!=1/0?w(this.height,e):this.height})},t.prototype.expand_to=function(t){var h=t.width,i=t.height;this.width=w(this.width,h),this.height=w(this.height,i)},t.prototype.narrowed_to=function(h){var i=h.width,e=h.height;return new t({width:r(this.width,i),height:r(this.height,e)})},t.prototype.narrow_to=function(t){var h=t.width,i=t.height;this.width=r(this.width,h),this.height=r(this.height,i)},t.prototype.grow_by=function(h){var i=h.left,e=h.right,n=h.top,o=h.bottom;return new t({width:this.width+i+e,height:this.height+n+o})},t.prototype.shrink_by=function(h){var i=h.left,e=h.right,n=h.top,o=h.bottom;return new t({width:w(this.width-i-e,0),height:w(this.height-n-o,0)})},t.prototype.map=function(h,i){return new t({width:h(this.width),height:(null!=i?i:h)(this.height)})},t}();i.Sizeable=d,d.__name__="Sizeable",i.SizingPolicy=o.Enum("fixed","fit","min","max")},
function _(i,t,e,h,n){h();var s=i(1),r=i(352),g=i(194),o=Math.min,a=Math.max,u=Math.round,l=function(){function i(){this._bbox=new g.BBox,this._inner_bbox=new g.BBox}return Object.defineProperty(i.prototype,"bbox",{get:function(){return this._bbox},enumerable:!1,configurable:!0}),Object.defineProperty(i.prototype,"inner_bbox",{get:function(){return this._inner_bbox},enumerable:!1,configurable:!0}),Object.defineProperty(i.prototype,"sizing",{get:function(){return this._sizing},enumerable:!1,configurable:!0}),i.prototype.set_sizing=function(i){var t,e,h,n,s,r=null!==(t=i.width_policy)&&void 0!==t?t:"fit",g=i.width,o=null!=i.min_width?i.min_width:0,a=null!=i.max_width?i.max_width:1/0,u=null!==(e=i.height_policy)&&void 0!==e?e:"fit",l=i.height,d=null!=i.min_height?i.min_height:0,_=null!=i.max_height?i.max_height:1/0,c=i.aspect,p=null!==(h=i.margin)&&void 0!==h?h:{top:0,right:0,bottom:0,left:0},w=!1!==i.visible,f=null!==(n=i.halign)&&void 0!==n?n:"start",b=null!==(s=i.valign)&&void 0!==s?s:"start";this._sizing={width_policy:r,min_width:o,width:g,max_width:a,height_policy:u,min_height:d,height:l,max_height:_,aspect:c,margin:p,visible:w,halign:f,valign:b,size:{width:g,height:l},min_size:{width:o,height:d},max_size:{width:a,height:_}},this._init()},i.prototype._init=function(){},i.prototype._set_geometry=function(i,t){this._bbox=i,this._inner_bbox=t},i.prototype.set_geometry=function(i,t){this._set_geometry(i,null!=t?t:i)},i.prototype.is_width_expanding=function(){return"max"==this.sizing.width_policy},i.prototype.is_height_expanding=function(){return"max"==this.sizing.height_policy},i.prototype.apply_aspect=function(i,t){var e=t.width,h=t.height,n=this.sizing.aspect;if(null!=n){var s=this.sizing,r=s.width_policy,g=s.height_policy;if("fixed"!=r&&"fixed"!=g)if(r==g){var o=e,a=u(e/n),l=u(h*n),d=h;Math.abs(i.width-o)+Math.abs(i.height-a)<=Math.abs(i.width-l)+Math.abs(i.height-d)?(e=o,h=a):(e=l,h=d)}else!function(i,t){var e={max:4,fit:3,min:2,fixed:1};return e[i]>e[t]}(r,g)?e=u(h*n):h=u(e/n);else"fixed"==r?h=u(e/n):"fixed"==g&&(e=u(h*n))}return{width:e,height:h}},i.prototype.measure=function(i){var t=this;if(!this.sizing.visible)return{width:0,height:0};var e=function(i){return"fixed"==t.sizing.width_policy&&null!=t.sizing.width?t.sizing.width:i},h=function(i){return"fixed"==t.sizing.height_policy&&null!=t.sizing.height?t.sizing.height:i},n=new r.Sizeable(i).shrink_by(this.sizing.margin).map(e,h),s=this._measure(n),g=this.clip_size(s),o=e(g.width),a=h(g.height),u=this.apply_aspect(n,{width:o,height:a});return Object.assign(Object.assign({},s),u)},i.prototype.compute=function(i){void 0===i&&(i={});var t=this.measure({width:null!=i.width&&this.is_width_expanding()?i.width:1/0,height:null!=i.height&&this.is_height_expanding()?i.height:1/0}),e=t.width,h=t.height,n=new g.BBox({left:0,top:0,width:e,height:h}),s=void 0;if(null!=t.inner){var r=t.inner,o=r.left,a=r.top,u=r.right,l=r.bottom;s=new g.BBox({left:o,top:a,right:e-u,bottom:h-l})}this.set_geometry(n,s)},Object.defineProperty(i.prototype,"xview",{get:function(){return this.bbox.xview},enumerable:!1,configurable:!0}),Object.defineProperty(i.prototype,"yview",{get:function(){return this.bbox.yview},enumerable:!1,configurable:!0}),i.prototype.clip_width=function(i){return a(this.sizing.min_width,o(i,this.sizing.max_width))},i.prototype.clip_height=function(i){return a(this.sizing.min_height,o(i,this.sizing.max_height))},i.prototype.clip_size=function(i){var t=i.width,e=i.height;return{width:this.clip_width(t),height:this.clip_height(e)}},i}();e.Layoutable=l,l.__name__="Layoutable";var d=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return s.__extends(t,i),t.prototype._measure=function(i){var t,e,h=this.sizing,n=h.width_policy,s=h.height_policy;if(i.width==1/0)t=null!=this.sizing.width?this.sizing.width:0;else switch(n){case"fixed":t=null!=this.sizing.width?this.sizing.width:0;break;case"min":t=null!=this.sizing.width?o(i.width,this.sizing.width):0;break;case"fit":t=null!=this.sizing.width?o(i.width,this.sizing.width):i.width;break;case"max":t=null!=this.sizing.width?a(i.width,this.sizing.width):i.width}if(i.height==1/0)e=null!=this.sizing.height?this.sizing.height:0;else switch(s){case"fixed":e=null!=this.sizing.height?this.sizing.height:0;break;case"min":e=null!=this.sizing.height?o(i.height,this.sizing.height):0;break;case"fit":e=null!=this.sizing.height?o(i.height,this.sizing.height):i.height;break;case"max":e=null!=this.sizing.height?a(i.height,this.sizing.height):i.height}return{width:t,height:e}},t}(l);e.LayoutItem=d,d.__name__="LayoutItem";var _=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return s.__extends(t,i),t.prototype._measure=function(i){var t=this,e=this._content_size(),h=i.bounded_to(this.sizing.size).bounded_to(e);return{width:function(){switch(t.sizing.width_policy){case"fixed":return null!=t.sizing.width?t.sizing.width:e.width;case"min":return e.width;case"fit":return h.width;case"max":return Math.max(e.width,h.width)}}(),height:function(){switch(t.sizing.height_policy){case"fixed":return null!=t.sizing.height?t.sizing.height:e.height;case"min":return e.height;case"fit":return h.height;case"max":return Math.max(e.height,h.height)}}()}},t}(l);e.ContentLayoutable=_,_.__name__="ContentLayoutable"},
function _(t,e,r,n,o){n();var a=t(1),h=t(353),i=t(194),l=function(t){function e(){var e=t.apply(this,a.__spread(arguments))||this;return e.children=[],e}return a.__extends(e,t),e}(h.Layoutable);r.Stack=l,l.__name__="Stack";var c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),e.prototype._measure=function(t){var e,r,n=0,o=0;try{for(var h=a.__values(this.children),i=h.next();!i.done;i=h.next()){var l=i.value.measure({width:0,height:0});n+=l.width,o=Math.max(o,l.height)}}catch(t){e={error:t}}finally{try{i&&!i.done&&(r=h.return)&&r.call(h)}finally{if(e)throw e.error}}return{width:n,height:o}},e.prototype._set_geometry=function(e,r){var n,o;t.prototype._set_geometry.call(this,e,r);var h=e.top,l=e.bottom,c=e.left;try{for(var _=a.__values(this.children),u=_.next();!u.done;u=_.next()){var s=u.value,y=s.measure({width:0,height:0}).width;s.set_geometry(new i.BBox({left:c,width:y,top:h,bottom:l})),c+=y}}catch(t){n={error:t}}finally{try{u&&!u.done&&(o=_.return)&&o.call(_)}finally{if(n)throw n.error}}},e}(l);r.HStack=c,c.__name__="HStack";var _=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),e.prototype._measure=function(t){var e,r,n=0,o=0;try{for(var h=a.__values(this.children),i=h.next();!i.done;i=h.next()){var l=i.value.measure({width:0,height:0});n=Math.max(n,l.width),o+=l.height}}catch(t){e={error:t}}finally{try{i&&!i.done&&(r=h.return)&&r.call(h)}finally{if(e)throw e.error}}return{width:n,height:o}},e.prototype._set_geometry=function(e,r){var n,o;t.prototype._set_geometry.call(this,e,r);var h=e.left,l=e.right,c=e.top;try{for(var _=a.__values(this.children),u=_.next();!u.done;u=_.next()){var s=u.value,y=s.measure({width:0,height:0}).height;s.set_geometry(new i.BBox({top:c,height:y,left:h,right:l})),c+=y}}catch(t){n={error:t}}finally{try{u&&!u.done&&(o=_.return)&&o.call(_)}finally{if(n)throw n.error}}},e}(l);r.VStack=_,_.__name__="VStack";var u=function(t){function e(){var e=t.apply(this,a.__spread(arguments))||this;return e.children=[],e}return a.__extends(e,t),e.prototype._measure=function(t){var e,r,n=0,o=0;try{for(var h=a.__values(this.children),i=h.next();!i.done;i=h.next()){var l=i.value.layout.measure(t);n=Math.max(n,l.width),o=Math.max(o,l.height)}}catch(t){e={error:t}}finally{try{i&&!i.done&&(r=h.return)&&r.call(h)}finally{if(e)throw e.error}}return{width:n,height:o}},e.prototype._set_geometry=function(e,r){var n,o;t.prototype._set_geometry.call(this,e,r);try{for(var h=a.__values(this.children),l=h.next();!l.done;l=h.next()){var c=l.value,_=c.layout,u=c.anchor,s=c.margin,y=e.left,f=e.right,d=e.top,v=e.bottom,g=e.hcenter,w=e.vcenter,p=_.measure(e),m=p.width,x=p.height,B=void 0;switch(u){case"top_left":B=new i.BBox({left:y+s,top:d+s,width:m,height:x});break;case"top_center":B=new i.BBox({hcenter:g,top:d+s,width:m,height:x});break;case"top_right":B=new i.BBox({right:f-s,top:d+s,width:m,height:x});break;case"bottom_right":B=new i.BBox({right:f-s,bottom:v-s,width:m,height:x});break;case"bottom_center":B=new i.BBox({hcenter:g,bottom:v-s,width:m,height:x});break;case"bottom_left":B=new i.BBox({left:y+s,bottom:v-s,width:m,height:x});break;case"center_left":B=new i.BBox({left:y+s,vcenter:w,width:m,height:x});break;case"center":B=new i.BBox({hcenter:g,vcenter:w,width:m,height:x});break;case"center_right":B=new i.BBox({right:f-s,vcenter:w,width:m,height:x})}_.set_geometry(B)}}catch(t){n={error:t}}finally{try{l&&!l.done&&(o=h.return)&&o.call(h)}finally{if(n)throw n.error}}},e}(h.Layoutable);r.AnchorLayout=u,u.__name__="AnchorLayout"},
function _(t,i,r,e,n){e();var o=t(1),a=t(352),s=t(353),l=t(123),h=t(194),c=t(124),u=Math.max,f=Math.round,p=function(){function t(t){this.def=t,this._map=new Map}return t.prototype.get=function(t){var i=this._map.get(t);return void 0===i&&(i=this.def(),this._map.set(t,i)),i},t.prototype.apply=function(t,i){var r=this.get(t);this._map.set(t,i(r))},t}();p.__name__="DefaultMap";var _=function(){function t(){this._items=[],this._nrows=0,this._ncols=0}return Object.defineProperty(t.prototype,"nrows",{get:function(){return this._nrows},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"ncols",{get:function(){return this._ncols},enumerable:!1,configurable:!0}),t.prototype.add=function(t,i){var r=t.r1,e=t.c1;this._nrows=u(this._nrows,r+1),this._ncols=u(this._ncols,e+1),this._items.push({span:t,data:i})},t.prototype.at=function(t,i){return this._items.filter((function(r){var e=r.span;return e.r0<=t&&t<=e.r1&&e.c0<=i&&i<=e.c1})).map((function(t){return t.data}))},t.prototype.row=function(t){return this._items.filter((function(i){var r=i.span;return r.r0<=t&&t<=r.r1})).map((function(t){return t.data}))},t.prototype.col=function(t){return this._items.filter((function(i){var r=i.span;return r.c0<=t&&t<=r.c1})).map((function(t){return t.data}))},t.prototype.foreach=function(t){var i,r;try{for(var e=o.__values(this._items),n=e.next();!n.done;n=e.next()){var a=n.value;t(a.span,a.data)}}catch(t){i={error:t}}finally{try{n&&!n.done&&(r=e.return)&&r.call(e)}finally{if(i)throw i.error}}},t.prototype.map=function(i){var r,e,n=new t;try{for(var a=o.__values(this._items),s=a.next();!s.done;s=a.next()){var l=s.value,h=l.span,c=l.data;n.add(h,i(h,c))}}catch(t){r={error:t}}finally{try{s&&!s.done&&(e=a.return)&&e.call(a)}finally{if(r)throw r.error}}return n},t}();_.__name__="Container";var g=function(t){function i(i){void 0===i&&(i=[]);var r=t.call(this)||this;return r.items=i,r.rows="auto",r.cols="auto",r.spacing=0,r.absolute=!1,r}return o.__extends(i,t),i.prototype.is_width_expanding=function(){if(t.prototype.is_width_expanding.call(this))return!0;if("fixed"==this.sizing.width_policy)return!1;var i=this._state.cols;return c.some(i,(function(t){return"max"==t.policy}))},i.prototype.is_height_expanding=function(){if(t.prototype.is_height_expanding.call(this))return!0;if("fixed"==this.sizing.height_policy)return!1;var i=this._state.rows;return c.some(i,(function(t){return"max"==t.policy}))},i.prototype._init=function(){var i,r,e,n,a,s,h=this;t.prototype._init.call(this);var u=new _;try{for(var f=o.__values(this.items),p=f.next();!p.done;p=f.next()){var g=p.value,d=g.layout,y=g.row,w=g.col,v=g.row_span,m=g.col_span;if(d.sizing.visible){var x=y,b=w,z=y+(null!=v?v:1)-1,j=w+(null!=m?m:1)-1;u.add({r0:x,c0:b,r1:z,c1:j},d)}}}catch(t){i={error:t}}finally{try{p&&!p.done&&(r=f.return)&&r.call(f)}finally{if(i)throw i.error}}for(var O=u.nrows,B=u.ncols,A=new Array(O),M=function(t){var i=function(){var i,r=l.isPlainObject(h.rows)?null!==(i=h.rows[t])&&void 0!==i?i:h.rows["*"]:h.rows;return null==r?{policy:"auto"}:l.isNumber(r)?{policy:"fixed",height:r}:l.isString(r)?{policy:r}:r}(),r=null!==(e=i.align)&&void 0!==e?e:"auto";if("fixed"==i.policy)A[t]={policy:"fixed",height:i.height,align:r};else if("min"==i.policy)A[t]={policy:"min",align:r};else if("fit"==i.policy||"max"==i.policy)A[t]={policy:i.policy,flex:null!==(n=i.flex)&&void 0!==n?n:1,align:r};else{if("auto"!=i.policy)throw new Error("unrechable");c.some(u.row(t),(function(t){return t.is_height_expanding()}))?A[t]={policy:"max",flex:1,align:r}:A[t]={policy:"min",align:r}}},P=0;P<O;P++)M(P);for(var C=new Array(B),N=function(t){var i=function(){var i,r=l.isPlainObject(h.cols)?null!==(i=h.cols[t])&&void 0!==i?i:h.cols["*"]:h.cols;return null==r?{policy:"auto"}:l.isNumber(r)?{policy:"fixed",width:r}:l.isString(r)?{policy:r}:r}(),r=null!==(a=i.align)&&void 0!==a?a:"auto";if("fixed"==i.policy)C[t]={policy:"fixed",width:i.width,align:r};else if("min"==i.policy)C[t]={policy:"min",align:r};else if("fit"==i.policy||"max"==i.policy)C[t]={policy:i.policy,flex:null!==(s=i.flex)&&void 0!==s?s:1,align:r};else{if("auto"!=i.policy)throw new Error("unrechable");c.some(u.col(t),(function(t){return t.is_width_expanding()}))?C[t]={policy:"max",flex:1,align:r}:C[t]={policy:"min",align:r}}},S=0;S<B;S++)N(S);var E=o.__read(l.isNumber(this.spacing)?[this.spacing,this.spacing]:this.spacing,2),G=E[0],R=E[1];this._state={items:u,nrows:O,ncols:B,rows:A,cols:C,rspacing:G,cspacing:R}},i.prototype._measure_totals=function(t,i){var r=this._state,e=r.nrows,n=r.ncols,o=r.rspacing,a=r.cspacing;return{height:c.sum(t)+(e-1)*o,width:c.sum(i)+(n-1)*a}},i.prototype._measure_cells=function(t){for(var i=this._state,r=i.items,e=i.nrows,n=i.ncols,s=i.rows,l=i.cols,h=i.rspacing,c=i.cspacing,p=new Array(e),g=0;g<e;g++){var d=s[g];p[g]="fixed"==d.policy?d.height:0}for(var y=new Array(n),w=0;w<n;w++){var v=l[w];y[w]="fixed"==v.policy?v.width:0}var m=new _;return r.foreach((function(i,r){for(var e,n,_,g,d=i.r0,w=i.c0,v=i.r1,x=i.c1,b=(v-d)*h,z=(x-w)*c,j=0,O=d;O<=v;O++)j+=t(O,w).height;j+=b;for(var B=0,A=w;A<=x;A++)B+=t(d,A).width;B+=z;var M=r.measure({width:B,height:j});m.add(i,{layout:r,size_hint:M});var P=new a.Sizeable(M).grow_by(r.sizing.margin);P.height-=b,P.width-=z;var C=[];for(O=d;O<=v;O++){var N=s[O];"fixed"==N.policy?P.height-=N.height:C.push(O)}if(P.height>0){var S=f(P.height/C.length);try{for(var E=o.__values(C),G=E.next();!G.done;G=E.next()){O=G.value;p[O]=u(p[O],S)}}catch(t){e={error:t}}finally{try{G&&!G.done&&(n=E.return)&&n.call(E)}finally{if(e)throw e.error}}}var R=[];for(A=w;A<=x;A++){var D=l[A];"fixed"==D.policy?P.width-=D.width:R.push(A)}if(P.width>0){var L=f(P.width/R.length);try{for(var k=o.__values(R),q=k.next();!q.done;q=k.next()){A=q.value;y[A]=u(y[A],L)}}catch(t){_={error:t}}finally{try{q&&!q.done&&(g=k.return)&&g.call(k)}finally{if(_)throw _.error}}}})),{size:this._measure_totals(p,y),row_heights:p,col_widths:y,size_hints:m}},i.prototype._measure_grid=function(t){var i,r=this._state,e=r.nrows,n=r.ncols,o=r.rows,a=r.cols,s=r.rspacing,l=r.cspacing,h=this._measure_cells((function(t,i){var r=o[t],e=a[i];return{width:"fixed"==e.policy?e.width:1/0,height:"fixed"==r.policy?r.height:1/0}}));i="fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:t.height!=1/0&&this.is_height_expanding()?t.height:h.size.height;for(var c,p=0,_=0;_<e;_++){"fit"==(y=o[_]).policy||"max"==y.policy?p+=y.flex:i-=h.row_heights[_]}if(i-=(e-1)*s,0!=p&&i>0)for(_=0;_<e;_++){if("fit"==(y=o[_]).policy||"max"==y.policy)i-=w=f(i*(y.flex/p)),h.row_heights[_]=w,p-=y.flex}else if(i<0){var g=0;for(_=0;_<e;_++){"fixed"!=(y=o[_]).policy&&g++}var d=-i;for(_=0;_<e;_++){var y;if("fixed"!=(y=o[_]).policy){var w=h.row_heights[_],v=f(d/g);h.row_heights[_]=u(w-v,0),d-=v>w?w:v,g--}}}c="fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:t.width!=1/0&&this.is_width_expanding()?t.width:h.size.width;for(var m=0,x=0;x<n;x++){"fit"==(z=a[x]).policy||"max"==z.policy?m+=z.flex:c-=h.col_widths[x]}if(c-=(n-1)*l,0!=m&&c>0)for(x=0;x<n;x++){if("fit"==(z=a[x]).policy||"max"==z.policy)c-=j=f(c*(z.flex/m)),h.col_widths[x]=j,m-=z.flex}else if(c<0){for(g=0,x=0;x<n;x++){"fixed"!=(z=a[x]).policy&&g++}var b=-c;for(x=0;x<n;x++){var z;if("fixed"!=(z=a[x]).policy){var j=h.col_widths[x];v=f(b/g);h.col_widths[x]=u(j-v,0),b-=v>j?j:v,g--}}}var O=this._measure_cells((function(t,i){return{width:h.col_widths[i],height:h.row_heights[t]}})),B=O.row_heights,A=O.col_widths,M=O.size_hints;return{size:this._measure_totals(B,A),row_heights:B,col_widths:A,size_hints:M}},i.prototype._measure=function(t){return this._measure_grid(t).size},i.prototype._set_geometry=function(i,r){t.prototype._set_geometry.call(this,i,r);for(var e=this._state,n=e.nrows,o=e.ncols,a=e.rspacing,s=e.cspacing,l=this._measure_grid(i),c=l.row_heights,_=l.col_widths,g=l.size_hints,d=this._state.rows.map((function(t,i){return Object.assign(Object.assign({},t),{top:0,height:c[i],get bottom(){return this.top+this.height}})})),y=this._state.cols.map((function(t,i){return Object.assign(Object.assign({},t),{left:0,width:_[i],get right(){return this.left+this.width}})})),w=g.map((function(t,i){return Object.assign(Object.assign({},i),{outer:new h.BBox,inner:new h.BBox})})),v=0,m=this.absolute?i.top:0;v<n;v++){var x=d[v];x.top=m,m+=x.height+a}for(var b=0,z=this.absolute?i.left:0;b<o;b++){var j=y[b];j.left=z,z+=j.width+s}w.foreach((function(t,i){var r=t.r0,e=t.c0,n=t.r1,o=t.c1,l=i.layout,c=i.size_hint,u=l.sizing,p=c.width,_=c.height,g=function(t,i){for(var r=(i-t)*s,e=t;e<=i;e++)r+=y[e].width;return r}(e,o),w=function(t,i){for(var r=(i-t)*a,e=t;e<=i;e++)r+=d[e].height;return r}(r,n),v=e==o&&"auto"!=y[e].align?y[e].align:u.halign,m=r==n&&"auto"!=d[r].align?d[r].align:u.valign,x=y[e].left;"start"==v?x+=u.margin.left:"center"==v?x+=f((g-p)/2):"end"==v&&(x+=g-u.margin.right-p);var b=d[r].top;"start"==m?b+=u.margin.top:"center"==m?b+=f((w-_)/2):"end"==m&&(b+=w-u.margin.bottom-_),i.outer=new h.BBox({left:x,top:b,width:p,height:_})}));var O=d.map((function(){return{start:new p((function(){return 0})),end:new p((function(){return 0}))}})),B=y.map((function(){return{start:new p((function(){return 0})),end:new p((function(){return 0}))}}));w.foreach((function(t,i){var r=t.r0,e=t.c0,n=t.r1,o=t.c1,a=i.size_hint,s=i.outer,l=a.inner;null!=l&&(O[r].start.apply(s.top,(function(t){return u(t,l.top)})),O[n].end.apply(d[n].bottom-s.bottom,(function(t){return u(t,l.bottom)})),B[e].start.apply(s.left,(function(t){return u(t,l.left)})),B[o].end.apply(y[o].right-s.right,(function(t){return u(t,l.right)})))})),w.foreach((function(t,i){var r=t.r0,e=t.c0,n=t.r1,o=t.c1,a=i.size_hint,s=i.outer;function l(t){var i=t.left,r=t.right,e=t.top,n=t.bottom,o=s.width-i-r,a=s.height-e-n;return new h.BBox({left:i,top:e,width:o,height:a})}if(null!=a.inner){var c=l(a.inner);if(!1!==a.align){var u=O[r].start.get(s.top),f=O[n].end.get(d[n].bottom-s.bottom),p=B[e].start.get(s.left),_=B[o].end.get(y[o].right-s.right);try{c=l({top:u,bottom:f,left:p,right:_})}catch(t){}}i.inner=c}else i.inner=s})),w.foreach((function(t,i){var r=i.layout,e=i.outer,n=i.inner;r.set_geometry(e,n)}))},i}(s.Layoutable);r.Grid=g,g.__name__="Grid";var d=function(t){function i(i){var r=t.call(this)||this;return r.items=i.map((function(t,i){return{layout:t,row:0,col:i}})),r.rows="fit",r}return o.__extends(i,t),i}(g);r.Row=d,d.__name__="Row";var y=function(t){function i(i){var r=t.call(this)||this;return r.items=i.map((function(t,i){return{layout:t,row:i,col:0}})),r.cols="fit",r}return o.__extends(i,t),i}(g);r.Column=y,y.__name__="Column"},
function _(e,t,n,i,a){i();var r=e(1),o=e(353),c=e(352),_=e(187),u=function(e){function t(t){var n=e.call(this)||this;return n.content_size=_.unsized(t,(function(){return new c.Sizeable(_.size(t))})),n}return r.__extends(t,e),t.prototype._content_size=function(){return this.content_size},t}(o.ContentLayoutable);n.ContentBox=u,u.__name__="ContentBox";var s=function(e){function t(t){var n=e.call(this)||this;return n.el=t,n}return r.__extends(t,e),t.prototype._measure=function(e){var t=this,n=new c.Sizeable(e).bounded_to(this.sizing.size);return _.sized(this.el,n,(function(){var e=new c.Sizeable(_.content_size(t.el)),n=_.extents(t.el),i=n.border,a=n.padding;return e.grow_by(i).grow_by(a).map(Math.ceil)}))},t}(o.Layoutable);n.VariadicBox=s,s.__name__="VariadicBox";var h=function(e){function t(t){var n=e.call(this,t)||this;return n._cache=new Map,n}return r.__extends(t,e),t.prototype._measure=function(t){var n=t.width+","+t.height,i=this._cache.get(n);return null==i&&(i=e.prototype._measure.call(this,t),this._cache.set(n,i)),i},t.prototype.invalidate_cache=function(){this._cache.clear()},t}(s);n.CachedVariadicBox=h,h.__name__="CachedVariadicBox"},
function _(u,m,n,s,S){s(),S("Expression",u(358).Expression),S("Stack",u(359).Stack),S("CumSum",u(360).CumSum)},
function _(t,e,n,i,s){i();var r=t(1),c=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._connected=new Set,this._result=new Map},e.prototype.v_compute=function(t){var e=this;this._connected.has(t)||(this.connect(t.change,(function(){return e._result.delete(t)})),this.connect(t.patching,(function(){return e._result.delete(t)})),this.connect(t.streaming,(function(){return e._result.delete(t)})),this._connected.add(t));var n=this._result.get(t);return null==n&&(n=this._v_compute(t),this._result.set(t,n)),n},e}(t(196).Model);n.Expression=c,c.__name__="Expression"},
function _(t,n,r,e,i){e();var a=t(1),l=t(358),o=t(139),u=function(t){function n(n){return t.call(this,n)||this}return a.__extends(n,t),n.init_Stack=function(){this.define((function(t){var n=t.String;return{fields:[(0,t.Array)(n),[]]}}))},n.prototype._v_compute=function(t){var n,r,e,i=null!==(e=t.get_length())&&void 0!==e?e:0,l=new o.NumberArray(i);try{for(var u=a.__values(this.fields),c=u.next();!c.done;c=u.next()){var f=c.value,_=t.data[f];if(null!=_)for(var s=0,v=Math.min(i,_.length);s<v;s++)l[s]+=_[s]}}catch(t){n={error:t}}finally{try{c&&!c.done&&(r=u.return)&&r.call(u)}finally{if(n)throw n.error}}return l},n}(l.Expression);r.Stack=u,u.__name__="Stack",u.init_Stack()},
function _(n,t,e,i,u){i();var r=n(1),o=n(358),_=n(139),l=function(n){function t(t){return n.call(this,t)||this}return r.__extends(t,n),t.init_CumSum=function(){this.define((function(n){var t=n.Boolean;return{field:[n.String],include_zero:[t,!1]}}))},t.prototype._v_compute=function(n){var t,e=new _.NumberArray(null!==(t=n.get_length())&&void 0!==t?t:0),i=n.data[this.field],u=this.include_zero?1:0;e[0]=this.include_zero?0:i[0];for(var r=1;r<e.length;r++)e[r]=e[r-1]+i[r-u];return e},t}(o.Expression);e.CumSum=l,l.__name__="CumSum",l.init_CumSum()},
function _(e,t,l,r,i){r(),i("BooleanFilter",e(362).BooleanFilter),i("CustomJSFilter",e(363).CustomJSFilter),i("Filter",e(229).Filter),i("GroupFilter",e(364).GroupFilter),i("IndexFilter",e(365).IndexFilter)},
function _(n,e,t,o,l){o();var i=n(1),r=n(229),a=n(139),u=function(n){function e(e){return n.call(this,e)||this}return i.__extends(e,n),e.init_BooleanFilter=function(){this.define((function(n){var e=n.Boolean,t=n.Array;return{booleans:[(0,n.Nullable)(t(e)),null]}}))},e.prototype.compute_indices=function(n){var e=n.length,t=this.booleans;return null==t?a.Indices.all_set(e):a.Indices.from_booleans(e,t)},e}(r.Filter);t.BooleanFilter=u,u.__name__="BooleanFilter",u.init_BooleanFilter()},
function _(e,t,n,r,i){r();var o=e(1),s=e(229),u=e(139),a=e(128),c=e(123),l=e(144),f=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_CustomJSFilter=function(){this.define((function(e){var t=e.Unknown,n=e.String;return{args:[(0,e.Dict)(t),{}],code:[n,""]}}))},Object.defineProperty(t.prototype,"names",{get:function(){return a.keys(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"values",{get:function(){return a.values(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"func",{get:function(){var e=l.use_strict(this.code);return new(Function.bind.apply(Function,o.__spread([void 0],this.names,["source",e])))},enumerable:!1,configurable:!0}),t.prototype.compute_indices=function(e){var t=e.length,n=this.func.apply(this,o.__spread(this.values,[e]));if(null==n)return u.Indices.all_set(t);if(c.isArrayOf(n,c.isInteger))return u.Indices.from_indices(t,n);if(c.isArrayOf(n,c.isBoolean))return u.Indices.from_booleans(t,n);throw new Error("expect an array of integers or booleans, or null, got "+n)},t}(s.Filter);n.CustomJSFilter=f,f.__name__="CustomJSFilter",f.init_CustomJSFilter()},
function _(n,t,e,r,i){r();var u=n(1),o=n(229),c=n(139),l=n(134),s=function(n){function t(t){return n.call(this,t)||this}return u.__extends(t,n),t.init_GroupFilter=function(){this.define((function(n){var t=n.String;return{column_name:[t],group:[t]}}))},t.prototype.compute_indices=function(n){var t=n.get_column(this.column_name);if(null==t)return l.logger.warn(this+": groupby column '"+this.column_name+"' not found in the data source"),new c.Indices(n.length,1);for(var e=new c.Indices(n.length),r=0;r<e.size;r++)t[r]===this.group&&e.set(r);return e},t}(o.Filter);e.GroupFilter=s,s.__name__="GroupFilter",s.init_GroupFilter()},
function _(n,i,e,t,r){t();var l=n(1),c=n(229),u=n(139),d=function(n){function i(i){return n.call(this,i)||this}return l.__extends(i,n),i.init_IndexFilter=function(){this.define((function(n){var i=n.Int,e=n.Array;return{indices:[(0,n.Nullable)(e(i)),null]}}))},i.prototype.compute_indices=function(n){var i=n.length,e=this.indices;return null==e?u.Indices.all_set(i):u.Indices.from_indices(i,e)},i}(c.Filter);e.IndexFilter=d,d.__name__="IndexFilter",d.init_IndexFilter()},
function _(t,r,a,e,c){e(),c("BasicTickFormatter",t(250).BasicTickFormatter),c("CategoricalTickFormatter",t(320).CategoricalTickFormatter),c("DatetimeTickFormatter",t(324).DatetimeTickFormatter),c("FuncTickFormatter",t(367).FuncTickFormatter),c("LogTickFormatter",t(337).LogTickFormatter),c("MercatorTickFormatter",t(340).MercatorTickFormatter),c("NumeralTickFormatter",t(368).NumeralTickFormatter),c("PrintfTickFormatter",t(369).PrintfTickFormatter),c("TickFormatter",t(247).TickFormatter)},
function _(t,n,e,r,i){r();var o=t(1),c=t(247),u=t(128),a=t(144),s=function(t){function n(n){return t.call(this,n)||this}return o.__extends(n,t),n.init_FuncTickFormatter=function(){this.define((function(t){var n=t.Unknown,e=t.String;return{args:[(0,t.Dict)(n),{}],code:[e,""]}}))},Object.defineProperty(n.prototype,"names",{get:function(){return u.keys(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"values",{get:function(){return u.values(this.args)},enumerable:!1,configurable:!0}),n.prototype._make_func=function(){var t=a.use_strict(this.code);return new(Function.bind.apply(Function,o.__spread([void 0,"tick","index","ticks"],this.names,[t])))},n.prototype.doFormat=function(t,n){var e=this,r=this._make_func().bind({});return t.map((function(t,n,i){return r.apply(void 0,o.__spread([t,n,i],e.values))}))},n}(c.TickFormatter);e.FuncTickFormatter=s,s.__name__="FuncTickFormatter",s.init_FuncTickFormatter()},
function _(r,n,t,e,o){e();var a=r(1),i=a.__importStar(r(327)),u=r(247),c=r(135),f=function(r){function n(n){return r.call(this,n)||this}return a.__extends(n,r),n.init_NumeralTickFormatter=function(){this.define((function(r){var n=r.String;return{format:[n,"0,0"],language:[n,"en"],rounding:[c.RoundingFunction,"round"]}}))},Object.defineProperty(n.prototype,"_rounding_fn",{get:function(){switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}},enumerable:!1,configurable:!0}),n.prototype.doFormat=function(r,n){var t=this,e=t.format,o=t.language,a=t._rounding_fn;return r.map((function(r){return i.format(r,e,o,a)}))},n}(u.TickFormatter);t.NumeralTickFormatter=f,f.__name__="NumeralTickFormatter",f.init_NumeralTickFormatter()},
function _(t,r,n,i,o){i();var e=t(1),f=t(247),a=t(326),c=function(t){function r(r){return t.call(this,r)||this}return e.__extends(r,t),r.init_PrintfTickFormatter=function(){this.define((function(t){return{format:[t.String,"%s"]}}))},r.prototype.doFormat=function(t,r){var n=this;return t.map((function(t){return a.sprintf(n.format,t)}))},r}(f.TickFormatter);n.PrintfTickFormatter=c,c.__name__="PrintfTickFormatter",c.init_PrintfTickFormatter()},
function _(e,a,l,t,i){t(),i("AnnularWedge",e(371).AnnularWedge),i("Annulus",e(372).Annulus),i("Arc",e(373).Arc),i("Bezier",e(374).Bezier),i("Circle",e(375).Circle),i("CenterRotatable",e(379).CenterRotatable),i("Ellipse",e(380).Ellipse),i("EllipseOval",e(381).EllipseOval),i("Glyph",e(203).Glyph),i("HArea",e(225).HArea),i("HBar",e(382).HBar),i("HexTile",e(384).HexTile),i("Image",e(385).Image),i("ImageRGBA",e(387).ImageRGBA),i("ImageURL",e(388).ImageURL),i("Line",e(212).Line),i("MultiLine",e(234).MultiLine),i("MultiPolygons",e(390).MultiPolygons),i("Oval",e(391).Oval),i("Patch",e(224).Patch),i("Patches",e(235).Patches),i("Quad",e(392).Quad),i("Quadratic",e(393).Quadratic),i("Ray",e(394).Ray),i("Rect",e(395).Rect),i("Segment",e(396).Segment),i("Step",e(397).Step),i("Text",e(398).Text),i("VArea",e(227).VArea),i("VBar",e(399).VBar),i("Wedge",e(400).Wedge),i("XYGlyph",e(213).XYGlyph)},
function _(e,t,r,i,s){i();var n=e(1),a=e(213),_=e(214),o=e(143),l=e(139),u=e(135),h=n.__importStar(e(133)),d=e(125),c=e(202),p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype._map_data=function(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius,this._angle=new l.NumberArray(this._start_angle.length);for(var e=0,t=this._start_angle.length;e<t;e++)this._angle[e]=this._end_angle[e]-this._start_angle[e]},t.prototype._render=function(e,t,r){var i,s,a=r.sx,_=r.sy,o=r._start_angle,l=r._angle,u=r.sinner_radius,h=r.souter_radius,d="anticlock"==this.model.direction;try{for(var c=n.__values(t),p=c.next();!p.done;p=c.next()){var v=p.value;isNaN(a[v]+_[v]+u[v]+h[v]+o[v]+l[v])||(e.translate(a[v],_[v]),e.rotate(o[v]),e.beginPath(),e.moveTo(h[v],0),e.arc(0,0,h[v],0,l[v],d),e.rotate(l[v]),e.lineTo(u[v],0),e.arc(0,0,u[v],0,-l[v],!d),e.closePath(),e.rotate(-l[v]-o[v]),e.translate(-a[v],-_[v]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,v),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,v),e.stroke()))}}catch(e){i={error:e}}finally{try{p&&!p.done&&(s=c.return)&&s.call(c)}finally{if(i)throw i.error}}},t.prototype._hit_point=function(e){var t,r,i,s,a,_,o,l,u,h,p=e.sx,v=e.sy,x=this.renderer.xscale.invert(p),y=this.renderer.yscale.invert(v);if("data"==this.model.properties.outer_radius.units)o=x-this.max_outer_radius,u=x+this.max_outer_radius,l=y-this.max_outer_radius,h=y+this.max_outer_radius;else{var f=p-this.max_outer_radius,g=p+this.max_outer_radius;o=(t=n.__read(this.renderer.xscale.r_invert(f,g),2))[0],u=t[1];var m=v-this.max_outer_radius,w=v+this.max_outer_radius;l=(r=n.__read(this.renderer.yscale.r_invert(m,w),2))[0],h=r[1]}var A=[];try{for(var M=n.__values(this.index.indices({x0:o,x1:u,y0:l,y1:h})),S=M.next();!S.done;S=M.next()){var W=S.value,V=Math.pow(this.souter_radius[W],2),k=Math.pow(this.sinner_radius[W],2),b=n.__read(this.renderer.xscale.r_compute(x,this._x[W]),2),D=(f=b[0],g=b[1],n.__read(this.renderer.yscale.r_compute(y,this._y[W]),2)),N=(m=D[0],w=D[1],Math.pow(f-g,2)+Math.pow(m-w,2));N<=V&&N>=k&&A.push(W)}}catch(e){i={error:e}}finally{try{S&&!S.done&&(s=M.return)&&s.call(M)}finally{if(i)throw i.error}}var z="anticlock"==this.model.direction,G=[];try{for(var P=n.__values(A),T=P.next();!T.done;T=P.next()){W=T.value;var X=Math.atan2(v-this.sy[W],p-this.sx[W]);d.angle_between(-X,-this._start_angle[W],-this._end_angle[W],z)&&G.push(W)}}catch(e){a={error:e}}finally{try{T&&!T.done&&(_=P.return)&&_.call(P)}finally{if(a)throw a.error}}return new c.Selection({indices:G})},t.prototype.draw_legend_for_index=function(e,t,r){_.generic_area_legend(this.visuals,e,t,r)},t.prototype.scenterxy=function(e){var t=(this.sinner_radius[e]+this.souter_radius[e])/2,r=(this._start_angle[e]+this._end_angle[e])/2;return[this.sx[e]+t*Math.cos(r),this.sy[e]+t*Math.sin(r)]},t}(a.XYGlyphView);r.AnnularWedgeView=p,p.__name__="AnnularWedgeView";var v=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_AnnularWedge=function(){this.prototype.default_view=p,this.mixins([o.LineVector,o.FillVector]),this.define((function(e){return{direction:[u.Direction,"anticlock"],inner_radius:[h.DistanceSpec],outer_radius:[h.DistanceSpec],start_angle:[h.AngleSpec],end_angle:[h.AngleSpec]}}))},t}(a.XYGlyph);r.AnnularWedge=v,v.__name__="AnnularWedge",v.init_AnnularWedge()},
function _(r,e,t,i,s){i();var a=r(1),n=r(213),u=r(143),_=a.__importStar(r(133)),o=r(147),h=r(202),d=function(r){function e(){return null!==r&&r.apply(this,arguments)||this}return a.__extends(e,r),e.prototype._map_data=function(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius},e.prototype._render=function(r,e,t){var i,s,n,u,_=t.sx,h=t.sy,d=t.sinner_radius,l=t.souter_radius;try{for(var c=a.__values(e),v=c.next();!v.done;v=c.next()){var y=v.value;if(!isNaN(_[y]+h[y]+d[y]+l[y])){if(this.visuals.fill.doit){if(this.visuals.fill.set_vectorize(r,y),r.beginPath(),o.is_ie)try{for(var x=(n=void 0,a.__values([!1,!0])),f=x.next();!f.done;f=x.next()){var p=f.value;r.arc(_[y],h[y],d[y],0,Math.PI,p),r.arc(_[y],h[y],l[y],Math.PI,0,!p)}}catch(r){n={error:r}}finally{try{f&&!f.done&&(u=x.return)&&u.call(x)}finally{if(n)throw n.error}}else r.arc(_[y],h[y],d[y],0,2*Math.PI,!0),r.arc(_[y],h[y],l[y],2*Math.PI,0,!1);r.fill()}this.visuals.line.doit&&(this.visuals.line.set_vectorize(r,y),r.beginPath(),r.arc(_[y],h[y],d[y],0,2*Math.PI),r.moveTo(_[y]+l[y],h[y]),r.arc(_[y],h[y],l[y],0,2*Math.PI),r.stroke())}}}catch(r){i={error:r}}finally{try{v&&!v.done&&(s=c.return)&&s.call(c)}finally{if(i)throw i.error}}},e.prototype._hit_point=function(r){var e,t,i,s,n,u,_,o,d=r.sx,l=r.sy,c=this.renderer.xscale.invert(d),v=this.renderer.yscale.invert(l);if("data"==this.model.properties.outer_radius.units)n=c-this.max_outer_radius,_=c+this.max_outer_radius,u=v-this.max_outer_radius,o=v+this.max_outer_radius;else{var y=d-this.max_outer_radius,x=d+this.max_outer_radius;n=(e=a.__read(this.renderer.xscale.r_invert(y,x),2))[0],_=e[1];var f=l-this.max_outer_radius,p=l+this.max_outer_radius;u=(t=a.__read(this.renderer.yscale.r_invert(f,p),2))[0],o=t[1]}var m=[];try{for(var w=a.__values(this.index.indices({x0:n,x1:_,y0:u,y1:o})),M=w.next();!M.done;M=w.next()){var A=M.value,P=Math.pow(this.souter_radius[A],2),I=Math.pow(this.sinner_radius[A],2),V=a.__read(this.renderer.xscale.r_compute(c,this._x[A]),2),b=(y=V[0],x=V[1],a.__read(this.renderer.yscale.r_compute(v,this._y[A]),2)),S=(f=b[0],p=b[1],Math.pow(y-x,2)+Math.pow(f-p,2));S<=P&&S>=I&&m.push(A)}}catch(r){i={error:r}}finally{try{M&&!M.done&&(s=w.return)&&s.call(w)}finally{if(i)throw i.error}}return new h.Selection({indices:m})},e.prototype.draw_legend_for_index=function(r,e,t){var i=e.x0,s=e.y0,a=e.x1,n=e.y1,u=t+1,_=new Array(u);_[t]=(i+a)/2;var o=new Array(u);o[t]=(s+n)/2;var h=.5*Math.min(Math.abs(a-i),Math.abs(n-s)),d=new Array(u);d[t]=.4*h;var l=new Array(u);l[t]=.8*h,this._render(r,[t],{sx:_,sy:o,sinner_radius:d,souter_radius:l})},e}(n.XYGlyphView);t.AnnulusView=d,d.__name__="AnnulusView";var l=function(r){function e(e){return r.call(this,e)||this}return a.__extends(e,r),e.init_Annulus=function(){this.prototype.default_view=d,this.mixins([u.LineVector,u.FillVector]),this.define((function(r){return{inner_radius:[_.DistanceSpec],outer_radius:[_.DistanceSpec]}}))},e}(n.XYGlyph);t.Annulus=l,l.__name__="Annulus",l.init_Annulus()},
function _(i,t,e,n,r){n();var s=i(1),a=i(213),o=i(214),_=i(143),c=i(135),l=s.__importStar(i(133)),u=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return s.__extends(t,i),t.prototype._map_data=function(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius},t.prototype._render=function(i,t,e){var n,r,a=e.sx,o=e.sy,_=e.sradius,c=e._start_angle,l=e._end_angle;if(this.visuals.line.doit){var u="anticlock"==this.model.direction;try{for(var d=s.__values(t),h=d.next();!h.done;h=d.next()){var p=h.value;isNaN(a[p]+o[p]+_[p]+c[p]+l[p])||(i.beginPath(),i.arc(a[p],o[p],_[p],c[p],l[p],u),this.visuals.line.set_vectorize(i,p),i.stroke())}}catch(i){n={error:i}}finally{try{h&&!h.done&&(r=d.return)&&r.call(d)}finally{if(n)throw n.error}}}},t.prototype.draw_legend_for_index=function(i,t,e){o.generic_line_legend(this.visuals,i,t,e)},t}(a.XYGlyphView);e.ArcView=u,u.__name__="ArcView";var d=function(i){function t(t){return i.call(this,t)||this}return s.__extends(t,i),t.init_Arc=function(){this.prototype.default_view=u,this.mixins(_.LineVector),this.define((function(i){return{direction:[c.Direction,"anticlock"],radius:[l.DistanceSpec],start_angle:[l.AngleSpec],end_angle:[l.AngleSpec]}}))},t}(a.XYGlyph);e.Arc=d,d.__name__="Arc",d.init_Arc()},
function _(e,t,i,r,n){r();var a=e(1),s=e(143),o=e(203),_=e(214),c=e(152),h=a.__importStar(e(133));function p(e,t,i,r,n,s,o,_){for(var c=[],h=[[],[]],p=0;p<=2;p++){var d=void 0,y=void 0,l=void 0;if(0===p?(y=6*e-12*i+6*n,d=-3*e+9*i-9*n+3*o,l=3*i-3*e):(y=6*t-12*r+6*s,d=-3*t+9*r-9*s+3*_,l=3*r-3*t),Math.abs(d)<1e-12){if(Math.abs(y)<1e-12)continue;0<(z=-l/y)&&z<1&&c.push(z)}else{var f=y*y-4*l*d,x=Math.sqrt(f);if(!(f<0)){var u=(-y+x)/(2*d);0<u&&u<1&&c.push(u);var v=(-y-x)/(2*d);0<v&&v<1&&c.push(v)}}}for(var m=c.length,M=m;m--;){var z,C=1-(z=c[m]),S=C*C*C*e+3*C*C*z*i+3*C*z*z*n+z*z*z*o;h[0][m]=S;var w=C*C*C*t+3*C*C*z*r+3*C*z*z*s+z*z*z*_;h[1][m]=w}return h[0][M]=e,h[1][M]=t,h[0][M+1]=o,h[1][M+1]=_,[Math.min.apply(Math,a.__spread(h[0])),Math.max.apply(Math,a.__spread(h[1])),Math.max.apply(Math,a.__spread(h[0])),Math.min.apply(Math,a.__spread(h[1]))]}var d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(t,e),t.prototype._project_data=function(){c.inplace.project_xy(this._x0,this._y0),c.inplace.project_xy(this._x1,this._y1)},t.prototype._index_data=function(e){for(var t=this.data_size,i=0;i<t;i++)if(isNaN(this._x0[i]+this._x1[i]+this._y0[i]+this._y1[i]+this._cx0[i]+this._cy0[i]+this._cx1[i]+this._cy1[i]))e.add_empty();else{var r=a.__read(p(this._x0[i],this._y0[i],this._x1[i],this._y1[i],this._cx0[i],this._cy0[i],this._cx1[i],this._cy1[i]),4),n=r[0],s=r[1],o=r[2],_=r[3];e.add(n,s,o,_)}},t.prototype._render=function(e,t,i){var r,n,s=i.sx0,o=i.sy0,_=i.sx1,c=i.sy1,h=i.scx0,p=i.scy0,d=i.scx1,y=i.scy1;if(this.visuals.line.doit)try{for(var l=a.__values(t),f=l.next();!f.done;f=l.next()){var x=f.value;isNaN(s[x]+o[x]+_[x]+c[x]+h[x]+p[x]+d[x]+y[x])||(e.beginPath(),e.moveTo(s[x],o[x]),e.bezierCurveTo(h[x],p[x],d[x],y[x],_[x],c[x]),this.visuals.line.set_vectorize(e,x),e.stroke())}}catch(e){r={error:e}}finally{try{f&&!f.done&&(n=l.return)&&n.call(l)}finally{if(r)throw r.error}}},t.prototype.draw_legend_for_index=function(e,t,i){_.generic_line_legend(this.visuals,e,t,i)},t.prototype.scenterxy=function(){throw new Error(this+".scenterxy() is not implemented")},t}(o.GlyphView);i.BezierView=d,d.__name__="BezierView";var y=function(e){function t(t){return e.call(this,t)||this}return a.__extends(t,e),t.init_Bezier=function(){this.prototype.default_view=d,this.define((function(e){return{x0:[h.XCoordinateSpec,{field:"x0"}],y0:[h.YCoordinateSpec,{field:"y0"}],x1:[h.XCoordinateSpec,{field:"x1"}],y1:[h.YCoordinateSpec,{field:"y1"}],cx0:[h.XCoordinateSpec,{field:"cx0"}],cy0:[h.YCoordinateSpec,{field:"cy0"}],cx1:[h.XCoordinateSpec,{field:"cx1"}],cy1:[h.YCoordinateSpec,{field:"cy1"}]}})),this.mixins(s.LineVector)},t}(o.Glyph);i.Bezier=y,y.__name__="Bezier",y.init_Bezier()},
function _(i,e,r,s,t){s();var a=i(1),n=i(213),d=i(376),h=i(143),_=i(135),l=a.__importStar(i(215)),u=a.__importStar(i(133)),o=i(124),c=i(127),x=i(202),p=function(i){function e(){return null!==i&&i.apply(this,arguments)||this}return a.__extends(e,i),e.prototype.initialize=function(){i.prototype.initialize.call(this);var e=this.renderer.plot_view.canvas_view.webgl;null!=e&&(this.glglyph=new d.CircleGL(e.gl,this))},e.prototype._map_data=function(){if(null!=this._radius)if("data"==this.model.properties.radius.units)switch(this.model.radius_dimension){case"x":this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius);break;case"y":this.sradius=this.sdist(this.renderer.yscale,this._y,this._radius);break;case"max":var i=this.sdist(this.renderer.xscale,this._x,this._radius),e=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=c.map(i,(function(i,r){return Math.max(i,e[r])}));break;case"min":i=this.sdist(this.renderer.xscale,this._x,this._radius);var r=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=c.map(i,(function(i,e){return Math.min(i,r[e])}))}else this.sradius=this._radius,this.max_size=2*this.max_radius;else this.sradius=c.map(this._size,(function(i){return i/2}))},e.prototype._mask_data=function(){var i,e,r=this,s=this.renderer.plot_view.frame,t=s.x_target,a=s.y_target;return null!=this._radius&&"data"==this.model.properties.radius.units?(i=t.map((function(i){return r.renderer.xscale.invert(i)})).widen(this.max_radius),e=a.map((function(i){return r.renderer.yscale.invert(i)})).widen(this.max_radius)):(i=t.widen(this.max_size).map((function(i){return r.renderer.xscale.invert(i)})),e=a.widen(this.max_size).map((function(i){return r.renderer.yscale.invert(i)}))),this.index.indices({x0:i.start,x1:i.end,y0:e.start,y1:e.end})},e.prototype._render=function(i,e,r){var s,t,n=r.sx,d=r.sy,h=r.sradius;try{for(var _=a.__values(e),l=_.next();!l.done;l=_.next()){var u=l.value;isNaN(n[u]+d[u]+h[u])||(i.beginPath(),i.arc(n[u],d[u],h[u],0,2*Math.PI,!1),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(i,u),i.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,u),i.stroke()))}}catch(i){s={error:i}}finally{try{l&&!l.done&&(t=_.return)&&t.call(_)}finally{if(s)throw s.error}}},e.prototype._hit_point=function(i){var e,r,s,t,n,d,h,_,l,u,o=i.sx,c=i.sy,p=this.renderer.xscale.invert(o),y=this.renderer.yscale.invert(c);if(null!=this._radius&&"data"==this.model.properties.radius.units)h=p-this.max_radius,_=p+this.max_radius,l=y-this.max_radius,u=y+this.max_radius;else{var v=o-this.max_size,m=o+this.max_size;h=(e=a.__read(this.renderer.xscale.r_invert(v,m),2))[0],_=e[1];var f=c-this.max_size,w=c+this.max_size;l=(r=a.__read(this.renderer.yscale.r_invert(f,w),2))[0],u=r[1]}var z=this.index.indices({x0:h,x1:_,y0:l,y1:u}),g=[];if(null!=this._radius&&"data"==this.model.properties.radius.units)try{for(var M=a.__values(z),S=M.next();!S.done;S=M.next()){var b=S.value,C=Math.pow(this.sradius[b],2),k=a.__read(this.renderer.xscale.r_compute(p,this._x[b]),2),V=(v=k[0],m=k[1],a.__read(this.renderer.yscale.r_compute(y,this._y[b]),2));f=V[0],w=V[1];Math.pow(v-m,2)+Math.pow(f-w,2)<=C&&g.push(b)}}catch(i){s={error:i}}finally{try{S&&!S.done&&(t=M.return)&&t.call(M)}finally{if(s)throw s.error}}else try{for(var A=a.__values(z),D=A.next();!D.done;D=A.next()){b=D.value,C=Math.pow(this.sradius[b],2);Math.pow(this.sx[b]-o,2)+Math.pow(this.sy[b]-c,2)<=C&&g.push(b)}}catch(i){n={error:i}}finally{try{D&&!D.done&&(d=A.return)&&d.call(A)}finally{if(n)throw n.error}}return new x.Selection({indices:g})},e.prototype._hit_span=function(i){var e,r,s,t,n,d,h,_,l=i.sx,u=i.sy,o=this.bounds();if("h"==i.direction){var c=void 0,p=void 0;if(h=o.y0,_=o.y1,null!=this._radius&&"data"==this.model.properties.radius.units)c=l-this.max_radius,p=l+this.max_radius,n=(e=a.__read(this.renderer.xscale.r_invert(c,p),2))[0],d=e[1];else c=l-(y=this.max_size/2),p=l+y,n=(r=a.__read(this.renderer.xscale.r_invert(c,p),2))[0],d=r[1]}else{var y,v=void 0,m=void 0;if(n=o.x0,d=o.x1,null!=this._radius&&"data"==this.model.properties.radius.units)v=u-this.max_radius,m=u+this.max_radius,h=(s=a.__read(this.renderer.yscale.r_invert(v,m),2))[0],_=s[1];else v=u-(y=this.max_size/2),m=u+y,h=(t=a.__read(this.renderer.yscale.r_invert(v,m),2))[0],_=t[1]}var f=a.__spread(this.index.indices({x0:n,x1:d,y0:h,y1:_}));return new x.Selection({indices:f})},e.prototype._hit_rect=function(i){var e=i.sx0,r=i.sx1,s=i.sy0,t=i.sy1,n=a.__read(this.renderer.xscale.r_invert(e,r),2),d=n[0],h=n[1],_=a.__read(this.renderer.yscale.r_invert(s,t),2),l=_[0],u=_[1],o=a.__spread(this.index.indices({x0:d,x1:h,y0:l,y1:u}));return new x.Selection({indices:o})},e.prototype._hit_poly=function(i){for(var e=i.sx,r=i.sy,s=o.range(0,this.sx.length),t=[],a=0,n=s.length;a<n;a++){var d=s[a];l.point_in_poly(this.sx[a],this.sy[a],e,r)&&t.push(d)}return new x.Selection({indices:t})},e.prototype.draw_legend_for_index=function(i,e,r){var s=e.x0,t=e.y0,a=e.x1,n=e.y1,d=r+1,h=new Array(d);h[r]=(s+a)/2;var _=new Array(d);_[r]=(t+n)/2;var l=new Array(d);l[r]=.2*Math.min(Math.abs(a-s),Math.abs(n-t)),this._render(i,[r],{sx:h,sy:_,sradius:l})},e}(n.XYGlyphView);r.CircleView=p,p.__name__="CircleView";var y=function(i){function e(e){return i.call(this,e)||this}return a.__extends(e,i),e.init_Circle=function(){this.prototype.default_view=p,this.mixins([h.LineVector,h.FillVector]),this.define((function(i){return{angle:[u.AngleSpec,0],size:[u.ScreenDistanceSpec,{value:4}],radius:[u.DistanceSpec,void 0,{optional:!0}],radius_dimension:[_.RadiusDimension,"x"]}}))},e}(n.XYGlyph);r.Circle=y,y.__name__="Circle",y.init_Circle()},
function _(t,e,s,i,r){i();var a=t(1),o=t(217),_=t(221),l=t(377),h=t(378),n=t(375),u=t(127),f=t(134),g=t(137);function v(t,e,s,i,r,a){if(r.doit)if(r[a].is_value)e.used=!1,t.set_attribute(s,"float",[r[a].value()]);else{e.used=!0;var o=new Float32Array(r.get_array(a));e.set_size(4*i),e.set_data(0,o),t.set_attribute(s,"float",e)}else e.used=!1,t.set_attribute(s,"float",[0])}function d(t,e,s,i,r,a){var o=a+"_color",_=a+"_alpha";if(r.doit){e.used=!0;var l=void 0;if(r[o].is_value){var h=g.encode_rgba(g.color2rgba(r[o].value()));(u=new Uint32Array(i)).fill(h),l=u}else l=r.get_array(o);var n=void 0;if(r[_].is_value){var u;h=r[_].value();(u=new Float32Array(i)).fill(h),n=u}else n=r.get_array(_);for(var f=new Float32Array(4*i),v=0,d=i;v<d;v++){var b=g.decode_rgba(l[v]);1==b[3]&&(b[3]=n[v]),f.set(b,4*v)}e.set_size(4*i*4),e.set_data(0,f),t.set_attribute(s,"vec4",e)}else e.used=!1,t.set_attribute(s,"vec4",[0,0,0,0])}s.attach_float=v,s.attach_color=d;var b=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),e.prototype.init=function(){var t=this.gl,e=l.vertex_shader,s=h.fragment_shader(this._marker_code);this.prog=new o.Program(t),this.prog.set_shaders(e,s),this.vbo_sx=new o.VertexBuffer(t),this.prog.set_attribute("a_sx","float",this.vbo_sx),this.vbo_sy=new o.VertexBuffer(t),this.prog.set_attribute("a_sy","float",this.vbo_sy),this.vbo_s=new o.VertexBuffer(t),this.prog.set_attribute("a_size","float",this.vbo_s),this.vbo_a=new o.VertexBuffer(t),this.prog.set_attribute("a_angle","float",this.vbo_a),this.vbo_linewidth=new o.VertexBuffer(t),this.vbo_fg_color=new o.VertexBuffer(t),this.vbo_bg_color=new o.VertexBuffer(t),this.index_buffer=new o.IndexBuffer(t)},e.prototype.draw=function(t,e,s){var i=e.glglyph,r=i.nvertices;if(i.data_changed&&(i._set_data(r),this.glyph instanceof n.CircleView&&null!=this.glyph._radius&&this.vbo_s.set_data(0,u.map(this.glyph.sradius,(function(t){return 2*t}))),i.data_changed=!1),this.visuals_changed&&(this._set_visuals(r),this.visuals_changed=!1),this.prog.set_uniform("u_pixel_ratio","float",[s.pixel_ratio]),this.prog.set_uniform("u_canvas_size","vec2",[s.width,s.height]),this.prog.set_attribute("a_sx","float",i.vbo_sx),this.prog.set_attribute("a_sy","float",i.vbo_sy),this.prog.set_attribute("a_size","float",i.vbo_s),this.prog.set_attribute("a_angle","float",i.vbo_a),0!=t.length)if(t.length===r)this.prog.draw(this.gl.POINTS,[0,r]);else if(r<65535){var a=window.navigator.userAgent;a.indexOf("MSIE ")+a.indexOf("Trident/")+a.indexOf("Edge/")>0&&f.logger.warn("WebGL warning: IE is known to produce 1px sprites whith selections."),this.index_buffer.set_size(2*t.length),this.index_buffer.set_data(0,new Uint16Array(t)),this.prog.draw(this.gl.POINTS,this.index_buffer)}else{for(var o=64e3,_=[],l=0,h=Math.ceil(r/o);l<h;l++)_.push([]);for(l=0,h=t.length;l<h;l++){var g=t[l]%o;_[v=Math.floor(t[l]/o)].push(g)}var v=0;for(h=_.length;v<h;v++){var d=new Uint16Array(_[v]),b=v*o*4;0!==d.length&&(this.prog.set_attribute("a_sx","float",i.vbo_sx,0,b),this.prog.set_attribute("a_sy","float",i.vbo_sy,0,b),this.prog.set_attribute("a_size","float",i.vbo_s,0,b),this.prog.set_attribute("a_angle","float",i.vbo_a,0,b),this.vbo_linewidth.used&&this.prog.set_attribute("a_linewidth","float",this.vbo_linewidth,0,b),this.vbo_fg_color.used&&this.prog.set_attribute("a_fg_color","vec4",this.vbo_fg_color,0,4*b),this.vbo_bg_color.used&&this.prog.set_attribute("a_bg_color","vec4",this.vbo_bg_color,0,4*b),this.index_buffer.set_size(2*d.length),this.index_buffer.set_data(0,d),this.prog.draw(this.gl.POINTS,this.index_buffer))}}},e.prototype._set_data=function(t){var e=4*t;this.vbo_sx.set_size(e),this.vbo_sy.set_size(e),this.vbo_a.set_size(e),this.vbo_s.set_size(e),this.vbo_sx.set_data(0,this.glyph.sx),this.vbo_sy.set_data(0,this.glyph.sy),null!=this.glyph._angle&&this.vbo_a.set_data(0,new Float32Array(this.glyph._angle)),this.glyph instanceof n.CircleView&&null!=this.glyph._radius?this.vbo_s.set_data(0,u.map(this.glyph.sradius,(function(t){return 2*t}))):this.vbo_s.set_data(0,new Float32Array(this.glyph._size))},e.prototype._set_visuals=function(t){v(this.prog,this.vbo_linewidth,"a_linewidth",t,this.glyph.visuals.line,"line_width"),d(this.prog,this.vbo_fg_color,"a_fg_color",t,this.glyph.visuals.line,"line"),d(this.prog,this.vbo_bg_color,"a_bg_color",t,this.glyph.visuals.fill,"fill"),this.prog.set_uniform("u_antialias","float",[.8])},e}(_.BaseGLGlyph);function c(t){return function(e){function s(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(s,e),Object.defineProperty(s.prototype,"_marker_code",{get:function(){return t},enumerable:!1,configurable:!0}),s}(b)}s.MarkerGL=b,b.__name__="MarkerGL";var p=a.__importStar(t(378));s.AsteriskGL=c(p.asterisk),s.CircleGL=c(p.circle),s.CircleCrossGL=c(p.circlecross),s.CircleXGL=c(p.circlex),s.CrossGL=c(p.cross),s.DiamondGL=c(p.diamond),s.DiamondCrossGL=c(p.diamondcross),s.HexGL=c(p.hex),s.InvertedTriangleGL=c(p.invertedtriangle),s.SquareGL=c(p.square),s.SquareCrossGL=c(p.squarecross),s.SquareXGL=c(p.squarex),s.TriangleGL=c(p.triangle),s.XGL=c(p.x)},
function _(n,i,a,o,_){o(),a.vertex_shader="\nprecision mediump float;\nconst float SQRT_2 = 1.4142135623730951;\n//\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size;\nuniform vec2 u_offset;\nuniform vec2 u_scale;\nuniform float u_antialias;\n//\nattribute float a_sx;\nattribute float a_sy;\nattribute float a_size;\nattribute float a_angle;  // in radians\nattribute float a_linewidth;\nattribute vec4  a_fg_color;\nattribute vec4  a_bg_color;\n//\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec4  v_fg_color;\nvarying vec4  v_bg_color;\nvarying vec2  v_rotation;\n\nvoid main (void)\n{\n    v_size = a_size * u_pixel_ratio;\n    v_linewidth = a_linewidth * u_pixel_ratio;\n    v_fg_color = a_fg_color;\n    v_bg_color = a_bg_color;\n    v_rotation = vec2(cos(-a_angle), sin(-a_angle));\n    vec2 pos = vec2(a_sx, a_sy);  // in pixels\n    pos += 0.5;  // make up for Bokeh's offset\n    pos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(pos*2.0-1.0, 0.0, 1.0);\n    gl_Position.y *= -1.0;\n    gl_PointSize = SQRT_2 * v_size + 2.0 * (v_linewidth + 1.5*u_antialias);\n}\n"},
function _(a,n,s,o,t){o(),s.fragment_shader=function(a){return"\nprecision mediump float;\nconst float SQRT_2 = 1.4142135623730951;\nconst float PI = 3.14159265358979323846264;\n//\nuniform float u_antialias;\n//\nvarying vec4  v_fg_color;\nvarying vec4  v_bg_color;\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec2  v_rotation;\n\n"+a+"\n\nvec4 outline(float distance, float linewidth, float antialias, vec4 fg_color, vec4 bg_color)\n{\n    vec4 frag_color;\n    float t = linewidth/2.0 - antialias;\n    float signed_distance = distance;\n    float border_distance = abs(signed_distance) - t;\n    float alpha = border_distance/antialias;\n    alpha = exp(-alpha*alpha);\n\n    // If fg alpha is zero, it probably means no outline. To avoid a dark outline\n    // shining through due to aa, we set the fg color to the bg color. Avoid if (i.e. branching).\n    float select = float(bool(fg_color.a));\n    fg_color.rgb = select * fg_color.rgb + (1.0  - select) * bg_color.rgb;\n    // Similarly, if we want a transparent bg\n    select = float(bool(bg_color.a));\n    bg_color.rgb = select * bg_color.rgb + (1.0  - select) * fg_color.rgb;\n\n    if( border_distance < 0.0)\n        frag_color = fg_color;\n    else if( signed_distance < 0.0 ) {\n        frag_color = mix(bg_color, fg_color, sqrt(alpha));\n    } else {\n        if( abs(signed_distance) < (linewidth/2.0 + antialias) ) {\n            frag_color = vec4(fg_color.rgb, fg_color.a * alpha);\n        } else {\n            discard;\n        }\n    }\n    return frag_color;\n}\n\nvoid main()\n{\n    vec2 P = gl_PointCoord.xy - vec2(0.5, 0.5);\n    P = vec2(v_rotation.x*P.x - v_rotation.y*P.y,\n             v_rotation.y*P.x + v_rotation.x*P.y);\n    float point_size = SQRT_2*v_size  + 2.0 * (v_linewidth + 1.5*u_antialias);\n    float distance = marker(P*point_size, v_size);\n    gl_FragColor = outline(distance, v_linewidth, u_antialias, v_fg_color, v_bg_color);\n}\n"},s.circle="\nfloat marker(vec2 P, float size)\n{\n    return length(P) - size/2.0;\n}\n",s.square="\nfloat marker(vec2 P, float size)\n{\n    return max(abs(P.x), abs(P.y)) - size/2.0;\n}\n",s.diamond="\nfloat marker(vec2 P, float size)\n{\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    return r1 / SQRT_2;\n}\n",s.hex="\nfloat marker(vec2 P, float size)\n{\n    vec2 q = abs(P);\n    return max(q.y * 0.57735 + q.x - 1.0 * size/2.0, q.y - 0.866 * size/2.0);\n}\n",s.triangle="\nfloat marker(vec2 P, float size)\n{\n    P.y -= size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = P.y;\n    return max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n}\n",s.invertedtriangle="\nfloat marker(vec2 P, float size)\n{\n    P.y += size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = - P.y;\n    return max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n}\n",s.cross='\nfloat marker(vec2 P, float size)\n{\n    float square = max(abs(P.x), abs(P.y)) - size / 2.5;   // 2.5 is a tweak\n    float cross = min(abs(P.x), abs(P.y)) - size / 100.0;  // bit of "width" for aa\n    return max(square, cross);\n}\n',s.circlecross="\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.squarecross="\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.diamondcross="\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float diamond = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    diamond /= SQRT_2;\n    float c1 = max(diamond, s1);\n    float c2 = max(diamond, s2);\n    float c3 = max(diamond, s3);\n    float c4 = max(diamond, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.x='\nfloat marker(vec2 P, float size)\n{\n    float circle = length(P) - size / 1.6;\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    return max(circle, X);\n}\n',s.circlex='\nfloat marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    float almost = min(min(min(c1, c2), c3), c4);\n    // In this case, the X is also outside of the main shape\n    float Xmask = length(P) - size / 1.6;  // a circle\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    return min(max(X, Xmask), almost);\n}\n',s.squarex="\nfloat marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.asterisk='\nfloat marker(vec2 P, float size)\n{\n    // Masks\n    float diamond = max(abs(SQRT_2 / 2.0 * (P.x - P.y)), abs(SQRT_2 / 2.0 * (P.x + P.y))) - size / (2.0 * SQRT_2);\n    float square = max(abs(P.x), abs(P.y)) - size / (2.0 * SQRT_2);\n    // Shapes\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    float cross = min(abs(P.x), abs(P.y)) - size / 100.0;  // bit of "width" for aa\n    // Result is union of masked shapes\n    return min(max(X, diamond), max(cross, square));\n}\n'},
function _(t,e,n,i,a){i();var r=t(1),l=t(213),_=t(143),o=r.__importStar(t(133)),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e}(l.XYGlyphView);n.CenterRotatableView=c,c.__name__="CenterRotatableView";var u=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_CenterRotatable=function(){this.mixins([_.LineVector,_.FillVector]),this.define((function(t){return{angle:[o.AngleSpec,0],width:[o.DistanceSpec],height:[o.DistanceSpec]}}))},e}(l.XYGlyph);n.CenterRotatable=u,u.__name__="CenterRotatable",u.init_CenterRotatable()},
function _(i,e,l,n,t){n();var _=i(1),s=i(381),p=function(i){function e(){return null!==i&&i.apply(this,arguments)||this}return _.__extends(e,i),e}(s.EllipseOvalView);l.EllipseView=p,p.__name__="EllipseView";var u=function(i){function e(e){return i.call(this,e)||this}return _.__extends(e,i),e.init_Ellipse=function(){this.prototype.default_view=p},e}(s.EllipseOval);l.Ellipse=u,u.__name__="Ellipse",u.init_Ellipse()},
function _(t,i,e,s,r){s();var h=t(1),a=t(379),n=h.__importStar(t(215)),l=t(202),_=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return h.__extends(i,t),i.prototype._set_data=function(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)},i.prototype._map_data=function(){"data"==this.model.properties.width.units?this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"):this.sw=this._width,"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"):this.sh=this._height},i.prototype._render=function(t,i,e){var s,r,a=e.sx,n=e.sy,l=e.sw,_=e.sh,o=e._angle;try{for(var d=h.__values(i),x=d.next();!x.done;x=d.next()){var p=x.value;isNaN(a[p]+n[p]+l[p]+_[p]+o[p])||(t.beginPath(),t.ellipse(a[p],n[p],l[p]/2,_[p]/2,o[p],0,2*Math.PI),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,p),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,p),t.stroke()))}}catch(t){s={error:t}}finally{try{x&&!x.done&&(r=d.return)&&r.call(d)}finally{if(s)throw s.error}}},i.prototype._hit_point=function(t){var i,e,s,r,a,_,o,d,x,p,u,y,c=t.sx,v=t.sy,w=this.renderer.xscale.invert(c),m=this.renderer.yscale.invert(v);"data"==this.model.properties.width.units?(a=w-this.max_width,_=w+this.max_width):(x=c-this.max_width,p=c+this.max_width,a=(i=h.__read(this.renderer.xscale.r_invert(x,p),2))[0],_=i[1]),"data"==this.model.properties.height.units?(o=m-this.max_height,d=m+this.max_height):(u=v-this.max_height,y=v+this.max_height,o=(e=h.__read(this.renderer.yscale.r_invert(u,y),2))[0],d=e[1]);var f=this.index.indices({x0:a,x1:_,y0:o,y1:d}),g=[];try{for(var b=h.__values(f),A=b.next();!A.done;A=b.next()){var E=A.value;n.point_in_ellipse(c,v,this._angle[E],this.sh[E]/2,this.sw[E]/2,this.sx[E],this.sy[E])&&g.push(E)}}catch(t){s={error:t}}finally{try{A&&!A.done&&(r=b.return)&&r.call(b)}finally{if(s)throw s.error}}return new l.Selection({indices:g})},i.prototype.draw_legend_for_index=function(t,i,e){var s=i.x0,r=i.y0,h=i.x1,a=i.y1,n=e+1,l=new Array(n);l[e]=(s+h)/2;var _=new Array(n);_[e]=(r+a)/2;var o=this.sw[e]/this.sh[e],d=.8*Math.min(Math.abs(h-s),Math.abs(a-r)),x=new Array(n),p=new Array(n);o>1?(x[e]=d,p[e]=d/o):(x[e]=d*o,p[e]=d),this._render(t,[e],{sx:l,sy:_,sw:x,sh:p,_angle:[0]})},i.prototype._bounds=function(t){var i=t.x0,e=t.x1,s=t.y0,r=t.y1;return{x0:i-this.max_w2,x1:e+this.max_w2,y0:s-this.max_h2,y1:r+this.max_h2}},i}(a.CenterRotatableView);e.EllipseOvalView=_,_.__name__="EllipseOvalView";var o=function(t){function i(i){return t.call(this,i)||this}return h.__extends(i,t),i}(a.CenterRotatable);e.EllipseOval=o,o.__name__="EllipseOval"},
function _(t,i,e,s,r){s();var h=t(1),n=t(383),_=t(139),o=h.__importStar(t(133)),a=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return h.__extends(i,t),i.prototype.scenterxy=function(t){return[(this.sleft[t]+this.sright[t])/2,this.sy[t]]},i.prototype._lrtb=function(t){return[Math.min(this._left[t],this._right[t]),Math.max(this._left[t],this._right[t]),this._y[t]+.5*this._height[t],this._y[t]-.5*this._height[t]]},i.prototype._map_data=function(){this.sy=this.renderer.yscale.v_compute(this._y),this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"),this.sleft=this.renderer.xscale.v_compute(this._left),this.sright=this.renderer.xscale.v_compute(this._right);var t=this.sy.length;this.stop=new _.NumberArray(t),this.sbottom=new _.NumberArray(t);for(var i=0;i<t;i++)this.stop[i]=this.sy[i]-this.sh[i]/2,this.sbottom[i]=this.sy[i]+this.sh[i]/2;this._clamp_viewport()},i}(n.BoxView);e.HBarView=a,a.__name__="HBarView";var u=function(t){function i(i){return t.call(this,i)||this}return h.__extends(i,t),i.init_HBar=function(){this.prototype.default_view=a,this.define((function(t){return{left:[o.XCoordinateSpec,{value:0}],y:[o.YCoordinateSpec,{field:"y"}],height:[o.NumberSpec,{value:1}],right:[o.XCoordinateSpec,{field:"right"}]}}))},i}(n.Box);e.HBar=u,u.__name__="HBar",u.init_HBar()},
function _(t,e,r,i,n){i();var s=t(1),a=t(143),o=t(203),h=t(214),_=t(202),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype.get_anchor_point=function(t,e,r){var i=Math.min(this.sleft[e],this.sright[e]),n=Math.max(this.sright[e],this.sleft[e]),s=Math.min(this.stop[e],this.sbottom[e]),a=Math.max(this.sbottom[e],this.stop[e]);switch(t){case"top_left":return{x:i,y:s};case"top_center":return{x:(i+n)/2,y:s};case"top_right":return{x:n,y:s};case"bottom_left":return{x:i,y:a};case"bottom_center":return{x:(i+n)/2,y:a};case"bottom_right":return{x:n,y:a};case"center_left":return{x:i,y:(s+a)/2};case"center":return{x:(i+n)/2,y:(s+a)/2};case"center_right":return{x:n,y:(s+a)/2};default:return null}},e.prototype._index_data=function(t){for(var e=Math.min,r=Math.max,i=this.data_size,n=0;n<i;n++){var a=s.__read(this._lrtb(n),4),o=a[0],h=a[1],_=a[2],c=a[3];isNaN(o+h+_+c)||!isFinite(o+h+_+c)?t.add_empty():t.add(e(o,h),e(_,c),r(h,o),r(_,c))}},e.prototype._render=function(t,e,r){var i,n,a=this,o=r.sleft,h=r.sright,_=r.stop,c=r.sbottom,l=function(e){if(isNaN(o[e]+_[e]+h[e]+c[e]))return"continue";t.rect(o[e],_[e],h[e]-o[e],c[e]-_[e]),d.visuals.fill.doit&&(d.visuals.fill.set_vectorize(t,e),t.beginPath(),t.rect(o[e],_[e],h[e]-o[e],c[e]-_[e]),t.fill()),d.visuals.hatch.doit2(t,e,(function(){t.beginPath(),t.rect(o[e],_[e],h[e]-o[e],c[e]-_[e]),t.fill()}),(function(){return a.renderer.request_render()})),d.visuals.line.doit&&(d.visuals.line.set_vectorize(t,e),t.beginPath(),t.rect(o[e],_[e],h[e]-o[e],c[e]-_[e]),t.stroke())},d=this;try{for(var u=s.__values(e),x=u.next();!x.done;x=u.next()){l(x.value)}}catch(t){i={error:t}}finally{try{x&&!x.done&&(n=u.return)&&n.call(u)}finally{if(i)throw i.error}}},e.prototype._clamp_viewport=function(){for(var t=this.renderer.plot_view.frame.bbox.h_range,e=this.renderer.plot_view.frame.bbox.v_range,r=this.stop.length,i=0;i<r;i++)this.stop[i]=Math.max(this.stop[i],e.start),this.sbottom[i]=Math.min(this.sbottom[i],e.end),this.sleft[i]=Math.max(this.sleft[i],t.start),this.sright[i]=Math.min(this.sright[i],t.end)},e.prototype._hit_rect=function(t){return this._hit_rect_against_index(t)},e.prototype._hit_point=function(t){var e=t.sx,r=t.sy,i=this.renderer.xscale.invert(e),n=this.renderer.yscale.invert(r),a=s.__spread(this.index.indices({x0:i,y0:n,x1:i,y1:n}));return new _.Selection({indices:a})},e.prototype._hit_span=function(t){var e,r=t.sx,i=t.sy;if("v"==t.direction){var n=this.renderer.yscale.invert(i),a=this.renderer.plot_view.frame.bbox.h_range,o=s.__read(this.renderer.xscale.r_invert(a.start,a.end),2),h=o[0],c=o[1];e=s.__spread(this.index.indices({x0:h,y0:n,x1:c,y1:n}))}else{var l=this.renderer.xscale.invert(r),d=this.renderer.plot_view.frame.bbox.v_range,u=s.__read(this.renderer.yscale.r_invert(d.start,d.end),2),x=u[0],f=u[1];e=s.__spread(this.index.indices({x0:l,y0:x,x1:l,y1:f}))}return new _.Selection({indices:e})},e.prototype.draw_legend_for_index=function(t,e,r){h.generic_area_legend(this.visuals,t,e,r)},e}(o.GlyphView);r.BoxView=c,c.__name__="BoxView";var l=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_Box=function(){this.mixins([a.LineVector,a.FillVector,a.HatchVector])},e}(o.Glyph);r.Box=l,l.__name__="Box",l.init_Box()},
function _(e,t,r,i,s){i();var n=e(1),a=e(203),o=n.__importStar(e(215)),_=n.__importStar(e(133)),l=e(143),h=e(139),c=e(135),d=e(152),p=e(214),y=e(202),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.scenterxy=function(e){return[this.sx[e],this.sy[e]]},t.prototype._set_data=function(){var e=this._q.length,t=this.model,r=t.orientation,i=t.size,s=t.aspect_scale;this._x=new h.NumberArray(e),this._y=new h.NumberArray(e);var n=Math.sqrt(3);if("pointytop"==r)for(var a=0;a<e;a++)this._x[a]=i*n*(this._q[a]+this._r[a]/2)/s,this._y[a]=3*-i/2*this._r[a];else for(a=0;a<e;a++)this._x[a]=3*i/2*this._q[a],this._y[a]=-i*n*(this._r[a]+this._q[a]/2)*s},t.prototype._project_data=function(){d.inplace.project_xy(this._x,this._y)},t.prototype._index_data=function(e){var t,r=this.model.size,i=Math.sqrt(3)*r/2;"flattop"==this.model.orientation?(i=(t=n.__read([r,i],2))[0],r=t[1],r*=this.model.aspect_scale):i/=this.model.aspect_scale;for(var s=this.data_size,a=0;a<s;a++){var o=this._x[a],_=this._y[a];isNaN(o+_)||!isFinite(o+_)?e.add_empty():e.add(o-i,_-r,o+i,_+r)}},t.prototype.map_data=function(){var e,t;e=n.__read(this.renderer.coordinates.map_to_screen(this._x,this._y),2),this.sx=e[0],this.sy=e[1],t=n.__read(this._get_unscaled_vertices(),2),this.svx=t[0],this.svy=t[1]},t.prototype._get_unscaled_vertices=function(){var e=this.model.size,t=this.model.aspect_scale;if("pointytop"==this.model.orientation){var r=this.renderer.yscale,i=this.renderer.xscale,s=Math.abs(r.compute(0)-r.compute(e));return[[0,-(n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))/t),-n,0,n,n],[s,a=s/2,-a,-s,-a,a]]}var n,a;r=this.renderer.xscale,i=this.renderer.yscale;return[[s=Math.abs(r.compute(0)-r.compute(e)),a=s/2,-a,-s,-a,a],[0,-(n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))*t),-n,0,n,n]]},t.prototype._render=function(e,t,r){var i,s,a=r.sx,o=r.sy,_=r.svx,l=r.svy,h=r._scale;try{for(var c=n.__values(t),d=c.next();!d.done;d=c.next()){var p=d.value;if(!isNaN(a[p]+o[p]+h[p])){e.translate(a[p],o[p]),e.beginPath();for(var y=0;y<6;y++)e.lineTo(_[y]*h[p],l[y]*h[p]);e.closePath(),e.translate(-a[p],-o[p]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,p),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,p),e.stroke())}}}catch(e){i={error:e}}finally{try{d&&!d.done&&(s=c.return)&&s.call(c)}finally{if(i)throw i.error}}},t.prototype._hit_point=function(e){var t,r,i=e.sx,s=e.sy,a=this.renderer.xscale.invert(i),_=this.renderer.yscale.invert(s),l=this.index.indices({x0:a,y0:_,x1:a,y1:_}),h=[];try{for(var c=n.__values(l),d=c.next();!d.done;d=c.next()){var p=d.value;o.point_in_poly(i-this.sx[p],s-this.sy[p],this.svx,this.svy)&&h.push(p)}}catch(e){t={error:e}}finally{try{d&&!d.done&&(r=c.return)&&r.call(c)}finally{if(t)throw t.error}}return new y.Selection({indices:h})},t.prototype._hit_span=function(e){var t,r=e.sx,i=e.sy;if("v"==e.direction){var s=this.renderer.yscale.invert(i),a=this.renderer.plot_view.frame.bbox.h_range,o=n.__read(this.renderer.xscale.r_invert(a.start,a.end),2),_=o[0],l=o[1];t=n.__spread(this.index.indices({x0:_,y0:s,x1:l,y1:s}))}else{var h=this.renderer.xscale.invert(r),c=this.renderer.plot_view.frame.bbox.v_range,d=n.__read(this.renderer.yscale.r_invert(c.start,c.end),2),p=d[0],u=d[1];t=n.__spread(this.index.indices({x0:h,y0:p,x1:h,y1:u}))}return new y.Selection({indices:t})},t.prototype._hit_rect=function(e){var t=e.sx0,r=e.sx1,i=e.sy0,s=e.sy1,a=n.__read(this.renderer.xscale.r_invert(t,r),2),o=a[0],_=a[1],l=n.__read(this.renderer.yscale.r_invert(i,s),2),h=l[0],c=l[1],d=n.__spread(this.index.indices({x0:o,x1:_,y0:h,y1:c}));return new y.Selection({indices:d})},t.prototype.draw_legend_for_index=function(e,t,r){p.generic_area_legend(this.visuals,e,t,r)},t}(a.GlyphView);r.HexTileView=u,u.__name__="HexTileView";var v=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_HexTile=function(){this.prototype.default_view=u,this.mixins([l.LineVector,l.FillVector]),this.define((function(e){var t=e.Number;return{r:[_.NumberSpec],q:[_.NumberSpec],size:[t,1],aspect_scale:[t,1],scale:[_.NumberSpec,1],orientation:[c.HexTileOrientation,"pointytop"]}})),this.override({line_color:null})},t}(a.Glyph);r.HexTile=v,v.__name__="HexTile",v.init_HexTile()},
function _(e,t,n,i,r){i();var a=e(1),o=e(386),_=e(252),p=e(260),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.color_mapper.change,(function(){return t._update_image()}))},t.prototype._update_image=function(){null!=this.image_data&&(this._set_data(null),this.renderer.plot_view.request_render())},t.prototype._flat_img_to_buf8=function(e){return this.model.color_mapper.rgba_mapper.v_compute(e)},t}(o.ImageBaseView);n.ImageView=u,u.__name__="ImageView";var f=function(e){function t(t){return e.call(this,t)||this}return a.__extends(t,e),t.init_Image=function(){this.prototype.default_view=u,this.define((function(e){return{color_mapper:[(0,e.Ref)(_.ColorMapper),function(){return new p.LinearColorMapper({palette:["#000000","#252525","#525252","#737373","#969696","#bdbdbd","#d9d9d9","#f0f0f0","#ffffff"]})}]}}))},t}(o.ImageBase);n.Image=f,f.__name__="Image",f.init_Image()},
function _(e,t,i,a,r){a();var s=e(1),h=e(213),n=e(139),_=s.__importStar(e(133)),d=e(202),o=e(124),l=e(145),g=e(126),c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.global_alpha.change,(function(){return t.renderer.request_render()}))},t.prototype._render=function(e,t,i){var a,r,h=i.image_data,n=i.sx,_=i.sy,d=i.sw,o=i.sh,l=e.getImageSmoothingEnabled();e.setImageSmoothingEnabled(!1),e.globalAlpha=this.model.global_alpha;try{for(var g=s.__values(t),c=g.next();!c.done;c=g.next()){var u=c.value;if(null!=h[u]&&!isNaN(n[u]+_[u]+d[u]+o[u])){var m=_[u];e.translate(0,m),e.scale(1,-1),e.translate(0,-m),e.drawImage(h[u],0|n[u],0|_[u],d[u],o[u]),e.translate(0,m),e.scale(1,-1),e.translate(0,-m)}}}catch(e){a={error:e}}finally{try{c&&!c.done&&(r=g.return)&&r.call(g)}finally{if(a)throw a.error}}e.setImageSmoothingEnabled(l)},t.prototype._set_data=function(e){this._set_width_heigh_data();for(var t=0,i=this._image.length;t<i;t++)if(!(null!=e&&e.indexOf(t)<0)){var a=this._image[t],r=void 0;l.is_NDArray(a)?(g.assert(2==a.dimension,"expected a 2D array"),r=a,this._height[t]=a.shape[0],this._width[t]=a.shape[1]):(r=o.concat(a),this._height[t]=a.length,this._width[t]=a[0].length);var s=this._flat_img_to_buf8(r);this._set_image_data_from_buffer(t,s)}},t.prototype._index_data=function(e){for(var t=this.data_size,i=0;i<t;i++){var a=s.__read(this._lrtb(i),4),r=a[0],h=a[1],n=a[2],_=a[3];isNaN(r+h+n+_)||!isFinite(r+h+n+_)?e.add_empty():e.add(r,_,h,n)}},t.prototype._lrtb=function(e){var t=this.renderer.xscale.source_range,i=this._x[e],a=t.is_reversed?i-this._dw[e]:i+this._dw[e],r=this.renderer.yscale.source_range,h=this._y[e],n=r.is_reversed?h-this._dh[e]:h+this._dh[e],_=s.__read(i<a?[i,a]:[a,i],2),d=_[0],o=_[1],l=s.__read(h<n?[h,n]:[n,h],2),g=l[0];return[d,o,l[1],g]},t.prototype._set_width_heigh_data=function(){null!=this.image_data&&this.image_data.length==this._image.length||(this.image_data=new Array(this._image.length)),null!=this._width&&this._width.length==this._image.length||(this._width=new n.NumberArray(this._image.length)),null!=this._height&&this._height.length==this._image.length||(this._height=new n.NumberArray(this._image.length))},t.prototype._get_or_create_canvas=function(e){var t=this.image_data[e];if(null!=t&&t.width==this._width[e]&&t.height==this._height[e])return t;var i=document.createElement("canvas");return i.width=this._width[e],i.height=this._height[e],i},t.prototype._set_image_data_from_buffer=function(e,t){var i=this._get_or_create_canvas(e),a=i.getContext("2d"),r=a.getImageData(0,0,this._width[e],this._height[e]);r.data.set(t),a.putImageData(r,0,0),this.image_data[e]=i},t.prototype._map_data=function(){switch(this.model.properties.dw.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,this._dw,"edge",this.model.dilate);break;case"screen":this.sw=this._dw}switch(this.model.properties.dh.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,this._dh,"edge",this.model.dilate);break;case"screen":this.sh=this._dh}},t.prototype._image_index=function(e,t,i){var a=s.__read(this._lrtb(e),4),r=a[0],h=a[1],n=a[2],_=a[3],d=this._width[e],o=this._height[e],l=(h-r)/d,g=(n-_)/o,c=Math.floor((t-r)/l),u=Math.floor((i-_)/g);return this.renderer.xscale.source_range.is_reversed&&(c=d-c-1),this.renderer.yscale.source_range.is_reversed&&(u=o-u-1),{index:e,dim1:c,dim2:u,flat_index:u*d+c}},t.prototype._hit_point=function(e){var t,i,a=e.sx,r=e.sy,h=this.renderer.xscale.invert(a),n=this.renderer.yscale.invert(r),_=this.index.indices({x0:h,x1:h,y0:n,y1:n}),o=new d.Selection;try{for(var l=s.__values(_),g=l.next();!g.done;g=l.next()){var c=g.value;a!=1/0&&r!=1/0&&o.image_indices.push(this._image_index(c,h,n))}}catch(e){t={error:e}}finally{try{g&&!g.done&&(i=l.return)&&i.call(l)}finally{if(t)throw t.error}}return o},t}(h.XYGlyphView);i.ImageBaseView=c,c.__name__="ImageBaseView";var u=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_ImageBase=function(){this.define((function(e){var t=e.Boolean,i=e.Alpha;return{image:[_.NDArraySpec],dw:[_.DistanceSpec],dh:[_.DistanceSpec],dilate:[t,!1],global_alpha:[i,1]}}))},t}(h.XYGlyph);i.ImageBase=u,u.__name__="ImageBase",u.init_ImageBase()},
function _(e,n,t,i,a){i();var r=e(1),_=e(386),u=e(123),f=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(n,e),n.prototype._flat_img_to_buf8=function(e){var n;return n=u.isArray(e)?new Uint32Array(e):e,new Uint8Array(n.buffer)},n}(_.ImageBaseView);t.ImageRGBAView=f,f.__name__="ImageRGBAView";var o=function(e){function n(n){return e.call(this,n)||this}return r.__extends(n,e),n.init_ImageRGBA=function(){this.prototype.default_view=f},n}(_.ImageBase);t.ImageRGBA=o,o.__name__="ImageRGBA",o.init_ImageRGBA()},
function _(e,t,r,i,a){i();var n=e(1),s=e(213),o=e(139),_=e(135),h=n.__importStar(e(133)),l=e(127),c=e(389),u=function(e){function t(){var t=e.apply(this,n.__spread(arguments))||this;return t._images_rendered=!1,t}return n.__extends(t,e),t.prototype.initialize=function(){var t=this;e.prototype.initialize.call(this),this.connect(this.model.properties.global_alpha.change,(function(){return t.renderer.request_render()}))},t.prototype._index_data=function(e){for(var t=this.data_size,r=0;r<t;r++)e.add_empty()},t.prototype._set_data=function(){var e,t,r=this;null!=this.image&&this.image.length==this._url.length||(this.image=l.map(this._url,(function(){return null})));for(var i=this.model,a=i.retry_attempts,s=i.retry_timeout,_=function(e,t){var i=h._url[e];if(null==i||""==i)return"continue";new c.ImageLoader(i,{loaded:function(t){r.image[e]=t,r.renderer.request_render()},attempts:a+1,timeout:s})},h=this,u=0,d=this._url.length;u<d;u++)_(u);var p="data"==this.model.properties.w.units,m="data"==this.model.properties.h.units,f=this._x.length,g=new o.NumberArray(p?2*f:f),y=new o.NumberArray(m?2*f:f),b=this.model.anchor;function w(e,t){switch(b){case"top_left":case"bottom_left":case"center_left":return[e,e+t];case"top_center":case"bottom_center":case"center":return[e-t/2,e+t/2];case"top_right":case"bottom_right":case"center_right":return[e-t,e]}}function v(e,t){switch(b){case"top_left":case"top_center":case"top_right":return[e,e-t];case"bottom_left":case"bottom_center":case"bottom_right":return[e+t,e];case"center_left":case"center":case"center_right":return[e+t/2,e-t/2]}}if(p)for(u=0;u<f;u++)e=n.__read(w(this._x[u],this._w[u]),2),g[u]=e[0],g[f+u]=e[1];else g.set(this._x,0);if(m)for(u=0;u<f;u++)t=n.__read(v(this._y[u],this._h[u]),2),y[u]=t[0],y[f+u]=t[1];else y.set(this._y,0);var x=n.__read(l.minmax(g),2),N=x[0],I=x[1],L=n.__read(l.minmax(y),2),A=L[0],R=L[1];this._bounds_rect={x0:N,x1:I,y0:A,y1:R}},t.prototype.has_finished=function(){return e.prototype.has_finished.call(this)&&1==this._images_rendered},t.prototype._map_data=function(){var e=null!=this.model.w?this._w:l.map(this._x,(function(){return NaN})),t=null!=this.model.h?this._h:l.map(this._x,(function(){return NaN}));switch(this.model.properties.w.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,e,"edge",this.model.dilate);break;case"screen":this.sw=e}switch(this.model.properties.h.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,t,"edge",this.model.dilate);break;case"screen":this.sh=t}},t.prototype._render=function(e,t,r){var i,a,s=r.image,o=r.sx,_=r.sy,h=r.sw,l=r.sh,c=r._angle,u=this.renderer.plot_view.frame;e.rect(u.bbox.left+1,u.bbox.top+1,u.bbox.width-2,u.bbox.height-2),e.clip();var d=!0;try{for(var p=n.__values(t),m=p.next();!m.done;m=p.next()){var f=m.value;if(!isNaN(o[f]+_[f]+c[f])){var g=s[f];null!=g?this._render_image(e,f,g,o,_,h,l,c):d=!1}}}catch(e){i={error:e}}finally{try{m&&!m.done&&(a=p.return)&&a.call(p)}finally{if(i)throw i.error}}d&&!this._images_rendered&&(this._images_rendered=!0,this.notify_finished())},t.prototype._final_sx_sy=function(e,t,r,i,a){switch(e){case"top_left":return[t,r];case"top_center":return[t-i/2,r];case"top_right":return[t-i,r];case"center_right":return[t-i,r-a/2];case"bottom_right":return[t-i,r-a];case"bottom_center":return[t-i/2,r-a];case"bottom_left":return[t,r-a];case"center_left":return[t,r-a/2];case"center":return[t-i/2,r-a/2]}},t.prototype._render_image=function(e,t,r,i,a,s,o,_){isNaN(s[t])&&(s[t]=r.width),isNaN(o[t])&&(o[t]=r.height);var h=this.model.anchor,l=n.__read(this._final_sx_sy(h,i[t],a[t],s[t],o[t]),2),c=l[0],u=l[1];e.save(),e.globalAlpha=this.model.global_alpha;var d=s[t]/2,p=o[t]/2;_[t]?(e.translate(c,u),e.translate(d,p),e.rotate(_[t]),e.translate(-d,-p),e.drawImage(r,0,0,s[t],o[t]),e.translate(d,p),e.rotate(-_[t]),e.translate(-d,-p),e.translate(-c,-u)):e.drawImage(r,c,u,s[t],o[t]),e.restore()},t.prototype.bounds=function(){return this._bounds_rect},t}(s.XYGlyphView);r.ImageURLView=u,u.__name__="ImageURLView";var d=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_ImageURL=function(){this.prototype.default_view=u,this.define((function(e){var t=e.Boolean,r=e.Int,i=e.Alpha;return{url:[h.StringSpec],anchor:[_.Anchor,"top_left"],global_alpha:[i,1],angle:[h.AngleSpec,0],w:[h.DistanceSpec,null],h:[h.DistanceSpec,null],dilate:[t,!1],retry_attempts:[r,0],retry_timeout:[r,0]}}))},t}(s.XYGlyph);r.ImageURL=d,d.__name__="ImageURL",d.init_ImageURL()},
function _(e,i,n,o,t){o();var r=e(134),a=function(){function e(e,i){var n=this;void 0===i&&(i={}),this._image=new Image,this._finished=!1;var o=i.attempts,t=void 0===o?1:o,a=i.timeout,g=void 0===a?1:a;this.promise=new Promise((function(o,a){n._image.crossOrigin="anonymous";var m=0;n._image.onerror=function(){if(++m==t){var o="unable to load "+e+" image after "+t+" attempts";if(r.logger.warn(o),null==n._image.crossOrigin)return void(null!=i.failed&&i.failed());r.logger.warn("attempting to load "+e+" without a cross origin policy"),n._image.crossOrigin=null,m=0}setTimeout((function(){return n._image.src=e}),g)},n._image.onload=function(){n._finished=!0,null!=i.loaded&&i.loaded(n._image),o(n._image)},n._image.src=e}))}return Object.defineProperty(e.prototype,"finished",{get:function(){return this._finished},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"image",{get:function(){return this._image},enumerable:!1,configurable:!0}),e}();n.ImageLoader=a,a.__name__="ImageLoader"},
function _(e,t,r,i,n){i();var s=e(1),o=e(204),a=e(203),_=e(214),l=e(127),h=e(127),d=e(143),y=s.__importStar(e(215)),f=s.__importStar(e(133)),u=e(202),c=e(126),p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype._project_data=function(){},t.prototype._index_data=function(e){for(var t=Math.min,r=Math.max,i=this.data_size,n=0;n<i;n++){var o=this._xs[n],a=this._ys[n];if(0!=o.length&&0!=a.length){for(var _=1/0,h=-1/0,d=1/0,y=-1/0,f=0,u=o.length;f<u;f++){var c=o[f][0],p=a[f][0];if(0!=c.length&&0!=p.length){var v=s.__read(l.minmax(c),2),x=v[0],g=v[1],m=s.__read(l.minmax(p),2),w=m[0],S=m[1];_=t(_,x),h=r(h,g),d=t(d,w),y=r(y,S)}}isFinite(_+h+d+y)?e.add(_,d,h,y):e.add_empty()}else e.add_empty()}this._hole_index=this._index_hole_data()},t.prototype._index_hole_data=function(){for(var e=Math.min,t=Math.max,r=this.data_size,i=new o.SpatialIndex(r),n=0;n<r;n++){var a=this._xs[n],_=this._ys[n];if(0!=a.length&&0!=_.length){for(var h=1/0,d=-1/0,y=1/0,f=-1/0,u=0,c=a.length;u<c;u++){var p=a[u],v=_[u];if(p.length>1&&v.length>1)for(var x=1,g=p.length;x<g;x++){var m=s.__read(l.minmax(p[x]),2),w=m[0],S=m[1],M=s.__read(l.minmax(v[x]),2),P=M[0],q=M[1];h=e(h,w),d=t(d,S),y=e(y,P),f=t(f,q)}}isFinite(h+d+y+f)?i.add(h,y,d,f):i.add_empty()}else i.add_empty()}return i.finish(),i},t.prototype._mask_data=function(){var e=this.renderer.plot_view.frame,t=e.x_range,r=e.y_range;return this.index.indices({x0:t.min,x1:t.max,y0:r.min,y1:r.max})},t.prototype._inner_loop=function(e,t,r){e.beginPath();for(var i=0,n=t.length;i<n;i++)for(var s=0,o=t[i].length;s<o;s++){for(var a=t[i][s],_=r[i][s],l=0,h=a.length;l<h;l++)0!=l?e.lineTo(a[l],_[l]):e.moveTo(a[l],_[l]);e.closePath()}},t.prototype._render=function(e,t,r){var i,n,o=this,a=r.sxs,_=r.sys;if(this.visuals.fill.doit||this.visuals.line.doit){var l=function(t){var r=s.__read([a[t],_[t]],2),i=r[0],n=r[1];h.visuals.fill.doit&&(h.visuals.fill.set_vectorize(e,t),h._inner_loop(e,i,n),e.fill("evenodd")),h.visuals.hatch.doit2(e,t,(function(){o._inner_loop(e,i,n),e.fill("evenodd")}),(function(){return o.renderer.request_render()})),h.visuals.line.doit&&(h.visuals.line.set_vectorize(e,t),h._inner_loop(e,i,n),e.stroke())},h=this;try{for(var d=s.__values(t),y=d.next();!y.done;y=d.next()){l(y.value)}}catch(e){i={error:e}}finally{try{y&&!y.done&&(n=d.return)&&n.call(d)}finally{if(i)throw i.error}}}},t.prototype._hit_rect=function(e){var t,r,i=e.sx0,n=e.sx1,o=e.sy0,a=e.sy1,_=[i,n,n,i],l=[o,o,a,a],h=s.__read(this.renderer.xscale.r_invert(i,n),2),d=h[0],f=h[1],c=s.__read(this.renderer.yscale.r_invert(o,a),2),p=c[0],v=c[1],x=this.index.indices({x0:d,x1:f,y0:p,y1:v}),g=[];try{for(var m=s.__values(x),w=m.next();!w.done;w=m.next()){for(var S=w.value,M=this.sxs[S],P=this.sys[S],q=!0,A=0,V=M.length;A<V;A++){for(var b=0,k=M[A][0].length;b<k;b++){var z=M[A][0][b],F=P[A][0][b];if(!y.point_in_poly(z,F,_,l)){q=!1;break}}if(!q)break}q&&g.push(S)}}catch(e){t={error:e}}finally{try{w&&!w.done&&(r=m.return)&&r.call(m)}finally{if(t)throw t.error}}return new u.Selection({indices:g})},t.prototype._hit_point=function(e){var t,r,i=e.sx,n=e.sy,o=this.renderer.xscale.invert(i),a=this.renderer.yscale.invert(n),_=this.index.indices({x0:o,y0:a,x1:o,y1:a}),l=this._hole_index.indices({x0:o,y0:a,x1:o,y1:a}),h=[];try{for(var d=s.__values(_),f=d.next();!f.done;f=d.next())for(var c=f.value,p=this.sxs[c],v=this.sys[c],x=0,g=p.length;x<g;x++){var m=p[x].length;if(y.point_in_poly(i,n,p[x][0],v[x][0]))if(1==m)h.push(c);else if(l.get(c)){if(m>1){for(var w=!1,S=1;S<m;S++){var M=p[x][S],P=v[x][S];if(y.point_in_poly(i,n,M,P)){w=!0;break}}w||h.push(c)}}else h.push(c)}}catch(e){t={error:e}}finally{try{f&&!f.done&&(r=d.return)&&r.call(d)}finally{if(t)throw t.error}}return new u.Selection({indices:h})},t.prototype._get_snap_coord=function(e){return h.sum(e)/e.length},t.prototype.scenterxy=function(e,t,r){if(1==this.sxs[e].length)return[this._get_snap_coord(this.sxs[e][0][0]),this._get_snap_coord(this.sys[e][0][0])];for(var i=this.sxs[e],n=this.sys[e],s=0,o=i.length;s<o;s++){if(y.point_in_poly(t,r,i[s][0],n[s][0]))return[this._get_snap_coord(i[s][0]),this._get_snap_coord(n[s][0])]}c.unreachable()},t.prototype.map_data=function(){var e=this._xs.length;this.sxs=new Array(e),this.sys=new Array(e);for(var t=0;t<e;t++){var r=this._xs[t].length;this.sxs[t]=new Array(r),this.sys[t]=new Array(r);for(var i=0;i<r;i++){var n=this._xs[t][i].length;this.sxs[t][i]=new Array(n),this.sys[t][i]=new Array(n);for(var o=0;o<n;o++){var a=s.__read(this.renderer.coordinates.map_to_screen(this._xs[t][i][o],this._ys[t][i][o]),2),_=a[0],l=a[1];this.sxs[t][i][o]=_,this.sys[t][i][o]=l}}}},t.prototype.draw_legend_for_index=function(e,t,r){_.generic_area_legend(this.visuals,e,t,r)},t}(a.GlyphView);r.MultiPolygonsView=p,p.__name__="MultiPolygonsView";var v=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_MultiPolygons=function(){this.prototype.default_view=p,this.define((function(e){return{xs:[f.XCoordinateSeqSeqSeqSpec,{field:"xs"}],ys:[f.YCoordinateSeqSeqSeqSpec,{field:"ys"}]}})),this.mixins([d.LineVector,d.FillVector,d.HatchVector])},t}(a.Glyph);r.MultiPolygons=v,v.__name__="MultiPolygons",v.init_MultiPolygons()},
function _(t,n,i,a,e){a();var l=t(1),_=t(381),r=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return l.__extends(n,t),n.prototype._map_data=function(){t.prototype._map_data.call(this);for(var n=this.sw,i=n.length,a=0;a<i;a++)n[a]*=.75},n}(_.EllipseOvalView);i.OvalView=r,r.__name__="OvalView";var o=function(t){function n(n){return t.call(this,n)||this}return l.__extends(n,t),n.init_Oval=function(){this.prototype.default_view=r},n}(_.EllipseOval);i.Oval=o,o.__name__="Oval",o.init_Oval()},
function _(t,i,e,n,o){n();var r=t(1),u=t(383),_=r.__importStar(t(133)),s=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(i,t),i.prototype.scenterxy=function(t){return[(this.sleft[t]+this.sright[t])/2,(this.stop[t]+this.sbottom[t])/2]},i.prototype._lrtb=function(t){return[this._left[t],this._right[t],this._top[t],this._bottom[t]]},i}(u.BoxView);e.QuadView=s,s.__name__="QuadView";var f=function(t){function i(i){return t.call(this,i)||this}return r.__extends(i,t),i.init_Quad=function(){this.prototype.default_view=s,this.define((function(t){return{right:[_.XCoordinateSpec,{field:"right"}],bottom:[_.YCoordinateSpec,{field:"bottom"}],left:[_.XCoordinateSpec,{field:"left"}],top:[_.YCoordinateSpec,{field:"top"}]}}))},i}(u.Box);e.Quad=f,f.__name__="Quad",f.init_Quad()},
function _(t,i,e,r,n){r();var a=t(1),o=t(143),_=t(152),s=t(203),c=t(214),d=a.__importStar(t(133));function h(t,i,e){if(i==(t+e)/2)return[t,e];var r=(t-i)/(t-2*i+e),n=t*Math.pow(1-r,2)+2*i*(1-r)*r+e*Math.pow(r,2);return[Math.min(t,e,n),Math.max(t,e,n)]}var u=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(i,t),i.prototype._project_data=function(){_.inplace.project_xy(this._x0,this._y0),_.inplace.project_xy(this._x1,this._y1)},i.prototype._index_data=function(t){for(var i=this.data_size,e=0;e<i;e++)if(isNaN(this._x0[e]+this._x1[e]+this._y0[e]+this._y1[e]+this._cx[e]+this._cy[e]))t.add_empty();else{var r=a.__read(h(this._x0[e],this._cx[e],this._x1[e]),2),n=r[0],o=r[1],_=a.__read(h(this._y0[e],this._cy[e],this._y1[e]),2),s=_[0],c=_[1];t.add(n,s,o,c)}},i.prototype._render=function(t,i,e){var r,n,o=e.sx0,_=e.sy0,s=e.sx1,c=e.sy1,d=e.scx,h=e.scy;if(this.visuals.line.doit)try{for(var u=a.__values(i),y=u.next();!y.done;y=u.next()){var l=y.value;isNaN(o[l]+_[l]+s[l]+c[l]+d[l]+h[l])||(t.beginPath(),t.moveTo(o[l],_[l]),t.quadraticCurveTo(d[l],h[l],s[l],c[l]),this.visuals.line.set_vectorize(t,l),t.stroke())}}catch(t){r={error:t}}finally{try{y&&!y.done&&(n=u.return)&&n.call(u)}finally{if(r)throw r.error}}},i.prototype.draw_legend_for_index=function(t,i,e){c.generic_line_legend(this.visuals,t,i,e)},i.prototype.scenterxy=function(){throw new Error(this+".scenterxy() is not implemented")},i}(s.GlyphView);e.QuadraticView=u,u.__name__="QuadraticView";var y=function(t){function i(i){return t.call(this,i)||this}return a.__extends(i,t),i.init_Quadratic=function(){this.prototype.default_view=u,this.define((function(t){return{x0:[d.XCoordinateSpec,{field:"x0"}],y0:[d.YCoordinateSpec,{field:"y0"}],x1:[d.XCoordinateSpec,{field:"x1"}],y1:[d.YCoordinateSpec,{field:"y1"}],cx:[d.XCoordinateSpec,{field:"cx"}],cy:[d.YCoordinateSpec,{field:"cy"}]}})),this.mixins(o.LineVector)},i}(s.Glyph);e.Quadratic=y,y.__name__="Quadratic",y.init_Quadratic()},
function _(t,e,n,i,r){i();var a=t(1),s=t(213),l=t(214),o=t(143),h=a.__importStar(t(133)),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.length.units?this.slength=this.sdist(this.renderer.xscale,this._x,this._length):this.slength=this._length},e.prototype._render=function(t,e,n){var i,r,s=n.sx,l=n.sy,o=n.slength,h=n._angle;if(this.visuals.line.doit){for(var _=2*(this.renderer.plot_view.frame.bbox.width+this.renderer.plot_view.frame.bbox.height),u=0,c=o.length;u<c;u++)0==o[u]&&(o[u]=_);try{for(var f=a.__values(e),d=f.next();!d.done;d=f.next()){u=d.value;isNaN(s[u]+l[u]+h[u]+o[u])||(t.translate(s[u],l[u]),t.rotate(h[u]),t.beginPath(),t.moveTo(0,0),t.lineTo(o[u],0),this.visuals.line.set_vectorize(t,u),t.stroke(),t.rotate(-h[u]),t.translate(-s[u],-l[u]))}}catch(t){i={error:t}}finally{try{d&&!d.done&&(r=f.return)&&r.call(f)}finally{if(i)throw i.error}}}},e.prototype.draw_legend_for_index=function(t,e,n){l.generic_line_legend(this.visuals,t,e,n)},e}(s.XYGlyphView);n.RayView=_,_.__name__="RayView";var u=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_Ray=function(){this.prototype.default_view=_,this.mixins(o.LineVector),this.define((function(t){return{length:[h.DistanceSpec],angle:[h.AngleSpec]}}))},e}(s.XYGlyph);n.Ray=u,u.__name__="Ray",u.init_Ray()},
function _(t,e,s,i,r){i();var a=t(1),h=t(379),n=t(214),o=t(139),_=t(127),l=t(202),d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),e.prototype._set_data=function(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)},e.prototype._map_data=function(){var t,e;if("data"==this.model.properties.width.units)t=a.__read(this._map_dist_corner_for_data_side_length(this._x,this._width,this.renderer.xscale),2),this.sw=t[0],this.sx0=t[1];else{this.sw=this._width;var s=this.sx.length;this.sx0=new o.NumberArray(s);for(var i=0;i<s;i++)this.sx0[i]=this.sx[i]-this.sw[i]/2}if("data"==this.model.properties.height.units)e=a.__read(this._map_dist_corner_for_data_side_length(this._y,this._height,this.renderer.yscale),2),this.sh=e[0],this.sy1=e[1];else{this.sh=this._height;var r=this.sy.length;this.sy1=new o.NumberArray(r);for(i=0;i<r;i++)this.sy1[i]=this.sy[i]-this.sh[i]/2}var h=this.sw.length;this.ssemi_diag=new o.NumberArray(h);for(i=0;i<h;i++)this.ssemi_diag[i]=Math.sqrt(this.sw[i]/2*this.sw[i]/2+this.sh[i]/2*this.sh[i]/2)},e.prototype._render=function(t,e,s){var i,r,h,n,o=s.sx,_=s.sy,l=s.sx0,d=s.sy1,u=s.sw,c=s.sh,y=s._angle;if(this.visuals.fill.doit)try{for(var f=a.__values(e),x=f.next();!x.done;x=f.next()){var v=x.value;isNaN(o[v]+_[v]+l[v]+d[v]+u[v]+c[v]+y[v])||(this.visuals.fill.set_vectorize(t,v),y[v]?(t.translate(o[v],_[v]),t.rotate(y[v]),t.fillRect(-u[v]/2,-c[v]/2,u[v],c[v]),t.rotate(-y[v]),t.translate(-o[v],-_[v])):t.fillRect(l[v],d[v],u[v],c[v]))}}catch(t){i={error:t}}finally{try{x&&!x.done&&(r=f.return)&&r.call(f)}finally{if(i)throw i.error}}if(this.visuals.line.doit){t.beginPath();try{for(var p=a.__values(e),w=p.next();!w.done;w=p.next()){v=w.value;isNaN(o[v]+_[v]+l[v]+d[v]+u[v]+c[v]+y[v])||0!=u[v]&&0!=c[v]&&(y[v]?(t.translate(o[v],_[v]),t.rotate(y[v]),t.rect(-u[v]/2,-c[v]/2,u[v],c[v]),t.rotate(-y[v]),t.translate(-o[v],-_[v])):t.rect(l[v],d[v],u[v],c[v]),this.visuals.line.set_vectorize(t,v),t.stroke(),t.beginPath())}}catch(t){h={error:t}}finally{try{w&&!w.done&&(n=p.return)&&n.call(p)}finally{if(h)throw h.error}}t.stroke()}},e.prototype._hit_rect=function(t){return this._hit_rect_against_index(t)},e.prototype._hit_point=function(t){for(var e,s,i=t.sx,r=t.sy,h=this.renderer.xscale.invert(i),n=this.renderer.yscale.invert(r),d=this.sx0.length,u=new o.NumberArray(d),c=0;c<d;c++)u[c]=this.sx0[c]+this.sw[c]/2;var y=new o.NumberArray(d);for(c=0;c<d;c++)y[c]=this.sy1[c]+this.sh[c]/2;var f,x,v=_.max(this._ddist(0,u,this.ssemi_diag)),p=_.max(this._ddist(1,y,this.ssemi_diag)),w=h-v,m=h+v,g=n-p,b=n+p,N=[];try{for(var R=a.__values(this.index.indices({x0:w,x1:m,y0:g,y1:b})),A=R.next();!A.done;A=R.next()){c=A.value;if(this._angle[c]){var M=Math.sin(-this._angle[c]),k=Math.cos(-this._angle[c]),V=k*(i-this.sx[c])-M*(r-this.sy[c])+this.sx[c],z=M*(i-this.sx[c])+k*(r-this.sy[c])+this.sy[c];i=V,r=z,f=Math.abs(this.sx[c]-i)<=this.sw[c]/2,x=Math.abs(this.sy[c]-r)<=this.sh[c]/2}else{var C=i-this.sx0[c],F=r-this.sy1[c];f=0<=C&&C<=this.sw[c],x=0<=F&&F<=this.sh[c]}f&&x&&N.push(c)}}catch(t){e={error:t}}finally{try{A&&!A.done&&(s=R.return)&&s.call(R)}finally{if(e)throw e.error}}return new l.Selection({indices:N})},e.prototype._map_dist_corner_for_data_side_length=function(t,e,s){for(var i=t.length,r=new Float64Array(i),a=new Float64Array(i),h=0;h<i;h++)r[h]=t[h]-e[h]/2,a[h]=t[h]+e[h]/2;var n=s.v_compute(r),o=s.v_compute(a),_=this.sdist(s,r,e,"edge",this.model.dilate),l=n;for(h=0;h<i;h++){var d=n[h],u=o[h];if(!isNaN(d+u)&&d!=u){l=d<u?n:o;break}}return[_,l]},e.prototype._ddist=function(t,e,s){for(var i=0==t?this.renderer.xscale:this.renderer.yscale,r=e,a=r.length,h=new o.NumberArray(a),n=0;n<a;n++)h[n]=r[n]+s[n];var _=i.v_invert(r),l=i.v_invert(h),d=_.length,u=new o.NumberArray(d);for(n=0;n<d;n++)u[n]=Math.abs(l[n]-_[n]);return u},e.prototype.draw_legend_for_index=function(t,e,s){n.generic_area_legend(this.visuals,t,e,s)},e.prototype._bounds=function(t){var e=t.x0,s=t.x1,i=t.y0,r=t.y1;return{x0:e-this.max_w2,x1:s+this.max_w2,y0:i-this.max_h2,y1:r+this.max_h2}},e}(h.CenterRotatableView);s.RectView=d,d.__name__="RectView";var u=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_Rect=function(){this.prototype.default_view=d,this.define((function(t){return{dilate:[t.Boolean,!1]}}))},e}(h.CenterRotatable);s.Rect=u,u.__name__="Rect",u.init_Rect()},
function _(e,t,i,r,n){r();var s=e(1),a=s.__importStar(e(215)),_=s.__importStar(e(133)),o=e(143),h=e(152),l=e(203),d=e(214),c=e(202),y=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype._project_data=function(){h.inplace.project_xy(this._x0,this._y0),h.inplace.project_xy(this._x1,this._y1)},t.prototype._index_data=function(e){for(var t=Math.min,i=Math.max,r=this.data_size,n=0;n<r;n++){var s=this._x0[n],a=this._x1[n],_=this._y0[n],o=this._y1[n];isNaN(s+a+_+o)?e.add_empty():e.add(t(s,a),t(_,o),i(s,a),i(_,o))}},t.prototype._render=function(e,t,i){var r,n,a=i.sx0,_=i.sy0,o=i.sx1,h=i.sy1;if(this.visuals.line.doit)try{for(var l=s.__values(t),d=l.next();!d.done;d=l.next()){var c=d.value;isNaN(a[c]+_[c]+o[c]+h[c])||(e.beginPath(),e.moveTo(a[c],_[c]),e.lineTo(o[c],h[c]),this.visuals.line.set_vectorize(e,c),e.stroke())}}catch(e){r={error:e}}finally{try{d&&!d.done&&(n=l.return)&&n.call(l)}finally{if(r)throw r.error}}},t.prototype._hit_point=function(e){var t,i,r=e.sx,n=e.sy,_={x:r,y:n},o=s.__read(this.renderer.xscale.r_invert(r-2,r+2),2),h=o[0],l=o[1],d=s.__read(this.renderer.yscale.r_invert(n-2,n+2),2),y=d[0],x=d[1],u=this.index.indices({x0:h,y0:y,x1:l,y1:x}),p=[];try{for(var v=s.__values(u),f=v.next();!f.done;f=v.next()){var m=f.value,w=Math.pow(Math.max(2,this.visuals.line.cache_select("line_width",m)/2),2),S={x:this.sx0[m],y:this.sy0[m]},g={x:this.sx1[m],y:this.sy1[m]};a.dist_to_segment_squared(_,S,g)<w&&p.push(m)}}catch(e){t={error:e}}finally{try{f&&!f.done&&(i=v.return)&&i.call(v)}finally{if(t)throw t.error}}return new c.Selection({indices:p})},t.prototype._hit_span=function(e){var t,i,r,n,a,_,o,h=s.__read(this.renderer.plot_view.frame.bbox.ranges,2),l=h[0],d=h[1],y=e.sx,x=e.sy;"v"==e.direction?(o=this.renderer.yscale.invert(x),a=(t=s.__read([this._y0,this._y1],2))[0],_=t[1]):(o=this.renderer.xscale.invert(y),a=(i=s.__read([this._x0,this._x1],2))[0],_=i[1]);var u=[],p=s.__read(this.renderer.xscale.r_invert(l.start,l.end),2),v=p[0],f=p[1],m=s.__read(this.renderer.yscale.r_invert(d.start,d.end),2),w=m[0],S=m[1],g=this.index.indices({x0:v,y0:w,x1:f,y1:S});try{for(var M=s.__values(g),b=M.next();!b.done;b=M.next()){var C=b.value;(a[C]<=o&&o<=_[C]||_[C]<=o&&o<=a[C])&&u.push(C);var N=1.5+this.visuals.line.cache_select("line_width",C)/2;a[C]==_[C]&&("h"==e.direction?Math.abs(this.sx0[C]-y)<=N&&u.push(C):Math.abs(this.sy0[C]-x)<=N&&u.push(C))}}catch(e){r={error:e}}finally{try{b&&!b.done&&(n=M.return)&&n.call(M)}finally{if(r)throw r.error}}return new c.Selection({indices:u})},t.prototype.scenterxy=function(e){return[(this.sx0[e]+this.sx1[e])/2,(this.sy0[e]+this.sy1[e])/2]},t.prototype.draw_legend_for_index=function(e,t,i){d.generic_line_legend(this.visuals,e,t,i)},t}(l.GlyphView);i.SegmentView=y,y.__name__="SegmentView";var x=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_Segment=function(){this.prototype.default_view=y,this.define((function(e){return{x0:[_.XCoordinateSpec,{field:"x0"}],y0:[_.YCoordinateSpec,{field:"y0"}],x1:[_.XCoordinateSpec,{field:"x1"}],y1:[_.YCoordinateSpec,{field:"y1"}]}})),this.mixins(o.LineVector)},t}(l.Glyph);i.Segment=x,x.__name__="Segment",x.init_Segment()},
function _(e,t,n,i,r){i();var o=e(1),a=e(213),_=e(214),l=e(143),s=e(135),d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._render=function(e,t,n){var i,r,a,_,l,s,d,u,f=n.sx,c=n.sy,h=!1,v=null;this.visuals.line.set_value(e);var p=t.length;if(!(p<2)){e.beginPath(),e.moveTo(f[0],c[0]);try{for(var y=o.__values(t),w=y.next();!w.done;w=y.next()){var b=w.value,m=void 0,x=void 0,g=void 0,S=void 0;switch(this.model.mode){case"before":m=(a=o.__read([f[b-1],c[b]],2))[0],g=a[1],x=(_=o.__read([f[b],c[b]],2))[0],S=_[1];break;case"after":m=(l=o.__read([f[b],c[b-1]],2))[0],g=l[1],x=(s=o.__read([f[b],c[b]],2))[0],S=s[1];break;case"center":var k=(f[b-1]+f[b])/2;m=(d=o.__read([k,c[b-1]],2))[0],g=d[1],x=(u=o.__read([k,c[b]],2))[0],S=u[1];break;default:throw new Error("unexpected")}if(h){if(!isFinite(f[b]+c[b])){e.stroke(),e.beginPath(),h=!1,v=b;continue}null!=v&&b-v>1&&(e.stroke(),h=!1)}h?(e.lineTo(m,g),e.lineTo(x,S)):(e.beginPath(),e.moveTo(f[b],c[b]),h=!0),v=b}}catch(e){i={error:e}}finally{try{w&&!w.done&&(r=y.return)&&r.call(y)}finally{if(i)throw i.error}}e.lineTo(f[p-1],c[p-1]),e.stroke()}},t.prototype.draw_legend_for_index=function(e,t,n){_.generic_line_legend(this.visuals,e,t,n)},t}(a.XYGlyphView);n.StepView=d,d.__name__="StepView";var u=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_Step=function(){this.prototype.default_view=d,this.mixins(l.LineVector),this.define((function(){return{mode:[s.StepMode,"before"]}}))},t}(a.XYGlyph);n.Step=u,u.__name__="Step",u.init_Step()},
function _(t,e,s,i,r){i();var n=t(1),_=t(213),a=t(143),o=n.__importStar(t(215)),l=n.__importStar(t(133)),h=t(278),u=t(126),x=t(202),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._rotate_point=function(t,e,s,i,r){return[(t-s)*Math.cos(r)-(e-i)*Math.sin(r)+s,(t-s)*Math.sin(r)+(e-i)*Math.cos(r)+i]},e.prototype._text_bounds=function(t,e,s,i){return[[t,t+s,t+s,t,t],[e,e,e-i,e-i,e]]},e.prototype._render=function(t,e,s){var i,r,_,a,o=s.sx,l=s.sy,u=s._x_offset,x=s._y_offset,c=s._angle,f=s._text;this._sys=[],this._sxs=[];try{for(var p=n.__values(e),v=p.next();!v.done;v=p.next()){var y=v.value;if(this._sxs[y]=[],this._sys[y]=[],!isNaN(o[y]+l[y]+u[y]+x[y]+c[y])&&null!=f[y]&&this.visuals.text.doit){var d=""+f[y];t.save(),t.translate(o[y]+u[y],l[y]+x[y]),t.rotate(c[y]),this.visuals.text.set_vectorize(t,y);var g=this.visuals.text.cache_select("font",y),m=h.measure_font(g).height,w=this.visuals.text.text_line_height.value()*m;if(-1==d.indexOf("\n")){t.fillText(d,0,0);var b=o[y]+u[y],T=l[y]+x[y],S=t.measureText(d).width,N=n.__read(this._text_bounds(b,T,S,w),2),M=N[0],V=N[1];this._sxs[y].push(M),this._sys[y].push(V)}else{var k=d.split("\n"),G=w*k.length,X=this.visuals.text.cache_select("text_baseline",y),Y=void 0;switch(X){case"top":Y=0;break;case"middle":Y=-G/2+w/2;break;case"bottom":Y=-G+w;break;default:Y=0,console.warn("'"+X+"' baseline not supported with multi line text")}try{for(var z=(_=void 0,n.__values(k)),A=z.next();!A.done;A=z.next()){var O=A.value;t.fillText(O,0,Y);b=o[y]+u[y],T=Y+l[y]+x[y],S=t.measureText(O).width;var j=n.__read(this._text_bounds(b,T,S,w),2);M=j[0],V=j[1];this._sxs[y].push(M),this._sys[y].push(V),Y+=w}}catch(t){_={error:t}}finally{try{A&&!A.done&&(a=z.return)&&a.call(z)}finally{if(_)throw _.error}}}t.restore()}}}catch(t){i={error:t}}finally{try{v&&!v.done&&(r=p.return)&&r.call(p)}finally{if(i)throw i.error}}},e.prototype._hit_point=function(t){for(var e=t.sx,s=t.sy,i=[],r=0;r<this._sxs.length;r++)for(var _=this._sxs[r],a=this._sys[r],l=_.length,h=0,u=l;h<u;h++){var c=n.__read(this._rotate_point(e,s,_[l-1][0],a[l-1][0],-this._angle[r]),2),f=c[0],p=c[1];o.point_in_poly(f,p,_[h],a[h])&&i.push(r)}return new x.Selection({indices:i})},e.prototype.scenterxy=function(t){var e=this._sxs[t],s=this._sys[t];u.assert(0!=e.length&&0!=s.length);var i=e[0][0],r=s[0][0],_=(e[0][2]+i)/2,a=(s[0][2]+r)/2,o=n.__read(this._rotate_point(_,a,i,r,this._angle[t]),2);return[o[0],o[1]]},e}(_.XYGlyphView);s.TextView=c,c.__name__="TextView";var f=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Text=function(){this.prototype.default_view=c,this.mixins(a.TextVector),this.define((function(t){return{text:[l.NullStringSpec,{field:"text"}],angle:[l.AngleSpec,0],x_offset:[l.NumberSpec,0],y_offset:[l.NumberSpec,0]}}))},e}(_.XYGlyph);s.Text=f,f.__name__="Text",f.init_Text()},
function _(t,i,e,s,r){s();var o=t(1),h=t(383),n=t(139),_=o.__importStar(t(133)),a=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(i,t),i.prototype.scenterxy=function(t){return[this.sx[t],(this.stop[t]+this.sbottom[t])/2]},i.prototype._lrtb=function(t){return[this._x[t]-this._width[t]/2,this._x[t]+this._width[t]/2,Math.max(this._top[t],this._bottom[t]),Math.min(this._top[t],this._bottom[t])]},i.prototype._map_data=function(){this.sx=this.renderer.xscale.v_compute(this._x),this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"),this.stop=this.renderer.yscale.v_compute(this._top),this.sbottom=this.renderer.yscale.v_compute(this._bottom);var t=this.sx.length;this.sleft=new n.NumberArray(t),this.sright=new n.NumberArray(t);for(var i=0;i<t;i++)this.sleft[i]=this.sx[i]-this.sw[i]/2,this.sright[i]=this.sx[i]+this.sw[i]/2;this._clamp_viewport()},i}(h.BoxView);e.VBarView=a,a.__name__="VBarView";var p=function(t){function i(i){return t.call(this,i)||this}return o.__extends(i,t),i.init_VBar=function(){this.prototype.default_view=a,this.define((function(t){return{x:[_.XCoordinateSpec,{field:"x"}],bottom:[_.YCoordinateSpec,{value:0}],width:[_.NumberSpec,{value:1}],top:[_.YCoordinateSpec,{field:"top"}]}}))},i}(h.Box);e.VBar=p,p.__name__="VBar",p.init_VBar()},
function _(e,t,r,i,n){i();var s=e(1),a=e(213),l=e(214),o=e(143),_=e(135),d=s.__importStar(e(133)),h=e(125),c=e(202),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype._map_data=function(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius},t.prototype._render=function(e,t,r){var i,n,a=r.sx,l=r.sy,o=r.sradius,_=r._start_angle,d=r._end_angle,h="anticlock"==this.model.direction;try{for(var c=s.__values(t),u=c.next();!u.done;u=c.next()){var p=u.value;isNaN(a[p]+l[p]+o[p]+_[p]+d[p])||(e.beginPath(),e.arc(a[p],l[p],o[p],_[p],d[p],h),e.lineTo(a[p],l[p]),e.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,p),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,p),e.stroke()))}}catch(e){i={error:e}}finally{try{u&&!u.done&&(n=c.return)&&n.call(c)}finally{if(i)throw i.error}}},t.prototype._hit_point=function(e){var t,r,i,n,a,l,o,_,d,u,p,y,v,f,x,g,w=e.sx,m=e.sy,M=this.renderer.xscale.invert(w),W=this.renderer.yscale.invert(m),S=2*this.max_radius;"data"===this.model.properties.radius.units?(v=M-S,f=M+S,x=W-S,g=W+S):(d=w-S,u=w+S,v=(t=s.__read(this.renderer.xscale.r_invert(d,u),2))[0],f=t[1],p=m-S,y=m+S,x=(r=s.__read(this.renderer.yscale.r_invert(p,y),2))[0],g=r[1]);var V=[];try{for(var k=s.__values(this.index.indices({x0:v,x1:f,y0:x,y1:g})),b=k.next();!b.done;b=k.next()){var z=b.value,A=Math.pow(this.sradius[z],2);d=(a=s.__read(this.renderer.xscale.r_compute(M,this._x[z]),2))[0],u=a[1],p=(l=s.__read(this.renderer.yscale.r_compute(W,this._y[z]),2))[0],y=l[1],Math.pow(d-u,2)+Math.pow(p-y,2)<=A&&V.push(z)}}catch(e){i={error:e}}finally{try{b&&!b.done&&(n=k.return)&&n.call(k)}finally{if(i)throw i.error}}var D="anticlock"==this.model.direction,G=[];try{for(var N=s.__values(V),P=N.next();!P.done;P=N.next()){z=P.value;var X=Math.atan2(m-this.sy[z],w-this.sx[z]);h.angle_between(-X,-this._start_angle[z],-this._end_angle[z],D)&&G.push(z)}}catch(e){o={error:e}}finally{try{P&&!P.done&&(_=N.return)&&_.call(N)}finally{if(o)throw o.error}}return new c.Selection({indices:G})},t.prototype.draw_legend_for_index=function(e,t,r){l.generic_area_legend(this.visuals,e,t,r)},t.prototype.scenterxy=function(e){var t=this.sradius[e]/2,r=(this._start_angle[e]+this._end_angle[e])/2;return[this.sx[e]+t*Math.cos(r),this.sy[e]+t*Math.sin(r)]},t}(a.XYGlyphView);r.WedgeView=u,u.__name__="WedgeView";var p=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_Wedge=function(){this.prototype.default_view=u,this.mixins([o.LineVector,o.FillVector]),this.define((function(e){return{direction:[_.Direction,"anticlock"],radius:[d.DistanceSpec],start_angle:[d.AngleSpec],end_angle:[d.AngleSpec]}}))},t}(a.XYGlyph);r.Wedge=p,p.__name__="Wedge",p.init_Wedge()},
function _(r,t,_,a,o){a();var e=r(1);e.__exportStar(r(233),_),e.__exportStar(r(232),_),e.__exportStar(r(402),_)},
function _(t,a,r,n,i){n();var o=t(1),u=t(232),e=t(139),l=function(t){function a(a){return t.call(this,a)||this}return o.__extends(a,t),a.init_StaticLayoutProvider=function(){this.define((function(t){var a=t.Number,r=t.Tuple;return{graph_layout:[(0,t.Dict)(r(a,a)),{}]}}))},a.prototype.get_node_coordinates=function(t){for(var a,r=null!==(a=t.data.index)&&void 0!==a?a:[],n=r.length,i=new e.NumberArray(n),u=new e.NumberArray(n),l=0;l<n;l++){var d=this.graph_layout[r[l]],h=o.__read(null!=d?d:[NaN,NaN],2),s=h[0],_=h[1];i[l]=s,u[l]=_}return[i,u]},a.prototype.get_edge_coordinates=function(t){for(var a,r,n=null!==(a=t.data.start)&&void 0!==a?a:[],i=null!==(r=t.data.end)&&void 0!==r?r:[],o=Math.min(n.length,i.length),u=[],e=[],l=null!=t.data.xs&&null!=t.data.ys,d=0;d<o;d++){var h=null!=this.graph_layout[n[d]]&&null!=this.graph_layout[i[d]];if(l&&h)u.push(t.data.xs[d]),e.push(t.data.ys[d]);else{var s=void 0,_=void 0;h?(s=this.graph_layout[n[d]],_=this.graph_layout[i[d]]):(s=[NaN,NaN],_=[NaN,NaN]),u.push([s[0],_[0]]),e.push([s[1],_[1]])}}return[u,e]},a}(u.LayoutProvider);r.StaticLayoutProvider=l,l.__name__="StaticLayoutProvider",l.init_StaticLayoutProvider()},
function _(i,d,n,r,G){r(),G("Grid",i(404).Grid)},
function _(i,r,e,t,n){t();var o=i(1),a=i(315),s=i(317),_=i(246),d=o.__importStar(i(143)),l=i(123),u=function(i){function r(){return null!==i&&i.apply(this,arguments)||this}return o.__extends(r,i),r.prototype._render=function(){var i=this.layer.ctx;i.save(),this._draw_regions(i),this._draw_minor_grids(i),this._draw_grids(i),i.restore()},r.prototype.connect_signals=function(){var r=this;i.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return r.request_render()}))},r.prototype._draw_regions=function(i){var r=this;if(this.visuals.band_fill.doit||this.visuals.band_hatch.doit){this.visuals.band_fill.set_value(i);for(var e=o.__read(this.grid_coords("major",!1),2),t=e[0],n=e[1],a=function(e){if(e%2!=1)return"continue";var a=o.__read(s.coordinates.map_to_screen(t[e],n[e]),2),_=a[0],d=a[1],l=o.__read(s.coordinates.map_to_screen(t[e+1],n[e+1]),2),u=l[0],h=l[1];s.visuals.band_fill.doit&&i.fillRect(_[0],d[0],u[1]-_[0],h[1]-d[0]),s.visuals.band_hatch.doit2(i,e,(function(){i.fillRect(_[0],d[0],u[1]-_[0],h[1]-d[0])}),(function(){return r.request_render()}))},s=this,_=0;_<t.length-1;_++)a(_)}},r.prototype._draw_grids=function(i){if(this.visuals.grid_line.doit){var r=o.__read(this.grid_coords("major"),2),e=r[0],t=r[1];this._draw_grid_helper(i,this.visuals.grid_line,e,t)}},r.prototype._draw_minor_grids=function(i){if(this.visuals.minor_grid_line.doit){var r=o.__read(this.grid_coords("minor"),2),e=r[0],t=r[1];this._draw_grid_helper(i,this.visuals.minor_grid_line,e,t)}},r.prototype._draw_grid_helper=function(i,r,e,t){r.set_value(i),i.beginPath();for(var n=0;n<e.length;n++){var a=o.__read(this.coordinates.map_to_screen(e[n],t[n]),2),s=a[0],_=a[1];i.moveTo(Math.round(s[0]),Math.round(_[0]));for(var d=1;d<s.length;d++)i.lineTo(Math.round(s[d]),Math.round(_[d]))}i.stroke()},r.prototype.ranges=function(){var i=this.model.dimension,r=(i+1)%2,e=this.coordinates.ranges;return[e[i],e[r]]},r.prototype.computed_bounds=function(){var i,r,e,t,n,a,s=o.__read(this.ranges(),1)[0],_=this.model.bounds,d=[s.min,s.max];if(l.isArray(_))n=Math.min(_[0],_[1]),a=Math.max(_[0],_[1]),n<d[0]&&(n=d[0]),a>d[1]&&(a=d[1]);else{n=(i=o.__read(d,2))[0],a=i[1];try{for(var u=o.__values(this.plot_view.axis_views),h=u.next();!h.done;h=u.next()){var c=h.value;c.dimension==this.model.dimension&&c.model.x_range_name==this.model.x_range_name&&c.model.y_range_name==this.model.y_range_name&&(n=(t=o.__read(c.computed_bounds,2))[0],a=t[1])}}catch(i){r={error:i}}finally{try{h&&!h.done&&(e=u.return)&&e.call(u)}finally{if(r)throw r.error}}}return[n,a]},r.prototype.grid_coords=function(i,r){var e;void 0===r&&(r=!0);var t=this.model.dimension,n=(t+1)%2,a=o.__read(this.ranges(),2),s=a[0],_=a[1],d=o.__read(this.computed_bounds(),2),l=d[0],u=d[1];l=(e=o.__read([Math.min(l,u),Math.max(l,u)],2))[0],u=e[1];var h=[[],[]],c=this.model.get_ticker();if(null==c)return h;var m=c.get_ticks(l,u,s,_.min)[i],f=s.min,p=s.max,v=_.min,g=_.max;r||(m[0]!=f&&m.splice(0,0,f),m[m.length-1]!=p&&m.push(p));for(var y=0;y<m.length;y++)if(m[y]!=f&&m[y]!=p||!r){for(var x=[],b=[],w=0;w<2;w++){var k=v+(g-v)/1*w;x.push(m[y]),b.push(k)}h[t].push(x),h[n].push(b)}return h},r}(s.GuideRendererView);e.GridView=u,u.__name__="GridView";var h=function(i){function r(r){return i.call(this,r)||this}return o.__extends(r,i),r.init_Grid=function(){this.prototype.default_view=u,this.mixins([["grid_",d.Line],["minor_grid_",d.Line],["band_",d.Fill],["band_",d.Hatch]]),this.define((function(i){var r=i.Number,e=i.Auto,t=i.Enum,n=i.Ref,o=i.Tuple;return{bounds:[(0,i.Or)(o(r,r),e),"auto"],dimension:[t(0,1),0],axis:[n(a.Axis)],ticker:[n(_.Ticker)]}})),this.override({level:"underlay",band_fill_color:null,band_fill_alpha:0,grid_line_color:"#e5e5e5",minor_grid_line_color:null})},r.prototype.get_ticker=function(){return null!=this.ticker?this.ticker:null!=this.axis?this.axis.ticker:null},r}(s.GuideRenderer);e.Grid=h,h.__name__="Grid",h.init_Grid()},
function _(o,a,x,B,e){B(),e("Box",o(406).Box),e("Column",o(409).Column),e("GridBox",o(410).GridBox),e("HTMLBox",o(411).HTMLBox),e("LayoutDOM",o(407).LayoutDOM),e("Panel",o(412).Panel),e("Row",o(413).Row),e("Spacer",o(414).Spacer),e("Tabs",o(415).Tabs),e("WidgetBox",o(420).WidgetBox)},
function _(n,t,e,i,o){i();var r=n(1),c=n(407),u=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.connect_signals=function(){var t=this;n.prototype.connect_signals.call(this),this.connect(this.model.properties.children.change,(function(){return t.rebuild()}))},Object.defineProperty(t.prototype,"child_models",{get:function(){return this.model.children},enumerable:!1,configurable:!0}),t}(c.LayoutDOMView);e.BoxView=u,u.__name__="BoxView";var a=function(n){function t(t){return n.call(this,t)||this}return r.__extends(t,n),t.init_Box=function(){this.define((function(n){var t=n.Number;return{children:[(0,n.Array)((0,n.Ref)(c.LayoutDOM)),[]],spacing:[t,0]}}))},t}(c.LayoutDOM);e.Box=a,a.__name__="Box",a.init_Box()},
function _(t,i,e,o,n){o();var r=t(1),l=t(196),a=t(135),s=t(187),h=t(134),u=t(123),_=t(230),c=t(193),d=t(351),p=t(408),f=t(192),y=function(t){function i(){var i=t.apply(this,r.__spread(arguments))||this;return i._idle_notified=!1,i._offset_parent=null,i._viewport={},i}return r.__extends(i,t),i.prototype.initialize=function(){t.prototype.initialize.call(this),this.el.style.position=this.is_root?"relative":"absolute",this._child_views=new Map},i.prototype.lazy_initialize=function(){return r.__awaiter(this,void 0,void 0,(function(){return r.__generator(this,(function(i){switch(i.label){case 0:return[4,t.prototype.lazy_initialize.call(this)];case 1:return i.sent(),[4,this.build_child_views()];case 2:return i.sent(),[2]}}))}))},i.prototype.remove=function(){var i,e;try{for(var o=r.__values(this.child_views),n=o.next();!n.done;n=o.next()){n.value.remove()}}catch(t){i={error:t}}finally{try{n&&!n.done&&(e=o.return)&&e.call(o)}finally{if(i)throw i.error}}this._child_views.clear(),t.prototype.remove.call(this)},i.prototype.connect_signals=function(){var i=this;t.prototype.connect_signals.call(this),this.is_root&&(this._on_resize=function(){return i.resize_layout()},window.addEventListener("resize",this._on_resize),this._parent_observer=setInterval((function(){var t=i.el.offsetParent;i._offset_parent!=t&&(i._offset_parent=t,null!=t&&(i.compute_viewport(),i.invalidate_layout()))}),250));var e=this.model.properties;this.on_change([e.width,e.height,e.min_width,e.min_height,e.max_width,e.max_height,e.margin,e.width_policy,e.height_policy,e.sizing_mode,e.aspect_ratio,e.visible],(function(){return i.invalidate_layout()})),this.on_change([e.background,e.css_classes],(function(){return i.invalidate_render()}))},i.prototype.disconnect_signals=function(){null!=this._parent_observer&&clearTimeout(this._parent_observer),null!=this._on_resize&&window.removeEventListener("resize",this._on_resize),t.prototype.disconnect_signals.call(this)},i.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(this.model.css_classes)},Object.defineProperty(i.prototype,"child_views",{get:function(){var t=this;return this.child_models.map((function(i){return t._child_views.get(i)}))},enumerable:!1,configurable:!0}),i.prototype.build_child_views=function(){return r.__awaiter(this,void 0,void 0,(function(){return r.__generator(this,(function(t){switch(t.label){case 0:return[4,_.build_views(this._child_views,this.child_models,{parent:this})];case 1:return t.sent(),[2]}}))}))},i.prototype.render=function(){var i,e,o;t.prototype.render.call(this),s.empty(this.el);var n=this.model.background;this.el.style.backgroundColor=null!=n?n:"",(i=s.classes(this.el).clear()).add.apply(i,r.__spread(this.css_classes()));try{for(var l=r.__values(this.child_views),a=l.next();!a.done;a=l.next()){var h=a.value;this.el.appendChild(h.el),h.render()}}catch(t){e={error:t}}finally{try{a&&!a.done&&(o=l.return)&&o.call(l)}finally{if(e)throw e.error}}},i.prototype.update_layout=function(){var t,i;try{for(var e=r.__values(this.child_views),o=e.next();!o.done;o=e.next()){o.value.update_layout()}}catch(i){t={error:i}}finally{try{o&&!o.done&&(i=e.return)&&i.call(e)}finally{if(t)throw t.error}}this._update_layout()},i.prototype.update_position=function(){var t,i;this.el.style.display=this.model.visible?"block":"none";var e=this.is_root?this.layout.sizing.margin:void 0;s.position(this.el,this.layout.bbox,e);try{for(var o=r.__values(this.child_views),n=o.next();!n.done;n=o.next()){n.value.update_position()}}catch(i){t={error:i}}finally{try{n&&!n.done&&(i=o.return)&&i.call(o)}finally{if(t)throw t.error}}},i.prototype.after_layout=function(){var t,i;try{for(var e=r.__values(this.child_views),o=e.next();!o.done;o=e.next()){o.value.after_layout()}}catch(i){t={error:i}}finally{try{o&&!o.done&&(i=e.return)&&i.call(e)}finally{if(t)throw t.error}}this._has_finished=!0},i.prototype.compute_viewport=function(){this._viewport=this._viewport_size()},i.prototype.renderTo=function(t){t.appendChild(this.el),this._offset_parent=this.el.offsetParent,this.compute_viewport(),this.build()},i.prototype.build=function(){return this.assert_root(),this.render(),this.update_layout(),this.compute_layout(),this},i.prototype.rebuild=function(){return r.__awaiter(this,void 0,void 0,(function(){return r.__generator(this,(function(t){switch(t.label){case 0:return[4,this.build_child_views()];case 1:return t.sent(),this.invalidate_render(),[2]}}))}))},i.prototype.compute_layout=function(){var t=Date.now();this.layout.compute(this._viewport),this.update_position(),this.after_layout(),h.logger.debug("layout computed in "+(Date.now()-t)+" ms"),this.notify_finished()},i.prototype.resize_layout=function(){this.root.compute_viewport(),this.root.compute_layout()},i.prototype.invalidate_layout=function(){this.root.update_layout(),this.root.compute_layout()},i.prototype.invalidate_render=function(){this.render(),this.invalidate_layout()},i.prototype.has_finished=function(){var i,e;if(!t.prototype.has_finished.call(this))return!1;try{for(var o=r.__values(this.child_views),n=o.next();!n.done;n=o.next()){if(!n.value.has_finished())return!1}}catch(t){i={error:t}}finally{try{n&&!n.done&&(e=o.return)&&e.call(o)}finally{if(i)throw i.error}}return!0},i.prototype.notify_finished=function(){this.is_root?!this._idle_notified&&this.has_finished()&&null!=this.model.document&&(this._idle_notified=!0,this.model.document.notify_idle(this.model)):this.root.notify_finished()},i.prototype._width_policy=function(){return null!=this.model.width?"fixed":"fit"},i.prototype._height_policy=function(){return null!=this.model.height?"fixed":"fit"},i.prototype.box_sizing=function(){var t,i=this.model,e=i.width_policy,o=i.height_policy,n=i.aspect_ratio;"auto"==e&&(e=this._width_policy()),"auto"==o&&(o=this._height_policy());var l=this.model.sizing_mode;if(null!=l)if("fixed"==l)e=o="fixed";else if("stretch_both"==l)e=o="max";else if("stretch_width"==l)e="max";else if("stretch_height"==l)o="max";else switch(null==n&&(n="auto"),l){case"scale_width":e="max",o="min";break;case"scale_height":e="min",o="max";break;case"scale_both":e="max",o="max"}var a={width_policy:e,height_policy:o},s=this.model,h=s.min_width,_=s.min_height;null!=h&&(a.min_width=h),null!=_&&(a.min_height=_);var c=this.model,d=c.width,p=c.height;null!=d&&(a.width=d),null!=p&&(a.height=p);var f=this.model,y=f.max_width,v=f.max_height;null!=y&&(a.max_width=y),null!=v&&(a.max_height=v),"auto"==n&&null!=d&&null!=p?a.aspect=d/p:u.isNumber(n)&&(a.aspect=n);var m=this.model.margin;if(null!=m)if(u.isNumber(m))a.margin={top:m,right:m,bottom:m,left:m};else if(2==m.length){var g=r.__read(m,2),w=g[0],b=g[1];a.margin={top:w,right:b,bottom:w,left:b}}else{var x=r.__read(m,4),z=x[0],M=x[1],O=x[2],L=x[3];a.margin={top:z,right:M,bottom:O,left:L}}a.visible=this.model.visible;var D=this.model.align;return u.isArray(D)?(t=r.__read(D,2),a.halign=t[0],a.valign=t[1]):a.halign=a.valign=D,a},i.prototype._viewport_size=function(){var t=this;return s.undisplayed(this.el,(function(){for(var i=t.el;i=i.parentElement;)if(!i.classList.contains(p.bk_root)){if(i==document.body){var e=s.extents(document.body).margin,o=e.left,n=e.right,r=e.top,l=e.bottom;return{width:Math.ceil(document.documentElement.clientWidth-o-n),height:Math.ceil(document.documentElement.clientHeight-r-l)}}var a=s.extents(i).padding,h=a.left,u=a.right,_=a.top,c=a.bottom,d=i.getBoundingClientRect(),f=d.width,y=d.height,v=Math.ceil(f-h-u),m=Math.ceil(y-_-c);if(v>0||m>0)return{width:v>0?v:void 0,height:m>0?m:void 0}}return{}}))},i.prototype.export=function(t,i){var e,o;void 0===i&&(i=!0);var n="png"==t?"canvas":"svg",l=new f.CanvasLayer(n,i),a=this.layout.bbox,s=a.width,h=a.height;l.resize(s,h);try{for(var u=r.__values(this.child_views),_=u.next();!_.done;_=u.next()){var c=_.value,d=c.export(t,i),p=c.layout.bbox,y=p.x,v=p.y;l.ctx.drawImage(d.canvas,y,v)}}catch(t){e={error:t}}finally{try{_&&!_.done&&(o=u.return)&&o.call(u)}finally{if(e)throw e.error}}return l},i.prototype.serializable_state=function(){return Object.assign(Object.assign({},t.prototype.serializable_state.call(this)),{bbox:this.layout.bbox.box,children:this.child_views.map((function(t){return t.serializable_state()}))})},i}(c.DOMView);e.LayoutDOMView=y,y.__name__="LayoutDOMView";var v=function(t){function i(i){return t.call(this,i)||this}return r.__extends(i,t),i.init_LayoutDOM=function(){this.define((function(t){var i=t.Boolean,e=t.Number,o=t.String,n=t.Auto,r=t.Color,l=t.Array,s=t.Tuple,h=t.Or,u=t.Null,_=t.Nullable,c=s(e,e),p=s(e,e,e,e);return{width:[_(e),null],height:[_(e),null],min_width:[_(e),null],min_height:[_(e),null],max_width:[_(e),null],max_height:[_(e),null],margin:[_(h(e,c,p)),[0,0,0,0]],width_policy:[h(d.SizingPolicy,n),"auto"],height_policy:[h(d.SizingPolicy,n),"auto"],aspect_ratio:[h(e,n,u),null],sizing_mode:[_(a.SizingMode),null],visible:[i,!0],disabled:[i,!1],align:[h(a.Align,s(a.Align,a.Align)),"start"],background:[_(r),null],css_classes:[l(o),[]]}}))},i}(l.Model);e.LayoutDOM=v,v.__name__="LayoutDOM",v.init_LayoutDOM()},
function _(o,t,b,k,n){k(),b.bk_root="bk-root"},
function _(t,n,i,o,u){o();var e=t(1),s=t(406),l=t(355),_=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return e.__extends(n,t),n.prototype._update_layout=function(){var t=this.child_views.map((function(t){return t.layout}));this.layout=new l.Column(t),this.layout.rows=this.model.rows,this.layout.spacing=[this.model.spacing,0],this.layout.set_sizing(this.box_sizing())},n}(s.BoxView);i.ColumnView=_,_.__name__="ColumnView";var r=function(t){function n(n){return t.call(this,n)||this}return e.__extends(n,t),n.init_Column=function(){this.prototype.default_view=_,this.define((function(t){return{rows:[t.Any,"auto"]}}))},n}(s.Box);i.Column=r,r.__name__="Column",r.init_Column()},
function _(t,i,o,n,e){n();var r=t(1),s=t(407),a=t(355),l=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(i,t),i.prototype.connect_signals=function(){var i=this;t.prototype.connect_signals.call(this);var o=this.model.properties,n=o.children,e=o.rows,r=o.cols,s=o.spacing;this.on_change([n,e,r,s],(function(){return i.rebuild()}))},Object.defineProperty(i.prototype,"child_models",{get:function(){return this.model.children.map((function(t){return r.__read(t,1)[0]}))},enumerable:!1,configurable:!0}),i.prototype._update_layout=function(){var t,i;this.layout=new a.Grid,this.layout.rows=this.model.rows,this.layout.cols=this.model.cols,this.layout.spacing=this.model.spacing;try{for(var o=r.__values(this.model.children),n=o.next();!n.done;n=o.next()){var e=r.__read(n.value,5),s=e[0],l=e[1],u=e[2],c=e[3],_=e[4],h=this._child_views.get(s);this.layout.items.push({layout:h.layout,row:l,col:u,row_span:c,col_span:_})}}catch(i){t={error:i}}finally{try{n&&!n.done&&(i=o.return)&&i.call(o)}finally{if(t)throw t.error}}this.layout.set_sizing(this.box_sizing())},i}(s.LayoutDOMView);o.GridBoxView=l,l.__name__="GridBoxView";var u=function(t){function i(i){return t.call(this,i)||this}return r.__extends(i,t),i.init_GridBox=function(){this.prototype.default_view=l,this.define((function(t){var i=t.Any,o=t.Int,n=t.Number,e=t.Tuple,r=t.Array,a=t.Ref,l=t.Or,u=t.Opt;return{children:[r(e(a(s.LayoutDOM),o,o,u(o),u(o))),[]],rows:[i,"auto"],cols:[i,"auto"],spacing:[l(n,e(n,n)),0]}}))},i}(s.LayoutDOM);o.GridBox=u,u.__name__="GridBox",u.init_GridBox()},
function _(t,n,e,o,i){o();var u=t(1),r=t(407),_=t(351),a=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return u.__extends(n,t),Object.defineProperty(n.prototype,"child_models",{get:function(){return[]},enumerable:!1,configurable:!0}),n.prototype._update_layout=function(){this.layout=new _.ContentBox(this.el),this.layout.set_sizing(this.box_sizing())},n}(r.LayoutDOMView);e.HTMLBoxView=a,a.__name__="HTMLBoxView";var s=function(t){function n(n){return t.call(this,n)||this}return u.__extends(n,t),n}(r.LayoutDOM);e.HTMLBox=s,s.__name__="HTMLBox"},
function _(n,t,e,i,l){i();var a=n(1),o=n(196),r=n(407),u=function(n){function t(t){return n.call(this,t)||this}return a.__extends(t,n),t.init_Panel=function(){this.define((function(n){var t=n.Boolean;return{title:[n.String,""],child:[(0,n.Ref)(r.LayoutDOM)],closable:[t,!1]}}))},t}(o.Model);e.Panel=u,u.__name__="Panel",u.init_Panel()},
function _(t,i,n,o,e){o();var s=t(1),u=t(406),_=t(355),a=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(i,t),i.prototype._update_layout=function(){var t=this.child_views.map((function(t){return t.layout}));this.layout=new _.Row(t),this.layout.cols=this.model.cols,this.layout.spacing=[0,this.model.spacing],this.layout.set_sizing(this.box_sizing())},i}(u.BoxView);n.RowView=a,a.__name__="RowView";var l=function(t){function i(i){return t.call(this,i)||this}return s.__extends(i,t),i.init_Row=function(){this.prototype.default_view=a,this.define((function(t){return{cols:[t.Any,"auto"]}}))},i}(u.Box);n.Row=l,l.__name__="Row",l.init_Row()},
function _(t,e,n,i,r){i();var o=t(1),u=t(407),a=t(351),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),Object.defineProperty(e.prototype,"child_models",{get:function(){return[]},enumerable:!1,configurable:!0}),e.prototype._update_layout=function(){this.layout=new a.LayoutItem,this.layout.set_sizing(this.box_sizing())},e}(u.LayoutDOMView);n.SpacerView=_,_.__name__="SpacerView";var c=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_Spacer=function(){this.prototype.default_view=_},e}(u.LayoutDOM);n.Spacer=c,c.__name__="Spacer",c.init_Spacer()},
function _(e,t,i,a,r){a();var l=e(1),s=e(351),n=e(187),o=e(124),h=e(135),c=e(407),d=e(412),_=e(303),u=e(416),p=e(417),v=e(301),b=l.__importDefault(e(418)),f=l.__importDefault(e(298)),y=l.__importDefault(e(419)),m=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return l.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.tabs.change,(function(){return t.rebuild()})),this.connect(this.model.properties.active.change,(function(){return t.on_active_change()}))},t.prototype.styles=function(){return l.__spread(e.prototype.styles.call(this),[b.default,f.default,y.default])},Object.defineProperty(t.prototype,"child_models",{get:function(){return this.model.tabs.map((function(e){return e.child}))},enumerable:!1,configurable:!0}),t.prototype._update_layout=function(){var e=this.model.tabs_location,t="above"==e||"below"==e,i=this.scroll_el,a=this.headers_el;this.header=new(function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return l.__extends(r,e),r.prototype._measure=function(r){var l=n.size(i),s=n.children(a).slice(0,3).map((function(e){return n.size(e)})),h=e.prototype._measure.call(this,r),c=h.width,d=h.height;if(t){var _=l.width+o.sum(s.map((function(e){return e.width})));return{width:r.width!=1/0?r.width:_,height:d}}var u=l.height+o.sum(s.map((function(e){return e.height})));return{width:c,height:r.height!=1/0?r.height:u}},r}(s.ContentBox))(this.header_el),t?this.header.set_sizing({width_policy:"fit",height_policy:"fixed"}):this.header.set_sizing({width_policy:"fixed",height_policy:"fit"});var r=1,h=1;switch(e){case"above":r-=1;break;case"below":r+=1;break;case"left":h-=1;break;case"right":h+=1}var c={layout:this.header,row:r,col:h},d=this.child_views.map((function(e){return{layout:e.layout,row:1,col:1}}));this.layout=new s.Grid(l.__spread([c],d)),this.layout.set_sizing(this.box_sizing())},t.prototype.update_position=function(){var t,i;e.prototype.update_position.call(this),this.header_el.style.position="absolute",n.position(this.header_el,this.header.bbox);var a=this.model.tabs_location,r="above"==a||"below"==a,s=n.size(this.scroll_el),o=n.scroll_size(this.headers_el);if(r){var h=this.header.bbox.width;o.width>h?(this.wrapper_el.style.maxWidth=h-s.width+"px",n.display(this.scroll_el)):(this.wrapper_el.style.maxWidth="",n.undisplay(this.scroll_el))}else{var c=this.header.bbox.height;o.height>c?(this.wrapper_el.style.maxHeight=c-s.height+"px",n.display(this.scroll_el)):(this.wrapper_el.style.maxHeight="",n.undisplay(this.scroll_el))}var d=this.child_views;try{for(var _=l.__values(d),u=_.next();!u.done;u=_.next()){var p=u.value;n.hide(p.el)}}catch(e){t={error:e}}finally{try{u&&!u.done&&(i=_.return)&&i.call(_)}finally{if(t)throw t.error}}var v=d[this.model.active];null!=v&&n.show(v.el)},t.prototype.render=function(){var t=this;e.prototype.render.call(this);var i=this.model.active,a=this.model.tabs_location,r="above"==a||"below"==a,l=this.model.tabs.map((function(e,a){var r=n.div({class:[u.bk_tab,a==i?_.bk_active:null]},e.title);if(r.addEventListener("click",(function(e){e.target==e.currentTarget&&t.change_active(a)})),e.closable){var l=n.div({class:u.bk_close});l.addEventListener("click",(function(e){if(e.target==e.currentTarget){t.model.tabs=o.remove_at(t.model.tabs,a);var i=t.model.tabs.length;t.model.active>i-1&&(t.model.active=i-1)}})),r.appendChild(l)}return r}));this.headers_el=n.div({class:[u.bk_headers]},l),this.wrapper_el=n.div({class:u.bk_headers_wrapper},this.headers_el);var s=n.div({class:[p.bk_btn,p.bk_btn_default],disabled:""},n.div({class:[v.bk_caret,_.bk_left]})),h=n.div({class:[p.bk_btn,p.bk_btn_default]},n.div({class:[v.bk_caret,_.bk_right]})),c=0,d=function(e){return function(){var i=t.model.tabs.length;0==(c="left"==e?Math.max(c-1,0):Math.min(c+1,i-1))?s.setAttribute("disabled",""):s.removeAttribute("disabled"),c==i-1?h.setAttribute("disabled",""):h.removeAttribute("disabled");var a=n.children(t.headers_el).slice(0,c).map((function(e){return e.getBoundingClientRect()}));if(r){var l=-o.sum(a.map((function(e){return e.width})));t.headers_el.style.left=l+"px"}else{var d=-o.sum(a.map((function(e){return e.height})));t.headers_el.style.top=d+"px"}}};s.addEventListener("click",d("left")),h.addEventListener("click",d("right")),this.scroll_el=n.div({class:p.bk_btn_group},s,h),this.header_el=n.div({class:[u.bk_tabs_header,_.bk_side(a)]},this.scroll_el,this.wrapper_el),this.el.appendChild(this.header_el)},t.prototype.change_active=function(e){e!=this.model.active&&(this.model.active=e)},t.prototype.on_active_change=function(){var e,t,i,a,r=this.model.active,s=n.children(this.headers_el);try{for(var o=l.__values(s),h=o.next();!h.done;h=o.next()){h.value.classList.remove(_.bk_active)}}catch(t){e={error:t}}finally{try{h&&!h.done&&(t=o.return)&&t.call(o)}finally{if(e)throw e.error}}s[r].classList.add(_.bk_active);var c=this.child_views;try{for(var d=l.__values(c),u=d.next();!u.done;u=d.next()){var p=u.value;n.hide(p.el)}}catch(e){i={error:e}}finally{try{u&&!u.done&&(a=d.return)&&a.call(d)}finally{if(i)throw i.error}}n.show(c[r].el)},t}(c.LayoutDOMView);i.TabsView=m,m.__name__="TabsView";var g=function(e){function t(t){return e.call(this,t)||this}return l.__extends(t,e),t.init_Tabs=function(){this.prototype.default_view=m,this.define((function(e){var t=e.Int;return{tabs:[(0,e.Array)((0,e.Ref)(d.Panel)),[]],tabs_location:[h.Location,"above"],active:[t,0]}}))},t}(c.LayoutDOM);i.Tabs=g,g.__name__="Tabs",g.init_Tabs()},
function _(e,b,a,k,r){k(),a.bk_tabs_header="bk-tabs-header",a.bk_headers_wrapper="bk-headers-wrapper",a.bk_headers="bk-headers",a.bk_tab="bk-tab",a.bk_close="bk-close"},
function _(n,b,t,r,_){r(),t.bk_btn="bk-btn",t.bk_btn_group="bk-btn-group",t.bk_btn_default="bk-btn-default",t.bk_btn_primary="bk-btn-primary",t.bk_btn_success="bk-btn-success",t.bk_btn_warning="bk-btn-warning",t.bk_btn_danger="bk-btn-danger",t.bk_btn_type=function(n){switch(n){case"default":return t.bk_btn_default;case"primary":return t.bk_btn_primary;case"success":return t.bk_btn_success;case"warning":return t.bk_btn_warning;case"danger":return t.bk_btn_danger}},t.bk_dropdown_toggle="bk-dropdown-toggle"},
function _(n,o,b,r,e){r();b.default="\n.bk-root .bk-btn {\n  height: 100%;\n  display: inline-block;\n  text-align: center;\n  vertical-align: middle;\n  white-space: nowrap;\n  cursor: pointer;\n  padding: 6px 12px;\n  font-size: 12px;\n  border: 1px solid transparent;\n  border-radius: 4px;\n  outline: 0;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-btn:hover,\n.bk-root .bk-btn:focus {\n  text-decoration: none;\n}\n.bk-root .bk-btn:active,\n.bk-root .bk-btn.bk-active {\n  background-image: none;\n  box-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125);\n}\n.bk-root .bk-btn[disabled] {\n  cursor: not-allowed;\n  pointer-events: none;\n  opacity: 0.65;\n  box-shadow: none;\n}\n.bk-root .bk-btn-default {\n  color: #333;\n  background-color: #fff;\n  border-color: #ccc;\n}\n.bk-root .bk-btn-default:hover {\n  background-color: #f5f5f5;\n  border-color: #b8b8b8;\n}\n.bk-root .bk-btn-default.bk-active {\n  background-color: #ebebeb;\n  border-color: #adadad;\n}\n.bk-root .bk-btn-default[disabled],\n.bk-root .bk-btn-default[disabled]:hover,\n.bk-root .bk-btn-default[disabled]:focus,\n.bk-root .bk-btn-default[disabled]:active,\n.bk-root .bk-btn-default[disabled].bk-active {\n  background-color: #e6e6e6;\n  border-color: #ccc;\n}\n.bk-root .bk-btn-primary {\n  color: #fff;\n  background-color: #428bca;\n  border-color: #357ebd;\n}\n.bk-root .bk-btn-primary:hover {\n  background-color: #3681c1;\n  border-color: #2c699e;\n}\n.bk-root .bk-btn-primary.bk-active {\n  background-color: #3276b1;\n  border-color: #285e8e;\n}\n.bk-root .bk-btn-primary[disabled],\n.bk-root .bk-btn-primary[disabled]:hover,\n.bk-root .bk-btn-primary[disabled]:focus,\n.bk-root .bk-btn-primary[disabled]:active,\n.bk-root .bk-btn-primary[disabled].bk-active {\n  background-color: #506f89;\n  border-color: #357ebd;\n}\n.bk-root .bk-btn-success {\n  color: #fff;\n  background-color: #5cb85c;\n  border-color: #4cae4c;\n}\n.bk-root .bk-btn-success:hover {\n  background-color: #4eb24e;\n  border-color: #409240;\n}\n.bk-root .bk-btn-success.bk-active {\n  background-color: #47a447;\n  border-color: #398439;\n}\n.bk-root .bk-btn-success[disabled],\n.bk-root .bk-btn-success[disabled]:hover,\n.bk-root .bk-btn-success[disabled]:focus,\n.bk-root .bk-btn-success[disabled]:active,\n.bk-root .bk-btn-success[disabled].bk-active {\n  background-color: #667b66;\n  border-color: #4cae4c;\n}\n.bk-root .bk-btn-warning {\n  color: #fff;\n  background-color: #f0ad4e;\n  border-color: #eea236;\n}\n.bk-root .bk-btn-warning:hover {\n  background-color: #eea43b;\n  border-color: #e89014;\n}\n.bk-root .bk-btn-warning.bk-active {\n  background-color: #ed9c28;\n  border-color: #d58512;\n}\n.bk-root .bk-btn-warning[disabled],\n.bk-root .bk-btn-warning[disabled]:hover,\n.bk-root .bk-btn-warning[disabled]:focus,\n.bk-root .bk-btn-warning[disabled]:active,\n.bk-root .bk-btn-warning[disabled].bk-active {\n  background-color: #c89143;\n  border-color: #eea236;\n}\n.bk-root .bk-btn-danger {\n  color: #fff;\n  background-color: #d9534f;\n  border-color: #d43f3a;\n}\n.bk-root .bk-btn-danger:hover {\n  background-color: #d5433e;\n  border-color: #bd2d29;\n}\n.bk-root .bk-btn-danger.bk-active {\n  background-color: #d2322d;\n  border-color: #ac2925;\n}\n.bk-root .bk-btn-danger[disabled],\n.bk-root .bk-btn-danger[disabled]:hover,\n.bk-root .bk-btn-danger[disabled]:focus,\n.bk-root .bk-btn-danger[disabled]:active,\n.bk-root .bk-btn-danger[disabled].bk-active {\n  background-color: #a55350;\n  border-color: #d43f3a;\n}\n.bk-root .bk-btn-group {\n  height: 100%;\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-btn-group > .bk-btn {\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n}\n.bk-root .bk-btn-group > .bk-btn + .bk-btn {\n  margin-left: -1px;\n}\n.bk-root .bk-btn-group > .bk-btn:first-child:not(:last-child) {\n  border-bottom-right-radius: 0;\n  border-top-right-radius: 0;\n}\n.bk-root .bk-btn-group > .bk-btn:not(:first-child):last-child {\n  border-bottom-left-radius: 0;\n  border-top-left-radius: 0;\n}\n.bk-root .bk-btn-group > .bk-btn:not(:first-child):not(:last-child) {\n  border-radius: 0;\n}\n.bk-root .bk-btn-group .bk-dropdown-toggle {\n  flex: 0 0 0;\n  -webkit-flex: 0 0 0;\n  padding: 6px 6px;\n}\n"},
function _(e,r,n,b,o){b();n.default='\n.bk-root .bk-tabs-header {\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  overflow: hidden;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-tabs-header .bk-btn-group {\n  height: auto;\n  margin-right: 5px;\n}\n.bk-root .bk-tabs-header .bk-btn-group > .bk-btn {\n  flex-grow: 0;\n  -webkit-flex-grow: 0;\n  height: auto;\n  padding: 4px 4px;\n}\n.bk-root .bk-tabs-header .bk-headers-wrapper {\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n  overflow: hidden;\n  color: #666666;\n}\n.bk-root .bk-tabs-header.bk-above .bk-headers-wrapper {\n  border-bottom: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-right .bk-headers-wrapper {\n  border-left: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-below .bk-headers-wrapper {\n  border-top: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-left .bk-headers-wrapper {\n  border-right: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-above,\n.bk-root .bk-tabs-header.bk-below {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-tabs-header.bk-above .bk-headers,\n.bk-root .bk-tabs-header.bk-below .bk-headers {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-tabs-header.bk-left,\n.bk-root .bk-tabs-header.bk-right {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-tabs-header.bk-left .bk-headers,\n.bk-root .bk-tabs-header.bk-right .bk-headers {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-tabs-header .bk-headers {\n  position: relative;\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n}\n.bk-root .bk-tabs-header .bk-tab {\n  padding: 4px 8px;\n  border: solid transparent;\n  white-space: nowrap;\n  cursor: pointer;\n}\n.bk-root .bk-tabs-header .bk-tab:hover {\n  background-color: #f2f2f2;\n}\n.bk-root .bk-tabs-header .bk-tab.bk-active {\n  color: #4d4d4d;\n  background-color: white;\n  border-color: #e6e6e6;\n}\n.bk-root .bk-tabs-header .bk-tab .bk-close {\n  margin-left: 10px;\n}\n.bk-root .bk-tabs-header.bk-above .bk-tab {\n  border-width: 3px 1px 0px 1px;\n  border-radius: 4px 4px 0 0;\n}\n.bk-root .bk-tabs-header.bk-right .bk-tab {\n  border-width: 1px 3px 1px 0px;\n  border-radius: 0 4px 4px 0;\n}\n.bk-root .bk-tabs-header.bk-below .bk-tab {\n  border-width: 0px 1px 3px 1px;\n  border-radius: 0 0 4px 4px;\n}\n.bk-root .bk-tabs-header.bk-left .bk-tab {\n  border-width: 1px 0px 1px 3px;\n  border-radius: 4px 0 0 4px;\n}\n.bk-root .bk-close {\n  display: inline-block;\n  width: 10px;\n  height: 10px;\n  vertical-align: middle;\n  background-image: url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="gray" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="gray" stroke-width="2"/>      </svg>\');\n}\n.bk-root .bk-close:hover {\n  background-image: url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="red" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="red" stroke-width="2"/>      </svg>\');\n}\n'},
function _(t,i,n,e,o){e();var _=t(1),u=t(409),r=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(i,t),i}(u.ColumnView);n.WidgetBoxView=r,r.__name__="WidgetBoxView";var d=function(t){function i(i){return t.call(this,i)||this}return _.__extends(i,t),i.init_WidgetBox=function(){this.prototype.default_view=r},i}(u.Column);n.WidgetBox=d,d.__name__="WidgetBox",d.init_WidgetBox()},
function _(r,t,a,e,c){e(),r(1).__exportStar(r(422),a),c("Marker",r(423).Marker),c("Scatter",r(424).Scatter)},
function _(e,t,o,i,r){i();var n=e(1),s=e(423),c=n.__importStar(e(376)),a=Math.sqrt(3);function l(e,t){e.rotate(Math.PI/4),v(e,t),e.rotate(-Math.PI/4)}function u(e,t){var o=t*a,i=o/3;e.moveTo(-o/2,-i),e.lineTo(0,0),e.lineTo(o/2,-i),e.lineTo(0,0),e.lineTo(0,t)}function v(e,t){e.moveTo(0,t),e.lineTo(0,-t),e.moveTo(-t,0),e.lineTo(t,0)}function d(e,t){e.moveTo(0,t),e.lineTo(t/1.5,0),e.lineTo(0,-t),e.lineTo(-t/1.5,0),e.closePath()}function _(e,t){var o=t*a,i=o/3;e.moveTo(-t,i),e.lineTo(t,i),e.lineTo(0,i-o),e.closePath()}function f(e,t,o,i,r){v(e,o),l(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function T(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function z(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),v(e,o),e.stroke())}function C(e,t,o,i,r){T(e,t,o,i,r),g(e,t,o,i,r)}function h(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),u(e,o),e.stroke())}function k(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),l(e,o),e.stroke())}function m(e,t,o,i,r){v(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function q(e,t,o,i,r){d(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function P(e,t,o,i,r){d(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.moveTo(0,o),e.lineTo(0,-o),e.moveTo(-o/1.5,0),e.lineTo(o/1.5,0),e.stroke())}function D(e,t,o,i,r){q(e,t,o,i,r),g(e,t,o,i,r)}function g(e,t,o,i,r){!function(e,t){e.beginPath(),e.arc(0,0,t/4,0,2*Math.PI,!1),e.closePath()}(e,o),i.set_vectorize(e,t),e.fillStyle=e.strokeStyle,e.fill()}function S(e,t,o,i,r){!function(e,t){var o=t/2,i=a*o;e.moveTo(t,0),e.lineTo(o,-i),e.lineTo(-o,-i),e.lineTo(-t,0),e.lineTo(-o,i),e.lineTo(o,i),e.closePath()}(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function p(e,t,o,i,r){S(e,t,o,i,r),g(e,t,o,i)}function G(e,t,o,i,r){e.rotate(Math.PI),_(e,o),e.rotate(-Math.PI),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function L(e,t,o,i,r){var n=3*o/8,s=[n,n,o,o,n,n,-n,-n,-o,-o,-n,-n],c=[o,n,n,-n,-n,-o,-o,-n,-n,n,n,o];for(e.moveTo(s[0],c[0]),t=1;t<12;t++)e.lineTo(s[t],c[t]);e.closePath(),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function x(e,t,o,i,r){var n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function I(e,t,o,i,r){var n=3*o/8;e.moveTo(-o,-o),e.quadraticCurveTo(0,-n,o,-o),e.quadraticCurveTo(n,0,o,o),e.quadraticCurveTo(0,n,-o,o),e.quadraticCurveTo(-n,0,-o,-o),e.closePath(),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function M(e,t,o,i,r){var n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),v(e,o),e.stroke())}function y(e,t,o,i,r){x(e,t,o,i,r),g(e,t,o,i)}function X(e,t,o,i,r){var n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.moveTo(-o,o),e.lineTo(o,-o),e.moveTo(-o,-o),e.lineTo(o,o),e.stroke())}function H(e,t,o,i,r){_(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function Y(e,t,o,i,r){H(e,t,o,i,r),g(e,t,o,i)}function A(e,t,o,i,r){var n=o*a,s=n/3,c=3*s/8;e.moveTo(-o,s),e.quadraticCurveTo(0,c,o,s),e.quadraticCurveTo(a*c/2,c/2,0,s-n),e.quadraticCurveTo(-a*c/2,c/2,-o,s),e.closePath(),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function w(e,t,o,i,r){!function(e,t){e.moveTo(-t,0),e.lineTo(t,0)}(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function b(e,t,o,i,r){l(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function V(e,t,o,i,r){u(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function j(e,t,o){var i,r=function(e){function i(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(i,e),i.initClass=function(){this.prototype._render_one=t,this.prototype.glglyph_cls=o},i}(s.MarkerView);r.initClass();var c=((i=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.default_view=r},t}(s.Marker)).__name__=e,i);return c.initClass(),c}o.Asterisk=j("Asterisk",f,c.AsteriskGL),o.CircleCross=j("CircleCross",z,c.CircleCrossGL),o.CircleDot=j("CircleDot",C),o.CircleY=j("CircleY",h),o.CircleX=j("CircleX",k,c.CircleXGL),o.Cross=j("Cross",m,c.CrossGL),o.Dash=j("Dash",w),o.Diamond=j("Diamond",q,c.DiamondGL),o.DiamondCross=j("DiamondCross",P,c.DiamondCrossGL),o.DiamondDot=j("DiamondDot",D),o.Dot=j("Dot",g),o.Hex=j("Hex",S,c.HexGL),o.HexDot=j("HexDot",p),o.InvertedTriangle=j("InvertedTriangle",G,c.InvertedTriangleGL),o.Plus=j("Plus",L),o.Square=j("Square",x,c.SquareGL),o.SquareCross=j("SquareCross",M,c.SquareCrossGL),o.SquareDot=j("SquareDot",y),o.SquarePin=j("SquarePin",I),o.SquareX=j("SquareX",X,c.SquareXGL),o.Triangle=j("Triangle",H,c.TriangleGL),o.TriangleDot=j("TriangleDot",Y),o.TrianglePin=j("TrianglePin",A),o.X=j("X",b,c.XGL),o.Y=j("Y",V),o.marker_funcs={asterisk:f,circle:T,circle_cross:z,circle_dot:C,circle_y:h,circle_x:k,cross:m,diamond:q,diamond_dot:D,diamond_cross:P,dot:g,hex:S,hex_dot:p,inverted_triangle:G,plus:L,square:x,square_cross:M,square_dot:y,square_pin:I,square_x:X,triangle:H,triangle_dot:Y,triangle_pin:A,dash:w,x:b,y:V}},
function _(e,r,t,i,n){i();var s=e(1),a=e(213),_=e(143),l=s.__importStar(e(215)),o=s.__importStar(e(133)),h=e(124),y=e(202),c=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(r,e),r.prototype.initialize=function(){e.prototype.initialize.call(this);var r=this.renderer.plot_view.canvas_view.webgl;null!=r&&null!=this.glglyph_cls&&(this.glglyph=new this.glglyph_cls(r.gl,this))},r.prototype._render=function(e,r,t){var i,n,a=t.sx,_=t.sy,l=t._size,o=t._angle;try{for(var h=s.__values(r),y=h.next();!y.done;y=h.next()){var c=y.value;if(!isNaN(a[c]+_[c]+l[c]+o[c])){var d=l[c]/2;e.beginPath(),e.translate(a[c],_[c]),o[c]&&e.rotate(o[c]),this._render_one(e,c,d,this.visuals.line,this.visuals.fill),o[c]&&e.rotate(-o[c]),e.translate(-a[c],-_[c])}}}catch(e){i={error:e}}finally{try{y&&!y.done&&(n=h.return)&&n.call(h)}finally{if(i)throw i.error}}},r.prototype._mask_data=function(){var e=this,r=this.renderer.plot_view.frame,t=r.x_target,i=r.y_target,n=t.widen(this.max_size).map((function(r){return e.renderer.xscale.invert(r)})),s=i.widen(this.max_size).map((function(r){return e.renderer.yscale.invert(r)}));return this.index.indices({x0:n.start,x1:n.end,y0:s.start,y1:s.end})},r.prototype._hit_point=function(e){var r,t,i=e.sx,n=e.sy,a=i-this.max_size,_=i+this.max_size,l=s.__read(this.renderer.xscale.r_invert(a,_),2),o=l[0],h=l[1],c=n-this.max_size,d=n+this.max_size,x=s.__read(this.renderer.yscale.r_invert(c,d),2),u=x[0],p=x[1],v=this.index.indices({x0:o,x1:h,y0:u,y1:p}),f=[];try{for(var g=s.__values(v),w=g.next();!w.done;w=g.next()){var m=w.value,z=this._size[m]/2;Math.abs(this.sx[m]-i)<=z&&Math.abs(this.sy[m]-n)<=z&&f.push(m)}}catch(e){r={error:e}}finally{try{w&&!w.done&&(t=g.return)&&t.call(g)}finally{if(r)throw r.error}}return new y.Selection({indices:f})},r.prototype._hit_span=function(e){var r,t,i,n,a,_,l=e.sx,o=e.sy,h=this.bounds(),c=this.max_size/2;if("h"==e.direction){a=h.y0,_=h.y1;var d=l-c,x=l+c;i=(r=s.__read(this.renderer.xscale.r_invert(d,x),2))[0],n=r[1]}else{i=h.x0,n=h.x1;var u=o-c,p=o+c;a=(t=s.__read(this.renderer.yscale.r_invert(u,p),2))[0],_=t[1]}var v=s.__spread(this.index.indices({x0:i,x1:n,y0:a,y1:_}));return new y.Selection({indices:v})},r.prototype._hit_rect=function(e){var r=e.sx0,t=e.sx1,i=e.sy0,n=e.sy1,a=s.__read(this.renderer.xscale.r_invert(r,t),2),_=a[0],l=a[1],o=s.__read(this.renderer.yscale.r_invert(i,n),2),h=o[0],c=o[1],d=s.__spread(this.index.indices({x0:_,x1:l,y0:h,y1:c}));return new y.Selection({indices:d})},r.prototype._hit_poly=function(e){for(var r=e.sx,t=e.sy,i=h.range(0,this.sx.length),n=[],s=0,a=i.length;s<a;s++){var _=i[s];l.point_in_poly(this.sx[s],this.sy[s],r,t)&&n.push(_)}return new y.Selection({indices:n})},r.prototype._get_legend_args=function(e,r){var t=e.x0,i=e.x1,n=e.y0,s=e.y1,a=r+1,_=new Array(a);_[r]=(t+i)/2;var l=new Array(a);l[r]=(n+s)/2;var o=new Array(a);o[r]=.4*Math.min(Math.abs(i-t),Math.abs(s-n));var h=new Array(a);return h[r]=0,{sx:_,sy:l,_size:o,_angle:h}},r.prototype.draw_legend_for_index=function(e,r,t){var i=r.x0,n=r.x1,s=r.y0,a=r.y1,_=this._get_legend_args({x0:i,x1:n,y0:s,y1:a},t);this._render(e,[t],_)},r}(a.XYGlyphView);t.MarkerView=c,c.__name__="MarkerView";var d=function(e){function r(r){return e.call(this,r)||this}return s.__extends(r,e),r.init_Marker=function(){this.mixins([_.LineVector,_.FillVector]),this.define((function(e){return{size:[o.ScreenDistanceSpec,{value:4}],angle:[o.AngleSpec,0]}}))},r}(a.XYGlyph);t.Marker=d,d.__name__="Marker",d.init_Marker()},
function _(r,t,e,n,a){n();var i=r(1),_=r(423),l=r(422),s=i.__importStar(r(133)),o=function(r){function t(){return null!==r&&r.apply(this,arguments)||this}return i.__extends(t,r),t.prototype._render=function(r,t,e){var n,a,_=e.sx,s=e.sy,o=e._size,u=e._angle,c=e._marker;try{for(var f=i.__values(t),h=f.next();!h.done;h=f.next()){var y=h.value;if(!isNaN(_[y]+s[y]+o[y]+u[y])&&null!=c[y]){var v=o[y]/2;r.beginPath(),r.translate(_[y],s[y]),u[y]&&r.rotate(u[y]),l.marker_funcs[c[y]](r,y,v,this.visuals.line,this.visuals.fill),u[y]&&r.rotate(-u[y]),r.translate(-_[y],-s[y])}}}catch(r){n={error:r}}finally{try{h&&!h.done&&(a=f.return)&&a.call(f)}finally{if(n)throw n.error}}},t.prototype.draw_legend_for_index=function(r,t,e){var n=t.x0,a=t.x1,i=t.y0,_=t.y1,l=this._get_legend_args({x0:n,x1:a,y0:i,y1:_},e),s=new Array(e+1);s[e]=this._marker[e],l._marker=s,this._render(r,[e],l)},t}(_.MarkerView);e.ScatterView=o,o.__name__="ScatterView";var u=function(r){function t(t){return r.call(this,t)||this}return i.__extends(t,r),t.init_Scatter=function(){this.prototype.default_view=o,this.define((function(r){return{marker:[s.MarkerSpec,{value:"circle"}]}}))},t}(_.Marker);e.Scatter=u,u.__name__="Scatter",u.init_Scatter()},
function _(p,o,t,a,n){a(),n("MapOptions",p(426).MapOptions),n("GMapOptions",p(426).GMapOptions),n("GMapPlot",p(426).GMapPlot),n("Plot",p(427).Plot)},
function _(t,n,i,e,o){e();var a=t(1),r=t(134),p=t(427),s=t(196),_=t(275),u=t(436);o("GMapPlotView",u.GMapPlotView);var l=function(t){function n(n){return t.call(this,n)||this}return a.__extends(n,t),n.init_MapOptions=function(){this.define((function(t){var n=t.Int,i=t.Number;return{lat:[i],lng:[i],zoom:[n,12]}}))},n}(s.Model);i.MapOptions=l,l.__name__="MapOptions",l.init_MapOptions();var c=function(t){function n(n){return t.call(this,n)||this}return a.__extends(n,t),n.init_GMapOptions=function(){this.define((function(t){var n=t.Boolean,i=t.Int,e=t.String;return{map_type:[e,"roadmap"],scale_control:[n,!1],styles:[e],tilt:[i,45]}}))},n}(l);i.GMapOptions=c,c.__name__="GMapOptions",c.init_GMapOptions();var f=function(t){function n(n){return t.call(this,n)||this}return a.__extends(n,t),n.init_GMapPlot=function(){this.prototype.default_view=u.GMapPlotView,this.define((function(t){var n=t.String;return{map_options:[(0,t.Ref)(c)],api_key:[n]}})),this.override({x_range:function(){return new _.Range1d},y_range:function(){return new _.Range1d}})},n.prototype.initialize=function(){t.prototype.initialize.call(this),this.use_map=!0,this.api_key||r.logger.error("api_key is required. See https://developers.google.com/maps/documentation/javascript/get-api-key for more information on how to obtain your own.")},n}(p.Plot);i.GMapPlot=f,f.__name__="GMapPlot",f.init_GMapPlot()},
function _(t,e,r,n,o){n();var i=t(1),a=i.__importStar(t(143)),l=i.__importStar(t(133)),s=t(130),_=t(135),c=t(124),u=t(128),h=t(123),d=t(407),f=t(316),p=t(404),g=t(151),y=t(288),b=t(264),v=t(290),w=t(208),m=t(266),x=t(237),A=t(185),P=t(211),R=t(210),S=t(349),O=t(428);o("PlotView",O.PlotView);var D=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_Plot=function(){this.prototype.default_view=O.PlotView,this.mixins([["outline_",a.Line],["background_",a.Fill],["border_",a.Fill]]),this.define((function(t){var e=t.Boolean,r=t.Number,n=t.String,o=t.Array,i=t.Dict,a=t.Or,s=t.Ref,c=t.Null,u=t.Nullable;return{toolbar:[s(v.Toolbar),function(){return new v.Toolbar}],toolbar_location:[u(_.Location),"right"],toolbar_sticky:[e,!0],plot_width:[l.Alias("width")],plot_height:[l.Alias("height")],frame_width:[u(r),null],frame_height:[u(r),null],title:[a(s(y.Title),n,c),function(){return new y.Title({text:""})}],title_location:[u(_.Location),"above"],above:[o(a(s(g.Annotation),s(f.Axis))),[]],below:[o(a(s(g.Annotation),s(f.Axis))),[]],left:[o(a(s(g.Annotation),s(f.Axis))),[]],right:[o(a(s(g.Annotation),s(f.Axis))),[]],center:[o(a(s(g.Annotation),s(p.Grid))),[]],renderers:[o(s(A.Renderer)),[]],x_range:[s(w.Range),function(){return new S.DataRange1d}],extra_x_ranges:[i(s(w.Range)),{}],y_range:[s(w.Range),function(){return new S.DataRange1d}],extra_y_ranges:[i(s(w.Range)),{}],x_scale:[s(m.Scale),function(){return new b.LinearScale}],y_scale:[s(m.Scale),function(){return new b.LinearScale}],lod_factor:[r,10],lod_interval:[r,300],lod_threshold:[r,2e3],lod_timeout:[r,500],hidpi:[e,!0],output_backend:[_.OutputBackend,"canvas"],min_border:[u(r),5],min_border_top:[u(r),null],min_border_left:[u(r),null],min_border_bottom:[u(r),null],min_border_right:[u(r),null],inner_width:[r],inner_height:[r],outer_width:[r],outer_height:[r],match_aspect:[e,!1],aspect_scale:[r,1],reset_policy:[_.ResetPolicy,"standard"]}})),this.override({width:600,height:600,outline_line_color:"#e5e5e5",border_fill_color:"#ffffff",background_fill_color:"#ffffff"})},e.prototype._doc_attached=function(){t.prototype._doc_attached.call(this),this._push_changes([[this.properties.inner_height,null,this.inner_height],[this.properties.inner_width,null,this.inner_width]])},e.prototype.initialize=function(){var e,r,n,o;t.prototype.initialize.call(this),this.reset=new s.Signal0(this,"reset");try{for(var a=i.__values(u.values(this.extra_x_ranges).concat(this.x_range)),l=a.next();!l.done;l=a.next()){var _=l.value,c=_.plots;h.isArray(c)&&(c=c.concat(this),_.setv({plots:c},{silent:!0}))}}catch(t){e={error:t}}finally{try{l&&!l.done&&(r=a.return)&&r.call(a)}finally{if(e)throw e.error}}try{for(var d=i.__values(u.values(this.extra_y_ranges).concat(this.y_range)),f=d.next();!f.done;f=d.next()){var p=f.value;c=p.plots;h.isArray(c)&&(c=c.concat(this),p.setv({plots:c},{silent:!0}))}}catch(t){n={error:t}}finally{try{f&&!f.done&&(o=d.return)&&o.call(d)}finally{if(n)throw n.error}}},e.prototype.add_layout=function(t,e){var r;void 0===e&&(e="center");var n=this.properties[e].get_value();this.setv(((r={})[e]=i.__spread(n,[t]),r))},e.prototype.remove_layout=function(t){var e=function(e){c.remove_by(e,(function(e){return e==t}))};e(this.left),e(this.right),e(this.above),e(this.below),e(this.center)},Object.defineProperty(e.prototype,"data_renderers",{get:function(){return this.renderers.filter((function(t){return t instanceof P.DataRenderer}))},enumerable:!1,configurable:!0}),e.prototype.add_renderers=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];this.renderers=this.renderers.concat(t)},e.prototype.add_glyph=function(t,e,r){void 0===e&&(e=new x.ColumnDataSource),void 0===r&&(r={});var n=Object.assign(Object.assign({},r),{data_source:e,glyph:t}),o=new R.GlyphRenderer(n);return this.add_renderers(o),o},e.prototype.add_tools=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];this.toolbar.tools=this.toolbar.tools.concat(t)},Object.defineProperty(e.prototype,"panels",{get:function(){return i.__spread(this.side_panels,this.center)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"side_panels",{get:function(){var t=this,e=t.above,r=t.below,n=t.left,o=t.right;return c.concat([e,r,n,o])},enumerable:!1,configurable:!0}),e}(d.LayoutDOM);r.Plot=D,D.__name__="Plot",D.init_Plot()},
function _(t,e,i,r,n){r();var a=t(1),o=this&&this.__rest||function(t,e){var i={};for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&e.indexOf(r)<0&&(i[r]=t[r]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var n=0;for(r=Object.getOwnPropertySymbols(t);n<r.length;n++)e.indexOf(r[n])<0&&Object.prototype.propertyIsEnumerable.call(t,r[n])&&(i[r[n]]=t[r[n]])}return i},s=t(347),l=t(192),_=t(211),h=t(407),u=t(288),d=t(316),c=t(289),p=t(429),v=t(130),f=t(230),y=t(430),b=t(189),g=t(134),m=t(432),w=t(123),x=t(124),z=t(354),O=t(433),j=t(434),k=t(355),P=t(194),q=t(435),M=function(t){function e(){var e=t.apply(this,a.__spread(arguments))||this;return e._outer_bbox=new P.BBox,e._inner_bbox=new P.BBox,e._needs_paint=!0,e._needs_layout=!1,e._invalidated_painters=new Set,e._invalidate_all=!0,e}return a.__extends(e,t),Object.defineProperty(e.prototype,"invalidate_dataranges",{set:function(t){this._range_manager.invalidate_dataranges=t},enumerable:!1,configurable:!0}),e.prototype.renderer_view=function(t){var e,i,r=this.renderer_views.get(t);if(null==r)try{for(var n=a.__values(this.renderer_views),o=n.next();!o.done;o=n.next()){var s=a.__read(o.value,2)[1].renderer_view(t);if(null!=s)return s}}catch(t){e={error:t}}finally{try{o&&!o.done&&(i=n.return)&&i.call(n)}finally{if(e)throw e.error}}return r},Object.defineProperty(e.prototype,"is_paused",{get:function(){return null!=this._is_paused&&0!==this._is_paused},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"child_models",{get:function(){return[]},enumerable:!1,configurable:!0}),e.prototype.pause=function(){null==this._is_paused?this._is_paused=1:this._is_paused+=1},e.prototype.unpause=function(t){if(void 0===t&&(t=!1),null==this._is_paused)throw new Error("wasn't paused");this._is_paused-=1,0!=this._is_paused||t||this.request_paint()},e.prototype.request_render=function(){this.request_paint()},e.prototype.request_paint=function(t){if(null!=t?this._invalidated_painters.add(t):this._invalidate_all=!0,!this.is_paused){var e=this.throttled_paint();this._ready=this._ready.then((function(){return e}))}},e.prototype.request_layout=function(){this._needs_layout=!0,this.request_paint()},e.prototype.reset=function(){"standard"==this.model.reset_policy&&(this.clear_state(),this.reset_range(),this.reset_selection()),this.model.trigger_event(new p.Reset)},e.prototype.remove=function(){this.ui_event_bus.destroy(),f.remove_views(this.renderer_views),f.remove_views(this.tool_views),this.canvas_view.remove(),t.prototype.remove.call(this)},e.prototype.render=function(){t.prototype.render.call(this),this.el.appendChild(this.canvas_view.el),this.canvas_view.render()},e.prototype.initialize=function(){var e=this;this.pause(),t.prototype.initialize.call(this),this.state_changed=new v.Signal0(this,"state_changed"),this.lod_started=!1,this.visuals=new b.Visuals(this.model),this._initial_state_info={selection:new Map,dimensions:{width:0,height:0}},this.visibility_callbacks=[],this.state={history:[],index:-1},this.renderer_views=new Map,this.tool_views=new Map;var i=this.model,r=i.hidpi,n=i.output_backend;this.canvas=new l.Canvas({hidpi:r,output_backend:n}),this.frame=new s.CartesianFrame(this.model.x_scale,this.model.y_scale,this.model.x_range,this.model.y_range,this.model.extra_x_ranges,this.model.extra_y_ranges),this._range_manager=new q.RangeManager(this),this.throttled_paint=m.throttle((function(){return e.repaint()}),1e3/60);var a=this.model,o=a.title_location,_=a.title;null!=o&&null!=_&&(this._title=_ instanceof u.Title?_:new u.Title({text:_}));var h=this.model,d=h.toolbar_location,p=h.toolbar;null!=d&&null!=p&&(this._toolbar=new c.ToolbarPanel({toolbar:p}),p.toolbar_location=d)},e.prototype.lazy_initialize=function(){return a.__awaiter(this,void 0,void 0,(function(){var e;return a.__generator(this,(function(i){switch(i.label){case 0:return[4,t.prototype.lazy_initialize.call(this)];case 1:return i.sent(),e=this,[4,f.build_view(this.canvas,{parent:this})];case 2:return e.canvas_view=i.sent(),this.ui_event_bus=new y.UIEvents(this,this.model.toolbar,this.canvas_view.events_el),[4,this.build_renderer_views()];case 3:return i.sent(),[4,this.build_tool_views()];case 4:return i.sent(),this._range_manager.update_dataranges(),this.unpause(!0),g.logger.debug("PlotView initialized"),[2]}}))}))},e.prototype._width_policy=function(){return null==this.model.frame_width?t.prototype._width_policy.call(this):"min"},e.prototype._height_policy=function(){return null==this.model.frame_height?t.prototype._height_policy.call(this):"min"},e.prototype._update_layout=function(){var t=this;this.layout=new O.BorderLayout,this.layout.set_sizing(this.box_sizing());var e=this.model,i=e.frame_width,r=e.frame_height;this.layout.center_panel=this.frame,this.layout.center_panel.set_sizing(Object.assign(Object.assign({},null!=i?{width_policy:"fixed",width:i}:{width_policy:"fit"}),null!=r?{height_policy:"fixed",height:r}:{height_policy:"fit"}));var n=x.copy(this.model.above),o=x.copy(this.model.below),s=x.copy(this.model.left),l=x.copy(this.model.right),_=function(t){switch(t){case"above":return n;case"below":return o;case"left":return s;case"right":return l}},h=this.model,d=h.title_location,p=h.title;null!=d&&null!=p&&_(d).push(this._title);var v=this.model,f=v.toolbar_location,y=v.toolbar;if(null!=f&&null!=y){var b=_(f),g=!0;if(this.model.toolbar_sticky)for(var m=0;m<b.length;m++){var P=b[m];if(P instanceof u.Title){b[m]="above"==f||"below"==f?[P,this._toolbar]:[this._toolbar,P],g=!1;break}}g&&b.push(this._toolbar)}var q=function(e,i){var r=t.renderer_view(i);return r.layout=new j.SidePanel(e,r)},M=function(t,e){var i,r,n="above"==t||"below"==t,o=[];try{for(var s=a.__values(e),l=s.next();!l.done;l=s.next()){var _=l.value;if(w.isArray(_)){var h=_.map((function(e){var i,r=q(t,e);if(e instanceof c.ToolbarPanel){var a=n?"width_policy":"height_policy";r.set_sizing(Object.assign(Object.assign({},r.sizing),((i={})[a]="min",i)))}return r})),u=void 0;n?(u=new k.Row(h)).set_sizing({width_policy:"max",height_policy:"min"}):(u=new k.Column(h)).set_sizing({width_policy:"min",height_policy:"max"}),u.absolute=!0,o.push(u)}else o.push(q(t,_))}}catch(t){i={error:t}}finally{try{l&&!l.done&&(r=s.return)&&r.call(s)}finally{if(i)throw i.error}}return o},R=null!=this.model.min_border?this.model.min_border:0;this.layout.min_border={left:null!=this.model.min_border_left?this.model.min_border_left:R,top:null!=this.model.min_border_top?this.model.min_border_top:R,right:null!=this.model.min_border_right?this.model.min_border_right:R,bottom:null!=this.model.min_border_bottom?this.model.min_border_bottom:R};var S=new z.VStack,V=new z.VStack,T=new z.HStack,B=new z.HStack;S.children=x.reversed(M("above",n)),V.children=M("below",o),T.children=x.reversed(M("left",s)),B.children=M("right",l),S.set_sizing({width_policy:"fit",height_policy:"min"}),V.set_sizing({width_policy:"fit",height_policy:"min"}),T.set_sizing({width_policy:"min",height_policy:"fit"}),B.set_sizing({width_policy:"min",height_policy:"fit"}),this.layout.top_panel=S,this.layout.bottom_panel=V,this.layout.left_panel=T,this.layout.right_panel=B},Object.defineProperty(e.prototype,"axis_views",{get:function(){var t,e,i=[];try{for(var r=a.__values(this.renderer_views),n=r.next();!n.done;n=r.next()){var o=a.__read(n.value,2)[1];o instanceof d.AxisView&&i.push(o)}}catch(e){t={error:e}}finally{try{n&&!n.done&&(e=r.return)&&e.call(r)}finally{if(t)throw t.error}}return i},enumerable:!1,configurable:!0}),e.prototype.set_cursor=function(t){void 0===t&&(t="default"),this.canvas_view.el.style.cursor=t},e.prototype.set_toolbar_visibility=function(t){var e,i;try{for(var r=a.__values(this.visibility_callbacks),n=r.next();!n.done;n=r.next()){(0,n.value)(t)}}catch(t){e={error:t}}finally{try{n&&!n.done&&(i=r.return)&&i.call(r)}finally{if(e)throw e.error}}},e.prototype.push_state=function(t,e){var i=this.state,r=i.history,n=i.index,a=null!=r[n]?r[n].info:{},o=Object.assign(Object.assign(Object.assign({},this._initial_state_info),a),e);this.state.history=this.state.history.slice(0,this.state.index+1),this.state.history.push({type:t,info:o}),this.state.index=this.state.history.length-1,this.state_changed.emit()},e.prototype.clear_state=function(){this.state={history:[],index:-1},this.state_changed.emit()},e.prototype.can_undo=function(){return this.state.index>=0},e.prototype.can_redo=function(){return this.state.index<this.state.history.length-1},e.prototype.undo=function(){this.can_undo()&&(this.state.index-=1,this._do_state_change(this.state.index),this.state_changed.emit())},e.prototype.redo=function(){this.can_redo()&&(this.state.index+=1,this._do_state_change(this.state.index),this.state_changed.emit())},e.prototype.update_range=function(t,e){this.pause(),this._range_manager.update(t,e),this.unpause()},e.prototype.reset_range=function(){this.update_range(null)},e.prototype._do_state_change=function(t){var e=null!=this.state.history[t]?this.state.history[t].info:this._initial_state_info;null!=e.range&&this.update_range(e.range),null!=e.selection&&this.update_selection(e.selection)},e.prototype.get_selection=function(){var t,e,i=new Map;try{for(var r=a.__values(this.model.renderers),n=r.next();!n.done;n=r.next()){var o=n.value;if(o instanceof _.DataRenderer){var s=o.selection_manager.source.selected;i.set(o,s)}}}catch(e){t={error:e}}finally{try{n&&!n.done&&(e=r.return)&&e.call(r)}finally{if(t)throw t.error}}return i},e.prototype.update_selection=function(t){var e,i;try{for(var r=a.__values(this.model.renderers),n=r.next();!n.done;n=r.next()){var o=n.value;if(o instanceof _.DataRenderer){var s=o.selection_manager.source;if(null!=t){var l=t.get(o);null!=l&&s.selected.update(l,!0)}else s.selection_manager.clear()}}}catch(t){e={error:t}}finally{try{n&&!n.done&&(i=r.return)&&i.call(r)}finally{if(e)throw e.error}}},e.prototype.reset_selection=function(){this.update_selection(null)},e.prototype._invalidate_layout=function(){var t=this;(function(){var e,i;try{for(var r=a.__values(t.model.side_panels),n=r.next();!n.done;n=r.next()){var o=n.value;if(t.renderer_views.get(o).layout.has_size_changed())return!0}}catch(t){e={error:t}}finally{try{n&&!n.done&&(i=r.return)&&i.call(r)}finally{if(e)throw e.error}}return!1})()&&this.root.compute_layout()},e.prototype.get_renderer_views=function(){var t=this;return this.computed_renderers.map((function(e){return t.renderer_views.get(e)}))},e.prototype.build_renderer_views=function(){return a.__awaiter(this,void 0,void 0,(function(){var t,e,i,r,n,o,s,l,_,h,u,d,c,p;return a.__generator(this,(function(v){switch(v.label){case 0:this.computed_renderers=[],t=this.model,e=t.above,i=t.below,r=t.left,n=t.right,o=t.center,s=t.renderers,(u=this.computed_renderers).push.apply(u,a.__spread(e,i,r,n,o,s)),null!=this._title&&this.computed_renderers.push(this._title),null!=this._toolbar&&this.computed_renderers.push(this._toolbar);try{for(l=a.__values(this.model.toolbar.tools),_=l.next();!_.done;_=l.next())null!=(h=_.value).overlay&&this.computed_renderers.push(h.overlay),(p=this.computed_renderers).push.apply(p,a.__spread(h.synthetic_renderers))}catch(t){d={error:t}}finally{try{_&&!_.done&&(c=l.return)&&c.call(l)}finally{if(d)throw d.error}}return[4,f.build_views(this.renderer_views,this.computed_renderers,{parent:this})];case 1:return v.sent(),[2]}}))}))},e.prototype.build_tool_views=function(){return a.__awaiter(this,void 0,void 0,(function(){var t,e=this;return a.__generator(this,(function(i){switch(i.label){case 0:return t=this.model.toolbar.tools,[4,f.build_views(this.tool_views,t,{parent:this})];case 1:return i.sent().map((function(t){return e.ui_event_bus.register_tool(t)})),[2]}}))}))},e.prototype.connect_signals=function(){var e,i,r,n,o=this;t.prototype.connect_signals.call(this);var s=this.frame,l=s.x_ranges,_=s.y_ranges;try{for(var h=a.__values(l),u=h.next();!u.done;u=h.next()){var d=a.__read(u.value,2)[1];this.connect(d.change,(function(){o._needs_layout=!0,o.request_paint()}))}}catch(t){e={error:t}}finally{try{u&&!u.done&&(i=h.return)&&i.call(h)}finally{if(e)throw e.error}}try{for(var c=a.__values(_),p=c.next();!p.done;p=c.next()){d=a.__read(p.value,2)[1];this.connect(d.change,(function(){o._needs_layout=!0,o.request_paint()}))}}catch(t){r={error:t}}finally{try{p&&!p.done&&(n=c.return)&&n.call(c)}finally{if(r)throw r.error}}var v=this.model.properties,f=v.above,y=v.below,b=v.left,g=v.right,m=v.center,w=v.renderers;this.on_change([f,y,b,g,m,w],(function(){return a.__awaiter(o,void 0,void 0,(function(){return a.__generator(this,(function(t){switch(t.label){case 0:return[4,this.build_renderer_views()];case 1:return[2,t.sent()]}}))}))})),this.connect(this.model.toolbar.properties.tools.change,(function(){return a.__awaiter(o,void 0,void 0,(function(){return a.__generator(this,(function(t){switch(t.label){case 0:return[4,this.build_renderer_views()];case 1:return t.sent(),[4,this.build_tool_views()];case 2:return t.sent(),[2]}}))}))})),this.connect(this.model.change,(function(){return o.request_paint()})),this.connect(this.model.reset,(function(){return o.reset()}))},e.prototype.has_finished=function(){var e,i;if(!t.prototype.has_finished.call(this))return!1;if(this.model.visible)try{for(var r=a.__values(this.renderer_views),n=r.next();!n.done;n=r.next()){if(!a.__read(n.value,2)[1].has_finished())return!1}}catch(t){e={error:t}}finally{try{n&&!n.done&&(i=r.return)&&i.call(r)}finally{if(e)throw e.error}}return!0},e.prototype.after_layout=function(){if(t.prototype.after_layout.call(this),this._needs_layout=!1,this.model.setv({inner_width:Math.round(this.frame.bbox.width),inner_height:Math.round(this.frame.bbox.height),outer_width:Math.round(this.layout.bbox.width),outer_height:Math.round(this.layout.bbox.height)},{no_change:!0}),!1!==this.model.match_aspect&&(this.pause(),this._range_manager.update_dataranges(),this.unpause(!0)),!this._outer_bbox.equals(this.layout.bbox)){var e=this.layout.bbox,i=e.width,r=e.height;this.canvas_view.resize(i,r),this._outer_bbox=this.layout.bbox,this._invalidate_all=!0,this._needs_paint=!0}this._inner_bbox.equals(this.frame.inner_bbox)||(this._inner_bbox=this.layout.inner_bbox,this._needs_paint=!0),this._needs_paint&&this.paint()},e.prototype.repaint=function(){this._needs_layout&&this._invalidate_layout(),this.paint()},e.prototype.paint=function(){var t,e,i,r=this;if(!this.is_paused&&this.model.visible){g.logger.trace("PlotView.paint() for "+this.model.id);var n=this.model.document;if(null!=n){var o=n.interactive_duration();o>=0&&o<this.model.lod_interval?setTimeout((function(){n.interactive_duration()>r.model.lod_timeout&&n.interactive_stop(),r.request_paint()}),this.model.lod_timeout):n.interactive_stop()}this._range_manager.invalidate_dataranges&&this._range_manager.update_dataranges();var s=!1,l=!1;if(this._invalidate_all)s=!0,l=!0;else try{for(var _=a.__values(this._invalidated_painters),h=_.next();!h.done;h=_.next()){if("overlay"!=h.value.model.level?s=!0:l=!0,s&&l)break}}catch(e){t={error:e}}finally{try{h&&!h.done&&(e=_.return)&&e.call(_)}finally{if(t)throw t.error}}this._invalidated_painters.clear(),this._invalidate_all=!1;var u=[this.frame.bbox.left,this.frame.bbox.top,this.frame.bbox.width,this.frame.bbox.height],d=this.canvas_view,c=d.primary,p=d.overlays;s&&(c.prepare(),this.canvas_view.prepare_webgl(u),this.canvas_view.clear_webgl(),this._map_hook(c.ctx,u),this._paint_empty(c.ctx,u),this._paint_outline(c.ctx,u),this._paint_levels(c.ctx,"image",u,!0),this._paint_levels(c.ctx,"underlay",u,!0),this._paint_levels(c.ctx,"glyph",u,!0),this._paint_levels(c.ctx,"guide",u,!1),this._paint_levels(c.ctx,"annotation",u,!1),c.finish()),l&&(p.prepare(),this._paint_levels(p.ctx,"overlay",u,!1),p.finish()),null==this._initial_state_info.range&&(this._initial_state_info.range=null!==(i=this._range_manager.compute_initial())&&void 0!==i?i:void 0),this._needs_paint=!1}},e.prototype._paint_levels=function(t,e,i,r){var n,o;try{for(var s=a.__values(this.computed_renderers),l=s.next();!l.done;l=s.next()){var _=l.value;if(_.level==e){var h=this.renderer_views.get(_);t.save(),(r||h.needs_clip)&&(t.beginPath(),t.rect.apply(t,a.__spread(i)),t.clip()),h.render(),t.restore(),h.has_webgl&&h.needs_webgl_blit&&(this.canvas_view.blit_webgl(t),this.canvas_view.clear_webgl())}}}catch(t){n={error:t}}finally{try{l&&!l.done&&(o=s.return)&&o.call(s)}finally{if(n)throw n.error}}},e.prototype._map_hook=function(t,e){},e.prototype._paint_empty=function(t,e){var i=a.__read([0,0,this.layout.bbox.width,this.layout.bbox.height],4),r=i[0],n=i[1],o=i[2],s=i[3],l=a.__read(e,4),_=l[0],h=l[1],u=l[2],d=l[3];this.visuals.border_fill.doit&&(this.visuals.border_fill.set_value(t),t.fillRect(r,n,o,s),t.clearRect(_,h,u,d)),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(_,h,u,d))},e.prototype._paint_outline=function(t,e){if(this.visuals.outline_line.doit){t.save(),this.visuals.outline_line.set_value(t);var i=a.__read(e,4),r=i[0],n=i[1],o=i[2],s=i[3];r+o==this.layout.bbox.width&&(o-=1),n+s==this.layout.bbox.height&&(s-=1),t.strokeRect(r,n,o,s),t.restore()}},e.prototype.to_blob=function(){return this.canvas_view.to_blob()},e.prototype.export=function(t,e){void 0===e&&(e=!0);var i="png"==t?"canvas":"svg",r=new l.CanvasLayer(i,e),n=this.layout.bbox,a=n.width,o=n.height;r.resize(a,o);var s=this.canvas_view.compose().canvas;return r.ctx.drawImage(s,0,0),r},e.prototype.serializable_state=function(){var e=t.prototype.serializable_state.call(this),i=e.children,r=o(e,["children"]),n=this.get_renderer_views().map((function(t){return t.serializable_state()})).filter((function(t){return null!=t.bbox}));return Object.assign(Object.assign({},r),{children:a.__spread(null!=i?i:[],n)})},e}(h.LayoutDOMView);i.PlotView=M,M.__name__="PlotView"},
function _(t,n,e,r,o){r();var _=t(1),s=this&&this.__decorate||function(t,n,e,r){var o,_=arguments.length,s=_<3?n:null===r?r=Object.getOwnPropertyDescriptor(n,e):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(t,n,e,r);else for(var a=t.length-1;a>=0;a--)(o=t[a])&&(s=(_<3?o(s):_>3?o(n,e,s):o(n,e))||s);return _>3&&s&&Object.defineProperty(n,e,s),s};function a(t){return function(n){n.prototype.event_name=t}}var i=function(){function t(){}return t.prototype.to_json=function(){return{event_name:this.event_name,event_values:this._to_json()}},t}();e.BokehEvent=i,i.__name__="BokehEvent";var u=function(t){function n(){var n=t.apply(this,_.__spread(arguments))||this;return n.origin=null,n}return _.__extends(n,t),n.prototype._to_json=function(){return{model:this.origin}},n}(i);e.ModelEvent=u,u.__name__="ModelEvent";var c=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n.prototype._to_json=function(){return{}},n}(i);e.DocumentReady=c,c.__name__="DocumentReady",e.DocumentReady=c=s([a("document_ready")],c);var l=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(u);e.ButtonClick=l,l.__name__="ButtonClick",e.ButtonClick=l=s([a("button_click")],l);var p=function(t){function n(n){var e=t.call(this)||this;return e.item=n,e}return _.__extends(n,t),n.prototype._to_json=function(){var n=this.item;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{item:n})},n}(u);e.MenuItemClick=p,p.__name__="MenuItemClick",e.MenuItemClick=p=s([a("menu_item_click")],p);var h=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(u);e.UIEvent=h,h.__name__="UIEvent";var f=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(h);e.LODStart=f,f.__name__="LODStart",e.LODStart=f=s([a("lodstart")],f);var y=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(h);e.LODEnd=y,y.__name__="LODEnd",e.LODEnd=y=s([a("lodend")],y);var d=function(t){function n(n,e){var r=t.call(this)||this;return r.geometry=n,r.final=e,r}return _.__extends(n,t),n.prototype._to_json=function(){var n=this.geometry,e=this.final;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{geometry:n,final:e})},n}(h);e.SelectionGeometry=d,d.__name__="SelectionGeometry",e.SelectionGeometry=d=s([a("selectiongeometry")],d);var v=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(h);e.Reset=v,v.__name__="Reset",e.Reset=v=s([a("reset")],v);var m=function(t){function n(n,e,r,o){var _=t.call(this)||this;return _.sx=n,_.sy=e,_.x=r,_.y=o,_}return _.__extends(n,t),n.prototype._to_json=function(){var n=this,e=n.sx,r=n.sy,o=n.x,_=n.y;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{sx:e,sy:r,x:o,y:_})},n}(h);e.PointEvent=m,m.__name__="PointEvent";var x=function(t){function n(n,e,r,o,_,s){var a=t.call(this,n,e,r,o)||this;return a.sx=n,a.sy=e,a.x=r,a.y=o,a.delta_x=_,a.delta_y=s,a}return _.__extends(n,t),n.prototype._to_json=function(){var n=this.delta_x,e=this.delta_y;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{delta_x:n,delta_y:e})},n}(m);e.Pan=x,x.__name__="Pan",e.Pan=x=s([a("pan")],x);var j=function(t){function n(n,e,r,o,_){var s=t.call(this,n,e,r,o)||this;return s.sx=n,s.sy=e,s.x=r,s.y=o,s.scale=_,s}return _.__extends(n,t),n.prototype._to_json=function(){var n=this.scale;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{scale:n})},n}(m);e.Pinch=j,j.__name__="Pinch",e.Pinch=j=s([a("pinch")],j);var P=function(t){function n(n,e,r,o,_){var s=t.call(this,n,e,r,o)||this;return s.sx=n,s.sy=e,s.x=r,s.y=o,s.rotation=_,s}return _.__extends(n,t),n.prototype._to_json=function(){var n=this.rotation;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{rotation:n})},n}(m);e.Rotate=P,P.__name__="Rotate",e.Rotate=P=s([a("rotate")],P);var g=function(t){function n(n,e,r,o,_){var s=t.call(this,n,e,r,o)||this;return s.sx=n,s.sy=e,s.x=r,s.y=o,s.delta=_,s}return _.__extends(n,t),n.prototype._to_json=function(){var n=this.delta;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{delta:n})},n}(m);e.MouseWheel=g,g.__name__="MouseWheel",e.MouseWheel=g=s([a("wheel")],g);var E=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(m);e.MouseMove=E,E.__name__="MouseMove",e.MouseMove=E=s([a("mousemove")],E);var O=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(m);e.MouseEnter=O,O.__name__="MouseEnter",e.MouseEnter=O=s([a("mouseenter")],O);var b=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(m);e.MouseLeave=b,b.__name__="MouseLeave",e.MouseLeave=b=s([a("mouseleave")],b);var M=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(m);e.Tap=M,M.__name__="Tap",e.Tap=M=s([a("tap")],M);var R=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(m);e.DoubleTap=R,R.__name__="DoubleTap",e.DoubleTap=R=s([a("doubletap")],R);var S=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(m);e.Press=S,S.__name__="Press",e.Press=S=s([a("press")],S);var D=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(m);e.PressUp=D,D.__name__="PressUp",e.PressUp=D=s([a("pressup")],D);var k=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(m);e.PanStart=k,k.__name__="PanStart",e.PanStart=k=s([a("panstart")],k);var L=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(m);e.PanEnd=L,L.__name__="PanEnd",e.PanEnd=L=s([a("panend")],L);var C=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(m);e.PinchStart=C,C.__name__="PinchStart",e.PinchStart=C=s([a("pinchstart")],C);var T=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(m);e.PinchEnd=T,T.__name__="PinchEnd",e.PinchEnd=T=s([a("pinchend")],T);var B=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(m);e.RotateStart=B,B.__name__="RotateStart",e.RotateStart=B=s([a("rotatestart")],B);var I=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(n,t),n}(m);e.RotateEnd=I,I.__name__="RotateEnd",e.RotateEnd=I=s([a("rotateend")],I)},
function _(t,e,n,r,i){r();var s=t(1),o=s.__importDefault(t(294)),a=t(130),_=t(134),h=t(187),c=s.__importStar(t(429)),p=t(431),u=t(124),l=t(123),v=t(147),d=t(299);var y=function(){function t(t,e,n){var r=this;this.plot_view=t,this.toolbar=e,this.hit_area=n,this.pan_start=new a.Signal(this,"pan:start"),this.pan=new a.Signal(this,"pan"),this.pan_end=new a.Signal(this,"pan:end"),this.pinch_start=new a.Signal(this,"pinch:start"),this.pinch=new a.Signal(this,"pinch"),this.pinch_end=new a.Signal(this,"pinch:end"),this.rotate_start=new a.Signal(this,"rotate:start"),this.rotate=new a.Signal(this,"rotate"),this.rotate_end=new a.Signal(this,"rotate:end"),this.tap=new a.Signal(this,"tap"),this.doubletap=new a.Signal(this,"doubletap"),this.press=new a.Signal(this,"press"),this.pressup=new a.Signal(this,"pressup"),this.move_enter=new a.Signal(this,"move:enter"),this.move=new a.Signal(this,"move"),this.move_exit=new a.Signal(this,"move:exit"),this.scroll=new a.Signal(this,"scroll"),this.keydown=new a.Signal(this,"keydown"),this.keyup=new a.Signal(this,"keyup"),this.hammer=new o.default(this.hit_area,{touchAction:"auto",inputClass:o.default.TouchMouseInput}),this._configure_hammerjs(),this.hit_area.addEventListener("mousemove",(function(t){return r._mouse_move(t)})),this.hit_area.addEventListener("mouseenter",(function(t){return r._mouse_enter(t)})),this.hit_area.addEventListener("mouseleave",(function(t){return r._mouse_exit(t)})),this.hit_area.addEventListener("contextmenu",(function(t){return r._context_menu(t)})),this.hit_area.addEventListener("wheel",(function(t){return r._mouse_wheel(t)})),document.addEventListener("keydown",this),document.addEventListener("keyup",this),this.menu=new d.ContextMenu([],{prevent_hide:function(t){return 2==t.button&&t.target==r.hit_area}}),this.hit_area.appendChild(this.menu.el)}return t.prototype.destroy=function(){this.menu.remove(),this.hammer.destroy(),document.removeEventListener("keydown",this),document.removeEventListener("keyup",this)},t.prototype.handleEvent=function(t){"keydown"==t.type?this._key_down(t):"keyup"==t.type&&this._key_up(t)},t.prototype._configure_hammerjs=function(){var t=this;this.hammer.get("doubletap").recognizeWith("tap"),this.hammer.get("tap").requireFailure("doubletap"),this.hammer.get("doubletap").dropRequireFailure("tap"),this.hammer.on("doubletap",(function(e){return t._doubletap(e)})),this.hammer.on("tap",(function(e){return t._tap(e)})),this.hammer.on("press",(function(e){return t._press(e)})),this.hammer.on("pressup",(function(e){return t._pressup(e)})),this.hammer.get("pan").set({direction:o.default.DIRECTION_ALL}),this.hammer.on("panstart",(function(e){return t._pan_start(e)})),this.hammer.on("pan",(function(e){return t._pan(e)})),this.hammer.on("panend",(function(e){return t._pan_end(e)})),this.hammer.get("pinch").set({enable:!0}),this.hammer.on("pinchstart",(function(e){return t._pinch_start(e)})),this.hammer.on("pinch",(function(e){return t._pinch(e)})),this.hammer.on("pinchend",(function(e){return t._pinch_end(e)})),this.hammer.get("rotate").set({enable:!0}),this.hammer.on("rotatestart",(function(e){return t._rotate_start(e)})),this.hammer.on("rotate",(function(e){return t._rotate(e)})),this.hammer.on("rotateend",(function(e){return t._rotate_end(e)}))},t.prototype.register_tool=function(t){var e=this,n=t.model.event_type;null!=n&&(l.isString(n)?this._register_tool(t,n):n.forEach((function(n,r){return e._register_tool(t,n,r<1)})))},t.prototype._register_tool=function(t,e,n){void 0===n&&(n=!0);var r=t,i=r.model.id,s=function(t){return function(e){e.id==i&&t(e.e)}},o=function(t){return function(e){t(e.e)}};switch(e){case"pan":null!=r._pan_start&&r.connect(this.pan_start,s(r._pan_start.bind(r))),null!=r._pan&&r.connect(this.pan,s(r._pan.bind(r))),null!=r._pan_end&&r.connect(this.pan_end,s(r._pan_end.bind(r)));break;case"pinch":null!=r._pinch_start&&r.connect(this.pinch_start,s(r._pinch_start.bind(r))),null!=r._pinch&&r.connect(this.pinch,s(r._pinch.bind(r))),null!=r._pinch_end&&r.connect(this.pinch_end,s(r._pinch_end.bind(r)));break;case"rotate":null!=r._rotate_start&&r.connect(this.rotate_start,s(r._rotate_start.bind(r))),null!=r._rotate&&r.connect(this.rotate,s(r._rotate.bind(r))),null!=r._rotate_end&&r.connect(this.rotate_end,s(r._rotate_end.bind(r)));break;case"move":null!=r._move_enter&&r.connect(this.move_enter,s(r._move_enter.bind(r))),null!=r._move&&r.connect(this.move,s(r._move.bind(r))),null!=r._move_exit&&r.connect(this.move_exit,s(r._move_exit.bind(r)));break;case"tap":null!=r._tap&&r.connect(this.tap,s(r._tap.bind(r)));break;case"press":null!=r._press&&r.connect(this.press,s(r._press.bind(r))),null!=r._pressup&&r.connect(this.pressup,s(r._pressup.bind(r)));break;case"scroll":null!=r._scroll&&r.connect(this.scroll,s(r._scroll.bind(r)));break;default:throw new Error("unsupported event_type: "+e)}n&&(null!=r._doubletap&&r.connect(this.doubletap,o(r._doubletap.bind(r))),null!=r._keydown&&r.connect(this.keydown,o(r._keydown.bind(r))),null!=r._keyup&&r.connect(this.keyup,o(r._keyup.bind(r))),v.is_mobile&&null!=r._scroll&&"pinch"==e&&(_.logger.debug("Registering scroll on touch screen"),r.connect(this.scroll,s(r._scroll.bind(r)))))},t.prototype._hit_test_renderers=function(t,e){var n,r,i=this.plot_view.get_renderer_views();try{for(var o=s.__values(u.reversed(i)),a=o.next();!a.done;a=o.next()){var _=a.value,h=_.model.level;if(("annotation"==h||"overlay"==h)&&null!=_.interactive_hit&&_.interactive_hit(t,e))return _}}catch(t){n={error:t}}finally{try{a&&!a.done&&(r=o.return)&&r.call(o)}finally{if(n)throw n.error}}return null},t.prototype._hit_test_frame=function(t,e){return this.plot_view.frame.bbox.contains(t,e)},t.prototype._hit_test_canvas=function(t,e){return this.plot_view.layout.bbox.contains(t,e)},t.prototype._trigger=function(t,e,n){var r,i=this,s=this.toolbar.gestures,o=t.name.split(":")[0],a=this._hit_test_renderers(e.sx,e.sy),_=this._hit_test_canvas(e.sx,e.sy);switch(o){case"move":null!=(l=s[o].active)&&this.trigger(t,e,l.id);var h=this.toolbar.inspectors.filter((function(t){return t.active})),c="default";null!=a?(c=null!==(r=a.cursor(e.sx,e.sy))&&void 0!==r?r:c,u.is_empty(h)||(t=this.move_exit)):this._hit_test_frame(e.sx,e.sy)&&(u.is_empty(h)||(c="crosshair")),this.plot_view.set_cursor(c),this.plot_view.set_toolbar_visibility(_),h.map((function(n){return i.trigger(t,e,n.id)}));break;case"tap":var p=n.target;if(null!=p&&p!=this.hit_area)return;null!=a&&null!=a.on_hit&&a.on_hit(e.sx,e.sy),null!=(l=s[o].active)&&this.trigger(t,e,l.id);break;case"scroll":null!=(l=s[v.is_mobile?"pinch":"scroll"].active)&&(n.preventDefault(),n.stopPropagation(),this.trigger(t,e,l.id));break;case"pan":null!=(l=s[o].active)&&(n.preventDefault(),this.trigger(t,e,l.id));break;default:var l;null!=(l=s[o].active)&&this.trigger(t,e,l.id)}this._trigger_bokeh_event(e)},t.prototype.trigger=function(t,e,n){void 0===n&&(n=null),t.emit({id:n,e:e})},t.prototype._trigger_bokeh_event=function(t){var e=this,n=function(){var n=t.sx,r=t.sy,i=e.plot_view.frame.x_scale.invert(n),s=e.plot_view.frame.y_scale.invert(r);switch(t.type){case"wheel":return new c.MouseWheel(n,r,i,s,t.delta);case"mousemove":return new c.MouseMove(n,r,i,s);case"mouseenter":return new c.MouseEnter(n,r,i,s);case"mouseleave":return new c.MouseLeave(n,r,i,s);case"tap":return new c.Tap(n,r,i,s);case"doubletap":return new c.DoubleTap(n,r,i,s);case"press":return new c.Press(n,r,i,s);case"pressup":return new c.PressUp(n,r,i,s);case"pan":return new c.Pan(n,r,i,s,t.deltaX,t.deltaY);case"panstart":return new c.PanStart(n,r,i,s);case"panend":return new c.PanEnd(n,r,i,s);case"pinch":return new c.Pinch(n,r,i,s,t.scale);case"pinchstart":return new c.PinchStart(n,r,i,s);case"pinchend":return new c.PinchEnd(n,r,i,s);case"rotate":return new c.Rotate(n,r,i,s,t.rotation);case"rotatestart":return new c.RotateStart(n,r,i,s);case"rotateend":return new c.RotateEnd(n,r,i,s);default:return}}();null!=n&&this.plot_view.model.trigger_event(n)},t.prototype._get_sxy=function(t){var e=function(t){return"undefined"!=typeof TouchEvent&&t instanceof TouchEvent}(t)?(0!=t.touches.length?t.touches:t.changedTouches)[0]:t,n=e.pageX,r=e.pageY,i=h.offset(this.hit_area);return{sx:n-i.left,sy:r-i.top}},t.prototype._pan_event=function(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{deltaX:t.deltaX,deltaY:t.deltaY,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})},t.prototype._pinch_event=function(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{scale:t.scale,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})},t.prototype._rotate_event=function(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{rotation:t.rotation,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})},t.prototype._tap_event=function(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})},t.prototype._move_event=function(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})},t.prototype._scroll_event=function(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{delta:p.getDeltaY(t),shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})},t.prototype._key_event=function(t){return{type:t.type,keyCode:t.keyCode}},t.prototype._pan_start=function(t){var e=this._pan_event(t);e.sx-=t.deltaX,e.sy-=t.deltaY,this._trigger(this.pan_start,e,t.srcEvent)},t.prototype._pan=function(t){this._trigger(this.pan,this._pan_event(t),t.srcEvent)},t.prototype._pan_end=function(t){this._trigger(this.pan_end,this._pan_event(t),t.srcEvent)},t.prototype._pinch_start=function(t){this._trigger(this.pinch_start,this._pinch_event(t),t.srcEvent)},t.prototype._pinch=function(t){this._trigger(this.pinch,this._pinch_event(t),t.srcEvent)},t.prototype._pinch_end=function(t){this._trigger(this.pinch_end,this._pinch_event(t),t.srcEvent)},t.prototype._rotate_start=function(t){this._trigger(this.rotate_start,this._rotate_event(t),t.srcEvent)},t.prototype._rotate=function(t){this._trigger(this.rotate,this._rotate_event(t),t.srcEvent)},t.prototype._rotate_end=function(t){this._trigger(this.rotate_end,this._rotate_event(t),t.srcEvent)},t.prototype._tap=function(t){this._trigger(this.tap,this._tap_event(t),t.srcEvent)},t.prototype._doubletap=function(t){var e=this._tap_event(t);this._trigger_bokeh_event(e),this.trigger(this.doubletap,e)},t.prototype._press=function(t){this._trigger(this.press,this._tap_event(t),t.srcEvent)},t.prototype._pressup=function(t){this._trigger(this.pressup,this._tap_event(t),t.srcEvent)},t.prototype._mouse_enter=function(t){this._trigger(this.move_enter,this._move_event(t),t)},t.prototype._mouse_move=function(t){this._trigger(this.move,this._move_event(t),t)},t.prototype._mouse_exit=function(t){this._trigger(this.move_exit,this._move_event(t),t)},t.prototype._mouse_wheel=function(t){this._trigger(this.scroll,this._scroll_event(t),t)},t.prototype._context_menu=function(t){!this.menu.is_open&&this.menu.can_open&&t.preventDefault();var e=this._get_sxy(t),n=e.sx,r=e.sy;this.menu.toggle({left:n,top:r})},t.prototype._key_down=function(t){this.trigger(this.keydown,this._key_event(t))},t.prototype._key_up=function(t){this.trigger(this.keyup,this._key_event(t))},t}();n.UIEvents=y,y.__name__="UIEvents"},
function _(t,e,n,l,a){
/*!
     * jQuery Mousewheel 3.1.13
     *
     * Copyright jQuery Foundation and other contributors
     * Released under the MIT license
     * http://jquery.org/license
     */
function o(t){var e=getComputedStyle(t).fontSize;return null!=e?parseInt(e,10):null}l(),n.getDeltaY=function(t){var e,n,l,a,r=-t.deltaY;if(t.target instanceof HTMLElement)switch(t.deltaMode){case t.DOM_DELTA_LINE:r*=(e=t.target,null!==(a=null!==(l=o(null!==(n=e.offsetParent)&&void 0!==n?n:document.body))&&void 0!==l?l:o(e))&&void 0!==a?a:16);break;case t.DOM_DELTA_PAGE:r*=function(t){return t.clientHeight}(t.target)}return r}},
function _(n,e,i,o,t){var u,d,r,w;o();var a=null!==(w=null!==(r=null!==(d=null!==(u="undefined"!=typeof window?window.requestAnimationFrame:void 0)&&void 0!==u?u:"undefined"!=typeof window?window.webkitRequestAnimationFrame:void 0)&&void 0!==d?d:"undefined"!=typeof window?window.mozRequestAnimationFrame:void 0)&&void 0!==r?r:"undefined"!=typeof window?window.msRequestAnimationFrame:void 0)&&void 0!==w?w:function(n){return n(Date.now()),-1};i.throttle=function(n,e){var i=null,o=0,t=!1;return function(){return new Promise((function(u,d){var r=function(){o=Date.now(),i=null,t=!1;try{n(),u()}catch(n){d(n)}},w=Date.now(),l=e-(w-o);l<=0&&!t?(null!=i&&clearTimeout(i),t=!0,a(r)):i||t?u():i=setTimeout((function(){return a(r)}),l)}))}}},
function _(t,e,h,i,o){i();var r=t(1),n=t(352),a=t(353),s=t(194),_=function(t){function e(){var e=t.apply(this,r.__spread(arguments))||this;return e.min_border={left:0,top:0,right:0,bottom:0},e}return r.__extends(e,t),e.prototype._measure=function(t){var e=this;t=new n.Sizeable(t).bounded_to(this.sizing.size);var h,i,o,r=this.left_panel.measure({width:0,height:t.height}),a=Math.max(r.width,this.min_border.left),s=this.right_panel.measure({width:0,height:t.height}),_=Math.max(s.width,this.min_border.right),g=this.top_panel.measure({width:t.width,height:0}),m=Math.max(g.height,this.min_border.top),p=this.bottom_panel.measure({width:t.width,height:0}),l=Math.max(p.height,this.min_border.bottom),d=new n.Sizeable(t).shrink_by({left:a,right:_,top:m,bottom:l}),w=this.center_panel.measure(d);return{width:a+w.width+_,height:m+w.height+l,inner:{left:a,right:_,top:m,bottom:l},align:(h=e.center_panel.sizing,i=h.width_policy,o=h.height_policy,"fixed"!=i&&"fixed"!=o)}},e.prototype._set_geometry=function(e,h){t.prototype._set_geometry.call(this,e,h),this.center_panel.set_geometry(h);var i=this.left_panel.measure({width:0,height:e.height}),o=this.right_panel.measure({width:0,height:e.height}),r=this.top_panel.measure({width:e.width,height:0}),n=this.bottom_panel.measure({width:e.width,height:0}),a=h.left,_=h.top,g=h.right,m=h.bottom;this.top_panel.set_geometry(new s.BBox({left:a,right:g,bottom:_,height:r.height})),this.bottom_panel.set_geometry(new s.BBox({left:a,right:g,top:m,height:n.height})),this.left_panel.set_geometry(new s.BBox({top:_,bottom:m,right:a,width:i.width})),this.right_panel.set_geometry(new s.BBox({top:_,bottom:m,left:g,width:o.width}))},e}(a.Layoutable);h.BorderLayout=_,_.__name__="BorderLayout"},
function _(e,t,i,r,l){r();var o=e(1),a=e(352),n=e(353),h=e(123),s=Math.PI/2,c="alphabetic",_="top",d="middle",p="hanging",u="left",b="right",f="center",m={above:{parallel:0,normal:-s,horizontal:0,vertical:-s},below:{parallel:0,normal:s,horizontal:0,vertical:s},left:{parallel:-s,normal:0,horizontal:0,vertical:-s},right:{parallel:s,normal:0,horizontal:0,vertical:s}},g={above:{justified:_,parallel:c,normal:d,horizontal:c,vertical:d},below:{justified:"bottom",parallel:p,normal:d,horizontal:p,vertical:d},left:{justified:_,parallel:c,normal:d,horizontal:d,vertical:c},right:{justified:_,parallel:c,normal:d,horizontal:d,vertical:c}},z={above:{justified:f,parallel:f,normal:u,horizontal:f,vertical:u},below:{justified:f,parallel:f,normal:u,horizontal:f,vertical:u},left:{justified:f,parallel:f,normal:b,horizontal:b,vertical:f},right:{justified:f,parallel:f,normal:u,horizontal:u,vertical:f}},v={above:b,below:u,left:b,right:u},y={above:u,below:b,left:b,right:u},j=function(e){function t(t,i){var r=e.call(this)||this;switch(r.side=t,r.obj=i,r.side){case"above":r._dim=0,r._normals=[0,-1];break;case"below":r._dim=0,r._normals=[0,1];break;case"left":r._dim=1,r._normals=[-1,0];break;case"right":r._dim=1,r._normals=[1,0]}return r.is_horizontal?r.set_sizing({width_policy:"max",height_policy:"fixed"}):r.set_sizing({width_policy:"fixed",height_policy:"max"}),r}return o.__extends(t,e),t.prototype._content_size=function(){return new a.Sizeable(this.get_oriented_size())},t.prototype.get_oriented_size=function(){var e=this.obj.get_size(),t=e.width,i=e.height;return!this.obj.rotate||this.is_horizontal?{width:t,height:i}:{width:i,height:t}},t.prototype.has_size_changed=function(){var e=this.get_oriented_size(),t=e.width,i=e.height;return this.is_horizontal?this.bbox.height!=i:this.bbox.width!=t},Object.defineProperty(t.prototype,"dimension",{get:function(){return this._dim},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"normals",{get:function(){return this._normals},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"is_horizontal",{get:function(){return 0==this._dim},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"is_vertical",{get:function(){return 1==this._dim},enumerable:!1,configurable:!0}),t.prototype.apply_label_text_heuristics=function(e,t){var i,r,l=this.side;h.isString(t)?(i=g[l][t],r=z[l][t]):t<0?(i="middle",r=v[l]):(i="middle",r=y[l]),e.textBaseline=i,e.textAlign=r},t.prototype.get_label_angle_heuristic=function(e){return m[this.side][e]},t}(n.ContentLayoutable);i.SidePanel=j,j.__name__="SidePanel"},
function _(r,e,a,t,n){t();var l=r(1),o=r(349),i=r(134),s=function(){function r(r){this.parent=r,this.invalidate_dataranges=!0}return Object.defineProperty(r.prototype,"frame",{get:function(){return this.parent.frame},enumerable:!1,configurable:!0}),r.prototype.update=function(r,e){var a,t,n,o,i,s,_,u,d=this.frame,f=d.x_ranges,v=d.y_ranges;if(null==r){try{for(var y=l.__values(f),c=y.next();!c.done;c=y.next()){(M=l.__read(c.value,2)[1]).reset()}}catch(r){a={error:r}}finally{try{c&&!c.done&&(t=y.return)&&t.call(y)}finally{if(a)throw a.error}}try{for(var h=l.__values(v),g=h.next();!g.done;g=h.next()){(M=l.__read(g.value,2)[1]).reset()}}catch(r){n={error:r}}finally{try{g&&!g.done&&(o=h.return)&&o.call(h)}finally{if(n)throw n.error}}this.update_dataranges()}else{var p=[];try{for(var x=l.__values(f),w=x.next();!w.done;w=x.next()){var m=l.__read(w.value,2),b=m[0],M=m[1];p.push([M,r.xrs.get(b)])}}catch(r){i={error:r}}finally{try{w&&!w.done&&(s=x.return)&&s.call(x)}finally{if(i)throw i.error}}try{for(var R=l.__values(v),D=R.next();!D.done;D=R.next()){var N=l.__read(D.value,2);b=N[0],M=N[1];p.push([M,r.yrs.get(b)])}}catch(r){_={error:r}}finally{try{D&&!D.done&&(u=R.return)&&u.call(R)}finally{if(_)throw _.error}}(null==e?void 0:e.scrolling)&&this._update_ranges_together(p),this._update_ranges_individually(p,e)}},r.prototype.reset=function(){this.update(null)},r.prototype.update_dataranges=function(){var r,e,a,t,n,s,_,u,d,f,v,y,c,h,g=new Map,p=new Map,x=!1;try{for(var w=l.__values(this.frame.x_ranges),m=w.next();!m.done;m=w.next()){(L=l.__read(m.value,2)[1])instanceof o.DataRange1d&&"log"==L.scale_hint&&(x=!0)}}catch(e){r={error:e}}finally{try{m&&!m.done&&(e=w.return)&&e.call(w)}finally{if(r)throw r.error}}try{for(var b=l.__values(this.frame.y_ranges),M=b.next();!M.done;M=b.next()){(T=l.__read(M.value,2)[1])instanceof o.DataRange1d&&"log"==T.scale_hint&&(x=!0)}}catch(r){a={error:r}}finally{try{M&&!M.done&&(t=b.return)&&t.call(b)}finally{if(a)throw a.error}}try{for(var R=l.__values(this.parent.model.data_renderers),D=R.next();!D.done;D=R.next()){var N=D.value,k=this.parent.renderer_view(N);if(null!=k){var j=k.glyph_view.bounds();if(null!=j&&g.set(N,j),x){var F=k.glyph_view.log_bounds();null!=F&&p.set(N,F)}}}}catch(r){n={error:r}}finally{try{D&&!D.done&&(s=R.return)&&s.call(R)}finally{if(n)throw n.error}}var O,P=!1,q=!1,z=this.frame.bbox,A=z.width,B=z.height;!1!==this.parent.model.match_aspect&&0!=A&&0!=B&&(O=1/this.parent.model.aspect_scale*(A/B));try{for(var C=l.__values(this.frame.x_ranges),E=C.next();!E.done;E=C.next()){if((L=l.__read(E.value,2)[1])instanceof o.DataRange1d){var G="log"==L.scale_hint?p:g;L.update(G,0,this.parent.model,O),L.follow&&(P=!0)}null!=L.bounds&&(q=!0)}}catch(r){_={error:r}}finally{try{E&&!E.done&&(u=C.return)&&u.call(C)}finally{if(_)throw _.error}}try{for(var H=l.__values(this.frame.y_ranges),I=H.next();!I.done;I=H.next()){if((T=l.__read(I.value,2)[1])instanceof o.DataRange1d){G="log"==T.scale_hint?p:g;T.update(G,1,this.parent.model,O),T.follow&&(P=!0)}null!=T.bounds&&(q=!0)}}catch(r){d={error:r}}finally{try{I&&!I.done&&(f=H.return)&&f.call(H)}finally{if(d)throw d.error}}if(P&&q){i.logger.warn("Follow enabled so bounds are unset.");try{for(var J=l.__values(this.frame.x_ranges),K=J.next();!K.done;K=J.next()){var L;(L=l.__read(K.value,2)[1]).bounds=null}}catch(r){v={error:r}}finally{try{K&&!K.done&&(y=J.return)&&y.call(J)}finally{if(v)throw v.error}}try{for(var Q=l.__values(this.frame.y_ranges),S=Q.next();!S.done;S=Q.next()){var T;(T=l.__read(S.value,2)[1]).bounds=null}}catch(r){c={error:r}}finally{try{S&&!S.done&&(h=Q.return)&&h.call(Q)}finally{if(c)throw c.error}}}this.invalidate_dataranges=!1},r.prototype.compute_initial=function(){var r,e,a,t,n=!0,o=this.frame,s=o.x_ranges,_=o.y_ranges,u=new Map,d=new Map;try{for(var f=l.__values(s),v=f.next();!v.done;v=f.next()){var y=l.__read(v.value,2),c=y[0],h=(w=y[1]).start,g=w.end;if(null==h||null==g||isNaN(h+g)){n=!1;break}u.set(c,{start:h,end:g})}}catch(e){r={error:e}}finally{try{v&&!v.done&&(e=f.return)&&e.call(f)}finally{if(r)throw r.error}}if(n)try{for(var p=l.__values(_),x=p.next();!x.done;x=p.next()){var w,m=l.__read(x.value,2);c=m[0],h=(w=m[1]).start,g=w.end;if(null==h||null==g||isNaN(h+g)){n=!1;break}d.set(c,{start:h,end:g})}}catch(r){a={error:r}}finally{try{x&&!x.done&&(t=p.return)&&t.call(p)}finally{if(a)throw a.error}}return n?{xrs:u,yrs:d}:(i.logger.warn("could not set initial ranges"),null)},r.prototype._update_ranges_together=function(r){var e,a,t,n,o=1;try{for(var i=l.__values(r),s=i.next();!s.done;s=i.next()){var _=l.__read(s.value,2),u=_[0],d=_[1];o=Math.min(o,this._get_weight_to_constrain_interval(u,d))}}catch(r){e={error:r}}finally{try{s&&!s.done&&(a=i.return)&&a.call(i)}finally{if(e)throw e.error}}if(o<1)try{for(var f=l.__values(r),v=f.next();!v.done;v=f.next()){var y=l.__read(v.value,2);u=y[0];(d=y[1]).start=o*d.start+(1-o)*u.start,d.end=o*d.end+(1-o)*u.end}}catch(r){t={error:r}}finally{try{v&&!v.done&&(n=f.return)&&n.call(f)}finally{if(t)throw t.error}}},r.prototype._update_ranges_individually=function(r,e){var a,t,n,o,i=!!(null==e?void 0:e.panning),s=!!(null==e?void 0:e.scrolling),_=!1;try{for(var u=l.__values(r),d=u.next();!d.done;d=u.next()){var f=l.__read(d.value,2),v=f[0],y=f[1];if(!s){var c=this._get_weight_to_constrain_interval(v,y);c<1&&(y.start=c*y.start+(1-c)*v.start,y.end=c*y.end+(1-c)*v.end)}if(null!=v.bounds&&"auto"!=v.bounds){var h=l.__read(v.bounds,2),g=h[0],p=h[1],x=Math.abs(y.end-y.start);v.is_reversed?(null!=g&&g>=y.end&&(_=!0,y.end=g,(i||s)&&(y.start=g+x)),null!=p&&p<=y.start&&(_=!0,y.start=p,(i||s)&&(y.end=p-x))):(null!=g&&g>=y.start&&(_=!0,y.start=g,(i||s)&&(y.end=g+x)),null!=p&&p<=y.end&&(_=!0,y.end=p,(i||s)&&(y.start=p-x)))}}}catch(r){a={error:r}}finally{try{d&&!d.done&&(t=u.return)&&t.call(u)}finally{if(a)throw a.error}}if(!(s&&_&&(null==e?void 0:e.maintain_focus)))try{for(var w=l.__values(r),m=w.next();!m.done;m=w.next()){var b=l.__read(m.value,2);v=b[0],y=b[1];v.have_updated_interactively=!0,v.start==y.start&&v.end==y.end||v.setv(y)}}catch(r){n={error:r}}finally{try{m&&!m.done&&(o=w.return)&&o.call(w)}finally{if(n)throw n.error}}},r.prototype._get_weight_to_constrain_interval=function(r,e){var a=r.min_interval,t=r.max_interval;if(null!=r.bounds&&"auto"!=r.bounds){var n=l.__read(r.bounds,2),o=n[0],i=n[1];if(null!=o&&null!=i){var s=Math.abs(i-o);t=null!=t?Math.min(t,s):s}}var _=1;if(null!=a||null!=t){var u=Math.abs(r.end-r.start),d=Math.abs(e.end-e.start);null!=a&&a>0&&d<a&&(_=(u-a)/(u-d)),null!=t&&t>0&&d>t&&(_=(t-u)/(d-u)),_=Math.max(0,Math.min(1,_))}return _},r}();a.RangeManager=s,s.__name__="RangeManager"},
function _(t,e,o,i,n){i();var s=t(1),a=t(130),p=t(187),l=t(152),_=t(428),r=new a.Signal0({},"gmaps_ready"),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype.initialize=function(){var e=this;this.pause(),t.prototype.initialize.call(this),this._tiles_loaded=!1,this.zoom_count=0;var o=this.model.map_options,i=o.zoom,n=o.lat,s=o.lng;if(this.initial_zoom=i,this.initial_lat=n,this.initial_lng=s,"undefined"==typeof google||null==google.maps){if(void 0===window._bokeh_gmaps_callback)!function(t){window._bokeh_gmaps_callback=function(){return r.emit()};var e=document.createElement("script");e.type="text/javascript",e.src="https://maps.googleapis.com/maps/api/js?v=3.36&key="+t+"&callback=_bokeh_gmaps_callback",document.body.appendChild(e)}(atob(this.model.api_key));r.connect((function(){return e.request_render()}))}this.unpause()},e.prototype.remove=function(){p.remove(this.map_el),t.prototype.remove.call(this)},e.prototype.update_range=function(e,o){var i,n;if(null==e)this.map.setCenter({lat:this.initial_lat,lng:this.initial_lng}),this.map.setOptions({zoom:this.initial_zoom}),t.prototype.update_range.call(this,null,o);else if(null!=e.sdx||null!=e.sdy)this.map.panBy(null!==(i=e.sdx)&&void 0!==i?i:0,null!==(n=e.sdy)&&void 0!==n?n:0),t.prototype.update_range.call(this,e,o);else if(null!=e.factor){if(10!==this.zoom_count)return void(this.zoom_count+=1);this.zoom_count=0,this.pause(),t.prototype.update_range.call(this,e,o);var a=e.factor<0?-1:1,p=this.map.getZoom(),l=p+a;if(l>=2){this.map.setZoom(l);var _=s.__read(this._get_projected_bounds(),3),r=_[0];_[1]-r<0&&this.map.setZoom(p)}this.unpause()}this._set_bokeh_ranges()},e.prototype._build_map=function(){var t=this,e=google.maps;this.map_types={satellite:e.MapTypeId.SATELLITE,terrain:e.MapTypeId.TERRAIN,roadmap:e.MapTypeId.ROADMAP,hybrid:e.MapTypeId.HYBRID};var o=this.model.map_options,i={center:new e.LatLng(o.lat,o.lng),zoom:o.zoom,disableDefaultUI:!0,mapTypeId:this.map_types[o.map_type],scaleControl:o.scale_control,tilt:o.tilt};null!=o.styles&&(i.styles=JSON.parse(o.styles)),this.map_el=p.div({style:{position:"absolute"}}),this.canvas_view.add_underlay(this.map_el),this.map=new e.Map(this.map_el,i),e.event.addListener(this.map,"idle",(function(){return t._set_bokeh_ranges()})),e.event.addListener(this.map,"bounds_changed",(function(){return t._set_bokeh_ranges()})),e.event.addListenerOnce(this.map,"tilesloaded",(function(){return t._render_finished()})),this.connect(this.model.properties.map_options.change,(function(){return t._update_options()})),this.connect(this.model.map_options.properties.styles.change,(function(){return t._update_styles()})),this.connect(this.model.map_options.properties.lat.change,(function(){return t._update_center("lat")})),this.connect(this.model.map_options.properties.lng.change,(function(){return t._update_center("lng")})),this.connect(this.model.map_options.properties.zoom.change,(function(){return t._update_zoom()})),this.connect(this.model.map_options.properties.map_type.change,(function(){return t._update_map_type()})),this.connect(this.model.map_options.properties.scale_control.change,(function(){return t._update_scale_control()})),this.connect(this.model.map_options.properties.tilt.change,(function(){return t._update_tilt()}))},e.prototype._render_finished=function(){this._tiles_loaded=!0,this.notify_finished()},e.prototype.has_finished=function(){return t.prototype.has_finished.call(this)&&!0===this._tiles_loaded},e.prototype._get_latlon_bounds=function(){var t=this.map.getBounds(),e=t.getNorthEast(),o=t.getSouthWest();return[o.lng(),e.lng(),o.lat(),e.lat()]},e.prototype._get_projected_bounds=function(){var t=s.__read(this._get_latlon_bounds(),4),e=t[0],o=t[1],i=t[2],n=t[3],a=s.__read(l.wgs84_mercator.compute(e,i),2),p=a[0],_=a[1],r=s.__read(l.wgs84_mercator.compute(o,n),2);return[p,r[0],_,r[1]]},e.prototype._set_bokeh_ranges=function(){var t=s.__read(this._get_projected_bounds(),4),e=t[0],o=t[1],i=t[2],n=t[3];this.frame.x_range.setv({start:e,end:o}),this.frame.y_range.setv({start:i,end:n})},e.prototype._update_center=function(t){var e=this.map.getCenter().toJSON();e[t]=this.model.map_options[t],this.map.setCenter(e),this._set_bokeh_ranges()},e.prototype._update_map_type=function(){this.map.setOptions({mapTypeId:this.map_types[this.model.map_options.map_type]})},e.prototype._update_scale_control=function(){this.map.setOptions({scaleControl:this.model.map_options.scale_control})},e.prototype._update_tilt=function(){this.map.setOptions({tilt:this.model.map_options.tilt})},e.prototype._update_options=function(){this._update_styles(),this._update_center("lat"),this._update_center("lng"),this._update_zoom(),this._update_map_type()},e.prototype._update_styles=function(){this.map.setOptions({styles:JSON.parse(this.model.map_options.styles)})},e.prototype._update_zoom=function(){this.map.setOptions({zoom:this.model.map_options.zoom}),this._set_bokeh_ranges()},e.prototype._map_hook=function(t,e){if(null==this.map&&"undefined"!=typeof google&&null!=google.maps&&this._build_map(),null!=this.map_el){var o=s.__read(e,4),i=o[0],n=o[1],a=o[2],p=o[3];this.map_el.style.top=n+"px",this.map_el.style.left=i+"px",this.map_el.style.width=a+"px",this.map_el.style.height=p+"px"}},e.prototype._paint_empty=function(t,e){var o=this.layout.bbox.width,i=this.layout.bbox.height,n=s.__read(e,4),a=n[0],p=n[1],l=n[2],_=n[3];t.clearRect(0,0,o,i),t.beginPath(),t.moveTo(0,0),t.lineTo(0,i),t.lineTo(o,i),t.lineTo(o,0),t.lineTo(0,0),t.moveTo(a,p),t.lineTo(a+l,p),t.lineTo(a+l,p+_),t.lineTo(a,p+_),t.lineTo(a,p),t.closePath(),null!=this.model.border_fill_color&&(t.fillStyle=this.model.border_fill_color,t.fill())},e}(_.PlotView);o.GMapPlotView=h,h.__name__="GMapPlotView"},
function _(a,n,e,g,R){g(),R("DataRange",a(350).DataRange),R("DataRange1d",a(349).DataRange1d),R("FactorRange",a(207).FactorRange),R("Range",a(208).Range),R("Range1d",a(275).Range1d)},
function _(e,r,d,n,R){n(),R("GlyphRenderer",e(210).GlyphRenderer),R("GraphRenderer",e(231).GraphRenderer),R("GuideRenderer",e(317).GuideRenderer),R("Renderer",e(185).Renderer)},
function _(a,e,l,c,n){c(),n("CategoricalScale",a(348).CategoricalScale),n("ContinuousScale",a(265).ContinuousScale),n("LinearScale",a(264).LinearScale),n("LinearInterpolationScale",a(276).LinearInterpolationScale),n("LogScale",a(277).LogScale),n("Scale",a(266).Scale)},
function _(e,t,n,o,c){o(),e(1).__exportStar(e(236),n),c("Selection",e(202).Selection)},
function _(a,e,S,o,r){o(),r("ServerSentDataSource",a(442).ServerSentDataSource),r("AjaxDataSource",a(444).AjaxDataSource),r("ColumnDataSource",a(237).ColumnDataSource),r("ColumnarDataSource",a(200).ColumnarDataSource),r("CDSView",a(228).CDSView),r("DataSource",a(201).DataSource),r("GeoJSONDataSource",a(445).GeoJSONDataSource),r("WebDataSource",a(443).WebDataSource)},
function _(t,e,a,i,n){i();var r=t(1),o=function(t){function e(e){var a=t.call(this,e)||this;return a.initialized=!1,a}return r.__extends(e,t),e.prototype.setup=function(){var t=this;this.initialized||(this.initialized=!0,new EventSource(this.data_url).onmessage=function(e){t.load_data(JSON.parse(e.data),t.mode,t.max_size)})},e}(t(443).WebDataSource);a.ServerSentDataSource=o,o.__name__="ServerSentDataSource"},
function _(t,a,e,r,n){r();var i=t(1),o=t(237),l=t(135),u=function(t){function a(a){return t.call(this,a)||this}return i.__extends(a,t),a.prototype.get_column=function(t){var a=this.data[t];return null!=a?a:[]},a.prototype.initialize=function(){t.prototype.initialize.call(this),this.setup()},a.prototype.load_data=function(t,a,e){var r,n,o,l=this.adapter;switch(o=null!=l?l.execute(this,{response:t}):t,a){case"replace":this.data=o;break;case"append":var u=this.data;try{for(var c=i.__values(this.columns()),s=c.next();!s.done;s=c.next()){var d=s.value,p=Array.from(u[d]),f=Array.from(o[d]);o[d]=p.concat(f).slice(-e)}}catch(t){r={error:t}}finally{try{s&&!s.done&&(n=c.return)&&n.call(c)}finally{if(r)throw r.error}}this.data=o}},a.init_WebDataSource=function(){this.define((function(t){var a=t.Any,e=t.Int,r=t.String,n=t.Nullable;return{max_size:[e],mode:[l.UpdateMode,"replace"],adapter:[n(a),null],data_url:[r]}}))},a}(o.ColumnDataSource);e.WebDataSource=u,u.__name__="WebDataSource",u.init_WebDataSource()},
function _(t,e,r,i,n){i();var a=t(1),o=t(443),l=t(135),s=t(134),d=t(128),u=function(t){function e(e){var r=t.call(this,e)||this;return r.interval=null,r.initialized=!1,r}return a.__extends(e,t),e.init_AjaxDataSource=function(){this.define((function(t){var e=t.Boolean,r=t.Int,i=t.String,n=t.Dict;return{polling_interval:[(0,t.Nullable)(r),null],content_type:[i,"application/json"],http_headers:[n(i),{}],method:[l.HTTPMethod,"POST"],if_modified:[e,!1]}}))},e.prototype.destroy=function(){null!=this.interval&&clearInterval(this.interval),t.prototype.destroy.call(this)},e.prototype.setup=function(){var t=this;if(!this.initialized&&(this.initialized=!0,this.get_data(this.mode),null!=this.polling_interval)){this.interval=setInterval((function(){return t.get_data(t.mode,t.max_size,t.if_modified)}),this.polling_interval)}},e.prototype.get_data=function(t,e,r){var i=this;void 0===e&&(e=0),void 0===r&&(r=!1);var n=this.prepare_request();n.addEventListener("load",(function(){return i.do_load(n,t,e)})),n.addEventListener("error",(function(){return i.do_error(n)})),n.send()},e.prototype.prepare_request=function(){var t,e,r=new XMLHttpRequest;r.open(this.method,this.data_url,!0),r.withCredentials=!1,r.setRequestHeader("Content-Type",this.content_type);var i=this.http_headers;try{for(var n=a.__values(d.entries(i)),o=n.next();!o.done;o=n.next()){var l=a.__read(o.value,2),s=l[0],u=l[1];r.setRequestHeader(s,u)}}catch(e){t={error:e}}finally{try{o&&!o.done&&(e=n.return)&&e.call(n)}finally{if(t)throw t.error}}return r},e.prototype.do_load=function(t,e,r){if(200===t.status){var i=JSON.parse(t.responseText);this.load_data(i,e,r)}},e.prototype.do_error=function(t){s.logger.error("Failed to fetch JSON from "+this.data_url+" with code "+t.status)},e}(o.WebDataSource);r.AjaxDataSource=u,u.__name__="AjaxDataSource",u.init_AjaxDataSource()},
function _(e,r,t,o,n){o();var a=e(1),i=e(200),s=e(134),l=e(124),_=e(128);function u(e){return null!=e?e:NaN}var c=function(e){function r(r){return e.call(this,r)||this}return a.__extends(r,e),r.init_GeoJSONDataSource=function(){this.define((function(e){return{geojson:[e.String]}})),this.internal((function(e){return{data:[(0,e.Dict)(e.Arrayable),{}]}}))},r.prototype.initialize=function(){e.prototype.initialize.call(this),this._update_data()},r.prototype.connect_signals=function(){var r=this;e.prototype.connect_signals.call(this),this.connect(this.properties.geojson.change,(function(){return r._update_data()}))},r.prototype._update_data=function(){this.data=this.geojson_to_column_data()},r.prototype._get_new_list_array=function(e){return l.range(0,e).map((function(e){return[]}))},r.prototype._get_new_nan_array=function(e){return l.range(0,e).map((function(e){return NaN}))},r.prototype._add_properties=function(e,r,t,o){var n,i,s,l=null!==(s=e.properties)&&void 0!==s?s:{};try{for(var c=a.__values(_.entries(l)),y=c.next();!y.done;y=c.next()){var h=a.__read(y.value,2),d=h[0],f=h[1];r.hasOwnProperty(d)||(r[d]=this._get_new_nan_array(o)),r[d][t]=u(f)}}catch(e){n={error:e}}finally{try{y&&!y.done&&(i=c.return)&&i.call(c)}finally{if(n)throw n.error}}},r.prototype._add_geometry=function(e,r,t){var o,n;function i(e,r){return e.concat([[NaN,NaN,NaN]]).concat(r)}switch(e.type){case"Point":var l=a.__read(e.coordinates,3),_=l[0],c=l[1],y=l[2];r.x[t]=_,r.y[t]=c,r.z[t]=u(y);break;case"LineString":for(var h=e.coordinates,d=0;d<h.length;d++){var f=a.__read(h[d],3);_=f[0],c=f[1],y=f[2];r.xs[t][d]=_,r.ys[t][d]=c,r.zs[t][d]=u(y)}break;case"Polygon":e.coordinates.length>1&&s.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used.");var g=e.coordinates[0];for(d=0;d<g.length;d++){var p=a.__read(g[d],3);_=p[0],c=p[1],y=p[2];r.xs[t][d]=_,r.ys[t][d]=c,r.zs[t][d]=u(y)}break;case"MultiPoint":s.logger.warn("MultiPoint not supported in Bokeh");break;case"MultiLineString":for(h=e.coordinates.reduce(i),d=0;d<h.length;d++){var v=a.__read(h[d],3);_=v[0],c=v[1],y=v[2];r.xs[t][d]=_,r.ys[t][d]=c,r.zs[t][d]=u(y)}break;case"MultiPolygon":var w=[];try{for(var m=a.__values(e.coordinates),x=m.next();!x.done;x=m.next()){var N=x.value;N.length>1&&s.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used."),w.push(N[0])}}catch(e){o={error:e}}finally{try{x&&!x.done&&(n=m.return)&&n.call(m)}finally{if(o)throw o.error}}for(h=w.reduce(i),d=0;d<h.length;d++){var S=a.__read(h[d],3);_=S[0],c=S[1],y=S[2];r.xs[t][d]=_,r.ys[t][d]=c,r.zs[t][d]=u(y)}break;default:throw new Error("Invalid GeoJSON geometry type: "+e.type)}},r.prototype.geojson_to_column_data=function(){var e,r,t,o,n,i,s,l=JSON.parse(this.geojson);switch(l.type){case"GeometryCollection":if(null==l.geometries)throw new Error("No geometries found in GeometryCollection");if(0===l.geometries.length)throw new Error("geojson.geometries must have one or more items");s=l.geometries;break;case"FeatureCollection":if(null==l.features)throw new Error("No features found in FeaturesCollection");if(0==l.features.length)throw new Error("geojson.features must have one or more items");s=l.features;break;default:throw new Error("Bokeh only supports type GeometryCollection and FeatureCollection at top level")}var _=0;try{for(var u=a.__values(s),c=u.next();!c.done;c=u.next()){"GeometryCollection"==(p="Feature"===(g=c.value).type?g.geometry:g).type?_+=p.geometries.length:_+=1}}catch(r){e={error:r}}finally{try{c&&!c.done&&(r=u.return)&&r.call(u)}finally{if(e)throw e.error}}var y={x:this._get_new_nan_array(_),y:this._get_new_nan_array(_),z:this._get_new_nan_array(_),xs:this._get_new_list_array(_),ys:this._get_new_list_array(_),zs:this._get_new_list_array(_)},h=0;try{for(var d=a.__values(s),f=d.next();!f.done;f=d.next()){var g,p;if("GeometryCollection"==(p="Feature"==(g=f.value).type?g.geometry:g).type)try{for(var v=(n=void 0,a.__values(p.geometries)),w=v.next();!w.done;w=v.next()){var m=w.value;this._add_geometry(m,y,h),"Feature"===g.type&&this._add_properties(g,y,h,_),h+=1}}catch(e){n={error:e}}finally{try{w&&!w.done&&(i=v.return)&&i.call(v)}finally{if(n)throw n.error}}else this._add_geometry(p,y,h),"Feature"===g.type&&this._add_properties(g,y,h,_),h+=1}}catch(e){t={error:e}}finally{try{f&&!f.done&&(o=d.return)&&o.call(d)}finally{if(t)throw t.error}}return y},r}(i.ColumnarDataSource);t.GeoJSONDataSource=c,c.__name__="GeoJSONDataSource",c.init_GeoJSONDataSource()},
function _(e,i,r,c,k){c(),k("AdaptiveTicker",e(249).AdaptiveTicker),k("BasicTicker",e(248).BasicTicker),k("CategoricalTicker",e(319).CategoricalTicker),k("CompositeTicker",e(330).CompositeTicker),k("ContinuousTicker",e(245).ContinuousTicker),k("DatetimeTicker",e(329).DatetimeTicker),k("DaysTicker",e(331).DaysTicker),k("FixedTicker",e(447).FixedTicker),k("LogTicker",e(338).LogTicker),k("MercatorTicker",e(341).MercatorTicker),k("MonthsTicker",e(334).MonthsTicker),k("SingleIntervalTicker",e(332).SingleIntervalTicker),k("Ticker",e(246).Ticker),k("YearsTicker",e(335).YearsTicker)},
function _(t,i,n,r,e){r();var o=t(1),c=function(t){function i(i){return t.call(this,i)||this}return o.__extends(i,t),i.init_FixedTicker=function(){this.define((function(t){var i=t.Number,n=t.Array;return{ticks:[n(i),[]],minor_ticks:[n(i),[]]}}))},i.prototype.get_ticks_no_defaults=function(t,i,n,r){return{major:this.ticks,minor:this.minor_ticks}},i.prototype.get_interval=function(t,i,n){return 0},i.prototype.get_min_interval=function(){return 0},i.prototype.get_max_interval=function(){return 0},i}(t(245).ContinuousTicker);n.FixedTicker=c,c.__name__="FixedTicker",c.init_FixedTicker()},
function _(e,r,T,o,S){o(),S("BBoxTileSource",e(449).BBoxTileSource),S("MercatorTileSource",e(450).MercatorTileSource),S("QUADKEYTileSource",e(453).QUADKEYTileSource),S("TileRenderer",e(454).TileRenderer),S("TileSource",e(451).TileSource),S("TMSTileSource",e(458).TMSTileSource),S("WMTSTileSource",e(455).WMTSTileSource)},
function _(e,t,r,i,n){i();var o=e(1),_=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_BBoxTileSource=function(){this.define((function(e){return{use_latlon:[e.Boolean,!1]}}))},t.prototype.get_image_url=function(e,t,r){var i,n,_,l,u,a,c=this.string_lookup_replace(this.url,this.extra_url_vars);return this.use_latlon?(l=(i=o.__read(this.get_tile_geographic_bounds(e,t,r),4))[0],a=i[1],_=i[2],u=i[3]):(l=(n=o.__read(this.get_tile_meter_bounds(e,t,r),4))[0],a=n[1],_=n[2],u=n[3]),c.replace("{XMIN}",l.toString()).replace("{YMIN}",a.toString()).replace("{XMAX}",_.toString()).replace("{YMAX}",u.toString())},t}(e(450).MercatorTileSource);r.BBoxTileSource=_,_.__name__="BBoxTileSource",_.init_BBoxTileSource()},
function _(t,e,r,i,o){i();var _=t(1),n=t(451),s=t(124),a=t(452),u=function(t){function e(e){return t.call(this,e)||this}return _.__extends(e,t),e.init_MercatorTileSource=function(){this.define((function(t){var e=t.Boolean;return{snap_to_zoom:[e,!1],wrap_around:[e,!0]}})),this.override({x_origin_offset:20037508.34,y_origin_offset:20037508.34,initial_resolution:156543.03392804097})},e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this._resolutions=s.range(this.min_zoom,this.max_zoom+1).map((function(t){return e.get_resolution(t)}))},e.prototype._computed_initial_resolution=function(){return null!=this.initial_resolution?this.initial_resolution:2*Math.PI*6378137/this.tile_size},e.prototype.is_valid_tile=function(t,e,r){return!(!this.wrap_around&&(t<0||t>=Math.pow(2,r)))&&!(e<0||e>=Math.pow(2,r))},e.prototype.parent_by_tile_xyz=function(t,e,r){var i=this.tile_xyz_to_quadkey(t,e,r),o=i.substring(0,i.length-1);return this.quadkey_to_tile_xyz(o)},e.prototype.get_resolution=function(t){return this._computed_initial_resolution()/Math.pow(2,t)},e.prototype.get_resolution_by_extent=function(t,e,r){return[(t[2]-t[0])/r,(t[3]-t[1])/e]},e.prototype.get_level_by_extent=function(t,e,r){var i,o,n=(t[2]-t[0])/r,s=(t[3]-t[1])/e,a=Math.max(n,s),u=0;try{for(var l=_.__values(this._resolutions),h=l.next();!h.done;h=l.next()){if(a>h.value){if(0==u)return 0;if(u>0)return u-1}u+=1}}catch(t){i={error:t}}finally{try{h&&!h.done&&(o=l.return)&&o.call(l)}finally{if(i)throw i.error}}return u-1},e.prototype.get_closest_level_by_extent=function(t,e,r){var i=(t[2]-t[0])/r,o=(t[3]-t[1])/e,_=Math.max(i,o),n=this._resolutions.reduce((function(t,e){return Math.abs(e-_)<Math.abs(t-_)?e:t}));return this._resolutions.indexOf(n)},e.prototype.snap_to_zoom_level=function(t,e,r,i){var o=_.__read(t,4),n=o[0],s=o[1],a=o[2],u=o[3],l=this._resolutions[i],h=r*l,p=e*l;if(!this.snap_to_zoom){var y=(a-n)/h,c=(u-s)/p;y>c?(h=a-n,p*=y):(h*=c,p=u-s)}var f=(h-(a-n))/2,d=(p-(u-s))/2;return[n-f,s-d,a+f,u+d]},e.prototype.tms_to_wmts=function(t,e,r){return[t,Math.pow(2,r)-1-e,r]},e.prototype.wmts_to_tms=function(t,e,r){return[t,Math.pow(2,r)-1-e,r]},e.prototype.pixels_to_meters=function(t,e,r){var i=this.get_resolution(r);return[t*i-this.x_origin_offset,e*i-this.y_origin_offset]},e.prototype.meters_to_pixels=function(t,e,r){var i=this.get_resolution(r);return[(t+this.x_origin_offset)/i,(e+this.y_origin_offset)/i]},e.prototype.pixels_to_tile=function(t,e){var r=Math.ceil(t/this.tile_size);return[r=0===r?r:r-1,Math.max(Math.ceil(e/this.tile_size)-1,0)]},e.prototype.pixels_to_raster=function(t,e,r){return[t,(this.tile_size<<r)-e]},e.prototype.meters_to_tile=function(t,e,r){var i=_.__read(this.meters_to_pixels(t,e,r),2),o=i[0],n=i[1];return this.pixels_to_tile(o,n)},e.prototype.get_tile_meter_bounds=function(t,e,r){var i=_.__read(this.pixels_to_meters(t*this.tile_size,e*this.tile_size,r),2),o=i[0],n=i[1],s=_.__read(this.pixels_to_meters((t+1)*this.tile_size,(e+1)*this.tile_size,r),2);return[o,n,s[0],s[1]]},e.prototype.get_tile_geographic_bounds=function(t,e,r){var i=this.get_tile_meter_bounds(t,e,r),o=_.__read(a.meters_extent_to_geographic(i),4);return[o[0],o[1],o[2],o[3]]},e.prototype.get_tiles_by_extent=function(t,e,r){void 0===r&&(r=1);var i=_.__read(t,4),o=i[0],n=i[1],s=i[2],a=i[3],u=_.__read(this.meters_to_tile(o,n,e),2),l=u[0],h=u[1],p=_.__read(this.meters_to_tile(s,a,e),2),y=p[0],c=p[1];l-=r,h-=r,y+=r;for(var f=[],d=c+=r;d>=h;d--)for(var x=l;x<=y;x++)this.is_valid_tile(x,d,e)&&f.push([x,d,e,this.get_tile_meter_bounds(x,d,e)]);return this.sort_tiles_from_center(f,[l,h,y,c]),f},e.prototype.quadkey_to_tile_xyz=function(t){for(var e=0,r=0,i=t.length,o=i;o>0;o--){var _=1<<o-1;switch(t.charAt(i-o)){case"0":continue;case"1":e|=_;break;case"2":r|=_;break;case"3":e|=_,r|=_;break;default:throw new TypeError("Invalid Quadkey: "+t)}}return[e,r,i]},e.prototype.tile_xyz_to_quadkey=function(t,e,r){for(var i="",o=r;o>0;o--){var _=1<<o-1,n=0;0!=(t&_)&&(n+=1),0!=(e&_)&&(n+=2),i+=n.toString()}return i},e.prototype.children_by_tile_xyz=function(t,e,r){for(var i=this.tile_xyz_to_quadkey(t,e,r),o=[],n=0;n<=3;n++){var s=_.__read(this.quadkey_to_tile_xyz(i+n.toString()),3),a=s[0],u=s[1],l=s[2],h=this.get_tile_meter_bounds(a,u,l);o.push([a,u,l,h])}return o},e.prototype.get_closest_parent_by_tile_xyz=function(t,e,r){var i,o,n,s=this.calculate_world_x_by_tile_xyz(t,e,r);t=(i=_.__read(this.normalize_xyz(t,e,r),3))[0],e=i[1],r=i[2];for(var a=this.tile_xyz_to_quadkey(t,e,r);a.length>0;)if(a=a.substring(0,a.length-1),t=(o=_.__read(this.quadkey_to_tile_xyz(a),3))[0],e=o[1],r=o[2],t=(n=_.__read(this.denormalize_xyz(t,e,r,s),3))[0],e=n[1],r=n[2],this.tiles.has(this.tile_xyz_to_key(t,e,r)))return[t,e,r];return[0,0,0]},e.prototype.normalize_xyz=function(t,e,r){if(this.wrap_around){var i=Math.pow(2,r);return[(t%i+i)%i,e,r]}return[t,e,r]},e.prototype.denormalize_xyz=function(t,e,r,i){return[t+i*Math.pow(2,r),e,r]},e.prototype.denormalize_meters=function(t,e,r,i){return[t+2*i*Math.PI*6378137,e]},e.prototype.calculate_world_x_by_tile_xyz=function(t,e,r){return Math.floor(t/Math.pow(2,r))},e}(n.TileSource);r.MercatorTileSource=u,u.__name__="MercatorTileSource",u.init_MercatorTileSource()},
function _(t,e,r,n,i){n();var o=t(1),a=t(196),l=t(128),c=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_TileSource=function(){this.define((function(t){var e=t.Number,r=t.String;return{url:[r,""],tile_size:[e,256],max_zoom:[e,30],min_zoom:[e,0],extra_url_vars:[(0,t.Dict)(r),{}],attribution:[r,""],x_origin_offset:[e],y_origin_offset:[e],initial_resolution:[e]}}))},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.tiles=new Map,this._normalize_case()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.change,(function(){return e._clear_cache()}))},e.prototype.string_lookup_replace=function(t,e){var r,n,i=t;try{for(var a=o.__values(l.entries(e)),c=a.next();!c.done;c=a.next()){var _=o.__read(c.value,2),p=_[0],u=_[1];i=i.replace("{"+p+"}",u)}}catch(t){r={error:t}}finally{try{c&&!c.done&&(n=a.return)&&n.call(a)}finally{if(r)throw r.error}}return i},e.prototype._normalize_case=function(){var t=this.url.replace("{x}","{X}").replace("{y}","{Y}").replace("{z}","{Z}").replace("{q}","{Q}").replace("{xmin}","{XMIN}").replace("{ymin}","{YMIN}").replace("{xmax}","{XMAX}").replace("{ymax}","{YMAX}");this.url=t},e.prototype._clear_cache=function(){this.tiles=new Map},e.prototype.tile_xyz_to_key=function(t,e,r){return t+":"+e+":"+r},e.prototype.key_to_tile_xyz=function(t){var e=o.__read(t.split(":").map((function(t){return parseInt(t)})),3);return[e[0],e[1],e[2]]},e.prototype.sort_tiles_from_center=function(t,e){var r=o.__read(e,4),n=r[0],i=r[1],a=r[2],l=r[3],c=(a-n)/2+n,_=(l-i)/2+i;t.sort((function(t,e){return Math.sqrt(Math.pow(c-t[0],2)+Math.pow(_-t[1],2))-Math.sqrt(Math.pow(c-e[0],2)+Math.pow(_-e[1],2))}))},e.prototype.get_image_url=function(t,e,r){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",t.toString()).replace("{Y}",e.toString()).replace("{Z}",r.toString())},e}(a.Model);r.TileSource=c,c.__name__="TileSource",c.init_TileSource()},
function _(e,r,t,_,n){_();var o=e(1),a=e(152);function c(e,r){return a.wgs84_mercator.compute(e,r)}function g(e,r){return a.wgs84_mercator.invert(e,r)}t.geographic_to_meters=c,t.meters_to_geographic=g,t.geographic_extent_to_meters=function(e){var r=o.__read(e,4),t=r[0],_=r[1],n=r[2],a=r[3],g=o.__read(c(t,_),2),i=g[0],u=g[1],m=o.__read(c(n,a),2);return[i,u,m[0],m[1]]},t.meters_extent_to_geographic=function(e){var r=o.__read(e,4),t=r[0],_=r[1],n=r[2],a=r[3],c=o.__read(g(t,_),2),i=c[0],u=c[1],m=o.__read(g(n,a),2);return[i,u,m[0],m[1]]}},
function _(t,e,r,_,i){_();var u=t(1),n=function(t){function e(e){return t.call(this,e)||this}return u.__extends(e,t),e.prototype.get_image_url=function(t,e,r){var _=this.string_lookup_replace(this.url,this.extra_url_vars),i=u.__read(this.tms_to_wmts(t,e,r),3),n=i[0],o=i[1],a=i[2],l=this.tile_xyz_to_quadkey(n,o,a);return _.replace("{Q}",l)},e}(t(450).MercatorTileSource);r.QUADKEYTileSource=n,n.__name__="QUADKEYTileSource"},
function _(e,t,i,r,n){r();var a=e(1),o=e(451),_=e(455),s=e(185),l=e(275),h=e(187),d=e(389),u=e(124),c=e(123),p=e(456),f=a.__importDefault(e(457)),m=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(t,e),t.prototype.initialize=function(){this._tiles=[],e.prototype.initialize.call(this)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return t.request_render()})),this.connect(this.model.tile_source.change,(function(){return t.request_render()}))},t.prototype.styles=function(){return a.__spread(e.prototype.styles.call(this),[f.default])},t.prototype.get_extent=function(){return[this.x_range.start,this.y_range.start,this.x_range.end,this.y_range.end]},Object.defineProperty(t.prototype,"map_plot",{get:function(){return this.plot_model},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"map_canvas",{get:function(){return this.layer.ctx},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"map_frame",{get:function(){return this.plot_view.frame},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"x_range",{get:function(){return this.map_plot.x_range},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"y_range",{get:function(){return this.map_plot.y_range},enumerable:!1,configurable:!0}),t.prototype._set_data=function(){this.extent=this.get_extent(),this._last_height=void 0,this._last_width=void 0},t.prototype._update_attribution=function(){null!=this.attribution_el&&h.removeElement(this.attribution_el);var e=this.model.tile_source.attribution;if(c.isString(e)&&e.length>0){var t=this.plot_view,i=t.layout,r=t.frame,n=i.bbox.width-r.bbox.right,a=i.bbox.height-r.bbox.bottom,o=r.bbox.width;this.attribution_el=h.div({class:p.bk_tile_attribution,style:{position:"absolute",right:n+"px",bottom:a+"px","max-width":o-4+"px",padding:"2px","background-color":"rgba(255,255,255,0.5)","font-size":"9px","line-height":"1.05","white-space":"nowrap",overflow:"hidden","text-overflow":"ellipsis"}}),this.plot_view.canvas_view.add_event(this.attribution_el),this.attribution_el.innerHTML=e,this.attribution_el.title=this.attribution_el.textContent.replace(/\s*\n\s*/g," ")}},t.prototype._map_data=function(){this.initial_extent=this.get_extent();var e=this.model.tile_source.get_level_by_extent(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width),t=this.model.tile_source.snap_to_zoom_level(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width,e);this.x_range.start=t[0],this.y_range.start=t[1],this.x_range.end=t[2],this.y_range.end=t[3],this.x_range instanceof l.Range1d&&(this.x_range.reset_start=t[0],this.x_range.reset_end=t[2]),this.y_range instanceof l.Range1d&&(this.y_range.reset_start=t[1],this.y_range.reset_end=t[3]),this._update_attribution()},t.prototype._create_tile=function(e,t,i,r,n){var o=this;void 0===n&&(n=!1);var _=a.__read(this.model.tile_source.normalize_xyz(e,t,i),3),s=_[0],l=_[1],h=_[2],u={img:void 0,tile_coords:[e,t,i],normalized_coords:[s,l,h],quadkey:this.model.tile_source.tile_xyz_to_quadkey(e,t,i),cache_key:this.model.tile_source.tile_xyz_to_key(e,t,i),bounds:r,loaded:!1,finished:!1,x_coord:r[0],y_coord:r[3]},c=this.model.tile_source.get_image_url(s,l,h);new d.ImageLoader(c,{loaded:function(e){Object.assign(u,{img:e,loaded:!0}),n?(u.finished=!0,o.notify_finished()):o.request_render()},failed:function(){u.finished=!0}}),this.model.tile_source.tiles.set(u.cache_key,u),this._tiles.push(u)},t.prototype._enforce_aspect_ratio=function(){if(this._last_height!==this.map_frame.bbox.height||this._last_width!==this.map_frame.bbox.width){var e=this.get_extent(),t=this.model.tile_source.get_level_by_extent(e,this.map_frame.bbox.height,this.map_frame.bbox.width),i=this.model.tile_source.snap_to_zoom_level(e,this.map_frame.bbox.height,this.map_frame.bbox.width,t);this.x_range.setv({start:i[0],end:i[2]}),this.y_range.setv({start:i[1],end:i[3]}),this.extent=i,this._last_height=this.map_frame.bbox.height,this._last_width=this.map_frame.bbox.width}},t.prototype.has_finished=function(){var t,i;if(!e.prototype.has_finished.call(this))return!1;if(0===this._tiles.length)return!1;try{for(var r=a.__values(this._tiles),n=r.next();!n.done;n=r.next()){if(!n.value.finished)return!1}}catch(e){t={error:e}}finally{try{n&&!n.done&&(i=r.return)&&i.call(r)}finally{if(t)throw t.error}}return!0},t.prototype._render=function(){null==this.map_initialized&&(this._set_data(),this._map_data(),this.map_initialized=!0),this._enforce_aspect_ratio(),this._update(),null!=this.prefetch_timer&&clearTimeout(this.prefetch_timer),this.prefetch_timer=setTimeout(this._prefetch_tiles.bind(this),500),this.has_finished()&&this.notify_finished()},t.prototype._draw_tile=function(e){var t=this.model.tile_source.tiles.get(e);if(null!=t&&t.loaded){var i=a.__read(this.coordinates.map_to_screen([t.bounds[0]],[t.bounds[3]]),2),r=a.__read(i[0],1)[0],n=a.__read(i[1],1)[0],o=a.__read(this.coordinates.map_to_screen([t.bounds[2]],[t.bounds[1]]),2),_=a.__read(o[0],1)[0]-r,s=a.__read(o[1],1)[0]-n,l=r,h=n,d=this.map_canvas.getImageSmoothingEnabled();this.map_canvas.setImageSmoothingEnabled(this.model.smoothing),this.map_canvas.drawImage(t.img,l,h,_,s),this.map_canvas.setImageSmoothingEnabled(d),t.finished=!0}},t.prototype._set_rect=function(){var e=this.plot_model.properties.outline_line_width.value(),t=this.map_frame.bbox.left+e/2,i=this.map_frame.bbox.top+e/2,r=this.map_frame.bbox.width-e,n=this.map_frame.bbox.height-e;this.map_canvas.rect(t,i,r,n),this.map_canvas.clip()},t.prototype._render_tiles=function(e){var t,i;this.map_canvas.save(),this._set_rect(),this.map_canvas.globalAlpha=this.model.alpha;try{for(var r=a.__values(e),n=r.next();!n.done;n=r.next()){var o=n.value;this._draw_tile(o)}}catch(e){t={error:e}}finally{try{n&&!n.done&&(i=r.return)&&i.call(r)}finally{if(t)throw t.error}}this.map_canvas.restore()},t.prototype._prefetch_tiles=function(){for(var e,t,i=this.model.tile_source,r=this.get_extent(),n=this.map_frame.bbox.height,o=this.map_frame.bbox.width,_=this.model.tile_source.get_level_by_extent(r,n,o),s=this.model.tile_source.get_tiles_by_extent(r,_),l=0,h=Math.min(10,s.length);l<h;l++){var d=a.__read(s[l],3),u=d[0],c=d[1],p=d[2],f=this.model.tile_source.children_by_tile_xyz(u,c,p);try{for(var m=(e=void 0,a.__values(f)),y=m.next();!y.done;y=m.next()){var b=y.value,g=a.__read(b,4),x=g[0],v=g[1],w=g[2],z=g[3];i.tiles.has(i.tile_xyz_to_key(x,v,w))||this._create_tile(x,v,w,z,!0)}}catch(t){e={error:t}}finally{try{y&&!y.done&&(t=m.return)&&t.call(m)}finally{if(e)throw e.error}}}},t.prototype._fetch_tiles=function(e){var t,i;try{for(var r=a.__values(e),n=r.next();!n.done;n=r.next()){var o=n.value,_=a.__read(o,4),s=_[0],l=_[1],h=_[2],d=_[3];this._create_tile(s,l,h,d)}}catch(e){t={error:e}}finally{try{n&&!n.done&&(i=r.return)&&i.call(r)}finally{if(t)throw t.error}}},t.prototype._update=function(){var e,t,i,r,n=this,o=this.model.tile_source,_=o.min_zoom,s=o.max_zoom,l=this.get_extent(),h=this.extent[2]-this.extent[0]<l[2]-l[0],d=this.map_frame.bbox.height,c=this.map_frame.bbox.width,p=o.get_level_by_extent(l,d,c),f=!1;p<_?(l=this.extent,p=_,f=!0):p>s&&(l=this.extent,p=s,f=!0),f&&(this.x_range.setv({x_range:{start:l[0],end:l[2]}}),this.y_range.setv({start:l[1],end:l[3]})),this.extent=l;var m=o.get_tiles_by_extent(l,p),y=[],b=[],g=[],x=[];try{for(var v=a.__values(m),w=v.next();!w.done;w=v.next()){var z=w.value,T=a.__read(z,3),k=T[0],R=T[1],S=T[2],j=o.tile_xyz_to_key(k,R,S),O=o.tiles.get(j);if(null!=O&&O.loaded)b.push(j);else if(this.model.render_parents){var q=a.__read(o.get_closest_parent_by_tile_xyz(k,R,S),3),I=q[0],P=q[1],E=q[2],M=o.tile_xyz_to_key(I,P,E),V=o.tiles.get(M);if(null!=V&&V.loaded&&!u.includes(g,M)&&g.push(M),h){var L=o.children_by_tile_xyz(k,R,S);try{for(var A=(i=void 0,a.__values(L)),B=A.next();!B.done;B=A.next()){var C=a.__read(B.value,3),D=C[0],H=C[1],N=C[2],W=o.tile_xyz_to_key(D,H,N);o.tiles.has(W)&&x.push(W)}}catch(e){i={error:e}}finally{try{B&&!B.done&&(r=A.return)&&r.call(A)}finally{if(i)throw i.error}}}}null==O&&y.push(z)}}catch(t){e={error:t}}finally{try{w&&!w.done&&(t=v.return)&&t.call(v)}finally{if(e)throw e.error}}this._render_tiles(g),this._render_tiles(x),this._render_tiles(b),null!=this.render_timer&&clearTimeout(this.render_timer),this.render_timer=setTimeout((function(){return n._fetch_tiles(y)}),65)},t}(s.RendererView);i.TileRendererView=m,m.__name__="TileRendererView";var y=function(e){function t(t){return e.call(this,t)||this}return a.__extends(t,e),t.init_TileRenderer=function(){this.prototype.default_view=m,this.define((function(e){var t=e.Boolean;return{alpha:[e.Number,1],smoothing:[t,!0],tile_source:[(0,e.Ref)(o.TileSource),function(){return new _.WMTSTileSource}],render_parents:[t,!0]}})),this.override({level:"image"})},t}(s.Renderer);i.TileRenderer=y,y.__name__="TileRenderer",y.init_TileRenderer()},
function _(t,r,e,i,n){i();var _=t(1),o=function(t){function r(r){return t.call(this,r)||this}return _.__extends(r,t),r.prototype.get_image_url=function(t,r,e){var i=this.string_lookup_replace(this.url,this.extra_url_vars),n=_.__read(this.tms_to_wmts(t,r,e),3),o=n[0],u=n[1],a=n[2];return i.replace("{X}",o.toString()).replace("{Y}",u.toString()).replace("{Z}",a.toString())},r}(t(450).MercatorTileSource);e.WMTSTileSource=o,o.__name__="WMTSTileSource"},
function _(t,i,b,n,o){n(),b.bk_tile_attribution="bk-tile-attribution"},
function _(n,t,o,a,b){a();o.default="\n.bk-root .bk-tile-attribution a {\n  color: black;\n}\n"},
function _(r,e,t,i,n){i();var o=r(1),u=function(r){function e(e){return r.call(this,e)||this}return o.__extends(e,r),e.prototype.get_image_url=function(r,e,t){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",r.toString()).replace("{Y}",e.toString()).replace("{Z}",t.toString())},e}(r(450).MercatorTileSource);t.TMSTileSource=u,u.__name__="TMSTileSource"},
function _(e,t,u,a,r){a(),r("CanvasTexture",e(460).CanvasTexture),r("ImageURLTexture",e(462).ImageURLTexture),r("Texture",e(461).Texture)},
function _(t,e,n,r,i){r();var u=t(1),a=t(461),c=t(144),o=function(t){function e(e){return t.call(this,e)||this}return u.__extends(e,t),e.init_CanvasTexture=function(){this.define((function(t){return{code:[t.String]}}))},Object.defineProperty(e.prototype,"func",{get:function(){var t=c.use_strict(this.code);return new Function("ctx","color","scale","weight",t)},enumerable:!1,configurable:!0}),e.prototype.get_pattern=function(t,e,n){var r=this;return function(i){var u=document.createElement("canvas");u.width=e,u.height=e;var a=u.getContext("2d");return r.func.call(r,a,t,e,n),i.createPattern(u,r.repetition)}},e}(a.Texture);n.CanvasTexture=o,o.__name__="CanvasTexture",o.init_CanvasTexture()},
function _(t,e,n,i,r){i();var u=t(1),o=t(196),_=t(135),c=function(t){function e(e){return t.call(this,e)||this}return u.__extends(e,t),e.init_Texture=function(){this.define((function(){return{repetition:[_.TextureRepetition,"repeat"]}}))},e.prototype.onload=function(t){t()},e}(o.Model);n.Texture=c,c.__name__="Texture",c.init_Texture()},
function _(t,e,n,i,r){i();var o=t(1),u=t(461),a=t(389),l=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_ImageURLTexture=function(){this.define((function(t){return{url:[t.String]}}))},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._loader=new a.ImageLoader(this.url)},e.prototype.get_pattern=function(t,e,n){var i=this;return function(t){return i._loader.finished?t.createPattern(i._loader.image,i.repetition):null}},e.prototype.onload=function(t){this._loader.promise.then((function(){return t()}))},e}(u.Texture);n.ImageURLTexture=l,l.__name__="ImageURLTexture",l.init_ImageURLTexture()},
function _(o,l,T,e,t){e(),t("ActionTool",o(306).ActionTool),t("CustomAction",o(464).CustomAction),t("HelpTool",o(307).HelpTool),t("RedoTool",o(465).RedoTool),t("ResetTool",o(466).ResetTool),t("SaveTool",o(467).SaveTool),t("UndoTool",o(468).UndoTool),t("ZoomInTool",o(469).ZoomInTool),t("ZoomOutTool",o(472).ZoomOutTool),t("ButtonTool",o(293).ButtonTool),t("EditTool",o(473).EditTool),t("BoxEditTool",o(474).BoxEditTool),t("FreehandDrawTool",o(475).FreehandDrawTool),t("PointDrawTool",o(476).PointDrawTool),t("PolyDrawTool",o(477).PolyDrawTool),t("PolyTool",o(478).PolyTool),t("PolyEditTool",o(479).PolyEditTool),t("BoxSelectTool",o(480).BoxSelectTool),t("BoxZoomTool",o(483).BoxZoomTool),t("GestureTool",o(292).GestureTool),t("LassoSelectTool",o(484).LassoSelectTool),t("LineEditTool",o(486).LineEditTool),t("PanTool",o(488).PanTool),t("PolySelectTool",o(485).PolySelectTool),t("RangeTool",o(489).RangeTool),t("SelectTool",o(481).SelectTool),t("TapTool",o(490).TapTool),t("WheelPanTool",o(491).WheelPanTool),t("WheelZoomTool",o(492).WheelZoomTool),t("CrosshairTool",o(493).CrosshairTool),t("CustomJSHover",o(494).CustomJSHover),t("HoverTool",o(495).HoverTool),t("InspectTool",o(304).InspectTool),t("Tool",o(291).Tool),t("ToolProxy",o(496).ToolProxy),t("Toolbar",o(290).Toolbar),t("ToolbarBase",o(305).ToolbarBase),t("ProxyToolbar",o(497).ProxyToolbar),t("ToolbarBox",o(497).ToolbarBox)},
function _(t,o,n,i,e){i();var c=t(1),u=t(306),r=t(295),s=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return c.__extends(o,t),o.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(r.bk_toolbar_button_custom_action)},o}(u.ActionToolButtonView);n.CustomActionButtonView=s,s.__name__="CustomActionButtonView";var l=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return c.__extends(o,t),o.prototype.doit=function(){var t;null===(t=this.model.callback)||void 0===t||t.execute(this.model)},o}(u.ActionToolView);n.CustomActionView=l,l.__name__="CustomActionView";var _=function(t){function o(o){var n=t.call(this,o)||this;return n.tool_name="Custom Action",n.button_view=s,n}return c.__extends(o,t),o.init_CustomAction=function(){this.prototype.default_view=l,this.define((function(t){var o=t.Any,n=t.String;return{action_tooltip:[n,"Perform a Custom Action"],callback:[(0,t.Nullable)(o)],icon:[n]}}))},Object.defineProperty(o.prototype,"tooltip",{get:function(){return this.action_tooltip},enumerable:!1,configurable:!0}),o}(u.ActionTool);n.CustomAction=_,_.__name__="CustomAction",_.init_CustomAction()},
function _(o,t,e,n,i){n();var r=o(1),_=o(306),l=o(308),c=function(o){function t(){return null!==o&&o.apply(this,arguments)||this}return r.__extends(t,o),t.prototype.connect_signals=function(){var t=this;o.prototype.connect_signals.call(this),this.connect(this.plot_view.state_changed,(function(){return t.model.disabled=!t.plot_view.can_redo()}))},t.prototype.doit=function(){this.plot_view.redo()},t}(_.ActionToolView);e.RedoToolView=c,c.__name__="RedoToolView";var s=function(o){function t(t){var e=o.call(this,t)||this;return e.tool_name="Redo",e.icon=l.bk_tool_icon_redo,e}return r.__extends(t,o),t.init_RedoTool=function(){this.prototype.default_view=c,this.override({disabled:!0}),this.register_alias("redo",(function(){return new t}))},t}(_.ActionTool);e.RedoTool=s,s.__name__="RedoTool",s.init_RedoTool()},
function _(t,e,o,n,i){n();var _=t(1),s=t(306),r=t(308),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(e,t),e.prototype.doit=function(){this.plot_view.reset()},e}(s.ActionToolView);o.ResetToolView=l,l.__name__="ResetToolView";var u=function(t){function e(e){var o=t.call(this,e)||this;return o.tool_name="Reset",o.icon=r.bk_tool_icon_reset,o}return _.__extends(e,t),e.init_ResetTool=function(){this.prototype.default_view=l,this.register_alias("reset",(function(){return new e}))},e}(s.ActionTool);o.ResetTool=u,u.__name__="ResetTool",u.init_ResetTool()},
function _(t,e,o,n,i){n();var r=t(1),a=t(306),c=t(308),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype.copy=function(){return r.__awaiter(this,void 0,void 0,(function(){var t,e,o;return r.__generator(this,(function(n){switch(n.label){case 0:return[4,this.plot_view.to_blob()];case 1:return t=n.sent(),e=new ClipboardItem(((o={})[t.type]=t,o)),[4,navigator.clipboard.write([e])];case 2:return n.sent(),[2]}}))}))},e.prototype.save=function(t){return r.__awaiter(this,void 0,void 0,(function(){var e,o;return r.__generator(this,(function(n){switch(n.label){case 0:return[4,this.plot_view.to_blob()];case 1:return e=n.sent(),(o=document.createElement("a")).href=URL.createObjectURL(e),o.download=t,o.target="_blank",o.dispatchEvent(new MouseEvent("click")),[2]}}))}))},e.prototype.doit=function(t){switch(void 0===t&&(t="save"),t){case"save":this.save("bokeh_plot");break;case"copy":this.copy()}},e}(a.ActionToolView);o.SaveToolView=u,u.__name__="SaveToolView";var l=function(t){function e(e){var o=t.call(this,e)||this;return o.tool_name="Save",o.icon=c.bk_tool_icon_save,o}return r.__extends(e,t),e.init_SaveTool=function(){this.prototype.default_view=u,this.register_alias("save",(function(){return new e}))},Object.defineProperty(e.prototype,"menu",{get:function(){var t=this;return[{icon:"bk-tool-icon-copy-to-clipboard",tooltip:"Copy image to clipboard",if:function(){return"undefined"!=typeof ClipboardItem},handler:function(){t.do.emit("copy")}}]},enumerable:!1,configurable:!0}),e}(a.ActionTool);o.SaveTool=l,l.__name__="SaveTool",l.init_SaveTool()},
function _(o,n,t,i,e){i();var _=o(1),l=o(306),c=o(308),r=function(o){function n(){return null!==o&&o.apply(this,arguments)||this}return _.__extends(n,o),n.prototype.connect_signals=function(){var n=this;o.prototype.connect_signals.call(this),this.connect(this.plot_view.state_changed,(function(){return n.model.disabled=!n.plot_view.can_undo()}))},n.prototype.doit=function(){this.plot_view.undo()},n}(l.ActionToolView);t.UndoToolView=r,r.__name__="UndoToolView";var s=function(o){function n(n){var t=o.call(this,n)||this;return t.tool_name="Undo",t.icon=c.bk_tool_icon_undo,t}return _.__extends(n,o),n.init_UndoTool=function(){this.prototype.default_view=r,this.override({disabled:!0}),this.register_alias("undo",(function(){return new n}))},n}(l.ActionTool);t.UndoTool=s,s.__name__="UndoTool",s.init_UndoTool()},
function _(o,n,i,t,e){t();var s=o(1),_=o(470),r=o(308),m=function(o){function n(n){var i=o.call(this,n)||this;return i.sign=1,i.tool_name="Zoom In",i.icon=r.bk_tool_icon_zoom_in,i}return s.__extends(n,o),n.init_ZoomInTool=function(){this.prototype.default_view=_.ZoomBaseToolView,this.register_alias("zoom_in",(function(){return new n({dimensions:"both"})})),this.register_alias("xzoom_in",(function(){return new n({dimensions:"width"})})),this.register_alias("yzoom_in",(function(){return new n({dimensions:"height"})}))},n}(_.ZoomBaseTool);i.ZoomInTool=m,m.__name__="ZoomInTool",m.init_ZoomInTool()},
function _(o,t,e,i,n){i();var s=o(1),l=o(306),r=o(135),_=o(471),a=function(o){function t(){return null!==o&&o.apply(this,arguments)||this}return s.__extends(t,o),t.prototype.doit=function(){var o=this.plot_view.frame,t=this.model.dimensions,e="width"==t||"both"==t,i="height"==t||"both"==t,n=_.scale_range(o,this.model.sign*this.model.factor,e,i);this.plot_view.push_state("zoom_out",{range:n}),this.plot_view.update_range(n,{scrolling:!0}),this.model.document&&this.model.document.interactive_start(this.plot_model)},t}(l.ActionToolView);e.ZoomBaseToolView=a,a.__name__="ZoomBaseToolView";var h=function(o){function t(t){return o.call(this,t)||this}return s.__extends(t,o),t.init_ZoomBaseTool=function(){this.prototype.default_view=a,this.define((function(o){return{factor:[o.Percent,.1],dimensions:[r.Dimensions,"both"]}}))},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!1,configurable:!0}),t}(l.ActionTool);e.ZoomBaseTool=h,h.__name__="ZoomBaseTool",h.init_ZoomBaseTool()},
function _(r,e,a,n,_){n();var t=r(1),l=r(125);function o(r,e,a){var n=t.__read([r.start,r.end],2),_=n[0],l=n[1],o=null!=a?a:(l+_)/2;return[_-(_-o)*e,l-(l-o)*e]}function d(r,e){var a,n,_=t.__read(e,2),l=_[0],o=_[1],d=new Map;try{for(var i=t.__values(r),v=i.next();!v.done;v=i.next()){var c=t.__read(v.value,2),u=c[0],s=c[1],f=t.__read(s.r_invert(l,o),2),x=f[0],y=f[1];d.set(u,{start:x,end:y})}}catch(r){a={error:r}}finally{try{v&&!v.done&&(n=i.return)&&n.call(i)}finally{if(a)throw a.error}}return d}a.scale_highlow=o,a.get_info=d,a.scale_range=function(r,e,a,n,_){void 0===a&&(a=!0),void 0===n&&(n=!0),e=l.clamp(e,-.9,.9);var i=a?e:0,v=t.__read(o(r.bbox.h_range,i,null!=_?_.x:void 0),2),c=v[0],u=v[1],s=d(r.x_scales,[c,u]),f=n?e:0,x=t.__read(o(r.bbox.v_range,f,null!=_?_.y:void 0),2),y=x[0],g=x[1];return{xrs:s,yrs:d(r.y_scales,[y,g]),factor:e}}},
function _(o,t,i,n,e){n();var s=o(1),u=o(470),_=o(308),r=function(o){function t(t){var i=o.call(this,t)||this;return i.sign=-1,i.tool_name="Zoom Out",i.icon=_.bk_tool_icon_zoom_out,i}return s.__extends(t,o),t.init_ZoomOutTool=function(){this.prototype.default_view=u.ZoomBaseToolView,this.register_alias("zoom_out",(function(){return new t({dimensions:"both"})})),this.register_alias("xzoom_out",(function(){return new t({dimensions:"width"})})),this.register_alias("yzoom_out",(function(){return new t({dimensions:"height"})}))},t}(u.ZoomBaseTool);i.ZoomOutTool=r,r.__name__="ZoomOutTool",r.init_ZoomOutTool()},
function _(e,t,r,n,o){n();var a=e(1),i=e(124),l=e(123),_=e(126),s=e(210),c=e(292),u=function(e){function t(){var t=e.apply(this,a.__spread(arguments))||this;return t._mouse_in_frame=!0,t}return a.__extends(t,e),t.prototype._select_mode=function(e){var t=e.shiftKey,r=e.ctrlKey;return t||r?t&&!r?"append":!t&&r?"intersect":t&&r?"subtract":void _.unreachable():"replace"},t.prototype._move_enter=function(e){this._mouse_in_frame=!0},t.prototype._move_exit=function(e){this._mouse_in_frame=!1},t.prototype._map_drag=function(e,t,r){if(!this.plot_view.frame.bbox.contains(e,t))return null;var n=this.plot_view.renderer_view(r);return null==n?null:[n.coordinates.x_scale.invert(e),n.coordinates.y_scale.invert(t)]},t.prototype._delete_selected=function(e){var t,r,n=e.data_source,o=n.selected.indices;o.sort();try{for(var i=a.__values(n.columns()),l=i.next();!l.done;l=i.next())for(var _=l.value,s=n.get_array(_),c=0;c<o.length;c++){var u=o[c];s.splice(u-c,1)}}catch(e){t={error:e}}finally{try{l&&!l.done&&(r=i.return)&&r.call(i)}finally{if(t)throw t.error}}this._emit_cds_changes(n)},t.prototype._pop_glyphs=function(e,t){var r,n,o=e.columns();if(t&&o.length)try{for(var i=a.__values(o),_=i.next();!_.done;_=i.next()){var s=_.value,c=e.get_array(s),u=c.length-t+1;u<1||(l.isArray(c)||(c=Array.from(c),e.data[s]=c),c.splice(0,u))}}catch(e){r={error:e}}finally{try{_&&!_.done&&(n=i.return)&&n.call(i)}finally{if(r)throw r.error}}},t.prototype._emit_cds_changes=function(e,t,r,n){void 0===t&&(t=!0),void 0===r&&(r=!0),void 0===n&&(n=!0),r&&e.selection_manager.clear(),t&&e.change.emit(),n&&(e.data=e.data,e.properties.data.change.emit())},t.prototype._drag_points=function(e,t,r){var n,o,i,l;if(void 0===r&&(r="both"),null!=this._basepoint){var _=a.__read(this._basepoint,2),s=_[0],c=_[1];try{for(var u=a.__values(t),d=u.next();!d.done;d=u.next()){var p=d.value,f=this._map_drag(s,c,p),v=this._map_drag(e.sx,e.sy,p);if(null!=v&&null!=f){var y=a.__read(v,2),h=y[0],m=y[1],g=a.__read(f,2),x=g[0],b=g[1],w=a.__read([h-x,m-b],2),T=w[0],E=w[1],A=p.glyph,G=p.data_source,V=a.__read([A.x.field,A.y.field],2),j=V[0],K=V[1];try{for(var O=(i=void 0,a.__values(G.selected.indices)),P=O.next();!P.done;P=O.next()){var R=P.value;!j||"width"!=r&&"both"!=r||(G.data[j][R]+=T),!K||"height"!=r&&"both"!=r||(G.data[K][R]+=E)}}catch(e){i={error:e}}finally{try{P&&!P.done&&(l=O.return)&&l.call(O)}finally{if(i)throw i.error}}G.change.emit()}}}catch(e){n={error:e}}finally{try{d&&!d.done&&(o=u.return)&&o.call(u)}finally{if(n)throw n.error}}this._basepoint=[e.sx,e.sy]}},t.prototype._pad_empty_columns=function(e,t){var r,n;try{for(var o=a.__values(e.columns()),l=o.next();!l.done;l=o.next()){var _=l.value;i.includes(t,_)||e.get_array(_).push(this.model.empty_value)}}catch(e){r={error:e}}finally{try{l&&!l.done&&(n=o.return)&&n.call(o)}finally{if(r)throw r.error}}},t.prototype._select_event=function(e,t,r){var n,o,i=this.plot_view.frame,l=e.sx,_=e.sy;if(!i.bbox.contains(l,_))return[];var s={type:"point",sx:l,sy:_},c=[];try{for(var u=a.__values(r),d=u.next();!d.done;d=u.next()){var p=d.value,f=p.get_selection_manager(),v=p.data_source,y=this.plot_view.renderer_view(p);if(null!=y)f.select([y],s,!0,t)&&c.push(p),v.properties.selected.change.emit()}}catch(e){n={error:e}}finally{try{d&&!d.done&&(o=u.return)&&o.call(u)}finally{if(n)throw n.error}}return c},t}(c.GestureToolView);r.EditToolView=u,u.__name__="EditToolView";var d=function(e){function t(t){return e.call(this,t)||this}return a.__extends(t,e),t.init_EditTool=function(){this.define((function(e){var t=e.Unknown,r=e.String;return{custom_icon:[r],custom_tooltip:[r],empty_value:[t],renderers:[(0,e.Array)((0,e.Ref)(s.GlyphRenderer)),[]]}}))},Object.defineProperty(t.prototype,"tooltip",{get:function(){var e;return null!==(e=this.custom_tooltip)&&void 0!==e?e:this.tool_name},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"computed_icon",{get:function(){var e;return null!==(e=this.custom_icon)&&void 0!==e?e:this.icon},enumerable:!1,configurable:!0}),t}(c.GestureTool);r.EditTool=d,d.__name__="EditTool",d.init_EditTool()},
function _(e,t,i,o,_){o();var n=e(1),r=e(187),s=e(135),a=e(473),d=e(308),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype._tap=function(e){null==this._draw_basepoint&&null==this._basepoint&&this._select_event(e,this._select_mode(e),this.model.renderers)},t.prototype._keyup=function(e){var t,i;if(this.model.active&&this._mouse_in_frame)try{for(var o=n.__values(this.model.renderers),_=o.next();!_.done;_=o.next()){var s=_.value;if(e.keyCode===r.Keys.Backspace)this._delete_selected(s);else if(e.keyCode==r.Keys.Esc){s.data_source.selection_manager.clear()}}}catch(e){t={error:e}}finally{try{_&&!_.done&&(i=o.return)&&i.call(o)}finally{if(t)throw t.error}}},t.prototype._set_extent=function(e,t,i,o){var _=n.__read(e,2),r=_[0],s=_[1],a=n.__read(t,2),d=a[0],l=a[1];void 0===o&&(o=!1);var h=this.model.renderers[0],p=this.plot_view.renderer_view(h);if(null!=p){var u=h.glyph,c=h.data_source,f=n.__read(p.coordinates.x_scale.r_invert(r,s),2),y=f[0],v=f[1],m=n.__read(p.coordinates.y_scale.r_invert(d,l),2),x=m[0],b=m[1],w=n.__read([(y+v)/2,(x+b)/2],2),g=w[0],E=w[1],T=n.__read([v-y,b-x],2),B=T[0],k=T[1],K=n.__read([u.x.field,u.y.field],2),V=K[0],j=K[1],C=n.__read([u.width.field,u.height.field],2),D=C[0],I=C[1];if(i)this._pop_glyphs(c,this.model.num_objects),V&&c.get_array(V).push(g),j&&c.get_array(j).push(E),D&&c.get_array(D).push(B),I&&c.get_array(I).push(k),this._pad_empty_columns(c,[V,j,D,I]);else{var q=c.data[V].length-1;V&&(c.data[V][q]=g),j&&(c.data[j][q]=E),D&&(c.data[D][q]=B),I&&(c.data[I][q]=k)}this._emit_cds_changes(c,!0,!1,o)}},t.prototype._update_box=function(e,t,i){if(void 0===t&&(t=!1),void 0===i&&(i=!1),null!=this._draw_basepoint){var o=[e.sx,e.sy],_=this.plot_view.frame,r=this.model.dimensions,s=this.model._get_dim_limits(this._draw_basepoint,o,_,r);if(null!=s){var a=n.__read(s,2),d=a[0],l=a[1];this._set_extent(d,l,t,i)}}},t.prototype._doubletap=function(e){this.model.active&&(null!=this._draw_basepoint?(this._update_box(e,!1,!0),this._draw_basepoint=null):(this._draw_basepoint=[e.sx,e.sy],this._select_event(e,"append",this.model.renderers),this._update_box(e,!0,!1)))},t.prototype._move=function(e){this._update_box(e,!1,!1)},t.prototype._pan_start=function(e){if(e.shiftKey){if(null!=this._draw_basepoint)return;this._draw_basepoint=[e.sx,e.sy],this._update_box(e,!0,!1)}else{if(null!=this._basepoint)return;this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy]}},t.prototype._pan=function(e,t,i){if(void 0===t&&(t=!1),void 0===i&&(i=!1),e.shiftKey){if(null==this._draw_basepoint)return;this._update_box(e,t,i)}else{if(null==this._basepoint)return;this._drag_points(e,this.model.renderers)}},t.prototype._pan_end=function(e){var t,i;if(this._pan(e,!1,!0),e.shiftKey)this._draw_basepoint=null;else{this._basepoint=null;try{for(var o=n.__values(this.model.renderers),_=o.next();!_.done;_=o.next()){var r=_.value;this._emit_cds_changes(r.data_source,!1,!0,!0)}}catch(e){t={error:e}}finally{try{_&&!_.done&&(i=o.return)&&i.call(o)}finally{if(t)throw t.error}}}},t}(a.EditToolView);i.BoxEditToolView=l,l.__name__="BoxEditToolView";var h=function(e){function t(t){var i=e.call(this,t)||this;return i.tool_name="Box Edit Tool",i.icon=d.bk_tool_icon_box_edit,i.event_type=["tap","pan","move"],i.default_order=1,i}return n.__extends(t,e),t.init_BoxEditTool=function(){this.prototype.default_view=l,this.define((function(e){var t=e.Int;return{dimensions:[s.Dimensions,"both"],num_objects:[t,0]}}))},t}(a.EditTool);i.BoxEditTool=h,h.__name__="BoxEditTool",h.init_BoxEditTool()},
function _(e,t,r,a,n){a();var o=e(1),i=e(187),_=e(123),d=e(473),s=e(308),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._draw=function(e,t,r){if(void 0===r&&(r=!1),this.model.active){var a=this.model.renderers[0],n=this._map_drag(e.sx,e.sy,a);if(null!=n){var i=o.__read(n,2),d=i[0],s=i[1],l=a.data_source,h=a.glyph,c=o.__read([h.xs.field,h.ys.field],2),p=c[0],u=c[1];if("new"==t)this._pop_glyphs(l,this.model.num_objects),p&&l.get_array(p).push([d]),u&&l.get_array(u).push([s]),this._pad_empty_columns(l,[p,u]);else if("add"==t){if(p){var f=l.data[p].length-1,y=l.get_array(p)[f];_.isArray(y)||(y=Array.from(y),l.data[p][f]=y),y.push(d)}if(u){var m=l.data[u].length-1,w=l.get_array(u)[m];_.isArray(w)||(w=Array.from(w),l.data[u][m]=w),w.push(s)}}this._emit_cds_changes(l,!0,!0,r)}}},t.prototype._pan_start=function(e){this._draw(e,"new")},t.prototype._pan=function(e){this._draw(e,"add")},t.prototype._pan_end=function(e){this._draw(e,"add",!0)},t.prototype._tap=function(e){this._select_event(e,this._select_mode(e),this.model.renderers)},t.prototype._keyup=function(e){var t,r;if(this.model.active&&this._mouse_in_frame)try{for(var a=o.__values(this.model.renderers),n=a.next();!n.done;n=a.next()){var _=n.value;e.keyCode===i.Keys.Esc?_.data_source.selection_manager.clear():e.keyCode===i.Keys.Backspace&&this._delete_selected(_)}}catch(e){t={error:e}}finally{try{n&&!n.done&&(r=a.return)&&r.call(a)}finally{if(t)throw t.error}}},t}(d.EditToolView);r.FreehandDrawToolView=l,l.__name__="FreehandDrawToolView";var h=function(e){function t(t){var r=e.call(this,t)||this;return r.tool_name="Freehand Draw Tool",r.icon=s.bk_tool_icon_freehand_draw,r.event_type=["pan","tap"],r.default_order=3,r}return o.__extends(t,e),t.init_FreehandDrawTool=function(){this.prototype.default_view=l,this.define((function(e){return{num_objects:[e.Int,0]}}))},t}(d.EditTool);r.FreehandDrawTool=h,h.__name__="FreehandDrawTool",h.init_FreehandDrawTool()},
function _(e,t,o,r,n){r();var a=e(1),i=e(187),s=e(473),_=e(308),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(t,e),t.prototype._tap=function(e){if(!this._select_event(e,this._select_mode(e),this.model.renderers).length&&this.model.add){var t=this.model.renderers[0],o=this._map_drag(e.sx,e.sy,t);if(null!=o){var r=t.glyph,n=t.data_source,i=a.__read([r.x.field,r.y.field],2),s=i[0],_=i[1],l=a.__read(o,2),d=l[0],h=l[1];this._pop_glyphs(n,this.model.num_objects),s&&n.get_array(s).push(d),_&&n.get_array(_).push(h),this._pad_empty_columns(n,[s,_]),n.change.emit(),n.data=n.data,n.properties.data.change.emit()}}},t.prototype._keyup=function(e){var t,o;if(this.model.active&&this._mouse_in_frame)try{for(var r=a.__values(this.model.renderers),n=r.next();!n.done;n=r.next()){var s=n.value;e.keyCode===i.Keys.Backspace?this._delete_selected(s):e.keyCode==i.Keys.Esc&&s.data_source.selection_manager.clear()}}catch(e){t={error:e}}finally{try{n&&!n.done&&(o=r.return)&&o.call(r)}finally{if(t)throw t.error}}},t.prototype._pan_start=function(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])},t.prototype._pan=function(e){this.model.drag&&null!=this._basepoint&&this._drag_points(e,this.model.renderers)},t.prototype._pan_end=function(e){var t,o;if(this.model.drag){this._pan(e);try{for(var r=a.__values(this.model.renderers),n=r.next();!n.done;n=r.next()){var i=n.value;this._emit_cds_changes(i.data_source,!1,!0,!0)}}catch(e){t={error:e}}finally{try{n&&!n.done&&(o=r.return)&&o.call(r)}finally{if(t)throw t.error}}this._basepoint=null}},t}(s.EditToolView);o.PointDrawToolView=l,l.__name__="PointDrawToolView";var d=function(e){function t(t){var o=e.call(this,t)||this;return o.tool_name="Point Draw Tool",o.icon=_.bk_tool_icon_point_draw,o.event_type=["tap","pan","move"],o.default_order=2,o}return a.__extends(t,e),t.init_PointDrawTool=function(){this.prototype.default_view=l,this.define((function(e){var t=e.Boolean;return{add:[t,!0],drag:[t,!0],num_objects:[e.Int,0]}}))},t}(s.EditTool);o.PointDrawTool=d,d.__name__="PointDrawTool",d.init_PointDrawTool()},
function _(e,t,r,a,i){a();var n=e(1),o=e(187),s=e(123),l=e(478),_=e(308),d=function(e){function t(){var t=e.apply(this,n.__spread(arguments))||this;return t._drawing=!1,t._initialized=!1,t}return n.__extends(t,e),t.prototype._tap=function(e){this._drawing?this._draw(e,"add",!0):this._select_event(e,this._select_mode(e),this.model.renderers)},t.prototype._draw=function(e,t,r){void 0===r&&(r=!1);var a=this.model.renderers[0],i=this._map_drag(e.sx,e.sy,a);if(this._initialized||this.activate(),null!=i){var o=n.__read(this._snap_to_vertex.apply(this,n.__spread([e],i)),2),l=o[0],_=o[1],d=a.data_source,h=a.glyph,c=n.__read([h.xs.field,h.ys.field],2),y=c[0],f=c[1];if("new"==t)this._pop_glyphs(d,this.model.num_objects),y&&d.get_array(y).push([l,l]),f&&d.get_array(f).push([_,_]),this._pad_empty_columns(d,[y,f]);else if("edit"==t){if(y)(p=d.data[y][d.data[y].length-1])[p.length-1]=l;if(f)(g=d.data[f][d.data[f].length-1])[g.length-1]=_}else if("add"==t){if(y){var p,v=d.data[y].length-1,u=(p=d.get_array(y)[v])[p.length-1];p[p.length-1]=l,s.isArray(p)||(p=Array.from(p),d.data[y][v]=p),p.push(u)}if(f){var g,m=d.data[f].length-1,w=(g=d.get_array(f)[m])[g.length-1];g[g.length-1]=_,s.isArray(g)||(g=Array.from(g),d.data[f][m]=g),g.push(w)}}this._emit_cds_changes(d,!0,!1,r)}},t.prototype._show_vertices=function(){var e,t,r,a;if(this.model.active){for(var i=[],o=[],s=0;s<this.model.renderers.length;s++){var l=this.model.renderers[s],_=l.data_source,d=l.glyph,h=n.__read([d.xs.field,d.ys.field],2),c=h[0],y=h[1];if(c)try{for(var f=(e=void 0,n.__values(_.get_array(c))),p=f.next();!p.done;p=f.next()){var v=p.value;i.push.apply(i,n.__spread(v))}}catch(t){e={error:t}}finally{try{p&&!p.done&&(t=f.return)&&t.call(f)}finally{if(e)throw e.error}}if(y)try{for(var u=(r=void 0,n.__values(_.get_array(y))),g=u.next();!g.done;g=u.next()){v=g.value;o.push.apply(o,n.__spread(v))}}catch(e){r={error:e}}finally{try{g&&!g.done&&(a=u.return)&&a.call(u)}finally{if(r)throw r.error}}this._drawing&&s==this.model.renderers.length-1&&(i.splice(i.length-1,1),o.splice(o.length-1,1))}this._set_vertices(i,o)}},t.prototype._doubletap=function(e){this.model.active&&(this._drawing?(this._drawing=!1,this._draw(e,"edit",!0)):(this._drawing=!0,this._draw(e,"new",!0)))},t.prototype._move=function(e){this._drawing&&this._draw(e,"edit")},t.prototype._remove=function(){var e=this.model.renderers[0],t=e.data_source,r=e.glyph,a=n.__read([r.xs.field,r.ys.field],2),i=a[0],o=a[1];if(i){var s=t.data[i].length-1,l=t.get_array(i)[s];l.splice(l.length-1,1)}if(o){var _=t.data[o].length-1,d=t.get_array(o)[_];d.splice(d.length-1,1)}this._emit_cds_changes(t)},t.prototype._keyup=function(e){var t,r;if(this.model.active&&this._mouse_in_frame)try{for(var a=n.__values(this.model.renderers),i=a.next();!i.done;i=a.next()){var s=i.value;e.keyCode===o.Keys.Backspace?this._delete_selected(s):e.keyCode==o.Keys.Esc&&(this._drawing&&(this._remove(),this._drawing=!1),s.data_source.selection_manager.clear())}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=a.return)&&r.call(a)}finally{if(t)throw t.error}}},t.prototype._pan_start=function(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])},t.prototype._pan=function(e){var t,r,a,i;if(null!=this._basepoint&&this.model.drag){var o=n.__read(this._basepoint,2),s=o[0],l=o[1];try{for(var _=n.__values(this.model.renderers),d=_.next();!d.done;d=_.next()){var h=d.value,c=this._map_drag(s,l,h),y=this._map_drag(e.sx,e.sy,h);if(null!=y&&null!=c){var f=h.data_source,p=h.glyph,v=n.__read([p.xs.field,p.ys.field],2),u=v[0],g=v[1];if(u||g){var m=n.__read(y,2),w=m[0],x=m[1],b=n.__read(c,2),P=b[0],T=b[1],D=n.__read([w-P,x-T],2),k=D[0],z=D[1];try{for(var A=(a=void 0,n.__values(f.selected.indices)),V=A.next();!V.done;V=A.next()){var j=V.value,B=void 0,C=void 0,K=void 0;u&&(C=f.data[u][j]),B=g?(K=f.data[g][j]).length:C.length;for(var E=0;E<B;E++)C&&(C[E]+=k),K&&(K[E]+=z)}}catch(e){a={error:e}}finally{try{V&&!V.done&&(i=A.return)&&i.call(A)}finally{if(a)throw a.error}}f.change.emit()}}}}catch(e){t={error:e}}finally{try{d&&!d.done&&(r=_.return)&&r.call(_)}finally{if(t)throw t.error}}this._basepoint=[e.sx,e.sy]}},t.prototype._pan_end=function(e){var t,r;if(this.model.drag){this._pan(e);try{for(var a=n.__values(this.model.renderers),i=a.next();!i.done;i=a.next()){var o=i.value;this._emit_cds_changes(o.data_source)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=a.return)&&r.call(a)}finally{if(t)throw t.error}}this._basepoint=null}},t.prototype.activate=function(){var e,t,r=this;if(this.model.vertex_renderer&&this.model.active){if(this._show_vertices(),!this._initialized)try{for(var a=n.__values(this.model.renderers),i=a.next();!i.done;i=a.next()){var o=i.value.data_source;o.connect(o.properties.data.change,(function(){return r._show_vertices()}))}}catch(t){e={error:t}}finally{try{i&&!i.done&&(t=a.return)&&t.call(a)}finally{if(e)throw e.error}}this._initialized=!0}},t.prototype.deactivate=function(){this._drawing&&(this._remove(),this._drawing=!1),this.model.vertex_renderer&&this._hide_vertices()},t}(l.PolyToolView);r.PolyDrawToolView=d,d.__name__="PolyDrawToolView";var h=function(e){function t(t){var r=e.call(this,t)||this;return r.tool_name="Polygon Draw Tool",r.icon=_.bk_tool_icon_poly_draw,r.event_type=["pan","tap","move"],r.default_order=3,r}return n.__extends(t,e),t.init_PolyDrawTool=function(){this.prototype.default_view=d,this.define((function(e){return{drag:[e.Boolean,!0],num_objects:[e.Int,0]}}))},t}(l.PolyTool);r.PolyDrawTool=h,h.__name__="PolyDrawTool",h.init_PolyDrawTool()},
function _(e,t,r,i,n){i();var o=e(1),_=e(123),l=e(473),d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._set_vertices=function(e,t){var r=this.model.vertex_renderer.glyph,i=this.model.vertex_renderer.data_source,n=o.__read([r.x.field,r.y.field],2),l=n[0],d=n[1];l&&(_.isArray(e)?i.data[l]=e:r.x={value:e}),d&&(_.isArray(t)?i.data[d]=t:r.y={value:t}),this._emit_cds_changes(i,!0,!0,!1)},t.prototype._hide_vertices=function(){this._set_vertices([],[])},t.prototype._snap_to_vertex=function(e,t,r){if(this.model.vertex_renderer){var i=this._select_event(e,"replace",[this.model.vertex_renderer]),n=this.model.vertex_renderer.data_source,_=this.model.vertex_renderer.glyph,l=o.__read([_.x.field,_.y.field],2),d=l[0],a=l[1];if(i.length){var s=n.selected.indices[0];d&&(t=n.data[d][s]),a&&(r=n.data[a][s]),n.selection_manager.clear()}}return[t,r]},t}(l.EditToolView);r.PolyToolView=d,d.__name__="PolyToolView";var a=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_PolyTool=function(){this.define((function(e){return{vertex_renderer:[(0,e.AnyRef)()]}}))},t}(l.EditTool);r.PolyTool=a,a.__name__="PolyTool",a.init_PolyTool()},
function _(e,t,r,i,_){i();var s=e(1),d=e(187),a=e(123),n=e(478),l=e(308),o=function(e){function t(){var t=e.apply(this,s.__spread(arguments))||this;return t._drawing=!1,t}return s.__extends(t,e),t.prototype._doubletap=function(e){if(this.model.active){var t=this._map_drag(e.sx,e.sy,this.model.vertex_renderer);if(null!=t){var r=s.__read(t,2),i=r[0],_=r[1],d=this._select_event(e,"replace",[this.model.vertex_renderer]),a=this.model.vertex_renderer.data_source,n=this.model.vertex_renderer.glyph,l=s.__read([n.x.field,n.y.field],2),o=l[0],c=l[1];if(d.length&&null!=this._selected_renderer){var h=a.selected.indices[0];this._drawing?(this._drawing=!1,a.selection_manager.clear()):(a.selected.indices=[h+1],o&&a.get_array(o).splice(h+1,0,i),c&&a.get_array(c).splice(h+1,0,_),this._drawing=!0),a.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}else this._show_vertices(e)}}},t.prototype._show_vertices=function(e){if(this.model.active){var t=this._select_event(e,"replace",this.model.renderers);if(!t.length)return this._set_vertices([],[]),this._selected_renderer=null,void(this._drawing=!1);var r,i,_=t[0],d=_.glyph,n=_.data_source,l=n.selected.indices[0],o=s.__read([d.xs.field,d.ys.field],2),c=o[0],h=o[1];c?(r=n.data[c][l],a.isArray(r)||(n.data[c][l]=r=Array.from(r))):r=d.xs.value,h?(i=n.data[h][l],a.isArray(i)||(n.data[h][l]=i=Array.from(i))):i=d.ys.value,this._selected_renderer=_,this._set_vertices(r,i)}},t.prototype._move=function(e){var t;if(this._drawing&&null!=this._selected_renderer){var r=this.model.vertex_renderer,i=r.data_source,_=r.glyph,d=this._map_drag(e.sx,e.sy,r);if(null==d)return;var a=s.__read(d,2),n=a[0],l=a[1],o=i.selected.indices;n=(t=s.__read(this._snap_to_vertex(e,n,l),2))[0],l=t[1],i.selected.indices=o;var c=s.__read([_.x.field,_.y.field],2),h=c[0],v=c[1],p=o[0];h&&(i.data[h][p]=n),v&&(i.data[v][p]=l),i.change.emit(),this._selected_renderer.data_source.change.emit()}},t.prototype._tap=function(e){var t,r=this.model.vertex_renderer,i=this._map_drag(e.sx,e.sy,r);if(null!=i){if(this._drawing&&this._selected_renderer){var _=s.__read(i,2),d=_[0],a=_[1],n=r.data_source,l=r.glyph,o=s.__read([l.x.field,l.y.field],2),c=o[0],h=o[1],v=n.selected.indices;d=(t=s.__read(this._snap_to_vertex(e,d,a),2))[0],a=t[1];var p=v[0];if(n.selected.indices=[p+1],c){var y=n.get_array(c),u=y[p];y[p]=d,y.splice(p+1,0,u)}if(h){var f=n.get_array(h),m=f[p];f[p]=a,f.splice(p+1,0,m)}return n.change.emit(),void this._emit_cds_changes(this._selected_renderer.data_source,!0,!1,!0)}var g=this._select_mode(e);this._select_event(e,g,[r]),this._select_event(e,g,this.model.renderers)}},t.prototype._remove_vertex=function(){if(this._drawing&&this._selected_renderer){var e=this.model.vertex_renderer,t=e.data_source,r=e.glyph,i=t.selected.indices[0],_=s.__read([r.x.field,r.y.field],2),d=_[0],a=_[1];d&&t.get_array(d).splice(i,1),a&&t.get_array(a).splice(i,1),t.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}},t.prototype._pan_start=function(e){this._select_event(e,"append",[this.model.vertex_renderer]),this._basepoint=[e.sx,e.sy]},t.prototype._pan=function(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._selected_renderer&&this._selected_renderer.data_source.change.emit())},t.prototype._pan_end=function(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._emit_cds_changes(this.model.vertex_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)},t.prototype._keyup=function(e){var t,r;if(this.model.active&&this._mouse_in_frame){var i;i=this._selected_renderer?[this.model.vertex_renderer]:this.model.renderers;try{for(var _=s.__values(i),a=_.next();!a.done;a=_.next()){var n=a.value;e.keyCode===d.Keys.Backspace?(this._delete_selected(n),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source)):e.keyCode==d.Keys.Esc&&(this._drawing?(this._remove_vertex(),this._drawing=!1):this._selected_renderer&&this._hide_vertices(),n.data_source.selection_manager.clear())}}catch(e){t={error:e}}finally{try{a&&!a.done&&(r=_.return)&&r.call(_)}finally{if(t)throw t.error}}}},t.prototype.deactivate=function(){this._selected_renderer&&(this._drawing&&(this._remove_vertex(),this._drawing=!1),this._hide_vertices())},t}(n.PolyToolView);r.PolyEditToolView=o,o.__name__="PolyEditToolView";var c=function(e){function t(t){var r=e.call(this,t)||this;return r.tool_name="Poly Edit Tool",r.icon=l.bk_tool_icon_poly_edit,r.event_type=["tap","pan","move"],r.default_order=4,r}return s.__extends(t,e),t.init_PolyEditTool=function(){this.prototype.default_view=o},t}(n.PolyTool);r.PolyEditTool=c,c.__name__="PolyEditTool",c.init_PolyEditTool()},
function _(e,t,o,i,n){i();var l=e(1),s=e(481),_=e(243),r=e(135),c=e(308),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return l.__extends(t,e),t.prototype._compute_limits=function(e){var t=this.plot_view.frame,o=this.model.dimensions,i=this._base_point;if("center"==this.model.origin){var n=l.__read(i,2),s=n[0],_=n[1],r=l.__read(e,2);i=[s-(r[0]-s),_-(r[1]-_)]}return this.model._get_dim_limits(i,e,t,o)},t.prototype._pan_start=function(e){var t=e.sx,o=e.sy;this._base_point=[t,o]},t.prototype._pan=function(e){var t=[e.sx,e.sy],o=l.__read(this._compute_limits(t),2),i=o[0],n=o[1];this.model.overlay.update({left:i[0],right:i[1],top:n[0],bottom:n[1]}),this.model.select_every_mousemove&&this._do_select(i,n,!1,this._select_mode(e))},t.prototype._pan_end=function(e){var t=[e.sx,e.sy],o=l.__read(this._compute_limits(t),2),i=o[0],n=o[1];this._do_select(i,n,!0,this._select_mode(e)),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null,this.plot_view.push_state("box_select",{selection:this.plot_view.get_selection()})},t.prototype._do_select=function(e,t,o,i){var n=l.__read(e,2),s=n[0],_=n[1],r=l.__read(t,2);void 0===i&&(i="replace");var c={type:"rect",sx0:s,sx1:_,sy0:r[0],sy1:r[1]};this._select(c,o,i)},t}(s.SelectToolView);o.BoxSelectToolView=a,a.__name__="BoxSelectToolView";var u=function(){return new _.BoxAnnotation({level:"overlay",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]})},h=function(e){function t(t){var o=e.call(this,t)||this;return o.tool_name="Box Select",o.icon=c.bk_tool_icon_box_select,o.event_type="pan",o.default_order=30,o}return l.__extends(t,e),t.init_BoxSelectTool=function(){this.prototype.default_view=a,this.define((function(e){var t=e.Boolean,o=e.Ref;return{dimensions:[r.Dimensions,"both"],select_every_mousemove:[t,!1],overlay:[o(_.BoxAnnotation),u],origin:[r.BoxOrigin,"corner"]}})),this.register_alias("box_select",(function(){return new t})),this.register_alias("xbox_select",(function(){return new t({dimensions:"width"})})),this.register_alias("ybox_select",(function(){return new t({dimensions:"height"})}))},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!1,configurable:!0}),t}(s.SelectTool);o.BoxSelectTool=h,h.__name__="BoxSelectTool",h.init_BoxSelectTool()},
function _(e,t,r,n,o){n();var i=e(1),c=e(292),a=e(210),l=e(231),s=e(211),u=e(482),_=e(135),d=e(187),p=e(429),v=e(130),f=e(126),h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.model.clear.connect((function(){return t._clear()}))},Object.defineProperty(t.prototype,"computed_renderers",{get:function(){var e=this.model.renderers,t=this.plot_model.data_renderers,r=this.model.names;return u.compute_renderers(e,t,r)},enumerable:!1,configurable:!0}),t.prototype._computed_renderers_by_data_source=function(){var e,t,r,n=new Map;try{for(var o=i.__values(this.computed_renderers),c=o.next();!c.done;c=o.next()){var s=c.value,u=void 0;if(s instanceof a.GlyphRenderer)u=s.data_source;else{if(!(s instanceof l.GraphRenderer))continue;u=s.node_renderer.data_source}var _=null!==(r=n.get(u))&&void 0!==r?r:[];n.set(u,i.__spread(_,[s]))}}catch(t){e={error:t}}finally{try{c&&!c.done&&(t=o.return)&&t.call(o)}finally{if(e)throw e.error}}return n},t.prototype._select_mode=function(e){var t=e.shiftKey,r=e.ctrlKey;return t||r?t&&!r?"append":!t&&r?"intersect":t&&r?"subtract":void f.unreachable():this.model.mode},t.prototype._keyup=function(e){e.keyCode==d.Keys.Esc&&this._clear()},t.prototype._clear=function(){var e,t;try{for(var r=i.__values(this.computed_renderers),n=r.next();!n.done;n=r.next()){n.value.get_selection_manager().clear()}}catch(t){e={error:t}}finally{try{n&&!n.done&&(t=r.return)&&t.call(r)}finally{if(e)throw e.error}}this.plot_view.request_render()},t.prototype._select=function(e,t,r){var n,o,c,a,l=this._computed_renderers_by_data_source();try{for(var s=i.__values(l),u=s.next();!u.done;u=s.next()){var _=i.__read(u.value,2)[1],d=_[0].get_selection_manager(),p=[];try{for(var v=(c=void 0,i.__values(_)),f=v.next();!f.done;f=v.next()){var h=f.value,y=this.plot_view.renderer_view(h);null!=y&&p.push(y)}}catch(e){c={error:e}}finally{try{f&&!f.done&&(a=v.return)&&a.call(v)}finally{if(c)throw c.error}}d.select(p,e,t,r)}}catch(e){n={error:e}}finally{try{u&&!u.done&&(o=s.return)&&o.call(s)}finally{if(n)throw n.error}}null!=this.model.callback&&this._emit_callback(e),this._emit_selection_event(e,t)},t.prototype._emit_selection_event=function(e,t){void 0===t&&(t=!0);var r,n=this.plot_view.frame,o=n.x_scale,c=n.y_scale;switch(e.type){case"point":var a=e.sx,l=e.sy,s=o.invert(a),u=c.invert(l);r=Object.assign(Object.assign({},e),{x:s,y:u});break;case"span":a=e.sx,l=e.sy,s=o.invert(a),u=c.invert(l);r=Object.assign(Object.assign({},e),{x:s,y:u});break;case"rect":var _=e.sx0,d=e.sx1,v=e.sy0,f=e.sy1,h=i.__read(o.r_invert(_,d),2),y=h[0],m=h[1],b=i.__read(c.r_invert(v,f),2),g=b[0],x=b[1];r=Object.assign(Object.assign({},e),{x0:y,y0:g,x1:m,y1:x});break;case"poly":a=e.sx,l=e.sy,s=o.v_invert(a),u=c.v_invert(l);r=Object.assign(Object.assign({},e),{x:s,y:u})}this.plot_model.trigger_event(new p.SelectionGeometry(r,t))},t}(c.GestureToolView);r.SelectToolView=h,h.__name__="SelectToolView";var y=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.clear=new v.Signal0(this,"clear")},t.init_SelectTool=function(){this.define((function(e){var t=e.String,r=e.Array,n=e.Ref,o=e.Or,i=e.Auto,c=e.Null;return{renderers:[o(r(n(s.DataRenderer)),i,c),"auto"],names:[r(t),[]],mode:[_.SelectionMode,"replace"]}}))},Object.defineProperty(t.prototype,"menu",{get:function(){var e=this;return[{icon:"bk-tool-icon-replace-mode",tooltip:"Replace the current selection",active:function(){return"replace"==e.mode},handler:function(){e.mode="replace",e.active=!0}},{icon:"bk-tool-icon-append-mode",tooltip:"Append to the current selection (Shift)",active:function(){return"append"==e.mode},handler:function(){e.mode="append",e.active=!0}},{icon:"bk-tool-icon-intersect-mode",tooltip:"Intersect with the current selection (Ctrl)",active:function(){return"intersect"==e.mode},handler:function(){e.mode="intersect",e.active=!0}},{icon:"bk-tool-icon-subtract-mode",tooltip:"Subtract from the current selection (Shift+Ctrl)",active:function(){return"subtract"==e.mode},handler:function(){e.mode="subtract",e.active=!0}},null,{icon:"bk-tool-icon-clear-selection",tooltip:"Clear the current selection (Esc)",handler:function(){e.clear.emit()}}]},enumerable:!1,configurable:!0}),t}(c.GestureTool);r.SelectTool=y,y.__name__="SelectTool",y.init_SelectTool()},
function _(n,r,e,t,u){t();var i=n(124);e.compute_renderers=function(n,r,e){if(null==n)return[];var t="auto"==n?r:n;return e.length>0&&(t=t.filter((function(n){return i.includes(e,n.name)}))),t}},
function _(t,e,o,n,r){n();var i=t(1),a=t(292),_=t(243),s=t(135),l=t(308),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._match_aspect=function(t,e,o){var n,r,a,_,s=o.bbox.aspect,l=o.bbox.h_range.end,u=o.bbox.h_range.start,h=o.bbox.v_range.end,p=o.bbox.v_range.start,c=Math.abs(t[0]-e[0]),d=Math.abs(t[1]-e[1]),m=0==d?0:c/d,f=i.__read(m>=s?[1,m/s]:[s/m,1],1)[0];return t[0]<=e[0]?(n=t[0],(r=t[0]+c*f)>l&&(r=l)):(r=t[0],(n=t[0]-c*f)<u&&(n=u)),c=Math.abs(r-n),t[1]<=e[1]?(_=t[1],(a=t[1]+c/s)>h&&(a=h)):(a=t[1],(_=t[1]-c/s)<p&&(_=p)),d=Math.abs(a-_),t[0]<=e[0]?r=t[0]+s*d:n=t[0]-s*d,[[n,r],[_,a]]},e.prototype._compute_limits=function(t){var e,o,n,r,a=this.plot_view.frame,_=this.model.dimensions,s=this._base_point;if("center"==this.model.origin){var l=i.__read(s,2),u=l[0],h=l[1],p=i.__read(t,2);s=[u-(p[0]-u),h-(p[1]-h)]}return this.model.match_aspect&&"both"==_?(n=(e=i.__read(this._match_aspect(s,t,a),2))[0],r=e[1]):(n=(o=i.__read(this.model._get_dim_limits(s,t,a,_),2))[0],r=o[1]),[n,r]},e.prototype._pan_start=function(t){this._base_point=[t.sx,t.sy]},e.prototype._pan=function(t){var e=[t.sx,t.sy],o=i.__read(this._compute_limits(e),2),n=o[0],r=o[1];this.model.overlay.update({left:n[0],right:n[1],top:r[0],bottom:r[1]})},e.prototype._pan_end=function(t){var e=[t.sx,t.sy],o=i.__read(this._compute_limits(e),2),n=o[0],r=o[1];this._update(n,r),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null},e.prototype._update=function(t,e){var o,n,r,a,_=i.__read(t,2),s=_[0],l=_[1],u=i.__read(e,2),h=u[0],p=u[1];if(!(Math.abs(l-s)<=5||Math.abs(p-h)<=5)){var c=this.plot_view.frame,d=c.x_scales,m=c.y_scales,f=new Map;try{for(var v=i.__values(d),b=v.next();!b.done;b=v.next()){var x=i.__read(b.value,2),y=x[0],g=x[1],w=i.__read(g.r_invert(s,l),2),B=w[0],M=w[1];f.set(y,{start:B,end:M})}}catch(t){o={error:t}}finally{try{b&&!b.done&&(n=v.return)&&n.call(v)}finally{if(o)throw o.error}}var T=new Map;try{for(var Z=i.__values(m),z=Z.next();!z.done;z=Z.next()){var V=i.__read(z.value,2),k=(y=V[0],g=V[1],i.__read(g.r_invert(h,p),2));B=k[0],M=k[1];T.set(y,{start:B,end:M})}}catch(t){r={error:t}}finally{try{z&&!z.done&&(a=Z.return)&&a.call(Z)}finally{if(r)throw r.error}}var A={xrs:f,yrs:T};this.plot_view.push_state("box_zoom",{range:A}),this.plot_view.update_range(A)}},e}(a.GestureToolView);o.BoxZoomToolView=u,u.__name__="BoxZoomToolView";var h=function(){return new _.BoxAnnotation({level:"overlay",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]})},p=function(t){function e(e){var o=t.call(this,e)||this;return o.tool_name="Box Zoom",o.icon=l.bk_tool_icon_box_zoom,o.event_type="pan",o.default_order=20,o}return i.__extends(e,t),e.init_BoxZoomTool=function(){this.prototype.default_view=u,this.define((function(t){var e=t.Boolean,o=t.Ref;return{dimensions:[s.Dimensions,"both"],overlay:[o(_.BoxAnnotation),h],match_aspect:[e,!1],origin:[s.BoxOrigin,"corner"]}})),this.register_alias("box_zoom",(function(){return new e({dimensions:"both"})})),this.register_alias("xbox_zoom",(function(){return new e({dimensions:"width"})})),this.register_alias("ybox_zoom",(function(){return new e({dimensions:"height"})}))},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!1,configurable:!0}),e}(a.GestureTool);o.BoxZoomTool=p,p.__name__="BoxZoomTool",p.init_BoxZoomTool()},
function _(t,e,o,s,i){s();var a=t(1),n=t(481),l=t(285),_=t(485),c=t(187),r=t(308),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.data=null},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,(function(){return e._active_change()}))},e.prototype._active_change=function(){this.model.active||this._clear_overlay()},e.prototype._keyup=function(t){t.keyCode==c.Keys.Enter&&this._clear_overlay()},e.prototype._pan_start=function(t){var e=t.sx,o=t.sy;this.data={sx:[e],sy:[o]}},e.prototype._pan=function(t){var e=t.sx,o=t.sy,s=a.__read(this.plot_view.frame.bbox.clip(e,o),2),i=s[0],n=s[1];this.data.sx.push(i),this.data.sy.push(n),this.model.overlay.update({xs:this.data.sx,ys:this.data.sy}),this.model.select_every_mousemove&&this._do_select(this.data.sx,this.data.sy,!1,this._select_mode(t))},e.prototype._pan_end=function(t){this._clear_overlay(),this._do_select(this.data.sx,this.data.sy,!0,this._select_mode(t)),this.plot_view.push_state("lasso_select",{selection:this.plot_view.get_selection()})},e.prototype._clear_overlay=function(){this.model.overlay.update({xs:[],ys:[]})},e.prototype._do_select=function(t,e,o,s){var i={type:"poly",sx:t,sy:e};this._select(i,o,s)},e}(n.SelectToolView);o.LassoSelectToolView=p,p.__name__="LassoSelectToolView";var h=function(t){function e(e){var o=t.call(this,e)||this;return o.tool_name="Lasso Select",o.icon=r.bk_tool_icon_lasso_select,o.event_type="pan",o.default_order=12,o}return a.__extends(e,t),e.init_LassoSelectTool=function(){this.prototype.default_view=p,this.define((function(t){return{select_every_mousemove:[t.Boolean,!0],overlay:[(0,t.Ref)(l.PolyAnnotation),_.DEFAULT_POLY_OVERLAY]}})),this.register_alias("lasso_select",(function(){return new e}))},e}(n.SelectTool);o.LassoSelectTool=h,h.__name__="LassoSelectTool",h.init_LassoSelectTool()},
function _(t,e,o,i,n){i();var l=t(1),s=t(481),a=t(285),_=t(187),c=t(124),r=t(308),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return l.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.data={sx:[],sy:[]}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,(function(){return e._active_change()}))},e.prototype._active_change=function(){this.model.active||this._clear_data()},e.prototype._keyup=function(t){t.keyCode==_.Keys.Enter&&this._clear_data()},e.prototype._doubletap=function(t){this._do_select(this.data.sx,this.data.sy,!0,this._select_mode(t)),this.plot_view.push_state("poly_select",{selection:this.plot_view.get_selection()}),this._clear_data()},e.prototype._clear_data=function(){this.data={sx:[],sy:[]},this.model.overlay.update({xs:[],ys:[]})},e.prototype._tap=function(t){var e=t.sx,o=t.sy;this.plot_view.frame.bbox.contains(e,o)&&(this.data.sx.push(e),this.data.sy.push(o),this.model.overlay.update({xs:c.copy(this.data.sx),ys:c.copy(this.data.sy)}))},e.prototype._do_select=function(t,e,o,i){var n={type:"poly",sx:t,sy:e};this._select(n,o,i)},e}(s.SelectToolView);o.PolySelectToolView=p,p.__name__="PolySelectToolView",o.DEFAULT_POLY_OVERLAY=function(){return new a.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]})};var y=function(t){function e(e){var o=t.call(this,e)||this;return o.tool_name="Poly Select",o.icon=r.bk_tool_icon_polygon_select,o.event_type="tap",o.default_order=11,o}return l.__extends(e,t),e.init_PolySelectTool=function(){this.prototype.default_view=p,this.define((function(t){return{overlay:[(0,t.Ref)(a.PolyAnnotation),o.DEFAULT_POLY_OVERLAY]}})),this.register_alias("poly_select",(function(){return new e}))},e}(s.SelectTool);o.PolySelectTool=y,y.__name__="PolySelectTool",y.init_PolySelectTool()},
function _(e,t,i,r,n){r();var s=e(1),_=e(135),o=e(487),d=e(308),a=function(e){function t(){var t=e.apply(this,s.__spread(arguments))||this;return t._drawing=!1,t}return s.__extends(t,e),t.prototype._doubletap=function(e){var t,i;if(this.model.active){var r=this.model.renderers;try{for(var n=s.__values(r),_=n.next();!_.done;_=n.next()){var o=_.value;1==this._select_event(e,"replace",[o]).length&&(this._selected_renderer=o)}}catch(e){t={error:e}}finally{try{_&&!_.done&&(i=n.return)&&i.call(n)}finally{if(t)throw t.error}}this._show_intersections(),this._update_line_cds()}},t.prototype._show_intersections=function(){if(this.model.active&&null!=this._selected_renderer){if(!this.model.renderers.length)return this._set_intersection([],[]),this._selected_renderer=null,void(this._drawing=!1);var e=this._selected_renderer.data_source,t=this._selected_renderer.glyph,i=s.__read([t.x.field,t.y.field],2),r=i[0],n=i[1],_=e.get_array(r),o=e.get_array(n);this._set_intersection(_,o)}},t.prototype._tap=function(e){var t=this.model.intersection_renderer;if(null!=this._map_drag(e.sx,e.sy,t)){if(this._drawing&&this._selected_renderer){var i=this._select_mode(e);if(0==this._select_event(e,i,[t]).length)return}var r=this._select_mode(e);this._select_event(e,r,[t]),this._select_event(e,r,this.model.renderers)}},t.prototype._update_line_cds=function(){if(null!=this._selected_renderer){var e=this.model.intersection_renderer.glyph,t=this.model.intersection_renderer.data_source,i=s.__read([e.x.field,e.y.field],2),r=i[0],n=i[1];if(r&&n){var _=t.data[r],o=t.data[n];this._selected_renderer.data_source.data[r]=_,this._selected_renderer.data_source.data[n]=o}this._emit_cds_changes(this._selected_renderer.data_source,!0,!0,!1)}},t.prototype._pan_start=function(e){this._select_event(e,"append",[this.model.intersection_renderer]),this._basepoint=[e.sx,e.sy]},t.prototype._pan=function(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer],this.model.dimensions),this._selected_renderer&&this._selected_renderer.data_source.change.emit())},t.prototype._pan_end=function(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer]),this._emit_cds_changes(this.model.intersection_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)},t.prototype.activate=function(){this._drawing=!0},t.prototype.deactivate=function(){this._selected_renderer&&(this._drawing&&(this._drawing=!1),this._hide_intersections())},t}(o.LineToolView);i.LineEditToolView=a,a.__name__="LineEditToolView";var l=function(e){function t(t){var i=e.call(this,t)||this;return i.tool_name="Line Edit Tool",i.icon=d.bk_tool_icon_line_edit,i.event_type=["tap","pan","move"],i.default_order=4,i}return s.__extends(t,e),t.init_LineEditTool=function(){this.prototype.default_view=a,this.define((function(){return{dimensions:[_.Dimensions,"both"]}}))},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!1,configurable:!0}),t}(o.LineTool);i.LineEditTool=l,l.__name__="LineEditTool",l.init_LineEditTool()},
function _(e,n,i,t,o){t();var r=e(1),_=e(123),s=e(473),l=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(n,e),n.prototype._set_intersection=function(e,n){var i=this.model.intersection_renderer.glyph,t=this.model.intersection_renderer.data_source,o=r.__read([i.x.field,i.y.field],2),s=o[0],l=o[1];s&&(_.isArray(e)?t.data[s]=e:i.x={value:e}),l&&(_.isArray(n)?t.data[l]=n:i.y={value:n}),this._emit_cds_changes(t,!0,!0,!1)},n.prototype._hide_intersections=function(){this._set_intersection([],[])},n}(s.EditToolView);i.LineToolView=l,l.__name__="LineToolView";var a=function(e){function n(n){return e.call(this,n)||this}return r.__extends(n,e),n.init_LineTool=function(){this.define((function(e){return{intersection_renderer:[(0,e.AnyRef)()]}}))},n}(s.EditTool);i.LineTool=a,a.__name__="LineTool",a.init_LineTool()},
function _(t,n,e,i,o){i();var a=t(1),s=t(292),r=t(135),_=t(308);function l(t,n,e){var i,o,s=new Map;try{for(var r=a.__values(t),_=r.next();!_.done;_=r.next()){var l=a.__read(_.value,2),h=l[0],d=l[1],u=a.__read(d.r_invert(n,e),2),p=u[0],c=u[1];s.set(h,{start:p,end:c})}}catch(t){i={error:t}}finally{try{_&&!_.done&&(o=r.return)&&o.call(r)}finally{if(i)throw i.error}}return s}e.update_ranges=l;var h=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(n,t),n.prototype._pan_start=function(t){this.last_dx=0,this.last_dy=0;var n=t.sx,e=t.sy,i=this.plot_view.frame.bbox;if(!i.contains(n,e)){var o=i.h_range,a=i.v_range;(n<o.start||n>o.end)&&(this.v_axis_only=!0),(e<a.start||e>a.end)&&(this.h_axis_only=!0)}null!=this.model.document&&this.model.document.interactive_start(this.plot_model)},n.prototype._pan=function(t){this._update(t.deltaX,t.deltaY),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)},n.prototype._pan_end=function(t){this.h_axis_only=!1,this.v_axis_only=!1,null!=this.pan_info&&this.plot_view.push_state("pan",{range:this.pan_info})},n.prototype._update=function(t,n){var e,i,o,a,s,r,_=this.plot_view.frame,h=t-this.last_dx,d=n-this.last_dy,u=_.bbox.h_range,p=u.start-h,c=u.end-h,f=_.bbox.v_range,y=f.start-d,v=f.end-d,m=this.model.dimensions;"width"!=m&&"both"!=m||this.v_axis_only?(e=u.start,i=u.end,o=0):(e=p,i=c,o=-h),"height"!=m&&"both"!=m||this.h_axis_only?(a=f.start,s=f.end,r=0):(a=y,s=v,r=-d),this.last_dx=t,this.last_dy=n;var x=_.x_scales,b=_.y_scales,g=l(x,e,i),w=l(b,a,s);this.pan_info={xrs:g,yrs:w,sdx:o,sdy:r},this.plot_view.update_range(this.pan_info,{panning:!0})},n}(s.GestureToolView);e.PanToolView=h,h.__name__="PanToolView";var d=function(t){function n(n){var e=t.call(this,n)||this;return e.tool_name="Pan",e.event_type="pan",e.default_order=10,e}return a.__extends(n,t),n.init_PanTool=function(){this.prototype.default_view=h,this.define((function(){return{dimensions:[r.Dimensions,"both",{on_update:function(t,n){switch(t){case"both":n.icon=_.bk_tool_icon_pan;break;case"width":n.icon=_.bk_tool_icon_xpan;break;case"height":n.icon=_.bk_tool_icon_ypan}}}]}})),this.register_alias("pan",(function(){return new n({dimensions:"both"})})),this.register_alias("xpan",(function(){return new n({dimensions:"width"})})),this.register_alias("ypan",(function(){return new n({dimensions:"height"})}))},Object.defineProperty(n.prototype,"tooltip",{get:function(){return this._get_dim_tooltip("Pan",this.dimensions)},enumerable:!1,configurable:!0}),n}(s.GestureTool);e.PanTool=d,d.__name__="PanTool",d.init_PanTool()},
function _(t,e,i,n,s){n();var r=t(1),l=t(243),a=t(275),o=t(134),_=t(292),h=t(308);function d(t){switch(t){case 1:return 2;case 2:return 1;case 4:return 5;case 5:return 4;default:return t}}function u(t,e,i,n){if(null==e)return!1;var s=i.compute(e);return Math.abs(t-s)<n}function c(t,e,i,n,s){var r=!0;if(null!=s.left&&null!=s.right){var l=i.invert(t);(l<s.left||l>s.right)&&(r=!1)}if(null!=s.bottom&&null!=s.top){var a=n.invert(e);(a<s.bottom||a>s.top)&&(r=!1)}return r}function y(t,e,i){var n=0;return t>=i.start&&t<=i.end&&(n+=1),e>=i.start&&e<=i.end&&(n+=1),n}function g(t,e,i,n){var s=e.compute(t),r=e.invert(s+i);return r>=n.start&&r<=n.end?r:t}function f(t,e,i){return t>e.start?(e.end=t,i):(e.end=e.start,e.start=t,d(i))}function p(t,e,i){return t<e.end?(e.start=t,i):(e.start=e.end,e.end=t,d(i))}function v(t,e,i,n){var s=r.__read(e.r_compute(t.start,t.end),2),l=s[0],a=s[1],o=r.__read(e.r_invert(l+i,a+i),2),_=o[0],h=o[1],d=y(t.start,t.end,n);y(_,h,n)>=d&&(t.start=_,t.end=h)}i.flip_side=d,i.is_near=u,i.is_inside=c,i.sides_inside=y,i.compute_value=g,i.update_range_end_side=f,i.update_range_start_side=p,i.update_range=v;var m=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.side=0,this.model.update_overlay_from_ranges()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),null!=this.model.x_range&&this.connect(this.model.x_range.change,(function(){return e.model.update_overlay_from_ranges()})),null!=this.model.y_range&&this.connect(this.model.y_range.change,(function(){return e.model.update_overlay_from_ranges()}))},e.prototype._pan_start=function(t){this.last_dx=0,this.last_dy=0;var e=this.model.x_range,i=this.model.y_range,n=this.plot_view.frame,s=n.x_scale,r=n.y_scale,a=this.model.overlay,o=a.left,_=a.right,h=a.top,d=a.bottom,y=this.model.overlay.properties.line_width.value()+l.EDGE_TOLERANCE;null!=e&&this.model.x_interaction&&(u(t.sx,o,s,y)?this.side=1:u(t.sx,_,s,y)?this.side=2:c(t.sx,t.sy,s,r,a)&&(this.side=3)),null!=i&&this.model.y_interaction&&(0==this.side&&u(t.sy,d,r,y)&&(this.side=4),0==this.side&&u(t.sy,h,r,y)?this.side=5:c(t.sx,t.sy,s,r,this.model.overlay)&&(3==this.side?this.side=7:this.side=6))},e.prototype._pan=function(t){var e=this.plot_view.frame,i=t.deltaX-this.last_dx,n=t.deltaY-this.last_dy,s=this.model.x_range,r=this.model.y_range,l=e.x_scale,a=e.y_scale;if(null!=s)if(3==this.side||7==this.side)v(s,l,i,e.x_range);else if(1==this.side){var o=g(s.start,l,i,e.x_range);this.side=p(o,s,this.side)}else if(2==this.side){var _=g(s.end,l,i,e.x_range);this.side=f(_,s,this.side)}if(null!=r)if(6==this.side||7==this.side)v(r,a,n,e.y_range);else if(4==this.side){o=g(r.start,a,n,e.y_range);this.side=p(o,r,this.side)}else if(5==this.side){_=g(r.end,a,n,e.y_range);this.side=f(_,r,this.side)}this.last_dx=t.deltaX,this.last_dy=t.deltaY},e.prototype._pan_end=function(t){this.side=0},e}(_.GestureToolView);i.RangeToolView=m,m.__name__="RangeToolView";var x=function(){return new l.BoxAnnotation({level:"overlay",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:.5,line_dash:[2,2]})},w=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Range Tool",i.icon=h.bk_tool_icon_range,i.event_type="pan",i.default_order=1,i}return r.__extends(e,t),e.init_RangeTool=function(){this.prototype.default_view=m,this.define((function(t){var e=t.Boolean,i=t.Ref,n=t.Nullable;return{x_range:[n(i(a.Range1d)),null],x_interaction:[e,!0],y_range:[n(i(a.Range1d)),null],y_interaction:[e,!0],overlay:[i(l.BoxAnnotation),x]}}))},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.overlay.in_cursor="grab",this.overlay.ew_cursor=null!=this.x_range&&this.x_interaction?"ew-resize":null,this.overlay.ns_cursor=null!=this.y_range&&this.y_interaction?"ns-resize":null},e.prototype.update_overlay_from_ranges=function(){null==this.x_range&&null==this.y_range&&(this.overlay.left=null,this.overlay.right=null,this.overlay.bottom=null,this.overlay.top=null,o.logger.warn("RangeTool not configured with any Ranges.")),null==this.x_range?(this.overlay.left=null,this.overlay.right=null):(this.overlay.left=this.x_range.start,this.overlay.right=this.x_range.end),null==this.y_range?(this.overlay.bottom=null,this.overlay.top=null):(this.overlay.bottom=this.y_range.start,this.overlay.top=this.y_range.end)},e}(_.GestureTool);i.RangeTool=w,w.__name__="RangeTool",w.init_RangeTool()},
function _(e,t,r,n,i){n();var o=e(1),l=e(481),s=e(135),a=e(308),c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._tap=function(e){var t={type:"point",sx:e.sx,sy:e.sy};this._select(t,!0,this._select_mode(e))},t.prototype._select=function(e,t,r){var n,i,l,s,a=this,c=this.model.callback;if("select"==this.model.behavior){var _=this._computed_renderers_by_data_source();try{for(var u=o.__values(_),p=u.next();!p.done;p=u.next()){var v=o.__read(p.value,2)[1],h=v[0].get_selection_manager(),f=v.map((function(e){return a.plot_view.renderer_view(e)})).filter((function(e){return null!=e}));if(h.select(f,e,t,r)&&null!=c){var d=f[0].coordinates.x_scale.invert(e.sx),y=f[0].coordinates.y_scale.invert(e.sy),m={geometries:Object.assign(Object.assign({},e),{x:d,y:y}),source:h.source};c.execute(this.model,m)}}}catch(e){n={error:e}}finally{try{p&&!p.done&&(i=u.return)&&i.call(u)}finally{if(n)throw n.error}}this._emit_selection_event(e),this.plot_view.push_state("tap",{selection:this.plot_view.get_selection()})}else try{for(var x=o.__values(this.computed_renderers),T=x.next();!T.done;T=x.next()){var w=T.value,g=this.plot_view.renderer_view(w);if(null!=g)if((h=w.get_selection_manager()).inspect(g,e)&&null!=c){d=g.coordinates.x_scale.invert(e.sx),y=g.coordinates.y_scale.invert(e.sy),m={geometries:Object.assign(Object.assign({},e),{x:d,y:y}),source:h.source};c.execute(this.model,m)}}}catch(e){l={error:e}}finally{try{T&&!T.done&&(s=x.return)&&s.call(x)}finally{if(l)throw l.error}}},t}(l.SelectToolView);r.TapToolView=c,c.__name__="TapToolView";var _=function(e){function t(t){var r=e.call(this,t)||this;return r.tool_name="Tap",r.icon=a.bk_tool_icon_tap_select,r.event_type="tap",r.default_order=10,r}return o.__extends(t,e),t.init_TapTool=function(){this.prototype.default_view=c,this.define((function(e){var t=e.Any,r=e.Nullable;return{behavior:[s.TapBehavior,"select"],callback:[r(t)]}})),this.register_alias("click",(function(){return new t({behavior:"inspect"})})),this.register_alias("tap",(function(){return new t}))},t}(l.SelectTool);r.TapTool=_,_.__name__="TapTool",_.init_TapTool()},
function _(e,t,n,i,o){i();var r=e(1),a=e(292),s=e(135),l=e(308),_=e(488),h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype._scroll=function(e){var t=this.model.speed*e.delta;t>.9?t=.9:t<-.9&&(t=-.9),this._update_ranges(t)},t.prototype._update_ranges=function(e){var t,n,i,o,a=this.plot_view.frame,s=a.bbox.h_range,l=a.bbox.v_range,h=r.__read([s.start,s.end],2),u=h[0],d=h[1],p=r.__read([l.start,l.end],2),c=p[0],f=p[1];switch(this.model.dimension){case"height":var m=Math.abs(f-c);t=u,n=d,i=c-m*e,o=f-m*e;break;case"width":var w=Math.abs(d-u);t=u-w*e,n=d-w*e,i=c,o=f;break;default:throw new Error("this shouldn't have happened")}var g=a.x_scales,v=a.y_scales,b={xrs:_.update_ranges(g,t,n),yrs:_.update_ranges(v,i,o),factor:e};this.plot_view.push_state("wheel_pan",{range:b}),this.plot_view.update_range(b,{scrolling:!0}),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)},t}(a.GestureToolView);n.WheelPanToolView=h,h.__name__="WheelPanToolView";var u=function(e){function t(t){var n=e.call(this,t)||this;return n.tool_name="Wheel Pan",n.icon=l.bk_tool_icon_wheel_pan,n.event_type="scroll",n.default_order=12,n}return r.__extends(t,e),t.init_WheelPanTool=function(){this.prototype.default_view=h,this.define((function(){return{dimension:[s.Dimension,"width"]}})),this.internal((function(e){return{speed:[e.Number,.001]}})),this.register_alias("xwheel_pan",(function(){return new t({dimension:"width"})})),this.register_alias("ywheel_pan",(function(){return new t({dimension:"height"})}))},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimension)},enumerable:!1,configurable:!0}),t}(a.GestureTool);n.WheelPanTool=u,u.__name__="WheelPanTool",u.init_WheelPanTool()},
function _(e,o,t,i,n){i();var s=e(1),l=e(292),r=e(471),_=e(135),h=e(147),a=e(308),m=function(e){function o(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(o,e),o.prototype._pinch=function(e){var o,t=e.sx,i=e.sy,n=e.scale,s=e.ctrlKey,l=e.shiftKey;o=n>=1?20*(n-1):-20/n,this._scroll({type:"wheel",sx:t,sy:i,delta:o,ctrlKey:s,shiftKey:l})},o.prototype._scroll=function(e){var o=this.plot_view.frame,t=o.bbox.h_range,i=o.bbox.v_range,n=e.sx,s=e.sy,l=this.model.dimensions,_=("width"==l||"both"==l)&&t.start<n&&n<t.end,h=("height"==l||"both"==l)&&i.start<s&&s<i.end;if(_&&h||this.model.zoom_on_axis){var a=this.model.speed*e.delta,m=r.scale_range(o,a,_,h,{x:n,y:s});this.plot_view.push_state("wheel_zoom",{range:m});var u=this.model.maintain_focus;this.plot_view.update_range(m,{scrolling:!0,maintain_focus:u}),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)}},o}(l.GestureToolView);t.WheelZoomToolView=m,m.__name__="WheelZoomToolView";var u=function(e){function o(o){var t=e.call(this,o)||this;return t.tool_name="Wheel Zoom",t.icon=a.bk_tool_icon_wheel_zoom,t.event_type=h.is_mobile?"pinch":"scroll",t.default_order=10,t}return s.__extends(o,e),o.init_WheelZoomTool=function(){this.prototype.default_view=m,this.define((function(e){var o=e.Boolean,t=e.Number;return{dimensions:[_.Dimensions,"both"],maintain_focus:[o,!0],zoom_on_axis:[o,!0],speed:[t,1/600]}})),this.register_alias("wheel_zoom",(function(){return new o({dimensions:"both"})})),this.register_alias("xwheel_zoom",(function(){return new o({dimensions:"width"})})),this.register_alias("ywheel_zoom",(function(){return new o({dimensions:"height"})}))},Object.defineProperty(o.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!1,configurable:!0}),o}(l.GestureTool);t.WheelZoomTool=u,u.__name__="WheelZoomTool",u.init_WheelZoomTool()},
function _(t,n,i,e,o){e();var r=t(1),s=t(304),l=t(287),a=t(135),h=t(128),_=t(308),u=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n.prototype._move=function(t){if(this.model.active){var n=t.sx,i=t.sy;this.plot_view.frame.bbox.contains(n,i)?this._update_spans(n,i):this._update_spans(null,null)}},n.prototype._move_exit=function(t){this._update_spans(null,null)},n.prototype._update_spans=function(t,n){var i=this.model.dimensions;"width"!=i&&"both"!=i||(this.model.spans.width.location=n),"height"!=i&&"both"!=i||(this.model.spans.height.location=t)},n}(s.InspectToolView);i.CrosshairToolView=u,u.__name__="CrosshairToolView";var p=function(t){function n(n){var i=t.call(this,n)||this;return i.tool_name="Crosshair",i.icon=_.bk_tool_icon_crosshair,i}return r.__extends(n,t),n.init_CrosshairTool=function(){function t(t,n){return new l.Span({for_hover:!0,dimension:n,location_units:"screen",level:"overlay",line_color:t.line_color,line_width:t.line_width,line_alpha:t.line_alpha})}this.prototype.default_view=u,this.define((function(t){var n=t.Alpha,i=t.Number,e=t.Color;return{dimensions:[a.Dimensions,"both"],line_color:[e,"black"],line_width:[i,1],line_alpha:[n,1]}})),this.internal((function(n){var i=n.Struct,e=n.Ref;return{spans:[i({width:e(l.Span),height:e(l.Span)}),function(n){return{width:t(n,"width"),height:t(n,"height")}}]}})),this.register_alias("crosshair",(function(){return new n}))},Object.defineProperty(n.prototype,"tooltip",{get:function(){return this._get_dim_tooltip("Crosshair",this.dimensions)},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"synthetic_renderers",{get:function(){return h.values(this.spans)},enumerable:!1,configurable:!0}),n}(s.InspectTool);i.CrosshairTool=p,p.__name__="CrosshairTool",p.init_CrosshairTool()},
function _(t,e,n,o,r){o();var i=t(1),u=t(196),s=t(128),a=t(144),c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_CustomJSHover=function(){this.define((function(t){var e=t.Unknown,n=t.String;return{args:[(0,t.Dict)(e),{}],code:[n,""]}}))},Object.defineProperty(e.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!1,configurable:!0}),e.prototype._make_code=function(t,e,n,o){return new(Function.bind.apply(Function,i.__spread([void 0],s.keys(this.args),[t,e,n,a.use_strict(o)])))},e.prototype.format=function(t,e,n){return this._make_code("value","format","special_vars",this.code).apply(void 0,i.__spread(this.values,[t,e,n]))},e}(u.Model);n.CustomJSHover=c,c.__name__="CustomJSHover",c.init_CustomJSHover()},
function _(e,t,r,n,o){n();var i=e(1),a=e(304),l=e(494),s=e(311),_=e(210),c=e(231),d=e(211),u=e(212),p=e(234),h=e(482),v=i.__importStar(e(215)),y=e(326),f=e(187),m=e(137),x=e(128),w=e(300),g=e(123),b=e(230),k=e(135),T=e(308),C=e(312);function R(e,t,r,n,o,i){var a,l,s={x:o[e],y:i[e]},_={x:o[e+1],y:i[e+1]};if("span"==t.type)"h"==t.direction?(a=Math.abs(s.x-r),l=Math.abs(_.x-r)):(a=Math.abs(s.y-n),l=Math.abs(_.y-n));else{var c={x:r,y:n};a=v.dist_2_pts(s,c),l=v.dist_2_pts(_,c)}return a<l?[[s.x,s.y],e]:[[_.x,_.y],e+1]}function S(e,t,r){return[[e[r],t[r]],r]}r._nearest_line_hit=R,r._line_hit=S;var H=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this._ttmodels=null,this._ttviews=new Map;var t=this.model.tooltips;g.isArray(t)&&(this._template_el=this._create_template(t))},t.prototype.remove=function(){b.remove_views(this._ttviews),e.prototype.remove.call(this)},t.prototype.connect_signals=function(){var t,r,n=this;e.prototype.connect_signals.call(this);try{for(var o=i.__values(this.computed_renderers),a=o.next();!a.done;a=o.next()){var l=a.value;l instanceof _.GlyphRenderer?this.connect(l.data_source.inspect,this._update):l instanceof c.GraphRenderer&&(this.connect(l.node_renderer.data_source.inspect,this._update),this.connect(l.edge_renderer.data_source.inspect,this._update))}}catch(e){t={error:e}}finally{try{a&&!a.done&&(r=o.return)&&r.call(o)}finally{if(t)throw t.error}}this.connect(this.model.properties.renderers.change,(function(){return n._computed_renderers=n._ttmodels=null})),this.connect(this.model.properties.names.change,(function(){return n._computed_renderers=n._ttmodels=null})),this.connect(this.model.properties.tooltips.change,(function(){return n._ttmodels=null}))},t.prototype._compute_ttmodels=function(){var e,t,r=this,n=new Map,o=this.model.tooltips;if(null!=o)try{for(var a=i.__values(this.computed_renderers),l=a.next();!l.done;l=a.next()){var d=l.value,u=new s.Tooltip({custom:g.isString(o)||g.isFunction(o),attachment:this.model.attachment,show_arrow:this.model.show_arrow});d instanceof _.GlyphRenderer?n.set(d,u):d instanceof c.GraphRenderer&&(n.set(d.node_renderer,u),n.set(d.edge_renderer,u))}}catch(t){e={error:t}}finally{try{l&&!l.done&&(t=a.return)&&t.call(a)}finally{if(e)throw e.error}}return i.__awaiter(r,void 0,void 0,(function(){var e,t,r,o,a;return i.__generator(this,(function(l){switch(l.label){case 0:return[4,b.build_views(this._ttviews,i.__spread(n.values()),{parent:this.plot_view})];case 1:e=l.sent();try{for(t=i.__values(e),r=t.next();!r.done;r=t.next())r.value.render()}catch(e){o={error:e}}finally{try{r&&!r.done&&(a=t.return)&&a.call(t)}finally{if(o)throw o.error}}return[2]}}))})),n},Object.defineProperty(t.prototype,"computed_renderers",{get:function(){if(null==this._computed_renderers){var e=this.model.renderers,t=this.plot_model.data_renderers,r=this.model.names;this._computed_renderers=h.compute_renderers(e,t,r)}return this._computed_renderers},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"ttmodels",{get:function(){return null==this._ttmodels&&(this._ttmodels=this._compute_ttmodels()),this._ttmodels},enumerable:!1,configurable:!0}),t.prototype._clear=function(){var e,t;this._inspect(1/0,1/0);try{for(var r=i.__values(this.ttmodels),n=r.next();!n.done;n=r.next()){i.__read(n.value,2)[1].clear()}}catch(t){e={error:t}}finally{try{n&&!n.done&&(t=r.return)&&t.call(r)}finally{if(e)throw e.error}}},t.prototype._move=function(e){if(this.model.active){var t=e.sx,r=e.sy;this.plot_view.frame.bbox.contains(t,r)?this._inspect(t,r):this._clear()}},t.prototype._move_exit=function(){this._clear()},t.prototype._inspect=function(e,t){var r,n,o;"mouse"==this.model.mode?o={type:"point",sx:e,sy:t}:o={type:"span",direction:"vline"==this.model.mode?"h":"v",sx:e,sy:t};try{for(var a=i.__values(this.computed_renderers),l=a.next();!l.done;l=a.next()){var s=l.value,_=s.get_selection_manager(),c=this.plot_view.renderer_view(s);null!=c&&_.inspect(c,o)}}catch(e){r={error:e}}finally{try{l&&!l.done&&(n=a.return)&&n.call(a)}finally{if(r)throw r.error}}this._emit_callback(o)},t.prototype._update=function(e){var t,r,n,o,a,l,s,c,d,h,v,y,m,w,g,b,k,T,C,H,M,A,G,$,O,P,V,F,N=i.__read(e,2),j=N[0],q=N[1].geometry;if(this.model.active&&("point"==q.type||"span"==q.type)&&j instanceof _.GlyphRenderer&&("ignore"!=this.model.muted_policy||!j.muted)){var z=this.ttmodels.get(j);if(null!=z){var L=j.get_selection_manager(),D=L.inspectors.get(j);if((D=j.view.convert_selection_to_subset(D)).is_empty())z.clear();else{var E=L.source,I=this.plot_view.renderer_view(j);if(null!=I){var B=q.sx,J=q.sy,K=I.coordinates.x_scale,Q=I.coordinates.y_scale,U=K.invert(B),W=Q.invert(J),X=I.glyph,Y=[];if(X instanceof u.LineView)try{for(var Z=i.__values(D.line_indices),ee=Z.next();!ee.done;ee=Z.next()){var te=ee.value,re=X._x[te+1],ne=X._y[te+1],oe=te,ie=void 0,ae=void 0;switch(this.model.line_policy){case"interp":re=(n=i.__read(X.get_interpolation_hit(te,q),2))[0],ne=n[1],ie=K.compute(re),ae=Q.compute(ne);break;case"prev":o=i.__read(S(X.sx,X.sy,te),2),ie=(a=i.__read(o[0],2))[0],ae=a[1],oe=o[1];break;case"next":l=i.__read(S(X.sx,X.sy,te+1),2),ie=(s=i.__read(l[0],2))[0],ae=s[1],oe=l[1];break;case"nearest":c=i.__read(R(te,q,B,J,X.sx,X.sy),2),ie=(d=i.__read(c[0],2))[0],ae=d[1],oe=c[1],re=X._x[oe],ne=X._y[oe];break;default:ie=(h=i.__read([B,J],2))[0],ae=h[1]}var le={index:oe,x:U,y:W,sx:B,sy:J,data_x:re,data_y:ne,rx:ie,ry:ae,indices:D.line_indices,name:j.name};Y.push([ie,ae,this._render_tooltips(E,oe,le)])}}catch(e){t={error:e}}finally{try{ee&&!ee.done&&(r=Z.return)&&r.call(Z)}finally{if(t)throw t.error}}try{for(var se=i.__values(D.image_indices),_e=se.next();!_e.done;_e=se.next()){var ce=_e.value,de=(le={index:ce.index,x:U,y:W,sx:B,sy:J,name:j.name},this._render_tooltips(E,ce,le));Y.push([B,J,de])}}catch(e){v={error:e}}finally{try{_e&&!_e.done&&(y=se.return)&&y.call(se)}finally{if(v)throw v.error}}try{for(var ue=i.__values(D.indices),pe=ue.next();!pe.done;pe=ue.next()){te=pe.value;if(X instanceof p.MultiLineView&&!x.isEmpty(D.multiline_indices))try{for(var he=(g=void 0,i.__values(D.multiline_indices[te.toString()])),ve=he.next();!ve.done;ve=he.next()){var ye=ve.value,fe=(re=X._xs.get(te)[ye],ne=X._ys.get(te)[ye],ye);ie=void 0,ae=void 0;switch(this.model.line_policy){case"interp":re=(k=i.__read(X.get_interpolation_hit(te,ye,q),2))[0],ne=k[1],ie=K.compute(re),ae=Q.compute(ne);break;case"prev":T=i.__read(S(X.sxs.get(te),X.sys.get(te),ye),2),ie=(C=i.__read(T[0],2))[0],ae=C[1],fe=T[1];break;case"next":H=i.__read(S(X.sxs.get(te),X.sys.get(te),ye+1),2),ie=(M=i.__read(H[0],2))[0],ae=M[1],fe=H[1];break;case"nearest":A=i.__read(R(ye,q,B,J,X.sxs.get(te),X.sys.get(te)),2),ie=(G=i.__read(A[0],2))[0],ae=G[1],fe=A[1],re=X._xs.get(te)[fe],ne=X._ys.get(te)[fe];break;default:throw new Error("should't have happened")}var me=void 0;le={index:me=j instanceof _.GlyphRenderer?j.view.convert_indices_from_subset([te])[0]:te,x:U,y:W,sx:B,sy:J,data_x:re,data_y:ne,segment_index:fe,indices:D.multiline_indices,name:j.name};Y.push([ie,ae,this._render_tooltips(E,me,le)])}}catch(e){g={error:e}}finally{try{ve&&!ve.done&&(b=he.return)&&b.call(he)}finally{if(g)throw g.error}}else{re=null===(V=X._x)||void 0===V?void 0:V[te],ne=null===(F=X._y)||void 0===F?void 0:F[te],ie=void 0,ae=void 0;if("snap_to_data"==this.model.point_policy){var xe=X.get_anchor_point(this.model.anchor,te,[B,J]);if(null==xe&&null==(xe=X.get_anchor_point("center",te,[B,J])))continue;ie=xe.x,ae=xe.y}else ie=($=i.__read([B,J],2))[0],ae=$[1];me=void 0,le={index:me=j instanceof _.GlyphRenderer?j.view.convert_indices_from_subset([te])[0]:te,x:U,y:W,sx:B,sy:J,data_x:re,data_y:ne,indices:D.indices,name:j.name};Y.push([ie,ae,this._render_tooltips(E,me,le)])}}}catch(e){m={error:e}}finally{try{pe&&!pe.done&&(w=ue.return)&&w.call(ue)}finally{if(m)throw m.error}}if(0==Y.length)z.clear();else{var we=z.content;f.empty(z.content);try{for(var ge=i.__values(Y),be=ge.next();!be.done;be=ge.next()){var ke=i.__read(be.value,3)[2];null!=ke&&we.appendChild(ke)}}catch(e){O={error:e}}finally{try{be&&!be.done&&(P=ge.return)&&P.call(ge)}finally{if(O)throw O.error}}var Te=i.__read(Y[Y.length-1],2),Ce=Te[0],Re=Te[1];z.setv({position:[Ce,Re]},{check_eq:!1})}}}}}},t.prototype._emit_callback=function(e){var t,r,n=this.model.callback;if(null!=n)try{for(var o=i.__values(this.computed_renderers),a=o.next();!a.done;a=o.next()){var l=a.value;if(l instanceof _.GlyphRenderer){var s=this.plot_view.renderer_view(l);if(null!=s){var c=s.coordinates,d=c.x_scale,u=c.y_scale,p=d.invert(e.sx),h=u.invert(e.sy);n.execute(this.model,{geometry:Object.assign({x:p,y:h},e),renderer:l})}}}}catch(e){t={error:e}}finally{try{a&&!a.done&&(r=o.return)&&r.call(o)}finally{if(t)throw t.error}}},t.prototype._create_template=function(e){var t,r,n=f.div({style:{display:"table",borderSpacing:"2px"}});try{for(var o=i.__values(e),a=o.next();!a.done;a=o.next()){var l=i.__read(a.value,1)[0],s=f.div({style:{display:"table-row"}});n.appendChild(s);var _=f.div({style:{display:"table-cell"},class:C.bk_tooltip_row_label},0!=l.length?l+": ":"");s.appendChild(_);var c=f.span();c.dataset.value="";var d=f.span({class:C.bk_tooltip_color_block}," ");d.dataset.swatch="",f.undisplay(d);var u=f.div({style:{display:"table-cell"},class:C.bk_tooltip_row_value},c,d);s.appendChild(u)}}catch(e){t={error:e}}finally{try{a&&!a.done&&(r=o.return)&&r.call(o)}finally{if(t)throw t.error}}return n},t.prototype._render_template=function(e,t,r,n,o){var a,l,s,_,c=e.cloneNode(!0),d=c.querySelectorAll("[data-value]"),u=c.querySelectorAll("[data-swatch]"),p=/\$color(\[.*\])?:(\w*)/;try{for(var h=i.__values(w.enumerate(t)),v=h.next();!v.done;v=h.next()){var x=i.__read(v.value,2),b=i.__read(x[0],2)[1],k=x[1],T=b.match(p);if(null!=T){var C=i.__read(T,3),R=C[1],S=void 0===R?"":R,H=C[2],M=r.get_column(H);if(null==M){d[k].textContent=H+" unknown";continue}var A=S.indexOf("hex")>=0,G=S.indexOf("swatch")>=0,$=g.isNumber(n)?M[n]:null;if(null==$){d[k].textContent="(null)";continue}A&&($=m.color2hex($)),d[k].textContent=$,G&&(u[k].style.backgroundColor=$,f.display(u[k]))}else{var O=y.replace_placeholders(b.replace("$~","$data_"),r,n,this.model.formatters,o);if(g.isString(O))d[k].textContent=O;else try{for(var P=(s=void 0,i.__values(O)),V=P.next();!V.done;V=P.next()){var F=V.value;d[k].appendChild(F)}}catch(e){s={error:e}}finally{try{V&&!V.done&&(_=P.return)&&_.call(P)}finally{if(s)throw s.error}}}}}catch(e){a={error:e}}finally{try{v&&!v.done&&(l=h.return)&&l.call(h)}finally{if(a)throw a.error}}return c},t.prototype._render_tooltips=function(e,t,r){var n=this.model.tooltips;if(g.isString(n)){var o=y.replace_placeholders({html:n},e,t,this.model.formatters,r);return f.div({},o)}return g.isFunction(n)?n(e,r):null!=n?this._render_template(this._template_el,n,e,t,r):null},t}(a.InspectToolView);r.HoverToolView=H,H.__name__="HoverToolView";var M=function(e){function t(t){var r=e.call(this,t)||this;return r.tool_name="Hover",r.icon=T.bk_tool_icon_hover,r}return i.__extends(t,e),t.init_HoverTool=function(){this.prototype.default_view=H,this.define((function(e){var t=e.Any,r=e.Boolean,n=e.String,o=e.Array,i=e.Tuple,a=e.Dict,s=e.Or,_=e.Ref,c=e.Function,u=e.Auto,p=e.Null,h=e.Nullable;return{tooltips:[h(s(n,o(i(n,n)),c())),[["index","$index"],["data (x, y)","($x, $y)"],["screen (x, y)","($sx, $sy)"]]],formatters:[a(s(_(l.CustomJSHover),y.FormatterType)),{}],renderers:[s(o(_(d.DataRenderer)),u,p),"auto"],names:[o(n),[]],mode:[k.HoverMode,"mouse"],muted_policy:[k.MutedPolicy,"show"],point_policy:[k.PointPolicy,"snap_to_data"],line_policy:[k.LinePolicy,"nearest"],show_arrow:[r,!0],anchor:[k.Anchor,"center"],attachment:[k.TooltipAttachment,"horizontal"],callback:[h(t)]}})),this.register_alias("hover",(function(){return new t}))},t}(a.InspectTool);r.HoverTool=M,M.__name__="HoverTool",M.init_HoverTool()},
function _(t,e,o,n,r){n();var i=t(1),l=t(130),a=t(196),c=t(293),u=t(304),f=t(300),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_ToolProxy=function(){this.define((function(t){var e=t.Boolean;return{tools:[(0,t.Array)((0,t.Ref)(c.ButtonTool)),[]],active:[e,!1],disabled:[e,!1]}}))},Object.defineProperty(e.prototype,"button_view",{get:function(){return this.tools[0].button_view},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"event_type",{get:function(){return this.tools[0].event_type},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"tooltip",{get:function(){return this.tools[0].tooltip},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"tool_name",{get:function(){return this.tools[0].tool_name},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"icon",{get:function(){return this.tools[0].computed_icon},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"computed_icon",{get:function(){return this.icon},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"toggleable",{get:function(){var t=this.tools[0];return t instanceof u.InspectTool&&t.toggleable},enumerable:!1,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.do=new l.Signal0(this,"do")},e.prototype.connect_signals=function(){var e,o,n=this;t.prototype.connect_signals.call(this),this.connect(this.do,(function(){return n.doit()})),this.connect(this.properties.active.change,(function(){return n.set_active()}));var r=function(t){l.connect(t.properties.active.change,(function(){n.active=t.active}))},l=this;try{for(var a=i.__values(this.tools),c=a.next();!c.done;c=a.next()){r(c.value)}}catch(t){e={error:t}}finally{try{c&&!c.done&&(o=a.return)&&o.call(a)}finally{if(e)throw e.error}}},e.prototype.doit=function(){var t,e;try{for(var o=i.__values(this.tools),n=o.next();!n.done;n=o.next()){n.value.do.emit()}}catch(e){t={error:e}}finally{try{n&&!n.done&&(e=o.return)&&e.call(o)}finally{if(t)throw t.error}}},e.prototype.set_active=function(){var t,e;try{for(var o=i.__values(this.tools),n=o.next();!n.done;n=o.next()){n.value.active=this.active}}catch(e){t={error:e}}finally{try{n&&!n.done&&(e=o.return)&&e.call(o)}finally{if(t)throw t.error}}},Object.defineProperty(e.prototype,"menu",{get:function(){var t,e,o=this,n=this.tools[0].menu;if(null==n)return null;var r=[],l=function(t,e){if(null==t)r.push(null);else{r.push(Object.assign(Object.assign({},t),{handler:function(){var t,n,r,l;try{for(var a=(t=void 0,i.__values(o.tools)),c=a.next();!c.done;c=a.next()){null===(l=null===(r=c.value.menu)||void 0===r?void 0:r[e])||void 0===l||l.handler()}}catch(e){t={error:e}}finally{try{c&&!c.done&&(n=a.return)&&n.call(a)}finally{if(t)throw t.error}}}}))}};try{for(var a=i.__values(f.enumerate(n)),c=a.next();!c.done;c=a.next()){var u=i.__read(c.value,2);l(u[0],u[1])}}catch(e){t={error:e}}finally{try{c&&!c.done&&(e=a.return)&&e.call(a)}finally{if(t)throw t.error}}return r},enumerable:!1,configurable:!0}),e}(a.Model);o.ToolProxy=s,s.__name__="ToolProxy",s.init_ToolProxy()},
function _(t,r,e,o,n){o();var i=t(1),l=t(135),a=t(124),s=t(128),u=t(305),c=t(290),h=t(496),y=t(407),_=t(351),f=function(t){function r(r){return t.call(this,r)||this}return i.__extends(r,t),r.init_ProxyToolbar=function(){this.define((function(t){return{toolbars:[(0,t.Array)((0,t.Ref)(c.Toolbar)),[]]}}))},r.prototype.initialize=function(){t.prototype.initialize.call(this),this._merge_tools()},r.prototype._merge_tools=function(){var t,r,e,o,n,l,u,c,y,_,f,v,d,p,x,b,w,g,m,T,B,z,P,L=this;this._proxied_tools=[];var O={},V={},k={},A=[],C=[];try{for(var D=i.__values(this.help),M=D.next();!M.done;M=D.next()){var R=M.value;a.includes(C,R.redirect)||(A.push(R),C.push(R.redirect))}}catch(r){t={error:r}}finally{try{M&&!M.done&&(r=D.return)&&r.call(D)}finally{if(t)throw t.error}}(e=this._proxied_tools).push.apply(e,i.__spread(A)),this.help=A;try{for(var j=i.__values(s.entries(this.gestures)),q=j.next();!q.done;q=j.next()){var E=i.__read(q.value,2),F=E[0],G=E[1];F in k||(k[F]={});try{for(var H=(l=void 0,i.__values(G.tools)),I=H.next();!I.done;I=H.next()){(at=I.value).type in k[F]||(k[F][at.type]=[]),k[F][at.type].push(at)}}catch(t){l={error:t}}finally{try{I&&!I.done&&(u=H.return)&&u.call(H)}finally{if(l)throw l.error}}}}catch(t){o={error:t}}finally{try{q&&!q.done&&(n=j.return)&&n.call(j)}finally{if(o)throw o.error}}try{for(var J=i.__values(this.inspectors),K=J.next();!K.done;K=J.next()){(at=K.value).type in O||(O[at.type]=[]),O[at.type].push(at)}}catch(t){c={error:t}}finally{try{K&&!K.done&&(y=J.return)&&y.call(J)}finally{if(c)throw c.error}}try{for(var N=i.__values(this.actions),Q=N.next();!Q.done;Q=N.next()){(at=Q.value).type in V||(V[at.type]=[]),V[at.type].push(at)}}catch(t){_={error:t}}finally{try{Q&&!Q.done&&(f=N.return)&&f.call(N)}finally{if(_)throw _.error}}var S=function(t,r){void 0===r&&(r=!1);var e=new h.ToolProxy({tools:t,active:r});return L._proxied_tools.push(e),e};try{for(var U=i.__values(s.keys(k)),W=U.next();!W.done;W=U.next()){F=W.value;(G=this.gestures[F]).tools=[];var X=function(t){var r,e,o=k[F][t];if(o.length>0)if("multi"==F){var n=function(t){var r=S([t]);G.tools.push(r),Y.connect(r.properties.active.change,(function(){return L._active_change(r)}))};try{for(var l=(r=void 0,i.__values(o)),a=l.next();!a.done;a=l.next()){n(a.value)}}catch(t){r={error:t}}finally{try{a&&!a.done&&(e=l.return)&&e.call(l)}finally{if(r)throw r.error}}}else{var s=S(o);G.tools.push(s),Y.connect(s.properties.active.change,(function(){return L._active_change(s)}))}},Y=this;try{for(var Z=(p=void 0,i.__values(s.keys(k[F]))),$=Z.next();!$.done;$=Z.next()){X(ot=$.value)}}catch(t){p={error:t}}finally{try{$&&!$.done&&(x=Z.return)&&x.call(Z)}finally{if(p)throw p.error}}}}catch(t){v={error:t}}finally{try{W&&!W.done&&(d=U.return)&&d.call(U)}finally{if(v)throw v.error}}this.actions=[];try{for(var tt=i.__values(s.entries(V)),rt=tt.next();!rt.done;rt=tt.next()){var et=i.__read(rt.value,2),ot=et[0],nt=et[1];if("CustomAction"==ot)try{for(var it=(g=void 0,i.__values(nt)),lt=it.next();!lt.done;lt=it.next()){var at=lt.value;this.actions.push(S([at]))}}catch(t){g={error:t}}finally{try{lt&&!lt.done&&(m=it.return)&&m.call(it)}finally{if(g)throw g.error}}else nt.length>0&&this.actions.push(S(nt))}}catch(t){b={error:t}}finally{try{rt&&!rt.done&&(w=tt.return)&&w.call(tt)}finally{if(b)throw b.error}}this.inspectors=[];try{for(var st=i.__values(s.values(O)),ut=st.next();!ut.done;ut=st.next()){(nt=ut.value).length>0&&this.inspectors.push(S(nt,!0))}}catch(t){T={error:t}}finally{try{ut&&!ut.done&&(B=st.return)&&B.call(st)}finally{if(T)throw T.error}}try{for(var ct=i.__values(s.entries(this.gestures)),ht=ct.next();!ht.done;ht=ct.next()){var yt=i.__read(ht.value,2),_t=yt[0];0!=(G=yt[1]).tools.length&&(G.tools=a.sort_by(G.tools,(function(t){return t.default_order})),"pinch"!=_t&&"scroll"!=_t&&"multi"!=_t&&(G.tools[0].active=!0))}}catch(t){z={error:t}}finally{try{ht&&!ht.done&&(P=ct.return)&&P.call(ct)}finally{if(z)throw z.error}}},r}(u.ToolbarBase);e.ProxyToolbar=f,f.__name__="ProxyToolbar",f.init_ProxyToolbar();var v=function(t){function r(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(r,t),r.prototype.initialize=function(){this.model.toolbar.toolbar_location=this.model.toolbar_location,t.prototype.initialize.call(this)},Object.defineProperty(r.prototype,"child_models",{get:function(){return[this.model.toolbar]},enumerable:!1,configurable:!0}),r.prototype._update_layout=function(){this.layout=new _.ContentBox(this.child_views[0].el),this.model.toolbar.horizontal?this.layout.set_sizing({width_policy:"fit",min_width:100,height_policy:"fixed"}):this.layout.set_sizing({width_policy:"fixed",height_policy:"fit",min_height:100})},r}(y.LayoutDOMView);e.ToolbarBoxView=v,v.__name__="ToolbarBoxView";var d=function(t){function r(r){return t.call(this,r)||this}return i.__extends(r,t),r.init_ToolbarBox=function(){this.prototype.default_view=v,this.define((function(t){return{toolbar:[(0,t.Ref)(u.ToolbarBase)],toolbar_location:[l.Location,"right"]}}))},r}(y.LayoutDOM);e.ToolbarBox=d,d.__name__="ToolbarBox",d.init_ToolbarBox()},
function _(e,n,t,r,i){r();var a=e(1),o=e(120),s=e(193),d=e(230),l=e(187),c=e(499);t.index={},t.add_document_standalone=function(e,n,r,i){return void 0===r&&(r=[]),void 0===i&&(i=!1),a.__awaiter(this,void 0,void 0,(function(){function u(i){return a.__awaiter(this,void 0,void 0,(function(){var o,u,_,f,w;return a.__generator(this,(function(a){switch(a.label){case 0:return u=e.roots(),_=u.indexOf(i),null!=(f=r[_])?o=f:n.classList.contains(c.BOKEH_ROOT)?o=n:(o=l.div({class:c.BOKEH_ROOT}),n.appendChild(o)),[4,d.build_view(i,{parent:null})];case 1:return(w=a.sent())instanceof s.DOMView&&w.renderTo(o),v.set(i,w),t.index[i.id]=w,[2,w]}}))}))}var v,_,f,w,h,O;return a.__generator(this,(function(n){switch(n.label){case 0:v=new Map,n.label=1;case 1:n.trys.push([1,6,7,8]),_=a.__values(e.roots()),f=_.next(),n.label=2;case 2:return f.done?[3,5]:[4,u(f.value)];case 3:n.sent(),n.label=4;case 4:return f=_.next(),[3,2];case 5:return[3,8];case 6:return w=n.sent(),h={error:w},[3,8];case 7:try{f&&!f.done&&(O=_.return)&&O.call(_)}finally{if(h)throw h.error}return[7];case 8:return i&&(window.document.title=e.title()),e.on_change((function(e){e instanceof o.RootAddedEvent?u(e.model):e instanceof o.RootRemovedEvent?function(e){var n=v.get(e);null!=n&&(n.remove(),v.delete(e),delete t.index[e.id])}(e.model):i&&e instanceof o.TitleChangedEvent&&(window.document.title=e.title)})),[2,a.__spread(v.values())]}}))}))}},
function _(r,e,o,n,t){n();var l=r(1),u=r(187),d=r(408);function i(r){var e=document.getElementById(r);if(null==e)throw new Error("Error rendering Bokeh model: could not find #"+r+" HTML tag");if(!document.body.contains(e))throw new Error("Error rendering Bokeh model: element #"+r+" must be under <body>");if("SCRIPT"==e.tagName){var n=u.div({class:o.BOKEH_ROOT});u.replaceWith(e,n),e=n}return e}o.BOKEH_ROOT=d.bk_root,o._resolve_element=function(r){var e=r.elementid;return null!=e?i(e):document.body},o._resolve_root_elements=function(r){var e,o,n=[];if(null!=r.root_ids&&null!=r.roots)try{for(var t=l.__values(r.root_ids),u=t.next();!u.done;u=t.next()){var d=u.value;n.push(i(r.roots[d]))}}catch(r){e={error:r}}finally{try{u&&!u.done&&(o=t.return)&&o.call(t)}finally{if(e)throw e.error}}return n}},
function _(e,n,o,t,s){t();var r=e(1),a=e(501),i=e(134),c=e(498);o._get_ws_url=function(e,n){var o,t="ws:";return"https:"==window.location.protocol&&(t="wss:"),null!=n?(o=document.createElement("a")).href=n:o=window.location,null!=e?"/"==e&&(e=""):e=o.pathname.replace(/\/+$/,""),t+"//"+o.host+e+"/ws"};var u={};function l(e,n,o){var t=a.parse_token(n).session_id;e in u||(u[e]={});var s=u[e];return t in s||(s[t]=a.pull_session(e,n,o)),s[t]}o.add_document_from_session=function(e,n,o,t,s){return void 0===t&&(t=[]),void 0===s&&(s=!1),r.__awaiter(this,void 0,void 0,(function(){var u,d,_,w;return r.__generator(this,(function(r){switch(r.label){case 0:u=window.location.search.substr(1),r.label=1;case 1:return r.trys.push([1,3,,4]),[4,l(e,n,u)];case 2:return d=r.sent(),[3,4];case 3:throw _=r.sent(),w=a.parse_token(n).session_id,i.logger.error("Failed to load Bokeh session "+w+": "+_),_;case 4:return[2,c.add_document_standalone(d.document,o,t,s)]}}))}))}},
function _(e,n,t,o,s){o();var r=e(1),i=e(134),c=e(120),l=e(502),_=e(503),a=e(504);t.DEFAULT_SERVER_WEBSOCKET_URL="ws://localhost:5006/ws",t.DEFAULT_TOKEN="eyJzZXNzaW9uX2lkIjogImRlZmF1bHQifQ";var h=0;function u(e){var n=e.split(".")[0],t=n.length%4;return 0!=t&&(n+="=".repeat(4-t)),JSON.parse(atob(n.replace(/_/g,"/").replace(/-/g,"+")))}t.parse_token=u;var d=function(){function e(e,n,o){void 0===e&&(e=t.DEFAULT_SERVER_WEBSOCKET_URL),void 0===n&&(n=t.DEFAULT_TOKEN),void 0===o&&(o=null),this.url=e,this.token=n,this.args_string=o,this._number=h++,this.socket=null,this.session=null,this.closed_permanently=!1,this._current_handler=null,this._pending_replies=new Map,this._pending_messages=[],this._receiver=new _.Receiver,this.id=u(n).session_id.split(".")[0],i.logger.debug("Creating websocket "+this._number+" to '"+this.url+"' session '"+this.id+"'")}return e.prototype.connect=function(){return r.__awaiter(this,void 0,void 0,(function(){var e,n=this;return r.__generator(this,(function(t){if(this.closed_permanently)throw new Error("Cannot connect() a closed ClientConnection");if(null!=this.socket)throw new Error("Already connected");this._current_handler=null,this._pending_replies.clear(),this._pending_messages=[];try{return e=""+this.url,null!=this.args_string&&this.args_string.length>0&&(e+="?"+this.args_string),this.socket=new WebSocket(e,["bokeh",this.token]),[2,new Promise((function(e,t){n.socket.binaryType="arraybuffer",n.socket.onopen=function(){return n._on_open(e,t)},n.socket.onmessage=function(e){return n._on_message(e)},n.socket.onclose=function(e){return n._on_close(e,t)},n.socket.onerror=function(){return n._on_error(t)}}))]}catch(e){throw i.logger.error("websocket creation failed to url: "+this.url),i.logger.error(" - "+e),e}return[2]}))}))},e.prototype.close=function(){this.closed_permanently||(i.logger.debug("Permanently closing websocket connection "+this._number),this.closed_permanently=!0,null!=this.socket&&this.socket.close(1e3,"close method called on ClientConnection "+this._number),this.session._connection_closed())},e.prototype._schedule_reconnect=function(e){var n=this;setTimeout((function(){n.closed_permanently||i.logger.info("Websocket connection "+n._number+" disconnected, will not attempt to reconnect")}),e)},e.prototype.send=function(e){if(null==this.socket)throw new Error("not connected so cannot send "+e);e.send(this.socket)},e.prototype.send_with_reply=function(e){return r.__awaiter(this,void 0,void 0,(function(){var n,t=this;return r.__generator(this,(function(o){switch(o.label){case 0:return[4,new Promise((function(n,o){t._pending_replies.set(e.msgid(),{resolve:n,reject:o}),t.send(e)}))];case 1:if("ERROR"===(n=o.sent()).msgtype())throw new Error("Error reply "+n.content.text);return[2,n]}}))}))},e.prototype._pull_doc_json=function(){return r.__awaiter(this,void 0,void 0,(function(){var e,n;return r.__generator(this,(function(t){switch(t.label){case 0:return e=l.Message.create("PULL-DOC-REQ",{}),[4,this.send_with_reply(e)];case 1:if(!("doc"in(n=t.sent()).content))throw new Error("No 'doc' field in PULL-DOC-REPLY");return[2,n.content.doc]}}))}))},e.prototype._repull_session_doc=function(e,n){return r.__awaiter(this,void 0,void 0,(function(){var t,o,s,_,h,u,d,g,p,f,w;return r.__generator(this,(function(m){switch(m.label){case 0:i.logger.debug(this.session?"Repulling session":"Pulling session for first time"),m.label=1;case 1:return m.trys.push([1,3,,4]),[4,this._pull_doc_json()];case 2:if(o=m.sent(),null==this.session)if(this.closed_permanently)i.logger.debug("Got new document after connection was already closed"),n(new Error("The connection has been closed"));else{s=c.Document.from_json(o),(_=c.Document._compute_patch_since_json(o,s)).events.length>0&&(i.logger.debug("Sending "+_.events.length+" changes from model construction back to server"),h=l.Message.create("PATCH-DOC",{},_),this.send(h)),this.session=new a.ClientSession(this,s,this.id);try{for(u=r.__values(this._pending_messages),d=u.next();!d.done;d=u.next())g=d.value,this.session.handle(g)}catch(e){f={error:e}}finally{try{d&&!d.done&&(w=u.return)&&w.call(u)}finally{if(f)throw f.error}}this._pending_messages=[],i.logger.debug("Created a new session from new pulled doc"),e(this.session)}else this.session.document.replace_with_json(o),i.logger.debug("Updated existing session with new pulled doc");return[3,4];case 3:return p=m.sent(),null===(t=console.trace)||void 0===t||t.call(console,p),i.logger.error("Failed to repull session "+p),n(p instanceof Error?p:""+p),[3,4];case 4:return[2]}}))}))},e.prototype._on_open=function(e,n){var t=this;i.logger.info("Websocket connection "+this._number+" is now open"),this._current_handler=function(o){t._awaiting_ack_handler(o,e,n)}},e.prototype._on_message=function(e){null==this._current_handler&&i.logger.error("Got a message with no current handler set");try{this._receiver.consume(e.data)}catch(e){this._close_bad_protocol(""+e)}var n=this._receiver.message;if(null!=n){var t=n.problem();null!=t&&this._close_bad_protocol(t),this._current_handler(n)}},e.prototype._on_close=function(e,n){i.logger.info("Lost websocket "+this._number+" connection, "+e.code+" ("+e.reason+")"),this.socket=null,this._pending_replies.forEach((function(e){return e.reject("Disconnected")})),this._pending_replies.clear(),this.closed_permanently||this._schedule_reconnect(2e3),n(new Error("Lost websocket connection, "+e.code+" ("+e.reason+")"))},e.prototype._on_error=function(e){i.logger.debug("Websocket error on socket "+this._number);var n="Could not open websocket";i.logger.error("Failed to connect to Bokeh server: "+n),e(new Error(n))},e.prototype._close_bad_protocol=function(e){i.logger.error("Closing connection: "+e),null!=this.socket&&this.socket.close(1002,e)},e.prototype._awaiting_ack_handler=function(e,n,t){var o=this;"ACK"===e.msgtype()?(this._current_handler=function(e){return o._steady_state_handler(e)},this._repull_session_doc(n,t)):this._close_bad_protocol("First message was not an ACK")},e.prototype._steady_state_handler=function(e){var n=e.reqid(),t=this._pending_replies.get(n);t?(this._pending_replies.delete(n),t.resolve(e)):this.session?this.session.handle(e):"PATCH-DOC"!=e.msgtype()&&this._pending_messages.push(e)},e}();t.ClientConnection=d,d.__name__="ClientConnection",t.pull_session=function(e,n,t){return new d(e,n,t).connect()}},
function _(e,t,r,n,s){n();var i=e(144),u=function(){function e(e,t,r){this.header=e,this.metadata=t,this.content=r,this.buffers=new Map}return e.assemble=function(t,r,n){return new e(JSON.parse(t),JSON.parse(r),JSON.parse(n))},e.prototype.assemble_buffer=function(e,t){var r=null!=this.header.num_buffers?this.header.num_buffers:0;if(r<=this.buffers.size)throw new Error("too many buffers received, expecting "+r);var n=JSON.parse(e).id;this.buffers.set(n,t)},e.create=function(t,r,n){void 0===n&&(n={});var s=e.create_header(t);return new e(s,r,n)},e.create_header=function(e){return{msgid:i.uniqueId(),msgtype:e}},e.prototype.complete=function(){return null!=this.header&&null!=this.metadata&&null!=this.content&&(null==this.header.num_buffers||this.buffers.size==this.header.num_buffers)},e.prototype.send=function(e){if((null!=this.header.num_buffers?this.header.num_buffers:0)>0)throw new Error("BokehJS only supports receiving buffers, not sending");var t=JSON.stringify(this.header),r=JSON.stringify(this.metadata),n=JSON.stringify(this.content);e.send(t),e.send(r),e.send(n)},e.prototype.msgid=function(){return this.header.msgid},e.prototype.msgtype=function(){return this.header.msgtype},e.prototype.reqid=function(){return this.header.reqid},e.prototype.problem=function(){return"msgid"in this.header?"msgtype"in this.header?null:"No msgtype in header":"No msgid in header"},e}();r.Message=u,u.__name__="Message"},
function _(t,e,s,_,r){_();var i=t(1),n=t(502),u=t(123),h=function(){function t(){this.message=null,this._partial=null,this._fragments=[],this._buf_header=null,this._current_consumer=this._HEADER}return t.prototype.consume=function(t){this._current_consumer(t)},t.prototype._HEADER=function(t){this._assume_text(t),this.message=null,this._partial=null,this._fragments=[t],this._buf_header=null,this._current_consumer=this._METADATA},t.prototype._METADATA=function(t){this._assume_text(t),this._fragments.push(t),this._current_consumer=this._CONTENT},t.prototype._CONTENT=function(t){this._assume_text(t),this._fragments.push(t);var e=i.__read(this._fragments.slice(0,3),3),s=e[0],_=e[1],r=e[2];this._partial=n.Message.assemble(s,_,r),this._check_complete()},t.prototype._BUFFER_HEADER=function(t){this._assume_text(t),this._buf_header=t,this._current_consumer=this._BUFFER_PAYLOAD},t.prototype._BUFFER_PAYLOAD=function(t){this._assume_binary(t),this._partial.assemble_buffer(this._buf_header,t),this._check_complete()},t.prototype._assume_text=function(t){if(!u.isString(t))throw new Error("Expected text fragment but received binary fragment")},t.prototype._assume_binary=function(t){if(!(t instanceof ArrayBuffer))throw new Error("Expected binary fragment but received text fragment")},t.prototype._check_complete=function(){this._partial.complete()?(this.message=this._partial,this._current_consumer=this._HEADER):this._current_consumer=this._BUFFER_HEADER},t}();s.Receiver=h,h.__name__="Receiver"},
function _(t,e,n,o,i){o();var r=t(1),c=t(120),s=t(502),_=t(134),h=function(){function t(t,e,n){var o=this;this._connection=t,this.document=e,this.id=n,this._document_listener=function(t){o._document_changed(t)},this.document.on_change(this._document_listener,!0)}return t.prototype.handle=function(t){var e=t.msgtype();"PATCH-DOC"===e?this._handle_patch(t):"OK"===e?this._handle_ok(t):"ERROR"===e?this._handle_error(t):_.logger.debug("Doing nothing with message "+t.msgtype())},t.prototype.close=function(){this._connection.close()},t.prototype._connection_closed=function(){this.document.remove_on_change(this._document_listener)},t.prototype.request_server_info=function(){return r.__awaiter(this,void 0,void 0,(function(){var t;return r.__generator(this,(function(e){switch(e.label){case 0:return t=s.Message.create("SERVER-INFO-REQ",{}),[4,this._connection.send_with_reply(t)];case 1:return[2,e.sent().content]}}))}))},t.prototype.force_roundtrip=function(){return r.__awaiter(this,void 0,void 0,(function(){return r.__generator(this,(function(t){switch(t.label){case 0:return[4,this.request_server_info()];case 1:return t.sent(),[2]}}))}))},t.prototype._document_changed=function(t){if(t.setter_id!==this.id){var e=t instanceof c.DocumentEventBatch?t.events:[t],n=this.document.create_json_patch(e),o=s.Message.create("PATCH-DOC",{},n);this._connection.send(o)}},t.prototype._handle_patch=function(t){this.document.apply_json_patch(t.content,t.buffers,this.id)},t.prototype._handle_ok=function(t){_.logger.trace("Unhandled OK reply to "+t.reqid())},t.prototype._handle_error=function(t){_.logger.error("Unhandled ERROR reply to "+t.reqid()+": "+t.content.text)},t}();n.ClientSession=h,h.__name__="ClientSession"},
function _(e,t,r,o,n){o();var a=e(1),s=this&&this.__asyncValues||function(e){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var t,r=e[Symbol.asyncIterator];return r?r.call(e):(e="function"==typeof __values?__values(e):e[Symbol.iterator](),t={},o("next"),o("throw"),o("return"),t[Symbol.asyncIterator]=function(){return this},t);function o(r){t[r]=e[r]&&function(t){return new Promise((function(o,n){(function(e,t,r,o){Promise.resolve(o).then((function(t){e({value:t,done:r})}),t)})(o,n,(t=e[r](t)).done,t.value)}))}}},l=e(120),i=e(503),u=e(134),c=e(187),f=e(128),g=e(498),m=e(499),d=a.__importDefault(e(188)),_=a.__importDefault(e(310)),b=a.__importDefault(e(506));function p(e,t){t.buffers.length>0?e.consume(t.buffers[0].buffer):e.consume(t.content.data);var r=e.message;null!=r&&this.apply_json_patch(r.content,r.buffers)}function y(e,t){var o=this;if("undefined"!=typeof Jupyter&&null!=Jupyter.notebook.kernel){u.logger.info("Registering Jupyter comms for target "+e);var n=Jupyter.notebook.kernel.comm_manager;try{n.register_target(e,(function(r){u.logger.info("Registering Jupyter comms for target "+e);var o=new i.Receiver;r.on_msg(p.bind(t,o))}))}catch(e){u.logger.warn("Jupyter comms failed to register. push_notebook() will not function. (exception reported: "+e+")")}}else if(t.roots()[0].id in r.kernels){u.logger.info("Registering JupyterLab comms for target "+e);var l=r.kernels[t.roots()[0].id];try{l.registerCommTarget(e,(function(r){u.logger.info("Registering JupyterLab comms for target "+e);var o=new i.Receiver;r.onMsg=p.bind(t,o)}))}catch(e){u.logger.warn("Jupyter comms failed to register. push_notebook() will not function. (exception reported: "+e+")")}}else if("undefined"!=typeof google&&null!=google.colab.kernel){u.logger.info("Registering Google Colab comms for target "+e);n=google.colab.kernel.comms;try{n.registerTarget(e,(function(r){return a.__awaiter(o,void 0,void 0,(function(){var o,n,l,c,f,g,m,d,_,b,y,h,v,w,k,x;return a.__generator(this,(function(J){switch(J.label){case 0:u.logger.info("Registering Google Colab comms for target "+e),c=new i.Receiver,J.label=1;case 1:J.trys.push([1,6,7,12]),f=s(r.messages),J.label=2;case 2:return[4,f.next()];case 3:if((g=J.sent()).done)return[3,5];m=g.value,d={data:m.data},_=[];try{for(k=void 0,b=a.__values(null!==(l=m.buffers)&&void 0!==l?l:[]),y=b.next();!y.done;y=b.next())h=y.value,_.push(new DataView(h))}catch(e){k={error:e}}finally{try{y&&!y.done&&(x=b.return)&&x.call(b)}finally{if(k)throw k.error}}v={content:d,buffers:_},p.bind(t)(c,v),J.label=4;case 4:return[3,2];case 5:return[3,12];case 6:return w=J.sent(),o={error:w},[3,12];case 7:return J.trys.push([7,,10,11]),g&&!g.done&&(n=f.return)?[4,n.call(f)]:[3,9];case 8:J.sent(),J.label=9;case 9:return[3,11];case 10:if(o)throw o.error;return[7];case 11:return[7];case 12:return[2]}}))}))}))}catch(e){u.logger.warn("Google Colab comms failed to register. push_notebook() will not function. (exception reported: "+e+")")}}else console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest @bokeh/jupyter_bokeh extension is installed. In an exported notebook this warning is expected.")}c.stylesheet.append(d.default),c.stylesheet.append(_.default),c.stylesheet.append(b.default),r.kernels={},r.embed_items_notebook=function(e,t){var r,o;if(1!=f.size(e))throw new Error("embed_items_notebook expects exactly one document in docs_json");var n=l.Document.from_json(f.values(e)[0]);try{for(var s=a.__values(t),i=s.next();!i.done;i=s.next()){var u=i.value;null!=u.notebook_comms_target&&y(u.notebook_comms_target,n);var c=m._resolve_element(u),d=m._resolve_root_elements(u);g.add_document_standalone(n,c,d)}}catch(e){r={error:e}}finally{try{i&&!i.done&&(o=s.return)&&o.call(s)}finally{if(r)throw r.error}}}},
function _(t,e,o,n,r){n();o.default="\n/* notebook specific tweaks so no black outline and matching padding\n/* can't be wrapped inside bk-root. here are the offending jupyter lines:\n/* https://github.com/jupyter/notebook/blob/master/notebook/static/notebook/less/renderedhtml.less#L59-L76 */\n.rendered_html .bk-root .bk-tooltip table,\n.rendered_html .bk-root .bk-tooltip tr,\n.rendered_html .bk-root .bk-tooltip th,\n.rendered_html .bk-root .bk-tooltip td {\n  border: none;\n  padding: 1px;\n}\n"},
function _(r,t,_,a,o){a();var e=r(1);e.__exportStar(r(502),_),e.__exportStar(r(503),_)},
function _(e,t,n,s,l){function o(){var e=document.getElementsByTagName("body")[0],t=document.getElementsByClassName("bokeh-test-div");1==t.length&&(e.removeChild(t[0]),delete t[0]);var n=document.createElement("div");n.classList.add("bokeh-test-div"),n.style.display="none",e.insertBefore(n,e.firstChild)}s(),n.results={},n.init=function(){o()},n.record0=function(e,t){n.results[e]=t},n.record=function(e,t){n.results[e]=t,o()},n.count=function(e){null==n.results[e]&&(n.results[e]=0),n.results[e]+=1,o()}},
function _(e,t,r,l,o){l(),r.safely=function(e,t){void 0===t&&(t=!1);try{return e()}catch(e){if(function(e){var t=document.createElement("div");t.style.backgroundColor="#f2dede",t.style.border="1px solid #a94442",t.style.borderRadius="4px",t.style.display="inline-block",t.style.fontFamily="sans-serif",t.style.marginTop="5px",t.style.minWidth="200px",t.style.padding="5px 5px 5px 10px",t.classList.add("bokeh-error-box-into-flames");var r=document.createElement("span");r.style.backgroundColor="#a94442",r.style.borderRadius="0px 4px 0px 0px",r.style.color="white",r.style.cursor="pointer",r.style.cssFloat="right",r.style.fontSize="0.8em",r.style.margin="-6px -6px 0px 0px",r.style.padding="2px 5px 4px 5px",r.title="close",r.setAttribute("aria-label","close"),r.appendChild(document.createTextNode("x")),r.addEventListener("click",(function(){return n.removeChild(t)}));var l=document.createElement("h3");l.style.color="#a94442",l.style.margin="8px 0px 0px 0px",l.style.padding="0px",l.appendChild(document.createTextNode("Bokeh Error"));var o=document.createElement("pre");o.style.whiteSpace="unset",o.style.overflowX="auto",o.appendChild(document.createTextNode(e)),t.appendChild(r),t.appendChild(l),t.appendChild(o);var n=document.getElementsByTagName("body")[0];n.insertBefore(t,n.firstChild)}(e instanceof Error&&e.stack?e.stack:""+e),t)return;throw e}}},
], 0, {"legacy":0,"polyfill":2,"main":116,"index":117,"version":118,"embed/index":119,"document/index":120,"document/document":121,"base":122,"core/util/types":123,"core/util/array":124,"core/util/math":125,"core/util/assert":126,"core/util/arrayable":127,"core/util/object":128,"core/has_props":129,"core/signaling":130,"core/util/callback":131,"core/util/refs":132,"core/properties":133,"core/logging":134,"core/enums":135,"core/kinds":136,"core/util/color":137,"core/util/svg_colors":138,"core/types":139,"core/util/eq":140,"core/util/data_structures":141,"core/settings":142,"core/property_mixins":143,"core/util/string":144,"core/util/ndarray":145,"core/util/serialization":146,"core/util/compat":147,"core/util/pretty":148,"models/index":149,"models/annotations/index":150,"models/annotations/annotation":151,"core/util/projections":152,"models/renderers/renderer":185,"core/view":186,"core/dom":187,"styles/root.css":188,"core/visuals":189,"core/util/svg":190,"core/util/affine":191,"models/canvas/canvas":192,"core/dom_view":193,"core/util/bbox":194,"core/util/canvas":195,"model":196,"models/canvas/coordinates":197,"models/annotations/arrow":198,"models/annotations/arrow_head":199,"models/sources/columnar_data_source":200,"models/sources/data_source":201,"models/selections/selection":202,"models/glyphs/glyph":203,"core/util/spatial":204,"models/ranges/factor_range":207,"models/ranges/range":208,"core/selection_manager":209,"models/renderers/glyph_renderer":210,"models/renderers/data_renderer":211,"models/glyphs/line":212,"models/glyphs/xy_glyph":213,"models/glyphs/utils":214,"core/hittest":215,"models/glyphs/webgl/line":216,"models/glyphs/webgl/utils/index":217,"models/glyphs/webgl/utils/program":218,"models/glyphs/webgl/utils/buffer":219,"models/glyphs/webgl/utils/texture":220,"models/glyphs/webgl/base":221,"models/glyphs/webgl/line.vert":222,"models/glyphs/webgl/line.frag":223,"models/glyphs/patch":224,"models/glyphs/harea":225,"models/glyphs/area":226,"models/glyphs/varea":227,"models/sources/cds_view":228,"models/filters/filter":229,"core/build_views":230,"models/renderers/graph_renderer":231,"models/graphs/layout_provider":232,"models/graphs/graph_hit_test_policy":233,"models/glyphs/multi_line":234,"models/glyphs/patches":235,"models/selections/interaction_policy":236,"models/sources/column_data_source":237,"core/util/typed_array":238,"core/util/set":239,"document/events":240,"models/annotations/band":241,"models/annotations/upper_lower":242,"models/annotations/box_annotation":243,"models/annotations/color_bar":244,"models/tickers/continuous_ticker":245,"models/tickers/ticker":246,"models/formatters/tick_formatter":247,"models/tickers/basic_ticker":248,"models/tickers/adaptive_ticker":249,"models/formatters/basic_tick_formatter":250,"models/mappers/continuous_color_mapper":251,"models/mappers/color_mapper":252,"models/mappers/mapper":253,"models/transforms/transform":254,"models/mappers/index":255,"models/mappers/categorical_color_mapper":256,"models/mappers/categorical_mapper":257,"models/mappers/categorical_marker_mapper":258,"models/mappers/categorical_pattern_mapper":259,"models/mappers/linear_color_mapper":260,"models/mappers/log_color_mapper":261,"models/mappers/scanning_color_mapper":262,"models/mappers/eqhist_color_mapper":263,"models/scales/linear_scale":264,"models/scales/continuous_scale":265,"models/scales/scale":266,"models/transforms/index":267,"models/transforms/customjs_transform":268,"models/transforms/dodge":269,"models/transforms/range_transform":270,"models/transforms/interpolator":271,"models/transforms/jitter":272,"models/transforms/linear_interpolator":273,"models/transforms/step_interpolator":274,"models/ranges/range1d":275,"models/scales/linear_interpolation_scale":276,"models/scales/log_scale":277,"core/util/text":278,"models/annotations/label":279,"models/annotations/text_annotation":280,"models/annotations/label_set":281,"models/annotations/legend":282,"models/annotations/legend_item":283,"core/vectorization":284,"models/annotations/poly_annotation":285,"models/annotations/slope":286,"models/annotations/span":287,"models/annotations/title":288,"models/annotations/toolbar_panel":289,"models/tools/toolbar":290,"models/tools/tool":291,"models/tools/gestures/gesture_tool":292,"models/tools/button_tool":293,"styles/toolbar":295,"styles/toolbar.css":296,"styles/icons.css":297,"styles/menus.css":298,"core/util/menus":299,"core/util/iterator":300,"styles/menus":301,"models/tools/on_off_button":302,"styles/mixins":303,"models/tools/inspectors/inspect_tool":304,"models/tools/toolbar_base":305,"models/tools/actions/action_tool":306,"models/tools/actions/help_tool":307,"styles/icons":308,"styles/logo":309,"styles/logo.css":310,"models/annotations/tooltip":311,"styles/tooltips":312,"styles/tooltips.css":313,"models/annotations/whisker":314,"models/axes/index":315,"models/axes/axis":316,"models/renderers/guide_renderer":317,"models/axes/categorical_axis":318,"models/tickers/categorical_ticker":319,"models/formatters/categorical_tick_formatter":320,"models/axes/continuous_axis":321,"models/axes/datetime_axis":322,"models/axes/linear_axis":323,"models/formatters/datetime_tick_formatter":324,"core/util/templating":326,"models/tickers/datetime_ticker":329,"models/tickers/composite_ticker":330,"models/tickers/days_ticker":331,"models/tickers/single_interval_ticker":332,"models/tickers/util":333,"models/tickers/months_ticker":334,"models/tickers/years_ticker":335,"models/axes/log_axis":336,"models/formatters/log_tick_formatter":337,"models/tickers/log_ticker":338,"models/axes/mercator_axis":339,"models/formatters/mercator_tick_formatter":340,"models/tickers/mercator_ticker":341,"models/callbacks/index":342,"models/callbacks/customjs":343,"models/callbacks/callback":344,"models/callbacks/open_url":345,"models/canvas/index":346,"models/canvas/cartesian_frame":347,"models/scales/categorical_scale":348,"models/ranges/data_range1d":349,"models/ranges/data_range":350,"core/layout/index":351,"core/layout/types":352,"core/layout/layoutable":353,"core/layout/alignments":354,"core/layout/grid":355,"core/layout/html":356,"models/expressions/index":357,"models/expressions/expression":358,"models/expressions/stack":359,"models/expressions/cumsum":360,"models/filters/index":361,"models/filters/boolean_filter":362,"models/filters/customjs_filter":363,"models/filters/group_filter":364,"models/filters/index_filter":365,"models/formatters/index":366,"models/formatters/func_tick_formatter":367,"models/formatters/numeral_tick_formatter":368,"models/formatters/printf_tick_formatter":369,"models/glyphs/index":370,"models/glyphs/annular_wedge":371,"models/glyphs/annulus":372,"models/glyphs/arc":373,"models/glyphs/bezier":374,"models/glyphs/circle":375,"models/glyphs/webgl/markers":376,"models/glyphs/webgl/markers.vert":377,"models/glyphs/webgl/markers.frag":378,"models/glyphs/center_rotatable":379,"models/glyphs/ellipse":380,"models/glyphs/ellipse_oval":381,"models/glyphs/hbar":382,"models/glyphs/box":383,"models/glyphs/hex_tile":384,"models/glyphs/image":385,"models/glyphs/image_base":386,"models/glyphs/image_rgba":387,"models/glyphs/image_url":388,"core/util/image":389,"models/glyphs/multi_polygons":390,"models/glyphs/oval":391,"models/glyphs/quad":392,"models/glyphs/quadratic":393,"models/glyphs/ray":394,"models/glyphs/rect":395,"models/glyphs/segment":396,"models/glyphs/step":397,"models/glyphs/text":398,"models/glyphs/vbar":399,"models/glyphs/wedge":400,"models/graphs/index":401,"models/graphs/static_layout_provider":402,"models/grids/index":403,"models/grids/grid":404,"models/layouts/index":405,"models/layouts/box":406,"models/layouts/layout_dom":407,"styles/root":408,"models/layouts/column":409,"models/layouts/grid_box":410,"models/layouts/html_box":411,"models/layouts/panel":412,"models/layouts/row":413,"models/layouts/spacer":414,"models/layouts/tabs":415,"styles/tabs":416,"styles/buttons":417,"styles/buttons.css":418,"styles/tabs.css":419,"models/layouts/widget_box":420,"models/markers/index":421,"models/markers/defs":422,"models/markers/marker":423,"models/markers/scatter":424,"models/plots/index":425,"models/plots/gmap_plot":426,"models/plots/plot":427,"models/plots/plot_canvas":428,"core/bokeh_events":429,"core/ui_events":430,"core/util/wheel":431,"core/util/throttle":432,"core/layout/border":433,"core/layout/side_panel":434,"models/plots/range_manager":435,"models/plots/gmap_plot_canvas":436,"models/ranges/index":437,"models/renderers/index":438,"models/scales/index":439,"models/selections/index":440,"models/sources/index":441,"models/sources/server_sent_data_source":442,"models/sources/web_data_source":443,"models/sources/ajax_data_source":444,"models/sources/geojson_data_source":445,"models/tickers/index":446,"models/tickers/fixed_ticker":447,"models/tiles/index":448,"models/tiles/bbox_tile_source":449,"models/tiles/mercator_tile_source":450,"models/tiles/tile_source":451,"models/tiles/tile_utils":452,"models/tiles/quadkey_tile_source":453,"models/tiles/tile_renderer":454,"models/tiles/wmts_tile_source":455,"styles/tiles":456,"styles/tiles.css":457,"models/tiles/tms_tile_source":458,"models/textures/index":459,"models/textures/canvas_texture":460,"models/textures/texture":461,"models/textures/image_url_texture":462,"models/tools/index":463,"models/tools/actions/custom_action":464,"models/tools/actions/redo_tool":465,"models/tools/actions/reset_tool":466,"models/tools/actions/save_tool":467,"models/tools/actions/undo_tool":468,"models/tools/actions/zoom_in_tool":469,"models/tools/actions/zoom_base_tool":470,"core/util/zoom":471,"models/tools/actions/zoom_out_tool":472,"models/tools/edit/edit_tool":473,"models/tools/edit/box_edit_tool":474,"models/tools/edit/freehand_draw_tool":475,"models/tools/edit/point_draw_tool":476,"models/tools/edit/poly_draw_tool":477,"models/tools/edit/poly_tool":478,"models/tools/edit/poly_edit_tool":479,"models/tools/gestures/box_select_tool":480,"models/tools/gestures/select_tool":481,"models/tools/util":482,"models/tools/gestures/box_zoom_tool":483,"models/tools/gestures/lasso_select_tool":484,"models/tools/gestures/poly_select_tool":485,"models/tools/edit/line_edit_tool":486,"models/tools/edit/line_tool":487,"models/tools/gestures/pan_tool":488,"models/tools/gestures/range_tool":489,"models/tools/gestures/tap_tool":490,"models/tools/gestures/wheel_pan_tool":491,"models/tools/gestures/wheel_zoom_tool":492,"models/tools/inspectors/crosshair_tool":493,"models/tools/inspectors/customjs_hover":494,"models/tools/inspectors/hover_tool":495,"models/tools/tool_proxy":496,"models/tools/toolbar_box":497,"embed/standalone":498,"embed/dom":499,"embed/server":500,"client/connection":501,"protocol/message":502,"protocol/receiver":503,"client/session":504,"embed/notebook":505,"styles/notebook.css":506,"protocol/index":507,"testing":508,"safely":509}, {});
})

