# pylint: disable=missing-module-docstring,missing-function-docstring,invalid-name,
# pylint: disable=redefined-outer-name,too-many-statements,too-many-locals,
# pylint: disable=too-many-branches,consider-using-with,line-too-long,
# pylint: disable=inconsistent-return-statements

import os
import pickle
import time
import glob

import numpy as np
import cupy  # pylint: disable=import-error
import GPUtil

import sparsebm
from sparsebm.utils import ARI, CARI

from . import lbm_not_sparse

gp = GPUtil.getGPUs()[0]
mem_gpu = gp.memoryTotal
gpu_index = gp.id

if mem_gpu > 22000:
    limit_size_accepted_by_gpu = 10000
    limit_size_accepted_by_gpu_sparse = 80000
elif mem_gpu > 8000:
    limit_size_accepted_by_gpu_sparse = 40000
    limit_size_accepted_by_gpu = 5000
elif mem_gpu > 4000:
    limit_size_accepted_by_gpu_sparse = 40000
    limit_size_accepted_by_gpu = 3000


f_prefix = [
    "500_250",
    "1000_500",
    "1500_750",
    "2000_1000",
    "2500_1250",
    "3000_1500",
    "5000_2500",
    "10000_5000",
    "15000_7500",
    "20000_10000",
    "40000_20000",
    "80000_40000",
]

nb_row_clusters, nb_column_clusters = 3, 4
n_init = 100  # Specifying the number of initializations to perform.
n_iter_early_stop = 20  # Specifying the number of EM-steps to perform on each init.
n_init_total_run = (
    10  # Specifying the number inits to keep and to train until convergence.
)


def train_with_both_model(dataset_file, gpu_index, not_sparse):
    if not os.path.exists("./experiments/results"):
        os.makedirs("./experiments/results")
    if not os.path.exists("./experiments/results/sparsity_fixed"):
        os.makedirs("./experiments/results/sparsity_fixed")
    print(dataset_file)

    results_files_already_done = glob.glob("./experiments/results/sparsity_fixed/*.pkl")
    if (
        "./experiments/results/sparsity_fixed/" + dataset_file.split("/")[-1]
        in results_files_already_done
    ):
        print("Already Done")
        return None

    dataset = pickle.load(open(dataset_file, "rb"))
    graph = dataset["data"]
    row_cluster_indicator = dataset["row_cluster_indicator"]
    column_cluster_indicator = dataset["column_cluster_indicator"]
    row_clusters_index = row_cluster_indicator.argmax(1)
    column_clusters_index = column_cluster_indicator.argmax(1)
    exponent = dataset["exponent"]
    seed = np.random.randint(0, 10000)

    if not_sparse:
        # instantiate the Latent Block Model class.
        print("Training not sparse")
        model = lbm_not_sparse.LBM_not_sparse(
            nb_row_clusters,  # A number of row classes must be specify. Otherwise see model selection.
            nb_column_clusters,  # A number of column classes must be specify. Otherwise see model selection.
            n_init=n_init,  # Specifying the number of initializations to perform.
            n_iter_early_stop=n_iter_early_stop,  # Specifying the number of EM-steps to perform on each init.
            n_init_total_run=n_init_total_run,  # Specifying the number inits to keep and to train until convergence.
            verbosity=1,  # Either 0, 1 or 2. Higher value display more information to the user.
            gpu_index=gpu_index,
        )
        cupy.random.seed(seed)
        np.random.seed(seed)

        start_time_not_sparse = time.time()
        model.fit(np.array(graph.todense()))
        end_time_not_sparse = time.time() - start_time_not_sparse

        row_ari_not_sparse = ARI(row_clusters_index, model.row_labels)
        column_ari_not_sparse = ARI(column_clusters_index, model.column_labels)
        co_ari_not_sparse = CARI(
            row_clusters_index,
            column_clusters_index,
            model.row_labels,
            model.column_labels,
        )
        print(end_time_not_sparse)
        print(f"coari not sparse {co_ari_not_sparse}")

    else:
        end_time_not_sparse = None
        row_ari_not_sparse = None
        column_ari_not_sparse = None
        co_ari_not_sparse = None

    print("Training sparse")
    # instantiate the Latent Block Model class.
    model2 = sparsebm.LBM(
        nb_row_clusters,  # A number of row classes must be specify. Otherwise see model selection.
        nb_column_clusters,  # A number of column classes must be specify. Otherwise see model selection.
        n_init=n_init,  # Specifying the number of initializations to perform.
        n_iter_early_stop=n_iter_early_stop,  # Specifying the number of EM-steps to perform on each init.
        n_init_total_run=n_init_total_run,  # Specifying the number inits to keep and to train until convergence.
        verbosity=1,  # Either 0, 1 or 2. Higher value display more information to the user.
        gpu_index=gpu_index,
    )
    cupy.random.seed(seed)
    np.random.seed(seed)

    start_time = time.time()
    model2.fit(graph)
    end_time = time.time() - start_time

    row_ari = ARI(row_clusters_index, model2.row_labels)
    column_ari = ARI(column_clusters_index, model2.column_labels)
    co_ari = CARI(
        row_clusters_index,
        column_clusters_index,
        model2.row_labels,
        model2.column_labels,
    )
    print(end_time)
    print(f"coari {co_ari}")

    results = {
        "dataset_file": dataset_file,
        "seed": seed,
        "exponent": exponent,
        #
        "row_ari_not_sparse": row_ari_not_sparse,
        "row_ari": row_ari,
        #
        "column_ari_not_sparse": column_ari_not_sparse,
        "column_ari": column_ari,
        #
        "co_ari_not_sparse": co_ari_not_sparse,
        "co_ari": co_ari,
        #
        "end_time_not_sparse": end_time_not_sparse,
        "end_time": end_time,
        #
        "model": {
            "pi": model2.pi_,
            "alpha_1": model2.alpha_1_,
            "alpha_2": model2.alpha_2_,
            "tau_1": model2.tau_1_,
            "tau_2": model2.tau_2_,
        },
    }

    if not_sparse:
        results["model_not_sparse"] = (
            {
                "pi": model.pi_,
                "alpha_1": model.alpha_1_,
                "alpha_2": model.alpha_2_,
                "tau_1": model.tau_1_,
                "tau_2": model.tau_2_,
            },
        )
    pickle.dump(
        results,
        open(
            "./experiments/results/sparsity_fixed/" + dataset_file.split("/")[-1],
            "wb",
        ),
    )


for f in f_prefix:
    dataset_files = glob.glob("./experiments/data/sparsity_fixed/" + f + "_*.pkl")
    if (
        int(f.split("_", maxsplit=1)[0]) > limit_size_accepted_by_gpu_sparse
    ):  # Preserve GPU OOM
        continue
    not_sparse = (
        int(f.split("_", maxsplit=1)[0]) <= limit_size_accepted_by_gpu
    )  # Preserve GPU OOM
    for dataset_file in dataset_files:
        train_with_both_model(dataset_file, gpu_index, not_sparse)
