from typing import Generator, List


def get_stations() -> Generator[List[str], None, None]:
    """Get an iterable data for all stations around the world.

    Yields:
        [List[str]]: the data of the station.
    """
    for stn in STATIONS:
        yield stn


# Information of every station as a List[List[str]]
# ['NAME', 'ICAO', 'IATA', 'SYNOP', 'LAT', 'LONG', 'ELEV', 'COUNTRY']
STATIONS: List[List[str]] = [
    ["AK ADAK NAS", "PADK", "ADK", "70454", "51.53N", "176.39W", "4", "US"],
    ["AK AKHIOK", "PAKH", "AKK", "None", "56.56N", "154.11W", "14", "US"],
    ["AK AKUTAN", "PAUT", "None", "None", "54.09N", "165.36W", "25", "US"],
    ["AK AMBLER", "PAFM", "AFM", "None", "67.06N", "157.51W", "88", "US"],
    ["AK ANAKTUVUK PASS", "PAKP", "AKP", "None", "68.08N", "151.44W", "642", "US"],
    ["AK ANCHORAGE INTL", "PANC", "ANC", "70273", "61.10N", "150.01W", "38", "US"],
    ["AK ANCHORAGE/WFO", "PAFC", "AFC", "None", "61.10N", "150.02W", "48", "US"],
    ["AK ANCHORAG/NIKISKI", "PAHG", "AHG", "None", "60.44N", "151.21W", "74", "US"],
    ["AK ANCHORAGE/LAKE H", "PALH", "LHD", "None", "61.11N", "149.58W", "22", "US"],
    ["AK ANCHORAGE/ARTCC", "PZAN", "ZAN", "None", "61.10N", "149.59W", "22", "US"],
    ["AK ANCHORAGE/MERRIL", "PAMR", "MRI", "None", "61.13N", "149.51W", "41", "US"],
    ["AK ANGOON SEAPLANE", "PAGN", "None", "None", "57.30N", "134.35W", "2", "US"],
    ["AK ANIAK", "PANI", "ANI", "70232", "61.35N", "159.32W", "26", "US"],
    ["AK ANNETTE ISLAND", "PANT", "ANN", "70398", "55.02N", "131.34W", "36", "US"],
    ["AK ANVIK", "PANV", "ANV", "None", "62.39N", "160.11W", "99", "US"],
    ["AK ARCTIC VILLAGE", "PARC", "ARC", "None", "68.07N", "145.35W", "636", "US"],
    ["AK ATQASUK BURNELL", "PATQ", "ATK", "None", "70.28N", "157.26W", "29", "US"],
    ["AK ATKA", "PAAK", "AKA", "None", "52.13N", "174.12W", "17", "US"],
    ["AK BARROW", "PABR", "BRW", "70026", "71.17N", "156.48W", "7", "US"],
    ["AK BARROW ARM-NSA", "None", "None", "70027", "71.19N", "156.37W", "7", "US"],
    ["AK BARTER ISLAND", "PABA", "BTI", "70086", "70.08N", "143.35W", "2", "US"],
    ["AK BETHEL", "PABE", "BET", "70219", "60.47N", "161.51W", "41", "US"],
    ["AK BETHEL/88D", "PABC", "ABC", "None", "60.48N", "161.53W", "49", "US"],
    ["AK BETTLES", "PABT", "BTT", "70174", "66.55N", "151.31W", "195", "US"],
    ["AK BIG RIVER LAKES", "PALV", "LVR", "None", "60.49N", "152.18W", "12", "US"],
    ["AK BIRCHWOOD", "PABV", "BCV", "None", "61.25N", "149.31W", "29", "US"],
    ["AK BREVIG_MISSION", "PFKT", "None", "None", "65.20N", "166.28W", "9", "US"],
    ["AK BUCKLAND", "PABL", "BVK", "None", "65.59N", "161.09W", "7", "US"],
    ["AK CANTWELL", "PATW", "TTW", "None", "63.23N", "148.57W", "668", "US"],
    ["AK CAPE LISBURNE", "PALU", "LUR", "70104", "68.53N", "166.08W", "3", "US"],
    ["AK CAPE NEWENHAM", "PAEH", "EHM", "70305", "58.39N", "162.04W", "161", "US"],
    ["AK CAPE ROMANZOF", "PACZ", "CZF", "70212", "61.47N", "166.02W", "146", "US"],
    ["AK CENTRAL", "PARL", "None", "None", "65.34N", "144.47W", "284", "US"],
    ["AK CENTRAL", "PACE", "None", "None", "65.34N", "144.47W", "286", "US"],
    ["AK CENTRAL AK PROF", "None", "CEN", "70197", "65.30N", "144.41W", "259", "US"],
    ["AK CHANDALAR LAKE", "PALR", "WCR", "None", "67.30N", "148.29W", "585", "US"],
    ["AK CHEVAK", "PAVA", "None", "None", "61.32N", "165.36W", "23", "US"],
    ["AK CHIGNIK BAY", "PAJC", "AJC", "None", "56.19N", "158.22W", "15", "US"],
    ["AK CIRCLE/PAFC RFC", "PACR", "CRC", "None", "65.50N", "144.04W", "182", "US"],
    ["AK CLARKS POINT", "PFCL", "CLP", "None", "58.50N", "158.32W", "24", "US"],
    ["AK COLD BAY", "PACD", "CDB", "70316", "55.12N", "162.43W", "30", "US"],
    ["AK CORDOVA", "PACV", "CDV", "70296", "60.30N", "145.30W", "12", "US"],
    ["AK DEADHORSE", "PASC", "SCC", "None", "70.12N", "148.28W", "15", "US"],
    ["AK DEERING", "PADE", "DEE", "None", "66.04N", "162.46W", "5", "US"],
    ["AK DELTA JUNCTION", "PABI", "BIG", "70267", "64.00N", "145.44W", "386", "US"],
    ["AK DILLINGHAM", "PADL", "DLG", "70321", "59.03N", "158.31W", "26", "US"],
    ["AK EAGLE", "PAEG", "EAA", "None", "64.47N", "141.09W", "268", "US"],
    ["AK EARECKSON/SHEMYA", "PASY", "SYA", "70414", "52.43N", "174.07E", "31", "US"],
    ["AK EGEGIK", "PAII", "EII", "None", "58.11N", "157.23W", "30", "US"],
    ["AK EIELSON AFB", "PAEI", "EIL", "70265", "64.40N", "147.06W", "167", "US"],
    ["AK ELFIN COVE", "PAEL", "ELV", "None", "58.12N", "136.21W", "3", "US"],
    ["AK ELIM APRT", "PFEL", "None", "None", "64.37N", "162.16W", "49", "US"],
    ["AK ELMENDORF AFB", "PAED", "EDF", "70272", "61.15N", "149.48W", "59", "US"],
    ["AK EMMONAK", "PAEM", "ENM", "None", "62.46N", "164.31W", "3", "US"],
    ["AK EUREKA", "PAZK", "AZK", "None", "61.56N", "147.10W", "1003", "US"],
    ["AK FAIRBANKS", "PAFA", "FAI", "70261", "64.48N", "147.53W", "132", "US"],
    ["AK FAIRBANKS/WFO", "PAFG", "AFG", "None", "64.48N", "147.53W", "140", "US"],
    ["AK FALSE PASS", "PAKF", "None", "None", "54.51N", "163.25W", "6", "US"],
    ["AK FRBNKS/PEDRO DOM", "PAPD", "APD", "None", "65.02N", "147.30W", "790", "US"],
    ["AK FAREWELL LAKE", "PAFK", "FKK", "70248", "62.32N", "153.36W", "321", "US"],
    ["AK FORT RICHARDSON", "PAFR", "FRN", "70270", "61.16N", "149.39W", "115", "US"],
    ["AK FORT WAINWRIGHT", "PAFB", "FBK", "None", "64.50N", "147.37W", "137", "US"],
    ["AK FORT YUKON", "PAFY", "None", "70194", "66.34N", "145.16W", "131", "US"],
    ["AK FORT YUKON", "PFYU", "FYU", "None", "66.34N", "145.16W", "131", "US"],
    ["AK FUNTER BAY", "PAFN", "FNR", "None", "58.15N", "134.54W", "9", "US"],
    ["AK GALBRAITH LAKE", "PAGB", "GBH", "None", "68.29N", "149.29W", "811", "US"],
    ["AK GALENA", "PAGA", "GAL", "70222", "64.44N", "156.56W", "46", "US"],
    ["AK GAMBELL", "PAGM", "GAM", "70204", "63.46N", "171.44W", "8", "US"],
    ["AK GLENNALLEN PROF", "None", "GNA", "70268", "62.07N", "145.58W", "564", "US"],
    ["AK GOLOVIN", "PAGL", "N93", "None", "64.33N", "163.02W", "8", "US"],
    ["AK GULKANA", "PAGK", "GKN", "70271", "62.09N", "145.27W", "481", "US"],
    ["AK GUSTAVUS", "PAGS", "GST", "70367", "58.25N", "135.44W", "9", "US"],
    ["AK HAINES", "PAHN", "HNS", "None", "59.15N", "135.31W", "5", "US"],
    ["AK HAYES RIVER", "PAHZ", "HZZ", "None", "61.59N", "152.05W", "305", "US"],
    ["AK HEALY", "PAHV", "HRR", "None", "63.50N", "149.00W", "396", "US"],
    ["AK HOLY CROSS", "PAHC", "HCA", "None", "62.11N", "159.47W", "21", "US"],
    ["AK HOMER", "PAHO", "HOM", "70341", "59.38N", "151.30W", "28", "US"],
    ["AK HOONAH", "PAOH", "HNH", "None", "58.06N", "135.27W", "9", "US"],
    ["AK HOOPER BAY", "PAHP", "HPB", "None", "61.32N", "166.09W", "5", "US"],
    ["AK HUSLIA", "PAHS", "HSL", "None", "65.42N", "156.23W", "55", "US"],
    ["AK HUSLIA", "PAHL", "None", "None", "65.42N", "156.21W", "65", "US"],
    ["AK HYDABURG", "PAHY", "HYG", "None", "55.12N", "132.50W", "1", "US"],
    ["AK IGIUGIG", "PAIG", "None", "None", "59.19N", "155.54W", "28", "US"],
    ["AK ILIAMNA", "PAIL", "ILI", "70340", "59.45N", "154.55W", "49", "US"],
    ["AK INDIAN MOUNTAIN", "PAIM", "UTO", "70173", "66.00N", "153.42W", "389", "US"],
    ["AK JUNEAU", "PAJN", "JNU", "70381", "58.22N", "134.35W", "5", "US"],
    ["AK JUNEAU/WFO", "PAJK", "AJK", "None", "58.22N", "134.34W", "7", "US"],
    ["AK KAKE", "PAFE", "AFE", "None", "56.58N", "133.55W", "9", "US"],
    ["AK KALSKAG", "PALG", "KLG", "None", "61.32N", "160.20W", "17", "US"],
    ["AK KALTAG", "PAKV", "KAL", "None", "64.20N", "158.45W", "61", "US"],
    ["AK KENAI", "PAEN", "ENA", "70259", "60.34N", "151.15W", "27", "US"],
    ["AK KETCHIKAN", "PAKT", "KTN", "70395", "55.21N", "131.42W", "28", "US"],
    ["AK KIANA", "PAIK", "None", "None", "66.59N", "160.26W", "51", "US"],
    ["AK KING COVE", "PAVC", "None", "None", "55.07N", "162.16W", "47", "US"],
    ["AK KING SALMON", "PAKN", "AKN", "70326", "58.41N", "156.39W", "17", "US"],
    ["AK KING SALMON/88D", "PAKC", "AKC", "None", "58.41N", "156.38W", "19", "US"],
    ["AK KING SALMON AFS", "KQRC", "QRC", "None", "58.41N", "156.38W", "15", "US"],
    ["AK KIPNUK", "PAKI", "IIK", "None", "59.56N", "164.02W", "4", "US"],
    ["AK KIVALINA", "PAVL", "KVL", "None", "67.44N", "164.33W", "3", "US"],
    ["AK KLAWOCK", "PAKW", "AKW", "None", "55.35N", "133.04W", "15", "US"],
    ["AK KODIAK", "PADQ", "ADQ", "70350", "57.45N", "152.30W", "34", "US"],
    ["AK KODIAK", "PAKD", "KDK", "None", "57.48N", "152.22W", "42", "US"],
    ["AK KOLIGANEK", "PAJZ", "JZZ", "None", "59.44N", "157.16W", "82", "US"],
    ["AK KOTZEBUE", "PAOT", "OTZ", "70133", "66.52N", "162.35W", "3", "US"],
    ["AK KOYUK", "PAKK", "KKA", "None", "64.56N", "161.09W", "47", "US"],
    ["AK KUPARUK", "PAKU", "UBW", "None", "70.19N", "149.35W", "2", "US"],
    ["AK KWETHLUK", "PFKW", "None", "None", "60.48N", "161.26W", "8", "US"],
    ["AK MANLEY HOT SPRIN", "PAML", "MLY", "None", "65.00N", "150.39W", "81", "US"],
    ["AK MANOKOTAK", "PAMB", "MBA", "None", "58.59N", "159.03W", "16", "US"],
    ["AK MARSHALL", "PADM", "None", "None", "61.52N", "162.02W", "31", "US"],
    ["AK MCCARTHY", "PAMX", "15Z", "None", "61.26N", "142.55W", "455", "US"],
    ["AK MCGRATH", "PAMC", "MCG", "70231", "62.58N", "155.37W", "103", "US"],
    ["AK MCKINLEY PARK", "PAIN", "INR", "None", "63.44N", "148.55W", "524", "US"],
    ["AK MEKORYUK", "PAMY", "MYU", "None", "60.22N", "166.16W", "13", "US"],
    ["AK METLAKATLA", "PAMM", "MTM", "None", "55.08N", "131.35W", "1", "US"],
    ["AK MIDDLETON ISLAND", "PAMD", "MDO", "70343", "59.26N", "146.18W", "14", "US"],
    ["AK MIDDLETON IS 88D", "PAIH", "AIH", "None", "59.28N", "146.18W", "20", "US"],
    ["AK MINCHUMINA", "PAMH", "MHM", "70246", "63.54N", "152.19W", "214", "US"],
    ["AK MOUNTAIN VILLAGE", "PAMO", "MOU", "None", "62.06N", "163.41W", "103", "US"],
    ["AK NABESNA", "PABN", "IBN", "None", "62.24N", "143.00W", "880", "US"],
    ["AK NELSON LAGOON", "PAOU", "None", "None", "56.00N", "161.10W", "4", "US"],
    ["AK NENANA", "PANN", "ENN", "70260", "64.33N", "149.05W", "110", "US"],
    ["AK NEW STUYAHOK", "PANW", "KNW", "None", "59.27N", "157.22W", "92", "US"],
    ["AK NIKOLAI", "PAFS", "FSP", "None", "63.01N", "154.21W", "126", "US"],
    ["AK NOME", "PAOM", "OME", "70200", "64.30N", "165.26W", "11", "US"],
    ["AK NOME/88D/PAEC", "None", "None", "None", "64.31N", "165.18W", "16", "US"],
    ["AK CHULITNA", "PAEC", "AEC", "None", "62.53N", "149.50W", "381", "US"],
    ["AK NAPAKIAK", "PANA", "None", "None", "60.41N", "161.59W", "5", "US"],
    ["AK NORTHWAY", "PAOR", "ORT", "70291", "62.58N", "141.56W", "523", "US"],
    ["AK NOATAK", "PAWN", "WTK", "None", "67.34N", "162.59W", "30", "US"],
    ["AK NOORVIK", "PFNO", "D76", "None", "66.49N", "161.01W", "17", "US"],
    ["AK NUIQSUT", "PAQT", "AQT", "None", "70.13N", "151.00W", "12", "US"],
    ["AK NUIQSUT VILLAGE", "PALP", "None", "None", "70.20N", "150.56W", "5", "US"],
    ["AK NUNAPITCHUK", "PPIT", "16A", "None", "60.54N", "162.26W", "7", "US"],
    ["AK OLIKTOK POINT", "POLI", "OLI", "70063", "70.30N", "149.53W", "5", "US"],
    ["AK PALMER", "PAAQ", "PAQ", "70274", "61.36N", "149.05W", "73", "US"],
    ["AK PAXSON", "PAXK", "PXK", "None", "63.02N", "145.30W", "809", "US"],
    ["AK PETERSBURG", "PAPG", "PSG", "70386", "56.49N", "132.58W", "15", "US"],
    ["AK PILOT POINT", "PAPN", "PNP", "None", "57.35N", "157.34W", "18", "US"],
    ["AK PLATINUM", "PAPM", "PTU", "None", "59.01N", "161.49W", "5", "US"],
    ["AK POINT HOPE", "PAPO", "PHO", "None", "68.21N", "166.48W", "6", "US"],
    ["AK POINT LAY", "PPIZ", "PIZ", "70121", "69.44N", "163.00W", "8", "US"],
    ["AK PORT ALEXANDER", "PAAP", "AHP", "None", "56.14N", "134.39W", "6", "US"],
    ["AK PORT ALSWORTH", "PALJ", "TPO", "None", "60.12N", "154.18W", "81", "US"],
    ["AK PORT CLARENCE", "PAPC", "KPC", "70119", "65.15N", "166.51W", "3", "US"],
    ["AK PORT HEIDEN", "PAPH", "PTH", "70333", "56.57N", "158.37W", "29", "US"],
    ["AK PORTAGE GLACIER", "PATO", "POR", "None", "60.47N", "148.51W", "31", "US"],
    ["AK PROSPECT CREEK", "PAPR", "PPC", "None", "66.49N", "150.39W", "335", "US"],
    ["AK PRUDHOE BAY", "PAUD", "PUO", "None", "70.15N", "148.20W", "12", "US"],
    ["AK PUNTILLA LAKE", "PAPT", "PTI", "70249", "62.06N", "152.43W", "558", "US"],
    ["AK QUINHAGAK", "PAQH", "None", "None", "59.45N", "161.51W", "13", "US"],
    ["AK REG DOG", "PARD", "None", "None", "68.02N", "162.54W", "297", "US"],
    ["AK REG DOG", "PADG", "DGG", "None", "68.02N", "162.54W", "297", "US"],
    ["AK RUBY", "PARY", "RBY", "None", "64.44N", "155.28W", "199", "US"],
    ["AK RUSSIAN MISSION", "PARS", "RSH", "None", "61.46N", "161.19W", "16", "US"],
    ["AK SAINT MARYS", "PASM", "KSM", "None", "62.04N", "163.18W", "92", "US"],
    ["AK SAND POINT", "PASD", "SDP", "None", "55.20N", "160.30W", "7", "US"],
    ["AK SAVOONGA", "PASA", "SVA", "None", "63.41N", "170.30W", "16", "US"],
    ["AK SCAMMON BAY", "PACM", "SCM", "None", "61.51N", "165.34W", "4", "US"],
    ["AK SELAWIK", "PASK", "WLK", "None", "66.36N", "160.00W", "8", "US"],
    ["AK SELDOVIA", "PASO", "SOV", "None", "59.27N", "151.42W", "9", "US"],
    ["AK SEWARD", "PAWD", "SWD", "70277", "60.07N", "149.25W", "23", "US"],
    ["AK SHAGELUK", "PAHX", "None", "None", "62.42N", "159.34W", "24", "US"],
    ["AK SHAKTOOLIK", "PFSH", "2C7", "None", "64.22N", "161.13W", "7", "US"],
    ["AK SHISHMAREF", "PASH", "SHH", "None", "66.16N", "166.05W", "2", "US"],
    ["AK SHUNGNAK", "PAGH", "SHG", "None", "66.53N", "157.10W", "60", "US"],
    ["AK SITKA", "PASI", "SIT", "70371", "57.04N", "135.21W", "5", "US"],
    ["AK SITKA/BIORKA/88D", "PACG", "ACG", "None", "56.51N", "135.32W", "63", "US"],
    ["AK SKAGWAY", "PAGY", "SGY", "70362", "59.28N", "135.18W", "5", "US"],
    ["AK SKWENTNA", "PASW", "SKW", "70255", "61.58N", "151.12W", "48", "US"],
    ["AK SLANA", "PADT", "DDT", "None", "62.43N", "143.51W", "730", "US"],
    ["AK SLEETMUTE", "PASL", "SLQ", "None", "61.43N", "157.09W", "55", "US"],
    ["AK SNOWSHOE LAKE", "PALK", "LLK", "None", "62.02N", "142.40W", "735", "US"],
    ["AK SOLDOTNA", "PASX", "SXQ", "None", "60.29N", "151.02W", "32", "US"],
    ["AK SOUTH NAKNEK", "PFWS", "None", "None", "58.42N", "157.00W", "49", "US"],
    ["AK SPARREVOHN", "PASV", "SVW", "70235", "61.06N", "155.34W", "484", "US"],
    ["AK ST GEORGE", "PAPB", "PBV", "None", "56.35N", "169.40W", "35", "US"],
    ["AK ST MICHAEL", "PAMK", "None", "None", "63.29N", "162.07W", "28", "US"],
    ["AK ST PAUL ISLAND", "PASN", "SNP", "70308", "57.09N", "170.13W", "29", "US"],
    ["AK STONY RIVER LAND", "PAER", "ERW", "None", "61.16N", "153.48W", "345", "US"],
    ["AK SUTTON", "PAJV", "JVM", "None", "61.43N", "148.53W", "263", "US"],
    ["AK TAHNETNA PASS LO", "PASP", "SMU", "None", "61.49N", "147.33W", "799", "US"],
    ["AK TALKEETNA", "PATK", "TKA", "70251", "62.18N", "150.06W", "109", "US"],
    ["AK TALKEETNA PROF", "None", "TLK", "70252", "62.19N", "150.25W", "137", "US"],
    ["AK TANANA", "PATA", "TAL", "70178", "65.10N", "152.06W", "67", "US"],
    ["AK TATALINA AFS", "PATL", "TLJ", "None", "62.54N", "155.58W", "294", "US"],
    ["AK TELLER", "PATE", "None", "None", "65.14N", "166.20W", "90", "US"],
    ["AK POINT THOMPSON", "PAAD", "None", "None", "70.08N", "146.17W", "8", "US"],
    ["AK TIN CITY AFS", "PATC", "TNC", "70117", "65.34N", "167.55W", "83", "US"],
    ["AK TOGIAK", "PATG", "TOG", "None", "59.03N", "160.23W", "4", "US"],
    ["AK TOKSOOK BAY", "PAOO", "None", "None", "60.32N", "165.07W", "18", "US"],
    ["AK UMIAT", "PAUM", "UMT", "70162", "69.22N", "152.08W", "104", "US"],
    ["AK UNALAKLEET", "PAUN", "UNK", "70207", "63.53N", "160.48W", "6", "US"],
    ["AK DUTCH HARBOR", "PADU", "DUT", "70489", "53.54N", "166.32W", "4", "US"],
    ["AK VALDEZ", "PAVD", "VDZ", "None", "61.08N", "146.15W", "37", "US"],
    ["AK VALDEZ WSO", "PAVW", "VWS", "70275", "61.08N", "146.21W", "11", "US"],
    ["AK WAINWRIGHT", "PAWI", "AWI", "70030", "70.37N", "159.51W", "27", "US"],
    ["AK WALES", "PAIW", "None", "None", "65.37N", "168.06W", "7", "US"],
    ["AK WASILLA", "PAWS", "IYS", "None", "61.34N", "149.32W", "107", "US"],
    ["AK WHITE MOUNTAIN", "PAWM", "WMO", "None", "64.41N", "163.25W", "82", "US"],
    ["AK WHITTIER", "PAWR", "IEM", "None", "60.47N", "148.43W", "47", "US"],
    ["AK WILLOW", "PAUO", "UUO", "None", "61.45N", "150.03W", "69", "US"],
    ["AK WOLVERINE ROAD", "PAIZ", "IZY", "None", "61.38N", "149.02W", "236", "US"],
    ["AK WRANGELL", "PAWG", "WRG", "70387", "56.29N", "132.22W", "11", "US"],
    ["AK YAKUTAT", "PAYA", "YAK", "70361", "59.31N", "139.40W", "11", "US"],
    ["AK ALASKAN ARTCC", "PZ74", "Z74", "None", "60.09N", "164.17W", "1", "US"],
    ["AK ALASKAN ARTCC", "PZ76", "Z76", "None", "65.15N", "134.39W", "647", "US"],
    ["AL ALABASTER", "KEET", "EET", "None", "33.11N", "086.47W", "173", "US"],
    ["AL ALBERTVILLE MUNI", "K8A0", "8A0", "None", "34.14N", "086.15W", "315", "US"],
    ["AL ALEXANDER/RUSSEL", "KALX", "ALX", "None", "32.55N", "085.58W", "209", "US"],
    ["AL ANDALUSIA/OPP AR", "K79J", "79J", "None", "31.19N", "086.24W", "94", "US"],
    ["AL ANNISTON", "KANB", "ANB", "None", "33.35N", "085.51W", "183", "US"],
    ["AL AUBURN UNIV. (AM", "KAUB", "AUB", "None", "32.36N", "085.30W", "198", "US"],
    ["AL AUBURN OPELIKA A", "KAUO", "AUO", "None", "32.37N", "085.25W", "236", "US"],
    ["AL BESSEMER", "KEKY", "EKY", "None", "33.19N", "086.56W", "214", "US"],
    ["AL BIRMINGHAM", "KBHM", "BHM", "72228", "33.34N", "086.45W", "197", "US"],
    ["AL BRMNGHM/ALABASTR", "KBMX", "BMX", "72230", "33.10N", "086.46W", "197", "US"],
    ["AL OZARK/CAIRNS AAF", "KOZR", "OZR", "None", "31.17N", "085.43W", "93", "US"],
    ["AL CENTREVILLE WSM", "K0A8", "0A8", "72229", "32.56N", "087.05W", "77", "US"],
    ["AL COURTLAND", "K9A4", "9A4", "None", "34.40N", "087.21W", "179", "US"],
    ["AL CULLMAN/FOLSOM F", "K3A1", "3A1", "None", "34.16N", "086.51W", "294", "US"],
    ["AL CULLMAN/FOLSOM F", "KCMD", "CMD", "None", "34.16N", "086.51W", "294", "US"],
    ["AL DECATUR", "KDCU", "DCU", "None", "34.39N", "086.57W", "176", "US"],
    ["AL DEMOPOLIS", "KDYA", "DYA", "None", "32.28N", "087.57W", "34", "US"],
    ["AL DOTHAN", "KDHN", "DHN", "None", "31.19N", "085.27W", "113", "US"],
    ["AL ENTERPRISE", "KEDN", "EDN", "None", "31.18N", "085.54W", "110", "US"],
    ["AL EUFAULA", "KEUF", "EUF", "None", "31.57N", "085.08W", "87", "US"],
    ["AL EVERGREEN", "KGZH", "GZH", "None", "31.25N", "087.03W", "78", "US"],
    ["AL FAIRHOPE", "KCQF", "CQF", "None", "30.28N", "087.53W", "28", "US"],
    ["AL FLORALA MUNI", "K0J4", "0J4", "None", "31.03N", "086.19W", "96", "US"],
    ["AL FT PAYNE/ISBELL", "K4A9", "4A9", "None", "34.28N", "085.43W", "267", "US"],
    ["AL FT RUCKER 88D", "KEOX", "EOX", "None", "31.28N", "085.28W", "132", "US"],
    ["AL FT RUCKER/SHELL", "KSXS", "SXS", "None", "31.22N", "085.51W", "122", "US"],
    ["AL FT RUCKER/HANCHE", "KHEY", "HEY", "None", "31.21N", "085.39W", "97", "US"],
    ["AL GADSDEN MUNI", "KGAD", "GAD", "None", "33.58N", "086.04W", "173", "US"],
    ["AL GREENVILLE", "KPRN", "PRN", "None", "31.51N", "086.37W", "138", "US"],
    ["AL GULF SHORES", "KJKA", "JKA", "None", "30.17N", "087.40W", "5", "US"],
    ["AL HALEYVILLE", "K1M4", "1M4", "None", "34.17N", "087.36W", "284", "US"],
    ["AL HUNTSVILLE", "KHSV", "HSV", "72323", "34.39N", "086.47W", "191", "US"],
    ["AL HUNTSVILLE/WFO", "KHUN", "None", "None", "34.43N", "086.39W", "191", "US"],
    ["AL HUNTSVILLE/MADIS", "KMDQ", "MDQ", "None", "34.52N", "086.33W", "230", "US"],
    ["AL HYTOP/88D", "KHTX", "HTX", "None", "34.56N", "086.05W", "536", "US"],
    ["AL JASPER/WALKER", "KJFX", "JFX", "None", "33.54N", "087.19W", "148", "US"],
    ["AL LOWE AHP/FT. RUC", "KLOR", "LOR", "None", "31.21N", "085.45W", "74", "US"],
    ["AL MAXWELL AFB 88D", "KMXX", "MXX", "None", "32.32N", "085.47W", "122", "US"],
    ["AL MAXWELL AFB/MGM", "KMXF", "MXF", "None", "32.22N", "086.22W", "51", "US"],
    ["AL MARION", "KA08", "A08", "None", "32.31N", "087.23W", "68", "US"],
    ["AL MOBILE/BROOKLEY", "KBFM", "BFM", "None", "30.37N", "088.04W", "20", "US"],
    ["AL MOBILE/BATES", "KMOB", "MOB", "72223", "30.41N", "088.15W", "63", "US"],
    ["AL MONTGOMERY", "KMGM", "MGM", "72226", "32.18N", "086.24W", "63", "US"],
    ["AL MUSCLE SHOAL", "KMSL", "MSL", "None", "34.45N", "087.36W", "164", "US"],
    ["AL MONROEVILLE", "KMVC", "MVC", "None", "31.27N", "087.21W", "128", "US"],
    ["AL PELL CITY", "KPLR", "PLR", "None", "33.34N", "086.15W", "148", "US"],
    ["AL PHI OIL PLAT", "KRAM", "RAM", "None", "29.03N", "088.05W", "10", "US"],
    ["AL PRATTVILLE", "K1A9", "1A9", "None", "32.26N", "086.31W", "69", "US"],
    ["AL REDSTONE ARSENAL", "KHUA", "HUA", "74001", "34.41N", "086.41W", "209", "US"],
    ["AL SCOTTSBORO", "K4A6", "4A6", "None", "34.41N", "086.00W", "198", "US"],
    ["AL SELMA", "KSEM", "SEM", "None", "32.21N", "086.59W", "51", "US"],
    ["AL SEMMNES VOR", "KSJI", "SJI", "None", "30.44N", "088.22W", "63", "US"],
    ["AL SYLACAUGA", "KSCD", "SCD", "None", "33.10N", "086.18W", "174", "US"],
    ["AL TALLADEGA", "KASN", "ASN", "None", "33.34N", "086.03W", "162", "US"],
    ["AL TROY", "KTOI", "TOI", "None", "31.51N", "086.01W", "118", "US"],
    ["AL TUSCALOOSA", "KTCL", "TCL", "None", "33.13N", "087.37W", "49", "US"],
    ["AL VULCAN VOR", "KVUZ", "VUZ", "None", "33.40N", "086.54W", "250", "US"],
    ["AL CENTREVILLE WSM", "KCKL", "CKL", "None", "32.53N", "087.15W", "140", "US"],
    ["AL DAUPHIN ISLAND", "K4R9", "4R9", "99442", "30.16N", "088.08W", "2", "US"],
    ["AL FAIRHOPE", "K4R4", "4R4", "None", "30.28N", "087.53W", "28", "US"],
    ["AL HUNTSVILLE/MADIS", "KM82", "M82", "None", "34.51N", "086.33W", "231", "US"],
    ["AL VIOSCA KNOLL768", "KVOA", "VOA", "None", "29.14N", "087.47W", "53", "US"],
    ["AR ARKADELPHIA", "KADF", "ADF", "None", "34.06N", "093.04W", "56", "US"],
    ["AR BATESVILLE", "KBVX", "BVX", "None", "35.44N", "091.39W", "141", "US"],
    ["AR BENTONVILLE", "KH00", "H00", "None", "36.21N", "094.13W", "395", "US"],
    ["AR BENTONVILLE", "KVBT", "VBT", "None", "36.21N", "094.13W", "395", "US"],
    ["AR BENTONVILLE (NW)", "KXNA", "XNA", "None", "36.17N", "094.18W", "392", "US"],
    ["AR BLYTHEVILLE", "KHKA", "HKA", "None", "35.56N", "089.50W", "78", "US"],
    ["AR BLYTHEVILLE", "KBYH", "BYH", "None", "35.58N", "089.57W", "78", "US"],
    ["AR CAMDEN", "KCDH", "CDH", "None", "33.37N", "092.46W", "35", "US"],
    ["AR CLINTON MUNI", "KCCA", "CCA", "None", "35.36N", "092.27W", "157", "US"],
    ["AR CONWAY", "KCXW", "CXW", "None", "35.01N", "092.33W", "85", "US"],
    ["AR CORNING", "K4M9", "4M9", "None", "36.24N", "090.39W", "90", "US"],
    ["AR DE QUEEN", "KDEQ", "DEQ", "None", "34.03N", "094.24W", "106", "US"],
    ["AR DEQUEEN PROFILER", "KDQU", "DQU", "74752", "34.06N", "094.17W", "195", "US"],
    ["AR EL DORADO", "KELD", "ELD", "None", "33.13N", "092.49W", "81", "US"],
    ["AR FAYETTEVILLE", "KFYV", "FYV", "None", "36.01N", "094.10W", "379", "US"],
    ["AR FLIPPIN (AWOS)", "KFLP", "FLP", "None", "36.17N", "092.35W", "219", "US"],
    ["AR FORT SMITH", "KFSM", "FSM", "72344", "35.20N", "094.22W", "140", "US"],
    ["AR SLATINGTON MTN.", "KSRX", "SRX", "None", "35.17N", "094.22W", "195", "US"],
    ["AR HARRISON", "KHRO", "HRO", "None", "36.16N", "093.09W", "417", "US"],
    ["AR HOT SPRINGS", "KHOT", "HOT", "None", "34.29N", "093.06W", "162", "US"],
    ["AR JONESBORO", "KJBR", "JBR", "None", "35.50N", "090.39W", "79", "US"],
    ["AR LITTLE ROCK", "KLIT", "LIT", "None", "34.44N", "092.14W", "79", "US"],
    ["AR LITTLE ROCK AFB", "KLRF", "LRF", "None", "34.55N", "092.09W", "95", "US"],
    ["AR MENA INTERMTN", "KMEZ", "MEZ", "None", "34.33N", "094.12W", "329", "US"],
    ["AR W MEMPHIS MUNI", "KAWM", "AWM", "None", "35.08N", "090.14W", "65", "US"],
    ["AR MONTICELLO", "KLLQ", "LLQ", "None", "33.38N", "091.45W", "83", "US"],
    ["AR MOUNT IDA", "KMWT", "MWT", "None", "34.33N", "093.35W", "214", "US"],
    ["AR MOUNTAIN HOME", "KBPK", "BPK", "None", "36.22N", "092.28W", "280", "US"],
    ["AR N. LITTLE ROCK", "KLZK", "LZK", "72340", "34.50N", "092.16W", "173", "US"],
    ["AR NEWPORT", "KM19", "M19", "None", "35.39N", "091.10W", "73", "US"],
    ["AR PINE BLUFF/GRIDR", "KPBF", "PBF", "None", "34.11N", "091.56W", "62", "US"],
    ["AR RAZORBACK VOR", "KRZC", "RZC", "None", "36.15N", "094.07W", "443", "US"],
    ["AR ROGERS", "KROG", "ROG", "None", "36.22N", "094.05W", "415", "US"],
    ["AR RUSSELLVILLE", "KRUE", "RUE", "None", "35.15N", "093.06W", "115", "US"],
    ["AR SEARCY", "KSRC", "SRC", "None", "35.13N", "091.44W", "80", "US"],
    ["AR SILOAM SPRING", "KSLG", "SLG", "None", "36.12N", "094.28W", "300", "US"],
    ["AR SPRINGDALE MUNI", "KASG", "ASG", "None", "36.10N", "094.07W", "412", "US"],
    ["AR STUTTGART", "KSGT", "SGT", "None", "34.36N", "091.34W", "68", "US"],
    ["AR TEXARKANA", "KTXK", "TXK", "None", "33.27N", "093.59W", "111", "US"],
    ["AR WALNUT RIDGE", "KARG", "ARG", "None", "36.07N", "090.55W", "83", "US"],
    ["AR ARKADELPHIA", "KM89", "M89", "None", "34.06N", "093.04W", "56", "US"],
    ["AR FORT CHAFFEE", "None", "None", "69050", "35.10N", "094.48W", "143", "US"],
    ["AR MENA INTERMTN", "KM39", "M39", "None", "34.33N", "094.12W", "329", "US"],
    ["AZ PHOENIX/SKY HRBR", "KPHX", "PHX", "72278", "33.26N", "112.01W", "336", "US"],
    ["AZ TUCSON", "KTUS", "TUS", "None", "32.08N", "110.57W", "776", "US"],
    ["AZ BUCKEYE", "KBXK", "BXK", "None", "33.25N", "112.41W", "315", "US"],
    ["AZ BULLHEAD CITY", "KIFP", "IFP", "None", "35.09N", "114.34W", "212", "US"],
    ["AZ CASA GRANDA", "KCGZ", "CGZ", "None", "32.57N", "111.46W", "446", "US"],
    ["AZ CHANDLER/MESA", "KIWA", "IWA", "None", "33.18N", "111.39W", "412", "US"],
    ["AZ CHANDLER", "KCHD", "CHD", "None", "33.16N", "111.49W", "379", "US"],
    ["AZ COCONINO/FLAGSTF", "KFSX", "FSX", "None", "34.34N", "111.12W", "2261", "US"],
    ["AZ COLORADO CITY", "KAZC", "AZC", "None", "36.58N", "113.01W", "1486", "US"],
    ["AZ COOLIDGE MUNI", "KP08", "P08", "None", "32.56N", "111.26W", "481", "US"],
    ["AZ DAVIS/TUCSON", "KDMA", "DMA", "None", "32.10N", "110.52W", "824", "US"],
    ["AZ DOUGLAS BISBEE", "KDUG", "DUG", "None", "31.28N", "109.35W", "1265", "US"],
    ["AZ FLAGSTAFF", "KFLG", "FLG", "72375", "35.08N", "111.40W", "2134", "US"],
    ["AZ FLAGSTAFF/BELLEM", "KFGZ", "FGZ", "72376", "35.14N", "111.49W", "2192", "US"],
    ["AZ FORT HUACHUCA", "KFHU", "FHU", "72273", "31.35N", "110.21W", "1438", "US"],
    ["AZ GILA BEND (AAF)", "KGXF", "GXF", "74724", "32.52N", "112.43W", "262", "US"],
    ["AZ GLENDALE", "KGEU", "GEU", "None", "33.32N", "112.18W", "325", "US"],
    ["AZ LUKE AFB/GLENDAL", "KLUF", "LUF", "None", "33.31N", "112.22W", "332", "US"],
    ["AZ GOODYEAR MUNICIP", "KGYR", "GYR", "None", "33.25N", "112.22W", "295", "US"],
    ["AZ GRAND CANYON", "KGCN", "GCN", "72378", "35.57N", "112.09W", "2016", "US"],
    ["AZ GRAND CANYON/VAL", "K40G", "40G", "None", "35.38N", "112.09W", "1830", "US"],
    ["AZ KINGMAN", "KIGM", "IGM", "72370", "35.15N", "113.56W", "1032", "US"],
    ["AZ LAKE HAVASU CITY", "KHII", "HII", "None", "34.34N", "114.22W", "238", "US"],
    ["AZ MARANA", "KAVQ", "AVQ", "None", "32.24N", "111.13W", "620", "US"],
    ["AZ MARICOPA AK-CHIN", "KA39", "A39", "None", "32.59N", "111.55W", "398", "US"],
    ["AZ MESA/FALCON FLD", "KFFZ", "FFZ", "None", "33.28N", "111.43W", "424", "US"],
    ["AZ NOGALES", "KOLS", "OLS", "None", "31.25N", "110.51W", "1184", "US"],
    ["AZ PAGE", "KPGA", "PGA", "72371", "36.55N", "111.27W", "1307", "US"],
    ["AZ PAYSON", "KPAN", "PAN", "None", "34.15N", "111.20W", "1572", "US"],
    ["AZ PEACH SPRING", "KPGS", "PGS", "None", "35.37N", "113.32W", "1450", "US"],
    ["AZ PHOENIX/DEER VLY", "KDVT", "DVT", "None", "33.41N", "112.04W", "443", "US"],
    ["AZ PHOENIX/WFO", "KPSR", "PSR", "74626", "33.26N", "112.01W", "342", "US"],
    ["AZ PIMA COUNTY/88D", "KEMX", "EMX", "None", "31.54N", "110.38W", "1586", "US"],
    ["AZ PIONEER AIRFIELD", "KALK", "ALK", "None", "31.36N", "110.26W", "1453", "US"],
    ["AZ PRESCOTT", "KPRC", "PRC", "None", "34.39N", "112.25W", "1524", "US"],
    ["AZ PRESCOTT(VOR)", "KDRK", "DRK", "None", "34.42N", "112.29W", "1524", "US"],
    ["AZ SAFFORD", "KSAD", "SAD", "None", "32.51N", "109.38W", "962", "US"],
    ["AZ SAN SIMON", "KSSO", "SSO", "None", "32.16N", "109.15W", "1097", "US"],
    ["AZ SCOTTSDALE", "KSDL", "SDL", "None", "33.37N", "111.55W", "447", "US"],
    ["AZ SEDONA", "KSEZ", "SEZ", "None", "34.51N", "111.47W", "1473", "US"],
    ["AZ SHOW LOW MUNICIP", "KSOW", "SOW", "None", "34.16N", "110.00W", "1954", "US"],
    ["AZ SPRINGERVILLE", "KJTC", "JTC", "None", "34.08N", "109.19W", "2151", "US"],
    ["AZ ST. JOHNS", "KSJN", "SJN", "None", "34.31N", "109.23W", "1745", "US"],
    ["AZ TUBA CITY", "KTBC", "TBC", "None", "36.07N", "111.16W", "1538", "US"],
    ["AZ TUCSON/WFO", "KTWC", "TWC", "72274", "32.14N", "110.57W", "752", "US"],
    ["AZ TUCSON/RYAN FLD", "KRYN", "RYN", "None", "32.09N", "111.10W", "737", "US"],
    ["AZ WELLTON", "KNOZ", "NOZ", "None", "32.31N", "114.28W", "103", "US"],
    ["AZ WILLIAMS CLARK", "KCMR", "CMR", "None", "35.18N", "112.12W", "2036", "US"],
    ["AZ WINDOW ROCK", "KRQE", "RQE", "None", "35.39N", "109.04W", "2055", "US"],
    ["AZ WINSLOW", "KINW", "INW", "72374", "35.02N", "110.43W", "1490", "US"],
    ["AZ YUMA/88D", "KYUX", "None", "None", "32.30N", "114.39W", "53", "US"],
    ["AZ YUMA INTL", "KYUM", "YUM", "72280", "32.38N", "114.35W", "63", "US"],
    ["AZ YUMA MCAS", "KNYL", "NYL", "69960", "32.38N", "114.37W", "65", "US"],
    ["AZ YUMA PRVG GROUN", "K1Y7", "1Y7", "74004", "32.30N", "114.24W", "231", "US"],
    ["AZ YUMA PRVG GROUN", "None", "None", "69031", "32.30N", "114.24W", "231", "US"],
    ["AZ YUMA (VOR)", "KBZA", "BZA", "None", "32.46N", "114.36W", "63", "US"],
    ["AZ GILA BEND (AAF)", "KGBN", "GBN", "None", "32.52N", "112.43W", "262", "US"],
    ["AZ NOGALES", "K13A", "13A", "None", "31.25N", "110.51W", "1198", "US"],
    ["AZ PAYSON", "K0E4", "0E4", "None", "34.13N", "111.19W", "1498", "US"],
    ["AZ SAFFORD", "KE74", "E74", "None", "32.49N", "109.41W", "900", "US"],
    ["AZ SHOW LOW", "KE03", "E03", "None", "34.15N", "110.02W", "1955", "US"],
    ["AZ TUBA CITY", "KT03", "T03", "None", "36.06N", "111.23W", "1400", "US"],
    ["AZ WINDOW ROCK", "KP34", "P34", "None", "35.39N", "109.04W", "2055", "US"],
    ["CA ALAMEDA NAS", "KNGZ", "NGZ", "74506", "37.46N", "122.19W", "4", "US"],
    ["CA ALTURAS", "KAAT", "AAT", "None", "41.29N", "120.34W", "1331", "US"],
    ["CA APPLE VALLEY", "KAPV", "APV", "None", "34.34N", "117.11W", "934", "US"],
    ["CA ARCATA/EUREKA", "KACV", "ACV", "None", "40.59N", "124.06W", "67", "US"],
    ["CA AUBURN MUNI", "KAUN", "AUN", "None", "38.57N", "121.05W", "467", "US"],
    ["CA AVALON", "KAVX", "AVX", "72292", "33.24N", "118.25W", "482", "US"],
    ["CA BAKERSFIELD", "KBFL", "BFL", "72384", "35.26N", "119.03W", "151", "US"],
    ["CA BAKERSFIELD(VOR)", "KEHF", "EHF", "None", "35.29N", "119.06W", "151", "US"],
    ["CA BEALE AFB/MARYSV", "KBAB", "BAB", "None", "39.07N", "121.25W", "34", "US"],
    ["CA BEALE/ORO DAM", "KBBX", "BBX", "None", "39.30N", "121.38W", "53", "US"],
    ["CA BEAUMONT", "KBUO", "BUO", "None", "33.55N", "116.58W", "692", "US"],
    ["CA BIG BEAR CITY", "KL35", "L35", "None", "34.16N", "116.51W", "2059", "US"],
    ["CA BICYCLE LAKE", "KBYS", "BYS", "74611", "35.17N", "116.37W", "716", "US"],
    ["CA BISHOP", "KBIH", "BIH", "72480", "37.22N", "118.21W", "1253", "US"],
    ["CA BLYTHE", "KBLH", "BLH", "None", "33.37N", "114.43W", "119", "US"],
    ["CA BRIDGEPORT", "KO57", "O57", "None", "38.16N", "119.13W", "1973", "US"],
    ["CA BRIDGEPORT(MCMWT", "KBAN", "None", "None", "38.21N", "119.31W", "2057", "US"],
    ["CA BURBANK", "KBUR", "BUR", "72288", "34.12N", "118.22W", "217", "US"],
    ["CA BURNEY", "KBNY", "BNY", "None", "40.52N", "121.40W", "957", "US"],
    ["CA CALEXICO INTL", "KCXL", "CXL", "None", "32.40N", "115.30W", "1", "US"],
    ["CA CAMARILLO", "KCMA", "CMA", "None", "34.13N", "119.06W", "23", "US"],
    ["CA CAMP PENDLETON", "KNFG", "NFG", "None", "33.17N", "117.20W", "24", "US"],
    ["CA CAMP ROBERTS", "KSYL", "SYL", "None", "35.45N", "120.42W", "220", "US"],
    ["CA CAMPO", "KCZZ", "CZZ", "None", "32.38N", "116.28W", "807", "US"],
    ["CA CARLSBAD", "KCRQ", "CRQ", "None", "33.08N", "117.17W", "99", "US"],
    ["CA CHICO MUNICIPAL", "KCIC", "CIC", "72497", "39.47N", "121.50W", "73", "US"],
    ["CA CHINA LAKE (NAF)", "KNID", "NID", "74612", "35.40N", "117.40W", "696", "US"],
    ["CA CHINO", "KCNO", "CNO", "None", "33.59N", "117.37W", "207", "US"],
    ["CA COLUMBIA", "KO22", "O22", "None", "38.02N", "120.25W", "646", "US"],
    ["CA CONCORD", "KCCR", "CCR", "None", "38.00N", "122.03W", "11", "US"],
    ["CA CORONA MUNI", "KAJO", "AJO", "None", "33.54N", "117.36W", "163", "US"],
    ["CA CRESCENT CITY", "KCEC", "CEC", "None", "41.46N", "124.13W", "17", "US"],
    ["CA DAGGETT", "KDAG", "DAG", "None", "34.51N", "116.47W", "587", "US"],
    ["CA DAVIS", "KEDU", "EDU", "None", "38.32N", "121.47W", "21", "US"],
    ["CA EDWARDS AFB", "KEDW", "EDW", "72381", "34.53N", "117.52W", "702", "US"],
    ["CA EDWARDS AFB/88D", "KEYX", "EYX", "None", "35.06N", "117.34W", "840", "US"],
    ["CA EDWARDS N-AUX", "K9L2", "9L2", "None", "34.58N", "117.52W", "701", "US"],
    ["CA EL CENTRO NAF", "KNJK", "NJK", "72281", "32.49N", "115.40W", "-13", "US"],
    ["CA EL MONTE", "KEMT", "EMT", "74704", "34.04N", "118.01W", "90", "US"],
    ["CA EMIGRANT GAP", "KBLU", "BLU", "None", "39.17N", "120.42W", "1609", "US"],
    ["CA EUREKA/MURRAY", "KEKA", "EKA", "72594", "40.48N", "124.10W", "18", "US"],
    ["CA FALLBROOK", "KL18", "L18", "None", "33.21N", "117.15W", "216", "US"],
    ["CA FORTUNA/FOT/VOR", "None", "None", "None", "40.40N", "124.14W", "122", "US"],
    ["CA FORTUNA", "KFOT", "FOT", "None", "40.33N", "124.08W", "120", "US"],
    ["CA FRESNO", "KFAT", "FAT", "72389", "36.47N", "119.43W", "104", "US"],
    ["CA FRESNO(VOR)", "KCZQ", "CZQ", "None", "36.53N", "119.49W", "104", "US"],
    ["CA FRESNO CHANDLER", "KFCH", "FCH", "None", "36.43N", "119.49W", "85", "US"],
    ["CA FULLERTON", "KFUL", "FUL", "None", "33.52N", "117.59W", "35", "US"],
    ["CA GRASS VALLEY", "KGOO", "GOO", "None", "39.13N", "121.00W", "962", "US"],
    ["CA HALF MOON BAY", "KHAF", "HAF", "None", "37.31N", "122.30W", "21", "US"],
    ["CA HANFORD", "KHJO", "HJO", "None", "36.19N", "119.37W", "74", "US"],
    ["CA HANFORD/SAN JOAQ", "KHNX", "HNX", "None", "36.19N", "119.38W", "74", "US"],
    ["CA HANFORD", "KO18", "O18", "None", "36.19N", "119.38W", "74", "US"],
    ["CA HAWTHORNE", "KHHR", "HHR", "None", "33.55N", "118.20W", "18", "US"],
    ["CA HAYWARD", "KHWD", "HWD", "None", "37.40N", "122.07W", "21", "US"],
    ["CA HEALDSBURG", "KHES", "HES", "None", "38.39N", "122.54W", "85", "US"],
    ["CA HECTOR(VOR)", "KHEC", "HEC", "None", "34.48N", "116.28W", "617", "US"],
    ["CA HOLLISTER MUNI", "KCVH", "CVH", "None", "36.54N", "121.25W", "70", "US"],
    ["CA HUMBOLDT CTY/88D", "KBHX", "BHX", "None", "40.30N", "124.18W", "732", "US"],
    ["CA HUNTER LIGGET", "KHGT", "HGT", "69002", "36.00N", "121.13W", "310", "US"],
    ["CA IMPERIAL", "KIPL", "IPL", "None", "32.50N", "115.35W", "-17", "US"],
    ["CA IMPERIAL BEACH", "KNRS", "NRS", "None", "32.34N", "117.07W", "7", "US"],
    ["CA INYOKERN", "KIYK", "IYK", "None", "35.40N", "117.49W", "749", "US"],
    ["CA LA VERNE/BRACKET", "KPOC", "POC", "None", "34.06N", "117.46W", "308", "US"],
    ["CA LANCASTER/FOX", "KWJF", "WJF", "None", "34.43N", "118.13W", "715", "US"],
    ["CA LEMOORE NAS/REEV", "KNLC", "NLC", "74702", "36.19N", "119.57W", "72", "US"],
    ["CA LINCOLN", "KLHM", "LHM", "None", "38.55N", "121.21W", "37", "US"],
    ["CA LITTLE RIVER", "KLLR", "LLR", "None", "39.16N", "123.45W", "175", "US"],
    ["CA LIVERMORE", "KLVK", "LVK", "None", "37.42N", "121.49W", "117", "US"],
    ["CA LOMPOC", "KLPC", "LPC", "74606", "34.40N", "120.28W", "27", "US"],
    ["CA LONG BEACH", "KLGB", "LGB", "72297", "33.49N", "118.09W", "10", "US"],
    ["CA LOS ALAMITOS AAF", "KSLI", "SLI", "None", "33.46N", "118.02W", "11", "US"],
    ["CA LOS ANGELES", "KLAX", "LAX", "72295", "33.56N", "118.23W", "46", "US"],
    ["CA LOS ANGELES/OXNA", "KLOX", "LOX", "None", "34.12N", "119.12W", "20", "US"],
    ["CA LOS ANGELS/ARTCC", "KZLA", "ZLA", "None", "34.38N", "118.05W", "819", "US"],
    ["CA LOS ANGELES", "KCQT", "CQT", "None", "34.01N", "118.17W", "56", "US"],
    ["CA LA / WHITEMAN", "KWHP", "None", "None", "34.15N", "118.25W", "306", "US"],
    ["CA MADERA", "KMAE", "MAE", "None", "36.59N", "120.07W", "77", "US"],
    ["CA MAMMOTH/JUNE LAK", "KMMH", "MMH", "None", "37.37N", "118.49W", "2173", "US"],
    ["CA MARYSVILLE", "KMYV", "MYV", "None", "39.06N", "121.34W", "21", "US"],
    ["CA MATHER FIELD", "KMHR", "MHR", "None", "38.32N", "121.17W", "29", "US"],
    ["CA MCCLELLAN AFB", "KMCC", "MCC", "None", "38.40N", "121.24W", "23", "US"],
    ["CA MERCED", "KMCE", "MCE", "None", "37.17N", "120.30W", "47", "US"],
    ["CA MERCED/CASTLE AF", "KMER", "MER", "72481", "37.23N", "120.34W", "57", "US"],
    ["CA MIRAMAR NAS/SAN", "KNKX", "NKX", "72293", "32.52N", "117.08W", "146", "US"],
    ["CA MISSION BAY VOR", "KMZB", "MZB", "None", "32.47N", "117.14W", "12", "US"],
    ["CA MODESTO", "KMOD", "MOD", "None", "37.37N", "120.57W", "29", "US"],
    ["CA MOFFETT NAS/MTN", "KNUQ", "NUQ", "74509", "37.24N", "122.03W", "12", "US"],
    ["CA MOJAVE", "KMHV", "MHV", "None", "35.04N", "118.09W", "849", "US"],
    ["CA MONTAGUE/SISKIYO", "KSIY", "SIY", "None", "41.46N", "122.28W", "807", "US"],
    ["CA MONTEREY", "KMRY", "MRY", "None", "36.35N", "121.51W", "66", "US"],
    ["CA MONTEREY/WFOKMTR", "None", "None", "None", "36.35N", "121.51W", "66", "US"],
    ["CA MOUNT SHASTA", "KMHS", "MHS", "72595", "41.19N", "122.19W", "1078", "US"],
    ["CA MOUNT WILSON", "KMWS", "MWS", "72289", "34.14N", "118.03W", "1739", "US"],
    ["CA MURRIETA/TEMECUL", "KF70", "F70", "None", "33.34N", "117.08W", "412", "US"],
    ["CA NAPA", "KAPC", "APC", "None", "38.12N", "122.17W", "13", "US"],
    ["CA NEEDLES", "KEED", "EED", "72380", "34.46N", "114.37W", "302", "US"],
    ["CA NEWHALL", "K3A6", "3A6", "None", "34.22N", "118.34W", "427", "US"],
    ["CA NORTH ISLAND NAS", "KNZY", "NZY", "None", "32.42N", "117.13W", "8", "US"],
    ["CA NOVATO/GNOSS FLD", "KDVO", "DVO", "None", "38.09N", "122.33W", "1", "US"],
    ["CA OAKLAND", "KOAK", "OAK", "72493", "37.43N", "122.14W", "26", "US"],
    ["CA OAKLAND/ARTCC", "KZOA", "ZOA", "None", "37.33N", "122.01W", "11", "US"],
    ["CA OCEANSIDE", "KOKB", "OKB", "None", "33.13N", "117.21W", "8", "US"],
    ["CA OCEANSIDE/RED-B", "KNXF", "NXF", "None", "33.17N", "117.27W", "27", "US"],
    ["CA ONTARIO", "KONT", "ONT", "None", "34.03N", "117.35W", "274", "US"],
    ["CA ORANGE CTY/88D", "KSOX", "SOX", "None", "33.49N", "117.38W", "923", "US"],
    ["CA ORCUTT OIL/VBG", "KVBX", "VBX", "None", "34.50N", "120.24W", "373", "US"],
    ["CA OROVILLE", "KOVE", "OVE", "None", "39.30N", "121.37W", "58", "US"],
    ["CA OXNARD", "KOXR", "OXR", "None", "34.12N", "119.12W", "20", "US"],
    ["CA PALM SPRINGS", "KPSP", "PSP", "None", "33.49N", "116.30W", "135", "US"],
    ["CA PALMDALE", "KPMD", "PMD", "72382", "34.38N", "118.05W", "780", "US"],
    ["CA PALMDALE", "KGXA", "GXA", "None", "34.34N", "117.40W", "923", "US"],
    ["CA PALO ALTO", "KPAO", "PAO", "None", "37.28N", "122.07W", "2", "US"],
    ["CA PASO ROBLES", "KPRB", "PRB", "None", "35.40N", "120.38W", "245", "US"],
    ["CA PETALUMA", "KO69", "O69", "None", "38.15N", "122.36W", "28", "US"],
    ["CA PLACERVILLE", "KPVF", "PVF", "None", "38.43N", "120.45W", "789", "US"],
    ["CA POINT MUGU NAS", "KNTD", "NTD", "72391", "34.07N", "119.07W", "4", "US"],
    ["CA POINT REYES VOR", "KPYE", "PYE", "None", "38.05N", "122.52W", "447", "US"],
    ["CA PORTERVILLE", "KPTV", "PTV", "None", "36.01N", "119.04W", "135", "US"],
    ["CA PT. PIEDRAS BLAN", "K87Q", "87Q", "72390", "35.40N", "121.17W", "27", "US"],
    ["CA RED BLUFF", "KRBL", "RBL", "72591", "40.09N", "122.15W", "104", "US"],
    ["CA REDDING", "KRDD", "RDD", "72592", "40.31N", "122.18W", "155", "US"],
    ["CA REDLANDS", "KREI", "REI", "None", "34.05N", "117.09W", "480", "US"],
    ["CA RIO VISTA", "KO88", "O88", "None", "38.12N", "121.42W", "7", "US"],
    ["CA RIVERSIDE", "KRAL", "RAL", "None", "33.57N", "117.27W", "252", "US"],
    ["CA RIVERSIDE/MARCH", "KRIV", "RIV", "72286", "33.52N", "117.16W", "469", "US"],
    ["CA RAMONA", "KRNM", "RNM", "None", "33.02N", "116.55W", "427", "US"],
    ["CA SACRAMENTO", "KSAC", "SAC", "None", "38.30N", "121.30W", "11", "US"],
    ["CA SACRAMENTO/WFO", "KSTO", "STO", "72483", "38.30N", "121.30W", "11", "US"],
    ["CA SACRAMENTO/RFC", "KRSA", "RSA", "None", "38.30N", "121.30W", "11", "US"],
    ["CA SACRAMENTO/88D", "KDAX", "DAX", "None", "38.30N", "121.41W", "9", "US"],
    ["CA SACRAMENTO/METRO", "KSMF", "SMF", "None", "38.42N", "121.36W", "6", "US"],
    ["CA SALINAS", "KSNS", "SNS", "None", "36.40N", "121.36W", "30", "US"],
    ["CA SAN BERNARDINO", "KSBD", "SBD", "None", "34.05N", "117.15W", "353", "US"],
    ["CA SAN CARLOS AIRPO", "KSQL", "SQL", "None", "37.31N", "122.15W", "1", "US"],
    ["CA SAN CLEMENTE IS.", "KNUC", "NUC", "None", "33.01N", "118.34W", "55", "US"],
    ["CA SAN DIEGO", "KSAN", "SAN", "72290", "32.44N", "117.11W", "12", "US"],
    ["CA SAN DIEGO/MNTGMY", "KMYF", "MYF", "None", "32.49N", "117.08W", "136", "US"],
    ["CA SAN DIEGO/BROWN", "KSDM", "SDM", "None", "32.35N", "117.00W", "159", "US"],
    ["CA SAN DIEGO/SANTEE", "KSEE", "SEE", "None", "32.49N", "116.58W", "117", "US"],
    ["CA SAN DIEGO/WFO", "KSGX", "SGX", "None", "32.44N", "117.10W", "9", "US"],
    ["CA SAN FRANCISCO", "KSFO", "SFO", "72494", "37.37N", "122.22W", "3", "US"],
    ["CA SAN JOSE", "KSJC", "SJC", "74505", "37.22N", "121.55W", "24", "US"],
    ["CA SAN JOSE/REID", "KRHV", "RHV", "None", "37.19N", "121.49W", "41", "US"],
    ["CA SAN LUIS OBISPO", "KSBP", "SBP", "None", "35.14N", "120.38W", "59", "US"],
    ["CA SAN MARTIN", "KE16", "E16", "None", "37.05N", "121.36W", "86", "US"],
    ["CA SAN NICOLAS ISLA", "KNSI", "NSI", "72291", "33.13N", "119.27W", "154", "US"],
    ["CA SANDBERG", "KSDB", "SDB", "72383", "34.45N", "118.43W", "1377", "US"],
    ["CA COSTA MESA", "KSNA", "SNA", "None", "33.40N", "117.52W", "16", "US"],
    ["CA SANTA BARBARA", "KSBA", "SBA", "None", "34.26N", "119.51W", "3", "US"],
    ["CA SANTA BARB(VOR)", "KRZS", "RZS", "None", "34.31N", "119.46W", "1104", "US"],
    ["CA SANTA CLAR/88D", "KMUX", "MUX", "None", "37.09N", "121.54W", "1057", "US"],
    ["CA SANTA MARIA", "KSMX", "SMX", "72394", "34.54N", "120.27W", "74", "US"],
    ["CA SANTA MONICA", "KSMO", "SMO", "None", "34.01N", "118.27W", "57", "US"],
    ["CA SANTA ROSA", "KSTS", "STS", "None", "38.30N", "122.49W", "39", "US"],
    ["CA SANTA YNEZ", "KIZA", "IZA", "None", "34.36N", "120.04W", "205", "US"],
    ["CA SHELTER COVE", "KO87", "O87", "None", "40.01N", "124.04W", "21", "US"],
    ["CA SOUTH LAKE TAHOE", "KTVL", "TVL", "None", "38.54N", "120.00W", "1924", "US"],
    ["CA STOCKTON", "KSCK", "SCK", "72492", "37.53N", "121.13W", "10", "US"],
    ["CA SUSANVILLE MUNI", "KSVE", "SVE", "72584", "40.22N", "120.34W", "1263", "US"],
    ["CA THERMAL/PALM SPG", "KTRM", "TRM", "None", "33.38N", "116.10W", "-35", "US"],
    ["CA TORRANCE MUNICIP", "KTOA", "TOA", "None", "33.47N", "118.19W", "31", "US"],
    ["CA TRAVIS AFB/FAIRF", "KSUU", "SUU", "74516", "38.16N", "121.55W", "19", "US"],
    ["CA TRUCKEE TAHOE", "KTRK", "TRK", "None", "39.19N", "120.07W", "1798", "US"],
    ["CA TEHACHAPI", "KTSP", "TSP", "None", "35.08N", "118.26W", "1220", "US"],
    ["CA TRINITY CENTER", "KO86", "O86", "None", "40.59N", "122.42W", "729", "US"],
    ["CA TWENTYNINE PALMS", "KNXP", "NXP", "69015", "34.17N", "116.10W", "626", "US"],
    ["CA UKIAH", "KUKI", "UKI", "None", "39.07N", "123.12W", "187", "US"],
    ["CA UKIAH(VOR)", "KENI", "ENI", "None", "39.03N", "123.16W", "187", "US"],
    ["CA VACAVILLE", "KVCB", "VCB", "None", "38.23N", "121.57W", "33", "US"],
    ["CA VAN NUYS", "KVNY", "VNY", "None", "34.13N", "118.29W", "245", "US"],
    ["CA VANDENBERG AFB", "KVBG", "VBG", "72393", "34.44N", "120.35W", "112", "US"],
    ["CA VANDENBERG RANGE", "KXVW", "XVW", "None", "34.43N", "120.34W", "100", "US"],
    ["CA VENTURA CTY/88D", "KVTX", "VTX", "None", "34.25N", "119.11W", "831", "US"],
    ["CA VICTORVILLE", "KVCV", "VCV", "None", "34.35N", "117.23W", "876", "US"],
    ["CA VISALIA MUNI", "KVIS", "VIS", "None", "36.19N", "119.24W", "89", "US"],
    ["CA WATSONVILLE", "KWVI", "WVI", "None", "36.56N", "121.47W", "43", "US"],
    ["CA WEAVERVILLE", "KO54", "O54", "None", "40.45N", "122.55W", "717", "US"],
    ["CA ALTURAS", "KO00", "O00", "None", "41.29N", "120.34W", "1331", "US"],
    ["CA ALTURAS", "KS11", "S11", "None", "41.30N", "120.31W", "1341", "US"],
    ["CA BODEGA BAY", "K92Q", "92Q", "None", "38.19N", "123.03W", "3", "US"],
    ["CA CROWS LANDING", "KNRC", "NRC", "None", "37.24N", "121.06W", "50", "US"],
    ["CA CUDDLEBACK GUN R", "None", "4CB", "74618", "35.16N", "117.26W", "864", "US"],
    ["CA EL TORO MCAS", "KNZJ", "NZJ", "69014", "33.40N", "117.43W", "117", "US"],
    ["CA FORT ORD/FRITZSC", "KOAR", "OAR", "None", "36.40N", "121.46W", "41", "US"],
    ["CA MONTAGUE/YREKA", "K1O5", "1O5", "None", "41.44N", "122.32W", "771", "US"],
    ["CA OCEANSIDE", "KL32", "L32", "None", "33.13N", "117.21W", "8", "US"],
    ["CA PILAR POINT AFS", "K53Q", "53Q", "72392", "37.30N", "122.30W", "49", "US"],
    ["CA POINT ARGUELLO", "None", "None", "None", "34.57N", "121.52W", "23", "US"],
    ["CA POINT ARGUELLO", "KPGU", "PGU", "99421", "34.34N", "120.21W", "12", "US"],
    ["CA POINT ARENA", "KPAA", "PAA", "72499", "38.57N", "123.16W", "18", "US"],
    ["CA POINT ARENA", "None", "None", "99412", "38.57N", "123.16W", "17", "US"],
    ["CA ROMONA", "KL39", "L39", "None", "33.02N", "116.55W", "427", "US"],
    ["CA RANCHO MURIETA", "KRIU", "RIU", "None", "38.29N", "121.06W", "45", "US"],
    ["CA SALTON SEA", "None", "None", "74718", "34.05N", "118.02W", "1", "US"],
    ["CA SUPERIOR VALLEY", "K4SU", "4SU", "74619", "35.20N", "117.06W", "962", "US"],
    ["CA TUSTIN MCAS", "KNTK", "NTK", "69016", "33.42N", "117.49W", "17", "US"],
    ["CA VACAVILLE", "KO45", "O45", "None", "38.23N", "121.57W", "33", "US"],
    ["CA MARCH AFB/88D", "KRIX", "RIX", "None", "33.33N", "117.26W", "468", "US"],
    ["CO DENVER (DIA)", "KDEN", "DEN", "72565", "39.51N", "104.39W", "1640", "US"],
    ["CO AKRON", "KAKO", "AKO", "None", "40.10N", "103.13W", "1421", "US"],
    ["CO ALAMOSA", "KALS", "ALS", "72462", "37.26N", "105.52W", "2299", "US"],
    ["CO ASPEN", "KASE", "ASE", "None", "39.14N", "106.52W", "2354", "US"],
    ["CO BERTHOUD PASS", "K0CO", "0CO", "None", "39.48N", "105.46W", "3807", "US"],
    ["CO BOULDER DEN/WFO", "KBOU", "BOU", "None", "40.00N", "105.20W", "1625", "US"],
    ["CO BROOMFIELD/JEFFC", "KBJC", "BJC", "None", "39.54N", "105.06W", "1724", "US"],
    ["CO BUCKLEY ANGB/DEN", "KBKF", "BKF", "None", "39.43N", "104.45W", "1726", "US"],
    ["CO BURLINGTON", "KITR", "ITR", "None", "39.14N", "102.17W", "1279", "US"],
    ["CO CANON CITY", "K1V6", "1V6", "None", "38.26N", "105.06W", "1658", "US"],
    ["CO CHEYENNE MTN", "KCWN", "CWN", "None", "38.45N", "104.51W", "2040", "US"],
    ["CO COLORADO SPRINGS", "KCOS", "COS", "72466", "38.49N", "104.41W", "1856", "US"],
    ["CO CO SPNGS MEADOW", "KFLY", "FLY", "None", "38.57N", "104.34W", "2096", "US"],
    ["CO CORTEZ", "KCEZ", "CEZ", "None", "37.18N", "108.38W", "1797", "US"],
    ["CO CRAIG", "KCAG", "CAG", "72570", "40.30N", "107.31W", "1887", "US"],
    ["CO DEL NORTE", "KRCV", "RCV", "None", "37.43N", "106.21W", "2425", "US"],
    ["CO DENVER/ARAPAHOE", "KAPA", "APA", "None", "39.34N", "104.51W", "1775", "US"],
    ["CO DENVER F. RANGE", "KFTG", "FTG", "None", "39.47N", "104.33W", "1675", "US"],
    ["CO DENVER/ARTCC", "KZDV", "ZDV", "None", "40.11N", "105.08W", "1498", "US"],
    ["CO DENVER/STAPLETON", "KDNR", "DNR", "72469", "39.45N", "104.52W", "1608", "US"],
    ["CO DOVE CREEK", "KDVC", "DVC", "None", "37.48N", "108.55W", "2131", "US"],
    ["CO DURANGO", "KDRO", "DRO", "None", "37.09N", "107.46W", "2035", "US"],
    ["CO EAGLE CO. REGION", "KEGE", "EGE", "None", "39.38N", "106.55W", "1993", "US"],
    ["CO RED TABLE VOR", "KDBL", "DBL", "None", "39.26N", "106.54W", "3584", "US"],
    ["CO FORT CARSON", "KFCS", "FCS", "72468", "38.40N", "104.46W", "1789", "US"],
    ["CO FT COLLINS/LOVEL", "KFNL", "FNL", "None", "40.27N", "105.01W", "1529", "US"],
    ["CO GRANADA PROFILER", "None", "GDA", "74530", "37.46N", "102.10W", "1155", "US"],
    ["CO GRAND JUNCTION", "KGJT", "GJT", "72476", "39.07N", "108.31W", "1475", "US"],
    ["CO GRAND JUNCTION", "KJNC", "JNC", "None", "39.04N", "108.48W", "2367", "US"],
    ["CO GRAND JUNC/MESA", "KGJX", "GJX", "None", "39.04N", "108.13W", "3045", "US"],
    ["CO GREELEY/WELD", "KGXY", "GXY", "None", "40.25N", "104.37W", "1420", "US"],
    ["CO GUNNISON", "KGUC", "GUC", "None", "38.31N", "106.55W", "2339", "US"],
    ["CO GUNNISON(VOR)", "KHBU", "HBU", "None", "38.27N", "107.02W", "2339", "US"],
    ["CO HAYDEN VOR", "KCHE", "CHE", "None", "40.29N", "107.13W", "2339", "US"],
    ["CO HAYDEN/YAMPA", "KHDN", "HDN", "72571", "40.28N", "107.13W", "2012", "US"],
    ["CO LA JUNTA", "KLHX", "LHX", "None", "38.03N", "103.31W", "1277", "US"],
    ["CO LAMAR", "KLAA", "LAA", "72463", "38.04N", "102.41W", "1119", "US"],
    ["CO LEADVILLE", "KLXV", "LXV", "72467", "39.14N", "106.19W", "3028", "US"],
    ["CO LIMON", "KLIC", "LIC", "None", "39.16N", "103.40W", "1630", "US"],
    ["CO MEEKER", "KEEO", "EEO", "None", "40.03N", "107.53W", "1930", "US"],
    ["CO MONTROSE", "KMTJ", "MTJ", "None", "38.30N", "107.54W", "1750", "US"],
    ["CO NUCLA/HOPKINS F", "KAIB", "AIB", "None", "38.14N", "108.34W", "1811", "US"],
    ["CO PETERSON AFB", "KPEF", "PEF", "None", "38.47N", "104.43W", "1881", "US"],
    ["CO PLATTEVILLE PROF", "None", "PLT", "74533", "40.10N", "104.42W", "1524", "US"],
    ["CO PUEBLO CTY 88D", "KPUX", "PUX", "None", "38.28N", "104.11W", "1600", "US"],
    ["CO PUEBLO", "KPUB", "PUB", "72464", "38.17N", "104.30W", "1420", "US"],
    ["CO RIFLE", "KRIL", "RIL", "None", "39.32N", "107.44W", "1678", "US"],
    ["CO SAGUACHE MUNI", "K04V", "04V", "None", "38.06N", "106.10W", "2385", "US"],
    ["CO SCHRIEVER AFB", "KSHM", "SHM", "None", "38.48N", "104.31W", "1900", "US"],
    ["CO SPRINGFIELD", "KSPD", "SPD", "None", "37.17N", "102.37W", "1335", "US"],
    ["CO STEAMBOAT SPRING", "KSBS", "SBS", "None", "40.31N", "106.52W", "2096", "US"],
    ["CO MT WERNER SBS", "K3MW", "3MW", "None", "40.27N", "106.45W", "3241", "US"],
    ["CO TELLURIDE REGION", "KTEX", "TEX", "None", "37.57N", "107.54W", "2769", "US"],
    ["CO TOBE/VOR", "KTBE", "TBE", "None", "37.16N", "103.36W", "1747", "US"],
    ["CO TRINIDAD/ANIMAS", "KTAD", "TAD", "None", "37.16N", "104.20W", "1756", "US"],
    ["CO USAF ACADEMY/COS", "KAFF", "AFF", "74531", "38.58N", "104.49W", "2003", "US"],
    ["CO WALTON PEAK", "KC07", "C07", "None", "40.21N", "106.42W", "3225", "US"],
    ["CO DURANGO(AWRS)", "K4V5", "4V5", "None", "37.17N", "107.52W", "2012", "US"],
    ["CO FORT COLLINS", "KFCL", "FCL", "None", "40.35N", "105.05W", "1525", "US"],
    ["CO FRASER", "K4FC", "4FC", "None", "39.57N", "105.50W", "2609", "US"],
    ["CO GUNNISON/AWRS", "K2V9", "2V9", "None", "38.36N", "106.55W", "2349", "US"],
    ["CO LAMAR", "K4LJ", "4LJ", "None", "38.05N", "102.37W", "1103", "US"],
    ["CO SALIDA", "KS29", "S29", "None", "38.31N", "106.01W", "2282", "US"],
    ["CO WINTER PARK", "KC96", "C96", "None", "40.00N", "105.52W", "2740", "US"],
    ["CO YUMA", "K2V6", "2V6", "None", "40.06N", "102.43W", "1261", "US"],
    ["CO YUMA", "KYMA", "None", "None", "40.06N", "102.43W", "1261", "US"],
    ["CO FLAGLER", "KFLA", "None", "None", "39.17N", "103.04W", "1507", "US"],
    ["CO KIRK", "K72C", "None", "None", "39.36N", "102.34W", "1280", "US"],
    ["CO STERLING", "KSTK", "None", "None", "40.37N", "103.16W", "1231", "US"],
    ["CO STRATTON", "KSTR", "None", "None", "39.18N", "102.36W", "1345", "US"],
    ["CO RED CLIFF PASS", "KCCU", "None", "None", "39.29N", "106.09W", "3680", "US"],
    ["CO RANGELY", "K4V0", "None", "None", "40.06N", "108.46W", "1608", "US"],
    ["CO BUENA VISTA", "KAEJ", "None", "None", "38.49N", "106.07W", "2422", "US"],
    ["CO DELTA/BLAKE FLD", "KAJZ", "None", "None", "38.47N", "108.04W", "1583", "US"],
    ["CO SALIDA", "KANK", "None", "None", "38.32N", "106.03W", "2293", "US"],
    ["CO BOULDER MUNI", "KBDU", "None", "None", "40.02N", "105.14W", "1612", "US"],
    ["CO ELLICOTT-B AFA", "KABH", "None", "None", "38.46N", "104.18W", "1840", "US"],
    ["CO ERIE MUNI", "KEIK", "None", "None", "40.01N", "105.03W", "1564", "US"],
    ["CO FORT MORGAN", "KFMM", "None", "None", "40.20N", "103.48W", "1393", "US"],
    ["CO GRANBY/GRAND CO", "KGNB", "None", "None", "40.05N", "105.55W", "2500", "US"],
    ["CO HOLYOKE", "KHEQ", "None", "None", "40.34N", "102.17W", "1137", "US"],
    ["CO LONGMONT/VBRAND", "KLMO", "None", "None", "40.10N", "105.10W", "1541", "US"],
    ["CO PAGOSA SPRINGS", "KPSO", "None", "None", "37.17N", "107.03W", "2334", "US"],
    ["CO WOLF CREEK PASS", "KCPW", "None", "None", "37.27N", "106.48W", "3584", "US"],
    ["CO CORONA PASS", "KCRV", "None", "None", "40.03N", "105.35W", "3538", "US"],
    ["CO MONUMENT/ELBERT", "KMNH", "None", "None", "39.13N", "104.39W", "2152", "US"],
    ["CO MONARCH PASS", "KMYP", "None", "None", "38.29N", "106.19W", "3667", "US"],
    ["CO LA VETA PASS", "KVTP", "None", "None", "37.30N", "105.10W", "3114", "US"],
    ["CO WALDEN", "K33V", "None", "None", "40.45N", "106.17W", "2484", "US"],
    ["CO KREMMLING AWOS", "K20V", "None", "None", "40.03N", "106.22W", "2259", "US"],
    ["CO WILKERSON PASS", "K4BM", "None", "None", "39.03N", "105.31W", "3438", "US"],
    ["CO SUNLIGHT", "K5SM", "None", "None", "39.26N", "107.23W", "3232", "US"],
    ["CO COTTONWOOD PASS", "K7BM", "None", "None", "38.47N", "106.13W", "2995", "US"],
    ["CO WRAY", "K2V5", "None", "None", "40.06N", "102.15W", "1118", "US"],
    ["CT BRIDGEPORT", "KBDR", "BDR", "72504", "41.10N", "073.08W", "7", "US"],
    ["CT CHESTER", "KSNC", "SNC", "None", "41.23N", "072.30W", "127", "US"],
    ["CT DANBURY", "KDXR", "DXR", "None", "41.22N", "073.29W", "139", "US"],
    ["CT GROTON/NEW LONDO", "KGON", "GON", "None", "41.20N", "072.03W", "3", "US"],
    ["CT HARTFORD/BRAINAR", "KHFD", "HFD", "None", "41.44N", "072.39W", "4", "US"],
    ["CT MERIDEN", "KMMK", "MMK", "None", "41.31N", "072.50W", "31", "US"],
    ["CT NEW HAVEN/TWEED", "KHVN", "HVN", "None", "41.16N", "072.52W", "4", "US"],
    ["CT OXFORD/WATERBURY", "KOXC", "OXC", "None", "41.28N", "073.08W", "222", "US"],
    ["CT WILLIMANTIC", "KIJD", "IJD", "None", "41.45N", "072.11W", "75", "US"],
    ["CT WINDSOR LOCKS", "KBDL", "BDL", "72508", "41.56N", "072.41W", "60", "US"],
    ["CT MANSFIELD", "K5B0", "5B0", "None", "41.45N", "072.10W", "76", "US"],
    ["CT PUTNAM", "K5B3", "5B3", "None", "41.04N", "073.37W", "91", "US"],
    ["DE DOVER AFB", "KDOV", "DOV", "None", "39.07N", "075.28W", "9", "US"],
    ["DE DOVER/ELLENDALE", "KDOX", "DOX", "None", "38.50N", "075.26W", "15", "US"],
    ["DE GEORGETOWN", "KGED", "GED", "None", "38.41N", "075.22W", "19", "US"],
    ["DE WILMINGTON", "KILG", "ILG", "None", "39.40N", "075.36W", "28", "US"],
    ["FL APALACHICOLA", "KAAF", "AAF", "72220", "29.44N", "085.02W", "5", "US"],
    ["FL BARTOW MUNICIPAL", "KBOW", "BOW", "None", "27.56N", "081.46W", "39", "US"],
    ["FL BOCA RATON", "KBCT", "BCT", "None", "26.23N", "080.06W", "4", "US"],
    ["FL BONIFAY TRI-CTY", "K1J0", "1J0", "None", "30.51N", "085.36W", "26", "US"],
    ["FL BROOKSVILLE", "KBKV", "BKV", "None", "28.28N", "082.27W", "20", "US"],
    ["FL CAPE CANAVERAL", "KXMR", "XMR", "74794", "28.28N", "080.34W", "3", "US"],
    ["FL CECIL FIELD NAS", "KNZC", "NZC", "None", "30.13N", "081.52W", "25", "US"],
    ["FL CLEARWATER", "KCLW", "CLW", "None", "27.59N", "082.46W", "22", "US"],
    ["FL CRESTVIEW", "KCEW", "CEW", "None", "30.47N", "086.31W", "55", "US"],
    ["FL CROSS CITY", "KCTY", "CTY", "72212", "29.38N", "083.06W", "13", "US"],
    ["FL CRYSTAL RIVER", "KCGC", "CGC", "None", "28.52N", "082.34W", "3", "US"],
    ["FL DAYTONA BEACH", "KDAB", "DAB", "None", "29.11N", "081.04W", "9", "US"],
    ["FL DE FUNIAK SPRNGS", "K54J", "54J", "None", "30.44N", "086.09W", "88", "US"],
    ["FL DELAND", "KDED", "DED", "None", "29.04N", "081.17W", "24", "US"],
    ["FL DESTIN", "KDTS", "DTS", "None", "30.24N", "086.28W", "5", "US"],
    ["FL DUKE FLD/EGLIN", "KEGI", "EGI", "74778", "30.38N", "086.31W", "59", "US"],
    ["FL EGLIN AFB/88D", "KEVX", "EVX", "None", "30.34N", "085.55W", "43", "US"],
    ["FL EGLIN AFB/VALPAR", "KVPS", "VPS", "72221", "30.28N", "086.31W", "26", "US"],
    ["FL EVERGLADES CITY", "KEGC", "EGC", "None", "25.51N", "081.23W", "2", "US"],
    ["FL FERNANDINA BEACH", "KFHB", "FHB", "None", "30.37N", "081.28W", "5", "US"],
    ["FL FLAMINGO/MONROE", "KFLM", "FLM", "None", "25.08N", "080.55W", "2", "US"],
    ["FL FT LAUDERD/HOLLY", "KFLL", "FLL", "None", "26.04N", "080.09W", "3", "US"],
    ["FL FT LAUDERD/EXEC", "KFXE", "FXE", "None", "26.12N", "080.11W", "6", "US"],
    ["FL FORT MYERS", "KRSW", "RSW", "None", "26.32N", "081.45W", "10", "US"],
    ["FL FORT MYERS", "KFMY", "FMY", "None", "26.35N", "081.52W", "4", "US"],
    ["FL FORT PIERCE", "KFPR", "FPR", "None", "27.30N", "080.23W", "13", "US"],
    ["FL GAINESVILLE", "KGNV", "GNV", "None", "29.42N", "082.17W", "45", "US"],
    ["FL HOLLYWOOD", "KHWO", "HWO", "None", "26.00N", "080.14W", "2", "US"],
    ["FL HOMESTEAD AFB", "KHST", "HST", "None", "25.28N", "080.22W", "2", "US"],
    ["FL HURLBURT FIELD", "KHRT", "HRT", "74777", "30.25N", "086.40W", "12", "US"],
    ["FL IMMOKALEE", "KIMM", "IMM", "None", "26.26N", "081.24W", "12", "US"],
    ["FL INVERNESS", "KINF", "INF", "None", "28.48N", "082.19W", "15", "US"],
    ["FL JACKSONVIL/CRAIG", "KCRG", "CRG", "None", "30.20N", "081.31W", "13", "US"],
    ["FL JACKSONVILLE NAS", "KNIP", "NIP", "None", "30.13N", "081.40W", "7", "US"],
    ["FL JACKSONVILLE", "KJAX", "JAX", "72206", "30.30N", "081.41W", "10", "US"],
    ["FL JACKSONVIL/ARTCC", "KZJX", "ZJX", "None", "30.41N", "081.54W", "2", "US"],
    ["FL JACKSONVIL/CECIL", "KVQQ", "VQQ", "None", "30.13N", "081.53W", "25", "US"],
    ["FL JACKSONVIL/NAVAL", "KNEN", "NEN", "None", "30.21N", "081.53W", "30", "US"],
    ["FL KEYSTONE HEIGHTS", "K42J", "42J", "None", "29.51N", "082.03W", "60", "US"],
    ["FL KEY WEST NAS", "KNQX", "NQX", "None", "24.34N", "081.40W", "2", "US"],
    ["FL KEY WEST", "KEYW", "EYW", "72201", "24.33N", "081.45W", "5", "US"],
    ["FL KEY WEST", "KKEY", "KEY", "None", "24.33N", "081.47W", "5", "US"],
    ["FL KEY W/BOCA CHICA", "KBYX", "BYX", "None", "24.36N", "081.42W", "2", "US"],
    ["FL KISSIMMEE/ORLAND", "KISM", "ISM", "None", "28.17N", "081.26W", "25", "US"],
    ["FL LA BELLE", "KX14", "X14", "None", "26.44N", "081.26W", "6", "US"],
    ["FL LAKE CITY", "KLCQ", "LCQ", "None", "30.10N", "082.35W", "62", "US"],
    ["FL LAKELAND REGIONA", "KLAL", "LAL", "None", "27.58N", "082.01W", "43", "US"],
    ["FL LEESBURG", "KLEE", "LEE", "None", "28.49N", "081.49W", "23", "US"],
    ["FL LIVE OAK", "K24J", "24J", "None", "30.18N", "083.01W", "32", "US"],
    ["FL MACDILL AFB/TAMP", "KMCF", "MCF", "74788", "27.51N", "082.31W", "4", "US"],
    ["FL MARATHON", "KMTH", "MTH", "None", "24.44N", "081.03W", "2", "US"],
    ["FL MARCO ISLAND", "KMKY", "MKY", "None", "26.00N", "081.40W", "2", "US"],
    ["FL MARIANNA", "KMAI", "MAI", "None", "30.50N", "085.11W", "32", "US"],
    ["FL MAYPORT NAS", "KNRB", "NRB", "None", "30.23N", "081.25W", "5", "US"],
    ["FL MELBOURNE", "KMLB", "MLB", "72204", "28.06N", "080.39W", "11", "US"],
    ["FL MERRITT ISLAND", "KCOI", "COI", "None", "28.20N", "080.41W", "2", "US"],
    ["FL MIAMI/88D", "KAMX", "AMX", "None", "25.37N", "080.25W", "4", "US"],
    ["FL MIAMI/WFO", "KMFL", "MFL", "72202", "25.45N", "080.22W", "5", "US"],
    ["FL MIAMI/TAMIAMI", "KTMB", "TMB", "None", "25.39N", "080.26W", "2", "US"],
    ["FL MIAMI", "KMIA", "MIA", "None", "25.48N", "080.17W", "3", "US"],
    ["FL MIAMI/ARTCC", "KZMA", "ZMA", "None", "25.46N", "080.11W", "3", "US"],
    ["FL MIAMI/OPA LOCKA", "KOPF", "OPF", "None", "25.55N", "080.17W", "16", "US"],
    ["FL MIAMI BEACH", "KMBF", "MBF", "None", "25.46N", "080.08W", "1", "US"],
    ["FL MILTON/WHITING S", "KNDZ", "NDZ", "None", "30.42N", "087.01W", "54", "US"],
    ["FL NAPLES MUNICIPAL", "KAPF", "APF", "None", "26.09N", "081.46W", "3", "US"],
    ["FL NASA SHUTTLE FCL", "KTTS", "TTS", "None", "28.37N", "080.43W", "3", "US"],
    ["FL NATL HURR CENTER", "KNHC", "NHC", "None", "25.44N", "080.16W", "3", "US"],
    ["FL NEW PORT RICHEY", "KRRF", "RRF", "None", "28.11N", "082.38W", "12", "US"],
    ["FL NEW SMYRNA BEACH", "KEVB", "EVB", "None", "29.03N", "080.57W", "3", "US"],
    ["FL OCALA MUNI", "KOCF", "OCF", "None", "29.10N", "082.13W", "27", "US"],
    ["FL OCEAN REEF", "KOCR", "OCR", "None", "25.18N", "080.16W", "2", "US"],
    ["FL OKEECHOBEE CTY", "KOBE", "OBE", "None", "27.16N", "080.51W", "11", "US"],
    ["FL ORLANDO", "KMCO", "MCO", "72205", "28.25N", "081.20W", "29", "US"],
    ["FL ORLANDO", "KORL", "ORL", "None", "28.33N", "081.20W", "37", "US"],
    ["FL ORMOND BEACH VOR", "KOMN", "OMN", "None", "29.18N", "081.07W", "9", "US"],
    ["FL PALATKA", "K28J", "28J", "None", "29.40N", "081.41W", "15", "US"],
    ["FL PALM COAST", "KFIN", "FIN", "None", "29.28N", "081.13W", "10", "US"],
    ["FL PANAMA CITY", "KECP", "ECP", "None", "30.21N", "085.48W", "21", "US"],
    ["FL PATRICK AFB/COCO", "KCOF", "COF", "74795", "28.14N", "080.36W", "3", "US"],
    ["FL PENSACOLA", "KPNS", "PNS", "72222", "30.29N", "087.11W", "38", "US"],
    ["FL PENSACOLA NAS", "KNPA", "NPA", "None", "30.21N", "087.19W", "9", "US"],
    ["FL PERRY FOLEY", "K40J", "40J", "None", "30.04N", "083.34W", "13", "US"],
    ["FL PLANT CITY MUNI", "KPCM", "PCM", "None", "28.00N", "082.10W", "47", "US"],
    ["FL POMPANO BEACH", "KPMP", "PMP", "None", "26.15N", "080.07W", "6", "US"],
    ["FL PORT RICHEY", "KX41", "X41", "None", "28.21N", "082.37W", "12", "US"],
    ["FL PUNTA GORDA", "KPGD", "PGD", "None", "26.55N", "082.00W", "7", "US"],
    ["FL QUINCY", "K2J9", "2J9", "None", "30.36N", "084.33W", "69", "US"],
    ["FL SANFORD/ORLANDO", "KSFB", "SFB", "None", "28.46N", "081.13W", "17", "US"],
    ["FL SARASOTA/BRADENT", "KSRQ", "SRQ", "None", "27.24N", "082.34W", "18", "US"],
    ["FL SEBASTIAN", "KX26", "X26", "None", "27.49N", "080.30W", "6", "US"],
    ["FL SEBRING", "KSEF", "SEF", "None", "27.27N", "081.21W", "19", "US"],
    ["FL ST AUGUSTINE", "KSGJ", "SGJ", "99441", "29.58N", "081.19W", "3", "US"],
    ["FL ST PETERSBURG", "KPIE", "PIE", "None", "27.55N", "082.41W", "4", "US"],
    ["FL ST PETERS/ALBERT", "KSPG", "SPG", "None", "27.46N", "082.38W", "2", "US"],
    ["FL STUART/WITHAM", "KSUA", "SUA", "None", "27.11N", "080.13W", "6", "US"],
    ["FL TALLAHASSEE", "KTLH", "TLH", "72214", "30.24N", "084.21W", "19", "US"],
    ["FL TALLAHASSEE/WFO", "KTAE", "TAE", "None", "30.24N", "084.20W", "16", "US"],
    ["FL TAMPA", "KTPA", "TPA", "72211", "27.58N", "082.32W", "11", "US"],
    ["FL TAMPA/O KNIGHT", "KTPF", "TPF", "None", "27.55N", "082.27W", "3", "US"],
    ["FL TAMPA BAY/RUSKIN", "KTBW", "TBW", "72210", "27.42N", "082.24W", "12", "US"],
    ["FL TAMPA/VANDENBURG", "KVDF", "VDF", "None", "28.01N", "082.20W", "7", "US"],
    ["FL TITUSVILLE", "KTIX", "TIX", "None", "28.30N", "080.48W", "11", "US"],
    ["FL TYNDALL AFB", "KPAM", "PAM", "74775", "30.04N", "085.34W", "5", "US"],
    ["FL TYNDALL DRONE", "KTDR", "TDR", "None", "30.03N", "085.31W", "5", "US"],
    ["FL VENICE", "KVNC", "VNC", "None", "27.04N", "082.26W", "6", "US"],
    ["FL VERO BEACH", "KVRB", "VRB", "None", "27.39N", "080.25W", "10", "US"],
    ["FL VERO BEACH", "KTRV", "TRV", "None", "27.39N", "080.25W", "10", "US"],
    ["FL THE VILLAGES", "KVVG", "VVG", "None", "28.57N", "081.58W", "27", "US"],
    ["FL WEST PALM BEACH", "KPBI", "PBI", "72203", "26.41N", "080.06W", "6", "US"],
    ["FL WHITING FLD NAS", "KNSE", "NSE", "None", "30.44N", "087.01W", "61", "US"],
    ["FL WILLISTON", "KX60", "X60", "None", "29.21N", "082.28W", "23", "US"],
    ["FL WINTER HAVEN", "KGIF", "GIF", "None", "28.04N", "081.45W", "43", "US"],
    ["FL ZEPHYRHILLS", "KZPH", "None", "None", "28.14N", "082.09W", "26", "US"],
    ["FL ALLIGATOR REEF", "None", "None", "99431", "24.51N", "080.22W", "1", "US"],
    ["FL APALACHICOLA", "KAQQ", "AQQ", "None", "29.44N", "085.02W", "5", "US"],
    ["FL ASTOR", "K90J", "90J", "None", "29.07N", "081.34W", "33", "US"],
    ["FL AVON PARK", "KAGR", "AGR", "74796", "27.39N", "081.20W", "20", "US"],
    ["FL CAPE SAN BLAS", "None", "None", "72224", "29.41N", "085.21W", "1", "US"],
    ["FL CAPE SAN BLAS", "None", "None", "99436", "29.40N", "085.37W", "2", "US"],
    ["FL DEERFIELD BEACH", "None", "None", "99417", "26.19N", "080.55W", "2", "US"],
    ["FL EGLIN AFB", "None", "2EG", "None", "30.34N", "086.19W", "48", "US"],
    ["FL INVERNESS", "KX40", "X40", "None", "28.48N", "082.19W", "15", "US"],
    ["FL LAKE WORTH", "None", "None", "99405", "26.37N", "080.58W", "5", "US"],
    ["FL MOLASSES REEF", "None", "None", "99443", "25.01N", "080.37W", "1", "US"],
    ["FL PALM COAST", "KXFL", "XFL", "None", "29.28N", "081.13W", "10", "US"],
    ["FL PANAMA CITY", "KPFN", "PFN", "None", "30.12N", "085.41W", "12", "US"],
    ["FL SETTLEMENT POIN", "None", "None", "99439", "26.40N", "079.00W", "2", "US"],
    ["FL SOMBRERO KEY", "None", "None", "99445", "24.37N", "081.52W", "1", "US"],
    ["FL ST JOHNS LIGHT", "None", "None", "99415", "30.22N", "081.36W", "5", "US"],
    ["FL VENICE PIER", "None", "None", "99422", "27.04N", "082.33W", "4", "US"],
    ["FL HURLBERT", "KQHY", "None", "None", "30.24N", "086.39W", "8", "US"],
    ["FL HURLBERT", "KQBL", "None", "None", "30.24N", "086.39W", "6", "US"],
    ["GA ALBANY", "KABY", "ABY", "72216", "31.32N", "084.12W", "58", "US"],
    ["GA AMERICUS", "KACJ", "ACJ", "None", "32.07N", "084.11W", "143", "US"],
    ["GA PECAN (ALBANY)", "KPZD", "PZD", "None", "31.39N", "084.18W", "85", "US"],
    ["GA ALMA", "KAMG", "AMG", "None", "31.32N", "082.30W", "59", "US"],
    ["GA ATHENS", "KAHN", "AHN", "72311", "33.57N", "083.20W", "244", "US"],
    ["GA ATLANTA", "KATL", "ATL", "72219", "33.38N", "084.27W", "296", "US"],
    ["GA ATLANTA/FULTON", "KFTY", "FTY", "None", "33.47N", "084.31W", "263", "US"],
    ["GA ATLANTA/PAULDING", "KPUJ", "PUJ", "None", "33.55N", "084.56W", "393", "US"],
    ["GA ATLANTA/RFC", "KATR", "ATR", "None", "33.22N", "084.34W", "312", "US"],
    ["GA ATLANTA/ARTCC", "KZTL", "ZTL", "None", "33.23N", "084.20W", "312", "US"],
    ["GA GRIFFIN-SPALDING", "K6A2", "6A2", "None", "33.14N", "084.16W", "292", "US"],
    ["GA AUGUSTA/DANIEL", "KDNL", "DNL", "None", "33.28N", "082.02W", "130", "US"],
    ["GA AUGUSTA/BUSH", "KAGS", "AGS", "72218", "33.22N", "081.58W", "44", "US"],
    ["GA BAINBRIDGE", "KBGE", "BGE", "None", "30.58N", "084.38W", "43", "US"],
    ["GA BAXLEY", "KBHC", "BHC", "None", "31.43N", "082.24W", "62", "US"],
    ["GA BLAIRSVILLE", "KDZJ", "DZJ", "None", "34.51N", "084.00W", "582", "US"],
    ["GA BLAKELY EARLY C", "KBIJ", "BIJ", "None", "31.24N", "084.54W", "65", "US"],
    ["GA BRUNSWICK", "KSSI", "SSI", "None", "31.09N", "081.23W", "6", "US"],
    ["GA BRUNSWICK/GLYNCO", "KBQK", "BQK", "None", "31.15N", "081.28W", "8", "US"],
    ["GA BUTLER", "K6A1", "6A1", "None", "32.34N", "084.15W", "203", "US"],
    ["GA CALHOUN", "KCZL", "CZL", "None", "34.27N", "084.56W", "200", "US"],
    ["GA CAMILLA", "KCXU", "CXU", "None", "31.13N", "084.14W", "54", "US"],
    ["GA CANON/FRANKLIN", "K18A", "18A", "None", "34.21N", "083.08W", "271", "US"],
    ["GA CANTON/CHEROKEE", "KCNI", "CNI", "None", "34.19N", "084.25W", "372", "US"],
    ["GA CARROLLTON/GRAY", "KCTJ", "CTJ", "None", "33.38N", "085.09W", "354", "US"],
    ["GA CARTERSVILLE", "KVPC", "VPC", "None", "34.08N", "084.51W", "222", "US"],
    ["GA CLAXTON/EVANS CO", "KCWV", "CWV", "None", "32.12N", "081.52W", "33", "US"],
    ["GA COLUMBUS", "KCSG", "CSG", "None", "32.31N", "084.57W", "135", "US"],
    ["GA CORDELE", "KCKF", "CKF", "None", "31.59N", "083.46W", "91", "US"],
    ["GA CORNELIA", "KAJR", "AJR", "None", "34.30N", "083.33W", "442", "US"],
    ["GA COVINGTON", "KCVC", "CVC", "None", "33.38N", "083.51W", "247", "US"],
    ["GA DALTON", "KDNN", "DNN", "None", "34.43N", "084.52W", "216", "US"],
    ["GA DOBBINS AFB/MARI", "KMGE", "MGE", "72227", "33.55N", "084.31W", "326", "US"],
    ["GA DOUGLAS MUNI", "KDQH", "DQH", "None", "31.29N", "082.52W", "78", "US"],
    ["GA DUBLIN", "KDBN", "DBN", "None", "32.34N", "082.59W", "94", "US"],
    ["GA EASTMAN", "KEZM", "EZM", "None", "32.13N", "083.08W", "93", "US"],
    ["GA ELBERTON PATZ F", "KEBA", "EBA", "None", "34.06N", "082.49W", "184", "US"],
    ["GA ELLIJAY", "K49A", "49A", "None", "34.38N", "084.32W", "453", "US"],
    ["GA FITZGERALD", "KFZG", "FZG", "None", "31.41N", "083.16W", "111", "US"],
    ["GA FT BENNING/COLUM", "KLSF", "LSF", "72225", "32.19N", "084.58W", "71", "US"],
    ["GA FT STEWART/WRIGH", "KLHW", "LHW", "72209", "31.52N", "081.34W", "14", "US"],
    ["GA GAINESVILLE", "KGVL", "GVL", "None", "34.16N", "083.50W", "386", "US"],
    ["GA GREENSBORO", "K3J7", "3J7", "None", "33.36N", "083.08W", "206", "US"],
    ["GA HAMPTON", "KHMP", "HMP", "None", "33.23N", "084.20W", "269", "US"],
    ["GA HAZELHURST", "KAZE", "AZE", "None", "31.53N", "082.39W", "78", "US"],
    ["GA HOMERVILLE", "KHOE", "HOE", "None", "31.03N", "082.47W", "57", "US"],
    ["GA JASPER", "KJZP", "JZP", "None", "34.27N", "084.27W", "468", "US"],
    ["GA JEFFERSON", "KJCA", "JCA", "None", "34.11N", "083.34W", "290", "US"],
    ["GA JESUP/WAYNE CTY", "KJES", "JES", "None", "31.33N", "081.53W", "33", "US"],
    ["GA LAFAYETTE", "K9A5", "9A5", "None", "34.41N", "085.17W", "323", "US"],
    ["GA LA GRANGE", "KLGC", "LGC", "None", "33.00N", "085.04W", "211", "US"],
    ["GA LAWRENCEVILLE", "KLZU", "LZU", "None", "33.59N", "083.58W", "323", "US"],
    ["GA MACON", "KMCN", "MCN", "72217", "32.41N", "083.39W", "109", "US"],
    ["GA MARIETTA MCCOLUM", "KRYY", "RYY", "None", "34.01N", "084.36W", "317", "US"],
    ["GA MCDUFFIE/THOMSON", "KHQU", "HQU", "None", "33.32N", "082.31W", "152", "US"],
    ["GA MILLEDGEVILLE", "KMLJ", "MLJ", "None", "33.09N", "083.14W", "117", "US"],
    ["GA MOODY AFB/VALDOS", "KVAD", "VAD", "74781", "30.58N", "083.12W", "71", "US"],
    ["GA MOODY AFB/88D", "KVAX", "VAX", "None", "30.53N", "083.00W", "54", "US"],
    ["GA MOULTRIE MUNI", "KMGR", "MGR", "None", "31.05N", "083.48W", "90", "US"],
    ["GA MOULTRIE/SPENCE", "KMUL", "MUL", "None", "31.08N", "083.42W", "89", "US"],
    ["GA NEWNAN", "KCCO", "CCO", "None", "33.19N", "084.46W", "296", "US"],
    ["GA PEACHTREE/DEKALB", "KPDK", "PDK", "None", "33.53N", "084.18W", "302", "US"],
    ["GA PEACHTREE CITY", "KFFC", "FFC", "72215", "33.21N", "084.34W", "262", "US"],
    ["GA PERRY", "KPXE", "PXE", "None", "32.31N", "083.46W", "128", "US"],
    ["GA PINE MOUNTAIN", "KPIM", "PIM", "None", "32.50N", "084.53W", "275", "US"],
    ["GA ATLANTA RFC", "KALR", "ALR", "None", "33.22N", "084.34W", "248", "US"],
    ["GA ROBINS AFB/88D", "KJGX", "JGX", "None", "32.41N", "083.21W", "159", "US"],
    ["GA ROME", "KRMG", "RMG", "72320", "34.21N", "085.10W", "193", "US"],
    ["GA SANDERSVILLE", "KOKZ", "OKZ", "None", "32.58N", "082.50W", "134", "US"],
    ["GA SAVANNAH", "KSAV", "SAV", "72207", "32.07N", "081.12W", "14", "US"],
    ["GA SAVANNAH/HUNTER", "KSVN", "SVN", "74780", "32.01N", "081.09W", "13", "US"],
    ["GA STATESBORO", "KTBR", "TBR", "None", "32.29N", "081.44W", "57", "US"],
    ["GA SWAINSBORO", "KSBO", "SBO", "None", "32.37N", "082.22W", "100", "US"],
    ["GA SYLVANIA", "KJYL", "JYL", "None", "32.39N", "081.36W", "57", "US"],
    ["GA TIFTON", "KTMA", "TMA", "None", "31.26N", "083.29W", "109", "US"],
    ["GA THOMASTON UPSON", "KOPN", "OPN", "None", "32.57N", "084.16W", "243", "US"],
    ["GA THOMASVILLE", "KTVI", "TVI", "None", "30.54N", "083.53W", "80", "US"],
    ["GA TOCCOA", "KTOC", "TOC", "None", "34.36N", "083.18W", "304", "US"],
    ["GA TOCCOA VOR", "KODF", "ODF", "None", "34.42N", "083.18W", "567", "US"],
    ["GA VALDOSTA REGIONA", "KVLD", "VLD", "None", "30.47N", "083.16W", "62", "US"],
    ["GA VIDALIA MUNI", "KVDI", "VDI", "None", "32.12N", "082.22W", "84", "US"],
    ["GA WARNER ROBINS AF", "KWRB", "WRB", "None", "32.37N", "083.35W", "90", "US"],
    ["GA WASHINGTON", "KIIY", "IIY", "None", "33.47N", "082.49W", "197", "US"],
    ["GA WAYCROSS/WARE CO", "KAYS", "AYS", "72213", "31.15N", "082.24W", "46", "US"],
    ["GA WINDER/BARROW", "KWDR", "WDR", "None", "33.59N", "083.40W", "287", "US"],
    ["GA BLAKELY EARLY C", "K11J", "11J", "None", "31.24N", "084.54W", "65", "US"],
    ["GA CANTON/CHEROKEE", "K47A", "47A", "None", "34.19N", "084.25W", "372", "US"],
    ["GA COVINGTON", "K9A1", "9A1", "None", "33.38N", "083.51W", "247", "US"],
    ["GA ELBERTON PATZ F", "K27A", "27A", "None", "34.06N", "082.49W", "184", "US"],
    ["GA JEFFERSON", "K19A", "19A", "None", "34.11N", "083.34W", "290", "US"],
    ["GA SAVANNAH LIGHT", "None", "None", "99438", "31.57N", "080.19W", "1", "US"],
    ["HI BARKING SANDS/KA", "PHBK", "BKH", "91162", "22.02N", "159.47W", "8", "US"],
    ["HI BRADSHAW AAF/HAW", "PHSF", "BSF", "None", "19.46N", "155.33W", "1887", "US"],
    ["HI HANA", "PHHN", "HNM", "91199", "20.48N", "156.01W", "24", "US"],
    ["HI HICKAM AFB", "PHIK", "HIK", "None", "21.19N", "157.56W", "4", "US"],
    ["HI HICKAM AWC", "PHWR", "HWR", "None", "21.19N", "157.56W", "4", "US"],
    ["HI HILO", "PHTO", "ITO", "91285", "19.43N", "155.03W", "12", "US"],
    ["HI HONOLULU", "PHNL", "HNL", "91182", "21.20N", "157.55W", "4", "US"],
    ["HI HONOLULU/WFO", "PHFO", "HFO", "None", "21.19N", "157.55W", "4", "US"],
    ["HI HONOLULU/ARTCC", "PZHN", "ZHN", "None", "21.19N", "157.55W", "4", "US"],
    ["HI KAANAPALI", "PHKP", "HKP", "91189", "20.56N", "156.42W", "3", "US"],
    ["HI KAHULUI", "PHOG", "OGG", "91190", "20.54N", "156.26W", "12", "US"],
    ["HI KAILUA/KONA", "PHKO", "KOA", "None", "19.44N", "156.03W", "27", "US"],
    ["HI KALAUPAPA", "PHLU", "LUP", "None", "21.13N", "156.58W", "7", "US"],
    ["HI KAMUELA/WAIMEA", "PHMU", "MUE", "None", "20.00N", "155.40W", "817", "US"],
    ["HI KOHALA 88D", "PHKM", "HKM", "None", "20.08N", "155.47W", "1162", "US"],
    ["HI KANEOHE MCAS", "PHNG", "NGF", "91176", "21.26N", "157.46W", "3", "US"],
    ["HI KOKEE", "PHAC", "HAC", "91161", "22.09N", "159.39W", "1280", "US"],
    ["HI KALAELOA", "PHJR", "JRF", "91178", "21.19N", "158.04W", "15", "US"],
    ["HI LAHAINA/WEST MAU", "PHJH", "JHM", "None", "20.58N", "156.40W", "78", "US"],
    ["HI LANAI CITY AIRPO", "PHNY", "LNY", "None", "20.46N", "156.56W", "399", "US"],
    ["HI LIHUE/KAUAI IS", "PHLI", "LIH", "91165", "21.58N", "159.20W", "45", "US"],
    ["HI MOLOKAI/KUKUI", "PHMO", "HMO", "None", "21.08N", "157.11W", "415", "US"],
    ["HI MOLOKAI", "PHMK", "MKK", "91186", "21.09N", "157.06W", "141", "US"],
    ["HI NAALEHU/S HAWAII", "PHWA", "HWA", "None", "19.06N", "155.34W", "421", "US"],
    ["HI NUMILA/S KAUAI", "PHKI", "HKI", "None", "21.54N", "159.33W", "55", "US"],
    ["HI UPOLU", "PHUP", "UPP", "None", "20.16N", "155.52W", "30", "US"],
    ["HI PEARL HARBOR", "PHNC", "HNC", "None", "21.21N", "157.56W", "1", "US"],
    ["HI WHEELER AFB/OAHU", "PHHI", "HHI", "91170", "21.29N", "158.03W", "255", "US"],
    ["HI FR FRIGATE SHOAL", "None", "1Z6", "91155", "23.52N", "166.17W", "2", "US"],
    ["HI BARBERS PT NAS", "PHNA", "NAX", "None", "21.19N", "158.04W", "15", "US"],
    ["HI MIDWAY ISLAND NA", "PMDY", "MDY", "91066", "28.13N", "177.22W", "4", "US"],
    ["IA ALGONA", "KAXA", "AXA", "None", "43.04N", "094.16W", "372", "US"],
    ["IA AMES", "KAMW", "AMW", "None", "41.59N", "093.37W", "279", "US"],
    ["IA ANKENY", "KIKV", "IKV", "None", "41.41N", "093.34W", "275", "US"],
    ["IA ATLANTIC", "KAIO", "AIO", "None", "41.23N", "095.02W", "360", "US"],
    ["IA AUDUBON", "KADU", "ADU", "None", "41.42N", "094.55W", "392", "US"],
    ["IA BOONE MUNI", "KBNW", "BNW", "None", "42.02N", "093.50W", "354", "US"],
    ["IA BURLINGTON", "KBRL", "BRL", "None", "40.46N", "091.08W", "211", "US"],
    ["IA CARROLL", "KCIN", "CIN", "None", "42.02N", "094.46W", "375", "US"],
    ["IA CEDAR RAPIDS", "KCID", "CID", "72545", "41.53N", "091.43W", "264", "US"],
    ["IA CENTERVILLE MUNI", "KTVK", "TVK", "None", "40.41N", "092.54W", "314", "US"],
    ["IA CHARITON", "KCNC", "CNC", "None", "41.01N", "093.22W", "320", "US"],
    ["IA CHARLES CITY", "KCCY", "CCY", "None", "43.04N", "092.37W", "343", "US"],
    ["IA CHEROKEE", "KCKP", "CKP", "None", "42.44N", "095.33W", "374", "US"],
    ["IA CLARINDA", "KICL", "ICL", "None", "40.43N", "095.01W", "303", "US"],
    ["IA CLARION", "KCAV", "CAV", "None", "42.45N", "093.46W", "354", "US"],
    ["IA CLINTON MUNI", "KCWI", "CWI", "None", "41.49N", "090.19W", "216", "US"],
    ["IA COUNCIL BLUFFS", "KCBF", "CBF", "None", "41.16N", "095.46W", "382", "US"],
    ["IA CRESTON", "KCSQ", "CSQ", "None", "41.01N", "094.22W", "394", "US"],
    ["IA DAVENPORT/QUAD C", "KDVN", "DVN", "74455", "41.37N", "090.35W", "230", "US"],
    ["IA DECORAH", "KDEH", "DEH", "None", "43.16N", "091.43W", "353", "US"],
    ["IA DENISON", "KDNS", "DNS", "None", "41.58N", "095.22W", "388", "US"],
    ["IA DES MOINES", "KDSM", "DSM", "72546", "41.32N", "093.40W", "295", "US"],
    ["IA DUBUQUE", "KDBQ", "DBQ", "72547", "42.24N", "090.42W", "326", "US"],
    ["IA ESTHERVILLE", "KEST", "EST", "None", "43.24N", "094.45W", "401", "US"],
    ["IA FAIRFIELD", "KFFL", "FFL", "None", "41.02N", "091.58W", "244", "US"],
    ["IA FOREST CITY", "KFXY", "FXY", "None", "43.14N", "093.37W", "375", "US"],
    ["IA FORT DODGE", "KFOD", "FOD", "72549", "42.32N", "094.10W", "355", "US"],
    ["IA FORT MADISON", "KFSW", "FSW", "None", "40.40N", "091.19W", "221", "US"],
    ["IA GRINNELL REG", "KGGI", "GGI", "None", "41.43N", "092.44W", "307", "US"],
    ["IA HARLAN MUNI", "KHNR", "HNR", "None", "41.35N", "095.20W", "375", "US"],
    ["IA INDEPENDENCE", "KIIB", "IIB", "None", "42.27N", "091.57W", "298", "US"],
    ["IA IOWA CITY", "KIOW", "IOW", "None", "41.38N", "091.33W", "198", "US"],
    ["IA IOWA FALLS MUNI", "KIFA", "IFA", "None", "42.28N", "093.16W", "347", "US"],
    ["IA JOHNSTON/DESMOIN", "KDMX", "DMX", "None", "41.44N", "093.43W", "299", "US"],
    ["IA KEOKUK MUNI", "KEOK", "EOK", "None", "40.28N", "091.25W", "205", "US"],
    ["IA KNOXVILLE", "KOXV", "OXV", "None", "41.17N", "093.07W", "283", "US"],
    ["IA LAMONI", "KLWD", "LWD", "None", "40.38N", "093.54W", "346", "US"],
    ["IA LAMONI", "KLMN", "LMN", "None", "40.36N", "093.58W", "348", "US"],
    ["IA LE MARS", "KLRJ", "LRJ", "None", "42.46N", "096.12W", "365", "US"],
    ["IA MARSHALLTOWN", "KMIW", "MIW", "None", "42.07N", "092.55W", "296", "US"],
    ["IA MASON CITY", "KMCW", "MCW", "None", "43.09N", "093.20W", "369", "US"],
    ["IA MONTICELLO MUNI", "KMXO", "MXO", "None", "42.13N", "091.10W", "259", "US"],
    ["IA MT PLEASANT", "KMPZ", "MPZ", "None", "40.57N", "091.31W", "224", "US"],
    ["IA MUSCATINE", "KMUT", "MUT", "None", "41.22N", "091.09W", "167", "US"],
    ["IA NEWTON MUNI", "KTNU", "TNU", "None", "41.40N", "093.01W", "290", "US"],
    ["IA OELWEN", "KOLZ", "OLZ", "None", "42.40N", "091.58W", "328", "US"],
    ["IA ORANGE CITY", "KORC", "ORC", "None", "42.58N", "096.04W", "431", "US"],
    ["IA OSCEOLA MUNI", "KI75", "I75", "None", "41.03N", "093.41W", "339", "US"],
    ["IA OSKALOOSA MUNI", "KOOA", "OOA", "None", "41.14N", "092.30W", "256", "US"],
    ["IA OTTUMWA", "KOTM", "OTM", "None", "41.06N", "092.27W", "256", "US"],
    ["IA PELLA", "KPEA", "PEA", "None", "41.24N", "092.57W", "270", "US"],
    ["IA PERRY MUNI", "KPRO", "PRO", "None", "41.50N", "094.10W", "308", "US"],
    ["IA RED OAK", "KRDK", "RDK", "None", "41.01N", "095.16W", "318", "US"],
    ["IA SHELDON", "KSHL", "SHL", "None", "43.13N", "095.49W", "432", "US"],
    ["IA SHENANDOAH MUNI", "KSDA", "SDA", "None", "40.45N", "095.25W", "296", "US"],
    ["IA SIOUX CITY", "KSUX", "SUX", "72557", "42.23N", "096.23W", "338", "US"],
    ["IA SLATER PROFILER", "None", "SLA", "74449", "41.53N", "093.41W", "315", "US"],
    ["IA SPENCER", "KSPW", "SPW", "72650", "43.10N", "095.13W", "403", "US"],
    ["IA STORM LAKE", "KSLB", "SLB", "None", "42.36N", "095.13W", "454", "US"],
    ["IA VINTON", "KVTI", "VTI", "None", "42.13N", "092.01W", "255", "US"],
    ["IA WASHINGTON", "KAWG", "AWG", "None", "41.16N", "091.40W", "230", "US"],
    ["IA WATERLOO", "KALO", "ALO", "72548", "42.33N", "092.24W", "264", "US"],
    ["IA WEBSTER CITY", "KEBS", "EBS", "None", "42.25N", "093.52W", "342", "US"],
    ["IA LAMONI", "K0Y7", "0Y7", "None", "40.38N", "093.54W", "346", "US"],
    ["IA LAMONI", "K3OI", "3OI", "None", "40.37N", "093.57W", "342", "US"],
    ["IA SPENCER", "K3SE", "3SE", "None", "43.10N", "095.09W", "404", "US"],
    ["IA ADAIR I80", "XADA", "None", "None", "41.29N", "094.43W", "450", "US"],
    ["IA ALGONA US18", "XALG", "None", "None", "43.05N", "094.23W", "337", "US"],
    ["IA ALTON IA10", "XATN", "None", "None", "42.49N", "096.05W", "430", "US"],
    ["IA ALTOONA I80/US65", "XALT", "None", "None", "41.40N", "093.31W", "262", "US"],
    ["IA AMES I35", "XAME", "None", "None", "42.02N", "093.34W", "313", "US"],
    ["IA ANKENY I35", "XANK", "None", "None", "41.46N", "093.34W", "264", "US"],
    ["IA AVOCA I80", "XAVO", "None", "None", "41.29N", "095.17W", "377", "US"],
    ["IA BURLINGTON US34", "XBUR", "None", "None", "40.49N", "091.05W", "218", "US"],
    ["IA CARROLL US30", "XCAR", "None", "None", "42.05N", "094.53W", "389", "US"],
    ["IA CEDAR RAPIDS 380", "XCDR", "None", "None", "41.49N", "091.40W", "236", "US"],
    ["IA CEDAR RAPID US30", "XCID", "None", "None", "41.56N", "091.41W", "246", "US"],
    ["IA CENTERVILLE IA2", "XCEN", "None", "None", "40.44N", "093.00W", "295", "US"],
    ["IA COUNCIL BLUFF 80", "XCOU", "None", "None", "41.14N", "095.52W", "268", "US"],
    ["IA CRESTON US34", "XCRE", "None", "None", "41.04N", "094.18W", "388", "US"],
    ["IA DAVENPORT 80/280", "XDAV", "None", "None", "41.36N", "090.41W", "206", "US"],
    ["IA DECORAH IA9", "XDEC", "None", "None", "43.14N", "091.41W", "310", "US"],
    ["IA DES MOINES I35", "XDSM", "None", "None", "41.32N", "093.46W", "224", "US"],
    ["IA DES MOINES I235", "XDES", "None", "None", "41.35N", "093.37W", "281", "US"],
    ["IA DE SOTO 80/US169", "XDST", "None", "None", "41.32N", "094.06W", "291", "US"],
    ["IA DE WITT US30/61", "XDEW", "None", "None", "41.50N", "090.34W", "240", "US"],
    ["IA DUBUQUE US20", "XDUB", "None", "None", "42.29N", "090.44W", "250", "US"],
    ["IA FORT DODGE US20", "XFOD", "None", "None", "42.26N", "094.11W", "286", "US"],
    ["IA GRINNELL I80", "XGRI", "None", "None", "41.41N", "092.44W", "281", "US"],
    ["IA IOWA CITY US218", "XIAC", "None", "None", "41.38N", "091.35W", "254", "US"],
    ["IA IOWA CITY I80", "XIOW", "None", "None", "41.41N", "091.35W", "250", "US"],
    ["IA JEFFERSON IA4", "XJEF", "None", "None", "42.03N", "094.23W", "310", "US"],
    ["IA LEON I35/IA2", "XLEO", "None", "None", "40.44N", "093.50W", "349", "US"],
    ["IA MANCHESTER US20", "XMAN", "None", "None", "42.26N", "091.26W", "309", "US"],
    ["IA MAQUOKETA 61/64", "XMAQ", "None", "None", "42.04N", "090.41W", "251", "US"],
    ["IA MARSHALTOWN US30", "XMAR", "None", "None", "42.01N", "092.58W", "291", "US"],
    ["IA MASON CITY I35", "XMCW", "None", "None", "43.02N", "093.20W", "376", "US"],
    ["IA MISSOURI VAL I29", "XMIS", "None", "None", "41.32N", "095.55W", "309", "US"],
    ["IA MT PLEASANT U218", "XMOU", "None", "None", "40.53N", "091.33W", "133", "US"],
    ["IA NEW HAMPTON US18", "XNEW", "None", "None", "43.02N", "092.28W", "327", "US"],
    ["IA ONAWA I29", "XONA", "None", "None", "41.52N", "096.01W", "303", "US"],
    ["IA OSCEOLA I35", "XOSC", "None", "None", "41.02N", "093.47W", "334", "US"],
    ["IA OTTUMWA US63", "XOTT", "None", "None", "41.01N", "092.25W", "196", "US"],
    ["IA PELLA IA163", "XPEL", "None", "None", "41.23N", "092.52W", "271", "US"],
    ["IA RED OAK US34/71", "XRED", "None", "None", "40.59N", "094.59W", "290", "US"],
    ["IA SIDNEY I29/IA2", "XSID", "None", "None", "40.41N", "095.47W", "287", "US"],
    ["IA SIGOURNEY IA92", "XSIG", "None", "None", "41.20N", "092.19W", "202", "US"],
    ["IA SIOUX CITY I29", "XSIO", "None", "None", "42.29N", "096.23W", "364", "US"],
    ["IA SPENCER US18", "XSPE", "None", "None", "43.08N", "095.05W", "452", "US"],
    ["IA STORM LAKE 71/3", "XSTO", "None", "None", "42.44N", "095.09W", "405", "US"],
    ["IA TIPTON I80", "XTIP", "None", "None", "41.38N", "091.08W", "236", "US"],
    ["IA URBANA I380", "XURB", "None", "None", "42.19N", "091.59W", "302", "US"],
    ["IA WATERLOO US20", "XWAT", "None", "None", "42.27N", "092.19W", "269", "US"],
    ["IA WILLIAMS I35", "XWIL", "None", "None", "42.32N", "093.34W", "325", "US"],
    ["IA WILLAIMSBURG I80", "XWBG", "None", "None", "41.41N", "092.01W", "260", "US"],
    ["IA HANLONTOWN I35", "XHAN", "None", "None", "43.23N", "093.20W", "333", "US"],
    ["IA STEAMBOAT R US20", "XSBI", "None", "None", "42.27N", "093.03W", "348", "US"],
    ["IA IDA GROVE US59", "XIGI", "None", "None", "42.21N", "095.29W", "376", "US"],
    ["IA CEDAR RAPIDS U30", "XCRI", "None", "None", "41.56N", "091.33W", "232", "US"],
    ["IA BEDFORD", "XBFI", "None", "None", "40.41N", "094.43W", "357", "US"],
    ["IA COLFAX", "XCFI", "None", "None", "41.41N", "093.16W", "247", "US"],
    ["IA EDDYVILLE", "XDYI", "None", "None", "41.09N", "092.39W", "244", "US"],
    ["IA SIBLEY", "XSYI", "None", "None", "43.26N", "095.43W", "480", "US"],
    ["IA TAMA", "XTMI", "None", "None", "41.58N", "092.18W", "250", "US"],
    ["IA CANTRIL", "XCTI", "None", "None", "40.40N", "092.04W", "211", "US"],
    ["IA DENISON", "XDNI", "None", "None", "41.55N", "095.20W", "426", "US"],
    ["IA PLAINFIELD", "XPFI", "None", "None", "42.50N", "092.32W", "294", "US"],
    ["IA QUAD CITIES", "XQCI", "None", "None", "41.31N", "090.31W", "177", "US"],
    ["IA STATE FAIR", "Q03I", "None", "None", "41.36N", "093.34W", "333", "US"],
    ["IA ADAIR", "QADI", "None", "None", "41.31N", "094.35W", "417", "US"],
    ["IA ADEL", "QAEI", "None", "None", "41.37N", "094.01W", "292", "US"],
    ["IA AFTON", "QAFI", "None", "None", "41.02N", "094.11W", "387", "US"],
    ["IA ALGONA", "QAGI", "None", "None", "43.04N", "094.14W", "341", "US"],
    ["IA ANKENY", "QAKI", "None", "None", "41.44N", "093.37W", "310", "US"],
    ["IA ALBIA", "QALI", "None", "None", "41.02N", "092.49W", "312", "US"],
    ["IA AMES", "QAMI", "None", "None", "42.03N", "093.38W", "309", "US"],
    ["IA ANITA", "QATI", "None", "None", "41.27N", "094.46W", "387", "US"],
    ["IA AUDUBON", "QAUI", "None", "None", "41.43N", "094.55W", "426", "US"],
    ["IA BEDFORD", "QBDI", "None", "None", "40.40N", "094.43W", "350", "US"],
    ["IA BELMOND", "QBKI", "None", "None", "42.51N", "093.36W", "372", "US"],
    ["IA BLOOMFIELD", "QBMI", "None", "None", "40.45N", "092.25W", "260", "US"],
    ["IA BOONE", "QBOI", "None", "None", "42.02N", "093.47W", "353", "US"],
    ["IA BROOKLYN", "QBRI", "None", "None", "41.44N", "092.27W", "280", "US"],
    ["IA BUSSEY", "QBSI", "None", "None", "41.13N", "092.53W", "265", "US"],
    ["IA BAXTER", "QBXI", "None", "None", "41.50N", "093.09W", "304", "US"],
    ["IA BLANK PARK ZOO", "QBZI", "None", "None", "41.32N", "093.37W", "294", "US"],
    ["IA CARROLL", "QCAI", "None", "None", "42.04N", "094.52W", "423", "US"],
    ["IA COON RAPIDS", "QCBI", "None", "None", "41.53N", "094.41W", "386", "US"],
    ["IA CHARLES CITY", "QCCI", "None", "None", "43.04N", "092.40W", "304", "US"],
    ["IA CORYDON", "QCDI", "None", "None", "40.45N", "093.19W", "331", "US"],
    ["IA CENTERVILLE", "QCEI", "None", "None", "40.44N", "092.52W", "299", "US"],
    ["IA CLARION", "QCGI", "None", "None", "42.44N", "093.44W", "377", "US"],
    ["IA CHARITON", "QCHI", "None", "None", "41.01N", "093.19W", "332", "US"],
    ["IA CLEAR LAKE", "QCKI", "None", "None", "43.08N", "093.22W", "368", "US"],
    ["IA CRESCO", "QCQI", "None", "None", "43.23N", "092.06W", "390", "US"],
    ["IA CORNING", "QCNI", "None", "None", "40.59N", "094.44W", "390", "US"],
    ["IA COLO", "QCOI", "None", "None", "42.01N", "093.19W", "315", "US"],
    ["IA CRESTON", "QCRI", "None", "None", "41.04N", "094.22W", "417", "US"],
    ["IA INWOOD", "QCSI", "None", "None", "43.19N", "096.26W", "449", "US"],
    ["IA DSM CHRISTIAN", "QDCI", "None", "None", "41.38N", "093.48W", "279", "US"],
    ["IA SHELDON", "QDNI", "None", "None", "43.11N", "095.50W", "433", "US"],
    ["IA RIVER WOODS", "QDRI", "None", "None", "41.34N", "093.35W", "304", "US"],
    ["IA EAGLE GROVE", "QEGI", "None", "None", "42.40N", "093.55W", "339", "US"],
    ["IA FARNHAMVILLE", "QFAI", "None", "None", "42.20N", "094.25W", "374", "US"],
    ["IA FOREST CITY", "QFCI", "None", "None", "43.16N", "093.39W", "384", "US"],
    ["IA FORT DODGE", "QFDI", "None", "None", "42.31N", "094.11W", "353", "US"],
    ["IA FONTANELLE", "QFOI", "None", "None", "41.17N", "094.34W", "423", "US"],
    ["IA GLIDDEN", "QGLI", "None", "None", "42.04N", "094.44W", "387", "US"],
    ["IA GARNER", "QGNI", "None", "None", "43.05N", "093.37W", "373", "US"],
    ["IA GRIMES", "QGRI", "None", "None", "41.41N", "093.48W", "310", "US"],
    ["IA HULL", "QHII", "None", "None", "43.11N", "096.08W", "436", "US"],
    ["IA HAMPTON", "QHPI", "None", "None", "42.45N", "093.11W", "328", "US"],
    ["IA HUMBOLDT", "QHUI", "None", "None", "42.43N", "094.14W", "379", "US"],
    ["IA ICA", "QIAI", "None", "None", "41.35N", "093.44W", "285", "US"],
    ["IA IOWA FALLS", "QIFI", "None", "None", "42.32N", "093.16W", "376", "US"],
    ["IA INDIANOLA", "QINI", "None", "None", "41.22N", "093.33W", "310", "US"],
    ["IA JORDAN CREEK", "QJCI", "None", "None", "41.34N", "093.46W", "283", "US"],
    ["IA JEFFERSON", "QJEI", "None", "None", "42.00N", "094.23W", "338", "US"],
    ["IA SOUTH HAMILTON", "QJWI", "None", "None", "42.18N", "093.39W", "340", "US"],
    ["IA KCCI", "QKCI", "None", "None", "41.35N", "093.38W", "274", "US"],
    ["IA KNOXVILLE", "QKNI", "None", "None", "41.19N", "093.07W", "301", "US"],
    ["IA KANAWHA", "QKWI", "None", "None", "42.56N", "093.47W", "369", "US"],
    ["IA LEON", "QLEI", "None", "None", "40.45N", "093.44W", "365", "US"],
    ["IA LATIMER", "QLMI", "None", "None", "42.45N", "093.22W", "398", "US"],
    ["IA LAMONI", "QLOI", "None", "None", "40.38N", "093.56W", "359", "US"],
    ["IA LUVERNE", "QLUI", "None", "None", "42.55N", "094.05W", "360", "US"],
    ["IA ROCK RAPIDS", "QLYI", "None", "None", "43.25N", "096.10W", "410", "US"],
    ["IA MARSHALLTOWN", "QMAI", "None", "None", "42.01N", "092.55W", "314", "US"],
    ["IA MADRID", "QMDI", "None", "None", "41.53N", "093.49W", "310", "US"],
    ["IA LAKE MILLS", "QMII", "None", "None", "43.25N", "093.32W", "393", "US"],
    ["IA MALLARD", "QMLI", "None", "None", "42.56N", "094.41W", "387", "US"],
    ["IA MONTEZUMA", "QMNI", "None", "None", "41.35N", "092.31W", "309", "US"],
    ["IA MOUNT AYR", "QMOI", "None", "None", "40.43N", "094.14W", "396", "US"],
    ["IA MANSON-NW", "QMSI", "None", "None", "42.30N", "094.22W", "368", "US"],
    ["IA MURRAY", "QMUI", "None", "None", "41.02N", "093.57W", "365", "US"],
    ["IA MASON CITY", "QMWI", "None", "None", "43.08N", "093.14W", "357", "US"],
    ["IA MASON CITY", "QMYI", "None", "None", "43.09N", "093.10W", "335", "US"],
    ["IA NEWTON", "QNEI", "None", "None", "41.42N", "093.02W", "305", "US"],
    ["IA THOMPSON", "QNII", "None", "None", "43.22N", "093.42W", "384", "US"],
    ["IA NORTHWOOD", "QNKI", "None", "None", "43.27N", "093.12W", "371", "US"],
    ["IA NORA SPRINGS", "QNSI", "None", "None", "43.09N", "093.00W", "332", "US"],
    ["IA NEVADA", "QNVI", "None", "None", "42.01N", "093.26W", "313", "US"],
    ["IA OSAGE", "QOAI", "None", "None", "43.17N", "092.49W", "353", "US"],
    ["IA OSKALOOSA", "QOCI", "None", "None", "41.18N", "092.39W", "245", "US"],
    ["IA OGDEN", "QOGI", "None", "None", "42.02N", "094.02W", "332", "US"],
    ["IA OSCEOLA", "QOSI", "None", "None", "41.02N", "093.46W", "353", "US"],
    ["IA PANORA", "QPAI", "None", "None", "41.42N", "094.22W", "356", "US"],
    ["IA PELLA", "QPEI", "None", "None", "41.25N", "092.54W", "289", "US"],
    ["IA NORTH POLK", "QPKI", "None", "None", "41.47N", "093.43W", "286", "US"],
    ["IA PERRY", "QPYI", "None", "None", "41.50N", "094.05W", "312", "US"],
    ["IA MASON CITY", "QRMI", "None", "None", "43.08N", "093.06W", "328", "US"],
    ["IA ROCKWELL CITY", "QROI", "None", "None", "42.23N", "094.38W", "384", "US"],
    ["IA ROCKFORD", "QRRI", "None", "None", "43.03N", "092.56W", "316", "US"],
    ["IA ROCKWELL", "QRSI", "None", "None", "42.59N", "093.06W", "351", "US"],
    ["IA RUSSELL", "QRUM", "None", "None", "44.19N", "095.57W", "466", "US"],
    ["IA RICEVILLE", "QRVI", "None", "None", "43.21N", "092.30W", "382", "US"],
    ["IA ST ANSGAR", "QSAI", "None", "None", "43.22N", "092.55W", "358", "US"],
    ["IA SIBLEY", "QSBI", "None", "None", "43.24N", "095.45W", "462", "US"],
    ["IA STUART", "QSTI", "None", "None", "41.30N", "094.19W", "367", "US"],
    ["IA SULLY", "QSUI", "None", "None", "41.34N", "092.50W", "289", "US"],
    ["IA TITONKA", "QTKI", "None", "None", "43.14N", "094.02W", "348", "US"],
    ["IA MESKWAKI SS TAMA", "QTQI", "None", "None", "41.59N", "092.39W", "256", "US"],
    ["IA UNION", "QUNI", "None", "None", "42.14N", "093.04W", "301", "US"],
    ["IA VENTURA", "QVTI", "None", "None", "43.08N", "093.29W", "386", "US"],
    ["IA WALL LAKE", "QWAI", "None", "None", "42.16N", "095.06W", "426", "US"],
    ["IA WEBSTER CITY", "QWBI", "None", "None", "42.28N", "093.49W", "345", "US"],
    ["IA WOODWARD", "QWGI", "None", "None", "41.52N", "093.55W", "291", "US"],
    ["IA WINTERSET", "QWII", "None", "None", "41.20N", "094.01W", "356", "US"],
    ["IA POCAHONTAS", "QPCI", "None", "None", "42.44N", "094.40W", "372", "US"],
    ["ID ADA COUNTY/BOISE", "KCBX", "CBX", "None", "43.29N", "116.14W", "933", "US"],
    ["ID BOISE", "KBOI", "BOI", "72681", "43.34N", "116.14W", "875", "US"],
    ["ID BURLEY", "KBYI", "BYI", "None", "42.33N", "113.46W", "1264", "US"],
    ["ID BONNERS FERRY", "K65S", "65S", "None", "48.44N", "116.18W", "713", "US"],
    ["ID CALDWELL", "KEUL", "EUL", "None", "43.37N", "116.37W", "740", "US"],
    ["ID CHALLIS", "KLLJ", "LLJ", "None", "44.31N", "114.13W", "1536", "US"],
    ["ID COEUR D'ALENE", "KCOE", "COE", "None", "47.46N", "116.49W", "707", "US"],
    ["ID DRIGGS REED MEM", "KDIJ", "DIJ", "None", "43.45N", "111.06W", "1899", "US"],
    ["ID DUBIOS (VOR)", "KDBS", "DBS", "None", "44.05N", "112.13W", "1638", "US"],
    ["ID GRANGEVILLE", "KGIC", "GIC", "72687", "45.56N", "116.08W", "1009", "US"],
    ["ID HAILEY/FRIEDMAN", "KSUN", "SUN", "None", "43.30N", "114.17W", "1620", "US"],
    ["ID IDAHO FALLS", "KIDA", "IDA", "None", "43.31N", "112.04W", "1453", "US"],
    ["ID JEROME COUNTY", "KJER", "JER", "None", "42.43N", "114.27W", "1222", "US"],
    ["ID LEWISTON", "KLWS", "LWS", "72783", "46.22N", "117.01W", "438", "US"],
    ["ID LOWELL/ELK CITY", "KP69", "P69", "None", "46.09N", "115.36W", "480", "US"],
    ["ID MALAD CITY", "KMLD", "MLD", "None", "42.10N", "112.17W", "1373", "US"],
    ["ID MALTA (AWRS)", "K77M", "77M", "None", "42.19N", "113.19W", "1375", "US"],
    ["ID MCCALL", "KMYL", "MYL", "None", "44.54N", "116.06W", "1533", "US"],
    ["ID MCCALL (VOR)", "KDNJ", "DNJ", "None", "44.46N", "116.13W", "2433", "US"],
    ["ID MOUNTAIN HOME", "KMUO", "MUO", "None", "43.02N", "115.52W", "913", "US"],
    ["ID MULLAN PASS", "KMLP", "MLP", "None", "47.27N", "115.40W", "1837", "US"],
    ["ID NAMPA", "KMAN", "MAN", "None", "43.35N", "116.31W", "774", "US"],
    ["ID POCATELLO", "KPIH", "PIH", "72578", "42.55N", "112.34W", "1359", "US"],
    ["ID REXBURG", "KRXE", "RXE", "None", "43.50N", "111.48W", "1480", "US"],
    ["ID SALMON/VOR", "KLKT", "LKT", "None", "45.01N", "114.05W", "2822", "US"],
    ["ID SALMON/LEMHI", "KSMN", "SMN", "72686", "45.07N", "113.52W", "1233", "US"],
    ["ID SODA SPRINGS", "KU78", "U78", "None", "42.38N", "111.34W", "1780", "US"],
    ["ID SPENCER", "KS14", "S14", "None", "44.21N", "112.10W", "1800", "US"],
    ["ID SPRINGFIELD/PIH", "KSFX", "SFX", "None", "43.06N", "112.41W", "1364", "US"],
    ["ID STANLEY", "KSNT", "SNT", "None", "44.10N", "114.56W", "1980", "US"],
    ["ID TWIN FALLS", "KTWF", "TWF", "None", "42.29N", "114.29W", "1266", "US"],
    ["ID WALL/SANDPOINT", "KSZT", "SZT", "None", "48.18N", "116.34W", "648", "US"],
    ["ID CALDWELL (AWOS)", "KU35", "U35", "None", "43.37N", "116.37W", "740", "US"],
    ["ID CHALLIS", "KU15", "U15", "None", "44.31N", "114.13W", "1536", "US"],
    ["ID GOODING", "KGNG", "GNG", "72586", "42.55N", "114.46W", "1126", "US"],
    ["ID JEROME", "KU73", "U73", "None", "42.44N", "114.27W", "1222", "US"],
    ["ID MULLAN (AWRS)", "KS06", "S06", "None", "47.28N", "115.47W", "1011", "US"],
    ["ID REXBURG", "KU11", "U11", "None", "43.50N", "111.48W", "1480", "US"],
    ["ID SALMON (AWRS)", "K27U", "27U", "None", "45.10N", "113.54W", "1210", "US"],
    ["ID SAYLOR CREEK", "KMI1", "MI1", "None", "42.30N", "115.30W", "1000", "US"],
    ["ID GRANGEVILLE", "KS80", "S80", "None", "45.57N", "116.07W", "1011", "US"],
    ["IL ALTON/ST LOUIS R", "KALN", "ALN", "None", "38.53N", "090.02W", "166", "US"],
    ["IL BLOOMINGTON/NORM", "KBMI", "BMI", "None", "40.28N", "088.55W", "267", "US"],
    ["IL BRADFORD/VOR", "KBDF", "BDF", "None", "41.09N", "089.35W", "247", "US"],
    ["IL CAHOKIA/ST LOUIS", "KCPS", "CPS", "None", "38.34N", "090.09W", "126", "US"],
    ["IL CAIRO", "KCIR", "CIR", "None", "37.04N", "089.13W", "98", "US"],
    ["IL CARBONDALE/MURPH", "KMDH", "MDH", "None", "37.47N", "089.15W", "130", "US"],
    ["IL CARMI MUNI", "KCUL", "None", "None", "38.05N", "088.07W", "118", "US"],
    ["IL CENTRALIA", "KENL", "ENL", "None", "38.31N", "089.06W", "163", "US"],
    ["IL CHAMPAIGN/URBANA", "KCMI", "CMI", "None", "40.02N", "088.16W", "228", "US"],
    ["IL CHICAGO", "KMDW", "MDW", "72534", "41.47N", "087.45W", "188", "US"],
    ["IL CHICAGO O'HARE", "KORD", "ORD", "72530", "41.59N", "087.56W", "200", "US"],
    ["IL CHICAGO/AURORA", "KARR", "ARR", "74465", "41.46N", "088.29W", "215", "US"],
    ["IL CHICAGO/DUPAGE", "KDPA", "DPA", "None", "41.55N", "088.15W", "231", "US"],
    ["IL CHICAGO/MEIGS", "KCGX", "CGX", "None", "41.52N", "087.35W", "181", "US"],
    ["IL CHICAGO/LANSING", "KIGQ", "IGQ", "None", "41.32N", "087.32W", "188", "US"],
    ["IL CHICAGO/ARTCC", "KZAU", "ZAU", "None", "41.47N", "088.20W", "213", "US"],
    ["IL DANVILLE", "KDNV", "DNV", "None", "40.12N", "087.36W", "212", "US"],
    ["IL DECATUR", "KDEC", "DEC", "None", "39.50N", "088.51W", "207", "US"],
    ["IL DECATUR", "KAXC", "AXC", "None", "39.50N", "088.51W", "207", "US"],
    ["IL DE KALB", "KDKB", "DKB", "None", "41.56N", "088.42W", "279", "US"],
    ["IL DIXON", "KC73", "C73", "None", "41.50N", "089.27W", "240", "US"],
    ["IL EFFINGHAM", "K1H2", "1H2", "None", "39.04N", "088.32W", "179", "US"],
    ["IL FAIRFIELD", "KFWC", "FWC", "None", "38.23N", "088.25W", "133", "US"],
    ["IL FREEPORT", "KFEP", "FEP", "None", "42.15N", "089.35W", "262", "US"],
    ["IL FLORA", "KFOA", "FOA", "None", "38.40N", "088.27W", "144", "US"],
    ["IL GALESBURG", "KGBG", "GBG", "None", "40.56N", "090.26W", "233", "US"],
    ["IL GREENVILLE", "KGRE", "GRE", "None", "38.50N", "089.23W", "165", "US"],
    ["IL HARRISBURG", "KHSB", "HSB", "None", "37.49N", "088.33W", "121", "US"],
    ["IL JACKSONVILLE", "KIJX", "IJX", "None", "39.46N", "090.15W", "190", "US"],
    ["IL JOLIET", "KJOT", "JOT", "None", "41.31N", "088.11W", "177", "US"],
    ["IL KANKAKEE", "KIKK", "IKK", "None", "41.04N", "087.51W", "192", "US"],
    ["IL LACON", "KC75", "C75", "None", "41.01N", "089.23W", "173", "US"],
    ["IL LAWRENCEVILLE", "KLWV", "LWV", "None", "38.46N", "087.36W", "131", "US"],
    ["IL LINCOLN", "KILX", "ILX", "74560", "40.09N", "089.20W", "177", "US"],
    ["IL LINCOLN", "KAAA", "AAA", "None", "40.10N", "089.20W", "182", "US"],
    ["IL LITCHFIELD MUNI", "K3LF", "3LF", "None", "39.10N", "089.40W", "210", "US"],
    ["IL MACOMB MUNI", "KMQB", "MQB", "None", "40.31N", "090.39W", "215", "US"],
    ["IL MARION REGIONAL", "KMWA", "MWA", "None", "37.46N", "089.01W", "144", "US"],
    ["IL MARSEILLES", "KMMO", "MMO", "74460", "41.22N", "088.40W", "225", "US"],
    ["IL MATTOON/CHARLEST", "KMTO", "MTO", "None", "39.28N", "088.16W", "214", "US"],
    ["IL METROPOLIS", "KM30", "M30", "None", "37.11N", "088.45W", "117", "US"],
    ["IL MOLINE/QUAD CITY", "KMLI", "MLI", "72544", "41.27N", "090.31W", "184", "US"],
    ["IL MONEE", "KC56", "C56", "None", "41.23N", "087.41W", "241", "US"],
    ["IL MORRIS-WASHBURN", "KC09", "C09", "None", "41.26N", "088.25W", "178", "US"],
    ["IL MOUNT CARMEL", "KAJG", "AJG", "None", "38.37N", "087.44W", "131", "US"],
    ["IL MOUNT STERLING", "KI63", "I63", "None", "39.59N", "090.48W", "224", "US"],
    ["IL MOUNT VERNON", "KMVN", "MVN", "None", "38.19N", "088.52W", "146", "US"],
    ["IL OLNEY-NOBLE", "KOLY", "OLY", "None", "38.43N", "088.11W", "147", "US"],
    ["IL PALWAUKEE", "KPWK", "PWK", "None", "42.07N", "087.54W", "203", "US"],
    ["IL PEORIA", "KPIA", "PIA", "72532", "40.40N", "089.41W", "205", "US"],
    ["IL PARIS", "KPRG", "PRG", "None", "39.42N", "087.40W", "199", "US"],
    ["IL PERU", "KVYS", "VYS", "None", "41.21N", "089.09W", "199", "US"],
    ["IL PITTSFIELD", "KPPQ", "PPQ", "None", "39.38N", "090.47W", "216", "US"],
    ["IL PONTIAC", "KPNT", "PNT", "None", "40.55N", "088.37W", "201", "US"],
    ["IL QUINCY MUNI/BALD", "KUIN", "UIN", "None", "39.57N", "091.12W", "234", "US"],
    ["IL RANTOUL", "KTIP", "TIP", "None", "40.17N", "088.09W", "225", "US"],
    ["IL ROBINSON MUNI", "KRSV", "RSV", "None", "39.01N", "087.39W", "141", "US"],
    ["IL ROCKFORD", "KRFD", "RFD", "72543", "42.12N", "089.06W", "221", "US"],
    ["IL ROCHELLE/KORITZ", "KRPJ", "RPJ", "None", "41.53N", "089.05W", "238", "US"],
    ["IL ROMEOVILLE/CHI", "KLOT", "LOT", "None", "41.36N", "088.06W", "205", "US"],
    ["IL SALEM/LECKRONE", "KSLO", "SLO", "None", "38.39N", "088.58W", "175", "US"],
    ["IL SAVANNA/TRITOWN", "KSFY", "SFY", "None", "42.03N", "090.07W", "188", "US"],
    ["IL SCOTT AFB/BELLEV", "KBLV", "BLV", "None", "38.32N", "089.50W", "138", "US"],
    ["IL SPARTA", "KSAR", "SAR", "None", "38.09N", "089.42W", "164", "US"],
    ["IL SPRINGFIELD", "KSPI", "SPI", "72439", "39.51N", "089.41W", "181", "US"],
    ["IL STERLING ROCKFAL", "KSQI", "SQI", "None", "41.45N", "089.40W", "197", "US"],
    ["IL TAYLORVILLE", "KTAZ", "TAZ", "None", "39.32N", "089.20W", "190", "US"],
    ["IL VANDALIA", "KVLA", "VLA", "None", "38.59N", "089.10W", "164", "US"],
    ["IL WAUKEGAN", "KUGN", "UGN", "None", "42.25N", "087.52W", "222", "US"],
    ["IL WINCHESTER PROFI", "None", "WNC", "74556", "39.38N", "090.28W", "170", "US"],
    ["IL CHICAGO", "KCHI", "CHI", "None", "42.00N", "087.53W", "203", "US"],
    ["IL GLENVIEW NAS", "KNBU", "NBU", "None", "42.05N", "087.49W", "199", "US"],
    ["IL LINCOLN", "K3LC", "3LC", "None", "40.10N", "089.20W", "182", "US"],
    ["IL RANTOUL", "K2I5", "2I5", "None", "40.18N", "088.09W", "225", "US"],
    ["IL ROCHELLE/KORITZ", "K12C", "12C", "None", "41.53N", "089.04W", "238", "US"],
    ["IN ANDERSON MUNICIP", "KAID", "AID", "None", "40.07N", "085.37W", "280", "US"],
    ["IN ANGOLA", "KANQ", "ANQ", "None", "41.38N", "085.05W", "303", "US"],
    ["IN AUBURN DEKALB C", "KGWB", "GWB", "None", "41.18N", "085.04W", "269", "US"],
    ["IN BLOOMINGTON", "KBMG", "BMG", "None", "39.09N", "086.37W", "257", "US"],
    ["IN COLUMBUS/BALKALA", "KBAK", "BAK", "None", "39.16N", "085.54W", "200", "US"],
    ["IN CRAWFORDSVILLE", "KCFJ", "CFJ", "None", "39.59N", "086.55W", "244", "US"],
    ["IN DAVIESS COUNTY", "KDCY", "DCY", "None", "38.42N", "087.08W", "144", "US"],
    ["IN ELKHART MUNICIPA", "KEKM", "EKM", "None", "41.43N", "086.00W", "237", "US"],
    ["IN EVANSVILLE", "KEVV", "EVV", "72432", "38.03N", "087.31W", "117", "US"],
    ["IN EVANSVILLE", "KVWX", "VWX", "None", "38.16N", "087.43W", "190", "US"],
    ["IN FORT WAYNE", "KFWA", "FWA", "72533", "40.59N", "085.11W", "248", "US"],
    ["IN FRANKFORT", "KFKR", "FKR", "None", "40.16N", "086.34W", "263", "US"],
    ["IN GARY REGIONAL", "KGYY", "GYY", "None", "41.37N", "087.25W", "180", "US"],
    ["IN GOSHEN", "KGSH", "GSH", "None", "41.32N", "085.47W", "252", "US"],
    ["IN GREENCASTLE", "KGPC", "GPC", "None", "39.38N", "086.49W", "257", "US"],
    ["IN GRISSOM AFB/PERU", "KGUS", "GUS", "None", "40.38N", "086.09W", "247", "US"],
    ["IN HIMSEL AAF", "K1II", "1II", "None", "39.20N", "086.02W", "214", "US"],
    ["IN HUNTINGBURG", "KHNB", "HNB", "None", "38.15N", "086.57W", "161", "US"],
    ["IN HUNTINGTON", "KHHG", "HHG", "None", "40.51N", "085.27W", "246", "US"],
    ["IN INDIANAPOLIS", "KEYE", "EYE", "None", "39.50N", "086.18W", "248", "US"],
    ["IN INDIANAPOLIS", "KIND", "IND", "72438", "39.43N", "086.18W", "241", "US"],
    ["IN INDIANAPOL/METRO", "KUMP", "UMP", "None", "39.56N", "086.03W", "248", "US"],
    ["IN INDIANAPOL/ARTCC", "KZID", "ZID", "None", "39.44N", "086.17W", "243", "US"],
    ["IN INDIANAPOLIS EXC", "KTYQ", "TYQ", "None", "40.02N", "086.15W", "281", "US"],
    ["IN INDIANAPOLIS REG", "KMQJ", "MQJ", "None", "39.51N", "085.54W", "263", "US"],
    ["IN INDIANAPOLIS", "KHFY", "HFY", "None", "39.38N", "086.05W", "251", "US"],
    ["IN KENDALLVILLE", "KC62", "C62", "None", "41.28N", "085.16W", "306", "US"],
    ["IN KNOX STARKE CTY", "KOXI", "OXI", "None", "41.20N", "086.40W", "209", "US"],
    ["IN KOKOMO", "KOKK", "OKK", "None", "40.32N", "086.04W", "253", "US"],
    ["IN LAFAYETTE", "KLAF", "LAF", "None", "40.25N", "086.56W", "182", "US"],
    ["IN LAFAYETTE VOR", "KBVT", "BVT", "None", "40.34N", "087.04W", "182", "US"],
    ["IN LA PORTE", "KPPO", "PPO", "None", "41.34N", "086.44W", "248", "US"],
    ["IN LOGANSPORT", "KGGP", "GGP", "None", "40.43N", "086.22W", "225", "US"],
    ["IN MADISON", "KIMS", "IMS", "None", "38.46N", "085.28W", "250", "US"],
    ["IN MARION MUNI", "KMZZ", "MZZ", "None", "40.29N", "085.41W", "262", "US"],
    ["IN MICHIGAN CITY", "KMGC", "MGC", "None", "41.42N", "086.49W", "200", "US"],
    ["IN MONTICELLO", "KMCX", "MCX", "None", "40.43N", "086.46W", "250", "US"],
    ["IN MUNCIE", "KMIE", "MIE", "None", "40.14N", "085.24W", "285", "US"],
    ["IN NINEVEH", "KHBE", "HBE", "None", "39.21N", "086.02W", "216", "US"],
    ["IN NORTH WEBSTER", "KIWX", "IWX", "None", "41.22N", "085.42W", "293", "US"],
    ["IN PLYMOUTH", "KC65", "C65", "None", "41.22N", "086.18W", "244", "US"],
    ["IN POCKET CITY VOR", "KPXV", "PXV", "None", "37.56N", "087.46W", "117", "US"],
    ["IN RENSSELAER", "KRZL", "RZL", "None", "40.57N", "087.11W", "213", "US"],
    ["IN RICHMOND", "KRID", "RID", "None", "39.45N", "084.51W", "348", "US"],
    ["IN ROCHESTER", "KRCR", "RCR", "None", "41.04N", "086.11W", "241", "US"],
    ["IN SHELBYVILLE", "KGEZ", "GEZ", "None", "39.35N", "085.48W", "245", "US"],
    ["IN SOUTH BEND", "KSBN", "SBN", "72535", "41.42N", "086.19W", "237", "US"],
    ["IN TERRE HAUTE", "KHUF", "HUF", "72437", "39.27N", "087.18W", "179", "US"],
    ["IN TERRE HAUTE VOR", "KTTH", "TTH", "None", "39.29N", "087.15W", "179", "US"],
    ["IN VALPARAISO", "KVPZ", "VPZ", "None", "41.27N", "087.00W", "231", "US"],
    ["IN WARSAW MUNI", "KASW", "ASW", "None", "41.16N", "085.50W", "259", "US"],
    ["IN WOLCOTT PROFILER", "None", "WLC", "74466", "40.49N", "087.03W", "212", "US"],
    ["IN BATESVILLE", "KHLB", "HLB", "None", "39.21N", "085.16W", "200", "US"],
    ["IN GREENCASTLE", "K4I7", "4I7", "None", "39.38N", "086.49W", "257", "US"],
    ["IN INDIANAPOLIS/EAG", "KI14", "I14", "None", "39.50N", "086.18W", "251", "US"],
    ["IN JEFFERSON PRVG", "None", "MDN", "74468", "38.50N", "085.25W", "266", "US"],
    ["IN SHELBYVILLE", "K3SM", "3SM", "None", "39.35N", "085.48W", "245", "US"],
    ["KS ALMA/TOPEKA", "KTWX", "TWX", "None", "39.00N", "096.14W", "417", "US"],
    ["KS AUGUSTA", "K3AU", "3AU", "None", "37.40N", "097.05W", "416", "US"],
    ["KS BENTON", "K1K1", "1K1", "None", "37.46N", "097.07W", "416", "US"],
    ["KS BURLINGTON", "KUKL", "UKL", "None", "38.18N", "095.44W", "358", "US"],
    ["KS CHANUTE", "KCNU", "CNU", "None", "37.40N", "095.29W", "297", "US"],
    ["KS COFFEYVILLE", "KCFV", "CFV", "None", "37.05N", "095.34W", "225", "US"],
    ["KS CONCORDIA", "KCNK", "CNK", "72458", "39.33N", "097.39W", "447", "US"],
    ["KS DODGE CITY", "KDDC", "DDC", "72451", "37.46N", "099.58W", "789", "US"],
    ["KS EL DORADO", "KEQA", "EQA", "None", "37.46N", "096.49W", "421", "US"],
    ["KS ELKHART", "KEHA", "EHA", "72460", "37.00N", "101.54W", "1099", "US"],
    ["KS EMPORIA", "KEMP", "EMP", "None", "38.20N", "096.12W", "367", "US"],
    ["KS FORT LEAVENWORTH", "KFLV", "FLV", "None", "39.22N", "094.55W", "235", "US"],
    ["KS FT RILEY/MARSHAL", "KFRI", "FRI", "72455", "39.02N", "096.46W", "325", "US"],
    ["KS GARDEN CITY", "KGCK", "GCK", "None", "37.55N", "100.43W", "877", "US"],
    ["KS GARNETT", "KK68", "K68", "None", "38.17N", "095.13W", "301", "US"],
    ["KS GOODLAND", "KGLD", "GLD", "72465", "39.22N", "101.42W", "1113", "US"],
    ["KS GREAT BEND", "KGBD", "GBD", "None", "38.21N", "098.52W", "575", "US"],
    ["KS HARPER", "K8K2", "8K2", "None", "37.17N", "098.03W", "445", "US"],
    ["KS HAVILAND PROFILE", "KHVL", "HVL", "74541", "37.39N", "099.06W", "648", "US"],
    ["KS HAYS MUNI", "KHYS", "HYS", "None", "38.51N", "099.16W", "609", "US"],
    ["KS HILL CITY", "KHLC", "HLC", "None", "39.22N", "099.50W", "669", "US"],
    ["KS HILLSBORO PROFIL", "None", "HBR", "74546", "38.17N", "097.17W", "477", "US"],
    ["KS HILLSBORO", "None", "None", "74547", "38.37N", "097.18W", "477", "US"],
    ["KS HUTCHINSON", "KHUT", "HUT", "None", "38.04N", "097.52W", "467", "US"],
    ["KS INDEPENDENCE", "KIDP", "IDP", "None", "37.10N", "095.47W", "251", "US"],
    ["KS IOLA", "KK88", "K88", "None", "37.52N", "095.23W", "310", "US"],
    ["KS JENNINGS", "KJN8", "JN8", "None", "39.41N", "100.18W", "762", "US"],
    ["KS LAWRENCE", "KLWC", "LWC", "None", "39.01N", "095.13W", "253", "US"],
    ["KS LEOTI/HOARD MEML", "K3K7", "3K7", "None", "38.27N", "101.21W", "1007", "US"],
    ["KS LIBERAL", "KLBL", "LBL", "None", "37.02N", "100.58W", "879", "US"],
    ["KS MANHATTAN", "KMHK", "MHK", "None", "39.08N", "096.41W", "317", "US"],
    ["KS MARYSVILLE", "KMYZ", "MYZ", "None", "39.51N", "096.38W", "392", "US"],
    ["KS MCCONNELL AFB", "KIAB", "IAB", "None", "37.37N", "097.16W", "418", "US"],
    ["KS MEDICINE LODGE", "KP28", "P28", "72452", "37.17N", "098.33W", "469", "US"],
    ["KS NEODESHA PROFILE", "None", "NDS", "74542", "37.22N", "095.37W", "255", "US"],
    ["KS NEW ALMELO", "KAL8", "AL8", "None", "39.36N", "100.07W", "734", "US"],
    ["KS NEWTON", "KEWK", "EWK", "None", "38.02N", "097.16W", "467", "US"],
    ["KS OLATHE/INDUSTRIA", "KIXD", "IXD", "None", "38.49N", "094.53W", "342", "US"],
    ["KS OLATHE/EXECUTIVE", "KOJC", "OJC", "None", "38.51N", "094.44W", "326", "US"],
    ["KS OSWEGO/VOR", "KOSW", "OSW", "None", "37.09N", "095.12W", "283", "US"],
    ["KS OTTAWA", "KOWI", "OWI", "None", "38.32N", "095.15W", "295", "US"],
    ["KS PARSONS", "KPPF", "PPF", "None", "37.20N", "095.30W", "274", "US"],
    ["KS PITTSBURG", "KPTS", "PTS", "None", "37.27N", "094.44W", "290", "US"],
    ["KS PRATT INDUST", "KPTT", "PTT", "None", "37.42N", "098.45W", "595", "US"],
    ["KS RUSSELL", "KRSL", "RSL", "None", "38.52N", "098.49W", "567", "US"],
    ["KS SALINA", "KSLN", "SLN", "None", "38.47N", "097.39W", "385", "US"],
    ["KS SUBLETTE", "K19S", "19S", "None", "37.30N", "100.50W", "888", "US"],
    ["KS TOPEKA/FORBES", "KFOE", "FOE", "None", "38.56N", "095.39W", "320", "US"],
    ["KS TOPEKA", "KTOP", "TOP", "72456", "39.04N", "095.38W", "268", "US"],
    ["KS WAKEENEY", "KWK6", "WK6", "None", "39.02N", "099.53W", "752", "US"],
    ["KS WICHITA", "KICT", "ICT", "72450", "37.39N", "097.26W", "407", "US"],
    ["KS WICHITA/JABARA", "KAAO", "AAO", "None", "37.45N", "097.13W", "434", "US"],
    ["KS WICHITA/BEECH", "KBEC", "BEC", "None", "37.42N", "097.13W", "430", "US"],
    ["KS WINFIELD/ARKANSA", "KWLD", "WLD", "None", "37.10N", "097.02W", "350", "US"],
    ["KS ELKHART", "K1K5", "1K5", "None", "37.00N", "101.53W", "1102", "US"],
    ["KS SMOKEY HILL GUN", "None", "None", "74545", "38.39N", "097.48W", "422", "US"],
    ["KS WICHITA/JABARA", "K3KM", "3KM", "None", "37.45N", "097.13W", "433", "US"],
    ["KS OBERLIN", "KOIN", "OIN", "None", "39.50N", "100.32W", "824", "US"],
    ["KS SYRACUSE", "K3K3", "3K3", "None", "38.00N", "101.45W", "1013", "US"],
    ["KS NORTON", "KNRN", "NRN", "None", "39.51N", "099.54W", "727", "US"],
    ["KS TRIBUNE", "KTRB", "TRB", "None", "38.27N", "101.45W", "1103", "US"],
    ["KS COLBY", "KCBK", "CBK", "None", "39.26N", "101.03W", "971", "US"],
    ["KS GRINNELL", "KGNL", "GNL", "None", "39.08N", "100.37W", "887", "US"],
    ["KS HOXIE", "KHOX", "HOX", "None", "39.22N", "100.26W", "833", "US"],
    ["KS PHILLIPSBURG", "KPHG", "PHG", "None", "39.44N", "099.19W", "582", "US"],
    ["KS HERNDON", "KHD7", "HD7", "None", "39.55N", "100.50W", "814", "US"],
    ["KS LOGAN", "KLG5", "LG5", "None", "39.40N", "099.34W", "597", "US"],
    ["KS ST FRANCIS", "KSYF", "SYF", "None", "39.46N", "101.48W", "1025", "US"],
    ["KS ABILENE", "KK78", "K78", "None", "38.54N", "097.14W", "352", "US"],
    ["KS ELLSWORTH", "K9K7", "9K7", "None", "38.45N", "098.14W", "492", "US"],
    ["KS EUREKA", "K13K", "13K", "None", "37.51N", "096.18W", "369", "US"],
    ["KS FORT SCOTT", "KFSK", "FSK", "None", "37.48N", "094.46W", "280", "US"],
    ["KS HUGOTON", "KHQG", "HQG", "None", "37.10N", "101.22W", "956", "US"],
    ["KS JOHNSON", "KJHN", "JHN", "None", "37.35N", "101.44W", "1014", "US"],
    ["KS KINGMAN", "K9K8", "9K8", "None", "37.40N", "098.07W", "490", "US"],
    ["KS MCPHERSON", "KMPR", "MPR", "None", "38.21N", "097.41W", "457", "US"],
    ["KS OAKLEY", "KOEL", "OEL", "None", "39.07N", "100.49W", "929", "US"],
    ["KS SCOTT CITY", "KTQK", "TQK", "None", "38.28N", "100.53W", "904", "US"],
    ["KS SMITH CENTER", "KK82", "K82", "None", "39.46N", "098.48W", "549", "US"],
    ["KS ULYSSES", "KULS", "ULS", "None", "37.36N", "101.22W", "936", "US"],
    ["KS WELLINGTON", "KEGT", "EGT", "None", "37.19N", "097.23W", "390", "US"],
    ["KS JOHNSON", "K2K3", "2K3", "None", "37.35N", "101.44W", "1014", "US"],
    ["KY ASHLAND", "KDWU", "DWU", "None", "38.33N", "082.44W", "167", "US"],
    ["KY BIG SANDY RGNL", "KSJS", "SJS", "None", "37.45N", "082.38W", "372", "US"],
    ["KY BOWLING GREE", "KBWG", "BWG", "None", "36.58N", "086.25W", "168", "US"],
    ["KY COVINGTON", "KCVG", "CVG", "72421", "39.03N", "084.40W", "269", "US"],
    ["KY DANVILLE", "KDVK", "DVK", "None", "37.35N", "084.46W", "312", "US"],
    ["KY HOPKINTON/F CAMB", "KHPX", "HPX", "None", "36.44N", "087.17W", "176", "US"],
    ["KY HOPKINSVILLE", "KHOP", "HOP", "74671", "36.40N", "087.30W", "174", "US"],
    ["KY ELIZABETH", "KEKX", "EKX", "None", "37.43N", "085.52W", "230", "US"],
    ["KY FALMOUTH", "KK62", "K62", "None", "38.42N", "084.24W", "274", "US"],
    ["KY FLEMINGSBURG", "KFGX", "FGX", "None", "38.33N", "083.45W", "279", "US"],
    ["KY FORT KNOX/88D", "KLVX", "LVX", "None", "37.59N", "085.57W", "219", "US"],
    ["KY FORT KNOX/GODMAN", "KFTK", "FTK", "72424", "37.53N", "085.58W", "230", "US"],
    ["KY FRANKFORT", "KFFT", "FFT", "None", "38.11N", "084.54W", "236", "US"],
    ["KY GLASGOW", "KGLW", "GLW", "None", "37.02N", "085.57W", "218", "US"],
    ["KY GREENVILLE", "KM21", "M21", "None", "37.14N", "087.09W", "131", "US"],
    ["KY HARLAN", "KI35", "I35", "None", "36.52N", "083.22W", "473", "US"],
    ["KY HENDERSON CITY", "KEHR", "EHR", "None", "37.49N", "087.40W", "117", "US"],
    ["KY LEWISPORT", "KKY8", "KY8", "None", "37.57N", "086.51W", "126", "US"],
    ["KY LEXINGTON", "KLEX", "LEX", "72422", "38.02N", "084.36W", "300", "US"],
    ["KY LONDON", "KLOZ", "LOZ", "72329", "37.05N", "084.04W", "362", "US"],
    ["KY LOUISVILLE", "KSDF", "SDF", "72423", "38.11N", "085.44W", "146", "US"],
    ["KY LOUISVILLE/BOWMN", "KLOU", "LOU", "None", "38.13N", "085.40W", "164", "US"],
    ["KY LOUISVILLE/WFO", "KLMK", "LMK", "None", "38.14N", "085.40W", "166", "US"],
    ["KY LOUISVILLE VOR", "KIIU", "IIU", "None", "38.06N", "085.35W", "219", "US"],
    ["KY MADISONVILLE", "K2I0", "2I0", "None", "37.21N", "087.24W", "134", "US"],
    ["KY MARION", "K5M9", "5M9", "None", "37.20N", "088.07W", "199", "US"],
    ["KY MAYFIELD", "KM25", "M25", "None", "36.46N", "088.35W", "160", "US"],
    ["KY MIDDLESBORO-BELL", "K1A6", "1A6", "None", "36.37N", "083.44W", "352", "US"],
    ["KY MONTICELLO/WAYNE", "KEKQ", "EKQ", "None", "36.51N", "084.51W", "294", "US"],
    ["KY MOREHEAD", "KSYM", "SYM", "None", "38.13N", "083.35W", "313", "US"],
    ["KY MOUNT STERLING", "KIOB", "IOB", "None", "38.03N", "083.59W", "311", "US"],
    ["KY MURRAY KYLE-OAK", "KCEY", "CEY", "None", "36.40N", "088.22W", "176", "US"],
    ["KY NOCTOR/JACKSON", "KJKL", "JKL", "None", "37.36N", "083.19W", "416", "US"],
    ["KY OWENSBORO/DAVIES", "KOWB", "OWB", "None", "37.43N", "087.10W", "124", "US"],
    ["KY PADUCAH", "KPAH", "PAH", "72435", "37.04N", "088.46W", "119", "US"],
    ["KY PIKEVILLE", "KPBX", "PBX", "None", "37.34N", "082.34W", "449", "US"],
    ["KY RICHMOND/MADISON", "KI39", "I39", "None", "37.38N", "084.20W", "306", "US"],
    ["KY SPRINGFIELD", "K6I2", "6I2", "None", "37.38N", "085.15W", "266", "US"],
    ["KY SOMERSET", "KSME", "SME", "None", "37.03N", "084.37W", "283", "US"],
    ["KY TOMPKINSVILLE", "KTZV", "TZV", "None", "36.44N", "085.39W", "316", "US"],
    ["KY WILLIAMSBURG", "KBYL", "BYL", "None", "36.48N", "084.12W", "359", "US"],
    ["KY HENDERSON CITY", "KI26", "I26", "None", "37.49N", "087.40W", "117", "US"],
    ["KY MOREHEAD", "KM97", "M97", "None", "38.13N", "083.35W", "313", "US"],
    ["KY PIKEVILLE (RAMOS", "K5I3", "5I3", "72413", "37.28N", "082.31W", "446", "US"],
    ["KY PRESTONBURG", "KK22", "K22", "None", "37.45N", "082.38W", "372", "US"],
    ["LA ABBEVILLE CC MEM", "KIYA", "IYA", "None", "29.59N", "092.05W", "5", "US"],
    ["LA ALEXANDRIA", "KAEX", "AEX", "74754", "31.20N", "092.34W", "27", "US"],
    ["LA ALEXANDRIA", "KESF", "ESF", "None", "31.24N", "092.17W", "28", "US"],
    ["LA AMELIA/LAKE PALO", "K7R3", "7R3", "None", "29.41N", "091.05W", "2", "US"],
    ["LA AUDUBON PARK", "KAUD", "AUD", "None", "29.56N", "090.08W", "2", "US"],
    ["LA BARKSDALE AFB", "KBAD", "BAD", "None", "32.30N", "093.40W", "51", "US"],
    ["LA BASTROP MOREHOUS", "KBQP", "BQP", "None", "32.45N", "091.53W", "51", "US"],
    ["LA BATON ROUGE", "KBTR", "BTR", "None", "30.32N", "091.09W", "21", "US"],
    ["LA BOGALUSA CARR F", "KBXA", "BXA", "None", "30.49N", "089.52W", "36", "US"],
    ["LA BOOTHVILLE", "KBVE", "BVE", "72232", "29.19N", "089.24W", "1", "US"],
    ["LA CAMERON HELIPORT", "K7R5", "7R5", "None", "29.46N", "093.17W", "1", "US"],
    ["LA CHENAULT/LK CHAS", "KCWF", "CWF", "None", "30.13N", "093.09W", "4", "US"],
    ["LA DEQUINCEY IND AR", "K5R8", "5R8", "None", "30.26N", "093.28W", "24", "US"],
    ["LA DERIDDER/FSS", "KDRI", "DRI", "None", "30.50N", "093.20W", "63", "US"],
    ["LA EUGENE IS 330", "K3B6", "3B6", "None", "28.14N", "091.41W", "1", "US"],
    ["LA FORT POLK FR", "KPOE", "POE", "72239", "31.03N", "093.12W", "101", "US"],
    ["LA PEASON RIDG/POLK", "KAQV", "AQV", "None", "31.24N", "093.18W", "111", "US"],
    ["LA FULLERTON/POLK", "KBKB", "BKB", "None", "31.00N", "092.55W", "94", "US"],
    ["LA SELF STRIP/POLK", "KDNK", "DNK", "None", "31.07N", "093.09W", "114", "US"],
    ["LA FOURCHON (SAWRS)", "K9F2", "9F2", "None", "29.06N", "090.12W", "2", "US"],
    ["LA PORT FOURCHON", "KXPY", "XPY", "None", "29.07N", "090.12W", "2", "US"],
    ["LA GALLIANO", "KGAO", "GAO", "None", "29.27N", "090.16W", "1", "US"],
    ["LA GALLIANO HELIPRT", "K2GL", "2GL", "None", "29.25N", "090.18W", "3", "US"],
    ["LA GRAND ISLE (SAWR", "KAXO", "AXO", "99429", "29.15N", "089.58W", "2", "US"],
    ["LA GRAND ISLE (VOR)", "KLEV", "LEV", "None", "29.11N", "090.06W", "2", "US"],
    ["LA GREEN CANYON 184", "KXCN", "XCN", "None", "27.46N", "091.31W", "1", "US"],
    ["LA GREEN CANYON 52", "K28K", "28K", "None", "27.53N", "091.30W", "1", "US"],
    ["LA HAMMOND", "KHDC", "HDC", "None", "30.31N", "090.25W", "13", "US"],
    ["LA HIGH ISLAND 334A", "KH02", "H02", "None", "28.06N", "093.24W", "30", "US"],
    ["LA HIGH IS. 264C", "KH08", "H08", "None", "28.28N", "093.44W", "30", "US"],
    ["LA OFFSHORE", "KH78", "H78", "None", "28.11N", "088.29W", "43", "US"],
    ["LA HOUMA TERREBONNE", "KHUM", "HUM", "None", "29.34N", "090.40W", "3", "US"],
    ["LA INTRACOASTAL CIT", "K7R4", "7R4", "None", "29.46N", "092.07W", "5", "US"],
    ["LA JENNINGS", "K3R7", "3R7", "None", "30.15N", "092.40W", "7", "US"],
    ["LA LAFAYETTE", "KLFT", "LFT", "None", "30.12N", "092.00W", "11", "US"],
    ["LA LAKE CHARLES", "KLCH", "LCH", "72240", "30.08N", "093.13W", "4", "US"],
    ["LA MANSFIELD", "K3F3", "3F3", "None", "32.04N", "093.46W", "99", "US"],
    ["LA MINDEN", "KMNE", "MNE", "None", "32.39N", "093.18W", "85", "US"],
    ["LA MONROE", "KMLU", "MLU", "None", "32.31N", "092.02W", "29", "US"],
    ["LA NATCHITOCHES", "KIER", "IER", "None", "31.44N", "093.06W", "37", "US"],
    ["LA NEW IBERIA", "KARA", "ARA", "None", "30.02N", "091.53W", "18", "US"],
    ["LA NEW ORLEANS/LAKE", "KNEW", "NEW", "None", "30.03N", "090.02W", "3", "US"],
    ["LA NEW ORLEANS NAS", "KNBG", "NBG", "None", "29.49N", "090.01W", "1", "US"],
    ["LA NEW ORLEANS/INTL", "KMSY", "MSY", "72231", "30.00N", "090.15W", "5", "US"],
    ["LA NEW ROADS", "KHZR", "HZR", "None", "30.43N", "091.29W", "12", "US"],
    ["LA NEW O SUPERDOME", "KVSH", "VSH", "None", "29.57N", "090.05W", "5", "US"],
    ["LA NEW O HELIPORT", "K7N0", "7N0", "None", "29.57N", "090.05W", "9", "US"],
    ["LA HARVEY/N ORLEANS", "KHRV", "HRV", "None", "29.51N", "090.00W", "1", "US"],
    ["LA OAKDALE ALLEN P", "KACP", "ACP", "None", "30.45N", "092.41W", "33", "US"],
    ["LA OPELOUSAS", "KOPL", "OPL", "None", "30.33N", "092.06W", "23", "US"],
    ["LA RESERVE", "KAPS", "APS", "None", "30.05N", "090.35W", "3", "US"],
    ["LA RUSTON REGIONAL", "KRSN", "RSN", "None", "32.31N", "092.35W", "95", "US"],
    ["LA PATTERSON MEMORI", "KPTN", "PTN", "None", "29.43N", "091.19W", "3", "US"],
    ["LA SALT POINT", "KP92", "P92", "None", "29.34N", "091.32W", "1", "US"],
    ["LA SHIP SHOAL 207", "KGSM", "GSM", "None", "28.32N", "090.59W", "1", "US"],
    ["LA SHREVEPORT/DWNTN", "KDTN", "DTN", "None", "32.33N", "093.45W", "53", "US"],
    ["LA SHREVEPORT", "KSHV", "SHV", "72248", "32.27N", "093.50W", "83", "US"],
    ["LA SHREVEPORT(VOR)", "KEIC", "EIC", "None", "32.46N", "093.49W", "80", "US"],
    ["LA SLIDELL/88D", "KLIX", "LIX", "72233", "30.20N", "089.50W", "7", "US"],
    ["LA SLIDELL 22", "KASD", "ASD", "None", "30.21N", "089.49W", "9", "US"],
    ["LA NEW ORLEANS RFC", "KORN", "ORN", "None", "30.15N", "089.46W", "3", "US"],
    ["LA S MARSH ISL 268", "KSRN", "SRN", "None", "29.07N", "091.52W", "1", "US"],
    ["LA S MARSH ISLAND", "K7R8", "7R8", "None", "28.18N", "091.58W", "1", "US"],
    ["LA SOUTH TIMBALIER", "KS58", "S58", "None", "28.31N", "090.34W", "1", "US"],
    ["LA SULPHUR", "KUXL", "UXL", "None", "30.08N", "093.23W", "4", "US"],
    ["LA TALLULAH/VICKSBU", "KTVR", "TVR", "None", "32.21N", "091.02W", "26", "US"],
    ["LA VENICE HELIPORT", "K1B7", "1B7", "None", "29.21N", "089.26W", "1", "US"],
    ["LA CAMERON", "KCVW", "CVW", "None", "29.47N", "093.18W", "1", "US"],
    ["LA E. CAMERON 346", "KE12", "E12", "None", "28.04N", "092.42W", "1", "US"],
    ["LA W. CAMERON 560", "KW60", "W60", "None", "28.09N", "093.21W", "1", "US"],
    ["LA PHI OIL PLATF", "KQT8", "QT8", "None", "27.32N", "092.26W", "1", "US"],
    ["LA PHI OIL PLATF", "KQT9", "QT9", "None", "27.47N", "090.38W", "1", "US"],
    ["LA PHI OIL PLATF", "K4CO", "4CO", "None", "29.47N", "093.11W", "1", "US"],
    ["LA PHI OIL PLATF", "K4C0", "4C0", "None", "29.47N", "093.11W", "1", "US"],
    ["LA WINNFIELD PROFIL", "None", "WNF", "74753", "31.53N", "092.46W", "93", "US"],
    ["LA ABBEVILLE CC MEM", "K0R3", "0R3", "None", "29.59N", "092.05W", "5", "US"],
    ["LA ALEXANDRIA/AFB", "K01R", "01R", "74755", "31.08N", "092.34W", "67", "US"],
    ["LA BASTROP MOREHOUS", "K2F8", "2F8", "None", "32.45N", "091.53W", "51", "US"],
    ["LA EUGENE IS. 266C", "K41I", "41I", "None", "28.28N", "091.47W", "31", "US"],
    ["LA GALLIANO", "KL49", "L49", "None", "29.27N", "090.16W", "1", "US"],
    ["LA GARDEN BANKS 23", "None", "None", "99447", "27.22N", "093.12W", "1", "US"],
    ["LA GARDEN BANKS172", "KGHB", "GHB", "None", "27.50N", "091.59W", "30", "US"],
    ["LA GONZALES", "KREG", "REG", "None", "30.10N", "090.56W", "5", "US"],
    ["LA GRAND CHEINER", "KL29", "L29", "None", "29.48N", "092.50W", "1", "US"],
    ["LA GONZALES", "KL38", "L38", "None", "30.10N", "090.56W", "5", "US"],
    ["LA GREEN CANYON 184", "KG01", "G01", "None", "27.54N", "091.30W", "1", "US"],
    ["LA HIGH ISLAND 511", "K01T", "01T", "None", "28.08N", "094.24W", "30", "US"],
    ["LA HIGH IS. A572C", "KH39", "H39", "None", "27.57N", "093.59W", "30", "US"],
    ["LA HIGH IS. A489B", "KL40", "L40", "None", "28.12N", "094.12W", "30", "US"],
    ["LA LEEVILLE", "K7R2", "7R2", "None", "29.13N", "090.14W", "1", "US"],
    ["LA MAIN PASS 133C", "None", "None", "99444", "29.24N", "088.24W", "1", "US"],
    ["LA MINDEN", "KF24", "F24", "None", "32.39N", "093.18W", "85", "US"],
    ["LA MISS. CANYON", "K1G7", "1G7", "None", "28.47N", "089.03W", "18", "US"],
    ["LA OAKDALE ALLEN P", "KL42", "L42", "None", "30.45N", "092.41W", "33", "US"],
    ["LA SHIP SHOAL 224A", "KS02", "S02", "None", "28.30N", "091.18W", "2", "US"],
    ["LA SHIP SHOAL 198G", "KS65", "S65", "None", "28.30N", "091.12W", "2", "US"],
    ["LA SLIDELL", "K6R0", "6R0", "None", "30.21N", "089.49W", "8", "US"],
    ["LA SLIDELL", "KSIL", "SIL", "None", "30.15N", "089.46W", "3", "US"],
    ["LA SOUTHLAND FIELD", "KL75", "L75", "None", "30.08N", "093.22W", "4", "US"],
    ["LA SOUTHWEST PASS", "None", "None", "99401", "28.54N", "089.34W", "1", "US"],
    ["LA S. PASS BLK 62A", "KH18", "H18", "None", "28.59N", "089.08W", "1", "US"],
    ["LA VENICE/HELIPORT", "K3V8", "3V8", "None", "29.07N", "089.12W", "80", "US"],
    ["LA VERMILLION", "K7W2", "7W2", "None", "28.35N", "092.28W", "1", "US"],
    ["LA VERMILLION AREA", "KVRX", "VRX", "None", "28.03N", "092.27W", "1", "US"],
    ["LA VENICE", "K7R1", "7R1", "None", "29.16N", "089.22W", "3", "US"],
    ["LA W. CAMERON 522", "KW76", "W76", "None", "28.22N", "093.30W", "30", "US"],
    ["LA W. CAMERON 556", "K37C", "37C", "None", "28.22N", "093.30W", "30", "US"],
    ["LA W. CAMERON 587", "K7B5", "7B5", "None", "28.05N", "093.12W", "1", "US"],
    ["LA MAIN PASS 299", "KMPM", "MPM", "None", "29.16N", "088.46W", "1", "US"],
    ["LA MISS CANYAN 807", "KCYD", "CYD", "None", "28.10N", "089.13W", "1", "US"],
    ["LA INDEPEDENCE 920", "KIPN", "IPN", "None", "28.05N", "087.59W", "41", "US"],
    ["LA MAGNOLIA OILP", "KGBK", "GBK", "None", "27.12N", "092.12W", "59", "US"],
    ["LA SHIP SHOAL178", "KSPR", "SPR", "None", "28.36N", "091.12W", "31", "US"],
    ["LA MISS CANYON 311A", "KMDJ", "MDJ", "None", "28.39N", "089.48W", "31", "US"],
    ["LA E CAMERON278OILP", "KEHC", "EHC", "None", "28.26N", "092.53W", "31", "US"],
    ["LA SABINE 13BOILP", "KVBS", "VBS", "None", "29.29N", "093.38W", "31", "US"],
    ["LA S MARSH268OILP", "KSCF", "SCF", "None", "29.07N", "091.52W", "8", "US"],
    ["LA VERMILLION26OILP", "KVNP", "VNP", "None", "29.28N", "092.22W", "28", "US"],
    ["LA EUGENE I 215OILP", "KEIR", "EIR", "None", "28.38N", "091.29W", "28", "US"],
    ["LA ATLANTISOILP", "KATP", "ATP", "None", "27.12N", "090.02W", "62", "US"],
    ["LA E CAMERON 47JP", "KCMB", "CMB", "None", "29.26N", "092.59W", "29", "US"],
    ["LA GREEN CANYON 338", "KGRY", "GRY", "None", "27.38N", "090.27W", "58", "US"],
    ["LA HIGH IS. 179A", "KXIH", "XIH", "None", "29.11N", "094.31W", "75", "US"],
    ["LA MAIN PASS 289C", "KVKY", "VKY", "None", "29.15N", "088.26W", "32", "US"],
    ["LA MAIN PASS 140B", "KMIS", "MIS", "None", "29.18N", "088.51W", "32", "US"],
    ["LA S TIMBALIER 301B", "KSTZ", "STZ", "None", "28.10N", "090.40W", "25", "US"],
    ["LA VERMILION 331", "KVQT", "VQT", "None", "28.16N", "092.16W", "25", "US"],
    ["LA MISS CANYON 474", "KIKT", "IKT", "None", "28.31N", "088.17W", "25", "US"],
    ["LA KEATHLEY C 875", "K18H", "18H", "None", "26.08N", "092.02W", "10", "US"],
    ["LA WALKER RIDGE 718", "KJSL", "JSL", "None", "26.14N", "095.15W", "10", "US"],
    ["MA BEDFORD", "KBED", "BED", "74490", "42.28N", "071.18W", "50", "US"],
    ["MA BEVERLY", "KBVY", "BVY", "None", "42.35N", "070.55W", "28", "US"],
    ["MA BLUE HILL OBS", "None", "BHV", "74992", "41.13N", "071.07W", "192", "US"],
    ["MA BLUE HILL OBS", "None", "BHV", "74995", "41.13N", "071.07W", "192", "US"],
    ["MA BOSTON", "KBOS", "BOS", "72509", "42.22N", "071.01W", "6", "US"],
    ["MA BOSTON/TAUNTON", "KBOX", "BOX", "None", "41.57N", "071.08W", "36", "US"],
    ["MA BOSTON/RFC", "KTAR", "TAR", "None", "41.57N", "071.08W", "36", "US"],
    ["MA CHATHAM", "KCHH", "CHH", "74494", "41.40N", "069.58W", "16", "US"],
    ["MA CHATHAM", "None", "None", "74493", "41.40N", "069.58W", "16", "US"],
    ["MA CHATHAM", "KCQX", "CQX", "None", "41.41N", "070.00W", "19", "US"],
    ["MA CHICOPEE/WESTOVE", "KCEF", "CEF", "74491", "42.12N", "072.31W", "75", "US"],
    ["MA CHICOPEE/WESTOVE", "None", "None", "72491", "42.12N", "072.31W", "75", "US"],
    ["MA EAST MILTON", "KMQE", "MQE", "None", "42.13N", "071.07W", "199", "US"],
    ["MA FALMOUTH/OTIS AB", "KFMH", "FMH", "None", "41.38N", "070.31W", "40", "US"],
    ["MA FITCHBURG", "KFIT", "FIT", "None", "42.33N", "071.45W", "103", "US"],
    ["MA HYANNIS", "KHYA", "HYA", "None", "41.40N", "070.16W", "22", "US"],
    ["MA LAWRENCE", "KLWM", "LWM", "None", "42.43N", "071.08W", "54", "US"],
    ["MA MARSHFIELD", "KGHG", "GHG", "None", "42.06N", "070.40W", "4", "US"],
    ["MA MARTHAS VINEYARD", "KMVY", "MVY", "None", "41.24N", "070.37W", "16", "US"],
    ["MA NANTUCKET", "KACK", "ACK", "72506", "41.15N", "070.04W", "16", "US"],
    ["MA NEW BEDFORD", "KEWB", "EWB", "None", "41.41N", "070.57W", "23", "US"],
    ["MA NORTH ADAMS", "KAQW", "AQW", "None", "42.42N", "073.10W", "199", "US"],
    ["MA NORWOOD", "KOWD", "OWD", "None", "42.11N", "071.10W", "19", "US"],
    ["MA ORANGE", "KORE", "ORE", "None", "42.34N", "072.17W", "164", "US"],
    ["MA PITTSFIELD", "KPSF", "PSF", "None", "42.26N", "073.17W", "355", "US"],
    ["MA PLYMOUTH", "KPYM", "PYM", "None", "41.55N", "070.44W", "43", "US"],
    ["MA PROVINCETOWN", "KPVC", "PVC", "None", "42.04N", "070.13W", "2", "US"],
    ["MA SOUTH WEYMOUTH", "KNZW", "NZW", "None", "42.08N", "070.55W", "49", "US"],
    ["MA TAUNTON", "KTAN", "TAN", "None", "41.53N", "071.01W", "7", "US"],
    ["MA WESTFIELD", "KBAF", "BAF", "None", "42.10N", "072.43W", "83", "US"],
    ["MA WORCESTER", "KORH", "ORH", "None", "42.16N", "071.52W", "304", "US"],
    ["MA ASHBURNHAM", "K9B4", "9B4", "None", "42.39N", "071.52W", "363", "US"],
    ["MA AYER", "KAYE", "AYE", "None", "42.34N", "071.36W", "82", "US"],
    ["MA BARRE FALLS", "K8B5", "8B5", "None", "42.25N", "072.04W", "178", "US"],
    ["MA BUZZARDS BAY (L", "None", "None", "99414", "41.24N", "071.58W", "1", "US"],
    ["MA GARDNER", "KGDM", "GDM", "None", "42.34N", "071.58W", "290", "US"],
    ["MA G BARRINGTON", "KGBR", "GBR", "None", "42.12N", "073.21W", "199", "US"],
    ["MA KNIGHTVILLE", "K7B2", "7B2", "None", "42.16N", "072.52W", "192", "US"],
    ["MA MARSHFIELD", "K3B2", "3B2", "None", "42.06N", "070.40W", "4", "US"],
    ["MA NEWBURYPORT", "K2B2", "2B2", "None", "42.49N", "070.55W", "6", "US"],
    ["MA NORTH ADAMS", "K2B6", "2B6", "None", "42.42N", "073.11W", "199", "US"],
    ["MA WORTHINGTON", "KWOR", "WOR", "None", "42.23N", "072.55W", "392", "US"],
    ["MD ABERDEEN/PHILLIP", "KAPG", "APG", "74002", "39.28N", "076.10W", "18", "US"],
    ["MD ABERDEEN PRV GND", "KQAH", "QAH", "None", "39.30N", "076.34W", "5", "US"],
    ["MD ANNAPOLIS/NAVAL", "KNAK", "None", "None", "38.59N", "076.29W", "2", "US"],
    ["MD ANDREWS AFB", "KADW", "ADW", "74594", "38.49N", "076.52W", "86", "US"],
    ["MD BALTO/WASH INTL", "KBWI", "BWI", "72406", "39.10N", "076.41W", "59", "US"],
    ["MD BALTIMORE/MARTIN", "KMTN", "MTN", "None", "39.19N", "076.25W", "7", "US"],
    ["MD BALTIMORE/DWNTWN", "KDMH", "DMH", "None", "39.17N", "076.37W", "5", "US"],
    ["MD CAMBRIDGE-DORCH", "KCGE", "CGE", "None", "38.32N", "076.02W", "6", "US"],
    ["MD NSF THURMONT", "KRSP", "None", "None", "39.39N", "077.28W", "561", "US"],
    ["MD CAMP SPRING/NCEP", "KWNO", "None", "None", "38.51N", "076.56W", "50", "US"],
    ["MD CAMP SPRINGS/HPC", "KWNH", "None", "None", "38.51N", "076.56W", "50", "US"],
    ["MD CAMP SPRINGS/MPC", "KWNM", "None", "None", "38.51N", "076.56W", "50", "US"],
    ["MD CAMP SPRINGS/CPC", "KWNC", "None", "None", "38.51N", "076.56W", "50", "US"],
    ["MD CAMP SPRINGS/DBC", "KWNB", "None", "None", "38.51N", "076.56W", "50", "US"],
    ["MD CARROLL CNTY", "KDMW", "DMW", "None", "39.36N", "077.00W", "241", "US"],
    ["MD CLINTON", "KW32", "W32", "None", "38.45N", "076.56W", "76", "US"],
    ["MD COLLEGE PARK", "KCGS", "CGS", "None", "38.59N", "076.55W", "15", "US"],
    ["MD CUMBERLAND REG", "KCBE", "CBE", "None", "39.37N", "078.46W", "236", "US"],
    ["MD EASTON/NEWNAM", "KESN", "ESN", "None", "38.48N", "076.04W", "22", "US"],
    ["MD FORT MEADE", "KFME", "FME", "None", "39.05N", "076.46W", "46", "US"],
    ["MD FORT RITCHIE", "KJWX", "JWX", "None", "39.43N", "077.25W", "84", "US"],
    ["MD FREDERICK", "KFDK", "FDK", "None", "39.25N", "077.22W", "92", "US"],
    ["MD GARRETT CO", "K2G4", "2G4", "None", "39.35N", "079.20W", "894", "US"],
    ["MD GAITHERSBURG", "KGAI", "GAI", "None", "39.10N", "077.10W", "165", "US"],
    ["MD HAGERSTOWN", "KHGR", "HGR", "None", "39.42N", "077.44W", "224", "US"],
    ["MD OCEAN CITY", "KOXB", "OXB", "None", "38.19N", "075.07W", "3", "US"],
    ["MD PATUXENT RIVER", "KNHK", "NHK", "72404", "38.16N", "076.24W", "12", "US"],
    ["MD RIDGELY", "KRJD", "RJD", "None", "38.58N", "075.52W", "20", "US"],
    ["MD SALISBURY", "KSBY", "SBY", "None", "38.20N", "075.30W", "19", "US"],
    ["MD STEVENSVILLE", "KW29", "W29", "None", "38.59N", "076.20W", "15", "US"],
    ["MD ST MARYS (DUKE)", "K2W6", "2W6", "None", "38.19N", "076.33W", "44", "US"],
    ["MD CAMP DAVID", "KDVD", "DVD", "None", "39.39N", "077.28W", "152", "US"],
    ["MD FORT RITCHIE/SIT", "K43M", "43M", "None", "39.43N", "077.25W", "275", "US"],
    ["MD OCEAN CITY", "KN80", "N80", "None", "38.19N", "075.07W", "4", "US"],
    ["MD THOMAS POINT", "None", "None", "99440", "38.54N", "076.34W", "1", "US"],
    ["MD WEBSTER NAVAL", "KNUI", "NUI", "None", "38.09N", "076.26W", "7", "US"],
    ["MD WESTMINSTER", "KEMI", "EMI", "None", "39.30N", "076.59W", "152", "US"],
    ["ME AUBURN/LEWISTON", "KLEW", "LEW", "None", "44.02N", "070.16W", "88", "US"],
    ["ME AUGUSTA", "KAUG", "AUG", "None", "44.19N", "069.48W", "109", "US"],
    ["ME BANGOR", "KBGR", "BGR", "72607", "44.48N", "068.49W", "57", "US"],
    ["ME BAR HARBOR", "KBHB", "BHB", "None", "44.27N", "068.22W", "26", "US"],
    ["ME BRUNSWICK NAS", "KNHZ", "NHZ", "74392", "43.52N", "069.55W", "23", "US"],
    ["ME CARIBOU", "KCAR", "CAR", "72712", "46.52N", "068.01W", "191", "US"],
    ["ME CARIBOU", "None", "None", "72711", "46.52N", "068.01W", "191", "US"],
    ["ME CARRABASSETT", "KB21", "B21", "None", "45.05N", "070.13W", "270", "US"],
    ["ME CLAYTON LAKE", "K40B", "40B", "None", "46.37N", "069.31W", "314", "US"],
    ["ME EASTPORT", "KEPM", "EPM", "72608", "44.55N", "067.01W", "14", "US"],
    ["ME FRENCHVILLE", "KFVE", "FVE", "None", "47.17N", "068.18W", "301", "US"],
    ["ME FRYEBURG", "KIZG", "IZG", "None", "43.59N", "070.57W", "135", "US"],
    ["ME GRAY/PORTLAND", "KGYX", "GYX", "74389", "43.53N", "070.15W", "125", "US"],
    ["ME GREENVILLE", "KGNR", "GNR", "72619", "45.28N", "069.33W", "427", "US"],
    ["ME HOULTON/88D", "KCBW", "CBW", "None", "46.02N", "067.48W", "227", "US"],
    ["ME HOULTON", "KHUL", "HUL", "None", "46.07N", "067.48W", "150", "US"],
    ["ME KENNEBUNKPORT", "KENE", "ENE", "None", "43.26N", "070.37W", "123", "US"],
    ["ME MILLINOCKET", "KMLT", "MLT", "None", "45.39N", "068.42W", "123", "US"],
    ["ME OLD TOWN/DEWITT", "KOLD", "OLD", "None", "44.57N", "068.40W", "39", "US"],
    ["ME PORTLAND", "KPWM", "PWM", "72606", "43.39N", "070.18W", "15", "US"],
    ["ME PRESQUE ISLE", "KPQI", "PQI", "72713", "46.40N", "068.02W", "146", "US"],
    ["ME RANGELEY", "K8B0", "8B0", "None", "44.58N", "070.42W", "554", "US"],
    ["ME ROCKLAND/KNOX", "KRKD", "RKD", "None", "44.04N", "069.05W", "17", "US"],
    ["ME SANFORD MUNI", "KSFM", "SFM", "None", "43.23N", "070.43W", "74", "US"],
    ["ME WATERVILLE", "KWVL", "WVL", "None", "44.31N", "069.40W", "101", "US"],
    ["ME WISCASSET", "KIWI", "IWI", "None", "43.58N", "069.43W", "20", "US"],
    ["ME EASTPORT", "K47B", "47B", "None", "44.55N", "067.00W", "24", "US"],
    ["ME FREYBURG", "KB20", "B20", "None", "43.59N", "070.57W", "138", "US"],
    ["ME GREENVILLE", "K3B1", "3B1", "None", "45.28N", "069.33W", "427", "US"],
    ["ME HARMONY", "K2B7", "2B7", "None", "44.56N", "069.37W", "107", "US"],
    ["ME LORING AFB", "KLIZ", "LIZ", "None", "46.57N", "067.53W", "227", "US"],
    ["ME MATINICUS ISLE", "None", "None", "99437", "43.46N", "068.09W", "16", "US"],
    ["ME MOUNT DESERT RO", "None", "None", "99406", "43.58N", "068.52W", "9", "US"],
    ["ME RUMFORD", "KRUM", "RUM", "72618", "44.32N", "070.32W", "207", "US"],
    ["ME SEWEL RIDGE", "K9B6", "9B6", "None", "43.00N", "068.00W", "150", "US"],
    ["ME WISCASSET", "K9B9", "9B9", "None", "43.58N", "069.43W", "21", "US"],
    ["MI ADRIAN", "KADG", "ADG", "None", "41.52N", "084.05W", "241", "US"],
    ["MI ALMA", "KAMN", "AMN", "None", "43.19N", "084.41W", "230", "US"],
    ["MI ALPENA", "KAPN", "APN", "72639", "45.04N", "083.34W", "210", "US"],
    ["MI ANN ARBOR", "KARB", "ARB", "None", "42.13N", "083.44W", "251", "US"],
    ["MI BAD AXE", "KBAX", "BAX", "None", "43.47N", "082.59W", "234", "US"],
    ["MI BATTLE CREEK", "KBTL", "BTL", "None", "42.19N", "085.14W", "290", "US"],
    ["MI BELLAIRE", "KACB", "ACB", "None", "44.59N", "085.12W", "190", "US"],
    ["MI BEAVER ISLAND", "KSJX", "SJX", "None", "45.42N", "085.34W", "204", "US"],
    ["MI BENTON HARBOR", "KBEH", "BEH", "None", "42.08N", "086.25W", "191", "US"],
    ["MI BIG RAPIDS", "KRQB", "RQB", "None", "43.43N", "085.30W", "302", "US"],
    ["MI CADILLAC/WEXFORD", "KCAD", "CAD", "None", "44.16N", "085.25W", "398", "US"],
    ["MI CARO/TUSCOLA", "KCFS", "CFS", "None", "43.28N", "083.27W", "214", "US"],
    ["MI CHARLEVOIX", "KCVX", "CVX", "None", "45.18N", "085.16W", "204", "US"],
    ["MI CHARLOTTE", "KFPK", "FPK", "None", "42.34N", "084.49W", "272", "US"],
    ["MI CHEBOYGAN", "KSLH", "SLH", "None", "45.39N", "084.31W", "195", "US"],
    ["MI CHIPPEWA INTL", "KCIU", "CIU", "None", "46.15N", "084.28W", "244", "US"],
    ["MI COLDWATER", "KOEB", "OEB", "None", "41.55N", "085.02W", "292", "US"],
    ["MI COPPER HARBOR", "KP59", "P59", "None", "47.28N", "087.53W", "190", "US"],
    ["MI DETROIT/CITY AIR", "KDET", "DET", "None", "42.24N", "083.01W", "190", "US"],
    ["MI DETROIT/WILLOW", "KYIP", "YIP", "None", "42.14N", "083.32W", "215", "US"],
    ["MI DETROIT/WAYNE", "KDTW", "DTW", "72537", "42.14N", "083.20W", "195", "US"],
    ["MI DETROIT/WHITE LK", "KDTX", "DTX", "72632", "42.42N", "083.28W", "327", "US"],
    ["MI DETROIT/GROSSE I", "KONZ", "ONZ", "None", "42.06N", "083.09W", "180", "US"],
    ["MI DETROIT/VOR", "KDXO", "DXO", "None", "42.13N", "083.22W", "215", "US"],
    ["MI DRUMMOND IS", "KDRM", "DRM", "None", "46.00N", "083.45W", "204", "US"],
    ["MI ESCANABA", "KESC", "ESC", "72648", "45.45N", "087.05W", "187", "US"],
    ["MI FLINT", "KFNT", "FNT", "72637", "42.58N", "083.45W", "233", "US"],
    ["MI FRANKFORT", "KFKS", "FKS", "None", "44.38N", "086.12W", "193", "US"],
    ["MI FREMONT", "KFFX", "FFX", "None", "43.26N", "086.00W", "236", "US"],
    ["MI GAYLORD/ALPENA", "KAPX", "APX", "72634", "44.54N", "084.43W", "446", "US"],
    ["MI GAYLORD", "KGLR", "GLR", "None", "45.01N", "084.41W", "407", "US"],
    ["MI GRAND RAPIDS", "KGRR", "GRR", "72635", "42.53N", "085.31W", "237", "US"],
    ["MI GRAYLING AF", "KGOV", "GOV", "None", "44.41N", "084.44W", "353", "US"],
    ["MI GWINN/SAWYER", "KSAW", "SAW", "None", "46.21N", "087.24W", "372", "US"],
    ["MI HANCOCK", "KCMX", "CMX", "72744", "47.10N", "088.29W", "326", "US"],
    ["MI HARBOR SPRINGS", "KMGN", "MGN", "None", "45.26N", "084.55W", "209", "US"],
    ["MI HART/SHELBY", "KC04", "C04", "None", "41.55N", "085.02W", "279", "US"],
    ["MI HILLSDALE", "KJYM", "JYM", "None", "41.55N", "084.35W", "360", "US"],
    ["MI HOLLAND", "KBIV", "BIV", "None", "42.45N", "086.06W", "208", "US"],
    ["MI HOUGHTON LAKE", "KHTL", "HTL", "72638", "44.21N", "084.40W", "351", "US"],
    ["MI HOWELL", "KOZW", "OZW", "None", "42.37N", "083.58W", "293", "US"],
    ["MI IONIA", "KY70", "Y70", "None", "42.56N", "085.04W", "250", "US"],
    ["MI IRON MOUNTAIN", "KIMT", "IMT", "None", "45.49N", "088.07W", "349", "US"],
    ["MI IRONWOOD", "KIWD", "IWD", "None", "46.31N", "090.07W", "375", "US"],
    ["MI JACKSON/REYNOLDS", "KJXN", "JXN", "None", "42.16N", "084.28W", "305", "US"],
    ["MI KALAMAZOO", "KAZO", "AZO", "None", "42.14N", "085.33W", "272", "US"],
    ["MI LAMBERTVILLE", "KDUH", "DUH", "None", "41.44N", "083.39W", "204", "US"],
    ["MI LANSING", "KLAN", "LAN", "72539", "42.47N", "084.35W", "264", "US"],
    ["MI LAPEER", "KD95", "D95", "None", "43.04N", "083.16W", "255", "US"],
    ["MI LUDINGTON/MASON", "KLDM", "LDM", "None", "43.58N", "086.24W", "197", "US"],
    ["MI MACKINAC ISLAND", "KMCD", "MCD", "None", "45.51N", "084.38W", "226", "US"],
    ["MI MANISTEE", "KMBL", "MBL", "None", "44.16N", "086.15W", "189", "US"],
    ["MI MANISTIQUE", "KISQ", "ISQ", "None", "45.58N", "086.10W", "209", "US"],
    ["MI MANISTIQUE", "KP75", "P75", "None", "45.57N", "086.14W", "178", "US"],
    ["MI MARSHALL", "KRMY", "RMY", "None", "42.14N", "084.57W", "287", "US"],
    ["MI MASON", "KTEW", "TEW", "None", "42.34N", "084.25W", "280", "US"],
    ["MI MENOMINEE", "KMNM", "MNM", "None", "45.07N", "087.37W", "191", "US"],
    ["MI MIDLAND BARSTOW", "KIKW", "IKW", "None", "43.40N", "084.16W", "194", "US"],
    ["MI MONROE", "KTTF", "TTF", "None", "41.56N", "083.25W", "188", "US"],
    ["MI MOUNT PLEASANT", "KMOP", "MOP", "None", "43.37N", "084.44W", "230", "US"],
    ["MI MUNISING LAKESH", "KP53", "P53", "None", "46.25N", "086.39W", "187", "US"],
    ["MI MUSKEGON", "KMKG", "MKG", "72636", "43.10N", "086.14W", "191", "US"],
    ["MI NEWBERRY", "KERY", "ERY", "None", "46.18N", "085.27W", "265", "US"],
    ["MI NILES VOR", "KGIJ", "GIJ", "None", "41.46N", "086.19W", "267", "US"],
    ["MI OSCODA/WURTSMITH", "KOSC", "OSC", "None", "44.27N", "083.24W", "193", "US"],
    ["MI OSCODA (VOR)", "KASP", "ASP", "None", "44.27N", "083.24W", "193", "US"],
    ["MI OWOSSO", "KRNP", "RNP", "None", "43.00N", "084.08W", "224", "US"],
    ["MI PELLSTON", "KPLN", "PLN", "None", "45.34N", "084.48W", "217", "US"],
    ["MI PONTIAC", "KPTK", "PTK", "None", "42.40N", "083.25W", "299", "US"],
    ["MI PULLMAN VOR", "KPMM", "PMM", "None", "42.28N", "086.07W", "213", "US"],
    ["MI PORT HOPE", "KP58", "P58", "None", "44.01N", "082.48W", "179", "US"],
    ["MI PORT HURON", "KPHN", "PHN", "None", "42.55N", "082.31W", "198", "US"],
    ["MI ROGERS CITY", "KPZQ", "PZQ", "None", "45.24N", "083.49W", "204", "US"],
    ["MI SAGINAW", "KMBS", "MBS", "None", "43.32N", "084.05W", "202", "US"],
    ["MI SAGINAW/BROWNE", "KHYX", "HYX", "None", "43.26N", "083.52W", "183", "US"],
    ["MI SALEM (LANSING)", "KSVM", "SVM", "None", "42.25N", "083.36W", "290", "US"],
    ["MI SAULT STE MARIE", "KSSM", "SSM", "None", "46.28N", "084.22W", "221", "US"],
    ["MI SAULT STE MARIE", "KANJ", "ANJ", "72734", "46.28N", "084.22W", "218", "US"],
    ["MI SELFRIDGE ANGB", "KMTC", "MTC", "None", "42.37N", "082.49W", "177", "US"],
    ["MI SOUTH HAVEN", "KLWA", "LWA", "None", "42.21N", "086.15W", "203", "US"],
    ["MI STURGIS/KIRSCH", "KIRS", "IRS", "None", "41.48N", "085.26W", "282", "US"],
    ["MI THREE RIVERS", "KHAI", "HAI", "None", "41.58N", "085.36W", "251", "US"],
    ["MI TRAVERSE CIT", "KTVC", "TVC", "None", "44.44N", "085.34W", "190", "US"],
    ["MI TROY/OAKLAND", "KVLL", "VLL", "None", "42.33N", "083.11W", "222", "US"],
    ["MI WEST BRANCH", "KY31", "Y31", "None", "44.15N", "084.11W", "270", "US"],
    ["MI CARO/TUSCOLA", "K78D", "78D", "None", "43.28N", "083.27W", "214", "US"],
    ["MI CHARLOTTE", "K07G", "07G", "None", "42.34N", "084.49W", "272", "US"],
    ["MI CHEBOYGAN", "KY15", "Y15", "None", "45.39N", "084.31W", "195", "US"],
    ["MI DETROIT/GROSSE I", "K2G5", "2G5", "None", "42.06N", "083.10W", "180", "US"],
    ["MI FREMONT", "K3FM", "3FM", "None", "43.26N", "086.00W", "236", "US"],
    ["MI GRAYLING AF", "K3RN", "3RN", "None", "44.41N", "084.44W", "353", "US"],
    ["MI GRAYLING AF", "K55D", "55D", "None", "44.41N", "084.44W", "353", "US"],
    ["MI HARBOR SPRINGS", "KD87", "D87", "None", "45.26N", "084.55W", "209", "US"],
    ["MI HOWELL", "K3HE", "3HE", "None", "42.37N", "083.58W", "293", "US"],
    ["MI LAMBERTVILLE", "K5G9", "5G9", "None", "41.44N", "083.39W", "204", "US"],
    ["MI MACKINAC ISLAND", "KY84", "Y84", "None", "45.52N", "084.38W", "226", "US"],
    ["MI MARQUETTE", "KMQT", "MQT", "72743", "46.32N", "087.34W", "430", "US"],
    ["MI MARSHALL", "K5D8", "5D8", "None", "42.15N", "084.57W", "287", "US"],
    ["MI MASON", "K09G", "09G", "None", "42.34N", "084.25W", "280", "US"],
    ["MI MONROE", "KD92", "D92", "None", "41.56N", "083.26W", "187", "US"],
    ["MI OWOSSO", "K5D3", "5D3", "None", "43.00N", "084.08W", "224", "US"],
    ["MI PASSAGE ISLAND", "None", "None", "99409", "48.13N", "088.37W", "195", "US"],
    ["MI PECK", "KECK", "ECK", "None", "43.15N", "082.43W", "247", "US"],
    ["MI ROCK OF AGES", "None", "None", "99413", "47.52N", "089.40W", "183", "US"],
    ["MI SAULT STE MARIE", "KY62", "Y62", "None", "46.28N", "084.22W", "219", "US"],
    ["MI SOUTH HAVEN", "K0D1", "0D1", "None", "42.21N", "086.15W", "203", "US"],
    ["MI STANNARD ROCK", "None", "None", "99420", "47.10N", "087.46W", "183", "US"],
    ["MI TROY/OAKLAND", "K7D2", "7D2", "None", "42.33N", "083.11W", "222", "US"],
    ["MN AITKIN NDB", "KAIT", "AIT", "None", "46.32N", "093.40W", "367", "US"],
    ["MN ALBERT LEA", "KAEL", "AEL", "None", "43.41N", "093.22W", "383", "US"],
    ["MN ALEXANDRIA", "KAXN", "AXN", "None", "45.52N", "095.24W", "433", "US"],
    ["MN APPLETON MUNICIP", "KAQP", "AQP", "None", "45.13N", "096.00W", "311", "US"],
    ["MN AUSTIN MUNI", "KAUM", "AUM", "None", "43.40N", "092.55W", "375", "US"],
    ["MN BAUDETTE", "KBDE", "BDE", "None", "48.44N", "094.37W", "329", "US"],
    ["MN BEMIDJI", "KBJI", "BJI", "72755", "47.30N", "094.55W", "420", "US"],
    ["MN BENSON MUNI", "KBBB", "BBB", "None", "45.19N", "095.39W", "317", "US"],
    ["MN BIGFORK", "KFOZ", "FOZ", "None", "47.46N", "093.39W", "411", "US"],
    ["MN BRAINERD", "KBRD", "BRD", "None", "46.24N", "094.08W", "372", "US"],
    ["MN BUFFALO MUNI", "KCFE", "CFE", "None", "45.10N", "093.51W", "295", "US"],
    ["MN CAMBRIDGE MUNI", "KCBG", "CBG", "None", "45.34N", "093.16W", "287", "US"],
    ["MN CANBY/MYERS FLD", "KCNB", "CNB", "None", "44.44N", "096.16W", "364", "US"],
    ["MN CHANHASSEN", "KMPX", "MPX", "72649", "44.51N", "093.34W", "288", "US"],
    ["MN CLOQUET", "KCOQ", "COQ", "None", "46.42N", "092.30W", "390", "US"],
    ["MN COOK MUNI AIRPOR", "KCQM", "CQM", "None", "47.49N", "092.41W", "404", "US"],
    ["MN CRANE LAKE", "KCDD", "CDD", "None", "48.16N", "092.29W", "341", "US"],
    ["MN CROOKSTON MUNI", "KCKN", "CKN", "None", "47.51N", "096.37W", "273", "US"],
    ["MN DETROIT LAKES", "KDTL", "DTL", "None", "46.49N", "095.52W", "426", "US"],
    ["MN DODGE CENTER", "KTOB", "TOB", "None", "44.01N", "092.49W", "398", "US"],
    ["MN DULUTH (SKY HARB", "KDYT", "DYT", "None", "46.43N", "092.02W", "186", "US"],
    ["MN DULUTH", "KDLH", "DLH", "72745", "46.51N", "092.12W", "435", "US"],
    ["MN ELBOW LAKE MUNI", "KY63", "Y63", "None", "45.59N", "096.00W", "367", "US"],
    ["MN ELY MUNI", "KELO", "ELO", "None", "47.49N", "091.49W", "443", "US"],
    ["MN EVELETH MUNI", "KEVM", "EVM", "None", "47.25N", "092.30W", "421", "US"],
    ["MN FAIRMONT MUNI", "KFRM", "FRM", "None", "43.38N", "094.25W", "354", "US"],
    ["MN FARIBAULT MUNI", "KFBL", "FBL", "None", "44.20N", "093.19W", "322", "US"],
    ["MN FERGUS FALLS", "KFFM", "FFM", "72656", "46.17N", "096.09W", "361", "US"],
    ["MN FLAG ISLAND", "KFGN", "FGN", "None", "49.19N", "094.54W", "328", "US"],
    ["MN FOSSTON", "KFSE", "FSE", "None", "47.35N", "095.46W", "389", "US"],
    ["MN GLENCOE", "KGYL", "GYL", "None", "44.46N", "094.05W", "302", "US"],
    ["MN GLENWOOD", "KGHW", "GHW", "None", "45.38N", "095.19W", "425", "US"],
    ["MN GRAND MARAIS", "KGNA", "None", "None", "47.45N", "090.21W", "185", "US"],
    ["MN GRAND MARAIS", "KGRM", "GRM", "None", "47.50N", "090.23W", "505", "US"],
    ["MN GRAND MARAIS/COO", "KCKC", "None", "None", "47.50N", "090.22W", "548", "US"],
    ["MN GRAND RAPIDS", "KGPZ", "GPZ", "None", "47.13N", "093.31W", "413", "US"],
    ["MN GRANITE FALLS", "KGDB", "GDB", "None", "44.45N", "095.33W", "319", "US"],
    ["MN HALLOCK", "KHCO", "HCO", "None", "48.45N", "096.56W", "250", "US"],
    ["MN HIBBING", "KHIB", "HIB", "None", "47.23N", "092.50W", "412", "US"],
    ["MN HINCKLEY", "K04W", "04W", "None", "46.01N", "092.54W", "311", "US"],
    ["MN HUTCHINSON", "KHCD", "HCD", "None", "44.52N", "094.23W", "323", "US"],
    ["MN INTERNTNL FALLS", "KINL", "INL", "72747", "48.34N", "093.24W", "360", "US"],
    ["MN JACKSON MUNI", "KMJQ", "MJQ", "None", "43.38N", "094.58W", "441", "US"],
    ["MN LAKE ELMO", "K21D", "21D", "None", "45.00N", "092.51W", "285", "US"],
    ["MN LITCHFIELD", "KLJF", "LJF", "None", "45.06N", "094.31W", "348", "US"],
    ["MN LITTLE FALLS", "KLXL", "LXL", "None", "45.57N", "094.20W", "342", "US"],
    ["MN LONG PRAIRIE", "K14Y", "14Y", "None", "45.54N", "094.52W", "406", "US"],
    ["MN LONGVILLE", "KXVG", "XVG", "None", "46.59N", "094.12W", "407", "US"],
    ["MN LUVERNE", "KLYV", "LYV", "None", "43.37N", "096.13W", "436", "US"],
    ["MN MADISON", "KDXX", "DXX", "None", "44.59N", "096.11W", "330", "US"],
    ["MN MAHNOMEN", "K3N8", "3N8", "None", "47.16N", "095.56W", "380", "US"],
    ["MN MANKATO", "KMKT", "MKT", "None", "44.13N", "093.55W", "311", "US"],
    ["MN MARSHALL/RYAN", "KMML", "MML", "None", "44.27N", "095.49W", "359", "US"],
    ["MN MAPLE LAKE", "KMGG", "MGG", "None", "45.14N", "093.59W", "313", "US"],
    ["MN MCGREGOR/IVERSON", "KHZX", "HZX", "None", "46.37N", "093.19W", "374", "US"],
    ["MN MINNEAPOLIS", "KMSP", "MSP", "72658", "44.53N", "093.14W", "265", "US"],
    ["MN MINNEAPLS/BLAINE", "KANE", "ANE", "None", "45.09N", "093.13W", "278", "US"],
    ["MN MINNEAPOLIS/RFC", "KMSR", "MSR", "None", "44.51N", "093.34W", "256", "US"],
    ["MN MINNEAPOLS/ARTCC", "KZMP", "ZMP", "None", "44.38N", "093.11W", "256", "US"],
    ["MN MNPLS/FLYING CLD", "KFCM", "FCM", "None", "44.50N", "093.28W", "280", "US"],
    ["MN MNPLS/CRYSTAL", "KMIC", "MIC", "None", "45.04N", "093.21W", "265", "US"],
    ["MN MNPLS/AIRLAKE", "KLVN", "LVN", "None", "44.38N", "093.14W", "293", "US"],
    ["MN MONTEVIDEO", "KMVE", "MVE", "None", "44.58N", "095.43W", "315", "US"],
    ["MN MOORHEAD MUNI", "KJKJ", "JKJ", "None", "46.50N", "096.40W", "280", "US"],
    ["MN MOOSE LAKE", "KMZH", "MZH", "None", "46.25N", "092.48W", "328", "US"],
    ["MN MORA", "KJMR", "JMR", "None", "45.53N", "093.16W", "309", "US"],
    ["MN MORRIS MUNI", "KMOX", "MOX", "None", "45.34N", "095.58W", "344", "US"],
    ["MN CANBY/MYERS FLD", "K27D", "27D", "None", "44.44N", "096.16W", "363", "US"],
    ["MN NEW ULM MUNI", "KULM", "ULM", "None", "44.19N", "094.30W", "308", "US"],
    ["MN NODINE VOR", "KODI", "ODI", "None", "43.55N", "091.28W", "427", "US"],
    ["MN OLIVIA", "KOVL", "OVL", "None", "44.47N", "095.02W", "328", "US"],
    ["MN ORR", "KORB", "ORB", "None", "48.01N", "092.52W", "397", "US"],
    ["MN ORTONVILLE", "KVVV", "VVV", "None", "45.18N", "096.25W", "335", "US"],
    ["MN OWATONNA", "KOWA", "OWA", "None", "44.07N", "093.15W", "350", "US"],
    ["MN PARK RAPIDS", "KPKD", "PKD", "None", "46.54N", "095.04W", "442", "US"],
    ["MN PAYNESVILLE", "KPEX", "PEX", "None", "45.22N", "094.44W", "360", "US"],
    ["MN PINE RIVER REGIO", "KPWC", "PWC", "None", "46.43N", "094.22W", "395", "US"],
    ["MN PIPESTONE", "KPQN", "PQN", "None", "43.58N", "096.19W", "529", "US"],
    ["MN PRESTON", "KFKA", "FKA", "None", "43.41N", "092.10W", "389", "US"],
    ["MN PRINCETON MUNI", "KPNM", "PNM", "None", "45.34N", "093.36W", "298", "US"],
    ["MN RED WING", "KRGK", "RGK", "None", "44.35N", "092.29W", "239", "US"],
    ["MN REDWOOD FALL", "KRWF", "RWF", "None", "44.33N", "095.05W", "311", "US"],
    ["MN ROCHESTER", "KRST", "RST", "72644", "43.54N", "092.30W", "403", "US"],
    ["MN ST MARY HOSPITAL", "K9MN", "9MN", "None", "44.01N", "092.29W", "355", "US"],
    ["MN ROSEAU MUNI", "KROX", "ROX", "None", "48.51N", "095.42W", "323", "US"],
    ["MN RUSH CITY", "KROS", "ROS", "None", "45.42N", "092.57W", "281", "US"],
    ["MN SAUK CENTRE", "KD39", "D39", "None", "45.42N", "094.56W", "380", "US"],
    ["MN SILVER BAY", "KBFW", "BFW", "None", "47.15N", "091.24W", "331", "US"],
    ["MN SLAYTON", "KDVP", "DVP", "None", "43.59N", "095.47W", "495", "US"],
    ["MN SOUTH ST PAUL", "KSGS", "SGS", "None", "44.52N", "093.02W", "250", "US"],
    ["MN ST. CLOUD", "KSTC", "STC", "72655", "45.33N", "094.03W", "314", "US"],
    ["MN ST. JAMES", "KJYG", "JYG", "None", "43.59N", "094.33W", "325", "US"],
    ["MN ST. PAUL", "KSTP", "STP", "None", "44.56N", "093.03W", "219", "US"],
    ["MN STANTON", "KSYN", "SYN", "None", "44.28N", "093.01W", "280", "US"],
    ["MN STAPLES", "KSAZ", "SAZ", "None", "46.22N", "094.48W", "392", "US"],
    ["MN THIEF RIVER", "KTVF", "TVF", "None", "48.04N", "096.10W", "340", "US"],
    ["MN TOFTE (RAMOS)", "KP61", "P61", "None", "47.34N", "090.49W", "241", "US"],
    ["MN TRACY", "KTKC", "TKC", "None", "44.15N", "095.37W", "408", "US"],
    ["MN TWO HARBORS", "KTWM", "TWM", "None", "47.02N", "091.45W", "328", "US"],
    ["MN WADENA MUNI", "KADC", "ADC", "None", "46.27N", "095.13W", "418", "US"],
    ["MN WALKER", "KY49", "Y49", "None", "47.10N", "094.39W", "411", "US"],
    ["MN WARROAD", "KRRT", "RRT", "72756", "48.56N", "095.20W", "327", "US"],
    ["MN WASECA", "KACQ", "ACQ", "None", "44.04N", "093.33W", "343", "US"],
    ["MN WASKISH MUNI", "KVWU", "VWU", "None", "48.09N", "094.31W", "360", "US"],
    ["MN WHEATON NDB", "KETH", "ETH", "None", "45.47N", "096.33W", "313", "US"],
    ["MN WILLMAR/RICE", "KILL", "ILL", "None", "45.07N", "095.04W", "344", "US"],
    ["MN WILLMAR MUNI", "KBDH", "BDH", "None", "45.07N", "095.08W", "247", "US"],
    ["MN WINDOM MUNI AIRP", "KMWM", "MWM", "None", "43.54N", "095.06W", "430", "US"],
    ["MN WINONA MUNI", "KONA", "ONA", "None", "44.04N", "091.42W", "200", "US"],
    ["MN WOOD LAKE PROFIL", "None", "WDL", "74341", "44.40N", "095.26W", "319", "US"],
    ["MN WORTHINGTON", "KOTG", "OTG", "None", "43.38N", "095.34W", "480", "US"],
    ["MN BIGFORK", "K85D", "85D", "None", "47.46N", "093.39W", "411", "US"],
    ["MN BUFFALO MUNI", "K8Y2", "8Y2", "None", "45.10N", "093.51W", "295", "US"],
    ["MN CRANE LAKE", "K8Y8", "8Y8", "None", "46.16N", "092.34W", "350", "US"],
    ["MN DODGE CENTER", "K87D", "87D", "None", "44.01N", "092.49W", "398", "US"],
    ["MN DULUTH/SKY HRBR", "KD36", "D36", "None", "46.43N", "092.03W", "186", "US"],
    ["MN GLENCOE", "KY29", "Y29", "None", "44.45N", "095.55W", "302", "US"],
    ["MN GRANITE FALLS", "K1G2", "1G2", "None", "44.45N", "095.33W", "319", "US"],
    ["MN HALLOCK", "K03Y", "03Y", "None", "48.46N", "096.57W", "250", "US"],
    ["MN LITCHFIELD MUNI", "K43F", "43F", "None", "45.06N", "094.30W", "347", "US"],
    ["MN LONGVILLE", "KD33", "D33", "None", "46.59N", "094.12W", "407", "US"],
    ["MN LUVERNE", "KD19", "D19", "None", "43.37N", "096.13W", "436", "US"],
    ["MN MAPLE LAKE", "KY33", "Y33", "None", "45.14N", "093.59W", "313", "US"],
    ["MN LAKEVILLE/MNPLS", "KY12", "Y12", "None", "44.38N", "093.14W", "293", "US"],
    ["MN MCGREGOR/IVERSON", "K17Y", "17Y", "None", "46.37N", "093.19W", "374", "US"],
    ["MN MORA MUNI", "K19D", "19D", "None", "45.52N", "093.16W", "309", "US"],
    ["MN MOOREHEAD", "K99M", "99M", "None", "46.50N", "096.40W", "280", "US"],
    ["MN PAYNESVILLE", "K2P3", "2P3", "None", "45.22N", "094.45W", "360", "US"],
    ["MN PEQUOT LAKE", "KP39", "P39", "72750", "46.36N", "094.19W", "390", "US"],
    ["MN RUSH CITY", "K54Y", "54Y", "None", "45.42N", "092.57W", "281", "US"],
    ["MN SLAYTON", "K60Y", "60Y", "None", "43.59N", "095.47W", "495", "US"],
    ["MN SOUTH ST PAUL", "KD97", "D97", "None", "44.51N", "093.09W", "250", "US"],
    ["MN ST JAMES MUNI", "KD40", "D40", "None", "43.59N", "094.33W", "325", "US"],
    ["MN TRACY", "KY68", "Y68", "None", "44.15N", "095.36W", "408", "US"],
    ["MN WADENA", "K17W", "17W", "None", "46.27N", "095.12W", "415", "US"],
    ["MN WARROAD", "KD45", "D45", "None", "48.56N", "095.21W", "326", "US"],
    ["MN WARROAD", "KRAD", "RAD", "None", "48.56N", "095.20W", "327", "US"],
    ["MN AUSTIN", "QASM", "None", "None", "43.40N", "092.57W", "365", "US"],
    ["MN ALBERT LEA", "QBLM", "None", "None", "43.38N", "093.23W", "383", "US"],
    ["MN PRESTON", "QFCM", "None", "None", "43.40N", "092.00W", "318", "US"],
    ["MN ROCHESTER", "QFMM", "None", "None", "44.01N", "092.28W", "304", "US"],
    ["MN GRAND MEADOW", "QGMM", "None", "None", "43.43N", "092.30W", "403", "US"],
    ["MN HILLS", "QHIM", "None", "None", "43.31N", "096.22W", "342", "US"],
    ["MN ROCHESTER", "QJAM", "None", "None", "44.04N", "092.29W", "317", "US"],
    ["MN ROCHESTER", "QKGM", "None", "None", "44.02N", "092.28W", "319", "US"],
    ["MN LEROY", "QLEM", "None", "None", "43.31N", "092.31W", "393", "US"],
    ["MN MADISON", "QMAM", "None", "None", "45.01N", "096.11W", "340", "US"],
    ["MN WORTHINGTON", "QMOM", "None", "None", "43.38N", "095.38W", "483", "US"],
    ["MN LUVERNE", "QMSM", "None", "None", "43.40N", "096.13W", "443", "US"],
    ["MN LAMBERTON", "QRCM", "None", "None", "44.14N", "095.16W", "349", "US"],
    ["MN WEST CONCORD", "QTMM", "None", "None", "44.08N", "092.54W", "387", "US"],
    ["MN ROCHESTER", "QWLM", "None", "None", "43.59N", "092.26W", "312", "US"],
    ["MO BLOOMFIELD PROFI", "None", "BLM", "74662", "36.52N", "089.58W", "130", "US"],
    ["MO BOONVILLE", "KVER", "VER", "None", "38.57N", "092.41W", "218", "US"],
    ["MO BRANSON", "KBBG", "BBG", "None", "36.32N", "093.12W", "397", "US"],
    ["MO BRANSON WEST", "KFWB", "FWB", "None", "36.42N", "093.24W", "406", "US"],
    ["MO BUTLER", "KBUM", "BUM", "None", "38.16N", "094.29W", "271", "US"],
    ["MO CAMDENTON", "KOZS", "OZS", "None", "37.58N", "092.41W", "324", "US"],
    ["MO CAPE GIRARDEAU", "KCGI", "CGI", "None", "37.14N", "089.35W", "102", "US"],
    ["MO CHILLICOTHE", "KCDJ", "CDJ", "None", "39.49N", "093.35W", "234", "US"],
    ["MO CLINTON", "KGLY", "GLY", "None", "38.21N", "093.41W", "251", "US"],
    ["MO COLUMBIA", "KCOU", "COU", "72445", "38.49N", "092.13W", "271", "US"],
    ["MO CONWAY PROFILER", "None", "CNW", "74550", "37.31N", "092.42W", "390", "US"],
    ["MO FARMINGTON", "KFAM", "FAM", "None", "37.46N", "090.25W", "288", "US"],
    ["MO FORT LEONARD WOO", "KTBN", "TBN", "None", "37.43N", "092.07W", "353", "US"],
    ["MO GRANDVIEW", "KGVW", "GVW", "None", "38.50N", "094.34W", "337", "US"],
    ["MO HANNIBAL", "KHAE", "HAE", "None", "39.44N", "091.27W", "234", "US"],
    ["MO HARRISONVILLE", "KLRY", "LRY", "None", "38.37N", "094.21W", "279", "US"],
    ["MO JEFFERSON CITY", "KJEF", "JEF", "None", "38.36N", "092.09W", "168", "US"],
    ["MO JOPLIN", "KJLN", "JLN", "None", "37.09N", "094.30W", "299", "US"],
    ["MO LEBANON", "KLBO", "LBO", "None", "37.39N", "092.39W", "403", "US"],
    ["MO KAISER MEM", "KAIZ", "AIZ", "None", "38.06N", "092.32W", "265", "US"],
    ["MO KANSAS CITY/INTL", "KMCI", "MCI", "72446", "39.18N", "094.44W", "320", "US"],
    ["MO KANSAS CITY/DNTN", "KMKC", "MKC", "None", "39.07N", "094.36W", "227", "US"],
    ["MO KANSAS CITY/COM", "KNKA", "NKA", "None", "39.07N", "094.36W", "231", "US"],
    ["MO KANSAS CITY/AWC", "KKCI", "KCI", "None", "39.17N", "094.40W", "231", "US"],
    ["MO KANSAS CITY/RFC", "KKRF", "KRF", "None", "38.49N", "094.16W", "312", "US"],
    ["MO KANSAS CIT/ARTCC", "KZKC", "ZKC", "None", "38.51N", "094.44W", "231", "US"],
    ["MO KENNETT", "KTKX", "TKX", "None", "36.14N", "090.02W", "80", "US"],
    ["MO KIRKSVILLE", "KIRK", "IRK", "None", "40.06N", "092.33W", "293", "US"],
    ["MO LATHROP PROFILER", "None", "LTH", "74551", "39.34N", "094.10W", "297", "US"],
    ["MO LEES SUMMIT MUNI", "KLXT", "LXT", "None", "38.58N", "094.22W", "306", "US"],
    ["MO MALDEN", "KMAW", "MAW", "None", "36.36N", "090.00W", "90", "US"],
    ["MO MARSHALL", "KMHL", "MHL", "None", "39.06N", "093.12W", "237", "US"],
    ["MO MARYVILLE", "KEVU", "EVU", "None", "40.21N", "094.55W", "349", "US"],
    ["MO MEXICO", "KMYJ", "MYJ", "None", "39.09N", "091.49W", "251", "US"],
    ["MO MOBERLY", "KMBY", "MBY", "None", "39.28N", "092.26W", "264", "US"],
    ["MO MONETT", "KUMN", "UMN", "72349", "36.52N", "093.54W", "437", "US"],
    ["MO MONETT", "KHFJ", "HFJ", "None", "36.54N", "094.01W", "401", "US"],
    ["MO MOSBY", "KGPH", "None", "None", "39.20N", "094.19W", "235", "US"],
    ["MO NEOSHO", "KEOS", "EOS", "None", "36.49N", "094.24W", "383", "US"],
    ["MO NEVADA", "KNVD", "NVD", "None", "37.51N", "094.18W", "272", "US"],
    ["MO PERRYVILE", "KPCD", "PCD", "None", "37.52N", "089.52W", "114", "US"],
    ["MO PIEDMONT", "KPYN", "PYN", "None", "37.08N", "090.43W", "142", "US"],
    ["MO PLEASANT HILL/KC", "KEAX", "EAX", "None", "38.49N", "094.16W", "303", "US"],
    ["MO POPULAR BLUFF", "KPOF", "POF", "None", "36.46N", "090.19W", "99", "US"],
    ["MO SEDALIA", "KDMO", "DMO", "None", "38.43N", "093.10W", "274", "US"],
    ["MO SIKESTON", "KSIK", "SIK", "None", "36.54N", "089.34W", "96", "US"],
    ["MO SPICKARD", "KP35", "P35", "72540", "40.15N", "093.43W", "270", "US"],
    ["MO SPRINGFIELD", "KSGF", "SGF", "72440", "37.14N", "093.23W", "390", "US"],
    ["MO ST CHARLES/88D", "KLSX", "LSX", "None", "38.42N", "090.41W", "185", "US"],
    ["MO ST. CHARLES", "KSET", "SET", "None", "38.56N", "090.26W", "134", "US"],
    ["MO ST. JOSEPH", "KSTJ", "STJ", "72449", "39.46N", "094.55W", "247", "US"],
    ["MO ST. LOUIS/SPIRIT", "KSUS", "SUS", "None", "38.39N", "090.39W", "141", "US"],
    ["MO ST. LOUIS", "KSTL", "STL", "72434", "38.45N", "090.22W", "171", "US"],
    ["MO SULLIVAN", "KUUV", "UUV", "None", "38.14N", "091.10W", "284", "US"],
    ["MO VICHY/ROLLA", "KVIH", "VIH", "None", "38.08N", "091.46W", "333", "US"],
    ["MO WARSAW", "KRAW", "RAW", "None", "38.21N", "093.21W", "285", "US"],
    ["MO WARRENSBURG SKYH", "KRCM", "RCM", "None", "38.47N", "093.48W", "244", "US"],
    ["MO WASHINGTON", "KFYG", "FYG", "None", "38.35N", "091.00W", "149", "US"],
    ["MO WEST PLAINS", "KUNO", "UNO", "72348", "36.53N", "091.54W", "372", "US"],
    ["MO WHITEMAN AFB", "KSZL", "SZL", "None", "38.43N", "093.32W", "265", "US"],
    ["MO POPLAR BLUFF", "KP02", "P02", "72330", "36.46N", "090.28W", "146", "US"],
    ["MO ST. CHARLES", "K3SQ", "3SQ", "None", "38.51N", "090.30W", "135", "US"],
    ["MO CAMDENTON", "KH21", "H21", "None", "37.58N", "092.41W", "324", "US"],
    ["MO WEST PLAINS", "KH63", "H63", "None", "36.45N", "091.52W", "308", "US"],
    ["MO WARRENSBURG SKYH", "K9K4", "9K4", "None", "38.47N", "093.48W", "244", "US"],
    ["MS ABERDEEN/AMORY", "KM40", "M40", "None", "33.52N", "088.29W", "69", "US"],
    ["MS BATESVILLE", "KPMU", "PMU", "None", "34.22N", "089.54W", "68", "US"],
    ["MS BAY ST LOUIS", "KHSA", "HSA", "None", "30.22N", "089.27W", "7", "US"],
    ["MS BELMONT", "K01M", "01M", "None", "34.30N", "088.12W", "176", "US"],
    ["MS BILOXI/KEESLER", "KBIX", "BIX", "None", "30.25N", "088.55W", "10", "US"],
    ["MS BIGBEE", "KIGB", "IGB", "None", "33.29N", "088.30W", "73", "US"],
    ["MS BROOKHAVEN", "K1R7", "1R7", "None", "31.36N", "090.25W", "149", "US"],
    ["MS CLARKSDALE", "KCKM", "CKM", "None", "34.18N", "090.31W", "53", "US"],
    ["MS CLEVELAND", "KRNV", "RNV", "None", "33.46N", "090.45W", "41", "US"],
    ["MS COLUMBIA-MARION", "K0R0", "0R0", "None", "31.18N", "089.49W", "81", "US"],
    ["MS COLUMBUS AFB", "KCBM", "CBM", "None", "33.38N", "088.27W", "67", "US"],
    ["MS COLUMBUS AFB/88D", "KGWX", "GWX", "None", "33.54N", "088.20W", "145", "US"],
    ["MS CONCORDIA PARISH", "K0R4", "0R4", "None", "31.34N", "091.30W", "17", "US"],
    ["MS CORINTH/R TURNER", "KCRX", "CRX", "None", "34.55N", "088.36W", "130", "US"],
    ["MS GOLDEN/COLUMBUS", "KGTR", "GTR", "None", "33.27N", "088.34W", "80", "US"],
    ["MS GREENVILLE", "KGLH", "GLH", "None", "33.30N", "090.59W", "45", "US"],
    ["MS GREENWOOD", "KGWO", "GWO", "None", "33.30N", "090.05W", "44", "US"],
    ["MS GULFPORT", "KGPT", "GPT", "None", "30.25N", "089.05W", "14", "US"],
    ["MS HATTIESBURG", "KHBG", "HBG", "None", "31.16N", "089.15W", "44", "US"],
    ["MS INDIANOLA", "KIDL", "IDL", "None", "33.29N", "090.41W", "39", "US"],
    ["MS JACKSON/HAWKINS", "KHKS", "HKS", "None", "32.20N", "090.13W", "108", "US"],
    ["MS JACKSON", "KJAN", "JAN", "72235", "32.19N", "090.05W", "91", "US"],
    ["MS LAUREL", "KLUL", "LUL", "None", "31.28N", "089.20W", "91", "US"],
    ["MS MADISON", "KMBO", "MBO", "None", "32.26N", "090.06W", "100", "US"],
    ["MS MAGNOLIA", "KMHZ", "MHZ", "None", "32.26N", "090.06W", "91", "US"],
    ["MS BRANDON/JACKSON", "KDGX", "DGX", "None", "32.17N", "089.59W", "186", "US"],
    ["MS MCCOMB", "KMCB", "MCB", "None", "31.11N", "090.28W", "124", "US"],
    ["MS MERIDIAN NAS", "KNMM", "NMM", "None", "32.32N", "088.34W", "97", "US"],
    ["MS MERIDIAN/KEY FLD", "KMEI", "MEI", "72234", "32.20N", "088.45W", "89", "US"],
    ["MS NATCHEZ/HARDY", "KHEZ", "HEZ", "None", "31.37N", "091.18W", "83", "US"],
    ["MS OLIVE BRANCH", "KOLV", "OLV", "None", "34.59N", "089.47W", "122", "US"],
    ["MS OKOLONA PROFILER", "None", "OKO", "74769", "34.04N", "088.51W", "125", "US"],
    ["MS OXFORD", "KUOX", "UOX", "None", "34.23N", "089.32W", "137", "US"],
    ["MS PASCAGOULA", "KPQL", "PQL", "None", "30.28N", "088.32W", "6", "US"],
    ["MS PASCAGOULA", "KPGL", "PGL", "None", "30.24N", "088.29W", "3", "US"],
    ["MS PINE BELT RGNL", "KPIB", "PIB", "None", "31.28N", "089.19W", "91", "US"],
    ["MS RAYMOND", "KJVW", "JVW", "None", "32.18N", "090.25W", "76", "US"],
    ["MS SIDON VOR", "KSQS", "SQS", "None", "33.28N", "090.17W", "42", "US"],
    ["MS STARKVILLE", "KSTF", "STF", "None", "33.26N", "088.51W", "102", "US"],
    ["MS TUNICA", "KUTA", "UTA", "None", "34.41N", "090.21W", "59", "US"],
    ["MS TUPELO", "KTUP", "TUP", "72332", "34.16N", "088.46W", "105", "US"],
    ["MS VICKSBURG", "KVKS", "VKS", "None", "32.14N", "090.56W", "32", "US"],
    ["MS WINONA", "K5A6", "5A6", "None", "33.28N", "089.44W", "111", "US"],
    ["MS GREENWOOD", "KGRW", "GRW", "None", "33.30N", "090.05W", "44", "US"],
    ["MS RAYMOND", "KM16", "M16", "None", "32.18N", "090.25W", "76", "US"],
    ["MS YAZOO CITY", "KYZO", "YZO", "None", "32.54N", "090.22W", "36", "US"],
    ["MS INNOVATOR OILP", "KMYT", "MYT", "None", "28.13N", "089.37W", "23", "US"],
    ["MS WEST DELTA 27A", "KDLP", "DLP", "None", "29.07N", "089.33W", "36", "US"],
    ["MT BAKER", "KBHK", "None", "None", "46.21N", "104.15W", "902", "US"],
    ["MT ENNIS BIG SKY", "KEKS", "EKS", "None", "45.16N", "111.39W", "1641", "US"],
    ["MT BILLINGS", "KBIL", "BIL", "72677", "45.48N", "108.33W", "1091", "US"],
    ["MT BILLINGS (WFO)", "KBYZ", "BYZ", "None", "45.48N", "108.33W", "1091", "US"],
    ["MT BOZEMAN", "KBZN", "BZN", "None", "45.47N", "111.10W", "1361", "US"],
    ["MT BROWNING", "K8S0", "8S0", "None", "48.36N", "113.07W", "1419", "US"],
    ["MT BUTTE", "KBTM", "BTM", "None", "45.58N", "112.30W", "1688", "US"],
    ["MT CHINOOK", "KS71", "S71", "None", "48.36N", "109.15W", "736", "US"],
    ["MT COLSTRIP", "KM46", "M46", "None", "45.51N", "106.43W", "1044", "US"],
    ["MT CUT BANK", "KCTB", "CTB", "None", "48.36N", "112.22W", "1175", "US"],
    ["MT DILLON", "KDLN", "DLN", "None", "45.15N", "112.33W", "1591", "US"],
    ["MT DRUMMOND", "K3DU", "3DU", "None", "46.40N", "113.09W", "1202", "US"],
    ["MT EKALAKA", "K97M", "97M", "None", "45.53N", "104.32W", "1068", "US"],
    ["MT EUREKA", "K88M", "88M", "None", "48.58N", "115.05W", "814", "US"],
    ["MT FORSYTH", "K1S3", "1S3", "None", "46.16N", "106.37W", "832", "US"],
    ["MT GLASGOW", "KGGW", "GGW", "72768", "48.13N", "106.37W", "694", "US"],
    ["MT GLENDIVE", "KGDV", "GDV", "None", "47.07N", "104.47W", "749", "US"],
    ["MT GRASS RANGE", "KMVH", "MVH", "None", "46.50N", "108.56W", "1355", "US"],
    ["MT GREAT FALLS/88D", "KTFX", "TFX", "72776", "47.28N", "111.23W", "1132", "US"],
    ["MT GREAT FALLS", "KGTF", "GTF", "72775", "47.28N", "111.23W", "1119", "US"],
    ["MT HAMILTON/RAVALLI", "K6S5", "6S5", "None", "46.15N", "114.08W", "1110", "US"],
    ["MT HARLOWTON", "K3HT", "3HT", "None", "46.25N", "109.49W", "1268", "US"],
    ["MT HAVRE", "KHVR", "HVR", "72777", "48.33N", "109.46W", "787", "US"],
    ["MT HELENA", "KHLN", "HLN", "72772", "46.36N", "111.59W", "1182", "US"],
    ["MT JORDAN", "KJDN", "JDN", "None", "47.20N", "106.57W", "801", "US"],
    ["MT KALISPELL", "KFCA", "FCA", "72779", "48.18N", "114.16W", "908", "US"],
    ["MT KALISPELL", "KGPI", "GPI", "None", "48.19N", "114.15W", "908", "US"],
    ["MT LAUREL", "K6S8", "6S8", "None", "45.42N", "108.46W", "1072", "US"],
    ["MT LEWISTOWN", "KLWT", "LWT", "None", "47.02N", "109.28W", "1270", "US"],
    ["MT LIBBY", "KS59", "S59", "None", "48.17N", "115.29W", "793", "US"],
    ["MT LIVINGSTON", "KLVM", "LVM", "None", "45.42N", "110.26W", "1418", "US"],
    ["MT MALMSTROM AFB", "KGFA", "GFA", "None", "47.30N", "111.10W", "1075", "US"],
    ["MT MALTA", "KM75", "M75", "None", "48.22N", "107.55W", "687", "US"],
    ["MT MILES CITY", "KMLS", "MLS", "74230", "46.26N", "105.53W", "801", "US"],
    ["MT MISSOULA CTY/88D", "KMSX", "MSX", "None", "47.02N", "113.59W", "2394", "US"],
    ["MT MISSOULA", "KMSO", "MSO", "72773", "46.55N", "114.06W", "975", "US"],
    ["MT PLAINS", "KS34", "S34", "None", "47.28N", "114.54W", "752", "US"],
    ["MT PLENTYWOOD", "KPWD", "PWD", "None", "48.47N", "104.31W", "686", "US"],
    ["MT POPLAR", "KPO1", "PO1", "None", "48.08N", "105.10W", "621", "US"],
    ["MT POWDER RIVER", "KQPR", "None", "None", "45.32N", "104.52W", "966", "US"],
    ["MT ROUNDUP", "KRPX", "RPX", "None", "46.28N", "108.33W", "1065", "US"],
    ["MT SCOBEY", "K9S2", "9S2", "None", "48.48N", "105.26W", "742", "US"],
    ["MT SIDNEY RICHLAND", "KSDY", "SDY", "None", "47.42N", "104.12W", "605", "US"],
    ["MT THOMPSON FALLS", "K3TH", "3TH", "None", "47.36N", "115.22W", "725", "US"],
    ["MT TWIN BRIDGES", "K7S1", "7S1", "None", "45.32N", "112.18W", "1456", "US"],
    ["MT WEST YELLOWSTONE", "KWEY", "WEY", "72676", "44.38N", "111.05W", "2031", "US"],
    ["MT WOLF POINT", "KOLF", "OLF", "None", "48.06N", "105.35W", "604", "US"],
    ["MT WEST YELLOWSTONE", "KWYS", "WYS", "None", "44.40N", "111.07W", "2025", "US"],
    ["MT YELLOWST/BILLING", "KBLX", "BLX", "None", "45.51N", "108.36W", "1097", "US"],
    ["MT BROADUS", "K4BQ", "4BQ", "72667", "45.26N", "105.24W", "922", "US"],
    ["MT HAMILTON/RAVALLI", "KHMM", "HMM", "None", "46.15N", "114.09W", "1110", "US"],
    ["MT MONIDA", "KMQM", "MQM", "None", "44.34N", "112.19W", "2068", "US"],
    ["NC AHOSKIE/TRI COUN", "KASJ", "ASJ", "None", "36.17N", "077.10W", "21", "US"],
    ["NC ALBEMARLE STANLY", "KVUJ", "VUJ", "None", "35.25N", "080.09W", "186", "US"],
    ["NC ANDREWS", "KRHP", "RHP", "None", "35.11N", "083.51W", "518", "US"],
    ["NC WADESBORO/ANSON", "KAFP", "AFP", "None", "35.01N", "080.05W", "92", "US"],
    ["NC ASHEBORO MUNI", "KHBI", "HBI", "None", "35.39N", "079.54W", "205", "US"],
    ["NC ASHEVILLE", "KAVL", "AVL", "72315", "35.26N", "082.32W", "670", "US"],
    ["NC BEAUFORT", "KMRH", "MRH", "None", "34.44N", "076.39W", "3", "US"],
    ["NC BOGUE/SWANSBORO", "KNJM", "NJM", "None", "34.40N", "077.01W", "7", "US"],
    ["NC BOONE WATAUGA CT", "KTNB", "TNB", "None", "36.12N", "081.39W", "911", "US"],
    ["NC BURLINGTON", "KBUY", "BUY", "None", "36.03N", "079.28W", "180", "US"],
    ["NC CAPE HATTERAS", "KHAT", "HAT", "72302", "35.16N", "075.32W", "3", "US"],
    ["NC CAPE HATTERAS", "None", "None", "72304", "35.16N", "075.32W", "3", "US"],
    ["NC CHAPEL HILL", "KIGX", "IGX", "None", "35.56N", "079.04W", "155", "US"],
    ["NC CHARLOTTE", "KCLT", "CLT", "72314", "35.13N", "080.57W", "220", "US"],
    ["NC CHERRY POINT", "KNKT", "NKT", "72309", "34.54N", "076.53W", "9", "US"],
    ["NC CLAYTON/RDU 88D", "KRAX", "RAX", "None", "35.40N", "078.29W", "106", "US"],
    ["NC CLINTON", "KCTZ", "CTZ", "None", "34.59N", "078.22W", "45", "US"],
    ["NC CONCORD REG ARPT", "KJQF", "JQF", "None", "35.23N", "080.43W", "210", "US"],
    ["NC CURRITUCK", "KONX", "ONX", "None", "36.24N", "076.01W", "5", "US"],
    ["NC DAVIDSON CTY AP", "KEXX", "EXX", "None", "35.47N", "080.18W", "223", "US"],
    ["NC EDENTON", "KEDE", "EDE", "None", "36.01N", "076.34W", "6", "US"],
    ["NC ELIZABETH CITY", "KECG", "ECG", "None", "36.16N", "076.11W", "11", "US"],
    ["NC ELIZABETHTOWN", "KEYF", "EYF", "None", "34.36N", "078.35W", "41", "US"],
    ["NC ENGELHARD", "K7W6", "7W6", "None", "35.34N", "075.57W", "2", "US"],
    ["NC ERWIN/HARNETT CO", "KHRJ", "HRJ", "None", "35.23N", "078.44W", "60", "US"],
    ["NC FAYETTEVILLE", "KFAY", "FAY", "None", "34.59N", "078.53W", "55", "US"],
    ["NC FORT BRAGG/SIMMO", "KFBG", "FBG", "74693", "35.07N", "078.55W", "74", "US"],
    ["NC GASTONIA", "KAKH", "AKH", "None", "35.12N", "081.09W", "243", "US"],
    ["NC GOLDSBORO/S. J.", "KGSB", "GSB", "None", "35.19N", "077.58W", "33", "US"],
    ["NC GOLDSBORO/WAYNE", "KGWW", "GWW", "None", "35.28N", "077.58W", "41", "US"],
    ["NC GREENSBORO", "KGSO", "GSO", "72317", "36.06N", "079.57W", "275", "US"],
    ["NC HATTERAS/MITCHEL", "KHSE", "HSE", "None", "35.14N", "075.37W", "3", "US"],
    ["NC HENDERSON/OXFORD", "KHNZ", "HNZ", "None", "36.22N", "078.32W", "161", "US"],
    ["NC HICKORY", "KHKY", "HKY", "None", "35.45N", "081.23W", "354", "US"],
    ["NC HOFFMAN/MACKALL", "KHFF", "HFF", "None", "35.01N", "079.30W", "115", "US"],
    ["NC JACKSONVILLE", "KOAJ", "OAJ", "None", "34.49N", "077.37W", "29", "US"],
    ["NC JEFFERSON", "KGEV", "GEV", "None", "36.26N", "081.25W", "969", "US"],
    ["NC KENANSVILLE/DUPL", "KDPL", "DPL", "None", "35.00N", "077.58W", "42", "US"],
    ["NC KILL DEVIL HILLS", "KFFA", "FFA", "None", "36.01N", "075.40W", "4", "US"],
    ["NC KINSTON/STALLING", "KISO", "ISO", "None", "35.19N", "077.37W", "29", "US"],
    ["NC LINCOLNTON", "KIPJ", "IPJ", "None", "35.29N", "081.10W", "267", "US"],
    ["NC LOUISBURG/FRANKL", "KLHZ", "LHZ", "None", "36.01N", "078.20W", "113", "US"],
    ["NC LUMBERTON", "KLBT", "LBT", "None", "34.36N", "079.04W", "37", "US"],
    ["NC MACON/FRANKLIN", "K1A5", "1A5", "None", "35.13N", "083.25W", "616", "US"],
    ["NC MANTEO/DARE CO", "KMQI", "MQI", "None", "35.55N", "075.42W", "4", "US"],
    ["NC MAXTON", "KMEB", "MEB", "None", "34.47N", "079.22W", "67", "US"],
    ["NC MONROE", "KEQY", "EQY", "None", "35.01N", "080.37W", "212", "US"],
    ["NC MOREHEAD/NEWPORT", "KMHX", "MHX", "72305", "34.46N", "076.52W", "9", "US"],
    ["NC MORGANTON/LENOIR", "KMRN", "MRN", "None", "35.49N", "081.37W", "387", "US"],
    ["NC MOUNT AIRY/SURRY", "KMWK", "MWK", "None", "36.28N", "080.33W", "380", "US"],
    ["NC NEW BERN", "KEWN", "EWN", "None", "35.04N", "077.03W", "3", "US"],
    ["NC NEW RIVER MCAS", "KNCA", "NCA", "None", "34.43N", "077.27W", "8", "US"],
    ["NC PINEY ISLAND", "KNBT", "NBT", "None", "35.01N", "076.28W", "5", "US"],
    ["NC PITT GREENVILLE", "KPGV", "PGV", "None", "35.37N", "077.24W", "8", "US"],
    ["NC POPE AFB", "KPOB", "POB", "72303", "35.10N", "079.01W", "66", "US"],
    ["NC RALEIGH/DURHAM", "KRDU", "RDU", "72306", "35.54N", "078.47W", "130", "US"],
    ["NC RALEIGH/WFO", "KRAH", "RAH", "None", "35.52N", "078.47W", "133", "US"],
    ["NC REIDSVILLE", "KSIF", "SIF", "None", "36.26N", "079.51W", "211", "US"],
    ["NC ROANOKE RAPIDS", "KRZZ", "RZZ", "None", "36.26N", "077.43W", "75", "US"],
    ["NC HALIFAX NORTHAMP", "KIXA", "IXA", "None", "36.20N", "077.38W", "44", "US"],
    ["NC ROCKINGHAM", "KRCZ", "RCZ", "None", "34.53N", "079.46W", "109", "US"],
    ["NC ROCKY MOUNT", "KRWI", "RWI", "None", "35.51N", "077.54W", "47", "US"],
    ["NC ROXBORO PERSON", "KTDF", "TDF", "None", "36.17N", "078.59W", "186", "US"],
    ["NC RUTHERFORDTON", "KFQD", "FQD", "None", "35.25N", "081.56W", "329", "US"],
    ["NC SALISBURY ROWAN", "KRUQ", "RUQ", "None", "35.39N", "080.31W", "236", "US"],
    ["NC SANFORD", "KTTA", "TTA", "None", "35.35N", "079.06W", "75", "US"],
    ["NC SHALLOTTE/WILM.", "KLTX", "LTX", "None", "33.59N", "078.26W", "20", "US"],
    ["NC SHELBY MUNI", "KEHO", "EHO", "None", "35.15N", "081.36W", "258", "US"],
    ["NC SILER CITY", "KSCR", "SCR", "None", "35.42N", "079.30W", "188", "US"],
    ["NC SOUTHERN PINES", "KSOP", "SOP", "None", "35.13N", "079.24W", "141", "US"],
    ["NC SMITHFIELD JOHNS", "KJNX", "JNX", "None", "35.32N", "078.23W", "50", "US"],
    ["NC STATESVILLE", "KSVH", "SVH", "None", "35.45N", "080.57W", "294", "US"],
    ["NC STUMPY POINT", "K2DP", "2DP", "74695", "35.41N", "075.54W", "3", "US"],
    ["NC SOUTHPORT", "KSUT", "SUT", "None", "33.56N", "078.05W", "8", "US"],
    ["NC SYLVA", "K24A", "24A", "None", "35.19N", "083.13W", "871", "US"],
    ["NC TARBORO", "KETC", "ETC", "None", "35.56N", "077.33W", "17", "US"],
    ["NC WASHINGTON", "KOCW", "OCW", "None", "35.34N", "077.03W", "12", "US"],
    ["NC WHITEVILLE", "KCPC", "CPC", "None", "34.17N", "078.43W", "29", "US"],
    ["NC WILKESBORO", "KUKF", "UKF", "None", "36.13N", "081.06W", "396", "US"],
    ["NC WILMINGTON", "KILM", "ILM", "None", "34.16N", "077.54W", "9", "US"],
    ["NC WINSTON SALEM", "KINT", "INT", "72319", "36.08N", "080.13W", "291", "US"],
    ["NC ANDREWS", "K6A3", "6A3", "None", "35.11N", "083.51W", "518", "US"],
    ["NC ASHEBORO", "KW44", "W44", "None", "35.39N", "080.06W", "205", "US"],
    ["NC BOGUE FLD (KQAJ)", "None", "None", "None", "34.40N", "077.02W", "7", "US"],
    ["NC CAPE LOOKOUT", "None", "None", "99416", "34.36N", "076.28W", "5", "US"],
    ["NC CURRITUCK", "K9W7", "9W7", "None", "36.24N", "076.01W", "5", "US"],
    ["NC DIAMOND SHORES", "K44W", "44W", "74696", "35.09N", "075.42W", "5", "US"],
    ["NC DIAMOND SHOALS", "None", "None", "99403", "35.09N", "075.42W", "1", "US"],
    ["NC ERWIN/HARNETT CO", "K37W", "37W", "None", "35.22N", "078.43W", "60", "US"],
    ["NC FRYING PAN SHOA", "None", "None", "99404", "33.28N", "077.25W", "1", "US"],
    ["NC HOT SPRINGS", "KHSS", "HSS", "None", "35.54N", "082.49W", "451", "US"],
    ["NC REIDSVILLE", "K78N", "78N", "None", "36.26N", "079.51W", "211", "US"],
    ["NC ROCKINGHAM", "K45J", "45J", "None", "34.53N", "079.46W", "109", "US"],
    ["NC SILER CITY", "K5W8", "5W8", "None", "35.42N", "079.30W", "188", "US"],
    ["NC WALLACE", "KACZ", "ACZ", "None", "34.44N", "078.00W", "30", "US"],
    ["ND BEACH", "K20U", "20U", "None", "46.56N", "103.59W", "840", "US"],
    ["ND BISMARCK", "KBIS", "BIS", "72764", "46.46N", "100.45W", "505", "US"],
    ["ND BOWMAN MUNI", "KBPP", "BPP", "None", "46.11N", "103.26W", "902", "US"],
    ["ND CANDO", "K9D7", "9D7", "None", "48.29N", "099.14W", "452", "US"],
    ["ND CARRINGTON", "K46D", "46D", "None", "47.27N", "099.09W", "490", "US"],
    ["ND CAVALIER", "K2C8", "2C8", "None", "48.47N", "097.38W", "272", "US"],
    ["ND COOPERSTOWN", "KS32", "S32", "None", "47.25N", "098.06W", "684", "US"],
    ["ND CROSBY", "KD50", "D50", "None", "48.56N", "103.18W", "595", "US"],
    ["ND DEVILS LAKE", "KDVL", "DVL", "72757", "48.07N", "098.55W", "443", "US"],
    ["ND DEVILS LAKE", "KP11", "P11", "72758", "48.07N", "098.55W", "443", "US"],
    ["ND DICKINSON", "KDIK", "DIK", "None", "46.48N", "102.48W", "788", "US"],
    ["ND FARGO", "KFAR", "FAR", "72753", "46.56N", "096.49W", "277", "US"],
    ["ND FARGO/GRAND FORK", "KFGF", "FGF", "None", "46.54N", "096.48W", "274", "US"],
    ["ND GARRISON", "KN60", "N60", "None", "47.39N", "101.26W", "582", "US"],
    ["ND GLEN ULLIN", "KD57", "D57", "None", "46.49N", "101.52W", "637", "US"],
    ["ND GRAFTON", "KGAF", "GAF", "None", "48.24N", "097.22W", "252", "US"],
    ["ND GRAND FORKS AFB", "KRDR", "RDR", "None", "47.58N", "097.24W", "278", "US"],
    ["ND GRAND FORKS", "KGFK", "GFK", "None", "47.57N", "097.11W", "258", "US"],
    ["ND GWINNER", "KGWR", "GWR", "None", "46.13N", "097.39W", "386", "US"],
    ["ND HARVEY", "K5H4", "5H4", "None", "47.47N", "099.56W", "490", "US"],
    ["ND HAZEN", "KHZE", "HZE", "None", "47.17N", "101.35W", "553", "US"],
    ["ND HETTINGER", "KHEI", "HEI", "None", "46.01N", "102.39W", "828", "US"],
    ["ND JAMESTOWN", "KJMS", "JMS", "None", "46.56N", "098.40W", "455", "US"],
    ["ND LANGDON/ROBERTSN", "KD55", "D55", "None", "48.45N", "098.24W", "491", "US"],
    ["ND LIDGERWOOD (RAMO", "KP67", "P67", "None", "46.06N", "097.09W", "351", "US"],
    ["ND LINTON", "K7L2", "7L2", "None", "46.13N", "100.15W", "543", "US"],
    ["ND MANDAN", "KY19", "Y19", "None", "46.46N", "100.54W", "593", "US"],
    ["ND MAYVILLE/FARGO", "KMVX", "MVX", "None", "47.32N", "097.20W", "301", "US"],
    ["ND MCHENRY CY/MINOT", "KMBX", "MBX", "None", "48.24N", "100.52W", "455", "US"],
    ["ND MINOT AFB", "KMIB", "MIB", "None", "48.25N", "101.20W", "508", "US"],
    ["ND MINOT", "KMOT", "MOT", "None", "48.15N", "101.16W", "519", "US"],
    ["ND OAKES", "K2D5", "2D5", "None", "46.10N", "098.05W", "407", "US"],
    ["ND ROLLA", "K06D", "06D", "None", "48.53N", "099.37W", "556", "US"],
    ["ND RUGBY", "KRUG", "RUG", "None", "48.23N", "100.01W", "472", "US"],
    ["ND STANLEY", "K08D", "08D", "None", "48.18N", "102.24W", "684", "US"],
    ["ND TIOGA", "KD60", "D60", "None", "48.23N", "102.54W", "693", "US"],
    ["ND VALLEY CITY", "KBAC", "BAC", "None", "46.56N", "098.01W", "684", "US"],
    ["ND WALHALLA", "K96D", "96D", "None", "48.56N", "097.54W", "290", "US"],
    ["ND WATFORD CITY", "KS25", "S25", "None", "47.48N", "103.15W", "644", "US"],
    ["ND WILLISTON", "KISN", "ISN", "72767", "48.10N", "103.38W", "579", "US"],
    ["ND ROSEGLEN", "KP24", "P24", "72765", "47.45N", "101.50W", "624", "US"],
    ["ND WAHPETON", "KBWP", "BWP", "None", "46.15N", "096.37W", "295", "US"],
    ["NE AINSWORTH MUNICI", "KANW", "ANW", "None", "42.34N", "100.00W", "789", "US"],
    ["NE ALBION MUNI", "KBVN", "BVN", "None", "41.44N", "098.03W", "551", "US"],
    ["NE ALLIANCE", "KAIA", "AIA", "None", "42.03N", "102.48W", "1196", "US"],
    ["NE AURORA", "KAUH", "AUH", "None", "40.53N", "098.00W", "550", "US"],
    ["NE BEATRICE MUNICIP", "KBIE", "BIE", "None", "40.17N", "096.45W", "403", "US"],
    ["NE BLAIR MUNI", "KBTA", "BTA", "None", "41.25N", "096.07W", "396", "US"],
    ["NE BROKEN BOW MUNI", "KBBW", "BBW", "None", "41.26N", "099.38W", "776", "US"],
    ["NE CHADRON", "KCDR", "CDR", "None", "42.50N", "103.06W", "1010", "US"],
    ["NE COLUMBUS MUNI", "KOLU", "OLU", "None", "41.27N", "097.19W", "440", "US"],
    ["NE FAIRBURY PROFILE", "None", "FBY", "74440", "40.04N", "097.19W", "433", "US"],
    ["NE FALLS CITY/BRENN", "KFNB", "FNB", "None", "40.04N", "095.35W", "300", "US"],
    ["NE FREMONT MUNI ARP", "KFET", "FET", "None", "41.27N", "096.31W", "367", "US"],
    ["NE GORDON", "KGRN", "GRN", "None", "42.48N", "102.11W", "1086", "US"],
    ["NE GRAND ISLAND", "KGRI", "GRI", "72552", "40.58N", "098.19W", "561", "US"],
    ["NE GRAND ISLAND/WFO", "KGID", "GID", "None", "40.58N", "098.19W", "563", "US"],
    ["NE HASTINGS", "KHSI", "HSI", "None", "40.36N", "098.26W", "591", "US"],
    ["NE HEBRON MUNI", "KHJH", "HJH", "None", "40.09N", "097.35W", "447", "US"],
    ["NE HOLDREGE/BREWSTR", "KHDE", "HDE", "None", "40.27N", "099.19W", "705", "US"],
    ["NE IMPERIAL MUNICIP", "KIML", "IML", "None", "40.31N", "101.37W", "998", "US"],
    ["NE KEARNEY MUNI", "KEAR", "EAR", "None", "40.43N", "099.00W", "649", "US"],
    ["NE KIMBALL MUNI", "KIBM", "IBM", "None", "41.11N", "103.41W", "1501", "US"],
    ["NE LEXINGTON", "KLXN", "LXN", "None", "40.47N", "099.46W", "734", "US"],
    ["NE LINCOLN", "KLNK", "LNK", "72551", "40.51N", "096.46W", "364", "US"],
    ["NE MCCOOK", "KMCK", "MCK", "None", "40.12N", "100.35W", "782", "US"],
    ["NE MCCOOK PROFILER", "None", "RWD", "74433", "40.04N", "100.39W", "800", "US"],
    ["NE MERRIMAN PROFILE", "None", "MRR", "74437", "42.53N", "101.41W", "991", "US"],
    ["NE NEBRASKA CITY", "KAFK", "AFK", "None", "40.36N", "095.51W", "354", "US"],
    ["NE NELIGH PROFILER", "None", "NLG", "74445", "42.12N", "097.47W", "524", "US"],
    ["NE NORFOLK", "KOFK", "OFK", "72556", "41.59N", "097.26W", "470", "US"],
    ["NE NORTH OMAHA", "KOVN", "OVN", "72553", "41.22N", "096.01W", "406", "US"],
    ["NE NORTH PLATTE", "KLBF", "LBF", "72562", "41.07N", "100.40W", "847", "US"],
    ["NE O'NEILL", "KONL", "ONL", "None", "42.28N", "098.40W", "619", "US"],
    ["NE OFFUTT/AFWA", "KGWC", "GWC", "None", "41.07N", "095.55W", "319", "US"],
    ["NE OFFUTT AFB/BELLE", "KOFF", "OFF", "72554", "41.07N", "095.55W", "319", "US"],
    ["NE OGALLALA", "KOGA", "OGA", "None", "41.07N", "101.46W", "999", "US"],
    ["NE OMAHA/EPPLEY", "KOMA", "OMA", "72550", "41.19N", "095.54W", "312", "US"],
    ["NE OMAHA/VALLEY/88D", "KOAX", "None", "72558", "41.19N", "096.22W", "350", "US"],
    ["NE OMAHA VOR", "KOVR", "OVR", "None", "41.10N", "095.44W", "312", "US"],
    ["NE OMAHA/MILLARD", "KMLE", "MLE", "None", "41.12N", "096.07W", "320", "US"],
    ["NE ORD/SHARP FIELD", "KODX", "ODX", "None", "41.37N", "098.57W", "631", "US"],
    ["NE PAWNEE CITY", "KPWE", "PWE", "None", "40.12N", "096.12W", "415", "US"],
    ["NE PLATTSMOUTH MUNI", "KPMV", "PMV", "None", "40.57N", "095.55W", "367", "US"],
    ["NE SCOTTSBLUFF", "KBFF", "BFF", "72566", "41.52N", "103.35W", "1203", "US"],
    ["NE SIDNEY", "KSNY", "SNY", "72561", "41.06N", "102.59W", "1307", "US"],
    ["NE TEKAMAH", "KTQE", "TQE", "None", "41.46N", "096.11W", "312", "US"],
    ["NE THEDFORD/LBF/88D", "KLNX", "LNX", "None", "41.57N", "100.35W", "905", "US"],
    ["NE THEDFORD/THOMAS", "KTIF", "TIF", "None", "41.58N", "100.34W", "892", "US"],
    ["NE VALENTINE", "KVTN", "VTN", "72567", "42.52N", "100.33W", "788", "US"],
    ["NE WAHOO", "KAHQ", "AHQ", "None", "41.14N", "096.36W", "374", "US"],
    ["NE WAYNE MUNI", "KLCG", "LCG", "None", "42.15N", "096.59W", "436", "US"],
    ["NE WEBSTER CNTY/88D", "KUEX", "UEX", "None", "40.19N", "098.27W", "602", "US"],
    ["NE WOLBACH (VOR)", "KOBH", "OBH", "None", "41.23N", "098.21W", "670", "US"],
    ["NE YORK", "KJYR", "JYR", "None", "40.54N", "097.37W", "509", "US"],
    ["NE BENKELMAN-JONES", "K42V", "42V", "None", "40.03N", "101.32W", "953", "US"],
    ["NE BLAIR MUNI", "KK46", "K46", "None", "41.25N", "096.07W", "396", "US"],
    ["NE BURWELL", "KBUB", "BUB", "72555", "41.47N", "099.09W", "664", "US"],
    ["NE COZAD", "KCZD", "CZD", "None", "40.52N", "100.00W", "800", "US"],
    ["NE MULLEN", "KMHN", "MHN", "None", "42.03N", "101.04W", "994", "US"],
    ["NE SIDNEY", "None", "None", "72563", "41.06N", "102.59W", "1307", "US"],
    ["NE CHAMPION", "KCHM", "CHM", "None", "40.23N", "101.43W", "1029", "US"],
    ["NH BERLIN", "KBML", "BML", "72616", "44.35N", "071.11W", "345", "US"],
    ["NH CONCORD", "KCON", "CON", "72605", "43.12N", "071.30W", "103", "US"],
    ["NH JAFFREY", "KAFN", "AFN", "None", "42.48N", "072.00W", "313", "US"],
    ["NH KEENE/DILLANT", "KEEN", "EEN", "None", "42.53N", "072.16W", "149", "US"],
    ["NH LACONIA MUNI", "KLCI", "LCI", "None", "43.34N", "071.25W", "166", "US"],
    ["NH LEBANON", "KLEB", "LEB", "72611", "43.38N", "072.18W", "171", "US"],
    ["NH MANCHESTER", "KMHT", "MHT", "None", "42.56N", "071.26W", "81", "US"],
    ["NH MOUNT WASHINGTON", "KMWN", "MWN", "72613", "44.16N", "071.18W", "1910", "US"],
    ["NH NASHUA/BOIRE FLD", "KASH", "ASH", "None", "42.47N", "071.31W", "61", "US"],
    ["NH NASHUA/ARTCC-BOS", "KZBW", "ZBW", "None", "42.44N", "071.29W", "61", "US"],
    ["NH PLYMOUTH", "K1P1", "1P1", "None", "43.47N", "071.45W", "154", "US"],
    ["NH PORTSMOUTH/PEASE", "KPSM", "PSM", "None", "43.04N", "070.49W", "31", "US"],
    ["NH ROCHESTER", "KDAW", "DAW", "None", "43.17N", "070.55W", "100", "US"],
    ["NH WHITEFIELD", "KHIE", "HIE", "None", "44.22N", "071.33W", "318", "US"],
    ["NH DIAMOND LAKE", "K8B2", "8B2", "None", "44.57N", "071.19W", "678", "US"],
    ["NH ISLE OF SHOALS", "None", "None", "99427", "42.58N", "070.22W", "13", "US"],
    ["NH NORTH GROTON", "KNGR", "NGR", "None", "43.46N", "071.52W", "390", "US"],
    ["NH ROCHESTER", "K6B1", "6B1", "None", "43.17N", "070.55W", "100", "US"],
    ["NH TAMWORTH", "KTMW", "TMW", "None", "43.54N", "071.18W", "241", "US"],
    ["NJ ALEXANDRIA", "KN85", "N85", "None", "40.35N", "075.01W", "146", "US"],
    ["NJ ANDOVER", "K12N", "12N", "None", "41.01N", "074.44W", "177", "US"],
    ["NJ ATLANTIC CITY", "KACY", "ACY", "72407", "39.27N", "074.34W", "23", "US"],
    ["NJ BELMAR/FARMDALE", "KBLM", "BLM", "None", "40.10N", "074.07W", "48", "US"],
    ["NJ BLAIRSTOWN", "K1N7", "1N7", "None", "40.58N", "075.00W", "113", "US"],
    ["NJ CALDWELL", "KCDW", "CDW", "None", "40.53N", "074.17W", "64", "US"],
    ["NJ COYLE VOR", "KCYN", "CYN", "None", "39.49N", "074.26W", "70", "US"],
    ["NJ CROSS KEYS", "K17N", "17N", "None", "39.42N", "075.02W", "49", "US"],
    ["NJ HAMMONTON", "KN81", "N81", "None", "39.40N", "074.45W", "20", "US"],
    ["NJ LAKEHURST NAS", "KNEL", "NEL", "72409", "40.01N", "074.20W", "31", "US"],
    ["NJ LAKEWOOD", "KN12", "N12", "None", "40.04N", "074.11W", "13", "US"],
    ["NJ LINCOLN PARK", "KN07", "N07", "None", "40.57N", "074.19W", "56", "US"],
    ["NJ LINDEN", "KLDJ", "LDJ", "None", "40.37N", "074.15W", "7", "US"],
    ["NJ LUMBERTON", "KN14", "N14", "None", "39.56N", "074.48W", "15", "US"],
    ["NJ MANCHESTER 88D", "KDIX", "DIX", "None", "39.57N", "074.25W", "45", "US"],
    ["NJ MANVILLE", "K47N", "47N", "None", "40.31N", "074.36W", "26", "US"],
    ["NJ MILLVILLE", "KMIV", "MIV", "None", "39.22N", "075.05W", "23", "US"],
    ["NJ MORRISTOWN MUNI", "KMMU", "MMU", "None", "40.47N", "074.25W", "57", "US"],
    ["NJ MOUNT HOLLY", "KVAY", "VAY", "None", "39.56N", "074.50W", "15", "US"],
    ["NJ MT HOLLY/PHL/WFO", "KPHI", "PHI", "None", "40.01N", "074.49W", "4", "US"],
    ["NJ NEWARK", "KEWR", "EWR", "72502", "40.41N", "074.10W", "7", "US"],
    ["NJ OCEAN CITY", "K26N", "26N", "None", "39.16N", "074.36W", "2", "US"],
    ["NJ OLD BRIDGE", "K3N6", "3N6", "None", "40.20N", "074.21W", "27", "US"],
    ["NJ PITTSTOWN", "KN40", "N40", "None", "40.34N", "074.59W", "171", "US"],
    ["NJ PRINCETON", "K39N", "39N", "None", "40.24N", "074.40W", "39", "US"],
    ["NJ ROBBINSVILLE", "KN87", "N87", "None", "40.13N", "074.36W", "36", "US"],
    ["NJ SEA ISLE VOR", "KSIE", "SIE", "None", "39.06N", "074.48W", "30", "US"],
    ["NJ SOMERVILLE", "KSMQ", "SMQ", "None", "40.37N", "074.40W", "30", "US"],
    ["NJ SPARTA VOR", "KSAX", "SAX", "None", "41.04N", "074.32W", "30", "US"],
    ["NJ SUSSEX", "KFWN", "FWN", "None", "41.12N", "074.38W", "133", "US"],
    ["NJ TETERBORO", "KTEB", "TEB", "None", "40.52N", "074.03W", "7", "US"],
    ["NJ TOMS RIVER", "KMJX", "MJX", "None", "39.56N", "074.18W", "25", "US"],
    ["NJ TRENTON", "KTTN", "TTN", "None", "40.17N", "074.49W", "59", "US"],
    ["NJ WEST MILFORD", "K4N1", "4N1", "None", "41.08N", "074.21W", "241", "US"],
    ["NJ WILDWOOD", "KWWD", "WWD", "None", "39.01N", "074.55W", "7", "US"],
    ["NJ WOODBINE MUNI", "KOBI", "OBI", "None", "39.13N", "074.48W", "13", "US"],
    ["NJ WRIGHTST/MCGUIRE", "KWRI", "WRI", "None", "40.01N", "074.35W", "41", "US"],
    ["NJ NEW BRUNSWICK", "KNBK", "NBK", "None", "40.29N", "074.26W", "5", "US"],
    ["NJ SANDY HOOK CGS", "K56N", "56N", "None", "40.28N", "074.01W", "5", "US"],
    ["NJ SOMERVILLE", "KN52", "N52", "None", "40.37N", "074.40W", "30", "US"],
    ["NJ SUSSEX", "KN63", "N63", "None", "41.12N", "074.36W", "119", "US"],
    ["NJ SOMERVILLE", "KSJB", "SJB", "None", "40.37N", "074.40W", "30", "US"],
    ["NM GALLUP", "KGUP", "GUP", "None", "35.31N", "108.48W", "1971", "US"],
    ["NM ALAMOGORDO WHITE", "KALM", "ALM", "72269", "32.49N", "105.58W", "1279", "US"],
    ["NM ALBUQUERQUE", "KABQ", "ABQ", "72365", "35.03N", "106.37W", "1618", "US"],
    ["NM ALBUQUERQUE/88D", "KABX", "ABX", "None", "35.09N", "106.49W", "1789", "US"],
    ["NM KIRTLAND AFB-ABQ", "KIKR", "IKR", "None", "35.03N", "106.36W", "1613", "US"],
    ["NM ALBUQUERQU/ARTCC", "KZAB", "ZAB", "None", "35.10N", "106.34W", "1621", "US"],
    ["NM ANGEL FIRE", "KAXX", "AXX", "None", "36.25N", "105.17W", "2548", "US"],
    ["NM ARTESIA", "KATS", "ATS", "None", "32.51N", "104.28W", "1081", "US"],
    ["NM AZTEC PROFILER", "None", "AZC", "74630", "36.49N", "107.54W", "1902", "US"],
    ["NM BELEN", "KE80", "E80", "None", "34.39N", "106.50W", "1582", "US"],
    ["NM CANNON AFB/CLOVI", "KCVS", "CVS", "None", "34.22N", "103.19W", "1309", "US"],
    ["NM CANNON AFB/88D", "KFDX", "FDX", "None", "34.38N", "103.37W", "1417", "US"],
    ["NM CARLSBAD", "KCNM", "CNM", "None", "32.20N", "104.15W", "985", "US"],
    ["NM CHAMA (AWRS)", "KE33", "E33", "None", "36.53N", "106.34W", "2393", "US"],
    ["NM CHISUM/ROSWELL", "KCME", "CME", "None", "33.20N", "104.37W", "1150", "US"],
    ["NM CIMARRON (VOR)", "KCIM", "CIM", "None", "36.29N", "104.52W", "2183", "US"],
    ["NM CLAYTON", "KCAO", "CAO", "72360", "36.27N", "103.09W", "1514", "US"],
    ["NM CLINES CORNERS", "KCQC", "CQC", "None", "35.00N", "105.40W", "2160", "US"],
    ["NM CLOVIS MUNI", "KCVN", "CVN", "None", "34.25N", "103.04W", "1284", "US"],
    ["NM CORONA/LINCOLN", "K4CR", "4CR", "None", "34.06N", "105.40W", "1981", "US"],
    ["NM DEMING", "KDMN", "DMN", "None", "32.16N", "107.43W", "1311", "US"],
    ["NM DOUBLE EAGLE II", "KAEG", "AEG", "None", "35.08N", "106.48W", "1779", "US"],
    ["NM FARMINGTON", "KFMN", "FMN", "None", "36.45N", "108.14W", "1685", "US"],
    ["NM RATTLESNAKE-FMN", "KRSK", "RSK", "None", "36.45N", "108.06W", "1775", "US"],
    ["NM GRANTS", "KGNT", "GNT", "None", "35.10N", "107.54W", "1987", "US"],
    ["NM HOBBS/LEA CO.", "KHOB", "HOB", "None", "32.40N", "103.13W", "1115", "US"],
    ["NM HOLLOMAN AFB", "KHMN", "HMN", "74732", "32.51N", "106.05W", "1248", "US"],
    ["NM LAS CRUCES INTL", "KLRU", "LRU", "None", "32.16N", "106.55W", "1358", "US"],
    ["NM LAS VEGAS", "KLVS", "LVS", "None", "35.39N", "105.08W", "2091", "US"],
    ["NM LORDSBURG", "KLSB", "LSB", "None", "32.20N", "108.42W", "1307", "US"],
    ["NM FT UNION/VEGAS", "KFTI", "FTI", "None", "35.39N", "105.08W", "2094", "US"],
    ["NM LOS ALAMOS", "KLAM", "LAM", "None", "35.52N", "106.16W", "2179", "US"],
    ["NM MCGREGOR RANGE", "KM63", "M63", "None", "32.03N", "106.09W", "1283", "US"],
    ["NM MELROSE G RANGE", "K4MR", "4MR", "74638", "34.18N", "103.48W", "1326", "US"],
    ["NM MORIARTY", "K4MY", "4MY", "None", "34.59N", "106.00W", "1890", "US"],
    ["NM MORIARTY", "K0E0", "0E0", "None", "34.59N", "106.00W", "1890", "US"],
    ["NM RATON", "KRTN", "RTN", "None", "36.44N", "104.30W", "1936", "US"],
    ["NM ROSWELL", "KROW", "ROW", "72268", "33.18N", "104.30W", "1112", "US"],
    ["NM SIERRA B/RUIDOSO", "KSRR", "SRR", "None", "33.28N", "105.31W", "2076", "US"],
    ["NM SANTA FE", "KSAF", "SAF", "None", "35.37N", "106.06W", "1930", "US"],
    ["NM SANTA ROSA US66", "KSXU", "SXU", "None", "34.56N", "104.39W", "1460", "US"],
    ["NM SANTA TERESA/88D", "KEPZ", "EPZ", "72364", "31.52N", "106.42W", "1251", "US"],
    ["NM SANTA TERESA", "KDNA", "DNA", "None", "31.53N", "106.42W", "1254", "US"],
    ["NM SILVER CITY", "KSVC", "SVC", "72272", "32.38N", "108.09W", "1659", "US"],
    ["NM SOCORRO", "KONM", "ONM", "72362", "34.01N", "106.54W", "1410", "US"],
    ["NM TAOS MUNI APT", "KSKX", "SKX", "None", "36.27N", "105.40W", "2161", "US"],
    ["NM TORREON/CUBA", "K4SL", "4SL", "None", "35.47N", "107.10W", "2106", "US"],
    ["NM TRUTH OR CONSEQ.", "KTCS", "TCS", "72271", "33.14N", "107.16W", "1469", "US"],
    ["NM TUCUMCARI PROFIL", "None", "TCU", "74731", "35.04N", "103.35W", "1241", "US"],
    ["NM TUCUMCARI", "KTCC", "TCC", "None", "35.11N", "103.36W", "1235", "US"],
    ["NM W SANDS/HOLLOMAN", "KHDX", "HDX", "None", "33.05N", "106.07W", "1287", "US"],
    ["NM WHITE SANDS PROF", "None", "WSM", "74629", "32.23N", "106.20W", "1224", "US"],
    ["NM WHITE SANDS TEST", "K2C2", "2C2", "74734", "32.22N", "106.28W", "1244", "US"],
    ["NM CLINES CORNERS", "KP70", "P70", "None", "34.55N", "105.34W", "2109", "US"],
    ["NM WHITE SANDS", "KE28", "E28", "74733", "32.56N", "106.25W", "1192", "US"],
    ["NM TAOS(AWRS)", "KE23", "E23", "None", "36.25N", "105.34W", "2123", "US"],
    ["NM ZUNI PUEBLO", "KZUN", "ZUN", "None", "35.05N", "108.47W", "1972", "US"],
    ["NM SANTA TERESA", "K5T6", "5T6", "None", "31.53N", "106.42W", "1253", "US"],
    ["NM MCGREGOR RANGE", "KQMG", "None", "None", "32.03N", "106.09W", "1283", "US"],
    ["NM TATUM NM 2SW", "XTAT", "None", "None", "33.14N", "103.21W", "1225", "US"],
    ["NM DORA 2SW", "XDR1", "None", "None", "33.55N", "103.21W", "1317", "US"],
    ["NM HOBBS 5NW", "XHO1", "None", "None", "32.46N", "103.11W", "1125", "US"],
    ["NM ENDEE 2SW", "XEN1", "None", "None", "35.06N", "103.07W", "1204", "US"],
    ["NV AUSTIN", "KU31", "U31", "None", "39.30N", "117.04W", "2014", "US"],
    ["NV BATTLE MOUNTAIN", "KB23", "B23", "None", "40.36N", "116.52W", "1381", "US"],
    ["NV BATTLE MTN (VOR)", "KBAM", "BAM", "None", "40.34N", "116.55W", "1381", "US"],
    ["NV BEATTY", "KBTY", "BTY", "None", "36.48N", "116.44W", "892", "US"],
    ["NV BOULDER CITY", "KBVU", "BVU", "None", "35.57N", "114.52W", "671", "US"],
    ["NV CARSON CITY", "KCXP", "CXP", "None", "39.11N", "119.44W", "1435", "US"],
    ["NV COALDALE (VOR)", "KOAL", "OAL", "None", "38.00N", "117.46W", "1600", "US"],
    ["NV DESERT R/MERCURY", "KDRA", "DRA", "72387", "36.37N", "116.02W", "1006", "US"],
    ["NV ELKO", "KEKO", "EKO", "None", "40.49N", "115.47W", "1547", "US"],
    ["NV ELKO/WFO", "KLKN", "LKN", "72582", "40.52N", "115.43W", "1608", "US"],
    ["NV ELKO/LANDER 88D", "KLRX", "LRX", "None", "40.44N", "116.48W", "2056", "US"],
    ["NV ELY", "KELY", "ELY", "72486", "39.18N", "114.51W", "1906", "US"],
    ["NV EUREKA", "K05U", "05U", "None", "39.36N", "116.00W", "1816", "US"],
    ["NV EUREKA", "KP68", "P68", "None", "39.36N", "116.00W", "1809", "US"],
    ["NV FALLON NAS", "KNFL", "NFL", "None", "39.25N", "118.42W", "1199", "US"],
    ["NV HAWTHORNE", "KHTH", "HTH", "None", "38.33N", "118.38W", "1285", "US"],
    ["NV INDIAN SPRINGS", "KINS", "INS", "None", "36.35N", "115.40W", "955", "US"],
    ["NV IND SPRNG RANGE", "KL63", "L63", "69017", "36.31N", "115.34W", "972", "US"],
    ["NV LAS VEGAS", "KLAS", "LAS", "72386", "36.04N", "115.10W", "636", "US"],
    ["NV LAS VEGAS/NELLIS", "KLSV", "LSV", "None", "36.13N", "115.01W", "570", "US"],
    ["NV LAS VEGAS/NELSON", "KESX", "ESX", "None", "35.42N", "114.53W", "1483", "US"],
    ["NV VEGAS/HENDERSON", "KHND", "HND", "None", "35.59N", "115.08W", "749", "US"],
    ["NV LAS VEGAS/WFO", "KVEF", "VEF", "72388", "36.03N", "115.11W", "694", "US"],
    ["NV LOVELOCK", "KLOL", "LOL", "72580", "40.04N", "118.34W", "1189", "US"],
    ["NV MINDEN", "KMEV", "MEV", "None", "39.00N", "119.45W", "1442", "US"],
    ["NV NORTH LAS VEGAS", "KVGT", "VGT", "None", "36.13N", "115.12W", "671", "US"],
    ["NV RENO", "KRNO", "RNO", "72488", "39.30N", "119.46W", "1342", "US"],
    ["NV RENO/WFO", "KREV", "REV", "72489", "39.34N", "119.48W", "1516", "US"],
    ["NV RENO/STEAD", "KRTS", "RTS", "None", "39.40N", "119.53W", "1540", "US"],
    ["NV RENO/WASHOE CTY", "KRGX", "RGX", "None", "39.45N", "119.28W", "2530", "US"],
    ["NV RENO(VOR)", "KFMG", "FMG", "None", "39.32N", "119.39W", "1342", "US"],
    ["NV TONOPAH", "KTPH", "TPH", "72485", "38.03N", "117.05W", "1652", "US"],
    ["NV TONOPAH RANGE74", "KBJN", "BJN", "72282", "37.37N", "116.16W", "1756", "US"],
    ["NV WELLS", "K9BB", "9BB", "None", "41.06N", "114.58W", "1723", "US"],
    ["NV WILDHORSE RES/EL", "KAWH", "AWH", "None", "41.40N", "115.46W", "1902", "US"],
    ["NV WILSON CREEK", "KILC", "ILC", "None", "38.15N", "114.23W", "2840", "US"],
    ["NV WINNEMUCCA", "KWMC", "WMC", "72583", "40.54N", "117.48W", "1310", "US"],
    ["NV YUCCA FLATS", "KYUC", "YUC", "None", "36.57N", "116.02W", "1198", "US"],
    ["NV YUCCA FLAT", "KUCC", "UCC", "72385", "36.57N", "116.03W", "1195", "US"],
    ["NV CALIENTE", "KP38", "P38", "72487", "37.37N", "114.32W", "1333", "US"],
    ["NV INDIAN SPRINGS", "KL76", "L76", "69018", "36.32N", "115.34W", "1153", "US"],
    ["NV JACKPOT", "K06U", "06U", "None", "41.59N", "114.39W", "1589", "US"],
    ["NV OWYHEE", "KOWY", "OWY", "72587", "41.57N", "116.06W", "1645", "US"],
    ["NV TONOPAH MILITARY", "KTNX", "TNX", "None", "37.47N", "116.46W", "1691", "US"],
    ["NY ALBANY", "KALB", "ALB", "72518", "42.45N", "073.48W", "92", "US"],
    ["NY ALBANY/E. BERNE", "KENX", "ENX", "None", "42.35N", "074.04W", "557", "US"],
    ["NY ALBANY/WFO", "KALY", "ALY", "None", "42.45N", "073.48W", "88", "US"],
    ["NY BINGHAMTON", "KBGM", "BGM", "72515", "42.13N", "075.59W", "490", "US"],
    ["NY BROOKHAVEN/UPTON", "KOKX", "OKX", "72501", "40.52N", "072.52W", "26", "US"],
    ["NY BROOKHAVEN/KBNL", "None", "None", "74498", "40.48N", "073.18W", "20", "US"],
    ["NY BUFFALO/CHEEKTOW", "KBUF", "BUF", "72528", "42.56N", "078.44W", "211", "US"],
    ["NY CANANDAIGUA", "KD38", "D38", "None", "42.54N", "077.19W", "248", "US"],
    ["NY CORTLAND", "KN03", "N03", "None", "42.36N", "076.13W", "366", "US"],
    ["NY DANSVILLE", "KDSV", "DSV", "72523", "42.34N", "077.43W", "198", "US"],
    ["NY DUNKIRK", "KDKK", "DKK", "99425", "42.30N", "079.17W", "202", "US"],
    ["NY EAST HAMPTON", "KHTO", "HTO", "None", "40.57N", "072.15W", "17", "US"],
    ["NY ELMIRA", "KELM", "ELM", "None", "42.09N", "076.54W", "302", "US"],
    ["NY ENDICOTT/TRI-CIT", "KCZG", "CZG", "None", "42.05N", "076.06W", "254", "US"],
    ["NY FARMINGDALE", "KFRG", "FRG", "None", "40.44N", "073.25W", "21", "US"],
    ["NY FORT DRUM/88D", "KTYX", "TYX", "None", "43.45N", "075.41W", "562", "US"],
    ["NY FORT DRUM/WHEELE", "KGTB", "GTB", "74370", "44.04N", "075.43W", "207", "US"],
    ["NY FULTON", "KFZY", "FZY", "None", "43.21N", "076.23W", "138", "US"],
    ["NY GLENS FALLS", "KGFL", "GFL", "None", "43.20N", "073.37W", "103", "US"],
    ["NY HAMILTON MUNICIP", "KVGC", "VGC", "None", "42.51N", "075.34W", "347", "US"],
    ["NY HANCOCK VOR", "KHNK", "HNK", "None", "42.04N", "075.19W", "690", "US"],
    ["NY HORNELL", "K4G6", "4G6", "None", "42.23N", "077.41W", "372", "US"],
    ["NY HUDSON/COLUMBIA", "K1B1", "1B1", "None", "42.17N", "073.43W", "60", "US"],
    ["NY ISLIP", "KISP", "ISP", "None", "40.48N", "073.06W", "43", "US"],
    ["NY ITHACA/TOMPKINS", "KITH", "ITH", "None", "42.28N", "076.27W", "335", "US"],
    ["NY JAMESTOWN", "KJHW", "JHW", "None", "42.08N", "079.16W", "525", "US"],
    ["NY JOHNSTOWN", "KNY0", "NY0", "None", "43.00N", "074.19W", "269", "US"],
    ["NY MANHATTAN/DWNTWN", "KJRB", "JRB", "None", "40.42N", "074.01W", "7", "US"],
    ["NY MASSENA", "KMSS", "MSS", "None", "44.56N", "074.51W", "66", "US"],
    ["NY MONTAUK", "KMTP", "MTP", "None", "41.04N", "071.55W", "2", "US"],
    ["NY MONTGOMERY", "KMGJ", "MGJ", "None", "41.31N", "074.16W", "108", "US"],
    ["NY MONTICELLO", "KMSV", "MSV", "None", "41.42N", "074.47W", "428", "US"],
    ["NY NEWBURGH/STEWART", "KSWF", "SWF", "None", "41.30N", "074.05W", "150", "US"],
    ["NY NIAGARA FALLS", "KIAG", "IAG", "None", "43.07N", "078.56W", "182", "US"],
    ["NY NORWICH", "KOIC", "OIC", "None", "42.34N", "075.31W", "312", "US"],
    ["NY NYC/JFK ARPT", "KJFK", "JFK", "74486", "40.38N", "073.46W", "9", "US"],
    ["NY NYC/LA GUARDIA", "KLGA", "LGA", "72503", "40.47N", "073.53W", "11", "US"],
    ["NY NYC/CENTRAL PARK", "KNYC", "NYC", "None", "40.47N", "073.58W", "11", "US"],
    ["NY NEW YORK/ARTCC", "KZNY", "ZNY", "None", "40.48N", "073.06W", "48", "US"],
    ["NY OGDENSBURG INTL", "KOGS", "OGS", "None", "44.40N", "075.28W", "91", "US"],
    ["NY OLEAN", "KOLE", "OLE", "None", "42.14N", "078.22W", "651", "US"],
    ["NY PENN YAN", "KPEO", "PEO", "None", "42.39N", "077.03W", "256", "US"],
    ["NY PLATTSBURGH", "KPLB", "PLB", "None", "44.41N", "073.32W", "106", "US"],
    ["NY PLATTSBURGH AFB", "KPBG", "PBG", "None", "44.39N", "073.28W", "72", "US"],
    ["NY POTSDAM", "KPTD", "PTD", "None", "44.41N", "074.57W", "144", "US"],
    ["NY POUGHKEEPSIE", "KPOU", "POU", "None", "41.38N", "073.53W", "46", "US"],
    ["NY ROCHESTER", "KROC", "ROC", "72529", "43.07N", "077.41W", "178", "US"],
    ["NY ROME/GRIFFISS AF", "KRME", "RME", "None", "43.13N", "075.24W", "154", "US"],
    ["NY SARANAC LAKE", "KSLK", "SLK", "None", "44.24N", "074.12W", "498", "US"],
    ["NY SARATOGA SPRINGS", "K5B2", "5B2", "None", "43.03N", "073.52W", "132", "US"],
    ["NY SCHENECTADY AIRP", "KSCH", "SCH", "None", "42.51N", "073.55W", "115", "US"],
    ["NY SHIRLEY", "KHWV", "HWV", "None", "40.49N", "072.52W", "21", "US"],
    ["NY SIDNEY", "KN23", "N23", "None", "42.18N", "075.25W", "313", "US"],
    ["NY SKANEATELES", "K6B9", "6B9", "None", "42.55N", "076.26W", "317", "US"],
    ["NY SYRACUSE", "KSYR", "SYR", "72519", "43.07N", "076.06W", "127", "US"],
    ["NY SYRACUSE", "None", "None", "74379", "43.07N", "076.05W", "122", "US"],
    ["NY UTICA", "KUCA", "UCA", "None", "43.09N", "075.23W", "228", "US"],
    ["NY WATERTOWN", "KART", "ART", "None", "43.59N", "076.02W", "100", "US"],
    ["NY WELLSVILLE", "KELZ", "ELZ", "None", "42.06N", "077.59W", "646", "US"],
    ["NY WESTHAMPTON BEAC", "KFOK", "FOK", "None", "40.51N", "072.37W", "33", "US"],
    ["NY WHITE PLAINS", "KHPN", "HPN", "None", "41.04N", "073.42W", "121", "US"],
    ["NY WILLIAMSON/SODUS", "KSDC", "SDC", "None", "43.14N", "077.07W", "129", "US"],
    ["NY AMBROSE", "KN28", "N28", "74499", "40.27N", "073.11W", "26", "US"],
    ["NY AMBROSE (LGT-SH", "None", "None", "99410", "40.28N", "073.10W", "1", "US"],
    ["NY BOONVILLE", "K1B8", "1B8", "None", "43.27N", "075.21W", "482", "US"],
    ["NY COLDEN", "KCOL", "COL", "None", "42.40N", "078.41W", "312", "US"],
    ["NY COOPERSTOWN", "KCOO", "COO", "None", "42.42N", "074.55W", "378", "US"],
    ["NY ELLENBURG DEPOT", "KELB", "ELB", "None", "44.54N", "073.48W", "262", "US"],
    ["NY GALLOO ISLAND", "None", "None", "99432", "43.52N", "076.34W", "76", "US"],
    ["NY MALONE", "KMAL", "MAL", "None", "44.51N", "074.18W", "268", "US"],
    ["NY ONEONTA", "KOZX", "OZX", "None", "42.23N", "075.09W", "351", "US"],
    ["NY FULTON/OSWEGO CT", "KN00", "N00", "None", "43.21N", "076.23W", "145", "US"],
    ["NY PISECO LAKE", "KPIC", "PIC", "None", "43.27N", "074.32W", "527", "US"],
    ["NY SLIDE MOUNTAIN", "KSLD", "SLD", "None", "41.58N", "074.21W", "610", "US"],
    ["NY STORMVILLE", "KSTM", "STM", "None", "41.32N", "073.44W", "279", "US"],
    ["NY WARSAW", "KWRS", "WRS", "None", "42.41N", "078.12W", "555", "US"],
    ["NY GRIFFISS AFB/88D", "KRMX", "RMX", "None", "43.28N", "075.27W", "154", "US"],
    ["OH AKRON (FULTON)", "KAKR", "AKR", "None", "41.02N", "081.28W", "363", "US"],
    ["OH AKRON", "KCAK", "CAK", "72521", "40.55N", "081.27W", "377", "US"],
    ["OH APPLETON", "KAPE", "APE", "None", "40.09N", "082.35W", "453", "US"],
    ["OH ASHTABULA", "KHZY", "HZY", "None", "41.47N", "080.42W", "276", "US"],
    ["OH ATHENS", "KUNI", "UNI", "None", "39.13N", "082.14W", "193", "US"],
    ["OH BATAVIA", "KI69", "I69", "None", "39.05N", "084.13W", "255", "US"],
    ["OH BELLAIRE VOR", "KAIR", "AIR", "None", "40.01N", "080.49W", "430", "US"],
    ["OH BELLEFONTAINE", "KEDJ", "EDJ", "None", "40.22N", "083.49W", "342", "US"],
    ["OH CAMBRIDGE", "KCDI", "CDI", "None", "39.59N", "081.35W", "244", "US"],
    ["OH CHILLICOTHE", "KRZT", "RZT", "None", "39.26N", "083.01W", "193", "US"],
    ["OH CINCINNAT/LUNKEN", "KLUK", "LUK", "None", "39.06N", "084.25W", "155", "US"],
    ["OH CLEVELAND", "KBKL", "BKL", "None", "41.32N", "081.40W", "184", "US"],
    ["OH CLEVELAND", "KCLE", "CLE", "72524", "41.25N", "081.51W", "233", "US"],
    ["OH CLEVLND/CUYAHOGA", "KCGF", "CGF", "None", "41.34N", "081.28W", "268", "US"],
    ["OH CLEVELAND/ARTCC", "KZOB", "ZOB", "None", "41.18N", "082.12W", "241", "US"],
    ["OH COLUMBUS", "KCMH", "CMH", "72428", "40.00N", "082.53W", "247", "US"],
    ["OH COLUMBUS/ST UNIV", "KOSU", "OSU", "None", "40.05N", "083.05W", "280", "US"],
    ["OH COLUMBUS/BOLTON", "KTZR", "TZR", "None", "39.54N", "083.08W", "276", "US"],
    ["OH DAYTON", "KDAY", "DAY", "72429", "39.54N", "084.13W", "305", "US"],
    ["OH DAYTON", "KMGY", "MGY", "None", "39.36N", "084.14W", "289", "US"],
    ["OH DAYTON-JACKSON", "KI19", "I19", "None", "39.41N", "084.00W", "290", "US"],
    ["OH DEFIANCE", "KDFI", "DFI", "None", "41.20N", "084.26W", "219", "US"],
    ["OH DELAWARE", "KDLZ", "DLZ", "None", "40.17N", "083.07W", "289", "US"],
    ["OH FINDLAY", "KFDY", "FDY", "None", "41.01N", "083.40W", "247", "US"],
    ["OH FLAG CITY", "KFBC", "FBC", "None", "41.01N", "083.40W", "247", "US"],
    ["OH HAMILTON", "KHAO", "HAO", "None", "39.22N", "084.31W", "188", "US"],
    ["OH HARRISON", "KI67", "I67", "None", "39.16N", "084.46W", "178", "US"],
    ["OH LANCASTER", "KLHQ", "LHQ", "None", "39.45N", "082.40W", "260", "US"],
    ["OH LEBANON", "KI68", "I68", "None", "39.28N", "084.15W", "274", "US"],
    ["OH LIMA", "KAOH", "AOH", "None", "40.42N", "084.01W", "296", "US"],
    ["OH LONDON", "KUYF", "UYF", "None", "39.56N", "083.28W", "330", "US"],
    ["OH LORAIN/ELYRIA", "KLPR", "LPR", "None", "41.21N", "082.11W", "241", "US"],
    ["OH MANSFIELD", "KMFD", "MFD", "None", "40.49N", "082.31W", "395", "US"],
    ["OH MARION", "KMNN", "MNN", "None", "40.37N", "083.04W", "301", "US"],
    ["OH MARYSVILLE", "KMRT", "MRT", "None", "40.13N", "083.21W", "312", "US"],
    ["OH MIDDLETOWN/HOOK", "KMWO", "MWO", "None", "39.32N", "084.24W", "198", "US"],
    ["OH MT VERNON/KNOX", "K4I3", "4I3", "None", "40.20N", "082.32W", "363", "US"],
    ["OH NEW PHILADELPHIA", "KPHD", "PHD", "None", "40.28N", "081.25W", "272", "US"],
    ["OH NEWARK", "KVTA", "VTA", "None", "40.01N", "082.28W", "268", "US"],
    ["OH OTTAWA", "KOWX", "OWX", "None", "41.02N", "083.59W", "233", "US"],
    ["OH PORT CLINTON", "KPCW", "PCW", "None", "41.31N", "082.52W", "178", "US"],
    ["OH RAVENA/PORTAGE", "KPOV", "POV", "None", "41.13N", "081.15W", "365", "US"],
    ["OH RICKENBACKER ANG", "KLCK", "LCK", "None", "39.49N", "082.55W", "227", "US"],
    ["OH ROSEWOOD VOR", "KROD", "ROD", "None", "40.17N", "084.02W", "360", "US"],
    ["OH SPRINGFIELD MUNI", "KSGH", "SGH", "None", "39.50N", "083.50W", "321", "US"],
    ["OH TOLEDO", "KTDZ", "TDZ", "None", "41.34N", "083.29W", "189", "US"],
    ["OH TOLEDO", "KTOL", "TOL", "72536", "41.35N", "083.48W", "210", "US"],
    ["OH VERSAILLES", "KVES", "VES", "None", "40.12N", "084.32W", "307", "US"],
    ["OH WAPAKONETA", "KAXV", "AXV", "None", "40.30N", "084.18W", "279", "US"],
    ["OH WASHINGTON COURT", "KI23", "I23", "None", "39.34N", "083.25W", "299", "US"],
    ["OH WAUSEON", "KUSE", "USE", "None", "41.37N", "084.08W", "238", "US"],
    ["OH WILLOUGHBY", "KLNN", "LNN", "None", "41.40N", "081.22W", "191", "US"],
    ["OH WILMINGTON", "KILN", "ILN", "72426", "39.26N", "083.48W", "322", "US"],
    ["OH WILMINGTON/RFC", "KTIR", "TIR", "None", "39.25N", "083.49W", "332", "US"],
    ["OH WOOSTER", "KBJJ", "BJJ", "None", "40.52N", "081.53W", "343", "US"],
    ["OH WRIGHT PATERSON", "KFFO", "FFO", "74570", "39.49N", "084.02W", "251", "US"],
    ["OH YOUNGSTOWN", "KYNG", "YNG", "72525", "41.15N", "080.40W", "360", "US"],
    ["OH ZANESVILLE", "KZZV", "ZZV", "None", "39.57N", "081.54W", "268", "US"],
    ["OH ASHTABULA", "K7G2", "7G2", "None", "41.47N", "080.42W", "276", "US"],
    ["OH ASHTABULA", "KSHI", "SHI", "None", "41.47N", "080.42W", "276", "US"],
    ["OH COLUMBUS/BOLTON", "K2I4", "2I4", "None", "39.54N", "083.08W", "290", "US"],
    ["OH LANCASTER", "KI15", "I15", "None", "39.45N", "082.39W", "265", "US"],
    ["OH LORAIN/ELYRIA", "K22G", "22G", "None", "41.21N", "082.11W", "241", "US"],
    ["OH NEWARK", "K2I8", "2I8", "None", "40.01N", "082.28W", "268", "US"],
    ["OH RAVENA/PORTAGE", "K29G", "29G", "None", "41.13N", "081.15W", "365", "US"],
    ["OH SOUTH BASS ISLA", "None", "None", "99434", "41.37N", "082.10W", "177", "US"],
    ["OK ADA", "KADH", "ADH", "None", "34.48N", "096.40W", "308", "US"],
    ["OK ARDMORE", "KADM", "ADM", "None", "34.17N", "097.01W", "232", "US"],
    ["OK ARDMORE/EXEC", "K1F0", "1F0", "None", "34.09N", "097.07W", "257", "US"],
    ["OK ALTUS AFB", "KLTS", "LTS", "72352", "34.40N", "099.16W", "420", "US"],
    ["OK ALTUS/QUARTZ MTN", "KAXS", "AXS", "None", "34.42N", "099.20W", "437", "US"],
    ["OK ALVA", "KAVK", "AVK", "None", "36.46N", "098.40W", "449", "US"],
    ["OK ATOKA", "KAQR", "AQR", "None", "34.24N", "096.09W", "189", "US"],
    ["OK BARTLESVILLE", "KBVO", "BVO", "None", "36.46N", "096.01W", "210", "US"],
    ["OK BLACKWELL", "KBKN", "BKN", "None", "36.45N", "097.21W", "314", "US"],
    ["OK CLAREMORE", "KGCM", "GCM", "None", "36.18N", "095.29W", "221", "US"],
    ["OK CHANDLER", "KCQB", "CQB", "None", "35.43N", "096.49W", "300", "US"],
    ["OK CHICKASHA", "KCHK", "CHK", "None", "35.06N", "097.58W", "351", "US"],
    ["OK CLINTON", "KCSM", "CSM", "None", "35.21N", "099.12W", "588", "US"],
    ["OK CLINTON", "KCLK", "CLK", "None", "35.32N", "098.56W", "492", "US"],
    ["OK CUSHING", "KCUH", "CUH", "None", "35.57N", "096.46W", "279", "US"],
    ["OK DUNCAN", "KDUC", "DUC", "None", "34.28N", "097.58W", "339", "US"],
    ["OK DURANT", "KDUA", "DUA", "None", "33.57N", "096.24W", "213", "US"],
    ["OK ELK CITY", "KELK", "ELK", "None", "35.26N", "099.24W", "614", "US"],
    ["OK EL RENO MUNI", "KRQO", "RQO", "None", "35.28N", "098.00W", "432", "US"],
    ["OK ENID/VANCE AFB", "KEND", "END", "None", "36.19N", "097.55W", "398", "US"],
    ["OK ENID/WOODRING", "KWDG", "WDG", "None", "36.22N", "097.46W", "356", "US"],
    ["OK FORT SILL", "KFSI", "FSI", "72355", "34.39N", "098.24W", "362", "US"],
    ["OK FREDERICK/ALTUS", "KFDR", "FDR", "None", "34.21N", "098.59W", "386", "US"],
    ["OK GAGE", "KGAG", "GAG", "None", "36.18N", "099.46W", "668", "US"],
    ["OK HUGO", "KHHW", "HHW", "None", "34.02N", "095.33W", "144", "US"],
    ["OK MITBEE/GAGE", "KMMB", "MMB", "None", "36.18N", "099.46W", "668", "US"],
    ["OK GROVE", "KGMJ", "GMJ", "None", "36.36N", "094.44W", "254", "US"],
    ["OK GUTHRIE", "KGOK", "GOK", "None", "35.51N", "097.24W", "324", "US"],
    ["OK GUYMON", "KGUY", "GUY", "None", "36.41N", "101.30W", "948", "US"],
    ["OK HASKELL PROFILER", "None", "HKL", "74648", "35.46N", "095.46W", "212", "US"],
    ["OK HOBART", "KHBR", "HBR", "None", "34.59N", "099.03W", "473", "US"],
    ["OK IDABEL", "K4O4", "4O4", "None", "33.55N", "094.52W", "144", "US"],
    ["OK INOLA/TULSA/88D", "KINX", "INX", "None", "36.11N", "095.34W", "204", "US"],
    ["OK LAMONT PROFILER", "None", "LMN", "74647", "36.41N", "097.28W", "306", "US"],
    ["OK LAMONT ARM KLMN", "None", "None", "74646", "36.37N", "097.29W", "318", "US"],
    ["OK LAWTON", "KLAW", "LAW", "None", "34.33N", "098.25W", "337", "US"],
    ["OK LEXINGTON", "KHMY", "HMY", "None", "35.02N", "097.14W", "331", "US"],
    ["OK MORRIS", "None", "None", "74650", "35.41N", "095.52W", "217", "US"],
    ["OK MCALESTER", "KMLC", "MLC", "None", "34.53N", "095.47W", "232", "US"],
    ["OK MUSKOGEE", "KMKO", "MKO", "None", "35.39N", "095.22W", "185", "US"],
    ["OK NORMAN/WESTHEIME", "KOUN", "OUN", "72357", "35.15N", "097.28W", "357", "US"],
    ["OK NORMAN/SPC", "KWNS", "WNS", "None", "35.13N", "097.27W", "357", "US"],
    ["OK OKLAHOMA CITY", "KOKC", "OKC", "72353", "35.23N", "097.36W", "390", "US"],
    ["OK OKLA CITY/WILEY", "KPWA", "PWA", "None", "35.32N", "097.39W", "397", "US"],
    ["OK OKLA CITY/PAGE", "KRCE", "RCE", "None", "35.29N", "097.49W", "413", "US"],
    ["OK OKMULGEE", "KOKM", "OKM", "None", "35.40N", "095.57W", "220", "US"],
    ["OK PAULS VALLEY", "KPVJ", "PVJ", "None", "34.43N", "097.13W", "295", "US"],
    ["OK PONCA CITY", "KPNC", "PNC", "None", "36.44N", "097.06W", "308", "US"],
    ["OK POTEAU (R KERR)", "KRKR", "RKR", "None", "35.01N", "094.37W", "138", "US"],
    ["OK PURCELL PROFILER", "None", "PRC", "74649", "34.58N", "097.30W", "331", "US"],
    ["OK PURCELL", "None", "None", "74651", "34.58N", "097.42W", "343", "US"],
    ["OK SALLISAW", "KJSV", "JSV", "None", "35.26N", "094.48W", "161", "US"],
    ["OK SAND SPRINGS", "KOWP", "OWP", "None", "36.11N", "096.09W", "272", "US"],
    ["OK SEMINOLE", "KSRE", "SRE", "None", "35.16N", "096.41W", "312", "US"],
    ["OK SHAWNEE", "KSNL", "SNL", "None", "35.21N", "096.57W", "327", "US"],
    ["OK STIGLER", "KGZL", "GZL", "None", "35.17N", "095.06W", "183", "US"],
    ["OK STILLWATER", "KSWO", "SWO", "None", "36.10N", "097.05W", "290", "US"],
    ["OK TAHLEQUAH", "KTQH", "TQH", "None", "35.56N", "095.00W", "266", "US"],
    ["OK TINKER AFB", "KTIK", "TIK", "72354", "35.25N", "097.22W", "394", "US"],
    ["OK TULSA", "KTUL", "TUL", "72356", "36.12N", "095.53W", "207", "US"],
    ["OK TULSA", "KRVS", "RVS", "None", "36.03N", "095.59W", "200", "US"],
    ["OK TULSA/WFO", "KTSA", "TSA", "None", "36.12N", "095.54W", "205", "US"],
    ["OK TULSA/RFC", "KTUA", "TUA", "None", "36.09N", "095.51W", "205", "US"],
    ["OK TWIN LAKES/88D", "KTLX", "TLX", "None", "35.20N", "097.17W", "370", "US"],
    ["OK VANCE/KEGELMAN", "KVNX", "VNX", "None", "36.44N", "098.08W", "369", "US"],
    ["OK VICI PROFILER", "None", "VCI", "74640", "36.04N", "099.12W", "648", "US"],
    ["OK VICI", "None", "None", "74641", "36.04N", "099.20W", "622", "US"],
    ["OK WATONGA", "KJWG", "JWG", "None", "35.52N", "098.25W", "472", "US"],
    ["OK WEATHERFORD", "KOJA", "OJA", "None", "35.33N", "098.40W", "490", "US"],
    ["OK WOODWARD", "KWWR", "WWR", "None", "36.27N", "099.31W", "667", "US"],
    ["OK EL RENO MUNI", "KF28", "F28", "None", "35.28N", "098.00W", "432", "US"],
    ["OK PAGE", "KPGO", "PGO", "72341", "34.41N", "094.37W", "883", "US"],
    ["OK SEMINOLE", "KH45", "H45", "None", "35.16N", "096.41W", "312", "US"],
    ["OR PORTLAND", "KPDX", "PDX", "72698", "45.36N", "122.37W", "7", "US"],
    ["OR HILLSBORO/PORTLD", "KHIO", "HIO", "None", "45.33N", "122.57W", "68", "US"],
    ["OR ASTORIA", "KAST", "AST", "72791", "46.09N", "123.53W", "3", "US"],
    ["OR AURORA", "KUAO", "UAO", "None", "45.15N", "122.46W", "59", "US"],
    ["OR BAKER", "KBKE", "BKE", "None", "44.51N", "117.49W", "1024", "US"],
    ["OR BEND", "KBDN", "BDN", "None", "44.06N", "121.12W", "1055", "US"],
    ["OR BROOKINGS", "KBOK", "BOK", "72598", "42.04N", "124.17W", "140", "US"],
    ["OR BURNS", "KBNO", "BNO", "72683", "43.36N", "118.57W", "1264", "US"],
    ["OR CAPE BLANCO (CGS", "K92S", "92S", "72599", "42.50N", "124.34W", "57", "US"],
    ["OR CASCADE LOCKS ST", "KCZK", "CZK", "None", "45.40N", "121.52W", "46", "US"],
    ["OR CLATSOP SPIT", "K3CL", "3CL", "None", "46.14N", "124.01W", "9", "US"],
    ["OR CORVALLIS MUNI A", "KCVO", "CVO", "None", "44.30N", "123.16W", "75", "US"],
    ["OR EUGENE", "KEUG", "EUG", "72693", "44.08N", "123.13W", "114", "US"],
    ["OR FLORENCE MUNI", "K6S2", "6S2", "None", "43.59N", "124.07W", "16", "US"],
    ["OR GOLD BEACH", "K4S1", "4S1", "None", "42.25N", "124.25W", "5", "US"],
    ["OR GRANTS PASS", "K3S8", "3S8", "None", "42.31N", "123.23W", "345", "US"],
    ["OR HERMISTON", "KHRI", "HRI", "None", "45.50N", "119.16W", "195", "US"],
    ["OR HOOD RIVER", "K4S2", "4S2", "None", "45.40N", "121.32W", "195", "US"],
    ["OR JACKSON CTY/MFR", "KMAX", "MAX", "None", "42.05N", "122.43W", "2290", "US"],
    ["OR JOHN DAY STATE", "KGCD", "GCD", "None", "44.23N", "118.58W", "1127", "US"],
    ["OR KIMBERLY/VOR", "KIMB", "IMB", "None", "44.39N", "119.43W", "1700", "US"],
    ["OR KLAMATH FALLS", "KLMT", "LMT", "None", "42.09N", "121.43W", "1246", "US"],
    ["OR LA GRANDE", "KLGD", "LGD", "None", "45.16N", "118.00W", "827", "US"],
    ["OR LAKEVIEW", "KLKV", "LKV", "None", "42.10N", "120.24W", "1441", "US"],
    ["OR MADRAS", "KS33", "S33", "None", "44.40N", "121.09W", "743", "US"],
    ["OR MCMINNVILLE", "KMMV", "MMV", "None", "45.12N", "123.08W", "48", "US"],
    ["OR MEACHAM", "KMEH", "MEH", "None", "45.31N", "118.25W", "1136", "US"],
    ["OR MEDFORD", "KMFR", "MFR", "72597", "42.23N", "122.52W", "396", "US"],
    ["OR MEDFORD(VOR)", "KOED", "OED", "None", "42.23N", "122.52W", "396", "US"],
    ["OR NEWPORT", "KJNW", "JNW", "None", "44.34N", "124.04W", "48", "US"],
    ["OR NEWPORT", "KONP", "ONP", "72695", "44.34N", "124.02W", "48", "US"],
    ["OR NORTH BEND", "KOTH", "OTH", "72691", "43.25N", "124.15W", "4", "US"],
    ["OR ONTARIO", "KONO", "ONO", "None", "44.01N", "117.01W", "667", "US"],
    ["OR PENDLETON", "KPDT", "PDT", "72688", "45.42N", "118.50W", "462", "US"],
    ["OR PORTLD/SCAPPOOSE", "KRTX", "RTX", "None", "45.43N", "122.58W", "479", "US"],
    ["OR PORTLAND/WFO", "KPQR", "PQR", "None", "45.34N", "122.32W", "7", "US"],
    ["OR PORTLAND/RFC", "KPTR", "PTR", "None", "45.36N", "122.36W", "24", "US"],
    ["OR PRINEVILLE", "KS39", "S39", "None", "44.17N", "120.54W", "991", "US"],
    ["OR REDMOND", "KRDM", "RDM", "None", "44.15N", "121.09W", "938", "US"],
    ["OR REDMOND(VOR)", "KDSD", "DSD", "None", "44.15N", "121.18W", "938", "US"],
    ["OR ROME", "KP88", "P88", "None", "42.53N", "117.39W", "1162", "US"],
    ["OR ROME", "KREO", "REO", "None", "42.35N", "117.52W", "1235", "US"],
    ["OR ROOSTER ROCK", "KRRK", "RRK", "None", "45.33N", "122.58W", "50", "US"],
    ["OR ROSEBURG", "KRBG", "RBG", "72690", "43.14N", "123.21W", "154", "US"],
    ["OR SALEM", "KSLE", "SLE", "72694", "44.54N", "123.00W", "59", "US"],
    ["OR SCAPPOOSE", "KSPB", "SPB", "None", "45.46N", "122.52W", "14", "US"],
    ["OR SEA LION CAVES", "K2SL", "2SL", "None", "44.07N", "124.08W", "121", "US"],
    ["OR SEXTON SUMMIT", "KSXT", "SXT", "None", "42.36N", "123.22W", "1170", "US"],
    ["OR SISTERS EAGLEAIR", "K6K5", "6K5", "None", "44.18N", "121.32W", "966", "US"],
    ["OR THE DALLES", "KDLS", "DLS", "None", "45.37N", "121.10W", "71", "US"],
    ["OR TILLAMOOK", "KTMK", "TMK", "None", "45.25N", "123.49W", "11", "US"],
    ["OR TROUTDALE", "KTTD", "TTD", "None", "45.33N", "122.25W", "14", "US"],
    ["OR ASTORIA CG", "KNMW", "NMW", "None", "46.09N", "123.53W", "3", "US"],
    ["OR AURORA STATE", "K3S2", "3S2", "None", "45.15N", "122.46W", "60", "US"],
    ["OR BROOKINGS", "K4BK", "4BK", "None", "42.02N", "124.16W", "24", "US"],
    ["OR CAPE ARAGO (LS)", "None", "None", "99424", "43.19N", "124.37W", "18", "US"],
    ["OR HERMISTON", "KS22", "S22", "None", "45.50N", "119.16W", "195", "US"],
    ["OR JOHN DAY STATE", "K5J0", "5J0", "None", "44.23N", "118.58W", "1127", "US"],
    ["OR LAKEVIEW", "K4LW", "4LW", "72589", "42.13N", "120.21W", "1455", "US"],
    ["OR NEWPORT STATE B", "None", "None", "99428", "44.37N", "124.55W", "9", "US"],
    ["OR PACIFIC CITY", "KPFC", "PFC", "None", "45.12N", "123.57W", "5", "US"],
    ["OR SCAPPOOSE", "K1S4", "1S4", "None", "45.46N", "122.52W", "14", "US"],
    ["OR TILLAMOOK", "KS47", "S47", "None", "45.25N", "123.49W", "11", "US"],
    ["PA ALLENTOWN", "KABE", "ABE", "72517", "40.39N", "075.27W", "114", "US"],
    ["PA ALLENTOWN QUEEN", "KXLL", "XLL", "None", "40.34N", "075.29W", "122", "US"],
    ["PA ALTOONA", "KAOO", "AOO", "None", "40.18N", "078.19W", "455", "US"],
    ["PA AVOCA/WILKES B.", "KAVP", "AVP", "72513", "41.20N", "075.43W", "291", "US"],
    ["PA BEAVER FALLS ARP", "KBVI", "BVI", "None", "40.46N", "080.24W", "382", "US"],
    ["PA BEDFORD", "KHMZ", "HMZ", "None", "40.05N", "078.31W", "355", "US"],
    ["PA BRADFORD", "KBFD", "BFD", "None", "41.48N", "078.38W", "647", "US"],
    ["PA BUTLER CO.", "KBTP", "BTP", "None", "40.46N", "079.57W", "380", "US"],
    ["PA CLEARFIELD", "KFIG", "FIG", "None", "41.03N", "078.25W", "462", "US"],
    ["PA COATESVILLE", "KMQS", "MQS", "None", "39.59N", "075.52W", "201", "US"],
    ["PA DOYLESTOWN", "KDYL", "DYL", "None", "40.20N", "075.07W", "117", "US"],
    ["PA DU BOIS", "KDUJ", "DUJ", "None", "41.10N", "078.54W", "554", "US"],
    ["PA EAST TEXAS VOR", "KETX", "ETX", "None", "40.35N", "075.41W", "250", "US"],
    ["PA ELLWOOD CITY VOR", "KEWC", "EWC", "None", "40.50N", "080.13W", "407", "US"],
    ["PA ERIE", "KERI", "ERI", "72526", "42.05N", "080.11W", "222", "US"],
    ["PA FOUNTAIN DALE", "KRYT", "None", "None", "39.44N", "077.26W", "274", "US"],
    ["PA FRANKLIN", "KFKL", "FKL", "None", "41.22N", "079.52W", "469", "US"],
    ["PA GROVE CITY", "K29D", "29D", "None", "41.09N", "080.10W", "418", "US"],
    ["PA HARRISBURG", "KCXY", "CXY", "None", "40.13N", "076.51W", "106", "US"],
    ["PA HARRISBURG", "KHAR", "HAR", "72511", "40.18N", "077.04W", "397", "US"],
    ["PA HAZLETON", "KHZL", "HZL", "None", "40.59N", "076.00W", "489", "US"],
    ["PA INDIANA/STEWART", "KIDI", "IDI", "None", "40.37N", "079.05W", "429", "US"],
    ["PA JOHNSTOWN", "KJST", "JST", "None", "40.19N", "078.50W", "694", "US"],
    ["PA LANCASTER", "KLNS", "LNS", "None", "40.07N", "076.18W", "125", "US"],
    ["PA LATROBE/WESTMORL", "KLBE", "LBE", "None", "40.16N", "079.24W", "361", "US"],
    ["PA LEHIGHTON", "K22N", "22N", "None", "40.49N", "075.46W", "163", "US"],
    ["PA LOCK HAVEN", "KLHV", "LHV", "None", "41.08N", "077.25W", "170", "US"],
    ["PA MEADVILLE", "KGKJ", "GKJ", "None", "41.38N", "080.13W", "428", "US"],
    ["PA MIDDLETOWN", "KMDT", "MDT", "None", "40.12N", "076.46W", "95", "US"],
    ["PA MT. POCONO", "KMPO", "MPO", "None", "41.08N", "075.23W", "577", "US"],
    ["PA MUIR AAF/INDIANT", "KMUI", "MUI", "None", "40.25N", "076.34W", "149", "US"],
    ["PA NEW CASTLE MUNI", "KUCP", "UCP", "None", "41.02N", "080.25W", "327", "US"],
    ["PA PERKASIE", "KCKZ", "CKZ", "None", "40.23N", "075.17W", "173", "US"],
    ["PA PHILADELPHIA", "KPHL", "PHL", "72408", "39.52N", "075.14W", "18", "US"],
    ["PA PHILADELPHIA/NE", "KPNE", "PNE", "None", "40.05N", "075.01W", "28", "US"],
    ["PA PHILLY WINGS F", "KLOM", "LOM", "None", "40.08N", "075.16W", "92", "US"],
    ["PA PHILIPSBURG/MID", "KPSB", "PSB", "72512", "40.52N", "078.04W", "594", "US"],
    ["PA PITTSBURGH/ALLEG", "KAGC", "AGC", "None", "40.21N", "079.55W", "389", "US"],
    ["PA PITTSBURGH", "KPIT", "PIT", "72520", "40.30N", "080.16W", "357", "US"],
    ["PA PITT/CORAOPOLIS", "KPBZ", "PBZ", "None", "40.32N", "080.13W", "361", "US"],
    ["PA POTTSTOWN", "KPTW", "PTW", "None", "40.14N", "075.33W", "92", "US"],
    ["PA QUAKERTOWN ARP", "KUKT", "UKT", "None", "40.26N", "075.23W", "160", "US"],
    ["PA READING", "KRDG", "RDG", "None", "40.22N", "075.58W", "109", "US"],
    ["PA RUSH/ST COLLEGE", "KCCX", "CCX", "None", "40.55N", "078.00W", "733", "US"],
    ["PA SELINSGROVE", "KSEG", "SEG", "None", "40.49N", "076.52W", "134", "US"],
    ["PA SOMERSET", "K2G9", "2G9", "None", "40.02N", "079.01W", "694", "US"],
    ["PA SLATE RUN", "KSLT", "SLT", "None", "41.30N", "077.58W", "707", "US"],
    ["PA STATE COLLEGE", "KUNV", "UNV", "None", "40.51N", "077.51W", "378", "US"],
    ["PA STATE COLLEG/WFO", "KCTP", "CTP", "None", "40.51N", "077.51W", "389", "US"],
    ["PA STATE COLLEG/RFC", "KRHA", "RHA", "None", "40.51N", "077.51W", "389", "US"],
    ["PA TOWANDA", "KN27", "N27", "None", "41.44N", "076.27W", "223", "US"],
    ["PA WASHINGTON", "KAFJ", "AFJ", "None", "40.07N", "080.16W", "361", "US"],
    ["PA WELLSBORO", "KN38", "N38", "None", "41.44N", "077.24W", "577", "US"],
    ["PA WEST CHESTER", "KOQN", "OQN", "None", "39.59N", "075.35W", "142", "US"],
    ["PA WILLIAMSPORT", "KIPT", "IPT", "72514", "41.15N", "076.55W", "164", "US"],
    ["PA YORK", "KTHV", "THV", "None", "39.55N", "076.53W", "144", "US"],
    ["PA ALLENTOWN QUEEN", "KJVU", "JVU", "None", "40.34N", "075.29W", "122", "US"],
    ["PA CLEARFIELD", "KN97", "N97", "None", "41.03N", "078.25W", "462", "US"],
    ["PA COATESVILLE", "K40N", "40N", "None", "39.59N", "075.52W", "201", "US"],
    ["PA HAWLEY", "KHAW", "HAW", "None", "41.29N", "075.10W", "268", "US"],
    ["PA MEADVILLE", "K2G6", "2G6", "None", "41.37N", "080.12W", "428", "US"],
    ["PA TOBYHANNA", "K7TB", "7TB", "None", "41.11N", "075.25W", "585", "US"],
    ["PA WILLOW GROVE NAS", "KNXX", "NXX", "None", "40.12N", "075.09W", "110", "US"],
    ["RI BLOCK ISLAND", "KBID", "BID", "None", "41.10N", "071.35W", "33", "US"],
    ["RI N. KINGSTON/QUON", "KOQU", "OQU", "None", "41.36N", "071.25W", "6", "US"],
    ["RI NEWPORT", "KUUU", "UUU", "None", "41.32N", "071.17W", "51", "US"],
    ["RI PAWTUCKET", "KSFZ", "SFZ", "None", "41.55N", "071.30W", "134", "US"],
    ["RI PROVIDENCE/GREEN", "KPVD", "PVD", "72507", "41.43N", "071.26W", "16", "US"],
    ["RI WESTERLY", "KWST", "WST", "None", "41.21N", "071.48W", "21", "US"],
    ["RI NEWPORT", "K2B4", "2B4", "None", "41.32N", "071.17W", "52", "US"],
    ["RI WOONSOCKET", "K1B6", "1B6", "None", "41.55N", "071.31W", "35", "US"],
    ["SC AIKEN", "KAIK", "AIK", "None", "33.39N", "081.41W", "161", "US"],
    ["SC ALLENDALE", "KAQX", "AQX", "None", "33.00N", "081.16W", "50", "US"],
    ["SC ANDERSON", "KAND", "AND", "None", "34.30N", "082.43W", "239", "US"],
    ["SC BARNWELL", "KBNL", "BNL", "None", "33.15N", "081.23W", "75", "US"],
    ["SC BEAUFORT MCAS", "KNBC", "NBC", "None", "32.28N", "080.43W", "12", "US"],
    ["SC BEAUFORT CNTY", "KARW", "ARW", "None", "32.25N", "080.38W", "4", "US"],
    ["SC BERKELEY MONCKS", "KMKS", "MKS", "None", "33.11N", "080.02W", "23", "US"],
    ["SC CAMDEN WOODWARD", "KCDN", "CDN", "None", "34.17N", "080.34W", "92", "US"],
    ["SC CHARLESTON", "KCHS", "CHS", "72208", "32.54N", "080.02W", "13", "US"],
    ["SC CHARLESTON/GRAYS", "KCLX", "CLX", "None", "32.39N", "081.03W", "30", "US"],
    ["SC CHARLESTON/EXEC", "KJZI", "JZI", "None", "32.42N", "080.00W", "6", "US"],
    ["SC CHERAW", "KCQW", "CQW", "None", "34.43N", "079.57W", "73", "US"],
    ["SC CHESTER CATAWBA", "KDCM", "DCM", "None", "34.47N", "081.12W", "200", "US"],
    ["SC CLEMSON", "KCEU", "CEU", "None", "34.40N", "082.53W", "268", "US"],
    ["SC COLLIERS VOR", "KIRQ", "IRQ", "None", "33.43N", "082.10W", "147", "US"],
    ["SC COLUMBIA", "KCAE", "CAE", "72310", "33.56N", "081.07W", "70", "US"],
    ["SC COLUMBIA-OWENS", "KCUB", "CUB", "None", "33.58N", "081.00W", "56", "US"],
    ["SC CONWAY-HORRY CTY", "KHYW", "HYW", "None", "33.50N", "079.07W", "11", "US"],
    ["SC DARLINGTON CNTY", "KUDG", "UDG", "None", "34.27N", "079.53W", "59", "US"],
    ["SC FLORENCE", "KFLO", "FLO", "None", "34.11N", "079.44W", "44", "US"],
    ["SC GEORGETOWN", "KGGE", "GGE", "None", "33.19N", "079.19W", "12", "US"],
    ["SC GREENWOOD", "KGRD", "GRD", "None", "34.15N", "082.09W", "185", "US"],
    ["SC GREER/SPARTANSBG", "KGSP", "GSP", "72312", "34.54N", "082.13W", "287", "US"],
    ["SC GREENVILLE", "KGMU", "GMU", "None", "34.51N", "082.21W", "315", "US"],
    ["SC GREENVILLE", "KGYH", "GYH", "None", "34.45N", "082.23W", "292", "US"],
    ["SC HARTSVILLE", "KHVS", "HVS", "None", "34.24N", "080.07W", "111", "US"],
    ["SC HILTON HEAD", "KHXD", "HXD", "None", "32.13N", "080.42W", "6", "US"],
    ["SC KINGSTREE", "KCKI", "CKI", "None", "33.43N", "079.51W", "21", "US"],
    ["SC LANCASTER", "KLKR", "LKR", "None", "34.43N", "080.51W", "149", "US"],
    ["SC LAURENS", "KLUX", "LUX", "None", "34.30N", "081.57W", "213", "US"],
    ["SC MANNING", "KMNI", "MNI", "None", "33.35N", "080.13W", "32", "US"],
    ["SC MARION", "KMAO", "MAO", "None", "34.11N", "079.20W", "28", "US"],
    ["SC MARLBORO CNTY", "KBBP", "BBP", "None", "34.37N", "079.44W", "45", "US"],
    ["SC MCENTIRE ANG BAS", "KMMT", "MMT", "None", "33.55N", "080.47W", "77", "US"],
    ["SC MOUNT PLEASANT", "KLRO", "LRO", "None", "32.54N", "079.47W", "4", "US"],
    ["SC MYRTLE BEACH", "KMYR", "MYR", "74791", "33.40N", "078.55W", "8", "US"],
    ["SC NORTH MYRTLE BEA", "KCRE", "CRE", "None", "33.49N", "078.43W", "10", "US"],
    ["SC NEWBERRY", "KEOE", "EOE", "None", "34.19N", "081.38W", "174", "US"],
    ["SC ORANGEBURG", "KOGB", "OGB", "None", "33.28N", "080.51W", "59", "US"],
    ["SC PICKENS", "KLQK", "LQK", "None", "34.49N", "082.42W", "309", "US"],
    ["SC ROCK HILL", "KUZA", "UZA", "None", "34.59N", "081.03W", "202", "US"],
    ["SC SHAW AFB/SUMTER", "KSSC", "SSC", "74790", "33.58N", "080.28W", "74", "US"],
    ["SC SPARTANBURG", "KSPA", "SPA", "None", "34.55N", "081.56W", "303", "US"],
    ["SC SUMMERVILLE", "KDYB", "DYB", "None", "33.04N", "080.17W", "18", "US"],
    ["SC SUMTER", "KSMS", "SMS", "None", "34.00N", "080.22W", "56", "US"],
    ["SC WALTERBORO", "KRBW", "RBW", "None", "32.55N", "080.38W", "31", "US"],
    ["SC WINNSBORO", "KFDW", "FDW", "None", "34.19N", "081.07W", "176", "US"],
    ["SC CHARLESTON AFB", "KIGC", "IGC", "None", "32.54N", "080.02W", "14", "US"],
    ["SC FOLLY ISLAND", "None", "None", "99423", "32.40N", "079.07W", "3", "US"],
    ["SC GRNVL/DNLDSN", "KXAA", "XAA", "None", "34.45N", "082.23W", "320", "US"],
    ["SC HILTON HEAD", "K49J", "49J", "None", "32.13N", "080.42W", "6", "US"],
    ["SC ROCK HILL", "K29J", "29J", "None", "34.59N", "081.03W", "202", "US"],
    ["SC SUMTER/POINSETT", "K2PJ", "2PJ", "74792", "33.51N", "080.29W", "68", "US"],
    ["SD ABERDEEN", "KABR", "ABR", "72659", "45.27N", "098.25W", "397", "US"],
    ["SD BELLE FOURCHE", "KEFC", "EFC", "None", "44.43N", "103.52W", "982", "US"],
    ["SD BISON", "K6V5", "6V5", "None", "45.31N", "102.28W", "851", "US"],
    ["SD BRITTON", "KBTN", "BTN", "None", "45.49N", "097.45W", "402", "US"],
    ["SD BROOKINGS", "KBKX", "BKX", "None", "44.17N", "096.49W", "502", "US"],
    ["SD BUFFALO", "K2WX", "2WX", "None", "45.36N", "103.33W", "915", "US"],
    ["SD CHAMBERLAIN", "K9V9", "9V9", "72653", "43.46N", "099.19W", "519", "US"],
    ["SD CLARK", "K8D7", "8D7", "None", "44.54N", "097.43W", "547", "US"],
    ["SD CUSTER", "KCUT", "CUT", "None", "43.44N", "103.37W", "1725", "US"],
    ["SD DESMET", "K6E5", "6E5", "None", "44.26N", "097.33W", "527", "US"],
    ["SD DUPREE", "KDPR", "DPR", "None", "45.04N", "101.42W", "771", "US"],
    ["SD EAGLE BUTTE", "K84D", "84D", "None", "44.59N", "101.15W", "746", "US"],
    ["SD ELLSWORTH AFB", "KRCA", "RCA", "None", "44.08N", "103.05W", "999", "US"],
    ["SD FAITH", "KD07", "D07", "None", "45.02N", "102.01W", "784", "US"],
    ["SD FAULKTON", "K3FU", "3FU", "None", "45.02N", "099.07W", "478", "US"],
    ["SD GETTYSBURG", "K0D8", "0D8", "None", "44.59N", "099.57W", "629", "US"],
    ["SD GREGORY", "K9D1", "9D1", "None", "43.13N", "099.24W", "663", "US"],
    ["SD HOT SPRINGS", "KHSR", "HSR", "None", "43.22N", "103.23W", "960", "US"],
    ["SD HURON", "KHON", "HON", "72654", "44.23N", "098.14W", "390", "US"],
    ["SD LEMMON", "KY22", "Y22", "72669", "45.55N", "102.10W", "781", "US"],
    ["SD MADISON", "KMDS", "MDS", "None", "44.01N", "097.05W", "524", "US"],
    ["SD MARTIN", "K9V6", "9V6", "None", "43.10N", "101.43W", "1004", "US"],
    ["SD MILLBANK", "K1D1", "1D1", "None", "45.14N", "096.34W", "341", "US"],
    ["SD MILLER", "KMKA", "MKA", "None", "44.32N", "098.57W", "479", "US"],
    ["SD MITCHELL", "KMHE", "MHE", "None", "43.46N", "098.01W", "397", "US"],
    ["SD MOBRIDGE", "KMBG", "MBG", "72668", "45.33N", "100.25W", "510", "US"],
    ["SD ONIDA", "K98D", "98D", "None", "44.42N", "100.06W", "571", "US"],
    ["SD PARKSTON", "K8V3", "8V3", "None", "43.23N", "097.59W", "432", "US"],
    ["SD PHILIP", "KPHP", "PHP", "None", "44.03N", "101.36W", "672", "US"],
    ["SD PIERRE", "KPIR", "PIR", "None", "44.23N", "100.17W", "526", "US"],
    ["SD PINE RIDGE", "KIEN", "IEN", "None", "43.02N", "102.31W", "998", "US"],
    ["SD PLATTE", "K1D3", "1D3", "None", "43.24N", "098.50W", "493", "US"],
    ["SD RAPID CITY/WFO", "KUNR", "UNR", "72662", "44.04N", "103.12W", "1027", "US"],
    ["SD RAPID CITY", "KRAP", "RAP", "None", "44.03N", "103.03W", "965", "US"],
    ["SD RAPID/N UNDERWOD", "KUDX", "UDX", "None", "44.08N", "102.50W", "919", "US"],
    ["SD SIOUX FALLS", "KFSD", "FSD", "72651", "43.35N", "096.45W", "436", "US"],
    ["SD SISSETON", "K8D3", "8D3", "None", "45.40N", "096.59W", "354", "US"],
    ["SD SPEARFISH/CLYDE", "KSPF", "SPF", "None", "44.28N", "103.46W", "1188", "US"],
    ["SD STURGIS", "K49B", "49B", "None", "44.25N", "103.23W", "989", "US"],
    ["SD TEA", "KY14", "Y14", "None", "43.27N", "096.48W", "462", "US"],
    ["SD VERMILLION", "KVMR", "VMR", "None", "42.46N", "096.56W", "349", "US"],
    ["SD WAGNER", "KAGZ", "AGZ", "None", "43.04N", "098.18W", "451", "US"],
    ["SD WALL", "K6V4", "6V4", "None", "44.00N", "102.15W", "857", "US"],
    ["SD WATERTOWN", "KATY", "ATY", "None", "44.54N", "097.09W", "532", "US"],
    ["SD WEBSTER", "K1D7", "1D7", "None", "45.18N", "097.31W", "566", "US"],
    ["SD WESSINGTON SPRIN", "K4X4", "4X4", "None", "44.04N", "098.32W", "471", "US"],
    ["SD WINNER", "KICR", "ICR", "None", "43.23N", "099.51W", "621", "US"],
    ["SD WINNER", "KSFD", "SFD", "None", "43.23N", "099.51W", "621", "US"],
    ["SD YANKTON", "KYKN", "YKN", "None", "42.55N", "097.22W", "398", "US"],
    ["SD BELLE FOURCHE", "KBEL", "BEL", "None", "44.48N", "104.03W", "971", "US"],
    ["SD JCT SD44 US385", "KPAC", "PAC", "None", "44.06N", "103.31W", "1494", "US"],
    ["SD ELLSWORTH I90", "KEL0", "EL0", "None", "44.07N", "103.05W", "939", "US"],
    ["SD WASTA I90", "KWTA", "None", "None", "44.05N", "102.29W", "810", "US"],
    ["SD SHERIDAN LAKE RD", "KSL0", "SL0", "None", "44.02N", "103.26W", "1478", "US"],
    ["SD EDGEMONT US18", "KED0", "ED0", "None", "43.17N", "103.53W", "1136", "US"],
    ["SD SD-WY BORDR US85", "KNE0", "NE0", "None", "44.11N", "104.03W", "1940", "US"],
    ["SD GLAD VLY SD20", "KGLV", "None", "None", "45.24N", "101.47W", "753", "US"],
    ["SD BATESLAND US18", "KBAT", "BAT", "None", "43.08N", "102.06W", "1042", "US"],
    ["SD LEMMON US12", "KLEM", "LEM", "None", "45.56N", "102.11W", "783", "US"],
    ["SD ANDOVER", "KADR", "ADR", "None", "45.26N", "097.56W", "453", "US"],
    ["SD BELVIDERE", "KBVD", "BVD", "None", "43.54N", "101.08W", "728", "US"],
    ["SD BRANDT", "KBRA", "BRA", "None", "44.41N", "096.51W", "564", "US"],
    ["SD CACTUS FLATS", "KCAC", "CAC", "None", "43.50N", "101.46W", "751", "US"],
    ["SD KADOKA", "KKAD", "KAD", "None", "43.52N", "101.50W", "765", "US"],
    ["SD FREDERICK", "KFED", "FED", "None", "45.56N", "098.34W", "427", "US"],
    ["SD HARROLD", "KHRD", "HRD", "None", "44.32N", "099.42W", "547", "US"],
    ["SD HERRIED", "KHER", "HER", "None", "45.51N", "100.06W", "513", "US"],
    ["SD RELIANCE", "KREL", "REL", "None", "43.52N", "099.34W", "542", "US"],
    ["SD SUMMIT", "KSUM", "SUM", "None", "45.20N", "097.05W", "607", "US"],
    ["SD TOLSTOY", "KTLS", "TLS", "None", "45.13N", "099.40W", "596", "US"],
    ["SD VICTOR", "KVIC", "VIC", "None", "45.54N", "096.52W", "329", "US"],
    ["SD VIVIAN", "KVIV", "VIV", "None", "44.14N", "100.22W", "588", "US"],
    ["SD CUSTER", "K0V1", "0V1", "None", "43.44N", "103.37W", "1725", "US"],
    ["SD MOBRIDGE", "KY26", "Y26", "None", "45.32N", "100.26W", "508", "US"],
    ["SD PHILIP", "KP05", "P05", "None", "44.04N", "101.39W", "683", "US"],
    ["SD PICKSTOWN", "None", "PKW", "72652", "43.04N", "098.31W", "453", "US"],
    ["SD REDIG", "KREJ", "REJ", "72661", "45.16N", "103.32W", "925", "US"],
    ["SD ABERDEEN", "QABS", "None", "None", "45.29N", "098.28W", "395", "US"],
    ["SD ALCESTER", "QALS", "None", "None", "43.01N", "096.38W", "342", "US"],
    ["SD BALTIC", "QBAS", "None", "None", "43.46N", "096.44W", "342", "US"],
    ["SD BRANDON", "QBRS", "None", "None", "43.36N", "096.35W", "342", "US"],
    ["SD FT THOMPSON", "QCES", "None", "None", "44.04N", "099.26W", "440", "US"],
    ["SD CLARK", "QCLS", "None", "None", "44.53N", "097.44W", "342", "US"],
    ["SD REDFIELD", "QDPS", "None", "None", "44.53N", "098.31W", "397", "US"],
    ["SD LEAD", "QDSS", "None", "None", "44.21N", "103.47W", "1560", "US"],
    ["SD ELKTON", "QEKS", "None", "None", "44.14N", "096.29W", "342", "US"],
    ["SD PARKSTON", "QESS", "None", "None", "43.24N", "097.59W", "426", "US"],
    ["SD GETTYSBURG", "QETS", "None", "None", "45.01N", "099.58W", "628", "US"],
    ["SD GARRETSON", "QGAS", "None", "None", "43.43N", "096.30W", "342", "US"],
    ["SD CHAMBERLAIN", "QHAS", "None", "None", "43.48N", "099.20W", "447", "US"],
    ["SD BRITTON", "QHHS", "None", "None", "45.47N", "097.45W", "414", "US"],
    ["SD HOWARD", "QHOS", "None", "None", "44.01N", "097.32W", "342", "US"],
    ["SD WINNER", "QHSS", "None", "None", "43.23N", "099.52W", "622", "US"],
    ["SD HURON", "QHUS", "None", "None", "44.21N", "098.14W", "388", "US"],
    ["SD KADOKA", "QKAS", "None", "None", "43.50N", "101.31W", "749", "US"],
    ["SD BROOKINGS", "QKGS", "None", "None", "44.17N", "096.47W", "495", "US"],
    ["SD MILLER", "QLES", "None", "None", "44.31N", "098.59W", "484", "US"],
    ["SD CLEAR LAKE", "QLKS", "None", "None", "44.45N", "096.41W", "342", "US"],
    ["SD COLTON", "QLTS", "None", "None", "43.44N", "096.55W", "478", "US"],
    ["SD MADISON", "QMMS", "None", "None", "44.01N", "097.06W", "510", "US"],
    ["SD MILBANK", "QMIS", "None", "None", "45.12N", "096.38W", "354", "US"],
    ["SD MISSION", "QMSS", "None", "None", "43.18N", "100.40W", "784", "US"],
    ["SD MOBRIDGE", "QOBS", "None", "None", "45.32N", "100.26W", "511", "US"],
    ["SD PIERRE", "QPIS", "None", "None", "44.22N", "100.21W", "493", "US"],
    ["SD ELK POINT", "QPJS", "None", "None", "42.41N", "096.41W", "342", "US"],
    ["SD RAPID CITY", "QRAS", "None", "None", "44.04N", "103.13W", "998", "US"],
    ["SD RAMONA", "QRMS", "None", "None", "44.07N", "097.13W", "342", "US"],
    ["SD FSD PH", "QSAS", "None", "None", "43.32N", "096.43W", "440", "US"],
    ["SD FSD PAV", "QSBS", "None", "None", "43.32N", "096.44W", "449", "US"],
    ["SD EUREKA", "QSDS", "None", "None", "45.46N", "099.37W", "576", "US"],
    ["SD FLANDREAU", "QSNS", "None", "None", "44.03N", "096.36W", "478", "US"],
    ["SD MITCHELL", "QTMS", "None", "None", "43.43N", "098.02W", "395", "US"],
    ["SD MARTY", "QTYS", "None", "None", "43.00N", "098.09W", "441", "US"],
    ["SD VERMILLION", "QVMS", "None", "None", "42.47N", "096.56W", "373", "US"],
    ["SD WALL", "QWAS", "None", "None", "43.59N", "102.14W", "854", "US"],
    ["SD WEBSTER", "QWES", "None", "None", "45.20N", "097.31W", "342", "US"],
    ["SD WATERTOWN", "QWTS", "None", "None", "44.55N", "097.06W", "544", "US"],
    ["SD YANKTON", "QYAS", "None", "None", "42.53N", "097.23W", "382", "US"],
    ["SD HARRISBURG", "QHBS", "None", "None", "43.25N", "096.42W", "380", "US"],
    ["SD MARION", "QMRS", "None", "None", "43.23N", "097.17W", "451", "US"],
    ["SD PLATTE", "QPTS", "None", "None", "43.23N", "098.51W", "488", "US"],
    ["TN ATHENS/MCMINN", "KMMI", "MMI", "None", "35.24N", "084.34W", "266", "US"],
    ["TN BOLIVAR/WHITEHST", "KM08", "M08", "None", "35.13N", "089.03W", "152", "US"],
    ["TN BRISTOL", "KTRI", "TRI", "None", "36.29N", "082.24W", "474", "US"],
    ["TN CHATTANOOGA", "KCHA", "CHA", "72324", "35.02N", "085.12W", "210", "US"],
    ["TN CHATTANOOGA VOR", "KGQO", "GQO", "None", "34.58N", "085.09W", "210", "US"],
    ["TN CLARKSVILLE", "KCKV", "CKV", "None", "36.37N", "087.25W", "165", "US"],
    ["TN CLEVELAND REG.", "KRZR", "RZR", "None", "35.13N", "084.48W", "263", "US"],
    ["TN COLLEGEDALE", "K3M3", "3M3", "None", "35.03N", "085.01W", "262", "US"],
    ["TN COLUMBIA", "KMRC", "MRC", "None", "35.33N", "087.11W", "208", "US"],
    ["TN COVINGTON MUNI", "KM04", "M04", "None", "35.35N", "089.35W", "85", "US"],
    ["TN CROSSVILLE", "KCSV", "CSV", "None", "35.57N", "085.05W", "570", "US"],
    ["TN DAYTON", "K2A0", "2A0", "None", "35.29N", "084.56W", "219", "US"],
    ["TN DEWITT SPAIN/MEM", "KM01", "M01", "None", "35.12N", "090.03W", "69", "US"],
    ["TN DICKSON", "KM02", "M02", "None", "36.08N", "087.26W", "272", "US"],
    ["TN DYERSBURG", "KDYR", "DYR", "None", "36.00N", "089.24W", "103", "US"],
    ["TN ELIZABETHTON", "K0A9", "0A9", "None", "36.22N", "082.10W", "486", "US"],
    ["TN FAYETTEVILLE", "KFYM", "FYM", "None", "35.04N", "086.34W", "300", "US"],
    ["TN FRANKLIN WILKINS", "KM52", "M52", "None", "35.39N", "088.23W", "157", "US"],
    ["TN GALLATIN", "KM33", "M33", "None", "36.23N", "086.25W", "178", "US"],
    ["TN HOLSTON MTN VOR", "KHMV", "HMV", "None", "36.26N", "082.08W", "1317", "US"],
    ["TN HUNTINGDON", "KHZD", "HZD", "None", "36.05N", "088.28W", "151", "US"],
    ["TN JACKSBORO", "KJAU", "JAU", "None", "36.20N", "084.10W", "360", "US"],
    ["TN JACKSON", "KMKL", "MKL", "None", "35.36N", "088.55W", "128", "US"],
    ["TN KNOXVILLE", "KTYS", "TYS", "72326", "35.49N", "083.59W", "302", "US"],
    ["TN KNOXVILLE VOR", "KVXV", "VXV", "None", "35.54N", "083.53W", "302", "US"],
    ["TN KNOXVILLE", "KDKX", "DKX", "None", "35.58N", "083.52W", "254", "US"],
    ["TN LAWRENCEBURG", "K2M2", "2M2", "None", "35.14N", "087.15W", "286", "US"],
    ["TN LEBANON", "KM54", "M54", "None", "36.11N", "086.19W", "180", "US"],
    ["TN LEWISBURG", "KLUG", "LUG", "None", "35.30N", "086.48W", "219", "US"],
    ["TN LEXINGTON-PARSON", "KPVE", "PVE", "None", "35.39N", "088.11W", "149", "US"],
    ["TN LIVINGSTON", "K8A3", "8A3", "None", "36.25N", "085.19W", "419", "US"],
    ["TN MADISONVILLE", "KMNV", "MNV", "None", "35.33N", "084.23W", "314", "US"],
    ["TN MCMINNVILLE", "KRNC", "RNC", "None", "35.42N", "085.51W", "315", "US"],
    ["TN MEMPHIS", "KMEM", "MEM", "72334", "35.04N", "089.59W", "86", "US"],
    ["TN MEMPHIS/WFO", "KMEG", "MEG", "None", "35.03N", "090.00W", "101", "US"],
    ["TN MEMPHIS/ARTCC", "KZME", "ZME", "None", "35.03N", "089.59W", "101", "US"],
    ["TN MILLINGTON/88D", "KNQA", "NQA", "None", "35.21N", "089.52W", "86", "US"],
    ["TN MILLINGTON", "K2M8", "2M8", "None", "35.17N", "089.56W", "75", "US"],
    ["TN MORRISTOWN/KNOX", "KMRX", "MRX", "None", "36.10N", "083.24W", "408", "US"],
    ["TN MORRISTOWN/MOORE", "KMOR", "MOR", "None", "36.11N", "083.23W", "401", "US"],
    ["TN MURFREESBORO", "KMBT", "MBT", "None", "35.53N", "086.23W", "188", "US"],
    ["TN NASHVILLE", "KBNA", "BNA", "72327", "36.07N", "086.41W", "210", "US"],
    ["TN NASHV/JC TUNE", "KJWN", "JWN", "None", "36.11N", "086.53W", "151", "US"],
    ["TN OAK RIDGE", "KOQT", "OQT", "None", "36.01N", "084.14W", "277", "US"],
    ["TN OLD HICKORY/NASH", "KOHX", "OHX", "None", "36.15N", "086.34W", "176", "US"],
    ["TN PARIS HENRY CTY", "KPHT", "PHT", "None", "36.20N", "088.23W", "177", "US"],
    ["TN PORTLAND", "K1M5", "1M5", "None", "36.36N", "086.29W", "250", "US"],
    ["TN PULASKI", "KGZS", "GZS", "None", "35.09N", "087.03W", "210", "US"],
    ["TN ROCKWOOD", "KRKW", "RKW", "None", "35.55N", "084.41W", "508", "US"],
    ["TN SAVANNAH HARDIN", "KSNH", "SNH", "None", "35.10N", "088.13W", "144", "US"],
    ["TN SEVIERVILLE", "KGKT", "GKT", "None", "35.51N", "083.32W", "309", "US"],
    ["TN SHELBYVILLE", "KSYI", "SYI", "None", "35.34N", "086.27W", "245", "US"],
    ["TN SMYRNA", "KMQY", "MQY", "None", "36.01N", "086.31W", "166", "US"],
    ["TN SOMERVILLE", "KFYE", "FYE", "None", "35.12N", "089.24W", "133", "US"],
    ["TN SPARTA", "KSRB", "SRB", "None", "36.03N", "085.32W", "313", "US"],
    ["TN SPRINGFIELD", "KM91", "M91", "None", "36.32N", "086.55W", "216", "US"],
    ["TN TULLAHOMA", "KTHA", "THA", "None", "35.23N", "086.15W", "331", "US"],
    ["TN UNION CITY", "KUCY", "UCY", "None", "36.23N", "088.59W", "104", "US"],
    ["TN WINCHESTER", "KBGF", "BGF", "None", "35.11N", "086.04W", "299", "US"],
    ["TN MONTEAGLE", "KMGL", "MGL", "None", "35.15N", "085.51W", "586", "US"],
    ["TN SELMER", "KSZY", "SZY", "None", "35.12N", "088.30W", "100", "US"],
    ["TX DALLAS/FT WORTH", "KDFW", "DFW", "72259", "32.54N", "097.01W", "174", "US"],
    ["TX ABILENE", "KABI", "ABI", "72266", "32.25N", "099.41W", "548", "US"],
    ["TX ALICE", "KALI", "ALI", "None", "27.44N", "098.01W", "53", "US"],
    ["TX ALPINE-CASPARIS", "KE38", "E38", "None", "30.23N", "103.41W", "1376", "US"],
    ["TX AMARILLO", "KAMA", "AMA", "72363", "35.13N", "101.43W", "1093", "US"],
    ["TX ANDREWS", "KE11", "E11", "None", "32.20N", "102.32W", "967", "US"],
    ["TX ANGLETON", "KLBX", "LBX", "None", "29.07N", "095.28W", "6", "US"],
    ["TX ARLINGTON", "KGKY", "GKY", "None", "32.40N", "097.06W", "192", "US"],
    ["TX ATHENS", "KF44", "F44", "None", "32.10N", "095.50W", "135", "US"],
    ["TX AUSTIN", "KAUS", "AUS", "72254", "30.11N", "097.41W", "166", "US"],
    ["TX AUSTIN EXEC", "KEDC", "EDC", "None", "30.24N", "097.34W", "189", "US"],
    ["TX AUSTIN/MABRY", "KATT", "ATT", "None", "30.19N", "097.46W", "201", "US"],
    ["TX BAY CITY", "KBYY", "BYY", "None", "28.58N", "095.52W", "14", "US"],
    ["TX BEAUMONT/PORT AR", "KBPT", "BPT", "72241", "29.57N", "094.02W", "5", "US"],
    ["TX BEAUMONT", "KBMT", "BMT", "None", "30.04N", "094.13W", "10", "US"],
    ["TX BEEVILLE MUNI", "KBEA", "BEA", "None", "28.22N", "097.47W", "82", "US"],
    ["TX BIG SPRING", "KBPG", "BPG", "None", "32.13N", "101.31W", "784", "US"],
    ["TX BONHAM", "KF00", "F00", "None", "33.37N", "096.11W", "189", "US"],
    ["TX BORGER", "KBGD", "BGD", "None", "35.42N", "101.24W", "927", "US"],
    ["TX BOWIE", "K0F2", "0F2", "None", "33.36N", "097.47W", "336", "US"],
    ["TX BRADY", "KBBD", "BBD", "None", "31.11N", "099.19W", "557", "US"],
    ["TX BRECKENRIDGE", "KBKD", "BKD", "None", "32.43N", "098.53W", "392", "US"],
    ["TX BRENHAM", "K11R", "11R", "None", "30.13N", "096.22W", "94", "US"],
    ["TX BRIDGEPORT", "KXBP", "None", "None", "33.11N", "097.50W", "260", "US"],
    ["TX BROWNSVILLE", "KBRO", "BRO", "72250", "25.55N", "097.25W", "7", "US"],
    ["TX BROWNWOOD", "KBWD", "BWD", "None", "31.48N", "098.57W", "423", "US"],
    ["TX BRYAN", "KCFD", "CFD", "None", "30.43N", "096.20W", "112", "US"],
    ["TX BURNET", "KBMQ", "BMQ", "None", "30.44N", "098.14W", "389", "US"],
    ["TX CALDWELL", "KRWV", "RWV", "None", "30.31N", "096.42W", "119", "US"],
    ["TX CANADIAN", "KHHF", "HHF", "None", "35.54N", "100.24W", "712", "US"],
    ["TX CAMERON", "KT35", "T35", "None", "30.53N", "096.58W", "123", "US"],
    ["TX CARRIZO SPRINGS", "KCZT", "CZT", "None", "28.31N", "099.49W", "183", "US"],
    ["TX CASTROVILLE MUNI", "KCVB", "CVB", "None", "29.21N", "098.51W", "235", "US"],
    ["TX CENTER", "KF17", "F17", "None", "31.50N", "094.09W", "92", "US"],
    ["TX CENTEX (AUSTIN)", "KCWK", "CWK", "None", "30.23N", "097.32W", "181", "US"],
    ["TX CHILDRESS", "KCDS", "CDS", "None", "34.26N", "100.17W", "594", "US"],
    ["TX CISCO", "KGZN", "GZN", "None", "32.22N", "099.01W", "522", "US"],
    ["TX CLARKSVILLE", "KLBR", "LBR", "None", "33.36N", "095.04W", "134", "US"],
    ["TX CLEBURNE", "KCPT", "CPT", "None", "32.21N", "097.26W", "260", "US"],
    ["TX CLEVELAND MUNI", "K6R3", "6R3", "None", "30.21N", "095.00W", "46", "US"],
    ["TX COLEMAN MUNI", "KCOM", "COM", "None", "31.50N", "099.24W", "517", "US"],
    ["TX COLLEGE STATION", "KCLL", "CLL", "None", "30.35N", "096.22W", "96", "US"],
    ["TX COLUMBUS", "K66R", "66R", "None", "29.38N", "096.31W", "74", "US"],
    ["TX COMANCHE", "KMKN", "MKN", "None", "31.55N", "098.36W", "423", "US"],
    ["TX CONROE", "KCXO", "CXO", "None", "30.21N", "095.25W", "75", "US"],
    ["TX CORPUS CHRISTI", "KCRP", "CRP", "72251", "27.46N", "097.30W", "14", "US"],
    ["TX C. CHRISTI NAS", "KNGP", "NGP", "None", "27.41N", "097.16W", "6", "US"],
    ["TX CORSICANA", "KCRS", "CRS", "None", "32.02N", "096.24W", "133", "US"],
    ["TX COTULLA", "KCOT", "COT", "None", "28.27N", "099.13W", "140", "US"],
    ["TX CROCKETT", "KDKR", "DKR", "None", "31.18N", "095.24W", "106", "US"],
    ["TX DALHART", "KDHT", "DHT", "None", "36.01N", "102.33W", "1217", "US"],
    ["TX DALLAS/LOVE FLD", "KDAL", "DAL", "72258", "32.51N", "096.51W", "158", "US"],
    ["TX DALLAS/ARTCC", "KZFW", "ZFW", "None", "32.50N", "097.04W", "182", "US"],
    ["TX DALLAS/REDBIRD", "KRBD", "RBD", "None", "32.41N", "096.52W", "203", "US"],
    ["TX DALLAS NAS/HENSL", "KNBE", "NBE", "None", "32.43N", "096.58W", "150", "US"],
    ["TX DALLAS/ADDISON", "KADS", "ADS", "None", "32.58N", "096.49W", "196", "US"],
    ["TX DECATUR", "KLUD", "LUD", "None", "33.15N", "097.35W", "319", "US"],
    ["TX DEL RIO", "KDRT", "DRT", "72261", "29.22N", "100.55W", "313", "US"],
    ["TX DENTON", "KDTO", "DTO", "None", "33.12N", "097.12W", "196", "US"],
    ["TX DIMMIT", "KFTN", "FTN", "None", "28.13N", "100.01W", "236", "US"],
    ["TX DRYDEN", "K6R6", "6R6", "None", "30.03N", "102.13W", "701", "US"],
    ["TX DUMAS/MOORE CTY", "KDUX", "DUX", "None", "35.51N", "102.01W", "1129", "US"],
    ["TX DYESS AFB/ABILEN", "KDYS", "DYS", "69019", "32.25N", "099.50W", "545", "US"],
    ["TX EAGLE LAKE", "KELA", "ELA", "None", "29.36N", "096.19W", "57", "US"],
    ["TX EAGLE PASS", "K5T9", "5T9", "None", "28.51N", "100.31W", "270", "US"],
    ["TX EASTLAND", "KETN", "ETN", "None", "32.25N", "098.49W", "448", "US"],
    ["TX EDINBURG INTL", "KEBG", "EBG", "None", "26.27N", "098.08W", "24", "US"],
    ["TX EL PASO", "KELP", "ELP", "72270", "31.49N", "106.23W", "1197", "US"],
    ["TX FALFURRIAS", "KBKS", "BKS", "None", "27.12N", "098.07W", "34", "US"],
    ["TX FORT BLISS", "KBIF", "BIF", "None", "31.51N", "106.23W", "1203", "US"],
    ["TX FORT STOCKTON", "KFST", "FST", "None", "30.55N", "102.55W", "918", "US"],
    ["TX FORT WORTH", "KFTW", "FTW", "None", "32.50N", "097.22W", "214", "US"],
    ["TX FORT WORTH", "KFWD", "FWD", "72249", "32.49N", "097.17W", "196", "US"],
    ["TX FORT WORTH/RFC", "KFWR", "FWR", "None", "32.50N", "097.18W", "211", "US"],
    ["TX FORT WORTH/88D", "KFWS", "FWS", "None", "32.34N", "097.18W", "208", "US"],
    ["TX FORT WORTH NAS", "KNFW", "NFW", "None", "32.47N", "097.26W", "198", "US"],
    ["TX FREDERICKSBURG", "KT82", "T82", "None", "30.15N", "098.55W", "517", "US"],
    ["TX FT WORTH/ALLIANC", "KAFW", "AFW", "None", "32.58N", "097.19W", "233", "US"],
    ["TX FT HOOD/KILLEEN", "KHLR", "HLR", "72257", "31.08N", "097.43W", "283", "US"],
    ["TX GALVESTON", "KGLS", "GLS", "72242", "29.16N", "094.52W", "6", "US"],
    ["TX GAINESVILLE", "KGLE", "GLE", "None", "33.39N", "097.12W", "256", "US"],
    ["TX UVALDE/GARNER F", "KUVA", "UVA", "None", "29.13N", "099.45W", "287", "US"],
    ["TX GATESVILLE", "KGOP", "GOP", "None", "31.25N", "097.48W", "276", "US"],
    ["TX GEORGETOWN", "KGTU", "GTU", "None", "30.41N", "097.41W", "240", "US"],
    ["TX GIDDINGS-LEE", "KGYB", "GYB", "None", "30.10N", "096.59W", "148", "US"],
    ["TX GILMER MUNI", "KJXI", "JXI", "None", "32.42N", "094.57W", "127", "US"],
    ["TX GONZALES MUNI", "KT20", "T20", "None", "29.31N", "097.28W", "108", "US"],
    ["TX GRAHAM MUNI", "KRPH", "RPH", "None", "33.07N", "098.33W", "342", "US"],
    ["TX GRANBURY MUNI", "KGDJ", "GDJ", "None", "32.27N", "097.49W", "237", "US"],
    ["TX GRAND PRAIRIE", "KGPM", "GPM", "None", "32.42N", "097.03W", "180", "US"],
    ["TX GREENVILLE/MAJOR", "KGVT", "GVT", "None", "33.04N", "096.04W", "163", "US"],
    ["TX GUADALUPE PASS", "KGDP", "GDP", "72262", "31.50N", "104.49W", "1692", "US"],
    ["TX HAMILTON MUNI", "KMNZ", "MNZ", "None", "31.40N", "098.09W", "396", "US"],
    ["TX HARLINGEN", "KHRL", "HRL", "None", "26.14N", "097.39W", "10", "US"],
    ["TX HEARNE MUNI", "KLHB", "LHB", "None", "30.52N", "096.37W", "87", "US"],
    ["TX HEBBRONVILLE", "KHBV", "HBV", "None", "27.21N", "098.44W", "202", "US"],
    ["TX HENDERSON RUSK C", "KRFI", "RFI", "None", "32.09N", "094.51W", "135", "US"],
    ["TX HEREFORD MUNI", "KHRX", "HRX", "None", "34.52N", "102.20W", "1154", "US"],
    ["TX HILLSBORO", "KINJ", "INJ", "None", "32.05N", "097.06W", "209", "US"],
    ["TX HONDO", "KHDO", "HDO", "None", "29.22N", "099.10W", "282", "US"],
    ["TX HORSESHOE BAY", "KDZB", "DZB", "None", "30.32N", "098.22W", "334", "US"],
    ["TX HOUSTON/DW HOOKS", "KDWH", "DWH", "None", "30.04N", "095.33W", "46", "US"],
    ["TX HOUSTON/HOBBY", "KHOU", "HOU", "None", "29.38N", "095.17W", "36", "US"],
    ["TX HOUSTON", "KLVJ", "LVJ", "None", "29.31N", "095.15W", "12", "US"],
    ["TX HOUSTON EXEC", "KTME", "TME", "None", "29.48N", "095.54W", "51", "US"],
    ["TX HOUSTON/INTNL", "KIAH", "IAH", "72243", "30.00N", "095.22W", "36", "US"],
    ["TX HOUSTON/DICKINSN", "KHGX", "HGX", "None", "29.28N", "095.05W", "5", "US"],
    ["TX HOUSTON/ELLINGTO", "KEFD", "EFD", "None", "29.36N", "095.10W", "10", "US"],
    ["TX HOUSTON/SUGAR LA", "KSGR", "SGR", "None", "29.37N", "095.39W", "2", "US"],
    ["TX HOUSTON/ARTCC", "KZHU", "ZHU", "None", "29.39N", "095.17W", "34", "US"],
    ["TX HOUSTON/UNIV", "KMCJ", "MCJ", "None", "29.43N", "095.24W", "69", "US"],
    ["TX HOUSTON/SOUTHWST", "KAXH", "AXH", "None", "29.31N", "095.29W", "21", "US"],
    ["TX WEST HOUSTON", "KIWS", "IWS", "None", "29.49N", "095.40W", "34", "US"],
    ["TX INGLESIDE/TP MCC", "KTFP", "TFP", "None", "27.55N", "097.13W", "6", "US"],
    ["TX INGLESIDE/TP MCC", "KT43", "T43", "None", "27.55N", "097.13W", "6", "US"],
    ["TX JOHNSON SPACE C", "KWNJ", "None", "None", "29.38N", "095.17W", "36", "US"],
    ["TX HUNTSVILLE", "KUTS", "UTS", "None", "30.45N", "095.35W", "104", "US"],
    ["TX JACKSONVILLE", "KJSO", "JSO", "None", "31.52N", "095.13W", "206", "US"],
    ["TX JASPER", "KJAS", "JAS", "None", "30.53N", "094.02W", "65", "US"],
    ["TX JAYTON PROFILER", "None", "JTN", "74735", "33.00N", "100.58W", "707", "US"],
    ["TX JUNCTION", "KJCT", "JCT", "74740", "30.30N", "099.46W", "522", "US"],
    ["TX KELLY AFB", "KSKF", "SKF", "None", "29.22N", "098.34W", "210", "US"],
    ["TX GRAY/FT HOOD", "KGRK", "GRK", "None", "31.04N", "097.50W", "309", "US"],
    ["TX GRANGER KGRK 88D", "None", "None", "None", "30.43N", "097.24W", "164", "US"],
    ["TX KERRVILLE", "KERV", "ERV", "None", "29.59N", "099.05W", "510", "US"],
    ["TX KICKAPOO", "KCWC", "CWC", "None", "33.51N", "098.29W", "305", "US"],
    ["TX KILLEEN MUNI", "KILE", "ILE", "None", "31.04N", "097.40W", "258", "US"],
    ["TX KINGSVILLE NAS", "KNQI", "NQI", "None", "27.30N", "097.49W", "15", "US"],
    ["TX KINGSVILLE", "KIKG", "IKG", "None", "27.33N", "098.02W", "40", "US"],
    ["TX LA GRANGE", "K3T5", "3T5", "None", "29.54N", "096.57W", "99", "US"],
    ["TX LAGO VISTA", "KRYW", "RYW", "None", "30.30N", "097.58W", "376", "US"],
    ["TX LAMPASAS", "KLZZ", "LZZ", "None", "31.06N", "098.12W", "371", "US"],
    ["TX LANCASTER", "KLNC", "LNC", "None", "32.35N", "096.43W", "153", "US"],
    ["TX LAREDO", "KLRD", "LRD", "72252", "27.33N", "099.28W", "155", "US"],
    ["TX LAUGHLIN AFB", "KDLF", "DLF", "None", "29.22N", "100.46W", "330", "US"],
    ["TX LAUGHLIN AFB/88D", "KDFX", "DFX", "None", "29.16N", "100.17W", "345", "US"],
    ["TX LEDBETTER PROFIL", "None", "LDB", "72246", "30.05N", "096.47W", "122", "US"],
    ["TX LLANO", "KAQO", "AQO", "None", "30.47N", "098.40W", "336", "US"],
    ["TX LONGVIEW", "KGGG", "GGG", "72247", "32.23N", "094.43W", "107", "US"],
    ["TX LUBBOCK", "KLBB", "LBB", "72267", "33.40N", "101.49W", "993", "US"],
    ["TX LUBBOCK/WFO", "KLUB", "LUB", "None", "33.39N", "101.49W", "996", "US"],
    ["TX LUFKIN", "KLFK", "LFK", "None", "31.14N", "094.45W", "88", "US"],
    ["TX MARFA", "KMRF", "MRF", "72264", "30.22N", "104.01W", "1481", "US"],
    ["TX MARSHALL", "KASL", "ASL", "None", "32.31N", "094.18W", "109", "US"],
    ["TX MAVERICK (DFW)", "KTTT", "TTT", "None", "32.52N", "097.02W", "165", "US"],
    ["TX MC GREGOR", "KPWG", "PWG", "None", "31.28N", "097.19W", "180", "US"],
    ["TX MCALLEN", "KMFE", "MFE", "None", "26.11N", "098.15W", "38", "US"],
    ["TX MCKINNEY", "KTKI", "TKI", "None", "33.11N", "096.35W", "179", "US"],
    ["TX MESQUITE", "KHQZ", "HQZ", "None", "32.45N", "096.32W", "136", "US"],
    ["TX MEXIA LIMESTONE", "KLXY", "LXY", "None", "31.38N", "096.31W", "166", "US"],
    ["TX MIDLAND", "KMAF", "MAF", "72265", "31.57N", "102.12W", "874", "US"],
    ["TX MIDLAND AIRPARK", "KMDD", "MDD", "None", "32.02N", "102.06W", "854", "US"],
    ["TX MIDLOTHIAN/WAX", "KJWY", "JWY", "None", "32.27N", "096.55W", "217", "US"],
    ["TX MINEOLA/QUITMAN", "KJDD", "JDD", "None", "32.45N", "095.30W", "132", "US"],
    ["TX MINERAL WELLS", "KMWL", "MWL", "None", "32.47N", "098.04W", "284", "US"],
    ["TX MOUNT PLEASANT", "KOSA", "OSA", "None", "33.06N", "094.58W", "111", "US"],
    ["TX NACOGDOCHES", "KOCH", "OCH", "None", "31.34N", "094.43W", "108", "US"],
    ["TX NEW BRAUNFELS", "KBAZ", "BAZ", "None", "29.43N", "098.03W", "195", "US"],
    ["TX NEW BRAUNFEL 88D", "KEWX", "EWX", "None", "29.42N", "098.02W", "193", "US"],
    ["TX ODESSA", "KODO", "ODO", "None", "31.55N", "102.24W", "902", "US"],
    ["TX ORANGE GROVE", "KNOG", "NOG", "None", "27.54N", "098.03W", "78", "US"],
    ["TX ORANGE", "KORG", "ORG", "None", "30.04N", "093.48W", "4", "US"],
    ["TX OZONA", "KOZA", "OZA", "None", "30.44N", "101.12W", "726", "US"],
    ["TX PALACIOS", "KPSX", "PSX", "None", "28.43N", "096.15W", "5", "US"],
    ["TX PALESTINE PROFIL", "None", "PAT", "74750", "31.46N", "095.42W", "119", "US"],
    ["TX PALESTINE MUNI", "KPSN", "PSN", "None", "31.47N", "095.42W", "129", "US"],
    ["TX PAMPA", "KPPA", "PPA", "None", "35.37N", "101.00W", "989", "US"],
    ["TX PAMPA M VISTA R", "KBPC", "BPC", "None", "35.53N", "101.02W", "845", "US"],
    ["TX PARIS/COX FIELD", "KPRX", "PRX", "None", "33.37N", "095.27W", "167", "US"],
    ["TX PECOS CITY", "KPEQ", "PEQ", "None", "31.23N", "103.31W", "797", "US"],
    ["TX PERRYTON", "KPYX", "PYX", "None", "36.25N", "100.45W", "889", "US"],
    ["TX PHILLIPS OIL", "K25T", "25T", "None", "26.56N", "094.41W", "10", "US"],
    ["TX PLAINVIEW", "KPVW", "PVW", "None", "34.10N", "101.43W", "1028", "US"],
    ["TX PLEASANTON MUNI", "KPEZ", "PEZ", "None", "28.57N", "098.31W", "132", "US"],
    ["TX PORT ARANSAS", "KRAS", "RAS", "None", "27.49N", "097.05W", "2", "US"],
    ["TX PORT ISABEL", "KPIL", "PIL", "None", "26.10N", "097.20W", "5", "US"],
    ["TX PORT LAVACA", "KPKV", "None", "None", "28.39N", "096.41W", "9", "US"],
    ["TX PRESIDIO/LELY IN", "KPRS", "PRS", "None", "29.38N", "104.21W", "896", "US"],
    ["TX RANDOLPH AFB", "KRND", "RND", "None", "29.31N", "098.16W", "232", "US"],
    ["TX RANGER", "K6P9", "6P9", "None", "32.26N", "098.36W", "450", "US"],
    ["TX REESE AFB/LUBBOC", "KREE", "REE", "None", "33.36N", "102.02W", "1017", "US"],
    ["TX ROBSTOWN/NUECES", "KRBO", "RBO", "None", "27.47N", "097.41W", "24", "US"],
    ["TX ROCKPORT", "KRKP", "RKP", "None", "28.05N", "097.03W", "6", "US"],
    ["TX ROCKSPRINGS", "KECU", "ECU", "None", "29.57N", "100.10W", "725", "US"],
    ["TX ROCKWALL", "KF46", "F46", "None", "32.56N", "096.26W", "176", "US"],
    ["TX SABINE PASS", "KRPE", "RPE", "99426", "29.41N", "093.57W", "3", "US"],
    ["TX SAN ANGELO", "KSJT", "SJT", "72263", "31.22N", "100.30W", "576", "US"],
    ["TX S ANTONIO/STINSN", "KSSF", "SSF", "None", "29.20N", "098.28W", "176", "US"],
    ["TX SAN ANTONIO", "KSAT", "SAT", "72253", "29.32N", "098.28W", "243", "US"],
    ["TX S ANTONIO-BOERNE", "K5C1", "5C1", "None", "29.43N", "098.42W", "423", "US"],
    ["TX SAN MARCOS", "KHYI", "HYI", "None", "29.53N", "097.52W", "182", "US"],
    ["TX SAN MARCOS", "KT98", "T98", "None", "29.53N", "097.52W", "182", "US"],
    ["TX SANDERSON (RAMOS", "KP07", "P07", "74730", "30.10N", "102.25W", "865", "US"],
    ["TX SEMINOLE", "KGNC", "GNC", "None", "32.41N", "102.39W", "1010", "US"],
    ["TX SHACKELFORD/DYES", "KDYX", "DYX", "None", "32.32N", "099.15W", "462", "US"],
    ["TX SHERMAN/DENISON", "KGYI", "GYI", "None", "33.43N", "096.40W", "228", "US"],
    ["TX SNYDER/WINSTON", "KSNK", "SNK", "None", "32.42N", "100.57W", "741", "US"],
    ["TX SONORA", "KSOA", "SOA", "None", "30.35N", "100.39W", "652", "US"],
    ["TX SOUTH PADRE IS", "KSPL", "SPL", "None", "26.04N", "097.09W", "4", "US"],
    ["TX SPOFFORD", "KT70", "T70", "None", "29.07N", "100.28W", "306", "US"],
    ["TX STEPHENVILLE", "KSEP", "SEP", "72260", "32.13N", "098.10W", "402", "US"],
    ["TX SULPHUR SPRINGS", "KSLR", "SLR", "None", "33.10N", "095.37W", "149", "US"],
    ["TX SWEETWATER", "KSWW", "SWW", "None", "32.28N", "100.28W", "727", "US"],
    ["TX TEMPLE/MILLER", "KTPL", "TPL", "None", "31.08N", "097.24W", "208", "US"],
    ["TX TERRELL", "KTRL", "TRL", "None", "32.43N", "096.16W", "145", "US"],
    ["TX TEXICO (VOR)", "KTXO", "TXO", "None", "34.30N", "102.50W", "1353", "US"],
    ["TX TYLER", "KTYR", "TYR", "None", "32.22N", "095.24W", "165", "US"],
    ["TX VERNON WILBARGER", "KF05", "F05", "None", "34.14N", "099.17W", "386", "US"],
    ["TX VICTORIA", "KVCT", "VCT", "72255", "28.52N", "096.56W", "31", "US"],
    ["TX WACO", "KACT", "ACT", "72256", "31.37N", "097.14W", "151", "US"],
    ["TX WACO/TSTI", "KCNW", "CNW", "None", "31.38N", "097.04W", "156", "US"],
    ["TX WHARTON", "KARM", "ARM", "None", "29.15N", "096.09W", "31", "US"],
    ["TX WICHITA FALL", "KSPS", "SPS", "72351", "33.59N", "098.30W", "308", "US"],
    ["TX WINK", "KINK", "INK", "None", "31.47N", "103.12W", "855", "US"],
    ["TX WESLACO MIDVALLY", "KT65", "T65", "None", "26.11N", "097.58W", "21", "US"],
    ["TX ZAPATA", "KAPY", "APY", "None", "26.58N", "099.15W", "129", "US"],
    ["TX BRAZOS 133B OILP", "KBBF", "BBF", "None", "27.50N", "096.01W", "36", "US"],
    ["TX GALVESTON424 OIL", "KGVX", "GVX", "None", "28.35N", "094.59W", "39", "US"],
    ["TX H ISLAND376 OILP", "KHQI", "HQI", "None", "27.56N", "093.40W", "26", "US"],
    ["TX BRAZOS 451 OILP", "KBQX", "BQX", "None", "28.30N", "095.43W", "34", "US"],
    ["TX MUSTANG IS31 OIL", "KMIU", "MIU", "None", "27.17N", "096.44W", "36", "US"],
    ["TX MUSTANG A85A OIL", "KMZG", "MZG", "None", "27.44N", "096.11W", "29", "US"],
    ["TX W CAMERON 368A", "KCRH", "CRH", "None", "28.55N", "093.18W", "34", "US"],
    ["TX E BREAKS BOOMVNG", "KVAF", "VAF", "None", "27.21N", "094.38W", "46", "US"],
    ["TX ALAMINOS CANYON", "KHHV", "HHV", "None", "26.56N", "094.41W", "25", "US"],
    ["TX ARLINGTON", "KF54", "F54", "None", "32.40N", "097.06W", "185", "US"],
    ["TX AUSTIN/BERGSTROM", "KBSM", "BSM", "None", "30.11N", "097.41W", "172", "US"],
    ["TX BAY CITY", "K3R1", "3R1", "None", "28.58N", "095.52W", "14", "US"],
    ["TX BEEVILLE", "KNIR", "NIR", "None", "28.22N", "097.40W", "20", "US"],
    ["TX BIG SPRING", "KBGS", "BGS", "None", "32.13N", "101.31W", "781", "US"],
    ["TX BRIDGEPORT", "K1F9", "1F9", "None", "33.11N", "097.50W", "260", "US"],
    ["TX BURNET MUNICIPAL", "KT27", "T27", "None", "30.44N", "098.13W", "389", "US"],
    ["TX CARMEN", "KCRM", "CRM", "None", "36.36N", "098.37W", "200", "US"],
    ["TX CARSWELL", "KAWN", "AWN", "None", "32.47N", "097.26W", "198", "US"],
    ["TX CASTROVILLE MUNI", "KT89", "T89", "None", "29.21N", "098.51W", "235", "US"],
    ["TX CLARKSVILLE", "K7F6", "7F6", "None", "33.36N", "095.04W", "134", "US"],
    ["TX CLEBURNE", "KF18", "F18", "None", "32.21N", "097.26W", "260", "US"],
    ["TX COMANCHE", "K7F9", "7F9", "None", "31.55N", "098.36W", "423", "US"],
    ["TX CROCKETT", "KT56", "T56", "None", "31.18N", "095.24W", "106", "US"],
    ["TX EAST ADDITION", "K5R0", "5R0", "None", "28.13N", "093.45W", "26", "US"],
    ["TX EDINBURG", "K25R", "25R", "None", "26.27N", "098.08W", "24", "US"],
    ["TX FT WORTH/NAS", "KFWH", "FWH", "None", "32.47N", "097.26W", "198", "US"],
    ["TX FREEPORT", "K6T5", "6T5", "None", "28.59N", "095.19W", "2", "US"],
    ["TX GATESVILLE", "K05F", "05F", "None", "31.25N", "097.48W", "276", "US"],
    ["TX GEORGETOWN", "KT04", "T04", "None", "30.40N", "097.40W", "240", "US"],
    ["TX GIDDINGS-LEE", "K62H", "62H", "None", "30.10N", "096.59W", "148", "US"],
    ["TX GILMER MUNI", "K4F4", "4F4", "None", "32.42N", "094.57W", "127", "US"],
    ["TX GRANBURY MUNI", "KF55", "F55", "None", "32.27N", "097.49W", "237", "US"],
    ["TX HEARNE MUNI", "KT72", "T72", "None", "30.52N", "096.37W", "87", "US"],
    ["TX HENDERSON RUSK C", "KF12", "F12", "None", "32.09N", "094.51W", "135", "US"],
    ["TX HILLSBORO MUNI", "K5T5", "5T5", "None", "32.05N", "097.06W", "209", "US"],
    ["TX HOUSTON", "KT02", "T02", "None", "29.31N", "095.15W", "12", "US"],
    ["TX KICKAPOO", "KT47", "T47", "None", "33.51N", "098.29W", "305", "US"],
    ["TX LAGO VISTA", "K5R3", "5R3", "None", "30.30N", "097.58W", "376", "US"],
    ["TX LLANO", "K6R9", "6R9", "None", "30.47N", "098.40W", "336", "US"],
    ["TX MC GREGOR", "KF60", "F60", "None", "31.28N", "097.19W", "180", "US"],
    ["TX MINEOLA/QUITMAN", "K3T1", "3T1", "None", "32.45N", "095.30W", "132", "US"],
    ["TX NEW BRAUNFELS", "K3R5", "3R5", "None", "29.43N", "098.03W", "195", "US"],
    ["TX ODESSA", "KE02", "E02", "None", "31.55N", "102.24W", "902", "US"],
    ["TX PORT ARANSAS", "K2R8", "2R8", "None", "27.49N", "097.05W", "2", "US"],
    ["TX PORT ISABEL", "KT31", "T31", "None", "26.10N", "097.20W", "5", "US"],
    ["TX PORT ARANSAS", "None", "None", "99411", "27.49N", "097.57W", "5", "US"],
    ["TX PORT LAVACA", "KT97", "T97", "None", "28.39N", "096.41W", "9", "US"],
    ["TX PORT MANSFIELD", "KT05", "T05", "None", "26.34N", "097.26W", "3", "US"],
    ["TX PRESIDIO/LELY IN", "KT77", "T77", "None", "29.38N", "104.21W", "896", "US"],
    ["TX ROBSTOWN NUECES", "KT53", "T53", "None", "27.47N", "097.41W", "24", "US"],
    ["TX SABINE PASS", "K28T", "28T", "None", "29.42N", "093.57W", "5", "US"],
    ["TX SEMINOLE", "K31F", "31F", "None", "32.41N", "102.39W", "1010", "US"],
    ["TX SHAMROCK", "K2F1", "2F1", "None", "35.12N", "100.15W", "1000", "US"],
    ["TX SHEPPARD AFB", "KSHP", "SHP", "None", "33.58N", "098.28W", "314", "US"],
    ["TX SHERMAN/DENISON", "KF39", "F39", "None", "33.43N", "096.40W", "228", "US"],
    ["TX SONORA", "KE29", "E29", "None", "30.35N", "100.39W", "652", "US"],
    ["TX SOUTH BRAZOS", "KT46", "T46", "None", "28.01N", "095.52W", "31", "US"],
    ["TX WHARTON", "K5R5", "5R5", "None", "29.15N", "096.09W", "31", "US"],
    ["TX ZAPATA", "KT86", "T86", "None", "26.58N", "099.15W", "129", "US"],
    ["TX E BREAKS 165", "KEMK", "EMK", "None", "27.49N", "094.19W", "26", "US"],
    ["TX GUNNISON 668", "KGUL", "GUL", "None", "27.18N", "093.32W", "30", "US"],
    ["TX N PADRE 975", "KOPM", "OPM", "None", "26.50N", "096.56W", "25", "US"],
    ["TX FRIONA 2NE", "XFAS", "None", "None", "34.39N", "102.41W", "1222", "US"],
    ["TX DIMMITT 2NE", "XDMS", "None", "None", "34.34N", "102.18W", "1181", "US"],
    ["TX TULIA 2NE", "XTIS", "None", "None", "34.33N", "101.44W", "1060", "US"],
    ["TX SILVERTON 7E", "XSVS", "None", "None", "34.27N", "101.11W", "976", "US"],
    ["TX MULESHOE 2S", "XMUS", "None", "None", "34.12N", "102.45W", "1160", "US"],
    ["TX AMHERST 1NE", "XAMH", "None", "None", "34.01N", "102.24W", "1112", "US"],
    ["TX PLAINVIEW 1S", "XPVS", "None", "None", "34.11N", "101.42W", "1024", "US"],
    ["TX FLOYDADA 2NE", "XFLS", "None", "None", "34.00N", "101.20W", "969", "US"],
    ["TX ROARING S. 3N", "XRRS", "None", "None", "33.56N", "100.51W", "797", "US"],
    ["TX MORTON 1NE", "XMNS", "None", "None", "33.44N", "102.44W", "1144", "US"],
    ["TX LEVELLAND 4S", "XLDS", "None", "None", "33.32N", "102.22W", "1066", "US"],
    ["TX LUBBOCK 12W", "XREE", "None", "None", "33.37N", "102.04W", "1020", "US"],
    ["TX RALLS 1SE", "XRLS", "None", "None", "33.40N", "101.23W", "944", "US"],
    ["TX PLAINS 3N", "XPPS", "None", "None", "33.14N", "102.50W", "1131", "US"],
    ["TX BROWNFIELD 2S", "XBWS", "None", "None", "33.09N", "102.16W", "1010", "US"],
    ["TX TAHOKA 3NE", "XTAS", "None", "None", "33.12N", "101.47W", "946", "US"],
    ["TX POST 1NE", "XPTS", "None", "None", "33.12N", "101.22W", "792", "US"],
    ["TX SEMINOLE 2N", "XSMS", "None", "None", "32.44N", "102.38W", "1010", "US"],
    ["TX SLATON 2NE", "XSLS", "None", "None", "33.27N", "101.37W", "934", "US"],
    ["TX ABERNATHY 5NE", "XARS", "None", "None", "33.53N", "101.45W", "1016", "US"],
    ["TX OLTON 6S", "XONS", "None", "None", "34.06N", "102.07W", "1087", "US"],
    ["TX O'DONNELL 1N", "XOES", "None", "None", "32.59N", "101.50W", "931", "US"],
    ["TX SEAGRAVES 1SW", "XSGV", "None", "None", "32.56N", "102.34W", "1024", "US"],
    ["TX LAMESA 2SE", "XLES", "None", "None", "32.42N", "101.56W", "901", "US"],
    ["TX HART 3N", "XHRS", "None", "None", "34.25N", "102.06W", "1126", "US"],
    ["TX GAIL 2SE", "XGGS", "None", "None", "32.45N", "101.25W", "778", "US"],
    ["TX WHITE R LAKE 6NW", "XWVS", "None", "None", "33.32N", "101.10W", "824", "US"],
    ["TX GRAHAM 5SW", "XGHS", "None", "None", "33.05N", "101.31W", "869", "US"],
    ["TX SUNDOWN 8SW", "XSDS", "None", "None", "33.23N", "102.37W", "1105", "US"],
    ["TX ANTON 6S", "XAOS", "None", "None", "33.44N", "102.11W", "1038", "US"],
    ["TX FLUVANNA 3W", "XFVS", "None", "None", "32.54N", "101.12W", "825", "US"],
    ["TX SPUR 1W", "XSPR", "None", "None", "33.29N", "100.53W", "697", "US"],
    ["TX LUBBOCK 3W", "XLBW", "None", "None", "33.35N", "101.54W", "985", "US"],
    ["TX GUTHRIE 10W", "XPFS", "None", "None", "33.34N", "100.29W", "609", "US"],
    ["TX CLARENDON", "XCES", "None", "None", "34.55N", "100.56W", "864", "US"],
    ["TX PADUCA 10SW", "XPAD", "None", "None", "33.53N", "100.24W", "616", "US"],
    ["TX SNYDER 3E", "XSYS", "None", "None", "32.43N", "100.52W", "741", "US"],
    ["TX MEMPHIS 1NE", "XMES", "None", "None", "34.44N", "100.32W", "627", "US"],
    ["TX JAYTON 1S", "XJTS", "None", "None", "33.14N", "100.34W", "613", "US"],
    ["TX PAMPA 2E", "XPMS", "None", "None", "35.32N", "100.56W", "974", "US"],
    ["TX HEREFORD 2NW", "XHES", "None", "None", "34.50N", "102.25W", "1182", "US"],
    ["TX ASPERMONT 3NE", "XASR", "None", "None", "33.10N", "100.12W", "530", "US"],
    ["TX GOODLETT 3W", "XGDS", "None", "None", "34.21N", "099.56W", "501", "US"],
    ["TX MCLEAN 1E", "XMCS", "None", "None", "35.14N", "100.34W", "873", "US"],
    ["TX DENVER CITY 7W", "XDVS", "None", "None", "32.59N", "102.56W", "1113", "US"],
    ["TX LAKE ALAN HENRY", "XAHS", "None", "None", "33.05N", "101.03W", "705", "US"],
    ["TX WOLFFORTH 6SW", "XWOS", "None", "None", "33.25N", "102.03W", "1008", "US"],
    ["TX ANDREWS 2E", "XANS", "None", "None", "32.19N", "102.31W", "966", "US"],
    ["TX TURKEY 2WSW", "XTUR", "None", "None", "34.23N", "100.56W", "747", "US"],
    ["TX CHILDRESS 2NNE", "XCXS", "None", "None", "34.27N", "100.12W", "593", "US"],
    ["TX NORTHFIELD 1S", "XNOR", "None", "None", "34.16N", "100.36W", "637", "US"],
    ["TX SAN ANGELO 7NW", "XASU", "None", "None", "31.33N", "100.31W", "597", "US"],
    ["TX ST LAWRENCE 5SW", "XST1", "None", "None", "31.39N", "101.36W", "821", "US"],
    ["TX HASKELL 1NW", "XHA1", "None", "None", "33.10N", "099.45W", "488", "US"],
    ["TX WALL 1E", "XWA1", "None", "None", "31.22N", "100.17W", "572", "US"],
    ["TX SEYMOUR 3NW", "XSE1", "None", "None", "33.38N", "099.17W", "397", "US"],
    ["TX COMANCHE SPRGS", "X3RF", "None", "None", "33.59N", "099.57W", "501", "US"],
    ["TX KNOX CITY 3NW", "XKN1", "None", "None", "33.27N", "099.52W", "448", "US"],
    ["TX PINE SPRNGS GMNP", "XGU1", "None", "None", "31.53N", "104.49W", "1698", "US"],
    ["TX ODELL 4ENE", "XOD1", "None", "None", "34.22N", "099.21W", "418", "US"],
    ["TX COYANOSA 2N", "XCO1", "None", "None", "31.17N", "103.04W", "783", "US"],
    ["TX QUITAQUE 3NNW", "XQU1", "None", "None", "34.25N", "101.04W", "808", "US"],
    ["TX BIG LAKE 1WNW", "XBI1", "None", "None", "31.12N", "101.28W", "824", "US"],
    ["TX JUNCTION 1SSW", "XJU1", "None", "None", "30.28N", "099.47W", "525", "US"],
    ["TX WEINERT 2NNE", "XWE1", "None", "None", "33.21N", "099.40W", "458", "US"],
    ["TX CANADIAN 6E", "XCA1", "None", "None", "35.55N", "100.17W", "739", "US"],
    ["TX PALO DURO CANYN", "XPD1", "None", "None", "34.59N", "101.42W", "1055", "US"],
    ["TX BOOTLEG 11WNW", "XBO1", "None", "None", "34.53N", "102.59W", "1348", "US"],
    ["TX STERLING COUNTY", "XSC1", "None", "None", "31.50N", "101.03W", "718", "US"],
    ["TX CLAUDE 12SW", "XCL1", "None", "None", "34.59N", "101.30W", "1052", "US"],
    ["TX PERSIMMON GAP", "XPG1", "None", "None", "29.40N", "103.11W", "875", "US"],
    ["TX AMARILLO 7SSE", "XAM1", "None", "None", "35.07N", "101.48W", "1101", "US"],
    ["TX UMBARGER 3NNE", "XUM1", "None", "None", "34.59N", "102.05W", "1145", "US"],
    ["TX LOMAX 1SSE", "XLO1", "None", "None", "32.06N", "101.38W", "765", "US"],
    ["TX AMARILLO 9NNE", "XAM2", "None", "None", "35.20N", "101.48W", "1020", "US"],
    ["TX AIKEN 3WSW", "XAI1", "None", "None", "34.08N", "101.34W", "1012", "US"],
    ["TX MERTZON", "XME1", "None", "None", "31.18N", "100.49W", "663", "US"],
    ["TX SWEETWATER 11SW", "XSW1", "None", "None", "32.21N", "100.32W", "758", "US"],
    ["TX AMARILLO 15NNW", "XAM3", "None", "None", "35.25N", "101.56W", "1013", "US"],
    ["TX BOYS RANCH 1WSW", "XBY1", "None", "None", "35.32N", "102.16W", "977", "US"],
    ["TX FORT CHADBOURNE", "XCH1", "None", "None", "32.02N", "100.15W", "613", "US"],
    ["TX CLYDE 2WNW", "XCL2", "None", "None", "32.25N", "099.32W", "615", "US"],
    ["TX CROWELL 1E", "XCR1", "None", "None", "33.59N", "099.43W", "452", "US"],
    ["TX DELL CITY 1N", "XDC1", "None", "None", "31.57N", "105.12W", "1131", "US"],
    ["TX DOZIER 3W", "XDO1", "None", "None", "35.05N", "100.23W", "691", "US"],
    ["TX HESPERUS 4SSW", "XFL1", "None", "None", "37.14N", "108.03W", "2361", "US"],
    ["TX GOODNIGHT", "XGO1", "None", "None", "35.02N", "101.11W", "962", "US"],
    ["TX FORT LANCASTER", "XLA1", "None", "None", "30.40N", "101.41W", "648", "US"],
    ["TX FORT MCKAVETT", "XMC1", "None", "None", "32.21N", "100.32W", "664", "US"],
    ["TX MCCAMEY 1SSW", "XMC4", "None", "None", "31.07N", "102.14W", "742", "US"],
    ["TX MENARD 2NW", "XMD1", "None", "None", "30.56N", "099.49W", "587", "US"],
    ["TX NEW HOME", "XNH1", "None", "None", "33.20N", "101.55W", "989", "US"],
    ["TX PANHANDLE 1SSW", "XPA1", "None", "None", "35.20N", "101.23W", "1054", "US"],
    ["TX CANYON 16ESE", "XPD2", "None", "None", "34.56N", "101.38W", "865", "US"],
    ["TX SIERRA BLANCA", "XSB1", "None", "None", "31.10N", "105.21W", "1390", "US"],
    ["TX STAMFORD 5ESE", "XST2", "None", "None", "32.55N", "099.43W", "473", "US"],
    ["TX STINNETT 1NNW", "XST3", "None", "None", "35.51N", "101.27W", "1013", "US"],
    ["TX TARZAN 2WNW", "XTA1", "None", "None", "32.19N", "102.00W", "866", "US"],
    ["TX VIGO PARK", "XVP1", "None", "None", "34.39N", "101.30W", "1035", "US"],
    ["TX WELCH", "XWE2", "None", "None", "32.56N", "102.08W", "951", "US"],
    ["TX SNYDER 3SSW", "XWT1", "None", "None", "32.41N", "100.56W", "726", "US"],
    ["TX THROCKMORTON 1SW", "XTH1", "None", "None", "33.10N", "099.11W", "420", "US"],
    ["TX COLORADO CITY", "XCO2", "None", "None", "32.27N", "100.55W", "672", "US"],
    ["TX HAPPY", "XHA2", "None", "None", "34.45N", "101.51W", "1101", "US"],
    ["TX ADRIAN 6WSW", "XAD1", "None", "None", "35.15N", "102.46W", "1299", "US"],
    ["TX PALO DURO 4E", "XPD3", "None", "None", "34.49N", "101.07W", "790", "US"],
    ["TX EARTH 9WSW", "XEA1", "None", "None", "34.11N", "102.33W", "1144", "US"],
    ["TX RALLS 1SE", "XRAS", "None", "None", "33.40N", "101.23W", "944", "US"],
    ["UT SALT LAKE CITY", "KSLC", "SLC", "72572", "40.46N", "111.58W", "1286", "US"],
    ["UT BLANDING", "KBDG", "BDG", "72472", "37.35N", "109.29W", "1789", "US"],
    ["UT BONNEVILLE", "KBVL", "BVL", "None", "40.43N", "113.45W", "1286", "US"],
    ["UT BRIGHAM CITY", "KBMC", "BMC", "None", "41.33N", "112.04W", "1290", "US"],
    ["UT BRYCE CANYON", "KBCE", "BCE", "None", "37.42N", "112.09W", "2312", "US"],
    ["UT CEDAR CITY", "KCDC", "CDC", "None", "37.42N", "113.06W", "1714", "US"],
    ["UT CEDAR CITY/88D", "KICX", "ICX", "None", "37.35N", "112.52W", "3231", "US"],
    ["UT DELTA", "KDTA", "DTA", "72479", "39.18N", "112.30W", "1402", "US"],
    ["UT DUGWAY PRVG GROU", "KDPG", "DPG", "74003", "40.12N", "112.55W", "1326", "US"],
    ["UT EAGLE RANGE", "KU16", "U16", "72430", "41.03N", "113.04W", "1292", "US"],
    ["UT EAGLE RANGE", "None", "None", "69430", "41.03N", "113.04W", "1292", "US"],
    ["UT ELDER COUNTY/SLC", "KMTX", "MTX", "None", "41.16N", "112.27W", "1969", "US"],
    ["UT GREEN RIVER RANG", "KU28", "U28", "72477", "39.00N", "110.10W", "1241", "US"],
    ["UT HANKSVILLE", "KHVE", "HVE", "72473", "38.25N", "110.42W", "1350", "US"],
    ["UT HEBER/RUSS MCDON", "KHCR", "HCR", "None", "40.29N", "111.26W", "1718", "US"],
    ["UT HILL AFB/OGDEN", "KHIF", "HIF", "None", "41.07N", "111.58W", "1459", "US"],
    ["UT LOGAN", "KLGU", "LGU", "None", "41.47N", "111.51W", "1355", "US"],
    ["UT MILFORD", "KMLF", "MLF", "72475", "38.25N", "113.01W", "1534", "US"],
    ["UT MOAB", "KCNY", "CNY", "None", "38.46N", "109.45W", "1390", "US"],
    ["UT MYTON", "KMTU", "MTU", "None", "40.08N", "110.07W", "1625", "US"],
    ["UT OGDEN", "KOGD", "OGD", "72575", "41.12N", "112.01W", "1353", "US"],
    ["UT PRICE", "KPUC", "PUC", "72470", "39.37N", "110.45W", "2091", "US"],
    ["UT PROVO MUNI", "KPVU", "PVU", "None", "40.13N", "111.43W", "1369", "US"],
    ["UT RICHFIELD", "KRIF", "RIF", "None", "38.44N", "112.06W", "1616", "US"],
    ["UT ROOSEVELT", "K74V", "74V", "74420", "40.17N", "110.03W", "1578", "US"],
    ["UT SAINT GEORGE", "KSGU", "SGU", "None", "37.04N", "113.31W", "896", "US"],
    ["UT SAINT GEORGE", "KDXZ", "DXZ", "None", "37.05N", "113.36W", "896", "US"],
    ["UT SALT LAKE MUNI", "KU42", "U42", "None", "40.37N", "111.59W", "1402", "US"],
    ["UT SALT LAKE/ARTCC", "KZLC", "ZLC", "None", "40.46N", "111.57W", "1287", "US"],
    ["UT SLC RFC=KSLR", "None", "None", "None", "40.46N", "111.57W", "1287", "US"],
    ["UT TOOELE", "KT62", "T62", "None", "40.19N", "112.17W", "1628", "US"],
    ["UT TOOELE", "KTVY", "TVY", "None", "40.37N", "112.21W", "1317", "US"],
    ["UT VERNAL", "KVEL", "VEL", "None", "40.27N", "109.31W", "1604", "US"],
    ["UT WENDOVER (AUT)", "KENV", "ENV", "72581", "40.43N", "114.01W", "1292", "US"],
    ["UT BLANDING", "K4BL", "4BL", "None", "37.37N", "109.28W", "1840", "US"],
    ["UT BULLFROG(AWRS)", "KU17", "U17", "None", "37.30N", "110.42W", "1110", "US"],
    ["UT DELTA", "KU24", "U24", "None", "39.20N", "112.35W", "1414", "US"],
    ["UT HANKSVILLE", "K4HV", "4HV", "None", "38.22N", "110.43W", "1314", "US"],
    ["UT HEBER/RUSS MCDON", "K36U", "36U", "None", "40.29N", "111.26W", "1718", "US"],
    ["UT JOSEPH", "K7LI", "7LI", "None", "38.38N", "112.12W", "1829", "US"],
    ["UT ROOSEVELT", "KU67", "U67", "None", "40.17N", "109.58W", "1556", "US"],
    ["VA ROANOKE", "KROA", "ROA", "72411", "37.19N", "079.58W", "362", "US"],
    ["VA ABINGDON", "KVJI", "VJI", "None", "36.40N", "082.01W", "631", "US"],
    ["VA BLACKSBURG/VA T.", "KBCB", "BCB", "None", "37.13N", "080.25W", "650", "US"],
    ["VA BLACKSTONE ARMY", "KBKT", "BKT", "None", "37.04N", "077.57W", "134", "US"],
    ["VA BROOKNEAL", "K0V4", "0V4", "None", "37.09N", "079.01W", "182", "US"],
    ["VA BUMPASS", "K7W4", "7W4", "None", "37.58N", "077.45W", "107", "US"],
    ["VA CASSANOVA VOR", "KCSN", "CSN", "None", "38.38N", "077.52W", "148", "US"],
    ["VA CHARLOTTESVILLE", "KCHO", "CHO", "None", "38.08N", "078.27W", "192", "US"],
    ["VA CHASE CITY", "KCXE", "CXE", "None", "36.47N", "078.30W", "154", "US"],
    ["VA CHESAPEAKE", "KCPK", "CPK", "99402", "36.40N", "076.19W", "6", "US"],
    ["VA CLARKSVILLE", "KW63", "W63", "None", "36.36N", "078.34W", "128", "US"],
    ["VA CREWE", "KW81", "W81", "None", "37.11N", "078.06W", "127", "US"],
    ["VA CULPEPER", "KCJR", "CJR", "None", "38.32N", "077.52W", "97", "US"],
    ["VA DANVILLE", "KDAN", "DAN", "None", "36.34N", "079.20W", "175", "US"],
    ["VA DUBLIN/NEW RIV", "KPSK", "PSK", "None", "37.07N", "080.40W", "642", "US"],
    ["VA EMPORIA", "KEMV", "EMV", "None", "36.41N", "077.29W", "39", "US"],
    ["VA FARMVILLE", "KFVX", "FVX", "None", "37.21N", "078.25W", "125", "US"],
    ["VA FENTRESS NAVAL", "KNFE", "NFE", "None", "36.42N", "076.08W", "5", "US"],
    ["VA FORT BELVOIR/DAV", "KDAA", "DAA", "None", "38.43N", "077.10W", "21", "US"],
    ["VA FORT ROYAL", "KFRR", "FRR", "None", "38.55N", "078.15W", "215", "US"],
    ["VA FRANKLIN/J B ROS", "KFKN", "FKN", "None", "36.42N", "076.54W", "12", "US"],
    ["VA FREDERICKSB/SHAN", "KEZF", "EZF", "None", "38.16N", "077.27W", "26", "US"],
    ["VA FT EUSTIS/FELKER", "KFAF", "FAF", "None", "37.07N", "076.37W", "4", "US"],
    ["VA GORDONSVILLE", "KGVE", "GVE", "None", "38.09N", "078.10W", "138", "US"],
    ["VA HILLSVILLE/GALAX", "KHLX", "HLX", "None", "36.46N", "080.49W", "834", "US"],
    ["VA HOT SPRINGS/INGA", "KHSP", "HSP", "None", "37.57N", "079.49W", "1156", "US"],
    ["VA JONESVILLE", "K0VG", "0VG", "None", "36.39N", "083.13W", "430", "US"],
    ["VA KENBRIDGE", "KW31", "W31", "None", "36.58N", "078.11W", "161", "US"],
    ["VA LANGLEY AFB/HAMP", "KLFI", "LFI", "74598", "37.04N", "076.22W", "3", "US"],
    ["VA LAWRENCEVILLE", "KLVL", "LVL", "None", "36.46N", "077.48W", "100", "US"],
    ["VA LEESBURG/GODFREY", "KJYO", "JYO", "None", "39.04N", "077.34W", "119", "US"],
    ["VA LOUISA", "KLKU", "LKU", "None", "38.01N", "077.58W", "150", "US"],
    ["VA LURAY", "KLUA", "LUA", "None", "38.40N", "078.30W", "275", "US"],
    ["VA LYNCHBURG", "KLYH", "LYH", "72410", "37.19N", "079.12W", "295", "US"],
    ["VA MANASSAS MUNI", "KHEF", "HEF", "None", "38.43N", "077.31W", "59", "US"],
    ["VA MARION / WYTHEVI", "KMKJ", "MKJ", "None", "36.53N", "081.20W", "780", "US"],
    ["VA MARTINSVILLE", "KMTV", "MTV", "None", "36.38N", "080.01W", "287", "US"],
    ["VA MELFA/ACCOMACK", "KMFV", "MFV", "None", "37.38N", "075.46W", "15", "US"],
    ["VA NEW MARKET", "K8W2", "8W2", "None", "38.39N", "078.43W", "293", "US"],
    ["VA NEWPORT NEWS", "KPHF", "PHF", "None", "37.08N", "076.30W", "12", "US"],
    ["VA NORFOLK NAS/CHAM", "KNGU", "NGU", "None", "36.55N", "076.16W", "5", "US"],
    ["VA NORFOLK", "KORF", "ORF", "72308", "36.54N", "076.12W", "14", "US"],
    ["VA NORFOLK/WAKEFLD", "KAKQ", "AKQ", "None", "36.59N", "077.00W", "34", "US"],
    ["VA NORFOLK/HAMPTON", "KPVG", "PVG", "None", "36.47N", "076.27W", "7", "US"],
    ["VA OCEANA NAS/SOUCE", "KNTU", "NTU", "None", "36.49N", "076.01W", "7", "US"],
    ["VA ORANGE", "KOMH", "OMH", "None", "38.15N", "078.03W", "142", "US"],
    ["VA PETERSBURG", "KPTB", "PTB", "None", "37.10N", "077.31W", "59", "US"],
    ["VA QUANTICO MCAF", "KNYG", "NYG", "None", "38.30N", "077.17W", "4", "US"],
    ["VA QUINTON", "KW96", "W96", "None", "37.30N", "077.08W", "37", "US"],
    ["VA RICHMOND/HANOVER", "KOFP", "OFP", "None", "37.42N", "077.26W", "62", "US"],
    ["VA RICHMOND/CHESTER", "KFCI", "FCI", "None", "37.24N", "077.31W", "72", "US"],
    ["VA RICHMOND", "KRIC", "RIC", "72401", "37.31N", "077.19W", "50", "US"],
    ["VA ROANOKE/BLACKSBG", "KRNK", "RNK", "72318", "37.12N", "080.24W", "648", "US"],
    ["VA ROANOKE/FLOYD CY", "KFCX", "FCX", "None", "37.01N", "080.16W", "874", "US"],
    ["VA SALUDA", "KW75", "W75", "None", "37.36N", "076.27W", "10", "US"],
    ["VA SOUTH BOSTON", "KW78", "W78", "None", "36.43N", "078.51W", "128", "US"],
    ["VA SOUTH HILL/MECKL", "KAVC", "AVC", "None", "36.41N", "078.02W", "135", "US"],
    ["VA STAFFORD REGNL", "KRMN", "RMN", "None", "38.24N", "077.27W", "65", "US"],
    ["VA STAUNTON/SHENAND", "KSHD", "SHD", "None", "38.16N", "078.54W", "366", "US"],
    ["VA STERLING", "KLWX", "LWX", "None", "38.59N", "077.29W", "89", "US"],
    ["VA SUFFOLK", "KSFQ", "SFQ", "None", "36.41N", "076.36W", "22", "US"],
    ["VA RICHLANDS", "KJFZ", "JFZ", "None", "37.04N", "081.48W", "809", "US"],
    ["VA TAPPAHANNOCK", "KXSA", "XSA", "None", "37.52N", "076.54W", "42", "US"],
    ["VA WALLOPS ISLAND", "KWAL", "WAL", "72402", "37.56N", "075.28W", "14", "US"],
    ["VA WARRENTON", "KHWY", "HWY", "None", "38.35N", "077.43W", "103", "US"],
    ["VA WASH DC/DULLES", "KIAD", "IAD", "72403", "38.56N", "077.27W", "93", "US"],
    ["VA WAYNESBORO", "KW13", "W13", "None", "38.05N", "078.57W", "438", "US"],
    ["VA WEST POINT", "KFYJ", "FYJ", "None", "37.31N", "076.46W", "7", "US"],
    ["VA WILLIAMSBURG", "KJGG", "JGG", "None", "37.14N", "076.43W", "15", "US"],
    ["VA WINCHESTER RGNL", "KOKV", "OKV", "None", "39.08N", "078.09W", "222", "US"],
    ["VA WISE/LONESOME PI", "KLNP", "LNP", "None", "36.58N", "082.31W", "817", "US"],
    ["VA LURAY", "KW45", "W45", "None", "38.40N", "078.30W", "275", "US"],
    ["VA RICHLANDS", "K6V3", "6V3", "None", "37.04N", "081.48W", "809", "US"],
    ["VA VOLENS", "KVQN", "VQN", "None", "36.57N", "078.59W", "280", "US"],
    ["VA WARRENTON", "KW66", "W66", "None", "38.35N", "077.43W", "103", "US"],
    ["VA WILLIAMSBURG", "KW94", "W94", "None", "37.18N", "076.38W", "11", "US"],
    ["VT BENNINGTON", "KDDH", "DDH", "72516", "42.54N", "073.15W", "244", "US"],
    ["VT BURLINGTON", "KBTV", "BTV", "72617", "44.28N", "073.09W", "105", "US"],
    ["VT COLCHESTER/88D", "KCXX", "CXX", "None", "44.31N", "073.10W", "97", "US"],
    ["VT HIGHGATE", "KFSO", "FSO", "None", "44.56N", "073.06W", "70", "US"],
    ["VT LYNDONVILLE", "KCDA", "CDA", "None", "44.34N", "072.01W", "363", "US"],
    ["VT MIDDLEBURY", "K6B0", "6B0", "None", "43.59N", "073.06W", "149", "US"],
    ["VT MORRISVILLE", "KMVL", "MVL", "None", "44.32N", "072.37W", "234", "US"],
    ["VT MONTPELIER/BARRE", "KMPV", "MPV", "None", "44.12N", "072.34W", "343", "US"],
    ["VT NEWPORT STATE", "KEFK", "EFK", "72612", "44.53N", "072.14W", "284", "US"],
    ["VT RUTLAND STATE", "KRUT", "RUT", "None", "43.31N", "072.57W", "240", "US"],
    ["VT SPRINGFIELD", "KVSF", "VSF", "None", "43.21N", "072.31W", "175", "US"],
    ["VT ST. JOHNSBURY", "K1V4", "1V4", "72614", "44.25N", "072.01W", "210", "US"],
    ["VT BALL MOUNTAIN", "K8B3", "8B3", "None", "43.07N", "072.48W", "345", "US"],
    ["VT BENNINGTON", "K5B5", "5B5", "None", "42.53N", "073.15W", "244", "US"],
    ["VT CANAAN", "KVT1", "VT1", "None", "44.59N", "071.30W", "317", "US"],
    ["VT JAY PEAK", "KJAY", "JAY", "None", "44.56N", "072.32W", "572", "US"],
    ["VT LYNDONVILLE", "K6B8", "6B8", "None", "44.34N", "072.01W", "363", "US"],
    ["VT POWNAL", "KPOW", "POW", "None", "42.47N", "073.13W", "348", "US"],
    ["VT SOUTH LINCOLN", "KSOL", "SOL", "None", "44.04N", "072.58W", "616", "US"],
    ["VT WEST BURKE", "KVT2", "VT2", "None", "44.39N", "071.59W", "274", "US"],
    ["VT WEST DOVER", "KWDO", "WDO", "None", "42.56N", "072.51W", "527", "US"],
    ["VT WILMINGTON", "KMNW", "MNW", "74483", "42.52N", "072.07W", "482", "US"],
    ["WA ARLINGTON MUNI", "KAWO", "AWO", "None", "48.10N", "122.10W", "42", "US"],
    ["WA BELLINGHAM", "KBLI", "BLI", "None", "48.48N", "122.32W", "50", "US"],
    ["WA WHATCOM (BLI)", "KHUH", "HUH", "None", "48.57N", "122.35W", "26", "US"],
    ["WA BREMERTON NTNL", "KPWT", "PWT", "None", "47.30N", "122.45W", "147", "US"],
    ["WA BURLINGTON/MT V", "KBVS", "BVS", "74200", "48.28N", "122.25W", "43", "US"],
    ["WA CHEHALIS CENTRAL", "KCLS", "CLS", "None", "46.41N", "122.59W", "54", "US"],
    ["WA COLVILLE MUNICIP", "KCQV", "CQV", "None", "48.32N", "117.52W", "572", "US"],
    ["WA DEER PARK", "KDEW", "DEW", "72787", "47.58N", "117.26W", "674", "US"],
    ["WA EASTSOUND/ORCAS", "KORS", "ORS", "None", "48.42N", "122.55W", "9", "US"],
    ["WA ELLENSBURG", "KELN", "ELN", "None", "47.02N", "120.32W", "519", "US"],
    ["WA EPHRATA", "KEPH", "EPH", "None", "47.18N", "119.31W", "383", "US"],
    ["WA EVERETT", "KPAE", "PAE", "None", "47.55N", "122.17W", "180", "US"],
    ["WA FAIRCHILD AFB", "KSKA", "SKA", "None", "47.37N", "117.39W", "750", "US"],
    ["WA FORT LEWIS/GRAY", "KGRF", "GRF", "74207", "47.04N", "122.34W", "92", "US"],
    ["WA FRIDAY HARBOR", "KFHR", "FHR", "None", "48.31N", "123.02W", "32", "US"],
    ["WA GRAYS HARBOR", "KLGX", "LGX", "None", "47.07N", "124.06W", "103", "US"],
    ["WA HANFORD", "KHMS", "HMS", "72784", "46.34N", "119.35W", "223", "US"],
    ["WA HOQUIAM", "KHQM", "HQM", "None", "46.58N", "123.56W", "7", "US"],
    ["WA KELSO LONGVEIW", "KKLS", "KLS", "None", "46.07N", "122.54W", "5", "US"],
    ["WA MOSES LAKE", "KMWH", "MWH", "None", "47.12N", "119.19W", "362", "US"],
    ["WA OAK HARBOR AIRPA", "KOKH", "OKH", "72796", "48.15N", "122.40W", "59", "US"],
    ["WA OLYMPIA", "KOLM", "OLM", "72792", "46.58N", "122.54W", "58", "US"],
    ["WA OMAK", "KOMK", "OMK", "72789", "48.28N", "119.31W", "395", "US"],
    ["WA PASCO", "KPSC", "PSC", "None", "46.16N", "119.07W", "121", "US"],
    ["WA PORT ANGELES", "KCLM", "CLM", "None", "48.07N", "123.30W", "85", "US"],
    ["WA PORT TOWNSEND", "K0S9", "0S9", "None", "48.03N", "122.49W", "37", "US"],
    ["WA PULLMAN/MOSCOW", "KPUW", "PUW", "None", "46.45N", "117.07W", "773", "US"],
    ["WA PUYALLUP/THUN", "KPLU", "PLU", "None", "47.06N", "122.17W", "164", "US"],
    ["WA QUILLAYUTE", "KUIL", "UIL", "72797", "47.56N", "124.33W", "54", "US"],
    ["WA RENTON", "KRNT", "RNT", "None", "47.30N", "122.13W", "21", "US"],
    ["WA RICHLAND", "KRLD", "RLD", "None", "46.18N", "119.18W", "121", "US"],
    ["WA SEATTLE/BOEING", "KBFI", "BFI", "None", "47.33N", "122.19W", "4", "US"],
    ["WA SEATTLE/METRO", "KSEA", "SEA", "72793", "47.27N", "122.19W", "136", "US"],
    ["WA SEATTLE/WFO", "KSEW", "SEW", "None", "47.41N", "122.15W", "7", "US"],
    ["WA SEATTLE/ARTCC", "KZSE", "ZSE", "None", "47.17N", "122.11W", "99", "US"],
    ["WA SEATTLE/CAMANO I", "KATX", "ATX", "None", "48.12N", "122.30W", "151", "US"],
    ["WA SHELTON", "KSHN", "SHN", "None", "47.14N", "123.08W", "82", "US"],
    ["WA SPOKANE", "KOTX", "OTX", "72786", "47.41N", "117.38W", "727", "US"],
    ["WA SPOKANE/FELTS", "KSFF", "SFF", "None", "47.41N", "117.19W", "609", "US"],
    ["WA SPOKANE/METRO", "KGEG", "GEG", "72785", "47.37N", "117.32W", "735", "US"],
    ["WA STAMPEDE PASS", "KSMP", "SMP", "None", "47.17N", "121.20W", "1208", "US"],
    ["WA SUNNYSIDE", "K1S5", "1S5", "None", "46.20N", "119.58W", "234", "US"],
    ["WA TACOMA", "KTIW", "TIW", "None", "47.16N", "122.35W", "89", "US"],
    ["WA TACOMA/MC CHORD", "KTCM", "TCM", "74206", "47.07N", "122.28W", "98", "US"],
    ["WA TATOOSH/VOR", "KTOU", "TOU", "99430", "48.18N", "124.38W", "520", "US"],
    ["WA TOLEDO WINLOCK M", "KTDO", "TDO", "None", "46.28N", "122.47W", "113", "US"],
    ["WA VANCOUVER", "KVUO", "VUO", "None", "45.37N", "122.39W", "8", "US"],
    ["WA WALLA WALLA", "KALW", "ALW", "72788", "46.06N", "118.17W", "363", "US"],
    ["WA WENATCHEE", "KEAT", "EAT", "None", "47.24N", "120.12W", "377", "US"],
    ["WA WHIDBEY IS. NAS", "KNUW", "NUW", "69023", "48.21N", "122.39W", "14", "US"],
    ["WA YAKIMA", "KYKM", "YKM", "72781", "46.34N", "120.32W", "324", "US"],
    ["WA BURLINGTON/MT V", "K75S", "75S", "None", "48.28N", "122.25W", "43", "US"],
    ["WA COLVILLE", "K63S", "63S", "None", "48.32N", "117.52W", "571", "US"],
    ["WA DEER PARK", "K07S", "07S", "None", "47.58N", "117.26W", "668", "US"],
    ["WA DESTRUCTION ISL", "None", "None", "99407", "47.40N", "124.31W", "21", "US"],
    ["WA OAK HARBOR AIRPA", "K76S", "76S", "None", "48.15N", "122.40W", "59", "US"],
    ["WA PORT ANGELES CG", "KNOW", "NOW", "74201", "48.08N", "123.25W", "4", "US"],
    ["WA SMITH ISLAND", "None", "None", "99418", "48.19N", "122.10W", "15", "US"],
    ["WA PEARSON/VANCOUVR", "K60S", "60S", "None", "45.37N", "122.39W", "8", "US"],
    ["WA YAGABOND AAF", "K1YT", "None", "None", "46.40N", "120.27W", "438", "US"],
    ["WA WEST POINT (LS)", "None", "None", "99435", "47.40N", "122.34W", "3", "US"],
    ["WI ANTIGO/LANGLADE", "KAIG", "None", "None", "45.09N", "089.07W", "464", "US"],
    ["WI APPLETON/OUTAGAM", "KATW", "ATW", "None", "44.16N", "088.31W", "280", "US"],
    ["WI ASHWAUBENON", "KGRB", "GRB", "72645", "44.29N", "088.08W", "208", "US"],
    ["WI ASHLAND", "KASX", "ASX", "None", "46.33N", "090.55W", "251", "US"],
    ["WI BLACK RIVER FALL", "KBCK", "BCK", "None", "44.15N", "090.51W", "255", "US"],
    ["WI BLUE RIVER PROFI", "None", "BLR", "74357", "43.13N", "090.31W", "226", "US"],
    ["WI BOSCOBEL", "KOVS", "OVS", "None", "43.09N", "090.41W", "202", "US"],
    ["WI BURLINGTON", "KBUU", "BUU", "None", "42.41N", "088.18W", "237", "US"],
    ["WI CHETEK", "KY23", "Y23", "None", "45.18N", "091.38W", "322", "US"],
    ["WI CLINTONVILLE", "KCLI", "CLI", "None", "44.37N", "088.44W", "250", "US"],
    ["WI CUMBERLAND", "KUBE", "UBE", "None", "45.30N", "091.59W", "379", "US"],
    ["WI DELLS/BARABOO", "KDLL", "DLL", "None", "43.31N", "089.46W", "299", "US"],
    ["WI EAGLE RIVER", "KEGV", "EGV", "None", "45.56N", "089.16W", "500", "US"],
    ["WI EPHRAIM-GILBRALT", "K3D2", "3D2", "None", "45.08N", "087.11W", "233", "US"],
    ["WI EAU CLAIRE", "KEAU", "EAU", "None", "44.52N", "091.28W", "276", "US"],
    ["WI FOND DU LAC", "KFLD", "FLD", "None", "43.46N", "088.29W", "240", "US"],
    ["WI HAYWARD", "KHYR", "HYR", "None", "46.01N", "091.27W", "370", "US"],
    ["WI JANESVILLE/ROCK", "KJVL", "JVL", "None", "42.37N", "089.03W", "246", "US"],
    ["WI JUNEAU", "KUNU", "UNU", "None", "43.25N", "088.42W", "285", "US"],
    ["WI KENOSHA", "KENW", "ENW", "None", "42.36N", "087.56W", "219", "US"],
    ["WI LA CROSSE", "KLSE", "LSE", "72643", "43.53N", "091.15W", "199", "US"],
    ["WI LA CROSSE/88D", "KARX", "ARX", "None", "43.49N", "091.11W", "389", "US"],
    ["WI LA POINTE", "K4R5", "4R5", "None", "46.47N", "090.46W", "198", "US"],
    ["WI LADYSMITH/RUSK", "KRCX", "RCX", "None", "45.30N", "091.00W", "377", "US"],
    ["WI LAND O LAKES", "KLNL", "LNL", "None", "46.09N", "089.13W", "520", "US"],
    ["WI LONE ROCK", "KLNR", "LNR", "None", "43.13N", "090.11W", "217", "US"],
    ["WI MADISON", "KMSN", "MSN", "72641", "43.08N", "089.21W", "261", "US"],
    ["WI MANITOWAC MUNI", "KMTW", "MTW", "None", "44.07N", "087.40W", "198", "US"],
    ["WI MANITOWISH WATER", "KD25", "D25", "None", "46.07N", "089.53W", "491", "US"],
    ["WI MARSHFIELD", "KMFI", "MFI", "None", "44.38N", "090.11W", "379", "US"],
    ["WI MEDFORD", "KMDZ", "MDZ", "None", "45.06N", "090.18W", "448", "US"],
    ["WI MENOMONIE MUNI", "KLUM", "LUM", "None", "44.54N", "091.52W", "273", "US"],
    ["WI MERRILL", "KRRL", "RRL", "None", "45.12N", "089.43W", "401", "US"],
    ["WI MIDDLETON", "KC29", "C29", "None", "43.07N", "089.32W", "283", "US"],
    ["WI MILWAUKEE", "KMKE", "MKE", "None", "42.57N", "087.54W", "206", "US"],
    ["WI MILWAUKEE/DOUSMN", "KMKX", "MKX", "72640", "42.58N", "088.33W", "292", "US"],
    ["WI MILWAUKEE/LAWREN", "KMWC", "MWC", "None", "43.07N", "088.02W", "227", "US"],
    ["WI MILWAUKEE VOR", "KBAE", "BAE", "None", "43.07N", "088.17W", "206", "US"],
    ["WI MINERAL POINT", "KMRJ", "MRJ", "None", "42.53N", "090.14W", "359", "US"],
    ["WI MINOCQUA/WOODRUF", "KARV", "ARV", "None", "45.55N", "089.43W", "496", "US"],
    ["WI MONROE", "KEFT", "EFT", "None", "42.37N", "089.36W", "331", "US"],
    ["WI MOSINEE/CENTRAL", "KCWA", "CWA", "None", "44.47N", "089.40W", "389", "US"],
    ["WI NEW LISBON", "K82C", "82C", "None", "43.50N", "090.08W", "277", "US"],
    ["WI NEW RICHMOND MUN", "KRNH", "RNH", "None", "45.09N", "092.32W", "304", "US"],
    ["WI OCONTO", "KOCQ", "OCQ", "None", "44.52N", "087.55W", "183", "US"],
    ["WI OSCEOLA", "KOEO", "OEO", "None", "45.19N", "092.42W", "275", "US"],
    ["WI OSHKOSH", "KOSH", "OSH", "None", "43.58N", "088.33W", "248", "US"],
    ["WI PHILLIPS/PRICE", "KPBH", "PBH", "None", "45.42N", "090.24W", "449", "US"],
    ["WI PLATTEVILLE", "KPVB", "PVB", "None", "42.41N", "090.26W", "313", "US"],
    ["WI PRAIRIE DU CHIEN", "KPDC", "PDC", "None", "43.01N", "091.07W", "201", "US"],
    ["WI RACINE", "KRAC", "RAC", "None", "42.46N", "087.49W", "203", "US"],
    ["WI REEDSBURG", "KC35", "C35", "None", "43.32N", "089.59W", "276", "US"],
    ["WI RHINELANDER", "KRHI", "RHI", "None", "45.38N", "089.29W", "485", "US"],
    ["WI RICE LAKE", "KRPD", "RPD", "None", "45.25N", "091.46W", "338", "US"],
    ["WI SHAWANO MUNI", "KEZS", "EZS", "None", "44.47N", "088.34W", "248", "US"],
    ["WI SHEBOYGAN", "KSBM", "SBM", "99433", "43.47N", "087.51W", "232", "US"],
    ["WI SIREN", "KRZN", "RZN", "None", "45.49N", "092.22W", "301", "US"],
    ["WI SOLON SPRINGS", "KOLG", "OLG", "None", "46.19N", "091.49W", "336", "US"],
    ["WI SPARTA/MCCOY AAF", "KCMY", "CMY", "None", "43.58N", "090.44W", "256", "US"],
    ["WI STEVENS POINT", "KSTE", "STE", "None", "44.33N", "089.32W", "338", "US"],
    ["WI STURGEON BAY", "KSUE", "SUE", "None", "44.51N", "087.25W", "221", "US"],
    ["WI SUPERIOR", "KSUW", "SUW", "None", "46.41N", "092.06W", "206", "US"],
    ["WI TOMAHAWK REGNL", "KTKV", "TKV", "None", "45.28N", "089.49W", "453", "US"],
    ["WI VIROQUA MUNI", "KY51", "Y51", "None", "43.35N", "090.54W", "394", "US"],
    ["WI VOLK/CAMP DOUGLA", "KVOK", "VOK", "None", "43.55N", "090.16W", "277", "US"],
    ["WI WASHINGTON ISL", "K2P2", "2P2", "None", "45.23N", "086.55W", "200", "US"],
    ["WI WATERTOWN", "KRYV", "RYV", "None", "43.10N", "088.43W", "254", "US"],
    ["WI WAUKESHA CNTY", "KUES", "UES", "None", "43.03N", "088.15W", "278", "US"],
    ["WI WAUPACA", "KPCZ", "PCZ", "None", "44.20N", "089.01W", "252", "US"],
    ["WI WAUSAU", "KAUW", "AUW", "72646", "44.56N", "089.37W", "362", "US"],
    ["WI WAUTOMA", "KY50", "Y50", "None", "44.02N", "089.18W", "262", "US"],
    ["WI WEST BEND", "KETB", "ETB", "None", "43.25N", "088.08W", "270", "US"],
    ["WI WISCONSIN RAPIDS", "KISW", "ISW", "None", "44.22N", "089.50W", "307", "US"],
    ["WI BARABOO", "KC85", "C85", "None", "43.32N", "089.46W", "299", "US"],
    ["WI BURLINGTON", "KC52", "C52", "None", "42.41N", "088.18W", "237", "US"],
    ["WI DEVILS ISLAND", "None", "None", "99419", "47.04N", "090.16W", "192", "US"],
    ["WI MENOMONIE MUNI", "KW11", "W11", "None", "44.54N", "091.52W", "273", "US"],
    ["WI NEENAH", "KEEW", "EEW", "None", "44.13N", "088.33W", "275", "US"],
    ["WI PARK FALLS", "KPKF", "PKF", "72741", "45.56N", "090.27W", "469", "US"],
    ["WI RICE LAKE", "KRIE", "RIE", "None", "45.29N", "091.43W", "360", "US"],
    ["WI SHAWANO MUNI", "K3WO", "3WO", "None", "44.47N", "088.34W", "248", "US"],
    ["WI TOMAHAWK REGNL", "KT08", "T08", "None", "45.28N", "089.48W", "453", "US"],
    ["WV BECKLEY", "KBKW", "BKW", "72412", "37.48N", "081.07W", "764", "US"],
    ["WV BLUEFIELD", "KBLF", "BLF", "None", "37.18N", "081.12W", "873", "US"],
    ["WV BUCKHANNON", "KW22", "W22", "None", "39.00N", "080.16W", "499", "US"],
    ["WV CHARLESTON", "KCRW", "CRW", "72414", "38.23N", "081.35W", "309", "US"],
    ["WV CLARKSBURG", "KCKB", "CKB", "None", "39.18N", "080.13W", "360", "US"],
    ["WV ELKINS", "KEKN", "EKN", "72417", "38.53N", "079.51W", "603", "US"],
    ["WV HENDERSON", "KHNN", "HNN", "None", "38.45N", "082.01W", "262", "US"],
    ["WV HUNTINGTON", "KHTS", "HTS", "72425", "38.22N", "082.33W", "254", "US"],
    ["WV LEWISBURG/GREENB", "KLWB", "LWB", "None", "37.52N", "080.24W", "702", "US"],
    ["WV LOGAN", "K6L4", "6L4", "None", "37.51N", "081.55W", "508", "US"],
    ["WV MARTINSBURG", "KMRB", "MRB", "None", "39.24N", "077.59W", "164", "US"],
    ["WV MORGANTOWN", "KMGW", "MGW", "None", "39.39N", "079.55W", "378", "US"],
    ["WV PARKERSBURG", "KPKB", "PKB", "72427", "39.21N", "081.25W", "262", "US"],
    ["WV PT PLEASANT", "K3I2", "3I2", "None", "38.55N", "082.06W", "196", "US"],
    ["WV PETERSBURG", "KW99", "W99", "None", "39.00N", "079.09W", "293", "US"],
    ["WV PINEVILLE", "KI16", "I16", "None", "37.36N", "081.34W", "544", "US"],
    ["WV RUTHDALE/CHARLES", "KRLX", "RLX", "None", "38.19N", "081.43W", "329", "US"],
    ["WV SUTTON/BRAXTON", "K48I", "48I", "None", "38.41N", "080.39W", "397", "US"],
    ["WV WHEELING", "KHLG", "HLG", "None", "40.10N", "080.39W", "372", "US"],
    ["WV WHITE SULPHUR SP", "KSSU", "SSU", "None", "37.46N", "080.19W", "549", "US"],
    ["WY AFTON", "KAFO", "AFO", "None", "42.43N", "110.57W", "1897", "US"],
    ["WY ALPINE", "K46U", "46U", "None", "43.11N", "111.02W", "1721", "US"],
    ["WY BIG PINEY", "KBPI", "BPI", "72671", "42.35N", "110.06W", "2117", "US"],
    ["WY BOYSEN (VOR)", "KBOY", "BOY", "None", "43.28N", "108.18W", "2517", "US"],
    ["WY BOYSEN/THERMOPOL", "KTBX", "TBX", "None", "43.28N", "108.14W", "2225", "US"],
    ["WY BUFFALO", "KBYG", "BYG", "None", "44.23N", "106.43W", "1497", "US"],
    ["WY CASPER", "KCPR", "CPR", "72569", "42.54N", "106.28W", "1621", "US"],
    ["WY CASPER(VOR)", "KDDY", "DDY", "None", "43.05N", "106.17W", "1621", "US"],
    ["WY CHEYENNE", "KCYS", "CYS", "72564", "41.09N", "104.48W", "1868", "US"],
    ["WY COWLEY/LOVELL", "KU68", "U68", "None", "44.55N", "108.27W", "1248", "US"],
    ["WY WARREN AIR BASE", "KFEW", "FEW", "None", "41.08N", "104.52W", "1878", "US"],
    ["WY CODY", "KCOD", "COD", "72670", "44.31N", "109.01W", "1553", "US"],
    ["WY CRAZY WOMAN/VOR", "KCZI", "CZI", "None", "44.00N", "106.26W", "1550", "US"],
    ["WY DIXON", "KDWX", "DWX", "None", "41.02N", "107.30W", "1996", "US"],
    ["WY DOUGLAS", "KDGW", "DGW", "72568", "42.48N", "105.23W", "1499", "US"],
    ["WY DUBOIS MUNI", "KDUB", "DUB", "None", "43.33N", "109.31W", "2224", "US"],
    ["WY ELK MOUNTAIN", "KEHY", "EHY", "None", "41.44N", "106.28W", "2225", "US"],
    ["WY EVANSTON", "KEVW", "EVW", "None", "41.16N", "111.02W", "2177", "US"],
    ["WY FORT BRIDGER", "KFBR", "FBR", "None", "41.24N", "110.21W", "2144", "US"],
    ["WY GILLETTE", "KGCC", "GCC", "72665", "44.20N", "105.33W", "1320", "US"],
    ["WY GREYBULL", "KGEY", "GEY", "None", "44.31N", "108.05W", "1191", "US"],
    ["WY HULETT MUNI", "KW43", "W43", "None", "44.40N", "104.34W", "1300", "US"],
    ["WY JACKSON", "KJAC", "JAC", "None", "43.37N", "110.44W", "1961", "US"],
    ["WY KEMMERER", "KEMM", "EMM", "None", "41.49N", "110.33W", "2220", "US"],
    ["WY LANDER", "KLND", "LND", "72576", "42.49N", "108.44W", "1694", "US"],
    ["WY LARAMIE", "KLAR", "LAR", "None", "41.19N", "105.40W", "2216", "US"],
    ["WY LAVA MOUNTAIN", "KAJL", "None", "None", "43.40N", "110.02W", "3161", "US"],
    ["WY MEDICINE BOW PRO", "None", "MBW", "74431", "41.53N", "106.10W", "2300", "US"],
    ["WY NEWCASTLE MONDEL", "KECS", "ECS", "None", "43.53N", "104.19W", "1273", "US"],
    ["WY PINEDALE R WENZ", "KPNA", "PNA", "None", "42.48N", "109.48W", "2160", "US"],
    ["WY PINE BLUFFS MUNI", "K82V", "82V", "None", "41.09N", "104.08W", "1570", "US"],
    ["WY POWELL", "KPOY", "POY", "None", "44.52N", "108.48W", "1554", "US"],
    ["WY RAWLINS MUNICIPA", "KRWL", "RWL", "None", "41.47N", "107.12W", "2077", "US"],
    ["WY RIVERTON", "KRIW", "RIW", "72672", "43.04N", "108.28W", "1697", "US"],
    ["WY ROCK SPRINGS", "KRKS", "RKS", "72574", "41.36N", "109.04W", "2060", "US"],
    ["WY ROCK SPNGS(VOR)", "KOCS", "OCS", "None", "41.35N", "109.01W", "2060", "US"],
    ["WY SARATOGA", "KSAA", "SAA", "None", "41.27N", "106.50W", "2138", "US"],
    ["WY SHERIDAN", "KSHR", "SHR", "72666", "44.46N", "106.58W", "1202", "US"],
    ["WY SOUTH PASS", "KFWZ", "FWZ", "None", "42.31N", "108.47W", "2588", "US"],
    ["WY TEN SLEEP", "KJPD", "JPD", "None", "44.09N", "107.10W", "2741", "US"],
    ["WY THERMOPOLIS", "KHSG", "HSG", "None", "43.43N", "108.24W", "1492", "US"],
    ["WY TORRINGTON", "KTOR", "TOR", "None", "42.04N", "104.09W", "1277", "US"],
    ["WY WORLAND", "KWRL", "WRL", "None", "43.58N", "107.57W", "1271", "US"],
    ["WY YELLOWSTONE LAKE", "KP60", "P60", "None", "44.33N", "110.25W", "2388", "US"],
    ["WY DOUGLAS", "K4DG", "4DG", "None", "42.45N", "105.23W", "1477", "US"],
    ["WY MOORCROFT", "K81V", "81V", "None", "44.16N", "104.57W", "1301", "US"],
    ["WY BORDEAUX", "KBRX", "BRX", "None", "41.57N", "104.57W", "1524", "US"],
    ["WY CONTINENTAL DIV", "KCTD", "CTD", "None", "41.43N", "107.47W", "2146", "US"],
    ["WY VEDAUWOO", "KVDW", "VDW", "None", "41.09N", "105.24W", "2542", "US"],
    ["WY PUMPKIN VINE", "KPUM", "PUM", "None", "41.03N", "105.28W", "2420", "US"],
    ["WY ARLINGTON", "KARL", "None", "None", "41.36N", "106.13W", "2179", "US"],
    ["WY BITTERCREEK", "KBIT", "BIT", "None", "41.39N", "108.35W", "2160", "US"],
    ["WY CEMETERY SEPARA", "KCMS", "CMS", "None", "41.32N", "109.28W", "1949", "US"],
    ["WY FIRST DIVIDE", "KFIR", "FIR", "None", "41.18N", "110.46W", "2294", "US"],
    ["WY I-25 DIVIDE", "KIDV", "IDV", "None", "43.56N", "106.39W", "1531", "US"],
    ["WY 20 MILE HILL", "KTMH", "TMH", "None", "43.07N", "106.20W", "1743", "US"],
    ["WY DEAD HORSE", "KDHS", "DHS", "None", "44.13N", "106.06W", "1241", "US"],
    ["WY INYAN KARA", "KIKA", "IKA", "None", "44.18N", "104.38W", "1319", "US"],
    ["WY BELLE FOURCHE", "KBFU", "BFU", "None", "43.56N", "105.27W", "1422", "US"],
    ["WY WHITAKER", "KWTR", "WTR", "None", "41.25N", "104.52W", "1882", "US"],
    ["WY PATHFINDER HILL", "KPAT", "None", "None", "42.34N", "106.51W", "1912", "US"],
    ["WY BEAVER RIM", "KBVR", "BVR", "None", "42.35N", "108.17W", "2072", "US"],
    ["WY SIBLEY PEAK", "KSIB", "SIB", "None", "42.27N", "105.02W", "1500", "US"],
    ["WY PINEY CREEK", "KPIN", "PIN", "None", "44.34N", "106.49W", "1392", "US"],
    ["WY HILAND", "KHLD", "HLD", "None", "43.06N", "107.19W", "1846", "US"],
    ["WY DEER CREEK", "KDRC", "DRC", "None", "42.50N", "105.52W", "1543", "US"],
    ["WY SKYLINE", "KSKL", "SKL", "None", "41.07N", "106.34W", "2451", "US"],
    ["WY RIM / PINEDALE", "KRIM", "RIM", "None", "43.06N", "110.19W", "2294", "US"],
    ["WY SAGE / JUNCTION", "KSGE", "SGE", "None", "41.47N", "110.30W", "2354", "US"],
    ["WY GUNBARREL", "KGUN", "GUN", "None", "41.26N", "104.21W", "1695", "US"],
    ["WY CHIEF JOSEPH", "KCHJ", "CHJ", "None", "44.45N", "109.22W", "2512", "US"],
    ["WY SHUTE CREEK", "KSHC", "SHC", "None", "41.56N", "109.58W", "2043", "US"],
    ["WY MAMMOTH/YELLOWST", "KMMM", "MMM", "None", "44.59N", "110.42W", "1902", "US"],
    ["WY TOWER FALLS", "KTOW", "TOW", "None", "44.54N", "110.23W", "1800", "US"],
    ["WY MEETEETSE RIM", "KMTR", "None", "None", "44.16N", "108.52W", "1803", "US"],
    ["DC NWS HDQTRS", "KWBC", "WBC", "None", "38.51N", "076.56W", "50", "US"],
    ["DC WASHINGTON/NATL", "KDCA", "DCA", "72405", "38.51N", "077.02W", "18", "US"],
    ["DC WASHINGTON/ARTCC", "KZDC", "ZDC", "None", "39.06N", "077.33W", "20", "US"],
    ["AB ABEE AGDM", "CXAF", "None", "71285", "54.17N", "112.58W", "664", "CA"],
    ["AB ANDREW AGDM", "CXAG", "None", "71286", "53.55N", "112.17W", "625", "CA"],
    ["AB ATMORE AGDM", "CXAJ", "None", "71287", "54.46N", "112.49W", "574", "CA"],
    ["AB BANFF (MARS)", "CWZG", "WZG", "None", "51.12N", "115.32W", "1397", "CA"],
    ["AB BARNWELL AGDM", "CXBW", "None", "71346", "49.48N", "112.18W", "824", "CA"],
    ["AB BEAVERLODGE", "CWBM", "None", "71230", "55.12N", "119.24W", "745", "CA"],
    ["AB BODO AGDM", "CXBA", "None", "71214", "52.07N", "110.06W", "687", "CA"],
    ["AB BOW ISLAND", "CWXL", "WXL", "71231", "49.44N", "111.27W", "817", "CA"],
    ["AB BOW VALLEY", "CWXA", "WXA", "71232", "51.04N", "115.04W", "1298", "CA"],
    ["AB BROCKET AGDM", "CXBR", "None", "71341", "49.37N", "113.49W", "1073", "CA"],
    ["AB BROOKS (AUTOB)", "CWBO", "WBO", "71457", "50.32N", "111.50W", "747", "CA"],
    ["AB CALGARY INTNL AR", "CYYC", "YYC", "71877", "51.07N", "114.01W", "1084", "CA"],
    ["AB CALGARY INTL", "CPCI", "None", "71393", "51.07N", "114.01W", "1081", "CA"],
    ["AB CALGARY/SPRINGBA", "CYBW", "YBW", "71860", "51.06N", "114.22W", "1200", "CA"],
    ["AB CARDSTON (AUT)", "CWFJ", "WFJ", "71153", "49.12N", "113.16W", "1136", "CA"],
    ["AB CHAMPION AGDM", "CXCP", "None", "71217", "50.17N", "113.21W", "1006", "CA"],
    ["AB CLARESHOLM (AUTO", "CWDK", "WDK", "71234", "50.01N", "113.37W", "1012", "CA"],
    ["AB CLEARDALE AGDM", "CXCD", "None", "71221", "56.19N", "119.45W", "630", "CA"],
    ["AB COLD LAKE (CAN", "CYOD", "YOD", "71120", "54.24N", "110.17W", "544", "CA"],
    ["AB CONSORT AGDM", "CXCS", "None", "71223", "51.56N", "110.43W", "772", "CA"],
    ["AB CORONATION(AUT)", "CWCT", "WCT", "None", "52.04N", "111.28W", "791", "CA"],
    ["AB CROWSNEST", "CWRT", "WRT", "71236", "49.37N", "114.28W", "1303", "CA"],
    ["AB DAPP AGDM", "CXDP", "None", "71340", "54.19N", "113.57W", "614", "CA"],
    ["AB DEL BONITA AGDM", "CXDB", "None", "71224", "49.03N", "112.49W", "1310", "CA"],
    ["AB DRUMHELLER EAST", "CWDZ", "WDZ", "None", "51.25N", "112.40W", "678", "CA"],
    ["AB EDMONTON INTL AR", "CYEG", "YEG", "71123", "53.17N", "113.34W", "723", "CA"],
    ["AB EDMONTON INTL AR", "CXEG", "XEG", "71155", "53.18N", "113.36W", "715", "CA"],
    ["AB EDMONTON MUNI", "CXEC", "XEC", "71157", "53.34N", "113.31W", "671", "CA"],
    ["AB EDMONTON MUNICIP", "CYXD", "YXD", "71879", "53.34N", "113.31W", "671", "CA"],
    ["AB EDMONTON/NAMAO(M", "CYED", "YED", "71121", "53.40N", "113.28W", "688", "CA"],
    ["AB EDMONTON/STONY P", "CWSE", "WSE", "71119", "53.32N", "114.05W", "766", "CA"],
    ["AB EDMONTON/STONY P", "CZED", "ZED", "71126", "53.33N", "114.06W", "766", "CA"],
    ["AB EDMONTON/STONY P", "CXPS", "None", "None", "53.33N", "114.06W", "766", "CA"],
    ["AB EDMONTON/VILLENU", "CZVL", "None", "None", "53.40N", "113.51W", "686", "CA"],
    ["AB EDSON AIRPORT", "CYET", "YET", "71881", "53.34N", "116.28W", "925", "CA"],
    ["AB EDSON", "CZZJ", "None", "71156", "53.35N", "116.28W", "927", "CA"],
    ["AB ESTHER 1", "CWGY", "WGY", "71240", "51.40N", "110.12W", "707", "CA"],
    ["AB FAIRVIEW AGDM", "CXFR", "None", "71347", "56.05N", "118.26W", "655", "CA"],
    ["AB FOREMOST AGDM", "CXFM", "None", "71225", "49.29N", "111.29W", "881", "CA"],
    ["AB FORT CHIPEWYAN A", "CYPY", "YPY", "71933", "58.46N", "111.07W", "232", "CA"],
    ["AB FORT MCMURRAY AR", "CYMM", "YMM", "71932", "56.39N", "111.13W", "369", "CA"],
    ["AB FORT MCMURRAY AR", "CXMM", "XMM", "71585", "56.39N", "111.13W", "369", "CA"],
    ["AB FORT VERMILLION", "CXFV", "None", "None", "58.23N", "116.02W", "289", "CA"],
    ["AB GRANDE PRAIRE AR", "CYQU", "YQU", "71940", "55.11N", "118.53W", "669", "CA"],
    ["AB HIGH LEVEL AIRPO", "CYOJ", "YOJ", "71066", "58.37N", "117.10W", "338", "CA"],
    ["AB HIGH PRAIRIE AGD", "CXHP", "None", "71226", "55.24N", "116.29W", "602", "CA"],
    ["AB HIGHVALE", "CWHA", "WHA", "71241", "53.27N", "114.28W", "747", "CA"],
    ["AB HOLDEN AGDM", "CXHD", "None", "71227", "53.11N", "112.15W", "688", "CA"],
    ["AB HUSSAR AGDM", "CXHR", "None", "71344", "51.11N", "112.30W", "971", "CA"],
    ["AB JASPER WARDEN (A", "CWJW", "WJW", "71486", "52.56N", "118.02W", "1020", "CA"],
    ["AB KILLAM AGDM", "CXKM", "None", "71228", "52.49N", "111.51W", "675", "CA"],
    ["AB LAC LA BICHE (MA", "CWLB", "WLB", "71931", "54.46N", "112.01W", "567", "CA"],
    ["AB LETHBRIDGE VOR", "CYQL", "YQL", "71874", "49.38N", "112.48W", "929", "CA"],
    ["AB LLOYDMINSTER ARP", "CYLL", "YLL", "71871", "53.19N", "110.04W", "669", "CA"],
    ["AB MANNING AGDM", "CXMG", "None", "71229", "56.58N", "117.27W", "457", "CA"],
    ["AB MASINASIN AGDM", "CXMN", "None", "71345", "49.07N", "111.39W", "947", "CA"],
    ["AB MEDICINE HAT", "CYXH", "YXH", "71872", "50.01N", "110.43W", "716", "CA"],
    ["AB MEDICINE HAT", "CXMH", "None", "71026", "50.02N", "110.43W", "717", "CA"],
    ["AB MILK RIVER", "CWRY", "WRY", "71244", "49.07N", "112.02W", "1050", "CA"],
    ["AB MORRIN AGDM", "CXMO", "None", "71257", "51.40N", "112.41W", "836", "CA"],
    ["AB MUNDARE AGDM", "CZMU", "None", "71354", "53.34N", "112.18W", "683", "CA"],
    ["AB NORDEGG CS", "CXND", "None", "None", "52.28N", "116.05W", "1362", "CA"],
    ["AB OLDS AGDM", "CXOL", "None", "71258", "51.46N", "114.05W", "1046", "CA"],
    ["AB OLIVER AGDM", "CZOL", "None", "71351", "53.39N", "113.21W", "665", "CA"],
    ["AB OYEN AGDM", "CXOY", "None", "71342", "51.23N", "110.21W", "767", "CA"],
    ["AB ONEFOUR (AUTOB)", "CWOE", "WOE", "71116", "49.07N", "110.28W", "935", "CA"],
    ["AB PEACE RIVER AIRP", "CYPE", "YPE", "71068", "56.13N", "117.27W", "571", "CA"],
    ["AB PEORIA AGDM", "CXPA", "None", "71348", "55.37N", "118.18W", "621", "CA"],
    ["AB PINCHER CREEK(M", "CZPC", "ZPC", "71875", "49.31N", "114.00W", "1190", "CA"],
    ["AB POLLOCKVILLE AGD", "CXPL", "None", "71259", "51.08N", "111.42W", "750", "CA"],
    ["AB PRAIRIE RIVER", "CXPV", "XPV", "71593", "58.27N", "111.40W", "213", "CA"],
    ["AB PRENTISS", "CZPS", "None", "71353", "52.26N", "113.36W", "965", "CA"],
    ["AB PRIMROSE LAKE", "CWIQ", "WIQ", "71124", "54.45N", "110.02W", "702", "CA"],
    ["AB PRIMROSE LAKE 2", "CWOU", "WOU", "71127", "54.46N", "110.04W", "606", "CA"],
    ["AB RED DEER AIRPORT", "CYQF", "YQF", "71878", "52.10N", "113.54W", "905", "CA"],
    ["AB RICH LAKE AGDM", "CXRL", "None", "71349", "54.30N", "111.42W", "585", "CA"],
    ["AB ROCKY HOUSE (MAR", "CWRM", "WRM", "None", "52.25N", "114.55W", "988", "CA"],
    ["AB SCHULER AGDM", "CXSC", "None", "71269", "50.18N", "110.05W", "800", "CA"],
    ["AB SCHULER RADAR", "CXBU", "None", "None", "50.29N", "110.12W", "777", "CA"],
    ["AB SLAVE LAKE AIRPO", "CYZH", "YZH", "71069", "55.17N", "114.46W", "581", "CA"],
    ["AB SMOKY LAKE AGDM", "CXSL", "None", "71274", "54.17N", "112.30W", "680", "CA"],
    ["AB SPIRIT RIVER", "CXSR", "XSR", "71571", "55.42N", "119.14W", "1015", "CA"],
    ["AB STETTLER AGDM", "CXAK", "None", "71289", "52.21N", "112.36W", "795", "CA"],
    ["AB ST PAUL AGDM", "CXSP", "None", "71275", "54.01N", "111.16W", "649", "CA"],
    ["AB SUFFIELD AIRPORT", "CYSD", "YSD", "71128", "50.16N", "111.10W", "770", "CA"],
    ["AB SUNDRE", "CWAV", "WAV", "71248", "51.46N", "114.40W", "1114", "CA"],
    ["AB THREE HILLS", "CWHI", "WHI", "71249", "51.42N", "113.13W", "907", "CA"],
    ["AB TURTLE MTN CS", "CWQA", "None", "71250", "49.35N", "114.25W", "2164", "CA"],
    ["AB TWO HILLS AGDM", "CXTH", "None", "71276", "53.38N", "111.41W", "678", "CA"],
    ["AB VALLEYVIEW AGDM", "CXVW", "None", "None", "55.06N", "117.12W", "698", "CA"],
    ["AB VEGREVILLE (AUTO", "CWVI", "None", "71458", "53.31N", "112.06W", "639", "CA"],
    ["AB VERMILION AGDM", "CXVM", "None", "None", "53.21N", "110.53W", "623", "CA"],
    ["AB VILNA AG", "CPVI", "None", "71761", "54.08N", "111.55W", "645", "CA"],
    ["AB WATERTON PARK GA", "CWGM", "WGM", "71154", "49.08N", "113.47W", "1296", "CA"],
    ["AB WHITECOURT AIRPO", "CYZU", "YZU", "71930", "54.09N", "115.47W", "785", "CA"],
    ["AB WHITECOURT AIRPO", "CXZU", "XZU", "71256", "54.09N", "115.47W", "785", "CA"],
    ["AB WRENTHAN AGDM", "CXWM", "None", "71343", "49.30N", "112.07W", "944", "CA"],
    ["AB YOHO PARK (AUTOB", "CWYL", "WYL", "71786", "51.27N", "116.19W", "1615", "CA"],
    ["AB BLOOD TRIBE AGDM", "CPBT", "None", "71517", "49.34N", "113.03W", "980", "CA"],
    ["AB ENCHANT AGDM", "CPEH", "None", "71518", "50.11N", "112.26W", "801", "CA"],
    ["AB FINCASTLE AGDM", "CPFI", "None", "71535", "49.48N", "112.02W", "833", "CA"],
    ["AB IRON SPRINGS", "CPIR", "None", "71528", "49.54N", "112.44W", "858", "CA"],
    ["AB LETHBRIDGE DEMO", "CPQL", "None", "71509", "49.41N", "112.45W", "903", "CA"],
    ["AB ROSEMARY AGDM", "CPRO", "None", "71537", "50.50N", "112.03W", "714", "CA"],
    ["AB RAYMOND AGDM", "CPRY", "None", "71536", "49.29N", "112.41W", "937", "CA"],
    ["AB STRATHMORE AGDM", "CPST", "None", "71526", "51.02N", "113.17W", "967", "CA"],
    ["AB SEVEN PERSONS", "CPSV", "None", "71525", "49.55N", "110.55W", "766", "CA"],
    ["AB BOW ISLAND AGDM", "CPXL", "None", "71519", "49.52N", "111.23W", "799", "CA"],
    ["AB BANFF (CWBA-old)", "None", "None", "71122", "51.10N", "115.34W", "1383", "CA"],
    ["BC ABBOTSFORD AIRPO", "CYXX", "YXX", "71108", "49.02N", "122.23W", "58", "CA"],
    ["BC ADDENBROKE ISL (", "CWCZ", "WCZ", "None", "51.36N", "127.52W", "21", "CA"],
    ["BC AGASSIZ (AUTO)", "CWZA", "WZA", "71113", "49.15N", "121.46W", "15", "CA"],
    ["BC AMPHITRITE POINT", "CWAN", "WAN", "71112", "48.55N", "125.32W", "27", "CA"],
    ["BC ASHCROFT", "CVAS", "None", "71681", "50.43N", "121.17W", "327", "CA"],
    ["BC BALLENAS IL AUTO", "CWGB", "WGB", "71769", "49.21N", "124.10W", "5", "CA"],
    ["BC BELLA COOLA ARPT", "CYBD", "YBD", "71206", "52.22N", "126.34W", "35", "CA"],
    ["BC BELLA BELLA", "CBBC", "None", "None", "52.11N", "128.09W", "43", "CA"],
    ["BC BIG CREEK(AUTO)", "CWBG", "WBG", "None", "51.15N", "123.04W", "1670", "CA"],
    ["BC BLEIBLER RANCH", "CYIN", "None", "None", "51.16N", "121.41W", "1128", "CA"],
    ["BC BLUE RIVER (MAN)", "CYCP", "YCP", "71883", "52.08N", "119.17W", "683", "CA"],
    ["BC BLUE RIVER (MARS", "CWSV", "WSV", "None", "52.06N", "119.17W", "683", "CA"],
    ["BC BOAT BLUFF (LGT", "CWZM", "WZM", "None", "52.39N", "128.31W", "15", "CA"],
    ["BC BONILLA ISL (MAP", "CWWL", "WWL", "71484", "53.30N", "130.38W", "17", "CA"],
    ["BC BONILLA ISLAND (", "CWVB", "WVB", "None", "53.30N", "130.38W", "16", "CA"],
    ["BC BURNS LAKE", "CWPZ", "WPZ", "71952", "54.23N", "125.58W", "713", "CA"],
    ["BC CAMPBELL RIVER A", "CYBL", "YBL", "None", "49.57N", "125.16W", "106", "CA"],
    ["BC CAPE MUDGE (LGT", "CWAD", "WAD", "None", "50.00N", "125.12W", "4", "CA"],
    ["BC CAPE SCOTT (LGT", "CWES", "WES", "71111", "50.46N", "128.25W", "72", "CA"],
    ["BC CAPE ST JAMES", "CWZV", "WZV", "71107", "51.56N", "131.01W", "92", "CA"],
    ["BC CASTLEGAR AIRPOR", "CYCG", "YCG", "71884", "49.17N", "117.37W", "495", "CA"],
    ["BC CATHEDRAL PT(MAP", "CWME", "WME", "71482", "52.11N", "127.28W", "32", "CA"],
    ["BC CHATHAM POINT (L", "CWFM", "WFM", "None", "50.20N", "125.27W", "23", "CA"],
    ["BC CHETWYND AIRPORT", "CYCQ", "YCQ", "None", "55.42N", "121.37W", "609", "CA"],
    ["BC CLINTON (MARS)", "CWCL", "WCL", "71474", "51.08N", "121.30W", "1057", "CA"],
    ["BC COMOX (CAN MIL)", "CYQQ", "YQQ", "71893", "49.43N", "124.54W", "24", "CA"],
    ["BC CRANBROOK", "CYXC", "YXC", "71880", "49.36N", "115.46W", "939", "CA"],
    ["BC CRESTON (AUTOB)", "CWJR", "WJR", "71770", "49.04N", "116.30W", "646", "CA"],
    ["BC CUMSHEWA ISL (MA", "CWZL", "WZL", "None", "53.02N", "131.36W", "17", "CA"],
    ["BC DAWSON CREEK ARP", "CYDQ", "YDQ", "None", "55.45N", "120.10W", "655", "CA"],
    ["BC DEASE LAKE", "CWDL", "None", "71958", "58.26N", "130.01W", "816", "CA"],
    ["BC DEASE LAKE", "CYDL", "None", "None", "58.25N", "130.01W", "816", "CA"],
    ["BC DEASE LAKE CS", "CWKX", "WKX", "71222", "58.26N", "130.01W", "793", "CA"],
    ["BC DISCOVERY ISLAND", "CWDR", "None", "71031", "48.25N", "123.14W", "17", "CA"],
    ["BC DRYAD POINT (LGT", "CWAU", "WAU", "None", "52.11N", "128.07W", "4", "CA"],
    ["BC EGG ISLAND", "CWEM", "WEM", "None", "51.15N", "127.50W", "14", "CA"],
    ["BC ENTRANCE IL AUTO", "CWEL", "WEL", "71772", "49.13N", "123.47W", "5", "CA"],
    ["BC ESQUIMALT METOC", "CWPF", "WPF", "None", "48.26N", "123.26W", "12", "CA"],
    ["BC ESTEVAN PT. (MAR", "CWEB", "WEB", "71894", "49.23N", "126.33W", "7", "CA"],
    ["BC FANNY ISLAND", "CXFA", "None", "71568", "50.27N", "126.00W", "5", "CA"],
    ["BC FORT NELSON AIRP", "CYYE", "YYE", "71945", "58.49N", "122.34W", "382", "CA"],
    ["BC FORT ST. JOHN AR", "CYXJ", "YXJ", "71943", "56.15N", "120.44W", "695", "CA"],
    ["BC GOLDEN ARPT", "CYGE", "YGE", "None", "51.18N", "116.59W", "785", "CA"],
    ["BC GREEN ISLAND (MT", "CWNJ", "None", "None", "54.34N", "130.42W", "12", "CA"],
    ["BC GREY ISLET (MAPS", "CWEK", "WEK", "71476", "54.35N", "130.42W", "8", "CA"],
    ["BC HELMCKEN ISL(MAP", "CWXM", "WXM", "71481", "50.23N", "125.52W", "19", "CA"],
    ["BC HERBERT ISL (MAP", "CWLP", "WLP", "71485", "50.56N", "127.38W", "17", "CA"],
    ["BC HOLBERG CCR", "CWXH", "WXH", "71562", "50.38N", "128.08W", "568", "CA"],
    ["BC HOLLAND ROCK(AUT", "CWHL", "WHL", "71440", "54.10N", "130.21W", "5", "CA"],
    ["BC HOPE AIRPORT (MA", "CYHE", "YHE", "71114", "49.22N", "121.30W", "39", "CA"],
    ["BC HOPE SLIDE", "CWKV", "WKV", "None", "49.16N", "121.13W", "674", "CA"],
    ["BC HORSEFLY R.71761", "CWFR", "WFR", "None", "52.16N", "121.02W", "846", "CA"],
    ["BC HOSKINS ISLET", "CWZK", "None", "71773", "52.32N", "131.33W", "8", "CA"],
    ["BC ISKUT RIVER(AUTO", "CWIO", "WIO", "None", "56.43N", "131.40W", "15", "CA"],
    ["BC IVORY ISLAND", "CWJG", "WJG", "None", "52.16N", "128.25W", "10", "CA"],
    ["BC KAMLOOPS AIRPORT", "CYKA", "YKA", "71887", "50.42N", "120.27W", "346", "CA"],
    ["BC KAMLOOPS", "CZKA", "None", "None", "50.42N", "120.26W", "345", "CA"],
    ["BC KELOWNA APT", "CYLW", "YLW", "71203", "49.57N", "119.22W", "430", "CA"],
    ["BC KELP REEFS 71036", "CWZO", "WZO", "None", "48.33N", "123.14W", "1", "CA"],
    ["BC KINDAKUN ROCKS(A", "CWQS", "WQS", "71472", "53.19N", "132.46W", "14", "CA"],
    ["BC LANGARA", "CWJU", "WJU", "71903", "54.15N", "133.04W", "41", "CA"],
    ["BC LANGARA", "CWLA", "WLA", "71899", "54.15N", "133.04W", "41", "CA"],
    ["BC LUCY ISL (LGT H)", "CWLC", "WLC", "None", "54.18N", "130.37W", "27", "CA"],
    ["BC LYTTON (READAC)", "CWLY", "WLY", "71891", "50.13N", "121.35W", "229", "CA"],
    ["BC MACKENZIE AIRPOR", "CYZY", "YZY", "71944", "55.17N", "123.07W", "690", "CA"],
    ["BC MALAHAT (AUTOB)", "CWKH", "WKH", "71774", "48.34N", "123.33W", "366", "CA"],
    ["BC MASSET", "CZMT", "None", "None", "54.02N", "132.08W", "8", "CA"],
    ["BC MCINNES ISLAND", "CWMS", "WMS", "71897", "52.16N", "128.43W", "26", "CA"],
    ["BC MERRY ISLAND", "CWMR", "WMR", "None", "49.28N", "123.55W", "8", "CA"],
    ["BC MT SICKER RADAR", "CXSI", "None", "None", "48.52N", "123.45W", "1", "CA"],
    ["BC MUNCHO LAKE", "CWWQ", "WWQ", "None", "58.56N", "125.46W", "837", "CA"],
    ["BC NAKUSP (AUTOB)", "CWNP", "WNP", "71216", "50.16N", "117.49W", "524", "CA"],
    ["BC NANAIMO AIRPORT", "CYCD", "YCD", "71890", "49.03N", "123.52W", "30", "CA"],
    ["BC NECHAKO RIVER AU", "CWNX", "WNX", "None", "53.40N", "124.49W", "715", "CA"],
    ["BC NELSON (AUTOB)", "CWNM", "WNM", "71776", "49.30N", "117.17W", "535", "CA"],
    ["BC NITINAT LAKE (MA", "CWAC", "WAC", "71483", "48.40N", "124.50W", "41", "CA"],
    ["BC NOOTKA LIGHTSTAT", "CWCV", "WCV", "None", "49.36N", "126.37W", "16", "CA"],
    ["BC OSOYOOS (AUTOB)", "CWYY", "WYY", "71215", "49.02N", "119.26W", "283", "CA"],
    ["BC P. MEADOWS CS AU", "CWMM", "WMM", "71775", "49.13N", "122.41W", "5", "CA"],
    ["BC PEMBERTON (AUTOB", "CWGP", "WGP", "71777", "50.18N", "122.44W", "204", "CA"],
    ["BC PEMBERTON (AUTOB", "CYPS", "WGE", "None", "50.18N", "122.44W", "204", "CA"],
    ["BC PENTICTON AIRPOR", "CYYF", "YYF", "71889", "49.28N", "119.35W", "344", "CA"],
    ["BC PINE ISLAND (MAP", "CWPI", "WPI", "71105", "50.59N", "127.44W", "9", "CA"],
    ["BC PORT ALBERNI (MA", "CWQC", "WQC", "71475", "49.19N", "124.56W", "53", "CA"],
    ["BC PORT HARDY AIRPO", "CYZT", "YZT", "71109", "50.40N", "127.22W", "22", "CA"],
    ["BC POWELL RIVER ARP", "CYPW", "YPW", "71208", "49.49N", "124.30W", "130", "CA"],
    ["BC PRINCE GEORGE", "CYXS", "YXS", "71908", "53.54N", "122.41W", "691", "CA"],
    ["BC PRINCE GEORGE", "CXPG", "None", "None", "53.37N", "122.57W", "1101", "CA"],
    ["BC PRINCE RUPERT AR", "CYPR", "YPR", "71898", "54.17N", "130.25W", "34", "CA"],
    ["BC PRINCETON", "CWPR", "WPR", "71032", "49.28N", "120.31W", "700", "CA"],
    ["BC PRINCETON", "CYDC", "YDC", "71886", "49.28N", "120.31W", "700", "CA"],
    ["BC PUNTZI MTN (MARS", "CWPU", "WPU", "71050", "52.07N", "124.07W", "910", "CA"],
    ["BC QUATSINO (LGT ST", "CWIF", "WIF", "None", "50.26N", "128.02W", "21", "CA"],
    ["BC QUESNEL AIRPORT", "CYQZ", "YQZ", "71103", "53.01N", "122.31W", "545", "CA"],
    ["BC RACE ROCKS AUTOB", "CWQK", "WQK", "71778", "48.18N", "123.32W", "5", "CA"],
    ["BC REVELSTOKE AIRPO", "CYRV", "YRV", "71882", "50.58N", "118.10W", "443", "CA"],
    ["BC ROSE SPIT (MAPS)", "CWRO", "WRO", "71477", "54.10N", "131.40W", "7", "CA"],
    ["BC SALMON ARM AUTOB", "CWSL", "WSL", "71218", "50.42N", "119.16W", "351", "CA"],
    ["BC SAND HEADS (LS)", "CWVF", "WVF", "None", "49.06N", "123.18W", "1", "CA"],
    ["BC SANDSPIT AIRPORT", "CYZP", "YZP", "71101", "53.15N", "131.49W", "6", "CA"],
    ["BC SARTINE ISL (MAP", "CWFG", "WFG", "71478", "50.49N", "128.54W", "111", "CA"],
    ["BC SATURNA ISL (MAP", "CWEZ", "WEZ", "71473", "48.47N", "123.03W", "7", "CA"],
    ["BC SCUDDER POINT", "CWZD", "None", "None", "52.27N", "131.14W", "5", "CA"],
    ["BC SHERINGHAM AUTOB", "CWSP", "WSP", "71780", "48.23N", "123.55W", "21", "CA"],
    ["BC SILVER STAR RADR", "CXSS", "None", "None", "50.22N", "119.04W", "1681", "CA"],
    ["BC SIKANNI CHIEF AU", "CWKS", "WKS", "None", "57.15N", "122.43W", "937", "CA"],
    ["BC SISTERS IL AUTOB", "CWGT", "None", "71781", "49.29N", "124.26W", "5", "CA"],
    ["BC SMITHERS AIRPORT", "CYYD", "YYD", "71950", "54.49N", "127.11W", "523", "CA"],
    ["BC SOLANDER ISL (MA", "CWRU", "WRU", "71479", "50.07N", "127.56W", "98", "CA"],
    ["BC SPARWOOD (AUTOB)", "CWGW", "WGW", "71782", "49.45N", "114.54W", "1137", "CA"],
    ["BC SPARWOOD/ELK VAL", "CWSW", "WSW", "None", "49.45N", "114.52W", "1138", "CA"],
    ["BC SQUAMISH (AUTOB)", "CWSK", "WSK", "71207", "49.47N", "123.10W", "60", "CA"],
    ["BC SQUAMISH (AUTOB)", "CYSE", "None", "None", "49.47N", "123.10W", "52", "CA"],
    ["BC STEWART AIRPORT", "CZST", "ZST", "71955", "55.56N", "129.59W", "7", "CA"],
    ["BC SUMMERLAND (AUTO", "CWUS", "WUS", "71768", "49.34N", "119.39W", "454", "CA"],
    ["BC TATLAYOKO LAKE", "CXTL", "None", "71028", "51.40N", "124.24W", "875", "CA"],
    ["BC TERRACE AIRPORT", "CYXT", "YXT", "71951", "54.28N", "128.34W", "217", "CA"],
    ["BC TETSA RIVER", "CWTH", "WTH", "None", "58.39N", "124.14W", "804", "CA"],
    ["BC TOFINO AIRPORT", "CYAZ", "YAZ", "71106", "49.05N", "125.46W", "24", "CA"],
    ["BC TRIPLE ISLAND (L", "CWTI", "WTI", "71100", "54.18N", "130.53W", "21", "CA"],
    ["BC VANCOUVER (AUTOB", "CWHC", "WHC", "71201", "49.17N", "123.07W", "2", "CA"],
    ["BC VANCOUVER INTL A", "CYVR", "YVR", "71892", "49.10N", "123.10W", "2", "CA"],
    ["BC VERNON (AUTOB)", "CWJV", "WJV", "71115", "50.13N", "119.11W", "556", "CA"],
    ["BC VERNON BRIDGE", "CWVK", "WVK", "73033", "50.13N", "119.16W", "555", "CA"],
    ["BC VIC. HARTLAND AU", "CWVV", "WVV", "None", "48.31N", "123.28W", "49", "CA"],
    ["BC VICTORIA (AUTOB)", "CWLM", "WLM", "71200", "48.25N", "123.19W", "70", "CA"],
    ["BC VICTORIA HARBOUR", "CYWH", "YWH", "None", "48.25N", "123.23W", "10", "CA"],
    ["BC VICTORIA INTL AR", "CYYJ", "YYJ", "71799", "48.39N", "123.26W", "19", "CA"],
    ["BC VICTORIA UNIV", "CWYJ", "WYJ", "71783", "48.27N", "123.18W", "39", "CA"],
    ["BC W VANCOUVER AUTO", "CWWA", "WWA", "71784", "49.21N", "123.10W", "178", "CA"],
    ["BC WHISTLER", "CWAE", "WAE", "None", "50.08N", "122.57W", "658", "CA"],
    ["BC WHITE ROCK AUTOB", "CWWK", "WWK", "71785", "49.01N", "122.47W", "15", "CA"],
    ["BC WILLIAMS LAKE AR", "CYWL", "YWL", "71104", "52.11N", "122.04W", "940", "CA"],
    ["BC ALERT BAY (CWAQ)", "None", "None", "71110", "50.34N", "126.55W", "59", "CA"],
    ["BC INGENIKA PT CWWU", "None", "None", "None", "56.47N", "124.54W", "680", "CA"],
    ["MB ARNES", "CWRE", "None", "None", "50.48N", "096.57W", "221", "CA"],
    ["MB BERENS RIVER APT", "CYBV", "YBV", "None", "52.21N", "097.02W", "222", "CA"],
    ["MB BERENS RIVER APT", "CWCF", "WCF", "71158", "52.21N", "097.02W", "222", "CA"],
    ["MB BRANDON AIRPORT", "CYBR", "YBR", "71140", "49.55N", "099.57W", "409", "CA"],
    ["MB CARMAN U OF M", "CWNK", "WNK", "71147", "49.30N", "098.02W", "268", "CA"],
    ["MB CHURCHILL AIRPOR", "CYYQ", "YYQ", "71913", "58.45N", "094.04W", "29", "CA"],
    ["MB DAUPHIN AIRPORT", "None", "None", "71855", "51.06N", "100.02W", "305", "CA"],
    ["MB DAUPHIN", "CYDN", "YDN", "71036", "51.06N", "100.03W", "305", "CA"],
    ["MB DEERWOOD RCS", "CXDW", "XDW", "71840", "49.24N", "098.19W", "341", "CA"],
    ["MB DELTA MARSH CS", "CZUG", "None", "71563", "50.11N", "098.23W", "248", "CA"],
    ["MB EMERSON", "CWEX", "None", "71560", "49.00N", "097.14W", "242", "CA"],
    ["MB FISHER BRANCH(MA", "CWSZ", "WSZ", "71442", "51.04N", "097.32W", "253", "CA"],
    ["MB FLIN FLON AIRPOR", "CYFO", "YFO", "None", "54.40N", "101.40W", "304", "CA"],
    ["MB FOXWARREN RADAR", "CXFW", "None", "None", "50.33N", "101.06W", "547", "CA"],
    ["MB GEORGE ISL (MAPS", "CWWS", "WWS", "71445", "52.49N", "097.37W", "223", "CA"],
    ["MB GILLAM AIRPORT", "CYGX", "YGX", "71912", "56.21N", "094.42W", "145", "CA"],
    ["MB GILLAM AIRPORT", "CWGX", "WGX", "None", "56.21N", "094.42W", "145", "CA"],
    ["MB GIMLI", "CYGM", "YGM", "71856", "50.37N", "097.01W", "230", "CA"],
    ["MB GIMLI HARBOUR", "CXGH", "None", "71577", "50.38N", "097.00W", "217", "CA"],
    ["MB GRAND RAPIDS (MA", "CWJD", "WJD", "71858", "53.10N", "099.16W", "223", "CA"],
    ["MB GRETNA (MARS)", "CWGN", "WGN", "71441", "49.01N", "097.34W", "251", "CA"],
    ["MB HUNTERS POINT MA", "CWHH", "WHH", "71142", "53.02N", "100.56W", "256", "CA"],
    ["MB ISLAND LAKE AIRP", "CYIV", "YIV", "71145", "53.51N", "094.39W", "237", "CA"],
    ["MB KELSEY DAM CS", "CZKD", "None", "71572", "56.02N", "096.31W", "183", "CA"],
    ["MB LYNN LAKE AIRPOR", "CYYL", "YYL", "71078", "56.52N", "101.04W", "357", "CA"],
    ["MB MELITA", "CWEI", "None", "71447", "49.17N", "100.59W", "446", "CA"],
    ["MB MORDEN", "CXMD", "XMD", "71564", "49.13N", "098.05W", "301", "CA"],
    ["MB PILOT MOUND (MAR", "CWPO", "WPO", "71148", "49.12N", "098.54W", "470", "CA"],
    ["MB PORTAGE SOUTHPOR", "CYPG", "YPG", "71851", "49.53N", "098.16W", "269", "CA"],
    ["MB SHILO", "CWLO", "WLO", "71853", "49.46N", "099.37W", "373", "CA"],
    ["MB SWAN RIVER (MARS", "CWEQ", "WEQ", "71443", "52.07N", "101.13W", "335", "CA"],
    ["MB TADOULE LAKE CS", "CXBQ", "None", "71334", "58.42N", "098.30W", "262", "CA"],
    ["MB TADOULE LAKE", "CYBQ", "None", "None", "58.42N", "098.30W", "262", "CA"],
    ["MB THE PAS AIRPORT", "CYQD", "YQD", "71867", "53.58N", "101.05W", "271", "CA"],
    ["MB THOMPSON AIRPORT", "CYTH", "YTH", "71079", "55.47N", "097.52W", "218", "CA"],
    ["MB VICTORIA BEACH", "CWII", "WII", "71552", "50.42N", "096.34W", "220", "CA"],
    ["MB VIVIAN RADAR", "CWVJ", "None", "None", "49.53N", "096.28W", "290", "CA"],
    ["MB WINNIPEG INTL AR", "CYWG", "YWG", "71852", "49.53N", "097.13W", "239", "CA"],
    ["MB WINNIPEG", "CXWI", "None", "71843", "49.53N", "097.08W", "251", "CA"],
    ["MB WINNIPEG FORKS", "CXWN", "XWN", "71579", "49.53N", "097.08W", "230", "CA"],
    ["MB NORWAY HOUSE ARP", "CYNE", "YNE", "None", "53.58N", "097.49W", "223", "CA"],
    ["NB BATHURST ARPT(AW", "CZBF", "ZBF", "71574", "47.37N", "065.45W", "59", "CA"],
    ["NB CHARLO AIRPORT", "CZCR", "None", "71711", "47.58N", "066.19W", "38", "CA"],
    ["NB CHARLO", "None", "None", "71315", "47.59N", "066.20W", "42", "CA"],
    ["NB CHIPMAN RADAR", "CXNC", "None", "None", "46.13N", "065.42W", "1", "CA"],
    ["NB EDMUNSTON", "CERM", "None", "None", "47.25N", "068.19W", "154", "CA"],
    ["NB FREDERICTON AIRP", "CYFC", "YFC", "71700", "45.52N", "066.31W", "20", "CA"],
    ["NB GAGETOWN(CAN M", "CYCX", "YCX", "71701", "45.49N", "066.25W", "51", "CA"],
    ["NB GRAND MANAN", "CXGM", "None", "71030", "44.43N", "066.48W", "78", "CA"],
    ["NB MECHANIC SETTLE", "CWMK", "None", "None", "45.42N", "065.10W", "1", "CA"],
    ["NB MIRAMICHI", "CACQ", "YCH", "71717", "47.01N", "065.28W", "31", "CA"],
    ["NB MISCOU ISL (MARS", "CWMI", "WMI", "71719", "48.01N", "064.30W", "3", "CA"],
    ["NB MONCTON AIRPORT", "CYQM", "YQM", "71705", "46.07N", "064.40W", "71", "CA"],
    ["NB POINT LEPREAU", "CWPE", "WPE", "None", "45.04N", "066.28W", "1", "CA"],
    ["NB PT. ESCUMINAC(MA", "CWPJ", "WPJ", "71414", "47.04N", "064.47W", "5", "CA"],
    ["NB SAINT JOHN", "CYSJ", "YSJ", "71609", "45.19N", "065.52W", "109", "CA"],
    ["NB SAINT LEONARD AR", "CYSL", "YSL", "71703", "47.08N", "067.49W", "241", "CA"],
    ["NB ST LEONARD AUTOB", "CWIY", "WIY", "71019", "47.08N", "067.49W", "241", "CA"],
    ["NB ST. STEPHEN (MAR", "CWSS", "WSS", "71607", "45.12N", "067.15W", "26", "CA"],
    ["NB CHARLO AIRPORT", "CYCL", "None", "None", "47.59N", "066.20W", "38", "CA"],
    ["NB CHATHAM", "CYCH", "None", "None", "47.00N", "065.27W", "31", "CA"],
    ["NB MIRAMICHI (AU8)", "CWCQ", "WCQ", "None", "47.00N", "065.28W", "34", "CA"],
    ["NL ARGENTIA (MARS)", "CWAR", "WAR", "71807", "47.17N", "054.00W", "16", "CA"],
    ["NL BADGER (MARS)", "CWDI", "WDI", "71400", "48.58N", "056.04W", "105", "CA"],
    ["NL BONAVISTA", "CWVA", "WVA", "71196", "48.40N", "053.07W", "27", "CA"],
    ["NL BURGEO", "CWBF", "None", "None", "47.37N", "057.38W", "12", "CA"],
    ["NL CAPE KAKKIVIAK", "CWKW", "WKW", "71176", "59.58N", "064.10W", "551", "CA"],
    ["NL CAPE KIGLAPAIT", "CWYK", "WYK", "71177", "57.07N", "061.28W", "834", "CA"],
    ["NL CAPE RACE (MARS)", "CWRA", "WRA", "71800", "46.38N", "053.04W", "28", "CA"],
    ["NL CARTWRIGHT", "CWCA", "None", "71818", "53.42N", "057.01W", "14", "CA"],
    ["NL CARTWRIGHT", "CYCA", "None", "None", "53.41N", "057.02W", "12", "CA"],
    ["NL CHURCHILL FALLS", "CZUM", "ZUM", "71182", "53.32N", "064.05W", "440", "CA"],
    ["NL DANIEL'S HARBOUR", "CWDH", "WDH", "71185", "50.13N", "057.34W", "19", "CA"],
    ["NL DEER LAKE AIRPOR", "CYDF", "YDF", "71809", "49.13N", "057.24W", "22", "CA"],
    ["NL ENGLEE (MAPS)", "CWDA", "WDA", "71417", "50.43N", "056.07W", "29", "CA"],
    ["NL FEROLLE PT. (MAP", "CWXI", "WXI", "None", "51.01N", "057.06W", "6", "CA"],
    ["NL GANDER INTL AIRP", "CYQX", "YQX", "71803", "48.57N", "054.35W", "151", "CA"],
    ["NL GOOSE BAY AIRPOR", "CYYR", "YYR", "71816", "53.19N", "060.25W", "49", "CA"],
    ["NL GRATES COVE", "CWVW", "None", "71336", "48.10N", "052.56W", "18", "CA"],
    ["NL HOLYROOD RADAR", "CWTP", "None", "None", "47.20N", "053.11W", "1", "CA"],
    ["NL HOPEDALE (MAPS)", "CWHO", "WHO", "71900", "55.27N", "060.13W", "8", "CA"],
    ["NL LA SCIE", "CWAG", "None", "71337", "49.55N", "055.40W", "192", "CA"],
    ["NL LONG POND", "CWWU", "None", "None", "47.31N", "052.59W", "13", "CA"],
    ["NL MAKKOVIK AIRPORT", "CYFT", "YFT", "None", "55.04N", "059.10W", "71", "CA"],
    ["NL MARBLE MTN RADAR", "CXME", "None", "None", "48.56N", "057.50W", "1", "CA"],
    ["NL MARY'S HARBOUR", "CYMH", "YMH", "None", "52.17N", "055.51W", "11", "CA"],
    ["NL NAIN AIRPORT", "CYDP", "YDP", "71902", "56.32N", "061.40W", "7", "CA"],
    ["NL PORT AUX BASQUES", "CWZB", "WZB", "71197", "47.34N", "059.10W", "40", "CA"],
    ["NL ROCKY HARBOUR", "CXRH", "XRH", "71588", "49.34N", "057.53W", "68", "CA"],
    ["NL SAGLEK (BAY)", "CWZZ", "WZZ", "71804", "58.19N", "062.34W", "483", "CA"],
    ["NL SAGLEK (BAY)", "None", "None", "71335", "58.20N", "062.35W", "501", "CA"],
    ["NL SAGONA ISL (MAPS", "CWZN", "WZN", "71408", "47.22N", "055.48W", "64", "CA"],
    ["NL SAINT ANTHONY", "CWAX", "WAX", "71819", "51.23N", "056.05W", "111", "CA"],
    ["NL SAINT ANTHONY", "CWDW", "None", "71558", "51.23N", "056.06W", "29", "CA"],
    ["NL SAINT ANTHONY AR", "CYAY", "YAY", "71830", "51.23N", "056.04W", "28", "CA"],
    ["NL ST JOHNS ARP", "CYYT", "YYT", "71801", "47.37N", "052.43W", "140", "CA"],
    ["NL ST JOHNS WEST", "CXSW", "None", "71587", "47.31N", "052.47W", "114", "CA"],
    ["NL STEPHENVILLE ARP", "CYJT", "YJT", "71815", "48.33N", "058.34W", "26", "CA"],
    ["NL TERRA NOVA", "CXTP", "XTP", "71589", "48.33N", "053.58W", "107", "CA"],
    ["NL TUKIALIK BAY", "CWTU", "WTU", "71179", "54.43N", "058.21W", "683", "CA"],
    ["NL TWILLINGATE (MAP", "CWDO", "None", "71402", "49.40N", "054.47W", "92", "CA"],
    ["NL WABUSH LAKE AIRP", "CYWK", "YWK", "71825", "52.55N", "066.52W", "551", "CA"],
    ["NL WRECKHOUSE", "CXWR", "None", "71584", "47.43N", "059.19W", "33", "CA"],
    ["NL ST PIERRE-FRANCE", "LFVP", "FVP", "71805", "46.46N", "056.11W", "8", "FR"],
    ["NS AMHERST (MARS)", "CWAH", "WAH", "71410", "45.51N", "064.16W", "23", "CA"],
    ["NS BEAVER ISLAND(MA", "CWBV", "WBV", "71403", "44.49N", "062.19W", "10", "CA"],
    ["NS BRIER ISLAND(AUT", "CWVU", "WVU", "None", "44.17N", "066.20W", "16", "CA"],
    ["NS CAPE GEORGE (AUT", "CWGU", "WGU", "None", "45.52N", "061.54W", "120", "CA"],
    ["NS CARIBOU POINT(MA", "CWBK", "WBK", "71415", "45.46N", "062.40W", "2", "CA"],
    ["NS CHETICAMP", "CXCH", "XCH", "None", "46.38N", "060.57W", "44", "CA"],
    ["NS DEBERT", "CZDB", "None", "71317", "45.25N", "063.28W", "38", "CA"],
    ["NS DIGBY ARPT (AWRS", "CYID", "YID", "None", "44.32N", "065.46W", "152", "CA"],
    ["NS FOURCHU HEAD(MAP", "CWRW", "WRW", "71416", "45.43N", "060.13W", "10", "CA"],
    ["NS GRAND ETANG (AUT", "CWZQ", "WZQ", "71413", "46.32N", "061.03W", "17", "CA"],
    ["NS GREENWOOD (CAN M", "CYZX", "YZX", "71397", "44.59N", "064.55W", "28", "CA"],
    ["NS HALIFAX INTL ARP", "CYHZ", "YHZ", "71395", "44.52N", "063.30W", "145", "CA"],
    ["NS HART ISLAND (MAP", "CWRN", "WRN", "71419", "45.21N", "060.59W", "8", "CA"],
    ["NS INGONISH BEACH", "CXIB", "XIB", "71027", "46.40N", "060.23W", "8", "CA"],
    ["NS KEJIMKUJIK (AU8)", "CWKG", "WKG", "71599", "44.26N", "065.12W", "165", "CA"],
    ["NS KENTVILLE (AUTOB", "CXKT", "XKT", "71605", "45.04N", "064.29W", "49", "CA"],
    ["NS LUNENBURG", "CXLB", "None", "None", "44.22N", "064.18W", "4", "CA"],
    ["NS MALAY FALLS", "CXMY", "XMY", "None", "44.59N", "062.29W", "40", "CA"],
    ["NS MARION BRIDGE", "CXMB", "None", "None", "45.57N", "060.12W", "1", "CA"],
    ["NS MCNABS ISLAND", "CXMI", "XMI", "None", "44.36N", "063.32W", "15", "CA"],
    ["NS NAPPAN (AUTO)", "CXNP", "None", "71311", "45.45N", "064.14W", "20", "CA"],
    ["NS NORTH MOUNTAIN", "CXNM", "XNM", "None", "46.49N", "060.40W", "439", "CA"],
    ["NS PORT HAWKESBURY", "CYPD", "YPD", "None", "45.40N", "061.22W", "114", "CA"],
    ["NS ROWAN GORILLA II", "CWXO", "WXO", "None", "43.52N", "060.32W", "44", "CA"],
    ["NS SABLE ISLAND", "CWSA", "WSA", "71600", "43.56N", "060.00W", "4", "CA"],
    ["NS SABLE ISLAND(APT", "CYSA", "YSA", "None", "43.55N", "060.00W", "4", "CA"],
    ["NS SHEARWATER(CAN M", "CYAW", "YAW", "71601", "44.38N", "063.30W", "51", "CA"],
    ["NS SHELBURNE", "CWOS", "WOS", "71399", "43.43N", "065.15W", "30", "CA"],
    ["NS ST. PAUL ISL(MAP", "CWEF", "WEF", "71418", "47.13N", "060.07W", "26", "CA"],
    ["NS SYDNEY AIRPORT", "CYQY", "YQY", "71707", "46.10N", "060.02W", "62", "CA"],
    ["NS TRACADIE", "CXTD", "None", "71308", "45.37N", "061.41W", "68", "CA"],
    ["NS TRENTON MUNICIPA", "CYTN", "YTN", "None", "45.37N", "062.37W", "97", "CA"],
    ["NS TRURO (MARS)", "CWUR", "WUR", "71398", "45.22N", "063.16W", "40", "CA"],
    ["NS WESTERN HEAD (MA", "CWWE", "WWE", "71411", "43.58N", "064.40W", "9", "CA"],
    ["NS YARMOUTH AIRPORT", "CYQI", "YQI", "71603", "43.50N", "066.05W", "43", "CA"],
    ["NT AKLAVIK AIRPORT", "CYKD", "YKD", "None", "68.13N", "135.00W", "7", "CA"],
    ["NT CAPE PARRY AUTO4", "CZCP", "None", "None", "70.10N", "124.43W", "93", "CA"],
    ["NT COLVILLE LAKE", "CYVL", "None", "None", "67.01N", "126.08W", "259", "CA"],
    ["NT DEADMAN VALLEY", "CXDK", "None", "71021", "61.16N", "124.28W", "283", "CA"],
    ["NT DELINE", "CXDE", "XDE", "71503", "65.13N", "123.26W", "213", "CA"],
    ["NT EKATI (PWS)", "CYOA", "YOA", "None", "64.42N", "110.37W", "469", "CA"],
    ["NT FORT FRANKLIN AR", "CYWJ", "YWJ", "None", "65.13N", "123.26W", "176", "CA"],
    ["NT FORT GOOD HOPE A", "CYGH", "YGH", "None", "66.16N", "128.37W", "66", "CA"],
    ["NT FORT LIARD AIRPO", "CYJF", "YJF", "None", "60.13N", "123.28W", "215", "CA"],
    ["NT FORT MCPHERSON A", "CZFM", "ZFM", "None", "67.24N", "134.52W", "43", "CA"],
    ["NT FORT NORMAN AIRP", "CZFN", "ZFN", "None", "64.55N", "125.34W", "98", "CA"],
    ["NT FORT PROVIDENCE", "CWID", "WID", "71087", "61.19N", "117.36W", "161", "CA"],
    ["NT FORT RESOLUTION", "CYFR", "YFR", "None", "61.10N", "113.40W", "164", "CA"],
    ["NT FORT SIMPSON ARP", "CYFS", "YFS", "71946", "61.45N", "121.13W", "169", "CA"],
    ["NT FT SIMPSON 71681", "CXFS", "None", "None", "61.45N", "121.14W", "169", "CA"],
    ["NT FORT SIMPSON", "CZFS", "None", "71365", "61.46N", "121.14W", "168", "CA"],
    ["NT FORT SMITH AIRPO", "CYSM", "YSM", "71934", "60.02N", "111.58W", "203", "CA"],
    ["NT FORT SMITH", "CZSM", "None", "71362", "60.02N", "111.56W", "203", "CA"],
    ["NT GATESHEAD ISLAND", "CNGH", "None", "71141", "70.38N", "100.16W", "20", "CA"],
    ["NT HAY RIVER AIRPOR", "CYHY", "YHY", "71935", "60.49N", "115.46W", "166", "CA"],
    ["NT HAY RIVER", "CZHY", "None", "71361", "60.50N", "115.47W", "164", "CA"],
    ["NT HANBURY RIVER", "CWQY", "None", "71963", "63.36N", "105.08W", "318", "CA"],
    ["NT HOLMAN ISLAND AR", "CYHI", "YHI", "None", "70.46N", "117.47W", "36", "CA"],
    ["NT HOLMAN CS", "CXHI", "None", "71029", "70.46N", "117.48W", "30", "CA"],
    ["NT INDIAN RIVER", "CWIE", "WIE", "71161", "64.23N", "115.01W", "478", "CA"],
    ["NT INUVIK AIRPORT", "CYEV", "YEV", "71957", "68.19N", "133.30W", "68", "CA"],
    ["NT INUVIK", "CZEV", "None", "71364", "68.19N", "133.31W", "103", "CA"],
    ["NT JEAN MARIER", "CXJM", "None", "71159", "61.21N", "120.47W", "227", "CA"],
    ["NT KEATS POINT", "CWKP", "None", "71058", "69.40N", "121.40W", "330", "CA"],
    ["NT LAC LA MARTRE", "CWMT", "None", "71163", "63.08N", "117.15W", "271", "CA"],
    ["NT LINDBERG LANDING", "CXLL", "None", "71682", "61.07N", "122.51W", "183", "CA"],
    ["NT LIVERPOOL BAY", "CWLI", "WLI", "71960", "69.35N", "130.54W", "102", "CA"],
    ["NT LOWER CARP LAKE", "CXLC", "XLC", "71680", "63.36N", "113.51W", "373", "CA"],
    ["NT LUTSEL KE ARPT (", "CYLK", "YLK", "None", "62.25N", "110.40W", "179", "CA"],
    ["NT LUTSEL KE CS", "CXLU", "None", "71529", "62.25N", "110.40W", "179", "CA"],
    ["NT MOULD BAY", "CYMD", "YMD", "71072", "76.13N", "119.19W", "12", "CA"],
    ["NT MOULD BAY CAMP", "CWMD", "WMD", "None", "76.13N", "119.19W", "12", "CA"],
    ["NT NORMAN WELLS ARP", "CYVQ", "YVQ", "71043", "65.16N", "126.47W", "74", "CA"],
    ["NT PAULATUK AIRPORT", "CYPC", "YPC", "None", "69.22N", "124.04W", "6", "CA"],
    ["NT PELLY ISLAND", "CWND", "None", "71502", "69.38N", "135.26W", "12", "CA"],
    ["NT QAVVIK LAKE", "CXQA", "None", "71583", "68.15N", "122.06W", "530", "CA"],
    ["NT RAE LAKES", "CYRA", "YRA", "None", "64.07N", "117.19W", "213", "CA"],
    ["NT RAE LAKES", "CWYH", "None", "71165", "64.07N", "117.22W", "220", "CA"],
    ["NT ROBERTSON LAKE", "CWTD", "None", "71490", "65.06N", "102.26W", "244", "CA"],
    ["NT SACHS HARBOUR(M", "CYSY", "YSY", "71051", "72.00N", "125.16W", "86", "CA"],
    ["NT TRAIL VALLEY", "CXTV", "XTV", "71683", "68.45N", "133.30W", "85", "CA"],
    ["NT TUKTOYAKTUK", "CYUB", "YUB", "71954", "69.27N", "133.01W", "5", "CA"],
    ["NT TUKTUT NOGAIT NP", "CXTN", "XTN", "71492", "69.12N", "122.21W", "552", "CA"],
    ["NT WEKWEETI", "CYWE", "None", "None", "64.11N", "114.05W", "371", "CA"],
    ["NT WRIGLEY AIRPORT", "CYWY", "YWY", "None", "63.13N", "123.25W", "150", "CA"],
    ["NT YELLOWKNIFE AIRP", "CYZF", "YZF", "71936", "62.28N", "114.27W", "206", "CA"],
    ["NT YOHIN", "CXYH", "None", "71020", "61.15N", "123.45W", "204", "CA"],
    ["NT CANADA/ARTCC", "CZVE", "ZVE", "None", "70.10N", "124.41W", "1", "CA"],
    ["NU ALERT", "CWLT", "WLT", "71082", "82.30N", "062.19W", "63", "CA"],
    ["NU ALERT AIRPORT", "CYLT", "YLT", "None", "82.31N", "062.16W", "31", "CA"],
    ["NU ALERT", "CZLT", "None", "71355", "82.30N", "062.20W", "65", "CA"],
    ["NU ARCTIC BAY CS", "CXAT", "XAT", "71592", "73.00N", "085.02W", "19", "CA"],
    ["NU ARCTIC BAY", "CYAB", "None", "None", "73.00N", "085.03W", "22", "CA"],
    ["NU ARVIAT AIRPORT", "CYEK", "YEK", "None", "61.06N", "094.04W", "10", "CA"],
    ["NU ARVIAT CLIMATE", "CXAR", "None", "71332", "61.06N", "094.04W", "10", "CA"],
    ["NU BAKER LAKE AIRPO", "CYBK", "YBK", "71926", "64.17N", "096.04W", "18", "CA"],
    ["NU BAKER LAKE", "CXBL", "None", "71356", "64.19N", "096.00W", "51", "CA"],
    ["NU BREVOORT ISLAND", "CWOB", "WOB", "71097", "63.19N", "064.09W", "367", "CA"],
    ["NU QIKIQTARJUAQ", "CYVM", "None", "71338", "67.32N", "064.01W", "6", "CA"],
    ["NU BROUGHTON ISLAND", "CWVD", "WVD", "None", "67.31N", "063.46W", "573", "CA"],
    ["NU BROWN RIVER", "CWBR", "None", "71049", "66.02N", "091.50W", "31", "CA"],
    ["NU CAMBRIDGE BAY AR", "CYCB", "YCB", "71925", "69.05N", "105.07W", "27", "CA"],
    ["NU CAMBRIDGE BAY", "CXCM", "None", "71288", "69.06N", "105.08W", "19", "CA"],
    ["NU CAPE DORSET AIRP", "CYTE", "YTE", "71910", "64.13N", "076.31W", "47", "CA"],
    ["NU CAPE DYER AIRPOR", "CWFD", "WFD", "71094", "66.34N", "061.35W", "393", "CA"],
    ["NU CAPE HOOPER", "CWUP", "WUP", "71093", "68.28N", "066.49W", "390", "CA"],
    ["NU CAPE MERCY", "CWYM", "WYM", "71975", "64.57N", "063.34W", "583", "CA"],
    ["NU CAPE PEEL WEST", "CWPX", "WPX", "71064", "69.01N", "107.49W", "165", "CA"],
    ["NU CHESTERFIELD INL", "CYCS", "YCS", "None", "63.21N", "090.43W", "11", "CA"],
    ["NU COPPERMINE AIRPO", "CYCO", "YCO", "71938", "67.49N", "115.09W", "22", "CA"],
    ["NU CORAL HARBOUR AR", "CYZS", "YZS", "71915", "64.12N", "083.22W", "64", "CA"],
    ["NU CROKER RIVER", "CWXR", "WXR", "71059", "69.16N", "119.13W", "69", "CA"],
    ["NU CYLDE AIRPORT", "CYCY", "YCY", "71090", "70.28N", "068.31W", "26", "CA"],
    ["NU DEWAR LAKES", "CWUW", "WUW", "71092", "68.39N", "071.10W", "527", "CA"],
    ["NU ENNADAI LAKE (MA", "CWJC", "WJC", "71923", "61.08N", "100.54W", "357", "CA"],
    ["NU EUREKA", "CWEU", "None", "71917", "80.00N", "085.55W", "10", "CA"],
    ["NU EUREKA", "CYEU", "None", "None", "80.00N", "085.49W", "78", "CA"],
    ["NU FROBISHER/IQALUI", "CYFB", "YFB", "71909", "63.45N", "068.33W", "34", "CA"],
    ["NU IQALUIT (CYFB)", "None", "None", "71321", "63.45N", "068.33W", "34", "CA"],
    ["NU GJOA HAVEN AIRPO", "CYHK", "YHK", "None", "68.37N", "095.50W", "46", "CA"],
    ["NU GJOA HAVEN", "CZHK", "None", "71363", "68.38N", "095.51W", "42", "CA"],
    ["NU GRISE FIORD AIR", "CWGZ", "WGZ", "None", "76.25N", "082.54W", "45", "CA"],
    ["NU HALL BEACH AIRPO", "CYUX", "None", "71081", "68.46N", "081.15W", "8", "CA"],
    ["NU HALL BEACH", "CXUX", "None", "71320", "68.47N", "081.15W", "8", "CA"],
    ["NU HAT ISLAND", "CWIL", "WIL", "71084", "68.19N", "100.04W", "36", "CA"],
    ["NU IGLOOLIK AIRPORT", "CYGT", "YGT", "None", "69.22N", "081.49W", "51", "CA"],
    ["NU ISACHSEN (MAPS)", "CWIC", "WIC", "71074", "78.47N", "103.33W", "58", "CA"],
    ["NU LADY FRANKLIN PO", "CYUJ", "YUJ", "71937", "68.30N", "113.13W", "16", "CA"],
    ["NU LAKE HARBOUR ARP", "CYLC", "YLC", "None", "62.51N", "069.52W", "53", "CA"],
    ["NU LONGSTAFF BLUFF", "CWLX", "WLX", "71091", "68.54N", "075.09W", "162", "CA"],
    ["NU LUPIN ARPT (SAWR", "CYWO", "YWO", "71496", "65.46N", "111.15W", "494", "CA"],
    ["NU LUPIN (MAPS)", "CWIJ", "WIJ", "None", "65.46N", "111.14W", "500", "CA"],
    ["NU NANISIVIK AIRPOR", "CYSR", "YSR", "None", "72.58N", "084.37W", "649", "CA"],
    ["NU PANGNIRTUNG AIRP", "CYXP", "YXP", "None", "66.09N", "065.43W", "23", "CA"],
    ["NU PELLY BAY 1", "CWRF", "WRF", "71918", "69.25N", "089.43W", "325", "CA"],
    ["NU PELLY BAY AIRPOR", "CYBB", "YBB", "None", "68.31N", "089.49W", "15", "CA"],
    ["NU POND INLET AIRPO", "CYIO", "YIO", "71095", "72.40N", "077.58W", "57", "CA"],
    ["NU RAE POINT", "CZRP", "None", "71983", "75.22N", "105.43W", "12", "CA"],
    ["NU RANKIN INLET ARP", "CYRT", "YRT", "71083", "62.49N", "092.07W", "32", "CA"],
    ["NU REPULSE BAY AIRP", "CYUT", "YUT", "None", "66.31N", "086.15W", "24", "CA"],
    ["NU RESOLUTE AIRPORT", "CYRB", "YRB", "71924", "74.43N", "094.58W", "67", "CA"],
    ["NU RESOLUTE CS", "CXRB", "None", "71018", "74.43N", "094.59W", "30", "CA"],
    ["NU RESOLUTION IS", "CWRH", "WRH", "71972", "61.34N", "064.39W", "369", "CA"],
    ["NU ROWLEY ISLAND", "CWRX", "WRX", "71088", "69.04N", "079.01W", "41", "CA"],
    ["NU SANIKILUAQ AIRPO", "CYSK", "YSK", "None", "56.32N", "079.15W", "26", "CA"],
    ["NU SHEPHERD BAY ARP", "CYUS", "YUS", "71911", "68.49N", "093.25W", "42", "CA"],
    ["NU SPENCE BAY AIRPO", "CYYH", "YYH", "None", "69.32N", "093.34W", "28", "CA"],
    ["NU STEFANSSON IS", "CXSE", "None", "71017", "73.46N", "105.17W", "11", "CA"],
    ["NU WAGER BAY", "CXWB", "None", "None", "65.53N", "089.27W", "18", "CA"],
    ["NU WHALE COVE AIRPO", "CYXN", "YXN", "None", "62.13N", "092.35W", "20", "CA"],
    ["NU IQALUIT CLIMATE", "CXFB", "None", "None", "63.45N", "068.33W", "34", "CA"],
    ["ON ARMSTRONG (MARS)", "CYYW", "None", "71841", "50.18N", ".88.54W", "351", "CN"],
    ["ON ATIKOKAN (AUT)", "CWCH", "WCH", "71747", "48.45N", "091.37W", "424", "CA"],
    ["ON ATIKOKAN", "None", "WIB", "71748", "48.45N", "091.36W", "393", "CA"],
    ["ON ATTAWAPISKAT", "CYAT", "None", "None", "52.56N", "082.26W", "9", "CA"],
    ["ON BANCROFT AUTOB", "CWRK", "WRK", "None", "45.04N", "077.52W", "331", "CA"],
    ["ON BARRIE (MARS)", "CWCU", "WCU", "71436", "44.22N", "079.46W", "295", "CA"],
    ["ON BARRIE-ORO", "CXBI", "None", "71314", "44.29N", "079.33W", "289", "CA"],
    ["ON BEAUSOLEIL ISL A", "CWPB", "WPB", "71272", "44.51N", "079.52W", "183", "CA"],
    ["ON BELLE RIVER AUT0", "CWDD", "WDD", "71273", "42.17N", "082.42W", "184", "CA"],
    ["ON BIG TROUT LAKE", "CWTL", "WTL", "None", "53.49N", "089.53W", "222", "CA"],
    ["ON BIG TROUT LAKE", "CYTL", "YTL", "71848", "53.49N", "089.53W", "224", "CA"],
    ["ON BORDEN", "CYBN", "YBN", "71534", "44.16N", "079.55W", "223", "CA"],
    ["ON BRITT (MARS)", "CWBI", "WBI", "71632", "45.48N", "080.32W", "190", "CA"],
    ["ON BURLINGTON PIERS", "CWWB", "WWB", "71437", "43.18N", "079.47W", "76", "CA"],
    ["ON CAMERON FALLS", "CXCA", "XCA", "71291", "49.09N", "088.21W", "228", "CA"],
    ["ON CARIBOU ISL (MAP", "CWCI", "WCI", "71433", "47.19N", "085.49W", "187", "CA"],
    ["ON CHAPLEAU ARPT(SA", "CYLD", "YLD", "None", "47.49N", "083.20W", "447", "CA"],
    ["ON CHATHAM", "CYCK", "None", "None", "42.18N", "082.05W", "198", "CA"],
    ["ON COBOURG (MARS)", "CWNC", "None", "71431", "43.57N", "078.10W", "78", "CA"],
    ["ON COLLINGWOOD (AUT", "CWCO", "WCO", "71270", "44.27N", "080.10W", "221", "CA"],
    ["ON COVE ISLAND (MAP", "CWWX", "WWX", "71439", "45.19N", "081.44W", "181", "CA"],
    ["ON CYPRUS LAKE CS", "CXCY", "XCY", "None", "45.14N", "081.32W", "190", "CA"],
    ["ON DELHI CS (AUT)", "CXDI", "XDI", "71573", "42.52N", "080.33W", "232", "CA"],
    ["ON DRYDEN AIRPORT", "CYHD", "YHD", "None", "49.49N", "092.45W", "413", "CA"],
    ["ON DRYDEN", "CXDR", "None", "None", "49.51N", "092.48W", "413", "CA"],
    ["ON EAR FALLS (AUT)", "CXEA", "XEA", "71295", "50.38N", "093.13W", "355", "CA"],
    ["ON EARLTON AIRPORT", "CYXR", "YXR", "71735", "47.42N", "079.50W", "243", "CA"],
    ["ON EARLTON", "CZXR", "None", "71533", "47.42N", "079.50W", "243", "CA"],
    ["ON EGBERT CS", "CXET", "XET", "71296", "44.14N", "079.47W", "251", "CA"],
    ["ON EGBERT (MAPS)", "CWET", "None", "71561", "44.14N", "079.47W", "251", "CA"],
    ["ON ELLIOT LAKE (SAW", "CYEL", "YEL", "None", "46.21N", "082.34W", "329", "CA"],
    ["ON ELORA RCS", "CZEL", "None", "71352", "43.39N", "080.25W", "376", "CA"],
    ["ON ERIEAU (MAPS)", "CWAJ", "WAJ", "71465", "42.15N", "081.54W", "178", "CA"],
    ["ON EXETER RADAR", "CWSO", "None", "None", "43.22N", "081.23W", "1", "CA"],
    ["ON FT SEVERN", "CYER", "None", "71099", "56.01N", "087.41W", "16", "CA"],
    ["ON FRANKTOWN", "CXFT", "None", "None", "45.02N", "076.06W", "122", "CA"],
    ["ON GERALDTON AIRPOR", "CYGQ", "YGQ", "71834", "49.46N", "086.55W", "351", "CA"],
    ["ON GODERICH (AUTOB)", "CWGD", "WGD", "71261", "43.46N", "081.43W", "214", "CA"],
    ["ON GORE BAY AIRPORT", "CYZE", "YZE", "71733", "45.52N", "082.34W", "193", "CA"],
    ["ON GREAT DUCK ISLAN", "CWNL", "WNL", "71462", "45.37N", "082.58W", "183", "CA"],
    ["ON GRENADIER ISLAND", "CWGH", "WGH", "71281", "44.25N", "075.51W", "82", "CA"],
    ["ON HAMILTON AIRPORT", "CYHM", "YHM", "71263", "43.10N", "079.56W", "238", "CA"],
    ["ON HAMILTON RBG CS", "CXHM", "XHM", "71297", "43.17N", "079.54W", "107", "CA"],
    ["ON HARROW CDA", "CXHA", "XHA", "71298", "42.02N", "082.54W", "191", "CA"],
    ["ON KAPUSKASING AIRP", "CYYU", "YYU", "71831", "49.25N", "082.28W", "227", "CA"],
    ["ON KAPUSKASING CDA", "CXKA", "XKA", "71299", "49.24N", "082.27W", "218", "CA"],
    ["ON KATATOTA ISLAND", "CWKK", "None", "None", "49.43N", "088.20W", "260", "CA"],
    ["ON KEMPTVILLE", "CXKE", "XKE", "71300", "45.00N", "075.38W", "99", "CA"],
    ["ON KENORA AIRPORT", "CYQK", "YQK", "71850", "49.46N", "094.22W", "411", "CA"],
    ["ON KILLARNEY (MAPS)", "CWBE", "WBE", "71460", "45.59N", "081.29W", "196", "CA"],
    ["ON KINGSTON ARPT (M", "CYGK", "YGK", "71620", "44.13N", "076.35W", "93", "CA"],
    ["ON KIRKLAND LAKE", "CXKI", "None", "71301", "48.13N", "080.00W", "324", "CA"],
    ["ON LADRIENNE RADAR", "CXLA", "None", "None", "48.33N", "077.48W", "1", "CA"],
    ["ON LAGOON CITY", "CWGL", "WGL", "71282", "44.31N", "079.13W", "221", "CA"],
    ["ON LANSDOWNE HOUSE", "CWLF", "WLF", "71846", "52.13N", "087.52W", "242", "CA"],
    ["ON LANSDOWNE HOUSE", "CYLF", "None", "None", "52.14N", "087.53W", "242", "CA"],
    ["ON LANSDOWNE 71697", "CYLH", "None", "None", "52.12N", "087.56W", "254", "CA"],
    ["ON OSHAWA", "None", "None", "71697", "43.55N", "078.53W", "140", "CA"],
    ["ON LONDON CS", "CWSN", "None", "71622", "43.02N", "081.09W", "278", "CA"],
    ["ON LONDON AIRPORT", "CYXU", "YXU", "71623", "43.01N", "081.09W", "278", "CA"],
    ["ON LONG POINT (MAPS", "CWPS", "WPS", "71464", "42.34N", "080.02W", "175", "CA"],
    ["ON MARATHON", "CYSP", "None", "None", "48.45N", "086.21W", "315", "CA"],
    ["ON MONTREAL RIV HAR", "CWGJ", "None", "None", "47.14N", "084.35W", "559", "CA"],
    ["ON MONTREAL RIV", "CZGJ", "None", "None", "47.15N", "084.36W", "520", "CA"],
    ["ON MOOSONEE (SAWR)", "CYMO", "YMO", "71836", "51.17N", "080.37W", "10", "CA"],
    ["ON MOOSONEE", "CWZC", "None", "None", "51.17N", "080.36W", "11", "CA"],
    ["ON MOOSONEE RCS", "CXZC", "None", "71309", "51.18N", "080.37W", "9", "CA"],
    ["ON MOUNT FOREST(MAR", "CWLS", "WLS", "71631", "43.58N", "080.45W", "415", "CA"],
    ["ON MUSKOKA AIRPORT", "CYQA", "YQA", "71630", "44.58N", "079.17W", "282", "CA"],
    ["ON MUSKRAT DAM", "CZMD", "None", "None", "53.26N", "091.46W", "278", "CA"],
    ["ON NAGAGAMI (MARS)", "CWNZ", "WNZ", "71832", "49.45N", "084.10W", "256", "CA"],
    ["ON NORTH BAY AIRPOR", "CYYB", "YYB", "71731", "46.21N", "079.25W", "371", "CA"],
    ["ON NORTHEAST ONT", "CXTI", "None", "None", "49.17N", "081.47W", "1", "CA"],
    ["ON OGOKI POST", "CYKP", "YKP", "None", "51.40N", "085.54W", "179", "CA"],
    ["ON OLIPHANT (AUTOB)", "CWDF", "WDF", "71283", "44.43N", "081.16W", "182", "CA"],
    ["ON OSHAWA", "CYOO", "None", "None", "43.55N", "078.54W", "139", "CA"],
    ["ON OTTAWA INTL", "CYOW", "YOW", "71628", "45.19N", "075.40W", "114", "CA"],
    ["ON OTTAWA CDA RCS", "CXOA", "None", "71063", "45.23N", "075.43W", "79", "CA"],
    ["ON N ONTARIO PORTAB", "CXQT", "XQT", "None", "48.26N", "089.13W", "183", "CA"],
    ["ON PARRY SOUND", "CXPC", "None", "71172", "45.21N", "080.03W", "176", "CA"],
    ["ON PEAWANUCK", "CYPO", "YPO", "None", "54.59N", "085.26W", "53", "CA"],
    ["ON PETAWAWA", "CYWA", "YWA", "71625", "45.57N", "077.19W", "130", "CA"],
    ["ON PETERBOROUGH ARP", "CYPQ", "YPQ", "None", "44.13N", "078.22W", "191", "CA"],
    ["ON PICKLE LAKE", "CYPL", "YPL", "71845", "51.28N", "090.12W", "373", "CA"],
    ["ON POINT PETRE (MAR", "CWQP", "WQP", "71430", "43.50N", "077.09W", "79", "CA"],
    ["ON PORT COLBORNE(AU", "CWPC", "WPC", "71463", "42.52N", "079.15W", "184", "CA"],
    ["ON PORT WELLER (MAR", "CWWZ", "WWZ", "71432", "43.15N", "079.13W", "79", "CA"],
    ["ON PUKASKWA PARK", "CWCJ", "WCJ", "None", "48.36N", "086.17W", "206", "CA"],
    ["ON RAWSON LAKE", "CYTA", "None", "None", "49.40N", "093.44W", "435", "CA"],
    ["ON RAWSON LAKE", "CTRA", "None", "None", "49.40N", "093.44W", "435", "CA"],
    ["ON RED LAKE AIRPORT", "CYRL", "YRL", "71854", "51.04N", "093.47W", "383", "CA"],
    ["ON RIDGETOWN RCS", "CXRG", "None", "71307", "42.27N", "081.53W", "205", "CA"],
    ["ON ROQUEMAURE", "CWGQ", "WGQ", "71736", "48.37N", "079.27W", "269", "CA"],
    ["ON S.E. SHOAL (MAPS", "CWNB", "WNB", "71466", "41.49N", "082.28W", "195", "CA"],
    ["ON SANDY LAKE", "CZSJ", "None", "71098", "53.04N", "093.21W", "290", "CA"],
    ["ON SARNIA AIRPORT", "CYZR", "YZR", "71634", "43.00N", "082.18W", "181", "CA"],
    ["ON SAULT STE MARIE", "CYAM", "YAM", "71260", "46.28N", "084.31W", "192", "CA"],
    ["ON SIOUX LOOKOUT AR", "CYXL", "YXL", "71842", "50.07N", "091.54W", "390", "CA"],
    ["ON ST. CATHARINES A", "CYSN", "YSN", "None", "43.12N", "079.10W", "98", "CA"],
    ["QC STERLING", "CYQC", "None", "None", "46.19N", "077.38W", "139", "CA"],
    ["ON SUDBURY AIRPORT", "CYSB", "YSB", "71730", "46.38N", "080.48W", "348", "CA"],
    ["ON SUPERIOR W RADAR", "CXNI", "None", "None", "48.51N", "089.07W", "1", "CA"],
    ["ON TERRACE BAY (SAW", "CYTJ", "YTJ", "None", "48.49N", "087.05W", "287", "CA"],
    ["ON THUNDER BAY", "CYQT", "YQT", "71749", "48.22N", "089.19W", "199", "CA"],
    ["ON THUNDER BAY", "CZTB", "None", "None", "48.22N", "089.19W", "199", "CA"],
    ["ON TIMMINS AIRPORT", "CYTS", "YTS", "71739", "48.34N", "081.22W", "295", "CA"],
    ["ON TORONTO BUTTONVI", "CYKZ", "YKZ", "71639", "43.52N", "079.22W", "198", "CA"],
    ["ON TORONTO ILVOR", "CYTZ", "YTZ", "71265", "43.38N", "079.24W", "77", "CA"],
    ["ON TORONTO/PEARSON", "CYYZ", "YYZ", "71624", "43.40N", "079.37W", "173", "CA"],
    ["ON TORONTO CITY", "CXTO", "None", "71508", "43.40N", "079.24W", "113", "CA"],
    ["ON TRENTON (CAN MIL", "CYTR", "YTR", "71621", "44.07N", "077.31W", "86", "CA"],
    ["ON TROWBRIDGE (MAPS", "CWAB", "WAB", "71461", "48.17N", "088.52W", "218", "CA"],
    ["ON UPPER RIDEAU LAK", "CWJM", "WJM", "71290", "44.42N", "076.17W", "125", "CA"],
    ["ON UPSALA (MARS)", "CWDV", "WDV", "71435", "49.01N", "090.28W", "489", "CA"],
    ["ON UPSALA (RADAR)", "CWIM", "None", "None", "49.02N", "090.25W", "538", "CA"],
    ["ON VINELAND (AU8)", "CXVN", "XVN", "71171", "43.11N", "079.24W", "79", "CA"],
    ["ON WATERLOO WELL", "CYKF", "YKF", "71368", "43.28N", "080.23W", "317", "CA"],
    ["ON WAWA AIRPORT", "CYXZ", "YXZ", "71738", "47.58N", "084.46W", "287", "CA"],
    ["ON WELCOME ISLAND", "CWEC", "None", "71751", "48.22N", "089.07W", "209", "CA"],
    ["ON WESTERN ISL (MAP", "CWMZ", "WMZ", "71438", "45.01N", "080.22W", "191", "CA"],
    ["ON WIARTON AIR", "CYVV", "YVV", "71633", "44.45N", "081.05W", "222", "CA"],
    ["ON WINDSOR AIRPORT", "CYQG", "YQG", "71538", "42.16N", "082.58W", "190", "CA"],
    ["ON SIMCOE (MARS)", "CWSI", "WSI", "71527", "42.51N", "080.16W", "241", "CA"],
    ["ON KENORA/ONT VOR", "CVBI", "VBI", "None", "49.28N", "094.02W", "394", "CA"],
    ["ON PICKLE LAKE", "CWPL", "WPL", "None", "51.28N", "090.12W", "386", "CA"],
    ["ON ALFRED", "CTAE", "None", "71366", "45.33N", "074.53W", "57", "CA"],
    ["ON ALEXANDRIA 71393", "CTAL", "None", "None", "45.19N", "074.37W", "77", "CA"],
    ["ON MOOSE CREEK", "CTCK", "None", "71304", "45.15N", "074.58W", "85", "CA"],
    ["ON CORNWALL", "CTCW", "None", "71369", "45.02N", "074.41W", "58", "CA"],
    ["ON ALGONQUIN PARK", "CTNK", "None", "71581", "45.32N", "078.16W", "410", "CA"],
    ["ON WINCHESTER", "CTWN", "None", "71367", "45.03N", "075.20W", "75", "CA"],
    ["PE CHARLOTTETOWN AR", "CYYG", "YYG", "71706", "46.16N", "063.07W", "54", "CA"],
    ["PE CONFEDERATION BR", "CXBP", "None", "None", "46.14N", "063.44W", "54", "CA"],
    ["PE EAST POINT (MARS", "CWEP", "WEP", "71412", "46.27N", "061.58W", "11", "CA"],
    ["PE MAPLE PLAINS PEI", "CXMP", "None", "None", "46.18N", "063.35W", "46", "CA"],
    ["PE NORTH POINT (AUT", "CWNE", "WNE", "None", "47.04N", "064.00W", "15", "CA"],
    ["PE ST PETERS", "CZSP", "None", "71310", "46.27N", "062.35W", "30", "CA"],
    ["PE SUMMERSIDE (AUTO", "CWSD", "None", "None", "46.25N", "063.51W", "24", "CA"],
    ["PE SUMMERSIDE(CAN M", "CYSU", "YSU", "71702", "46.25N", "063.49W", "24", "CA"],
    ["PE HARRINGTON CDA", "CAHR", "None", "71350", "46.21N", "063.10W", "53", "CA"],
    ["QC AMQUI", "CWZS", "WZS", "71386", "48.28N", "067.26W", "166", "CA"],
    ["QC AKULIVIK AIRPORT", "CYKO", "YKO", "None", "60.49N", "078.09W", "9", "CA"],
    ["QC AUPALUK", "CYLA", "YLA", "None", "59.17N", "069.35W", "35", "CA"],
    ["QC BAGOTVILLE(CAN M", "CYBG", "YBG", "71727", "48.20N", "070.59W", "159", "CA"],
    ["QC BAIE COMEAU AIRP", "CYBC", "YBC", "71187", "49.07N", "068.12W", "22", "CA"],
    ["QC BARRAGE ANGLIERS", "CWRC", "WRC", "71820", "47.33N", "079.14W", "266", "CA"],
    ["QC BEAUCEVILLE", "CWHV", "WHV", "71323", "46.12N", "070.46W", "229", "CA"],
    ["QC BEAUPORT", "CXBO", "XBO", "71578", "46.50N", "071.12W", "100", "CA"],
    ["QC BLANC SABLON ARP", "CYBX", "YBX", "71808", "51.27N", "057.10W", "35", "CA"],
    ["QC BONNARD(AUTO)", "CWKD", "WKD", "71383", "50.44N", "071.01W", "497", "CA"],
    ["QC BORDER (MAPS)", "CWTB", "WTB", "71901", "55.19N", "063.13W", "479", "CA"],
    ["QC CAP CHAT (MAPS)", "CWSG", "WSG", "71428", "49.07N", "066.39W", "5", "CA"],
    ["QC CAP D'ESPOIR (MA", "CWRZ", "WRZ", "71429", "48.25N", "064.19W", "16", "CA"],
    ["QC CAP MADELEINE(MA", "CWSF", "WSF", "71425", "49.15N", "065.19W", "29", "CA"],
    ["QC CAP TOURMENTE", "CWTN", "WTN", "71384", "47.04N", "070.47W", "6", "CA"],
    ["QC CHAMOUCHOUANE AU", "CWEE", "WEE", "71523", "49.16N", "073.20W", "305", "CA"],
    ["QC CHAPAIS", "CWUK", "None", "71824", "49.49N", "074.59W", "381", "CA"],
    ["QC CHARLEVOIX (MRX)", "CWIS", "WIS", "71319", "47.17N", "070.38W", "719", "CA"],
    ["QC CHARLEVOIX AIRPO", "CYML", "YML", "None", "47.36N", "070.13W", "298", "CA"],
    ["QC CHATHAM BROWNBRG", "CMBB", "None", "None", "45.37N", "074.25W", "75", "CA"],
    ["QC CHEVERY (MARS)", "CWDM", "WDM", "71814", "50.28N", "059.37W", "6", "CA"],
    ["QC CHIBOUGAMAU CHAP", "CYMT", "YMT", "71822", "49.46N", "074.31W", "387", "CA"],
    ["QC CHUTE DES PASSES", "CWDT", "WDT", "71522", "49.53N", "071.15W", "399", "CA"],
    ["QC DESCHAMBAULTS", "CWHQ", "WHQ", "71389", "46.41N", "071.58W", "55", "CA"],
    ["QC EASTMAIN RIVER A", "CZEM", "ZEM", "None", "52.13N", "078.31W", "7", "CA"],
    ["QC FRELIGHSBURG", "CWFQ", "WFQ", "71373", "45.02N", "072.49W", "152", "CA"],
    ["QC GASPE AIRPORT", "CYGP", "YGP", "71188", "48.46N", "064.28W", "33", "CA"],
    ["QC GATINEAU AIRPORT", "CYND", "YND", "None", "45.31N", "075.34W", "64", "CA"],
    ["QC HARRINGTON", "CMHN", "None", "None", "45.48N", "074.39W", "168", "CA"],
    ["QC HAVRE ST PIERRE", "CYGV", "YGV", "71313", "50.16N", "063.37W", "33", "CA"],
    ["QC HEATH POINT (MAP", "CWHP", "None", "71423", "49.04N", "061.42W", "4", "CA"],
    ["QC HIGH FALLS CS (A", "CXHF", "XHF", "71391", "45.50N", "075.39W", "190", "CA"],
    ["QC ICE AUX GRUES", "CWIG", "WIG", "None", "47.04N", "070.32W", "18", "CA"],
    ["QC ICE AUX PERROQUE", "CWQR", "WQR", "71375", "50.13N", "064.13W", "9", "CA"],
    ["QC ILE BICQUETTE", "CWQO", "WQO", "71385", "48.25N", "068.54W", "1", "CA"],
    ["QC ILE CHARRON", "CWVZ", "WVZ", "None", "45.35N", "073.30W", "12", "CA"],
    ["QC ILE D'ORLEANS(AU", "CWER", "WER", "71424", "47.00N", "070.49W", "5", "CA"],
    ["QC ILE ROUGE(MAPS)", "CWAF", "WAF", "71426", "48.04N", "069.32W", "5", "CA"],
    ["QC ILES DE LA MADEL", "CYGR", "YGR", "71709", "47.25N", "061.46W", "10", "CA"],
    ["QC ILES-DE-LA-MADEL", "CWGR", "WGR", "71710", "47.25N", "061.48W", "60", "CA"],
    ["QC INUKJUAK", "None", "None", "71907", "58.27N", "078.05W", "3", "CA"],
    ["QC INUKJUAK", "CYPH", "YPH", "71306", "58.28N", "078.05W", "25", "CA"],
    ["QC IVUJIVIK ARPT(SA", "CYIK", "YIK", "None", "62.25N", "077.56W", "42", "CA"],
    ["QC JONQUIERE(AUTO)", "CWJO", "WJO", "71617", "48.26N", "071.09W", "133", "CA"],
    ["QC KANGIKSUALUJJUAQ", "CYLU", "YLU", "None", "58.43N", "065.58W", "60", "CA"],
    ["QC KANGIQSUJUAQ(SAW", "CYKG", "YKG", "None", "61.34N", "071.55W", "151", "CA"],
    ["QC KANGIRSUK (SAWR)", "CYAS", "YAS", "None", "60.01N", "070.00W", "117", "CA"],
    ["QC KUUJJUAQ AIRPORT", "CYVP", "YVP", "71906", "58.07N", "068.25W", "60", "CA"],
    ["QC KUUJJUARAPIK ARP", "CYGW", "YGW", "71905", "55.16N", "077.46W", "12", "CA"],
    ["QC L'ACADIE", "CWIZ", "WIZ", "71372", "45.17N", "073.20W", "45", "CA"],
    ["QC L'ASSOMPTION", "CWEW", "WEW", "71524", "45.49N", "073.26W", "21", "CA"],
    ["QC LA BAIE", "CWUX", "WUX", "71388", "48.18N", "070.56W", "135", "CA"],
    ["QC LA GRANDE III(SA", "CYAD", "YAD", "None", "53.34N", "076.12W", "233", "CA"],
    ["QC LA GRANDE IV ARP", "CYAH", "YAH", "71823", "53.45N", "073.40W", "306", "CA"],
    ["QC LA GRANDE RIVIER", "CYGL", "YGL", "71827", "53.37N", "077.42W", "195", "CA"],
    ["QC LA POCATIERE", "CWST", "None", "71713", "47.21N", "070.01W", "31", "CA"],
    ["QC LA TUQUE", "CWDQ", "WDQ", "71378", "47.25N", "072.47W", "169", "CA"],
    ["QC LAC EON (MAPS)", "CWEO", "WEO", "71421", "51.52N", "063.16W", "561", "CA"],
    ["QC LAC MEMPHREMAGOG", "CWTT", "WTT", "None", "45.16N", "072.10W", "209", "CA"],
    ["QC LAC ST PIERRE (A", "CWBS", "WBS", "71198", "46.11N", "072.55W", "16", "CA"],
    ["QC LATERRIERE", "CXLT", "None", "71040", "48.18N", "071.08W", "162", "CA"],
    ["QC LAUZON", "CWLU", "WLU", "None", "46.50N", "071.10W", "20", "CA"],
    ["QC LENNOXVILLE", "CWQH", "WQH", "71611", "45.22N", "071.49W", "181", "CA"],
    ["QC LOCHABER", "CMHB", "None", "None", "45.38N", "075.12W", "105", "CA"],
    ["QC LONGUE PT DE MON", "CWBT", "WBT", "71512", "50.16N", "064.14W", "11", "CA"],
    ["QC MANIWAKI", "CWMJ", "WMJ", "71721", "46.16N", "076.00W", "200", "CA"],
    ["QC MANIWAKI", "CWMW", "WMW", "71722", "46.22N", "075.58W", "170", "CA"],
    ["QC MATAGAMI AIRPORT", "CYNM", "YNM", "71821", "49.46N", "077.49W", "281", "CA"],
    ["QC MCGILL RADAR", "CWMN", "None", "None", "45.25N", "073.56W", "63", "CA"],
    ["QC MC TAVISH (AUT)", "CWTA", "WTA", "71612", "45.30N", "073.35W", "63", "CA"],
    ["QC MISTOOK (AUT)", "CWIX", "WIX", "71381", "48.36N", "071.43W", "113", "CA"],
    ["QC MONT JOLI AIRPOR", "CYYY", "YYY", "71718", "48.36N", "068.13W", "52", "CA"],
    ["QC MONT ORFORD", "CWHY", "WHY", "71618", "45.19N", "072.15W", "851", "CA"],
    ["QC MONTREAL EST", "CWPQ", "WPQ", "71675", "45.38N", "073.30W", "6", "CA"],
    ["QC MONTREAL/DORVAL", "CYUL", "YUL", "71627", "45.28N", "073.44W", "36", "CA"],
    ["QC MONTREAL/DORVAL", "CWTQ", "None", "71183", "45.28N", "073.45W", "32", "CA"],
    ["QC MONTREAL/MIRABEL", "CYMX", "YMX", "71626", "45.40N", "074.01W", "82", "CA"],
    ["QC NATASHQUAN AIRP", "CYNA", "YNA", "71813", "50.10N", "061.49W", "11", "CA"],
    ["QC NEMISCAU ARPT(SA", "CYHH", "YHH", "None", "51.42N", "076.07W", "244", "CA"],
    ["QC NEW CARLISLE1", "CWOC", "WOC", "71619", "48.01N", "065.19W", "47", "CA"],
    ["QC NICOLET (AUTOB)", "CWNQ", "WNQ", "71723", "46.13N", "072.39W", "10", "CA"],
    ["QC NORMANDIN", "CWOD", "WOD", "71379", "48.51N", "072.33W", "137", "CA"],
    ["QC ONATCHIWAY", "CWXC", "WXC", "71387", "48.53N", "071.02W", "300", "CA"],
    ["QC PARC DES LAURENT", "CWPD", "WPD", "71382", "47.34N", "071.13W", "803", "CA"],
    ["QC PARENT (MARS)", "CWPK", "WPK", "71726", "47.55N", "074.37W", "442", "CA"],
    ["QC POINTE DES MONTS", "CWTG", "WTG", "71427", "49.19N", "067.22W", "5", "CA"],
    ["QC POINTE NOIRES CS", "CWIP", "WIP", "71390", "50.10N", "066.26W", "25", "CA"],
    ["QC PORT MENIER (MAR", "CWBY", "WBY", "71810", "49.49N", "064.17W", "53", "CA"],
    ["QC PUVIRGNITUQ", "CYPX", "YPX", "None", "60.02N", "077.16W", "23", "CA"],
    ["QC POINTE CLAVEAU", "CWQV", "WQV", "71189", "48.16N", "070.07W", "1", "CA"],
    ["QC QUAQTAQ AIRPORT", "CYHA", "YHA", "71904", "61.02N", "069.37W", "30", "CA"],
    ["QC QUEBEC", "CYQB", "YQB", "71714", "46.47N", "071.22W", "73", "CA"],
    ["QC RAWDON", "CMWD", "None", "None", "46.01N", "073.49W", "210", "CA"],
    ["QC RIVIERE DU LOUP", "CWNH", "None", "71715", "47.47N", "069.32W", "148", "CA"],
    ["QC ROBERVAL AIRPORT", "CYRJ", "YRJ", "71728", "48.31N", "072.16W", "179", "CA"],
    ["QC ROUYN AIRPORT", "CYUY", "YUY", "None", "48.12N", "078.49W", "301", "CA"],
    ["QC SAINT HUBERT ARP", "CYHU", "YHU", "71371", "45.31N", "073.25W", "27", "CA"],
    ["QC SAINT LOUIS", "CMLI", "None", "None", "45.52N", "073.00W", "31", "CA"],
    ["QC SALLIUT ARPT (SA", "CYZG", "YZG", "None", "62.10N", "075.40W", "226", "CA"],
    ["QC SCHEFFERVILLE AR", "CYKL", "YKL", "71828", "54.47N", "066.49W", "521", "CA"],
    ["QC SEPT ILES AIRPOR", "CYZV", "YZV", "71811", "50.13N", "066.16W", "55", "CA"],
    ["QC SEPT ILES", "CXZV", "None", "None", "50.13N", "066.15W", "52", "CA"],
    ["QC SHAWINIGAN", "CXSH", "XSH", "71370", "46.35N", "072.44W", "110", "CA"],
    ["QC SHERBROOKE", "CYSC", "YSC", "71610", "45.26N", "071.41W", "241", "CA"],
    ["QC ST ANICET", "CWBZ", "WBZ", "71712", "45.07N", "074.16W", "49", "CA"],
    ["QC ST FOY/U LAVAL", "CWJB", "WJB", "71392", "46.47N", "071.16W", "91", "CA"],
    ["QC ST GEDEON", "CWIU", "WIU", "None", "48.29N", "071.47W", "103", "CA"],
    ["QC ST HENRI", "CWIA", "WIA", "None", "48.39N", "071.51W", "103", "CA"],
    ["QC ST JOVITE (AUTOB", "CWJT", "WJT", "71376", "46.04N", "074.34W", "239", "CA"],
    ["QC ST CLOTHILDE (A", "CWIT", "WIT", "71614", "45.10N", "073.40W", "52", "CA"],
    ["QC STE ANNE DE BELL", "CWVQ", "WVQ", "71377", "45.25N", "073.55W", "39", "CA"],
    ["QC TASIUJAQ A", "CYTQ", "YTQ", "None", "58.40N", "069.57W", "31", "CA"],
    ["QC TEMISCAMINQUE", "CWBA", "None", "71732", "46.43N", "079.06W", "181", "CA"],
    ["QC TROIS RIVIERES", "CWTY", "WTY", "71724", "46.21N", "072.31W", "6", "CA"],
    ["QC TROIS RIVIERES", "CYRQ", "None", "None", "46.21N", "072.41W", "61", "CA"],
    ["QC UMIUJAQ", "CYMU", "YMU", "None", "56.31N", "076.31W", "71", "CA"],
    ["QC VAL D'OR AIRPORT", "CYVO", "YVO", "71725", "48.04N", "077.46W", "337", "CA"],
    ["QC VALCARTIER AIRPO", "CYOY", "YOY", "71716", "46.53N", "071.30W", "168", "CA"],
    ["QC VARENNES", "CWHM", "WHM", "71184", "45.43N", "073.22W", "192", "CA"],
    ["QC VILLEROY RADAR", "CWVY", "WVY", "71616", "46.27N", "071.55W", "108", "CA"],
    ["QC WASKAGANISH AIRP", "CYKQ", "YKQ", "None", "51.28N", "078.45W", "23", "CA"],
    ["QC WEMINDJI", "CYNC", "YNC", "None", "53.01N", "078.49W", "14", "CA"],
    ["QC INUKJUAK", "CWPH", "WPH", "None", "58.27N", "078.07W", "253", "CA"],
    ["QC VALCARTIER", "CWQG", "WQG", "71151", "46.53N", "071.30W", "168", "CA"],
    ["QC VAL D IRENE RADR", "CXAM", "None", "None", "48.29N", "067.36W", "583", "CA"],
    ["QC BEAUHARNOS", "CMBR", "None", "None", "45.19N", "073.55W", "22", "CA"],
    ["QC ST CONSTANT", "CMCT", "None", "None", "45.20N", "073.35W", "39", "CA"],
    ["QC COVEY HILL", "CMCW", "None", "None", "45.01N", "073.52W", "262", "CA"],
    ["QC FORET MONTMORENC", "CMFM", "None", "71212", "47.19N", "071.09W", "672", "CA"],
    ["QC GRANBY", "CMGB", "None", "None", "45.22N", "072.46W", "86", "CA"],
    ["QC HOWICK", "CMHW", "None", "None", "45.10N", "073.52W", "42", "CA"],
    ["QC L ARTIFICE", "CMLA", "None", "None", "45.04N", "073.50W", "61", "CA"],
    ["QC PIEDMONT", "CMPD", "None", "None", "45.53N", "074.06W", "175", "CA"],
    ["QC S POLYCARPE71306", "CMPL", "None", "None", "45.18N", "074.18W", "56", "CA"],
    ["QC ROUGEMONT", "CMRG", "None", "None", "45.25N", "073.03W", "54", "CA"],
    ["QC RIGAUD", "CMRI", "None", "71305", "45.29N", "074.18W", "30", "CA"],
    ["QC RUSSELTOWN", "CMRU", "None", "None", "45.03N", "073.48W", "65", "CA"],
    ["QC RUISSEAU CRANB", "CMRY", "None", "None", "45.07N", "073.41W", "59", "CA"],
    ["QC ST SABINE", "CMSB", "None", "None", "45.13N", "073.01W", "49", "CA"],
    ["QC ST CELESTIN", "CMSC", "None", "None", "46.12N", "072.27W", "55", "CA"],
    ["QC ST M-D-NAPIERVIL", "CMSX", "None", "None", "45.11N", "073.37W", "59", "CA"],
    ["QC ST CHRYSOSTOME", "CMYT", "None", "None", "45.08N", "073.46W", "55", "CA"],
    ["SK ASSINIBOIA ARPT", "CWJI", "WJI", "71487", "49.43N", "105.55W", "724", "CA"],
    ["SK BROADVIEW", "CWIK", "WIK", "71861", "50.22N", "102.35W", "602", "CA"],
    ["SK BRATTS LAKE", "CXBK", "XBK", "71569", "50.12N", "104.42W", "580", "CA"],
    ["SK BROADVIEW CS", "CWXU", "None", "71737", "50.23N", "102.41W", "600", "CA"],
    ["SK BUFFALO NARROWS", "CWVT", "WVT", "71077", "55.49N", "108.25W", "434", "CA"],
    ["SK BUFFALO NARROWS", "CYVT", "YVT", "None", "55.49N", "108.25W", "434", "CA"],
    ["SK CANDLE LAKE", "CWLZ", "WLZ", "71146", "53.44N", "105.16W", "503", "CA"],
    ["SK CLUFF LAKE", "CXXX", "None", "71073", "58.23N", "109.31W", "339", "CA"],
    ["SK CORONACH SPC", "CWAQ", "WAQ", "71516", "49.03N", "105.29W", "756", "CA"],
    ["SK CYPRESS HILLS PA", "CWVP", "WVP", "71139", "49.38N", "109.31W", "1271", "CA"],
    ["SK EASTEND CYPRESS", "CWEH", "WEH", "71131", "49.25N", "108.58W", "1078", "CA"],
    ["SK ELBOW (MARS)", "CWOK", "WOK", "71450", "51.07N", "106.34W", "595", "CA"],
    ["SK ESTEVAN AIRPORT", "CYEN", "YEN", "71862", "49.13N", "102.58W", "581", "CA"],
    ["SK HUDSON BAY", "CYHB", "YHB", "71868", "52.49N", "102.19W", "358", "CA"],
    ["SK INDIAN HEAD CDA", "CWBD", "WBD", "71194", "50.33N", "103.39W", "582", "CA"],
    ["SK JIMMY LAKE", "CWHN", "WHN", "None", "54.53N", "109.58W", "636", "CA"],
    ["SK KEY LAKE", "CYKJ", "YKJ", "71488", "57.15N", "105.37W", "509", "CA"],
    ["SK KINDERSLEY", "CYKY", "YKY", "71129", "51.31N", "109.10W", "694", "CA"],
    ["SK LA RONGE AIRPORT", "CYVC", "YVC", "71922", "55.09N", "105.16W", "379", "CA"],
    ["SK LA RONGE AIRPORT", "CXOX", "XOX", "71586", "55.09N", "105.16W", "379", "CA"],
    ["SK LEADER ARPT (AUT", "CWJX", "WJX", "71459", "50.53N", "109.30W", "672", "CA"],
    ["SK LUCKY LAKE (AUTO", "CWLE", "WLE", "71455", "50.57N", "107.09W", "665", "CA"],
    ["SK MAPLECREEK (AUTO", "CWMQ", "WMQ", "71453", "49.54N", "109.28W", "767", "CA"],
    ["SK MEADOW LAKE AIRP", "CYLJ", "YLJ", "71125", "54.07N", "108.31W", "480", "CA"],
    ["SK MELFORT (AUTOB)", "CWFF", "WFF", "71456", "52.49N", "104.35W", "490", "CA"],
    ["SK MOOSE JAW (CAN M", "CYMJ", "YMJ", "71864", "50.19N", "105.32W", "577", "CA"],
    ["SK MOOSE JAW", "CZMJ", "None", "None", "50.20N", "105.34W", "577", "CA"],
    ["SK NIPAWIN AIRPORT", "CYBU", "YBU", "71130", "53.19N", "104.00W", "374", "CA"],
    ["SK NIPAWIN", "CWBU", "None", "None", "53.20N", "104.01W", "373", "CA"],
    ["SK NORTH BATTLEFORD", "CYQW", "YQW", "71876", "52.46N", "108.15W", "548", "CA"],
    ["SK PRINCE ALBERT AR", "CYPA", "YPA", "71869", "53.13N", "105.40W", "428", "CA"],
    ["SK REGINA AIRPORT", "CYQR", "YQR", "71863", "50.26N", "104.40W", "577", "CA"],
    ["SK REGINA UNIVERSIT", "CWDJ", "WDJ", "71514", "50.24N", "104.35W", "573", "CA"],
    ["SK ROCKGLEN (MARS)", "CWKO", "WKO", "71135", "49.10N", "105.58W", "917", "CA"],
    ["SK ROSETOWN EAST (A", "CWRJ", "WRJ", "71510", "51.34N", "107.55W", "586", "CA"],
    ["SK SASKATOON AIRPOR", "CYXE", "YXE", "71866", "52.10N", "106.42W", "504", "CA"],
    ["SK SOUTHEND (AUTOB)", "CWJH", "WJH", "71451", "56.19N", "103.16W", "344", "CA"],
    ["SK SPIRITWOOD WEST", "CWSR", "WSR", "71133", "53.22N", "107.32W", "584", "CA"],
    ["SK STONY RAPIDS ARP", "CYSF", "YSF", "71132", "59.15N", "105.49W", "250", "CA"],
    ["SK SWIFT CURREN", "CYYN", "YYN", "71870", "50.16N", "107.40W", "818", "CA"],
    ["SK URANIUM CITY(MAR", "CWDC", "WDC", "71076", "59.34N", "108.28W", "318", "CA"],
    ["SK VAL MARIE SE(AUT", "CWVN", "WVN", "71137", "49.04N", "107.34W", "785", "CA"],
    ["SK WATROUS EAST (AU", "CWIW", "WIW", "71511", "51.40N", "105.24W", "526", "CA"],
    ["SK WEYBURN (AUTOB)", "CWWF", "WWF", "71452", "49.42N", "103.48W", "589", "CA"],
    ["SK WYNYARD (AUT)", "CWOY", "WOY", "71865", "51.46N", "104.12W", "560", "CA"],
    ["SK YORKTON AIRPORT", "CYQV", "YQV", "71292", "51.16N", "102.28W", "498", "CA"],
    ["SK WALDRON VOR", "CYDR", "YDR", "None", "50.22N", "102.32W", "615", "CA"],
    ["SK CANADA ARTCC", "CZFD", "ZFD", "None", "59.19N", "107.11W", "131", "CA"],
    ["YT BEAVER CREEK ARP", "CYXQ", "YXQ", "None", "62.25N", "140.52W", "649", "CA"],
    ["YT BURWASH", "CYDB", "YDB", "71967", "61.22N", "139.03W", "801", "CA"],
    ["YT CARMACKS", "CXCK", "XCK", "71039", "62.07N", "136.12W", "540", "CA"],
    ["YT DAWSON AIRPORT", "CYDA", "YDA", "71966", "64.02N", "139.07W", "369", "CA"],
    ["YT FARO (MARS)", "CWUM", "WUM", "71949", "62.13N", "133.20W", "717", "CA"],
    ["YT FARO APT ARTCC", "CZFA", "ZFA", "None", "62.12N", "133.22W", "717", "CA"],
    ["YT HAINES JUNCTION", "CWHT", "WHT", "71505", "60.46N", "137.35W", "599", "CA"],
    ["YT HERSCHEL ISLAND", "CWJN", "None", "71501", "69.34N", "138.55W", "1", "CA"],
    ["YT KOMAKUK BEACH", "CWKM", "WKM", "71046", "69.36N", "140.10W", "13", "CA"],
    ["YT MARGARET LAKE", "CWZR", "None", "71977", "68.48N", "140.51W", "543", "CA"],
    ["YT MAYO AIRPORT", "CYMA", "None", "71965", "63.37N", "135.52W", "504", "CA"],
    ["YT OLD CROW AIRPORT", "CYOC", "YOC", "None", "67.34N", "139.49W", "251", "CA"],
    ["YT SHINGLE POINT AR", "CYUA", "YUA", "71968", "68.57N", "137.17W", "38", "CA"],
    ["YT STORM HILLS", "CWVH", "WVH", "71052", "68.54N", "133.56W", "261", "CA"],
    ["YT TESLIN (MARS)", "CWZW", "WZW", "None", "60.10N", "132.44W", "705", "CA"],
    ["YT TESLIN ARPT (AUT", "CYZW", "YZW", "71045", "60.10N", "132.45W", "705", "CA"],
    ["YT WATSON LAKE AIRP", "CYQH", "YQH", "71953", "60.07N", "128.49W", "690", "CA"],
    ["YT WATSON LAKE", "CXQH", "None", "71199", "60.07N", "128.49W", "690", "CA"],
    ["YT WHITEHORSE AIRPO", "CYXY", "YXY", "71964", "60.43N", "135.04W", "703", "CA"],
    ["ACAPULCO/G. ALVA", "MMAA", "ACA", "None", "16.45N", "099.45W", "5", "MX"],
    ["ACAPULCO/G. ALVA", "None", "None", "76805", "16.50N", "099.56W", "3", "MX"],
    ["AGUASCALIENTES", "MMAS", "AGU", "76571", "21.42N", "102.19W", "1863", "MX"],
    ["BAHIAS DE HUATUL", "MMBT", "HUX", "None", "15.46N", "096.16W", "143", "MX"],
    ["CAMPECHE/IGNACIO", "MMCP", "CPE", "76695", "19.49N", "090.30W", "5", "MX"],
    ["CANCUN", "MMUN", "CUN", "76595", "21.01N", "086.51W", "10", "MX"],
    ["CHETUMAL", "MMCM", "CTM", "76750", "18.30N", "088.20W", "12", "MX"],
    ["CHIHUAHUA INTL A", "MMCU", "CUU", "76225", "28.42N", "105.58W", "1372", "MX"],
    ["CIUDAD DEL CARM", "MMCE", "CME", "None", "18.39N", "091.48W", "2", "MX"],
    ["CIUDAD JUAREZ IN", "MMCS", "CJS", "None", "31.37N", "106.25W", "1171", "MX"],
    ["CHICHEN ITZA YU", "MMCT", "MCT", "None", "20.38N", "088.27W", "28", "MX"],
    ["CIUDAD OBREGON", "MMCN", "CEN", "None", "27.24N", "109.50W", "43", "MX"],
    ["CIUDAD VICTORIA", "MMCV", "CVM", "76491", "23.43N", "098.58W", "238", "MX"],
    ["COLIMA", "MMIA", "IMA", "76658", "19.16N", "103.34W", "723", "MX"],
    ["COZUMEL (CIV/MIL", "MMCZ", "CZM", "76648", "20.31N", "086.55W", "5", "MX"],
    ["CUERNAVACA", "MMCB", "CVJ", "76726", "18.50N", "099.16W", "1560", "MX"],
    ["CULIACAN (CITY)", "MMCL", "CUL", "76412", "24.46N", "107.28W", "39", "MX"],
    ["DEL BAJIO/LEON", "MMLO", "LEO", "76752", "21.00N", "101.28W", "1819", "MX"],
    ["GUADALAJARA", "MMGL", "GDL", "None", "20.31N", "103.19W", "1528", "MX"],
    ["GUADALAJARA", "None", "None", "76612", "20.40N", "103.23W", "1551", "MX"],
    ["DURANGO AIRPORT", "MMDO", "DGO", "76423", "24.07N", "104.31W", "1857", "MX"],
    ["GUAYMAS INTL ARP", "MMGM", "GYM", "None", "27.57N", "110.55W", "20", "MX"],
    ["EMPALME", "None", "None", "76256", "27.57N", "110.46W", "12", "MX"],
    ["HERMOSILLO INTL", "MMHO", "HMO", "76160", "29.05N", "111.03W", "184", "MX"],
    ["ISLA GUADALUPE", "MMGD", "GUD", "76151", "29.10N", "118.19W", "25", "MX"],
    ["ISLA SOCORRO", "MMSC", "SOC", "76723", "18.43N", "110.57W", "35", "MX"],
    ["IXTAPA ZIHUATANE", "MMZH", "ZIH", "None", "17.36N", "101.28W", "6", "MX"],
    ["IXTEPEC OX", "MMIT", "MIT", "None", "16.27N", "095.05W", "61", "MX"],
    ["LA PAZ INTL AIRP", "MMLP", "LAP", "None", "24.04N", "110.22W", "21", "MX"],
    ["LA PAZ", "None", "None", "76405", "24.10N", "110.18W", "18", "MX"],
    ["LORETO", "MMLT", "LTO", "76305", "26.01N", "111.20W", "15", "MX"],
    ["LOS MOCHIS AIRPO", "MMLM", "LMM", "None", "25.40N", "109.04W", "4", "MX"],
    ["MANZANILLO INTL", "MMZO", "ZLO", "None", "19.08N", "104.34W", "8", "MX"],
    ["MANZANILLO", "None", "None", "76654", "19.03N", "104.19W", "3", "MX"],
    ["MATAMOROS INTL", "MMMA", "MAM", "None", "25.46N", "097.31W", "8", "MX"],
    ["MAZATLAN/G. BUEL", "MMMZ", "MZT", "None", "23.10N", "106.16W", "10", "MX"],
    ["MAZATLAN", "None", "None", "76458", "23.12N", "106.25W", "4", "MX"],
    ["MERIDA INTL ARPT", "MMMD", "MID", "76644", "20.57N", "089.39W", "10", "MX"],
    ["MEXICALI INTL AR", "MMML", "MXL", "None", "32.37N", "115.14W", "22", "MX"],
    ["MEXICO CITY/LICE", "MMMX", "MEX", "None", "19.25N", "099.05W", "2238", "MX"],
    ["MEXICO CITY/TACU", "None", "None", "76679", "19.24N", "099.12W", "2313", "MX"],
    ["MINATITLAN", "MMMT", "MTT", "None", "18.06N", "094.34W", "40", "MX"],
    ["MONCLOVA", "MMMV", "MOV", "76342", "26.57N", "101.28W", "615", "MX"],
    ["MONTERREY INTL A", "MMAN", "MAN", "76394", "25.52N", "100.14W", "448", "MX"],
    ["MONTERREY/GEN MA", "MMMY", "MTY", "None", "25.46N", "100.05W", "387", "MX"],
    ["MORELIA NEW", "MMMM", "MLM", "76665", "19.51N", "101.01W", "1833", "MX"],
    ["NOGALES", "MMNG", "NOG", "None", "31.13N", "110.58W", "1222", "MX"],
    ["NUEVO LAREDO INT", "MMNL", "NLD", "None", "27.25N", "099.34W", "148", "MX"],
    ["OAXACA/XOXOCOTLA", "MMOX", "OAX", "76775", "17.00N", "096.43W", "1528", "MX"],
    ["PIEDRAS NEGRAS", "MMPG", "PNG", "76243", "28.39N", "100.31W", "250", "MX"],
    ["POCA RICA-TAJIN", "MMPA", "PAZ", "None", "20.30N", "097.28W", "142", "MX"],
    ["PUEBLA", "MMPB", "PBC", "76685", "19.10N", "098.22W", "2244", "MX"],
    ["PUERTO PENASCO", "MMPE", "None", "None", "31.21N", "113.31W", "9", "MX"],
    ["PALENQUE", "MMPQ", "None", "None", "17.32N", "091.59W", "61", "MX"],
    ["PUERTO ESCONDIDO", "MMPS", "PXM", "None", "15.52N", "097.04W", "88", "MX"],
    ["PUERTO VALLARTA", "MMPR", "PVR", "None", "20.40N", "105.15W", "6", "MX"],
    ["PUNTA PENASCO", "None", "PPE", "76061", "31.11N", "113.20W", "14", "MX"],
    ["QUERETARO", "MMQT", "QRO", "76625", "20.37N", "100.11W", "1813", "MX"],
    ["REYNOSA INTL ARP", "MMRX", "REX", "None", "26.01N", "098.13W", "39", "MX"],
    ["SALTILLO", "MMIO", "SLW", "76390", "25.33N", "100.56W", "1790", "MX"],
    ["SAN JOSE DEL CAB", "MMSD", "SJD", "None", "23.08N", "109.42W", "109", "MX"],
    ["CABO SAN LUCAS", "MMSL", "None", "None", "22.57N", "109.56W", "140", "MX"],
    ["SAN LUIS POTOSI", "MMSP", "SLP", "76539", "22.15N", "100.56W", "1903", "MX"],
    ["SANTA ROSALIA", "None", "SRL", "76253", "27.19N", "112.17W", "75", "MX"],
    ["TAMPICO/GEN FJ M", "MMTM", "TAM", "76548", "22.16N", "097.52W", "24", "MX"],
    ["TAPACHULA", "MMTP", "TAP", "None", "14.46N", "092.22W", "29", "MX"],
    ["TAPACHULA", "None", "None", "76903", "14.53N", "092.18W", "119", "MX"],
    ["TEPIC", "MMEP", "TPQ", "76556", "21.25N", "104.51W", "922", "MX"],
    ["TIJUANA INTL ARP", "MMTJ", "TIJ", "None", "32.32N", "116.58W", "152", "MX"],
    ["TOLUCA/JOSE MARI", "MMTO", "TLC", "None", "19.21N", "099.34W", "2576", "MX"],
    ["TORREON AIRPORT", "MMTC", "TRC", "76382", "25.34N", "103.24W", "1124", "MX"],
    ["TULANCINGO", "MMTL", "TCG", "76634", "20.04N", "098.22W", "2181", "MX"],
    ["TUXTLA GUTIERREZ", "MMTG", "TGZ", "76843", "16.34N", "093.02W", "528", "MX"],
    ["TUXTLA GUTIERREZ", "MMTB", "TGM", "None", "16.44N", "093.10W", "528", "MX"],
    ["URUAPAN/GEN RAYO", "MMPN", "UPN", "None", "19.23N", "102.01W", "1593", "MX"],
    ["VERACRUZ", "MMVR", "VER", "76692", "19.09N", "096.11W", "16", "MX"],
    ["VILLAHERMOSA", "MMVA", "VSA", "None", "18.00N", "092.49W", "13", "MX"],
    ["VILLAHERMOSA", "None", "None", "76743", "17.59N", "092.56W", "6", "MX"],
    ["ZACATECAS ARPT", "MMZC", "ZCL", "None", "22.54N", "102.41W", "2177", "MX"],
    ["ZACATECAS", "None", "None", "76526", "22.45N", "102.30W", "2265", "MX"],
    ["GUADALUPE/ZACATE", "MMZA", "None", "None", "22.45N", "102.30W", "2265", "MX"],
    ["TAPACHULA", "None", "None", "76904", "14.46N", "092.22W", "29", "MX"],
    ["GU AGANA", "PGUM", "None", "None", "13.29N", "144.48E", "91", "US"],
    ["GU MARIANA/ANDERSEN", "PGUA", "None", "91218", "13.34N", "144.55E", "187", "US"],
    ["GU TAGUAC", "PGAC", "None", "91212", "13.33N", "144.49E", "111", "US"],
    ["GU TAGUAC", "None", "None", "91217", "13.33N", "144.49E", "111", "US"],
    ["GU PEIPEINIMARU/TIN", "PGWT", "None", "91233", "14.59N", "145.37E", "82", "US"],
    ["UM PAGAN/N. MARIANA", "PAGP", "None", "99451", "18.00N", "145.25E", "2", "US"],
    ["UM SABANETTAN/TINIA", "PGNT", "None", "None", "15.00N", "145.37E", "80", "US"],
    ["UM WEST TINIAN", "PGTI", "None", "None", "15.00N", "145.37E", "82", "US"],
    ["UM JOHNSTON ISLAND", "PJON", "None", "91275", "16.44N", "169.31W", "5", "US"],
    ["UM WAKE ISLAND AIRF", "PWAK", "None", "91245", "19.17N", "166.39E", "4", "US"],
    ["UM CHRISTMAS/CASSID", "PLCH", "None", "91490", "01.59N", "157.21W", "3", "US"],
    ["UM FANNING ISLAND", "PLFA", "None", "91487", "03.51N", "159.22W", "5", "US"],
    ["UM PALMYRA/COOPER(A", "PLPA", "None", "91385", "05.52N", "162.03W", "2", "US"],
    ["UM ENIWETOK AUX AF", "PKMA", "None", "91250", "11.20N", "162.20E", "5", "US"],
    ["UM JARVIS ISLAND (A", "PLUR", "None", "91901", "00.22S", "160.01W", "2", "US"],
    ["MH MAJURO WSO AIRPO", "PKMJ", "None", "91376", "07.04N", "171.16E", "3", "US"],
    ["MH MAJURO ATOLL/NWS", "PKMR", "None", "None", "07.05N", "171.23E", "4", "US"],
    ["MH KWAJALEIN/BUCHOL", "PKWA", "None", "91366", "08.43N", "167.43E", "8", "US"],
    ["MH MILI/MARSHALL IS", "MLIP", "None", "99450", "06.00N", "172.00E", "0", "US"],
    ["UJAE ATOLL/MARSH", "UJAP", "None", "99449", "08.55N", "165.45E", "2", "RU"],
    ["ENEWETAK/MARSHAL", "ENIP", "None", "99448", "11.22N", "162.22E", "2", "NO"],
    ["WENO IS/CHUUK", "PTKK", "None", "91334", "07.28N", "151.51E", "2", "FM"],
    ["YAP ISLAND", "PTYA", "None", "91413", "09.29N", "138.05E", "17", "FM"],
    ["BABELTHUAP/KOROR", "PTRO", "None", "91408", "07.22N", "134.33E", "54", "FM"],
    ["KOROR PALAU/NWS", "PTKR", "None", "None", "07.20N", "134.29E", "30", "FM"],
    ["KOSRAE ISLAND", "PTSA", "None", "91356", "05.21N", "162.57E", "3", "FM"],
    ["POHNPEI NWS", "PTTP", "None", "91348", "06.58N", "158.13E", "2", "FM"],
    ["POHNPEI AIRPORT", "PTPN", "None", "None", "06.58N", "158.13E", "2", "FM"],
    ["SAIPAN/KOBLER", "PGSN", "None", "91232", "15.07N", "145.43E", "65", "FM"],
    ["ROTA INTL AIRP", "PGRO", "None", "91221", "14.11N", "145.15E", "185", "FM"],
    ["KOSRAE CAROLINES", "PTTK", "None", "91355", "05.20N", "162.56E", "2", "FM"],
    ["PR AGUADILLA/BORINQ", "TJBQ", "None", "78514", "18.30N", "067.08W", "72", "US"],
    ["PR FERN LUIS RIBAS", "TJIG", "None", "None", "18.27N", "066.06W", "3", "US"],
    ["PR MAYAGUEZ/EUGENIO", "TJMZ", "None", "None", "18.16N", "067.09W", "9", "US"],
    ["PR ROOSEVELT RD NAS", "TJNR", "None", "78535", "18.15N", "065.38W", "12", "US"],
    ["PR PONCE/MERCEDITA", "TJPS", "None", "None", "18.01N", "066.34W", "9", "US"],
    ["PR SAN JUAN/CAYEY", "TJUA", "JUA", "None", "18.07N", "066.05W", "852", "US"],
    ["PR SAN JUAN/WFO", "TJSJ", "SJU", "78526", "18.26N", "066.01W", "21", "US"],
    ["PROVIDENCIALES", "MBPV", "None", "None", "21.46N", "072.16W", "5", "BS"],
    ["ANDROS TOWN", "MYAF", "None", "None", "24.41N", "077.47W", "2", "BS"],
    ["KEMPS BAY/ANDR", "MYAK", "None", "78086", "24.04N", "077.32W", "4", "BS"],
    ["ALICE TOWN/S BI", "MYBS", "None", "78070", "25.42N", "079.16W", "3", "BS"],
    ["EXUMA INTL", "MYEF", "None", "None", "23.34N", "075.53W", "3", "BS"],
    ["GEORGE TOWN/EXU", "MYEG", "None", "78092", "23.30N", "075.46W", "3", "BS"],
    ["N ELEUTHERA", "MYEH", "None", "78075", "25.28N", "076.41W", "3", "BS"],
    ["ROCK SOUND(PRIVA", "MYER", "None", "None", "24.53N", "076.10W", "3", "BS"],
    ["FREEPORT INTL A", "MYGF", "None", "78062", "26.33N", "078.42W", "2", "BS"],
    ["GRAND BAHAMA AUX", "MYGM", "None", "None", "26.40N", "078.19W", "2", "BS"],
    ["WEST END INTL A", "MYGW", "None", "78061", "26.42N", "078.58W", "4", "BS"],
    ["MATTHEW TOWN/INA", "MYIG", "None", "78121", "20.56N", "073.40W", "4", "BS"],
    ["NASSAU INTL", "MYNN", "None", "78073", "25.02N", "077.28W", "3", "BS"],
    ["COCKBURN/SAN SAL", "MYSM", "None", "78088", "24.03N", "074.31W", "5", "BS"],
    ["TURKS ISLAND", "MBGT", "None", "78118", "21.26N", "071.09W", "4", "BS"],
    ["TURKS/MCCARTNEY", "MBJT", "None", "None", "21.26N", "071.09W", "4", "BS"],
    ["BARACOA ORIENTE", "MUBA", "None", "78268", "20.21N", "074.30W", "9", "CU"],
    ["BAYAMO", "MUBY", "None", "None", "20.24N", "076.37W", "64", "CU"],
    ["VENEZUELA/CIEGO", "MUCA", "None", "78346", "22.02N", "078.47W", "101", "CU"],
    ["CANAGUA", "MUCC", "None", "None", "22.28N", "078.20W", "4", "CU"],
    ["CIENFUEGOS(CIV/M", "MUCF", "None", "78244", "22.08N", "080.24W", "39", "CU"],
    ["CAMAGUEY/IGANCI", "MUCM", "None", "78255", "21.25N", "077.51W", "122", "CU"],
    ["COLON", "MUCO", "None", "78332", "22.40N", "080.55W", "35", "CU"],
    ["CAYO LARGO D SUR", "MUCL", "None", "None", "21.38N", "081.33W", "5", "CU"],
    ["SANTIAGO DE CUB", "MUCU", "None", "78264", "19.58N", "075.50W", "76", "CU"],
    ["GUANTANAMO", "MUGT", "None", "78267", "20.05N", "075.09W", "8", "CU"],
    ["GUANTANAMO BAY", "MUGM", "None", "78367", "19.54N", "075.12W", "17", "CU"],
    ["HAVANA/JOSE MAR", "MUHA", "None", "78224", "22.58N", "082.25W", "64", "CU"],
    ["HOLGUIN (CIV/MIL", "MUHG", "None", "None", "20.46N", "076.19W", "106", "CU"],
    ["MOA MILITARY", "MUMO", "None", "None", "20.39N", "074.55W", "5", "CU"],
    ["MANZANILLO", "MUMZ", "None", "78256", "20.17N", "077.06W", "60", "CU"],
    ["NUEVA GERONA (M", "MUNG", "None", "78221", "21.50N", "082.47W", "23", "CU"],
    ["PLAYA BARACOA", "MUPB", "None", "None", "23.02N", "082.35W", "31", "CU"],
    ["PINAR DEL RIO NO", "MUPR", "None", "78315", "22.25N", "083.40W", "37", "CU"],
    ["SAN ANTONIO BANO", "MUSA", "None", "None", "22.52N", "082.31W", "50", "CU"],
    ["SANTA CLARA", "MUSC", "None", "None", "22.30N", "079.57W", "103", "CU"],
    ["SAN JULIAN(MIL/C", "MUSJ", "None", "None", "22.06N", "084.09W", "30", "CU"],
    ["SANTA LUCIA", "MUSL", "None", "78312", "22.40N", "083.58W", "24", "CU"],
    ["SIGUANEA", "MUSN", "None", "None", "21.39N", "082.57W", "11", "CU"],
    ["TRINIDAD", "MUTD", "None", "78337", "21.46N", "079.58W", "54", "CU"],
    ["VARADERO", "MUVR", "None", "78229", "23.02N", "081.26W", "65", "CU"],
    ["LAS TUMAS", "MUVT", "None", "78357", "20.57N", "076.57W", "106", "CU"],
    ["KINGSTON/NORMAN", "MKJP", "None", "78397", "17.55N", "076.47W", "3", "JM"],
    ["SANGSTER/MONTEG", "MKJS", "None", "78388", "18.30N", "077.55W", "1", "JM"],
    ["GRND CAYMAN/OWEN", "MWCR", "None", "78384", "19.18N", "081.22W", "3", "KY"],
    ["GERRARD SMITH", "MWCB", "None", "None", "19.41N", "079.53W", "2", "KY"],
    ["GRAND CAYMAN", "MWCG", "None", "78383", "19.15N", "081.25W", "6", "KY"],
    ["LES CAYES", "MTCA", "None", "78447", "18.10N", "073.43W", "2", "HT"],
    ["CAP-HAITIEN", "MTCH", "None", "78409", "19.45N", "072.11W", "2", "HT"],
    ["PORT-AU-PRINCE", "MTPP", "None", "78439", "18.34N", "072.17W", "37", "HT"],
    ["CAMP CANARGUS", "CTPP", "None", "None", "18.34N", "072.19W", "38", "HT"],
    ["ARROYO BARRIL", "MDAB", "None", "None", "19.12N", "069.26W", "35", "DO"],
    ["BARAHONA", "MDBH", "None", "78482", "18.15N", "071.07W", "3", "DO"],
    ["EL CATEY INTL", "MDCY", "None", "None", "19.16N", "069.44W", "10", "DO"],
    ["CAUCEDO/DE LAS", "MDSD", "None", "78485", "18.25N", "069.40W", "18", "DO"],
    ["HERRERA", "MDHE", "None", "78484", "18.28N", "069.58W", "58", "DO"],
    ["DR BALAGUER INTL", "MDJB", "None", "None", "18.34N", "069.59W", "30", "DO"],
    ["LA ROMANA INT. A", "MDLR", "None", "None", "18.27N", "068.55W", "8", "DO"],
    ["MONTE CRISTI", "MDMC", "None", "78451", "19.52N", "071.39W", "2", "DO"],
    ["PUERTO PLATA IN", "MDPP", "None", "78457", "19.45N", "070.34W", "5", "DO"],
    ["PUNTA CANA", "MDPC", "None", "78479", "18.34N", "068.22W", "12", "DO"],
    ["SANTIAGO INTL A", "MDST", "None", "78460", "19.24N", "070.36W", "184", "DO"],
    ["SANTO DOMINGO", "TSDM", "None", "78486", "18.28N", "069.53W", "14", "DO"],
    ["CANEFIELD AIRPOR", "TDCF", "None", "78906", "15.20N", "061.24W", "5", "DM"],
    ["MELVILLE HALL AR", "TDPD", "None", "78905", "15.33N", "061.18W", "14", "DM"],
    ["ROSEAU", "TDPR", "None", "78907", "15.18N", "061.23W", "72", "DM"],
    ["CHARLOTTE AMALIE", "KSTT", "None", "None", "18.20N", "064.59W", "15", "VI"],
    ["CHRISTIANSTED", "TISX", "None", "78547", "17.42N", "064.48W", "19", "VI"],
    ["ST THOMAS (KING)", "TIST", "None", "78543", "18.20N", "064.59W", "7", "VI"],
    ["ST MAARTEN JULIA", "TNCM", "None", "78866", "18.03N", "063.07W", "4", "VI"],
    ["HATO AIR CURACAO", "TNCC", "None", "78988", "12.12N", "068.58W", "9", "VI"],
    ["WALL BLAKE", "TQPF", "None", "78846", "18.11N", "063.02W", "31", "VI"],
    ["BEEF ISL/ROADTOW", "TUPJ", "None", "78550", "18.26N", "064.31W", "4", "VI"],
    ["COOLIDGE/ANTIGUA", "TAPA", "None", "78862", "17.07N", "061.47W", "14", "AG"],
    ["LE LAMENTIN/MART", "TFFF", "None", "78925", "14.36N", "061.00W", "5", "MQ"],
    ["GUSTAVIA/ST.BART", "TFFJ", "None", "78894", "17.54N", "062.51W", "290", "GP"],
    ["LE RAIZET", "TFFR", "None", "78897", "16.16N", "061.32W", "11", "GP"],
    ["GOLDEN ROCKS/NEV", "TKPK", "None", "78858", "17.18N", "062.43W", "48", "KN"],
    ["CHARLESTOWN/NEWC", "TKPN", "None", "78859", "17.11N", "062.34W", "17", "AG"],
    ["VIGIE/ST LUCIA", "TLPC", "None", "78947", "14.01N", "061.00W", "2", "LC"],
    ["HEWANORRA INTL", "TLPL", "None", "78948", "13.45N", "060.57W", "3", "LC"],
    ["QUEEN BEATRIX", "TNCA", "None", "78982", "12.30N", "070.00W", "18", "AW"],
    ["BONAIRE/FLAMINGO", "TNCB", "None", "78990", "12.08N", "068.17W", "6", "AN"],
    ["FDR ARPT/ORANJES", "TNCE", "None", "78873", "17.28N", "062.58W", "39", "AN"],
    ["BLACKBURNE/PLYMO", "TRPM", "None", "None", "16.45N", "062.10W", "12", "AG"],
    ["J F MITCHELL ARP", "TVSB", "None", "None", "12.59N", "061.16W", "4", "VC"],
    ["CANOUAN AIRPORT", "TVSC", "None", "None", "12.42N", "061.21W", "4", "VC"],
    ["MUSTIQUE", "TVSM", "None", "None", "12.53N", "061.11W", "2", "VC"],
    ["UNION ISLAND", "TVSU", "None", "None", "12.36N", "061.25W", "15", "VC"],
    ["ARNOS VALE/ST V", "TVSV", "None", "78951", "13.08N", "061.12W", "9", "VC"],
    ["ANTIGUA/COOLIDG", "MCOL", "None", "78861", "17.07N", "061.46W", "10", "AG"],
    ["GRANTLEY ADAMS", "TBPB", "None", "78954", "13.04N", "059.29W", "52", "BB"],
    ["BRIDGETOWN CITY", "TBPO", "None", "None", "13.05N", "059.37W", "50", "BB"],
    ["POINT SALINES", "TGPY", "None", "78958", "12.00N", "061.47W", "7", "GD"],
    ["PEARLS AIRPORT", "MKPE", "None", "78956", "12.09N", "061.37W", "6", "GD"],
    ["JOHN OSBORNE APT", "TRPG", "None", "None", "16.47N", "062.12W", "168", "MS"],
    ["PIARCO INT AIRPT", "TTPP", "None", "78970", "10.35N", "061.21W", "15", "TT"],
    ["CROWN PT/SCARBOR", "TTCP", "None", "None", "11.09N", "060.51W", "8", "TT"],
    ["PORT OF SPAIN", "TTPS", "None", "78967", "10.39N", "061.31W", "2", "TT"],
    ["CROWN POINT AIRP", "TTPT", "None", "78962", "11.09N", "060.50W", "6", "TT"],
    ["BERMUDA NAS", "TXKF", "None", "78016", "32.22N", "064.41W", "6", "BM"],
    ["BELIZE INTL", "MZBZ", "None", "78583", "17.31N", "088.18W", "5", "BZ"],
    ["COBAN", "MGCB", "None", "None", "15.29N", "090.25W", "1316", "GT"],
    ["CHAMPERICO", "MGCP", "None", "None", "14.18N", "091.54W", "11", "GT"],
    ["ESQUIPULAS", "MGES", "None", "None", "14.34N", "089.19W", "965", "GT"],
    ["FLORES/SANTA EL", "MGFL", "None", "78615", "16.55N", "089.53W", "115", "GT"],
    ["AURORA ARP", "MGGI", "None", "None", "14.35N", "090.31W", "1489", "GT"],
    ["GUATEMALA/LA AU", "MGGT", "None", "78641", "14.34N", "090.32W", "1509", "GT"],
    ["HUEHUETENANGO", "MGHT", "None", "78627", "15.19N", "091.30W", "1901", "GT"],
    ["MELCHOR DE MENCO", "MGMM", "None", "None", "17.04N", "089.09W", "105", "GT"],
    ["PUERTO BARRIOS(", "MGPB", "None", "78637", "15.43N", "088.35W", "10", "GT"],
    ["POPTUN", "MGPP", "None", "78625", "16.19N", "089.25W", "500", "GT"],
    ["QUEZALTENANGO", "MGQZ", "None", "None", "14.52N", "091.30W", "2371", "GT"],
    ["RETALHULEU (MIL/", "MGRT", "None", "None", "14.32N", "091.42W", "200", "GT"],
    ["SAN JOSE (CIV/M", "MGSJ", "None", "78647", "13.55N", "090.50W", "9", "GT"],
    ["TIKAL INTL", "MGTK", "None", "None", "16.55N", "089.52W", "128", "GT"],
    ["ZACAPA", "MGZA", "None", "None", "14.58N", "089.31W", "490", "GT"],
    ["AMAPALA/LOS PEL", "MHAM", "None", "78700", "13.16N", "087.39W", "5", "HN"],
    ["CATACAMAS", "MHCA", "None", "78714", "14.54N", "085.47W", "442", "HN"],
    ["ISLAS DEL CISNE", "MHIC", "None", "78501", "17.23N", "083.55W", "11", "HN"],
    ["ISLA DE GUANAJA", "MHNJ", "None", "78701", "16.27N", "085.54W", "15", "HN"],
    ["NUEVA OCOTEPEQUE", "MHNO", "None", "78718", "14.26N", "089.11W", "2", "HN"],
    ["LA CEIBA/GOLOSO", "MHLC", "None", "78705", "15.45N", "086.51W", "15", "HN"],
    ["LA ESPERANZA", "MHLE", "None", "78719", "14.19N", "088.09W", "1100", "HN"],
    ["LA MESA/PEDRO S", "MHLM", "None", "78708", "15.27N", "087.56W", "26", "HN"],
    ["PUERTO LEMPIRA", "MHPL", "None", "78711", "15.16N", "083.47W", "13", "HN"],
    ["ROATAN", "MHRO", "None", "78703", "16.19N", "086.32W", "5", "HN"],
    ["SOTO CANO AB", "MHSC", "None", "None", "14.22N", "087.37W", "626", "HN"],
    ["SANTA ROSA DE C", "MHSR", "None", "78717", "14.47N", "088.47W", "1079", "HN"],
    ["TEGUCIGALPA/TON", "MHTG", "None", "78720", "14.04N", "087.13W", "1004", "HN"],
    ["TELA", "MHTE", "None", "78706", "15.47N", "087.29W", "3", "HN"],
    ["YORO", "MHYR", "None", "78707", "15.08N", "087.07W", "670", "HN"],
    ["TRUJILLO", "MHTR", "None", "78704", "15.56N", "085.56W", "3", "HN"],
    ["CHOLUTECA", "MHCH", "None", "78724", "13.19N", "087.09W", "48", "HN"],
    ["TEGUCIGALPA", "TRPA", "None", "None", "14.03N", "087.13W", "1004", "HN"],
    ["ACAJUTLA/SONSON", "MSAC", "None", "78650", "13.34N", "089.50W", "15", "SV"],
    ["EL SALVADOR INT", "MSLP", "None", "78666", "13.26N", "089.03W", "25", "SV"],
    ["LA UNION", "MSLU", "None", "78672", "13.20N", "087.53W", "5", "SV"],
    ["ILOPANGO/S.SALV", "MSSS", "None", "78663", "13.42N", "089.07W", "616", "SV"],
    ["SANTA ANA", "MSSA", "None", "78655", "13.58N", "089.34W", "725", "SV"],
    ["SAN MIGUEL", "MSSM", "None", "78670", "13.26N", "088.07W", "80", "SV"],
    ["BLUEFIELDS", "MNBL", "None", "78745", "12.00N", "083.46W", "5", "NI"],
    ["MANAGUA/AUGUSTO", "MNMG", "None", "78741", "12.09N", "086.10W", "59", "NI"],
    ["PUERTO CABEZAS(", "MNPC", "None", "78730", "14.03N", "083.23W", "16", "NI"],
    ["CHINANDEGA", "MNCH", "None", "78739", "12.37N", "087.07W", "53", "NI"],
    ["JINOTEGA", "MNJG", "None", "78734", "13.05N", "086.01W", "985", "NI"],
    ["JUIGALPA", "MNJU", "None", "78735", "12.05N", "085.22W", "90", "NI"],
    ["LEON/FANOR URROZ", "MNLN", "None", "None", "12.25N", "086.54W", "100", "NI"],
    ["RIVAS", "MNRS", "None", "78733", "11.25N", "085.49W", "53", "NI"],
    ["CHACHARITA", "MRCH", "None", "None", "09.59N", "084.47W", "2", "CR"],
    ["LIBERIA/DANIEL ODUBER", "MRLB", "LIR", "78774", "10.36N", "085.33W", "82", "CR"],
    ["LIMON INTL AIRP", "MRLM", "LIO", "78767", "09.58N", "083.02W", "2", "CR"],
    ["NICOYA", "MRNC", "None", "78755", "10.09N", "085.27W", "120", "CR"],
    ["JUAN SANTAMARIA", "MROC", "SJO", "78762", "10.00N", "084.13W", "920", "CR"],
    ["PALMAR SUR", "MRPM", "None", "78772", "08.56N", "083.28W", "15", "CR"],
    ["PUNTARENAS", "MRPT", "None", "78760", "09.58N", "084.49W", "3", "CR"],
    ["TOBIAS BOLANOS", "MRPV", "SQY", "78764", "09.57N", "084.09W", "994", "CR"],
    ["BOCAS DEL TORO", "MPBO", "None", "None", "09.21N", "082.15W", "3", "PA"],
    ["DAVID/ENRIQUE M", "MPDA", "None", "78793", "08.24N", "082.26W", "27", "PA"],
    ["COLON", "MPEJ", "None", "78794", "09.21N", "079.52W", "8", "PA"],
    ["HOWARD AFB", "MPHO", "None", "78806", "08.55N", "079.36W", "13", "PA"],
    ["MARCOS GELABERT", "MPMG", "None", "None", "08.59N", "079.34W", "13", "PA"],
    ["PANAMA PACIFICO", "MPPA", "None", "None", "08.55N", "079.36W", "13", "PA"],
    ["SANTIAGO", "MPSA", "None", "78795", "08.04N", "080.56W", "83", "PA"],
    ["TOCUMEN", "MPTO", "None", "78792", "09.03N", "079.22W", "45", "PA"],
    ["ENRIQUE ADOLFO J", "MPCF", "None", "None", "09.20N", "079.52W", "8", "PA"],
    ["CAPTAIN MANUEL N", "MPCH", "None", "None", "09.27N", "082.31W", "6", "PA"],
    ["FT SHERMAN (ROCO", "MPFS", "None", "78801", "09.19N", "079.58W", "52", "PA"],
    ["JAQUE", "MPJE", "None", "None", "07.31N", "078.09W", "9", "PA"],
    ["ALBROOK AFS/BALB", "MPLB", "None", "None", "08.58N", "079.32W", "9", "PA"],
    ["LA PALMA", "MPLP", "None", "None", "08.24N", "078.07W", "10", "PA"],
    ["AUGUSTO VERGARA", "MPNU", "None", "None", "07.49N", "080.16W", "21", "PA"],
    ["PUERTO OBALDIA", "MPOA", "None", "None", "08.40N", "077.25W", "1", "PA"],
    ["RIO HATO", "MPRH", "None", "None", "08.22N", "080.07W", "31", "PA"],
    ["SCARLETT MARTINE", "MPSM", "None", "None", "08.21N", "080.08W", "0", "PA"],
    ["EL PORVENIR", "MPVR", "None", "78788", "09.34N", "078.58W", "2", "PA"],
    ["ARMENIA/EL EDEN", "SKAR", "None", "80211", "04.27N", "075.46W", "1219", "CO"],
    ["PUERTO ASIS", "SKAS", "None", "80372", "00.30N", "076.30W", "254", "CO"],
    ["EL BANCO/LAS FLO", "SKBC", "None", "80074", "09.04N", "073.58W", "34", "CO"],
    ["BUCARAMANGO/PALO", "SKBG", "None", "80094", "07.08N", "073.11W", "1189", "CO"],
    ["BOGOTA/ELDORADO", "SKBO", "None", "80222", "04.42N", "074.07W", "2548", "CO"],
    ["BARRANQUILLA/ERN", "SKBQ", "None", "80028", "10.54N", "074.46W", "10", "CO"],
    ["BAHIA SOLANO/JOS", "SKBS", "None", "None", "06.10N", "077.24W", "24", "CO"],
    ["BUENAVENTURA", "SKBU", "None", "80252", "03.52N", "077.04W", "15", "CO"],
    ["CUCUTA/CAMILO DA", "SKCC", "None", "80097", "07.55N", "072.31W", "317", "CO"],
    ["CARTAGENA/RAFAEL", "SKCG", "None", "80022", "10.26N", "075.31W", "1", "CO"],
    ["CALI/ALFONSO BON", "SKCL", "None", "80259", "03.32N", "076.22W", "969", "CO"],
    ["TUMACO/LA FLORID", "SKCO", "None", "80336", "01.49N", "078.45W", "6", "CO"],
    ["BARRANCABERMEJA", "SKEJ", "None", "80091", "07.01N", "073.47W", "134", "CO"],
    ["FLORENCIA/CAPITO", "SKFL", "None", "80354", "01.36N", "075.31W", "244", "CO"],
    ["GIRARDOT/SANTIAG", "SKGI", "None", "80219", "04.16N", "074.47W", "293", "CO"],
    ["GUAPI", "SKGP", "None", "80300", "02.34N", "077.54W", "54", "CO"],
    ["IBAGUE/PERALES", "SKIB", "None", "80214", "04.25N", "075.09W", "928", "CO"],
    ["IPIALES/SAN LUIS", "SKIP", "None", "80370", "00.53N", "077.40W", "2961", "CO"],
    ["APARTADO/LOS CED", "SKLC", "None", "80084", "07.49N", "076.42W", "30", "CO"],
    ["LETICIA/VASQUEZ", "SKLT", "None", "80398", "04.12S", "069.56W", "84", "CO"],
    ["MEDELLIN/OLAYA H", "SKMD", "None", "80110", "06.13N", "075.35W", "1499", "CO"],
    ["MONTERIA/LOS GAR", "SKMR", "None", "80063", "08.49N", "075.50W", "26", "CO"],
    ["MITU", "SKMU", "None", "80361", "01.07N", "070.02W", "207", "CO"],
    ["MANIZALES LNUBIA", "SKMZ", "None", "80149", "05.02N", "075.28W", "2080", "CO"],
    ["NEIVA/LA MANGUIT", "SKNV", "None", "80315", "02.58N", "075.17W", "443", "CO"],
    ["OTU", "SKOT", "None", "80089", "07.00N", "074.43W", "630", "CO"],
    ["PUERTO CARRENO", "SKPC", "None", "80139", "06.10N", "067.30W", "55", "CO"],
    ["PEREIRA/MATECANA", "SKPE", "None", "80210", "04.49N", "075.44W", "1346", "CO"],
    ["PITALITO", "SKPI", "None", "80346", "01.52N", "076.02W", "1320", "CO"],
    ["POPAYAN/GUILLERM", "SKPP", "None", "80308", "02.28N", "076.35W", "1730", "CO"],
    ["PASTO/ANTONIO NA", "SKPS", "None", "80342", "01.24N", "077.17W", "1826", "CO"],
    ["PROVIDENCIA ISLA", "SKPV", "None", "80002", "13.22N", "081.20W", "6", "CO"],
    ["MARIQUITA", "SKQU", "None", "None", "05.13N", "074.52W", "467", "CO"],
    ["RIONEGRO/JOSE MA", "SKRG", "None", "80112", "06.10N", "075.25W", "2137", "CO"],
    ["RIOHACHA/ALMIRAN", "SKRH", "None", "80035", "11.31N", "072.55W", "4", "CO"],
    ["SAN JOSE GUAVIAR", "SKSJ", "None", "80322", "02.34N", "072.37W", "155", "CO"],
    ["SANTA MARTA/SIMO", "SKSM", "None", "80009", "11.07N", "074.13W", "4", "CO"],
    ["SAN ANDRES ISLAN", "SKSP", "None", "80001", "12.34N", "081.43W", "-2", "CO"],
    ["TRINIDAD", "SKTD", "None", "80175", "05.25N", "071.39W", "217", "CO"],
    ["TURBO/GONZALO ME", "SKTU", "None", "80062", "08.07N", "076.43W", "5", "CO"],
    ["ARAUCA/SANTIAGO", "SKUC", "None", "80099", "07.04N", "070.43W", "128", "CO"],
    ["QUIBDO/EL CARANO", "SKUI", "None", "80144", "05.43N", "076.37W", "33", "CO"],
    ["TULUA/FARFAN", "SKUL", "None", "None", "04.05N", "076.13W", "955", "CO"],
    ["VALLEDUPAR/ALFON", "SKVP", "None", "80036", "10.25N", "073.15W", "138", "CO"],
    ["VILLAVICENCIO/VA", "SKVV", "None", "80234", "04.10N", "073.37W", "431", "CO"],
    ["YOPAL/EL ALCARAV", "SKYP", "None", "None", "05.19N", "072.23W", "312", "CO"],
    ["GAVIOTAS", "MCGV", "None", "80241", "04.32N", "070.55W", "167", "CO"],
    ["ACARIGUA/OSWALDO", "SVAC", "None", "80427", "09.33N", "069.13W", "225", "VE"],
    ["BARCELONA/GEN JO", "SVBC", "None", "80419", "10.07N", "064.40W", "7", "VE"],
    ["BARINAS", "SVBI", "None", "80440", "08.37N", "070.13W", "204", "VE"],
    ["EL LIBERTADOR (A", "SVBL", "None", "None", "10.10N", "067.32W", "442", "VE"],
    ["BARQUISIMETO (MI", "SVBM", "None", "80410", "10.03N", "069.22W", "614", "VE"],
    ["MARISCAL SUCRE(M", "SVBS", "None", "80413", "10.15N", "067.39W", "437", "VE"],
    ["CIUDAD BOLIVAR", "SVCB", "None", "80444", "08.09N", "063.32W", "48", "VE"],
    ["CALABOZO", "SVCL", "None", "80442", "08.55N", "067.25W", "101", "VE"],
    ["CANAIMA ARPT", "SVCN", "None", "None", "06.14N", "062.51W", "442", "VE"],
    ["CARUPANO/GEN. JO", "SVCP", "None", "None", "10.40N", "063.16W", "10", "VE"],
    ["CORO/JOSE LEONAR", "SVCR", "None", "80403", "11.25N", "069.40W", "17", "VE"],
    ["CARACAS/OSCAR MA", "SVCS", "None", "None", "10.18N", "066.49W", "654", "VE"],
    ["CUMANA/ANTONIO J", "SVCU", "None", "80420", "10.27N", "064.08W", "4", "VE"],
    ["CARRIZAL", "SVCZ", "None", "None", "09.22N", "066.55W", "160", "VE"],
    ["CARACAS/LA CARLO", "SVFM", "None", "80416", "10.29N", "066.50W", "835", "VE"],
    ["GUASDUALITO", "SVGD", "None", "80448", "07.13N", "070.45W", "131", "VE"],
    ["GUIRIA", "SVGI", "None", "80423", "10.34N", "062.19W", "14", "VE"],
    ["GUANARE", "SVGU", "None", "80428", "09.02N", "069.45W", "163", "VE"],
    ["HIGUEROTE", "SVHG", "None", "None", "10.28N", "066.05W", "4", "VE"],
    ["PARAGUANA/JOSEFA", "SVJC", "None", "None", "11.46N", "070.09W", "23", "VE"],
    ["SAN JUAN LOS MOR", "SVJM", "None", "80431", "09.55N", "067.23W", "429", "VE"],
    ["LA FRIA", "SVLF", "None", "None", "08.15N", "072.16W", "98", "VE"],
    ["LA ORCHILA ISL(M", "SVLO", "None", "80405", "11.48N", "066.10W", "3", "VE"],
    ["MARACAIBO/LA CHI", "SVMC", "None", "80407", "10.34N", "071.43W", "65", "VE"],
    ["MERIDA/ALBERTO C", "SVMD", "None", "80438", "08.35N", "071.10W", "1498", "VE"],
    ["MARGARITA/DEL CA", "SVMG", "None", "None", "10.55N", "063.58W", "23", "VE"],
    ["CARACAS/S. BOLIV", "SVMI", "None", "80415", "10.35N", "067.00W", "48", "VE"],
    ["MENE GRANDE", "SVMN", "None", "80425", "09.49N", "070.55W", "28", "VE"],
    ["METROPOLITANO (P", "SVMP", "None", "None", "10.07N", "066.46W", "175", "VE"],
    ["MATURIN", "SVMT", "None", "80435", "09.45N", "063.10W", "66", "VE"],
    ["PUERTO AYACUCHO", "SVPA", "None", "80457", "05.37N", "067.36W", "74", "VE"],
    ["PUERTO CABELLO(M", "SVPC", "None", "80412", "10.29N", "068.04W", "2", "VE"],
    ["PARAMILLO (PRIVA", "SVPM", "None", "None", "07.47N", "072.12W", "1000", "VE"],
    ["GUAYANA/MANUEL C", "SVPR", "None", "None", "08.17N", "062.46W", "144", "VE"],
    ["SAN ANTONIO TACH", "SVSA", "None", "80447", "07.50N", "072.27W", "378", "VE"],
    ["SANTA ELENA UAIR", "SVSE", "None", "80462", "04.35N", "061.07W", "907", "VE"],
    ["SANTO DOMINGO/MA", "SVSO", "None", "80475", "07.34N", "072.02W", "327", "VE"],
    ["SAN FELIPE", "SVSP", "None", "None", "10.16N", "068.45W", "232", "VE"],
    ["SAN FERNANDO APU", "SVSR", "None", "80450", "07.54N", "067.25W", "48", "VE"],
    ["SAN TOME (PRIVAT", "SVST", "None", "None", "08.56N", "064.09W", "262", "VE"],
    ["SANTA BARBARA ZU", "SVSZ", "None", "None", "08.58N", "071.57W", "10", "VE"],
    ["TUMEREMO", "SVTM", "None", "80453", "07.17N", "061.27W", "181", "VE"],
    ["TEMBLADOR (PRIVA", "SVTR", "None", "80478", "09.01N", "062.37W", "30", "VE"],
    ["ZIM VALENCIA INT", "SVVA", "None", "80472", "10.09N", "067.55W", "431", "VE"],
    ["EL VIGIA/PEREZ A", "SVVG", "None", "None", "08.37N", "071.40W", "100", "VE"],
    ["VALERA/DR. ANTON", "SVVL", "None", "80426", "09.20N", "070.35W", "575", "VE"],
    ["VALLE DE LA PASC", "SVVP", "None", "80434", "09.13N", "066.01W", "125", "VE"],
    ["CARRIZAL", "MVCZ", "None", "80432", "09.25N", "066.55W", "161", "VE"],
    ["MENE GRANDE", "MVMN", "None", "None", "09.49N", "070.55W", "28", "VE"],
    ["PORLAMAR DEL CA", "MVPQ", "None", "80421", "10.55N", "063.58W", "19", "VE"],
    ["TEMBLADOR", "MVTR", "None", "None", "09.01N", "062.37W", "30", "VE"],
    ["CAYENNE/ROCHAMBE", "SOCA", "None", "81405", "04.49N", "052.22W", "9", "GY"],
    ["ST LAURENT DU MA", "SOOM", "None", "81401", "05.30N", "054.01W", "9", "GY"],
    ["OGLE AIRPORT", "SYGO", "None", "None", "06.48N", "058.06W", "10", "GY"],
    ["GEORGETOWN", "SYGT", "None", "81001", "06.47N", "058.08W", "2", "GY"],
    ["MABARUMA", "SYMB", "None", "81100", "08.12N", "059.47W", "50", "GY"],
    ["GEORGETOWN/TIMEH", "SYCJ", "None", "81002", "06.30N", "058.15W", "30", "GY"],
    ["KAMARANG", "SYKM", "None", "81005", "05.52N", "060.37W", "488", "GY"],
    ["KATO", "SYKT", "None", "None", "04.39N", "059.50W", "701", "GY"],
    ["LETHEM", "SYLT", "None", "81006", "03.22N", "059.47W", "107", "GY"],
    ["EBINI", "None", "None", "81010", "05.34N", "057.47W", "29", "GY"],
    ["NEW AMSTERDAM", "None", "None", "81058", "06.15N", "057.18W", "2", "GY"],
    ["KAIETEUR FALLS", "None", "None", "81080", "05.11N", "059.29W", "439", "GY"],
    ["GEORGETOWN/TIMEH", "SYTM", "None", "None", "06.30N", "058.15W", "30", "GY"],
    ["AMBATO/CHACHOAN", "SEAM", "None", "84147", "01.11S", "078.34W", "2520", "EC"],
    ["ASCAZUBI", "SEAS", "None", "None", "00.04S", "078.17W", "2743", "EC"],
    ["BAHIA DE CARAQUE", "SEBC", "None", "84101", "00.34S", "080.24W", "3", "EC"],
    ["CHONE", "SECH", "None", "84015", "00.42S", "080.07W", "69", "EC"],
    ["COCA/FRANCISCO", "SECO", "None", "84099", "00.27S", "076.59W", "220", "EC"],
    ["CUENCA/MARISCAL", "SECU", "None", "84239", "02.52S", "078.58W", "2531", "EC"],
    ["ESMERALDAS-TACHI", "SEES", "None", "84018", "00.58N", "079.37W", "8", "EC"],
    ["SEYMOUR(EQ-AFB/C", "SEGS", "None", "84001", "00.27S", "090.16W", "16", "EC"],
    ["GUAYAQUIL/SIMON", "SEGU", "None", "84203", "02.08S", "079.52W", "9", "EC"],
    ["IBARRA/ATAHUALPA", "SEIB", "None", "84043", "00.21N", "078.07W", "2228", "EC"],
    ["LAGO AGRIO", "SELA", "None", "84063", "00.04N", "076.52W", "299", "EC"],
    ["LIMONCOCHA", "SELI", "None", "None", "00.24S", "076.35W", "221", "EC"],
    ["CATAMAYO/ENRIQUE", "SELO", "None", "84265", "04.00S", "079.22W", "1238", "EC"],
    ["LATACUNGA/COTOPA", "SELT", "None", "84123", "00.55S", "078.37W", "2785", "EC"],
    ["MACARA/J.M.VELAS", "SEMA", "None", "84279", "04.22S", "079.55W", "430", "EC"],
    ["MACHALA/GEN SERR", "SEMH", "None", "84248", "03.15S", "079.58W", "10", "EC"],
    ["MANTA/ELOY ALFAR", "SEMT", "None", "84117", "00.57S", "080.40W", "14", "EC"],
    ["LAGO AGRIO", "SENL", "None", "None", "00.06N", "076.52W", "293", "EC"],
    ["PASTAZA/RIO AMAZ", "SEPA", "None", "84163", "01.30S", "078.02W", "1043", "EC"],
    ["PORTOVIEJO/REALE", "SEPV", "None", "None", "01.01S", "080.28W", "44", "EC"],
    ["QUITO/NEW INTL", "SEQM", "None", "None", "00.07S", "078.21W", "2400", "EC"],
    ["QUITO/MARISCAL S", "SEQU", "None", "84071", "00.09S", "078.28W", "2812", "EC"],
    ["RIOBAMBA/CHIMBOR", "SERB", "None", "84176", "01.37S", "078.40W", "2796", "EC"],
    ["SALINAS/GEN ULPI", "SESA", "None", "84200", "02.12S", "080.58W", "8", "EC"],
    ["SAN LORENZO", "SESL", "None", "None", "01.16N", "078.50W", "40", "EC"],
    ["SAN CRISTOBAL IS", "SEST", "None", "84008", "00.54S", "089.35W", "6", "EC"],
    ["TAURA (EQ-AFB)", "SETA", "None", "84125", "02.16S", "079.40W", "17", "EC"],
    ["TIPUTINI", "SETI", "None", "84131", "00.46S", "075.31W", "220", "EC"],
    ["TULCAN/EL ROSAL", "SETU", "None", "84027", "00.49N", "077.42W", "2940", "EC"],
    ["ATALAYA", "SPAY", "None", "84593", "10.43S", "073.46W", "451", "PE"],
    ["MOYOBAMBA", "SPBB", "None", "84435", "06.01S", "076.58W", "833", "PE"],
    ["PUCALLPA (CIV/MI", "SPCL", "None", "84515", "08.23S", "074.35W", "149", "PE"],
    ["MOLLENDO", "SPDO", "None", "84761", "17.01S", "072.01W", "13", "PE"],
    ["CHIMBOTE/TENIENT", "SPEO", "None", "84531", "09.10S", "078.31W", "11", "PE"],
    ["CESAR TORQUE POD", "SPEQ", "None", "None", "17.10S", "070.55W", "1366", "PE"],
    ["TINGO MARIA", "SPGM", "None", "84534", "09.17S", "076.00W", "665", "PE"],
    ["CHICLAYO/CAPT JO", "SPHI", "None", "84452", "06.46S", "079.49W", "34", "PE"],
    ["AYACUCHO/CORONEL", "SPHO", "None", "84673", "13.10S", "074.13W", "2749", "PE"],
    ["HUANCAYO", "SPHU", "None", "None", "12.04S", "075.13W", "3350", "PE"],
    ["ANDAHUAYLA", "SPHY", "None", "84688", "13.42S", "073.21W", "3548", "PE"],
    ["ANTA/HUARAZ", "SPHZ", "None", "84542", "09.20S", "077.35W", "2760", "PE"],
    ["QUINCEMIL", "SPIL", "None", "84677", "13.16S", "070.40W", "634", "PE"],
    ["LIMA/JORGE CHAVE", "SPIM", "None", "84628", "12.01S", "077.07W", "13", "PE"],
    ["RIOJA", "SPJA", "None", "84440", "06.02S", "077.09W", "792", "PE"],
    ["JUANJUI", "SPJI", "None", "84474", "07.10S", "076.43W", "363", "PE"],
    ["JAUJA", "SPJJ", "None", "None", "11.46S", "075.28W", "3322", "PE"],
    ["JULIACA", "SPJL", "None", "84735", "15.28S", "070.09W", "3827", "PE"],
    ["SAN JUAN DE MARC", "SPJN", "None", "84721", "15.21S", "075.08W", "40", "PE"],
    ["CAJAMARCA/REVORE", "SPJR", "None", "84472", "07.07S", "078.28W", "2622", "PE"],
    ["ILO", "SPLO", "None", "84773", "17.42S", "071.21W", "9", "PE"],
    ["LAS PALMAS (MIL)", "SPLP", "None", "None", "12.10S", "077.00W", "76", "PE"],
    ["TUMBES/PEDRO CAN", "SPME", "None", "84370", "03.32S", "080.24W", "27", "PE"],
    ["YURIMAGUAS/MOISE", "SPMS", "None", "84425", "05.54S", "076.07W", "179", "PE"],
    ["HUANUCO/ALFEREZ", "SPNC", "None", "84564", "09.54S", "075.45W", "1860", "PE"],
    ["ZORRITOS", "SPOS", "None", "None", "03.40S", "080.40W", "49", "PE"],
    ["PARAMONGA", "SPPG", "None", "None", "10.40S", "077.49W", "46", "PE"],
    ["CHACHAPOYAS", "SPPY", "None", "84444", "06.13S", "077.49W", "2435", "PE"],
    ["IQUITOS/SECADA", "SPQT", "None", "84377", "03.47S", "073.19W", "126", "PE"],
    ["AREQUIPA/RODRIGU", "SPQU", "None", "84752", "16.20S", "071.34W", "2554", "PE"],
    ["TRUJILLO/MARTINE", "SPRU", "None", "84501", "08.05S", "079.07W", "30", "PE"],
    ["PISCO (CIV/MIL)", "SPSO", "None", "84691", "13.44S", "076.13W", "10", "PE"],
    ["TARAPOTO", "SPST", "None", "84455", "06.31S", "076.22W", "282", "PE"],
    ["TACNA/CIRIANI", "SPTN", "None", "84782", "18.04S", "070.17W", "458", "PE"],
    ["PUERTO MALDONADO", "SPTU", "None", "84658", "12.37S", "069.12W", "266", "PE"],
    ["PIURA/CAPT CONCH", "SPUR", "None", "84401", "05.10S", "080.35W", "55", "PE"],
    ["CARAVELI", "SPVL", "None", "None", "15.46S", "073.22W", "1833", "PE"],
    ["TALARA/CAPT MONT", "SPYL", "None", "84390", "04.34S", "081.15W", "90", "PE"],
    ["NAZCA REICHE APT", "SPZA", "None", "None", "14.52S", "074.57W", "765", "PE"],
    ["CUZCO/VELAZCO AS", "SPZO", "None", "84686", "13.33S", "071.58W", "3249", "PE"],
    ["APOLO", "SLAP", "None", "85151", "14.43S", "068.25W", "1415", "BO"],
    ["ASCENCION GUARAY", "SLAS", "None", "85175", "15.43S", "063.06W", "247", "BO"],
    ["CAMIRI", "SLCA", "None", "85315", "20.00S", "063.32W", "798", "BO"],
    ["COCHABAMBA/JORGE", "SLCB", "None", "85223", "17.25S", "066.11W", "2548", "BO"],
    ["CHARANA", "SLCN", "None", "85230", "17.35S", "069.27W", "4057", "BO"],
    ["COBIJA", "SLCO", "None", "85041", "11.02S", "068.47W", "272", "BO"],
    ["CONCEPCION", "SLCP", "None", "85196", "16.09S", "062.01W", "497", "BO"],
    ["SANTA CRUZ/EL TR", "SLET", "None", "85245", "17.48S", "063.10W", "414", "BO"],
    ["GUAYARAMERIN", "SLGY", "None", "85033", "10.49S", "065.20W", "130", "BO"],
    ["SAN JOSE", "SLJE", "None", "85247", "17.49S", "060.45W", "284", "BO"],
    ["SAN JOAQUIN", "SLJO", "None", "85104", "13.04S", "064.40W", "140", "BO"],
    ["SAN JAVIER", "SLJV", "None", "85195", "16.16S", "062.28W", "520", "BO"],
    ["LA PAZ/JFK INTL", "SLLP", "None", "85201", "16.31S", "068.10W", "4014", "BO"],
    ["MAGDALENA", "SLMG", "None", "85114", "13.16S", "064.04W", "141", "BO"],
    ["ORURO/JUAN MENDO", "SLOR", "None", "85242", "17.58S", "067.05W", "3702", "BO"],
    ["POTOSI/ROJAS", "SLPO", "None", "85293", "19.31S", "065.43W", "3934", "BO"],
    ["PUERTO SUAREZ/SA", "SLPS", "None", "85289", "18.59S", "057.49W", "135", "BO"],
    ["ROBORE (CIV/MIL)", "SLRB", "None", "85268", "18.19S", "059.45W", "284", "BO"],
    ["RIBERALTA", "SLRI", "None", "85043", "11.01S", "066.05W", "135", "BO"],
    ["RURRENABAQUE", "SLRQ", "None", "85141", "14.25S", "067.30W", "203", "BO"],
    ["REYES", "SLRY", "None", "85140", "14.18S", "067.22W", "280", "BO"],
    ["SANTA ANA DE YAC", "SLSA", "None", "85123", "13.46S", "065.26W", "144", "BO"],
    ["SAN BORJA/CAPT G", "SLSB", "None", "85152", "14.52S", "066.45W", "194", "BO"],
    ["SAN IGNACIO VELA", "SLSI", "None", "85207", "16.22S", "060.57W", "413", "BO"],
    ["SAN IGNACIO DE M", "SLSM", "None", "85153", "14.58S", "065.38W", "160", "BO"],
    ["SUCRE/JUANA AZUR", "SLSU", "None", "85283", "19.01S", "065.16W", "2903", "BO"],
    ["TARIJA/CAPT ORIE", "SLTJ", "None", "85364", "21.33S", "064.43W", "1858", "BO"],
    ["TRINIDAD/JORGE H", "SLTR", "None", "85154", "14.50S", "064.55W", "157", "BO"],
    ["VILLA MONTES/RAF", "SLVM", "None", "85345", "21.15S", "063.24W", "400", "BO"],
    ["VIRU VIRU INTL A", "SLVR", "None", "85244", "17.38S", "063.07W", "373", "BO"],
    ["YACUIBA", "SLYA", "None", "85365", "21.58S", "063.39W", "645", "BO"],
    ["CONCEICAO ARAGUA", "SBAA", "None", "82861", "08.21S", "049.18W", "199", "BR"],
    ["AFONSOS ARPT (MI", "SBAF", "None", "83748", "22.52S", "043.22W", "34", "BR"],
    ["AMAPA AIRPORT", "SBAM", "None", "82030", "02.04N", "050.51W", "10", "BR"],
    ["ANAPOLIS (BRAZ-A", "SBAN", "None", "83419", "16.13S", "048.58W", "1137", "BR"],
    ["ASSIS", "SBAS", "None", "None", "22.38S", "050.27W", "564", "BR"],
    ["ARARAQUARA", "SBAQ", "None", "None", "21.48S", "048.08W", "708", "BR"],
    ["ARACAJU/SANTA MA", "SBAR", "None", "83095", "10.58S", "037.04W", "9", "BR"],
    ["ALTA FLORESTA", "SBAT", "None", "82965", "09.52S", "056.06W", "288", "BR"],
    ["ARACATUBA", "SBAU", "None", "None", "21.08S", "050.26W", "415", "BR"],
    ["ARAXA", "SBAX", "None", "None", "19.34S", "046.58W", "998", "BR"],
    ["BOCADOACRE", "SBBA", "None", "82816", "08.43S", "067.19W", "112", "BR"],
    ["BENJAMIN CONSTAN", "SBBC", "None", "82410", "04.22S", "070.01W", "65", "BR"],
    ["BELEM/VAL DE CAE", "SBBE", "None", "82193", "01.22S", "048.28W", "16", "BR"],
    ["BAGE/CMDT KRAEME", "SBBG", "None", "83981", "31.23S", "054.07W", "180", "BR"],
    ["BELO HORIZ/PAMPU", "SBBH", "None", "83583", "19.51S", "043.57W", "785", "BR"],
    ["CURITIBA/BACACHE", "SBBI", "None", "83842", "25.24S", "049.14W", "923", "BR"],
    ["BARBACENA (CIV/M", "SBBQ", "None", "83689", "21.15S", "043.46W", "1171", "BR"],
    ["BRASILIA (CIV/MI", "SBBR", "None", "83378", "15.52S", "047.55W", "1061", "BR"],
    ["CHAFEI AMSEI", "SBBT", "None", "None", "20.35S", "048.36W", "579", "BR"],
    ["BAURU", "SBBU", "None", "83722", "22.19S", "049.04W", "590", "BR"],
    ["BOA VISTA (CIV/M", "SBBV", "None", "82022", "02.51N", "060.42W", "140", "BR"],
    ["BERRA DO GARCAS", "SBBW", "None", "83359", "15.52S", "052.22W", "350", "BR"],
    ["BUZIOS/MODIANO", "SBBZ", "None", "None", "22.45S", "041.57W", "3", "BR"],
    ["CASCAVEL", "SBCA", "None", "None", "25.00S", "053.30W", "754", "BR"],
    ["CABO FRIO", "SBCB", "None", "None", "22.55S", "042.05W", "4", "BR"],
    ["CACHIMBO", "SBCC", "None", "None", "09.19S", "054.57W", "536", "BR"],
    ["CACADOR", "SBCD", "None", "None", "26.47S", "050.56W", "1029", "BR"],
    ["BELO HORIZ/TANCR", "SBCF", "None", "83587", "19.38S", "043.58W", "828", "BR"],
    ["CAMPO GRANDE INT", "SBCG", "None", "83612", "20.28S", "054.40W", "567", "BR"],
    ["CHAPECO", "SBCH", "None", "None", "27.08S", "052.40W", "650", "BR"],
    ["CAROLINA AIRPORT", "SBCI", "None", "82764", "07.19S", "047.28W", "183", "BR"],
    ["CARAJAS/MARABA", "SBCJ", "None", "None", "06.07S", "050.00W", "621", "BR"],
    ["FORQUILHINHA", "SBCM", "None", "None", "28.43S", "049.25W", "28", "BR"],
    ["PORTO ALEGRE/CAN", "SBCO", "None", "83967", "29.57S", "051.09W", "47", "BR"],
    ["CAMPOS/BARTOLOME", "SBCP", "None", "83698", "21.42S", "041.18W", "11", "BR"],
    ["CORUMBA INTL ARP", "SBCR", "None", "83552", "19.00S", "057.40W", "141", "BR"],
    ["CURITIBA/AFONSO", "SBCT", "None", "83840", "25.31S", "049.10W", "908", "BR"],
    ["CARAVELAS AIRPOR", "SBCV", "None", "83497", "17.37S", "039.15W", "4", "BR"],
    ["CAXIAS DO SUL", "SBCX", "None", "None", "29.12S", "051.11W", "754", "BR"],
    ["CUIABA/MARECHAL", "SBCY", "None", "83362", "15.39S", "056.07W", "182", "BR"],
    ["CRUZEIRO DO SUL", "SBCZ", "None", "82705", "07.37S", "072.46W", "170", "BR"],
    ["PRESIDENTE PRUDE", "SBDN", "None", "83716", "22.11S", "051.26W", "435", "BR"],
    ["PIRANA P15 OIL", "SBEC", "None", "None", "22.40S", "040.36W", "10", "BR"],
    ["EDUARDO GOMES IN", "SBEG", "None", "82111", "03.01S", "060.02W", "2", "BR"],
    ["JACAREACANGA", "SBEK", "None", "82640", "06.14S", "057.47W", "98", "BR"],
    ["EIRUNEPE", "SBER", "None", "82610", "06.40S", "069.52W", "104", "BR"],
    ["SAO PEDRO DA ALD", "SBES", "None", "83759", "22.49S", "042.06W", "11", "BR"],
    ["FOZ DO IGUACU AR", "SBFI", "None", "83827", "25.36S", "054.29W", "243", "BR"],
    ["FLORIANOPOLIS AR", "SBFL", "None", "83899", "27.40S", "048.32W", "5", "BR"],
    ["FERNANDO DE NORO", "SBFN", "None", "82400", "03.51S", "032.25W", "56", "BR"],
    ["CMP D GOITACAZES", "SBFS", "None", "None", "22.01S", "041.04W", "3", "BR"],
    ["FRONTEIRA", "SBFT", "None", "None", "20.17S", "049.11W", "487", "BR"],
    ["FURNAS (PRIVATE)", "SBFU", "None", "None", "20.41S", "046.19W", "735", "BR"],
    ["FORTALEZA/PINTO", "SBFZ", "None", "82398", "03.46S", "038.31W", "25", "BR"],
    ["GAMA", "SBGA", "None", "83375", "16.03S", "048.02W", "700", "BR"],
    ["GALEAO/RIO(CIV/M", "SBGL", "None", "83746", "22.49S", "043.15W", "6", "BR"],
    ["GUAJARA MIRIM", "SBGM", "None", "83016", "10.47S", "065.17W", "146", "BR"],
    ["GOIANIA/SANTA GE", "SBGO", "None", "83424", "16.37S", "049.13W", "747", "BR"],
    ["GAVIAO PEIXOTO", "SBGP", "None", "None", "21.46S", "048.24W", "609", "BR"],
    ["GUARULHOS (CIV/M", "SBGR", "None", "None", "23.25S", "046.28W", "750", "BR"],
    ["GUARAPUAVA", "SBGU", "None", "None", "25.23S", "051.31W", "1065", "BR"],
    ["GOV VALADARES", "SBGV", "None", "None", "18.53S", "041.59W", "171", "BR"],
    ["GUARATINGUETA (M", "SBGW", "None", "83708", "22.46S", "045.12W", "533", "BR"],
    ["ALTAMIRA", "SBHT", "None", "82353", "03.15S", "052.16W", "74", "BR"],
    ["ITACOATIARA", "SBIC", "None", "82335", "03.07S", "058.28W", "43", "BR"],
    ["ITAITUBA", "SBIH", "None", "82444", "04.15S", "056.00W", "34", "BR"],
    ["ILHEUS AIRPORT", "SBIL", "None", "83349", "14.48S", "039.01W", "5", "BR"],
    ["USIMINAS/PARAISO", "SBIP", "None", "None", "19.28S", "042.29W", "239", "BR"],
    ["ITUMBIARA", "SBIT", "None", "None", "18.26S", "049.12W", "497", "BR"],
    ["IMPERATRIZE", "SBIZ", "None", "82564", "05.31S", "047.27W", "123", "BR"],
    ["JUIZ FORA/FRANCI", "SBJF", "None", "83692", "21.46S", "043.23W", "939", "BR"],
    ["JOAO PESSOA/PRES", "SBJP", "None", "82798", "07.09S", "034.57W", "7", "BR"],
    ["RIO/JACAREPAGUA", "SBJR", "None", "83111", "22.58S", "043.22W", "3", "BR"],
    ["JUAZEIRO D NORTE", "SBJU", "None", "None", "07.13S", "039.16W", "409", "BR"],
    ["JOINVILLE", "SBJV", "None", "83905", "26.13S", "048.48W", "4", "BR"],
    ["CAMPINA GRANDE", "SBKG", "None", "82795", "07.16S", "035.52W", "560", "BR"],
    ["CAMPINAS/VIRACOP", "SBKP", "None", "83721", "23.00S", "047.07W", "661", "BR"],
    ["ALBACORA P25 OIL", "SBLB", "None", "None", "22.06S", "039.55W", "10", "BR"],
    ["LENCOIS CHAPADA", "SBLE", "None", "None", "12.29S", "041.17W", "511", "BR"],
    ["LAGES", "SBLJ", "None", "None", "27.47S", "050.17W", "934", "BR"],
    ["LINS", "SBLN", "None", "83674", "21.40S", "049.45W", "426", "BR"],
    ["LONDRINA AIRPORT", "SBLO", "None", "83768", "23.19S", "051.07W", "570", "BR"],
    ["BOM JESUS DA LAP", "SBLP", "None", "83288", "13.16S", "043.25W", "440", "BR"],
    ["LAGOA SANTA(CV/M", "SBLS", "None", "83588", "19.40S", "043.53W", "852", "BR"],
    ["MARABA", "SBMA", "None", "82562", "05.22S", "049.08W", "102", "BR"],
    ["MINACU", "SBMC", "None", "None", "13.33S", "048.12W", "440", "BR"],
    ["MONTE DOURADO", "SBMD", "None", "82091", "00.52S", "052.36W", "206", "BR"],
    ["MACAE", "SBME", "None", "None", "22.21S", "041.46W", "2", "BR"],
    ["MARINGA", "SBMG", "None", "83767", "23.29S", "052.01W", "542", "BR"],
    ["MONTES CLAROS", "SBMK", "None", "83437", "16.42S", "043.49W", "646", "BR"],
    ["MARILIA", "SBML", "None", "None", "22.11S", "049.55W", "647", "BR"],
    ["MARLIM P20 OIL", "SBMM", "None", "None", "22.21S", "040.05W", "10", "BR"],
    ["MANAUS/PONTA PEL", "SBMN", "None", "82332", "03.08S", "059.58W", "84", "BR"],
    ["MACEIO/CAMPO PAL", "SBMO", "None", "82993", "09.31S", "035.46W", "115", "BR"],
    ["MACAPA INTL AIRP", "SBMQ", "None", "82098", "00.03N", "051.04W", "15", "BR"],
    ["MOSSORO", "SBMS", "None", "82591", "05.12S", "037.22W", "18", "BR"],
    ["MARTE (CIV/MIL)", "SBMT", "None", "83779", "23.31S", "046.37W", "722", "BR"],
    ["MANICORE", "SBMY", "None", "82533", "05.49S", "061.17W", "49", "BR"],
    ["PORTO DE MOZ", "SBMZ", "None", "82184", "01.44S", "052.15W", "17", "BR"],
    ["NAVEGANTES", "SBNF", "None", "83926", "26.53S", "048.39W", "5", "BR"],
    ["SANTO ANGELO ARP", "SBNM", "None", "None", "28.16S", "054.10W", "322", "BR"],
    ["NATAL/AUGUSTO SE", "SBNT", "None", "82599", "05.55S", "035.15W", "49", "BR"],
    ["OIAPOQUE", "SBOI", "None", "82017", "03.51N", "051.49W", "39", "BR"],
    ["PORTO ALEGRE/SAL", "SBPA", "None", "83971", "30.00S", "051.10W", "3", "BR"],
    ["PARNAIBA AIRPORT", "SBPB", "None", "82288", "02.55S", "041.45W", "5", "BR"],
    ["POCOS DE CALDAS", "SBPC", "None", "83681", "21.51S", "046.34W", "1260", "BR"],
    ["PASSO FUNDO/LAUR", "SBPF", "None", "83914", "28.15S", "052.20W", "684", "BR"],
    ["PARANAGUA", "SBPG", "None", "83844", "25.31S", "048.31W", "4", "BR"],
    ["PALMAS", "SBPJ", "None", "83065", "10.17S", "048.22W", "236", "BR"],
    ["PELOTAS", "SBPK", "None", "83985", "31.43S", "052.20W", "13", "BR"],
    ["PETROLINA AIRPOR", "SBPL", "None", "82984", "09.22S", "040.34W", "375", "BR"],
    ["PORTO NACIONAL A", "SBPN", "None", "83063", "10.43S", "048.23W", "265", "BR"],
    ["PONTA PORA INTL", "SBPP", "None", "83703", "22.33S", "055.42W", "660", "BR"],
    ["BELO HORIZONTE", "SBPR", "None", "83571", "19.54S", "043.59W", "927", "BR"],
    ["PORTO SEGURO", "SBPS", "None", "83460", "16.26S", "039.04W", "51", "BR"],
    ["PORTO VELHO(CV/M", "SBPV", "None", "82824", "08.43S", "063.54W", "88", "BR"],
    ["VITORIA DA CONQU", "SBQV", "None", "83344", "14.52S", "040.52W", "893", "BR"],
    ["RIO BRANCO/MEDIC", "SBRB", "None", "82917", "10.00S", "067.47W", "143", "BR"],
    ["RECIFE/GUARARAPE", "SBRF", "None", "82899", "08.08S", "034.55W", "19", "BR"],
    ["RIO GRANDE", "SBRG", "None", "83995", "32.01S", "052.05W", "8", "BR"],
    ["SANTOS DUMONT/RI", "SBRJ", "None", "83755", "22.53S", "043.10W", "3", "BR"],
    ["LEITE LOPES/RIBE", "SBRP", "None", "None", "21.07S", "047.46W", "549", "BR"],
    ["SAO ROQUE/S. PAU", "SBRQ", "None", "83058", "23.31S", "047.07W", "750", "BR"],
    ["RESENDE", "SBRS", "None", "83738", "22.28S", "044.28W", "439", "BR"],
    ["SAO CARLOS(PRIVA", "SBSA", "None", "83726", "22.01S", "047.52W", "856", "BR"],
    ["SANTA CRUZ (MIL)", "SBSC", "None", "83741", "22.55S", "043.43W", "3", "BR"],
    ["NATAL", "SBSG", "None", "None", "05.46S", "035.22W", "83", "BR"],
    ["SAO JOSE DOS CAM", "SBSJ", "None", "None", "23.13S", "045.52W", "646", "BR"],
    ["SAO LUIS/MARECHA", "SBSL", "None", "82280", "02.36S", "044.13W", "53", "BR"],
    ["SANTA MARIA(CV/M", "SBSM", "None", "83937", "29.43S", "053.42W", "85", "BR"],
    ["SANTAREM INTL AR", "SBSN", "None", "82244", "02.25S", "054.47W", "72", "BR"],
    ["SAO PAULO/CONGON", "SBSP", "None", "83780", "23.37S", "046.38W", "803", "BR"],
    ["SAO JOSE PRETO", "SBSR", "None", "None", "20.48S", "049.24W", "543", "BR"],
    ["SANTOS (BRAZ-AFB", "SBST", "None", "83818", "23.55S", "046.17W", "3", "BR"],
    ["SALVADOR/DOIS JU", "SBSV", "None", "83248", "12.54S", "038.19W", "6", "BR"],
    ["SANTA ISABEL MOR", "SBSY", "None", "83156", "11.34S", "050.40W", "197", "BR"],
    ["TAUBATE (BASE)", "SBTA", "None", "None", "23.02S", "045.30W", "586", "BR"],
    ["ORIXIMINA", "SBTB", "None", "None", "01.29S", "056.23W", "87", "BR"],
    ["UNA HOTEL TRANSA", "SBTC", "None", "None", "15.21S", "038.59W", "6", "BR"],
    ["TOLEDO", "SBTD", "None", "None", "24.41S", "053.42W", "565", "BR"],
    ["TERESINA AIRPORT", "SBTE", "None", "82579", "05.02S", "042.49W", "69", "BR"],
    ["TEFE", "SBTF", "None", "82317", "03.22S", "064.43W", "47", "BR"],
    ["TARAUACA", "SBTK", "None", "82808", "08.10S", "070.46W", "188", "BR"],
    ["TELEMACO BORBA", "SBTL", "None", "None", "24.19S", "050.39W", "796", "BR"],
    ["TORRES", "SBTR", "None", "83948", "29.21S", "049.44W", "1", "BR"],
    ["TIRIOS", "SBTS", "None", "82026", "02.13S", "055.56W", "325", "BR"],
    ["TABATINGA INTL A", "SBTT", "None", "82411", "04.15S", "069.56W", "85", "BR"],
    ["TUCURUI", "SBTU", "None", "82361", "03.47S", "049.43W", "40", "BR"],
    ["SAO GABRIEL CACH", "SBUA", "None", "82107", "00.09S", "066.59W", "79", "BR"],
    ["PAULO AFONSO", "SBUF", "None", "82986", "09.24S", "038.15W", "252", "BR"],
    ["URUGUAIANA/RUBEM", "SBUG", "None", "83928", "29.46S", "057.01W", "74", "BR"],
    ["CARAUARI", "SBUI", "None", "82418", "04.57S", "066.54W", "81", "BR"],
    ["UBERLANDIA", "SBUL", "None", "83525", "18.52S", "048.13W", "922", "BR"],
    ["URUBUPUNGA/CASTI", "SBUP", "None", "83617", "20.48S", "051.34W", "356", "BR"],
    ["UBERABA", "SBUR", "None", "83576", "19.46S", "047.58W", "807", "BR"],
    ["PORTO URUCU", "SBUY", "None", "None", "04.53S", "065.21W", "72", "BR"],
    ["VARGINHA", "SBVG", "None", "None", "21.35S", "045.28W", "923", "BR"],
    ["VILHENA", "SBVH", "None", "83208", "12.43S", "060.07W", "652", "BR"],
    ["VITORIA/GOIABEIR", "SBVT", "None", "83649", "20.16S", "040.16W", "4", "BR"],
    ["CACHIMBO-IN-PAR", "SBXI", "None", "82930", "09.21S", "054.53W", "432", "BR"],
    ["XAVANTINA", "SBXV", "None", "83319", "14.41S", "052.21W", "315", "BR"],
    ["IAUARETE (PRIVAT", "SBYA", "None", "82068", "00.37N", "069.12W", "105", "BR"],
    ["PIRASSUNUNGA/CAM", "SBYS", "None", "83671", "21.58S", "047.19W", "598", "BR"],
    ["BARCELOS", "SWBC", "None", "82113", "00.58S", "062.55W", "40", "BR"],
    ["PARINTINS", "SWPI", "None", "None", "02.40S", "056.47W", "27", "BR"],
    ["LABREA", "None", "None", "82723", "07.15S", "064.50W", "60", "BR"],
    ["CRUZEIRO DO SUL", "None", "None", "82704", "07.37S", "072.40W", "170", "BR"],
    ["SAO LUIS/MARECHA", "None", "None", "82281", "02.36S", "044.13W", "53", "BR"],
    ["ASUNCION/SILVIO", "SGAS", "None", "86218", "25.15S", "057.31W", "101", "PY"],
    ["CONCEPCION/MARIS", "SGCO", "None", "86134", "23.25S", "057.17W", "74", "PY"],
    ["ENCARNACION", "SGEN", "None", "86297", "27.19S", "055.49W", "91", "PY"],
    ["GUARANY", "SGES", "None", "None", "25.27S", "054.51W", "849", "PY"],
    ["FILADELFIA", "SGFI", "None", "None", "22.22S", "060.02W", "139", "PY"],
    ["MARISCAL ESTIGAR", "SGME", "None", "86068", "22.01S", "060.36W", "181", "PY"],
    ["NUEVA ASUNCION", "SGNA", "None", "86017", "20.43S", "061.55W", "315", "PY"],
    ["PILAR", "SGPI", "None", "86255", "26.51S", "058.19W", "56", "PY"],
    ["MELILLA/ANGEL S.", "SUAA", "None", "86575", "34.46S", "056.15W", "54", "UY"],
    ["ARTIGAS", "SUAG", "None", "86330", "30.24S", "056.30W", "123", "UY"],
    ["COLONIA SACRAMEN", "SUCA", "None", "86560", "34.27S", "057.46W", "23", "UY"],
    ["DURAZNO/SANTA BE", "SUDU", "None", "86530", "33.21S", "056.30W", "93", "UY"],
    ["CAPITAN CORBETA", "SULS", "None", "None", "34.52S", "055.06W", "30", "UY"],
    ["MERCEDES/RICARDO", "SUME", "None", "86490", "33.15S", "058.04W", "22", "UY"],
    ["MELO/CERRO LARGO", "SUMO", "None", "86440", "32.20S", "054.13W", "100", "UY"],
    ["CARRASCO (CIV/MI", "SUMU", "None", "86580", "34.49S", "056.00W", "32", "UY"],
    ["MALDONADO/PUNTA", "SUPE", "None", "None", "34.55S", "054.55W", "15", "UY"],
    ["PAYSANDU", "SUPU", "None", "86430", "32.19S", "058.01W", "61", "UY"],
    ["RIVERA", "SURV", "None", "86350", "30.58S", "055.28W", "205", "UY"],
    ["SALTO", "SUSO", "None", "86360", "31.26S", "057.59W", "34", "UY"],
    ["TACUAREMBO", "SUTB", "None", "86370", "31.41S", "055.58W", "134", "UY"],
    ["TREINTA Y TRES", "SUTR", "None", "86500", "33.13S", "054.22W", "46", "UY"],
    ["ANCUD/PUPELDE", "SCAC", "None", "85818", "41.53S", "073.47W", "114", "CL"],
    ["ALTO PALENA", "SCAP", "None", "85836", "43.37S", "071.47W", "277", "CL"],
    ["ARICA/CHACALLUTA", "SCAR", "None", "85406", "18.21S", "070.19W", "59", "CL"],
    ["CABO JUAN ROMAN", "SCAS", "None", "None", "45.24S", "072.40W", "10", "CL"],
    ["DESIERTO ATACAMA", "SCAT", "None", "None", "27.16S", "070.46W", "204", "CL"],
    ["BALMACEDA", "SCBA", "None", "85874", "45.55S", "071.40W", "524", "CL"],
    ["EL BELLOTO (MIL)", "SCBL", "None", "85562", "33.02S", "071.25W", "123", "CL"],
    ["BERNADO OHIGGINS", "SCBO", "None", "89059", "63.19S", "056.41W", "10", "CL"],
    ["EL BOSQUE (MIL)", "SCBQ", "None", "85581", "33.34S", "070.40W", "573", "CL"],
    ["CHILE CHICO", "SCCC", "None", "85886", "46.35S", "071.42W", "325", "CL"],
    ["CALAMA/EL LOA", "SCCF", "None", "85432", "22.30S", "068.54W", "2312", "CL"],
    ["CHILLAN/GEN BERN", "SCCH", "None", "85672", "36.34S", "072.01W", "148", "CL"],
    ["PUNTA ARENAS/PRE", "SCCI", "None", "85934", "53.00S", "070.50W", "37", "CL"],
    ["COYHAIQUE/TENIEN", "SCCY", "None", "85864", "45.34S", "072.06W", "311", "CL"],
    ["IQUIQUE/DIEGO AR", "SCDA", "None", "85418", "20.31S", "070.10W", "52", "CL"],
    ["PUDAHUEL/ARTURO", "SCEL", "None", "85574", "33.22S", "070.46W", "476", "CL"],
    ["QUINTERO (MIL)", "SCER", "None", "85543", "32.46S", "071.31W", "8", "CL"],
    ["ANTOFAGASTA/CERR", "SCFA", "None", "85442", "23.25S", "070.25W", "120", "CL"],
    ["CAPT FUENTES MAR", "SCFM", "None", "None", "53.15S", "070.19W", "30", "CL"],
    ["FUTALEUFU", "SCFT", "None", "85832", "43.10S", "071.51W", "318", "CL"],
    ["MARIA DOLORES", "SCGE", "None", "85703", "37.23S", "072.25W", "114", "CL"],
    ["GUARDIAMARINA", "SCGZ", "None", "None", "54.56S", "067.38W", "27", "CL"],
    ["COPIAPO/CHAMONAT", "SCHA", "None", "85470", "27.18S", "070.25W", "291", "CL"],
    ["COCHRANE", "SCHR", "None", "85892", "47.13S", "072.32W", "167", "CL"],
    ["CURICO/GEN FREIR", "SCIC", "None", "85629", "34.58S", "071.13W", "242", "CL"],
    ["CONCEPCION/CARRI", "SCIE", "None", "85682", "36.46S", "073.04W", "16", "CL"],
    ["EASTER ISLAND", "SCIP", "None", "85469", "27.10S", "109.26W", "69", "CL"],
    ["ROBINSON CRUSOE", "SCIR", "None", "85585", "33.40S", "078.56W", "29", "CL"],
    ["OSORNO/CANAL BAJ", "SCJO", "None", "85782", "40.36S", "073.02W", "65", "CL"],
    ["VALLENAR", "SCLL", "None", "85486", "28.36S", "070.46W", "538", "CL"],
    ["MELINKA ARPT", "SCMK", "None", "None", "43.54S", "073.44W", "11", "CL"],
    ["TENIENTE GALLARD", "SCNT", "None", "None", "51.40S", "072.32W", "67", "CL"],
    ["QUELLON", "SCON", "None", "85831", "43.07S", "073.37W", "3", "CL"],
    ["MONOPULLI", "SCPQ", "None", "None", "42.20S", "073.43W", "5", "CL"],
    ["TEMUCO", "SCQP", "None", "None", "38.55S", "072.39W", "97", "CL"],
    ["CHANARAL", "SCRA", "None", "85460", "26.19S", "070.37W", "30", "CL"],
    ["RODELILLO", "SCRD", "None", "None", "33.04S", "071.33W", "336", "CL"],
    ["DE LA INDEPENDEN", "SCRG", "None", "85608", "34.10S", "070.46W", "441", "CL"],
    ["TENIENTE R MARSH", "SCRM", "None", "None", "62.11S", "058.59W", "45", "CL"],
    ["LA SERENA/LAFLOR", "SCSE", "None", "85488", "29.55S", "071.12W", "146", "CL"],
    ["SANTO DOMINGO", "SCSN", "None", "85586", "33.38S", "071.37W", "75", "CL"],
    ["SEGUNDO CORRAL A", "SCSR", "None", "None", "42.04S", "071.52W", "366", "CL"],
    ["CASTRO/GAMBOA", "SCST", "None", "85825", "42.28S", "073.46W", "44", "CL"],
    ["EULOGIO SANCHEZ", "SCTB", "None", "85580", "33.27S", "070.32W", "649", "CL"],
    ["TEMUCO/MAQUEHUE", "SCTC", "None", "85743", "38.45S", "072.37W", "120", "CL"],
    ["PUERTO MONTT/TEP", "SCTE", "None", "85799", "41.25S", "073.04W", "86", "CL"],
    ["LOS CERRILLOS", "SCTI", "None", "85579", "33.28S", "070.42W", "511", "CL"],
    ["CHAITEN", "SCTN", "None", "85830", "42.55S", "072.42W", "4", "CL"],
    ["VALDIVIA/PICHOY", "SCVD", "None", "85766", "39.39S", "073.04W", "14", "CL"],
    ["VINA DEL MAR", "SCVM", "None", "None", "32.57S", "071.29W", "141", "CL"],
    ["CONCORDIA/PIERRE", "SAAC", "None", "87395", "31.18S", "058.01W", "38", "AR"],
    ["GUALEGUAYCHU ARP", "SAAG", "None", "87497", "33.00S", "058.37W", "21", "AR"],
    ["JUNIN AIRPORT", "SAAJ", "None", "87548", "34.32S", "060.57W", "81", "AR"],
    ["PARANA/GEN URQUI", "SAAP", "None", "87374", "31.46S", "060.28W", "78", "AR"],
    ["ROSARIO AIRPORT", "SAAR", "None", "87480", "32.55S", "060.46W", "25", "AR"],
    ["VILLAGUAY", "SAAU", "None", "87385", "31.51S", "059.04W", "43", "AR"],
    ["SAUCE VIEJO AIRP", "SAAV", "None", "87371", "31.41S", "060.49W", "18", "AR"],
    ["BUENOS AIRES (OB", "SABA", "None", "87585", "34.34S", "058.28W", "25", "AR"],
    ["AEROPARQUE(CIV/M", "SABE", "None", "87582", "34.34S", "058.25W", "6", "AR"],
    ["LA CUMBRE", "SACC", "None", "None", "31.00S", "064.32W", "1138", "AR"],
    ["PILAR OBSERVATOR", "SACI", "None", "87349", "31.40S", "063.52W", "338", "AR"],
    ["CORDOBA AIRPORT", "SACO", "None", "87344", "31.19S", "064.13W", "474", "AR"],
    ["CHEPES", "SACP", "None", "87322", "31.19S", "066.35W", "658", "AR"],
    ["MONTE QUEMADO", "SACQ", "None", "87071", "25.45S", "062.52W", "220", "AR"],
    ["GOBERNADOR GORDI", "SACT", "None", "None", "30.22S", "066.17W", "457", "AR"],
    ["VILLA MARIA DEL", "SACV", "None", "87244", "29.53S", "063.40W", "341", "AR"],
    ["DON TORCUATO ARP", "SADD", "None", "87568", "34.28S", "058.37W", "4", "AR"],
    ["SAN FERNANDO", "SADF", "None", "None", "34.27S", "058.35W", "4", "AR"],
    ["MARIANO MORENO", "SADJ", "None", "87572", "34.34S", "058.46W", "28", "AR"],
    ["LA PLATA AIRPORT", "SADL", "None", "87593", "34.58S", "057.53W", "19", "AR"],
    ["BUENOS AIRES/MOR", "SADM", "None", "87574", "34.40S", "058.38W", "30", "AR"],
    ["EL PALOMAR AIRPO", "SADP", "None", "87571", "34.36S", "058.36W", "12", "AR"],
    ["BUENOS AIRES/EZE", "SAEZ", "None", "87576", "34.49S", "058.31W", "20", "AR"],
    ["MENDOZA/EL PLUME", "SAME", "None", "87418", "32.49S", "068.46W", "704", "AR"],
    ["SAN MARTIN", "SAMI", "None", "87416", "33.04S", "068.25W", "653", "AR"],
    ["JACHAL", "SAMJ", "None", "87305", "30.15S", "068.45W", "1165", "AR"],
    ["MALARGUE AIRPORT", "SAMM", "None", "87506", "35.30S", "069.34W", "1425", "AR"],
    ["SAN RAFAEL AIRPO", "SAMR", "None", "87509", "34.34S", "068.24W", "748", "AR"],
    ["SAN CARLOS", "SAMS", "None", "87412", "33.46S", "069.01W", "940", "AR"],
    ["USPALLATA", "SAMU", "None", "87405", "32.36S", "069.19W", "1844", "AR"],
    ["CATAMARCA AIRPOR", "SANC", "None", "87222", "28.36S", "065.46W", "454", "AR"],
    ["SANTIAGO DEL EST", "SANE", "None", "87129", "27.46S", "064.17W", "199", "AR"],
    ["TINOGASTA", "SANI", "None", "87211", "28.04S", "067.34W", "1201", "AR"],
    ["LA RIOJA/CAPT VI", "SANL", "None", "87217", "29.22S", "066.49W", "429", "AR"],
    ["CHILECITO", "SANO", "None", "87214", "29.13S", "067.25W", "950", "AR"],
    ["TUCUMAN/TENIENTE", "SANT", "None", "87121", "26.51S", "065.05W", "450", "AR"],
    ["SAN JUAN AIRPORT", "SANU", "None", "87311", "31.34S", "068.25W", "598", "AR"],
    ["CERES", "SANW", "None", "87257", "29.52S", "061.57W", "88", "AR"],
    ["RIO CUARTO AIRPO", "SAOC", "None", "87453", "33.07S", "064.16W", "421", "AR"],
    ["VILLA DOLORES AR", "SAOD", "None", "87328", "31.56S", "065.07W", "569", "AR"],
    ["LABOULAYE", "SAOL", "None", "87534", "34.07S", "063.22W", "137", "AR"],
    ["MARCOS JUAREZ AR", "SAOM", "None", "87467", "32.42S", "062.08W", "114", "AR"],
    ["VILLA REYNOLDS A", "SAOR", "None", "87448", "33.43S", "065.22W", "486", "AR"],
    ["SAN LUIS AIRPORT", "SAOU", "None", "87436", "33.16S", "066.20W", "702", "AR"],
    ["CORRIENTES AIRPO", "SARC", "None", "87166", "27.26S", "058.46W", "62", "AR"],
    ["RESISTENCIA AIRP", "SARE", "None", "87155", "27.26S", "059.02W", "52", "AR"],
    ["FORMOSA AIRPORT", "SARF", "None", "87162", "26.13S", "058.13W", "60", "AR"],
    ["IGUAZU/CATARATAS", "SARI", "None", "87097", "25.43S", "054.28W", "270", "AR"],
    ["PASO DE LOS LIBR", "SARL", "None", "87289", "29.40S", "057.08W", "70", "AR"],
    ["MONTE CASEROS AR", "SARM", "None", "87393", "30.15S", "057.38W", "54", "AR"],
    ["POSADAS AIRPORT", "SARP", "None", "87178", "27.23S", "055.58W", "125", "AR"],
    ["PRESIDENT R S PE", "SARS", "None", "87149", "26.49S", "060.27W", "92", "AR"],
    ["SALTA AIRPORT", "SASA", "None", "87047", "24.51S", "065.28W", "1216", "AR"],
    ["JUJUY AIRPORT", "SASJ", "None", "87046", "24.22S", "065.06W", "1167", "AR"],
    ["ORAN AIRPORT", "SASO", "None", "87016", "23.08S", "064.19W", "357", "AR"],
    ["LA QUIACA OBSERV", "SASQ", "None", "87007", "22.06S", "065.35W", "3462", "AR"],
    ["RIVADAVIA", "SASR", "None", "87065", "24.10S", "062.53W", "205", "AR"],
    ["TARTAGAL AIRPORT", "SAST", "None", "87022", "22.38S", "063.49W", "450", "AR"],
    ["GOYA", "SATG", "None", "None", "29.06S", "059.13W", "38", "AR"],
    ["LAS LOMITAS", "SATK", "None", "87078", "24.41S", "060.34W", "130", "AR"],
    ["MERCEDES", "SATM", "None", "None", "29.13S", "058.04W", "107", "AR"],
    ["RECONQUISTA", "SATR", "None", "None", "29.13S", "059.41W", "48", "AR"],
    ["CURUZU CUATIA AR", "SATU", "None", "87286", "29.46S", "057.58W", "73", "AR"],
    ["EL BOLSON AERO", "SAVB", "None", "87800", "41.58S", "071.31W", "337", "AR"],
    ["COMODORO RIVADAV", "SAVC", "None", "87860", "45.46S", "067.28W", "46", "AR"],
    ["EL MAITEN", "SAVD", "None", "None", "42.01S", "071.10W", "720", "AR"],
    ["ESQUEL AIRPORT", "SAVE", "None", "87803", "42.54S", "071.09W", "794", "AR"],
    ["SAN ANTONIO OEST", "SAVO", "None", "87784", "40.45S", "065.02W", "7", "AR"],
    ["PASO DE INDIOS", "SAVP", "None", "87814", "43.49S", "068.52W", "460", "AR"],
    ["ALTO RIO SENGUER", "SAVR", "None", "None", "45.01S", "070.49W", "697", "AR"],
    ["TRELEW/ALMIRANTE", "SAVT", "None", "87828", "43.12S", "065.16W", "43", "AR"],
    ["VIEDMA/CASTELLO", "SAVV", "None", "87791", "40.51S", "063.01W", "7", "AR"],
    ["EL TEHUELCHE", "SAVY", "None", "None", "42.46S", "065.06W", "136", "AR"],
    ["LAGO ARGENTINO A", "SAWA", "None", "87903", "50.19S", "072.17W", "220", "AR"],
    ["PUERTO DESEADO A", "SAWD", "None", "87896", "47.43S", "065.55W", "80", "AR"],
    ["RIO GRANDE AIRPO", "SAWE", "None", "87934", "53.47S", "067.45W", "22", "AR"],
    ["RIO GALLEGOS ARP", "SAWG", "None", "87925", "51.37S", "069.19W", "19", "AR"],
    ["USHUAIA (ARG-NAV", "SAWH", "None", "87938", "54.51S", "068.18W", "14", "AR"],
    ["SAN JULIAN AIRPO", "SAWJ", "None", "87909", "49.19S", "067.46W", "62", "AR"],
    ["RIO MAYO", "SAWM", "None", "None", "45.42S", "070.15W", "545", "AR"],
    ["PERITO MORENO AR", "SAWP", "None", "87852", "46.31S", "071.01W", "429", "AR"],
    ["GOBERNADOR GREGO", "SAWR", "None", "87880", "48.46S", "070.10W", "356", "AR"],
    ["EL TURBIO/RIO TU", "SAWT", "None", "None", "51.36S", "072.13W", "273", "AR"],
    ["SANTA CRUZ AIRPO", "SAWU", "None", "87912", "50.01S", "068.34W", "111", "AR"],
    ["AZUL AIRPORT", "SAZA", "None", "87642", "36.45S", "059.49W", "132", "AR"],
    ["BAHIA BLANCA (MI", "SAZB", "None", "87750", "38.43S", "062.10W", "83", "AR"],
    ["DOLORES AIRPORT", "SAZD", "None", "87648", "36.21S", "057.43W", "9", "AR"],
    ["PIGUE AIRPORT", "SAZE", "None", "87679", "37.36S", "062.22W", "304", "AR"],
    ["GENERAL PICO ARP", "SAZG", "None", "87532", "35.42S", "063.45W", "145", "AR"],
    ["TRES ARROYOS", "SAZH", "None", "87688", "38.19S", "060.15W", "115", "AR"],
    ["BOLIVAR", "SAZI", "None", "87639", "36.11S", "061.05W", "94", "AR"],
    ["MAR DEL PLATA AR", "SAZM", "None", "87692", "37.55S", "057.34W", "21", "AR"],
    ["NEUQUEN AIRPORT", "SAZN", "None", "87715", "38.57S", "068.09W", "271", "AR"],
    ["NECOCHEA AIRPORT", "SAZO", "None", "87758", "38.28S", "058.49W", "32", "AR"],
    ["PEHUAJO/CMDR ZAN", "SAZP", "None", "87544", "35.52S", "061.53W", "86", "AR"],
    ["RIO COLORADO", "SAZQ", "None", "87736", "39.01S", "064.04W", "79", "AR"],
    ["SANTA ROSA AIRPO", "SAZR", "None", "87623", "36.34S", "064.16W", "191", "AR"],
    ["SAN CARLOS BARIL", "SAZS", "None", "87765", "41.08S", "071.10W", "840", "AR"],
    ["TANDIL AIRPORT", "SAZT", "None", "87645", "37.13S", "059.15W", "175", "AR"],
    ["VILLA GESELL", "SAZV", "None", "87663", "37.13S", "057.01W", "7", "AR"],
    ["CHAPELCO", "SAZY", "None", "87761", "40.04S", "071.07W", "779", "AR"],
    ["STANLEY AIRPORT", "SFAL", "None", "88891", "51.40S", "057.46W", "23", "FK"],
    ["MOUNT PLEASANT", "EGYP", "None", "88889", "51.49S", "058.27W", "74", "FK"],
    ["JOHAN A. PENGEL", "SMJP", "None", "None", "05.27N", "055.10W", "16", "SR"],
    ["NICKERIE FERNAND", "SMNI", "None", "None", "05.57N", "057.02W", "10", "SR"],
    ["SIPALIWINI", "SMSI", "None", "81251", "02.01N", "056.07W", "265", "SR"],
    ["STOELMANSEILAND", "SMST", "None", "81209", "04.20N", "054.25W", "52", "SR"],
    ["TAFELBERG/RUDI K", "SMTB", "None", "81250", "03.46N", "056.08W", "323", "SR"],
    ["PARAMARIBO", "SMZO", "None", "None", "05.49N", "055.11W", "10", "SR"],
    ["ZANDERY/PARAMARI", "SMZY", "None", "81225", "05.27N", "055.12W", "15", "SR"],
    ["AASIAAT/EGEDESMI", "BGAA", "None", "None", "68.42N", "052.48W", "41", "GL"],
    ["ANGMAGSSALIK", "BGAM", "None", "04360", "65.35N", "037.37W", "52", "GL"],
    ["ANGISSOQ (AUT)", "BGAS", "None", "04285", "59.58N", "045.12W", "16", "GL"],
    ["APUTITEQ ADS (AU", "BGAT", "None", "04351", "67.46N", "032.16W", "23", "GL"],
    ["NARSSARSSUAQ", "BGBW", "None", "04270", "61.10N", "045.25W", "26", "GL"],
    ["CHRISTIANHAB(POR", "BGCH", "None", "None", "68.45N", "051.30W", "76", "GL"],
    ["CONSTABLE POINT", "BGCO", "None", "04341", "70.44N", "022.39W", "10", "GL"],
    ["DANEBORG (AUT)", "BGDB", "None", "04330", "74.17N", "020.13W", "44", "GL"],
    ["DANMARKSHAVN (PO", "BGDH", "None", "04320", "76.46N", "018.40W", "12", "GL"],
    ["DUNDAS", "BGDU", "None", "None", "76.30N", "069.00W", "20", "GL"],
    ["EGEDESMINDE/AUSI", "BGEM", "None", "04220", "68.42N", "052.45W", "47", "GL"],
    ["FREDERIKSDAL", "BGFD", "None", "None", "60.15N", "045.30W", "23", "GL"],
    ["FREDERIKSHAB (PO", "BGFH", "None", "04260", "62.00N", "049.43W", "16", "GL"],
    ["GRONNEDAL", "BGGD", "None", "04261", "61.13N", "048.07W", "29", "GL"],
    ["GODTHAB (PORT)", "BGGH", "None", "04250", "64.12N", "051.41W", "70", "GL"],
    ["GODHAVN (PORT)", "BGGN", "None", "None", "69.19N", "053.34W", "24", "GL"],
    ["HOLSTEINSBORG", "BGHB", "None", "04230", "66.55N", "053.40W", "9", "GL"],
    ["JULIANEHAB (PORT", "BGJH", "None", "04272", "60.43N", "046.02W", "34", "GL"],
    ["JAKOBSHAVN (PORT", "BGJN", "None", "04221", "69.15N", "051.04W", "25", "GL"],
    ["KULUSUK AIRPORT", "BGKK", "None", "04361", "65.34N", "037.08W", "34", "GL"],
    ["CAPE TOBIN (AUT)", "BGKT", "None", "04340", "70.25N", "021.58W", "41", "GL"],
    ["MANIITSOQ", "BGMQ", "None", "None", "65.25N", "052.56W", "15", "GL"],
    ["MESTERS VIG", "BGMV", "None", "None", "72.15N", "024.19W", "10", "GL"],
    ["NANORTALIK", "BGNN", "None", "None", "60.31N", "045.45W", "20", "GL"],
    ["NARSSAQ", "BGNS", "None", "None", "61.00N", "046.00W", "30", "GL"],
    ["QAANAAQ", "BGQQ", "None", "None", "77.29N", "069.23W", "19", "GL"],
    ["PRINS CHRISTIAN", "BGPC", "None", "04390", "60.01N", "043.07W", "19", "GL"],
    ["PAAMIUT", "BGPT", "None", "None", "62.01N", "049.40W", "2", "GL"],
    ["SCORESBYSUND", "BGSC", "None", "04339", "70.28N", "021.58W", "66", "GL"],
    ["SONDRE STROMFJOR", "BGSF", "None", "04231", "67.00N", "050.43W", "53", "GL"],
    ["SISIMIUT", "BGSS", "None", "None", "66.57N", "053.44W", "50", "GL"],
    ["SUKKERTOPPEN", "BGST", "None", "None", "65.25N", "053.00W", "24", "GL"],
    ["THULE AB", "BGTL", "None", "04202", "76.32N", "068.42W", "77", "GL"],
    ["TINGMIARMIUT", "BGTM", "None", "None", "62.25N", "042.15W", "10", "GL"],
    ["UPERNAVIK", "BGUK", "None", "None", "72.47N", "056.08W", "127", "GL"],
    ["UUMMANNAQ/QAARSU", "BGUQ", "None", "None", "70.44N", "052.42W", "2", "GL"],
    ["UPERNAVIK AWS (A", "BGUP", "None", "04209", "72.46N", "056.10W", "63", "GL"],
    ["WALRUS BAY", "None", "None", "04342", "70.30N", "021.58W", "7", "GL"],
    ["IKATEQ", "BIKA", "None", "04353", "65.56N", "036.41W", "56", "GL"],
    ["MARRAK POINT", "BMKA", "None", "04255", "63.26N", "051.11W", "41", "GL"],
    ["AKUREYRI", "BIAR", "None", "04063", "65.40N", "018.04W", "27", "IS"],
    ["BILDUDALUR", "BIBD", "None", "None", "65.38N", "023.33W", "6", "IS"],
    ["EGILSSTADIR", "BIEG", "None", "04089", "65.16N", "014.24W", "38", "IS"],
    ["GRIMSEY ISLAND", "BIGR", "None", "04065", "66.31N", "018.01W", "16", "IS"],
    ["HJARDARNES/HORNA", "BIHN", "None", "04082", "64.18N", "015.14W", "7", "IS"],
    ["ISAFJOROUR", "BIIS", "None", "None", "66.03N", "023.08W", "3", "IS"],
    ["KEFLAVIK (CIV/MI", "BIKF", "None", "04018", "63.59N", "022.36W", "54", "IS"],
    ["SAUOARKROKUR", "BIKR", "None", "None", "65.44N", "019.34W", "3", "IS"],
    ["RAUFARHOFN", "BIRG", "None", "04077", "66.27N", "015.56W", "10", "IS"],
    ["REYKJAVIK (NOTAM", "BIRK", "None", "04030", "64.08N", "021.56W", "61", "IS"],
    ["STYKKISHOLMUR", "BIST", "None", "04013", "65.04N", "022.43W", "8", "IS"],
    ["VESTMANNAEYJAR (", "BIVM", "None", "04048", "63.25N", "020.16W", "124", "IS"],
    ["SKJALDTHINGSSTAD", "BIVO", "None", "04085", "65.45N", "014.49W", "48", "IS"],
    ["HVALLATUR", "None", "None", "04001", "65.32N", "024.28W", "17", "IS"],
    ["ANTWERP/DEURNE", "EBAW", "None", "06450", "51.12N", "004.28E", "14", "BE"],
    ["BEAUVECHAIN (BAF", "EBBE", "None", "06458", "50.45N", "004.46E", "127", "BE"],
    ["KLEINE-BROGEL(BA", "EBBL", "None", "06479", "51.10N", "005.28E", "64", "BE"],
    ["BRUSSELS NATIONA", "EBBR", "None", "06451", "50.54N", "004.30E", "58", "BE"],
    ["BRASSCHAAT (MIL)", "EBBT", "None", "06452", "51.19N", "004.30E", "23", "BE"],
    ["BERTRIX (BEL-AFB", "EBBX", "None", "06467", "49.53N", "005.13E", "461", "BE"],
    ["CHARLEROI/GOSSEL", "EBCI", "None", "06449", "50.28N", "004.27E", "192", "BE"],
    ["CHIEVRES AB", "EBCV", "None", "06432", "50.34N", "003.49E", "63", "BE"],
    ["SCHAFFEN", "EBDT", "None", "06465", "51.01N", "005.04E", "54", "BE"],
    ["KOKSIJDE (BEL-AF", "EBFN", "None", "06400", "51.04N", "002.38E", "9", "BE"],
    ["FLORENNES (BEL-A", "EBFS", "None", "06456", "50.13N", "004.39E", "299", "BE"],
    ["GRIMBERGEN", "EBGB", "None", "None", "50.57N", "004.24E", "21", "BE"],
    ["HOEVENEN", "EBHN", "None", "None", "51.18N", "004.23E", "3", "BE"],
    ["BALEN-KEIHEUVEL", "EBKH", "None", "None", "51.11N", "005.13E", "40", "BE"],
    ["KORTRIJK", "EBKT", "None", "None", "50.49N", "003.12E", "20", "BE"],
    ["ELSENBORN (MIL)", "EBLB", "None", "06496", "50.28N", "006.10E", "570", "BE"],
    ["BIERSET/LIEGE (C", "EBLG", "None", "06478", "50.38N", "005.27E", "178", "BE"],
    ["BIERSET/LIEGE (M", "EBLH", "None", "None", "50.38N", "005.27E", "178", "BE"],
    ["MELSBROEK (BEL-A", "EBMB", "None", "06448", "50.53N", "004.30E", "55", "BE"],
    ["OOSTENDE AIRPORT", "EBOS", "None", "06407", "51.12N", "002.52E", "5", "BE"],
    ["SPA/LA SAUVENIER", "EBSP", "None", "06490", "50.28N", "005.55E", "482", "BE"],
    ["ST. TRUIDEN (BAF", "EBST", "None", "06470", "50.47N", "005.12E", "75", "BE"],
    ["SAINT HUBERT", "EBSH", "None", "None", "50.01N", "005.24E", "588", "BE"],
    ["SAINT HUBERT (MI", "EBSU", "None", "06476", "50.01N", "005.24E", "557", "BE"],
    ["SEMMERZAKE (MIL)", "EBSZ", "None", "06428", "50.56N", "003.39E", "37", "BE"],
    ["GOETSENHOVEN (MI", "EBTN", "None", "06463", "50.46N", "004.57E", "81", "BE"],
    ["MAUBRAY", "EBTY", "None", "None", "50.32N", "003.30E", "49", "BE"],
    ["WEELDE (MIL)", "EBWE", "None", "06462", "51.25N", "005.00E", "60", "BE"],
    ["BRUSSELS (MIL)", "EBWM", "None", "None", "50.53N", "004.31E", "58", "BE"],
    ["HASSELT KIVIT", "EBZH", "None", "None", "50.58N", "005.23E", "43", "BE"],
    ["GENK/ZWARTBERG", "EBZW", "None", "06481", "51.01N", "005.32E", "63", "BE"],
    ["UCCLE/UKKLE", "None", "None", "06447", "50.48N", "004.21E", "100", "BE"],
    ["GENT/INDUSTRY ZO", "EBGT", "None", "06431", "51.11N", "003.48E", "13", "BE"],
    ["MUNTE (MIL)", "EBMT", "None", "None", "50.55N", "003.43E", "60", "BE"],
    ["ALTENBURG-NOBITZ", "EDAC", "AOC", "None", "50.59N", "012.30E", "195", "DE"],
    ["DESSAU", "EDAD", "None", "None", "51.50N", "012.11E", "57", "DE"],
    ["HERINGSDORF", "EDAH", "None", "None", "53.52N", "014.09E", "28", "DE"],
    ["BERLIN/TEMPLEHO", "EDBB", "None", "None", "52.28N", "013.24E", "49", "DE"],
    ["COCHSTEDT ARPT", "EDBC", "None", "None", "51.51N", "011.25E", "181", "DE"],
    ["MAGDEBURG", "EDBM", "None", "None", "52.06N", "011.35E", "82", "DE"],
    ["ALLSTEDT", "EDBT", "None", "None", "51.23N", "011.27E", "284", "DE"],
    ["PAROW", "EDCP", "None", "10181", "54.22N", "013.04E", "4", "DE"],
    ["BERLIN/SCHONEFEL", "EDDB", "None", "10385", "52.23N", "013.32E", "48", "DE"],
    ["DRESDEN/KLOTZSCH", "EDDC", "None", "10488", "51.08N", "013.45E", "226", "DE"],
    ["ERFURT/BINDERSLE", "EDDE", "None", "10554", "50.59N", "010.58E", "323", "DE"],
    ["FRANKFURT MAIN A", "EDDF", "None", "10637", "50.03N", "008.36E", "113", "DE"],
    ["MUENSTER/OSNABRU", "EDDG", "None", "10315", "52.08N", "007.42E", "52", "DE"],
    ["HAMBURG/FUHLSBUT", "EDDH", "None", "10147", "53.38N", "010.00E", "16", "DE"],
    ["BERLIN/TEMPELHOF", "EDDI", "None", "10384", "52.28N", "013.24E", "49", "DE"],
    ["KOELN/BONN", "EDDK", "None", "10513", "50.52N", "007.09E", "99", "DE"],
    ["DUESSELDORF", "EDDL", "None", "10400", "51.18N", "006.46E", "44", "DE"],
    ["MUNICH-FLUGHAFEN", "EDDM", "None", "10870", "48.21N", "011.49E", "447", "DE"],
    ["NUERNBERG", "EDDN", "None", "10763", "49.30N", "011.05E", "312", "DE"],
    ["LEIPZIG/SCHKEUDI", "EDDP", "None", "10469", "51.26N", "012.14E", "149", "DE"],
    ["SAARBRUECKEN", "EDDR", "None", "10708", "49.13N", "007.06E", "320", "DE"],
    ["STUTTGART/ECHTER", "EDDS", "None", "10738", "48.40N", "009.13E", "419", "DE"],
    ["BERLIN/TEGEL (FA", "EDDT", "None", "10382", "52.34N", "013.19E", "37", "DE"],
    ["HANNOVER", "EDDV", "None", "10338", "52.28N", "009.41E", "54", "DE"],
    ["BREMEN", "EDDW", "None", "10224", "53.02N", "008.48E", "5", "DE"],
    ["BABENHAUSEN(USA", "EDEF", "None", "10643", "49.57N", "008.58E", "131", "DE"],
    ["BAUMHOLDER (USA", "EDEK", "None", "10619", "49.38N", "007.17E", "426", "DE"],
    ["EGELSBACH", "EDFE", "None", "None", "49.58N", "008.38E", "118", "DE"],
    ["HAHN", "EDFH", "None", "10616", "49.57N", "007.16E", "498", "DE"],
    ["MANNHEIM", "EDFM", "None", "10729", "49.31N", "008.33E", "100", "DE"],
    ["SIEGERLAND", "EDGS", "None", "None", "50.42N", "008.05E", "602", "DE"],
    ["ITZEHOE", "EDHF", "None", "10142", "54.00N", "009.34E", "26", "DE"],
    ["HAMBURG/FINKENWE", "EDHI", "None", "10149", "53.32N", "009.50E", "13", "DE"],
    ["KIEL/HOLTENAU CI", "EDHK", "None", "None", "54.23N", "010.09E", "31", "DE"],
    ["LUEBECK/BLANKENS", "EDHL", "None", "10156", "53.48N", "010.43E", "16", "DE"],
    ["GIESSEN (USA-HP", "EDIA", "None", "10533", "50.36N", "008.43E", "152", "DE"],
    ["ILLESHEIM (USAF)", "EDIK", "None", "10752", "49.28N", "010.23E", "325", "DE"],
    ["FEUCHT (USA-AF)", "EDIG", "None", "10764", "49.23N", "011.11E", "386", "DE"],
    ["HOHENFELS (USAF)", "EDIH", "None", "10775", "49.13N", "011.49E", "442", "DE"],
    ["MEMMINGEN ALLGAU", "EDJA", "None", "None", "47.59N", "010.14E", "633", "DE"],
    ["MONCHENGLADBACH", "EDLN", "None", "None", "51.14N", "006.30E", "38", "DE"],
    ["PADERBORN/LIPPST", "EDLP", "None", "10426", "51.37N", "008.37E", "213", "DE"],
    ["NIEDERRHEIN", "EDLV", "None", "None", "51.36N", "006.09E", "32", "DE"],
    ["DORTMUND/WICKEDE", "EDLW", "None", "10416", "51.31N", "007.37E", "127", "DE"],
    ["AUGSBURG/MULHAUS", "EDMA", "None", "10852", "48.25N", "010.55E", "463", "DE"],
    ["OBERPFAFFENHOFEN", "EDMO", "None", "None", "48.04N", "011.16E", "600", "DE"],
    ["FRIEDRICHSHAFEN", "EDNY", "None", "10935", "47.40N", "009.31E", "424", "DE"],
    ["SCHWERIN-PARCHIM", "EDOP", "None", "None", "53.26N", "011.47E", "51", "DE"],
    ["NEUHAUSEN OB EC", "EDPH", "None", "10921", "47.58N", "008.54E", "794", "DE"],
    ["BAYREUTH", "EDQD", "None", "10677", "49.58N", "011.37E", "498", "DE"],
    ["HOF", "EDQM", "None", "10685", "50.18N", "011.51E", "568", "DE"],
    ["ZWEIBRUCKEN", "EDRZ", "None", "None", "49.13N", "007.24E", "344", "DE"],
    ["KARLSRUHE/BADEN", "EDSB", "FKB", "None", "48.47N", "008.05E", "124", "DE"],
    ["DONAUESCHINGEN", "EDTD", "None", "None", "47.58N", "008.31E", "680", "DE"],
    ["LAHR (CAN-AFB)", "EDTL", "None", "None", "48.22N", "007.50E", "156", "DE"],
    ["SCHWAEBISCH HALL", "EDTY", "None", "None", "49.07N", "009.47E", "400", "DE"],
    ["KONSTANZ", "EDTZ", "None", "10929", "47.41N", "009.11E", "447", "DE"],
    ["BRAUNSCHWEIG", "EDVE", "None", "10348", "52.19N", "010.33E", "88", "DE"],
    ["KASSEL/CALDEN", "EDVK", "None", "10436", "51.23N", "009.22E", "285", "DE"],
    ["LEMWERDER", "EDWD", "None", "None", "53.08N", "008.37E", "30", "DE"],
    ["EMDEN-KOENIGSPO", "EDWE", "None", "10200", "53.23N", "007.14E", "5", "DE"],
    ["WESTERLAND/SYLT", "EDXW", "None", "10018", "54.55N", "008.20E", "20", "DE"],
    ["ESSEN/MULHEIM", "EDZE", "None", "10410", "51.24N", "006.58E", "161", "DE"],
    ["SPANGDAHLEM (USA", "ETAD", "None", "10607", "49.59N", "006.42E", "365", "DE"],
    ["RAMSTEIN (USAFB)", "ETAR", "None", "10614", "49.25N", "007.35E", "238", "DE"],
    ["PIRNA-PRATZSCHWI", "EDAR", "None", "None", "50.59N", "013.55E", "400", "DE"],
    ["SEMBACH (USAFB)", "ETAS", "None", "10712", "49.30N", "007.52E", "321", "DE"],
    ["SEMBACH (USAFB)", "EDAS", "None", "None", "49.30N", "007.52E", "321", "DE"],
    ["AACHEN/MERZBRUCK", "ETBA", "None", "10503", "50.49N", "006.10E", "191", "DE"],
    ["BUTZWEILERHOF (B", "ETBB", "None", "10509", "50.58N", "006.54E", "49", "DE"],
    ["KATTERBACH (USA-", "ETEB", "None", "10755", "49.19N", "010.37E", "467", "DE"],
    ["BAD KREUZNACH AA", "ETEH", "None", "10627", "49.51N", "007.52E", "103", "DE"],
    ["GIEBELSTADT(USA-", "ETEU", "None", "10653", "49.38N", "009.58E", "298", "DE"],
    ["BERGEN (MIL)", "ETGB", "None", "10238", "52.49N", "009.55E", "69", "DE"],
    ["MEIERWIK", "ETGG", "None", "10033", "54.50N", "009.30E", "33", "DE"],
    ["IDAR-OBERSTEIN(M", "ETGI", "None", "10618", "49.42N", "007.19E", "377", "DE"],
    ["KUEMMERSBRUCK", "ETGK", "None", "10771", "49.26N", "011.54E", "418", "DE"],
    ["MEPPEN (MIL)", "ETGM", "None", "10304", "52.43N", "007.19E", "26", "DE"],
    ["ROTENBURG", "ETGQ", "None", "None", "53.08N", "009.21E", "61", "DE"],
    ["WITTSTOCK", "ETGW", "None", "10272", "53.12N", "012.31E", "74", "DE"],
    ["KALKAR (MIL COMM", "ETGY", "None", "10404", "51.45N", "006.16E", "43", "DE"],
    ["MESSSTETTEN", "ETGZ", "None", "10827", "48.11N", "009.00E", "920", "DE"],
    ["ALTENSTADT/SCHON", "ETHA", "None", "10954", "47.49N", "010.52E", "760", "DE"],
    ["BUCKEBURG(GER-AR", "ETHB", "None", "10335", "52.16N", "009.04E", "78", "DE"],
    ["CELLE (GER-ARMY)", "ETHC", "None", "10343", "52.36N", "010.01E", "52", "DE"],
    ["RHEINE/BENTLAGE", "ETHE", "None", "10306", "52.17N", "007.22E", "49", "DE"],
    ["FRITZLAR (GER-AR", "ETHF", "None", "10439", "51.07N", "009.16E", "181", "DE"],
    ["ITZEHOE (GER-ARM", "ETHI", "None", "None", "54.00N", "009.34E", "26", "DE"],
    ["LAUPHEIM (GER-AR", "ETHL", "None", "10837", "48.13N", "009.55E", "549", "DE"],
    ["MENDIG (GER-ARMY", "ETHM", "None", "10514", "50.22N", "007.19E", "191", "DE"],
    ["NIEDERSTETTEN (G", "ETHN", "None", "10743", "49.23N", "009.58E", "473", "DE"],
    ["ROTH (GER-ARMY)", "ETHR", "None", "10765", "49.13N", "011.05E", "395", "DE"],
    ["FASSBERG (GER-AF", "ETHS", "None", "10246", "52.55N", "010.11E", "88", "DE"],
    ["COTTBUS (FLUGPLA", "ETHT", "None", "10492", "51.46N", "014.18E", "67", "DE"],
    ["GRAFENWOEHR", "ETIC", "None", "10687", "49.42N", "011.56E", "415", "DE"],
    ["HANAU (USA-AF)", "ETID", "None", "10642", "50.10N", "008.58E", "112", "DE"],
    ["HEIDELBERG (USA-", "ETIE", "None", "10734", "49.23N", "008.39E", "109", "DE"],
    ["HOHENFELS (USA-A", "ETIH", "None", "None", "49.13N", "011.49E", "442", "DE"],
    ["ILLESHEIM (USA-A", "ETIK", "None", "None", "49.28N", "010.22E", "325", "DE"],
    ["KITZINGEN (USA-A", "ETIN", "None", "10659", "49.45N", "010.11E", "210", "DE"],
    ["EGGEBEK (GER-NAV", "ETME", "None", "10034", "54.37N", "009.20E", "22", "DE"],
    ["KIEL/HOLTENAU(GN", "ETMK", "None", "10046", "54.23N", "010.09E", "31", "DE"],
    ["NORDHOLZ (GER-NA", "ETMN", "None", "10136", "53.46N", "008.40E", "31", "DE"],
    ["AHLHORN (GER-AFB", "ETNA", "None", "10218", "52.53N", "008.14E", "45", "DE"],
    ["DIEPHOLZ (GER-AF", "ETND", "None", "10321", "52.35N", "008.21E", "43", "DE"],
    ["GEILENKIRCHEN(NA", "ETNG", "None", "10500", "50.58N", "006.02E", "98", "DE"],
    ["HOHN (GER-AFB)", "ETNH", "None", "10038", "54.19N", "009.33E", "17", "DE"],
    ["JEVER (GER-AFB)", "ETNJ", "None", "10122", "53.31N", "007.52E", "21", "DE"],
    ["LAAGE", "ETNL", "None", "10172", "53.55N", "012.16E", "40", "DE"],
    ["NOERVENICH (GAF)", "ETNN", "None", "10502", "50.49N", "006.40E", "135", "DE"],
    ["HOPSTEN (GER-AFB", "ETNP", "None", "10314", "52.19N", "007.32E", "43", "DE"],
    ["SCHLESWIG(GER-NA", "ETNS", "None", "10037", "54.28N", "009.31E", "25", "DE"],
    ["WITTMUNDHAVEN(GA", "ETNT", "None", "10126", "53.32N", "007.40E", "12", "DE"],
    ["TROLLENHAGEN", "ETNU", "None", "10281", "53.36N", "013.19E", "71", "DE"],
    ["WUNSTORF (GER-AF", "ETNW", "None", "10334", "52.27N", "009.25E", "70", "DE"],
    ["COLEMAN (USA-AF)", "ETOR", "None", "10728", "49.34N", "008.28E", "94", "DE"],
    ["WIESBADEN (USA-A", "ETOU", "None", "10633", "50.02N", "008.19E", "141", "DE"],
    ["LANDSBERG (GER-A", "ETSA", "None", "10857", "48.04N", "010.54E", "628", "DE"],
    ["BUECHEL", "ETSB", "None", "10613", "50.10N", "007.04E", "486", "DE"],
    ["ERDING (GER-AFB)", "ETSE", "None", "10869", "48.19N", "011.56E", "467", "DE"],
    ["FUERSTENFELDBRUC", "ETSF", "None", "10858", "48.12N", "011.16E", "535", "DE"],
    ["HOLZDORF", "ETSH", "None", "10476", "51.46N", "013.10E", "79", "DE"],
    ["INGOLSTADT(GER-M", "ETSI", "None", "10860", "48.43N", "011.31E", "370", "DE"],
    ["LECHFELD (GER-AF", "ETSL", "None", "10856", "48.10N", "010.52E", "562", "DE"],
    ["MEMMINGEN (GER-A", "ETSM", "None", "10947", "47.58N", "010.13E", "644", "DE"],
    ["NEUBURG/DONAU", "ETSN", "None", "10853", "48.43N", "011.13E", "387", "DE"],
    ["PFERDSFELD (GER-", "ETSP", "None", "10626", "49.51N", "007.35E", "396", "DE"],
    ["LAARBRUCH (RAF)", "ETUL", "None", "10405", "51.36N", "006.09E", "31", "DE"],
    ["NORDHORN RANGE", "ETUN", "None", "10308", "52.27N", "007.10E", "26", "DE"],
    ["GUETERSLOH (RAF)", "ETUO", "None", "10320", "51.47N", "008.18E", "72", "DE"],
    ["BRUGGEN (RAF)", "ETUR", "None", "10401", "51.12N", "006.07E", "76", "DE"],
    ["MEPPEN", "ETWM", "None", "None", "52.43N", "007.20E", "21", "DE"],
    ["MUENSTER/OSNABRU", "EDLG", "None", "None", "52.07N", "007.42E", "52", "DE"],
    ["MUNICH-RIEM EDDM", "None", "None", "10866", "48.07N", "011.41E", "529", "DE"],
    ["HANNOVER", "EDVV", "None", "None", "52.28N", "009.41E", "54", "DE"],
    ["ESSEN", "EDLE", "None", "None", "51.24N", "006.58E", "161", "DE"],
    ["BERGEN/HOHNE", "EDZB", "None", "None", "52.49N", "009.55E", "70", "DE"],
    ["IDAR/OBERSTEIN", "EDZJ", "None", "None", "49.42N", "007.19E", "377", "DE"],
    ["GAERMERSDORF", "EDZH", "None", "None", "49.25N", "011.54E", "419", "DE"],
    ["MENDIG (GER-ARM", "EDPN", "None", "None", "50.22N", "007.19E", "191", "DE"],
    ["GRAFENWOHR (USA", "EDIC", "None", "None", "49.42N", "011.56E", "415", "DE"],
    ["KIEL/HOLTENAU(G", "EDCK", "None", "None", "54.22N", "010.09E", "31", "DE"],
    ["NORVENICH (GER-", "EDNN", "None", "None", "50.49N", "006.40E", "135", "DE"],
    ["BERLIN/SCHONEFE", "ETBS", "None", "None", "52.22N", "013.31E", "48", "DE"],
    ["SCHLESWIG", "None", "None", "10035", "54.32N", "009.33E", "48", "DE"],
    ["GREIFSWALD", "None", "None", "10184", "54.06N", "013.23E", "2", "DE"],
    ["LINDENBERG", "None", "None", "10393", "52.13N", "014.07E", "115", "DE"],
    ["OPIN", "None", "None", "10468", "51.32N", "012.04E", "106", "DE"],
    ["WAHNSDORF", "None", "None", "10486", "51.07N", "013.41E", "246", "DE"],
    ["MEININGEN", "None", "None", "10548", "50.34N", "010.22E", "450", "DE"],
    ["CHEMNITZ", "None", "None", "10577", "50.48N", "012.52E", "419", "DE"],
    ["STUTTGART/SCHNAR", "None", "None", "10739", "48.50N", "009.12E", "315", "DE"],
    ["MUENCHEN/OBERSCH", "None", "None", "10868", "48.15N", "011.35E", "484", "DE"],
    ["HOHENPEISSENBERG", "None", "None", "10962", "47.48N", "011.01E", "986", "DE"],
    ["FURSTENZELL", "None", "None", "10895", "48.33N", "013.21E", "480", "DE"],
    ["KARDLA", "EEKA", "None", "26116", "58.59N", "022.50E", "4", "EE"],
    ["KURESSAARE", "EEKE", "None", "None", "58.14N", "022.31E", "4", "EE"],
    ["PARNU", "EEPU", "None", "None", "58.25N", "024.28E", "14", "EE"],
    ["TALLINN", "EETN", "None", "26038", "59.24N", "024.49E", "40", "EE"],
    ["TARTU", "EETU", "None", "None", "58.19N", "026.41E", "67", "EE"],
    ["ENONTEKIO", "EFET", "None", "None", "68.22N", "023.26E", "306", "FI"],
    ["HALLI (FIN-AFB)", "EFHA", "None", "02945", "61.51N", "024.48E", "145", "FI"],
    ["HELSINKI/MALMI", "EFHF", "None", "02975", "60.15N", "025.03E", "28", "FI"],
    ["HELSINKI/VANTAA", "EFHK", "None", "02974", "60.19N", "024.58E", "56", "FI"],
    ["HAILUOTO ISLAND", "EFHL", "None", "02874", "65.01N", "024.48E", "6", "FI"],
    ["AHTARI", "EFHT", "None", "02924", "62.31N", "024.13E", "161", "FI"],
    ["ILMAJOKI", "EFIL", "None", "None", "62.42N", "022.49E", "92", "FI"],
    ["IVALO", "EFIV", "None", "02807", "68.37N", "027.25E", "148", "FI"],
    ["JOENSUU", "EFJO", "None", "02929", "62.40N", "029.37E", "117", "FI"],
    ["JYVASKYLA (MIL/C", "EFJY", "None", "02935", "62.24N", "025.41E", "145", "FI"],
    ["KAUHAVA (FIN-AFB", "EFKA", "None", "02913", "63.06N", "023.03E", "44", "FI"],
    ["KEMI", "EFKE", "None", "02864", "65.46N", "024.34E", "15", "FI"],
    ["KAJAANI", "EFKI", "None", "02897", "64.16N", "027.40E", "136", "FI"],
    ["KRUUNUPYY", "EFKK", "None", "02903", "63.43N", "023.08E", "25", "FI"],
    ["KUUSAMO", "EFKS", "None", "02869", "66.00N", "029.14E", "263", "FI"],
    ["KITTILA", "EFKT", "None", "None", "67.42N", "024.51E", "643", "FI"],
    ["KUOPIO (MIL/CIV)", "EFKU", "None", "02917", "63.01N", "027.48E", "102", "FI"],
    ["LAPPEENRANTA", "EFLP", "None", "02958", "61.04N", "028.08E", "106", "FI"],
    ["LUOSTO FELL", "None", "None", "05841", "67.08N", "026.54E", "525", "FI"],
    ["MARIEHAMN/ALAND", "EFMA", "None", "02970", "60.07N", "019.53E", "6", "FI"],
    ["MIKKELI", "EFMI", "None", "02947", "61.41N", "027.12E", "138", "FI"],
    ["OULU/ULEABORG", "EFOU", "None", "02875", "64.55N", "025.22E", "15", "FI"],
    ["PELLO", "EFPE", "None", "02844", "66.47N", "024.00E", "84", "FI"],
    ["PORI (MIL/CIV)", "EFPO", "None", "02952", "61.28N", "021.48E", "17", "FI"],
    ["PUDASJARVI", "EFPU", "None", "02867", "65.22N", "027.01E", "117", "FI"],
    ["ROVANIEMI (CIV/M", "EFRO", "None", "02845", "66.34N", "025.49E", "201", "FI"],
    ["SAVONLINNA (AUT)", "EFSA", "None", "02948", "61.57N", "028.56E", "95", "FI"],
    ["SEINAJOKI-ILMAJO", "EFSI", "SJY", "None", "62.42N", "022.50E", "91", "FI"],
    ["SODANKYLA", "EFSO", "None", "02836", "67.22N", "026.38E", "179", "FI"],
    ["SUOMUSSALMI", "EFSU", "None", "02879", "64.54N", "029.01E", "224", "FI"],
    ["TAMPERE/PIRKKALA", "EFTP", "None", "02944", "61.25N", "023.37E", "112", "FI"],
    ["TURKU/ABO", "EFTU", "None", "02972", "60.31N", "022.16E", "59", "FI"],
    ["UTTI (FIN-AFB)", "EFUT", "None", "02966", "60.53N", "026.55E", "100", "FI"],
    ["VAASA", "EFVA", "None", "02911", "63.02N", "021.46E", "4", "FI"],
    ["VIITASAARI", "EFVI", "None", "02915", "63.04N", "025.52E", "132", "FI"],
    ["VARKAUS", "EFVR", "None", "None", "62.10N", "027.52E", "87", "FI"],
    ["YLIVIESKA", "EFYL", "None", "None", "64.02N", "024.43E", "77", "FI"],
    ["JOKIOINEN", "None", "None", "02963", "60.49N", "023.30E", "103", "FI"],
    ["BELFAST/ALDERGRO", "EGAA", "None", "03917", "54.38N", "006.13W", "81", "GB"],
    ["BELFAST HARBOUR", "EGAC", "None", "03924", "54.37N", "005.52W", "5", "GB"],
    ["EGLINTON/LONDOND", "EGAE", "None", "None", "55.02N", "007.09W", "9", "GB"],
    ["BIRMINGHAM AIRPO", "EGBB", "None", "03534", "52.28N", "001.45W", "99", "GB"],
    ["CAMPBELTOWN", "EGEC", "CAL", "None", "55.26N", "005.41W", "13", "GB"],
    ["COVENTRY AIRPORT", "EGBE", "None", "None", "52.22N", "001.28W", "82", "GB"],
    ["STAVERTON (PRIVA", "EGBJ", "None", "None", "51.54N", "002.10W", "29", "GB"],
    ["KEMBLE RAF", "EGBP", "None", "None", "51.40N", "002.02W", "133", "GB"],
    ["MANCHESTER INTL", "EGCC", "None", "03334", "53.21N", "002.16W", "78", "GB"],
    ["STRUBBY HELIPORT", "EGCG", "None", "None", "53.19N", "000.10E", "14", "GB"],
    ["DONCASTER SHEFFI", "EGCN", "None", "None", "53.29N", "001.00W", "17", "GB"],
    ["PLYMOUTH/MOUNTBA", "EGDB", "None", "03827", "50.21N", "004.07W", "27", "GB"],
    ["CHIVENOR RAF", "EGDC", "None", "03707", "51.05N", "004.09W", "8", "GB"],
    ["NEWQUAY", "EGHQ", "None", "None", "50.26N", "005.00W", "119", "GB"],
    ["LYNEHAM RAF", "EGDL", "None", "03740", "51.30N", "001.58W", "156", "GB"],
    ["BOSCOMBE DOWN", "EGDM", "None", "03746", "51.10N", "001.45W", "124", "GB"],
    ["NETHERAVON (ARMY", "EGDN", "None", "03745", "51.15N", "001.46W", "139", "GB"],
    ["PORTLAND HELIPOR", "EGDP", "None", "03858", "50.34N", "002.27W", "3", "GB"],
    ["CULDROSE (NAVY)", "EGDR", "None", "03809", "50.05N", "005.15W", "82", "GB"],
    ["ST ATHAN RAF", "EGDX", "None", "None", "51.24N", "003.26W", "50", "GB"],
    ["YEOVILTON (NAVY)", "EGDY", "None", "03853", "51.00N", "002.37W", "23", "GB"],
    ["OBAN AIRPORT", "EGEO", "None", "None", "56.28N", "005.24W", "6", "GB"],
    ["CARDIFF-WALES AR", "EGFF", "None", "03715", "51.23N", "003.21W", "67", "GB"],
    ["SWANSEA", "EGFH", "None", "None", "51.36N", "004.04W", "90", "GB"],
    ["BRISTOL/LULSGATE", "EGGD", "None", "None", "51.22N", "002.43W", "189", "GB"],
    ["LIVERPOOL AIRPOR", "EGGP", "None", "None", "53.19N", "002.51W", "26", "GB"],
    ["LUTON AIRPORT", "EGGW", "None", "None", "51.52N", "000.22W", "160", "GB"],
    ["PLYMOUTH/ROBOROU", "EGHD", "None", "None", "50.25N", "004.07W", "25", "GB"],
    ["SCILLY SAINT MAR", "EGHE", "None", "03803", "49.55N", "006.17W", "31", "GB"],
    ["BOURNEMOUTH AIRP", "EGHH", "None", "03862", "50.47N", "001.50W", "11", "GB"],
    ["SOUTHAMPTON WX C", "EGHI", "None", "03865", "50.57N", "001.21W", "14", "GB"],
    ["PENZANCE HELIPOR", "EGHK", "None", "None", "50.07N", "005.31W", "4", "GB"],
    ["ALDERNEY/CHANNEL", "EGJA", "None", "None", "49.43N", "002.12W", "71", "GB"],
    ["GUERNSEY AIRPORT", "EGJB", "None", "03894", "49.25N", "002.36W", "102", "GB"],
    ["JERSEY AIRPORT", "EGJJ", "None", "03895", "49.13N", "002.12W", "84", "GB"],
    ["SHOREHAM-BY-SEA", "EGKA", "None", "03876", "50.50N", "000.18W", "2", "GB"],
    ["BIGGIN HILL", "EGKB", "None", "None", "51.19N", "000.01E", "183", "GB"],
    ["LONDON/GATWICK A", "EGKK", "None", "03776", "51.08N", "000.10W", "62", "GB"],
    ["WEST MALLING", "EGKM", "None", "None", "51.16N", "000.25E", "104", "GB"],
    ["LONDON CITY AIRP", "EGLC", "None", "None", "51.30N", "000.03E", "5", "GB"],
    ["FARNBOROUGH", "EGLF", "None", "03768", "51.17N", "000.46W", "65", "GB"],
    ["LONDON/HEATHROW", "EGLL", "None", "03772", "51.29N", "000.27W", "24", "GB"],
    ["SOUTHEND-ON-SEA", "EGMC", "None", "None", "51.34N", "000.42E", "15", "GB"],
    ["LYDD AIRPORT", "EGMD", "None", "None", "50.57N", "000.55E", "3", "GB"],
    ["MANSTON SOUTHEAS", "EGMH", "None", "None", "51.21N", "001.20E", "55", "GB"],
    ["CARLISLE", "EGNC", "None", "03222", "54.56N", "002.49W", "26", "GB"],
    ["BLACKPOOL AIRPOR", "EGNH", "None", "03318", "53.46N", "003.01W", "10", "GB"],
    ["HUMBERSIDE", "EGNJ", "None", "None", "53.34N", "000.21W", "31", "GB"],
    ["WALNEY ISL/BARRO", "EGNL", "None", "03214", "54.07N", "003.15W", "15", "GB"],
    ["LEEDS AND BRADFO", "EGNM", "None", "None", "53.52N", "001.38W", "208", "GB"],
    ["WHARTON", "EGNO", "None", "None", "53.45N", "002.53W", "17", "GB"],
    ["HAWARDEN (AUT)", "EGNR", "None", "03321", "53.10N", "002.58W", "10", "GB"],
    ["ISLE OF MAN/RONA", "EGNS", "None", "03204", "54.05N", "004.38W", "17", "GB"],
    ["NEWCASTLE", "EGNT", "None", "None", "55.01N", "001.42W", "81", "GB"],
    ["TEES-SIDE", "EGNV", "None", "None", "54.31N", "001.25W", "37", "GB"],
    ["EAST MIDLANDS", "EGNX", "None", "None", "52.49N", "001.19W", "94", "GB"],
    ["LLANBEDR", "EGOD", "None", "None", "52.48N", "004.07W", "9", "GB"],
    ["TERNHILL RAF", "EGOE", "None", "None", "52.52N", "002.31W", "83", "GB"],
    ["SPADEADAM", "EGOM", "None", "03165", "55.03N", "002.33W", "325", "GB"],
    ["PEMBRY SANDS", "EGOP", "None", "03605", "51.43N", "004.19W", "6", "GB"],
    ["SHAWBURY RAF", "EGOS", "None", "03414", "52.48N", "002.40W", "76", "GB"],
    ["VALLEY RAF", "EGOV", "None", "03302", "53.15N", "004.32W", "11", "GB"],
    ["WOODVALE RAF", "EGOW", "None", "None", "53.35N", "003.03W", "12", "GB"],
    ["WEST FREUGH (AUT", "EGOY", "None", "03132", "54.51N", "004.57W", "12", "GB"],
    ["KIRKWALL AIRPORT", "EGPA", "None", "03017", "58.57N", "002.53W", "21", "GB"],
    ["TAIN RANGE (SAWS", "EGQA", "None", "03062", "57.50N", "003.57W", "4", "GB"],
    ["SUMBURGH (CAPE)", "EGPB", "None", "03003", "59.52N", "001.18W", "5", "GB"],
    ["WICK", "EGPC", "None", "03075", "58.27N", "003.04W", "39", "GB"],
    ["ABERDEEN/DYCE", "EGPD", "None", "03091", "57.12N", "002.13W", "65", "GB"],
    ["INVERNESS/DALCRO", "EGPE", "None", "03059", "57.31N", "004.02W", "9", "GB"],
    ["GLASGOW AIRPORT", "EGPF", "None", "03140", "55.52N", "004.25W", "8", "GB"],
    ["EDINBURGH AIRPOR", "EGPH", "None", "03160", "55.57N", "003.21W", "41", "GB"],
    ["ISLAY/PORT ELLEN", "EGPI", "None", "None", "55.41N", "006.15W", "18", "GB"],
    ["PRESTWICK(CIV/NA", "EGPK", "None", "03135", "55.30N", "004.34W", "20", "GB"],
    ["BENBECULA ISLAND", "EGPL", "None", "03022", "57.28N", "007.22W", "6", "GB"],
    ["SCATSA/SHETLAND", "EGPM", "None", "None", "60.25N", "001.18W", "22", "GB"],
    ["DUNDEE/RIVERSIDE", "EGPN", "None", "None", "56.27N", "003.01W", "4", "GB"],
    ["STORNOWAY", "EGPO", "None", "03026", "58.13N", "006.19W", "13", "GB"],
    ["PERTH/SCONE", "EGPT", "None", "None", "56.27N", "003.22W", "121", "GB"],
    ["TIREE ISLAND", "EGPU", "None", "03100", "56.30N", "006.52W", "12", "GB"],
    ["UNST ISLAND", "EGPW", "None", "None", "60.45N", "000.51W", "285", "GB"],
    ["MACHRIHANISH RAF", "EGQJ", "None", "03111", "55.25N", "005.42W", "13", "GB"],
    ["KINLOSS RAF", "EGQK", "None", "03066", "57.39N", "003.34W", "7", "GB"],
    ["LEUCHARS RAF", "EGQL", "None", "03171", "56.23N", "002.52W", "12", "GB"],
    ["BOULMER", "EGQM", "None", "03240", "55.25N", "001.36W", "23", "GB"],
    ["LOSSIEMOUTH RAF", "EGQS", "None", "03068", "57.43N", "003.19W", "13", "GB"],
    ["LONDON WEA CENTE", "EGRB", "None", "03779", "51.30N", "000.07W", "39", "GB"],
    ["UK MET EXETER", "EGRR", "None", "03763", "50.44N", "003.29W", "27", "GB"],
    ["CAMBRIDGE", "EGSC", "None", "None", "52.12N", "000.10E", "15", "GB"],
    ["GREAT YARMOUTH", "EGSD", "None", "None", "52.38N", "001.43E", "2", "GB"],
    ["NORWICH WEA CNTR", "EGSH", "None", "03492", "52.41N", "001.17E", "36", "GB"],
    ["STANSTED AIRPORT", "EGSS", "None", "03683", "51.53N", "000.13E", "106", "GB"],
    ["YORKSHIRE/HUMBER", "EGSY", "None", "None", "53.24N", "001.23W", "70", "GB"],
    ["CRANFIELD", "EGTC", "None", "None", "52.04N", "000.37W", "111", "GB"],
    ["EXETER AIRPORT", "EGTE", "None", "03839", "50.43N", "003.25W", "30", "GB"],
    ["FILTON (PRIVATE)", "EGTG", "None", "None", "51.31N", "002.34W", "69", "GB"],
    ["HATFIELD", "EGTH", "None", "None", "51.46N", "000.15W", "77", "GB"],
    ["OXFORD", "EGTK", "None", "None", "51.50N", "001.19W", "82", "GB"],
    ["BENSON RAF", "EGUB", "None", "03658", "51.37N", "001.04W", "63", "GB"],
    ["ABERPORTH", "EGUC", "None", "03502", "52.07N", "004.34W", "134", "GB"],
    ["FARNBOROUGH (MIL", "EGUF", "None", "03766", "51.16N", "000.46W", "72", "GB"],
    ["HIGH WYCOMBE RAF", "EGUH", "None", "None", "51.37N", "000.46W", "75", "GB"],
    ["LAKENHEATH RAF", "EGUL", "None", "03583", "52.25N", "000.34E", "10", "GB"],
    ["MANSTON RAF", "EGUM", "None", "03797", "51.21N", "001.20E", "55", "GB"],
    ["MILDENHALL RAF", "EGUN", "None", "03577", "52.22N", "000.28E", "10", "GB"],
    ["COLERNE RAF", "EGUO", "None", "None", "51.26N", "002.17W", "13", "GB"],
    ["LEE-ON-SOLENT(NA", "EGUS", "None", "03867", "50.49N", "001.13W", "10", "GB"],
    ["WATTISHAM RAF", "EGUW", "None", "03590", "52.07N", "000.58E", "87", "GB"],
    ["WYTON RAF", "EGUY", "None", "03566", "52.21N", "000.07W", "41", "GB"],
    ["FAIRFORD RAF", "EGVA", "None", "03644", "51.40N", "001.46W", "87", "GB"],
    ["WOODBRIDGE RAF", "EGVG", "None", "None", "52.04N", "001.23E", "29", "GB"],
    ["GREENHAM COMMON", "EGVI", "None", "None", "51.22N", "001.16W", "122", "GB"],
    ["BRIZE NORTON RAF", "EGVN", "None", "03649", "51.46N", "001.35W", "88", "GB"],
    ["ODIHAM RAF", "EGVO", "None", "03761", "51.14N", "000.57W", "123", "GB"],
    ["MIDDLE WALLOP", "EGVP", "None", "03749", "51.08N", "001.34W", "91", "GB"],
    ["WETHERSFIELD RAF", "EGVT", "None", "None", "51.58N", "000.30E", "98", "GB"],
    ["COSFORD RAF", "EGWC", "None", "None", "52.37N", "002.17W", "83", "GB"],
    ["HENLOW", "EGWE", "None", "None", "52.01N", "000.16W", "95", "GB"],
    ["NORTHOLT RAF", "EGWU", "None", "03672", "51.33N", "000.25W", "40", "GB"],
    ["ALCONBURY RAF", "EGWZ", "None", "03562", "52.22N", "000.13W", "49", "GB"],
    ["CONINGSBY RAF", "EGXC", "None", "03391", "53.06N", "000.10W", "7", "GB"],
    ["DISHFORTH RAF", "EGXD", "None", "03261", "54.08N", "001.25W", "35", "GB"],
    ["LEEMING RAF", "EGXE", "None", "03257", "54.17N", "001.31W", "40", "GB"],
    ["CHURCH FENTON RA", "EGXG", "None", "03355", "53.50N", "001.12W", "9", "GB"],
    ["HONINGTON RAF", "EGXH", "None", "03586", "52.19N", "000.46E", "54", "GB"],
    ["COTTESMORE RAF", "EGXJ", "None", "03453", "52.44N", "000.39W", "138", "GB"],
    ["NEWTON", "EGXN", "None", "None", "52.58N", "000.58W", "55", "GB"],
    ["SCAMPTON RAF", "EGXP", "None", "03373", "53.18N", "000.33W", "61", "GB"],
    ["DONNA NOOK RAF", "EGXS", "None", "None", "53.29N", "000.09E", "3", "GB"],
    ["WITTERING RAF", "EGXT", "None", "03462", "52.37N", "000.28W", "84", "GB"],
    ["LINTON-ON-OUSE R", "EGXU", "None", "03266", "54.03N", "001.15W", "16", "GB"],
    ["LECONFIELD (AUT)", "EGXV", "None", "03384", "53.52N", "000.27W", "6", "GB"],
    ["WADDINGTON RAF", "EGXW", "None", "03377", "53.11N", "000.31W", "70", "GB"],
    ["TOPCLIFFE RAF", "EGXZ", "None", "None", "54.12N", "001.23W", "28", "GB"],
    ["CRANWELL RAF", "EGYD", "None", "03379", "53.02N", "000.30W", "67", "GB"],
    ["BARKSTON HEATH R", "EGYE", "None", "None", "52.58N", "000.34W", "112", "GB"],
    ["HOLBEACH (AUT)", "EGYH", "None", "03469", "52.52N", "000.09E", "3", "GB"],
    ["MARHAM RAF", "EGYM", "None", "03482", "52.38N", "000.34E", "23", "GB"],
    ["WATTON RAF RADAR", "EGYR", "None", "None", "52.34N", "000.51E", "59", "GB"],
    ["WAINFLEET (AUT)", "EGYW", "None", "03392", "53.05N", "000.16E", "5", "GB"],
    ["CASTOR BAY", "None", "None", "03918", "54.18N", "006.11W", "15", "GB"],
    ["MUCKLE FLUGGA", "None", "None", "03001", "60.51N", "000.53W", "53", "GB"],
    ["LERWICK/SHETLAND", "None", "None", "03005", "60.08N", "001.11W", "82", "GB"],
    ["ALBERMARLE", "None", "None", "03238", "55.06N", "001.56W", "146", "GB"],
    ["NOTTINGHAM", "None", "None", "03354", "53.00N", "001.15W", "117", "GB"],
    ["CAMBORNE", "None", "None", "03808", "50.13N", "005.19W", "87", "GB"],
    ["HERSTOMONCEUX W", "None", "None", "03882", "50.54N", "000.19E", "54", "GB"],
    ["HILLSBOROUGH", "None", "None", "03920", "54.29N", "006.06W", "38", "GB"],
    ["SAINT MAWGAN RAF", "EGDG", "None", "03817", "50.26N", "005.00W", "119", "GB"],
    ["KEMBLE RAF", "EGDK", "None", "None", "51.40N", "002.02W", "133", "GB"],
    ["SANDOWN/WIGHT IS", "EGHN", "None", "None", "50.38N", "001.08W", "18", "GB"],
    ["BALLYKELLY", "EGQB", "None", "None", "55.04N", "007.01W", "2", "GB"],
    ["LEAVESDEN", "EGTI", "None", "None", "51.40N", "000.25W", "102", "GB"],
    ["UPPER HEYFORD RA", "EGUA", "None", "None", "51.55N", "001.15W", "134", "GB"],
    ["ABINGDON RAF", "EGUD", "None", "None", "51.40N", "001.19W", "80", "GB"],
    ["SCULTHORPE (AF M", "EGUP", "None", "None", "52.51N", "000.46E", "65", "GB"],
    ["BENTWATERS RAF", "EGVJ", "None", "None", "52.07N", "001.25E", "26", "GB"],
    ["BINBROOK RAF", "EGXB", "None", "03388", "53.27N", "000.12W", "108", "GB"],
    ["COWDEN", "EGXF", "None", "None", "53.51N", "006.05W", "15", "GB"],
    ["FINNINGLEY RAF", "EGXI", "None", "03360", "53.28N", "001.00W", "17", "GB"],
    ["DONNA NOOK NO.2", "EGXX", "None", "03385", "53.29N", "000.05E", "11", "GB"],
    ["COLTISHALL RAF", "EGYC", "None", "03495", "52.46N", "001.21E", "20", "GB"],
    ["AMSTERDAM/SCHIPH", "EHAM", "None", "06240", "52.19N", "004.47E", "9", "NL"],
    ["ZUID-LIMBURG/BEE", "EHBK", "None", "06380", "50.55N", "005.46E", "116", "NL"],
    ["DE BILT", "EHDB", "None", "06260", "52.06N", "005.10E", "4", "NL"],
    ["DEELEN RNLAFB", "EHDL", "None", "06275", "52.04N", "005.52E", "52", "NL"],
    ["EINDHOVEN RNLAFB", "EHEH", "None", "06370", "51.27N", "005.23E", "22", "NL"],
    ["GRONINGEN/EELDE", "EHGG", "None", "06280", "53.07N", "006.34E", "4", "NL"],
    ["GILZE-RIJEN RNLA", "EHGR", "None", "06350", "51.34N", "004.55E", "13", "NL"],
    ["DE KOOY (NAVY)", "EHKD", "None", "06235", "52.55N", "004.46E", "14", "NL"],
    ["LELYSTAD", "EHLE", "LEY", "06269", "52.27N", "005.31E", "-6", "NL"],
    ["LEEUWARDEN RNLAF", "EHLW", "None", "06270", "53.13N", "005.45E", "2", "NL"],
    ["ROTTERDAM AIRPOR", "EHRD", "None", "06344", "51.57N", "004.27E", "-5", "NL"],
    ["SOESTERBERG RNLA", "EHSB", "None", "06265", "52.07N", "005.16E", "13", "NL"],
    ["TWENTE RNLAFB", "EHTW", "None", "06290", "52.16N", "006.54E", "36", "NL"],
    ["TEXEL ISLAND", "EHTX", "None", "None", "53.04N", "004.45E", "3", "NL"],
    ["VALKENBURG (NAVY", "EHVB", "None", "06210", "52.10N", "004.25E", "2", "NL"],
    ["VOLKEL RNLAFB", "EHVK", "None", "06375", "51.38N", "005.42E", "21", "NL"],
    ["VLIELAND ISLAND", "EHVL", "None", "06242", "53.14N", "004.55E", "5", "NL"],
    ["WOENSDRECHT RNLA", "EHWO", "None", "06340", "51.27N", "004.19E", "17", "NL"],
    ["YPENBURG RNLAFB", "EHYB", "None", "06200", "52.01N", "004.20E", "1", "NL"],
    ["A12-CPP SEA", "EHAK", "None", "06205", "55.25N", "003.49E", "50", "NL"],
    ["D15-FA-1 SEA", "EHDV", "None", "06201", "54.19N", "002.56E", "50", "NL"],
    ["F3-FB-1SEA", "EHFD", "None", "06239", "54.51N", "004.42E", "50", "NL"],
    ["VLISSINGEN", "EHFS", "None", "None", "51.27N", "003.36E", "32", "NL"],
    ["F16-ASEA", "EHFZ", "None", "06206", "54.07N", "004.01E", "50", "NL"],
    ["J6-ASEA", "EHJA", "None", "06211", "53.49N", "002.57E", "50", "NL"],
    ["K13-ASEA", "EHJR", "None", "06252", "53.13N", "003.13E", "50", "NL"],
    ["K14-FA-1C SEA", "EHKV", "None", "06204", "53.16N", "003.38E", "50", "NL"],
    ["AWG-1SEA", "EHMA", "None", "06208", "53.30N", "005.57E", "50", "NL"],
    ["L9-FF-1SEA", "EHMG", "None", "06207", "53.37N", "004.58E", "50", "NL"],
    ["P11-BSEA", "EHPG", "None", "06203", "52.22N", "003.21E", "50", "NL"],
    ["HOORN-ASEA", "EHQE", "None", "06212", "52.55N", "004.09E", "50", "NL"],
    ["EURO PLATFORM", "EHSA", "None", "06321", "52.00N", "003.17E", "50", "NL"],
    ["GOEREE LESEA", "EHSC", "None", "06320", "51.56N", "003.40E", "50", "NL"],
    ["CORK ARPT/CORCAI", "EICK", "None", "03955", "51.51N", "008.28W", "162", "IE"],
    ["GALWAY", "EICM", "GWY", "None", "53.18N", "008.56W", "25", "IE"],
    ["DONEGAL ARPT", "EIDL", "CFN", "None", "55.03N", "008.20W", "9", "IE"],
    ["DUBLIN AIRPORT", "EIDW", "None", "03969", "53.25N", "006.15W", "85", "IE"],
    ["CONNAUGHT APT", "EIKN", "None", "03973", "53.55N", "008.49W", "64", "IE"],
    ["KERRY ARPT", "EIKY", "KIR", "None", "52.11N", "009.31W", "34", "IE"],
    ["CASEMENT (MIL)", "EIME", "None", "03967", "53.18N", "006.27W", "93", "IE"],
    ["SHANNON AIRPORT", "EINN", "None", "03962", "52.42N", "008.55W", "20", "IE"],
    ["SLIGO ARPT", "EISG", "SXL", "None", "54.17N", "008.36W", "3", "IE"],
    ["WATERFORD ARPT", "EIWF", "None", "None", "52.11N", "007.05W", "36", "IE"],
    ["VALENTIA OBSERV", "None", "None", "03953", "51.56N", "010.15W", "9", "IE"],
    ["TIRSTRUP (CIV/MI", "EKAH", "None", "06070", "56.17N", "010.37E", "25", "DK"],
    ["ANHOLT ISLAND (A", "EKAT", "None", "06078", "56.42N", "011.33E", "8", "DK"],
    ["AVNO (DAN-AFB)", "EKAV", "None", "06150", "55.04N", "011.46E", "4", "DK"],
    ["BILLUND AIRPORT", "EKBI", "None", "06104", "55.43N", "009.09E", "66", "DK"],
    ["COPENHAGEN/KASTR", "EKCH", "None", "06180", "55.37N", "012.40E", "5", "DK"],
    ["ESBJERG", "EKEB", "None", "06080", "55.31N", "008.33E", "29", "DK"],
    ["GORM(OIL)", "EKGC", "None", "None", "55.35N", "004.46E", "0", "DN"],
    ["TYRA OEST", "EKGF", "None", "06022", "55.43N", "004.48E", "43", "DK"],
    ["HALFDAN(OIL)", "EKHA", "None", "None", "55.32N", "005.00E", "0", "DN"],
    ["HARALD(OIL)", "EKHD", "None", "None", "56.20N", "004.16E", "0", "DN"],
    ["HORNS REV B HELI", "EKHN", "None", "None", "55.36N", "007.37E", "50", "DK"],
    ["LINDTORP AIRPORT", "EKHO", "None", "06054", "56.23N", "008.26E", "15", "DK"],
    ["HORNS REV B HELI", "EKHR", "None", "None", "55.31N", "007.53E", "50", "DK"],
    ["HADSUND", "EKHS", "None", "06048", "56.45N", "010.14E", "2", "DK"],
    ["KARUP (DAN-AFB)", "EKKA", "None", "06060", "56.18N", "009.07E", "52", "DK"],
    ["ARHUS/KIRSTINESM", "EKKM", "None", "None", "56.08N", "010.13E", "57", "DK"],
    ["MARIBO ARPT (AUT", "EKMB", "None", "06143", "54.42N", "011.26E", "5", "DK"],
    ["ODENSE/BELDRINGE", "EKOD", "None", "06120", "55.28N", "010.19E", "17", "DK"],
    ["COPENHAGEN/ROSKI", "EKRK", "None", "06170", "55.34N", "012.07E", "44", "DK"],
    ["RONNE", "EKRN", "None", "06190", "55.04N", "014.45E", "16", "DK"],
    ["SONDERBORG AIRPO", "EKSB", "None", "06118", "54.58N", "009.48E", "23", "DK"],
    ["SINDAL AIRPORT", "EKSN", "None", "06034", "57.30N", "010.13E", "28", "DK"],
    ["SKRYDSTRUP(DAN-A", "EKSP", "None", "06110", "55.13N", "009.16E", "40", "DK"],
    ["SYDFYNS/TASINGE", "EKST", "None", "06124", "55.01N", "010.34E", "6", "DK"],
    ["SKIVE AIRPORT", "EKSV", "None", "06062", "56.32N", "009.10E", "21", "DK"],
    ["TYRA(OIL)", "EKTE", "None", "None", "55.43N", "004.48E", "0", "DN"],
    ["THISTED ARPT (AU", "EKTS", "None", "06024", "57.04N", "008.41E", "7", "DK"],
    ["VANDEL (DAN-AFB)", "EKVA", "None", "06100", "55.43N", "009.13E", "74", "DK"],
    ["VAMDRUP (AUT/MAN", "EKVD", "None", "06108", "55.25N", "009.19E", "45", "DK"],
    ["SORVAAG/VAGAR", "EKVG", "None", "06010", "62.04N", "007.18W", "85", "DK"],
    ["STAUNING AIRPORT", "EKVJ", "None", "06066", "55.58N", "008.20E", "5", "DK"],
    ["VAERLOSE (DAN-AF", "EKVL", "None", "06160", "55.46N", "012.19E", "31", "DK"],
    ["ALBORG", "EKYT", "None", "06030", "57.06N", "009.52E", "3", "DK"],
    ["THORSHAVN (PORT)", "None", "None", "06011", "62.01N", "006.46W", "55", "DK"],
    ["KOEBENHAVN/JAEG", "None", "None", "06181", "55.46N", "012.32E", "50", "DK"],
    ["LUXEMBOURG (AUT)", "ELLX", "None", "06590", "49.38N", "006.12E", "379", "LU"],
    ["ALESUND/VIGRA", "ENAL", "None", "01210", "62.34N", "006.07E", "22", "NO"],
    ["ANDOYA/ANDENES(A", "ENAN", "None", "01010", "69.17N", "016.08E", "14", "NO"],
    ["NY-ALESUND II", "ENAS", "None", "01004", "78.55N", "011.55E", "8", "NO"],
    ["ALTA AIRPORT", "ENAT", "None", "01049", "69.58N", "023.22E", "3", "NO"],
    ["BJORNOYA ISLAND", "ENBJ", "None", "01028", "74.31N", "019.01E", "14", "NO"],
    ["FORDE/BRINGELAND", "ENBL", "None", "None", "61.24N", "005.46E", "150", "NO"],
    ["VOSS/BOMOEN", "ENBM", "None", "01336", "60.38N", "006.30E", "122", "NO"],
    ["BRONNOYSUND/BRON", "ENBN", "None", "01112", "65.28N", "012.13E", "9", "NO"],
    ["BODO VI (CIV/MIL", "ENBO", "None", "01152", "67.16N", "014.22E", "13", "NO"],
    ["BERGEN/FLESLAND", "ENBR", "None", "01311", "60.17N", "005.13E", "50", "NO"],
    ["BATSFJORD", "ENBS", "None", "None", "70.37N", "029.43E", "10", "NO"],
    ["BERLEVAG", "ENBV", "None", "01083", "70.52N", "029.01E", "13", "NO"],
    ["KRISTIANSAND/KJE", "ENCN", "None", "01452", "58.12N", "008.04E", "17", "NO"],
    ["DRAUGEN", "ENDR", "None", "None", "64.21N", "007.48E", "50", "NO"],
    ["BARDUFOSS (CIV/M", "ENDU", "None", "01023", "69.02N", "018.33E", "79", "NO"],
    ["EKOFISK OIL PLTF", "ENEK", "None", "01400", "56.32N", "003.15E", "3", "NO"],
    ["EVENES (CIV/MIL)", "ENEV", "None", "01183", "68.31N", "016.40E", "26", "NO"],
    ["STATFJORD B OILP", "ENFB", "None", "None", "61.12N", "001.50E", "10", "NO"],
    ["FAGERNES/LEIRIN", "ENFG", "None", "01368", "61.00N", "009.18E", "822", "NO"],
    ["FLORO", "ENFL", "None", "01310", "61.34N", "005.01E", "9", "NO"],
    ["FRIGG", "ENFR", "None", "None", "59.55N", "002.00E", "0", "NO"],
    ["GULLFAX (PLATFOR", "ENGC", "None", "None", "61.01N", "002.01E", "10", "NO"],
    ["OSLO/GARDERMOEN", "ENGM", "None", "01384", "60.12N", "011.06E", "204", "NO"],
    ["HAUGESUND/KARMOY", "ENHD", "None", "01408", "59.21N", "005.13E", "24", "NO"],
    ["HEIDRUN", "ENHE", "None", "None", "65.20N", "002.20E", "1", "NO"],
    ["HAMMERFEST", "ENHF", "None", "01052", "70.40N", "023.40E", "81", "NO"],
    ["HASVIK", "ENHK", "None", "None", "70.28N", "022.08E", "10", "NO"],
    ["HEIMDAL OILP", "ENHM", "None", "None", "59.34N", "002.14E", "10", "NO"],
    ["HOPEN ISLAND", "ENHO", "None", "01062", "76.30N", "025.04E", "10", "NO"],
    ["HONNINGSVAG/VALA", "ENHV", "None", "01068", "71.01N", "025.58E", "14", "NO"],
    ["JAN MAYEN(NOR-NA", "ENJA", "None", "01001", "70.55N", "008.40W", "9", "NO"],
    ["KAUTOKEINO II", "ENKA", "None", "01047", "69.01N", "023.04E", "330", "NO"],
    ["KRISTIANSUND/KVE", "ENKB", "None", "01223", "63.07N", "007.49E", "62", "NO"],
    ["KIRKENES (CIV/MI", "ENKR", "None", "01089", "69.43N", "029.53E", "91", "NO"],
    ["ULA PLATFORM (OI", "ENLA", "None", "None", "59.06N", "002.50E", "4", "NO"],
    ["LISTA/FARSUND (A", "ENLI", "None", "01428", "58.06N", "006.37E", "10", "NO"],
    ["LEKNES", "ENLK", "None", "01141", "68.09N", "013.37E", "26", "NO"],
    ["MEHAMN", "ENMH", "None", "01074", "71.01N", "027.49E", "13", "NO"],
    ["MOLDE/ARO", "ENML", "None", "01217", "62.45N", "007.16E", "3", "NO"],
    ["MOSJOEN/KJAERSTA", "ENMS", "None", "01122", "65.47N", "013.13E", "70", "NO"],
    ["BANAK/LAKSELV (A", "ENNA", "None", "01059", "70.04N", "024.58E", "8", "NO"],
    ["NORNE FPSO OILP", "ENNE", "None", "None", "66.02N", "008.05E", "10", "NO"],
    ["NARVIK III/FRAMN", "ENNK", "None", "01194", "68.28N", "017.23E", "23", "NO"],
    ["NAMSOS AIRPORT", "ENNM", "None", "01290", "64.28N", "011.34E", "2", "NO"],
    ["NOTODDEN", "ENNO", "None", "None", "59.34N", "009.13E", "19", "NO"],
    ["OSEBERG", "ENOA", "None", "None", "60.30N", "002.50E", "5", "NO"],
    ["ORLAND III(NOR-A", "ENOL", "None", "01241", "63.42N", "009.35E", "7", "NO"],
    ["ORSTA-VOLDA/HOVD", "ENOV", "None", "01209", "62.10N", "006.04E", "74", "NO"],
    ["TROLL-A HELI", "ENQA", "None", "None", "60.39N", "003.43E", "20", "NO"],
    ["TROLL-C HELI", "ENQC", "None", "None", "60.53N", "003.37E", "20", "NO"],
    ["SNORRE B OILP", "ENQR", "None", "None", "61.21N", "002.13E", "10", "NO"],
    ["MOIRANA", "ENRA", "None", "01151", "66.22N", "014.18E", "70", "NO"],
    ["RORVIK/RYUM", "ENRM", "None", "01282", "64.50N", "011.08E", "14", "NO"],
    ["ROROS AIRPORT", "ENRO", "None", "01289", "62.34N", "011.20E", "626", "NO"],
    ["ROST (NOR-AFB)", "ENRS", "None", "01107", "67.31N", "012.05E", "4", "NO"],
    ["RYGGE (NOR-AFB)", "ENRY", "None", "01494", "59.22N", "010.46E", "53", "NO"],
    ["SVALBARD/LONGYEA", "ENSB", "None", "01008", "78.15N", "015.28E", "29", "NO"],
    ["SANDANE/ANDA", "ENSD", "None", "01320", "61.49N", "006.07E", "60", "NO"],
    ["SNORRE A OILP", "ENSE", "None", "None", "61.27N", "002.09E", "10", "NO"],
    ["STATFJORD A OILP", "ENSF", "None", "None", "61.15N", "001.51E", "10", "NO"],
    ["SOGNDAL/HAUKASEN", "ENSG", "None", "01347", "61.08N", "007.07E", "497", "NO"],
    ["SVOLVAER/HELLE", "ENSH", "None", "01161", "68.15N", "014.40E", "9", "NO"],
    ["STORKMARKNES/SKA", "ENSK", "None", "01162", "68.34N", "015.01E", "3", "NO"],
    ["SLEIPNER A PLATF", "ENSL", "None", "None", "58.22N", "001.54E", "50", "NO"],
    ["SKIEN/GEITERYGGE", "ENSN", "None", "01475", "59.10N", "009.34E", "14", "NO"],
    ["STORD/SOERSTOKKE", "ENSO", "None", "None", "59.47N", "005.20E", "49", "NO"],
    ["SORKJOSEN", "ENSR", "None", "01046", "69.46N", "020.58E", "6", "NO"],
    ["SVARTNES", "ENSS", "None", "01097", "70.20N", "031.03E", "12", "NO"],
    ["SANDNESSJOEN/STO", "ENST", "None", "01116", "65.58N", "012.28E", "17", "NO"],
    ["TROMSO/LANGNES", "ENTC", "None", "01025", "69.41N", "018.55E", "10", "NO"],
    ["TORP (CIV/NOR-AF", "ENTO", "None", "01483", "59.12N", "010.16E", "88", "NO"],
    ["TRONDHEIM/VAERNE", "ENVA", "None", "01271", "63.28N", "010.55E", "17", "NO"],
    ["VADSO", "ENVD", "None", "01088", "70.04N", "029.51E", "39", "NO"],
    ["VALHALL (OIL)", "ENVH", "None", "None", "56.16N", "003.23E", "4", "NO"],
    ["STAVANGER/SOLA(A", "ENZV", "None", "01415", "58.52N", "005.37E", "9", "NO"],
    ["DAGALI", "ENDI", "None", "None", "60.25N", "008.31E", "798", "NO"],
    ["OSLO ENFB/01488", "None", "None", "None", "59.53N", "010.37E", "17", "NO"],
    ["HAKADAL/OSLO", "None", "None", "01488", "60.07N", "010.50E", "170", "NO"],
    ["WARSZAWA/BABICE", "EPBC", "None", "None", "52.16N", "020.55E", "107", "PL"],
    ["BYDGOSZDZ", "EPBY", "None", "None", "53.06N", "018.00E", "71", "PL"],
    ["CEWICE AIRBASE", "EPCE", "None", "None", "54.25N", "017.46E", "151", "PL"],
    ["DARTOWEK NAVAL", "EPDA", "None", "None", "54.24N", "016.21E", "4", "PL"],
    ["DEBLIN-IRENA", "EPDE", "None", "None", "51.33N", "021.54E", "120", "PL"],
    ["GDANSK/REBIECHOW", "EPGD", "None", "12150", "54.22N", "018.28E", "138", "PL"],
    ["INOWROCLAW INOWR", "EPIR", "None", "None", "52.50N", "018.20E", "79", "PL"],
    ["JEZOW SUDECKI", "EPJS", "None", "None", "50.56N", "015.46E", "559", "PL"],
    ["KRAKOW/BALICE", "EPKK", "None", "12566", "50.04N", "019.48E", "237", "PL"],
    ["KOSZALIN", "EPKO", "None", "12105", "54.12N", "016.09E", "34", "PL"],
    ["KATOWICE/MUCHOWI", "EPKM", "None", "None", "50.14N", "019.02E", "284", "PL"],
    ["KRZESINY ARPT", "EPKS", "None", "None", "52.20N", "016.58E", "81", "PL"],
    ["KATOWICE/PYRZOWI", "EPKT", "None", "12560", "50.28N", "019.05E", "284", "PL"],
    ["LUBLIN", "EPLB", "None", "None", "51.14N", "022.43E", "206", "PL"],
    ["LASK ARPT", "EPLK", "None", "None", "51.33N", "019.11E", "193", "PL"],
    ["LODZ/LUBLINEK", "EPLL", "None", "None", "51.43N", "019.24E", "184", "PL"],
    ["LECZYCA-LEZNICA", "EPLY", "None", "None", "52.00N", "019.09E", "115", "PL"],
    ["MALBORK", "EPMB", "None", "None", "54.02N", "019.08E", "5", "PL"],
    ["TWELTH AIRBASE", "EPMI", "None", "None", "53.24N", "016.05E", "140", "PL"],
    ["MINSK MAZOWIECKI", "EPMM", "None", "None", "52.12N", "021.39E", "185", "PL"],
    ["MODLIN", "EPMO", "None", "None", "52.27N", "020.39E", "104", "PL"],
    ["GDYNIA-BABIE DO", "EPOK", "None", "None", "54.35N", "018.31E", "44", "PL"],
    ["POZNAN/LAWICA", "EPPO", "None", "12330", "52.25N", "016.49E", "92", "PL"],
    ["PRUSZCZ GDANSKI", "EPPR", "None", "None", "54.15N", "018.40E", "7", "PL"],
    ["POWIDZ AIRPORT", "EPPW", "None", "None", "52.23N", "017.51E", "113", "PL"],
    ["RADOM AIRPORT", "EPRA", "None", "None", "51.23N", "021.13E", "178", "PL"],
    ["RZESZOW/JASIONKA", "EPRZ", "None", "12580", "50.06N", "022.03E", "202", "PL"],
    ["SZCZECIN/GOLENIO", "EPSC", "None", "12205", "53.35N", "014.54E", "3", "PL"],
    ["SLUPSK", "EPSK", "None", "None", "54.28N", "017.01E", "25", "PL"],
    ["SWIDWIN ARPT", "EPSN", "None", "None", "53.47N", "015.50E", "118", "PL"],
    ["SZYMANY", "EPSY", "None", "None", "53.28N", "020.56E", "141", "PL"],
    ["SPAA GLINNIK", "EPTM", "None", "None", "51.35N", "020.06E", "174", "PL"],
    ["WARSAW/OKECIE", "EPWA", "None", "12375", "52.10N", "020.58E", "107", "PL"],
    ["WROCLAW/STRACHOW", "EPWR", "None", "12424", "51.06N", "016.52E", "121", "PL"],
    ["ZIELONA GORA", "EPZG", "None", "12400", "52.08N", "015.48E", "59", "PL"],
    ["LEBA", "None", "None", "12120", "54.45N", "017.32E", "2", "PL"],
    ["LEGIONOWO", "None", "None", "12374", "52.24N", "020.58E", "94", "PL"],
    ["WROCLAW/MALY GAD", "None", "None", "12425", "51.08N", "016.59E", "116", "PL"],
    ["LINKOPING/MALMEN", "ESCF", "None", "02562", "58.23N", "015.31E", "117", "SE"],
    ["SODERHAMN (SWE-A", "ESNY", "None", "02376", "61.16N", "017.06E", "36", "SE"],
    ["UPPSALA (SWE-AFB", "ESCM", "None", "02458", "59.52N", "017.36E", "41", "SE"],
    ["LJUNGBYHED(SWE-A", "ESDA", "None", "02630", "56.04N", "013.13E", "52", "SE"],
    ["ANGELHOLM (SWE-A", "ESTA", "None", "02607", "56.17N", "012.50E", "47", "SE"],
    ["RONNEBY (SWE-AFB", "ESDF", "None", "02664", "56.16N", "015.16E", "74", "SE"],
    ["VAXJO/URASA (AFB", "ESFU", "None", "02640", "56.52N", "014.48E", "166", "SE"],
    ["GOTEBORG/LANDVET", "ESGG", "None", "02527", "57.40N", "012.18E", "169", "SE"],
    ["GOTEBORG/LANDVET", "None", "None", "02526", "57.40N", "012.18E", "169", "SE"],
    ["JONKOPING AIRPOR", "ESGJ", "None", "02550", "57.46N", "014.04E", "232", "SE"],
    ["LIDKOPING", "ESGL", "None", "None", "58.28N", "013.10E", "61", "SE"],
    ["GOTEBORG/SAVE (A", "ESGP", "None", "02512", "57.46N", "011.52E", "53", "SE"],
    ["SKOVDE AIRPORT", "ESGR", "None", "02535", "58.27N", "013.58E", "105", "SE"],
    ["TROLLHATTAN (PVT", "ESGT", "None", "None", "58.19N", "012.20E", "41", "SE"],
    ["SATENAS (SWE-AFB", "ESIB", "None", "02520", "58.25N", "012.41E", "74", "SE"],
    ["SKAVSTA/STOCKHO", "ESKN", "None", "None", "58.47N", "016.54E", "43", "SE"],
    ["KRISTIANSTAD/EVE", "ESMK", "None", "02651", "55.55N", "014.04E", "23", "SE"],
    ["KALMAR", "ESMQ", "None", "02672", "56.41N", "016.18E", "16", "SE"],
    ["MALMO/STURUP", "ESMS", "None", "02636", "55.32N", "013.22E", "106", "SE"],
    ["HALMSTAD (SWE-AF", "ESMT", "None", "02604", "56.40N", "012.49E", "30", "SE"],
    ["HAGSHULT (SWE-AF", "ESMV", "None", "02556", "57.17N", "014.07E", "172", "SE"],
    ["VAXJO/KRONOBERG", "ESMX", "None", "02641", "56.55N", "014.43E", "186", "SE"],
    ["SVEG", "ESND", "None", "None", "62.03N", "014.25E", "359", "SE"],
    ["GALLIVARE (PRIVA", "ESNG", "None", "02049", "67.08N", "020.49E", "310", "SE"],
    ["JOKKMOKK (SWE-AF", "ESNJ", "None", "02142", "66.37N", "019.38E", "264", "SE"],
    ["KRAMFORS (SWE-AF", "ESNK", "None", "02259", "63.02N", "017.46E", "19", "SE"],
    ["LYCKSELE", "ESNL", "None", "None", "64.33N", "018.43E", "214", "SE"],
    ["SUNDSVALL/HARNOS", "ESNN", "None", "02365", "62.31N", "017.26E", "10", "SE"],
    ["SUNDSVALL/HARNOS", "None", "None", "02366", "62.31N", "017.26E", "10", "SE"],
    ["ORNSKOLDSVIK ARP", "ESNO", "None", "02267", "63.23N", "018.58E", "103", "SE"],
    ["KIRUNA AIRPORT", "ESNQ", "None", "02044", "67.49N", "020.19E", "452", "SE"],
    ["SKELLEFTEA AIRPO", "ESNS", "None", "02293", "64.37N", "021.04E", "49", "SE"],
    ["UMEA AIRPORT", "ESNU", "None", "02286", "63.47N", "020.16E", "14", "SE"],
    ["VILHELMINA", "ESNV", "None", "None", "64.35N", "016.50E", "348", "SE"],
    ["ARVIDSJAUR", "ESNX", "None", "None", "65.35N", "019.17E", "379", "SE"],
    ["OREBRO (PRIVATE)", "ESOE", "None", "None", "59.13N", "015.03E", "57", "SE"],
    ["KARLSTAD NORTH", "ESOK", "None", "None", "59.27N", "013.20E", "107", "SE"],
    ["VASTERAS/HASSLO", "ESOW", "None", "02446", "59.34N", "016.37E", "31", "SE"],
    ["KALLAX/LULEA (AF", "ESPA", "None", "02185", "65.32N", "022.07E", "34", "SE"],
    ["KALLAX/LULEA (AF", "None", "None", "02186", "65.32N", "022.07E", "34", "SE"],
    ["OSTERSUND/FROSON", "ESNZ", "None", "02226", "63.10N", "014.30E", "370", "SE"],
    ["GUNNARN (SWE-AFB", "ESPD", "None", "02128", "65.01N", "017.40E", "281", "SE"],
    ["VIDSEL (SWE-AFB)", "ESPE", "None", "02154", "65.53N", "020.09E", "182", "SE"],
    ["VISBY AERO STATI", "ESQV", "None", "02591", "57.38N", "018.21E", "47", "SE"],
    ["STOCKHOLM/ARLAND", "ESSA", "None", "02460", "59.38N", "017.56E", "61", "SE"],
    ["STOCKHOLM/BROMMA", "ESSB", "None", "02464", "59.21N", "017.56E", "11", "SE"],
    ["BORLANGE (SWE-AF", "ESSD", "None", "02435", "60.25N", "015.30E", "161", "SE"],
    ["HULTSFRED (SWE-A", "ESSF", "None", "02565", "57.31N", "015.49E", "112", "SE"],
    ["GAVLE/SANDVIKEN", "ESSK", "None", "02443", "60.36N", "016.57E", "69", "SE"],
    ["LINKOPING/SAAB", "ESSL", "None", "None", "58.23N", "015.40E", "52", "SE"],
    ["NORRKOPING/KUNGS", "ESSP", "None", "02571", "58.34N", "016.15E", "8", "SE"],
    ["KARLSTADT AIRPOR", "ESSQ", "None", "02418", "59.22N", "013.28E", "55", "SE"],
    ["TORSBY", "ESST", "None", "None", "60.09N", "012.59E", "120", "SE"],
    ["VISBY AIRPORT", "ESSV", "None", "02590", "57.40N", "018.21E", "47", "SE"],
    ["LJUNGBYHED", "ESTL", "None", "None", "56.04N", "013.12E", "43", "SE"],
    ["STORUMAN", "ESUD", "None", "None", "64.58N", "017.42E", "279", "SE"],
    ["PAJALA", "ESUP", "None", "None", "67.15N", "023.04E", "165", "SE"],
    ["HEMAVAN", "ESUT", "None", "None", "65.48N", "015.05E", "463", "SE"],
    ["ANGELHOLM (SWE-A", "ESDB", "None", "None", "56.17N", "012.50E", "47", "SE"],
    ["BARKARBY (SWE-AF", "ESKB", "None", "None", "59.25N", "017.52E", "17", "SE"],
    ["ARVIKA", "ESKV", "None", "02404", "59.40N", "012.34E", "78", "SE"],
    ["SILJAN/MORA", "ESKM", "None", "None", "60.58N", "014.31E", "193", "SE"],
    ["SODERHAMN (SWE-A", "ESCL", "None", "None", "61.16N", "017.06E", "36", "SE"],
    ["OSTERSUND/FROSON", "ESPC", "None", "None", "63.10N", "014.30E", "370", "SE"],
    ["KAUNAS", "EYKA", "None", "None", "54.58N", "024.05E", "77", "LT"],
    ["PALANGA INTL", "EYPA", "None", "None", "55.58N", "021.05E", "10", "LT"],
    ["SIAULIAI INTL", "EYSA", "None", "None", "55.54N", "023.24E", "135", "LT"],
    ["VILNIUS INTL", "EYVI", "None", "26730", "54.38N", "025.17E", "197", "LT"],
    ["TIRANA", "LATI", "None", "13615", "41.25N", "019.43E", "90", "AL"],
    ["BURGAS", "LBBG", "None", "15655", "42.34N", "027.31E", "28", "BG"],
    ["GORNA ORECHOVIST", "LBGO", "None", "None", "43.09N", "025.43E", "86", "BG"],
    ["PLOVDIV", "LBPD", "None", "15625", "42.08N", "024.48E", "185", "BG"],
    ["GRAF IGNATIEVO", "LBPG", "None", "None", "42.17N", "024.43E", "58", "BG"],
    ["ROUSSE/RUSE", "LBRS", "None", "15535", "43.51N", "025.56E", "45", "BG"],
    ["SOFIA (OBSERVATO", "LBSF", "None", "15614", "42.39N", "023.23E", "595", "BG"],
    ["VARNA", "LBWN", "None", "15552", "43.13N", "027.49E", "43", "BG"],
    ["ERCAN", "LCEN", "None", "None", "35.08N", "033.30E", "91", "CY"],
    ["GECITKALE", "LCGK", "None", "None", "35.15N", "033.44E", "20", "CY"],
    ["LARNACA/LARNAX A", "LCLK", "None", "17609", "34.52N", "033.37E", "2", "CY"],
    ["NICOSIA/ATHALASS", "LCNC", "None", "17607", "35.08N", "033.23E", "161", "CY"],
    ["PAPHOS/BAF INTL", "LCPH", "None", "17600", "34.43N", "032.28E", "8", "CY"],
    ["AKROTIRI (RAF)", "LCRA", "None", "17601", "34.34N", "032.58E", "23", "CY"],
    ["ZAGREB/MAKSIMIR", "LDDD", "None", "14240", "45.49N", "016.02E", "123", "HR"],
    ["DUBROVNIK-CILIPI", "LDDU", "None", "13452", "42.34N", "018.16E", "165", "HR"],
    ["LOSINJ ISLAND", "LDLO", "None", "None", "44.34N", "014.24E", "46", "HR"],
    ["OSIJEK", "LDOS", "None", "13157", "45.28N", "018.49E", "89", "HR"],
    ["PULA", "LDPL", "None", "13209", "44.53N", "013.55E", "63", "HR"],
    ["RIJEKA/OMISALJ", "LDRI", "None", "13116", "45.13N", "014.34E", "85", "HR"],
    ["BOL AIRPORT", "LDSB", "None", "None", "43.17N", "016.41E", "542", "HR"],
    ["SPLIT/KASTEL STA", "LDSP", "None", "13333", "43.31N", "016.18E", "21", "HR"],
    ["SHIP C7M/MIKE", "LDWR", "None", "99018", "66.00N", "002.00E", "0", "HR"],
    ["ZAGREB/PLESO", "LDZA", "None", "13131", "45.43N", "016.04E", "107", "HR"],
    ["ZADAR/ZEMUNIK", "LDZD", "None", "13224", "44.06N", "015.22E", "84", "HR"],
    ["ALBACETE (CIV/MI", "LEAB", "None", "08280", "38.57N", "001.51W", "704", "ES"],
    ["ALICANTE/EL ALTE", "LEAL", "None", "08360", "38.16N", "000.33W", "31", "ES"],
    ["ALMERIA AIRPORT", "LEAM", "None", "08487", "36.51N", "002.22W", "21", "ES"],
    ["ASTURIAS/AVILES", "LEAS", "None", "08011", "43.32N", "006.01W", "134", "ES"],
    ["CORDOBA AIRPORT", "LEBA", "None", "08410", "37.51N", "004.49W", "92", "ES"],
    ["BILBAO/SONDICA", "LEBB", "None", "08025", "43.17N", "002.55W", "34", "ES"],
    ["BURGOS/VILLAFRIA", "LEBG", "None", "08075", "42.22N", "003.37W", "891", "ES"],
    ["BARCELONA AIRPOR", "LEBL", "None", "08181", "41.16N", "002.04E", "6", "ES"],
    ["BARDENAS REALES", "LEBR", "None", "08087", "42.12N", "001.26W", "295", "ES"],
    ["TALAVERA AB/BADA", "LEBZ", "None", "08330", "38.52N", "006.49W", "192", "ES"],
    ["CALAMOCHA", "LECH", "None", "08233", "40.52N", "001.18W", "899", "ES"],
    ["LA CORUNA/ALVEDR", "LECO", "None", "08002", "43.17N", "008.22W", "103", "ES"],
    ["MADRI-COLMENAR", "LECV", "None", "08219", "40.38N", "003.43W", "710", "ES"],
    ["LLEIDA/ALGUAIRE", "LEDA", "None", "None", "41.44N", "000.32E", "350", "ES"],
    ["ARMILLA (CIV/MIL", "LEGA", "None", "None", "37.07N", "003.37W", "686", "ES"],
    ["GERONA/COSTA BRA", "LEGE", "None", "08184", "41.53N", "002.46E", "129", "ES"],
    ["GRANADA AIRPORT", "LEGR", "None", "08419", "37.10N", "003.46W", "559", "ES"],
    ["MADRID/GETAFE (A", "LEGT", "None", "08224", "40.17N", "003.43W", "612", "ES"],
    ["HUESCA-PIRINEOS", "LEHC", "None", "None", "42.05N", "000.19W", "539", "ES"],
    ["HINOJOSA DEL DUQ", "LEHI", "None", "08335", "38.31N", "005.07W", "534", "ES"],
    ["IBIZA/ES CODOLA", "LEIB", "None", "08373", "38.52N", "001.22E", "12", "ES"],
    ["JEREZ (CIV/MIL)", "LEJR", "None", "08451", "36.45N", "006.04W", "30", "ES"],
    ["SAN JAVIER(MIL/C", "LELC", "None", "08433", "37.46N", "000.48W", "3", "ES"],
    ["SABADELL", "LELL", "None", "None", "41.31N", "002.06E", "250", "ES"],
    ["LEON/VIRGEN CAMI", "LELN", "None", "08055", "42.34N", "005.39W", "914", "ES"],
    ["LOGRONO/AGONCILL", "LELO", "None", "08084", "42.27N", "002.19W", "363", "ES"],
    ["MADRID/BARAJAS", "LEMD", "None", "08221", "40.29N", "003.34W", "582", "ES"],
    ["MALAGA (CIV/MIL)", "LEMG", "None", "08482", "36.40N", "004.30W", "7", "ES"],
    ["MAHON/MENORCA IS", "LEMH", "None", "08314", "39.52N", "004.13E", "82", "ES"],
    ["MORON (SP-USAFB)", "LEMO", "None", "08397", "37.10N", "005.37W", "88", "ES"],
    ["PALMA DE MALLORC", "LEPA", "None", "08306", "39.32N", "002.43E", "8", "ES"],
    ["PAMPLONA/NOAIN", "LEPP", "None", "08085", "42.46N", "001.39W", "459", "ES"],
    ["ALCANTARILLA(SP-", "LERI", "None", "08429", "37.57N", "001.13W", "75", "ES"],
    ["REUS (CIV/MIL)", "LERS", "None", "08175", "41.08N", "001.10E", "76", "ES"],
    ["ROTA NAVAL STATI", "LERT", "None", "08449", "36.38N", "006.20W", "26", "ES"],
    ["ROTA NAVAL STATI", "KQNR", "None", "None", "36.38N", "006.20W", "26", "ES"],
    ["SALAMANCA (CIV/M", "LESA", "None", "08202", "40.57N", "005.30W", "795", "ES"],
    ["SAN SEBASTIAN/FU", "LESO", "None", "08029", "43.21N", "001.48W", "8", "ES"],
    ["SANTIAGO/LABACOL", "LEST", "None", "08042", "42.53N", "008.25W", "367", "ES"],
    ["PIRINEUS/LA SEU", "LESU", "None", "None", "42.20N", "001.24E", "800", "ES"],
    ["SEVILLA/TABLADA", "LETA", "None", "08390", "37.22N", "006.00W", "14", "ES"],
    ["TORREJON (USAFB)", "LETO", "None", "08227", "40.28N", "003.28W", "608", "ES"],
    ["VALENCIA (CIV/MI", "LEVC", "None", "08284", "39.30N", "000.28W", "62", "ES"],
    ["VALLADOLID(MIL/C", "LEVD", "None", "08140", "41.43N", "004.50W", "854", "ES"],
    ["MADRID/CUATRO VI", "LEVS", "None", "08223", "40.22N", "003.46W", "687", "ES"],
    ["VITORIA", "LEVT", "None", "08080", "42.52N", "002.43W", "509", "ES"],
    ["VIGO/PEINADOR", "LEVX", "None", "08045", "42.13N", "008.37W", "256", "ES"],
    ["SANTANDER/PARAYA", "LEXJ", "None", "08021", "43.25N", "003.49W", "6", "ES"],
    ["ZARAGOZA (USAFB)", "LEZA", "None", "None", "41.40N", "001.03W", "263", "ES"],
    ["ZARAGOZA (MIL/CI", "LEZG", "None", "08160", "41.40N", "001.01W", "258", "ES"],
    ["SEVILLA (CIV/MIL", "LEZL", "None", "08391", "37.25N", "005.54W", "31", "ES"],
    ["LA CORUNA CITY", "None", "None", "08001", "43.22N", "008.25W", "67", "ES"],
    ["SANTANDER CITY", "None", "None", "08023", "43.28N", "003.49W", "79", "ES"],
    ["PALMA D MALLORCA", "None", "None", "08301", "39.33N", "002.37W", "6", "ES"],
    ["PALMA/SON BONET", "None", "None", "08302", "39.36N", "002.42W", "41", "ES"],
    ["MURCIA CITY", "None", "None", "08430", "37.59N", "001.07W", "54", "ES"],
    ["FUERTEVENTURA AR", "GCFV", "None", "60035", "28.26N", "013.52W", "23", "ES"],
    ["LA GOMERA ARPT", "GCGM", "None", "None", "28.02N", "017.13W", "219", "ES"],
    ["HIERRO AIRPORT", "GCHI", "None", "60001", "27.49N", "017.52W", "30", "ES"],
    ["LA PALMA AIRPORT", "GCLA", "None", "60005", "28.37N", "017.45W", "31", "ES"],
    ["LAS PALMAS/GANDO", "GCLP", "None", "60030", "27.55N", "015.22W", "25", "ES"],
    ["ARRECIFE/LANZARO", "GCRR", "None", "60040", "28.56N", "013.35W", "40", "ES"],
    ["TENERIFE SUR/REI", "GCTS", "None", "60025", "28.03N", "016.34W", "72", "ES"],
    ["TENERIFE/LOS ROD", "GCXO", "None", "60015", "28.29N", "016.21W", "632", "ES"],
    ["MELILLA", "GEML", "None", "60338", "35.16N", "002.57W", "55", "ES"],
    ["CALAIS/DUNKERQUE", "LFAC", "None", "None", "50.58N", "001.57E", "3", "FR"],
    ["BRAY", "LFAQ", "None", "None", "49.58N", "002.42E", "111", "FR"],
    ["LE TOUQUET/P. PL", "LFAT", "None", "07003", "50.31N", "001.37E", "14", "FR"],
    ["AGEN/LA GARENNE", "LFBA", "None", "07524", "44.10N", "000.36E", "60", "FR"],
    ["CAZAUX POND (FAF", "LFBC", "None", "07502", "44.31N", "001.07W", "33", "FR"],
    ["BORDEAUX/MERIGNA", "LFBD", "None", "07510", "44.49N", "000.42W", "61", "FR"],
    ["BERGERAC/ROUMANI", "LFBE", "None", "07530", "44.49N", "000.31E", "52", "FR"],
    ["TOULOUSE/FRANCAZ", "LFBF", "None", "07631", "43.31N", "001.22E", "166", "FR"],
    ["COGNAC/CHATEAUBE", "LFBG", "None", "07412", "45.40N", "000.19W", "31", "FR"],
    ["LA ROCHELLE/LALE", "LFBH", "None", "07315", "46.11N", "001.12W", "10", "FR"],
    ["POITIERS/BIARD(A", "LFBI", "None", "07335", "46.34N", "000.19E", "120", "FR"],
    ["MONTLUCON/GUERET", "LFBK", "None", "None", "46.13N", "002.22E", "415", "FR"],
    ["LIMOGES/BELLEGAR", "LFBL", "None", "07434", "45.52N", "001.10E", "402", "FR"],
    ["MONT-DE-MARSAN F", "LFBM", "None", "07607", "43.55N", "000.30W", "63", "FR"],
    ["NIORT/SOUCHE (AU", "LFBN", "None", "07330", "46.19N", "000.24W", "61", "FR"],
    ["TOULOUSE/BLAGNAC", "LFBO", "None", "07630", "43.37N", "001.22E", "153", "FR"],
    ["PONT-LONG-UZEIN/", "LFBP", "None", "07610", "43.22N", "000.25W", "185", "FR"],
    ["MURET/LHERM", "LFBR", "None", "None", "43.27N", "001.16E", "189", "FR"],
    ["BISCAROSSE/PAREN", "LFBS", "None", "07503", "44.22N", "001.08W", "39", "FR"],
    ["TARBES/OSSUN", "LFBT", "None", "07621", "43.10N", "000.00E", "363", "FR"],
    ["BRIE CHAMPNIERS", "LFBU", "None", "None", "45.43N", "000.13E", "133", "FR"],
    ["BRIVE/LA ROCHE(A", "LFBV", "None", "07438", "45.08N", "001.28E", "117", "FR"],
    ["PERIGUEUX/BASSIL", "LFBX", "None", "07428", "45.12N", "000.49E", "97", "FR"],
    ["DAX/SEYRESSE", "LFBY", "None", "07603", "43.40N", "001.04W", "32", "FR"],
    ["BIARRITZ/ANGLET", "LFBZ", "None", "07602", "43.28N", "001.31W", "71", "FR"],
    ["LALBENQUE/CAHORS", "LFCC", "None", "None", "44.21N", "001.28E", "278", "FR"],
    ["ST. GIRONS/ANTIC", "LFCG", "None", "07627", "43.00N", "001.06E", "412", "FR"],
    ["ALBI/LE SEQUESTR", "LFCI", "None", "07632", "43.55N", "002.07E", "178", "FR"],
    ["CASTRES-MAZAMET", "LFCK", "None", "None", "43.33N", "002.17E", "240", "FR"],
    ["RODEZ/MARCILLAC", "LFCR", "None", "07552", "44.23N", "002.28E", "580", "FR"],
    ["MONTAUBAN", "LFDB", "None", "None", "44.08N", "001.29E", "160", "FR"],
    ["AUCH/LAMOTHE (AU", "LFDH", "None", "07622", "43.40N", "000.36E", "128", "FR"],
    ["SUIPPES RANGE (M", "LFFS", "None", "None", "49.08N", "004.31E", "199", "FR"],
    ["COLMAR HOUSSEN", "LFGA", "None", "None", "48.06N", "007.21E", "191", "FR"],
    ["DOLE TAVAUX", "LFGJ", "None", "None", "47.03N", "005.26E", "196", "FR"],
    ["MEGEVE", "LFHM", "None", "None", "45.52N", "006.37E", "950", "FR"],
    ["LE PUY/LOUDES (A", "LFHP", "None", "07471", "45.04N", "003.46E", "833", "FR"],
    ["CASSAGNES-BEGONH", "LFIG", "None", "07555", "44.10N", "002.31E", "1020", "FR"],
    ["METZ-NANCY-LORRA", "LFJL", "None", "07093", "48.58N", "006.15E", "264", "FR"],
    ["MARCE", "LFJR", "None", "None", "47.34N", "000.18W", "60", "FR"],
    ["BASTIA/PORETTA", "LFKB", "None", "07790", "42.32N", "009.28E", "12", "FR"],
    ["CALVI/ST. CATHER", "LFKC", "None", "07754", "42.31N", "008.48E", "58", "FR"],
    ["FIGARI (AUT)", "LFKF", "None", "07780", "41.30N", "009.05E", "23", "FR"],
    ["AJACCIO/CAMPO OR", "LFKJ", "None", "07761", "41.55N", "008.48E", "9", "FR"],
    ["SOLENZARA (FAFB)", "LFKS", "None", "07765", "41.55N", "009.24E", "22", "FR"],
    ["AUXERRE (AUT)", "LFLA", "None", "07265", "47.47N", "003.32E", "212", "FR"],
    ["CHAMBERY/AIX BAI", "LFLB", "None", "07491", "45.38N", "005.52E", "239", "FR"],
    ["CLERMONT/AULNAT", "LFLC", "None", "07460", "45.46N", "003.10E", "330", "FR"],
    ["BOURGES (AUT)", "LFLD", "None", "07255", "47.04N", "002.22E", "166", "FR"],
    ["LYON/SATOLAS", "LFLL", "None", "07481", "45.43N", "005.04E", "240", "FR"],
    ["MACON/CHARNAY (A", "LFLM", "None", "07385", "46.17N", "004.47E", "217", "FR"],
    ["SAINT YAN", "LFLN", "None", "07379", "46.25N", "004.01E", "244", "FR"],
    ["ANNECY/MEYTHET", "LFLP", "None", "None", "45.55N", "006.05E", "463", "FR"],
    ["MONTELIMAR/ANCON", "LFLQ", "None", "07577", "44.34N", "004.43E", "74", "FR"],
    ["GRENOBLE/ST. GEO", "LFLS", "None", "07486", "45.22N", "005.19E", "386", "FR"],
    ["VALENCE-CHABEUIL", "LFLU", "None", "None", "44.55N", "004.59E", "160", "FR"],
    ["VICHY/CHARMEIL", "LFLV", "None", "07374", "46.10N", "003.23E", "251", "FR"],
    ["AURILLAC (AUT)", "LFLW", "None", "07549", "44.53N", "002.25E", "639", "FR"],
    ["CHATEAUROUX/DEOL", "LFLX", "None", "07354", "46.51N", "001.43E", "157", "FR"],
    ["LYON/BRON", "LFLY", "None", "07480", "45.43N", "004.57E", "201", "FR"],
    ["AIX LES MILLES F", "LFMA", "None", "07649", "43.30N", "005.22E", "111", "FR"],
    ["LE LUC/LE CANNET", "LFMC", "None", "07675", "43.22N", "006.22E", "78", "FR"],
    ["CANNES/MANDELIEU", "LFMD", "None", "07684", "43.32N", "006.57E", "9", "FR"],
    ["NIMES/COURBESSAC", "LFME", "None", "07645", "43.52N", "004.24E", "62", "FR"],
    ["ST ETIENNE/BOUTH", "LFMH", "None", "07475", "45.31N", "004.17E", "402", "FR"],
    ["ISTRES/LE TUBE F", "LFMI", "None", "07647", "43.31N", "004.55E", "24", "FR"],
    ["CARCASSONNE/SALV", "LFMK", "None", "07635", "43.13N", "002.19E", "130", "FR"],
    ["MARSEILLE/MARIGN", "LFML", "None", "07650", "43.27N", "005.13E", "36", "FR"],
    ["NICE/COTE D'AZUR", "LFMN", "None", "07690", "43.38N", "007.12E", "10", "FR"],
    ["ORANGE/CARITAT(F", "LFMO", "None", "07579", "44.07N", "004.52E", "55", "FR"],
    ["PERPIGNAN/RIVESA", "LFMP", "None", "07747", "42.43N", "002.52E", "48", "FR"],
    ["FREJORGUES/MONTP", "LFMT", "None", "07643", "43.34N", "003.58E", "6", "FR"],
    ["BEZIERS/VIAS", "LFMU", "None", "None", "43.19N", "003.21E", "17", "FR"],
    ["CAUMONT", "LFMV", "None", "None", "43.54N", "004.54E", "38", "FR"],
    ["ST-AUBAN-SUR-DUR", "LFMX", "None", "07588", "44.04N", "006.00E", "461", "FR"],
    ["SALON (FAFB)", "LFMY", "None", "07648", "43.36N", "005.05E", "60", "FR"],
    ["GAP/TALLARD", "LFNA", "None", "None", "44.34N", "006.04E", "733", "FR"],
    ["MENDE/BRENOUX", "LFNB", "None", "None", "44.30N", "003.31E", "1024", "FR"],
    ["LA MOLE", "LFNM", "None", "None", "43.12N", "006.28E", "18", "FR"],
    ["AVORD (FAFB)", "LFOA", "None", "07257", "47.02N", "002.38E", "179", "FR"],
    ["BEAUVAIS/TILLE(A", "LFOB", "None", "07055", "49.28N", "002.07E", "111", "FR"],
    ["CHATEAUDUN (FAFB", "LFOC", "None", "07140", "48.02N", "001.22E", "127", "FR"],
    ["EVREUX/FAUVILLE", "LFOE", "None", "07038", "49.01N", "001.13E", "146", "FR"],
    ["ALENCON/VALFRAMB", "LFOF", "None", "07139", "48.27N", "000.07E", "141", "FR"],
    ["LE HAVRE/OCTEVIL", "LFOH", "None", "07028", "49.31N", "000.04E", "103", "FR"],
    ["ABBEVILLE (AUT)", "LFOI", "None", "07005", "50.08N", "001.50E", "77", "FR"],
    ["ORLEANS/BRICY(FA", "LFOJ", "None", "07249", "47.58N", "001.45E", "125", "FR"],
    ["CHALONS/VATRY FA", "LFOK", "None", "None", "48.47N", "004.11E", "162", "FR"],
    ["ROUEN/BOOS (AUT)", "LFOP", "None", "07037", "49.22N", "001.10E", "157", "FR"],
    ["CHARTRES/CHAMPOL", "LFOR", "None", "07143", "48.28N", "001.31E", "156", "FR"],
    ["VITTEFLEUR/ST. V", "LFOS", "None", "07033", "49.49N", "000.39E", "83", "FR"],
    ["TOURS/ST SYMPHOR", "LFOT", "TUF", "07240", "47.26N", "000.43E", "108", "FR"],
    ["LAVAL/ENTRAMMES", "LFOV", "None", "None", "48.02N", "000.45W", "101", "FR"],
    ["ST. QUENTIN/ROUP", "LFOW", "None", "07061", "49.49N", "003.12E", "101", "FR"],
    ["PARIS/LE BOURGET", "LFPB", "None", "07150", "48.58N", "002.27E", "65", "FR"],
    ["CREIL (FAFB)", "LFPC", "None", "07057", "49.15N", "002.31E", "88", "FR"],
    ["CHARLES DE GAULL", "LFPG", "None", "07157", "49.01N", "002.31E", "109", "FR"],
    ["MELUN/VILLAROCHE", "LFPM", "None", "07153", "48.37N", "002.40E", "92", "FR"],
    ["TOUSSUS LE NOBLE", "LFPN", "None", "07146", "48.45N", "002.07E", "164", "FR"],
    ["PARIS/ORLY", "LFPO", "None", "07149", "48.43N", "002.23E", "96", "FR"],
    ["CORMEILLES VEXIN", "LFPT", "None", "None", "49.06N", "002.02E", "99", "FR"],
    ["VILLACOUBLAY/VEL", "LFPV", "None", "07147", "48.46N", "002.12E", "179", "FR"],
    ["PARIS MET CENTER", "LFPW", "None", "None", "48.49N", "002.19E", "75", "FR"],
    ["BRETIGNY-SUR-ORG", "LFPY", "None", "07148", "48.36N", "002.19E", "85", "FR"],
    ["REIMS/PRUNAY", "LFQA", "None", "07072", "49.12N", "004.09E", "95", "FR"],
    ["TROYES/BARBEREY", "LFQB", "None", "07168", "48.19N", "004.01E", "118", "FR"],
    ["ROUVRES (FR-ARMY", "LFQE", "None", "None", "49.13N", "005.40E", "234", "FR"],
    ["NEVERS/FOURCHAMB", "LFQG", "None", "07260", "47.00N", "003.06E", "181", "FR"],
    ["CHATILLON-SUR-SE", "LFQH", "None", "07276", "47.51N", "004.32E", "264", "FR"],
    ["CAMBRAI/EPINOY(F", "LFQI", "None", "07017", "50.13N", "003.08E", "77", "FR"],
    ["LILLE/LESQUIN", "LFQQ", "None", "07015", "50.34N", "003.06E", "52", "FR"],
    ["CHARLEVILLE/MEZI", "LFQV", "None", "07075", "49.46N", "004.37E", "150", "FR"],
    ["ANGERS/AVRILLE(A", "LFRA", "None", "07230", "47.30N", "000.34W", "58", "FR"],
    ["BREST/GUIPAVAS", "LFRB", "None", "07110", "48.27N", "004.25W", "103", "FR"],
    ["CHERBOURG/MAUPER", "LFRC", "None", "07024", "49.38N", "001.28W", "138", "FR"],
    ["DINARD/PLEURTUIT", "LFRD", "None", "07125", "48.35N", "002.04W", "59", "FR"],
    ["ST GATIEN", "LFRG", "None", "None", "49.22N", "000.09E", "146", "FR"],
    ["LORIENT/LANN BIH", "LFRH", "None", "07205", "47.46N", "003.27W", "44", "FR"],
    ["LA ROCHE/LES AJO", "LFRI", "None", "07306", "46.42N", "001.22W", "91", "FR"],
    ["LANDIVISIAU (NAV", "LFRJ", "None", "07106", "48.31N", "004.09W", "115", "FR"],
    ["CAEN/CARPIQUET(A", "LFRK", "None", "07027", "49.10N", "000.27W", "67", "FR"],
    ["LANVEOC/POULMIC(", "LFRL", "None", "07109", "48.16N", "004.25W", "82", "FR"],
    ["LE MANS/ARNAGE(A", "LFRM", "None", "07235", "47.57N", "000.12E", "52", "FR"],
    ["RENNES/ST. JACQU", "LFRN", "None", "07130", "48.04N", "001.43W", "37", "FR"],
    ["LANNION/SERVEL", "LFRO", "None", "None", "48.45N", "003.28W", "89", "FR"],
    ["QUIMPER/PLUGUFFA", "LFRQ", "None", "07201", "47.58N", "004.10W", "94", "FR"],
    ["NANTES/CHATEAU B", "LFRS", "None", "07222", "47.10N", "001.36W", "27", "FR"],
    ["SAINT-BRIEUC ARM", "LFRT", "None", "07120", "48.31N", "002.51W", "136", "FR"],
    ["MORLAIX/PLOUJEAN", "LFRU", "None", "None", "48.36N", "003.49W", "86", "FR"],
    ["VANNES/MEUCON", "LFRV", "None", "None", "47.43N", "002.43W", "133", "FR"],
    ["ST. NAZAIRE/MONT", "LFRZ", "None", "07217", "47.19N", "002.10W", "4", "FR"],
    ["BESANCON/THISE(A", "LFSA", "None", "07288", "47.15N", "005.58E", "309", "FR"],
    ["BALE/MULHOUSE", "LFSB", "None", "07299", "47.36N", "007.31E", "271", "FR"],
    ["COLMAR/MEYENHEIM", "LFSC", "None", "07197", "47.55N", "007.24E", "217", "FR"],
    ["DIJON/LONGVIC(FA", "LFSD", "None", "07280", "47.16N", "005.04E", "227", "FR"],
    ["METZ/FRESCATY(FA", "LFSF", "None", "07090", "49.04N", "006.07E", "191", "FR"],
    ["EPINAL/MIRECOURT", "LFSG", "None", "None", "48.20N", "006.04E", "330", "FR"],
    ["ST. DIZIER/ROBIN", "LFSI", "None", "07169", "48.37N", "004.54E", "140", "FR"],
    ["BRIVE/SOUILLAC", "LFSL", "None", "None", "45.02N", "001.29E", "310", "FR"],
    ["NANCY/ESSEY", "LFSN", "None", "07180", "48.40N", "006.13E", "217", "FR"],
    ["NANCY/OCHEY (FAF", "LFSO", "None", "07181", "48.34N", "005.58E", "350", "FR"],
    ["PONTARLIER", "LFSP", "None", "None", "46.53N", "006.19E", "817", "FR"],
    ["BELFORT/FONTAINE", "LFSQ", "None", "07295", "47.37N", "006.52E", "423", "FR"],
    ["REIMS/CHAMPAGNE", "LFSR", "None", "07070", "49.17N", "004.01E", "99", "FR"],
    ["STRASBOURG/ENTZH", "LFST", "None", "07190", "48.32N", "007.37E", "154", "FR"],
    ["LUXEUIL/ST. SAUV", "LFSX", "None", "07292", "47.46N", "006.20E", "273", "FR"],
    ["PIERREFEN (NAVY)", "LFTF", "None", "None", "43.15N", "006.07E", "81", "FR"],
    ["HYERES/LE PALYVE", "LFTH", "None", "07667", "43.06N", "006.09E", "4", "FR"],
    ["FREJUS/ST. RAPHA", "LFTU", "None", "07680", "43.25N", "006.45E", "6", "FR"],
    ["NIMES/GARONS (NA", "LFTW", "None", "07646", "43.45N", "004.25E", "96", "FR"],
    ["AMBERIEU (FAFB/A", "LFXA", "None", "07482", "45.58N", "005.19E", "257", "FR"],
    ["APT/ST. CHRISTOL", "LFXI", "None", "07657", "44.02N", "005.28E", "837", "FR"],
    ["NIERGNIES (FAFB)", "LFYG", "None", "None", "50.07N", "003.16E", "110", "FR"],
    ["BROYE-LES-PESMES", "LFYH", "None", "None", "47.20N", "005.31E", "208", "FR"],
    ["CAPTIEUX (MET/OB", "LFYJ", "None", "07517", "44.10N", "000.16W", "133", "FR"],
    ["LURE/MALBOUHANS", "LFYL", "None", "None", "47.42N", "006.32E", "317", "FR"],
    ["ROMORANTIN/PRUNI", "LFYR", "None", "07247", "47.19N", "001.40E", "86", "FR"],
    ["TRAPPES (AUT)", "None", "None", "07145", "48.46N", "002.01E", "168", "FR"],
    ["ANDRAVIDA (CIV/A", "LGAD", "None", "16682", "37.55N", "021.16E", "12", "GR"],
    ["ALEXANDROUPOLIS", "LGAL", "None", "16627", "40.51N", "025.57E", "3", "GR"],
    ["ATHENS/ELEF-VEN", "LGAV", "None", "None", "37.56N", "023.57E", "94", "GR"],
    ["NEA ANCHIALOS", "LGBL", "None", "16665", "39.13N", "022.48E", "26", "GR"],
    ["ELEFSIS (HEL-AFB", "LGEL", "None", "16718", "38.04N", "023.33E", "31", "GR"],
    ["CHIOS AIRPORT", "LGHI", "None", "16706", "38.19N", "026.07E", "4", "GR"],
    ["IRAKLION (CIV/AF", "LGIR", "None", "16754", "35.19N", "025.10E", "39", "GR"],
    ["KITHIRA ARPT", "LGKC", "None", "None", "36.17N", "023.01E", "319", "GR"],
    ["KEFALLINIA", "LGKF", "None", "16685", "38.07N", "020.30E", "18", "GR"],
    ["KALAMATA (HEL-AF", "LGKL", "None", "16726", "37.04N", "022.01E", "8", "GR"],
    ["KOS AIRPORT", "LGKO", "None", "16742", "36.48N", "027.05E", "125", "GR"],
    ["KARPATHOS", "LGKP", "None", "16765", "35.25N", "027.09E", "20", "GR"],
    ["IOANNIS KAPODIST", "LGKR", "None", "16641", "39.37N", "019.55E", "2", "GR"],
    ["KAVALA/CHRISOUPO", "LGKV", "None", "16624", "40.55N", "024.37E", "5", "GR"],
    ["KOZANI (CIV/ARMY", "LGKZ", "None", "16632", "40.17N", "021.50E", "628", "GR"],
    ["LIMNOS ISLAND AR", "LGLM", "None", "16650", "39.55N", "025.14E", "5", "GR"],
    ["LARISA AIRPORT", "LGLR", "None", "16648", "39.39N", "022.28E", "74", "GR"],
    ["MIKONOS ISLAND", "LGMK", "None", "16750", "37.26N", "025.21E", "123", "GR"],
    ["MITILINI", "LGMT", "None", "16667", "39.03N", "026.36E", "17", "GR"],
    ["NAXOS AIRPORT", "LGNX", "None", "None", "37.05N", "025.22E", "4", "GR"],
    ["PAROS", "LGPA", "None", "16766", "37.00N", "025.08E", "36", "GR"],
    ["PREVEZA/AKTION", "LGPZ", "None", "16643", "38.55N", "020.46E", "4", "GR"],
    ["RHODES/DIAGORAS", "LGRP", "None", "16749", "36.24N", "028.05E", "5", "GR"],
    ["ARAXOS (CIV/AFB)", "LGRX", "None", "16687", "38.10N", "021.25E", "15", "GR"],
    ["SOUDA/KHANIA (AF", "LGSA", "None", "16746", "35.32N", "024.08E", "135", "GR"],
    ["SKIATHOS ISLAND", "LGSK", "None", "16660", "39.11N", "023.30E", "15", "GR"],
    ["SAMOS AIRPORT", "LGSM", "None", "16723", "37.41N", "026.55E", "6", "GR"],
    ["SYROS", "LGSO", "None", "16774", "37.25N", "024.57E", "72", "GR"],
    ["SANTORINI ISLAND", "LGSR", "None", "16744", "36.24N", "025.29E", "40", "GR"],
    ["SITIA AIRPORT", "LGST", "None", "16757", "35.13N", "026.06E", "115", "GR"],
    ["SKIROS", "LGSY", "None", "16684", "38.58N", "024.29E", "15", "GR"],
    ["TANAGRA AIRPORT", "LGTG", "None", "16699", "38.20N", "023.34E", "148", "GR"],
    ["KASTELI AIRPORT", "LGTL", "None", "16760", "35.12N", "025.20E", "360", "GR"],
    ["THESSALONIKI/MIK", "LGTS", "None", "16622", "40.31N", "022.58E", "7", "GR"],
    ["ZAKINTHOS AIRPOR", "LGZA", "None", "None", "37.45N", "020.52E", "3", "GR"],
    ["AGRINION (HEL-AF", "LGAG", "None", "16672", "38.37N", "021.22E", "24", "GR"],
    ["ATHENS/HELLENKIO", "LGAT", "None", "16716", "37.53N", "023.43E", "21", "GR"],
    ["IKARIA", "LGIK", "None", "16779", "37.41N", "026.21E", "24", "GR"],
    ["IOANNINA", "LGIO", "None", "16642", "39.42N", "020.49E", "476", "GR"],
    ["KASTORIA AIRPORT", "LGKA", "None", "16614", "40.27N", "021.16E", "669", "GR"],
    ["KASTELLORIZO", "LGKJ", "None", "16767", "36.04N", "029.20E", "145", "GR"],
    ["KASOS", "LGKS", "None", "16770", "35.25N", "026.55E", "10", "GR"],
    ["LEROS", "LGLE", "None", "16768", "37.11N", "026.48E", "11", "GR"],
    ["PIRAEUS", "LGLX", "None", "16717", "37.59N", "023.34E", "2", "GR"],
    ["MARATHONAS", "LGMR", "None", "16680", "38.09N", "024.01E", "5", "GR"],
    ["ASTYPALAIA", "LGPL", "None", "16739", "36.35N", "026.23E", "47", "GR"],
    ["RHODES/MARITSA", "LGRD", "None", "None", "36.22N", "028.07E", "62", "GR"],
    ["SEDES (HEL-MIL)", "LGSD", "None", "None", "40.32N", "023.01E", "57", "GR"],
    ["TRIPOLIS (HEL-AF", "LGTP", "None", "16710", "37.31N", "022.23E", "652", "GR"],
    ["TATOI/DEKELIA (A", "LGTT", "None", "16715", "38.06N", "023.46E", "235", "GR"],
    ["TYMBAKI", "LGTY", "None", "16759", "35.04N", "024.46E", "7", "GR"],
    ["VOLOS (CIV/MIL)", "LGVO", "None", "None", "39.22N", "022.56E", "27", "GR"],
    ["BEKESCSABA GLIDE", "LHBC", "None", "None", "46.41N", "021.10E", "86", "HU"],
    ["BUDAPEST/FERIHEG", "LHBP", "None", "12839", "47.25N", "019.16E", "185", "HU"],
    ["DEBRECEN AIRPORT", "LHDC", "None", "12882", "47.28N", "021.37E", "112", "HU"],
    ["KECSKEMET", "LHKE", "None", "None", "46.55N", "019.45E", "115", "HU"],
    ["PAPA", "LHPA", "None", "None", "47.21N", "017.30E", "148", "HU"],
    ["PECS-POGANY", "LHPP", "None", "None", "45.59N", "018.14E", "305", "HU"],
    ["GYOR", "LHPR", "None", "None", "47.38N", "017.49E", "129", "HU"],
    ["BALATON", "LHSM", "None", "None", "46.41N", "017.10E", "125", "HU"],
    ["SZOLNOK", "LHSN", "None", "None", "47.07N", "020.14E", "98", "HU"],
    ["BUDAPEST/LORINC", "None", "None", "12843", "47.26N", "019.11E", "140", "HU"],
    ["SZEGED (AUT)", "LHUD", "None", "12982", "46.15N", "020.06E", "84", "HU"],
    ["TASZAR", "LHTA", "None", "None", "46.24N", "017.55E", "160", "HU"],
    ["AMENDOLA (IT-AFB", "LIBA", "None", "16261", "41.31N", "015.43E", "60", "IT"],
    ["CROTONE", "LIBC", "None", "16350", "39.00N", "017.04E", "161", "IT"],
    ["BARI/PALESE MACC", "LIBD", "None", "16270", "41.07N", "016.46E", "44", "IT"],
    ["SANT'ANGELO (MOU", "LIBE", "None", "16258", "41.43N", "015.57E", "844", "IT"],
    ["FOGGIA/GINO LISA", "LIBF", "None", "None", "41.25N", "015.31E", "80", "IT"],
    ["GROTTAGLIE(CIV/A", "LIBG", "None", "16324", "40.31N", "017.23E", "69", "IT"],
    ["MARINA DI GINOSA", "LIBH", "None", "16325", "40.25N", "016.52E", "12", "IT"],
    ["VIESTE", "LIBI", "None", "None", "41.55N", "016.03E", "50", "IT"],
    ["VIBO VALENTIA", "LIBJ", "None", "None", "38.40N", "016.06E", "520", "IT"],
    ["CARAFFA DI CATAN", "LIBK", "None", "None", "38.52N", "016.28E", "343", "IT"],
    ["PALASCIA", "LIBL", "None", "None", "40.06N", "018.31E", "89", "IT"],
    ["GROTTAMMARE", "LIBM", "None", "None", "42.58N", "013.52E", "1", "IT"],
    ["LECCE (IT-AFB)", "LIBN", "None", "16332", "40.13N", "018.08E", "61", "IT"],
    ["PESCARA", "LIBP", "None", "16230", "42.25N", "014.11E", "11", "IT"],
    ["SCURO MOUNTAIN", "LIBQ", "None", "16344", "39.19N", "016.23E", "1720", "IT"],
    ["BRINDISI/CASALE", "LIBR", "None", "16320", "40.39N", "017.57E", "10", "IT"],
    ["CAMPOBASSO", "LIBS", "None", "16252", "41.34N", "014.39E", "807", "IT"],
    ["TERMOLI", "LIBT", "None", "16232", "42.00N", "015.00E", "44", "IT"],
    ["LATRONICO", "LIBU", "None", "16316", "40.04N", "016.01E", "896", "IT"],
    ["GIOIA DEL COLLE", "LIBV", "None", "16312", "40.46N", "016.55E", "350", "IT"],
    ["BONIFATI (CAPE)", "LIBW", "None", "16337", "39.34N", "015.52E", "485", "IT"],
    ["MARTINA FRANCA(A", "LIBX", "None", "None", "40.42N", "017.19E", "447", "IT"],
    ["SANTA MARIA DI L", "LIBY", "None", "16360", "39.49N", "018.21E", "112", "IT"],
    ["POTENZA", "LIBZ", "None", "16300", "40.37N", "015.48E", "843", "IT"],
    ["LAMEZIA TERME", "LICA", "None", "16362", "38.53N", "016.15E", "15", "IT"],
    ["COMISO", "LICB", "None", "None", "37.00N", "014.37E", "220", "IT"],
    ["CATANIA/FONTANAR", "LICC", "None", "16460", "37.28N", "015.03E", "17", "IT"],
    ["LAMPEDUSA ISLAND", "LICD", "None", "16490", "35.30N", "012.37E", "20", "IT"],
    ["ENNA", "LICE", "None", "16450", "37.34N", "014.16E", "965", "IT"],
    ["MESSINA", "LICF", "None", "16420", "38.12N", "015.33E", "51", "IT"],
    ["PANTELLERIA(IT-A", "LICG", "None", "16470", "36.49N", "011.58E", "191", "IT"],
    ["CAPE SPARTIVENTO", "LICH", "None", "None", "37.55N", "016.04E", "17", "IT"],
    ["PALERMO/POINT RA", "LICJ", "None", "16405", "38.10N", "013.05E", "34", "IT"],
    ["GELA", "LICL", "None", "16453", "37.04N", "014.13E", "33", "IT"],
    ["CALOPEZZATI", "LICM", "None", "None", "39.32N", "016.48E", "179", "IT"],
    ["COZZO SPADARO", "LICO", "None", "16480", "36.40N", "015.07E", "51", "IT"],
    ["PALMERO/BOCCADIF", "LICP", "None", "16410", "38.06N", "013.18E", "117", "IT"],
    ["REGGIO CALABRIA", "LICR", "None", "16422", "38.04N", "015.39E", "21", "IT"],
    ["SCIACCA", "LICS", "None", "None", "37.31N", "013.03E", "125", "IT"],
    ["TRAPANI/BIRGI (A", "LICT", "None", "16429", "37.55N", "012.30E", "7", "IT"],
    ["USTICA ISLAND", "LICU", "None", "16400", "38.42N", "013.10E", "251", "IT"],
    ["PRIZZI", "LICX", "None", "16434", "37.43N", "013.25E", "1035", "IT"],
    ["SIGONELLA (NAS)", "LICZ", "None", "16459", "37.23N", "014.55E", "22", "IT"],
    ["ALGHERO", "LIEA", "None", "16520", "40.37N", "008.16E", "23", "IT"],
    ["CAPE BELLAVISTA", "LIEB", "None", "16550", "39.56N", "009.43E", "156", "IT"],
    ["CAPE CARBONARA", "LIEC", "None", "16564", "39.06N", "009.31E", "118", "IT"],
    ["DECIMOMANNU(IT-A", "LIED", "None", "16546", "39.21N", "008.58E", "28", "IT"],
    ["CAGLIARI/ELMAS(A", "LIEE", "None", "16560", "39.15N", "009.04E", "4", "IT"],
    ["CAPE FRASCA", "LIEF", "None", "16539", "39.44N", "008.28E", "92", "IT"],
    ["GUARDIAVECCHIA", "LIEG", "None", "16506", "41.13N", "009.24E", "170", "IT"],
    ["CAPE CACCIA", "LIEH", "None", "16522", "40.34N", "008.10E", "205", "IT"],
    ["CAPE S. LORENZO", "LIEL", "None", "16542", "39.30N", "009.37E", "22", "IT"],
    ["MACOMER", "LIEM", "None", "None", "40.16N", "008.46E", "559", "IT"],
    ["FONNI", "LIEN", "None", "16538", "40.07N", "009.15E", "1029", "IT"],
    ["OLBIA/COSTA SMER", "LIEO", "None", "16531", "40.53N", "009.31E", "13", "IT"],
    ["PERDASDEFOGU", "LIEP", "None", "16541", "39.40N", "009.25E", "645", "IT"],
    ["TORTOLI", "LIET", "None", "None", "39.55N", "009.41E", "8", "IT"],
    ["AERITALIA", "LIMA", "None", "None", "45.05N", "007.36E", "287", "IT"],
    ["MILANO/MALPENSA", "LIMC", "None", "16066", "45.37N", "008.43E", "211", "IT"],
    ["GRIGNA SETTENTRI", "LIMD", "None", "None", "45.57N", "009.22E", "2403", "IT"],
    ["BERGAMO/ORIO SER", "LIME", "None", "16076", "45.40N", "009.41E", "237", "IT"],
    ["TORINO/CASELLE", "LIMF", "None", "16059", "45.13N", "007.39E", "287", "IT"],
    ["ALBENGA", "LIMG", "None", "16122", "44.02N", "008.07E", "49", "IT"],
    ["PIAN ROSA (MTN T", "LIMH", "None", "16052", "45.56N", "007.42E", "3488", "IT"],
    ["GENOVA/SESTRI", "LIMJ", "None", "16120", "44.25N", "008.50E", "3", "IT"],
    ["TORINO/BRIC CROC", "LIMK", "None", "16061", "45.01N", "007.43E", "710", "IT"],
    ["MILANO/LINATE", "LIML", "None", "16080", "45.28N", "009.16E", "103", "IT"],
    ["CAMERI (IT-AFB)", "LIMN", "None", "16064", "45.31N", "008.40E", "169", "IT"],
    ["BISBINO MOUNTAIN", "LIMO", "None", "16072", "45.52N", "009.04E", "1322", "IT"],
    ["PARMA", "LIMP", "None", "None", "44.49N", "010.18E", "50", "IT"],
    ["GOVONE", "LIMQ", "None", "16116", "44.47N", "008.05E", "315", "IT"],
    ["PIACENZA (IT-AFB", "LIMS", "None", "16084", "44.55N", "009.43E", "138", "IT"],
    ["CISA PASS", "LIMT", "None", "16124", "44.28N", "009.55E", "1040", "IT"],
    ["CAPE MELE", "LIMU", "None", "16153", "43.57N", "008.10E", "221", "IT"],
    ["GIOVI PASS", "LIMV", "None", "16119", "44.33N", "008.55E", "475", "IT"],
    ["AOSTA ARPT", "LIMW", "None", "None", "45.44N", "007.22E", "546", "IT"],
    ["MALANOTTE MOUNTA", "LIMY", "None", "16115", "44.15N", "007.47E", "1742", "IT"],
    ["LEVALDIGI", "LIMZ", "None", "None", "44.32N", "007.37E", "380", "IT"],
    ["AVIANO (IT/US-AF", "LIPA", "None", "16036", "46.01N", "012.35E", "126", "IT"],
    ["BOLZANO(CIV/IT-A", "LIPB", "None", "16020", "46.28N", "011.19E", "241", "IT"],
    ["CERVIA (IT-AFB)", "LIPC", "None", "16148", "44.13N", "012.18E", "10", "IT"],
    ["UDINE/CAMPOFORMI", "LIPD", "None", "16044", "46.01N", "013.10E", "94", "IT"],
    ["BOLOGNA/BORGO (A", "LIPE", "None", "16140", "44.31N", "011.18E", "42", "IT"],
    ["FERRARA (AUT)", "LIPF", "None", "16138", "44.49N", "011.37E", "10", "IT"],
    ["TREVISO(CIV/IT-A", "LIPH", "None", "16099", "45.38N", "012.10E", "23", "IT"],
    ["RIVOLTO (IT-AFB)", "LIPI", "None", "16045", "45.58N", "013.03E", "53", "IT"],
    ["FORLI (CIV/IT-AF", "LIPK", "None", "16147", "44.12N", "012.04E", "32", "IT"],
    ["GHEDI (IT-AFB)", "LIPL", "None", "16088", "45.25N", "010.16E", "92", "IT"],
    ["VERONA/BOSCOMANT", "LIPN", "None", "None", "45.28N", "010.55E", "91", "IT"],
    ["BRESCIA/MONTICHI", "LIPO", "None", "None", "45.25N", "010.20E", "109", "IT"],
    ["DOVA ACC", "LIPP", "None", "None", "45.23N", "011.52E", "14", "IT"],
    ["RONCHI LEGIONARI", "LIPQ", "None", "16108", "45.49N", "013.28E", "12", "IT"],
    ["RIMINI (CIV/IT-A", "LIPR", "None", "16149", "44.01N", "012.37E", "13", "IT"],
    ["ISTRANA (IT-AFB)", "LIPS", "None", "16098", "45.40N", "012.05E", "41", "IT"],
    ["VICENZA(CIV/IT-A", "LIPT", "None", "16094", "45.34N", "011.31E", "53", "IT"],
    ["PADOVA (CIV/IT-A", "LIPU", "None", "16095", "45.23N", "011.50E", "14", "IT"],
    ["VENEZIA/SAN NICO", "LIPV", "None", "None", "45.25N", "012.22E", "4", "IT"],
    ["VILLAFRANCA(CV/M", "LIPX", "None", "16090", "45.23N", "010.52E", "68", "IT"],
    ["FALCONARA (IT-AF", "LIPY", "None", "16191", "43.37N", "013.22E", "10", "IT"],
    ["VENEZIA/TESSERA", "LIPZ", "None", "16105", "45.30N", "012.21E", "6", "IT"],
    ["AREZZO", "LIQB", "None", "16172", "43.28N", "011.50E", "249", "IT"],
    ["CAPRI ISLAND", "LIQC", "None", "16294", "40.33N", "014.12E", "269", "IT"],
    ["PORRETTA PASS", "LIQD", "None", "None", "44.01N", "010.55E", "932", "IT"],
    ["GRAN SASSO MTN R", "LIQI", "None", "None", "42.27N", "013.41E", "2138", "IT"],
    ["CIVITAVECCHIA", "LIQJ", "None", "16214", "42.01N", "011.49E", "4", "IT"],
    ["CAPE PALINURO", "LIQK", "None", "16310", "40.02N", "015.17E", "185", "IT"],
    ["RIETI", "LIQN", "None", "16221", "42.25N", "012.50E", "389", "IT"],
    ["MOUNT ARGENTARIO", "LIQO", "None", "16168", "42.22N", "011.10E", "632", "IT"],
    ["PALMARIA ISLAND", "LIQP", "None", "16129", "44.01N", "009.49E", "192", "IT"],
    ["RADICOFANI", "LIQR", "None", "16204", "42.53N", "011.46E", "918", "IT"],
    ["SIENA", "LIQS", "None", "None", "43.19N", "011.20E", "322", "IT"],
    ["CAPE CIRCEO", "LIQT", "None", "None", "41.13N", "013.03E", "3", "IT"],
    ["VOLTERRA", "LIQV", "None", "16164", "43.24N", "010.52E", "575", "IT"],
    ["SARZANA/LUNI", "LIQW", "None", "16125", "44.04N", "009.58E", "10", "IT"],
    ["PONZA ISLAND", "LIQZ", "None", "16280", "40.55N", "012.56E", "185", "IT"],
    ["CIAMPINO(IT-AFB/", "LIRA", "None", "16239", "41.48N", "012.35E", "101", "IT"],
    ["VIGNA DI VALLE(M", "LIRB", "None", "16224", "42.04N", "012.13E", "270", "IT"],
    ["PRATICA DI MARE(", "LIRE", "None", "16245", "41.38N", "012.25E", "12", "IT"],
    ["ROME/FIUMICINO", "LIRF", "None", "16242", "41.47N", "012.13E", "3", "IT"],
    ["GUIDONIA (IT-AFB", "LIRG", "None", "16234", "42.00N", "012.43E", "89", "IT"],
    ["FROSINONE (IT-AF", "LIRH", "None", "16244", "41.39N", "013.18E", "181", "IT"],
    ["PONTECAGNANO (AF", "LIRI", "None", "None", "40.37N", "014.55E", "40", "IT"],
    ["M. CALAMITA", "LIRJ", "None", "16197", "42.46N", "010.14E", "397", "IT"],
    ["TERMINILLO MOUNT", "LIRK", "None", "16219", "42.28N", "012.58E", "1875", "IT"],
    ["LATINA (IT-AFB)", "LIRL", "None", "16243", "41.32N", "012.54E", "26", "IT"],
    ["GRAZZANISE (IT-A", "LIRM", "None", "16253", "41.02N", "014.04E", "10", "IT"],
    ["NAPLES/CAPODICHI", "LIRN", "None", "16289", "40.53N", "014.18E", "72", "IT"],
    ["PISA (CIV/IT-AFB", "LIRP", "None", "16158", "43.40N", "010.22E", "2", "IT"],
    ["FIRENZE/PERETOLA", "LIRQ", "None", "16170", "43.47N", "011.11E", "38", "IT"],
    ["GROSSETO (IT-AFB", "LIRS", "None", "16206", "42.45N", "011.04E", "7", "IT"],
    ["TREVICO", "LIRT", "None", "16263", "41.02N", "015.13E", "1093", "IT"],
    ["ROME/URBE (IT-AF", "LIRU", "None", "16235", "41.57N", "012.30E", "24", "IT"],
    ["VITERBO (IT-MIL)", "LIRV", "None", "16216", "42.25N", "012.04E", "300", "IT"],
    ["MONTE CALAMITA", "LIRX", "None", "None", "42.44N", "010.23E", "297", "IT"],
    ["PERUGIA", "LIRZ", "None", "16181", "43.06N", "012.30E", "205", "IT"],
    ["CIMONE MOUNTAIN", "LIVC", "None", "16134", "44.12N", "010.41E", "2173", "IT"],
    ["DOBBIACO", "LIVD", "None", "16033", "46.43N", "012.13E", "1226", "IT"],
    ["RESIA PASS", "LIVE", "None", "None", "46.51N", "010.30E", "1800", "IT"],
    ["FRONTONE", "LIVF", "None", "16179", "43.31N", "012.43E", "574", "IT"],
    ["GRAPPA MOUNTAIN", "LIVG", "None", "None", "45.52N", "011.48E", "1775", "IT"],
    ["POINT MARINA/RAV", "LIVM", "None", "16146", "44.27N", "012.18E", "6", "IT"],
    ["TARVISIO", "LIVO", "None", "16040", "46.30N", "013.34E", "778", "IT"],
    ["PAGANELLA MOUNTA", "LIVP", "None", "16022", "46.09N", "011.02E", "2129", "IT"],
    ["ROLLE PASS", "LIVR", "None", "16021", "46.17N", "011.46E", "2006", "IT"],
    ["TRIESTE", "LIVT", "None", "16110", "45.41N", "013.45E", "20", "IT"],
    ["MOUNT VENDA", "LIVV", "None", "None", "45.19N", "011.40E", "575", "IT"],
    ["AVIANO (USAF)", "LIYW", "None", "16037", "46.01N", "012.37E", "126", "IT"],
    ["MILANO ACC/COM", "LIMM", "None", "None", "45.26N", "009.17E", "103", "IT"],
    ["S PIETRO CAPOFIU", "None", "None", "16144", "44.39N", "011.37E", "38", "IT"],
    ["CERKLJE", "LJCE", "None", "14122", "45.54N", "015.31E", "155", "SI"],
    ["LJUBLJANA/BRNIK", "LJLJ", "None", "14014", "46.13N", "014.28E", "385", "SI"],
    ["MARIBOR", "LJMB", "None", "14026", "46.28N", "015.40E", "265", "SI"],
    ["MURSKA SOBOTA", "LJMS", "None", "14031", "46.38N", "016.10E", "188", "SI"],
    ["NOVO MESTO", "LJNM", "None", "14121", "45.47N", "015.10E", "213", "SI"],
    ["PORTOROZ", "LJPZ", "None", "14105", "45.28N", "013.37E", "2", "SI"],
    ["LUUBLUANA", "None", "None", "14015", "46.04N", "014.31E", "316", "SI"],
    ["CASLAV", "LKCV", "None", "None", "49.56N", "015.23E", "242", "CZ"],
    ["HOLESOV", "LKHO", "GTW", "11774", "49.19N", "017.34E", "224", "CZ"],
    ["KBELY", "LKKB", "None", "None", "50.07N", "014.32E", "286", "CZ"],
    ["LIBEREC", "LKLB", "None", "None", "50.46N", "015.01E", "405", "CZ"],
    ["PLZEN LINE", "LKLN", "None", "None", "49.41N", "013.16E", "362", "CZ"],
    ["KUNOVICE", "LKKU", "UHE", "None", "49.03N", "017.27E", "177", "CZ"],
    ["KARLOVY VARY", "LKKV", "KLV", "11414", "50.12N", "012.55E", "604", "CZ"],
    ["OSTRAVA/MOSNOV", "LKMT", "OSR", "11782", "49.40N", "018.07E", "256", "CZ"],
    ["NAMEST", "LKNA", "None", "None", "49.10N", "016.07E", "472", "CZ"],
    ["PARDUBICE", "LKPD", "PED", "None", "50.01N", "015.44E", "226", "CZ"],
    ["PREROV", "LKPO", "PRV", "None", "49.25N", "017.24E", "206", "CZ"],
    ["PRAGUE/RUZYNE", "LKPR", "PRG", "11518", "50.06N", "014.16E", "365", "CZ"],
    ["BRNO/TURANY", "LKTB", "BRQ", "11723", "49.08N", "016.41E", "246", "CZ"],
    ["PRAGUE/LIBUS", "None", "None", "11520", "50.00N", "014.27E", "303", "CZ"],
    ["BRNO REBESOVICE", "None", "None", "11722", "49.05N", "016.37E", "195", "CZ"],
    ["KOSICE", "LKKZ", "None", "None", "48.42N", "021.16E", "232", "CZ"],
    ["PIESTANY", "LKPP", "None", "None", "48.37N", "017.50E", "161", "CZ"],
    ["SLIAC", "LKSL", "None", "None", "48.37N", "019.08E", "318", "CZ"],
    ["MNICHOVO HRADIST", "LKMH", "None", "None", "50.32N", "015.00E", "244", "CZ"],
    ["VODOCHODY", "LKVO", "None", "None", "50.13N", "014.24E", "280", "CZ"],
    ["BRATISLAVA IVANK", "LZIB", "BTS", "11816", "48.10N", "017.13E", "134", "SK"],
    ["LUCENEC AIRPORT", "LZLU", "None", "None", "48.20N", "019.44E", "200", "SK"],
    ["POPRAD/TATRY", "LZTT", "TAT", "11934", "49.04N", "020.15E", "707", "SK"],
    ["KAMENICA NAD CIR", "LZKC", "None", "11993", "48.56N", "021.59E", "177", "SK"],
    ["KOSICE BARCA", "LZKZ", "KSC", "11968", "48.40N", "021.14E", "232", "SK"],
    ["PIESTANY", "LZPP", "PZY", "11826", "48.37N", "017.50E", "161", "SK"],
    ["SLIAC", "LZSL", "SLD", "11903", "48.38N", "019.08E", "313", "SK"],
    ["POPRAD/GANOVCE", "None", "None", "11952", "49.02N", "020.19E", "701", "SK"],
    ["PRIEVIDZA", "LZPE", "None", "None", "48.46N", "018.35E", "260", "SK"],
    ["NITRA", "LZNI", "None", "None", "48.17N", "018.08E", "135", "SK"],
    ["ZILINA", "LZZI", "ILZ", "None", "49.14N", "018.37E", "311", "SK"],
    ["BEN-GURION(CIV/M", "LLBG", "None", "40180", "32.00N", "034.53E", "49", "IL"],
    ["BEER-SHEVA/TEYMA", "LLBS", "None", "40191", "31.17N", "034.43E", "200", "IL"],
    ["ELAT/J. HOZMAN(A", "LLET", "None", "40199", "29.33N", "034.57E", "13", "IL"],
    ["HAIFA (ISR-AFB)", "LLHA", "None", "40155", "32.47N", "035.01E", "8", "IL"],
    ["BEN YA AKOV", "LLIB", "None", "None", "32.59N", "035.34E", "282", "IL"],
    ["JERUSALEM/ATAROT", "LLJR", "None", "40290", "31.52N", "035.13E", "759", "IL"],
    ["OVDA (ISR-AFB/CI", "LLOV", "None", "40198", "29.56N", "034.56E", "432", "IL"],
    ["SDE DOV AIRPORT", "LLSD", "None", "None", "32.07N", "034.47E", "14", "IL"],
    ["LUQA/MALTA", "LMML", "None", "16597", "35.51N", "014.28E", "91", "MT"],
    ["MALTA ACC", "LMMM", "None", "None", "35.53N", "014.31E", "95", "MT"],
    ["KREMS-LANGENLOIS", "LOAG", "None", "None", "48.27N", "015.38E", "312", "AT"],
    ["WR.NEUSTADT EAST", "LOAN", "None", "None", "47.51N", "016.15E", "272", "AT"],
    ["VOESLAU-KOTTINGB", "LOAV", "None", "11181", "47.58N", "016.16E", "233", "AT"],
    ["PUNITZ/GUESSING", "LOGG", "None", "11195", "47.09N", "016.19E", "290", "AT"],
    ["HOHENEMS-DORNBIR", "LOIH", "None", "None", "47.23N", "009.42E", "418", "AT"],
    ["OBEROSTERREICH", "LOLF", "None", "None", "48.31N", "014.25E", "685", "AT"],
    ["GRAZ (MIL/CIV)", "LOWG", "None", "11240", "47.00N", "015.25E", "347", "AT"],
    ["INNSBRUCK AIRPOR", "LOWI", "None", "11120", "47.16N", "011.20E", "581", "AT"],
    ["KLAGENFURT(CIV/M", "LOWK", "None", "11231", "46.39N", "014.19E", "441", "AT"],
    ["LINZ (CIV/MIL)", "LOWL", "None", "11010", "48.13N", "014.11E", "313", "AT"],
    ["SALZBURG AIRPORT", "LOWS", "None", "11150", "47.47N", "013.01E", "450", "AT"],
    ["VIENNA/SCHWECHAT", "LOWW", "None", "11036", "48.07N", "016.34E", "190", "AT"],
    ["ZELL AM SEE", "LOWZ", "None", "None", "47.18N", "012.47E", "754", "AT"],
    ["AIGEN/ENNSTAL (M", "LOXA", "None", "11157", "47.31N", "014.07E", "649", "AT"],
    ["HORSCHING (AUS-A", "LOXL", "None", "11011", "48.13N", "014.10E", "313", "AT"],
    ["WR.NEUSTADT WEST", "LOXN", "None", "11182", "47.50N", "016.13E", "280", "AT"],
    ["SCHWAZ (HELIPORT", "LOXS", "None", "11122", "47.19N", "011.41E", "543", "AT"],
    ["LANGENLEBARN/TUL", "LOXT", "None", "11030", "48.19N", "016.07E", "176", "AT"],
    ["ZELTWEG (MIL)", "LOXZ", "None", "11165", "47.12N", "014.45E", "682", "AT"],
    ["WIEN/HOHE WARTE", "None", "None", "11035", "48.15N", "016.22E", "200", "AT"],
    ["ALVERCA", "LPAR", "None", "08537", "38.53N", "009.02W", "3", "PT"],
    ["SANTA MARIA ISLA", "LPAZ", "None", "08515", "36.58N", "025.10W", "100", "PT"],
    ["BRAGANCA", "LPBG", "None", "08575", "41.51N", "006.42W", "692", "PT"],
    ["BEJA (POR/GER-AF", "LPBJ", "None", "08562", "38.05N", "007.56W", "247", "PT"],
    ["CORVO IS AZORES", "LPCR", "None", "None", "39.40N", "031.07W", "26", "PT"],
    ["CASCAIS", "LPCS", "None", "None", "38.44N", "009.21W", "99", "PT"],
    ["FLORES ISLAND", "LPFL", "None", "08501", "39.27N", "031.07W", "29", "PT"],
    ["FARO", "LPFR", "None", "08554", "37.01N", "007.58W", "4", "PT"],
    ["GRACIOSA IS AZOR", "LPGR", "None", "None", "39.06N", "028.02W", "26", "PT"],
    ["HORTA/FAIAL ISLA", "LPHR", "None", "08505", "38.31N", "028.43W", "41", "PT"],
    ["LAJES AB", "LPLA", "None", "08509", "38.46N", "027.06W", "55", "PT"],
    ["FUNCHAL/MADEIRA", "LPMA", "None", "None", "32.42N", "016.46W", "55", "PT"],
    ["MONTE REAL(POR-A", "LPMR", "None", "08540", "39.49N", "008.52W", "54", "PT"],
    ["MONTIJO (POR-AFB", "LPMT", "None", "08534", "38.42N", "009.03W", "11", "PT"],
    ["OTA (POR-AFB)", "LPOT", "None", "08539", "39.07N", "008.58W", "49", "PT"],
    ["OVAR MIL", "LPOV", "None", "None", "40.55N", "008.39W", "17", "PT"],
    ["PONTA DELGADA/NO", "LPPD", "None", "08512", "37.43N", "025.41W", "72", "PT"],
    ["RPICO IS AZORES", "LPPI", "None", "None", "38.33N", "028.26W", "33", "PT"],
    ["PORTO/PEDRAS RUB", "LPPR", "None", "08545", "41.13N", "008.40W", "73", "PT"],
    ["PORTO SANTO ISLA", "LPPS", "None", "08524", "33.04N", "016.21W", "82", "PT"],
    ["LISBON/PORTELA", "LPPT", "None", "08536", "38.46N", "009.07W", "123", "PT"],
    ["SINTRA/GRANJA (A", "LPST", "None", "08532", "38.49N", "009.19W", "130", "PT"],
    ["TANCOS (POR-AFB)", "LPTN", "None", "08552", "39.28N", "008.25W", "80", "PT"],
    ["VILA REAL", "LPVR", "None", "08567", "41.16N", "007.43W", "562", "PT"],
    ["HORTA", "None", "None", "08506", "38.31N", "028.38W", "62", "PT"],
    ["LAJES/SANTA RITA", "None", "None", "08508", "38.45N", "027.05W", "55", "PT"],
    ["FUNCHAL", "None", "None", "08522", "32.38N", "016.54W", "56", "PT"],
    ["LISBON/GAGO C", "None", "None", "08579", "38.46N", "009.08W", "105", "PT"],
    ["FUNCHAL/MADEIRA", "LPFU", "None", "08521", "32.40N", "016.46W", "55", "PT"],
    ["BANJA LUKA", "LQBK", "None", "None", "44.56N", "017.18E", "122", "CS"],
    ["SARAJEVO/BUTMIR", "LQSA", "None", "13353", "43.49N", "018.19E", "511", "CS"],
    ["TUZLA", "LQTZ", "None", "None", "44.28N", "018.44E", "306", "CS"],
    ["BELGRADE/SURCIN", "LYBE", "None", "13272", "44.49N", "020.17E", "99", "CS"],
    ["BATAJNICA", "LYBT", "None", "None", "44.56N", "020.15E", "80", "CS"],
    ["KRALJEVO", "LYKV", "None", "None", "43.49N", "020.35E", "209", "CS"],
    ["MOSTAR", "LYMO", "None", "13348", "43.21N", "017.48E", "108", "CS"],
    ["NIS", "LYNI", "None", "13388", "43.19N", "021.53E", "202", "CS"],
    ["PODGORICA(TITOGR", "LYPG", "None", "None", "42.22N", "019.15E", "43", "CS"],
    ["UZICE-PONIKVE", "LYUZ", "None", "None", "43.54N", "019.42E", "904", "CS"],
    ["PRISHTINA", "BKPR", "None", "13481", "42.35N", "021.02E", "576", "CS"],
    ["TITOGRAD/GOLUBOV", "LYTI", "None", "13462", "42.22N", "019.15E", "33", "CS"],
    ["TIVAT", "LYTV", "None", "13457", "42.23N", "018.43E", "5", "CS"],
    ["VRSAC", "LYVR", "None", "13183", "45.08N", "021.19E", "85", "CS"],
    ["OHRID", "LYOH", "None", "None", "41.07N", "020.48E", "761", "CS"],
    ["BEOGRAD KOSUTNJA", "None", "None", "13275", "44.47N", "020.32E", "243", "CS"],
    ["PRISHTINA", "LYPR", "None", "None", "42.35N", "021.02E", "546", "CS"],
    ["MOSTAR AIRPORT", "LQMO", "None", "None", "43.17N", "017.50E", "48", "BA"],
    ["ARAD", "LRAR", "None", "15200", "46.11N", "021.16E", "118", "RO"],
    ["BACAU", "LRBC", "None", "15150", "46.31N", "026.55E", "185", "RO"],
    ["BAIA MARE", "LRBM", "None", "15014", "47.40N", "023.28E", "185", "RO"],
    ["BUCHAREST/BANEAS", "LRBS", "None", "15420", "44.30N", "026.05E", "91", "RO"],
    ["KOGALNICEANU", "LRCK", "None", "15481", "44.22N", "028.29E", "108", "RO"],
    ["CLUJ-NAPOCA/SOME", "LRCL", "None", "15120", "46.47N", "023.41E", "413", "RO"],
    ["CARANSEBES", "LRCS", "None", "15292", "45.25N", "022.15E", "242", "RO"],
    ["CAMPIA TURZII", "LRCT", "None", "None", "46.30N", "023.53E", "331", "RO"],
    ["CRAIOVA", "LRCV", "None", "15450", "44.19N", "023.52E", "191", "RO"],
    ["IASI", "LRIA", "None", "15090", "47.10N", "027.37E", "104", "RO"],
    ["ORADEA", "LROD", "None", "15080", "47.02N", "021.55E", "140", "RO"],
    ["BUCHAREST/OTOPEN", "LROP", "None", "15421", "44.34N", "026.06E", "95", "RO"],
    ["SIBIU/TURNISOR", "LRSB", "None", "15260", "45.47N", "024.05E", "444", "RO"],
    ["SATU MARE", "LRSM", "None", "15010", "47.42N", "022.53E", "124", "RO"],
    ["SUCEAVA/SALCEA", "LRSV", "None", "15023", "47.41N", "026.21E", "351", "RO"],
    ["TULCEA", "LRTC", "None", "15335", "45.04N", "028.43E", "6", "RO"],
    ["TIGU MURES/VIDRA", "LRTM", "None", "15145", "46.28N", "024.25E", "309", "RO"],
    ["TIMISOARA/GIARMA", "LRTR", "None", "15247", "45.49N", "021.20E", "88", "RO"],
    ["AVRAMENI", "None", "None", "15001", "48.01N", "026.57E", "240", "RO"],
    ["CONSTANTA", "None", "None", "15480", "44.11N", "028.40E", "17", "RO"],
    ["LES EPLATURES", "LSGC", "None", "None", "47.05N", "006.48E", "1027", "CH"],
    ["GENEVA/COINTRIN", "LSGG", "None", "06700", "46.15N", "006.07E", "416", "CH"],
    ["LAUSANNE/BLECHER", "LSGL", "None", "06710", "46.32N", "006.37E", "615", "CH"],
    ["NEUCHATEL (AUT)", "LSGN", "None", "06604", "46.57N", "006.52E", "487", "CH"],
    ["SION (MIL/CIV/AU", "LSGS", "None", "06720", "46.13N", "007.19E", "481", "CH"],
    ["ALPNACH", "LSMA", "None", "None", "46.57N", "008.17E", "444", "CH"],
    ["DUBENDORF", "LSMD", "None", "None", "47.24N", "008.39E", "448", "CH"],
    ["EMMEN", "LSME", "None", "None", "47.06N", "008.18E", "427", "CH"],
    ["MEIRINGEN", "LSMM", "None", "None", "46.45N", "008.07E", "577", "CH"],
    ["PAYERNE (MIL/AUT", "LSMP", "None", "06610", "46.49N", "006.55E", "491", "CH"],
    ["SION (MIL)", "LSMS", "None", "None", "46.13N", "007.19E", "481", "CH"],
    ["LUGANO (PVT/AUT)", "LSZA", "None", "06770", "46.00N", "008.55E", "276", "CH"],
    ["BERN/BELP", "LSZB", "None", "None", "46.55N", "007.30E", "505", "CH"],
    ["BUOCHS", "LSZC", "None", "None", "46.58N", "008.23E", "450", "CH"],
    ["GRENCHEN", "LSZG", "None", "06632", "47.10N", "007.25E", "430", "CH"],
    ["ZURICH-KLOTEN (A", "LSZH", "None", "06670", "47.29N", "008.32E", "432", "CH"],
    ["LOCARNO", "LSZL", "None", "None", "46.10N", "008.53E", "600", "CH"],
    ["LOCARNO/ASCONA", "LSZD", "None", "None", "46.09N", "008.47E", "600", "CH"],
    ["RHEINECK/ALTENRH", "LSZR", "None", "06690", "47.29N", "009.34E", "398", "CH"],
    ["SAMEDAN", "LSZS", "None", "06792", "46.32N", "009.53E", "1706", "CH"],
    ["ANKARA/GUVERCIN", "LTAB", "None", "None", "39.55N", "032.45E", "819", "TR"],
    ["ANKARA/ESENBOGA", "LTAC", "None", "17128", "40.07N", "032.58E", "949", "TR"],
    ["ANKARA/ETIMESGUT", "LTAD", "None", "17129", "39.57N", "032.40E", "806", "TR"],
    ["MURTED (TUR-AFB)", "LTAE", "None", "17120", "40.04N", "032.34E", "843", "TR"],
    ["ADANA/SAKIRPASA", "LTAF", "None", "17352", "36.58N", "035.17E", "20", "TR"],
    ["ADANA/INCIRLIK A", "LTAG", "None", "17350", "37.00N", "035.25E", "66", "TR"],
    ["AFYON (MIL)", "LTAH", "None", "17190", "38.45N", "030.31E", "1034", "TR"],
    ["ANTALYA (CIV/MIL", "LTAI", "None", "17300", "36.54N", "030.48E", "54", "TR"],
    ["GAZIANTEP", "LTAJ", "None", "17260", "36.57N", "037.29E", "855", "TR"],
    ["ISKENDERUN", "LTAK", "None", "17370", "36.34N", "036.10E", "3", "TR"],
    ["KASTAMONU", "LTAL", "None", "17074", "41.19N", "033.48E", "1066", "TR"],
    ["KAYSERI (CITY)", "LTAM", "None", "None", "38.43N", "035.30E", "1043", "TR"],
    ["KONYA (TUR-AFB)", "LTAN", "None", "17244", "37.58N", "032.32E", "1006", "TR"],
    ["MERZIFON (TUR-AF", "LTAP", "None", "17082", "40.50N", "035.31E", "535", "TR"],
    ["SAMSUN AIRPORT", "LTAQ", "None", "17029", "41.16N", "036.17E", "168", "TR"],
    ["SIVAS (CIV/MIL)", "LTAR", "None", "17090", "39.48N", "036.54E", "1271", "TR"],
    ["ZONGULDAK", "LTAS", "None", "17022", "41.31N", "032.05E", "136", "TR"],
    ["MALATYA/ERHAC (A", "LTAT", "None", "17200", "38.25N", "038.04E", "849", "TR"],
    ["KAYSERI/ERKILET", "LTAU", "None", "17195", "38.46N", "035.28E", "1054", "TR"],
    ["SIVRIHISAR", "LTAV", "None", "None", "39.27N", "031.21E", "96", "TR"],
    ["TOKAT", "LTAW", "None", "17086", "40.17N", "036.22E", "608", "TR"],
    ["CARDAK", "LTAY", "None", "None", "37.46N", "029.41E", "849", "TR"],
    ["NEVSEHIR", "LTAZ", "None", "None", "38.46N", "034.33E", "945", "TR"],
    ["ISTANBUL/ATATURK", "LTBA", "None", "17060", "40.58N", "028.49E", "37", "TR"],
    ["AYDIN", "LTBD", "None", "17234", "37.51N", "027.51E", "57", "TR"],
    ["BURSA", "LTBE", "None", "17116", "40.10N", "029.04E", "100", "TR"],
    ["BALIKESIR (TUR-A", "LTBF", "None", "17150", "39.37N", "027.55E", "102", "TR"],
    ["BANDIRMA (CIV/AF", "LTBG", "None", "17115", "40.19N", "027.58E", "49", "TR"],
    ["CANAKKALE", "LTBH", "None", "17112", "40.08N", "026.25E", "3", "TR"],
    ["ESKISEHIR (TUR-A", "LTBI", "None", "17124", "39.46N", "030.34E", "785", "TR"],
    ["IZMIR/ADNAN MEND", "LTBJ", "None", "17219", "38.17N", "027.09E", "120", "TR"],
    ["IZMIR/CIGLI(CV/A", "LTBL", "None", "17218", "38.30N", "027.01E", "5", "TR"],
    ["ISPARTA", "LTBM", "None", "17240", "37.45N", "030.33E", "997", "TR"],
    ["KUTAHYA (TUR-AFB", "LTBN", "None", "None", "39.25N", "030.01E", "921", "TR"],
    ["USAK", "LTBO", "None", "17188", "38.40N", "029.28E", "919", "TR"],
    ["TOPEL (TUR-AFB)", "LTBQ", "None", "None", "40.43N", "030.04E", "50", "TR"],
    ["YENISEHIR AB", "LTBR", "None", "None", "40.15N", "029.34E", "232", "TR"],
    ["DALAMAN (COMMUNE", "LTBS", "None", "17295", "36.42N", "028.46E", "2", "TR"],
    ["AKHISAR (TUR-AFB", "LTBT", "None", "17184", "38.55N", "027.51E", "93", "TR"],
    ["CORLU", "LTBU", "None", "None", "41.07N", "027.55E", "173", "TR"],
    ["ANADOLU", "LTBY", "None", "None", "39.49N", "030.31E", "789", "TR"],
    ["MARISA", "LTBZ", "None", "None", "38.38N", "027.21E", "73", "TR"],
    ["ELAZIG (CIV/MIL)", "LTCA", "None", "17202", "38.36N", "039.16E", "882", "TR"],
    ["AGRI", "LTCB", "None", "17099", "39.43N", "043.02E", "1632", "TR"],
    ["DIYARBAKIR(CIV/A", "LTCC", "None", "17280", "37.52N", "040.12E", "677", "TR"],
    ["ERZINCAN", "LTCD", "None", "17092", "39.43N", "039.30E", "1215", "TR"],
    ["ERZURUM (CIV/MIL", "LTCE", "None", "17096", "39.57N", "041.10E", "1758", "TR"],
    ["KARS", "LTCF", "None", "17098", "40.34N", "043.07E", "1795", "TR"],
    ["TRABZON", "LTCG", "None", "17038", "41.00N", "039.48E", "30", "TR"],
    ["URFA/SANILURFA", "LTCH", "None", "17270", "37.07N", "038.46E", "547", "TR"],
    ["VAN", "LTCI", "None", "17170", "38.27N", "043.19E", "1661", "TR"],
    ["BATMAN (TUR-AFB)", "LTCJ", "None", "17282", "37.56N", "041.07E", "540", "TR"],
    ["MUS (TUR-AFB)", "LTCK", "None", "None", "38.45N", "041.40E", "1266", "TR"],
    ["SIIRT AIRPORT", "LTCL", "None", "None", "37.59N", "041.50E", "610", "TR"],
    ["SINOP AIRPORT", "LTCM", "None", "None", "42.01N", "035.04E", "8", "TR"],
    ["KAHRAMANMARAS", "LTCN", "None", "None", "37.32N", "036.57E", "526", "TR"],
    ["AGRI AIRPORT", "LTCO", "None", "None", "39.39N", "043.02E", "1665", "TR"],
    ["ADIYAMAN ARPT", "LTCP", "None", "None", "37.44N", "038.28E", "676", "TR"],
    ["MARDIN AIRPORT", "LTCR", "None", "None", "37.13N", "040.38E", "527", "TR"],
    ["SANLIURFA GAP", "LTCS", "None", "None", "37.27N", "038.54E", "825", "TR"],
    ["IGDIR", "LTCT", "None", "None", "39.59N", "043.52E", "946", "TR"],
    ["BINGOL", "LTCU", "None", "None", "38.52N", "040.35E", "1061", "TR"],
    ["SIRNAK", "LTCV", "None", "None", "37.22N", "042.04E", "621", "TR"],
    ["YUKSEKOVA", "LTCW", "None", "None", "37.33N", "044.14E", "1856", "TR"],
    ["HATAY AIRPORT", "LTDA", "None", "None", "36.22N", "036.17E", "82", "TR"],
    ["SULEYMAN DEMIREL", "LTFC", "ISE", "None", "37.52N", "030.23E", "864", "TR"],
    ["BALIKESIR KORFEZ", "LTFD", "None", "None", "39.33N", "027.01E", "16", "TR"],
    ["BODRUM MILAS", "LTFE", "None", "17290", "37.15N", "027.40E", "6", "TR"],
    ["GAZIPASA", "LTFG", "None", "None", "36.18N", "032.18E", "95", "TR"],
    ["CARSAMBA", "LTFH", "None", "None", "41.16N", "036.33E", "5", "TR"],
    ["SABIHA GOKCEN", "LTFJ", "None", "None", "40.54N", "029.18E", "98", "TR"],
    ["GOKCEADA", "LTFK", "None", "None", "40.12N", "025.53E", "21", "TR"],
    ["SAMSUN CITY", "None", "None", "17030", "41.17N", "036.20E", "4", "TR"],
    ["ISTANBUL/GOZTEPE", "None", "None", "17062", "40.58N", "029.05E", "33", "TR"],
    ["GOLCUK/DUMLUPINA", "None", "None", "17067", "40.43N", "029.49E", "18", "TR"],
    ["CENGIZTOPEL", "None", "None", "17068", "40.44N", "030.05E", "70", "TR"],
    ["ANKARA/CENTRAL", "None", "None", "17130", "39.57N", "032.53E", "894", "TR"],
    ["IZMIR", "None", "None", "17220", "38.26N", "027.10E", "25", "TR"],
    ["ADANA", "None", "None", "17351", "37.03N", "035.21E", "28", "TR"],
    ["CHISINAU INTL", "LUKK", "None", "None", "46.56N", "028.56E", "122", "MD"],
    ["CHISINAU", "UKII", "None", "33815", "47.01N", "028.52E", "180", "MD"],
    ["BALTI INTL ARPT", "LUBL", "None", "None", "47.50N", "027.47E", "232", "MD"],
    ["MARCULESTI", "LUBM", "None", "None", "47.52N", "028.13E", "95", "MD"],
    ["CAHUL INTL", "LUCH", "None", "None", "45.51N", "028.16E", "199", "MD"],
    ["SKOPJE/PETROVAC", "LWSK", "None", "13586", "41.58N", "021.38E", "239", "MK"],
    ["OHRID", "LWOH", "None", "13578", "41.11N", "020.45E", "761", "MK"],
    ["GIBRALTAR (CIV/M", "LXGB", "None", "08495", "36.08N", "005.20W", "5", "GI"],
    ["BOUGOUNI", "GABG", "None", "61296", "11.25N", "007.30W", "351", "ML"],
    ["BAMAKO/SENOU (MI", "GABS", "None", "61291", "12.31N", "007.57W", "381", "ML"],
    ["SHIP C7L/ROMEO", "GACA", "None", "99023", "47.00N", "017.00W", "0", "ML"],
    ["GAO (CIV/MIL)", "GAGO", "None", "61226", "16.16N", "000.03W", "260", "ML"],
    ["HOMBORI", "GAHB", "None", "61240", "15.19N", "001.40W", "288", "ML"],
    ["KENIEBA", "GAKA", "None", "61285", "12.50N", "011.13W", "132", "ML"],
    ["KIDAL", "GAKL", "None", "61214", "18.25N", "001.21E", "459", "ML"],
    ["KOUTIALA", "GAKO", "None", "61293", "12.22N", "005.28W", "367", "ML"],
    ["KITA", "GAKT", "None", "61270", "13.04N", "009.28W", "334", "ML"],
    ["KAYES", "GAKY", "None", "61257", "14.25N", "011.25W", "47", "ML"],
    ["MOPTI/BARBE (MIL", "GAMB", "None", "61265", "14.31N", "004.05W", "272", "ML"],
    ["MENAKA", "GAMK", "None", "61250", "15.52N", "002.13E", "278", "ML"],
    ["NARA/KEIBANE", "GANK", "None", "61233", "15.10N", "007.16W", "265", "ML"],
    ["NIORO DU SAHEL", "GANR", "None", "61230", "15.13N", "009.20W", "237", "ML"],
    ["SEGOU", "GASG", "None", "61272", "13.24N", "006.09W", "289", "ML"],
    ["SIKASSO", "GASK", "None", "61297", "11.20N", "005.40W", "375", "ML"],
    ["SAN", "GASN", "None", "61277", "13.19N", "004.49W", "284", "ML"],
    ["TOMBOUCTOU/TIMBU", "GATB", "None", "61223", "16.43N", "003.00W", "264", "ML"],
    ["TESSALIT", "GATS", "None", "61202", "20.11N", "000.58E", "491", "ML"],
    ["YELIMANE", "GAYE", "None", "None", "15.08N", "010.34W", "99", "ML"],
    ["BANJUL/YUNDUM IN", "GBYD", "None", "61701", "13.20N", "016.39W", "36", "GM"],
    ["BONTHE", "GFBN", "None", "61866", "07.31N", "012.30W", "8", "SL"],
    ["BO", "GFBO", "None", "61881", "07.57N", "011.46W", "93", "SL"],
    ["KABALA", "GFKB", "None", "61886", "09.34N", "011.33W", "464", "SL"],
    ["FREETOWN/LUNGI", "GFLL", "None", "61856", "08.37N", "013.11W", "27", "SL"],
    ["BAFATA", "GGBF", "None", "61781", "12.10N", "014.40W", "43", "GW"],
    ["BOLAMA", "GGBO", "None", "61769", "11.34N", "015.28W", "20", "GW"],
    ["BISSAU (CIV/MIL)", "GGOV", "None", "61766", "11.52N", "015.39W", "36", "GW"],
    ["CONAKRY/GBESSIA", "GUCY", "None", "61832", "09.34N", "013.37W", "26", "GN"],
    ["FARANAH/BADALA", "GUFH", "None", "61833", "10.01N", "010.45W", "459", "GN"],
    ["KINDIA", "GUID", "None", "61818", "10.03N", "012.52W", "459", "GN"],
    ["KISSIDOUGOU", "GUKU", "None", "61834", "09.10N", "010.05W", "525", "GN"],
    ["LABE/TATA", "GULB", "None", "61809", "11.19N", "012.18W", "1026", "GN"],
    ["MACENTA", "GUMA", "None", "61847", "08.31N", "009.28W", "544", "GN"],
    ["N'ZEREKORE/KONIA", "GUNZ", "None", "61849", "07.43N", "008.49W", "470", "GN"],
    ["BOKE/BARALANDE", "GUOK", "None", "61816", "10.55N", "014.19W", "69", "GN"],
    ["SIGUIRI", "GUSI", "None", "61811", "11.25N", "009.10W", "366", "GN"],
    ["KANKAN/DIANKANA", "GUXD", "None", "61829", "10.22N", "009.18W", "384", "GN"],
    ["SPRIGGS PAYNE/MO", "GLMR", "None", "65602", "06.19N", "010.45W", "12", "LR"],
    ["ROBERTS INTL/MON", "GLRB", "None", "65660", "06.15N", "010.20W", "18", "LR"],
    ["AGADIR/INEZGANE", "GMAA", "None", "60250", "30.22N", "009.34W", "23", "MA"],
    ["AL MASSIRA MC", "GMAD", "None", "60252", "30.19N", "009.25W", "74", "MA"],
    ["GUELMIM", "GMAG", "None", "None", "29.02N", "010.03W", "333", "MA"],
    ["TAN-TAN (CIV/MIL", "GMAT", "None", "60285", "28.26N", "011.09W", "200", "MA"],
    ["ZAGORA", "GMAZ", "None", "60275", "30.19N", "005.52W", "729", "MA"],
    ["FES-SAIS", "GMFF", "None", "60141", "33.55N", "004.58W", "579", "MA"],
    ["IFRANE AIRPORT", "GMFI", "None", "60160", "33.30N", "005.10W", "1665", "MA"],
    ["ER-RACHIDIA (RMA", "GMFK", "None", "60210", "31.57N", "004.24W", "1045", "MA"],
    ["MEKNES/BASSATINE", "GMFM", "None", "60150", "33.52N", "005.31W", "549", "MA"],
    ["TAOUIMA/NADOR", "GMFN", "None", "60340", "35.08N", "002.55W", "16", "MA"],
    ["OUJDA/ANGADS", "GMFO", "None", "60115", "34.46N", "001.55W", "470", "MA"],
    ["TAZA", "GMFZ", "None", "60127", "34.13N", "004.00W", "510", "MA"],
    ["CASABLANCA/ANFA", "GMMC", "None", "60155", "33.34N", "007.40W", "62", "MA"],
    ["RABAT/SALE (RMAF", "GMME", "None", "60135", "34.02N", "006.46W", "75", "MA"],
    ["SIDI IFNI", "GMMF", "None", "60060", "29.22N", "010.10W", "66", "MA"],
    ["ESSAOUIRA", "GMMI", "None", "60220", "31.31N", "009.46W", "8", "MA"],
    ["LAAYOUNE/HASSAN", "GMML", "None", "None", "27.08N", "013.14W", "6", "MA"],
    ["NOUASSEUR/CASABL", "GMMN", "None", "60156", "33.22N", "007.34W", "206", "MA"],
    ["SAFI", "GMMS", "None", "60185", "32.16N", "009.13W", "45", "MA"],
    ["CASABLANCA T-M", "GMMT", "None", "None", "33.36N", "007.28W", "96", "MA"],
    ["ARWI", "GMMW", "None", "None", "34.59N", "003.01W", "175", "MA"],
    ["MARRAKECH/MENARA", "GMMX", "None", "60230", "31.37N", "008.01W", "466", "MA"],
    ["KENITRA/TOURISME", "GMMY", "None", "60120", "34.17N", "006.35W", "14", "MA"],
    ["OUARZAZATE", "GMMZ", "None", "60265", "30.55N", "006.54W", "1140", "MA"],
    ["SIDI SLIMANE", "GMSL", "None", "60136", "34.13N", "006.02W", "52", "MA"],
    ["AL HOCEIMA/COTE", "GMTA", "None", "60107", "35.10N", "003.51W", "14", "MA"],
    ["SANIA RAMEL/TETO", "GMTN", "None", "60318", "35.34N", "005.19W", "10", "MA"],
    ["TANGIER/BOUKHALF", "GMTT", "None", "60101", "35.43N", "005.54W", "21", "MA"],
    ["DAKHLA AIRPORT", "GMMH", "None", "None", "23.43N", "015.56W", "11", "MA"],
    ["ZIGUINCHOR", "GOGG", "None", "61695", "12.33N", "016.16W", "23", "SN"],
    ["KOLDA", "GOGK", "None", "61698", "12.54N", "014.58W", "10", "SN"],
    ["CAPE SKIRING", "GOGS", "None", "61697", "12.24N", "016.45W", "13", "SN"],
    ["DIOURBEL", "GOOD", "None", "61666", "14.39N", "016.13W", "9", "SN"],
    ["LINGUERE", "GOOG", "None", "61627", "15.24N", "015.05W", "21", "SN"],
    ["KAOLACK", "GOOK", "None", "61679", "14.09N", "016.04W", "7", "SN"],
    ["DAKAR/YOFF", "GOOY", "None", "61641", "14.43N", "017.30W", "24", "SN"],
    ["MATAM/OURO SOGUI", "GOSM", "None", "61630", "15.36N", "013.20W", "17", "SN"],
    ["PODOR", "GOSP", "None", "61612", "16.41N", "014.58W", "7", "SN"],
    ["SAINT LOUIS", "GOSS", "None", "61600", "16.03N", "016.26W", "4", "SN"],
    ["KEDOUGOU", "GOTK", "None", "61699", "12.34N", "012.13W", "167", "SN"],
    ["SIMENTI", "GOTS", "None", "None", "13.03N", "013.18W", "52", "SN"],
    ["TAMBACOUNDA", "GOTT", "None", "61687", "13.44N", "013.39W", "50", "SN"],
    ["AIOUN EL ATROUSS", "GQNA", "None", "61499", "16.41N", "009.35W", "223", "MR"],
    ["BOUTILIMIT", "GQNB", "None", "61461", "17.31N", "014.40W", "75", "MR"],
    ["TIDJIKJA", "GQND", "None", "61450", "18.34N", "011.25W", "402", "MR"],
    ["KIFFA", "GQNF", "None", "61498", "16.37N", "011.24W", "115", "MR"],
    ["NEMA", "GQNI", "None", "61497", "16.36N", "007.16W", "269", "MR"],
    ["AKJOUJT", "GQNJ", "None", "61437", "19.45N", "014.22W", "120", "MR"],
    ["KAEDI", "GQNK", "None", "61492", "16.08N", "013.31W", "18", "MR"],
    ["NOUAKCHOTT", "GQNN", "None", "61442", "18.06N", "015.56W", "3", "MR"],
    ["NOUAKCHOTT/OUMTO", "GQNO", "None", "None", "18.18N", "015.58W", "4", "MR"],
    ["ROSSO", "GQNR", "None", "61489", "16.30N", "015.49W", "6", "MR"],
    ["ATAR", "GQPA", "None", "61421", "20.31N", "013.04W", "224", "MR"],
    ["NOUADHIBOU", "GQPP", "None", "61415", "20.55N", "017.01W", "3", "MR"],
    ["BIR MOGHREIN (MI", "GQPT", "None", "61401", "25.13N", "011.37W", "360", "MR"],
    ["EL AAIUN", "GSAI", "None", "60033", "27.08N", "013.11W", "63", "EH"],
    ["VILLA CISNEROS(M", "GSVO", "None", "60096", "23.41N", "015.52W", "10", "EH"],
    ["SAL ISL/AMILCAR", "GVAC", "None", "08594", "16.43N", "022.56W", "55", "CV"],
    ["RABIL AIRPORT", "GVBA", "None", "None", "16.08N", "022.53W", "22", "CV"],
    ["PRAIA INTL", "GVNP", "None", "None", "14.57N", "023.29W", "70", "CV"],
    ["FRANCISCO MENDES", "GVFM", "RAI", "None", "14.55N", "023.30W", "70", "CV"],
    ["S. PEDRO", "GVSV", "VXE", "None", "16.50N", "025.40W", "20", "CV"],
    ["BOU-SAADA", "DAAD", "None", "60515", "35.19N", "004.12E", "461", "DZ"],
    ["BEJAIA/SOUMMAM", "DAAE", "None", "60402", "36.43N", "005.04E", "2", "DZ"],
    ["AOULEF", "DAAF", "None", "None", "26.58N", "001.04E", "309", "DZ"],
    ["DAR-EL-BEIDA/HOU", "DAAG", "None", "60390", "36.43N", "003.13E", "25", "DZ"],
    ["DJANET/TISKA", "DAAJ", "None", "60670", "24.17N", "009.28E", "968", "DZ"],
    ["ILLIZI/ILLIRANE", "DAAP", "None", "60640", "26.43N", "008.37E", "558", "DZ"],
    ["SETIF/AIN-ARNAT", "DAAS", "None", "60445", "36.11N", "005.20E", "1038", "DZ"],
    ["TAMANRASSET/AGUE", "DAAT", "None", "None", "22.49N", "005.28E", "1377", "DZ"],
    ["JIJEL/TAHER", "DAAV", "None", "60351", "36.48N", "005.53E", "11", "DZ"],
    ["BORDJ OMAR DRISS", "DAAW", "None", "None", "28.07N", "006.49E", "387", "DZ"],
    ["MECHERIA", "DAAY", "None", "60549", "33.32N", "000.15W", "1149", "DZ"],
    ["ANNABA/EL MELLAH", "DABB", "None", "60360", "36.49N", "007.49E", "4", "DZ"],
    ["CONSTANTINE/EL B", "DABC", "None", "60419", "36.16N", "006.37E", "694", "DZ"],
    ["SKIKDA", "DABP", "None", "60355", "36.55N", "006.57E", "7", "DZ"],
    ["TEBESSA", "DABS", "None", "60475", "35.26N", "008.07E", "813", "DZ"],
    ["BATNA", "DABT", "None", "60468", "35.45N", "006.19E", "1052", "DZ"],
    ["TINFOUYE", "DAEF", "None", "None", "28.26N", "007.33E", "472", "DZ"],
    ["RHOURD NOUSS", "DAEN", "None", "None", "29.44N", "006.43E", "252", "DZ"],
    ["TILREMPT/HASSI", "DAFH", "None", "None", "32.56N", "003.19E", "774", "DZ"],
    ["DJELFA/TLETSI", "DAFI", "None", "60535", "34.40N", "003.15E", "1144", "DZ"],
    ["TIARET", "DAOB", "None", "60511", "35.20N", "001.28E", "989", "DZ"],
    ["TINDOUF", "DAOF", "None", "60656", "27.42N", "008.10W", "431", "DZ"],
    ["CHLEF", "DAOI", "None", "60425", "36.13N", "001.19E", "143", "DZ"],
    ["ORAN/TAFAROUI", "DAOL", "None", "None", "35.32N", "000.31W", "112", "DZ"],
    ["MASCARA", "DAOM", "None", "None", "35.23N", "000.08W", "492", "DZ"],
    ["TLEMCEN/ZENATA", "DAON", "None", "60531", "35.01N", "001.28W", "247", "DZ"],
    ["ORAN/ES SENIA", "DAOO", "None", "60490", "35.37N", "000.36W", "90", "DZ"],
    ["BECHAR/OUAKDA", "DAOR", "None", "60571", "31.39N", "002.16W", "773", "DZ"],
    ["MASCARA/GHRISS", "DAOV", "None", "60507", "35.12N", "000.09E", "514", "DZ"],
    ["IN GUEZZAM", "DATG", "None", "None", "19.34N", "005.45E", "399", "DZ"],
    ["BORDJ MOKHTAR", "DATM", "None", "None", "21.23N", "000.55E", "396", "DZ"],
    ["ADRAR/TOUAT", "DAUA", "None", "60620", "27.50N", "000.11W", "263", "DZ"],
    ["BISKRA", "DAUB", "None", "60525", "34.47N", "005.43E", "87", "DZ"],
    ["EL GOLEA", "DAUE", "None", "60590", "30.34N", "002.52E", "397", "DZ"],
    ["GHARDAIA/NOUMERA", "DAUG", "None", "60566", "32.22N", "003.49E", "450", "DZ"],
    ["HASSI-MESSAOUD/I", "DAUH", "None", "60581", "31.40N", "006.09E", "142", "DZ"],
    ["IN SALAH NORTH", "DAUI", "None", "None", "27.15N", "002.31E", "269", "DZ"],
    ["TOUGGOURT/SIDI M", "DAUK", "None", "60555", "33.05N", "006.07E", "85", "DZ"],
    ["LAGHOUAT", "DAUL", "None", "60545", "33.46N", "002.55E", "765", "DZ"],
    ["EL OUED/GUEMER", "DAUO", "None", "60559", "33.30N", "006.47E", "63", "DZ"],
    ["TIMIMOUN", "DAUT", "None", "60607", "29.15N", "000.16E", "312", "DZ"],
    ["OUARGLA", "DAUU", "None", "60580", "31.55N", "005.24E", "141", "DZ"],
    ["IN AMENAS/ZARZAI", "DAUZ", "None", "60611", "28.03N", "009.37E", "562", "DZ"],
    ["COTONOU/CADJEHOU", "DBBB", "None", "65344", "06.20N", "002.22E", "9", "BJ"],
    ["BOHICON/CANA", "DBBC", "None", "65338", "07.10N", "002.04E", "167", "BJ"],
    ["KANDI", "DBBK", "None", "65306", "11.07N", "002.55E", "292", "BJ"],
    ["NATITINGOU", "DBBN", "None", "65319", "10.19N", "001.22E", "461", "BJ"],
    ["PARAKOU", "DBBP", "None", "65330", "09.20N", "002.37E", "393", "BJ"],
    ["SAVE", "DBBS", "None", "65335", "08.01N", "002.28E", "200", "BJ"],
    ["OUAHIGOUYA", "DFCC", "None", "65502", "13.34N", "002.25W", "336", "BF"],
    ["BOROMO", "DFCO", "None", "65516", "11.45N", "002.55W", "271", "BF"],
    ["PO", "DFCP", "None", "65518", "11.09N", "001.08W", "322", "BF"],
    ["DORI", "DFEE", "None", "65501", "14.01N", "000.01W", "277", "BF"],
    ["FADA N'GOURMA", "DFEF", "None", "65507", "12.01N", "000.22E", "309", "BF"],
    ["OUAGADOUGOU (MIL", "DFFD", "None", "65503", "12.20N", "001.31W", "306", "BF"],
    ["DEDOUGOU", "DFOD", "None", "65505", "12.28N", "003.28W", "300", "BF"],
    ["GAOUA", "DFOG", "None", "65522", "10.19N", "003.10W", "335", "BF"],
    ["BOBO-DIOULASSO", "DFOO", "None", "65510", "11.10N", "004.19W", "460", "BF"],
    ["ACCRA/KOTOKA INT", "DGAA", "None", "65472", "05.35N", "000.10W", "69", "GH"],
    ["ADA", "DGAD", "None", "65475", "05.46N", "000.37E", "7", "GH"],
    ["HO", "DGAH", "None", "65453", "06.35N", "000.28E", "158", "GH"],
    ["AKUSE", "DGAK", "None", "65460", "06.05N", "000.07E", "19", "GH"],
    ["SALTPOND", "DGAS", "None", "65469", "05.12N", "001.04W", "47", "GH"],
    ["TEMA", "DGAT", "None", "65473", "05.37N", "000.00E", "18", "GH"],
    ["AKIM ODA", "DGKA", "None", "65457", "05.55N", "000.58W", "140", "GH"],
    ["KOFORIDUA", "DGKK", "None", "65459", "06.04N", "000.15W", "167", "GH"],
    ["BOLE", "DGLB", "None", "65416", "09.01N", "002.28W", "301", "GH"],
    ["TAMALE (AFB/CIV)", "DGLE", "None", "65418", "09.30N", "000.51W", "173", "GH"],
    ["NAVRONGO", "DGLN", "None", "65401", "10.54N", "001.06W", "203", "GH"],
    ["WA", "DGLW", "None", "65404", "10.03N", "002.30W", "323", "GH"],
    ["YENDI", "DGLY", "None", "65420", "09.26N", "000.01W", "197", "GH"],
    ["SEFWI BEKWAI", "DGSB", "None", "65445", "06.12N", "002.19W", "172", "GH"],
    ["KUMASI", "DGSI", "None", "65442", "06.43N", "001.36W", "293", "GH"],
    ["SUNYANI", "DGSN", "None", "65439", "07.19N", "002.19W", "312", "GH"],
    ["WENCHI", "DGSW", "None", "65432", "07.45N", "002.06W", "340", "GH"],
    ["TAKORADI (AFB)", "DGTK", "None", "65467", "04.52N", "001.46W", "9", "GH"],
    ["AXIM", "DGTX", "None", "65465", "04.52N", "002.13W", "40", "GH"],
    ["ADIAKE", "DIAD", "None", "65585", "05.17N", "003.17W", "39", "CI"],
    ["ABIDJAN/PORT BOU", "DIAP", "None", "65578", "05.15N", "003.55W", "8", "CI"],
    ["BOUAKE (CIV/MIL)", "DIBK", "None", "65555", "07.43N", "005.04W", "376", "CI"],
    ["BONDOUKOU/SOKO", "DIBU", "None", "65545", "08.03N", "002.46W", "370", "CI"],
    ["DIMBOKRO CITY", "DIDK", "None", "65562", "06.39N", "004.42W", "92", "CI"],
    ["DALOA", "DIDL", "None", "65560", "06.52N", "006.28W", "277", "CI"],
    ["FERKESSEDOUGOU", "DIFK", "None", "None", "09.35N", "005.12W", "323", "CI"],
    ["GAGNOA CITY", "DIGA", "None", "65557", "06.07N", "005.57W", "210", "CI"],
    ["KORHOGO", "DIKO", "None", "65536", "09.25N", "005.37W", "381", "CI"],
    ["MAN", "DIMN", "None", "65548", "07.22N", "007.31W", "340", "CI"],
    ["ODIENNE", "DIOD", "None", "65528", "09.30N", "007.34W", "421", "CI"],
    ["SAN PEDRO", "DISP", "None", "65594", "04.45N", "006.39W", "30", "CI"],
    ["SASSANDRA/DREWIN", "DISS", "None", "65599", "04.57N", "006.04W", "66", "CI"],
    ["TABOU", "DITB", "None", "65592", "04.25N", "007.22W", "21", "CI"],
    ["YAMOUSSOUKRO", "DIYO", "None", "65563", "06.54N", "005.20W", "213", "CI"],
    ["SAM MBAKWE", "DNIM", "None", "None", "05.26N", "007.12E", "114", "NG"],
    ["ABUJA", "DNAA", "None", "65125", "09.00N", "007.16E", "344", "NG"],
    ["AKURE AIRPORT", "DNAK", "None", "None", "07.15N", "005.18E", "336", "NG"],
    ["BENIN CITY(CIV/M", "DNBE", "None", "65229", "06.19N", "005.35E", "79", "NG"],
    ["BIDA", "DNBI", "None", "65112", "09.05N", "006.01E", "143", "NG"],
    ["CALABAR", "DNCA", "None", "65264", "04.58N", "008.20E", "63", "NG"],
    ["ENUGU", "DNEN", "None", "65257", "06.28N", "007.32E", "137", "NG"],
    ["GUSAU", "DNGU", "None", "65015", "12.10N", "006.42E", "469", "NG"],
    ["IBADAN", "DNIB", "None", "65208", "07.22N", "003.59E", "228", "NG"],
    ["ILORIN", "DNIL", "None", "65101", "08.28N", "004.29E", "305", "NG"],
    ["JOS", "DNJO", "None", "65134", "09.52N", "008.54E", "1285", "NG"],
    ["KADUNA (CIV/MIL)", "DNKA", "None", "65019", "10.35N", "007.27E", "642", "NG"],
    ["KANO/MALLAM AMIN", "DNKN", "None", "65046", "12.03N", "008.31E", "481", "NG"],
    ["MAIDUGURI", "DNMA", "None", "65082", "11.50N", "013.04E", "354", "NG"],
    ["MAKURDI (MIL)", "DNMK", "None", "65271", "07.40N", "008.37E", "97", "NG"],
    ["LAGOS/IKEJA", "DNMM", "None", "65201", "06.34N", "003.19E", "38", "NG"],
    ["MINNA AIRPORT", "DNMN", "None", "None", "09.39N", "006.28E", "254", "NG"],
    ["OSHOGBO", "DNOS", "None", "65215", "07.46N", "004.28E", "304", "NG"],
    ["PORT HARCOURT", "DNPO", "None", "65250", "04.50N", "007.01E", "18", "NG"],
    ["SOKOTO", "DNSO", "None", "65010", "12.55N", "005.12E", "302", "NG"],
    ["YOLA", "DNYO", "None", "65167", "09.13N", "012.28E", "174", "NG"],
    ["ZARIA", "DNZA", "None", "65030", "11.07N", "007.40E", "664", "NG"],
    ["BIRNI-N'KONNI", "DRRB", "None", "61075", "13.48N", "005.15E", "273", "NE"],
    ["GAYA", "DRRG", "None", "61099", "11.52N", "003.27E", "203", "NE"],
    ["BILMA", "DRRI", "None", "61017", "18.40N", "012.55E", "357", "NE"],
    ["TILLABERY", "DRRL", "None", "61036", "14.11N", "001.26E", "210", "NE"],
    ["MARADI", "DRRM", "None", "61080", "13.28N", "007.04E", "373", "NE"],
    ["NIAMEY (CIV/MIL)", "DRRN", "None", "61052", "13.28N", "002.10E", "227", "NE"],
    ["TAHOUA", "DRRT", "None", "61043", "14.54N", "005.15E", "391", "NE"],
    ["AGADEZ SOUTH (MI", "DRZA", "None", "61024", "16.58N", "008.00E", "502", "NE"],
    ["DIFFA", "DRZF", "None", "61085", "13.25N", "012.46E", "305", "NE"],
    ["GOURE", "DRZG", "None", "61045", "13.58N", "010.18E", "460", "NE"],
    ["MAINE-SOROA", "DRZM", "None", "61096", "13.13N", "011.58E", "337", "NE"],
    ["ZINDER", "DRZR", "None", "61090", "13.46N", "008.58E", "453", "NE"],
    ["TABARKA", "DTKA", "None", "60710", "36.59N", "008.53E", "21", "TN"],
    ["HABIB BOURGUIBA", "DTMB", "None", "None", "35.46N", "010.45E", "2", "TN"],
    ["ENFIDHA", "DTNH", "None", "None", "36.04N", "010.26E", "2", "TN"],
    ["ZINE EL ABIDINE", "DTNZ", "None", "None", "36.05N", "010.26E", "21", "TN"],
    ["TUNIS/CARTHAGE", "DTTA", "None", "60715", "36.51N", "010.13E", "4", "TN"],
    ["BIZERTE/SIDI AHM", "DTTB", "None", "60714", "37.15N", "009.48E", "3", "TN"],
    ["REMADA", "DTTD", "None", "60775", "32.19N", "010.24E", "301", "TN"],
    ["GAFSA", "DTTF", "None", "60745", "34.25N", "008.49E", "314", "TN"],
    ["GABES", "DTTG", "None", "60765", "33.44N", "009.55E", "5", "TN"],
    ["DJERBA MELLITA", "DTTJ", "None", "60769", "33.52N", "010.46E", "4", "TN"],
    ["KAIROUAN", "DTTK", "None", "60735", "35.40N", "010.05E", "68", "TN"],
    ["KELIBIA", "DTTL", "None", "60720", "36.51N", "011.04E", "30", "TN"],
    ["MONASTIR-SKANES", "DTTM", "None", "60740", "35.40N", "010.45E", "3", "TN"],
    ["JENDOUBA", "DTTN", "None", "60725", "36.28N", "008.48E", "144", "TN"],
    ["EL BORMA", "DTTR", "None", "60780", "31.42N", "009.16E", "259", "TN"],
    ["SFAX/EL-MAOU", "DTTX", "None", "60750", "34.43N", "010.40E", "23", "TN"],
    ["TOZEUR/NEFTA", "DTTZ", "None", "60760", "33.55N", "008.05E", "93", "TN"],
    ["ATAKPAME/AKPAKA", "DXAK", "None", "65376", "07.32N", "001.07E", "402", "TG"],
    ["DJANGOU AIRPORT", "DXDP", "None", "None", "10.48N", "000.14E", "280", "TG"],
    ["MANGO/SANSANNE", "DXMG", "None", "65352", "10.22N", "000.28E", "146", "TG"],
    ["NAIMTOUGOU(CIV/M", "DXNG", "None", "65355", "09.46N", "001.06E", "343", "TG"],
    ["SOKODE", "DXSK", "None", "65361", "09.00N", "001.09E", "387", "TG"],
    ["TABLIGBO", "DXTA", "None", "65380", "06.34N", "001.30E", "44", "TG"],
    ["LOME/TOKOIN (MIL", "DXXX", "None", "65387", "06.10N", "001.15E", "25", "TG"],
    ["ADDIS ABABA/BOLE", "HAAB", "None", "63450", "08.58N", "038.47E", "2355", "ET"],
    ["AGORDAT", "HAAG", "None", "None", "15.33N", "037.52E", "626", "ET"],
    ["ARBA MINCH", "HAAM", "None", "63500", "06.04N", "037.40E", "1219", "ET"],
    ["AWASH", "HAAW", "None", "None", "08.58N", "040.10E", "1052", "ET"],
    ["AXUM", "HAAX", "None", "None", "14.07N", "038.43E", "2134", "ET"],
    ["ASMARA/YOHANNES", "HAAY", "None", "63021", "15.16N", "038.55E", "2325", "ET"],
    ["ASMARA/YOHANNES", "HHAS", "None", "None", "15.16N", "038.55E", "2356", "ET"],
    ["BACO/BAKO", "HABC", "None", "None", "05.49N", "036.37E", "1311", "ET"],
    ["BAHAR DAR", "HABD", "None", "63332", "11.36N", "037.19E", "1822", "ET"],
    ["COMBOLCHA/DESSIE", "HADC", "None", "63333", "11.04N", "039.43E", "1864", "ET"],
    ["DEBRE MARCOS", "HADM", "None", "63334", "10.20N", "037.43E", "2476", "ET"],
    ["DIRE DAWA (MIL/C", "HADR", "None", "63471", "09.35N", "041.52E", "1146", "ET"],
    ["GHINNIR/GINIR", "HAGH", "None", "None", "07.09N", "040.43E", "1844", "ET"],
    ["GONDAR", "HAGN", "None", "63331", "12.31N", "037.25E", "1985", "ET"],
    ["GODE (MIL)", "HAGO", "None", "63478", "05.56N", "043.34E", "320", "ET"],
    ["GORE", "HAGR", "None", "63403", "08.10N", "035.32E", "1974", "ET"],
    ["HARAR MEDA (MIL)", "HAHM", "None", "63451", "08.43N", "039.00E", "1876", "ET"],
    ["JIJIGA (MIL)", "HAJJ", "None", "63473", "09.19N", "042.43E", "1644", "ET"],
    ["JIMMA", "HAJM", "None", "63402", "07.40N", "036.49E", "1676", "ET"],
    ["KABRE DARE (MIL)", "HAKD", "None", "None", "06.45N", "044.16E", "550", "ET"],
    ["AWASSA (LAKE)", "HALA", "None", "63460", "07.04N", "038.30E", "1652", "ET"],
    ["MAKALE/MEQELE", "HAMK", "None", "63330", "13.28N", "039.32E", "2255", "ET"],
    ["MASSLO/MESLO", "HAML", "None", "None", "06.22N", "039.49E", "2274", "ET"],
    ["MASSAWA", "HAMS", "None", "63023", "15.37N", "039.27E", "10", "ET"],
    ["NEGHELLI (MIL)", "HANG", "None", "63533", "05.16N", "039.45E", "1455", "ET"],
    ["ASSAB", "HASB", "None", "63043", "13.04N", "042.43E", "14", "ET"],
    ["ASSOSA/ASOSA", "HASO", "None", "None", "10.01N", "034.31E", "1733", "ET"],
    ["TESSENEI/TESENEY", "HATS", "None", "None", "15.07N", "036.40E", "615", "ET"],
    ["BUJUMBURA", "HBBA", "None", "64390", "03.19S", "029.19E", "783", "BI"],
    ["ALULA", "HCMA", "None", "63200", "11.56N", "050.43E", "2", "SO"],
    ["BARDERA", "HCMD", "None", "63250", "02.21N", "042.17E", "116", "SO"],
    ["EIL", "HCME", "None", "63228", "07.57N", "049.46E", "36", "SO"],
    ["BOSASO", "HCMF", "None", "63210", "11.16N", "049.10E", "2", "SO"],
    ["GARDO", "HCMG", "None", "63225", "09.31N", "049.04E", "812", "SO"],
    ["HARGEISA", "HCMH", "None", "63170", "09.30N", "044.04E", "1326", "SO"],
    ["BERBERA (CIV/MIL", "HCMI", "None", "63160", "10.25N", "045.01E", "9", "SO"],
    ["LUG-GANANE", "HCMJ", "None", "63248", "03.34N", "042.27E", "150", "SO"],
    ["EL BUR", "HCML", "None", "63237", "04.42N", "046.37E", "175", "SO"],
    ["MOGADISHU", "HCMM", "None", "63260", "02.01N", "045.21E", "9", "SO"],
    ["BELET UEN", "HCMN", "None", "63240", "04.42N", "045.13E", "173", "SO"],
    ["OBBIA", "HCMO", "None", "63235", "05.19N", "048.34E", "10", "SO"],
    ["GALCAYO", "HCMR", "None", "63230", "06.50N", "047.16E", "302", "SO"],
    ["SCUSCIUBAN", "HCMS", "None", "63220", "10.18N", "050.13E", "344", "SO"],
    ["ERIGAVO", "HCMU", "None", "63180", "10.37N", "047.22E", "1743", "SO"],
    ["BURAO", "HCMV", "None", "63175", "09.31N", "045.34E", "1032", "SO"],
    ["AMBOULI DJIBOUTI", "HDAM", "None", "None", "11.33N", "043.10E", "49", "DJ"],
    ["DJIBOUTI/AMBOULI", "HFFF", "None", "63125", "11.33N", "043.08E", "19", "DJ"],
    ["MENIA", "HEAM", "None", "None", "28.00N", "030.45E", "1", "EG"],
    ["EL ARISH", "HEAR", "None", "62337", "31.04N", "033.49E", "32", "EG"],
    ["ASYUT", "HEAT", "None", "62393", "27.03N", "031.01E", "70", "EG"],
    ["ALEXANDRIA/NOUZH", "HEAX", "None", "62318", "31.11N", "029.56E", "7", "EG"],
    ["ALEXANDRIA BORG", "HEBA", "None", "None", "30.55N", "029.42E", "54", "EG"],
    ["BENI SUEF AFB", "HEBF", "None", "None", "29.13N", "031.01E", "33", "EG"],
    ["ABU SIMBEL (RUIN", "HEBL", "None", "62419", "22.23N", "031.37E", "188", "EG"],
    ["CAIRO INTL AIRPO", "HECA", "None", "62366", "30.07N", "031.23E", "74", "EG"],
    ["HURGUADA", "HEGN", "None", "62463", "27.11N", "033.48E", "14", "EG"],
    ["JIYANKLIS AFB", "HEGS", "None", "None", "30.49N", "030.11E", "15", "EG"],
    ["ISMAILIA", "HEIS", "None", "None", "30.35N", "032.15E", "3", "EG"],
    ["LUXOR (CIV/MIL)", "HELX", "None", "62405", "25.40N", "032.42E", "88", "EG"],
    ["MARSA ALAM INTL", "HEMA", "RMF", "None", "25.33N", "034.35E", "77", "EG"],
    ["MERSA MATRUH (MI", "HEMM", "None", "62306", "31.19N", "027.13E", "30", "EG"],
    ["PORT SAID", "HEPS", "None", "62333", "31.17N", "032.15E", "6", "EG"],
    ["ST CATHERINE", "HESC", "SKV", "None", "28.41N", "034.04E", "1332", "EG"],
    ["SHARM EL SHEIKHI", "HESH", "None", "None", "27.58N", "034.23E", "50", "EG"],
    ["ASWAN (CIV/MIL)", "HESN", "None", "62414", "23.58N", "032.49E", "194", "EG"],
    ["TABA INTL", "HETB", "TCP", "None", "29.35N", "034.47E", "750", "EG"],
    ["EL TOR", "HETR", "None", "62459", "28.13N", "033.39E", "35", "EG"],
    ["ELDORET", "HKEL", "None", "63686", "00.24N", "035.14E", "2133", "KE"],
    ["EMBU", "HKEM", "None", "63720", "00.34S", "037.29E", "1493", "KE"],
    ["GARISSA", "HKGA", "None", "63723", "00.28S", "039.39E", "147", "KE"],
    ["ISIOLO", "HKIS", "None", "None", "00.21N", "037.34E", "1067", "KE"],
    ["NAIROBI/JOMO KEN", "HKJK", "None", "None", "01.19S", "036.55E", "1624", "KE"],
    ["KAKAMEGA", "HKKG", "None", "63687", "00.16N", "034.46E", "1530", "KE"],
    ["KISUMU", "HKKI", "None", "63708", "00.06S", "034.45E", "1146", "KE"],
    ["KERICHO", "HKKR", "None", "63710", "00.22S", "035.21E", "2184", "KE"],
    ["KISII", "HKKS", "None", "63709", "00.40S", "034.46E", "1493", "KE"],
    ["KITALE", "HKKT", "None", "63661", "00.58N", "034.58E", "1850", "KE"],
    ["LODWAR", "HKLO", "None", "63612", "03.07N", "035.37E", "515", "KE"],
    ["LAMU/MANDA ISLAN", "HKLU", "None", "63772", "02.15S", "040.55E", "6", "KE"],
    ["MANDERA", "HKMA", "None", "63624", "03.55N", "041.52E", "231", "KE"],
    ["MARSABIT", "HKMB", "None", "63641", "02.17N", "037.53E", "1345", "KE"],
    ["MERU", "HKME", "None", "63695", "00.04N", "037.38E", "1554", "KE"],
    ["MERU", "HKMK", "None", "None", "00.14N", "038.10E", "680", "KE"],
    ["MALINDI", "HKML", "None", "63799", "03.13S", "040.06E", "23", "KE"],
    ["MOMBASA/MOI INTL", "HKMO", "None", "63820", "04.01S", "039.37E", "55", "KE"],
    ["MAKINDU", "HKMU", "None", "63766", "02.16S", "037.49E", "1000", "KE"],
    ["MARA SERENA", "HKMS", "None", "None", "01.24S", "035.00E", "1612", "KE"],
    ["MOYALE LOWER (OD", "HKMY", "None", "63619", "03.28N", "039.06E", "1097", "KE"],
    ["NAIROBI/JOMO KEN", "HKNA", "None", "63740", "01.19S", "036.55E", "1624", "KE"],
    ["NAIROBI/DAGORETT", "HKNC", "None", "63741", "01.18S", "036.45E", "1798", "KE"],
    ["NYERI", "HKNI", "None", "63717", "00.22S", "036.55E", "1759", "KE"],
    ["NAKURU", "HKNK", "None", "63714", "00.18S", "036.10E", "1901", "KE"],
    ["NAROK", "HKNO", "None", "63737", "01.07S", "035.49E", "1890", "KE"],
    ["NAIROBI/WILSON", "HKNW", "None", "63742", "01.19S", "036.49E", "1679", "KE"],
    ["NANYUKI", "HKNY", "None", "None", "00.04S", "037.01E", "1905", "KE"],
    ["MOI AIRBASE", "HKRE", "None", "None", "01.17S", "036.52E", "1627", "KE"],
    ["VOI", "HKVO", "None", "63793", "03.23S", "038.32E", "579", "KE"],
    ["WAJIR", "HKWJ", "None", "63671", "01.45N", "040.04E", "244", "KE"],
    ["SIRTE", "HLGD", "None", "None", "31.04N", "016.36E", "81", "LY"],
    ["GHAT", "HLGT", "None", "62212", "25.07N", "010.07E", "692", "LY"],
    ["KUFRA (MIL/CIV)", "HLKF", "None", "62271", "24.13N", "023.18E", "435", "LY"],
    ["BENINA/BENGHAZI", "HLLB", "None", "62053", "32.04N", "020.16E", "132", "LY"],
    ["MITIGA", "HLLM", "None", "None", "32.54N", "013.17E", "11", "LY"],
    ["EL BEIDA", "HLLQ", "None", "None", "32.47N", "021.58E", "657", "LY"],
    ["SEBHA (AUT)", "HLLS", "None", "62124", "26.59N", "014.28E", "435", "LY"],
    ["TRIPOLI INTL ARP", "HLLT", "None", "62010", "32.40N", "013.09E", "81", "LY"],
    ["HON", "HLON", "None", "None", "29.07N", "015.58E", "280", "LY"],
    ["GHADAMES", "HLTD", "None", "62103", "30.07N", "009.30E", "357", "LY"],
    ["GISENYI", "HRYG", "None", "64381", "01.40S", "029.15E", "1554", "RW"],
    ["BUTARE", "HRYI", "None", "64384", "02.36S", "029.43E", "1768", "RW"],
    ["KIGALI", "HRYR", "None", "64387", "01.58S", "030.07E", "1497", "RW"],
    ["RUHENGERI", "HRYU", "None", "64383", "01.30S", "029.37E", "1860", "RW"],
    ["KAMEMBE", "HRZA", "None", "64380", "02.28S", "028.55E", "1591", "RW"],
    ["AKOBO", "HSAK", "None", "None", "07.46N", "033.01E", "402", "SD"],
    ["ATBARA", "HSAT", "None", "62680", "17.41N", "033.58E", "345", "SD"],
    ["AWEIL/UWAYL", "HSAW", "None", "None", "08.46N", "027.23E", "414", "SD"],
    ["BOR", "HSBR", "None", "None", "06.12N", "031.33E", "420", "SD"],
    ["DONGOLA/DUNQULAH", "HSDN", "None", "62650", "19.10N", "030.28E", "226", "SD"],
    ["DAMAZIN", "HSDZ", "None", "62805", "11.46N", "034.22E", "470", "SD"],
    ["EL FASHER", "HSFS", "None", "62760", "13.37N", "025.19E", "730", "SD"],
    ["GEDAREF/AZAZA", "HSGF", "None", "62752", "14.01N", "035.23E", "599", "SD"],
    ["GENEINA", "HSGN", "None", "62770", "13.28N", "022.26E", "805", "SD"],
    ["KASSALA", "HSKA", "None", "62730", "15.28N", "036.23E", "500", "SD"],
    ["KOSTI/RABAK", "HSKI", "None", "62772", "13.10N", "032.40E", "381", "SD"],
    ["KADUGLI", "HSLI", "None", "62810", "11.00N", "029.43E", "499", "SD"],
    ["MARIDI", "HSMD", "None", "None", "04.55N", "029.28E", "749", "SD"],
    ["RUMBEK", "HSMK", "None", "None", "06.47N", "029.41E", "418", "SD"],
    ["NASIR", "HSNA", "None", "None", "08.37N", "033.04E", "399", "SD"],
    ["SHENDI", "HSND", "None", "62700", "16.41N", "033.25E", "360", "SD"],
    ["NYALA", "HSNL", "None", "62790", "12.03N", "024.52E", "658", "SD"],
    ["SENNAR", "HSNR", "None", "62762", "13.33N", "033.37E", "418", "SD"],
    ["EL OBEID", "HSOB", "None", "62771", "13.10N", "030.13E", "574", "SD"],
    ["PIBOR POST", "HSPI", "None", "62905", "06.47N", "033.07E", "510", "SD"],
    ["PORT SUDAN INTL", "HSPN", "None", "None", "19.25N", "037.13E", "138", "SD"],
    ["RAGA", "HSRJ", "None", "62871", "08.28N", "025.40E", "545", "SD"],
    ["RENK", "HSRN", "None", "62801", "11.45N", "032.46E", "282", "SD"],
    ["JUBA", "HSSJ", "None", "62941", "04.52N", "031.36E", "457", "SD"],
    ["MALAKAL", "HSSM", "None", "62840", "09.33N", "031.38E", "388", "SD"],
    ["PORT SUDAN", "HSSP", "None", "62641", "19.34N", "037.13E", "2", "SD"],
    ["KHARTOUM (CIV/MI", "HSSS", "None", "62721", "15.35N", "032.32E", "380", "SD"],
    ["HALFA (WADI)", "HSSW", "None", "62600", "21.49N", "031.28E", "183", "SD"],
    ["TORIT", "HSTR", "None", "None", "04.25N", "032.34E", "624", "SD"],
    ["YAMBIO", "HSYA", "None", "62940", "04.34N", "028.23E", "649", "SD"],
    ["ZALINGEI", "HSZA", "None", "None", "12.54N", "023.28E", "900", "SD"],
    ["ARUSHA", "HTAR", "None", "63789", "03.22S", "036.38E", "1387", "TZ"],
    ["BUKOBA", "HTBU", "None", "63729", "01.19S", "031.49E", "1137", "TZ"],
    ["DAR ES SALAAM AR", "HTDA", "None", "63894", "06.53S", "039.12E", "55", "TZ"],
    ["DODOMA", "HTDO", "None", "63862", "06.10S", "035.46E", "1120", "TZ"],
    ["IRINGA", "HTIR", "None", "63887", "07.40S", "035.45E", "1428", "TZ"],
    ["KIGOMA", "HTKA", "None", "63801", "04.52S", "029.40E", "885", "TZ"],
    ["KILWA MASOKO", "HTKI", "None", "None", "08.55S", "039.31E", "18", "TZ"],
    ["KILIMANJARO AIRP", "HTKJ", "None", "63791", "03.25S", "037.04E", "896", "TZ"],
    ["MBEYA", "HTMB", "None", "63932", "08.55S", "033.28E", "1707", "TZ"],
    ["MOROGORO (MET)", "HTMG", "None", "63866", "06.49S", "037.38E", "526", "TZ"],
    ["MOMBO", "HTMO", "None", "63818", "04.52S", "038.16E", "511", "TZ"],
    ["MOSHI", "HTMS", "None", "63790", "03.21S", "037.19E", "831", "TZ"],
    ["MTWARA", "HTMT", "None", "63971", "10.16S", "040.10E", "113", "TZ"],
    ["MUSOMA", "HTMU", "None", "63733", "01.30S", "033.47E", "1147", "TZ"],
    ["MWANZA", "HTMW", "None", "63756", "02.28S", "032.55E", "1140", "TZ"],
    ["NACHINGWEA", "HTNA", "None", "63969", "10.20S", "038.45E", "465", "TZ"],
    ["PEMBA/KARUME ARP", "HTPE", "None", "63845", "05.15S", "039.49E", "25", "TZ"],
    ["SAME", "HTSE", "None", "63816", "04.04S", "037.43E", "872", "TZ"],
    ["SONGEA", "HTSO", "None", "63962", "10.40S", "035.34E", "1067", "TZ"],
    ["SUMBAWANGA", "HTSU", "None", "None", "07.57S", "031.40E", "1804", "TZ"],
    ["SHINYANGA", "HTSY", "None", "None", "03.30S", "033.00E", "1100", "TZ"],
    ["TABORA AIRPORT", "HTTB", "None", "63832", "05.04S", "032.49E", "1190", "TZ"],
    ["TANGA", "HTTG", "None", "63844", "05.04S", "039.04E", "35", "TZ"],
    ["ZANZIBAR/KISAUNI", "HTZA", "None", "63870", "06.13S", "039.13E", "15", "TZ"],
    ["ARUA", "HUAR", "None", "63602", "03.02N", "030.55E", "1211", "UG"],
    ["ENTEBBE INTL ARP", "HUEN", "None", "63705", "00.02N", "032.27E", "1155", "UG"],
    ["FORT PORTAL", "HUFP", "None", "None", "00.40N", "030.16E", "1533", "UG"],
    ["GULU (MIL/CIV)", "HUGU", "None", "63630", "02.45N", "032.19E", "1105", "UG"],
    ["JINJA", "HUJI", "None", "63682", "00.27N", "033.10E", "1173", "UG"],
    ["KABALE", "HUKB", "None", "63726", "01.15S", "029.58E", "1869", "UG"],
    ["KASESE", "HUKS", "None", "63674", "00.10N", "030.06E", "961", "UG"],
    ["LIRA", "HULI", "None", "None", "02.15N", "032.53E", "1091", "UG"],
    ["MBARARA", "HUMA", "None", "63702", "00.33S", "030.36E", "1413", "UG"],
    ["MASINDI", "HUMI", "None", "63654", "01.40N", "031.43E", "1147", "UG"],
    ["MOROTO", "HUMO", "None", "None", "02.31N", "034.38E", "1280", "UG"],
    ["SOROTI", "HUSO", "None", "63658", "01.43N", "033.37E", "1123", "UG"],
    ["TORORO", "HUTO", "None", "63684", "00.40N", "034.10E", "1171", "UG"],
    ["ALEXANDER BAY", "FAAB", "None", "68406", "28.34S", "016.31E", "21", "ZA"],
    ["ALIWAL NORTH", "FAAN", "None", "68546", "30.43S", "026.43E", "1351", "ZA"],
    ["BRAKPAN", "FABB", "None", "None", "26.13S", "028.18E", "1615", "ZA"],
    ["BURGERSDORP", "FABD", "None", "None", "30.58S", "026.19E", "1437", "ZA"],
    ["BISHO", "FABE", "None", "None", "32.53S", "027.16E", "594", "ZA"],
    ["BLOEMFONTEIN/HER", "FABL", "None", "68442", "29.06S", "026.18E", "1348", "ZA"],
    ["BETHLEHEM AIRPOR", "FABM", "None", "68461", "28.15S", "028.19E", "1682", "ZA"],
    ["BARBERTON", "FABN", "None", "None", "25.43S", "031.00E", "800", "ZA"],
    ["BREDASDORP", "FABR", "None", "None", "34.31S", "020.01E", "50", "ZA"],
    ["BEAUFORT WEST (M", "FABY", "None", "68728", "32.21S", "022.34E", "842", "ZA"],
    ["COOKHOUSE", "FACH", "None", "None", "32.46S", "025.45E", "900", "ZA"],
    ["CAROLINA", "FACL", "None", "68380", "26.04S", "030.07E", "1700", "ZA"],
    ["CAPETOWN/DF MALA", "FACT", "None", "68816", "33.58S", "018.36E", "42", "ZA"],
    ["CALVINIA (MET)", "FACV", "None", "68618", "31.28S", "019.46E", "1000", "ZA"],
    ["CLANWILLIAM", "FACW", "None", "None", "32.10S", "018.52E", "150", "ZA"],
    ["DE AAR", "FADA", "None", "68536", "30.38S", "024.01E", "1247", "ZA"],
    ["DUNDEE", "FADD", "None", "None", "28.10S", "030.13E", "1286", "ZA"],
    ["DURNACOL", "FADH", "None", "None", "28.07S", "029.58E", "1500", "ZA"],
    ["DURBAN/LOUIS BOT", "FADN", "None", "68588", "29.58S", "030.56E", "8", "ZA"],
    ["DUNNOTTAR (SAAF)", "FADR", "None", "None", "26.21S", "028.28E", "1620", "ZA"],
    ["DE AAR MET", "FADY", "None", "None", "30.38S", "023.55E", "384", "ZA"],
    ["EAST LONDON/SCHO", "FAEL", "None", "68858", "33.01S", "027.49E", "125", "ZA"],
    ["ERMELO", "FAEO", "None", "None", "26.30S", "029.58E", "1737", "ZA"],
    ["ELLISRAS", "FAER", "None", "68156", "23.44S", "027.41E", "839", "ZA"],
    ["ESHOWE", "FAES", "None", "None", "28.52S", "031.26E", "487", "ZA"],
    ["ELLIOT", "FAET", "None", "None", "31.18S", "027.51E", "1533", "ZA"],
    ["FICKSBURG", "FAFB", "None", "None", "28.49S", "027.55E", "1620", "ZA"],
    ["FRANKFORT", "FAFF", "None", "68362", "27.17S", "028.31E", "1500", "ZA"],
    ["FRASERBURG", "FAFR", "None", "68624", "31.55S", "021.31E", "1267", "ZA"],
    ["GOBABIS", "FAGB", "None", "68116", "22.28S", "018.58E", "1449", "ZA"],
    ["GRAND CENTRAL", "FAGC", "None", "None", "25.59S", "028.08E", "1623", "ZA"],
    ["GOUGH ISLAND", "FAGE", "None", "68906", "40.21S", "009.52W", "54", "ZA"],
    ["GEORGE/P. W. BOT", "FAGG", "None", "68828", "34.00S", "022.22E", "193", "ZA"],
    ["JOHANNESBURG/RAN", "FAGM", "None", "None", "26.15S", "028.09E", "1672", "ZA"],
    ["GRAAFF REINET", "FAGR", "None", "68736", "32.15S", "024.31E", "754", "ZA"],
    ["GRAHAMSTOWN", "FAGT", "None", "None", "33.16S", "026.30E", "651", "ZA"],
    ["GRAVELOTTE", "FAGV", "None", "None", "23.53S", "030.40E", "532", "ZA"],
    ["GREYTOWN", "FAGY", "None", "None", "29.06S", "030.36E", "1100", "ZA"],
    ["HARMONY (PRIVATE", "FAHA", "None", "None", "28.04S", "026.52E", "1337", "ZA"],
    ["HUMANSDORP", "FAHD", "None", "None", "34.01S", "024.46E", "40", "ZA"],
    ["HENDRINA (PRIVAT", "FAHE", "None", "None", "26.01S", "029.36E", "1576", "ZA"],
    ["HEIDELBERG", "FAHG", "None", "None", "26.31S", "028.22E", "1560", "ZA"],
    ["HOEDSPRUIT (SAAF", "FAHS", "None", "68290", "24.22S", "031.01E", "500", "ZA"],
    ["PRETORIA/IRENE", "FAIR", "None", "68263", "25.55S", "028.13E", "1500", "ZA"],
    ["JOHANNESBURG CIT", "FAJB", "None", "None", "26.09S", "028.00E", "1626", "ZA"],
    ["JAGERSFONTEIN", "FAJF", "None", "None", "29.46S", "025.25E", "1400", "ZA"],
    ["KLERKSDORP", "FAKD", "None", "None", "26.52S", "026.43E", "1355", "ZA"],
    ["KIMBERLEY/BJ VOR", "FAKM", "None", "68438", "28.48S", "024.46E", "1192", "ZA"],
    ["KRUGER MPUMALANG", "FAKN", "None", "None", "25.23S", "031.06E", "862", "ZA"],
    ["KOMATIPOORT", "FAKP", "None", "None", "25.25S", "031.55E", "152", "ZA"],
    ["KROONSTAD", "FAKS", "None", "68352", "27.40S", "027.15E", "1350", "ZA"],
    ["KLEINSEE", "FAKZ", "None", "None", "29.37S", "017.04E", "80", "ZA"],
    ["LANSERIA (CIV/MI", "FALA", "None", "None", "25.55S", "027.55E", "1377", "ZA"],
    ["LIME ACRES(PRIVA", "FALC", "None", "None", "28.22S", "023.26E", "1494", "ZA"],
    ["DURBAN SHAKA", "FALE", "None", "68592", "29.37S", "031.07E", "109", "ZA"],
    ["LICHTENBURG", "FALI", "None", "None", "26.10S", "026.11E", "1486", "ZA"],
    ["MAKHADO AFB", "FALM", "None", "None", "23.10S", "029.42E", "935", "ZA"],
    ["LOUIS TRICHARDT", "FALO", "None", "None", "23.03S", "029.52E", "922", "ZA"],
    ["LICHTENBURG", "FALT", "None", "None", "26.10S", "026.10E", "1486", "ZA"],
    ["LANGEBAANWEG (SA", "FALW", "None", "68714", "32.58S", "018.10E", "0", "ZA"],
    ["LADYSMITH", "FALY", "None", "68476", "28.34S", "029.46E", "1100", "ZA"],
    ["MIDDELBURG", "FAMB", "None", "68638", "31.28S", "025.01E", "1300", "ZA"],
    ["MARION ISLAND", "FAME", "None", "68994", "46.52S", "037.52E", "22", "ZA"],
    ["MARGATE", "FAMG", "None", "None", "30.51S", "030.21E", "151", "ZA"],
    ["MAFIKENG", "FAMK", "None", "None", "25.52S", "025.38E", "1400", "ZA"],
    ["MMABATHO INTL AR", "FAMM", "None", "68242", "25.48S", "025.31E", "1277", "ZA"],
    ["MOSSEL BAY (LGT-", "FAMO", "None", "68928", "34.10S", "022.08E", "59", "ZA"],
    ["MPACHA (CIV/MIL)", "FAMP", "None", "None", "17.37S", "024.10E", "985", "ZA"],
    ["MARIEPSKOP (SAAF", "FAMR", "None", "None", "24.33S", "030.52E", "1927", "ZA"],
    ["MEYERTON", "FAMT", "None", "None", "26.33S", "028.01E", "1500", "ZA"],
    ["NEWCASTLE", "FANC", "None", "None", "27.46S", "029.58E", "1251", "ZA"],
    ["NEW HANOVER", "FANH", "None", "None", "29.25S", "030.26E", "750", "ZA"],
    ["NEW LARGO", "FANL", "None", "None", "25.55S", "028.58E", "1700", "ZA"],
    ["NELSPRUIT", "FANS", "None", "68288", "25.25S", "030.58E", "674", "ZA"],
    ["JOHANNESBURG/TAM", "FAOR", "None", "68368", "26.07S", "028.13E", "1700", "ZA"],
    ["ONDANGWA (MIL/CI", "FAOA", "None", "68006", "17.55S", "015.58E", "1100", "ZA"],
    ["OVERBERG", "FAOB", "None", "None", "34.36S", "020.16E", "75", "ZA"],
    ["OUDTSHOORN", "FAOH", "None", "68826", "33.34S", "022.13E", "359", "ZA"],
    ["PIETERSBURG (SAA", "FAPB", "None", "68174", "23.52S", "029.26E", "1222", "ZA"],
    ["PLETTENBERG BAY", "FAPG", "None", "None", "34.05S", "023.20E", "139", "ZA"],
    ["PRINCE ALBERT RO", "FAPC", "None", "None", "33.13S", "022.01E", "900", "ZA"],
    ["PORT ELIZABETH", "FAPE", "None", "68842", "33.58S", "025.36E", "60", "ZA"],
    ["PHALABORWA(PRIVA", "FAPH", "None", "68190", "23.55S", "031.08E", "400", "ZA"],
    ["PIETERSBURG(CIVI", "FAPI", "None", "None", "23.53S", "029.28E", "1327", "ZA"],
    ["PORT ST. JOHNS (", "FAPJ", "None", "68674", "31.37S", "029.33E", "47", "ZA"],
    ["PIETERMARITZBURG", "FAPM", "None", "None", "29.38S", "030.23E", "739", "ZA"],
    ["PILANESBERG", "FAPN", "None", "None", "25.20S", "027.10E", "1039", "ZA"],
    ["POLOKWANE INTL", "FAPP", "None", "None", "23.50S", "029.27E", "1242", "ZA"],
    ["PRETORIA (MET)", "FAPR", "None", "68262", "25.43S", "028.10E", "1322", "ZA"],
    ["POTCHEFSTROOM(SA", "FAPS", "None", "68351", "26.40S", "027.06E", "1400", "ZA"],
    ["QUEENSTOWN", "FAQT", "None", "68648", "31.53S", "026.52E", "1086", "ZA"],
    ["RICHARD'S BAY", "FARB", "None", "68498", "28.48S", "032.06E", "0", "ZA"],
    ["FARAULEP ISLAND", "FARP", "None", "99446", "08.16N", "144.33E", "2", "ZA"],
    ["RUNDU (MIL/CIV)", "FARU", "None", "None", "17.55S", "019.46E", "1100", "ZA"],
    ["SPRINGBOK", "FASB", "None", "68512", "29.40S", "017.52E", "990", "ZA"],
    ["SPRINGS", "FASI", "None", "None", "26.15S", "028.24E", "1628", "ZA"],
    ["SWARTKOP (SAAF)", "FASK", "None", "None", "25.49S", "028.10E", "1457", "ZA"],
    ["SISHEN", "FASS", "None", "None", "27.38S", "023.00E", "1173", "ZA"],
    ["TRISTAN DA CUNHA", "FATC", "None", "68902", "37.02S", "012.19W", "23", "ZA"],
    ["TSUMEB (PRIVATE)", "FATM", "None", "None", "19.16S", "017.43E", "1327", "ZA"],
    ["TZANEEN", "FATZ", "None", "None", "23.49S", "030.19E", "583", "ZA"],
    ["ULUNDI", "FAUL", "None", "None", "28.19S", "031.25E", "525", "ZA"],
    ["UPINGTON/PIERRE", "FAUP", "None", "68424", "28.23S", "021.16E", "836", "ZA"],
    ["UMTATA/KD MATANZ", "FAUT", "None", "68668", "31.31S", "028.40E", "752", "ZA"],
    ["VEREENIGING", "FAVV", "None", "None", "26.34S", "027.58E", "1483", "ZA"],
    ["VRYBURG", "FAVB", "None", "68338", "26.59S", "024.44E", "1195", "ZA"],
    ["DURBAN/VIRGINIA", "FAVG", "None", "None", "29.46S", "031.04E", "6", "ZA"],
    ["VREDENDAL", "FAVR", "None", "68614", "31.40S", "018.30E", "34", "ZA"],
    ["VICTORIA WEST", "FAVW", "None", "None", "31.23S", "023.07E", "1256", "ZA"],
    ["VRYHEID", "FAVY", "None", "None", "27.46S", "030.48E", "1158", "ZA"],
    ["WONDERBOOM/PRETO", "FAWB", "None", "None", "25.38S", "028.13E", "1248", "ZA"],
    ["WINDHOEK", "FAWE", "None", "68110", "22.34S", "017.06E", "1700", "ZA"],
    ["WITBANK", "FAWI", "None", "None", "25.50S", "029.12E", "1553", "ZA"],
    ["WATERKLOOF (SAAF", "FAWK", "None", "68264", "25.49S", "028.13E", "1500", "ZA"],
    ["WELKOM", "FAWM", "None", "68346", "28.00S", "026.40E", "1341", "ZA"],
    ["YSTERPLANT (SAAF", "FAYP", "None", "None", "33.53S", "018.30E", "16", "ZA"],
    ["ZASTRON", "FAZA", "None", "None", "30.18S", "027.07E", "1300", "ZA"],
    ["WINDHOEK/EROS(SA", "FAWW", "None", "None", "22.34S", "017.06E", "1725", "ZA"],
    ["J. G. STRIJDOM", "FAWH", "None", "None", "22.28S", "017.28E", "1700", "ZA"],
    ["JAN SMUTS", "FAJS", "None", "None", "26.07S", "028.13E", "1700", "ZA"],
    ["FRANCISTOWN", "FBFT", "None", "68054", "21.10S", "027.29E", "1000", "BW"],
    ["GHANZI", "FBGZ", "None", "68024", "21.41S", "021.38E", "1100", "BW"],
    ["JWANENG (PRIVATE", "FBJW", "None", "68234", "24.36S", "024.40E", "1200", "BW"],
    ["KASANE", "FBKE", "None", "68029", "17.49S", "025.10E", "1000", "BW"],
    ["GBADOLITE", "FBLT", "None", "68040", "21.25S", "025.36E", "985", "BW"],
    ["MAUN", "FBMN", "None", "68032", "19.58S", "023.25E", "900", "BW"],
    ["MAHALAPYE", "FBMP", "None", "None", "23.04S", "026.50E", "1009", "BW"],
    ["ORAPA (PRIVATE)", "FBOR", "None", "None", "21.16S", "025.19E", "945", "BW"],
    ["SIR SERETSE KHAM", "FBSK", "None", "68240", "24.33S", "025.55E", "1005", "BW"],
    ["SUA-PAN", "FBSN", "None", "68038", "20.28S", "025.58E", "904", "BW"],
    ["SELEBI PHIKWE", "FBSP", "None", "None", "22.03S", "027.49E", "892", "BW"],
    ["SHAKAWE", "FBSW", "None", "68026", "18.22S", "021.51E", "1000", "BW"],
    ["TSHANE", "FBTE", "None", "68226", "24.01S", "021.52E", "1100", "BW"],
    ["TSABONG", "FBTS", "None", "68328", "26.03S", "022.26E", "1000", "BW"],
    ["PANDAMATENGA", "FBPA", "None", "None", "18.16S", "025.39E", "1064", "BW"],
    ["BRAZZAVILLE/MAYA", "FCBB", "None", "64450", "04.15S", "015.15E", "316", "CG"],
    ["DJAMBALA", "FCBD", "None", "64453", "02.31S", "014.46E", "790", "CG"],
    ["MOUYONDZI", "FCBM", "None", "64402", "03.58S", "013.55E", "512", "CG"],
    ["M'POUYA", "FCBO", "None", "64452", "02.37S", "016.13E", "312", "CG"],
    ["SIBITI", "FCBS", "None", "64405", "03.40S", "013.20E", "531", "CG"],
    ["GAMBOMA", "FCOG", "None", "64454", "01.52S", "015.52E", "377", "CG"],
    ["IMPFONDO", "FCOI", "None", "64459", "01.37N", "018.04E", "326", "CG"],
    ["MAKOUA", "FCOM", "None", "64456", "00.01S", "015.34E", "379", "CG"],
    ["SOUANKE", "FCOS", "None", "64460", "02.04N", "014.07E", "550", "CG"],
    ["OUESSO", "FCOU", "None", "64458", "01.37N", "016.03E", "352", "CG"],
    ["MAKABANA", "FCPA", "None", "64403", "03.28S", "012.37E", "161", "CG"],
    ["LOUBOMO", "FCPL", "None", "64401", "04.12S", "012.41E", "330", "CG"],
    ["POINTE-NOIRE", "FCPP", "None", "64400", "04.49S", "011.54E", "17", "CG"],
    ["KINSHASA/N'DJILI", "FZAA", "None", "64210", "04.23S", "015.27E", "312", "CD"],
    ["MOANDA", "FZAG", "None", "64201", "06.00S", "012.25E", "27", "CD"],
    ["KITONA (ZAI-AFB)", "FZAI", "None", "64203", "05.55S", "012.26E", "120", "CD"],
    ["MATADI/TSHIMPI", "FZAM", "None", "64207", "05.47S", "013.25E", "340", "CD"],
    ["INGA", "FZAN", "None", "64206", "05.31S", "013.34E", "277", "CD"],
    ["INONGO", "FZBA", "None", "64115", "01.58S", "018.16E", "300", "CD"],
    ["BANDUNDU", "FZBO", "None", "64108", "03.17S", "017.21E", "324", "CD"],
    ["KIKWIT", "FZCA", "None", "64222", "05.01S", "018.48E", "449", "CD"],
    ["KAHEMBA", "FZCF", "None", "None", "07.16S", "019.00E", "1060", "CD"],
    ["KENGE", "FZCS", "None", "64217", "04.55S", "017.04E", "563", "CD"],
    ["MBANDAKA", "FZEA", "None", "64005", "00.03N", "018.16E", "317", "CD"],
    ["BASANKUSU", "FZEN", "None", "64008", "01.13N", "019.48E", "353", "CD"],
    ["GEMENA", "FZFK", "None", "64006", "03.16N", "019.46E", "446", "CD"],
    ["LISALA", "FZGA", "None", "64014", "02.19N", "021.34E", "463", "CD"],
    ["BOENDE", "FZGN", "None", "64126", "00.13S", "020.51E", "351", "CD"],
    ["KISANGANI (ZAI-A", "FZIA", "None", "64040", "00.31N", "025.10E", "396", "CD"],
    ["ISIRO", "FZJA", "None", "64062", "02.46N", "027.38E", "764", "CD"],
    ["BUNIA", "FZKA", "None", "64076", "01.30N", "030.13E", "1239", "CD"],
    ["ANGO", "FZKO", "None", "None", "04.01N", "025.52E", "650", "CD"],
    ["BONDO", "FZKP", "None", "64021", "03.47N", "023.49E", "474", "CD"],
    ["BUKAVU/KAVUMU", "FZMA", "None", "64180", "02.31S", "028.51E", "1612", "CD"],
    ["BUTEMBO", "FZMB", "None", "64072", "00.07N", "029.16E", "1840", "CD"],
    ["GOMA INTL AIRPOR", "FZNA", "None", "64184", "01.40S", "029.13E", "1552", "CD"],
    ["RUTSHURU", "FZNC", "None", "64157", "01.10S", "029.26E", "1275", "CD"],
    ["KINDU", "FZOA", "None", "64155", "02.57S", "025.55E", "497", "CD"],
    ["KALIMA", "FZOD", "None", "64156", "02.36S", "026.33E", "569", "CD"],
    ["KASONGO", "FZOK", "None", "64264", "04.31S", "026.34E", "544", "CD"],
    ["LUBUMBASHI/LUANO", "FZQA", "None", "64360", "11.35S", "027.32E", "1309", "CD"],
    ["KOLWEZI", "FZQM", "None", "64328", "10.43S", "025.26E", "1526", "CD"],
    ["MITWABA", "FZQV", "None", "64348", "08.35S", "027.19E", "1579", "CD"],
    ["MANONO", "FZRA", "None", "64282", "07.16S", "027.25E", "633", "CD"],
    ["MOBA", "FZRB", "None", "None", "07.04S", "029.46E", "1132", "CD"],
    ["KALEMIE", "FZRF", "None", "64285", "05.52S", "029.10E", "818", "CD"],
    ["KONGOLO", "FZRQ", "None", "64276", "05.20S", "027.00E", "561", "CD"],
    ["KAMINA (ZAI-AFB)", "FZSA", "None", "64315", "08.37S", "025.15E", "1106", "CD"],
    ["SANDOA", "FZSD", "None", "64303", "09.37S", "022.51E", "921", "CD"],
    ["DILOLO", "FZSI", "None", "64301", "10.40S", "022.19E", "1028", "CD"],
    ["KAPANGA", "FZSK", "None", "None", "08.20S", "022.34E", "882", "CD"],
    ["KANIAMA", "FZTK", "None", "None", "07.31S", "024.10E", "845", "CD"],
    ["KANANGA", "FZUA", "None", "64235", "05.52S", "022.25E", "657", "CD"],
    ["TSHIKAPA", "FZUK", "None", "64228", "06.25S", "020.51E", "481", "CD"],
    ["LODJA", "FZVA", "None", "64146", "03.28S", "023.28E", "500", "CD"],
    ["LOMELA", "FZVE", "None", "None", "02.17S", "023.16E", "437", "CD"],
    ["ILEBO", "FZVS", "None", "64224", "04.19S", "020.34E", "420", "CD"],
    ["MBUJI-MAYI", "FZWA", "None", "64247", "06.07S", "023.34E", "677", "CD"],
    ["KABINDA/TUNTA", "FZWT", "None", "None", "06.07S", "024.28E", "890", "CD"],
    ["BIG BEND MET", "FDBB", "None", "68399", "26.51S", "031.55E", "94", "SZ"],
    ["JERICHO", "FDJR", "None", "None", "27.10S", "031.26E", "701", "SZ"],
    ["LOMAHASHA", "FDLM", "None", "68298", "25.59S", "031.59E", "570", "SZ"],
    ["LAVUMISA", "FDLV", "None", "68393", "27.16S", "031.49E", "315", "SZ"],
    ["MANZINI/MATSAPA", "FDMS", "None", "68396", "26.31S", "031.18E", "641", "SZ"],
    ["MAYIWANE", "FDMY", "None", "None", "25.52S", "031.31E", "480", "SZ"],
    ["NDZEVANE", "FDND", "None", "None", "26.58S", "031.58E", "207", "SZ"],
    ["NYONYANE", "FDNY", "None", "None", "26.07S", "031.27E", "320", "SZ"],
    ["MOTI", "FDOT", "None", "None", "26.42S", "031.26E", "341", "SZ"],
    ["PIGGS PEAK", "FDPP", "None", "68299", "25.58S", "031.15E", "1099", "SZ"],
    ["SITEKI", "FDST", "None", "68398", "26.26S", "031.57E", "667", "SZ"],
    ["NHLANGANO ARPT", "FDNH", "None", "None", "27.07S", "031.13E", "1074", "SZ"],
    ["VUVULANE", "FDVV", "None", "None", "26.04S", "031.53E", "276", "SZ"],
    ["ALINDAO", "FEFA", "None", "64662", "05.02N", "021.11E", "449", "CF"],
    ["OBO", "FEFB", "None", "64659", "05.24N", "026.30E", "651", "CF"],
    ["BANGUI/M'POKO (M", "FEFF", "None", "64650", "04.24N", "018.31E", "366", "CF"],
    ["BANGASSOU", "FEFG", "None", "64656", "04.43N", "022.49E", "500", "CF"],
    ["BIRAO", "FEFI", "None", "64658", "10.16N", "022.46E", "464", "CF"],
    ["BOSSEMBELE", "FEFL", "None", "64605", "05.16N", "017.37E", "674", "CF"],
    ["BAMBARI", "FEFM", "None", "64660", "05.50N", "020.38E", "475", "CF"],
    ["N'DELE", "FEFN", "None", "64654", "08.24N", "020.38E", "511", "CF"],
    ["BOUAR", "FEFO", "None", "64601", "05.58N", "015.37E", "1020", "CF"],
    ["BRIA", "FEFR", "None", "64655", "06.31N", "021.58E", "584", "CF"],
    ["BOSSANGOA", "FEFS", "None", "64610", "06.28N", "017.25E", "465", "CF"],
    ["BERBERATI", "FEFT", "None", "64600", "04.15N", "015.48E", "583", "CF"],
    ["YALINGA", "FEFY", "None", "64661", "06.30N", "023.16E", "602", "CF"],
    ["BANGUI", "FEFV", "None", "None", "04.24N", "018.31E", "366", "CF"],
    ["BATA (RIO MUNI)", "FGBT", "None", "64820", "01.53N", "009.48E", "8", "GQ"],
    ["MALABO/FERNANDO", "FGSL", "None", "64810", "03.45N", "008.43E", "56", "GQ"],
    ["WIDE AWAKE FIELD", "FHAW", "None", "61902", "07.58S", "014.24W", "79", "SH"],
    ["PLAISANCE", "FIMP", "None", "61990", "20.25S", "057.40E", "57", "MU"],
    ["RODRIGUES/PLAINE", "FIMR", "None", "61988", "19.45S", "063.22E", "31", "MU"],
    ["DIEGO GARCIA", "FJDG", "None", "61967", "07.19S", "072.25E", "3", "MU"],
    ["BANYO", "FKAB", "None", "64880", "06.46N", "011.49E", "1110", "CM"],
    ["BAFIA", "FKAF", "None", "64920", "04.43N", "011.15E", "500", "CM"],
    ["ABONG-MBANG", "FKAG", "None", "64960", "03.58N", "013.11E", "693", "CM"],
    ["LOMIE", "FKAL", "None", "64961", "03.08N", "013.37E", "624", "CM"],
    ["MEIGANGA", "FKAM", "None", "64882", "06.31N", "014.22E", "1027", "CM"],
    ["NKONGSAMBA", "FKAN", "None", "64911", "04.57N", "009.55E", "821", "CM"],
    ["BETARE-OYA", "FKAO", "None", "64901", "05.35N", "014.04E", "804", "CM"],
    ["YOKO", "FKAY", "None", "64900", "05.32N", "012.22E", "1031", "CM"],
    ["MAROUA-SALAK", "FKKA", "None", "64851", "10.26N", "014.15E", "422", "CM"],
    ["KRIBI", "FKKB", "None", "64971", "02.57N", "009.54E", "16", "CM"],
    ["TIKO", "FKKC", "None", "64912", "04.04N", "009.22E", "52", "CM"],
    ["DOUALA (CIV/MIL)", "FKKD", "None", "64910", "04.00N", "009.43E", "9", "CM"],
    ["ESEKA", "FKKE", "None", "None", "03.38N", "010.46E", "227", "CM"],
    ["MAMFE", "FKKF", "None", "64890", "05.43N", "009.16E", "126", "CM"],
    ["KAELE", "FKKH", "None", "None", "10.05N", "014.26E", "389", "CM"],
    ["BATOURI", "FKKI", "None", "64931", "04.28N", "014.22E", "656", "CM"],
    ["YAGOUA CITY", "FKKJ", "None", "None", "10.22N", "015.13E", "326", "CM"],
    ["MAROUA SALAK", "FKKL", "None", "None", "10.27N", "014.15E", "424", "CM"],
    ["KOUNDJA/FOUMBAN", "FKKM", "None", "64893", "05.39N", "010.45E", "1210", "CM"],
    ["NGAOUNDERE", "FKKN", "None", "64870", "07.20N", "013.34E", "1104", "CM"],
    ["BERTOUA", "FKKO", "None", "None", "04.32N", "013.43E", "670", "CM"],
    ["GAROUA", "FKKR", "None", "64860", "09.19N", "013.22E", "244", "CM"],
    ["DSCHANG", "FKKS", "None", "None", "05.27N", "010.04E", "1408", "CM"],
    ["TIBATI", "FKKT", "None", "None", "06.28N", "012.37E", "870", "CM"],
    ["BAMENDA", "FKKV", "None", "64892", "06.02N", "010.07E", "1239", "CM"],
    ["EBOLOWA", "FKKW", "None", "None", "02.53N", "011.10E", "628", "CM"],
    ["YOUNDE II", "FKKY", "None", "None", "03.49N", "011.31E", "751", "CM"],
    ["YAOUNDE", "FKYS", "None", "64950", "03.49N", "011.31E", "760", "CM"],
    ["MBALA (MIL/CIV)", "FLBA", "None", "67413", "08.50S", "031.19E", "1673", "ZM"],
    ["CHOMA", "FLCH", "None", "67753", "16.49S", "027.04E", "1278", "ZM"],
    ["CHIPATA", "FLCP", "None", "67581", "13.33S", "032.34E", "1032", "ZM"],
    ["ISOKA", "FLIK", "None", "67481", "10.07S", "032.37E", "1360", "ZM"],
    ["KAWAMBWA", "FLKB", "None", "67403", "09.48S", "029.04E", "1324", "ZM"],
    ["KAOMA", "FLKO", "None", "67641", "14.48S", "024.48E", "1213", "ZM"],
    ["KASAMA", "FLKS", "None", "67475", "10.13S", "031.07E", "1384", "ZM"],
    ["KABWE/MILLIKEN", "FLKW", "None", "67663", "14.26S", "028.28E", "1207", "ZM"],
    ["LUSAKA CITY AIRP", "FLLC", "None", "67666", "15.25S", "028.20E", "1280", "ZM"],
    ["LUNDAZI", "FLLD", "None", "67583", "12.16S", "033.12E", "1143", "ZM"],
    ["LIVINGSTONE (MIL", "FLLI", "None", "67743", "17.49S", "025.49E", "986", "ZM"],
    ["LIVINGSTONE NKUM", "FLHN", "None", "None", "17.49S", "025.49E", "986", "ZM"],
    ["LUSAKA KUANDA", "FLKK", "None", "67665", "15.19S", "028.27E", "1154", "ZM"],
    ["MANSA", "FLMA", "None", "67461", "11.05S", "028.51E", "1259", "ZM"],
    ["MFUWE", "FLMF", "MFU", "None", "13.16S", "031.56E", "561", "ZM"],
    ["MONGU", "FLMG", "None", "67633", "15.15S", "023.08E", "1053", "ZM"],
    ["MPIKA", "FLMP", "None", "67477", "11.54S", "031.25E", "1402", "ZM"],
    ["MWINILUNGA", "FLMW", "None", "67441", "11.45S", "024.25E", "1363", "ZM"],
    ["NDOLA", "FLND", "None", "67561", "13.00S", "028.38E", "1270", "ZM"],
    ["KASEMPA", "FLPA", "None", "67541", "13.31S", "025.51E", "1234", "ZM"],
    ["PETAUKE", "FLPE", "None", "67673", "14.15S", "031.16E", "1036", "ZM"],
    ["KABOMPO", "FLPO", "None", "67543", "13.35S", "024.11E", "1075", "ZM"],
    ["SERENJE", "FLSE", "None", "67571", "13.13S", "030.13E", "1384", "ZM"],
    ["NDOLA", "FLSK", "None", "None", "13.00S", "028.40E", "1261", "ZM"],
    ["SENANGA", "FLSN", "None", "67731", "16.06S", "023.16E", "1027", "ZM"],
    ["SESHEKE", "FLSS", "None", "67741", "17.28S", "024.18E", "951", "ZM"],
    ["SOLWEZI", "FLSW", "None", "67551", "12.10S", "026.22E", "1386", "ZM"],
    ["SAMFYA", "FLYA", "None", "67469", "11.20S", "029.31E", "1171", "ZM"],
    ["ZAMBEZI", "FLZB", "None", "67531", "13.31S", "023.07E", "1078", "ZM"],
    ["LUSAKA (MIL/CIV)", "FLLS", "None", "None", "15.19S", "028.26E", "1154", "ZM"],
    ["MORONI/HAHAIA IN", "FMCH", "None", "67002", "11.31S", "043.16E", "29", "KM"],
    ["MORONI/ICONI ARP", "FMCN", "None", "67001", "11.41S", "043.13E", "6", "KM"],
    ["ANJOUAN/OUANI", "FMCV", "None", "67004", "12.07S", "044.25E", "12", "KM"],
    ["DZAOUDZI/PAMANZI", "FMCZ", "None", "67005", "12.48S", "045.16E", "7", "KM"],
    ["ANTSIRABE", "FMME", "None", "67107", "19.49S", "047.04E", "1532", "KM"],
    ["MAHANORO", "FMMH", "None", "67113", "19.49S", "048.47E", "5", "KM"],
    ["ANTANANARIVO/IVA", "FMMI", "None", "67083", "18.48S", "047.28E", "1276", "KM"],
    ["MAINTIRANO", "FMMO", "None", "67073", "18.03S", "044.01E", "23", "KM"],
    ["SAINTE-MARIE ARP", "FMMS", "None", "67072", "17.04S", "049.49E", "3", "KM"],
    ["TAMATAVE/TOAMASI", "FMMT", "None", "67095", "18.07S", "049.23E", "6", "KM"],
    ["MORONDAVA", "FMMV", "None", "67117", "20.16S", "044.19E", "8", "KM"],
    ["DIEGO-SUAREZ/ANT", "FMNA", "None", "67009", "12.20S", "049.17E", "105", "KM"],
    ["ANDAPA", "FMND", "None", "67022", "14.39S", "049.37E", "474", "KM"],
    ["ANTALAHA/ANTSIRA", "FMNH", "None", "67025", "14.52S", "050.15E", "88", "KM"],
    ["ANALALAVA", "FMNL", "None", "67019", "14.37S", "047.46E", "57", "KM"],
    ["MAJUNGA/MAHAJANG", "FMNM", "None", "67027", "15.40S", "046.21E", "18", "KM"],
    ["NOSY BE/FASCENE", "FMNN", "None", "67012", "13.19S", "048.19E", "9", "KM"],
    ["BESALAMPY", "FMNQ", "None", "67037", "16.45S", "044.28E", "36", "KM"],
    ["SAMBAVA SUD", "FMNS", "None", "67023", "14.16S", "050.10E", "5", "KM"],
    ["VOHEMAR", "FMNV", "None", "67017", "13.22S", "050.00E", "5", "KM"],
    ["FT. DAUPHIN/TOLA", "FMSD", "None", "67197", "25.01S", "046.57E", "9", "KM"],
    ["FIANARANTSOA", "FMSF", "None", "67137", "21.26S", "047.06E", "1109", "KM"],
    ["FARAFANGANA", "FMSG", "None", "67157", "22.48S", "047.49E", "6", "KM"],
    ["MANANJARY", "FMSM", "None", "67143", "21.11S", "048.22E", "6", "KM"],
    ["RANOHIRA", "FMSO", "None", "67152", "22.33S", "045.23E", "824", "KM"],
    ["MOROMBE", "FMSR", "None", "67131", "21.45S", "043.22E", "4", "KM"],
    ["TULEAR/TOLIARA", "FMST", "None", "67161", "23.22S", "043.43E", "8", "KM"],
    ["ST. DENIS/GILLOT", "FMEE", "None", "61980", "20.52S", "055.31E", "25", "FR"],
    ["ST. PIERRE/FONDS", "FMEP", "None", "61984", "21.19S", "055.25E", "53", "FR"],
    ["BENGUELA/MONBACA", "FNBG", "None", "66310", "12.37S", "013.24E", "36", "AO"],
    ["CABINDA", "FNCA", "None", "66104", "05.32S", "012.10E", "20", "AO"],
    ["HUAMBO/NOVA LISB", "FNHU", "None", "66318", "12.49S", "015.46E", "1701", "AO"],
    ["BIE/KUITO/SILVA", "FNKU", "None", "66325", "12.22S", "016.56E", "1699", "AO"],
    ["LOBITO", "FNLB", "None", "66305", "12.22S", "013.31E", "3", "AO"],
    ["LUANDA/4 DE FEVE", "FNLU", "None", "66160", "08.50S", "013.13E", "70", "AO"],
    ["MALANGE", "FNMA", "None", "66215", "09.33S", "016.22E", "1142", "AO"],
    ["MENONGUE EAST/SE", "FNME", "None", "66410", "14.39S", "017.40E", "1343", "AO"],
    ["PORTO AMBOIM", "FNPA", "None", "66240", "10.41S", "013.45E", "5", "AO"],
    ["SAURIMO/HENRIQUE", "FNSA", "None", "66226", "09.41S", "020.26E", "1093", "AO"],
    ["WAKU KUNGU/CELA", "FNWK", "None", "66270", "11.25S", "015.07E", "1304", "AO"],
    ["N'ZETO/AMBRIZETE", "FNZE", "None", "66130", "07.13S", "012.52E", "17", "AO"],
    ["MOUILA CITY", "FOGM", "None", "64550", "01.52S", "011.01E", "89", "GA"],
    ["LAMBARENE", "FOGR", "None", "64551", "00.43S", "010.13E", "26", "GA"],
    ["BITAM", "FOOB", "None", "64510", "02.04N", "011.28E", "599", "GA"],
    ["COCOBEACH", "FOOC", "None", "64504", "01.00N", "009.35E", "13", "GA"],
    ["MOANDA", "FOOD", "None", "64565", "01.31S", "013.16E", "573", "GA"],
    ["MEKAMBO", "FOOE", "None", "64545", "01.01N", "013.55E", "501", "GA"],
    ["PORT GENTIL", "FOOG", "None", "64501", "00.42S", "008.45E", "4", "GA"],
    ["MAKOKOU/EPASSENG", "FOOK", "None", "64556", "00.34N", "012.52E", "515", "GA"],
    ["LIBREVILLE/LEON", "FOOL", "None", "64500", "00.27N", "009.25E", "15", "GA"],
    ["MITZIC", "FOOM", "None", "64552", "00.46N", "011.31E", "583", "GA"],
    ["FRANCEVILLE/MVEN", "FOON", "None", "None", "01.38S", "013.25E", "441", "GA"],
    ["LASTOURSVILLE", "FOOR", "None", "64560", "00.49S", "012.43E", "485", "GA"],
    ["TCHIBANGA", "FOOT", "None", "64507", "02.51S", "011.01E", "79", "GA"],
    ["MAYUMBA", "FOOY", "None", "64503", "03.25S", "010.39E", "34", "GA"],
    ["PRINCIPE ISLAND", "FPPR", "None", "61934", "01.38N", "007.25E", "5", "ST"],
    ["SAO TOME IL/SALA", "FPST", "None", "61931", "00.22N", "006.43E", "13", "ST"],
    ["ANGOCHE", "FQAG", "None", "67273", "16.13S", "039.53E", "62", "MZ"],
    ["BEIRA", "FQBR", "None", "67297", "19.48S", "034.53E", "16", "MZ"],
    ["CUAMBA", "FQCB", "None", "67231", "14.49S", "036.31E", "607", "MZ"],
    ["CHIMOIO", "FQCH", "None", "67295", "19.09S", "033.26E", "732", "MZ"],
    ["FURANCUNGO", "FQFU", "None", "None", "14.55S", "033.37E", "1262", "MZ"],
    ["INHAMBANE", "FQIN", "None", "67323", "23.52S", "035.22E", "15", "MZ"],
    ["LICHINGA", "FQLC", "None", "67217", "13.16S", "035.15E", "1365", "MZ"],
    ["LUMBO", "FQLU", "None", "67241", "15.01S", "040.40E", "11", "MZ"],
    ["MAPUTO/MAVALANE", "FQMA", "None", "67341", "25.55S", "032.34E", "44", "MZ"],
    ["MOCIMBOA DA PRAI", "FQMP", "None", "67205", "11.20S", "040.22E", "29", "MZ"],
    ["MARRUPA", "FQMR", "None", "67221", "13.43S", "037.32E", "838", "MZ"],
    ["MUTARARA", "FQMU", "None", "None", "17.22S", "035.01E", "89", "MZ"],
    ["NAMPULA", "FQNP", "None", "67237", "15.05S", "039.16E", "441", "MZ"],
    ["PEMBA", "FQPB", "None", "67215", "12.58S", "040.30E", "50", "MZ"],
    ["QUELIMANE", "FQQL", "None", "67283", "17.52S", "036.52E", "16", "MZ"],
    ["SONGO", "FQSG", "None", "None", "15.35S", "032.46E", "882", "MZ"],
    ["TETE", "FQTE", "None", "67261", "16.10S", "033.34E", "150", "MZ"],
    ["TETE/CHINGOZI", "FQTT", "None", "None", "16.06S", "033.37E", "160", "MZ"],
    ["ULONGUE", "FQUG", "None", "67229", "14.13S", "034.21E", "1311", "MZ"],
    ["VILANCULOS", "FQVL", "None", "67315", "22.00S", "035.19E", "21", "MZ"],
    ["XAI XAI", "FQXA", "None", "67335", "25.03S", "033.37E", "5", "MZ"],
    ["SEYCHELLES INTL", "FSIA", "None", "63980", "04.40S", "055.31E", "3", "SC"],
    ["SEYCHELLES INTL", "FSSS", "None", "63985", "04.40S", "055.31E", "4", "SC"],
    ["DESROCHES", "None", "None", "63998", "05.41S", "053.40E", "3", "SC"],
    ["LAI", "FTTH", "None", "None", "09.24N", "016.18E", "356", "TD"],
    ["SARH (CIV/MIL)", "FTTA", "None", "64750", "09.09N", "018.22E", "365", "TD"],
    ["BONGOR", "FTTB", "None", "None", "10.17N", "015.23E", "328", "TD"],
    ["ABECHE", "FTTC", "None", "64756", "13.50N", "020.51E", "549", "TD"],
    ["MOUNDOU", "FTTD", "None", "64706", "08.37N", "016.04E", "422", "TD"],
    ["ATI", "FTTI", "None", "64751", "13.13N", "018.19E", "334", "TD"],
    ["NDJAMENA (CIV/MI", "FTTJ", "None", "64700", "12.07N", "015.01E", "295", "TD"],
    ["BOKORO", "FTTK", "None", "64708", "12.22N", "017.03E", "301", "TD"],
    ["BOL-BERIM", "FTTL", "None", "64702", "13.25N", "014.43E", "292", "TD"],
    ["MONGO", "FTTM", "None", "64758", "12.07N", "018.25E", "428", "TD"],
    ["AM-TIMAN", "FTTN", "None", "64754", "11.01N", "020.16E", "436", "TD"],
    ["PALA", "FTTP", "None", "64709", "09.22N", "014.55E", "455", "TD"],
    ["ZOUAR", "FTTR", "None", "None", "20.26N", "016.34E", "809", "TD"],
    ["FAYA-LARGEAU (MI", "FTTY", "None", "64753", "18.00N", "019.10E", "234", "TD"],
    ["BARDAI-ZOUGRA(MI", "FTTZ", "None", "None", "21.26N", "017.03E", "1074", "TD"],
    ["BEITBRIDGE", "FVBB", "None", "67991", "22.13S", "030.00E", "457", "ZW"],
    ["BINGA", "FVBI", "None", "67755", "17.37S", "027.19E", "617", "ZW"],
    ["BULAWAYO/WOODVAL", "FVBU", "None", "67965", "20.01S", "028.37E", "1326", "ZW"],
    ["CHIPINGE", "FVCH", "None", "67983", "20.11S", "032.37E", "1132", "ZW"],
    ["CHIREDZI/BUFFALO", "FVCZ", "None", "67977", "21.01S", "031.34E", "430", "ZW"],
    ["VICTORIA FALLS", "FVFA", "None", "67843", "18.06S", "025.51E", "1062", "ZW"],
    ["GOKWE", "FVGO", "None", "67861", "18.13S", "028.55E", "1282", "ZW"],
    ["MUTARE/GRAND REE", "FVGR", "None", "None", "18.58S", "032.27E", "1019", "ZW"],
    ["HARARE/KUTSAGA(M", "FVHA", "None", "67775", "17.55S", "031.07E", "1503", "ZW"],
    ["KAROI", "FVKA", "None", "67765", "16.49S", "029.37E", "1344", "ZW"],
    ["KARIBA", "FVKB", "None", "67761", "16.31S", "028.52E", "518", "ZW"],
    ["MUTOKO", "FVMT", "None", "67781", "17.25S", "032.13E", "1244", "ZW"],
    ["MASVINGO", "FVMV", "None", "67975", "20.04S", "030.52E", "1095", "ZW"],
    ["RUSAPE", "FVRU", "None", "67881", "18.31S", "032.07E", "1430", "ZW"],
    ["GWERU/THORNHILL", "FVTL", "None", "67867", "19.26S", "029.51E", "1429", "ZW"],
    ["HWANGE NATL. PAR", "FVWN", "None", "67853", "18.37S", "027.00E", "1077", "ZW"],
    ["CHILEKA INTL ARP", "FWCL", "None", "67693", "15.40S", "034.58E", "767", "MW"],
    ["CHITIPA", "FWCT", "None", "67421", "09.41S", "033.16E", "1278", "MW"],
    ["DEDZA", "FWDZ", "None", "67689", "14.19S", "034.16E", "1632", "MW"],
    ["KARONGA", "FWKA", "None", "67423", "09.56S", "033.52E", "529", "MW"],
    ["KAMUZU INTL AIRP", "FWKI", "None", "67586", "13.46S", "033.46E", "1229", "MW"],
    ["NKHOTA KOTA", "FWKK", "None", "67591", "12.55S", "034.16E", "500", "MW"],
    ["LILONGWE INTL AR", "FWLI", "LLW", "None", "13.47S", "033.47E", "1230", "MW"],
    ["LILONGWE INTL AR", "FWLL", "None", "67587", "13.58S", "033.46E", "1067", "MW"],
    ["MANGOCHI", "FWMG", "None", "67695", "14.25S", "035.15E", "485", "MW"],
    ["MONKEY BAY", "FWMY", "None", "67690", "14.04S", "034.55E", "474", "MW"],
    ["MZIMBA", "FWMZ", "None", "67485", "11.52S", "033.37E", "1351", "MW"],
    ["SALIMA", "FWSM", "None", "67597", "13.45S", "034.34E", "513", "MW"],
    ["MZUZU", "FWUU", "None", "67489", "11.26S", "034.01E", "1253", "MW"],
    ["MASERU/MOSHOESHO", "FXMM", "None", "None", "29.28S", "027.33E", "1631", "LS"],
    ["MEJAMETALANA/MAS", "FXMU", "None", "68454", "29.18S", "027.30E", "1556", "LS"],
    ["AROAB", "FYAB", "None", "None", "26.46S", "019.38E", "986", "NA"],
    ["ARANOS", "FYAN", "None", "None", "24.09S", "019.07E", "1189", "NA"],
    ["AUS", "FYAS", "None", "None", "26.42S", "016.19E", "1480", "NA"],
    ["BAGANI", "FYBG", "None", "None", "18.07S", "021.38E", "1011", "NA"],
    ["EENHANA", "FYEN", "None", "None", "17.29S", "016.19E", "1116", "NA"],
    ["GOBABIS ARPT", "FYGB", "None", "None", "22.30S", "018.58E", "1442", "NA"],
    ["GOBABEB", "FYGO", "None", "68106", "23.34S", "015.03E", "400", "NA"],
    ["GROOTFONTEIN", "FYGF", "None", "68014", "19.36S", "018.07E", "1400", "NA"],
    ["HENTIES BAY", "FYGN", "None", "None", "19.36S", "018.07E", "1400", "NA"],
    ["HENTIES BAY", "FYHN", "None", "None", "22.07S", "014.17E", "3", "NA"],
    ["KARASBURG", "FYKB", "None", "None", "28.02S", "018.44E", "1017", "NA"],
    ["KEETMANSHOOP", "FYKT", "None", "68312", "26.31S", "018.07E", "1061", "NA"],
    ["KHORIXAS", "FYKX", "None", "None", "20.22S", "014.58E", "1026", "NA"],
    ["KATIMA MULILO", "FYKM", "None", "None", "17.38S", "024.11E", "958", "NA"],
    ["LUDERITZ/DIAZ PO", "FYLZ", "None", "None", "26.40S", "015.15E", "130", "NA"],
    ["MALTAHOEHE", "FYMH", "None", "None", "24.46S", "016.59E", "1375", "NA"],
    ["MARIENTAL ARPT", "FYML", "None", "None", "24.36S", "017.56E", "1113", "NA"],
    ["NOORDOEWER", "FYND", "None", "None", "28.45S", "017.37E", "150", "NA"],
    ["ONDANGWA", "FYOA", "OND", "None", "17.53S", "015.58E", "1095", "NA"],
    ["OKAHAO", "FYOH", "None", "None", "17.53S", "015.04E", "1097", "NA"],
    ["OUTJO AIRPORT", "FYOJ", "None", "None", "20.05S", "016.08E", "1321", "NA"],
    ["OKAKARARA", "FYOK", "None", "None", "20.36S", "017.28E", "1360", "NA"],
    ["OMARURU", "FYOM", "None", "None", "21.25S", "015.56E", "1217", "NA"],
    ["OKAUKUEJO ARPT", "FYOO", "None", "None", "19.09S", "015.55E", "1192", "NA"],
    ["OSHAKATI", "FYOS", "None", "None", "17.48S", "015.42E", "1097", "NA"],
    ["OOTMOED", "FYOT", "None", "None", "24.01S", "019.44E", "1200", "NA"],
    ["OTJIWARONGO ARPT", "FYOW", "None", "None", "20.26S", "016.40E", "1481", "NA"],
    ["REHOBETH", "FYRH", "None", "None", "23.19S", "017.05E", "1380", "NA"],
    ["ROOIKOP (SAAF/CI", "FYRK", "None", "None", "22.58S", "014.39E", "88", "NA"],
    ["RUNDU", "FYRU", "None", "68018", "17.55S", "019.46E", "1100", "NA"],
    ["TERRACE BAY", "FYTE", "None", "None", "19.58S", "013.01E", "5", "NA"],
    ["TSUMKWE", "FYTK", "None", "None", "19.35S", "020.27E", "1152", "NA"],
    ["TSUMEB", "FYTM", "None", "None", "19.16S", "017.44E", "1327", "NA"],
    ["OTJINENE", "FYTN", "None", "None", "21.08S", "018.47E", "443", "NA"],
    ["WALVIS BAY", "FYWB", "None", "None", "22.59S", "014.39E", "46", "NA"],
    ["EROS AIRPORT", "FYWE", "None", "None", "22.37S", "017.05E", "1700", "NA"],
    ["J. G. STRIJDOM", "FYWH", "None", "68112", "22.28S", "017.28E", "1700", "NA"],
    ["WINDHOEK", "FYWW", "None", "None", "22.34S", "017.06E", "1725", "NA"],
    ["KUNDUZ", "EQBA", "None", "99876", "36.40N", "068.55E", "433", "AF"],
    ["FEYZABAD", "EQBF", "None", "99881", "37.07N", "070.34E", "1200", "AF"],
    ["CAMP BASTION", "EQBH", "None", "99883", "31.52N", "064.12E", "900", "AF"],
    ["CHAGCHARAN", "EQBI", "None", "99884", "34.52N", "065.27E", "2252", "AF"],
    ["MARZAR I SHARIF", "EQBM", "None", "99888", "36.42N", "067.12E", "378", "AF"],
    ["KANDAHAR", "EQCB", "None", "99903", "31.31N", "065.52E", "1010", "AF"],
    ["TARIN KOWT", "EQTK", "None", "99915", "32.36N", "065.51E", "1357", "AF"],
    ["KABUL INTL (MIL)", "OAKB", "None", "40948", "34.33N", "069.13E", "1791", "AF"],
    ["ASMAR", "OAAS", "None", "40934", "35.01N", "071.25E", "880", "AF"],
    ["BEHSOOD", "OABD", "None", "None", "34.17N", "067.50E", "2975", "AF"],
    ["BAMIYAN", "OABN", "None", "40945", "34.49N", "067.49E", "2550", "AF"],
    ["WAZAKHAW", "OADW", "None", "None", "32.12N", "068.20E", "2800", "AF"],
    ["DARWAZ", "OADZ", "None", "40900", "38.25N", "070.47E", "1320", "AF"],
    ["KESHM", "OAEK", "None", "40917", "36.51N", "070.04E", "1000", "AF"],
    ["ISKACHEM/ESHKASH", "OAEM", "None", "40918", "36.42N", "071.34E", "2620", "AF"],
    ["ISLAM-QALA", "OAEQ", "None", "40935", "34.38N", "061.34E", "800", "AF"],
    ["FARAH", "OAFR", "None", "40974", "32.22N", "062.10E", "700", "AF"],
    ["FAIZABAD", "OAFZ", "None", "40904", "37.07N", "070.31E", "1200", "AF"],
    ["GULISTAN", "OAGL", "None", "None", "32.37N", "063.40E", "1375", "AF"],
    ["GHELMEEN", "OAGM", "None", "40941", "34.52N", "065.17E", "2070", "AF"],
    ["GHAZNI", "OAGN", "None", "40968", "33.31N", "068.25E", "2183", "AF"],
    ["GARDEZ", "OAGZ", "None", "40970", "33.37N", "069.14E", "2350", "AF"],
    ["HAJIGAK", "OAHJ", "None", "40933", "34.34N", "068.05E", "3400", "AF"],
    ["KHWAHAN", "OAHN", "None", "40901", "37.52N", "070.13E", "1040", "AF"],
    ["HERAT", "OAHR", "None", "40938", "34.13N", "062.13E", "964", "AF"],
    ["JALALABAD (MIL)", "OAJL", "None", "40954", "34.25N", "070.28E", "580", "AF"],
    ["JABUL-SARAJ", "OAJS", "None", "40932", "35.07N", "069.15E", "1630", "AF"],
    ["KAJAKI", "OAKJ", "None", "None", "32.10N", "065.05E", "1000", "AF"],
    ["KANDAHAR INTL AR", "OAKN", "KDH", "40990", "31.30N", "065.50E", "1010", "AF"],
    ["KALDAR", "OAKR", "None", "40924", "37.12N", "067.43E", "304", "AF"],
    ["KHOST", "OAKS", "None", "40971", "33.21N", "069.57E", "1146", "AF"],
    ["KALAT", "OAKT", "None", "None", "32.07N", "066.54E", "1565", "AF"],
    ["LAL", "OALL", "None", "40944", "34.30N", "066.17E", "2800", "AF"],
    ["MAIMANA/MIMANA", "OAMN", "None", "40922", "35.55N", "064.45E", "815", "AF"],
    ["MAZAR-I-SHARIF", "OAMS", "None", "40911", "36.42N", "067.12E", "378", "AF"],
    ["URGOON", "OAOG", "None", "40984", "32.55N", "069.07E", "2262", "AF"],
    ["PAGHMAN", "OAPG", "None", "None", "34.34N", "068.58E", "2114", "AF"],
    ["PAN JAO", "OAPJ", "None", "None", "34.22N", "067.01E", "2710", "AF"],
    ["QADES", "OAQD", "None", "40939", "34.47N", "063.25E", "1280", "AF"],
    ["QALA-I-NOW", "OAQN", "None", "40937", "35.00N", "063.07E", "914", "AF"],
    ["SHINDAND", "OASD", "None", "40957", "33.23N", "062.16E", "1150", "AF"],
    ["SHEBIRGHAN", "OASG", "None", "40908", "36.40N", "065.43E", "360", "AF"],
    ["KUNDUZ", "OAUZ", "None", "40913", "36.40N", "068.55E", "433", "AF"],
    ["YANGI QALA", "OAYQ", "None", "40928", "37.28N", "069.40E", "810", "AF"],
    ["ZEBAK", "OAZB", "None", "40920", "36.30N", "071.15E", "2600", "AF"],
    ["BAHRAIN INTL ARP", "OBBI", "None", "41150", "26.16N", "050.38E", "2", "BH"],
    ["ABHA", "OEAB", "None", "41112", "18.13N", "042.38E", "2084", "SA"],
    ["AL AHSA", "OEAH", "None", "40420", "25.16N", "049.28E", "172", "SA"],
    ["PRINCE ABDULMAJE", "OEAO", "None", "40401", "26.29N", "038.07E", "624", "SA"],
    ["AL BAHA", "OEBA", "None", "41055", "20.18N", "041.37E", "1656", "SA"],
    ["AL DAWADMI", "OEDM", "None", "None", "24.27N", "044.07E", "922", "SA"],
    ["BISHA (CIV/MIL)", "OEBH", "None", "41084", "19.58N", "042.37E", "1157", "SA"],
    ["KING FAHD INTL", "OEDF", "None", "None", "26.28N", "049.48E", "22", "SA"],
    ["DHAHRAN INTL (MI", "OEDR", "None", "40416", "26.16N", "050.10E", "17", "SA"],
    ["DAWADMI", "OEDW", "None", "40435", "24.30N", "044.23E", "990", "SA"],
    ["GIZAN", "OEGN", "None", "41140", "16.53N", "042.34E", "3", "SA"],
    ["GASSIM", "OEGS", "None", "40405", "26.18N", "043.46E", "650", "SA"],
    ["GURIAT", "OEGT", "None", "40360", "31.25N", "037.16E", "499", "SA"],
    ["HAIL", "OEHL", "None", "40394", "27.25N", "041.40E", "1013", "SA"],
    ["JUBAIL(NAVAL)", "OEJB", "None", "None", "27.03N", "049.23E", "8", "SA"],
    ["JEDDAH", "OEJD", "None", "41026", "21.30N", "039.12E", "15", "SA"],
    ["JEDDAH/KING ABDU", "OEJN", "None", "41024", "21.41N", "039.09E", "15", "SA"],
    ["KAIBER", "OEKB", "None", "None", "25.40N", "039.23E", "754", "SA"],
    ["AL KHARJ AB", "OEKJ", "None", "None", "24.04N", "047.35E", "503", "SA"],
    ["PRINCE SULTAN AB", "OEPS", "None", "None", "24.04N", "047.35E", "503", "SA"],
    ["KING KHALID MIL", "OEKK", "None", "40377", "27.53N", "045.31E", "413", "SA"],
    ["KHAMIS MUSHAIT A", "OEKM", "None", "41114", "18.18N", "042.47E", "2054", "SA"],
    ["MADINAH INTL ARP", "OEMA", "None", "40430", "24.33N", "039.42E", "631", "SA"],
    ["MAKKAH/MECCA", "OEMK", "None", "41030", "21.26N", "040.00E", "369", "SA"],
    ["MUAYH", "OEMH", "None", "None", "22.26N", "041.42E", "971", "SA"],
    ["NEJRAN", "OENG", "None", "41128", "17.37N", "044.25E", "1203", "SA"],
    ["HAFR AL-BATIN AR", "OEPA", "None", "40373", "28.19N", "046.07E", "355", "SA"],
    ["RAFHA (PRIVATE)", "OERF", "None", "40362", "29.37N", "043.28E", "447", "SA"],
    ["RIYADH/KING KHAL", "OERK", "None", "40437", "24.57N", "046.43E", "612", "SA"],
    ["ARAR", "OERR", "None", "40357", "30.53N", "041.07E", "552", "SA"],
    ["RIYADH (SAUD-AFB", "OERY", "None", "40438", "24.43N", "046.43E", "612", "SA"],
    ["SHARURAH (CIV/MI", "OESH", "None", "41136", "17.28N", "047.07E", "722", "SA"],
    ["AL-JOUF (CIV/MIL", "OESK", "None", "40361", "29.46N", "040.06E", "684", "SA"],
    ["TABUK (SAUD-AFB)", "OETB", "None", "40375", "28.22N", "036.37E", "770", "SA"],
    ["TAIF (CIV/MIL)", "OETF", "None", "41036", "21.28N", "040.32E", "1449", "SA"],
    ["TURAIF", "OETR", "None", "40356", "31.42N", "038.44E", "855", "SA"],
    ["WADI AL DAWASER", "OEWD", "None", "41061", "20.30N", "045.12E", "617", "SA"],
    ["WEJH", "OEWJ", "None", "40400", "26.11N", "036.28E", "16", "SA"],
    ["YENBO", "OEYN", "None", "40439", "24.08N", "038.04E", "8", "SA"],
    ["ABADAN INTL AIRP", "OIAA", "None", "40831", "30.22N", "048.15E", "11", "IR"],
    ["DEZFUL (IRAN-AFB", "OIAD", "None", "40795", "32.26N", "048.24E", "143", "IR"],
    ["AGHA JARI", "OIAG", "None", "40833", "30.46N", "049.40E", "29", "IR"],
    ["GACH SARAN(PRIVA", "OIAH", "None", "40835", "30.20N", "050.50E", "738", "IR"],
    ["MASJED-SOLEYMAN", "OIAI", "None", "40812", "32.00N", "049.16E", "372", "IR"],
    ["BANDAR MAHSHAHR", "OIAM", "None", "40832", "30.33N", "049.09E", "4", "IR"],
    ["AHWAZ", "OIAW", "None", "40811", "31.19N", "048.46E", "22", "IR"],
    ["BUSHEHR (CIV/AFB", "OIBB", "None", "40858", "28.58N", "050.49E", "19", "IR"],
    ["KISH ISLAND", "OIBK", "KIH", "None", "26.32N", "053.59E", "30", "IR"],
    ["BANDAR LENGEH", "OIBL", "None", "40883", "26.32N", "054.49E", "14", "IR"],
    ["KERMANSHAH/BAKTA", "OICC", "None", "40766", "34.20N", "047.10E", "1322", "IR"],
    ["GHASRE-SHIRIN", "OICG", "None", "40765", "34.31N", "045.34E", "378", "IR"],
    ["BORUJERD", "OICJ", "None", "None", "33.54N", "048.45E", "1600", "IR"],
    ["KHORAM ABAD", "OICK", "KHD", "None", "33.26N", "048.17E", "1155", "IR"],
    ["SANANDAJ", "OICS", "None", "40747", "35.15N", "047.01E", "1373", "IR"],
    ["KASHAN", "OIFK", "None", "40785", "33.54N", "051.35E", "982", "IR"],
    ["ESFAHAN S B INTL", "OIFM", "None", "40800", "32.45N", "051.52E", "1542", "IR"],
    ["SHAHRE-KORD", "OIFS", "None", "40798", "32.19N", "050.51E", "2078", "IR"],
    ["RASHT", "OIGG", "None", "40719", "37.20N", "049.36E", "-13", "IR"],
    ["KERMANSHAH", "OIGK", "None", "None", "34.17N", "047.07E", "1322", "IR"],
    ["HAMADAN", "OIHH", "None", "None", "34.52N", "048.33E", "1757", "IR"],
    ["ARAK", "OIHR", "None", "40769", "34.08N", "049.51E", "1658", "IR"],
    ["TEHRAN/MEHRABAD", "OIII", "None", "40754", "35.41N", "051.18E", "1191", "IR"],
    ["GHAZVIN", "OIIK", "None", "40731", "36.15N", "050.03E", "1278", "IR"],
    ["KARAJ/PAYAM", "OIIP", "None", "None", "35.47N", "050.50E", "1271", "IR"],
    ["GHOM/QOM", "OIIQ", "None", "None", "34.38N", "050.53E", "928", "IR"],
    ["SEMNAN", "OIIS", "None", "40757", "35.23N", "053.40E", "1115", "IR"],
    ["BANDAR ABBAS INT", "OIKB", "None", "40875", "27.13N", "056.22E", "10", "IR"],
    ["KERMAN", "OIKK", "None", "40841", "30.15N", "056.58E", "1754", "IR"],
    ["BAM", "OIKM", "None", "40854", "29.05N", "058.27E", "985", "IR"],
    ["MINAB", "OIKO", "None", "None", "27.08N", "057.06E", "27", "IR"],
    ["GHESHM/DAYRESTAN", "OIKQ", "None", "None", "26.45N", "055.54E", "12", "IR"],
    ["BIRJAND", "OIMB", "None", "40809", "32.54N", "059.17E", "1491", "IR"],
    ["TORBAT-HEYDARIEH", "OIMH", "None", "40762", "35.16N", "059.13E", "1333", "IR"],
    ["MASHHAD (AFB/CIV", "OIMM", "None", "40745", "36.14N", "059.37E", "980", "IR"],
    ["BOJNOURD", "OIMN", "None", "40723", "37.29N", "057.18E", "1074", "IR"],
    ["KASMAR", "OIMQ", "None", "None", "35.14N", "058.28E", "1140", "IR"],
    ["SABZEVAR", "OIMS", "None", "40743", "36.10N", "057.36E", "941", "IR"],
    ["TABAS", "OIMT", "None", "40791", "33.40N", "056.55E", "711", "IR"],
    ["KALALEH", "OINE", "None", "None", "37.23N", "055.27E", "130", "IR"],
    ["GORGAN", "OING", "None", "40738", "36.54N", "054.24E", "155", "IR"],
    ["GONBAD GHABUS", "OINK", "None", "None", "37.15N", "055.06E", "33", "IR"],
    ["NOSHAHR", "OINN", "None", "None", "36.40N", "051.28E", "-19", "IR"],
    ["RAMSAR", "OINR", "None", "40732", "36.53N", "050.40E", "-20", "IR"],
    ["SARY DASHTE NAZ", "OINZ", "None", "None", "36.38N", "053.12E", "11", "IR"],
    ["ABADEH", "OISA", "None", "40818", "31.02N", "052.47E", "2004", "IR"],
    ["FASA", "OISF", "None", "40859", "28.54N", "053.43E", "1383", "IR"],
    ["SHIRAZ (CIV/AFB)", "OISS", "None", "40848", "29.31N", "052.34E", "1491", "IR"],
    ["KHOY", "OITK", "None", "40703", "38.25N", "044.59E", "1107", "IR"],
    ["PARSABAD", "OITP", "None", "None", "39.36N", "047.53E", "77", "IR"],
    ["ARDABIL", "OITL", "None", "None", "38.20N", "048.25E", "1316", "IR"],
    ["ORUMIEH", "OITR", "None", "40712", "37.40N", "045.04E", "1312", "IR"],
    ["SAGHEZ", "OITS", "None", "40727", "36.15N", "046.16E", "1493", "IR"],
    ["TABRIZ(IRAN-AB/C", "OITT", "None", "40706", "38.08N", "046.14E", "1361", "IR"],
    ["ZANJAN", "OITZ", "None", "40729", "36.46N", "048.22E", "1663", "IR"],
    ["YAZD", "OIYY", "None", "40821", "31.54N", "054.17E", "1236", "IR"],
    ["ZABOL", "OIZB", "None", "40829", "31.06N", "061.33E", "489", "IR"],
    ["CHAH BAHAR (IR-A", "OIZC", "None", "40898", "25.27N", "060.23E", "6", "IR"],
    ["ZAHEDAN INTL ARP", "OIZH", "None", "40856", "29.28N", "060.55E", "1370", "IR"],
    ["IRANSHAHR", "OIZI", "None", "40879", "27.14N", "060.43E", "591", "IR"],
    ["JASK", "OIZJ", "None", "40893", "25.39N", "057.48E", "4", "IR"],
    ["ABUMUSA ISLAND", "OIBA", "None", "None", "25.53N", "055.02E", "7", "IR"],
    ["JAM AIRPORT", "OIBJ", "None", "None", "27.49N", "052.21E", "663", "IR"],
    ["PERSIAN GULF APT", "OIBP", "None", "None", "27.23N", "052.44E", "9", "IR"],
    ["KHARK ISLAND", "OIBQ", "None", "None", "29.16N", "050.19E", "6", "IR"],
    ["SIRRI ISLAND", "OIBS", "None", "None", "25.54N", "054.33E", "14", "IR"],
    ["LAVAN ISLAND", "OIBV", "None", "None", "26.49N", "053.21E", "24", "IR"],
    ["ILAM AIRPORT", "OICI", "None", "None", "33.35N", "046.24E", "1343", "IR"],
    ["MALAYER AIRPORT", "OIHM", "None", "None", "34.17N", "048.49E", "1726", "IR"],
    ["IMAM KHOMEINI", "OIIE", "None", "None", "35.25N", "051.09E", "1008", "IR"],
    ["RAFSANJAN", "OIKR", "None", "None", "30.18N", "056.03E", "1615", "IR"],
    ["SARAKHS", "OIMC", "None", "None", "36.30N", "061.04E", "288", "IR"],
    ["GONABAD", "OIMD", "None", "None", "34.23N", "058.38E", "1100", "IR"],
    ["BABOLSAR", "OINB", "None", "None", "36.43N", "052.39E", "-15", "IR"],
    ["LAR AIRPORT", "OISL", "None", "None", "27.40N", "054.22E", "805", "IR"],
    ["LAMERD AIRPORT", "OISR", "None", "None", "27.22N", "053.12E", "408", "IR"],
    ["YASOUJ AIRPORT", "OISY", "None", "None", "30.42N", "051.33E", "1811", "IR"],
    ["SAHAND AIRPORT", "OITM", "None", "None", "37.21N", "046.09E", "1340", "IR"],
    ["MAKOU AIRPORT", "OITU", "None", "None", "39.20N", "044.26E", "1364", "IR"],
    ["QUEEN ALIA INTL", "OJAI", "None", "40272", "31.43N", "036.00E", "730", "JO"],
    ["AMMAN/KING ABDUL", "OJAM", "None", "40270", "31.58N", "035.58E", "773", "JO"],
    ["AQABA INTL AIRPO", "OJAQ", "None", "40340", "29.37N", "035.01E", "51", "JO"],
    ["IRBID (MET)", "OJBD", "None", "40255", "32.32N", "035.51E", "619", "JO"],
    ["HOTEL-5 'SAFAWI'", "OJHF", "None", "40260", "32.12N", "037.07E", "670", "JO"],
    ["HOTEL-4 'IRWAISH", "OJHR", "None", "40250", "32.30N", "038.12E", "688", "JO"],
    ["MAFRAQ (JOR-AFB)", "OJMF", "None", "40265", "32.22N", "036.15E", "687", "JO"],
    ["MA'AN", "OJMN", "None", "40310", "30.10N", "035.46E", "1070", "JO"],
    ["KUWAIT INTL (MIL", "OKBK", "None", "40582", "29.13N", "047.58E", "55", "KW"],
    ["BEIRUT (CIV/MIL)", "OLBA", "None", "40100", "33.49N", "035.28E", "19", "LB"],
    ["ABU DHABI INTL", "OMAA", "None", "41217", "24.25N", "054.38E", "27", "AE"],
    ["BUHASA", "OMAB", "None", "None", "23.37N", "053.22E", "94", "AE"],
    ["ABU DHABI/BATEEN", "OMAD", "None", "41216", "24.25N", "054.28E", "3", "AE"],
    ["AL HAMRA AUX", "OMAH", "None", "None", "24.05N", "052.28E", "16", "AE"],
    ["AL AIN INTNL ARP", "OMAL", "None", "41218", "24.15N", "055.36E", "262", "AE"],
    ["DUBAI INTL AIRPO", "OMDB", "None", "41194", "25.15N", "055.22E", "5", "AE"],
    ["DELMA ISLAND", "OMDL", "None", "None", "24.30N", "052.20E", "25", "AE"],
    ["AL MINHAD AIRB", "OMDM", "None", "None", "25.02N", "055.22E", "51", "AE"],
    ["DUBAI AL MAKTOUM", "OMDW", "None", "None", "24.54N", "055.10E", "25", "AE"],
    ["FUJAIRAH INTL AR", "OMFJ", "None", "41198", "25.06N", "056.19E", "28", "AE"],
    ["RAS AL KHAIMAH", "OMRK", "None", "41184", "25.37N", "055.55E", "31", "AE"],
    ["SHARJAH INTL ARP", "OMSJ", "None", "41196", "25.19N", "055.31E", "33", "AE"],
    ["BURAIMI (AUT)", "OOBR", "None", "41244", "24.13N", "055.46E", "299", "OM"],
    ["FAHUD (AUT)", "OOFD", "None", "41262", "22.21N", "056.28E", "170", "OM"],
    ["GHABA CENTRAL(PV", "OOGB", "None", "None", "21.22N", "057.02E", "135", "OM"],
    ["HAIMA", "OOHA", "None", "None", "19.58N", "056.16E", "122", "OM"],
    ["IBRA", "OOIA", "None", "None", "22.37N", "058.40E", "1100", "OM"],
    ["IBRI", "OOII", "None", "None", "23.16N", "056.31E", "1000", "OM"],
    ["KHASSAB (MIL)", "OOKB", "None", "41240", "26.13N", "056.13E", "3", "OM"],
    ["MASIRAH (OM-AFB)", "OOMA", "None", "41288", "20.40N", "058.53E", "19", "OM"],
    ["SEEB INTL/MUSCAT", "OOMS", "None", "41256", "23.34N", "058.16E", "8", "OM"],
    ["NIZWA", "OONZ", "None", "None", "22.55N", "057.31E", "1900", "OM"],
    ["SALALAH", "OOSA", "None", "41316", "17.01N", "054.04E", "20", "OM"],
    ["SOHAR MAJIS", "OOSH", "None", "41246", "24.28N", "056.37E", "4", "OM"],
    ["SAIQ", "OOSQ", "None", "41254", "23.04N", "057.38E", "1755", "OM"],
    ["SUR", "OOSR", "None", "41268", "22.31N", "059.28E", "14", "OM"],
    ["THUMRAIT (OM-AFB", "OOTH", "None", "41314", "17.40N", "054.01E", "445", "OM"],
    ["BANNU", "OPBN", "None", "None", "32.58N", "070.31E", "404", "PK"],
    ["BAHAWALPUR", "OPBW", "None", "41700", "29.21N", "071.43E", "120", "PK"],
    ["CHITRAL", "OPCH", "None", "41506", "35.51N", "071.49E", "1500", "PK"],
    ["DERA GHAZI", "OPDG", "None", "None", "29.58N", "070.29E", "150", "PK"],
    ["DERA ISMAIL KHAN", "OPDI", "None", "41624", "31.49N", "070.55E", "173", "PK"],
    ["FAISALABAD INTL", "OPFA", "None", "None", "31.22N", "073.00E", "185", "PK"],
    ["GWADAR", "OPGD", "None", "None", "25.14N", "062.20E", "29", "PK"],
    ["GILGIT", "OPGT", "None", "41517", "35.55N", "074.19E", "1454", "PK"],
    ["JACOBABAD (CIV/M", "OPJA", "None", "41715", "28.18N", "068.28E", "56", "PK"],
    ["JIWANI (CAPE)", "OPJI", "None", "41756", "25.04N", "061.47E", "57", "PK"],
    ["KARACHI INTL ARP", "OPKC", "None", "41780", "24.53N", "067.10E", "22", "PK"],
    ["HYDERABAD AIRPOR", "OPKD", "None", "41764", "25.19N", "068.22E", "41", "PK"],
    ["KALAT", "OPKL", "None", "None", "29.01N", "066.34E", "2015", "PK"],
    ["LAHORE (CIV/MIL)", "OPLA", "None", "41641", "31.31N", "074.24E", "217", "PK"],
    ["LAHORE/WALTON", "OPLH", "None", "41640", "31.33N", "074.19E", "215", "PK"],
    ["MIANWALI (CIV/MI", "OPMI", "None", "41592", "32.32N", "071.31E", "212", "PK"],
    ["MIRANSHAH(CIV/MI", "OPMN", "None", "None", "32.58N", "070.07E", "921", "PK"],
    ["KARACHI/MASROOR", "OPMR", "None", "41781", "24.53N", "066.55E", "16", "PK"],
    ["MULTAN", "OPMT", "None", "41675", "30.11N", "071.25E", "123", "PK"],
    ["NAWABSHAH", "OPNH", "None", "41749", "26.13N", "068.22E", "38", "PK"],
    ["ORMARA", "OPOR", "None", "None", "25.13N", "064.37E", "2", "PK"],
    ["PANJGUR", "OPPG", "None", "41739", "26.57N", "064.08E", "1003", "PK"],
    ["PASNI", "OPPI", "None", "41759", "25.17N", "063.21E", "11", "PK"],
    ["PESHAWAR (CIV/MI", "OPPS", "None", "41530", "34.01N", "071.31E", "360", "PK"],
    ["QUETTA (CIV/MIL)", "OPQT", "None", "41660", "30.15N", "066.56E", "1606", "PK"],
    ["SHAIKH ZAID", "OPRK", "None", "None", "28.23N", "070.17E", "83", "PK"],
    ["ISLAMABAD (CIV/M", "OPRN", "None", "41571", "33.37N", "073.05E", "508", "PK"],
    ["RAIFIQUI (PAK-AF", "OPRQ", "None", "None", "30.46N", "072.16E", "150", "PK"],
    ["RISALPUR (PAK-AF", "OPRS", "None", "41533", "34.04N", "071.58E", "317", "PK"],
    ["SIBI", "OPSB", "None", "41697", "29.33N", "067.52E", "134", "PK"],
    ["SUKKUR", "OPSK", "None", "None", "27.43N", "068.48E", "58", "PK"],
    ["SARGODHA (PAK-AF", "OPSR", "None", "41594", "32.02N", "072.40E", "188", "PK"],
    ["SAIDU SHARIF", "OPSS", "None", "41523", "34.49N", "072.21E", "970", "PK"],
    ["SIALKOT AIRPORT", "OPST", "None", "None", "32.32N", "074.22E", "247", "PK"],
    ["TARBELA DAM", "OPTA", "None", "None", "33.59N", "072.36E", "340", "PK"],
    ["TURBAT NEW", "OPTU", "None", "None", "25.58N", "063.01E", "122", "PK"],
    ["AL KUT", "EQBC", "None", "99878", "32.28N", "045.45E", "20", "IQ"],
    ["BAGHDAD-SIRSENK", "ORBB", "None", "40650", "33.13N", "044.13E", "34", "IQ"],
    ["BALAD", "ORBD", "None", "None", "33.56N", "044.22E", "49", "IQ"],
    ["BAGHDAD INTL", "ORBI", "None", "None", "33.16N", "044.14E", "35", "IQ"],
    ["MOSUL (IRQ-AFB)", "ORBM", "None", "40608", "36.19N", "043.08E", "223", "IQ"],
    ["SADDAM(IRQ-AFB/C", "ORBS", "None", "None", "33.16N", "044.13E", "34", "IQ"],
    ["ERBIL INTL", "ORER", "None", "None", "36.14N", "043.58E", "409", "IQ"],
    ["BASRAH/MAGAL", "ORMM", "None", "40689", "30.34N", "047.40E", "2", "IQ"],
    ["AL NAJAF", "ORNI", "None", "None", "31.59N", "044.24E", "53", "IQ"],
    ["SHAIBAH/BASRAH", "ORMS", "None", "40688", "30.25N", "047.38E", "19", "IQ"],
    ["SULAYMANIYAH", "ORSU", "None", "None", "35.34N", "045.19E", "761", "IQ"],
    ["ALEPPO (CIV/MIL)", "OSAP", "None", "40007", "36.10N", "037.13E", "393", "SY"],
    ["DAMASCUS (CIV/MI", "OSDI", "None", "40080", "33.25N", "036.31E", "605", "SY"],
    ["DEIR ZZOR (CIV/M", "OSDZ", "None", "40045", "35.19N", "040.08E", "212", "SY"],
    ["KAMISHLI", "OSKL", "None", "40001", "37.02N", "041.12E", "455", "SY"],
    ["LATAKIA", "OSLK", "None", "40022", "35.24N", "035.57E", "7", "SY"],
    ["PALMYRA (CIV/MIL", "OSPR", "None", "40061", "34.32N", "038.17E", "404", "SY"],
    ["DOHA INTL AIRPOR", "OTBD", "None", "41170", "25.15N", "051.34E", "10", "QA"],
    ["DOHA/AL UDEID AB", "OTBH", "None", "None", "25.07N", "051.19E", "40", "QA"],
    ["DOHA HAMAD INTL", "OTHH", "None", "None", "25.15N", "051.36E", "0", "QA"],
    ["ADEN INTL", "OYAA", "None", "41480", "12.50N", "045.01E", "3", "YE"],
    ["AL GHAIDAH", "OYAG", "None", "41398", "16.05N", "052.05E", "42", "YE"],
    ["KAMARAN ISLAND", "OYAN", "None", "41430", "15.22N", "042.34E", "15", "YE"],
    ["RIYAN", "OYAR", "None", "41443", "14.35N", "049.15E", "25", "YE"],
    ["ABBS", "OYAS", "None", "None", "16.01N", "043.10E", "2000", "YE"],
    ["ATAQ", "OYAT", "None", "41437", "14.33N", "046.50E", "1039", "YE"],
    ["AL-BAYDA", "OYBI", "None", "None", "13.58N", "045.34E", "1011", "YE"],
    ["DHAMAR", "OYDM", "None", "41434", "14.32N", "044.26E", "2425", "YE"],
    ["HODEIDAH", "OYHD", "None", "41431", "14.45N", "042.58E", "115", "YE"],
    ["HAJJAH", "OYHJ", "None", "41391", "15.42N", "043.36E", "1760", "YE"],
    ["IBB", "OYIB", "None", "None", "13.58N", "044.10E", "1920", "YE"],
    ["MARIB", "OYMB", "None", "41350", "15.28N", "045.19E", "1000", "YE"],
    ["MOKHA", "OYMC", "None", "41477", "13.15N", "044.07E", "3", "YE"],
    ["MOKHA", "OYMK", "None", "41382", "13.19N", "043.16E", "3", "YE"],
    ["RMUKALLA INTL", "OYRN", "None", "None", "14.40N", "049.23E", "17", "YE"],
    ["SA'ADA/SADAH", "OYSH", "None", "None", "16.58N", "043.43E", "1890", "YE"],
    ["SANA'A (CIV/MIL)", "OYSN", "None", "41344", "15.29N", "044.13E", "2190", "YE"],
    ["SANA'A", "None", "None", "41404", "15.22N", "044.12E", "2190", "YE"],
    ["SOCOTRA ISLAND", "OYSQ", "None", "41494", "12.37N", "053.53E", "45", "YE"],
    ["SAYUN", "OYSY", "None", "None", "15.58N", "048.47E", "701", "YE"],
    ["TAIZ/GANED", "OYTZ", "None", "41466", "13.40N", "044.07E", "1385", "YE"],
    ["AL-HAZM", "OYZM", "None", "41326", "16.11N", "044.46E", "1900", "YE"],
    ["AL-GHAIDAH", "OYGD", "None", "None", "16.11N", "052.10E", "41", "YE"],
    ["ADEN KHORMAKSAR", "ODAA", "None", "41467", "12.49N", "045.01E", "3", "YE"],
    ["ALMA-ATA", "UAAA", "None", "36870", "43.21N", "077.02E", "847", "KZ"],
    ["UZUNAGAC", "UAAN", "None", "36874", "43.36N", "076.19E", "685", "KZ"],
    ["ASTANA KAZAKHSTA", "UACC", "None", "None", "51.01N", "071.28E", "355", "KZ"],
    ["PETROPAVLOVSK", "UACP", "None", "None", "54.47N", "069.11E", "142", "KZ"],
    ["KOKSHETAU", "UACK", "None", "None", "53.19N", "069.35E", "2547", "KZ"],
    ["TARAZ", "UADD", "None", "None", "42.51N", "071.18E", "665", "KZ"],
    ["FRUNZE", "UAFF", "None", "38353", "42.51N", "074.31E", "760", "KZ"],
    ["CIMKENT", "UAII", "None", "38328", "42.22N", "069.29E", "422", "KZ"],
    ["ZHEZKAZGAN", "UAKD", "None", "None", "47.42N", "067.44E", "381", "KZ"],
    ["KARAGANDA", "UAKK", "None", "None", "49.40N", "073.20E", "538", "KZ"],
    ["KZYL-ORDA", "UAOO", "None", "38062", "44.42N", "065.36E", "129", "KZ"],
    ["URALSK", "UARR", "None", "35108", "51.09N", "051.32E", "38", "KZ"],
    ["PAVLODAR", "UASP", "None", "None", "52.12N", "077.04E", "125", "KZ"],
    ["ARALSK", "UATA", "None", "35746", "46.47N", "061.39E", "56", "KZ"],
    ["AKTAU KAZAKHSTAN", "UATE", "None", "None", "43.52N", "051.06E", "22", "KZ"],
    ["ATYRAU", "UATG", "None", "None", "47.07N", "051.50E", "-22", "KZ"],
    ["CELKAR", "UATR", "None", "35633", "47.51N", "059.37E", "176", "KZ"],
    ["AKTJUBINSK", "UATT", "None", "35229", "50.15N", "057.12E", "227", "KZ"],
    ["KOSTANAY", "UAUU", "None", "None", "53.12N", "063.33E", "182", "KZ"],
    ["BISHKEK/MANAS", "UAFM", "None", "None", "43.04N", "074.29E", "760", "KZ"],
    ["OSH", "UAFO", "OSS", "None", "40.36N", "072.48E", "892", "KZ"],
    ["BAKU/BINE ARPT", "UBBB", "None", "37864", "40.27N", "050.04E", "-6", "AZ"],
    ["GYANDZHA", "UBBG", "None", "None", "40.44N", "046.19E", "330", "AZ"],
    ["LENKORAN", "UBBL", "None", "None", "38.45N", "048.49E", "10", "AZ"],
    ["NAKHCHIVAN", "UBBN", "None", "None", "39.11N", "045.27E", "873", "AZ"],
    ["QABALA", "UBBQ", "None", "None", "40.49N", "047.43E", "338", "AZ"],
    ["ZAKATALY", "UBBY", "None", "None", "41.34N", "046.40E", "390", "AZ"],
    ["MANAS", "UCFM", "None", "None", "43.04N", "074.29E", "633", "KG"],
    ["OSH", "UCFO", "None", "None", "40.36N", "072.48E", "884", "KG"],
    ["TBILISI/NOVO-AL", "UGTB", "None", "37549", "41.40N", "044.57E", "495", "GE"],
    ["KOPITNARI", "UGKO", "None", "None", "42.11N", "042.29E", "68", "GE"],
    ["BATUMI", "UGSB", "None", "37484", "41.37N", "041.36E", "32", "GE"],
    ["POTI (PORT)", "UGSP", "None", "37379", "42.09N", "041.40E", "3", "GE"],
    ["TBILISI/NOVO-AL", "UGGG", "None", "None", "41.40N", "044.57E", "490", "GE"],
    ["MUHRANI", "UGMM", "None", "37541", "41.55N", "044.34E", "551", "GE"],
    ["YEREVAN/ZAPADNY", "UGEE", "None", "37789", "40.07N", "044.28E", "907", "AM"],
    ["SHIRAK", "UGEL", "None", "None", "40.45N", "043.51E", "1524", "AM"],
    ["SHIRAK", "UDSG", "None", "None", "40.45N", "043.52E", "1524", "AM"],
    ["ZVARTNOTS", "UDYZ", "None", "None", "40.09N", "044.24E", "865", "AM"],
    ["UST KAMENOGORSK", "UASK", "None", "None", "50.02N", "082.30E", "286", "RU"],
    ["YAKUTSK", "UEEE", "None", "24959", "62.05N", "129.46E", "103", "RU"],
    ["CULMAN/NERIUGRI", "UELL", "None", "30393", "56.55N", "124.55E", "859", "RU"],
    ["POLYARNY", "UERP", "None", "None", "66.24N", "112.02E", "509", "RU"],
    ["MIRNY", "UERR", "None", "None", "62.32N", "114.03E", "347", "RU"],
    ["CHOKURDAKH", "UESO", "None", "None", "70.38N", "147.55E", "26", "RU"],
    ["TIKSI", "UEST", "None", "None", "71.42N", "128.54E", "7", "RU"],
    ["BLAGOVESHCHENSK", "UHBB", "None", "31510", "50.26N", "127.25E", "195", "RU"],
    ["EKIMCAN", "UHBP", "None", "31329", "53.04N", "132.55E", "543", "RU"],
    ["KHABAROVSK/NOVY", "UHHH", "None", "31735", "48.31N", "135.11E", "72", "RU"],
    ["TROICKOE", "UHHO", "None", "31655", "49.27N", "136.34E", "29", "RU"],
    ["ANADYR'", "UHMA", "None", "25563", "64.44N", "177.44E", "62", "RU"],
    ["PROVIDENJA BAY", "UHMD", "None", "25594", "64.23N", "173.13W", "3", "RU"],
    ["CHAYBUKHA", "UHMG", "None", "None", "61.50N", "160.33E", "1", "RU"],
    ["MYS SCHMIDTA", "UHMI", "None", "None", "68.54N", "179.27W", "1", "RU"],
    ["LAVRENTIJA", "UHML", "None", "25496", "65.35N", "171.00W", "9", "RU"],
    ["MAGADAN/NAGAEVO", "UHMM", "None", "25913", "59.55N", "150.43E", "118", "RU"],
    ["MARKOVO", "UHMO", "None", "None", "64.39N", "170.27E", "18", "RU"],
    ["PEVEK", "UHMP", "None", "25051", "69.47N", "170.36E", "4", "RU"],
    ["UGOLNAYA BAY/BE", "UHMR", "None", "25677", "63.02N", "179.19E", "1", "RU"],
    ["NIKOLAEVSK-NA-AM", "UHNN", "None", "31369", "53.09N", "140.39E", "68", "RU"],
    ["PETROPAVLOVSK-KA", "UHPP", "None", "32540", "53.10N", "158.27E", "40", "RU"],
    ["OKHA", "UHSH", "None", "32010", "53.31N", "142.53E", "37", "RU"],
    ["JUZNO-SAHALINSK", "UHSS", "None", "32150", "46.53N", "142.43E", "31", "RU"],
    ["VLADIVOSTOK", "UHWW", "None", "31960", "43.24N", "132.09E", "184", "RU"],
    ["CITA/KADALA", "UIAA", "None", "30758", "52.01N", "113.19E", "685", "RU"],
    ["BRATSK/IRKUTSK", "UIBB", "None", "None", "56.22N", "101.42E", "490", "RU"],
    ["IRKUTSK", "UIII", "None", "30710", "52.16N", "104.24E", "513", "RU"],
    ["UST-ORDYNSKIJ", "UIIO", "None", "30713", "52.49N", "104.46E", "525", "RU"],
    ["BODAJBO", "UIKB", "None", "30253", "57.51N", "114.12E", "278", "RU"],
    ["KIRENSK", "UIKK", "None", "30230", "57.46N", "108.04E", "258", "RU"],
    ["VITIM-IN-YAKUT", "UIKW", "None", "30054", "59.27N", "112.34E", "193", "RU"],
    ["NIZNE-UDINSK", "UINN", "None", "29698", "54.52N", "099.01E", "410", "RU"],
    ["HORINSK", "UIUH", "None", "30739", "52.10N", "109.46E", "666", "RU"],
    ["ULAN-UDE/MUHINO", "UIUU", "None", "30823", "51.48N", "107.27E", "515", "RU"],
    ["MARIUPOL INTL", "UKCM", "None", "None", "47.05N", "037.27E", "76", "RU"],
    ["ARHANGELSK", "ULAA", "None", "22550", "64.36N", "040.43E", "19", "RU"],
    ["AMDERMA", "ULDD", "None", "23022", "69.45N", "061.34E", "49", "RU"],
    ["KOTLAS", "ULAK", "None", "None", "61.14N", "046.38E", "56", "RU"],
    ["KOTLAS", "ULKK", "None", "22887", "61.14N", "046.42E", "56", "RU"],
    ["ST PETERSBURG", "ULLI", "None", "26063", "59.48N", "030.16E", "4", "RU"],
    ["MURMANSK", "ULMM", "None", "None", "68.47N", "032.45E", "51", "RU"],
    ["MURMANSK", "None", "None", "22113", "68.58N", "033.03E", "51", "RU"],
    ["VELIKIE LUKI", "ULOL", "None", "26477", "56.22N", "030.36E", "98", "RU"],
    ["PSKOV", "ULOO", "None", "26258", "57.47N", "028.24E", "47", "RU"],
    ["PETROZAVODSK", "ULPB", "None", "None", "61.53N", "034.09E", "46", "RU"],
    ["TALLINN", "ULTT", "None", "None", "59.21N", "024.48E", "44", "RU"],
    ["BOTOVO/CHEREPOVE", "ULWC", "None", "27113", "59.17N", "038.01E", "115", "RU"],
    ["TOT'MA", "ULWT", "None", "27051", "59.52N", "042.45E", "134", "RU"],
    ["VOLOGDA", "ULWW", "None", "27037", "59.17N", "039.56E", "131", "RU"],
    ["KALININGRAD", "UMKK", "None", "None", "54.53N", "020.36E", "21", "RU"],
    ["ABAKAN", "UNAA", "None", "None", "53.45N", "091.24E", "245", "RU"],
    ["BARNAUL", "UNBB", "None", "29838", "53.25N", "083.31E", "255", "RU"],
    ["NOVOKUZNETSK", "UNCE", "None", "29846", "53.43N", "087.10E", "308", "RU"],
    ["KOLPASHEVO-IN-T", "UNCL", "None", "29231", "58.17N", "082.52E", "76", "RU"],
    ["KEMEROVO", "UNEE", "None", "None", "55.16N", "086.05E", "260", "RU"],
    ["JENISEJSK", "UNII", "None", "29263", "58.27N", "092.09E", "78", "RU"],
    ["ABAKAN", "UNKA", "None", "29865", "53.45N", "091.24E", "245", "RU"],
    ["VANAVARA", "UNKI", "None", "24908", "60.19N", "102.16E", "260", "RU"],
    ["KRASNOJARSK", "UNKK", "None", "29574", "56.00N", "092.52E", "277", "RU"],
    ["KRASNOYARSK", "UNKL", "KJA", "29570", "56.10N", "092.29E", "276", "RU"],
    ["PODKAMENNAYA TU", "UNKT", "None", "23884", "61.36N", "090.00E", "63", "RU"],
    ["NOVOSIBIRSK/TOLM", "UNNN", "None", "29634", "55.05N", "082.59E", "177", "RU"],
    ["TOLMACHEVO", "UNNT", "None", "None", "55.01N", "082.38E", "111", "RU"],
    ["TSENTRALNY/OMSK", "UNOO", "OMS", "None", "54.58N", "073.19E", "95", "RU"],
    ["PLOTNIKOVO/TOMSK", "UNTT", "None", "None", "56.23N", "085.13E", "182", "RU"],
    ["NOVOKUZNETSK", "UNWW", "None", "None", "53.49N", "086.53E", "308", "RU"],
    ["KHATANGA", "UOHH", "None", "20891", "71.59N", "102.30E", "33", "RU"],
    ["IGARKA", "UOII", "None", "23274", "67.26N", "086.37E", "31", "RU"],
    ["ALYKEL", "UOOO", "None", "None", "69.19N", "087.20E", "175", "RU"],
    ["ANAPA/VITIAZEVO", "URKA", "None", "None", "45.00N", "037.21E", "53", "RU"],
    ["KRASNODAR", "URKK", "None", "34929", "45.02N", "039.09E", "34", "RU"],
    ["MAYKOP", "URKM", "None", "None", "44.41N", "040.02E", "558", "RU"],
    ["GROZNY", "URMG", "None", "None", "43.22N", "045.42E", "263", "RU"],
    ["UYTASH", "URML", "MCX", "None", "42.49N", "047.39E", "4", "RU"],
    ["MINERALYNE VODY", "URMM", "None", "37054", "44.13N", "043.06E", "314", "RU"],
    ["NALCHIK", "URMN", "NAL", "None", "43.31N", "043.38E", "445", "RU"],
    ["BESLAN", "URMO", "None", "None", "43.12N", "044.36E", "510", "RU"],
    ["STAVROPOL/SHPAKO", "URMT", "None", "None", "45.07N", "042.07E", "453", "RU"],
    ["ROSTOV-ON-DON", "URRR", "None", "34731", "47.15N", "039.49E", "77", "RU"],
    ["SOTCHI", "URSS", "None", "37171", "43.27N", "039.57E", "16", "RU"],
    ["ASTRAKHAN", "URWA", "ASF", "34880", "46.17N", "048.01E", "-20", "RU"],
    ["ELISTA", "URWI", "None", "34861", "46.22N", "044.20E", "150", "RU"],
    ["VOLGOGRAD/GUMRAK", "URWW", "None", "34560", "48.47N", "044.20E", "147", "RU"],
    ["CHELYABINSK-BALA", "USCC", "None", "None", "55.18N", "061.30E", "234", "RU"],
    ["MAGNITOGORSK", "USCM", "None", "None", "53.24N", "058.45E", "435", "RU"],
    ["SALEKHARD", "USDD", "None", "23330", "66.35N", "066.37E", "67", "RU"],
    ["KHANTY-MANSIYSK", "USHH", "None", "23933", "61.02N", "069.05E", "23", "RU"],
    ["NADYM", "USMM", "None", "None", "65.29N", "072.42E", "15", "RU"],
    ["NOVYI URENGOI", "USMU", "None", "23358", "66.04N", "076.31E", "59", "RU"],
    ["PERM/BOLSHOE SAV", "USPP", "None", "None", "57.55N", "056.01E", "123", "RU"],
    ["SURGUT", "USRR", "None", "23849", "61.20N", "073.25E", "44", "RU"],
    ["NIZHNEVARTOVSK", "USNN", "None", "None", "60.57N", "076.29E", "54", "RU"],
    ["RADUZHNY", "USNR", "RAT", "None", "62.09N", "077.20E", "76", "RU"],
    ["RUSSKINSKAJA", "USRK", "KGP", "23748", "62.11N", "074.32E", "68", "RU"],
    ["IVDEL-IN-SVERDL", "USSI", "None", "23921", "60.40N", "060.25E", "101", "RU"],
    ["EKATERINBURG", "USSS", "None", "None", "56.45N", "060.49E", "233", "RU"],
    ["EKATERINBURG", "None", "None", "28440", "56.50N", "060.38E", "280", "RU"],
    ["ROSCHINO", "USTR", "TJM", "None", "57.10N", "065.19E", "115", "RU"],
    ["UGRYUMOVO", "UUBC", "None", "None", "54.33N", "036.22E", "199", "RU"],
    ["IVANOVO SOUTH", "UUBI", "None", "None", "56.56N", "040.57E", "125", "RU"],
    ["BRJANSK", "UUBP", "None", "26898", "53.13N", "034.11E", "202", "RU"],
    ["MOSCOW/NOVOYE SR", "UUBW", "None", "None", "55.33N", "038.09E", "115", "RU"],
    ["MOSCOW/DOMODEDOV", "UUDD", "None", "None", "55.24N", "037.54E", "168", "RU"],
    ["YAROSLAV", "UUDL", "None", "None", "57.34N", "040.10E", "88", "RU"],
    ["MOSCOW/SHEREMET'", "UUEE", "None", "None", "55.58N", "037.25E", "190", "RU"],
    ["KALININ/MIGALOVO", "UUEM", "None", "27402", "56.49N", "035.45E", "143", "RU"],
    ["OSTAFYEVO INTL", "UUMO", "None", "None", "55.31N", "037.30E", "174", "RU"],
    ["BELGOROD", "UUOB", "None", "None", "50.39N", "036.35E", "224", "RU"],
    ["KURSK", "UUOK", "None", "None", "51.45N", "036.17E", "209", "RU"],
    ["VORONEZ", "UUOO", "None", "34122", "51.49N", "039.14E", "157", "RU"],
    ["MOSCOW/VNUKOVO", "UUWW", "None", "None", "55.36N", "037.16E", "203", "RU"],
    ["USINSK", "UUYS", "None", "23417", "66.00N", "057.22E", "80", "RU"],
    ["UST-KULOM", "UUYT", "None", "23803", "61.40N", "053.40E", "139", "RU"],
    ["UKHTA", "UUYH", "UCT", "None", "63.34N", "053.48E", "149", "RU"],
    ["SYKTYVKAR", "UUYY", "None", "23804", "61.39N", "050.49E", "119", "RU"],
    ["NIZHNY NOVGOROD", "UWGG", "None", "None", "56.14N", "043.47E", "73", "RU"],
    ["KAZAN", "UWKD", "None", "None", "55.37N", "049.17E", "126", "RU"],
    ["BEGISHEVO", "UWKE", "None", "None", "55.34N", "052.05E", "196", "RU"],
    ["CHEBOKSARY", "UWKS", "None", "None", "56.05N", "047.21E", "170", "RU"],
    ["ULJANOVSK", "UWLL", "None", "None", "54.16N", "048.14E", "134", "RU"],
    ["ULYANOVSK", "UWLW", "None", "None", "54.24N", "048.48E", "66", "RU"],
    ["ORENBURG/TSENTRA", "UWOO", "None", "None", "51.48N", "055.28E", "109", "RU"],
    ["ORSK", "UWOR", "None", "None", "51.04N", "058.36E", "277", "RU"],
    ["PENZA (STREAM)", "UWPP", "None", "27962", "53.07N", "045.01E", "174", "RU"],
    ["SARATOV/TSENTRAL", "UWSS", "None", "None", "51.34N", "046.04E", "166", "RU"],
    ["BASHKORTOSTAN", "UWUU", "None", "None", "54.34N", "055.52E", "137", "RU"],
    ["KURUMOCH", "UWWW", "None", "None", "53.30N", "050.10E", "146", "RU"],
    ["KUJBYSEV/BEZENCU", "UWWS", "None", "28900", "53.13N", "050.19E", "44", "RU"],
    ["VORKUTA", "UUYW", "None", "None", "67.29N", "064.00E", "185", "RU"],
    ["BORISPOL'/KIEV", "UKBB", "None", "33347", "50.20N", "030.54E", "119", "UA"],
    ["DONETSK", "UKCC", "None", "None", "48.05N", "037.45E", "241", "UA"],
    ["LUHANSK", "UKCW", "None", "None", "48.25N", "039.23E", "194", "UA"],
    ["DNIPROPETROVSK", "UKDD", "None", "None", "48.22N", "035.06E", "149", "UA"],
    ["MOKRAYA", "UKDE", "OZH", "None", "47.52N", "035.19E", "113", "UA"],
    ["KRIVYY RIH", "UKDR", "None", "None", "48.03N", "033.13E", "124", "UA"],
    ["SIMFEROPOL'", "UKFF", "None", "33946", "45.02N", "033.59E", "188", "UA"],
    ["HAR'KOV/OSNOVA", "UKHH", "None", "34300", "49.55N", "036.17E", "155", "UA"],
    ["CHERKASY", "UKKE", "None", "None", "49.25N", "032.00E", "114", "UA"],
    ["KIEV/ZHYLIANY", "UKKK", "None", "None", "50.24N", "030.27E", "179", "UA"],
    ["KIEV", "None", "None", "33345", "50.24N", "030.34E", "167", "UA"],
    ["GOSTOMEL'", "UKKM", "None", "None", "50.36N", "030.12E", "157", "UA"],
    ["IVANO-FRANKIVSK", "UKLI", "None", "None", "48.53N", "024.41E", "280", "UA"],
    ["LVIV", "UKLL", "None", "33393", "49.49N", "023.56E", "325", "UA"],
    ["CHERNOVTSY", "UKLN", "None", "None", "48.16N", "025.59E", "252", "UA"],
    ["ROVNO", "UKLR", "None", "None", "50.36N", "026.08E", "230", "UA"],
    ["UZHGOROD", "UKLU", "UDJ", "None", "48.38N", "022.16E", "117", "UA"],
    ["KHERSON", "UKOH", "None", "None", "46.40N", "032.30E", "45", "UA"],
    ["MYKOLAIV", "UKON", "NLV", "None", "47.03N", "031.55E", "56", "UA"],
    ["ODESSA/TSENTRALN", "UKOO", "None", "33837", "46.25N", "030.41E", "35", "UA"],
    ["VINNITSA", "UKWW", "None", "None", "49.15N", "028.36E", "293", "UA"],
    ["LIEPAJA INTL", "EVLA", "None", "26406", "56.31N", "021.06E", "4", "LV"],
    ["RIGA AIRPORT", "EVRA", "None", "None", "56.55N", "023.58E", "10", "LV"],
    ["VENTPILS", "EVVA", "None", "None", "57.21N", "021.33E", "6", "LV"],
    ["RIGA", "UMRR", "None", "26422", "56.58N", "024.04E", "3", "LV"],
    ["VENTSPILS (HARBO", "UMRW", "None", "26314", "57.22N", "021.33E", "4", "LV"],
    ["BREST", "UMBB", "None", "None", "52.07N", "023.54E", "143", "BY"],
    ["GOMEL", "UMGG", "None", "None", "52.32N", "031.01E", "144", "BY"],
    ["VITEBSK", "UMII", "None", "26666", "55.08N", "030.21E", "208", "BY"],
    ["UNKNOWN", "UMLI", "None", "None", "53.46N", "027.35E", "214", "BY"],
    ["GRODNO", "UMMG", "None", "None", "53.36N", "024.03E", "135", "BY"],
    ["MINSK-IN-MIN", "UMMM", "None", "None", "53.52N", "027.31E", "234", "BY"],
    ["MINSK", "UMMS", "None", "26850", "53.53N", "028.02E", "205", "BY"],
    ["MOGILEV", "UMOO", "None", "None", "53.57N", "030.06E", "194", "BY"],
    ["ASHGABAT", "UTAA", "None", "None", "37.59N", "058.22E", "210", "TM"],
    ["TURKMENBASHI", "UTAK", "None", "38570", "40.03N", "053.00E", "85", "TM"],
    ["MARY", "UTAM", "None", "None", "37.37N", "061.54E", "222", "TM"],
    ["DASHOGUZ", "UTAT", "None", "None", "41.46N", "059.50E", "83", "TM"],
    ["TURKMENABAT", "UTAV", "None", "None", "39.05N", "063.37E", "192", "TM"],
    ["DZIZAK", "UTED", "None", "38579", "40.07N", "067.49E", "345", "TM"],
    ["SHAHRISABZ", "UTSH", "None", "None", "39.02N", "066.47E", "599", "TM"],
    ["TAMDY-BULAK", "UTSM", "None", "38413", "41.43N", "064.37E", "238", "TM"],
    ["DUSHANBE", "UTDD", "None", "38836", "38.32N", "068.49E", "803", "TJ"],
    ["KOLUB", "UTDK", "None", "None", "37.59N", "069.48E", "699", "TJ"],
    ["KHUDZHAND", "UTDL", "None", "None", "40.13N", "069.42E", "442", "TJ"],
    ["QURGHONTEPPA", "UTDT", "None", "None", "37.52N", "068.52E", "449", "TJ"],
    ["ANDIZAN", "UTFA", "AZN", "38475", "40.44N", "072.18E", "477", "UZ"],
    ["NAMANGAN", "UTFN", "NMA", "None", "40.59N", "071.34E", "490", "UZ"],
    ["FERGANA", "UTFF", "FRG", "38618", "40.22N", "071.46E", "577", "UZ"],
    ["NAMANGAN", "UTKN", "None", "38611", "40.59N", "071.35E", "474", "UZ"],
    ["NUKUS/KARAKALPAK", "UTNN", "NCU", "None", "42.29N", "059.38E", "67", "TM"],
    ["URGENCH", "UTNU", "URG", "None", "41.35N", "060.38E", "98", "TM"],
    ["NAVOI", "UTSA", "None", "None", "40.07N", "065.10E", "346", "UZ"],
    ["BUKHARA", "UTSB", "BHK", "38683", "39.46N", "064.29E", "226", "UZ"],
    ["KARSHI KHANABAD", "UTSK", "None", "None", "38.50N", "065.46E", "1365", "UZ"],
    ["SAMARKAND", "UTSS", "SMD", "38696", "39.38N", "066.56E", "724", "TM"],
    ["TERMEZ", "UTST", "TMJ", "38927", "37.17N", "067.19E", "302", "TM"],
    ["TASHKENT-VOSTOCH", "UTTP", "TAS", "None", "41.19N", "069.23E", "466", "UZ"],
    ["TASKENT/YUZNI", "UTTT", "TAS", "38457", "41.16N", "069.16E", "489", "TM"],
    ["ANDIZAN", "UTKA", "None", "None", "40.44N", "072.20E", "477", "UZ"],
    ["FERGANA", "UTKF", "None", "None", "40.22N", "071.45E", "577", "UZ"],
    ["BEIJING/PEKING", "ZBAA", "None", "54511", "40.04N", "116.35E", "30", "CN"],
    ["HUHHOT", "ZBHH", "None", "53463", "40.51N", "111.49E", "1065", "CN"],
    ["BAOTOU", "ZBOW", "None", "None", "40.40N", "109.59E", "1049", "CN"],
    ["ZHENGDING", "ZBSJ", "SJW", "None", "38.17N", "114.42E", "71", "CN"],
    ["TIANJIN/ZHANGGUI", "ZBTJ", "None", "None", "39.07N", "117.21E", "3", "CN"],
    ["TAIYUAN/WUSU", "ZBYN", "None", "53772", "37.46N", "112.38E", "779", "CN"],
    ["BEIHAI", "ZGBH", "None", "59644", "21.29N", "109.06E", "16", "CN"],
    ["CHANGSHA/DATUOPU", "ZGCS", "None", "57679", "28.11N", "113.04E", "46", "CN"],
    ["DAYONG", "ZGDY", "None", "None", "29.08N", "110.29E", "900", "CN"],
    ["GUANGZHOU/BAIYUN", "ZGGG", "None", "59287", "23.24N", "113.18E", "15", "CN"],
    ["HUANGHUA/CHANGSH", "ZGHA", "CSX", "None", "28.11N", "113.13E", "66", "CN"],
    ["HAIKOU", "ZGHK", "None", "59758", "20.01N", "110.20E", "15", "CN"],
    ["GUILIN", "ZGKL", "None", "57957", "25.13N", "110.02E", "166", "CN"],
    ["SHAN-TOU", "ZGOW", "None", "59316", "23.33N", "116.30E", "3", "CN"],
    ["NANNING/WUXU", "ZGNN", "None", "59431", "22.37N", "108.10E", "73", "CN"],
    ["SHENZHEN", "ZGSZ", "None", "59493", "22.38N", "113.48E", "18", "CN"],
    ["ZHANJIANG", "ZGZJ", "None", "59658", "21.13N", "110.24E", "28", "CN"],
    ["ZHENGZHOU", "ZHCC", "None", "57083", "34.31N", "113.50E", "111", "CN"],
    ["WUHAN/NANHU", "ZHHH", "None", "57494", "30.47N", "114.13E", "23", "CN"],
    ["HAIKOU", "ZJHK", "None", "None", "19.56N", "110.28E", "23", "CN"],
    ["SANYA/FENGHUANG", "ZJSY", "None", "None", "18.18N", "109.25E", "27", "CN"],
    ["KIMCHAEK/SONGJIN", "ZKKC", "None", "47025", "40.40N", "129.11E", "23", "CN"],
    ["PYONGYANG/SUNAN", "ZKPY", "None", "47058", "39.01N", "125.46E", "38", "CN"],
    ["HEDONG AIRPORT", "ZLIC", "None", "53614", "38.19N", "106.24E", "1112", "CN"],
    ["JIUQUAN/SUZHOU", "ZLJQ", "None", "52533", "39.46N", "098.28E", "1478", "CN"],
    ["LANZHOU", "ZLLL", "None", "52889", "36.31N", "103.37E", "1947", "CN"],
    ["XI'AN", "ZLSN", "None", "57036", "34.17N", "108.55E", "398", "CN"],
    ["XINING", "ZLXN", "None", "52866", "36.37N", "101.46E", "2262", "CN"],
    ["XIANYANG", "ZLXY", "None", "None", "34.26N", "108.45E", "479", "CN"],
    ["YAN AN", "ZLYA", "None", "53845", "36.36N", "109.30E", "959", "CN"],
    ["ULAN-BATOR", "ZMUB", "None", "None", "47.50N", "106.47E", "1330", "CN"],
    ["BOSHANG LINCANG", "ZPLC", "None", "None", "23.42N", "100.01E", "2107", "CN"],
    ["KUNMING/WUJIABA", "ZPPP", "None", "56778", "25.00N", "102.45E", "1892", "CN"],
    ["XIAMEN", "ZSAM", "None", "59134", "24.32N", "118.08E", "139", "CN"],
    ["CHANGZHOU", "ZSCG", "None", "None", "31.42N", "119.58E", "2", "CN"],
    ["NANCHANG", "ZSCN", "None", "58606", "28.36N", "115.55E", "50", "CN"],
    ["FUZHOU", "ZSFZ", "None", "58847", "25.56N", "119.40E", "85", "CN"],
    ["GAN-ZHOU", "ZSGZ", "CI2", "57993", "25.51N", "114.57E", "125", "CN"],
    ["HANGZHOU/JIANQIA", "ZSHC", "None", "58457", "30.13N", "120.26E", "43", "CN"],
    ["JINAN YAOQIANG", "ZSJN", "None", "None", "36.51N", "117.13E", "23", "CN"],
    ["HUANGYAN", "ZSLC", "None", "None", "28.25N", "122.22E", "1", "CN"],
    ["NINGBO/LISHE", "ZSNB", "None", "None", "29.50N", "121.28E", "4", "CN"],
    ["NANJING/NANKING", "ZSNJ", "None", "58238", "31.56N", "118.54E", "33", "CN"],
    ["NANTONG", "ZSNT", "None", "None", "32.01N", "120.51E", "6", "CN"],
    ["HEFEI/LUOGANG", "ZSOF", "None", "58321", "31.47N", "117.18E", "33", "CN"],
    ["SHANGHAI/PUDONG", "ZSPD", "PVG", "None", "31.09N", "121.48E", "4", "CN"],
    ["QINGDAO/TSINGTAO", "ZSQD", "None", "54857", "36.16N", "120.23E", "77", "CN"],
    ["SHANGHAI/HONGQIA", "ZSSS", "None", "58367", "31.12N", "121.20E", "7", "CN"],
    ["JINAN/TSINAN", "ZSTN", "None", "54823", "36.40N", "116.58E", "58", "CN"],
    ["TUNXI", "ZSTX", "None", "None", "29.43N", "118.16E", "145", "CN"],
    ["WUYISHAN", "ZSWY", "None", "None", "27.45N", "118.02E", "298", "CN"],
    ["WENZHOU", "ZSWZ", "None", "None", "28.01N", "120.39E", "7", "CN"],
    ["XUZHOU", "ZSXZ", "None", "None", "34.16N", "117.11E", "42", "CN"],
    ["CHONGQING/CHUNGK", "ZUCK", "None", "57516", "29.43N", "106.38E", "351", "CN"],
    ["GUIYANG", "ZUGY", "None", "57816", "26.32N", "106.48E", "1074", "CN"],
    ["LHASA", "ZULS", "None", "None", "29.18N", "090.55E", "3650", "CN"],
    ["LHASA", "None", "None", "55591", "29.40N", "091.08E", "3650", "CN"],
    ["CHENGDU", "ZUUU", "None", "56294", "30.35N", "103.57E", "508", "CN"],
    ["HAMI", "ZWHM", "None", "52203", "42.49N", "093.31E", "739", "CN"],
    ["KASHI", "ZWSH", "None", "51709", "39.33N", "076.01E", "1291", "CN"],
    ["HOTAN", "ZWTN", "None", "51828", "37.07N", "079.55E", "1375", "CN"],
    ["URUM-QI/DIWOPU", "ZWWW", "None", "None", "43.53N", "087.28E", "654", "CN"],
    ["YINING", "ZWYN", "None", "51431", "43.57N", "081.19E", "663", "CN"],
    ["CHANGCHUN", "ZYCC", "None", "54161", "43.59N", "125.41E", "238", "CN"],
    ["CHAOYANG", "ZYCY", "None", "54324", "41.36N", "120.24E", "176", "CN"],
    ["HARBIN", "ZYHB", "None", "50953", "45.37N", "126.15E", "140", "CN"],
    ["JILIN/CHANGCHUN", "ZYJL", "None", "None", "43.52N", "126.39E", "187", "CN"],
    ["MUDANJIANG-HAILA", "ZYMD", "None", "None", "44.31N", "129.34E", "269", "CN"],
    ["QIQIHAR", "ZYQQ", "None", "50745", "47.22N", "123.55E", "148", "CN"],
    ["DALIAN/DAIREN/LU", "ZYTL", "None", "54662", "38.58N", "121.32E", "97", "CN"],
    ["SHENYANG/TAOKIAN", "ZYTX", "None", "None", "41.38N", "123.29E", "35", "CN"],
    ["YANJI", "ZYYJ", "None", "None", "42.53N", "129.27E", "190", "CN"],
    ["SHENYANG/DONGTA", "ZYYY", "None", "54342", "41.47N", "123.30E", "43", "CN"],
    ["CHEN-ZHOU", "None", "CI1", "57972", "25.49N", "113.01E", "185", "CN"],
    ["WU-ZHOU", "None", "CI3", "59265", "23.29N", "111.18E", "120", "CN"],
    ["XI-SHA ISLAND", "None", "CI6", "59981", "16.50N", "112.20E", "5", "CN"],
    ["TAIPEI TAOYUAN", "RCTP", "None", "46686", "25.04N", "121.13E", "33", "TW"],
    ["MAZU", "RCFG", "None", "46689", "26.10N", "119.55E", "91", "TW"],
    ["SUNGSHAN/TAIPEI", "RCSS", "None", "46696", "25.04N", "121.32E", "6", "TW"],
    ["TAOYUAN AB", "RCGM", "None", "46697", "25.04N", "121.13E", "45", "TW"],
    ["DONGSHI", "RCNO", "None", "46730", "23.16N", "119.40E", "45", "TW"],
    ["MAKUNG AB", "RCQC", "None", "46734", "23.34N", "119.37E", "31", "TW"],
    ["CHINMEM/SHATOU", "RCBS", "None", "46736", "24.25N", "118.22E", "9", "TW"],
    ["PA KUEI/BAKUAI", "RCUK", "None", "46738", "24.55N", "121.17E", "141", "TW"],
    ["KAOHSIUNG INTL", "RCKH", "None", "46740", "22.34N", "120.20E", "9", "TW"],
    ["TAINAN TW-AFB", "RCNN", "None", "46743", "22.56N", "120.12E", "19", "TW"],
    ["KANGSHAN TW-AFB", "RCAY", "None", "46745", "22.46N", "120.16E", "10", "TW"],
    ["CHIAYI TW-AFB", "RCKU", "None", "46746", "23.28N", "120.22E", "25", "TW"],
    ["DONGGANG", "RCMJ", "None", "46747", "22.28N", "120.25E", "8", "TW"],
    ["PINGTUNG SOUTH", "RCDC", "None", "46750", "22.40N", "120.28E", "24", "TW"],
    ["TAICHUNG TW-AFB", "RCLG", "None", "46751", "24.10N", "120.39E", "112", "TW"],
    ["HENGCHUN", "RCKW", "None", "46752", "21.55N", "120.49E", "13", "TW"],
    ["HSINCHU TW-AFB", "RCPO", "None", "46756", "24.49N", "120.55E", "8", "TW"],
    ["PINGTUNG N AFB", "RCSQ", "None", "46758", "22.41N", "120.28E", "29", "TW"],
    ["CHIHHANG TW-AFB", "RCQS", "None", "46760", "22.48N", "121.10E", "37", "TW"],
    ["LAN YU", "RCLY", "None", "46762", "22.01N", "121.32E", "325", "TW"],
    ["HUALIEN AB", "RCYU", "None", "46763", "24.01N", "121.37E", "16", "TW"],
    ["ILAN", "RCMS", "None", "46764", "24.45N", "121.46E", "9", "TW"],
    ["WUCHIA OBSERVATO", "RCMQ", "None", "46770", "24.16N", "120.37E", "5", "TW"],
    ["CHIA TUNG", "RCFS", "None", "46772", "22.25N", "120.32E", "20", "TW"],
    ["DONGSHA/PRATAS", "RCLM", "None", "46810", "20.40N", "116.43E", "6", "TW"],
    ["FENG NIN TW-AFB", "RCFN", "None", "None", "22.46N", "121.04E", "42", "TW"],
    ["GREEN ISLAND", "RCGI", "None", "None", "22.40N", "121.27E", "8", "TW"],
    ["BAI GAN", "RCMT", "None", "None", "26.13N", "119.59E", "1", "TW"],
    ["NEW TOKYO INTL A", "RJAA", "None", "47686", "35.46N", "140.22E", "44", "JP"],
    ["MATSUMOTO AIRPOR", "RJAF", "None", "47709", "36.10N", "137.55E", "660", "JP"],
    ["HYAKURI (JASDF)", "RJAH", "None", "47715", "36.10N", "140.25E", "35", "JP"],
    ["ICHIKAWA", "RJAI", "None", "None", "35.43N", "139.55E", "31", "JP"],
    ["KASUMIGAURA (JAS", "RJAK", "None", "47716", "36.01N", "140.11E", "29", "JP"],
    ["MINAMITORISHIMA", "RJAM", "None", "47991", "24.18N", "153.58E", "9", "JP"],
    ["CHICHIJIMA ISLAN", "RJAO", "None", "47971", "27.04N", "142.10E", "8", "JP"],
    ["FUJI (JASDF)", "RJAT", "None", "47721", "35.19N", "138.52E", "683", "JP"],
    ["IWOJIMA (JMSDF)", "RJAW", "None", "47981", "24.46N", "141.19E", "116", "JP"],
    ["KANSAI INTL", "RJBB", "None", "47774", "34.25N", "135.15E", "8", "JP"],
    ["NANKISHIRAHAMA A", "RJBD", "None", "47782", "33.40N", "135.22E", "108", "JP"],
    ["KOBE", "RJBE", "UKB", "None", "34.38N", "135.14E", "5", "JP"],
    ["HIROSHIMANISHI", "RJBH", "None", "None", "34.22N", "132.25E", "5", "JP"],
    ["TAJIMA", "RJBT", "None", "None", "35.30N", "134.48E", "210", "JP"],
    ["ASAHIKAWA (JASDF", "RJCA", "None", "47477", "43.47N", "142.22E", "118", "JP"],
    ["OBIHIRO AIRPORT", "RJCB", "None", "47490", "42.43N", "143.13E", "152", "JP"],
    ["CHITOSE (JASDF/C", "RJCC", "None", "47425", "42.46N", "141.40E", "30", "JP"],
    ["HAKODATE AIRPORT", "RJCH", "None", "47488", "41.46N", "140.49E", "36", "JP"],
    ["CHITOSE (JASDF)", "RJCJ", "None", "47434", "42.48N", "141.40E", "27", "JP"],
    ["KUSHIRO AIRPORT", "RJCK", "None", "47489", "43.01N", "144.11E", "98", "JP"],
    ["MEMAMBETSU AIRPO", "RJCM", "None", "47481", "43.53N", "144.10E", "36", "JP"],
    ["NAKASHIBETSU ARP", "RJCN", "None", "47483", "43.34N", "144.58E", "70", "JP"],
    ["SAPPORO (JGSDF/C", "RJCO", "None", "47479", "43.07N", "141.22E", "11", "JP"],
    ["REBUN ISLAND", "RJCR", "None", "None", "45.27N", "141.01E", "27", "JP"],
    ["KUSHIRO/KENEBETS", "RJCS", "None", "47418", "42.58N", "144.24E", "37", "JP"],
    ["TOKACHI (JGSDF)", "RJCT", "None", "None", "42.53N", "143.10E", "84", "JP"],
    ["WAKKANAI AIRPORT", "RJCW", "None", "47441", "45.23N", "141.48E", "11", "JP"],
    ["MURORAN/YAKUMO", "RJCY", "None", "47423", "42.19N", "140.58E", "49", "JP"],
    ["IKI AIRPORT (ISL", "RJDB", "None", "47858", "33.45N", "129.46E", "16", "JP"],
    ["YAMAGUCHI/UBE AR", "RJDC", "None", "47786", "33.55N", "131.16E", "8", "JP"],
    ["KAMIGOTO", "RJDK", "None", "None", "33.01N", "129.10E", "20", "JP"],
    ["METABARU (JASDF)", "RJDM", "None", "47860", "33.19N", "130.25E", "19", "JP"],
    ["OJIKA ISLAND", "RJDO", "None", "None", "33.13N", "129.03E", "20", "JP"],
    ["TSUSHIMA AIRPORT", "RJDT", "None", "47799", "34.16N", "129.19E", "66", "JP"],
    ["MONBETSU AIRPORT", "RJEB", "None", "47474", "44.18N", "143.24E", "25", "JP"],
    ["ASAHIKAWA AIRPOR", "RJEC", "None", "47476", "43.40N", "142.26E", "211", "JP"],
    ["OKUSHIRI ISLAND", "RJEO", "None", "None", "42.04N", "139.26E", "36", "JP"],
    ["RISHIRI ISLAND", "RJER", "None", "None", "45.15N", "141.10E", "30", "JP"],
    ["ASHIYA (JASDF)", "RJFA", "None", "47803", "33.52N", "130.39E", "33", "JP"],
    ["YAKUSHIMA ISLAND", "RJFC", "None", "47836", "30.22N", "130.40E", "38", "JP"],
    ["FUKUE AIRPORT", "RJFE", "None", "47844", "32.40N", "128.49E", "80", "JP"],
    ["FUKUOKA/ITAZUKE", "RJFF", "None", "47808", "33.34N", "130.26E", "12", "JP"],
    ["TANEGASHIMA AIRP", "RJFG", "None", "47870", "30.37N", "130.59E", "95", "JP"],
    ["KAGOSHIMA AIRPOR", "RJFK", "None", "47851", "31.48N", "130.43E", "275", "JP"],
    ["MIYAZAKI AIRPORT", "RJFM", "None", "47857", "31.52N", "131.26E", "9", "JP"],
    ["NYUTABARU (JASDF", "RJFN", "None", "47854", "32.04N", "131.26E", "82", "JP"],
    ["OITA AIRPORT", "RJFO", "None", "47852", "33.28N", "131.43E", "8", "JP"],
    ["KITAKYUSHU/KOKUR", "RJFR", "None", "47853", "33.49N", "131.02E", "6", "JP"],
    ["SAGA AIRPORT", "RJFS", "None", "None", "33.09N", "130.18E", "5", "JP"],
    ["KUMAMOTO(CIV/JAS", "RJFT", "None", "47856", "32.49N", "130.50E", "196", "JP"],
    ["NAGASAKI(CIV/JMS", "RJFU", "None", "47855", "32.55N", "129.55E", "5", "JP"],
    ["SASABO NAS", "RJFW", "None", "None", "33.10N", "129.43E", "3", "JP"],
    ["KANOYA (JMSDF)", "RJFY", "None", "47850", "31.22N", "130.49E", "68", "JP"],
    ["TSUIKI (JASDF)", "RJFZ", "None", "47840", "33.40N", "131.03E", "20", "JP"],
    ["NAGOYA/CHUBU", "RJGG", "NGO", "None", "34.52N", "136.48E", "5", "JP"],
    ["AMAMI AIRPORT", "RJKA", "None", "47872", "28.25N", "129.43E", "7", "JP"],
    ["OKINOERABU/OKIER", "RJKB", "None", "47942", "27.25N", "128.41E", "29", "JP"],
    ["KIKAI ISLAND", "RJKI", "None", "None", "28.19N", "129.55E", "6", "JP"],
    ["TOKUNOSHIMA ISLA", "RJKN", "None", "47910", "27.49N", "128.52E", "5", "JP"],
    ["FUKUI AIRPORT", "RJNF", "None", "47706", "36.07N", "136.13E", "8", "JP"],
    ["GIFU (JASDF)", "RJNG", "None", "47634", "35.22N", "136.52E", "42", "JP"],
    ["HAMAMATSU (JASDF", "RJNH", "None", "47681", "34.45N", "137.41E", "48", "JP"],
    ["KOMATSU (CIV/JAS", "RJNK", "None", "47704", "36.22N", "136.25E", "9", "JP"],
    ["NAGOYA (CIV/JASD", "RJNN", "None", "47635", "35.15N", "136.55E", "17", "JP"],
    ["NAGOYA (CIV/JASD", "RJNA", "NKM", "None", "35.15N", "136.55E", "17", "JP"],
    ["OKI AIRPORT", "RJNO", "None", "47739", "36.10N", "133.19E", "95", "JP"],
    ["SHIZOUKA", "RJNS", "None", "None", "34.48N", "138.11E", "135", "JP"],
    ["TOYAMA AIRPORT", "RJNT", "None", "47707", "36.38N", "137.10E", "27", "JP"],
    ["NOTO", "RJNW", "None", "None", "37.18N", "136.58E", "219", "JP"],
    ["SHIZUHAMA (JASDF", "RJNY", "None", "47658", "34.49N", "138.18E", "10", "JP"],
    ["NEW HIROSHIMA", "RJOA", "None", "47789", "34.25N", "132.55E", "6", "JP"],
    ["OKAYAMA AIRPORT", "RJOB", "None", "47793", "34.45N", "133.50E", "242", "JP"],
    ["IZUMO AIRPORT", "RJOC", "None", "47790", "35.25N", "132.52E", "5", "JP"],
    ["AKENO (JASDF)", "RJOE", "None", "47730", "34.31N", "136.40E", "9", "JP"],
    ["HOFU (JASDF)", "RJOF", "None", "47788", "34.01N", "131.33E", "5", "JP"],
    ["MIHO (CIV/JASDF)", "RJOH", "None", "47743", "35.28N", "133.15E", "9", "JP"],
    ["IWAKUNI MCAS", "RJOI", "None", "47764", "34.08N", "132.13E", "2", "JP"],
    ["KOCHI AIRPORT", "RJOK", "None", "47883", "33.31N", "133.40E", "10", "JP"],
    ["MATSUYAMA AIRPOR", "RJOM", "None", "47882", "33.49N", "132.41E", "7", "JP"],
    ["OSAKA INTL/ITAMI", "RJOO", "None", "47771", "34.46N", "135.26E", "15", "JP"],
    ["KOMATSUJIMA (JAS", "RJOP", "None", "47884", "34.00N", "134.37E", "6", "JP"],
    ["TOTTORI AIRPORT", "RJOR", "None", "47794", "35.31N", "134.10E", "18", "JP"],
    ["TOKUSHIMA(JMSDF/", "RJOS", "None", "47881", "34.07N", "134.37E", "11", "JP"],
    ["TAKAMATSU AIRPOR", "RJOT", "None", "47880", "34.13N", "134.01E", "188", "JP"],
    ["IWAMI", "RJOW", "None", "47783", "34.40N", "131.48E", "54", "JP"],
    ["YAO (CIV/JGSDF)", "RJOY", "None", "47779", "34.36N", "135.35E", "13", "JP"],
    ["OZUKI (JMSDF)", "RJOZ", "None", "47787", "34.02N", "131.03E", "7", "JP"],
    ["AOMORI AIRPORT", "RJSA", "None", "47542", "40.43N", "140.41E", "201", "JP"],
    ["YAMAGATA(CIV/JGS", "RJSC", "None", "47553", "38.25N", "140.22E", "108", "JP"],
    ["SADO AIRPORT", "RJSD", "None", "47700", "38.02N", "138.25E", "26", "JP"],
    ["FUKUSHIMA ARPT", "RJSF", "None", "47557", "37.13N", "140.25E", "375", "JP"],
    ["HACHINOHE (JMSDF", "RJSH", "None", "47515", "40.32N", "141.28E", "49", "JP"],
    ["HANAMAKI AIRPORT", "RJSI", "None", "47549", "39.25N", "141.07E", "93", "JP"],
    ["AKITA AIRPORT", "RJSK", "None", "47545", "39.37N", "140.13E", "96", "JP"],
    ["MISAWA(JASDF/AF/", "RJSM", "None", "47580", "40.42N", "141.22E", "36", "JP"],
    ["NIIGATA (CIV/JAS", "RJSN", "None", "47573", "37.57N", "139.07E", "4", "JP"],
    ["OMINATO (JASDF)", "RJSO", "None", "47516", "41.13N", "141.07E", "10", "JP"],
    ["ODATE-NOSHIRO", "RJSR", "None", "None", "40.11N", "140.22E", "87", "JP"],
    ["SENDAI AIRPORT", "RJSS", "None", "47569", "38.07N", "140.55E", "5", "JP"],
    ["MATSUSHIMA (JASD", "RJST", "None", "47591", "38.23N", "141.13E", "5", "JP"],
    ["KASUMINOME (JASD", "RJSU", "None", "47567", "38.13N", "140.55E", "10", "JP"],
    ["SHONAI", "RJSY", "None", "None", "38.49N", "139.46E", "22", "JP"],
    ["ATSUGI NAS (JMSD", "RJTA", "None", "47679", "35.27N", "139.26E", "65", "JP"],
    ["TACHIKAWA (JASDF", "RJTC", "None", "47660", "35.42N", "139.24E", "98", "JP"],
    ["TOKYO JMA", "RJTD", "None", "47662", "35.41N", "139.46E", "36", "JP"],
    ["TATEYAMA (JMSDF)", "RJTE", "None", "47688", "34.58N", "139.49E", "6", "JP"],
    ["CHOFU AIRPORT", "RJTF", "None", "47683", "35.40N", "139.31E", "44", "JP"],
    ["HACHIJOJIMA ISLA", "RJTH", "None", "47738", "33.07N", "139.46E", "95", "JP"],
    ["TOKYO HELIPORT", "RJTI", "None", "47687", "35.38N", "139.50E", "8", "JP"],
    ["IRUMA (JASDF)", "RJTJ", "None", "47643", "35.49N", "139.25E", "93", "JP"],
    ["KISARAZU (JGSDF)", "RJTK", "None", "47661", "35.23N", "139.55E", "6", "JP"],
    ["SHIMOFUSA (JMSDF", "RJTL", "None", "47727", "35.47N", "140.01E", "33", "JP"],
    ["OSHIMA AIRPORT", "RJTO", "None", "47735", "34.46N", "139.22E", "41", "JP"],
    ["MIYAKEJIMA AIRPO", "RJTQ", "None", "47737", "34.04N", "139.34E", "23", "JP"],
    ["KASTNER AAF/ZAMA", "RJTR", "None", "47680", "35.31N", "139.24E", "109", "JP"],
    ["TOKYO INTL AIRPO", "RJTT", "None", "47671", "35.32N", "139.46E", "8", "JP"],
    ["UTSUNOMIYA (JGSD", "RJTU", "None", "47692", "36.31N", "139.52E", "105", "JP"],
    ["YOKOSUKA FWF", "RJTX", "None", "47696", "35.18N", "139.41E", "5", "JP"],
    ["YOKOTA (JASDF/US", "RJTY", "None", "47642", "35.45N", "139.20E", "139", "JP"],
    ["NAHA (CIV/JASDF)", "ROAH", "None", "47930", "26.10N", "127.39E", "8", "JP"],
    ["IEJIMA AUX (USAF", "RODE", "None", "47938", "26.43N", "127.46E", "73", "JP"],
    ["KADENA (USAFB-NA", "RODN", "None", "47931", "26.21N", "127.46E", "45", "JP"],
    ["HAMBY AAF/BUCKNE", "ROHF", "None", "47935", "26.18N", "127.46E", "6", "JP"],
    ["ISHIGAKIJIMA ISL", "ROIG", "None", "47918", "24.19N", "124.10E", "7", "JP"],
    ["KUMEJIMA ISLAND", "ROKJ", "None", "47929", "26.19N", "126.47E", "5", "JP"],
    ["MINAMIDAITOJIMA", "ROMD", "None", "47945", "25.49N", "131.13E", "15", "JP"],
    ["MIYAKOJIMA ISLAN", "ROMY", "None", "47927", "24.46N", "125.16E", "41", "JP"],
    ["AGUNI ISLAND", "RORA", "None", "None", "26.36N", "127.13E", "29", "JP"],
    ["HATERUMA", "RORH", "None", "None", "24.04N", "123.47E", "13", "JP"],
    ["KITADAITO ISLAND", "RORK", "None", "None", "25.55N", "131.19E", "22", "JP"],
    ["SHIMOJI-SHIMA IS", "RORS", "None", "None", "24.49N", "125.09E", "16", "JP"],
    ["TARAMA ISLAND", "RORT", "None", "None", "24.38N", "124.42E", "9", "JP"],
    ["YORON ISLAND", "RORY", "None", "None", "27.03N", "128.24E", "16", "JP"],
    ["FUTENMA(US-MCAS)", "ROTM", "None", "47933", "26.16N", "127.45E", "75", "JP"],
    ["YONAGUNI AIRPORT", "ROYN", "None", "47911", "24.28N", "122.58E", "17", "JP"],
    ["TAKAO RADAR", "TAKA", "None", "None", "35.34N", "133.13E", "15", "JP"],
    ["MUAN INTL", "RKJB", "None", "None", "34.59N", "126.23E", "2", "KR"],
    ["GWANGJU (KOR-AFB", "RKJJ", "None", "47158", "35.07N", "126.49E", "13", "KR"],
    ["KUNSAN (US/KOR-A", "RKJK", "None", "47141", "35.54N", "126.37E", "9", "KR"],
    ["MOKPO (KOR-NAVY)", "RKJM", "None", "None", "34.46N", "126.22E", "3", "KR"],
    ["JHUNJU (KOR-ARMY", "RKJU", "None", "None", "35.52N", "127.07E", "29", "KR"],
    ["YOSU AIRPORT", "RKJY", "None", "47167", "34.49N", "127.37E", "18", "KR"],
    ["CAMP PAGE/CHUNCH", "RKNC", "None", "47104", "37.52N", "127.43E", "75", "KR"],
    ["SOKCHO AIRPORT", "RKND", "None", "47091", "38.07N", "128.35E", "14", "KR"],
    ["WHANG RYEONG", "RKNF", "None", "None", "37.45N", "128.40E", "1407", "KR"],
    ["HOENGSONG (KOR-A", "RKNH", "None", "47118", "37.25N", "127.57E", "101", "KR"],
    ["KANGNUNG (KOR-AF", "RKNN", "None", "47107", "37.45N", "128.56E", "11", "KR"],
    ["KEO JIN", "RKNO", "None", "None", "38.28N", "128.28E", "107", "KR"],
    ["KOTAR RANGE", "RKNR", "None", "None", "37.06N", "128.54E", "792", "KR"],
    ["WONJU", "RKNW", "None", "47114", "37.19N", "127.57E", "150", "KR"],
    ["YANGYANG INTL", "RKNY", "None", "None", "38.04N", "128.40E", "74", "KR"],
    ["JEJU INTL AIRPO", "RKPC", "None", "47182", "33.30N", "126.29E", "27", "KR"],
    ["JINHAE (KOR-ARM", "RKPE", "None", "None", "35.08N", "128.41E", "2", "KR"],
    ["BUSAN/KIMHAE INT", "RKPK", "None", "47153", "35.10N", "128.55E", "15", "KR"],
    ["MOSULPO (KOR-AFB", "RKPM", "None", "47187", "33.12N", "126.16E", "27", "KR"],
    ["SACHON (KOR-AFB)", "RKPS", "None", "47161", "35.04N", "128.04E", "8", "KR"],
    ["ULSAN", "RKPU", "None", "47152", "35.32N", "129.19E", "33", "KR"],
    ["DONGHAE RADAR", "RKSB", "None", "47106", "37.30N", "129.08E", "37", "KR"],
    ["SV RI SAN", "RKSC", "None", "None", "37.21N", "126.55E", "406", "KR"],
    ["MAESANRI", "RKSD", "None", "None", "37.21N", "127.16E", "144", "KR"],
    ["PAENGNYONGDO BEA", "RKSE", "None", "None", "37.57N", "124.43E", "2", "KR"],
    ["SEOUL (KOR-AF HQ", "RKSF", "None", "47117", "37.30N", "126.55E", "49", "KR"],
    ["PYONGTAEK (A-511", "RKSG", "None", "47127", "36.58N", "127.01E", "16", "KR"],
    ["COMMAND POST TAN", "RKSH", "None", "None", "37.31N", "126.58E", "73", "KR"],
    ["CHAJANG NI", "RKSI", "None", "None", "37.28N", "126.27E", "7", "KR"],
    ["TAESONG-SAN", "RKSJ", "None", "None", "38.12N", "127.32E", "1182", "KR"],
    ["SEOUL CITY", "RKSL", "None", "47108", "37.34N", "126.58E", "87", "KR"],
    ["SEOUL EAST(KOR-A", "RKSM", "None", "47111", "37.25N", "127.07E", "20", "KR"],
    ["KOON-NI RANGE", "RKSN", "None", "69010", "37.01N", "126.45E", "15", "KR"],
    ["OSAN (US/KOR-AFB", "RKSO", "None", "47122", "37.04N", "127.01E", "12", "KR"],
    ["PAENGNYONGDO (KA", "RKSP", "None", "47103", "37.58N", "124.40E", "171", "KR"],
    ["YEONPYEUNGDO", "RKSQ", "None", "None", "37.42N", "125.42E", "91", "KR"],
    ["SEOUL/KIMPO INTL", "RKSS", "None", "47110", "37.32N", "126.47E", "19", "KR"],
    ["CAMP CASEY/TONGD", "RKST", "None", "None", "37.55N", "127.03E", "60", "KR"],
    ["YEOJU RANGE", "RKSU", "None", "None", "37.25N", "127.37E", "43", "KR"],
    ["PYORIPSAN", "RKSV", "None", "None", "37.46N", "126.22E", "250", "KR"],
    ["SUWON (US/KOR-AF", "RKSW", "None", "47120", "37.15N", "127.00E", "24", "KR"],
    ["CAMP STANLEY/H-2", "RKSX", "None", "None", "37.43N", "127.05E", "71", "KR"],
    ["YONGSAN/H-208 HP", "RKSY", "None", "None", "37.31N", "126.58E", "12", "KR"],
    ["ANDONG", "RKTA", "None", "47136", "36.32N", "128.43E", "142", "KR"],
    ["PAEKADO", "RKTB", "None", "None", "37.01N", "126.02E", "46", "KR"],
    ["TAEJON (KOR-AFB)", "RKTD", "None", "47132", "36.32N", "126.20E", "63", "KR"],
    ["SONGMU (KOR-AFB)", "RKTE", "None", "47124", "36.23N", "127.30E", "79", "KR"],
    ["TAEJON", "RKTF", "None", "47133", "36.17N", "127.24E", "78", "KR"],
    ["CAMP WALKER (H-8", "RKTG", "None", "None", "35.51N", "128.36E", "75", "KR"],
    ["POHANG (KOR-NAVY", "RKTH", "None", "47139", "35.58N", "129.25E", "20", "KR"],
    ["JUNG WON (ROK-AB", "RKTI", "None", "47125", "37.01N", "127.52E", "91", "KR"],
    ["ULJIN", "RKTL", "None", "None", "36.59N", "129.24E", "49", "KR"],
    ["MANGILSAN (KOR-A", "RKTM", "None", "47126", "36.56N", "126.27E", "302", "KR"],
    ["TAEGU (US/KOR-AF", "RKTN", "None", "47142", "35.53N", "128.39E", "35", "KR"],
    ["SANGJU", "RKTS", "None", "None", "36.25N", "128.10E", "150", "KR"],
    ["TAEGU ACC (KOR-A", "RKTT", "None", "47143", "35.52N", "128.37E", "61", "KR"],
    ["JONGJU (KAFB-AR", "RKTU", "None", "47128", "36.42N", "127.30E", "66", "KR"],
    ["JUNGJU", "RKTV", "None", "None", "37.04N", "127.52E", "59", "KR"],
    ["WOONG CHEON", "RKTW", "None", "None", "36.12N", "126.32E", "13", "KR"],
    ["YECHON (KOR-AFB)", "RKTY", "None", "47134", "36.37N", "128.20E", "108", "KR"],
    ["HAEMI", "RKTZ", "None", "None", "36.23N", "126.20E", "31", "KR"],
    ["NIGHTMARE RANGE", "RKXX", "None", "None", "38.04N", "127.20E", "0", "KR"],
    ["YANGGU (G-404)", "RK13", "None", "None", "38.05N", "127.59E", "200", "KR"],
    ["OLONGAPO/SUBIC", "RPLB", "None", "98426", "14.48N", "120.16E", "17", "PH"],
    ["ANGELES/PAMPANGA", "RPLC", "None", "98327", "15.10N", "120.35E", "196", "PH"],
    ["LAOAG INTL(PH-AR", "RPLI", "None", "98223", "18.10N", "120.31E", "5", "PH"],
    ["NINOY AQUINO INT", "RPLL", "None", "98429", "14.31N", "121.00E", "21", "PH"],
    ["DAVAO/FRANCISCO", "RPMD", "None", "98753", "07.07N", "125.39E", "18", "PH"],
    ["CLARK AFB/LUZON", "RPMK", "None", "None", "15.10N", "120.32E", "196", "PH"],
    ["CAGAYAN DE ORO", "RPML", "CGY", "None", "08.26N", "124.37E", "186", "PH"],
    ["LEGAZPI/LUZON IS", "RPMP", "None", "98444", "13.09N", "123.44E", "17", "PH"],
    ["ROMBLON/TABLAS I", "RPMR", "None", "98536", "12.34N", "122.16E", "47", "PH"],
    ["SANGLEY POINT AB", "RPMS", "None", "98428", "14.30N", "120.55E", "4", "PH"],
    ["ZAMBOANGA (CIV/A", "RPMZ", "None", "98836", "06.55N", "122.04E", "6", "PH"],
    ["APARRI/LUZON ISL", "RPUA", "None", "98232", "18.22N", "121.37E", "3", "PH"],
    ["BAGUIO/LUZON ISL", "RPUB", "None", "98328", "16.23N", "120.37E", "1296", "PH"],
    ["DAET/LUZON ISLAN", "RPUD", "None", "98440", "14.07N", "122.58E", "4", "PH"],
    ["SAN JOSE/MINDORO", "RPUH", "None", "98531", "12.20N", "121.01E", "3", "PH"],
    ["IBA/LUZON ISLAND", "RPUI", "None", "98324", "15.19N", "119.58E", "5", "PH"],
    ["CALAPAN/MINDORO", "RPUK", "None", "98431", "13.25N", "121.10E", "41", "PH"],
    ["MAMBURAO/MINDORO", "RPUM", "None", "None", "13.13N", "120.35E", "4", "PH"],
    ["NAGA/LUZON ISLAN", "RPUN", "None", "None", "13.34N", "123.16E", "43", "PH"],
    ["BASCO/BATAN ISLA", "RPUO", "None", "98135", "20.26N", "121.58E", "11", "PH"],
    ["VIGAN/LUZON ISLA", "RPUQ", "None", "98222", "17.54N", "120.28E", "33", "PH"],
    ["BALER/LUZON ISLA", "RPUR", "None", "98333", "15.46N", "121.34E", "6", "PH"],
    ["TUGUEGARAO/LUZON", "RPUT", "None", "98233", "17.37N", "121.43E", "62", "PH"],
    ["VIRAC/CATANDUANE", "RPUV", "None", "98446", "13.34N", "124.13E", "40", "PH"],
    ["MARINDUQUE ISLAN", "RPUW", "None", "None", "13.22N", "121.49E", "5", "PH"],
    ["TACLOBAN/LEYTE I", "RPVA", "None", "98550", "11.15N", "125.00E", "3", "PH"],
    ["BACOLOD/NEGROS I", "RPVB", "None", "None", "10.39N", "122.55E", "9", "PH"],
    ["CALBAYOG/SAMAR I", "RPVC", "None", "None", "12.04N", "124.32E", "3", "PH"],
    ["DUMAGUETE/NEGROS", "RPVD", "None", "98642", "09.20N", "123.18E", "8", "PH"],
    ["CATARMAN/SAMAR I", "RPVF", "None", "98546", "12.28N", "124.37E", "5", "PH"],
    ["GUIUAN/SAMAR ISL", "RPVG", "None", "98558", "11.01N", "125.43E", "60", "PH"],
    ["ILOILO/PANAY ISL", "RPVI", "None", "98637", "10.41N", "122.34E", "8", "PH"],
    ["MASBATE", "RPVJ", "None", "98543", "12.22N", "123.38E", "6", "PH"],
    ["KALIBO/PANAY ISL", "RPVK", "None", "None", "11.40N", "122.22E", "6", "PH"],
    ["MACTAN-CEBU", "RPVM", "None", "98646", "10.19N", "123.59E", "10", "PH"],
    ["PUERTO PRINCESA", "RPVP", "None", "98618", "09.45N", "118.43E", "16", "PH"],
    ["ROXAS/PANAY ISLA", "RPVR", "None", "98538", "11.34N", "122.45E", "4", "PH"],
    ["TAGBILARAN/BOHOL", "RPVT", "None", "98644", "09.35N", "123.50E", "8", "PH"],
    ["GENERAL SANTOS", "RPWB", "None", "98851", "06.07N", "125.10E", "15", "PH"],
    ["COTABATO/MINDANA", "RPWC", "None", "98746", "07.10N", "124.13E", "58", "PH"],
    ["BUTUAN/MINDANAO", "RPWE", "None", "98752", "08.57N", "125.29E", "46", "PH"],
    ["DIPOLOG/MINDANAO", "RPWG", "None", "98741", "08.35N", "123.20E", "5", "PH"],
    ["OZAMIS/MINDANAO", "RPWI", "None", "None", "08.10N", "123.50E", "5", "PH"],
    ["JOLO ISLAND", "RPWJ", "None", "98830", "06.02N", "121.00E", "13", "PH"],
    ["CAGAYAN DE ORO", "RPWL", "None", "98748", "08.28N", "124.37E", "6", "PH"],
    ["MALABANG/MINDANA", "RPWM", "None", "None", "07.37N", "124.04E", "8", "PH"],
    ["PAGADIAN/MINDANA", "RPWP", "None", "None", "07.49N", "123.28E", "2", "PH"],
    ["SURIGAO/MINDANAO", "RPWS", "None", "98653", "09.48N", "125.30E", "55", "PH"],
    ["TANDAG/MINDANAO", "RPWW", "None", "None", "09.04N", "126.10E", "5", "PH"],
    ["ILIGAN/MINDANAO", "RPWX", "None", "None", "08.09N", "124.13E", "396", "PH"],
    ["MALAYBALAY/MINDA", "RPWY", "None", "98751", "08.09N", "125.04E", "627", "PH"],
    ["BISLIG/MINDANAO", "RPWZ", "None", "None", "08.13N", "126.19E", "3", "PH"],
    ["CROW VALLEY GNRY", "RPXC", "None", "98322", "15.19N", "120.22E", "161", "PH"],
    ["ALABAT ISLAND", "RPXT", "None", "98435", "14.14N", "121.56E", "5", "PH"],
    ["MACTAN INTL(CIV/", "RPMT", "None", "None", "10.19N", "123.59E", "24", "PH"],
    ["AHMADABAD", "VAAH", "None", "42647", "23.04N", "072.37E", "55", "IN"],
    ["AKOLA AIRPORT", "VAAK", "None", "42934", "20.41N", "077.04E", "309", "IN"],
    ["AURANGABAD AIRPO", "VAAU", "None", "43014", "19.51N", "075.24E", "579", "IN"],
    ["BOMBAY/SANTACRUZ", "VABB", "None", "43003", "19.06N", "072.52E", "8", "IN"],
    ["BILASPUR", "VABI", "None", "42080", "31.15N", "076.40E", "587", "IN"],
    ["BHUJ-RUDRAMATA(A", "VABJ", "None", "42634", "23.17N", "069.40E", "80", "IN"],
    ["BELGAUM/SAMBRA", "VABM", "None", "43198", "15.50N", "074.37E", "747", "IN"],
    ["VADODARA", "VABO", "None", "None", "22.20N", "073.14E", "39", "IN"],
    ["BHOPAL/BAIRAGARH", "VABP", "None", "42667", "23.16N", "077.20E", "523", "IN"],
    ["BHAUNAGAR", "VABV", "None", "42838", "21.45N", "072.12E", "11", "IN"],
    ["GOA/DABOLIM (NAV", "VAGO", "None", "None", "15.22N", "073.49E", "52", "IN"],
    ["GOA/DABOLIM (NAV", "VOGO", "None", "43194", "15.22N", "073.49E", "52", "IN"],
    ["INDORE", "VAID", "None", "42754", "22.43N", "075.47E", "567", "IN"],
    ["JABALPUR", "VAJB", "None", "42675", "23.11N", "079.57E", "393", "IN"],
    ["BOMBAY/JUHU", "VAJJ", "None", "43002", "19.07N", "072.49E", "4", "IN"],
    ["JAMNAGAR (IN-AFB", "VAJM", "None", "42734", "22.26N", "070.04E", "20", "IN"],
    ["KHAJURAHO", "VAKJ", "None", "None", "24.49N", "079.55E", "222", "IN"],
    ["KHANDWA", "VAKD", "None", "42855", "21.49N", "076.22E", "318", "IN"],
    ["KANDLA AERODROME", "VAKE", "None", "42638", "23.08N", "070.07E", "35", "IN"],
    ["KOLHAPUR", "VAKP", "None", "43157", "16.41N", "074.13E", "570", "IN"],
    ["NAGPUR SONEGAON", "VANP", "None", "42867", "21.05N", "079.03E", "310", "IN"],
    ["PUNE/POONA (IN-A", "VAPO", "None", "43064", "18.34N", "073.55E", "593", "IN"],
    ["PORBANDAR", "VAPR", "None", "42830", "21.38N", "069.40E", "7", "IN"],
    ["RAJKOT", "VARK", "None", "42737", "22.18N", "070.46E", "138", "IN"],
    ["RAIPUR", "VARP", "None", "42875", "21.13N", "081.39E", "298", "IN"],
    ["SHOLAPUR", "VASL", "None", "43117", "17.40N", "075.54E", "479", "IN"],
    ["MAHARANA PRATAP", "VAUD", "None", "None", "24.37N", "073.54E", "513", "IN"],
    ["AGARTALA", "VEAT", "None", "42724", "23.52N", "091.15E", "16", "IN"],
    ["BAGHDOGRA (IN-AF", "VEBD", "None", "42398", "26.41N", "088.20E", "126", "IN"],
    ["BHUBANESWAR", "VEBS", "None", "42971", "20.15N", "085.49E", "46", "IN"],
    ["VARANASI", "VEBN", "None", "None", "25.27N", "082.51E", "83", "IN"],
    ["CALCUTTA/DUM DUM", "VECC", "None", "42809", "22.39N", "088.26E", "6", "IN"],
    ["CAR NICOBAR(IN-A", "VECX", "None", "43368", "09.09N", "092.49E", "14", "IN"],
    ["GORAKHPUR (IN-AF", "VEGK", "None", "42379", "26.45N", "083.22E", "77", "IN"],
    ["GAUHATI (IN-AFB)", "VEGT", "None", "42410", "26.06N", "091.35E", "54", "IN"],
    ["GAYA", "VEGY", "None", "42591", "24.45N", "084.57E", "116", "IN"],
    ["IMPHAL/TULIHAL", "VEIM", "None", "42623", "24.46N", "093.54E", "781", "IN"],
    ["JHARSUGUDA", "VEJH", "None", "42886", "21.55N", "084.04E", "230", "IN"],
    ["JAMSHEDPUR(PRIVA", "VEJS", "None", "42798", "22.49N", "086.10E", "142", "IN"],
    ["NORTH LAKHIMPUR/", "VELR", "None", "42309", "27.18N", "094.06E", "101", "IN"],
    ["MALDA", "VEMH", "None", "42503", "25.01N", "088.07E", "31", "IN"],
    ["DIBRUGARH/MOHANB", "VEMN", "None", "42314", "27.28N", "095.01E", "111", "IN"],
    ["PORT BLAIR", "VEPB", "None", "43333", "11.40N", "092.43E", "79", "IN"],
    ["PATNA", "VEPT", "None", "42492", "25.36N", "085.05E", "60", "IN"],
    ["RANCHI", "VERC", "None", "42701", "23.19N", "085.19E", "652", "IN"],
    ["ROURKELA (PRIVAT", "VERK", "None", "42793", "22.13N", "084.52E", "196", "IN"],
    ["RAXAUL", "VERL", "None", "42382", "26.58N", "084.50E", "79", "IN"],
    ["AGRA (IN-AFB)", "VIAG", "None", "42260", "27.08N", "077.58E", "169", "IN"],
    ["ALIGARH", "VIAH", "None", "42262", "27.52N", "078.04E", "187", "IN"],
    ["ALLAHABAD (IN-AF", "VIAL", "None", "42475", "25.26N", "081.43E", "98", "IN"],
    ["AMRITSAR", "VIAR", "None", "42071", "31.42N", "074.48E", "234", "IN"],
    ["VARANASI/BABATPU", "VIBN", "None", "42479", "25.26N", "082.52E", "85", "IN"],
    ["BHATINDA", "VIBT", "None", "42097", "30.10N", "074.34E", "211", "IN"],
    ["BAREILLY (IN-AFB", "VIBY", "None", "42189", "28.22N", "079.24E", "173", "IN"],
    ["KANPUR/CHAKERI(A", "VICX", "None", "42367", "26.23N", "080.24E", "126", "IN"],
    ["DELHI/SAFDARJUNG", "VIDD", "None", "42182", "28.35N", "077.13E", "216", "IN"],
    ["INDIRA GANDHI/DE", "VIDP", "None", "42181", "28.34N", "077.07E", "233", "IN"],
    ["GWALIOR (IN-AFB)", "VIGR", "None", "42361", "26.13N", "078.15E", "207", "IN"],
    ["HISSAR", "VIHR", "None", "42131", "29.10N", "075.43E", "221", "IN"],
    ["JHANSI", "VIJN", "None", "42463", "25.26N", "078.34E", "251", "IN"],
    ["JODHPUR (IN-AFB)", "VIJO", "None", "42339", "26.18N", "073.01E", "224", "IN"],
    ["JAIPUR/SANGANER", "VIJP", "None", "42348", "26.49N", "075.47E", "390", "IN"],
    ["KANPUR", "VIKA", "None", "42366", "26.25N", "080.22E", "126", "IN"],
    ["KOTA AERODROME", "VIKO", "None", "42452", "25.08N", "075.50E", "274", "IN"],
    ["LUCKNOW/AMAUSI", "VILK", "None", "42369", "26.45N", "080.52E", "128", "IN"],
    ["SRINAGAR (CIV/MI", "VISR", "None", "42042", "33.58N", "074.46E", "1666", "IN"],
    ["SATNA", "VIST", "None", "42571", "24.34N", "080.49E", "317", "IN"],
    ["UDAIPUR/DABOK", "VIUD", "None", "42542", "24.37N", "073.52E", "514", "IN"],
    ["BANGALORE ARP", "VOBG", "None", "43296", "12.57N", "077.38E", "897", "IN"],
    ["BELLARY", "VOBI", "None", "43205", "15.09N", "076.50E", "449", "IN"],
    ["BENGALURU", "VOBL", "None", "None", "13.12N", "077.42E", "915", "IN"],
    ["BELGAUM", "VOBM", "None", "None", "15.52N", "074.37E", "758", "IN"],
    ["VIJAYAWADA/GANNA", "VOBZ", "None", "43181", "16.31N", "080.47E", "24", "IN"],
    ["COIMBATORE/PEELA", "VOCB", "None", "43321", "11.01N", "077.02E", "399", "IN"],
    ["COCHIN (IN-NAVY)", "VOCC", "None", "43353", "09.56N", "076.16E", "3", "IN"],
    ["COCHIN INTL", "VOCI", "None", "None", "10.09N", "076.24E", "8", "IN"],
    ["CALICUT", "VOCL", "None", "None", "11.08N", "075.57E", "104", "IN"],
    ["CUDDAPAH", "VOCP", "None", "43241", "14.28N", "078.49E", "130", "IN"],
    ["RAJIV GANDHI INL", "VOHS", "None", "None", "17.14N", "078.26E", "1", "IN"],
    ["HYDERABAD (CIV/M", "VOHY", "None", "43128", "17.27N", "078.27E", "545", "IN"],
    ["MADURAI", "VOMD", "None", "43360", "09.49N", "078.04E", "131", "IN"],
    ["MANGALORE/BAJPE", "VOML", "None", "43284", "12.58N", "074.53E", "103", "IN"],
    ["MADRAS/CHENNAI", "VOMM", "None", "43279", "13.00N", "080.10E", "16", "IN"],
    ["MYSORE", "VOMY", "None", "43291", "12.18N", "076.42E", "767", "IN"],
    ["TIRUPATI", "VOTP", "None", "None", "13.38N", "079.33E", "107", "IN"],
    ["TIRUCHCHIRAPALLI", "VOTR", "None", "43344", "10.46N", "078.43E", "88", "IN"],
    ["THIRUVANANTHAPUR", "VOTV", "None", "43372", "08.28N", "076.57E", "8", "IN"],
    ["VELLORE", "VOVR", "None", "43303", "12.55N", "079.09E", "214", "IN"],
    ["VISAKHAPATNAM", "VOVZ", "None", "None", "17.43N", "083.13E", "5", "IN"],
    ["BHAMO", "VBBM", "None", "48019", "24.16N", "097.12E", "113", "MM"],
    ["PATHEIN/BASSEIN", "VBBS", "None", "48094", "16.46N", "094.46E", "10", "MM"],
    ["COCO ISLAND", "VBCI", "None", "48109", "14.07N", "093.22E", "3", "MM"],
    ["HOMALIN", "VBHL", "None", "48010", "24.52N", "094.55E", "131", "MM"],
    ["KENGTUNG", "VBKG", "None", "48060", "21.18N", "099.37E", "828", "MM"],
    ["KYAUKPYU/RAMREE", "VBKP", "None", "48071", "19.25N", "093.32E", "5", "MM"],
    ["LASHIO", "VBLS", "None", "48035", "22.55N", "097.45E", "749", "MM"],
    ["MYITKYINA", "VBMK", "None", "48008", "25.22N", "097.24E", "147", "MM"],
    ["MEIKTILA", "VBML", "None", "48053", "20.49N", "095.49E", "220", "MM"],
    ["MOULMEIN", "VBMM", "None", "48103", "16.30N", "097.37E", "22", "MM"],
    ["MONGHSAT", "VBMS", "None", "48070", "20.33N", "099.16E", "572", "MM"],
    ["NYAUNG-U/PAGAN", "VBNU", "None", "48048", "21.11N", "094.55E", "55", "MM"],
    ["HPA-AN/PA-AN", "VBPA", "None", "48099", "16.45N", "097.40E", "10", "MM"],
    ["BAGO/PEGU", "VBPG", "None", "48093", "17.19N", "096.30E", "15", "MM"],
    ["PROME/PYE", "VBPR", "None", "48077", "18.48N", "095.13E", "60", "MM"],
    ["PUTAO", "VBPT", "None", "48001", "27.19N", "097.25E", "409", "MM"],
    ["AKYAB", "VBRA", "None", "None", "20.07N", "092.52E", "5", "MM"],
    ["SITTWE/AKYAB", "VYSW", "None", "48062", "20.07N", "092.52E", "5", "MM"],
    ["MANDALAY", "VBRM", "None", "48042", "21.58N", "096.05E", "76", "MM"],
    ["MERGUI", "VBRN", "None", "48110", "12.25N", "098.35E", "37", "MM"],
    ["RANGOON/MINGALAD", "VBRR", "None", "48096", "16.53N", "096.10E", "29", "MM"],
    ["SANDOWAY/MAZIN", "VBSY", "None", "48080", "18.28N", "094.20E", "11", "MM"],
    ["DAWEI", "VBTV", "None", "48108", "14.05N", "098.13E", "17", "MM"],
    ["YE", "VBYE", "None", "48107", "15.15N", "097.52E", "7", "MM"],
    ["MANDALAY", "VYMD", "None", "None", "21.42N", "095.59E", "91", "MM"],
    ["COLOMBO/KATUNAYA", "VCBI", "None", "43450", "07.10N", "079.52E", "8", "LK"],
    ["ANURADHAPURA (AF", "VCCA", "None", "43421", "08.19N", "080.25E", "89", "LK"],
    ["BATTICALOA (AFB)", "VCCB", "None", "43436", "07.43N", "081.42E", "12", "LK"],
    ["COLOMBO/RATMALAN", "VCCC", "None", "43467", "06.49N", "079.52E", "5", "LK"],
    ["TRINCOMALEE (AFB", "VCCT", "None", "43418", "08.34N", "081.15E", "7", "LK"],
    ["MATTALA RAJAPAKS", "VCRI", "None", "43407", "06.17N", "081.08E", "7", "LK"],
    ["BATTAMBANG", "VDGB", "None", "48962", "13.05N", "103.12E", "13", "KH"],
    ["KOMPONG-CHAM", "VDKC", "None", "48995", "12.00N", "105.27E", "16", "KH"],
    ["KAMPONG CHHNANG", "VDKH", "None", "48969", "12.15N", "104.40E", "15", "KH"],
    ["PHNOM-PENH/POCHE", "VDPP", "None", "48991", "11.33N", "104.50E", "10", "KH"],
    ["SIEMREAP", "VDSR", "None", "48966", "13.25N", "103.50E", "15", "KH"],
    ["STUNG TRENG", "VDST", "None", "48972", "13.31N", "105.58E", "56", "KH"],
    ["BOGRA", "VGBG", "None", "41883", "24.51N", "089.22E", "20", "BD"],
    ["COX'S BAZAR", "VGCB", "None", "41992", "21.25N", "091.58E", "4", "BD"],
    ["COMILLA", "VGCM", "None", "41933", "23.25N", "091.10E", "10", "BD"],
    ["CHITTAGONG (CV/M", "VGEG", "None", "41978", "22.16N", "091.49E", "6", "BD"],
    ["DHAKA", "VGHS", "None", "41922", "23.51N", "090.24E", "10", "BD"],
    ["ISHURDI", "VGIS", "None", "41907", "24.07N", "089.02E", "14", "BD"],
    ["JESSORE (CIV/MIL", "VGJR", "None", "41936", "23.10N", "089.10E", "7", "BD"],
    ["RAJSHAHI", "VGRJ", "None", "41895", "24.22N", "088.42E", "20", "BD"],
    ["THAKURGAON", "VGSG", "None", "41852", "26.01N", "088.24E", "54", "BD"],
    ["SYLHET OSMANI", "VGSY", "None", "41891", "24.58N", "091.52E", "16", "BD"],
    ["DHAKA/TEJGAON (M", "VGTJ", "None", "41923", "23.46N", "090.22E", "9", "BD"],
    ["KURMITOLA/ZIA IN", "VGZR", "None", "None", "23.51N", "090.24E", "10", "BD"],
    ["CHEUNG CHAU", "VHCH", "None", "45001", "22.11N", "114.01E", "79", "HK"],
    ["HONG KONG INTL", "VHHH", "None", "45007", "22.19N", "113.55E", "9", "HK"],
    ["HONG KONG RO", "HKRO", "None", "45004", "22.19N", "114.10E", "66", "HK"],
    ["H KONG OLD VHHH", "None", "None", "None", "22.20N", "114.11E", "24", "HK"],
    ["ATTOPEU", "VLAP", "None", "48957", "14.48N", "106.49E", "105", "LA"],
    ["BAN HOUAYXAY/BAN", "VLHS", "None", "None", "20.15N", "100.25E", "421", "LA"],
    ["PAKSE (CIV/MIL)", "VLIP", "None", "48955", "15.07N", "105.10E", "102", "LA"],
    ["MUANG KHONG", "VLKG", "None", "None", "14.07N", "105.50E", "76", "LA"],
    ["LUANG-PRABANG", "VLLB", "None", "48930", "19.54N", "102.10E", "291", "LA"],
    ["LUANG NAMTHA", "VLLN", "None", "None", "20.58N", "101.24E", "600", "LA"],
    ["PAKSE INTL", "VLPS", "None", "None", "15.08N", "105.47E", "107", "LA"],
    ["SAYABOURY", "VLSB", "None", "48938", "19.13N", "101.43E", "326", "LA"],
    ["SAVANNAKHET(CV/M", "VLSK", "None", "48947", "16.33N", "104.45E", "155", "LA"],
    ["SAM-NEUA", "VLSN", "None", "48928", "20.25N", "104.04E", "1000", "LA"],
    ["SARAVANE", "VLSV", "None", "48952", "15.40N", "106.25E", "168", "LA"],
    ["THAKHEK", "VLTK", "None", "48946", "17.22N", "104.39E", "52", "LA"],
    ["VIENTIANE/WATTAY", "VLVT", "None", "48940", "17.59N", "102.34E", "171", "LA"],
    ["VANG VIENG(CIV/M", "VLVV", "None", "None", "18.55N", "102.27E", "296", "LA"],
    ["MACAO/MACAU", "VMMC", "None", "45011", "22.09N", "113.35E", "6", "MO"],
    ["BHAIRAWA AIRPORT", "VNBW", "None", "44438", "27.31N", "083.27E", "109", "NP"],
    ["JUMLA", "VNJL", "None", "44424", "29.16N", "082.10E", "2300", "NP"],
    ["KATHMANDU INTL A", "VNKT", "None", "44454", "27.41N", "085.22E", "1337", "NP"],
    ["POKHARA AIRPORT", "VNPK", "None", "44434", "28.13N", "084.00E", "827", "NP"],
    ["SIMRA AIRPORT", "VNSI", "None", "44449", "27.10N", "084.58E", "137", "NP"],
    ["SURKHET", "VNSK", "None", "44416", "28.36N", "081.37E", "720", "NP"],
    ["TAPLEJUNG", "VNTJ", "None", "44474", "27.21N", "087.40E", "1732", "NP"],
    ["BIRATNAGAR AIRPO", "VNVT", "None", "44478", "26.28N", "087.16E", "72", "NP"],
    ["PARO", "VQPR", "None", "None", "27.24N", "089.26E", "2235", "BT"],
    ["GAN ISLAND", "VRGN", "None", "43599", "00.40S", "073.09E", "2", "MV"],
    ["GAN INTL AIRPORT", "VRMG", "None", "None", "00.42S", "073.09E", "3", "MV"],
    ["MALE INTL/HULULE", "VRMM", "None", "43555", "04.12N", "073.31E", "2", "MV"],
    ["CHANTHABURI", "VTBC", "None", "48480", "12.35N", "102.07E", "4", "TH"],
    ["BANGKOK/DON MUAN", "VTBD", "DMK", "48456", "13.55N", "100.36E", "3", "TH"],
    ["KANCHANABURI", "VTBG", "None", "48450", "14.01N", "099.32E", "29", "TH"],
    ["PRACHIN BURI (AR", "VTBI", "None", "48430", "14.03N", "101.22E", "6", "TH"],
    ["PHETCHABURI/THA", "VTBJ", "None", "48465", "13.09N", "100.04E", "4", "TH"],
    ["KAMPHAENG SAEN(A", "VTBK", "None", "None", "14.05N", "099.55E", "9", "TH"],
    ["KOKE KATHIEM (MI", "VTBL", "None", "None", "14.52N", "100.40E", "30", "TH"],
    ["TRAT/KHAO SAMING", "VTBO", "None", "None", "12.17N", "102.19E", "32", "TH"],
    ["PRACHUAP KHIRI K", "VTBP", "None", "48500", "11.49N", "099.49E", "5", "TH"],
    ["CHON BURI/SATTAH", "VTBS", "BKK", "48459", "13.41N", "100.45E", "2", "TH"],
    ["RAYONG/U-TAPHAO", "VTBU", "None", "48478", "12.41N", "101.00E", "5", "TH"],
    ["CHIANG KHAM (ARM", "VTCB", "None", "None", "19.30N", "100.16E", "389", "TH"],
    ["CHIANG MAI(CIV/A", "VTCC", "None", "48327", "18.46N", "098.58E", "314", "TH"],
    ["MAE HONG SON/MUA", "VTCH", "None", "48300", "19.18N", "097.59E", "269", "TH"],
    ["LAMPANG", "VTCL", "None", "48328", "18.16N", "099.31E", "242", "TH"],
    ["NAN/MUANG NAN", "VTCN", "None", "48331", "18.49N", "100.46E", "201", "TH"],
    ["PHRAE", "VTCP", "None", "48330", "18.08N", "100.10E", "162", "TH"],
    ["CHIANG RAI", "VTCR", "None", "48303", "19.55N", "099.49E", "395", "TH"],
    ["MAE SARIANG", "VTCS", "None", "48325", "18.10N", "097.55E", "213", "TH"],
    ["CHIANG RAI INTL", "VTCT", "CEI", "None", "19.57N", "099.53E", "390", "TH"],
    ["PHETCHABUN", "VTPB", "None", "None", "16.40N", "101.12E", "137", "TH"],
    ["HUA HIN", "VTPH", "None", "48475", "12.38N", "099.57E", "6", "TH"],
    ["LOM SAK (THAI-AF", "VTPL", "None", "None", "16.49N", "101.15E", "152", "TH"],
    ["SUKHOTHAI", "VTPO", "None", "None", "17.14N", "099.49E", "54", "TH"],
    ["MAE SOT/TAK", "VTPM", "None", "48375", "16.40N", "098.32E", "197", "TH"],
    ["NAKHON SAWAN/PAK", "VTPN", "None", "48400", "15.48N", "100.10E", "35", "TH"],
    ["PHITSANULOK", "VTPP", "PHS", "None", "16.47N", "100.17E", "44", "TH"],
    ["PHITSANULOK/SARI", "VTPS", "None", "48378", "16.46N", "100.16E", "45", "TH"],
    ["TAK", "VTPT", "None", "48376", "16.52N", "099.09E", "124", "TH"],
    ["UTTARADIT EAST", "VTPU", "None", "48351", "17.37N", "100.05E", "64", "TH"],
    ["SATUN (THAI-AFB)", "VTSA", "None", "48570", "06.39N", "100.04E", "6", "TH"],
    ["SURAT THANI", "VTSB", "None", "48551", "09.07N", "099.08E", "11", "TH"],
    ["NARATHIWAT", "VTSC", "NAW", "None", "06.31N", "101.45E", "6", "TH"],
    ["CHUMPHON", "VTSD", "None", "48517", "10.28N", "099.10E", "5", "TH"],
    ["CHUMPHON", "VTSE", "None", "None", "10.43N", "099.22E", "5", "TH"],
    ["NAKHON SI THAMMA", "VTSF", "None", "None", "08.32N", "099.57E", "4", "TH"],
    ["KRABI", "VTSG", "KBV", "None", "08.06N", "098.59E", "25", "TH"],
    ["SONGKHLA(THAI-NA", "VTSH", "None", "48568", "07.12N", "100.35E", "5", "TH"],
    ["PATTANI", "VTSK", "None", "48580", "06.46N", "101.09E", "9", "TH"],
    ["SAMUI", "VTSM", "None", "None", "09.33N", "100.04E", "17", "TH"],
    ["NAKHON SI THAMMA", "VTSN", "None", "48552", "08.28N", "099.58E", "9", "TH"],
    ["PHUKET INTL AIRP", "VTSP", "None", "48565", "08.07N", "098.19E", "10", "TH"],
    ["RANONG", "VTSR", "None", "48532", "09.58N", "098.37E", "8", "TH"],
    ["HAT YAI", "VTSS", "None", "48569", "06.55N", "100.23E", "35", "TH"],
    ["TRANG", "VTST", "None", "48567", "07.31N", "099.37E", "16", "TH"],
    ["MUKDAHAN/BAKHON", "VTUB", "None", "48383", "16.31N", "104.43E", "139", "TH"],
    ["CHAIYAPHUM", "VTUC", "None", "48403", "15.48N", "102.01E", "183", "TH"],
    ["UDON THANI(CIV/A", "VTUD", "None", "48354", "17.22N", "102.47E", "182", "TH"],
    ["SAKON NAKHON", "VTUI", "None", "None", "17.12N", "104.07E", "172", "TH"],
    ["SURIN", "VTUJ", "None", "None", "14.52N", "103.30E", "146", "TH"],
    ["KHON KAEN", "VTUK", "None", "48381", "16.28N", "102.47E", "204", "TH"],
    ["LOEI", "VTUL", "None", "48353", "17.26N", "101.43E", "254", "TH"],
    ["NONG KHAI", "VTUM", "None", "48352", "17.52N", "102.43E", "175", "TH"],
    ["KORAT/NAKHON RAT", "VTUN", "None", "48431", "14.58N", "102.04E", "188", "TH"],
    ["BURIRUM", "VTUO", "None", "None", "15.14N", "103.15E", "183", "TH"],
    ["NAKHON PHANOM", "VTUP", "None", "48357", "17.25N", "104.46E", "148", "TH"],
    ["NAKHON RATCHASIM", "VTUQ", "NAK", "None", "14.57N", "102.19E", "234", "TH"],
    ["ROI ET", "VTUR", "None", "48405", "16.03N", "103.40E", "142", "TH"],
    ["SAKON NAKHON (AR", "VTUS", "None", "48356", "17.08N", "104.07E", "172", "TH"],
    ["UBON/RATCHATHANI", "VTUU", "None", "48407", "15.15N", "104.52E", "127", "TH"],
    ["ROIET", "VTUV", "None", "None", "16.07N", "103.47E", "138", "TH"],
    ["NAKHON PHANOM", "VTUW", "None", "None", "17.23N", "104.38E", "184", "TH"],
    ["CAM RANH BAY", "VVCR", "None", "None", "12.00N", "109.13E", "12", "VN"],
    ["CAN THO", "VVCT", "None", "None", "10.05N", "105.43E", "3", "VN"],
    ["DA NANG INTL ARP", "VVDN", "None", "48855", "16.01N", "108.12E", "7", "VN"],
    ["HANOI/GIALAM", "VVGL", "None", "None", "21.02N", "105.53E", "16", "VN"],
    ["HANOI WMO SITE", "None", "None", "48820", "21.01N", "105.48E", "6", "VN"],
    ["HANOI/NOIBAI INT", "VVNB", "None", "None", "21.13N", "105.48E", "12", "VN"],
    ["NHA TRANG", "VVNT", "None", "48877", "12.15N", "109.12E", "10", "VN"],
    ["HUE/PHUBAI", "VVPB", "None", "48852", "16.23N", "107.42E", "17", "VN"],
    ["PLEIKU CITY", "VVPK", "None", "48866", "13.58N", "108.00E", "801", "VN"],
    ["PHU QUOC", "VVPQ", "None", "None", "10.14N", "103.58E", "4", "VN"],
    ["QUI NHO'N", "VVQN", "None", "48870", "13.46N", "109.13E", "6", "VN"],
    ["HO CHI MINH/TANS", "VVTS", "None", "48900", "10.49N", "106.40E", "19", "VN"],
    ["VINH", "VVVH", "None", "48845", "18.41N", "105.40E", "6", "VN"],
    ["VUNG TAU", "VVVT", "None", "None", "10.22N", "107.04E", "4", "VN"],
    ["YANGON INTL MYAN", "VYYY", "None", "48097", "16.54N", "096.08E", "33", "VN"],
    ["HASANUDDIN/UJUNG", "WAAA", "None", "97180", "05.04S", "119.32E", "14", "ID"],
    ["BAU-BAU/BETO AMB", "WAAB", "None", "97192", "05.28S", "122.37E", "2", "ID"],
    ["KOLAKA/POMALAA", "WAAP", "None", "97142", "04.11S", "121.37E", "3", "ID"],
    ["SOROAKO/LUWU", "WAAS", "None", "97114", "02.31S", "121.20E", "10", "ID"],
    ["KENDARI/WOLTER(A", "WAAU", "None", "97146", "04.05S", "122.25E", "50", "ID"],
    ["BIAK/FRANS KAISI", "WABB", "None", "97560", "01.10S", "136.07E", "11", "ID"],
    ["NABIRE/IRIAN JAY", "WABI", "None", "97682", "03.19S", "135.30E", "3", "ID"],
    ["KOKONAO/TIMUKA", "WABN", "None", "97796", "04.43S", "136.25E", "3", "ID"],
    ["SERUI/YENDOSA", "WABO", "None", "97570", "01.52S", "136.13E", "3", "ID"],
    ["ENAROTALI", "WABT", "None", "97780", "03.55S", "136.22E", "1770", "ID"],
    ["SELAPARANG", "WADA", "None", "None", "08.32S", "116.04E", "3", "ID"],
    ["BALI INTL", "WADD", "DSP", "97230", "08.44S", "115.10E", "216", "ID"],
    ["BANDARA", "WADL", "None", "None", "08.45S", "116.17E", "97", "ID"],
    ["AHMAD YANI", "WAHS", "None", "None", "06.59S", "110.23E", "5", "ID"],
    ["SARMI/ORAI", "WAJI", "None", "97580", "01.49S", "138.43E", "3", "ID"],
    ["JAYAPURA/SENTANI", "WAJJ", "None", "97690", "02.35S", "140.31E", "88", "ID"],
    ["WAMENA/IRIAN JAY", "WAJW", "None", "97686", "04.04S", "138.56E", "1660", "ID"],
    ["MERAUKE/MOPAH", "WAKK", "None", "97980", "08.28S", "140.22E", "3", "ID"],
    ["TANAH MERAH", "WAKT", "None", "97876", "06.05S", "140.18E", "16", "ID"],
    ["GALELA/GAMARMALA", "WAMA", "None", "97406", "01.49N", "127.49E", "8", "ID"],
    ["GORONTALO/JALAL", "WAMG", "None", "97048", "00.31N", "123.04E", "2", "ID"],
    ["TAHUNA/NAHA", "WAMH", "None", "97008", "03.41N", "125.32E", "5", "ID"],
    ["TOLI-TOLI/LALOS", "WAMI", "None", "97028", "01.07N", "120.48E", "2", "ID"],
    ["PALU/MUTIARA", "WAML", "None", "97072", "00.40S", "119.43E", "6", "ID"],
    ["MENADO/SAM RATUL", "WAMM", "None", "97014", "01.33N", "124.55E", "80", "ID"],
    ["MALANGUANE/TALAU", "WAMN", "None", "97004", "04.13N", "126.42E", "9", "ID"],
    ["POSO/KASIGUNCU", "WAMP", "None", "97096", "01.22S", "120.43E", "2", "ID"],
    ["MOROTAI/PITU", "WAMR", "None", "97404", "02.02N", "129.19E", "15", "ID"],
    ["TERNATE/BABULLAH", "WAMT", "None", "97430", "00.50N", "127.23E", "15", "ID"],
    ["LUWUK/BUBUNG", "WAMW", "None", "97086", "00.54S", "122.46E", "2", "ID"],
    ["AMAHAI", "WAPA", "None", "97722", "03.21S", "128.52E", "10", "ID"],
    ["LABUHA/TALIABU", "WAPH", "None", "97460", "01.37S", "124.32E", "3", "ID"],
    ["SAUMLAKI", "WAPI", "None", "97900", "07.58S", "131.18E", "24", "ID"],
    ["SANANA", "WAPN", "None", "97600", "02.06S", "125.58E", "2", "ID"],
    ["AMBON/PATTIMURA", "WAPP", "None", "97724", "03.42S", "128.04E", "12", "ID"],
    ["NAMLEA/BURU ISLA", "WAPR", "None", "97700", "03.15S", "127.04E", "20", "ID"],
    ["JUWATA", "WAQQ", "None", "None", "03.20N", "117.34E", "0", "ID"],
    ["JUANDA", "WARR", "None", "None", "07.22S", "112.47E", "2", "ID"],
    ["ACHMAD YANI", "WARS", "None", "None", "06.58S", "110.23E", "3", "ID"],
    ["ADI SUMARMO WIRY", "WARQ", "None", "None", "07.31S", "110.45E", "128", "ID"],
    ["FAK-FAK/TOREA", "WASF", "None", "97630", "02.52S", "132.15E", "130", "ID"],
    ["KAIMANA/UTAROM", "WASK", "None", "97760", "03.40S", "133.45E", "3", "ID"],
    ["MANOKWARI/RENDAN", "WASR", "None", "97530", "00.52S", "134.03E", "3", "ID"],
    ["SORONG/JEFMAN", "WASS", "None", "97502", "00.55S", "131.07E", "3", "ID"],
    ["SABANG/CUT BAU", "WIAA", "None", "96001", "05.52N", "095.19E", "126", "ID"],
    ["MENGGALA/ASTRA K", "WIAG", "None", "96273", "04.27S", "105.10E", "19", "ID"],
    ["CIBEUREM/TASIK(A", "WIAM", "None", "96801", "07.19S", "108.15E", "335", "ID"],
    ["MADIUN/ISWAHYUD", "WIAR", "None", "96881", "07.37S", "111.31E", "110", "ID"],
    ["MALANG/ABDUL (AF", "WIAS", "None", "96947", "07.58S", "112.42E", "526", "ID"],
    ["PAKANBARU/SIMPAN", "WIBB", "None", "96109", "00.28N", "101.27E", "31", "ID"],
    ["HANG NADIM", "WIDD", "None", "None", "01.07N", "104.07E", "38", "ID"],
    ["MINANGKABAU", "WIEE", "None", "None", "00.47S", "100.17E", "5", "ID"],
    ["HALIM PERDANAKUS", "WIHH", "None", "None", "06.15S", "106.53E", "25", "ID"],
    ["CURUG/BUDIARTO", "WIIA", "None", "96739", "06.18S", "106.34E", "46", "ID"],
    ["BANDUNG/HUSEIN(A", "WIIB", "None", "96781", "06.54S", "107.34E", "740", "ID"],
    ["JAKARTA/KEMAYOR", "WIID", "None", "96743", "06.09S", "106.50E", "5", "ID"],
    ["HALIM INTL(CIV/M", "WIIH", "None", "96747", "06.15S", "106.54E", "30", "ID"],
    ["SOEKARNO-HATTA I", "WIII", "None", "96749", "06.08S", "106.40E", "8", "ID"],
    ["ADISUCIPTO/JOGYA", "WIIJ", "None", "None", "07.46S", "110.25E", "107", "ID"],
    ["ADI SUTJIPTO", "WARJ", "None", "96853", "07.47S", "110.26E", "107", "ID"],
    ["KALIJATI", "WIIK", "None", "96773", "06.32S", "107.40E", "110", "ID"],
    ["CILACAP/TUNGGUL", "WIIL", "None", "96805", "07.43S", "109.01E", "6", "ID"],
    ["ACHMAD YANI (ARM", "WIIS", "None", "96839", "06.58S", "110.22E", "3", "ID"],
    ["TELUKBETUNG/BRAN", "WIIT", "None", "96295", "05.16S", "105.10E", "96", "ID"],
    ["HANG NADIM", "WIKB", "None", "None", "01.07N", "104.07E", "40", "ID"],
    ["TANJUNG PANDAN/B", "WIKD", "None", "96249", "02.45S", "107.45E", "44", "ID"],
    ["PANGKALPINANG", "WIKK", "None", "96237", "02.10S", "106.08E", "33", "ID"],
    ["TANJUNGPINANG/KI", "WIDN", "None", "96091", "00.55N", "104.31E", "18", "ID"],
    ["TANJUNGPINANG/KI", "WIKN", "None", "None", "00.55N", "104.31E", "18", "ID"],
    ["SINGKEP/DABO", "WIKS", "None", "96179", "00.28S", "104.34E", "31", "ID"],
    ["GUNUNG SITOLI/BI", "WIMB", "None", "96075", "01.10N", "097.42E", "6", "ID"],
    ["PADANG/TABING", "WIMG", "None", "96163", "00.52S", "100.20E", "3", "ID"],
    ["MEDAN/POLONIA (M", "WIMM", "None", "96035", "03.34N", "098.40E", "25", "ID"],
    ["SIBOLGA/PINANGSO", "WIMS", "None", "96073", "01.33N", "098.52E", "3", "ID"],
    ["TEBINGTINGGI/PAB", "WIMT", "None", "96039", "03.22N", "099.07E", "23", "ID"],
    ["SINGKAWANG II", "WIOI", "None", "96533", "01.04N", "109.40E", "38", "ID"],
    ["KETAPANG/RAHADI", "WIOK", "None", "96615", "01.51S", "109.58E", "9", "ID"],
    ["RANAI (MIL/CIV)", "WION", "None", "96147", "03.57N", "108.22E", "2", "ID"],
    ["PONTIANAK/SUPADI", "WIOO", "None", "96581", "00.09S", "109.24E", "3", "ID"],
    ["SINTANG/SUSILO(A", "WIOS", "None", "96559", "00.07N", "111.31E", "30", "ID"],
    ["JAMBI/SULTAN TAH", "WIPA", "None", "96195", "01.37S", "103.39E", "25", "ID"],
    ["KERINCI/DEPATI P", "WIPH", "None", "96207", "02.46S", "101.22E", "782", "ID"],
    ["DEPATI AMIR", "WIPK", "None", "None", "02.10S", "106.08E", "33", "ID"],
    ["BENGKULA/PADANGK", "WIPL", "None", "96253", "03.52S", "102.19E", "16", "ID"],
    ["PALEMBANG/SULTAN", "WIPP", "None", "96221", "02.53S", "104.42E", "10", "ID"],
    ["RENGAT/JAPURA", "WIPR", "None", "96171", "00.21S", "102.20E", "19", "ID"],
    ["MINANGKABAU INTL", "WIPT", "PDG", "None", "00.47S", "100.17E", "5", "ID"],
    ["TAPAK TUAN/TEUKU", "WITA", "None", "96045", "03.28N", "097.17E", "75", "ID"],
    ["MEULABOH/CUT NYA", "WITC", "None", "96015", "04.15N", "096.07E", "90", "ID"],
    ["LHOKSEUMAWE/MALI", "WITM", "None", "96009", "05.14N", "096.57E", "28", "ID"],
    ["BANDA ACEH/BLANG", "WITT", "None", "96011", "05.31N", "095.25E", "21", "ID"],
    ["BANJARMASIN/SYAM", "WRBB", "None", "None", "03.25S", "114.45E", "20", "ID"],
    ["SYAMSUDIN NOOR", "WAOO", "None", "96685", "03.27S", "114.46E", "20", "ID"],
    ["PANGKALAN BUN/IS", "WRBI", "None", "96645", "02.42S", "111.42E", "25", "ID"],
    ["KOTABARU/SETAGEN", "WRBK", "None", "96695", "03.23S", "116.13E", "18", "ID"],
    ["MUARATEWE/BERING", "WRBM", "None", "96595", "00.57S", "114.54E", "60", "ID"],
    ["PANARUNG/PALANGK", "WRBP", "None", "96655", "01.00S", "114.00E", "27", "ID"],
    ["ATAMBUA/HALIWEN", "WRKA", "None", "97374", "09.19S", "124.54E", "125", "ID"],
    ["MAUMERE/WAI OTI", "WRKC", "None", "97300", "08.37S", "122.15E", "3", "ID"],
    ["ENDEH/IPI", "WRKE", "None", "97290", "08.48S", "121.35E", "3", "ID"],
    ["KUPANG/EL TARI", "WRKK", "None", "97372", "10.10S", "123.40E", "108", "ID"],
    ["EL TARI", "WATT", "None", "None", "10.10S", "123.40E", "102", "ID"],
    ["LARANTUKA/GEWAYE", "WRKL", "None", "97310", "08.16S", "122.58E", "9", "ID"],
    ["ALOR/MALI/KALABA", "WRKM", "None", "97320", "08.13S", "124.34E", "12", "ID"],
    ["ROTE/BAA/LEKUNIK", "WRKR", "None", "97378", "10.43S", "123.04E", "1", "ID"],
    ["SABU/TARDAMU", "WRKS", "None", "97380", "10.30S", "121.49E", "26", "ID"],
    ["LONGBAWAN/JUVAI", "WRLB", "None", "96505", "03.43N", "115.40E", "550", "ID"],
    ["TANJUNG SELOR", "WRLG", "None", "96525", "02.51N", "117.19E", "50", "ID"],
    ["TANAHGROGOT", "WRLH", "None", "96639", "02.12S", "116.19E", "10", "ID"],
    ["TANJUNG REDEP/BE", "WRLK", "None", "96529", "02.07N", "117.27E", "26", "ID"],
    ["BALIKPAPAN/SEPIN", "WRLL", "None", "None", "01.16S", "116.54E", "3", "ID"],
    ["SEPINGGAN", "WALL", "None", "96633", "01.16S", "116.54E", "3", "ID"],
    ["TARAKAN/JUWATA", "WALR", "None", "96509", "03.19N", "117.34E", "6", "ID"],
    ["TARAKAN/JUWATA", "WRLR", "None", "None", "03.19N", "117.34E", "6", "ID"],
    ["SAMARINDA/TEMIND", "WRLS", "None", "96607", "00.37S", "117.09E", "230", "ID"],
    ["SANGKULIRANG", "WRLU", "None", "96577", "01.00N", "118.00E", "210", "ID"],
    ["AMPENAN/SELAPARA", "WRRA", "None", "97240", "08.31S", "116.04E", "3", "ID"],
    ["BIMA/MOHAMMAD SA", "WRRB", "None", "97270", "08.33S", "118.42E", "2", "ID"],
    ["BALI INTL/NGURAH", "WRRR", "None", "None", "08.45S", "115.10E", "1", "ID"],
    ["SUMBAWA BESAR", "WRRS", "None", "97260", "08.25S", "117.25E", "3", "ID"],
    ["WAINGAPU/MAU HAU", "WRRW", "None", "97340", "09.40S", "120.19E", "12", "ID"],
    ["SURABAYA/JUANDA", "WRSJ", "None", "96935", "07.22S", "112.46E", "3", "ID"],
    ["SURABAYA/PERAK", "WRSP", "None", "96933", "07.13S", "112.43E", "3", "ID"],
    ["SURAKARTA/ADISUM", "WRSQ", "None", "96845", "07.52S", "110.55E", "104", "ID"],
    ["SURABAYA/GEDANGA", "WRSS", "None", "96937", "07.13S", "112.43E", "3", "ID"],
    ["BINTULU/KALIMANT", "WBGB", "None", "96441", "03.07N", "113.01E", "5", "MY"],
    ["KUCHING (CIV/MIL", "WBGG", "None", "96413", "01.28N", "110.21E", "27", "MY"],
    ["MIRI/KALIMANTAN", "WBGR", "None", "96449", "04.19N", "113.58E", "18", "MY"],
    ["SIBU", "WBGS", "None", "96421", "02.16N", "111.59E", "8", "MY"],
    ["SIMANGGANG", "WBGY", "None", "None", "01.13N", "111.26E", "34", "MY"],
    ["KOTA KINABALU IN", "WBKK", "BKI", "96471", "05.55N", "116.02E", "3", "MY"],
    ["LABUAN (AFB)", "WBKL", "None", "96465", "05.17N", "115.15E", "30", "MY"],
    ["SANDAKAN/KALIMAN", "WBKS", "None", "96491", "05.54N", "118.04E", "13", "MY"],
    ["KUDAT", "WBKT", "None", "96477", "06.55N", "116.49E", "5", "MY"],
    ["TAWAU/KALIMANTAN", "WBKW", "None", "96481", "04.19N", "118.07E", "20", "MY"],
    ["BRUNEI INTL AIRP", "WBSB", "None", "96315", "04.55N", "114.55E", "15", "MY"],
    ["KLUANG", "WMAP", "None", "48672", "02.01N", "103.19E", "88", "MY"],
    ["MERSING", "WMAU", "None", "48674", "02.23N", "103.53E", "45", "MY"],
    ["SITIAWAN", "WMBA", "None", "48620", "04.13N", "100.42E", "8", "MY"],
    ["TIOMAN ISLAND", "WMBT", "None", "None", "02.49N", "104.10E", "5", "MY"],
    ["S ABDUL HALIM", "WMKA", "None", "48603", "06.12N", "100.24E", "5", "MY"],
    ["BUTTERWORTH(AUS-", "WMKB", "None", "48602", "05.28N", "100.22E", "4", "MY"],
    ["KOTA BHARU/SULTA", "WMKC", "None", "48615", "06.10N", "102.16E", "5", "MY"],
    ["KUANTAN (AFB)", "WMKD", "None", "48657", "03.46N", "103.13E", "16", "MY"],
    ["KERTEH", "WMKE", "None", "None", "04.32N", "103.26E", "5", "MY"],
    ["SIMPANG (AFB)", "WMKF", "None", "None", "03.07N", "101.42E", "34", "MY"],
    ["IPOH", "WMKI", "None", "48625", "04.34N", "101.05E", "39", "MY"],
    ["JOHORE BHARU/SEN", "WMKJ", "None", "48679", "01.37N", "103.40E", "40", "MY"],
    ["KUALA LUMPUR/SUB", "WMKK", "KUL", "48647", "02.45N", "101.43E", "22", "MY"],
    ["LANGKAWI INTL AR", "WMKL", "None", "48600", "06.19N", "099.43E", "7", "MY"],
    ["MALACCA", "WMKM", "None", "48665", "02.16N", "102.15E", "9", "MY"],
    ["KUALA TRENGGANU", "WMKN", "None", "48618", "05.22N", "103.05E", "6", "MY"],
    ["PENANG/BAYAN LEP", "WMKP", "None", "48601", "05.17N", "100.16E", "4", "MY"],
    ["PANGKOR ISLAND", "WMPA", "None", "None", "04.15N", "100.33E", "1", "MY"],
    ["KUALA LUMPUR SA", "WMSA", "None", "None", "03.08N", "101.33E", "27", "MY"],
    ["DILLI ARPT/TIMOR", "WPDL", "None", "97390", "08.34S", "125.34E", "6", "TP"],
    ["BAUCAU/TIMOR ISL", "WPEC", "None", "97395", "08.30S", "126.24E", "522", "TP"],
    ["OE-CUSSE/TIMOR I", "WPOC", "None", "97385", "09.11S", "124.22E", "5", "TP"],
    ["VIQUEQUE/TIMOR I", "WPVQ", "None", "97394", "08.52S", "126.22E", "47", "TP"],
    ["PAYA LEBAR", "WSAP", "None", "48694", "01.22N", "103.55E", "32", "SG"],
    ["SINGAPORE/TENGAH", "WSAT", "None", "48687", "01.22N", "103.43E", "12", "SG"],
    ["SINGAPORE/SELETA", "WSSL", "None", "48692", "01.25N", "103.52E", "14", "SG"],
    ["SINGAPORE/CHANGI", "WSSS", "SIN", "48698", "01.22N", "103.58E", "16", "SG"],
    ["HONIARA/HENDERSO", "AGGH", "None", "91520", "09.25S", "160.03E", "9", "SB"],
    ["SANTA CRUZ ISLAN", "AGGL", "None", "91541", "10.41S", "165.48E", "24", "SB"],
    ["MUNDA/NEW GEORGI", "AGGM", "None", "91503", "08.19S", "157.16E", "6", "SB"],
    ["MADANG AIRPORT", "AYMD", "None", "94014", "05.13S", "145.48E", "12", "PG"],
    ["PORT MORESBY INT", "AYPY", "None", "94035", "09.25S", "147.13E", "47", "PG"],
    ["RABAUL/NEW BRITA", "AYRB", "None", "94085", "04.13S", "152.10E", "9", "PG"],
    ["WEWAK INTL AIRPO", "AYWK", "None", "94004", "03.35S", "143.40E", "6", "PG"],
    ["GOROKA", "AYGA", "GKA", "None", "06.05S", "145.24E", "1587", "PG"],
    ["ALOTAU", "AYGN", "None", "None", "10.19S", "150.20E", "27", "PG"],
    ["MOUNT HAGEN", "AYMH", "HGU", "None", "05.50S", "144.18E", "1642", "PG"],
    ["MOMOTE MANUS IS", "AYMO", "None", "None", "02.04S", "147.25E", "4", "PG"],
    ["NADZAB", "AYNZ", "LAE", "None", "06.34S", "146.43E", "70", "PG"],
    ["VANIMO AIRPORT", "AYVN", "None", "None", "02.42S", "141.18E", "4", "PG"],
    ["ALBANY AIRPORT", "YABA", "None", "94802", "34.56S", "117.48E", "69", "AU"],
    ["AMBERLEY", "YAMB", "None", "None", "27.38S", "152.43E", "28", "AU"],
    ["ARGYLE AERO", "YARG", "None", "94217", "16.38S", "128.27E", "165", "AU"],
    ["AYERS ROCK", "YAYE", "None", "None", "25.11S", "130.59E", "496", "AU"],
    ["ARCHEFIELD/BRISB", "YBAF", "None", "94575", "27.34S", "153.00E", "18", "AU"],
    ["AMBERLEY (AUS-AF", "YBAM", "None", "94568", "27.37S", "152.43E", "31", "AU"],
    ["ALICE SPRINGS AR", "YBAS", "None", "94326", "23.48S", "133.54E", "541", "AU"],
    ["BRISBANE INTL AR", "YBBN", "None", "94578", "27.23S", "153.08E", "5", "AU"],
    ["COOLANGATTA AWS", "YBCG", "None", "94592", "28.10S", "153.30E", "6", "AU"],
    ["CAIRNS AIRPORT", "YBCS", "None", "94287", "16.52S", "145.45E", "7", "AU"],
    ["CHARLEVILLE ARPT", "YBCV", "None", "94510", "26.23S", "146.16E", "304", "AU"],
    ["BIRDSVILLE", "YBDV", "None", "95482", "25.54S", "139.21E", "47", "AU"],
    ["GLADSTONE", "YBGL", "None", "94380", "23.51S", "151.15E", "76", "AU"],
    ["BROKEN HILL", "YBHI", "None", "94691", "32.00S", "141.28E", "292", "AU"],
    ["HAMILTON ISLAND", "YBHM", "None", "None", "20.21S", "148.57E", "5", "AU"],
    ["LONGREACH AIRPOR", "YBLR", "None", "94346", "23.25S", "144.16E", "193", "AU"],
    ["MOUNT ISA AIRPOR", "YBMA", "None", "94332", "20.40S", "139.28E", "344", "AU"],
    ["MACKAY", "YBMK", "None", "94367", "21.07S", "149.13E", "31", "AU"],
    ["BALLINA BYRON G.", "YBNA", "None", "94596", "28.50S", "153.34E", "2", "AU"],
    ["OAKEY (ARMY/CIV)", "YBOK", "None", "94552", "27.25S", "151.43E", "407", "AU"],
    ["PROSPERINE AIRPO", "YBPN", "None", "94365", "20.30S", "148.33E", "25", "AU"],
    ["ROCKHAMPTON AIRP", "YBRK", "None", "94374", "23.22S", "150.28E", "14", "AU"],
    ["BROOME AIRPORT", "YBRM", "None", "94203", "17.56S", "122.13E", "9", "AU"],
    ["TOWNSVILLE(CIV/M", "YBTL", "None", "94294", "19.15S", "146.45E", "6", "AU"],
    ["BUNDABERG", "YBUD", "None", "94387", "24.54S", "152.19E", "82", "AU"],
    ["WEIPA", "None", "None", "94170", "12.41S", "141.55E", "58", "AU"],
    ["WEIPA CITY", "YBWP", "None", "94171", "12.37S", "141.52E", "12", "AU"],
    ["BARROW ISLAND", "YBWX", "None", "94304", "20.53S", "115.24E", "6", "AU"],
    ["CARNARVON", "YCAR", "None", "94300", "24.53S", "113.40E", "8", "AU"],
    ["CASINO AIRPORT", "YCAS", "None", "94573", "28.53S", "153.04E", "26", "AU"],
    ["COBAR AIRPORT", "YCBA", "None", "94710", "31.32S", "145.48E", "221", "AU"],
    ["COONABARABRAN", "YCBB", "None", "95728", "31.20S", "149.16E", "645", "AU"],
    ["COOBER PEDY", "YCBP", "None", "95458", "29.02S", "134.43E", "226", "AU"],
    ["CLONCURRY", "YCCY", "None", "94335", "20.40S", "140.30E", "570", "AU"],
    ["CEDUNA AIRPORT", "YCDU", "None", "94653", "32.07S", "133.42E", "15", "AU"],
    ["COONAMBLE", "YCNM", "None", "95718", "30.59S", "148.23E", "184", "AU"],
    ["COFFS HARBOUR", "YCFS", "None", "94791", "30.19S", "153.07E", "5", "AU"],
    ["CURTIN/DERBY", "YCIN", "None", "94204", "17.34S", "123.50E", "91", "AU"],
    ["COOMA SNOWY MTNS", "YCOM", "None", "94921", "36.18S", "148.58E", "941", "AU"],
    ["DERBY", "YDBY", "None", "94205", "17.22S", "123.40E", "7", "AU"],
    ["GOVE AIRPORT", "YDGV", "None", "94150", "12.16S", "136.49E", "54", "AU"],
    ["TENNANT CREEK AR", "YDTC", "None", "94238", "19.37S", "134.10E", "376", "AU"],
    ["YULARA AWS", "YDYL", "None", "94462", "25.10S", "130.58E", "493", "AU"],
    ["EMERALD ARPT", "YEML", "None", "94363", "24.34S", "148.11E", "190", "AU"],
    ["ESPERANCE ARPT", "YESP", "None", "95638", "33.41S", "121.49E", "143", "AU"],
    ["FORREST", "YFRT", "None", "None", "30.50S", "128.07E", "156", "AU"],
    ["GERALDTON", "YGEL", "None", "None", "28.48S", "114.42E", "37", "AU"],
    ["GRAFTON ARPT", "YGFN", "None", "95570", "29.46S", "153.02E", "34", "AU"],
    ["GLADSTONE", "YGLA", "None", "94381", "23.52S", "151.13E", "52", "AU"],
    ["GROOTE EYLANDT", "YGTE", "None", "94153", "13.58S", "136.27E", "14", "AU"],
    ["GRIFFITH ARPT", "YGTH", "None", "95704", "34.15S", "146.04E", "134", "AU"],
    ["HORN ISLAND", "YHID", "None", "None", "10.35S", "142.18E", "13", "AU"],
    ["HUGHENDEN ARPT", "YHUG", "None", "94343", "20.49S", "144.14E", "318", "AU"],
    ["KINGAROY ARPT", "YKRY", "None", "94549", "26.34S", "151.50E", "434", "AU"],
    ["LEIGH CREEK", "YLEC", "None", "None", "30.36S", "138.26E", "262", "AU"],
    ["LORD HOME ISLAND", "YLHI", "None", "None", "31.32S", "159.05E", "12", "AU"],
    ["LISMORE ARPT", "YLIS", "None", "94572", "28.50S", "153.16E", "11", "AU"],
    ["LONGREACH ARPT", "YLRE", "None", "None", "23.26S", "144.17E", "193", "AU"],
    ["MUDGEE ARPT", "YMDG", "None", "94727", "32.34S", "149.37E", "471", "AU"],
    ["MEEKATHARRA ARPT", "YMEK", "None", "None", "26.37S", "118.33E", "522", "AU"],
    ["MERIMBULA ARPT", "YMER", "None", "95929", "36.55S", "149.54E", "2", "AU"],
    ["MILDURA ARPT", "YMIA", "None", "None", "34.14S", "142.05E", "51", "AU"],
    ["MOREE ARPT", "YMOR", "None", "95527", "29.30S", "149.51E", "214", "AU"],
    ["MOUNT GAMBIER", "YMTG", "None", "None", "37.45S", "140.47E", "65", "AU"],
    ["NARRANDERA", "YNAR", "None", "95706", "34.42S", "146.31E", "145", "AU"],
    ["NARRABRI", "YNBR", "None", "95734", "30.19S", "149.50E", "240", "AU"],
    ["NORMANTON", "YNTN", "None", "94266", "17.41S", "141.04E", "22", "AU"],
    ["NEWMAN ARPT", "YNWN", "None", "94317", "23.25S", "119.48E", "525", "AU"],
    ["OLYMPIC DAM ARPT", "YOLD", "None", "95658", "30.29S", "136.53E", "105", "AU"],
    ["GOVE AIRPORT", "YPGV", "None", "None", "12.16S", "136.49E", "55", "AU"],
    ["JANDAKOT", "YPJT", "None", "None", "32.06S", "115.53E", "30", "AU"],
    ["PORT MACQUARIE", "YPMQ", "None", "94786", "31.26S", "152.52E", "4", "AU"],
    ["AVALON AIRPORT", "YMAV", "None", "None", "38.02S", "144.29E", "8", "AU"],
    ["ALBURY AIRPORT", "YMAY", "None", "94896", "36.04S", "146.56E", "171", "AU"],
    ["DEVONPORT EAST", "YMDV", "None", "94960", "41.10S", "146.22E", "47", "AU"],
    ["MELBOURNE/ESSEND", "YMEN", "None", "94864", "37.43S", "144.54E", "86", "AU"],
    ["EAST SALE (AUS-A", "YMES", "None", "94907", "38.06S", "147.07E", "8", "AU"],
    ["HOBART/TASMANIA", "YMHB", "None", "94975", "42.49S", "147.31E", "27", "AU"],
    ["LAUNCESTON AIRPO", "YMLT", "None", "94968", "41.31S", "147.11E", "178", "AU"],
    ["LAVERTON AERO", "YMLV", "None", "94865", "37.51S", "144.43E", "21", "AU"],
    ["MELBOURNE/MOORAB", "YMMB", "None", "94870", "37.58S", "145.05E", "16", "AU"],
    ["MOUNT GAMBIER AR", "YMMG", "None", "94821", "37.43S", "140.46E", "69", "AU"],
    ["MILDURA AIRPORT", "YMMI", "None", "94693", "34.13S", "142.04E", "52", "AU"],
    ["MELBOURNE INTL A", "YMML", "None", "94866", "37.40S", "144.49E", "141", "AU"],
    ["MACQUARIE ISLAND", "YMMQ", "None", "94998", "54.28S", "158.55E", "6", "AU"],
    ["WYNYARD WEST", "YMWY", "None", "94957", "40.58S", "145.43E", "11", "AU"],
    ["ADELAIDE INTL AR", "YPAD", "None", "94672", "34.57S", "138.31E", "4", "AU"],
    ["ALBANY AIRPORT", "YPAL", "None", "None", "34.56S", "117.48E", "69", "AU"],
    ["BROKEN HILL", "YPBH", "None", "94689", "31.58S", "141.28E", "315", "AU"],
    ["PARABURDOO", "YPBO", "None", "94316", "23.12S", "117.45E", "1292", "AU"],
    ["COCOS ISL INTL A", "YPCC", "None", "96996", "12.10S", "096.49E", "3", "AU"],
    ["CEDUNA AIRPORT", "YPCD", "None", "None", "32.07S", "133.41E", "17", "AU"],
    ["DARWIN (CIV/MIL)", "YPDN", "None", "94120", "12.25S", "130.54E", "30", "AU"],
    ["PEARCE (AUS-AFB)", "YPEA", "None", "94612", "31.40S", "116.01E", "49", "AU"],
    ["EDINBURGH (AUS-A", "YPED", "None", "95676", "34.42S", "138.37E", "20", "AU"],
    ["FORREST AIRPORT", "YPFT", "None", "94646", "30.49S", "128.05E", "160", "AU"],
    ["GERALDTON AIRPOR", "YPGN", "None", "94403", "28.46S", "114.42E", "34", "AU"],
    ["KALGOORLIE/BOULD", "YPKG", "None", "94637", "30.46S", "121.27E", "360", "AU"],
    ["KUNUNURRA AIRPOR", "YPKU", "None", "94216", "15.46S", "128.41E", "45", "AU"],
    ["LEIGH CREEK S. A", "YPLC", "None", "94674", "30.36S", "138.25E", "262", "AU"],
    ["LEARMOUTH", "YPLM", "None", "94302", "22.13S", "114.04E", "6", "AU"],
    ["MEEKATHARRA AIRP", "YPMR", "None", "94430", "26.36S", "118.31E", "518", "AU"],
    ["PORT HEDLAND ARR", "YPPD", "None", "94312", "20.22S", "118.37E", "6", "AU"],
    ["ADELAIDE/PARAFIE", "YPPF", "None", "95677", "34.46S", "138.37E", "16", "AU"],
    ["PERTH INTL/BELMO", "YPPH", "None", "94610", "31.56S", "115.59E", "13", "AU"],
    ["KATHERINE/TINDAL", "YPTN", "None", "94132", "14.31S", "132.23E", "109", "AU"],
    ["WOOMERA (AUS-AFB", "YPWR", "None", "94659", "31.07S", "136.49E", "167", "AU"],
    ["CHRISTMAS ISL (P", "YPXM", "None", "96995", "10.27S", "105.40E", "259", "AU"],
    ["RICHMOND", "YRMD", "None", "None", "20.42S", "143.07E", "207", "AU"],
    ["BANKSTOWN AIRPOR", "YSBK", "None", "94765", "33.56S", "150.59E", "14", "AU"],
    ["CANBERRA (CIV/MI", "YSCB", "None", "94926", "35.17S", "149.10E", "577", "AU"],
    ["COOMA", "YSCM", "None", "94923", "36.13S", "149.04E", "778", "AU"],
    ["CAMDEN AIRPORT", "YSCN", "None", "94755", "34.01S", "150.40E", "70", "AU"],
    ["DUBBO", "YSDU", "None", "94719", "32.13S", "148.34E", "275", "AU"],
    ["NORFOLK ISLAND A", "YSNF", "None", "94996", "29.01S", "167.55E", "109", "AU"],
    ["NOWRA (AUS-NAVY)", "YSNW", "None", "94750", "34.57S", "150.31E", "110", "AU"],
    ["RICHMOND (AUS-AF", "YSRI", "None", "94753", "33.36S", "150.46E", "21", "AU"],
    ["SYDNEY INTL AIRP", "YSSY", "SYD", "94767", "33.57S", "151.10E", "3", "AU"],
    ["TAMWORTH AIRPORT", "YSTW", "None", "94762", "31.04S", "150.51E", "410", "AU"],
    ["WAGGA WAGGA(CV/M", "YSWG", "None", "94910", "35.08S", "147.28E", "213", "AU"],
    ["WILLIAMTOWN(AUS-", "YSWM", "None", "94776", "32.46S", "151.49E", "8", "AU"],
    ["TELFER AIRPORT", "YTEF", "None", "None", "21.43S", "122.14E", "296", "AU"],
    ["TENNANT CREEK", "YTNK", "TCA", "None", "19.38S", "134.11E", "377", "AU"],
    ["TAREE AIRPORT", "YTRE", "TRO", "None", "31.53S", "152.31E", "12", "AU"],
    ["WANGARATTA ARP", "YWGT", "None", "None", "36.25S", "146.18E", "153", "AU"],
    ["WHYALLA AIRPORT", "YWHA", "WYA", "None", "33.04S", "137.31E", "13", "AU"],
    ["WILLIAMTOWN ARP", "YWLM", "None", "None", "32.48S", "151.50E", "9", "AU"],
    ["ADELAIDE AIRPOR", "AAAD", "None", "None", "34.55S", "138.31E", "4", "AU"],
    ["WOOMERA AERODRO", "AAWR", "None", "None", "31.08S", "136.48E", "167", "AU"],
    ["BRISBANE AIRPOR", "ABBN", "None", "None", "27.25S", "153.04E", "6", "AU"],
    ["CHARLEVILLE ARP", "ABCV", "None", "None", "26.25S", "146.16E", "304", "AU"],
    ["GLADSTONE", "ABGL", "None", "None", "23.51S", "151.16E", "76", "AU"],
    ["MOUNT ISA AIRPO", "ABMA", "None", "None", "20.38S", "139.28E", "342", "AU"],
    ["TOWNSVILLE(AUS-", "ABTL", "None", "None", "19.15S", "146.45E", "6", "AU"],
    ["DARWIN (AUS-AFB", "ADDN", "None", "None", "12.24S", "130.52E", "30", "AU"],
    ["GOVE AIRPORT", "ADGV", "None", "None", "12.16S", "136.49E", "54", "AU"],
    ["BROOME AIRPORT", "AHBR", "None", "None", "17.56S", "122.13E", "9", "AU"],
    ["PORT HEDLAND AR", "AHPD", "None", "None", "20.22S", "118.37E", "11", "AU"],
    ["LAVERTON (AUS-A", "AMLV", "None", "None", "37.51S", "144.43E", "14", "AU"],
    ["MOUNT GAMBIER A", "AMMG", "None", "None", "37.43S", "140.46E", "69", "AU"],
    ["NAURU ISLAND", "ANAU", "INU", "91530", "00.33S", "166.55E", "7", "AU"],
    ["NAURU ISLAND", "ANYN", "None", "None", "00.33S", "166.55E", "7", "AU"],
    ["ALBANY AIRPORT", "APAL", "None", "None", "34.57S", "117.47E", "69", "AU"],
    ["CARNARVON AIRPOR", "APCR", "None", "None", "24.53S", "113.40E", "7", "AU"],
    ["COFFS HARBOUR AR", "YSCH", "None", "None", "30.19S", "153.07E", "5", "AU"],
    ["DARWIN (CIV/MIL", "APDN", "None", "None", "12.24S", "130.52E", "30", "AU"],
    ["FORREST AIRPORT", "APFT", "None", "None", "30.49S", "128.05E", "160", "AU"],
    ["KALGOORLIE ARPT", "APKG", "None", "None", "30.46S", "121.27E", "360", "AU"],
    ["PERTH INTL ARPT", "APPH", "None", "None", "31.55S", "115.57E", "12", "AU"],
    ["ALICE SPRINGS A", "ASAS", "None", "None", "23.48S", "133.54E", "544", "AU"],
    ["LORD HOWE ISLAND", "ASLH", "None", "None", "31.31S", "159.04E", "6", "AU"],
    ["NORFOLK ISLAND", "ASNF", "None", "None", "29.01S", "167.55E", "109", "AU"],
    ["NOWRA (AUS-NAVY", "ASNW", "None", "None", "34.57S", "150.31E", "110", "AU"],
    ["SYDNEY INTL AIR", "ASSY", "None", "None", "33.57S", "151.10E", "3", "AU"],
    ["WAGGA ARPT", "ASWG", "None", "None", "35.08S", "147.26E", "213", "AU"],
    ["WILLIAMTOWN AER", "ASWM", "None", "None", "32.46S", "151.49E", "11", "AU"],
    ["HOBART/TASMANIA", "AMHB", "None", "None", "42.49S", "147.30E", "3", "AU"],
    ["MACQUARIE ISLAND", "AMMQ", "None", "None", "54.28S", "158.55E", "6", "AU"],
    ["COCOS ISLAND AR", "ACCC", "None", "None", "12.10S", "096.49E", "3", "CC"],
    ["DERBY", "YPDB", "None", "None", "17.22S", "123.40E", "7", "AU"],
    ["AUCKLAND INTL AR", "NZAA", "AKL", "93119", "37.01S", "174.48E", "6", "NZ"],
    ["CAMPBELL ISLAND", "NZCA", "None", "93944", "52.32S", "169.09E", "19", "NZ"],
    ["CHRISTCHURCH INT", "NZCH", "CHC", "93780", "43.28S", "172.33E", "34", "NZ"],
    ["CHATHAM ISL/TUUT", "NZCI", "None", "93986", "43.57S", "176.34E", "48", "NZ"],
    ["DUNEDIN AIRPORT", "NZDN", "None", "93890", "45.55S", "170.11E", "2", "NZ"],
    ["GISBORNE AERODRO", "NZGS", "None", "93291", "38.40S", "177.58E", "8", "NZ"],
    ["HOKITIKA AERODRO", "NZHK", "None", "93614", "42.43S", "170.58E", "40", "NZ"],
    ["KAIKOURA", "NZKI", "None", "93677", "42.25S", "173.41E", "101", "NZ"],
    ["KAITAIA", "NZKT", "None", "93012", "35.07S", "173.16E", "87", "NZ"],
    ["MILFORD SOUND", "NZMF", "None", "93720", "44.40S", "167.55E", "6", "NZ"],
    ["NEW PLYMOUTH AER", "NZNP", "None", "93308", "39.01S", "174.10E", "36", "NZ"],
    ["INVERCARGILL AER", "NZNV", "None", "93844", "46.25S", "168.19E", "1", "NZ"],
    ["OHAKEA (NZ-AFB)", "NZOH", "None", "93401", "40.12S", "175.23E", "52", "NZ"],
    ["OAMARU ARPT (AUT", "NZOU", "None", "93796", "44.58S", "171.04E", "30", "NZ"],
    ["PARAPARAUMU AERO", "NZPP", "None", "93417", "40.53S", "174.58E", "12", "NZ"],
    ["RAOUL ISL/KERMAD", "NZRN", "None", "93997", "29.15S", "177.55E", "49", "NZ"],
    ["ROTORUA AERODROM", "NZRO", "None", "93246", "38.07S", "176.19E", "294", "NZ"],
    ["TAURANGA AERO AW", "NZTG", "None", "93186", "37.40S", "176.11E", "5", "NZ"],
    ["BLEHEIM/WOODBOUR", "NZWB", "None", "93577", "41.31S", "173.52E", "32", "NZ"],
    ["WELLINGTON INTL", "NZWN", "None", "93436", "41.19S", "174.48E", "7", "NZ"],
    ["WHENUAPAI (NZ-AF", "NZWP", "None", "93112", "36.46S", "174.37E", "27", "NZ"],
    ["WESTPORT HARBOUR", "NZWS", "None", "93516", "41.45S", "171.35E", "4", "NZ"],
    ["WILLIAMS FIELD", "NZCM", "None", "89674", "77.52S", "166.58E", "8", "AQ"],
    ["AMUNDSEN-SCOTT", "NZSP", "None", "89009", "89.59S", "179.59E", "2830", "AQ"],
    ["PEGASUS FIELD", "NZPG", "None", "None", "77.57S", "166.31E", "5", "AQ"],
    ["MCMURDO WILLIAMS", "NZWD", "None", "None", "77.52S", "167.04E", "22", "AQ"],
    ["MCMURDO ICE RNWY", "NZIR", "None", "None", "77.51S", "166.35E", "2", "AQ"],
    ["SOLA/VANUA LAVA", "NVSC", "None", "91551", "13.50S", "167.33E", "18", "VU"],
    ["LONGANA AIRPORT", "NVSG", "None", "None", "15.18S", "167.58E", "51", "VU"],
    ["LAMAP/MALEKOULA", "NVSL", "None", "91555", "16.25S", "167.48E", "26", "VU"],
    ["PEKOA ARPT/SANTO", "NVSS", "None", "91554", "15.31S", "167.13E", "44", "VU"],
    ["ANELGHOWHAT ARPT", "NVVA", "None", "None", "20.15S", "169.46E", "3", "VU"],
    ["BAUERFIELD/EFATE", "NVVV", "None", "91557", "17.41S", "168.18E", "21", "VU"],
    ["TANNA", "NVVW", "None", "None", "19.27S", "169.13E", "6", "VU"],
    ["KONE AIRPORT", "NWWD", "None", "None", "21.03S", "164.50E", "7", "NC"],
    ["ILS DES PINS/MOU", "NWWE", "None", "91596", "22.36S", "167.26E", "97", "NC"],
    ["KOUMAC", "NWWK", "None", "91577", "20.34S", "164.16E", "18", "NC"],
    ["OUANAHAM/WANAHAM", "NWWL", "None", "91582", "20.46S", "167.13E", "29", "NC"],
    ["MAGENTA", "NWWM", "None", "None", "22.16S", "166.28E", "3", "NC"],
    ["NOUMEA/CALEDONI", "NWWN", "None", "91592", "22.16S", "166.26E", "72", "NC"],
    ["LA ROCHE/MARE IS", "NWWR", "None", "91587", "21.28S", "168.01E", "42", "NC"],
    ["TOUHO", "NWWU", "None", "None", "20.47S", "165.16E", "3", "NC"],
    ["OUVEA OULOUP/FAY", "NWWV", "None", "91579", "20.38S", "166.34E", "7", "NC"],
    ["NANDI FIJI", "NFFN", "None", "91680", "17.45S", "177.27E", "18", "FJ"],
    ["LAUTHALA BAY", "NFLB", "None", "91690", "18.09S", "178.27E", "6", "FJ"],
    ["NAUSORI FIJI", "NFNA", "None", "91683", "18.03S", "178.34E", "5", "FJ"],
    ["LAMBASA AIRPORT", "NFNL", "None", "91657", "16.28S", "179.20E", "17", "FJ"],
    ["FUA AMOTU TONGA", "NFTF", "None", "91792", "21.14S", "175.09W", "38", "FJ"],
    ["FUNAFUTI TUVALU", "NGFU", "None", "91643", "08.31S", "179.13E", "1", "FJ"],
    ["TARAWA KIRIBATI", "NGTA", "None", "91610", "01.21N", "172.55E", "2", "FJ"],
    ["TARAWA KIRIBATI", "NGTT", "None", "None", "01.21N", "172.55E", "2", "FJ"],
    ["LAKEMBA ISLAND", "NFNK", "None", "91691", "18.14S", "178.48W", "3", "FJ"],
    ["MATEI/TAVEUNI IS", "NFNM", "None", "91665", "16.40S", "179.52E", "21", "FJ"],
    ["ROTUMA ISLAND", "NFNR", "None", "91650", "12.30S", "177.03E", "26", "FJ"],
    ["SAVUSAVU AIRPORT", "NFNS", "None", "91663", "16.49S", "179.20E", "13", "FJ"],
    ["HA'APAI/LIFUKA I", "NFTL", "None", "91784", "19.47S", "174.20W", "3", "FJ"],
    ["VAVA'U ISLAND", "NFTV", "None", "91780", "18.35S", "173.58W", "71", "FJ"],
    ["BERU ISLAND", "NGBR", "None", "91623", "01.21S", "176.00E", "3", "FJ"],
    ["NANUMEA ISLAND", "NGFO", "None", "91631", "05.40S", "176.07E", "3", "FJ"],
    ["ARORAE ISLAND", "NGTR", "None", "91629", "02.40S", "176.49E", "7", "FJ"],
    ["BUTARITARI ATOLL", "NGTU", "None", "91601", "03.01N", "172.46E", "1", "FJ"],
    ["FUTUNA ISL/MAOPO", "NLWF", "None", "91754", "14.19S", "178.07W", "36", "FJ"],
    ["PAGO PAGO", "NSTU", "None", "91765", "14.20S", "170.43W", "3", "WS"],
    ["FALEOLO INT/APIA", "NSFA", "None", "91759", "13.50S", "172.00W", "5", "WS"],
    ["RAROTONGA COOK I", "NCRG", "None", "91843", "21.12S", "159.49W", "7", "WS"],
    ["ALOFI COOK IS", "NIUE", "None", "91822", "19.04S", "169.55W", "20", "WS"],
    ["HIHIFO ILE WALLI", "NLWW", "None", "91753", "13.14S", "176.10W", "23", "WS"],
    ["TAHITI-FAAA POLY", "NTAA", "None", "91938", "17.33S", "149.37W", "2", "WS"],
    ["LA TONTOUTA NLLE", "NWWW", "None", "91590", "22.01S", "166.13E", "16", "WS"],
    ["APIA/UPOLU ISLAN", "NSAP", "None", "91762", "13.49S", "171.47W", "2", "WS"],
    ["ASAU/SAVAI'I ISL", "NSAU", "None", "91760", "13.30S", "172.37W", "4", "WS"],
    ["RURUTU ISLAND", "NTAR", "None", "91950", "22.25S", "151.22W", "3", "WS"],
    ["TUBUAI ISLAND", "NTAT", "None", "91954", "23.21S", "149.28W", "3", "WS"],
    ["REAO ISLAND", "NTGE", "None", "91949", "18.28S", "136.28W", "8", "WS"],
    ["BORA-BORA/MOTU-M", "NTTB", "None", "91930", "16.26S", "151.45W", "3", "WS"],
    ["RANGIROA/TUAMOTO", "NTTG", "None", "91941", "14.58S", "147.40W", "3", "WS"],
    ["HAO/TUAMOTO (MIL", "NTTO", "None", "91944", "18.04S", "140.56W", "3", "WS"],
    ["UTUROA/SOCIETY I", "NTTR", "None", "91934", "16.43S", "151.28W", "1", "WS"],
    ["MORUROA ATOLL (M", "NTTX", "None", "91952", "21.49S", "138.48W", "3", "WS"],
    ["AMURI/AITUTAKI I", "NCAI", "None", "91830", "18.49S", "159.46W", "6", "WS"],
    ["MANIHIKI ISLAND", "NCMH", "None", "None", "10.23S", "161.00W", "0", "WS"],
    ["MAUKE ISLAND", "NCMK", "None", "91840", "20.09S", "157.23W", "9", "WS"],
    ["PENRHYN ISLAND", "NCPY", "None", "91800", "09.01S", "158.04W", "2", "WS"],
    ["RAKAHANGA ATOLL", "NCRK", "None", "91804", "10.03S", "161.05W", "5", "WS"],
]
