from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="empress-eco-python",
    version="v1.0.5",
    author="Empress Platform",
    author_email="support@empress-platform.com",
    description="Official Python SDK for the Empress Platform - Auto-generated from 3,452+ business functions",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/empress-eco/empress-platform",
    project_urls={
        "Bug Tracker": "https://github.com/empress-eco/empress-platform/issues",
        "Documentation": "https://docs.empress-platform.com",
        "Homepage": "https://empress-platform.com",
    },
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Office/Business",
    ],
    packages=find_packages(),
    python_requires=">=3.7",
    install_requires=[
        "requests>=2.25.0",
        "urllib3>=1.25.3",
        "python-dateutil",
    ],
    keywords=[
        "empress",
        "business",
        "automation",
        "api",
        "sdk",
        "crm",
        "accounting",
        "inventory",
        "hr",
    ],
)
