import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabProjectIssuesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Return issues assigned to the given user id. Mutually exclusive with assignee_username. None returns unassigned issues. Any returns issues with an assignee.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#assignee_id DataGitlabProjectIssues#assignee_id}
    */
    readonly assigneeId?: number;
    /**
    * Return issues assigned to the given username. Similar to assignee_id and mutually exclusive with assignee_id. In GitLab CE, the assignee_username array should only contain a single value. Otherwise, an invalid parameter error is returned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#assignee_username DataGitlabProjectIssues#assignee_username}
    */
    readonly assigneeUsername?: string;
    /**
    * Return issues created by the given user id. Combine with scope=all or scope=assigned_to_me.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#author_id DataGitlabProjectIssues#author_id}
    */
    readonly authorId?: number;
    /**
    * Filter confidential or public issues.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#confidential DataGitlabProjectIssues#confidential}
    */
    readonly confidential?: boolean | cdktf.IResolvable;
    /**
    * Return issues created on or after the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#created_after DataGitlabProjectIssues#created_after}
    */
    readonly createdAfter?: string;
    /**
    * Return issues created on or before the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#created_before DataGitlabProjectIssues#created_before}
    */
    readonly createdBefore?: string;
    /**
    * Return issues that have no due date, are overdue, or whose due date is this week, this month, or between two weeks ago and next month. Accepts: 0 (no due date), any, today, tomorrow, overdue, week, month, next_month_and_previous_two_weeks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#due_date DataGitlabProjectIssues#due_date}
    */
    readonly dueDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#id DataGitlabProjectIssues#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Return only the issues having the given iid
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#iids DataGitlabProjectIssues#iids}
    */
    readonly iids?: number[];
    /**
    * Filter to a given type of issue. Valid values are [issue incident test_case]. (Introduced in GitLab 13.12)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#issue_type DataGitlabProjectIssues#issue_type}
    */
    readonly issueType?: string;
    /**
    * Return issues with labels. Issues must have all labels to be returned. None lists all issues with no labels. Any lists all issues with at least one label. No+Label (Deprecated) lists all issues with no labels. Predefined names are case-insensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#labels DataGitlabProjectIssues#labels}
    */
    readonly labels?: string[];
    /**
    * The milestone title. None lists all issues with no milestone. Any lists all issues that have an assigned milestone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#milestone DataGitlabProjectIssues#milestone}
    */
    readonly milestone?: string;
    /**
    * Return issues reacted by the authenticated user by the given emoji. None returns issues not given a reaction. Any returns issues given at least one reaction.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#my_reaction_emoji DataGitlabProjectIssues#my_reaction_emoji}
    */
    readonly myReactionEmoji?: string;
    /**
    * Return issues that do not match the assignee id.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#not_assignee_id DataGitlabProjectIssues#not_assignee_id}
    */
    readonly notAssigneeId?: number[];
    /**
    * Return issues that do not match the author id.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#not_author_id DataGitlabProjectIssues#not_author_id}
    */
    readonly notAuthorId?: number[];
    /**
    * Return issues that do not match the labels.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#not_labels DataGitlabProjectIssues#not_labels}
    */
    readonly notLabels?: string[];
    /**
    * Return issues that do not match the milestone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#not_milestone DataGitlabProjectIssues#not_milestone}
    */
    readonly notMilestone?: string[];
    /**
    * Return issues not reacted by the authenticated user by the given emoji.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#not_my_reaction_emoji DataGitlabProjectIssues#not_my_reaction_emoji}
    */
    readonly notMyReactionEmoji?: string[];
    /**
    * Return issues ordered by. Valid values are `created_at`, `updated_at`, `priority`, `due_date`, `relative_position`, `label_priority`, `milestone_due`, `popularity`, `weight`. Default is created_at
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#order_by DataGitlabProjectIssues#order_by}
    */
    readonly orderBy?: string;
    /**
    * The name or id of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#project DataGitlabProjectIssues#project}
    */
    readonly project: string;
    /**
    * Return issues for the given scope. Valid values are `created_by_me`, `assigned_to_me`, `all`. Defaults to all.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#scope DataGitlabProjectIssues#scope}
    */
    readonly scope?: string;
    /**
    * Search project issues against their title and description
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#search DataGitlabProjectIssues#search}
    */
    readonly search?: string;
    /**
    * Return issues sorted in asc or desc order. Default is desc
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#sort DataGitlabProjectIssues#sort}
    */
    readonly sort?: string;
    /**
    * Return issues updated on or after the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#updated_after DataGitlabProjectIssues#updated_after}
    */
    readonly updatedAfter?: string;
    /**
    * Return issues updated on or before the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#updated_before DataGitlabProjectIssues#updated_before}
    */
    readonly updatedBefore?: string;
    /**
    * Return issues with the specified weight. None returns issues with no weight assigned. Any returns issues with a weight assigned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#weight DataGitlabProjectIssues#weight}
    */
    readonly weight?: number;
    /**
    * If true, the response returns more details for each label in labels field: :name, :color, :description, :description_html, :text_color. Default is false. description_html was introduced in GitLab 12.7
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues#with_labels_details DataGitlabProjectIssues#with_labels_details}
    */
    readonly withLabelsDetails?: boolean | cdktf.IResolvable;
}
export interface DataGitlabProjectIssuesIssuesTaskCompletionStatus {
}
export declare function dataGitlabProjectIssuesIssuesTaskCompletionStatusToTerraform(struct?: DataGitlabProjectIssuesIssuesTaskCompletionStatus): any;
export declare class DataGitlabProjectIssuesIssuesTaskCompletionStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectIssuesIssuesTaskCompletionStatus | undefined;
    set internalValue(value: DataGitlabProjectIssuesIssuesTaskCompletionStatus | undefined);
    get completedCount(): number;
    get count(): number;
}
export declare class DataGitlabProjectIssuesIssuesTaskCompletionStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectIssuesIssuesTaskCompletionStatusOutputReference;
}
export interface DataGitlabProjectIssuesIssues {
}
export declare function dataGitlabProjectIssuesIssuesToTerraform(struct?: DataGitlabProjectIssuesIssues): any;
export declare class DataGitlabProjectIssuesIssuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectIssuesIssues | undefined;
    set internalValue(value: DataGitlabProjectIssuesIssues | undefined);
    get assigneeIds(): number[];
    get authorId(): number;
    get closedAt(): string;
    get closedByUserId(): number;
    get confidential(): cdktf.IResolvable;
    get createdAt(): string;
    get description(): string;
    get discussionLocked(): cdktf.IResolvable;
    get discussionToResolve(): string;
    get downvotes(): number;
    get dueDate(): string;
    get epicId(): number;
    get epicIssueId(): number;
    get externalId(): string;
    get humanTimeEstimate(): string;
    get humanTotalTimeSpent(): string;
    get iid(): number;
    get issueId(): number;
    get issueLinkId(): number;
    get issueType(): string;
    get labels(): string[];
    private _links;
    get links(): cdktf.StringMap;
    get mergeRequestToResolveDiscussionsOf(): number;
    get mergeRequestsCount(): number;
    get milestoneId(): number;
    get movedToId(): number;
    get project(): string;
    private _references;
    get references(): cdktf.StringMap;
    get state(): string;
    get subscribed(): cdktf.IResolvable;
    private _taskCompletionStatus;
    get taskCompletionStatus(): DataGitlabProjectIssuesIssuesTaskCompletionStatusList;
    get timeEstimate(): number;
    get title(): string;
    get totalTimeSpent(): number;
    get updatedAt(): string;
    get upvotes(): number;
    get userNotesCount(): number;
    get webUrl(): string;
    get weight(): number;
}
export declare class DataGitlabProjectIssuesIssuesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectIssuesIssuesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues gitlab_project_issues}
*/
export declare class DataGitlabProjectIssues extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_project_issues";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues gitlab_project_issues} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabProjectIssuesConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabProjectIssuesConfig);
    private _assigneeId?;
    get assigneeId(): number;
    set assigneeId(value: number);
    resetAssigneeId(): void;
    get assigneeIdInput(): number | undefined;
    private _assigneeUsername?;
    get assigneeUsername(): string;
    set assigneeUsername(value: string);
    resetAssigneeUsername(): void;
    get assigneeUsernameInput(): string | undefined;
    private _authorId?;
    get authorId(): number;
    set authorId(value: number);
    resetAuthorId(): void;
    get authorIdInput(): number | undefined;
    private _confidential?;
    get confidential(): boolean | cdktf.IResolvable;
    set confidential(value: boolean | cdktf.IResolvable);
    resetConfidential(): void;
    get confidentialInput(): boolean | cdktf.IResolvable | undefined;
    private _createdAfter?;
    get createdAfter(): string;
    set createdAfter(value: string);
    resetCreatedAfter(): void;
    get createdAfterInput(): string | undefined;
    private _createdBefore?;
    get createdBefore(): string;
    set createdBefore(value: string);
    resetCreatedBefore(): void;
    get createdBeforeInput(): string | undefined;
    private _dueDate?;
    get dueDate(): string;
    set dueDate(value: string);
    resetDueDate(): void;
    get dueDateInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _iids?;
    get iids(): number[];
    set iids(value: number[]);
    resetIids(): void;
    get iidsInput(): number[] | undefined;
    private _issueType?;
    get issueType(): string;
    set issueType(value: string);
    resetIssueType(): void;
    get issueTypeInput(): string | undefined;
    private _issues;
    get issues(): DataGitlabProjectIssuesIssuesList;
    private _labels?;
    get labels(): string[];
    set labels(value: string[]);
    resetLabels(): void;
    get labelsInput(): string[] | undefined;
    private _milestone?;
    get milestone(): string;
    set milestone(value: string);
    resetMilestone(): void;
    get milestoneInput(): string | undefined;
    private _myReactionEmoji?;
    get myReactionEmoji(): string;
    set myReactionEmoji(value: string);
    resetMyReactionEmoji(): void;
    get myReactionEmojiInput(): string | undefined;
    private _notAssigneeId?;
    get notAssigneeId(): number[];
    set notAssigneeId(value: number[]);
    resetNotAssigneeId(): void;
    get notAssigneeIdInput(): number[] | undefined;
    private _notAuthorId?;
    get notAuthorId(): number[];
    set notAuthorId(value: number[]);
    resetNotAuthorId(): void;
    get notAuthorIdInput(): number[] | undefined;
    private _notLabels?;
    get notLabels(): string[];
    set notLabels(value: string[]);
    resetNotLabels(): void;
    get notLabelsInput(): string[] | undefined;
    private _notMilestone?;
    get notMilestone(): string[];
    set notMilestone(value: string[]);
    resetNotMilestone(): void;
    get notMilestoneInput(): string[] | undefined;
    private _notMyReactionEmoji?;
    get notMyReactionEmoji(): string[];
    set notMyReactionEmoji(value: string[]);
    resetNotMyReactionEmoji(): void;
    get notMyReactionEmojiInput(): string[] | undefined;
    private _orderBy?;
    get orderBy(): string;
    set orderBy(value: string);
    resetOrderBy(): void;
    get orderByInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _search?;
    get search(): string;
    set search(value: string);
    resetSearch(): void;
    get searchInput(): string | undefined;
    private _sort?;
    get sort(): string;
    set sort(value: string);
    resetSort(): void;
    get sortInput(): string | undefined;
    private _updatedAfter?;
    get updatedAfter(): string;
    set updatedAfter(value: string);
    resetUpdatedAfter(): void;
    get updatedAfterInput(): string | undefined;
    private _updatedBefore?;
    get updatedBefore(): string;
    set updatedBefore(value: string);
    resetUpdatedBefore(): void;
    get updatedBeforeInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
    private _withLabelsDetails?;
    get withLabelsDetails(): boolean | cdktf.IResolvable;
    set withLabelsDetails(value: boolean | cdktf.IResolvable);
    resetWithLabelsDetails(): void;
    get withLabelsDetailsInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-gitlab-project-issues.d.ts.map