/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.comparators;

import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.comparators.Levenshtein;
import no.priv.garshol.duke.utils.StringUtils;

public class PersonNameComparator
implements Comparator {
    @Override
    public boolean isTokenized() {
        return true;
    }

    @Override
    public double compare(String v1, String v2) {
        String[] t2;
        if (v1.equals(v2)) {
            return 1.0;
        }
        if (v1.length() + v2.length() > 20 && Levenshtein.distance(v1, v2) == 1) {
            return 0.95;
        }
        String[] t1 = StringUtils.split(v1);
        if (t1.length < (t2 = StringUtils.split(v2)).length) {
            String[] tmp = t2;
            t2 = t1;
            t1 = tmp;
        }
        double penalty = 0.0;
        if (t1.length != t2.length && t2.length >= 2) {
            if (t1[0].length() == 2 && t1[0].charAt(1) == '.' || t1[0].length() == 1) {
                String[] tmp = new String[t1.length - 1];
                for (int ix = 1; ix < t1.length; ++ix) {
                    tmp[ix - 1] = t1[ix];
                }
                t1 = tmp;
                penalty = 0.2;
            } else {
                int d1 = Levenshtein.distance(t1[0], t2[0]);
                int d2 = Levenshtein.distance(t1[t1.length - 1], t2[t2.length - 1]);
                return 0.4 / (double)(d1 + 1) + 0.4 / (double)(d2 + 1);
            }
        }
        if (t1.length == t2.length) {
            int d;
            if (t1.length == 2 && t1[0].equals(t2[1]) && t1[1].equals(t2[0])) {
                return 0.9;
            }
            double points = 1.0 - penalty;
            for (int ix = 0; ix < t1.length && points > 0.0; points -= (double)d * 0.1, ++ix) {
                d = Levenshtein.distance(t1[ix], t2[ix]);
                if (ix == 0 && d > 0 && (t1[ix].startsWith(t2[ix]) || t2[ix].startsWith(t1[ix]))) {
                    d = 1;
                    continue;
                }
                if (d > 1 && ix + 1 <= t1.length) {
                    String s1 = t1[ix];
                    String s2 = t2[ix];
                    if (s1.length() < s2.length()) {
                        String tmp = s1;
                        s1 = s2;
                        s2 = tmp;
                    }
                    if ((s2.length() != 2 || s2.charAt(1) != '.') && s2.length() != 1 || s2.charAt(0) != s1.charAt(0)) continue;
                    d = 1;
                    continue;
                }
                if (t1[ix].length() + t2[ix].length() <= 4) {
                    d *= 4;
                    continue;
                }
                if (t1[ix].length() + t2[ix].length() <= 6) {
                    d *= 3;
                    continue;
                }
                if (t1[ix].length() + t2[ix].length() > 8) continue;
                d *= 2;
            }
            if (t1.length == 1 && points < 0.8) {
                return 0.0;
            }
            return Math.max(points, 0.0);
        }
        return 0.0;
    }
}

