/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.comparators;

import junit.framework.Assert;
import no.priv.garshol.duke.comparators.JaroWinkler;
import org.junit.Test;

public class JaroWinklerTest {
    @Test
    public void testEmpty() {
        Assert.assertEquals((Object)1.0, (Object)JaroWinkler.similarity((String)"", (String)""));
    }

    @Test
    public void testEqual() {
        Assert.assertEquals((Object)1.0, (Object)JaroWinkler.similarity((String)"abc", (String)"abc"));
    }

    @Test
    public void testEqual2() {
        Assert.assertEquals((Object)1.0, (Object)JaroWinkler.similarity((String)"ab", (String)"ab"));
    }

    @Test
    public void testEqual1() {
        Assert.assertEquals((Object)1.0, (Object)JaroWinkler.similarity((String)"a", (String)"a"));
    }

    @Test
    public void testEqual4() {
        Assert.assertEquals((Object)1.0, (Object)JaroWinkler.similarity((String)"abcd", (String)"abcd"));
    }

    @Test
    public void testTotallyDifferent() {
        Assert.assertEquals((Object)0.0, (Object)JaroWinkler.similarity((String)"abc", (String)"def"));
    }

    @Test
    public void testWikipedia1() {
        double score = 0.8222222222222223;
        score += 1.0 * (1.0 - score) / 10.0;
        Assert.assertEquals((Object)score, (Object)JaroWinkler.similarity((String)"DwAyNE", (String)"DuANE"));
    }

    @Test
    public void testWikipedia2() {
        double score = 0.9444444444444445;
        score += 3.0 * (1.0 - score) / 10.0;
        Assert.assertEquals((Object)score, (Object)JaroWinkler.similarity((String)"MARTHA", (String)"MARHTA"));
    }

    @Test
    public void testWikipedia3() {
        double score = 0.7333333333333334;
        Assert.assertEquals((Object)score, (Object)JaroWinkler.similarity((String)"CRATE", (String)"TRACE"));
    }

    @Test
    public void testWikipedia4() {
        double score = 0.7666666666666666;
        score += 2.0 * (1.0 - score) / 10.0;
        Assert.assertEquals((Object)score, (Object)JaroWinkler.similarity((String)"DIXON", (String)"DICKSONX"));
    }

    @Test
    public void testYancey1() {
        double score = 0.7527777777777779;
        Assert.assertEquals((Object)score, (Object)JaroWinkler.similarity((String)"anderson", (String)"barnes"));
    }

    @Test
    public void testWinkler1() {
        this.roughlyEquals(0.982, JaroWinkler.similarity((String)"SHACKLEFORD", (String)"SHACKELFORD"));
    }

    @Test
    public void testWinkler2() {
        this.roughlyEquals(0.896, JaroWinkler.similarity((String)"DUNNINGHAM", (String)"CUNNIGHAM"));
    }

    @Test
    public void testWinkler3() {
        this.roughlyEquals(0.956, JaroWinkler.similarity((String)"NICHLESON", (String)"NICHULSON"));
    }

    @Test
    public void testWinkler4() {
        this.roughlyEquals(0.832, JaroWinkler.similarity((String)"JONES", (String)"JOHNSON"));
    }

    @Test
    public void testWinkler5() {
        this.roughlyEquals(0.933, JaroWinkler.similarity((String)"MASSEY", (String)"MASSIE"));
    }

    @Test
    public void testWinkler6() {
        this.roughlyEquals(0.922, JaroWinkler.similarity((String)"ABROMS", (String)"ABRAMS"));
    }

    @Test
    public void testWinkler7() {
        this.roughlyEquals(0.722, JaroWinkler.similarity((String)"HARDIN", (String)"MARTINEZ"));
    }

    @Test
    public void testWinkler8() {
        this.roughlyEquals(0.467, JaroWinkler.similarity((String)"ITMAN", (String)"SMITH"));
    }

    @Test
    public void testWinkler9() {
        this.roughlyEquals(0.926, JaroWinkler.similarity((String)"JERALDINE", (String)"GERALDINE"));
    }

    @Test
    public void testWinkler10() {
        this.roughlyEquals(0.921, JaroWinkler.similarity((String)"MICHELLE", (String)"MICHAEL"));
    }

    @Test
    public void testWinkler11() {
        this.roughlyEquals(0.933, JaroWinkler.similarity((String)"JULIES", (String)"JULIUS"));
    }

    @Test
    public void testWinkler12() {
        this.roughlyEquals(0.88, JaroWinkler.similarity((String)"TANYA", (String)"TONYA"));
    }

    @Test
    public void testWinkler13() {
        this.roughlyEquals(0.805, JaroWinkler.similarity((String)"SEAN", (String)"SUSAN"));
    }

    @Test
    public void testWinkler14() {
        this.roughlyEquals(0.933, JaroWinkler.similarity((String)"JON", (String)"JOHN"));
    }

    @Test
    public void testWinkler15() {
        this.roughlyEquals(0.357, JaroWinkler.similarity((String)"MUNAWAR", (String)"STANLEY"));
    }

    @Test
    public void testWinkler16() {
        this.roughlyEquals(0.357, JaroWinkler.similarity((String)"STANLEY", (String)"MUNAWAR"));
    }

    private void roughlyEquals(double d1, double d2) {
        Assert.assertTrue((String)("too different: " + d1 + " != " + d2), (Math.abs(d1 - d2) < 0.01 ? 1 : 0) != 0);
    }
}

