/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.comparators;

import junit.framework.Assert;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.comparators.GeopositionComparator;
import org.junit.Before;
import org.junit.Test;

public class GeopositionComparatorTest {
    private GeopositionComparator comp;

    @Before
    public void setup() {
        this.comp = new GeopositionComparator();
    }

    @Test
    public void testEmpty() {
        Assert.assertEquals((Object)0.5, (Object)this.comp.compare("", ""));
    }

    @Test
    public void testMalformed() {
        Assert.assertEquals((Object)0.5, (Object)this.comp.compare("41.5,27.2", "41.5127.21"));
    }

    @Test
    public void testMalformed2() {
        Assert.assertEquals((Object)0.5, (Object)this.comp.compare("41.5,27.2", "1231,123123"));
    }

    @Test
    public void testMalformedStrict() {
        this.comp.setStrict(true);
        try {
            Assert.assertEquals((Object)0.5, (Object)this.comp.compare("41.5,27.2", "41.5127.21"));
            Assert.fail((String)"Didn't catch bad value");
        }
        catch (DukeException dukeException) {
            // empty catch block
        }
    }

    @Test
    public void testMalformed2Strict() {
        this.comp.setStrict(true);
        try {
            Assert.assertEquals((Object)0.5, (Object)this.comp.compare("41.5,27.2", "1231,123123"));
            Assert.fail((String)"Didn't catch bad value");
        }
        catch (DukeException dukeException) {
            // empty catch block
        }
    }

    @Test
    public void testOsloKiev() {
        Assert.assertEquals((Object)0.0, (Object)this.comp.compare("59.913869,10.752245", "50.45,30.5234"));
    }

    @Test
    public void testOsloKiev2() {
        String oslo = "59.913869,10.752245";
        String kiev = "50.45,30.5234";
        this.comp.setMaxDistance(2000000.0);
        Assert.assertTrue((this.ratio(1550.0, 2000.0) > this.comp.compare(oslo, kiev) ? 1 : 0) != 0);
        Assert.assertTrue((this.ratio(1700.0, 2000.0) < this.comp.compare(oslo, kiev) ? 1 : 0) != 0);
    }

    private double ratio(double dist, double maxdist) {
        return (1.0 - dist / maxdist) * 0.5 + 0.5;
    }

    @Test
    public void testOsloKiev3() {
        String oslo = "59.913869,10.752245";
        String kiev = "50.45,30.5234";
        this.comp.setMaxDistance(2000000.0);
        Assert.assertEquals((Object)this.comp.compare(oslo, kiev), (Object)this.comp.compare(kiev, oslo));
    }
}

