import os
import json
import boto3
import logging

from trell_ai_util.utils import LogFormatter
LogFormatter.apply()

try:
    secret_name = "data-secret"
    region_name = "ap-south-1"
    session = boto3.session.Session()
    try:
        client = session.client(
            service_name='secretsmanager',
            region_name=region_name
        )
        response = client.get_secret_value(SecretId=secret_name)
        cred = json.loads(response['SecretString'])
        logging.info("----------- Connected to AWS via AWS CLI configured credentials -----------------------")
    except Exception as err:
        client = session.client(
            service_name='secretsmanager',
            region_name=region_name,
            aws_access_key_id=os.environ['ACCESS_KEY'],
            aws_secret_access_key=os.environ['SECRET_KEY']
        )
        response = client.get_secret_value(SecretId=secret_name)
        cred = json.loads(response['SecretString'])
        logging.info("----------- Connected to AWS via environment credentials -----------------------")

    
except Exception as err:
    logging.error("* you are not authorized to use Trell pip package *")
    logging.info("** Either setup AWS CLI or place trell.env in the current folder **")
