"""
Patches :class:`~intents.model.entity.Sys.Person`

Sources:

* https://www.ssa.gov/oact/babynames/ (top 100)
* https://www.istat.it/it/dati-analisi-e-prodotti/contenuti-interattivi/contanomi
  (top 50)
* https://www.behindthename.com/top/lists/netherlands/2011
* https://www.beliebte-vornamen.de/jahrgang/j2020/top-500-2020
* https://www.ine.es/dyngs/INEbase/es/operacion.htm?c=Estadistica_C&cid=1254736177009&menu=resultados&idp=1254734710990


"""
from typing import List, Union

from intents import Entity, LanguageCode
from intents.language.entity_language import make_language_data

# TODO: limited to 100 names per country. Stats may be about baby names rather
# than whole population. Chinese should be reviewed and expanded.

class I_IntentsFirstName(Entity):
    __intents_internal__ = True
    __entity_language_data__ = {
        LanguageCode.ENGLISH: make_language_data(["Liam", "Noah", "Oliver", "Elijah", "William", "James", "Benjamin", "Lucas", "Henry", "Alexander", "Mason", "Michael", "Ethan", "Daniel", "Jacob", "Logan", "Jackson", "Levi", "Sebastian", "Mateo", "Jack", "Owen", "Theodore", "Aiden", "Samuel", "Joseph", "John", "David", "Wyatt", "Matthew", "Luke", "Asher", "Carter", "Julian", "Grayson", "Leo", "Jayden", "Gabriel", "Isaac", "Lincoln", "Anthony", "Hudson", "Dylan", "Ezra", "Thomas", "Charles", "Christopher", "Jaxon", "Maverick", "Josiah", "Isaiah", "Andrew", "Elias", "Joshua", "Nathan", "Caleb", "Ryan", "Adrian", "Miles", "Eli", "Nolan", "Christian", "Aaron", "Cameron", "Ezekiel", "Colton", "Luca", "Landon", "Hunter", "Jonathan", "Santiago", "Axel", "Easton", "Cooper", "Jeremiah", "Angel", "Roman", "Connor", "Jameson", "Robert", "Greyson", "Jordan", "Ian", "Carson", "Jaxson", "Leonardo", "Nicholas", "Dominic", "Austin", "Everett", "Brooks", "Xavier", "Kai", "Jose", "Parker", "Adam", "Jace", "Wesley", "Kayden", "Silas", "Olivia", "Emma", "Ava", "Charlotte", "Sophia", "Amelia", "Isabella", "Mia", "Evelyn", "Harper", "Camila", "Gianna", "Abigail", "Luna", "Ella", "Elizabeth", "Sofia", "Emily", "Avery", "Mila", "Scarlett", "Eleanor", "Madison", "Layla", "Penelope", "Aria", "Chloe", "Grace", "Ellie", "Nora", "Hazel", "Zoey", "Riley", "Victoria", "Lily", "Aurora", "Violet", "Nova", "Hannah", "Emilia", "Zoe", "Stella", "Everly", "Isla", "Leah", "Lillian", "Addison", "Willow", "Lucy", "Paisley", "Natalie", "Naomi", "Eliana", "Brooklyn", "Elena", "Aubrey", "Claire", "Ivy", "Kinsley", "Audrey", "Maya", "Genesis", "Skylar", "Bella", "Aaliyah", "Madelyn", "Savannah", "Anna", "Delilah", "Serenity", "Caroline", "Kennedy", "Valentina", "Ruby", "Sophie", "Alice", "Gabriella", "Sadie", "Ariana", "Allison", "Hailey", "Autumn", "Nevaeh", "Natalia", "Quinn", "Josephine", "Sarah", "Cora", "Emery", "Samantha", "Piper", "Leilani", "Eva", "Everleigh", "Madeline", "Lydia", "Jade", "Peyton", "Brielle", "Adeline"]),
        LanguageCode.ITALIAN: make_language_data(["Sofia", "Aurora", "Giulia", "Ginevra", "Alice", "Emma", "Giorgia", "Beatrice", "Greta", "Vittoria", "Anna", "Martina", "Chiara", "Matilde", "Ludovica", "Nicole", "Sara", "Bianca", "Camilla", "Arianna", "Noemi", "Gaia", "Francesca", "Mia", "Alessia", "Rebecca", "Elena", "Adele", "Elisa", "Viola", "Marta", "Giada", "Isabel", "Gioia", "Maria", "Emily", "Cecilia", "Azzurra", "Carlotta", "Ambra", "Margherita", "Chloe", "Eleonora", "Asia", "Melissa", "Anita", "Miriam", "Benedetta", "Irene", "Rachele", "Amelia", "Caterina", "Eva", "Diana", "Diletta", "Lucia", "Stella", "Serena", "Alessandra", "Isabella", "Angelica", "Olivia", "Celeste", "Sveva", "Ilaria", "Nina", "Virginia", "Linda", "Agata", "Sophia", "Lavinia", "Anastasia", "Cloe", "Federica", "Zoe", "Clara", "Iris", "Lara", "Gloria", "Nora", "Luna", "Laura", "Clarissa", "Agnese", "Victoria", "Flavia", "Angela", "Valentina", "Claudia", "Letizia", "Rosa", "Elisabetta", "Fatima", "Silvia", "Teresa", "Jasmine", "Maddalena", "Amira", "Lucrezia", "Maya", "Michela", "Livia", "Desiree", "Antonia", "Leonardo", "Francesco", "Lorenzo", "Alessandro", "Andrea", "Mattia", "Gabriele", "Tommaso", "Riccardo", "Edoardo", "Matteo", "Giuseppe", "Nicolo'", "Antonio", "Federico", "Diego", "Davide", "Giovanni", "Pietro", "Samuele", "Christian", "Filippo", "Marco", "Michele", "Luca", "Simone", "Giulio", "Elia", "Alessio", "Salvatore", "Gabriel", "Enea", "Emanuele", "Vincenzo", "Gioele", "Giacomo", "Manuel", "Jacopo", "Daniele", "Thomas", "Samuel", "Cristian", "Giorgio", "Luigi", "Daniel", "Domenico", "Nicola", "Liam", "Nathan", "Raffaele", "Stefano", "Mario", "Angelo", "Ettore", "Noah", "Flavio", "Niccolo'", "Kevin", "Paolo", "Santiago", "Carlo", "Adam", "Alberto", "Alex", "Damiano", "Nicolas", "Nicholas", "Rayan", "Bryan", "Vittorio", "Valerio", "Pasquale", "Amir", "Cesare", "Michael", "Roberto", "Sebastiano", "Enrico", "Sebastian", "Dario", "David", "Achille", "Gregorio", "Brando", "Ludovico", "Massimo", "Fabio", "Antonino", "Ciro", "Dylan", "Carmine", "Martino", "Leo", "Youssef", "Omar", "Cristiano", "Ivan", "Zeno", "Gaetano", "Gennaro", "Mathias", "Ethan", "Claudio"]),
        LanguageCode.DUTCH: make_language_data(["Noah", "Sem", "Liam", "Lucas", "Daan", "Finn", "Levi", "Luuk", "Mees", "James", "Milan", "Sam", "Noud", "Benjamin", "Luca", "Bram", "Mason", "Max", "Thomas", "Adam", "Hugo", "Jesse", "Boaz", "Olivier", "Teun", "Julian", "Lars", "Thijs", "Gijs", "Siem", "Guus", "Mats", "Zayn", "Otis", "Jens", "Jack", "Floris", "Ties", "Vince", "Joep", "David", "Jan", "Stijn", "Sven", "Dex", "Jurre", "Morris", "Ruben", "Owen", "Jayden", "Mohammed", "Tobias", "Moos", "Tim", "Abel", "Tijn", "Jace", "Willem", "Oliver", "Cas", "Fedde", "Ryan", "Jaxx", "Roan", "Quinn", "Xavi", "Daniël", "Dani", "Alexander", "Dean", "Jake", "Sepp", "Ezra", "Mohamed", "Pepijn", "Tom", "Jason", "Aiden", "Jax", "Nathan", "Kai", "Rayan", "Pim", "Oscar", "Elias", "Melle", "Boris", "Mick", "Senn", "Samuel", "Lenn", "Hidde", "Amir", "Johannes", "Job", "Joshua", "Niek", "Tygo", "Stef", "Arthur", "Emma", "Julia", "Mila", "Tess", "Sophie", "Zoë", "Sara", "Nora", "Yara", "Eva", "Liv", "Lotte", "Evi", "Noor", "Anna", "Milou", "Olivia", "Saar", "Lauren", "Nina", "Lieke", "Fleur", "Lynn", "Sofie", "Elin", "Fien", "Nova", "Sarah", "Maud", "Lina", "Mia", "Loïs", "Sofia", "Emily", "Roos", "Fenna", "Ella", "Isa", "Hailey", "Luna", "Hannah", "Julie", "Noa", "Elena", "Sophia", "Bo", "Suze", "Lara", "Maria", "Jasmijn", "Lena", "Esmee", "Cato", "Amy", "Vera", "Lisa", "Liz", "Juul", "Floor", "Hanna", "Norah", "Rosa", "Noé", "Ivy", "Charlotte", "Isabella", "Amber", "Feline", "Elise", "Puck", "Veerle", "Lizzy", "Lize", "Linde", "Livia", "Naomi", "Rosie", "Charlie", "Merel", "Isabel", "Liva", "Fenne", "Anne", "Maeve", "Kiki", "Jill", "Amira", "Benthe", "Iris", "Romy", "Romée", "Eline", "Sanne", "Tessa", "Fiene", "Lola", "Loua", "Femke", "Nola", "Fay"]),
        LanguageCode.FRENCH: make_language_data(["Mathis", "Auguste", "Juliette", "Imran", "Côme", "Léon", "Nour", "Noam", "Samuel", "Chloé", "Lila", "Lana", "Lyam", "Martin", "Clément", "Lisa", "Jeanne", "Eva", "Simon", "Oscar", "Célia", "Malone", "Louna", "Marceau", "Lenny", "Enzo", "Alice", "Elise", "Gabriel", "Zélie", "Salomé", "Axel", "Aaron", "Ambre", "Pablo", "Gabin", "Olivia", "Nino", "Yanis", "Mohamed", "Owen", "Elio", "Apolline", "Gaspard", "Joseph", "Alexandre", "Léa", "Inès", "Maxence", "Margot", "Noah", "Lilou", "Giulia", "Timéo", "Zoé", "Logan", "Emy", "Amélia", "Ella", "Iris", "Maya", "Léna", "Maëlys", "Amir", "Hugo", "Mathilde", "Diego", "Noa", "Clara", "Lyna", "Livio", "Ayden", "Léana", "Noé", "Mila", "Inaya", "Théo", "Héloïse", "Constance", "Gabrielle", "Sofia", "Lou", "Maël", "Mathéo", "Milo", "Roxane", "Kaïs", "Clémence", "Rose", "Manon", "Noémie", "Louis", "Basile", "Lina", "Liam", "Jade", "Jules", "Marius", "Elsa", "Sacha", "Baptiste", "Ali", "Albane", "Ilyan", "Charlie", "Luna", "Léonie", "Soan", "Augustin", "Alya", "Valentine", "Mathys", "Ava", "Louise", "Margaux", "Timothée", "Ayoub", "Soline", "Eliott", "Wassim", "Marie", "Isaac", "Tom", "Evan", "Elena", "Arthur", "Romy", "Anna", "Romane", "Théa", "Anas", "Victoire", "Sarah", "Antoine", "Youssef", "Alba", "Naël", "Nolan", "Lucas", "Léandre", "Assia", "Adèle", "Robin", "Yasmine", "Victoria", "Lise", "Thomas", "Céleste", "Livia", "Adem", "Julia", "Nathan", "Maria", "Nina", "Tiago", "Victor", "William", "Sohan", "Mia", "Ethan", "Alessio", "Capucine", "Lya", "Lyana", "Lily", "Adam", "Thaïs", "Camille", "Aya", "Emmy", "Léo", "Rayan", "Lucie", "Alicia", "Naïm", "Mya", "Lola", "Joy", "Agathe", "Raphaël", "Alix", "Milan", "Emma", "Charlotte", "Paul", "Charly", "Maëlle", "Nora", "Ismaël", "Ilyes", "Malo", "Eden", "Anaïs", "Valentin", "Marin", "Alma", "Maxime", "Ibrahim"]),
        LanguageCode.GERMAN: make_language_data(["Mia", "Emilia", "Hannah", "Emma", "Sophia", "Lina", "Ella", "Mila", "Clara", "Lea", "Marie", "Anna", "Luisa", "Ida", "Leni", "Frieda", "Emily", "Lia", "Lena", "Mathilda", "Charlotte", "Leonie", "Amelie", "Johanna", "Sophie", "Maja", "Lilly", "Lara", "Nele", "Lotta", "Laura", "Sarah", "Nora", "Paula", "Juna", "Mira", "Elisa", "Helena", "Mara", "Melina", "Victoria", "Elena", "Alina", "Maria", "Thea", "Tilda", "Luna", "Marlene", "Carla", "Eva", "Romy", "Pia", "Paulina", "Elina", "Hailey", "Malia", "Merle", "Isabella", "Luise", "Anni", "Antonia", "Josephine", "Zoe", "Fiona", "Pauline", "Julia", "Olivia", "Finja", "Elli", "Lisa", "Martha", "Amalia", "Mina", "Amira", "Carlotta", "Isabell", "Jana", "Rosalie", "Lotte", "Alma", "Liya", "Katharina", "Ronja", "Theresa", "Lucy", "Jasmin", "Aaliyah", "Maila", "Stella", "Elisabeth", "Jule", "Leyla", "Valentina", "Chiara", "Milena", "Annika", "Magdalena", "Amelia", "Melissa", "Amy", "Noah", "Ben", "Matteo", "Finn", "Leon", "Elias", "Paul", "Henry", "Louis", "Felix", "Luca", "Emil", "Jonas", "Theo", "Lukas", "Anton", "Liam", "Maximilian", "Jakob", "Leo", "Oskar", "Max", "Milan", "Karl", "David", "Moritz", "Julian", "Alexander", "Jonah", "Niklas", "Samuel", "Jonathan", "Lio", "Levi", "Mohammed", "Mats", "Raphael", "Aaron", "Philipp", "Tim", "Tom", "Linus", "Erik", "Mika", "Hannes", "Leonard", "Valentin", "Benjamin", "Johann", "Jannis", "Till", "Adrian", "Adam", "Simon", "Milo", "Theodor", "Joshua", "Jan", "Konstantin", "Arthur", "Lian", "Maxim", "Julius", "Vincent", "Fabian", "Marlon", "Nico", "Fiete", "Toni", "Daniel", "Lennard", "Mattis", "Carlo", "Johannes", "Fritz", "Kilian", "Jannik", "Ole", "Malik", "Emilio", "Bruno", "Matti", "Gabriel", "Nils", "Luke", "Lias", "Lasse", "Lenny", "Phil", "Pepe", "Malte", "Levin", "Ludwig", "Nick", "Thilo", "Miran", "Ali", "Benedikt", "Frederik", "Michael"]),
        LanguageCode.SPANISH: make_language_data(["Mario", "Eduardo", "Roberto", "Jaime", "Francisco Jose", "Marcos", "Ignacio", "Hugo", "Alfonso", "Jordi", "Ricardo", "Salvador", "Guillermo", "Gabriel", "Marc", "Emilio", "Mohamed", "Gonzalo", "Julio", "Julian", "Martin", "Jose Miguel", "Tomas", "Agustin", "Nicolas", "Jose Ramon", "Samuel", "Ismael", "Joan", "Cristian", "Felix", "Lucas", "Aitor", "Hector", "Juan Francisco", "Iker", "Alex", "Jose Carlos", "Josep", "Sebastian", "Mariano", "Cesar", "Alfredo", "Domingo", "Jose Angel", "Felipe", "Victor Manuel", "Rodrigo", "Jose Ignacio", "Mateo", "Luis Miguel", "Jose Francisco", "Juan Luis", "Xavier", "Albert", "Maria Carmen", "Maria", "Carmen", "Ana Maria", "Josefa", "Maria Pilar", "Isabel", "Laura", "Maria Dolores", "Maria Teresa", "Ana", "Cristina", "Marta", "Maria Angeles", "Lucia", "Francisca", "Maria Isabel", "Maria Jose", "Antonia", "Dolores", "Sara", "Paula", "Elena", "Maria Luisa", "Raquel", "Rosa Maria", "Pilar", "Manuela", "Concepcion", "Maria Jesus", "Mercedes", "Julia", "Beatriz", "Nuria", "Silvia", "Alba", "Irene", "Rosario", "Juana", "Teresa", "Patricia", "Encarnacion", "Montserrat", "Andrea", "Rocio", "Monica", "Alicia", "Maria Mar", "Rosa", "Sonia", "Sandra", "Marina", "Angela", "Susana", "Natalia", "Yolanda", "Margarita", "Maria Josefa", "Claudia", "Sofia", "Eva", "Carla", "Maria Rosario", "Inmaculada", "Maria Mercedes", "Ana Isabel", "Esther", "Noelia", "Veronica", "Nerea", "Carolina", "Angeles", "Daniela", "Maria Victoria", "Eva Maria", "Ines", "Miriam", "Lorena", "Maria Rosa", "Maria Elena", "Ana Belen", "Victoria", "Maria Concepcion", "Amparo", "Martina", "Maria Antonia", "Alejandra", "Lidia", "Catalina", "Celia", "Maria Nieves", "Consuelo", "Fatima", "Olga", "Ainhoa", "Gloria", "Clara", "Maria Cristina", "Maria Soledad", "Emilia"]),
        LanguageCode.CHINESE: make_language_data(["麗", "偉", "芳", "偉", "秀英", "秀英", "娜", "秀英", "偉", "敏", "静", "麗", "静", "丽", "强", "静", "敏", "敏", "磊", "军", "洋", "勇", "勇", "艳", "杰", "磊", "强", "军", "杰", "娟", "艳", "涛", "涛", "明", "艳", "超", "勇", "娟", "杰", "秀兰", "霞", "敏", "军", "丽", "强", "平", "刚", "杰", "桂英", "芳"]),
    }
