(this["webpackJsonpmasterful-ai-visualize-frontend"]=this["webpackJsonpmasterful-ai-visualize-frontend"]||[]).push([[0],{361:function(e,a,t){e.exports=t.p+"media/react-logo-transparent.f7d45c01.svg"},364:function(e,a,t){e.exports=t.p+"media/masterful_ai_logo_bw.06d23c2e.svg"},365:function(e,a){e.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGAAAABgCAYAAADimHc4AAACtElEQVR4Ae3cO05VURyFcRuNGh/XRxgCI7CixjAYaOkMN9I4BBgFgxBFwXdotLGSgoTQYKCCnwUkFIjnHtzcfyDr68/OyreS89iPcyNUEkIIAVOYSu4isIKV5C4AkzjEISaTe8xg2SnLyT1GMIF9p+xjIrnHBBadZTG5xwDuYsdZdnA3uS8ZzDqf2eS+JHAHc9h2PtuYw53kbvvgWsSO0dnBIiaS+//el5dw4OIcYAmTyd3vM30Fh9pxiBVMJXcKqM+dW1B97i7yEC4ir6FF5EOsnExFZDIuuTMdnQUZPMcq9rCJIW6OIXeWJLHg76xjcIm5syiPoX+zgUHL3NmW0iG/QQkduUOH/I4SmhP59SVEfn0JkV9fQuTXlxD5W1UlRP6JUAyLSoj8BteGJgL7j7GOWzHfQv7Fx3oZ+Qz1Y7rhmD8ivz+7eNYx7gC/dLMX+WhZAgbYMBprkd+whJ7yjzAT+Y1K6CkfFiK/XQnTPeUPI7/7VXMauxoT+d18wKOT655hN/IL5B9zWkLkF8hvVULkd/PxjPyOEprLj/xuMB35dfIH7V8167elRH79xqzIL92aWCD/U738+s25lfIfjzjuQ6y3l1+/PT3yqw9oFMj/XCK/4IhS5Bcc0ov8gmOqkX+dD2oXyH/fXn79rwoiv/pnHQXyv+DJiOM+aCD/+hRQIP9de/n1t6DIr38IR375a2jkF3yIFcj/Wi+//m8plfKf9pC/ViD/6kzGYSHyi6ajMYMjo/HtessvWJDBWnv57lfKv1JLkvitm62e8t9Wy78yi/L4bjTmr6H8+m0peGF05hvLD7iJ1/1LiPxm4B7e9CqhXn5KOL2mSn5K+FkoPyUUyE8JBfJTQr38lFAvPyXUy08J9fJTQr38lLCafy8Ugtt4hU3sYRXPYyYcE0IIIYQQQvgDlYF75V2EaQoAAAAASUVORK5CYII="},366:function(e,a){e.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAQAAAD9CzEMAAAAkUlEQVRYw+3Xyw2AIBAEUPtAa7UatDL0gjWMJy9emJ2Nv7hzZuclBELousgLg4SMBa2Men0FF41ABh+FQAEuJY5JZo1EmAErIQA2QgIshAjwhAywhAPgCBfAEE4A3wBccwH8EGi9OAFcD8QxjXsQQBzTRwDbB+Sc0gYmF5DbQI9Nrq9IzG4OmLGayxdkqj5ye3ZY2irQOtTXPQAAAABJRU5ErkJggg=="},386:function(e,a,t){e.exports=t(625)},391:function(e,a,t){},443:function(e,a){e.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAYUlEQVR4Ae3NwQ1AQBQA0e2ODpSjGnVJbBnC04CNlS/swbvOYVI7fuiQlY3RwawsPsEGhTZgVSejrxiEJkt5EATw/cBNNYP9nUFAWwMXmhyAFPD5YPGc7WzQI3vGlH7NOACG5pfo9HAxcQAAAABJRU5ErkJggg=="},625:function(e,a,t){"use strict";t.r(a);var n=t(0),l=t.n(n),r=t(41),i=t.n(r),o=t(91),c=(t(391),t(392),t(393),t(10)),s=t(58),m=t(35),u=t(666),d=t(361),f=t.n(d),h=function(e){var a=e.show;return l.a.createElement("div",{className:"preloader bg-soft flex-column justify-content-center align-items-center ".concat(a?"":"show")},l.a.createElement(u.a,{className:"loader-element animate__animated animate__jackInTheBox",src:f.a,height:40}))},p=t(219),g=(t(687),t(688)),v=t(667),y=t(686),E=t(378),b=t(364),A=t.n(b),k=(t(443),t(365)),x=t.n(k),N=t(366),S=t.n(N),P={path:"/policies"},w={path:"/docs"},O=function(){var e="v".concat("0.4"),a=Object(m.g)(),t=a.pathname,r=Object(n.useState)(!1),i=Object(c.a)(r,2),s=i[0],d=i[1],f=s?"show":"",h=function(e){var a=e.title,n=e.link,r=e.external,i=e.target,c=e.icon,s=e.image,m=e.badgeText,f=e.badgeBg,h=void 0===f?"secondary":f,y=e.badgeColor,E=void 0===y?"primary":y,_=m?"d-flex justify-content-start align-items-center justify-content-between":"",b=n===t?"active":"",A=r?{href:n}:{as:o.b,to:n};return l.a.createElement(g.a.Item,{className:b,onClick:function(){return d(!1)}},l.a.createElement(g.a.Link,Object.assign({},A,{target:i,className:_}),l.a.createElement("span",null,c?l.a.createElement("span",{className:"sidebar-icon"},l.a.createElement(p.a,{icon:c})," "):null,s?l.a.createElement(u.a,{src:s,width:20,height:20,className:"sidebar-icon svg-icon"}):null,l.a.createElement("span",{className:"sidebar-text"},a)),m?l.a.createElement(v.a,{pill:!0,bg:h,text:E,className:"badge-md notification-count ms-2"},m):null))};return l.a.createElement(l.a.Fragment,null,l.a.createElement(E.a,{className:"collapse ".concat(f," sidebar d-md-block bg-primary text-white")},l.a.createElement("div",{className:"sidebar-inner px-4 pt-3"},l.a.createElement(g.a,{className:"flex-column pt-3 pt-md-0"},l.a.createElement("div",{className:"masterful-sidebar-div"},l.a.createElement("img",{src:A.a,className:"masterful-sidebar-logo"})),l.a.createElement(y.a.Divider,{className:"my-3 border-indigo"}),l.a.createElement(h,{title:"Training Params",link:P.path,image:x.a}),l.a.createElement(h,{title:"Docs",link:w.path,image:S.a}),l.a.createElement("div",{className:"sidebar-version-container"},l.a.createElement("p",{className:"sidebar-version"},e))))))},L=t(7),M=t(12),B=t(13),R=t(14),T=t(668),j=t(669),C=t(111),D=t.n(C),I=t(690),F=t(670),V=t(19),U=t(73),Y=t.n(U),H="LAYER",z=function(e,a){var t,n=-1,l=Object(V.a)(e.val_metrics);try{for(l.s();!(t=l.n()).done;){var r=t.value;if(Y.a.isEqual(r.node_scalar_map,a)){n=r.metrics.loss;break}}}catch(i){l.e(i)}finally{l.f()}return-1===n&&console.log("No val_loss found for scalar: ".concat(a," in task: ").concat(e.title)),n},W=function(e,a){return e<=0?(console.log("Error: total cannot be <= 0"),-1):100*a/e},Q=function(e){if(!e.fit_was_captured)return!1;var a=e.node_search_tasks.length,t=e.node_search_tasks[a-1];return"UNLABELED_DATA_SSL"===t.type&&0!==t.node_optimal_scalar_map.masterful_unlabeled_switch},K=function(e){var a=e.node_optimal_scalar_map;return Object.values(a).some((function(e){return e>0}))},G=function(e){for(var a=[],t=Object.keys(e.node_scalars_map),n=e.node_scalars_map[t[0]].scalars.length,l=0;l<n;l++){var r,i={},o=Object(V.a)(t);try{for(o.s();!(r=o.n()).done;){var c=r.value;i[c]=e.node_scalars_map[c].scalars[l]}}catch(s){o.e(s)}finally{o.f()}a.push(i)}return a},J=function(e,a){var t=arguments.length>2&&void 0!==arguments[2]&&arguments[2],n=[];if(e.type===H){var l,r=Object(V.a)(e.searched_layers);try{for(r.s();!(l=r.n()).done;){var i=l.value;n=n.concat(q(i,a[i.name],t))}}catch(o){r.e(o)}finally{r.f()}}else n.push(a[e.title]);return n},q=function(e,a){var t=arguments.length>2&&void 0!==arguments[2]&&arguments[2];if("MASTERFUL_SAMPLE_MAG_BY_QUANTILE_LAYER"!==e.layer_type)return[a];if(0===a){if(t)return[0];var n=new Array(e.ordered_actions.length).fill(0);return n}for(var l=[],r=a-1,i=0;i<e.ordered_actions.length;i++){var o=e.max_index_grid[i].values[r],c=o-1,s=e.action_mag_grid[i].values[c];l.push(s)}if(t&&l.length>0){var m=0;l.forEach((function(e){return m+=e}));var u=m/l.length;return[Math.floor(100*u)/100]}return l},X=function(e){var a=e.policies,t=e.onTableRowClick;"object"!==typeof a&&(a=[]);var n=function(e){var a=e.policy_name,t=e.handleClick,n=e.engine_version,r=e.task_type;return l.a.createElement("tr",null,l.a.createElement("th",{scope:"row",onClick:function(){return t(a)}}," ",a),l.a.createElement("td",null,function(e){if("COMPUTER_VISION_TASK_UNKNOWN"===e)return"Unknown";for(var a=e.toLowerCase().split("_"),t=0;t<a.length;t++)a[t]=a[t][0].toUpperCase()+a[t].substring(1);return a.join(" ")}(r)),l.a.createElement("td",null,n))};return l.a.createElement(I.a,{border:"light",className:"shadow-sm"},l.a.createElement(I.a.Header,null,l.a.createElement(T.a,{className:"align-items-center"},l.a.createElement(j.a,null,l.a.createElement("h5",null,"Training Params"),l.a.createElement("p",null,"Select training params to visualize")))),l.a.createElement(F.a,{responsive:!0,className:"align-items-center table-flush"},l.a.createElement("thead",{className:"thead-light"},l.a.createElement("tr",null,l.a.createElement("th",{scope:"col"},"Params Name"),l.a.createElement("th",{scope:"col"},"ML Task"),l.a.createElement("th",{scope:"col"},"Params Engine"))),l.a.createElement("tbody",null,a.map((function(e){return l.a.createElement(n,Object.assign({handleClick:t,key:"policy-".concat(e.policy_name)},e))})))))},Z=function(e){var a=e.datasets,t=e.onTableRowClick;"object"!==typeof a&&(a=[]);var n=function(e){var a=e.title,t=e.task,n=e.handleClick,r=e.total_cardinality,i=e.train_cardinality,o=e.test_cardinality;return l.a.createElement("tr",null,l.a.createElement("th",{scope:"row",onClick:function(){return n(a)}}," ",a),l.a.createElement("td",null,r),l.a.createElement("td",null,i," / ",o),l.a.createElement("td",null,t))};return l.a.createElement(I.a,{border:"light",className:"shadow-sm"},l.a.createElement(I.a.Header,null,l.a.createElement(T.a,{className:"align-items-center"},l.a.createElement(j.a,null,l.a.createElement("h5",null,"Datasets"),l.a.createElement("p",null,"Select a dataset to visualize")))),l.a.createElement(F.a,{responsive:!0,className:"align-items-center table-flush"},l.a.createElement("thead",{className:"thead-light"},l.a.createElement("tr",null,l.a.createElement("th",{scope:"col"},"Dataset"),l.a.createElement("th",{scope:"col"},"Cardinality"),l.a.createElement("th",{scope:"col"},"Train / Test Split"),l.a.createElement("th",{scope:"col"},"Task"))),l.a.createElement("tbody",null,a.map((function(e){return l.a.createElement(n,Object.assign({handleClick:t,key:"dataset-".concat(e.title)},e))})))))},$=t(114),ee=t(377),ae="http://127.0.0.1:7007/",te={"Access-Control-Allow-Origin":"*","Access-Control-Allow-Methods":"*","Access-Control-Allow-Headers":"*"},ne=function(e){var a=e.title,t=e.policyName,n=e.policyEngine,r=e.plotData,i=e.plotVariables;return l.a.createElement(I.a,{className:"shadow-sm"},l.a.createElement(I.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},a),l.a.createElement("h6",{className:"fw-normal mb-2"},l.a.createElement("strong",null,"Params:")," ",t),l.a.createElement("h6",{className:"fw-normal mb-2"},l.a.createElement("strong",null,"Params Engine:")," ",n))),l.a.createElement(I.a.Body,{className:"p-2",style:{minHeight:800,height:1e3,minWidth:400}},l.a.createElement(ee.a,{data:r,variables:i.reverse().map((function(e){return"selected"===e.actionKey||"masterful_unlabeled_switch"===e.actionKey?{key:e.actionKey,legend:e.actionLegend,type:"point",ticksPosition:"before",legendPosition:"start",legendOffset:20,padding:1,values:e.values}:{key:e.actionKey,legend:e.actionLegend,type:"linear",min:e.min,max:e.max,ticksPosition:"before",legendPosition:"start",legendOffset:20}})),margin:{top:50,right:60,bottom:50,left:60},layout:"vertical",colors:function(e){var a=e.size,t=Array(a);return t.fill("#D32F2F"),t[a-1]="#00e676",t}({size:r.length}),strokeWidth:3,lineOpacity:.8,curve:"linear",motionConfig:"molasses",theme:{fontSize:14,axis:{domain:{line:{stroke:"#dde1e9",strokeWidth:1}}}}})))},le=function(e){var a=e.title,t=e.policyName,n=e.policyEngine,r=e.data;e.min,e.max;return l.a.createElement(I.a,{className:"shadow-sm"},l.a.createElement(I.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},a),l.a.createElement("h6",{className:"fw-normal mb-2"},l.a.createElement("strong",null,"Params:")," ",t),l.a.createElement("h6",{className:"fw-normal mb-2"},l.a.createElement("strong",null,"Params Engine:")," ",n))),l.a.createElement(I.a.Body,{className:"p-2",style:{minHeight:600,height:600,minWidth:400}},l.a.createElement($.a,{data:r,keys:["Basline","Masterful"],indexBy:"classLabel",margin:{top:50,right:60,bottom:50,left:60},padding:.3,groupMode:"grouped",isInteractive:!0,borderRadius:4,colors:["#00BCD4","#5E35B1"],label:function(e){var a=e.value;return"".concat(a,"%")},valueScale:{type:"linear"},indexScale:{type:"band",round:!0},tooltipFormat:function(e){return"".concat(e,"%")},axisTop:null,axisRight:null,axisBottom:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Class Label",legendPosition:"middle",legendOffset:32},axisLeft:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Recall",legendPosition:"middle",legendOffset:-40},labelSkipWidth:24,labelSkipHeight:24,labelTextColor:"#ffffff",legends:[{dataFrom:"keys",anchor:"bottom-right",direction:"column",justify:!1,translateX:80,translateY:0,itemsSpacing:2,itemWidth:100,itemHeight:20,itemDirection:"left-to-right",itemOpacity:.85,symbolSize:20,effects:[{on:"hover",style:{itemOpacity:1}}]}]})),l.a.createElement("p",{className:"lead chart-description-paragraph"},"Recall is defined as TP / P, or equivalently, TP / (TP + FN). The term Recall has the same meaning as True Positive Rate and sensitivity."))},re=function(e){var a=e.title,t=e.policyName,n=e.policyEngine,r=e.data;e.min,e.max;return l.a.createElement(I.a,{className:"shadow-sm"},l.a.createElement(I.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},a),l.a.createElement("h6",{className:"fw-normal mb-2"},l.a.createElement("strong",null,"Params:")," ",t),l.a.createElement("h6",{className:"fw-normal mb-2"},l.a.createElement("strong",null,"Params Engine:")," ",n))),l.a.createElement(I.a.Body,{className:"p-2",style:{minHeight:600,height:600,minWidth:400}},l.a.createElement($.a,{data:r,keys:["Basline","Masterful"],indexBy:"classLabel",margin:{top:50,right:60,bottom:50,left:60},groupMode:"grouped",padding:.3,borderRadius:4,colors:["#00BCD4","#5E35B1"],label:function(e){var a=e.value;return"".concat(a,"%")},tooltipFormat:function(e){return"".concat(e,"%")},valueScale:{type:"linear"},indexScale:{type:"band",round:!0},axisTop:null,axisRight:null,axisBottom:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Class Prediction",legendPosition:"middle",legendOffset:32},axisLeft:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Precision",legendPosition:"middle",legendOffset:-40},labelSkipWidth:24,labelSkipHeight:24,labelTextColor:"#ffffff",legends:[{dataFrom:"keys",anchor:"bottom-right",direction:"column",justify:!1,translateX:80,translateY:0,itemsSpacing:2,itemWidth:100,itemHeight:20,itemDirection:"left-to-right",itemOpacity:.85,symbolSize:20,effects:[{on:"hover",style:{itemOpacity:1}}]}]})),l.a.createElement("h6",{className:"lead chart-description-paragraph"},"Precision is defined as TP / PP, where PP means Predicted Positives. Or equivalently, TP / (TP + FP). The term Precision has the same meaning as Positive Predictive Value."))},ie=function(e){var a=e.title,t=e.datasetTitle,n=e.keys,r=e.data;return l.a.createElement(I.a,{className:"shadow-sm"},l.a.createElement(I.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},a),l.a.createElement("h6",{className:"fw-normal mb-2"},"Dataset: ",t))),l.a.createElement(I.a.Body,{className:"p-2",style:{minHeight:1e3,height:1e3,minWidth:400}},l.a.createElement($.a,{data:r,keys:n,indexBy:"classLabel",margin:{top:50,right:60,bottom:50,left:100},padding:.3,colors:function(e){var a=e.id;return"train"===a?"#64dd17":"test"===a?"#c51162":"val"===a?"#ffd600":"#64dd17"},groupMode:"grouped",layout:"horizontal",valueScale:{type:"linear"},indexScale:{type:"band",round:!0},axisTop:null,axisRight:null,borderRadius:8,axisBottom:{tickSize:5,tickPadding:5,tickRotation:0,legend:"# Labels",legendPosition:"middle",legendOffset:32},axisLeft:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Class Labels",legendPosition:"middle",legendOffset:-60},labelSkipWidth:12,labelSkipHeight:12,labelTextColor:"#ffffff",legends:[{dataFrom:"keys",anchor:"bottom-right",direction:"column",justify:!1,translateX:120,translateY:0,itemsSpacing:2,itemWidth:100,itemHeight:20,itemDirection:"left-to-right",itemOpacity:.85,symbolSize:20,effects:[{on:"hover",style:{itemOpacity:1}}]}]})))},oe=function(e){var a=e.title,t=e.policyName,n=e.policyEngine,r=e.data,i=e.keys,o=e.maxVal;return l.a.createElement(I.a,{className:"shadow-sm"},l.a.createElement(I.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},a),l.a.createElement("h6",{className:"fw-normal mb-2"},l.a.createElement("strong",null,"Params:")," ",t),l.a.createElement("h6",{className:"fw-normal mb-2"},l.a.createElement("strong",null,"Params Engine:")," ",n))),l.a.createElement(I.a.Body,{className:"p-2",style:{minHeight:600,height:600,minWidth:400}},l.a.createElement($.a,{data:r,keys:i,indexBy:"technique",margin:{top:50,right:60,bottom:50,left:60},padding:.3,minValue:0,borderRadius:8,isInteractive:!1,maxValue:o,label:function(e){var a=e.data,t=e.value;return"original"===a.technique||"with Masterful"===a.technique?t:"-".concat(t)},colors:function(e){var a=e.id,t=e.data;return"lowerPart"===a||"upperPart"===a?"#0000":"Basline"===t.technique?"#00BCD4":"Masterful"===t.technique?"#5E35B1":"#D32F2F"},valueScale:{type:"linear"},indexScale:{type:"band",round:!0},axisTop:null,axisRight:null,axisBottom:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Technique",legendPosition:"middle",legendOffset:32},axisLeft:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Val loss",legendPosition:"middle",legendOffset:-50},labelSkipWidth:24,labelSkipHeight:12,labelTextColor:"#ffffff"})))},ce=function(e){var a=e.policyName,t=e.policyEngine,n=e.data,r=e.reductionRate;return l.a.createElement(I.a,{className:"shadow-sm"},l.a.createElement(I.a.Header,{className:"d-flex flex-row align-items-center flex-0"},l.a.createElement("div",{className:"d-block"},l.a.createElement("h3",{className:"fw-normal mb-2"},"Error Rate Reduction",": ",r,"%"),l.a.createElement("h6",{className:"fw-normal mb-2"},l.a.createElement("strong",null,"Params:")," ",a),l.a.createElement("h6",{className:"fw-normal mb-2"},l.a.createElement("strong",null,"Params Engine:")," ",t))),l.a.createElement(I.a.Body,{className:"p-2",style:{minHeight:600,height:600,minWidth:400}},l.a.createElement($.a,{data:n,keys:["Error Rate"],indexBy:"Model",margin:{top:50,right:60,bottom:50,left:60},padding:.3,borderRadius:8,minValue:0,colors:function(e){return"Basline"===e.data.Model?"#00BCD4":"#5E35B1"},label:function(e){var a=e.value;return"".concat(a,"%")},tooltipFormat:function(e){return"".concat(e,"%")},valueScale:{type:"linear"},indexScale:{type:"band",round:!0},axisTop:null,axisRight:null,axisBottom:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Model",legendPosition:"middle",legendOffset:32},axisLeft:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Error Rate",legendPosition:"middle",legendOffset:-40},labelSkipWidth:24,labelSkipHeight:24,labelTextColor:"#ffffff"})))},se=(l.a.Component,function(e,a,t){var n=[],l={upperPart:0,lowerPart:0,technique:"Basline"};l.impValue=Math.floor(1e5*e)/1e5,n.push(l);for(var r=0,i=0,o=Object.keys(t);i<o.length;i++){var c=o[i],s=Math.floor(1e5*t[c])/1e5;if(0!==s){var m={};m.upperPart=r,m.technique=c,m.impValue=s,m.lowerPart=e-r-m.impValue,n.push(m),r+=m.impValue}}var u=e-a,d={};return d.upperPart=Math.floor(1e5*u)/1e5,d.lowerPart=0,d.technique="Masterful",d.impValue=Math.floor(1e5*a)/1e5,n.push(d),n}),me=function(e){return z(e,e.node_optimal_scalar_map)},ue=function(e){return e.presearch_model_val_metrics.loss},de=function(e,a){for(var t={},n=0,l=Object.keys(e);n<l.length;n++){var r=l[n];t[r]=e[r]*a/100}return t},fe=function(e,a,t){var n,l={},r=a,i=Object(V.a)(e.node_search_tasks);try{for(i.s();!(n=i.n()).done;){var o=n.value;if(!o.title.includes("unlabeled")){var c=ve(o);if(K(o)){var s=he(o,r,t);l[c]=s;var m=z(o,o.node_optimal_scalar_map);if(-1===m)return console.log("Error: did not expect node optimal val loss to be missing."),null;r=m}else l[c]=0}}}catch(u){i.e(u)}finally{i.f()}return l},he=function(e,a,t){var n=z(e,e.node_optimal_scalar_map);if(-1===n)return-1;var l=a-n;if(l<0)return console.log("Optimal node val loss cannot be worse than previous optimal val loss."),-1;var r=W(t,l);return-1===r?-1:r},pe=function(e){if(0===e.node_search_tasks.length)return-1;var a=function(e){var a=e.node_search_tasks.length;if(0===a)return console.log("RAY | killing analyze final loss here #1"),null;var t=a-1;e.fit_was_captured&&("UNLABELED_DATA_SSL"!==e.node_search_tasks[a-1].type?console.log("Warning: Detected a policy with fit captured and SSL node missing."):t=a-2);for(var n=t;n>=0;n--){var l=e.node_search_tasks[n];if(K(l))return l}return null}(e);return null===a?-1:z(a,a.node_optimal_scalar_map)},ge=function(e){return e.fit_was_captured?e.learned_policy_val_metrics.loss:(console.log("Cannot get Masterful teacher val loss, fit was not captured."),-1)},ve=function(e){var a="",t=e.type;if("SYNTHETIC_DATA_BLENDING"===t)a="Synthetic Data";else if("UNLABELED_DATA_SSL"===t)a="SSL";else if(t===H){if("MASTERFUL_SAMPLE_MAG_BY_QUANTILE_LAYER"===e.searched_layers[0].layer_type){var n,l=[],r=Object(V.a)(e.searched_layers);try{for(r.s();!(n=r.n()).done;){var i=n.value.name;if(-1!==i.indexOf("masterful")){var o=i.split("_").slice(1).join(" ");l.push(o)}else l.push(i)}}catch(s){r.e(s)}finally{r.f()}var c=l.join(" & ");a=c.length<=25?c:c.slice(0,25)}else a=e.searched_layers[0].ordered_actions[0]}else a=e.title;return a.toLowerCase()},ye=function(e){var a=e.learned_policy_val_metrics.label_recall_map;if(Q(e)){var t=e.node_search_tasks.length,n=e.node_search_tasks[t-1];if("UNLABELED_DATA_SSL"!==n.type)console.log("Expected last node to be SSL, instead got: ",n.type),console.log("Will use Masterful teacher fit training result instead.");else{var l,r=Object(V.a)(n.val_metrics);try{for(r.s();!(l=r.n()).done;){var i=l.value;if(Y.a.isEqual(i.node_scalar_map,n.node_optimal_scalar_map)){a=i.metrics.label_recall_map;break}}}catch(o){r.e(o)}finally{r.f()}}}return a},Ee=function(e){var a=e.learned_policy_val_metrics.label_precision_map;if(Q(e)){var t=e.node_search_tasks.length,n=e.node_search_tasks[t-1];if("UNLABELED_DATA_SSL"!==n.type)console.log("Expected last node to be SSL, instead got: ",n.type),console.log("Will use Masterful teacher fit training result instead.");else{var l,r=Object(V.a)(n.val_metrics);try{for(r.s();!(l=r.n()).done;){var i=l.value;if(Y.a.isEqual(i.node_scalar_map,n.node_optimal_scalar_map)){a=i.metrics.label_precision_map;break}}}catch(o){r.e(o)}finally{r.f()}}}return a},_e=function(e){var a={errPlotData:null,errReductionRate:null},t=be(e.presearch_model_val_metrics.confusion_matrix);if(-1===t)return console.error("Cannot create error rate plot: baseline confusion matrix missing."),a;var n=0;if(Q(e)){var l=e.node_search_tasks.length,r=e.node_search_tasks[l-1],i=function(e,a){var t,n=null,l=Object(V.a)(e.val_metrics);try{for(l.s();!(t=l.n()).done;){var r=t.value;if(Y.a.isEqual(r.node_scalar_map,a)){n=r.metrics.confusion_matrix;break}}}catch(i){l.e(i)}finally{l.f()}return null==n&&console.log("No confusion matrix found for scalar: ".concat(a," in task: ").concat(e.title)),n}(r,r.node_optimal_scalar_map);n=be(i)}else n=be(e.learned_policy_val_metrics.confusion_matrix);if(-1===n)return console.error("Failed calculating error rate, final error rate unavailable."),a;var o=W(t,t-n);o=Math.floor(100*o)/100;var c=[],s={Model:"Basline"};s["Error Rate"]=Math.floor(100*t)/100,c.push(s);var m={Model:"Masterful"};return m["Error Rate"]=Math.floor(100*n)/100,c.push(m),{errPlotData:c,errReductionRate:o}},be=function(e){var a=Ae(e);if(-1===a)return console.log("Failed computing error rate."),-1;for(var t=Object.keys(e).length,n=0,l=0;l<t;l++){var r=0;e[l].values.forEach((function(e){return r+=e})),n+=r}return 0===n?(console.log("Failed computing error rate, totalSum is 0 for: ",e),-1):100*(1-a/n)},Ae=function(e){if(void 0==e)return console.log("Failed computing true positives, no confusion matrix."),-1;for(var a=0,t=Object.keys(e).length,n=0;n<t;n++){if(void 0==e[n])return console.log("Invalid confusion matrix, no data for class: ",n," in: ",e),-1;a+=e[n].values[n]}return a},ke=function(e,a){var t=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"",n=!(arguments.length>3&&void 0!==arguments[3])||arguments[3],l="",r="";if(r=n&&-1!==e.toLowerCase().indexOf("masterful")?e.split("_").slice(1).join(" "):e,a===H)l="MASTERFUL_REPLACEMENT_RATE_LAYER"===t?"(rr)":"(m)";else{if("SYNTHETIC_DATA_BLENDING"!==a)return"UNLABELED_DATA_SSL"===a?"SSL":r;l="(r)"}return String(r.toLowerCase()+" "+l)},xe=function(e){var a=[],t=e.presearch_model_val_metrics.loss;a.push(t);var n,l=Object(V.a)(e.node_search_tasks);try{for(l.s();!(n=l.n()).done;){var r,i=n.value,o=G(i),c=Object(V.a)(o);try{for(c.s();!(r=c.n()).done;){var s=r.value,m=z(i,s);-1!==m&&a.push(m)}}catch(u){c.e(u)}finally{c.f()}}}catch(u){l.e(u)}finally{l.f()}return a.sort(),{minValLoss:a[0],maxValLoss:a[a.length-1]}},Ne=function(e,a){var t=e;if(a.includes(t))for(var n=1;a.includes(t);)t=String(e+"_"+n),n++;return t},Se=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"",a=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"",t=0,n=1;return a===H&&("MASTERFUL_SAMPLE_MAG_BY_QUANTILE_LAYER"!==e&&"MASTERFUL_FIXED_MAG_LAYER"!==e||(n=100)),{min:t,max:n}},Pe=function(e){var a,t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],n=e.presearch_model_val_metrics.loss,l=[],r=Object(V.a)(e.node_search_tasks);try{for(r.s();!(a=r.n()).done;){var i=a.value;l=l.concat(J(i,i.node_optimal_scalar_map,t))}}catch(s){r.e(s)}finally{r.f()}var o=e.node_search_tasks.length-1,c=z(e.node_search_tasks[o],e.node_search_tasks[o].node_optimal_scalar_map);if(-1===c)for(;-1===c;){if(-1===(o-=1)){c=n;break}c=z(e.node_search_tasks[o],e.node_search_tasks[o].node_optimal_scalar_map)}return l.push(c),l.push("SELECTED"),l},we=function(e,a){if(e.length!==a.length)return console.log("Number of action keys (".concat(e.length,") and values (").concat(a.length,") should be identical.")),[];for(var t=[],n=0;n<e.length;n++){var l=e[n],r=a[n];t[l]="masterful_unlabeled_switch"===l?Oe(r):r}return t},Oe=function(e){return 0===e?"OFF":"ON"},Le=function(e){return e.filter((function(e){return!0===e.fit_was_captured}))},Me=function(e){return null!==e&&"CLASSIFICATION"===e.task_type},Be=function(e){Object(B.a)(t,e);var a=Object(R.a)(t);function t(e){var n;return Object(L.a)(this,t),(n=a.call(this,e)).state={selectedPolicyIndex:null,policySearchTasks:[],intervalId:null},n}return Object(M.a)(t,[{key:"sync_",value:function(){var e=this;D.a.get(String(ae+"scan/"),{headers:te}).then((function(e){return D.a.get(String(ae+"api/search/"),{headers:te})})).then((function(a){var t;if(a.data.length>0){var n=a.data.slice();e.setState({policySearchTasks:(t=Le(n),t.filter((function(e){return Me(e)})))})}})).catch((function(e){return console.log(e)}))}},{key:"componentDidMount",value:function(){var e=this;this.sync_();var a=setInterval((function(){e.sync_()}),6e5);this.setState({intervalId:a})}},{key:"componentWillUnmount",value:function(){null!==this.state.intervalId&&(clearInterval(this.state.intervalId),this.setState({intervalId:null}))}},{key:"render",value:function(){var e=this,a={policyName:"",policyEngine:"",plotVariables:[],actionKeys:[],recallByClassData:[],precisionByClassData:[],waterfallChartKeys:[],waterfallChartData:[],waterfallChartMaxVal:1,recallMin:0,recallMax:100,precisionMin:0,precisionMax:100,errorRateReductionValue:0,errorRateReductionData:[]},t=[];if(0!==this.state.policySearchTasks.length&&null!==this.state.selectedPolicyIndex){var n=this.state.selectedPolicyIndex,r=this.state.policySearchTasks[n],i=function(e,a){var t,n=[],l=[],r=Object(V.a)(e.node_search_tasks);try{for(r.s();!(t=r.n()).done;){var i=t.value,o=i.type;if(o===H){var c=i.searched_layers[0].layer_type;if(a&&"MASTERFUL_SAMPLE_MAG_BY_QUANTILE_LAYER"===c){var s,m=Object(V.a)(i.searched_layers);try{for(m.s();!(s=m.n()).done;){var u=s.value,d=u.name;l.push(d);var f=Se(c,o),h=f.min,p=f.max;n.push({actionKey:d,actionLegend:ke(d.toUpperCase(),o,u.layer_type),min:h,max:p})}}catch(R){m.e(R)}finally{m.f()}}else{var g,v=Object(V.a)(i.searched_layers);try{for(v.s();!(g=v.n()).done;)for(var y=g.value,E=y.ordered_actions.length,_=0;_<E;_++){var b=y.ordered_actions[_],A=Ne(b,l);l.push(A);var k=Se(c,o),x=k.min,N=k.max;n.push({actionKey:A,actionLegend:ke(b,o,c),min:x,max:N})}}catch(R){v.e(R)}finally{v.f()}}}else{var S=Ne(i.title,l);if(l.push(S),"UNLABELED_DATA_SSL"===o)n.push({actionKey:S,actionLegend:ke(i.title,o),values:["ON","OFF"]});else{var P=Se("",o),w=P.min,O=P.max;n.push({actionKey:S,actionLegend:ke(i.title,o),min:w,max:O})}}}}catch(R){r.e(R)}finally{r.f()}var L=xe(e),M=L.minValLoss,B=L.maxValLoss;return n.push({actionKey:"val_loss",actionLegend:"val_loss",min:M-.05,max:B+.05}),n.push({actionKey:"selected",actionLegend:"Optimal Policy",values:["SELECTED","NOT SELECTED"]}),l.push("val_loss"),l.push("selected"),{currentPlotVariables:n,actionKeysSoFar:l}}(r,!0),o=i.actionKeysSoFar,c=i.currentPlotVariables;a.policyName=r.policy_name,a.policyEngine=r.engine_version,a.plotVariables=c,a.actionKeys=o,a.waterfallChartKeys=["lowerPart","impValue","upperPart"],a.waterfallChartData=function(e){var a=ue(e),t=pe(e),n=fe(e,a,a-t),l=ge(e),r=l,i=de(n,a-l);if(Q(e)){var o=e.node_search_tasks.length,c=e.node_search_tasks[o-1],s=me(c);i[ve(c)]=l-s,r=s}return se(a,r,i)}(r),a.waterfallChartMaxVal=r.presearch_model_val_metrics.loss,t=(t=function(e,a,t){var n=[],l=Pe(e,t);n.push(we(a,l));var r,i=[],o=Object(V.a)(e.node_search_tasks);try{for(o.s();!(r=o.n()).done;){var c,s=r.value,m=G(s),u=Object(V.a)(m);try{for(u.s();!(c=u.n()).done;){var d=c.value;if(!_.isEqual(d,s.node_optimal_scalar_map)){var f=[];f=f.concat(i);var h=J(s,d,t);f=f.concat(h);var p=a.length-f.length-2;if(p>0){var g=new Array(p).fill(0);f=f.concat(g)}var v=z(s,d);f.push(v),f.push("NOT SELECTED"),n.push(we(a,f))}}}catch(y){u.e(y)}finally{u.f()}i=i.concat(J(s,s.node_optimal_scalar_map,t))}}catch(y){o.e(y)}finally{o.f()}return n}(r,o,!0)).reverse();var s=function(e){if(!e.fit_was_captured)return console.error("Fit must be captured to comput recall by class data."),[];var a=e.presearch_model_val_metrics.label_recall_map;if(!a)return console.error("Baseline metrics unavailable. Label recall failed."),[];var t=ye(e);if(!t)return console.error("Failed getting final recall map for policy: ",e),[];if(Object.keys(a).length!==Object.keys(t).length)return console.error("BaselineRecallMap & finalRecallMap must same amount : "),[];for(var n=[],l=0;l<Object.keys(a).length;l++){var r={};r.classLabel=l,r.Basline=Math.floor(1e4*a[l])/100,r.Masterful=Math.floor(1e4*t[l])/100,n.push(r)}return n}(r);a.recallByClassData=s;var m=function(e){if(!e.fit_was_captured)return console.error("Fit must be captured to comput precision by class data."),[];var a=e.presearch_model_val_metrics.label_precision_map;if(!a)return console.error("Baseline metrics unavailable. Label precision failed."),[];var t=Ee(e);if(!t)return console.error("Failed getting final precision map for policy: ",e),[];if(Object.keys(a).length!==Object.keys(t).length)return console.error("baselinePrecisionMap & finalPrecisionMap must same amount : "),[];for(var n=[],l=0;l<Object.keys(a).length;l++){var r={};r.classLabel=l,r.Basline=Math.floor(1e4*a[l])/100,r.Masterful=Math.floor(1e4*t[l])/100,n.push(r)}return n}(r);a.precisionByClassData=m;var u=function(e){if(null===e||0===e.length)return{recallMin:0,recallMax:100};var a,t=100,n=0,l=Object(V.a)(e);try{for(l.s();!(a=l.n()).done;){var r=a.value;if(0!==r["Baseline Recall"]){r["Baseline Recall"]<t&&(t=r["Baseline Recall"]);var i=0;void 0===r["Worse Recall"]?i+=r["Baseline Recall"]+r["Better Recall"]:i+=r["Actual Baseline Recall"],i>n&&(n=i)}}}catch(o){l.e(o)}finally{l.f()}return{recallMin:t=Math.max(0,t-2),recallMax:n=Math.min(100,n+2)}}(s),d=u.recallMin,f=u.recallMax,h=function(e){if(null===e||0===e.length)return{precisionMin:0,precisionMax:100};var a,t=100,n=0,l=Object(V.a)(e);try{for(l.s();!(a=l.n()).done;){var r=a.value;if(0!==r["Baseline Precision"]){r["Baseline Precision"]<t&&(t=r["Baseline Precision"]);var i=0;void 0===r["Worse Precision"]?i+=r["Baseline Precision"]+r["Better Precision"]:i+=r["Actual Baseline Precision"],i>n&&(n=i)}}}catch(o){l.e(o)}finally{l.f()}return{precisionMin:t=Math.max(0,t-2),precisionMax:n=Math.min(100,n+2)}}(m),p=h.precisionMin,g=h.precisionMax;a.recallMin=Math.min(d,p),a.recallMax=Math.max(f,g),a.precisionMin=Math.min(d,p),a.precisionMax=Math.max(f,g);var v=_e(r),y=v.errPlotData,E=v.errReductionRate;a.errorRateReductionValue=E,a.errorRateReductionData=y}var b=function(a){var t=e.state.policySearchTasks.findIndex((function(e){return e.policy_name===a}));e.setState({selectedPolicyIndex:t})};return null!==this.state.selectedPolicyIndex?l.a.createElement(l.a.Fragment,null,l.a.createElement(T.a,{className:"justify-content-md-center",style:{marginTop:12,marginBottom:12}},l.a.createElement(j.a,null,l.a.createElement(X,{policies:this.state.policySearchTasks,onTableRowClick:b}))),l.a.createElement(T.a,{className:"justify-content-md-center",style:{marginTop:12,marginBottom:12}},l.a.createElement(j.a,null,l.a.createElement(oe,{title:"Validation Loss Improvement",policyName:a.policyName,policyEngine:a.policyEngine,data:a.waterfallChartData,keys:a.waterfallChartKeys,maxVal:a.waterfallChartMaxVal})),l.a.createElement(j.a,null,function(){if(null!=a.errorRateReductionData)return l.a.createElement(ce,{policyName:a.policyName,policyEngine:a.policyEngine,data:a.errorRateReductionData,reductionRate:a.errorRateReductionValue})}())),l.a.createElement(T.a,{className:"justify-content-md-center",style:{marginTop:12,marginBottom:12}},l.a.createElement(j.a,null,function(){if(a.recallByClassData.length>0)return l.a.createElement(le,{title:"Recall Improvement",policyName:a.policyName,policyEngine:a.policyEngine,data:a.recallByClassData,min:a.recallMin,max:a.recallMax})}()),l.a.createElement(j.a,null,function(){if(a.precisionByClassData.length>0)return l.a.createElement(re,{title:"Precision Improvement",policyName:a.policyName,policyEngine:a.policyEngine,data:a.precisionByClassData,min:a.precisionMin,max:a.precisionMax})}())),l.a.createElement(T.a,{className:"justify-content-md-center",style:{marginTop:12,marginBottom:12,width:"50.8%",minWidth:800}},l.a.createElement(j.a,null,l.a.createElement(ne,{title:"Policy Components",policyName:a.policyName,policyEngine:a.policyEngine,plotVariables:a.plotVariables,plotData:t})))):l.a.createElement(l.a.Fragment,null,l.a.createElement(T.a,null,l.a.createElement(j.a,null,l.a.createElement(X,{policies:this.state.policySearchTasks,onTableRowClick:b}))))}}]),t}(l.a.Component),Re=function(e){Object(B.a)(t,e);var a=Object(R.a)(t);function t(e){return Object(L.a)(this,t),a.call(this,e)}return Object(M.a)(t,[{key:"render",value:function(){return l.a.createElement(l.a.Fragment,null,l.a.createElement("iframe",{src:" https://masterful-public.s3.us-west-1.amazonaws.com/933013963/0.3.5/index.html",title:"Documentation",width:"100%",height:"2000"}))}}]),t}(l.a.Component),Te=function(e){var a=e.component,t=Object(s.a)(e,["component"]),r=Object(n.useState)(!1),i=Object(c.a)(r,2),o=i[0],u=i[1];Object(n.useEffect)((function(){var e=setTimeout((function(){return u(!0)}),1e3);return function(){return clearTimeout(e)}}),[]);var d=Object(n.useState)((function(){return"false"!==localStorage.getItem("settingsVisible")})),f=Object(c.a)(d,2);f[0],f[1];return l.a.createElement(m.b,Object.assign({},t,{render:function(e){return l.a.createElement(l.a.Fragment,null,l.a.createElement(h,{show:!o}),l.a.createElement(O,null),l.a.createElement("main",{className:"content"},l.a.createElement(a,e)))}}))},je=function(){return l.a.createElement(m.d,null,l.a.createElement(Te,{exact:!0,path:P.path,component:Be}),l.a.createElement(Te,{exact:!0,path:w.path,component:Re}),l.a.createElement(m.a,{to:P.path}))},Ce=function(){var e=Object(m.g)().pathname;return Object(n.useEffect)((function(){window.scrollTo({top:0,left:0,behavior:"auto"})}),[e]),null};i.a.render(l.a.createElement(o.a,null,l.a.createElement(Ce,null),l.a.createElement(je,null)),document.getElementById("root"))}},[[386,1,2]]]);
//# sourceMappingURL=main.3e864282.chunk.js.map