/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.util.net.EasySSLProtocolSocketFactory;
import ucar.nc2.util.net.HTTPAuthScheme;
import ucar.nc2.util.net.HTTPAuthStore;
import ucar.nc2.util.net.HTTPBasicProvider;
import ucar.nc2.util.net.HTTPCredsProvider;
import ucar.nc2.util.net.HTTPException;
import ucar.nc2.util.net.HTTPMethod;
import ucar.nc2.util.net.HTTPSSLProvider;

@NotThreadSafe
public class HTTPSession {
    public static final HTTPAuthScheme BASIC = HTTPAuthScheme.BASIC;
    public static final HTTPAuthScheme DIGEST = HTTPAuthScheme.DIGEST;
    public static final HTTPAuthScheme NTLM = HTTPAuthScheme.NTLM;
    public static final HTTPAuthScheme SSL = HTTPAuthScheme.SSL;
    public static int SC_NOT_FOUND = 404;
    public static int SC_UNAUTHORIZED = 401;
    public static int SC_OK = 200;
    public static String CONNECTION_TIMEOUT = "http.connection.timeout";
    public static String SO_TIMEOUT = "http.socket.timeout";
    public static String ALLOW_CIRCULAR_REDIRECTS = "http.protocol.allow-circular-redirects";
    public static String MAX_REDIRECTS = "http.protocol.max-redirects";
    public static String USER_AGENT = "http.useragent";
    public static String PROTOCOL_VERSION = "http.protocol.version";
    public static String VIRTUAL_HOST = "http.virtual-host";
    public static String USE_EXPECT_CONTINUE = "http.protocol.expect-continue";
    public static String STRICT_TRANSFER_ENCODING = "http.protocol.strict-transfer-encoding";
    public static String HTTP_ELEMENT_CHARSET = "http.protocol.element-charset";
    public static String HTTP_CONTENT_CHARSET = "http.protocol.content-charset";
    public static String HTTP_CONNECTION = "<undefined>";
    public static String HTTP_PROXY_HOST = "<undefined>";
    public static String HTTP_REQ_SENT = "<undefined>";
    public static String HTTP_REQUEST = "<undefined>";
    public static String HTTP_RESPONSE = "<undefined>";
    public static String HTTP_TARGET_HOST = "<undefined>";
    public static String ORIGIN_SERVER = "<undefined>";
    public static String WAIT_FOR_CONTINUE = "<undefined>";
    static int DFALTTHREADCOUNT = 50;
    static int DFALTTIMEOUT = 300000;
    public static Logger log = LoggerFactory.getLogger(HTTPSession.class);
    static MultiThreadedHttpConnectionManager connmgr;
    static String globalAgent;
    static int threadcount;
    static boolean globalauthpreemptive;
    static int globalSoTimeout;
    static int globalConnectionTimeout;
    static Proxy globalproxy;
    static List<ProtocolEntry> registry;
    HttpClient sessionClient = null;
    List<HTTPMethod> methodList = new Vector<HTTPMethod>();
    HttpState context = null;
    String identifier = "Session";
    String useragent = null;
    String legalurl = null;
    boolean closed = false;
    static List<HTTPSession> sessionList;
    public static boolean TESTING;

    public static synchronized void setGlobalUserAgent(String _userAgent) {
        globalAgent = _userAgent;
    }

    public static String getGlobalUserAgent() {
        return globalAgent;
    }

    public static void setGlobalThreadCount(int nthreads) {
        connmgr.getParams().setMaxTotalConnections(nthreads);
        connmgr.getParams().setDefaultMaxConnectionsPerHost(nthreads);
    }

    public static void setGlobalMaxConnections(int nthreads) {
        HTTPSession.setGlobalThreadCount(nthreads);
    }

    public static int getGlobalThreadCount() {
        return connmgr.getParams().getMaxTotalConnections();
    }

    public static Cookie[] getGlobalCookies() {
        HttpClient client2 = new HttpClient((HttpConnectionManager)connmgr);
        Cookie[] cookies = client2.getState().getCookies();
        return cookies;
    }

    public static synchronized void registerProtocol(String protocol, int port, Protocol handler) throws IllegalArgumentException {
        if (protocol == null) {
            throw new IllegalArgumentException();
        }
        if (port < 0) {
            port = 0;
        }
        if (port == 0) {
            if (handler == null) {
                Protocol.unregisterProtocol((String)protocol);
            } else {
                Protocol.registerProtocol((String)protocol, (Protocol)handler);
            }
        } else {
            for (int i = 0; i < registry.size(); ++i) {
                ProtocolEntry entry = registry.get(i);
                if (!entry.protocol.equals(protocol) || entry.port != port) continue;
                if (handler == null) {
                    registry.remove(i);
                } else {
                    entry.handler = handler;
                }
                return;
            }
            registry.add(new ProtocolEntry(protocol, port, handler));
        }
    }

    public static synchronized Protocol getProtocol(String protocol, int port) throws IllegalArgumentException, IllegalStateException {
        ProtocolEntry entry = null;
        if (protocol == null) {
            throw new IllegalArgumentException();
        }
        if (port < 0) {
            port = 0;
        }
        if (port == 0) {
            return Protocol.getProtocol((String)protocol);
        }
        for (int i = 0; i < registry.size(); ++i) {
            entry = registry.get(i);
            if (!entry.protocol.equals(protocol) || entry.port != port) continue;
            return entry.handler;
        }
        Protocol p = Protocol.getProtocol((String)protocol);
        if (p == null) {
            throw new IllegalStateException();
        }
        return p;
    }

    public static void setConnectionManagerTimeout(int timeout) {
        HTTPSession.setGlobalConnectionTimeout(timeout);
    }

    public static void setGlobalConnectionTimeout(int timeout) {
        connmgr.getParams().setConnectionTimeout(timeout);
    }

    public static void setGlobalSoTimeout(int timeout) {
        globalSoTimeout = timeout;
    }

    public static synchronized void setGlobalProxy(String host, int port) {
        if (globalproxy == null) {
            globalproxy = new Proxy();
            HTTPSession.globalproxy.host = host;
            HTTPSession.globalproxy.port = port;
        }
    }

    public static synchronized void setGlobalAuthenticationPreemptive(boolean tf) {
        globalauthpreemptive = tf;
    }

    private static synchronized void defineCredentialsProvider(HTTPAuthScheme scheme, String url, CredentialsProvider provider) {
        try {
            if (provider == null) {
                HTTPAuthStore.remove(new HTTPAuthStore.Entry(scheme, url, provider));
            } else {
                HTTPAuthStore.insert(new HTTPAuthStore.Entry(scheme, url, provider));
            }
        }
        catch (HTTPException he) {
            log.error("HTTPSession.setCredentialsProvider failed");
        }
    }

    public static void setAnyCredentialsProvider(HTTPAuthScheme scheme, String url, CredentialsProvider provider) {
        HTTPSession.defineCredentialsProvider(scheme, url, provider);
    }

    public static void setGlobalCredentialsProvider(HTTPAuthScheme scheme, CredentialsProvider provider) {
        HTTPSession.setAnyCredentialsProvider(scheme, "", provider);
    }

    public static void setGlobalCredentialsProvider(CredentialsProvider provider) {
        HTTPSession.setGlobalCredentialsProvider(HTTPAuthStore.DEFAULT_SCHEME, provider);
    }

    public static void setGlobalCredentialsProvider(String url) {
        String userinfo = HTTPSession.getUserinfo(url);
        if (userinfo != null) {
            int index = userinfo.indexOf(58);
            String user = userinfo.substring(index);
            String pwd = userinfo.substring(index + 1, userinfo.length());
            if (user != null && pwd != null) {
                HTTPBasicProvider bp = new HTTPBasicProvider(user, pwd);
                HTTPSession.setGlobalCredentialsProvider(HTTPAuthScheme.BASIC, bp);
            }
        }
    }

    public static void setGlobalCredentials(HTTPAuthScheme scheme, Credentials creds) {
        HTTPCredsProvider provider = new HTTPCredsProvider(creds);
        HTTPSession.defineCredentialsProvider(scheme, "", provider);
    }

    static String getUserinfo(String surl) {
        try {
            URL url = new URL(surl);
            return url.getUserInfo();
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    public static String getCanonicalURL(String legalurl) {
        if (legalurl == null) {
            return null;
        }
        int index = legalurl.indexOf(63);
        if (index >= 0) {
            legalurl = legalurl.substring(0, index);
        }
        return HTTPSession.canonicalpath(legalurl);
    }

    public static String canonicalpath(String path) {
        if (path == null) {
            return null;
        }
        if ((path = path.replace('\\', '/')).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String removeprincipal(String u) {
        String newurl = null;
        try {
            URL url = new URL(u);
            String protocol = url.getProtocol() + "://";
            String host = url.getHost();
            int port = url.getPort();
            String path = url.getPath();
            String query = url.getQuery();
            String ref = url.getRef();
            String sport = port <= 0 ? "" : ":" + port;
            path = path == null ? "" : path;
            query = query == null ? "" : "?" + query;
            ref = ref == null ? "" : "#" + ref;
            newurl = protocol + host + sport + path + query + ref;
        }
        catch (MalformedURLException use) {
            newurl = u;
        }
        return newurl;
    }

    public static String getUrlAsString(String url) throws HTTPException {
        HTTPSession session = new HTTPSession(url);
        HTTPMethod m = HTTPMethod.Get(session);
        int status = m.execute();
        String content = null;
        if (status == 200) {
            content = m.getResponseAsString();
        }
        m.close();
        return content;
    }

    public static int putUrlAsString(String content, String url) throws HTTPException {
        HTTPSession session = new HTTPSession(url);
        HTTPMethod m = HTTPMethod.Put(session);
        m.setRequestContentAsString(content);
        int status = m.execute();
        m.close();
        return status;
    }

    static String getstorepath(String prefix) {
        String path = System.getProperty(prefix + "store");
        if (path != null && (path = path.trim()).length() == 0) {
            path = null;
        }
        return path;
    }

    static String getpassword(String prefix) {
        String password = System.getProperty(prefix + "storepassword");
        if (password != null && (password = password.trim()).length() == 0) {
            password = null;
        }
        return password;
    }

    static String cleanproperty(String property) {
        String value = System.getProperty(property);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    static synchronized void setGlobalKeyStore() {
        String keypassword = HTTPSession.cleanproperty("keystorepassword");
        String keypath = HTTPSession.cleanproperty("keystore");
        String trustpassword = HTTPSession.cleanproperty("truststorepassword");
        String trustpath = HTTPSession.cleanproperty("truststore");
        if (keypath != null || trustpath != null) {
            HTTPSSLProvider sslprovider = new HTTPSSLProvider(keypath, keypassword, trustpath, trustpassword);
            HTTPSession.setAnyCredentialsProvider(HTTPAuthScheme.SSL, "", sslprovider);
        }
    }

    static void getGlobalProxyD() {
        Proxy proxy = new Proxy();
        String host = System.getProperty("http.proxyHost");
        String port = System.getProperty("http.proxyPort");
        int portno = -1;
        if (host != null && (host = host.trim()).length() == 0) {
            host = null;
        }
        if (port != null && (port = port.trim()).length() > 0) {
            try {
                portno = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                portno = -1;
            }
        }
        if (host != null) {
            proxy.host = host;
            proxy.port = portno;
            globalproxy = proxy;
        }
    }

    public HTTPSession(String legalurl) throws HTTPException {
        this.construct(legalurl);
    }

    public HTTPSession() throws HTTPException {
        this(null);
    }

    protected void construct(String legalurl) throws HTTPException {
        this.legalurl = legalurl;
        try {
            this.sessionClient = new HttpClient((HttpConnectionManager)connmgr);
            HttpClientParams clientparams = this.sessionClient.getParams();
            clientparams.setParameter(ALLOW_CIRCULAR_REDIRECTS, (Object)true);
            clientparams.setParameter(MAX_REDIRECTS, (Object)25);
            if (globalSoTimeout > 0) {
                this.setSoTimeout(globalSoTimeout);
            }
            if (globalConnectionTimeout > 0) {
                this.setConnectionTimeout(globalConnectionTimeout);
            }
            if (globalAgent != null) {
                this.setUserAgent(globalAgent);
            }
            this.setAuthenticationPreemptive(globalauthpreemptive);
            this.setProxy();
            if (TESTING) {
                HTTPSession.track(this);
            }
        }
        catch (Exception e) {
            throw new HTTPException("url=" + legalurl, e);
        }
    }

    public String getURL() {
        return this.legalurl;
    }

    public void setUserAgent(String agent) {
        this.useragent = agent;
        if (this.useragent != null && this.sessionClient != null) {
            this.sessionClient.getParams().setParameter(USER_AGENT, (Object)this.useragent);
        }
    }

    public void setAuthenticationPreemptive(boolean tf) {
        if (this.sessionClient != null) {
            this.sessionClient.getParams().setAuthenticationPreemptive(tf);
        }
    }

    public void setSoTimeout(int timeout) {
        this.sessionClient.getParams().setSoTimeout(timeout);
    }

    public void setConnectionTimeout(int timeout) {
        this.sessionClient.setConnectionTimeout(timeout);
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        while (this.methodList.size() > 0) {
            HTTPMethod m = this.methodList.get(0);
            m.close();
        }
        this.closed = true;
    }

    public String getCookiePolicy() {
        return this.sessionClient == null ? null : this.sessionClient.getParams().getCookiePolicy();
    }

    public Cookie[] getCookies() {
        if (this.sessionClient == null) {
            return null;
        }
        Cookie[] cookies = this.sessionClient.getState().getCookies();
        return cookies;
    }

    synchronized void addMethod(HTTPMethod m) {
        if (!this.methodList.contains(m)) {
            this.methodList.add(m);
        }
    }

    synchronized void removeMethod(HTTPMethod m) {
        this.methodList.remove(m);
    }

    public void setMaxRedirects(int n) {
        HttpClientParams clientparams = this.sessionClient.getParams();
        clientparams.setParameter(MAX_REDIRECTS, (Object)n);
    }

    public void setContext(HttpState cxt) {
        this.context = cxt;
    }

    public HttpState getContext() {
        return this.context;
    }

    public void clearState() {
        this.sessionClient.getState().clearCookies();
        this.sessionClient.getState().clearCredentials();
    }

    void setProxy(Proxy proxy) {
        if (this.sessionClient == null) {
            return;
        }
        if (proxy != null && proxy.host != null) {
            this.sessionClient.getHostConfiguration().setProxy(proxy.host, proxy.port);
        }
    }

    void setProxy() {
        if (globalproxy == null) {
            return;
        }
        this.setProxy(globalproxy);
    }

    public void setProxy(String host, int port) {
        Proxy proxy = new Proxy();
        proxy.host = host;
        proxy.port = port;
        this.setProxy(proxy);
    }

    public void setCredentialsProvider(HTTPAuthScheme scheme, CredentialsProvider provider) {
        HTTPSession.defineCredentialsProvider(scheme, this.legalurl, provider);
    }

    public void setCredentialsProvider(CredentialsProvider provider) {
        this.setCredentialsProvider(HTTPAuthStore.DEFAULT_SCHEME, provider);
    }

    public void setCredentialsProvider(String url) {
        String userinfo = HTTPSession.getUserinfo(url);
        if (userinfo != null) {
            int index = userinfo.indexOf(58);
            String user = userinfo.substring(index);
            String pwd = userinfo.substring(index + 1, userinfo.length());
            if (user != null && pwd != null) {
                HTTPBasicProvider bp = new HTTPBasicProvider(user, pwd);
                this.setCredentialsProvider(HTTPAuthScheme.BASIC, bp);
            }
        }
    }

    public void setCredentials(HTTPAuthScheme scheme, Credentials creds) {
        HTTPCredsProvider provider = new HTTPCredsProvider(creds);
        HTTPSession.defineCredentialsProvider(scheme, this.legalurl, provider);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getMethodcount() {
        return this.methodList.size();
    }

    private static synchronized void kill() {
        if (sessionList != null) {
            for (HTTPSession session : sessionList) {
                session.close();
            }
            sessionList.clear();
            connmgr.shutdown();
            connmgr = new MultiThreadedHttpConnectionManager();
            HTTPSession.setGlobalThreadCount(DFALTTHREADCOUNT);
        }
    }

    private static synchronized void track(HTTPSession session) {
        if (sessionList == null) {
            sessionList = new ArrayList<HTTPSession>();
        }
        sessionList.add(session);
    }

    static {
        globalAgent = "/NetcdfJava/HttpClient3";
        threadcount = DFALTTHREADCOUNT;
        globalauthpreemptive = false;
        globalSoTimeout = 0;
        globalConnectionTimeout = 0;
        globalproxy = null;
        connmgr = new MultiThreadedHttpConnectionManager();
        HTTPSession.setGlobalThreadCount(DFALTTHREADCOUNT);
        registry = new ArrayList<ProtocolEntry>();
        HTTPSession.registerProtocol("https", 0, new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443));
        HTTPSession.registerProtocol("https", 8443, new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 8443));
        HTTPSession.setGlobalConnectionTimeout(DFALTTIMEOUT);
        HTTPSession.setGlobalSoTimeout(DFALTTIMEOUT);
        HTTPSession.getGlobalProxyD();
        HTTPSession.setGlobalKeyStore();
        sessionList = null;
        TESTING = false;
    }

    static class ProtocolEntry {
        public String protocol = null;
        public int port = 0;
        public Protocol handler;

        public ProtocolEntry(String protocol, int port, Protocol handler) {
            this.protocol = protocol;
            this.port = port;
            this.handler = handler;
        }
    }

    static enum Methods {
        Get("get"),
        Head("head"),
        Put("put"),
        Post("post"),
        Options("options");

        private final String name;

        private Methods(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    static class Proxy {
        String host = null;
        int port = -1;

        Proxy() {
        }
    }
}

