/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.EnhanceScaleMissing;
import ucar.nc2.dataset.EnhanceScaleMissingImpl;
import ucar.nc2.dataset.EnhancementsImpl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.util.CancelTask;

public class VariableDS
extends Variable
implements VariableEnhanced,
EnhanceScaleMissing {
    private EnhancementsImpl enhanceProxy;
    private EnhanceScaleMissingImpl scaleMissingProxy;
    private EnumSet<NetcdfDataset.Enhance> enhanceMode;
    private boolean needScaleOffsetMissing = false;
    private boolean needEnumConversion = false;
    protected Variable orgVar;
    protected DataType orgDataType;
    protected String orgName;

    public VariableDS(NetcdfDataset ds, Group group, Structure parentStructure, String shortName, DataType dataType, String dims, String units, String desc) {
        super(ds, group, parentStructure, shortName);
        this.setDataType(dataType);
        this.setDimensions(dims);
        if (dataType == DataType.STRUCTURE) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + shortName);
        }
        if (units != null) {
            this.addAttribute(new Attribute("units", units));
        }
        if (desc != null) {
            this.addAttribute(new Attribute("long_name", desc));
        }
        this.enhanceProxy = new EnhancementsImpl(this, units, desc);
        this.scaleMissingProxy = new EnhanceScaleMissingImpl();
    }

    public VariableDS(Group group, Structure parent, String shortName, Variable orgVar) {
        super(null, group, parent, shortName);
        this.setDimensions(this.getDimensionsString());
        if (orgVar instanceof Structure) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + orgVar.getFullName());
        }
        this.ncfile = null;
        this.spiObject = null;
        this.createNewCache();
        this.orgVar = orgVar;
        this.orgDataType = orgVar.getDataType();
        this.enhanceProxy = new EnhancementsImpl(this);
        this.scaleMissingProxy = new EnhanceScaleMissingImpl();
    }

    public VariableDS(Group g, Variable orgVar, boolean enhance) {
        super(orgVar);
        if (g != null) {
            this.setParentGroup(g);
        }
        this.setDimensions(this.getDimensionsString());
        if (orgVar instanceof Structure) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + orgVar.getFullName());
        }
        this.ncfile = null;
        this.spiObject = null;
        this.createNewCache();
        this.orgVar = orgVar;
        this.orgDataType = orgVar.getDataType();
        if (orgVar instanceof VariableDS) {
            VariableDS ncVarDS = (VariableDS)orgVar;
            this.enhanceProxy = ncVarDS.enhanceProxy;
            this.scaleMissingProxy = ncVarDS.scaleMissingProxy;
            this.enhanceMode = ncVarDS.enhanceMode;
        } else {
            this.enhanceProxy = new EnhancementsImpl(this);
            if (enhance) {
                this.enhance(NetcdfDataset.getDefaultEnhanceMode());
            } else {
                this.scaleMissingProxy = new EnhanceScaleMissingImpl();
            }
        }
    }

    protected VariableDS(VariableDS vds, boolean isCopy) {
        super(vds);
        this.orgVar = vds;
        this.orgDataType = vds.orgDataType;
        this.orgName = vds.orgName;
        this.scaleMissingProxy = vds.scaleMissingProxy;
        this.enhanceProxy = new EnhancementsImpl(this);
        this.enhanceMode = vds.enhanceMode;
        if (!isCopy) {
            this.createNewCache();
        }
    }

    public String getDatasetLocation() {
        if (this.ncfile != null) {
            return this.ncfile.getLocation();
        }
        return "N/A";
    }

    @Override
    protected Variable copy() {
        return new VariableDS(this, true);
    }

    @Override
    public void clearCoordinateSystems() {
        this.enhanceProxy = new EnhancementsImpl(this, this.getUnitsString(), this.getDescription());
    }

    @Override
    public void enhance(Set<NetcdfDataset.Enhance> mode) {
        VariableDS orgVarDS;
        EnumSet<NetcdfDataset.Enhance> orgEnhanceMode;
        this.enhanceMode = EnumSet.copyOf(mode);
        boolean alreadyScaleOffsetMissing = false;
        boolean alreadyEnumConversion = false;
        if (this.orgVar != null && this.orgVar instanceof VariableDS && (orgEnhanceMode = (orgVarDS = (VariableDS)this.orgVar).getEnhanceMode()) != null) {
            if (orgEnhanceMode.contains((Object)NetcdfDataset.Enhance.ScaleMissing)) {
                alreadyScaleOffsetMissing = true;
                this.enhanceMode.add(NetcdfDataset.Enhance.ScaleMissing);
            }
            if (orgEnhanceMode.contains((Object)NetcdfDataset.Enhance.ConvertEnums)) {
                alreadyEnumConversion = true;
                this.enhanceMode.add(NetcdfDataset.Enhance.ConvertEnums);
            }
        }
        if (!alreadyScaleOffsetMissing && (this.dataType.isNumeric() || this.dataType == DataType.CHAR) && mode.contains((Object)NetcdfDataset.Enhance.ScaleMissing) || mode.contains((Object)NetcdfDataset.Enhance.ScaleMissingDefer)) {
            this.scaleMissingProxy = new EnhanceScaleMissingImpl(this);
            if (mode.contains((Object)NetcdfDataset.Enhance.ScaleMissing) && this.scaleMissingProxy.hasScaleOffset() && this.scaleMissingProxy.getConvertedDataType() != this.getDataType()) {
                this.setDataType(this.scaleMissingProxy.getConvertedDataType());
                this.removeAttributeIgnoreCase("_Unsigned");
            }
            boolean bl = this.needScaleOffsetMissing = mode.contains((Object)NetcdfDataset.Enhance.ScaleMissing) && (this.scaleMissingProxy.hasScaleOffset() || this.scaleMissingProxy.getUseNaNs());
        }
        if (!alreadyEnumConversion && mode.contains((Object)NetcdfDataset.Enhance.ConvertEnums) && this.dataType.isEnum()) {
            this.needEnumConversion = true;
            this.setDataType(DataType.STRING);
            this.removeAttributeIgnoreCase("_Unsigned");
        }
    }

    boolean needConvert() {
        if (this.needScaleOffsetMissing || this.needEnumConversion) {
            return true;
        }
        if (this.orgVar != null && this.orgVar instanceof VariableDS) {
            return ((VariableDS)this.orgVar).needConvert();
        }
        return false;
    }

    Array convert(Array data) {
        if (this.needScaleOffsetMissing) {
            return this.convertScaleOffsetMissing(data);
        }
        if (this.needEnumConversion) {
            return this.convertEnums(data);
        }
        if (this.orgVar != null && this.orgVar instanceof VariableDS) {
            return ((VariableDS)this.orgVar).convert(data);
        }
        return data;
    }

    public EnumSet<NetcdfDataset.Enhance> getEnhanceMode() {
        return this.enhanceMode;
    }

    @Override
    public void addCoordinateSystem(CoordinateSystem p0) {
        this.enhanceProxy.addCoordinateSystem(p0);
    }

    @Override
    public void removeCoordinateSystem(CoordinateSystem p0) {
        this.enhanceProxy.removeCoordinateSystem(p0);
    }

    @Override
    public List<CoordinateSystem> getCoordinateSystems() {
        return this.enhanceProxy.getCoordinateSystems();
    }

    @Override
    public String getDescription() {
        return this.enhanceProxy.getDescription();
    }

    @Override
    public String getUnitsString() {
        return this.enhanceProxy.getUnitsString();
    }

    @Override
    public void setUnitsString(String units) {
        this.enhanceProxy.setUnitsString(units);
    }

    @Override
    public Array convertScaleOffsetMissing(Array data) {
        return this.scaleMissingProxy.convertScaleOffsetMissing(data);
    }

    @Override
    public double getValidMax() {
        return this.scaleMissingProxy.getValidMax();
    }

    @Override
    public double getValidMin() {
        return this.scaleMissingProxy.getValidMin();
    }

    @Override
    public boolean hasFillValue() {
        return this.scaleMissingProxy.hasFillValue();
    }

    @Override
    public boolean hasInvalidData() {
        return this.scaleMissingProxy.hasInvalidData();
    }

    @Override
    public boolean hasMissing() {
        return this.scaleMissingProxy.hasMissing();
    }

    @Override
    public boolean hasMissingValue() {
        return this.scaleMissingProxy.hasMissingValue();
    }

    @Override
    public boolean hasScaleOffset() {
        return this.scaleMissingProxy.hasScaleOffset();
    }

    @Override
    public boolean isFillValue(double p0) {
        return this.scaleMissingProxy.isFillValue(p0);
    }

    @Override
    public boolean isInvalidData(double p0) {
        return this.scaleMissingProxy.isInvalidData(p0);
    }

    @Override
    public boolean isMissing(double val) {
        return this.scaleMissingProxy.isMissing(val);
    }

    @Override
    public boolean isMissingFast(double val) {
        return this.scaleMissingProxy.isMissingFast(val);
    }

    @Override
    public boolean isMissingValue(double p0) {
        return this.scaleMissingProxy.isMissingValue(p0);
    }

    @Override
    public void setFillValueIsMissing(boolean p0) {
        this.scaleMissingProxy.setFillValueIsMissing(p0);
    }

    @Override
    public void setInvalidDataIsMissing(boolean p0) {
        this.scaleMissingProxy.setInvalidDataIsMissing(p0);
    }

    @Override
    public void setMissingDataIsMissing(boolean p0) {
        this.scaleMissingProxy.setMissingDataIsMissing(p0);
    }

    @Override
    public void setUseNaNs(boolean useNaNs) {
        this.scaleMissingProxy.setUseNaNs(useNaNs);
    }

    @Override
    public boolean getUseNaNs() {
        return this.scaleMissingProxy.getUseNaNs();
    }

    @Override
    public double convertScaleOffsetMissing(byte value) {
        return this.scaleMissingProxy.convertScaleOffsetMissing(value);
    }

    @Override
    public double convertScaleOffsetMissing(short value) {
        return this.scaleMissingProxy.convertScaleOffsetMissing(value);
    }

    @Override
    public double convertScaleOffsetMissing(int value) {
        return this.scaleMissingProxy.convertScaleOffsetMissing(value);
    }

    @Override
    public double convertScaleOffsetMissing(long value) {
        return this.scaleMissingProxy.convertScaleOffsetMissing(value);
    }

    @Override
    public double convertScaleOffsetMissing(double value) {
        return this.scaleMissingProxy.convertScaleOffsetMissing(value);
    }

    @Override
    public Variable getOriginalVariable() {
        return this.orgVar;
    }

    @Override
    public void setOriginalVariable(Variable orgVar) {
        if (orgVar instanceof Structure) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + orgVar.getFullName());
        }
        this.orgVar = orgVar;
    }

    public DataType getOriginalDataType() {
        return this.orgDataType != null ? this.orgDataType : this.getDataType();
    }

    @Override
    public String getOriginalName() {
        return this.orgName;
    }

    @Override
    public String lookupEnumString(int val) {
        if (this.dataType.isEnum()) {
            return super.lookupEnumString(val);
        }
        return this.orgVar.lookupEnumString(val);
    }

    @Override
    public String setName(String newName) {
        this.orgName = this.getShortName();
        super.setShortName(newName);
        return newName;
    }

    @Override
    public String toStringDebug() {
        return this.orgVar != null ? this.orgVar.toStringDebug() : "";
    }

    public boolean hasCachedDataRecurse() {
        if (super.hasCachedData()) {
            return true;
        }
        return this.orgVar != null && this.orgVar.hasCachedData();
    }

    @Override
    public void setCaching(boolean caching) {
        if (caching && this.orgVar != null) {
            this.orgVar.setCaching(caching);
        }
    }

    @Override
    protected Array _read() throws IOException {
        Array result = this.hasCachedData() ? super._read() : this.proxyReader.reallyRead(this, null);
        if (this.needScaleOffsetMissing) {
            return this.convertScaleOffsetMissing(result);
        }
        if (this.needEnumConversion) {
            return this.convertEnums(result);
        }
        return result;
    }

    @Override
    public Array reallyRead(Variable client2, CancelTask cancelTask) throws IOException {
        if (this.orgVar == null) {
            return this.getMissingDataArray(this.shape);
        }
        return this.orgVar.read();
    }

    @Override
    protected Array _read(Section section) throws IOException, InvalidRangeException {
        if (null == section || section.computeSize() == this.getSize()) {
            return this._read();
        }
        Array result = this.hasCachedData() ? super._read(section) : this.proxyReader.reallyRead(this, section, null);
        if (this.needScaleOffsetMissing) {
            return this.convertScaleOffsetMissing(result);
        }
        if (this.needEnumConversion) {
            return this.convertEnums(result);
        }
        return result;
    }

    @Override
    public Array reallyRead(Variable client2, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        if (null == section || section.computeSize() == this.getSize()) {
            return this.reallyRead(client2, cancelTask);
        }
        if (this.orgVar == null) {
            return this.getMissingDataArray(section.getShape());
        }
        return this.orgVar.read(section);
    }

    @Override
    public long readToStream(Section section, OutputStream out) throws IOException, InvalidRangeException {
        if (this.orgVar == null) {
            return super.readToStream(section, out);
        }
        return this.orgVar.readToStream(section, out);
    }

    public Array getMissingDataArray(int[] shape) {
        Object data = this.scaleMissingProxy.getFillValue(this.getDataType());
        return Array.factoryConstant(this.dataType.getPrimitiveClassType(), shape, data);
    }

    public void showScaleMissingProxy(Formatter f) {
        Object mv;
        f.format("use NaNs = %s%n", this.scaleMissingProxy.getUseNaNs());
        f.format("has missing = %s%n", this.scaleMissingProxy.hasMissing());
        if (this.scaleMissingProxy.hasMissing()) {
            if (this.scaleMissingProxy.hasMissingValue()) {
                f.format("   missing value(s) = ", new Object[0]);
                for (double d : this.scaleMissingProxy.getMissingValues()) {
                    f.format(" %f", d);
                }
                f.format("%n", new Object[0]);
            }
            if (this.scaleMissingProxy.hasFillValue()) {
                f.format("   fillValue = %f%n", this.scaleMissingProxy.getFillValue());
            }
            if (this.scaleMissingProxy.hasInvalidData()) {
                f.format("   valid min/max = [%f,%f]%n", this.scaleMissingProxy.getValidMin(), this.scaleMissingProxy.getValidMax());
            }
        }
        String mvs = (mv = this.scaleMissingProxy.getFillValue(this.getDataType())) instanceof String ? (String)mv : java.lang.reflect.Array.get(mv, 0).toString();
        f.format("FillValue or default = %s%n", mvs);
        f.format("%nhas scale/offset = %s%n", this.scaleMissingProxy.hasScaleOffset());
        if (this.scaleMissingProxy.hasScaleOffset()) {
            double offset = this.scaleMissingProxy.convertScaleOffsetMissing(0.0);
            double scale = this.scaleMissingProxy.convertScaleOffsetMissing(1.0) - offset;
            f.format("   scale_factor = %f add_offset = %f%n", scale, offset);
        }
        f.format("original data type = %s%n", new Object[]{this.getDataType()});
        f.format("converted data type = %s%n", new Object[]{this.scaleMissingProxy.getConvertedDataType()});
    }

    protected Array convertEnums(Array values) {
        DataType dt = DataType.getType(values.getElementType());
        if (!dt.isNumeric()) {
            System.out.println("HEY !dt.isNumeric()");
        }
        Array result = Array.factory(DataType.STRING, values.getShape());
        IndexIterator ii = result.getIndexIterator();
        values.resetLocalIterator();
        while (values.hasNext()) {
            String sval = this.lookupEnumString(values.nextInt());
            ii.setObjectNext(sval);
        }
        return result;
    }
}

