/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.ProxyReader;
import ucar.nc2.Variable;
import ucar.nc2.util.CancelTask;

class SliceReader
implements ProxyReader {
    private static Logger log = LoggerFactory.getLogger(SliceReader.class);
    private Variable orgClient;
    private int sliceDim;
    private Section slice;

    SliceReader(Variable orgClient, int dim, Section slice) throws InvalidRangeException {
        this.orgClient = orgClient;
        this.sliceDim = dim;
        this.slice = slice;
    }

    @Override
    public Array reallyRead(Variable client2, CancelTask cancelTask) throws IOException {
        Array data;
        try {
            data = this.orgClient._read(this.slice);
        }
        catch (InvalidRangeException e) {
            log.error("InvalidRangeException in slice, var=" + client2);
            throw new IllegalStateException(e.getMessage());
        }
        data = data.reduce(this.sliceDim);
        return data;
    }

    @Override
    public Array reallyRead(Variable client2, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        Section orgSection = new Section(section.getRanges());
        orgSection.insertRange(this.sliceDim, this.slice.getRange(this.sliceDim));
        Array data = this.orgClient._read(orgSection);
        data = data.reduce(this.sliceDim);
        return data;
    }
}

