/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.commonj;

import commonj.work.Work;
import commonj.work.WorkException;
import commonj.work.WorkItem;
import commonj.work.WorkListener;
import commonj.work.WorkManager;
import commonj.work.WorkRejectedException;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.naming.NamingException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.jndi.JndiLocatorSupport;
import org.springframework.scheduling.SchedulingException;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.scheduling.commonj.DelegatingWork;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkManagerTaskExecutor
extends JndiLocatorSupport
implements SchedulingTaskExecutor,
WorkManager,
InitializingBean {
    private WorkManager workManager;
    private String workManagerName;
    private WorkListener workListener;

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    public void setWorkManagerName(String workManagerName) {
        this.workManagerName = workManagerName;
    }

    public void setWorkListener(WorkListener workListener) {
        this.workListener = workListener;
    }

    public void afterPropertiesSet() throws NamingException {
        if (this.workManager == null) {
            if (this.workManagerName == null) {
                throw new IllegalArgumentException("Either 'workManager' or 'workManagerName' must be specified");
            }
            this.workManager = (WorkManager)this.lookup(this.workManagerName, WorkManager.class);
        }
    }

    public void execute(Runnable task) {
        Assert.state(this.workManager != null, "No WorkManager specified");
        DelegatingWork work = new DelegatingWork(task);
        try {
            if (this.workListener != null) {
                this.workManager.schedule((Work)work, this.workListener);
            } else {
                this.workManager.schedule((Work)work);
            }
        }
        catch (WorkRejectedException ex) {
            throw new TaskRejectedException("CommonJ WorkManager did not accept task: " + task, ex);
        }
        catch (WorkException ex) {
            throw new SchedulingException("Could not schedule task on CommonJ WorkManager", (Throwable)ex);
        }
    }

    public void execute(Runnable task, long startTimeout) {
        this.execute(task);
    }

    public Future<?> submit(Runnable task) {
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        this.execute(future);
        return future;
    }

    public <T> Future<T> submit(Callable<T> task) {
        FutureTask<T> future = new FutureTask<T>(task);
        this.execute(future);
        return future;
    }

    public boolean prefersShortLivedTasks() {
        return true;
    }

    public WorkItem schedule(Work work) throws WorkException, IllegalArgumentException {
        return this.workManager.schedule(work);
    }

    public WorkItem schedule(Work work, WorkListener workListener) throws WorkException, IllegalArgumentException {
        return this.workManager.schedule(work, workListener);
    }

    public boolean waitForAll(Collection workItems, long timeout) throws InterruptedException, IllegalArgumentException {
        return this.workManager.waitForAll(workItems, timeout);
    }

    public Collection waitForAny(Collection workItems, long timeout) throws InterruptedException, IllegalArgumentException {
        return this.workManager.waitForAny(workItems, timeout);
    }
}

