/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.commonj;

import commonj.timers.Timer;
import commonj.timers.TimerManager;
import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.Lifecycle;
import org.springframework.scheduling.commonj.ScheduledTimerListener;
import org.springframework.scheduling.commonj.TimerManagerAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerManagerFactoryBean
extends TimerManagerAccessor
implements FactoryBean<TimerManager>,
InitializingBean,
DisposableBean,
Lifecycle {
    private ScheduledTimerListener[] scheduledTimerListeners;
    private final List<Timer> timers = new LinkedList<Timer>();

    public void setScheduledTimerListeners(ScheduledTimerListener[] scheduledTimerListeners) {
        this.scheduledTimerListeners = scheduledTimerListeners;
    }

    @Override
    public void afterPropertiesSet() throws NamingException {
        super.afterPropertiesSet();
        if (this.scheduledTimerListeners != null) {
            TimerManager timerManager = this.getTimerManager();
            ScheduledTimerListener[] scheduledTimerListenerArray = this.scheduledTimerListeners;
            int n = this.scheduledTimerListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ScheduledTimerListener scheduledTask = scheduledTimerListenerArray[n2];
                Timer timer = scheduledTask.isOneTimeTask() ? timerManager.schedule(scheduledTask.getTimerListener(), scheduledTask.getDelay()) : (scheduledTask.isFixedRate() ? timerManager.scheduleAtFixedRate(scheduledTask.getTimerListener(), scheduledTask.getDelay(), scheduledTask.getPeriod()) : timerManager.schedule(scheduledTask.getTimerListener(), scheduledTask.getDelay(), scheduledTask.getPeriod()));
                this.timers.add(timer);
                ++n2;
            }
        }
    }

    public TimerManager getObject() {
        return this.getTimerManager();
    }

    public Class<? extends TimerManager> getObjectType() {
        TimerManager timerManager = this.getTimerManager();
        return timerManager != null ? timerManager.getClass() : TimerManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    @Override
    public void destroy() {
        for (Timer timer : this.timers) {
            try {
                timer.cancel();
            }
            catch (Throwable ex) {
                this.logger.warn("Could not cancel CommonJ Timer", ex);
            }
        }
        this.timers.clear();
        super.destroy();
    }
}

