/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class VfsResource
extends AbstractResource {
    private final VirtualFile file;

    public VfsResource(VirtualFile file2) {
        Assert.notNull(file2, "VirtualFile must not be null");
        this.file = file2;
    }

    public boolean exists() {
        try {
            return this.file.exists();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isReadable() {
        try {
            return this.file.getSize() > 0L;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public long lastModified() throws IOException {
        return this.file.getLastModified();
    }

    public InputStream getInputStream() throws IOException {
        return this.file.openStream();
    }

    public URL getURL() throws IOException {
        try {
            return this.file.toURL();
        }
        catch (Exception ex) {
            throw new NestedIOException("Failed to obtain URL for file " + this.file, ex);
        }
    }

    public URI getURI() throws IOException {
        try {
            return this.file.toURI();
        }
        catch (Exception ex) {
            throw new NestedIOException("Failed to obtain URI for " + this.file, ex);
        }
    }

    public File getFile() throws IOException {
        if (VFSUtils.isNestedFile((VirtualFile)this.file)) {
            throw new IOException("File resolution not supported for nested resource: " + this.file);
        }
        try {
            return new File(VFSUtils.getCompatibleURI((VirtualFile)this.file));
        }
        catch (Exception ex) {
            throw new NestedIOException("Failed to obtain File reference for " + this.file, ex);
        }
    }

    public Resource createRelative(String relativePath) throws IOException {
        return new VfsResource(VFS.getRoot((URL)new URL(this.getURL(), relativePath)));
    }

    public String getFilename() {
        return this.file.getName();
    }

    public String getDescription() {
        return this.file.toString();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof VfsResource && this.file.equals((Object)((VfsResource)obj).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

