/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.scijava.util.ClassUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XML {
    private final String path;
    private final Document doc;
    private final XPath xpath;
    private final boolean debug = "debug".equals(System.getProperty("scijava.log.level"));

    public XML(File file2) throws ParserConfigurationException, SAXException, IOException {
        this(file2.getAbsolutePath(), XML.loadXML(file2));
    }

    public XML(URL url) throws ParserConfigurationException, SAXException, IOException {
        this(url.getPath(), XML.loadXML(url));
    }

    public XML(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        this(null, XML.loadXML(in));
    }

    public XML(String s) throws ParserConfigurationException, SAXException, IOException {
        this(null, XML.loadXML(s));
    }

    public XML(Document doc) {
        this(null, doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XML(String path, Document doc) {
        this.path = path;
        this.doc = doc;
        if (this.debug) {
            System.err.println(ClassUtils.getLocation(XPathFactory.class));
        }
        XPath xp = null;
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        try {
            ClassLoader loader = contextClassLoader;
            while (true) {
                try {
                    xp = XPathFactory.newInstance().newXPath();
                    try {
                        xp.evaluate("//dummy", doc);
                    }
                    catch (Throwable t) {
                        if (this.debug) {
                            System.err.println("There was a problem with " + xp.getClass() + " in " + ClassUtils.getLocation(xp.getClass()) + ":");
                            t.printStackTrace();
                        }
                        throw new Error(t);
                    }
                }
                catch (Error e) {
                    if (this.debug) {
                        e.printStackTrace();
                    }
                    if ((loader = loader.getParent()) == null) {
                        throw e;
                    }
                    thread.setContextClassLoader(loader);
                    continue;
                }
                break;
            }
            this.xpath = xp;
        }
        finally {
            thread.setContextClassLoader(contextClassLoader);
        }
    }

    public String getPath() {
        return this.path;
    }

    public Document getDocument() {
        return this.doc;
    }

    public String cdata(String expression) {
        NodeList nodes = this.xpath(expression);
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        return XML.cdata(nodes.item(0));
    }

    public ArrayList<Element> elements(String expression) {
        return XML.elements(this.xpath(expression));
    }

    public NodeList xpath(String expression) {
        Object result;
        try {
            result = this.xpath.evaluate(expression, this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            return null;
        }
        return (NodeList)result;
    }

    public String toString() {
        try {
            return XML.dumpXML(this.doc);
        }
        catch (TransformerException exc) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            exc.printStackTrace(new PrintStream(out));
            return out.toString();
        }
    }

    public static String cdata(Node item) {
        NodeList children = item.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            return child.getNodeValue();
        }
        return null;
    }

    public static String cdata(Element el, String child) {
        NodeList children = el.getElementsByTagName(child);
        if (children == null || children.getLength() == 0) {
            return null;
        }
        return XML.cdata(children.item(0));
    }

    public static ArrayList<Element> elements(NodeList nodes) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof Element)) continue;
                elements.add((Element)node);
            }
        }
        return elements;
    }

    public static ArrayList<Element> elements(Element el, String child) {
        return XML.elements(el.getElementsByTagName(child));
    }

    private static Document loadXML(File file2) throws ParserConfigurationException, SAXException, IOException {
        return XML.createBuilder().parse(file2.getAbsolutePath());
    }

    private static Document loadXML(URL url) throws ParserConfigurationException, SAXException, IOException {
        InputStream in = url.openStream();
        Document document = XML.loadXML(in);
        in.close();
        return document;
    }

    protected static Document loadXML(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        return XML.createBuilder().parse(in);
    }

    protected static Document loadXML(String s) throws ParserConfigurationException, SAXException, IOException {
        return XML.createBuilder().parse(new ByteArrayInputStream(s.getBytes()));
    }

    private static DocumentBuilder createBuilder() throws ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    private static String dumpXML(Document doc) throws TransformerException {
        DOMSource source = new DOMSource(doc);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(source, result);
        return stringWriter.getBuffer().toString();
    }
}

