/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class MirrorWebsite {
    public static final int THREAD_COUNT = 20;
    public static final long DELAY_IN_MICROSECONDS = 0L;
    private String baseURL;
    private String basePath;
    private File localDirectory;
    private Map<String, String> linkMap = new HashMap<String, String>();
    private Set<String> missingLinks = new LinkedHashSet<String>();
    private ExecutorService executorService;
    private Map<String, MirrorJob> jobs;
    private Set<String> done;
    private int threadCount;
    private long delay;

    public MirrorWebsite(String baseURL, File localDirectory, int threadCount, long delay) {
        this.baseURL = baseURL + (baseURL.endsWith("/") ? "" : "/");
        this.basePath = baseURL.startsWith("file:") ? baseURL.substring(5) : null;
        this.localDirectory = localDirectory;
        this.threadCount = threadCount;
        this.delay = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws InterruptedException {
        MirrorWebsite mirrorWebsite = this;
        synchronized (mirrorWebsite) {
            if (this.jobs != null) {
                throw new RuntimeException("Mirroring already in progress!");
            }
            this.executorService = Executors.newFixedThreadPool(this.threadCount);
            this.done = new TreeSet<String>();
            this.jobs = new LinkedHashMap<String, MirrorJob>();
            this.mirror("index.html");
        }
        this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mirror(String path) {
        MirrorJob job;
        MirrorWebsite mirrorWebsite = this;
        synchronized (mirrorWebsite) {
            if (this.jobs.containsKey(path)) {
                return;
            }
            job = new MirrorJob(path);
            this.jobs.put(path, job);
        }
        try {
            this.executorService.execute(job);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.done.add(path);
        }
    }

    private static long getRemoteTimestamp(String url) throws IOException {
        URLConnection connection = null;
        try {
            connection = new URL(url).openConnection();
        }
        catch (FileNotFoundException e) {
            if (url.endsWith("/index.html")) {
                connection = new URL(url.substring(0, url.length() - 10)).openConnection();
            }
            throw e;
        }
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).setRequestMethod("HEAD");
        }
        connection.setUseCaches(false);
        long lastModified = connection.getLastModified();
        connection.getInputStream().close();
        return lastModified;
    }

    private long upToDate(String path) throws IOException {
        long remote = MirrorWebsite.getRemoteTimestamp(this.baseURL + path);
        File file2 = new File(this.localDirectory, path);
        if (!file2.exists()) {
            return remote;
        }
        long local = file2.lastModified();
        return remote < 0L || local == remote ? 0L : remote;
    }

    private String getValue(String html, int startOffset) {
        int offset;
        for (offset = startOffset; offset < html.length() && (html.charAt(offset) == '\n' || html.charAt(offset) == '\r' || html.charAt(offset) == ' '); ++offset) {
        }
        if (offset + 1 >= html.length()) {
            return "";
        }
        char delim = ' ';
        char delim2 = '>';
        char c = html.charAt(offset);
        if (c == '\"' || c == '\'') {
            char c2 = c;
            delim2 = c2;
            delim = c2;
            ++offset;
        }
        for (int end = offset; end < html.length(); ++end) {
            if (html.charAt(end) != delim && html.charAt(end) != delim2) continue;
            return html.substring(offset, end);
        }
        return html.substring(offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLinkRelation(List<String> result, String sourceURL, String url) {
        String normalized = MirrorWebsite.normalizeURL(url);
        if (normalized == null) {
            return;
        }
        result.add(normalized);
        Map<String, String> map = this.linkMap;
        synchronized (map) {
            String previous = this.linkMap.get(normalized);
            if (previous == null) {
                this.linkMap.put(normalized, sourceURL);
            } else if ((" " + previous + " ").indexOf(" " + sourceURL + " ") < 0) {
                this.linkMap.put(normalized, previous + " " + sourceURL);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getLinks(String relativePath, String path, String html) {
        ArrayList<String> result = new ArrayList<String>();
        int offset = -1;
        while (true) {
            int newOffset = -1;
            for (String pattern : new String[]{" href=", " src=", " HREF=", " SRC="}) {
                int tmp = html.indexOf(pattern, offset + 1);
                if (tmp < 0 || newOffset >= 0 && newOffset <= tmp) continue;
                newOffset = tmp + pattern.length();
            }
            if (newOffset < 0) return result;
            offset = newOffset;
            String value = this.getValue(html, offset);
            offset += value.length();
            if (value.startsWith("mailto:") || value.startsWith("MAILTO:")) continue;
            for (char c : new char[]{'#', '?', ';'}) {
                int hash = value.indexOf(c);
                if (hash < 0) continue;
                value = value.substring(0, hash);
            }
            if (value.endsWith("/")) {
                value = value + "index.html";
            }
            if (value.startsWith("/")) {
                int colon = this.baseURL.indexOf("://");
                int slash = this.baseURL.indexOf(47, colon + 3);
                value = this.baseURL.substring(0, slash) + value;
            } else if (value.indexOf("://") < 0) {
                if (!value.equals("")) {
                    this.addLinkRelation(result, path, relativePath + value);
                }
                if (offset >= 0) continue;
                return result;
            }
            if (value.startsWith(this.baseURL)) {
                this.addLinkRelation(result, path, value.substring(this.baseURL.length()));
            }
            if (offset < 0) return result;
        }
    }

    private static boolean isHTML(String path) {
        String lower = path.toLowerCase();
        return lower.endsWith(".htm") || lower.endsWith(".html");
    }

    private static void copyStream(InputStream in, StringBuffer string, OutputStream out) throws IOException {
        int count;
        byte[] buffer = new byte[65536];
        while ((count = in.read(buffer)) >= 0) {
            if (string != null) {
                string.append(new String(buffer, 0, count));
            }
            if (out == null) continue;
            out.write(buffer, 0, count);
        }
        in.close();
        if (out != null) {
            out.close();
        }
    }

    private List<String> ensureUptodate(String path) throws IOException {
        long remoteLastModified;
        StringBuffer string = new StringBuffer();
        String relativePath = path.substring(0, path.lastIndexOf(47) + 1);
        File file2 = new File(this.localDirectory, path);
        if (this.basePath != null && ("/" + path).endsWith("/index.html") && !new File(this.basePath + path).exists()) {
            String directory = path.substring(0, path.length() - 10);
            File[] list = new File(this.basePath + directory).listFiles();
            if (list == null) {
                return Collections.emptyList();
            }
            ArrayList<String> result = new ArrayList<String>();
            for (File item : list) {
                if (item.isDirectory()) {
                    result.add(directory + item.getName() + "/index.html");
                    continue;
                }
                result.add(directory + item.getName());
            }
            return result;
        }
        try {
            remoteLastModified = this.upToDate(path);
            if (remoteLastModified == 0L) {
                if (!MirrorWebsite.isHTML(path)) {
                    return Collections.emptyList();
                }
                MirrorWebsite.copyStream(new FileInputStream(file2), string, null);
                return this.getLinks(relativePath, path, string.toString());
            }
        }
        catch (FileNotFoundException e) {
            if (!path.endsWith("/index.html")) {
                throw e;
            }
            remoteLastModified = -1L;
        }
        InputStream in = null;
        try {
            in = new URL(this.baseURL + path).openStream();
        }
        catch (MalformedURLException e) {
            throw new MalformedURLException(this.baseURL + path);
        }
        catch (FileNotFoundException e) {
            if (path.endsWith("/index.html")) {
                in = new URL(this.baseURL + path.substring(0, path.length() - 10)).openStream();
            }
            throw e;
        }
        System.err.println("Downloading " + path);
        File tmp = new File(this.localDirectory, path + ".download.tmp");
        tmp.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(tmp);
        if (MirrorWebsite.isHTML(path)) {
            MirrorWebsite.copyStream(in, string, null);
            String rewritten = string.toString().replaceAll("http://rsb.info.nih.gov", "http://imagej.nih.gov");
            String replacement = "";
            String path2 = path;
            while (true) {
                path2 = path2.substring(0, path2.lastIndexOf(47) + 1);
                rewritten = rewritten.replaceAll(this.baseURL + path2, replacement);
                if (this.basePath != null) {
                    rewritten = rewritten.replaceAll("http://imagej.nih.gov/ij/" + path2, replacement);
                }
                if (path2.equals("")) break;
                path2 = path2.substring(0, path2.length() - 1);
                replacement = "../" + replacement;
            }
            MirrorWebsite.copyStream(new ByteArrayInputStream(rewritten.getBytes()), null, out);
        } else {
            MirrorWebsite.copyStream(in, null, out);
        }
        tmp.renameTo(file2);
        if (remoteLastModified >= 0L) {
            file2.setLastModified(remoteLastModified);
        }
        if (!MirrorWebsite.isHTML(path)) {
            return Collections.emptyList();
        }
        return this.getLinks(relativePath, path, string.toString());
    }

    private static String normalizeURL(String originalPath) {
        String path = originalPath;
        while (true) {
            int dot;
            if ((dot = path.indexOf("/./")) >= 0) {
                path = path.substring(0, dot) + path.substring(dot + 2);
                continue;
            }
            int dotdot = path.indexOf("/../");
            if (dotdot < 0) break;
            if (dotdot == 0) {
                return null;
            }
            int slash = path.lastIndexOf(dotdot - 1);
            if (slash < 0) {
                return null;
            }
            path = path.substring(0, slash) + path.substring(dotdot + 3);
        }
        if (path.startsWith("../")) {
            throw new RuntimeException("ignore");
        }
        return path;
    }

    private void reportMissingLinks() {
        if (this.missingLinks.size() == 0) {
            return;
        }
        System.err.println("Found broken links:");
        for (String path : this.missingLinks) {
            String source = this.linkMap.get(path);
            System.err.println(path + (source == null ? "" : " (linked from " + source + ")"));
        }
    }

    private static void usage() {
        System.err.println("Usage: MirrorWebsite [<option>...] <url> <directory>");
        System.err.println("Options:");
        System.err.println("--help");
        System.err.println("\tshow this help");
        System.err.println("--threads <n>");
        System.err.println("\tuse <n> threads (default: 20)");
        System.err.println("--delay <microseconds>");
        System.err.println("\twait after each request (default: 0)");
        System.exit(1);
    }

    public static void main(String[] args) {
        File directory;
        String option;
        int threadCount = 20;
        long delay = 0L;
        int i = 0;
        while (i < args.length && args[i].startsWith("--") && !(option = args[i++]).equals("--")) {
            if (option.equals("--help")) {
                MirrorWebsite.usage();
            }
            if (i + 1 >= args.length) {
                System.err.println("Missing argument: " + option);
                MirrorWebsite.usage();
            }
            String arg = args[i++];
            if (option.equals("--threads")) {
                threadCount = Integer.parseInt(arg);
                continue;
            }
            if (option.equals("--delay")) {
                delay = Long.parseLong(arg);
                continue;
            }
            System.err.println("Unknown option: " + option);
            MirrorWebsite.usage();
        }
        if (args.length - i != 2) {
            MirrorWebsite.usage();
        }
        if (!(directory = new File(args[i + 1])).isDirectory() && !directory.mkdirs()) {
            System.err.println("Could not make directories " + directory);
            System.exit(1);
        }
        try {
            System.err.println("Mirroring " + args[i] + " to " + directory);
            new MirrorWebsite(args[i], directory, threadCount, delay).run();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private class MirrorJob
    implements Runnable {
        private String path;

        public MirrorJob(String path) {
            this.path = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                System.err.println("Looking at " + this.path + " (" + (1 + MirrorWebsite.this.done.size()) + "/" + MirrorWebsite.this.jobs.size() + ")");
                for (String path2 : MirrorWebsite.this.ensureUptodate(this.path)) {
                    try {
                        MirrorWebsite.this.mirror(path2);
                    }
                    catch (Throwable e) {
                        System.err.println("" + e);
                    }
                }
            }
            catch (FileNotFoundException e) {
                String source = (String)MirrorWebsite.this.linkMap.get(this.path);
                System.err.println("" + e + (source == null ? "" : " (linked from " + source + ")"));
                MirrorWebsite.this.missingLinks.add(this.path);
            }
            catch (Throwable e) {
                System.err.println("Error while trying to mirror " + this.path);
                e.printStackTrace();
            }
            if (MirrorWebsite.this.delay > 0L) {
                try {
                    Thread.sleep(MirrorWebsite.this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            MirrorWebsite mirrorWebsite = MirrorWebsite.this;
            synchronized (mirrorWebsite) {
                MirrorWebsite.this.done.add(this.path);
                if (MirrorWebsite.this.done.size() == MirrorWebsite.this.jobs.size()) {
                    MirrorWebsite.this.executorService.shutdown();
                    MirrorWebsite.this.reportMissingLinks();
                }
            }
        }
    }
}

