/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.dnd;

import java.io.File;
import java.io.IOException;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.io.IOService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.dnd.AbstractDragAndDropHandler;
import org.scijava.ui.dnd.DragAndDropHandler;

@Plugin(type=DragAndDropHandler.class, priority=-100.0)
public class FileDragAndDropHandler
extends AbstractDragAndDropHandler<File> {
    @Parameter(required=false)
    private IOService ioService;
    @Parameter(required=false)
    private DisplayService displayService;
    @Parameter(required=false)
    private LogService log;

    @Override
    public boolean supports(File file2) {
        if (this.ioService == null || this.displayService == null) {
            return false;
        }
        if (!super.supports(file2)) {
            return false;
        }
        return this.ioService.getOpener(file2.getAbsolutePath()) != null;
    }

    @Override
    public boolean drop(File file2, Display<?> display) {
        Object data;
        if (this.ioService == null || this.displayService == null) {
            return false;
        }
        this.check(file2, display);
        if (file2 == null) {
            return true;
        }
        String filename = file2.getAbsolutePath();
        try {
            data = this.ioService.open(filename);
        }
        catch (IOException exc) {
            if (this.log != null) {
                this.log.error("Error opening file: " + filename, exc);
            }
            return false;
        }
        this.displayService.createDisplay(data);
        return true;
    }

    @Override
    public Class<File> getType() {
        return File.class;
    }
}

